/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.gephi.project.api.Project;
import org.gephi.project.api.Projects;
import org.gephi.project.impl.ProjectImpl;

public class ProjectsImpl
implements Projects,
Serializable {
    private final List<Project> projects = new ArrayList<Project>();
    private ProjectImpl currentProject;
    private final AtomicInteger projectIds = new AtomicInteger(1);

    public synchronized void addProject(Project project) {
        if (!this.projects.contains(project)) {
            this.projects.add(project);
        }
    }

    public synchronized void removeProject(Project project) {
        this.projects.remove(project);
    }

    @Override
    public synchronized Project[] getProjects() {
        return this.projects.toArray(new Project[0]);
    }

    @Override
    public synchronized ProjectImpl getCurrentProject() {
        return this.currentProject;
    }

    @Override
    public synchronized boolean hasCurrentProject() {
        return this.currentProject != null;
    }

    public synchronized void setCurrentProject(ProjectImpl currentProject) {
        this.currentProject = currentProject;
    }

    public synchronized void closeCurrentProject() {
        this.currentProject = null;
    }

    public int nextProjectId() {
        return this.projectIds.getAndIncrement();
    }

    public void setProjectIds(int id) {
        this.projectIds.set(id);
    }

    public int getProjectIds() {
        return this.projectIds.get();
    }
}

