/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.editor;

import java.awt.BorderLayout;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import net.sf.sdedit.config.ExportConfiguration;
import net.sf.sdedit.diagram.DiagramFactory;
import net.sf.sdedit.diagram.SDPaintDevice;
import net.sf.sdedit.server.Exporter;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.ConfigurationUI;
import net.sf.sdedit.ui.components.configuration.ConfigurationUIListener;
import net.sf.sdedit.ui.impl.DiagramTab;
import net.sf.sdedit.util.UIUtilities;

public class ExportDialog
extends JDialog
implements ConfigurationUIListener,
WindowListener,
PropertyChangeListener {
    private static final long serialVersionUID = 2916559030760216855L;
    private Bean<ExportConfiguration> configuration;
    private DiagramTab tab;
    private ConfigurationUI<ExportConfiguration> cui;
    private Bean<ExportConfiguration> copy;
    private Map<Integer, File> files;

    public ExportDialog(DiagramTab tab) {
        super(tab.get_UI());
        this.setTitle("Export diagram");
        this.tab = tab;
        this.addWindowListener(this);
        this.configuration = new Bean<ExportConfiguration>(ExportConfiguration.class, null);
        this.configuration.addPropertyChangeListener(this);
        this.configuration.setPermitNullValues(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.setModal(true);
        this.files = new HashMap<Integer, File>();
        this.cui = new ConfigurationUI<ExportConfiguration>(this, this.configuration, null, null, null, null, false);
        this.cui.hideCategoryList();
        this.getContentPane().add(this.cui, "Center");
        this.pack();
    }

    public ExportConfiguration getConfiguration() {
        return this.configuration.getDataObject();
    }

    private File getFile(DiagramTab tab, String type) {
        File file = this.files.get(tab.getId());
        if (file == null) {
            file = tab.getFile();
        }
        if (file != null && type != null) {
            file = new File(file.getParentFile(), file.getName().replaceAll("(.*)\\..*", "$1") + "." + type);
        }
        return file;
    }

    public void open(DiagramTab tab) {
        this.tab = tab;
        this.cui.refreshAll();
        this.copy = this.configuration.copy();
        UIUtilities.centerWindow(this, this.getOwner());
        this.configuration.getDataObject().setFile(this.getFile(tab, this.configuration.getDataObject().getType()));
        this.adjustButton();
        this.setVisible(true);
    }

    @Override
    public void cancelConfiguration() {
        this.setVisible(false);
        this.dispose();
        this.configuration.takeValuesFrom(this.copy);
    }

    public void adjustButton() {
        boolean enable;
        File file = this.configuration.getDataObject().getFile();
        boolean bl = enable = file != null && (file.getParentFile() == null || file.getParentFile().exists()) && !file.isDirectory();
        if (enable) {
            this.cui.getButtonPanel().enable(this.cui.getOkAction());
        } else {
            this.cui.getButtonPanel().disable(this.cui.getOkAction());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyConfiguration() {
        File file = this.configuration.getDataObject().getFile();
        if (file != null) {
            if (file.exists() && this.tab.get_UI().confirmOrCancel("Overwrite existing file?") < 1) {
                return;
            }
            try {
                FileOutputStream stream = new FileOutputStream(file);
                try {
                    Exporter exporter = Exporter.getExporter(this.configuration.getDataObject().getType(), null, null, stream);
                    SDPaintDevice paintDevice = new SDPaintDevice(exporter);
                    DiagramFactory factory = this.tab.createFactory(paintDevice);
                    factory.generateDiagram(this.tab.getConfiguration().getDataObject());
                    exporter.export();
                }
                finally {
                    stream.close();
                }
            }
            catch (Throwable e) {
                this.tab.get_UI().errorMessage(e, "Export failed", "Export failed");
            }
        }
        this.setVisible(false);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.isVisible()) {
            String type;
            File file;
            if (evt.getPropertyName().equals("type") && (file = this.getFile(this.tab, type = (String)evt.getNewValue())) != null) {
                this.configuration.getDataObject().setFile(file);
            }
            if (evt.getPropertyName().equals("file")) {
                this.files.put(this.tab.getId(), (File)evt.getNewValue());
            }
            this.adjustButton();
        }
    }
}

