<!--
title: Serverless - AWS Documentation
menuText: AWS
menuOrder: 1
layout: Doc
-->

<!-- DOCS-SITE-LINK:START automatically generated  -->

### [Read this on the main serverless docs site](https://www.serverless.com/framework/docs/)

<!-- DOCS-SITE-LINK:END -->

# AWS Provider Documentation

<div class="docsSections">
  <div class="docsSection">
    <div class="docsSectionSubHeader">
      <h4>Guides</h4>
    </div>
    <div class="docsProviderItems">
      <ul>
        <li><a href="./guide/intro.md">Intro</a></li>
        <li><a href="./guide/credentials.md">Credentials</a></li>
        <li><a href="./guide/services.md">Services</a></li>
        <li><a href="./guide/functions.md">Functions</a></li>
        <li><a href="./guide/events.md">Events</a></li>
        <li><a href="./guide/resources.md">Resources</a></li>
        <li><a href="./guide/deploying.md">Deploying</a></li>
        <li><a href="./guide/testing.md">Testing</a></li>
        <li><a href="./guide/variables.md">Variables</a></li>
        <li><a href="./guide/packaging.md">Packaging</a></li>
        <li><a href="./guide/iam.md">IAM</a></li>
        <li><a href="./guide/plugins.md">Plugins</a></li>
        <li><a href="./guide/workflow.md">Workflow</a></li>
        <li><a href="./guide/serverless.yml.md">Serverless.yml</a></li>
      </ul>
    </div>
  </div>

  <div class="docsSection">
    <div class="docsSectionSubHeader">
      <h4>CLI references</h4>
    </div>
    <div class="docsProviderItems">
      <ul>
        <li><a href="./cli-reference/config-credentials.md">Config Credentials</a></li>
        <li><a href="./cli-reference/create.md">Create</a></li>
        <li><a href="./cli-reference/install.md">Install</a></li>
        <li><a href="./cli-reference/package.md">Package</a></li>
        <li><a href="./cli-reference/deploy.md">Deploy</a></li>
        <li><a href="./cli-reference/deploy-function.md">Deploy Function</a></li>
        <li><a href="./cli-reference/deploy-list.md">Deploy List</a></li>
        <li><a href="./cli-reference/invoke.md">Invoke</a></li>
        <li><a href="./cli-reference/invoke-local.md">Invoke Local</a></li>
        <li><a href="./cli-reference/logs.md">Logs</a></li>
        <li><a href="./cli-reference/login.md">Login</a></li>
        <li><a href="./cli-reference/metrics.md">Metrics</a></li>
        <li><a href="./cli-reference/info.md">Info</a></li>
        <li><a href="./cli-reference/rollback.md">Rollback</a></li>
        <li><a href="./cli-reference/rollback-function.md">Rollback Function</a></li>
        <li><a href="./cli-reference/remove.md">Remove</a></li>
        <li><a href="./cli-reference/plugin-list.md">Plugin List</a></li>
        <li><a href="./cli-reference/plugin-search.md">Plugin Search</a></li>
        <li><a href="./cli-reference/plugin-install.md">Plugin Install</a></li>
        <li><a href="./cli-reference/plugin-uninstall.md">Plugin Uninstall</a></li>
        <li><a href="./cli-reference/print.md">Print</a></li>
        <li><a href="./cli-reference/slstats.md">Serverless Stats</a></li>
      </ul>
    </div>
  </div>

  <div class="docsSection">
    <div class="docsSectionSubHeader">
      <h4>Events</h4>
    </div>
    <div class="docsProviderItems">
      <ul>
        <li><a href="./events/apigateway.md">API Gateway</a></li>
        <li><a href="./events/http-api.md">HTTP API</a></li>
        <li><a href="./events/websocket.md">Websocket</a></li>
        <li><a href="./events/streams.md">Streams</a></li>
        <li><a href="./events/s3.md">S3</a></li>
        <li><a href="./events/schedule.md">Schedule</a></li>
        <li><a href="./events/sns.md">SNS</a></li>
        <li><a href="./events/sqs.md">SQS</a></li>
        <li><a href="./events/alb.md">ALB</a></li>
        <li><a href="./events/alexa-skill.md">Alexa Skill</a></li>
        <li><a href="./events/alexa-smart-home.md">Alexa Smart Home</a></li>
        <li><a href="./events/iot.md">IoT</a></li>
        <li><a href="./events/cloudwatch-event.md">CloudWatch Event</a></li>
        <li><a href="./events/cloudwatch-log.md">CloudWatch Log</a></li>
        <li><a href="./events/event-bridge.md">EventBridge</a></li>
        <li><a href="./events/cloudfront.md">CloudFront</a></li>
        <li><a href="./events/cognito-user-pool.md">Cognito User Pool</a></li>
        <li><a href="./events/kafka.md">Self Managed Apache Kafka</a></li>
        <li><a href="./events/msk.md">MSK</a></li>
        <li><a href="./events/iot-fleet-provisioning.md">IoT Fleet Provisioning</a></li>
      </ul>
    </div>
  </div>

  <div class="docsSection">
    <div class="docsSectionSubHeader">
      <h4>Examples</h4>
    </div>
    <div>
      <div class="docsProviderItems">
        <ul>
          <li><a href="./examples/hello-world">Hello World</a></li>
        </ul>
      </div>
    </div>
  </div>
</div>
