/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.tomcat.util.net.SSLContext;

class JSSESSLContext
implements SSLContext {
    private javax.net.ssl.SSLContext context;
    private KeyManager[] kms;
    private TrustManager[] tms;

    JSSESSLContext(String string) throws NoSuchAlgorithmException {
        this.context = javax.net.ssl.SSLContext.getInstance(string);
    }

    @Override
    public void init(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) throws KeyManagementException {
        this.kms = keyManagerArray;
        this.tms = trustManagerArray;
        this.context.init(keyManagerArray, trustManagerArray, secureRandom);
    }

    @Override
    public void destroy() {
    }

    @Override
    public SSLSessionContext getServerSessionContext() {
        return this.context.getServerSessionContext();
    }

    @Override
    public SSLEngine createSSLEngine() {
        return this.context.createSSLEngine();
    }

    @Override
    public SSLServerSocketFactory getServerSocketFactory() {
        return this.context.getServerSocketFactory();
    }

    @Override
    public SSLParameters getSupportedSSLParameters() {
        return this.context.getSupportedSSLParameters();
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        X509Certificate[] x509CertificateArray = null;
        if (this.kms != null) {
            for (int i = 0; i < this.kms.length && x509CertificateArray == null; ++i) {
                if (!(this.kms[i] instanceof X509KeyManager)) continue;
                x509CertificateArray = ((X509KeyManager)this.kms[i]).getCertificateChain(string);
            }
        }
        return x509CertificateArray;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
        if (this.tms != null) {
            for (TrustManager trustManager : this.tms) {
                X509Certificate[] x509CertificateArray;
                if (!(trustManager instanceof X509TrustManager) || (x509CertificateArray = ((X509TrustManager)trustManager).getAcceptedIssuers()) == null) continue;
                hashSet.addAll(Arrays.asList(x509CertificateArray));
            }
        }
        return hashSet.toArray(new X509Certificate[0]);
    }
}

