/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.coyote.ActionCode;

public class SSLAuthenticator
extends AuthenticatorBase {
    @Override
    protected boolean doAuthenticate(Request request, HttpServletResponse httpServletResponse) throws IOException {
        X509Certificate[] x509CertificateArray;
        if (this.checkForCachedAuthentication(request, httpServletResponse, false)) {
            return true;
        }
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)" Looking up certificates");
        }
        if ((x509CertificateArray = this.getRequestCertificates(request)) == null || x509CertificateArray.length < 1) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)"  No certificates included with this request");
            }
            httpServletResponse.sendError(401, sm.getString("authenticator.certificates"));
            return false;
        }
        Principal principal = this.context.getRealm().authenticate(x509CertificateArray);
        if (principal == null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)"  Realm.authenticate() returned false");
            }
            httpServletResponse.sendError(401, sm.getString("authenticator.unauthorized"));
            return false;
        }
        this.register(request, httpServletResponse, principal, "CLIENT_CERT", null, null);
        return true;
    }

    @Override
    protected String getAuthMethod() {
        return "CLIENT_CERT";
    }

    @Override
    protected boolean isPreemptiveAuthPossible(Request request) {
        X509Certificate[] x509CertificateArray = this.getRequestCertificates(request);
        return x509CertificateArray != null && x509CertificateArray.length > 0;
    }

    protected X509Certificate[] getRequestCertificates(Request request) throws IllegalStateException {
        X509Certificate[] x509CertificateArray = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (x509CertificateArray == null || x509CertificateArray.length < 1) {
            try {
                request.getCoyoteRequest().action(ActionCode.REQ_SSL_CERTIFICATE, null);
                x509CertificateArray = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return x509CertificateArray;
    }
}

