/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInput;
import java.io.IOException;
import org.apache.tomcat.util.bcel.Const;
import org.apache.tomcat.util.bcel.classfile.ClassFormatException;
import org.apache.tomcat.util.bcel.classfile.Constant;

public class ConstantPool {
    private final Constant[] constantPool;

    ConstantPool(DataInput dataInput) throws IOException, ClassFormatException {
        int n = dataInput.readUnsignedShort();
        this.constantPool = new Constant[n];
        for (int i = 1; i < n; ++i) {
            byte by;
            this.constantPool[i] = Constant.readConstant(dataInput);
            if (this.constantPool[i] == null || (by = this.constantPool[i].getTag()) != 6 && by != 5) continue;
            ++i;
        }
    }

    public Constant getConstant(int n) {
        if (n >= this.constantPool.length || n < 0) {
            throw new ClassFormatException("Invalid constant pool reference: " + n + ". Constant pool size is: " + this.constantPool.length);
        }
        return this.constantPool[n];
    }

    public Constant getConstant(int n, byte by) throws ClassFormatException {
        Constant constant = this.getConstant(n);
        if (constant == null) {
            throw new ClassFormatException("Constant pool at index " + n + " is null.");
        }
        if (constant.getTag() != by) {
            throw new ClassFormatException("Expected class `" + Const.getConstantName(by) + "' at index " + n + " and got " + constant);
        }
        return constant;
    }
}

