/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.openide.text.Installer;
import org.openide.awt.UndoRedo;
import org.openide.text.CloneableEditorInitializer;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.QuietEditorPane;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.WindowManager;

public class CloneableEditor
extends CloneableTopComponent
implements CloneableEditorSupport.Pane {
    private static final String HELP_ID = "editing.editorwindow";
    static final long serialVersionUID = -185739563792410059L;
    protected JEditorPane pane;
    private CloneableEditorSupport support;
    private boolean componentCreated = false;
    private int cursorPosition = -1;
    private final boolean[] CLOSE_LAST_LOCK = new boolean[1];
    private Component customComponent;
    private CloneableEditorInitializer initializer;
    static final Logger LOG = Logger.getLogger("org.openide.text.CloneableEditor");

    public CloneableEditor() {
        this(null);
    }

    public CloneableEditor(CloneableEditorSupport cloneableEditorSupport) {
        this(cloneableEditorSupport, false);
    }

    public CloneableEditor(CloneableEditorSupport cloneableEditorSupport, boolean bl) {
        this.support = cloneableEditorSupport;
        this.updateName();
        this._setCloseOperation();
        this.setMinimumSize(new Dimension(10, 10));
        if (bl) {
            this.associateLookup(cloneableEditorSupport.getLookup());
        }
    }

    private void _setCloseOperation() {
        this.setCloseOperation(0);
    }

    protected CloneableEditorSupport cloneableEditorSupport() {
        return this.support;
    }

    public int getPersistenceType() {
        return 1;
    }

    public HelpCtx getHelpCtx() {
        HelpCtx helpCtx;
        EditorKit editorKit = this.support.cesKit();
        HelpCtx helpCtx2 = helpCtx = editorKit == null ? null : HelpCtx.findHelp((Object)editorKit);
        if (helpCtx != null) {
            return helpCtx;
        }
        return new HelpCtx(HELP_ID);
    }

    public boolean canClose() {
        boolean bl = super.canClose();
        return bl;
    }

    protected void componentShowing() {
        super.componentShowing();
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (this.pane != null || this.discard()) {
            return;
        }
        QuietEditorPane quietEditorPane = new QuietEditorPane();
        quietEditorPane.putClientProperty("usedByCloneableEditor", true);
        this.pane = quietEditorPane;
        Object object = this.getInitializerLock();
        synchronized (object) {
            this.componentCreated = true;
            this.initializer = new CloneableEditorInitializer(this, this.support, this.pane);
        }
        this.initializer.start();
    }

    private Object getInitializerLock() {
        return CloneableEditorInitializer.edtRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isInitializationRunning() {
        Object object = this.getInitializerLock();
        synchronized (object) {
            boolean bl = this.initializer != null;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isProvideUnfinishedPane() {
        Object object = this.getInitializerLock();
        synchronized (object) {
            return this.initializer != null && this.initializer.isProvideUnfinishedPane();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markInitializationFinished(boolean bl) {
        Object object = this.getInitializerLock();
        synchronized (object) {
            this.initializer = null;
            if (!bl) {
                this.pane = null;
            }
            CloneableEditorInitializer.notifyEDTRequestsMonitor();
        }
    }

    protected final void initializeBySupport() {
        this.cloneableEditorSupport().initializeCloneableEditor(this);
    }

    void setCustomComponent(Component component) {
        this.customComponent = component;
    }

    int getCursorPosition() {
        return this.cursorPosition;
    }

    void setCursorPosition(int n) {
        this.cursorPosition = n;
    }

    protected CloneableTopComponent createClonedObject() {
        return this.support.createCloneableTopComponent();
    }

    protected void componentOpened() {
        super.componentOpened();
        CloneableEditorSupport cloneableEditorSupport = this.cloneableEditorSupport();
        if (cloneableEditorSupport != null) {
            cloneableEditorSupport.firePropertyChange("openedPanes", null, null);
            StyledDocument styledDocument = cloneableEditorSupport.getDocument();
            if (styledDocument != null) {
                String string = (String)styledDocument.getProperty("mimeType");
                Installer.add(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void componentClosed() {
        if (this.pane != null) {
            this.pane.setEditorKit(null);
            this.pane.putClientProperty("usedByCloneableEditor", false);
        }
        Object object = this.getInitializerLock();
        synchronized (object) {
            this.customComponent = null;
            this.pane = null;
            this.componentCreated = false;
        }
        super.componentClosed();
        object = this.cloneableEditorSupport();
        if (object != null) {
            ((CloneableEditorSupport)((Object)object)).firePropertyChange("openedPanes", null, null);
        }
        if (((CloneableEditorSupport)((Object)object)).getAnyEditor() == null) {
            ((CloneableEditorSupport)((Object)object)).close(false);
        }
    }

    protected boolean closeLast() {
        return this.closeLast(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean closeLast(boolean bl) {
        if (bl && !this.support.canClose()) {
            return false;
        }
        boolean[] blArray = this.CLOSE_LAST_LOCK;
        synchronized (this.CLOSE_LAST_LOCK) {
            if (this.CLOSE_LAST_LOCK[0]) {
                this.CLOSE_LAST_LOCK[0] = false;
            } else {
                this.support.notifyClosed();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.support.getLastSelected() == this) {
                this.support.setLastSelected(null);
            }
            return true;
        }
    }

    public UndoRedo getUndoRedo() {
        return this.support.getUndoRedo();
    }

    public Action[] getActions() {
        ArrayList<Action> arrayList = new ArrayList<Action>(Arrays.asList(super.getActions()));
        arrayList.add(null);
        arrayList.addAll(Utilities.actionsForPath((String)"Editors/TabActions"));
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    @Deprecated
    public void requestFocus() {
        super.requestFocus();
        if (this.pane != null) {
            if (this.customComponent != null && !SwingUtilities.isDescendingFrom(this.pane, this.customComponent)) {
                this.customComponent.requestFocus();
            } else {
                this.pane.requestFocus();
            }
        }
    }

    @Deprecated
    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        if (this.pane != null) {
            if (this.customComponent != null && !SwingUtilities.isDescendingFrom(this.pane, this.customComponent)) {
                return this.customComponent.requestFocusInWindow();
            }
            return this.pane.requestFocusInWindow();
        }
        return false;
    }

    @Deprecated
    public boolean requestDefaultFocus() {
        if (this.customComponent != null && !SwingUtilities.isDescendingFrom(this.pane, this.customComponent)) {
            return this.customComponent.requestFocusInWindow();
        }
        if (this.pane != null) {
            return this.pane.requestFocusInWindow();
        }
        return false;
    }

    public Dimension getPreferredSize() {
        Rectangle rectangle = WindowManager.getDefault().getCurrentWorkspace().getBounds();
        return new Dimension(rectangle.width / 2, rectangle.height / 2);
    }

    public void open() {
        boolean bl = this.getClientProperty("TopComponentAllowDockAnywhere") == null;
        super.open();
        if (bl) {
            this.putClientProperty("TopComponentAllowDockAnywhere", null);
        }
    }

    protected void componentActivated() {
        this.support.setLastSelected(this);
    }

    @Override
    public void updateName() {
        final CloneableEditorSupport cloneableEditorSupport = this.cloneableEditorSupport();
        if (cloneableEditorSupport != null) {
            Mutex.EVENT.writeAccess(new Runnable(){

                @Override
                public void run() {
                    String string = cloneableEditorSupport.messageHtmlName();
                    CloneableEditor.this.setHtmlDisplayName(string);
                    string = cloneableEditorSupport.messageName();
                    CloneableEditor.this.setDisplayName(string);
                    CloneableEditor.this.setName(string);
                    CloneableEditor.this.setToolTipText(cloneableEditorSupport.messageToolTip());
                }
            });
        }
    }

    protected String preferredID() {
        CloneableEditorSupport cloneableEditorSupport = this.cloneableEditorSupport();
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.documentID();
        }
        return "";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.support != null ? this.support.cesEnv() : null);
        int n = 0;
        JEditorPane jEditorPane = this.pane;
        if (jEditorPane != null) {
            Caret caret = jEditorPane.getCaret();
            if (caret != null) {
                n = caret.getDot();
            } else if (jEditorPane instanceof QuietEditorPane) {
                int n2 = ((QuietEditorPane)jEditorPane).getLastPosition();
                if (n2 == -1) {
                    Logger.getLogger(CloneableEditor.class.getName()).log(Level.WARNING, null, new IllegalStateException("Pane=" + jEditorPane + "was not initialized yet!"));
                } else {
                    n = n2;
                }
            } else {
                StyledDocument styledDocument;
                StyledDocument styledDocument2 = styledDocument = this.support != null ? this.support.getDocument() : null;
                if (styledDocument != null) {
                    Logger.getLogger(CloneableEditor.class.getName()).log(Level.WARNING, null, new IllegalStateException("Caret is null in editor pane=" + jEditorPane + "\nsupport=" + (Object)((Object)this.support) + "\ndoc=" + styledDocument));
                }
            }
        }
        objectOutput.writeObject(new Integer(n));
        objectOutput.writeBoolean(this.getLookup() == this.support.getLookup());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        boolean bl;
        super.readExternal(objectInput);
        Object object = objectInput.readObject();
        if (object instanceof CloneableOpenSupport.Env) {
            CloneableOpenSupport.Env env = (CloneableOpenSupport.Env)object;
            CloneableOpenSupport cloneableOpenSupport = env.findCloneableOpenSupport();
            this.support = (CloneableEditorSupport)cloneableOpenSupport;
        }
        int n = (Integer)objectInput.readObject();
        if (!this.discard()) {
            this.cursorPosition = n;
        }
        this.updateName();
        this.componentCreated = true;
        if (objectInput.available() > 0 && (bl = objectInput.readBoolean()) && this.support != null) {
            this.associateLookup(this.support.getLookup());
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.discard()) {
            throw new NotSerializableException("Serializing component is invalid: " + this);
        }
        return super.writeReplace();
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.discard()) {
            throw new InvalidObjectException("Deserialized component is invalid: " + this);
        }
        this.initializeBySupport();
        return this;
    }

    private boolean discard() {
        return this.support == null || !this.support.cesEnv().isValid();
    }

    @Override
    public CloneableTopComponent getComponent() {
        return this;
    }

    boolean isEditorPaneReady() {
        assert (SwingUtilities.isEventDispatchThread());
        return this.isEditorPaneReadyImpl();
    }

    boolean isEditorPaneReadyTest() {
        return this.isEditorPaneReadyImpl();
    }

    private boolean isEditorPaneReadyImpl() {
        return this.pane != null && !this.isInitializationRunning();
    }

    @Override
    public JEditorPane getEditorPane() {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.componentCreated) {
            return null;
        }
        if (CloneableEditorInitializer.modalDialog) {
            LOG.log(Level.WARNING, "AWT is blocked by modal dialog. Return null from CloneableEditor.getEditorPane. Please report this to IZ.");
            LOG.log(Level.WARNING, "support:" + ((Object)((Object)this.support)).getClass().getName());
            Exception exception = new Exception();
            StringWriter stringWriter = new StringWriter(500);
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            LOG.log(Level.WARNING, stringWriter.toString());
            return null;
        }
        this.initialize();
        CloneableEditorInitializer.waitForFinishedInitialization(this);
        return this.pane;
    }

    @Override
    public void ensureVisible() {
        this.open();
        this.requestVisible();
    }
}

