/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.utils;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.BoundedRangeModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.graalvm.visualvm.heapviewer.HeapFragment;
import org.graalvm.visualvm.heapviewer.utils.Bundle;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.HeapProgress;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.RequestProcessor;

public final class HeapOperations {
    private static Map<Heap, HeapOperations> INSTANCES;
    private volatile boolean referencesInitialized;
    private volatile RequestProcessor.Task referencesComputer;
    private volatile boolean gcrootsInitialized;
    private volatile RequestProcessor.Task gcrootsComputer;
    private volatile boolean retainedInitialized;
    private volatile RequestProcessor.Task retainedComputer;

    private HeapOperations() {
    }

    private static synchronized HeapOperations get(Heap heap) {
        HeapOperations instance;
        if (INSTANCES == null) {
            INSTANCES = new WeakHashMap<Heap, HeapOperations>();
        }
        if ((instance = INSTANCES.get(heap)) == null) {
            instance = new HeapOperations();
            INSTANCES.put(heap, instance);
        }
        return instance;
    }

    public static void initializeReferences(Heap heap) throws InterruptedException {
        HeapOperations.get(heap).initializeReferencesImpl(heap);
    }

    public static void initializeGCRoots(Heap heap) throws InterruptedException {
        HeapOperations.get(heap).initializeGCRootsImpl(heap);
    }

    public static void initializeRetainedSizes(Heap heap) throws InterruptedException {
        HeapOperations.get(heap).initializeRetainedSizesImpl(heap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeReferencesImpl(final Heap heap) throws InterruptedException {
        RequestProcessor.Task _referencesComputer;
        HeapOperations heapOperations = this;
        synchronized (heapOperations) {
            if (this.referencesInitialized) {
                return;
            }
            if (this.referencesComputer == null) {
                Runnable workerR = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ProgressHandle pHandle = null;
                        try {
                            pHandle = ProgressHandle.createHandle((String)Bundle.HeapOperations_ComputingReferences());
                            pHandle.setInitialDelay(1000);
                            pHandle.start(1000);
                            HeapFragment.setProgress(pHandle, 0);
                            Instance dummy = (Instance)heap.getAllInstancesIterator().next();
                            dummy.getReferences();
                        }
                        finally {
                            if (pHandle != null) {
                                pHandle.finish();
                            }
                        }
                        HeapOperations heapOperations = HeapOperations.this;
                        synchronized (heapOperations) {
                            HeapOperations.this.referencesInitialized = true;
                            HeapOperations.this.referencesComputer = null;
                        }
                    }
                };
                _referencesComputer = this.referencesComputer = new RequestProcessor("References Computer").post(workerR);
            } else {
                _referencesComputer = this.referencesComputer;
            }
        }
        assert (!SwingUtilities.isEventDispatchThread());
        _referencesComputer.waitFinished(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeGCRootsImpl(final Heap heap) throws InterruptedException {
        RequestProcessor.Task _gcrootsComputer;
        this.initializeReferencesImpl(heap);
        HeapOperations heapOperations = this;
        synchronized (heapOperations) {
            if (this.gcrootsInitialized) {
                return;
            }
            if (this.gcrootsComputer == null) {
                Runnable workerR = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ProgressHandle pHandle = null;
                        try {
                            pHandle = ProgressHandle.createHandle((String)Bundle.HeapOperations_ComputingGCRoots());
                            pHandle.setInitialDelay(1000);
                            pHandle.start(1000);
                            HeapFragment.setProgress(pHandle, 0);
                            Instance dummy = (Instance)heap.getAllInstancesIterator().next();
                            dummy.getNearestGCRootPointer();
                        }
                        finally {
                            if (pHandle != null) {
                                pHandle.finish();
                            }
                        }
                        HeapOperations heapOperations = HeapOperations.this;
                        synchronized (heapOperations) {
                            HeapOperations.this.gcrootsInitialized = true;
                            HeapOperations.this.gcrootsComputer = null;
                        }
                    }
                };
                _gcrootsComputer = this.gcrootsComputer = new RequestProcessor("GC Roots Computer").post(workerR);
            } else {
                _gcrootsComputer = this.gcrootsComputer;
            }
        }
        assert (!SwingUtilities.isEventDispatchThread());
        _gcrootsComputer.waitFinished(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRetainedSizesImpl(final Heap heap) throws InterruptedException {
        RequestProcessor.Task _retainedComputer;
        this.initializeGCRootsImpl(heap);
        HeapOperations heapOperations = this;
        synchronized (heapOperations) {
            if (this.retainedInitialized) {
                return;
            }
            if (this.retainedComputer == null) {
                Runnable workerR = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ProgressHandle pHandle = null;
                        try {
                            pHandle = ProgressHandle.createHandle((String)Bundle.HeapOperations_ComputingRetainedSizes());
                            pHandle.setInitialDelay(1000);
                            pHandle.start();
                            HeapOperations.setRetainedSizesProgress(pHandle, 1000, 3000);
                            Instance dummy = (Instance)heap.getAllInstancesIterator().next();
                            dummy.getRetainedSize();
                            HeapFragment.setProgress(pHandle, 2000);
                            List classes = heap.getAllClasses();
                            if (!classes.isEmpty()) {
                                ((JavaClass)classes.get(0)).getRetainedSizeByClass();
                            }
                        }
                        finally {
                            if (pHandle != null) {
                                pHandle.finish();
                            }
                        }
                        HeapOperations heapOperations = HeapOperations.this;
                        synchronized (heapOperations) {
                            HeapOperations.this.retainedInitialized = true;
                            HeapOperations.this.retainedComputer = null;
                        }
                    }
                };
                _retainedComputer = this.retainedComputer = new RequestProcessor("Retained Sizes Computer").post(workerR);
            } else {
                _retainedComputer = this.retainedComputer;
            }
        }
        assert (!SwingUtilities.isEventDispatchThread());
        _retainedComputer.waitFinished(0L);
    }

    private static void setRetainedSizesProgress(final ProgressHandle pHandle, final int offset, final int workunits) {
        final BoundedRangeModel progress = HeapProgress.getProgress();
        progress.addChangeListener(new ChangeListener(){
            boolean switchedToDeterminate;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!this.switchedToDeterminate) {
                    pHandle.switchToDeterminate(workunits);
                    this.switchedToDeterminate = true;
                }
                pHandle.progress(progress.getValue() + offset);
            }
        });
    }
}

