info = {
    "name": "be",
    "date_order": "DMY",
    "january": [
        "сту",
        "студзень",
        "студзеня",
        "Стд"
    ],
    "february": [
        "лют",
        "лютага",
        "люты"
    ],
    "march": [
        "сак",
        "сакавік",
        "сакавіка"
    ],
    "april": [
        "кра",
        "красавік",
        "красавіка",
        "Крс"
    ],
    "may": [
        "май",
        "мая",
        "Траўня",
        "Тра"
    ],
    "june": [
        "чэр",
        "чэрвень",
        "чэрвеня"
    ],
    "july": [
        "ліп",
        "ліпень",
        "ліпеня"
    ],
    "august": [
        "жні",
        "жнівень",
        "жніўня",
        "Жнівеня",
        "Жнв"
    ],
    "september": [
        "вер",
        "верасень",
        "верасня",
        "Врс"
    ],
    "october": [
        "кас",
        "кастрычнік",
        "кастрычніка",
        "Кст"
    ],
    "november": [
        "ліс",
        "лістапад",
        "лістапада",
        "Ліс"
    ],
    "december": [
        "сне",
        "снежань",
        "снежня",
        "Снж"
    ],
    "monday": [
        "панядзелак",
        "пн",
        "Пнд"
    ],
    "tuesday": [
        "аў",
        "аўторак",
        "Аўт"
    ],
    "wednesday": [
        "серада",
        "ср"
    ],
    "thursday": [
        "чацвер",
        "чц",
        "Чцв",
        "Чв"
    ],
    "friday": [
        "пт",
        "пятніца",
        "Пят"
    ],
    "saturday": [
        "сб",
        "субота",
        "Суб"
    ],
    "sunday": [
        "нд",
        "нядзеля",
        "Няд"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "г",
        "год",
        "гады",
        "года",
        "гадоў"
    ],
    "month": [
        "мес",
        "месяц",
        "месяца",
        "месяцы",
        "месяцаў"
    ],
    "week": [
        "тыд",
        "тыдзень",
        "тыдня",
        "тыдні",
        "тыдняў"
    ],
    "day": [
        "д",
        "дзень",
        "дні",
        "дзён",
        "дзен"
    ],
    "hour": [
        "гадз",
        "гадзіна",
        "гадзіны",
        "гадзіну",
        "гадзін"
    ],
    "minute": [
        "хв",
        "хвіліна",
        "хвілін",
        "хвіліны",
        "хвіліну",
        "хвіл"
    ],
    "second": [
        "с",
        "секунда",
        "секунды",
        "секунду",
        "секунд",
        "сек"
    ],
    "relative-type": {
        "0 day ago": [
            "сёння",
            "сення"
        ],
        "0 hour ago": [
            "у гэту гадзіну"
        ],
        "0 minute ago": [
            "у гэту хвіліну"
        ],
        "0 month ago": [
            "у гэтым месяцы"
        ],
        "0 second ago": [
            "цяпер"
        ],
        "0 week ago": [
            "на гэтым тыдні"
        ],
        "0 year ago": [
            "у гэтым годзе"
        ],
        "1 day ago": [
            "учора",
            "ўчора"
        ],
        "1 month ago": [
            "у мінулым месяцы"
        ],
        "1 week ago": [
            "на мінулым тыдні"
        ],
        "1 year ago": [
            "у мінулым годзе"
        ],
        "in 1 day": [
            "заўтра"
        ],
        "in 1 month": [
            "у наступным месяцы"
        ],
        "in 1 week": [
            "на наступным тыдні"
        ],
        "in 1 year": [
            "у наступным годзе"
        ],
        "2 day ago": [
            "пазаўчора"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "(\\d+) д таму",
            "(\\d+) дзень таму",
            "(\\d+) дня таму"
        ],
        "\\1 hour ago": [
            "(\\d+) гадз таму",
            "(\\d+) гадзіну таму",
            "(\\d+) гадзіны таму"
        ],
        "\\1 minute ago": [
            "(\\d+) хв таму",
            "(\\d+) хвіліну таму",
            "(\\d+) хвіліны таму"
        ],
        "\\1 month ago": [
            "(\\d+) мес таму",
            "(\\d+) месяц таму",
            "(\\d+) месяца таму"
        ],
        "\\1 second ago": [
            "(\\d+) с таму",
            "(\\d+) секунду таму",
            "(\\d+) секунды таму"
        ],
        "\\1 week ago": [
            "(\\d+) тыд таму",
            "(\\d+) тыдзень таму",
            "(\\d+) тыдня таму"
        ],
        "\\1 year ago": [
            "(\\d+) г таму",
            "(\\d+) год таму",
            "(\\d+) года таму"
        ],
        "in \\1 day": [
            "праз (\\d+) д",
            "праз (\\d+) дзень",
            "праз (\\d+) дня"
        ],
        "in \\1 hour": [
            "праз (\\d+) гадз",
            "праз (\\d+) гадзіну",
            "праз (\\d+) гадзіны"
        ],
        "in \\1 minute": [
            "праз (\\d+) хв",
            "праз (\\d+) хвіліну",
            "праз (\\d+) хвіліны"
        ],
        "in \\1 month": [
            "праз (\\d+) мес",
            "праз (\\d+) месяц",
            "праз (\\d+) месяца"
        ],
        "in \\1 second": [
            "праз (\\d+) с",
            "праз (\\d+) секунду",
            "праз (\\d+) секунды"
        ],
        "in \\1 week": [
            "праз (\\d+) тыд",
            "праз (\\d+) тыдзень",
            "праз (\\d+) тыдня"
        ],
        "in \\1 year": [
            "праз (\\d+) г",
            "праз (\\d+) год",
            "праз (\\d+) года"
        ]
    },
    "locale_specific": {},
    "skip": [
        "каля",
        "у",
        "і",
        "ў",
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "таму назад",
        "таму",
        "назад"
    ],
    "in": [
        "на працягу"
    ],
    "simplifications": [
        {
            "^гадзіна": "1 гадзіна"
        },
        {
            "гадзіну": "1 гадзіну"
        },
        {
            "^хвіліну": "1 хвіліну"
        },
        {
            "^секунду": "1 секунду"
        },
        {
            "некалькі секунд": "44 секунды"
        },
        {
            "некалькі хвілін": "2 хвіліны"
        },
        {
            "(\\d+)\\s*гадзін\\s(\\d+)\\s*хвілін": "\\1:\\2"
        }
    ]
}
