
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include <qapp_macro.h>

QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "abstractbuttoninterface_clickcontroller_wrapper.h"

// inner classes

// Extra includes
#include <qpoint.h>
#include <qsize.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_AbstractButtonInterface_ClickController_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::AbstractButtonInterface::ClickController >()))
        return -1;

    ::AbstractButtonInterface::ClickController *cptr{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ClickController()
            cptr = new ::AbstractButtonInterface::ClickController();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::AbstractButtonInterface::ClickController >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_AbstractButtonInterface_ClickControllerFunc_callPopupClosed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::AbstractButtonInterface::ClickController *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_ABSTRACTBUTTONINTERFACE_CLICKCONTROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // callPopupClosed()const
            const_cast<const ::AbstractButtonInterface::ClickController *>(cppSelf)->callPopupClosed();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_AbstractButtonInterface_ClickControllerFunc_callPopupPosition(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::AbstractButtonInterface::ClickController *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_ABSTRACTBUTTONINTERFACE_CLICKCONTROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ClickController::callPopupPosition(QSize)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArg)))) {
        overloadId = 0; // callPopupPosition(QSize)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_AbstractButtonInterface_ClickControllerFunc_callPopupPosition_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSize cppArg0_local;
        ::QSize *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // callPopupPosition(QSize)const
            QPoint cppResult = const_cast<const ::AbstractButtonInterface::ClickController *>(cppSelf)->callPopupPosition(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_AbstractButtonInterface_ClickControllerFunc_callPopupPosition_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.AbstractButtonInterface.ClickController.callPopupPosition");
        return {};
}


static const char *Sbk_AbstractButtonInterface_ClickController_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_AbstractButtonInterface_ClickController_methods[] = {
    {"callPopupClosed", reinterpret_cast<PyCFunction>(Sbk_AbstractButtonInterface_ClickControllerFunc_callPopupClosed), METH_NOARGS},
    {"callPopupPosition", reinterpret_cast<PyCFunction>(Sbk_AbstractButtonInterface_ClickControllerFunc_callPopupPosition), METH_O},

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_AbstractButtonInterface_ClickController_get_visualParent(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::AbstractButtonInterface::ClickController *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_ABSTRACTBUTTONINTERFACE_CLICKCONTROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), cppSelf->visualParent);
    return pyOut;
}
static int Sbk_AbstractButtonInterface_ClickController_set_visualParent(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::AbstractButtonInterface::ClickController *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_ABSTRACTBUTTONINTERFACE_CLICKCONTROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'visualParent' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'visualParent', 'QWidget' or convertible type expected");
        return -1;
    }

    ::QWidget *& cppOut_ptr = cppSelf->visualParent;
    pythonToCpp(pyIn, &cppOut_ptr);

    Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "visualParent", pyIn);
    return 0;
}

static PyObject *Sbk_AbstractButtonInterface_ClickController_get_popupOpened(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::AbstractButtonInterface::ClickController *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_ABSTRACTBUTTONINTERFACE_CLICKCONTROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->popupOpened;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_AbstractButtonInterface_ClickController_set_popupOpened(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::AbstractButtonInterface::ClickController *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_ABSTRACTBUTTONINTERFACE_CLICKCONTROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'popupOpened' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'popupOpened', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->popupOpened;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->popupOpened = cppOut_local;

    return 0;
}

// Getters and Setters for ClickController
static PyGetSetDef Sbk_AbstractButtonInterface_ClickController_getsetlist[] = {
    {const_cast<char *>("visualParent"), Sbk_AbstractButtonInterface_ClickController_get_visualParent, Sbk_AbstractButtonInterface_ClickController_set_visualParent},
    {const_cast<char *>("popupOpened"), Sbk_AbstractButtonInterface_ClickController_get_popupOpened, Sbk_AbstractButtonInterface_ClickController_set_popupOpened},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_AbstractButtonInterface_ClickController_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_AbstractButtonInterface_ClickController_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_AbstractButtonInterface_ClickController_Type = nullptr;
static SbkObjectType *Sbk_AbstractButtonInterface_ClickController_TypeF(void)
{
    return _Sbk_AbstractButtonInterface_ClickController_Type;
}

static PyType_Slot Sbk_AbstractButtonInterface_ClickController_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_AbstractButtonInterface_ClickController_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_AbstractButtonInterface_ClickController_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_AbstractButtonInterface_ClickController_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_AbstractButtonInterface_ClickController_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_AbstractButtonInterface_ClickController_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_AbstractButtonInterface_ClickController_spec = {
    "1:PyFalkon.AbstractButtonInterface.ClickController",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_AbstractButtonInterface_ClickController_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void ClickController_PythonToCpp_ClickController_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_AbstractButtonInterface_ClickController_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_ClickController_PythonToCpp_ClickController_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_AbstractButtonInterface_ClickController_TypeF())))
        return ClickController_PythonToCpp_ClickController_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *ClickController_PTR_CppToPython_ClickController(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::AbstractButtonInterface::ClickController *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_AbstractButtonInterface_ClickController_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *AbstractButtonInterface_ClickController_SignatureStrings[] = {
    "PyFalkon.AbstractButtonInterface.ClickController(self)",
    "PyFalkon.AbstractButtonInterface.ClickController.callPopupClosed(self)",
    "PyFalkon.AbstractButtonInterface.ClickController.callPopupPosition(self,size:PySide2.QtCore.QSize)->PySide2.QtCore.QPoint",
    nullptr}; // Sentinel

void init_AbstractButtonInterface_ClickController(PyObject *enclosingClass)
{
    _Sbk_AbstractButtonInterface_ClickController_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "ClickController",
        "AbstractButtonInterface::ClickController*",
        &Sbk_AbstractButtonInterface_ClickController_spec,
        &Shiboken::callCppDestructor< ::AbstractButtonInterface::ClickController >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_AbstractButtonInterface_ClickController_Type);
    InitSignatureStrings(pyType, AbstractButtonInterface_ClickController_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_AbstractButtonInterface_ClickController_Type), Sbk_AbstractButtonInterface_ClickController_PropertyStrings);
    SbkPyFalkonTypes[SBK_ABSTRACTBUTTONINTERFACE_CLICKCONTROLLER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_AbstractButtonInterface_ClickController_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_AbstractButtonInterface_ClickController_TypeF(),
        ClickController_PythonToCpp_ClickController_PTR,
        is_ClickController_PythonToCpp_ClickController_PTR_Convertible,
        ClickController_PTR_CppToPython_ClickController);

    Shiboken::Conversions::registerConverterName(converter, "AbstractButtonInterface::ClickController");
    Shiboken::Conversions::registerConverterName(converter, "AbstractButtonInterface::ClickController*");
    Shiboken::Conversions::registerConverterName(converter, "AbstractButtonInterface::ClickController&");
    Shiboken::Conversions::registerConverterName(converter, "ClickController");
    Shiboken::Conversions::registerConverterName(converter, "ClickController*");
    Shiboken::Conversions::registerConverterName(converter, "ClickController&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::AbstractButtonInterface::ClickController).name());



}
