START TRANSACTION;
INSERT INTO `role` (`roleid`,`name`,`type`,`readonly`) values ('1','User role','1','0');
INSERT INTO `role` (`roleid`,`name`,`type`,`readonly`) values ('2','Admin role','2','0');
INSERT INTO `role` (`roleid`,`name`,`type`,`readonly`) values ('3','Super admin role','3','1');
INSERT INTO `role` (`roleid`,`name`,`type`,`readonly`) values ('4','Guest role','1','0');
INSERT INTO `users` (`userid`,`username`,`name`,`surname`,`passwd`,`url`,`autologin`,`autologout`,`refresh`,`rows_per_page`,`roleid`) values ('1','Admin','Zabbix','Administrator','$2y$10$92nDno4n0Zm7Ej7Jfsz8WukBfgSS/U0QkIuu8WkJPihXBb2A1UrEK','','1','0','30s','50','3');
INSERT INTO `users` (`userid`,`username`,`name`,`surname`,`passwd`,`url`,`autologin`,`autologout`,`refresh`,`rows_per_page`,`roleid`) values ('2','guest','','','$2y$10$89otZrRNmde97rIyzclecuk6LwKAsHN0BcvoOKGjbT.BwMBfm7G06','','0','15m','30s','50','4');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`,`uuid`) values ('1','Templates','0','0','7df96b18c230490a9a0a9e2307226338');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`,`uuid`) values ('2','Linux servers','0','0','dc579cd7a1a34222933f24f52a68bcd8');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`,`uuid`) values ('4','Zabbix servers','0','0','6f6799aa69e844b4b3918f779f2abf08');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`,`uuid`) values ('5','Discovered hosts','1','0','f2481361f99448eea617b7b1d4765566');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`,`uuid`) values ('6','Virtual machines','0','0','137f19e6e2dc4219b33553b812627bc2');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`,`uuid`) values ('7','Hypervisors','0','0','1b837a3c078647049a0c00c61b4d57b5');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`,`uuid`) values ('8','Templates/Modules','0','0','57b7ae836ca64446ba2c296389c009b7');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`,`uuid`) values ('9','Templates/Network devices','0','0','36bff6c29af64692839d077febfc7079');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`,`uuid`) values ('10','Templates/Operating systems','0','0','846977d1dfed4968bc5f8bdb363285bc');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`,`uuid`) values ('11','Templates/Server hardware','0','0','e960332b3f6c46a1956486d4f3f99fce');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`,`uuid`) values ('12','Templates/Applications','0','0','a571c0d144b14fd4a87a9d9b2aa9fcd6');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`,`uuid`) values ('13','Templates/Databases','0','0','748ad4d098d447d492bb935c907f652f');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`,`uuid`) values ('14','Templates/Virtualization','0','0','02e4df4f20b848e79267641790f241da');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`,`uuid`) values ('15','Templates/Telephony','0','0','1d12408342854fd5a4436dd6d5d1bd4a');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`,`uuid`) values ('16','Templates/SAN','0','0','7c2cb727f85b492d88cd56e17127c64d');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`,`uuid`) values ('17','Templates/Video surveillance','0','0','d37f71c7e3f7469bab645852a69a2018');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`,`uuid`) values ('18','Templates/Power','0','0','3dcd5bbe90534f9e8eb5c2d53756af63');
INSERT INTO `drules` (`druleid`,`proxy_hostid`,`name`,`iprange`,`delay`,`status`) values ('2',NULL,'Local network','192.168.0.1-254','1h','1');
INSERT INTO `dchecks` (`dcheckid`,`druleid`,`type`,`key_`,`snmp_community`,`ports`,`snmpv3_securityname`,`snmpv3_securitylevel`,`snmpv3_authpassphrase`,`snmpv3_privpassphrase`,`uniq`,`snmpv3_authprotocol`,`snmpv3_privprotocol`,`snmpv3_contextname`,`host_source`,`name_source`) values ('2','2','9','system.uname','','10050','','0','','','0','0','0','','1','0');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('1','0','Email','mail.example.com','example.com','zabbix@example.com','','','','','0','25','0','0','0','0','','1','3','10s','0','','30s','0','0','','','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('3','2','SMS','','','','','/dev/ttyS0','','','0','25','0','0','0','0','','1','3','10s','1','','30s','0','0','','','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('4','0','Email (HTML)','mail.example.com','example.com','zabbix@example.com','','','','','0','25','0','0','0','0','','1','3','10s','1','','30s','0','0','','','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('5','4','Mattermost','','','','','','','','0','25','0','0','0','0','','1','1','10s','1','var SEVERITY_COLORS = [\r\n    \'#97AAB3\', \'#7499FF\', \'#FFC859\',\r\n    \'#FFA059\', \'#E97659\', \'#E45959\'\r\n];\r\n\r\nvar RESOLVE_COLOR = \'#009900\';\r\n\r\nvar SEND_MODE_HANDLERS = {\r\n    alarm: handlerAlarm,\r\n    event: handlerEvent\r\n};\r\n\r\nif (!String.prototype.format) {\r\n    String.prototype.format = function() {\r\n        var args = arguments;\r\n\r\n        return this.replace(/{(\\d+)}/g, function(match, number) {\r\n            return number in args\r\n                ? args[number]\r\n                : match\r\n            ;\r\n        });\r\n    };\r\n}\r\n\r\nfunction isEventProblem(params) {\r\n    return params.event_value == 1\r\n        && params.event_update_status == 0\r\n    ;\r\n}\r\n\r\nfunction isEventUpdate(params) {\r\n    return params.event_value == 1\r\n        && params.event_update_status == 1\r\n    ;\r\n}\r\n\r\nfunction isEventResolve(params) {\r\n    return params.event_value == 0;\r\n}\r\n\r\nfunction getPermalink(mattermost_url, team_name, postid) {\r\n    return \'{0}/{1}/pl/{2}\'.format(\r\n        mattermost_url.replace(/\\/+$/, \'\'),\r\n        team_name,\r\n        postid\r\n    );\r\n}\r\n\r\nfunction getChannel(send_to) {\r\n    switch (true) {\r\n        case /.+\\/#.+/.test(send_to):\r\n            return getChannelByName(send_to);\r\n\r\n        case /@.+/.test(send_to):\r\n            return getDirectChannel(send_to);\r\n\r\n        default:\r\n            return getChannelByID(send_to);\r\n    }\r\n}\r\n\r\nfunction getChannelByName(send_to) {\r\n    var team_chan = send_to\r\n        .trim()\r\n        .split(\'/#\');\r\n\r\n    var resp = JSON.parse(req.get(\r\n        Mattermost.channel_byname.format(team_chan[0], team_chan[1]),\r\n        JSON.stringify(fields)\r\n    )\r\n    );\r\n\r\n    if (req.getStatus() != 200) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    return resp;\r\n}\r\n\r\nfunction getDirectChannel(send_to) {\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Call {0}({1})\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(arguments)\r\n    ));\r\n\r\n    var teamUser = send_to\r\n            .trim()\r\n            .split(\'/@\'),\r\n        bot = getBotUser(),\r\n        user = getUserByName(teamUser[1]);\r\n\r\n    var resp = JSON.parse(req.post(\r\n        Mattermost.direct_channel,\r\n        JSON.stringify([bot.id, user.id])\r\n    )\r\n    );\r\n\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Result {0}: {1}\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(resp)\r\n    ));\r\n\r\n    if (req.getStatus() != 201) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    resp.team_name = teamUser[0];\r\n\r\n    return resp;\r\n}\r\n\r\nfunction getChannelByID(channelID) {\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Call {0}({1})\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(arguments)\r\n    ));\r\n\r\n    var resp = JSON.parse(req.get(\r\n        Mattermost.get_channel.format(channelID),\r\n        JSON.stringify(fields)\r\n    )\r\n    );\r\n\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Result {0}: {1}\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(resp)\r\n    ));\r\n\r\n    if (req.getStatus() != 200) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    return resp;\r\n}\r\n\r\nfunction getBotUser() {\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Call {0}({1})\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(arguments)\r\n    ));\r\n\r\n    var resp = JSON.parse(req.get(\r\n        Mattermost.bot_user,\r\n        JSON.stringify(fields)\r\n    )\r\n    );\r\n\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Result {0}: {1}\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(resp)\r\n    ));\r\n\r\n    if (req.getStatus() != 200) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    return resp;\r\n}\r\n\r\nfunction getUserByName(userName) {\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Call {0}({1})\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(arguments)\r\n    ));\r\n\r\n    var resp = JSON.parse(req.get(\r\n        Mattermost.user_byname.format(userName),\r\n        JSON.stringify(fields)\r\n    )\r\n    );\r\n\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Result {0}: {1}\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(resp)\r\n    ));\r\n\r\n    if (req.getStatus() != 200) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    return resp;\r\n}\r\n\r\nfunction getTeamByID(teamID) {\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Call {0}({1})\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(arguments)\r\n    ));\r\n\r\n    var resp = JSON.parse(req.get(\r\n        Mattermost.get_team.format(teamID),\r\n        JSON.stringify(fields)\r\n    )\r\n    );\r\n\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Result {0}: {1}\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(resp)\r\n    ));\r\n\r\n    if (req.getStatus() != 200) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    return resp;\r\n}\r\n\r\nfunction createProblemURL(zabbix_url, triggerid, eventid, event_source) {\r\n    var problem_url = \'\';\r\n    if (event_source === \'0\') {\r\n        problem_url = \'{0}/tr_events.php?triggerid={1}&eventid={2}\'\r\n            .format(\r\n                zabbix_url,\r\n                triggerid,\r\n                eventid\r\n            );\r\n    }\r\n    else {\r\n        problem_url = zabbix_url;\r\n    }\r\n\r\n    return problem_url;\r\n}\r\n\r\nfunction getTagValue(event_tags, key) {\r\n    var pattern = new RegExp(\'(\' + key + \':.+)\');\r\n    var tagValue = event_tags\r\n        .split(\',\')\r\n        .filter(function (v) {\r\n            return v.match(pattern);\r\n        })\r\n        .map(function (v) {\r\n            return v.split(\':\')[1];\r\n        })[0]\r\n        || 0;\r\n\r\n    return tagValue;\r\n}\r\n\r\nfunction handlerAlarm(req, params) {\r\n    var channel = getChannel(params.send_to);\r\n    var fields = {\r\n        channel_id: channel.id,\r\n        props: {}\r\n    };\r\n\r\n    if (isEventProblem(params)) {\r\n        var team_name = channel.team_name\r\n            ? channel.team_name\r\n            : getTeamByID(channel.team_id).name;\r\n\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_date,\r\n                params.event_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        var resp = JSON.parse(req.post(\r\n            Mattermost.post_message,\r\n            JSON.stringify(fields)\r\n        )\r\n        );\r\n\r\n        if (req.getStatus() != 201) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n\r\n        result.tags.__mattermost_post_id = resp.id;\r\n        result.tags.__mattermost_channel_id = channel.id;\r\n        result.tags.__mattermost_channel_name = channel.name;\r\n        result.tags.__mattermost_message_link = getPermalink(\r\n            params.mattermost_url,\r\n            team_name,\r\n            resp.id\r\n        );\r\n\r\n    }\r\n    else if (isEventUpdate(params)) {\r\n        fields.root_id = getTagValue(params.event_tags, \'mattermost_post_id\');\r\n\r\n        if (params.event_source === \'0\') {}\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_update_date,\r\n                params.event_update_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),\r\n                true\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.post(\r\n            Mattermost.post_message, JSON.stringify(fields)\r\n        )\r\n        );\r\n\r\n        if (req.getStatus() != 201) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n\r\n    }\r\n    else if (isEventResolve(params)) {\r\n        fields.channel_id = getTagValue(params.event_tags, \'mattermost_channel_id\');\r\n        fields.id = getTagValue(params.event_tags, \'mattermost_post_id\');\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                RESOLVE_COLOR,\r\n                params.event_date,\r\n                params.event_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        var post_id = getTagValue(params.event_tags, \'mattermost_post_id\');\r\n\r\n        resp = JSON.parse(req.put(\r\n            Mattermost.chat_update.format(post_id),\r\n            JSON.stringify(fields)\r\n        )\r\n        );\r\n\r\n        if (req.getStatus() != 200) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n    }\r\n}\r\n\r\nfunction handlerEvent(req, params) {\r\n    var channel = getChannel(params.send_to);\r\n    var fields = {\r\n        channel_id: channel.id,\r\n        props: {}\r\n    };\r\n\r\n    if (isEventProblem(params)) {\r\n        var team_name = channel.team_name\r\n            ? channel.team_name\r\n            : getTeamByID(channel.team_id).name;\r\n\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_date,\r\n                params.event_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        var resp = JSON.parse(req.post(Mattermost.post_message, JSON.stringify(fields)));\r\n\r\n        if (req.getStatus() != 201) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n\r\n        result.tags.__mattermost_channel_name = channel.name;\r\n        result.tags.__mattermost_message_link = getPermalink(\r\n            params.mattermost_url,\r\n            team_name,\r\n            resp.id\r\n        );\r\n\r\n    }\r\n    else if (isEventUpdate(params)) {\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_update_date,\r\n                params.event_update_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),\r\n                false\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.post(Mattermost.post_message, JSON.stringify(fields)));\r\n\r\n        if (req.getStatus() != 201) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n\r\n    }\r\n    else if (isEventResolve(params)) {\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                RESOLVE_COLOR,\r\n                params.event_recovery_date,\r\n                params.event_recovery_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.post(Mattermost.post_message, JSON.stringify(fields)));\r\n\r\n        if (req.getStatus() != 201) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n    }\r\n}\r\n\r\nfunction createMessage(\r\n    event_severity_color,\r\n    event_date,\r\n    event_time,\r\n    problem_url,\r\n    isShort\r\n) {\r\n    var message = {\r\n        fallbac: params.alert_subject,\r\n        title: params.alert_subject,\r\n        color: event_severity_color,\r\n        title_link: problem_url,\r\n        footer: problem_url,\r\n\r\n        fields: [\r\n            {\r\n                title: \'Host\',\r\n                value: \'{0} [{1}]\'.format(params.host_name, params.host_ip),\r\n                short: true\r\n            },\r\n            {\r\n                title: \'Event time\',\r\n                value: \'{0} {1}\'.format(event_date, event_time),\r\n                short: true\r\n            }\r\n        ],\r\n    };\r\n\r\n    \r\n    if (params.event_source === \'0\') {\r\n        message.fields.push(\r\n            {\r\n                title: \'Severity\',\r\n                value: params.event_severity,\r\n                short: true\r\n            },\r\n            {\r\n                title: \'Opdata\',\r\n                value: params.event_opdata,\r\n                short: true\r\n            }\r\n        );\r\n    }\r\n\r\n    if (!isShort && params.event_source === \'0\') {\r\n        message.fields.push(\r\n            {\r\n                title: \'Event tags\',\r\n                value: \'`{0}`\'.format(params.event_tags.replace(/__.+?:(.+?,|.+)/g, \'\') || \'None\'),\r\n                short: true\r\n            },\r\n            {\r\n                title: \'Trigger description\',\r\n                value: params.trigger_description,\r\n                short: true\r\n            }\r\n        );\r\n    }\r\n\r\n    if (params.event_source !== \'0\' || params.event_update_status === \'1\') {\r\n        message.fields.push(\r\n            {\r\n                title: \'Details\',\r\n                value: params.alert_message,\r\n                short: false\r\n            }\r\n        );\r\n    }\r\n\r\n    return message;\r\n}\r\n\r\nfunction validateParams(params) {\r\n    if (typeof params.bot_token !== \'string\' || params.bot_token.trim() === \'\') {\r\n        throw \'Field "bot_token" cannot be empty\';\r\n    }\r\n\r\n    if (isNaN(params.event_id)) {\r\n        throw \'Field "event_id" is not a number\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\') {\r\n        params.event_nseverity = \'0\';\r\n        params.event_severity = \'Not classified\';\r\n        params.event_update_status = \'0\';\r\n        params.send_mode = \'event\';\r\n    }\r\n\r\n    if (params.event_source === \'1\' || params.event_source === \'2\') {\r\n        params.event_value = \'1\';\r\n    }\r\n\r\n    if (params.event_source === \'1\') {\r\n        params.host_name = params.discovery_host_dns;\r\n        params.host_ip = params.discovery_host_ip;\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        throw \'Incorrect "event_nseverity" parameter given: \' + params.event_nseverity + \'\\nMust be 0-5.\';\r\n    }\r\n\r\n    if (typeof params.event_severity !== \'string\' || params.event_severity.trim() === \'\') {\r\n        throw \'Field "event_severity" cannot be empty\';\r\n    }\r\n\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\') {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (typeof params.host_ip !== \'string\' || params.host_ip.trim() === \'\') {\r\n        throw \'Field "host_ip" cannot be empty\';\r\n    }\r\n\r\n    if (typeof params.host_name !== \'string\' || params.host_name.trim() === \'\') {\r\n        throw \'Field "host_name" cannot be empty\';\r\n    }\r\n\r\n    if (typeof params.mattermost_url !== \'string\' || params.mattermost_url.trim() === \'\') {\r\n        throw \'Field "mattermost_url" cannot be empty\';\r\n    }\r\n\r\n    if (!/^(http|https):\\/\\/.+/.test(params.mattermost_url)) {\r\n        throw \'Field "mattermost_url" must contain a schema\';\r\n    }\r\n\r\n    if ([\'alarm\', \'event\'].indexOf(params.send_mode) === -1) {\r\n        throw \'Incorrect "send_mode" parameter given: \' + params.send_mode + \'\\nMust be "alarm" or "event".\';\r\n    }\r\n\r\n    if (typeof params.send_to !== \'string\' || params.send_to.trim() === \'\') {\r\n        throw \'Field "send_to" cannot be empty\';\r\n    }\r\n\r\n    if (isNaN(params.trigger_id) && params.event_source === \'0\') {\r\n        throw \'field "trigger_id" is not a number\';\r\n    }\r\n\r\n    if (typeof params.zabbix_url !== \'string\' || params.zabbix_url.trim() === \'\') {\r\n        throw \'Field "zabbix_url" cannot be empty\';\r\n    }\r\n\r\n    if (!/^(http|https):\\/\\/.+/.test(params.zabbix_url)) {\r\n        throw \'Field "zabbix_url" must contain a schema\';\r\n    }\r\n\r\n}\r\n\r\ntry {\r\n    var params = JSON.parse(value);\r\n\r\n    validateParams(params);\r\n\r\n    var req = new HttpRequest(),\r\n        fields = {},\r\n        result = {tags: {}};\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        req.setProxy(params.HTTPProxy);\r\n    }\r\n\r\n    req.addHeader(\'Content-Type: application/json; charset=utf-8\');\r\n    req.addHeader(\'Authorization: Bearer \' + params.bot_token);\r\n\r\n    params.mattermost_url = params.mattermost_url.replace(/\\/+$/, \'\');\r\n    params.zabbix_url = params.zabbix_url.replace(/\\/+$/, \'\');\r\n\r\n    var APIEndpoint = params.mattermost_url + \'/api/v4/\';\r\n\r\n    var Mattermost = {\r\n        post_message: APIEndpoint + \'posts\',\r\n        get_channel: APIEndpoint + \'channels/{0}\',\r\n        get_team: APIEndpoint + \'teams/{0}\',\r\n        chat_update: APIEndpoint + \'posts/{0}\',\r\n        direct_channel: APIEndpoint + \'channels/direct\',\r\n        channel_byname: APIEndpoint + \'teams/name/{0}/channels/name/{1}\',\r\n        user_byname: APIEndpoint + \'users/username/{0}\',\r\n        bot_user: APIEndpoint + \'users/me\'\r\n\r\n    };\r\n\r\n    params.send_mode = params.send_mode.toLowerCase();\r\n    params.send_mode = params.send_mode in SEND_MODE_HANDLERS\r\n        ? params.send_mode\r\n        : \'alarm\';\r\n\r\n    SEND_MODE_HANDLERS[params.send_mode](req, params);\r\n\r\n    if (params.event_source === \'0\') {\r\n        return JSON.stringify(result);\r\n    }\r\n    else {\r\n        return \'OK\';\r\n    }\r\n}\r\ncatch (error) {\r\n    Zabbix.log(4, \'[ Mattermost Webhook ] Mattermost notification failed: \' + error);\r\n    throw \'Mattermost notification failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__mattermost_message_link}','Open in Mattermost: {EVENT.TAGS.__mattermost_channel_name}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('6','4','Opsgenie','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Media = {\r\n    params: {},\r\n    name: \'\',\r\n    labels: [],\r\n    HTTPProxy: \'\',\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Media.params = params;\r\n        Media.params.api += Media.params.api.endsWith(\'/\') ? \'\' : \'/\';\r\n        Media.params.web += Media.params.web.endsWith(\'/\') ? \'\' : \'/\';\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        if (typeof HTTPProxy !== \'undefined\' && HTTPProxy.trim() !== \'\') {\r\n            Media.HTTPProxy = HTTPProxy;\r\n        }\r\n    },\r\n\r\n    setTags: function(event_tags_json) {\r\n        if (typeof event_tags_json !== \'undefined\' && event_tags_json !== \'\'\r\n                && event_tags_json !== \'{EVENT.TAGSJSON}\') {\r\n\r\n            try {\r\n                var tags = JSON.parse(event_tags_json),\r\n                    label;\r\n\r\n                tags.forEach(function (tag) {\r\n                    if (typeof tag.tag === \'string\') {\r\n                        label = (tag.tag + (typeof tag.value !== \'undefined\'\r\n                                && tag.value !== \'\' ? (\':\' + tag.value) : \'\')).replace(/\\s/g, \'_\');\r\n                        Media.labels.push(label);\r\n                    }\r\n                });\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Failed to parse "event_tags_json" param\');\r\n            }\r\n        }\r\n    },\r\n\r\n    request: function (method, query, data, allow_404) {\r\n        if (typeof(allow_404) === \'undefined\') {\r\n            allow_404 = false;\r\n        }\r\n\r\n        [\'api\', \'token\'].forEach(function (field) {\r\n            if (typeof Media.params !== \'object\' || typeof Media.params[field] === \'undefined\'\r\n                    || Media.params[field] === \'\') {\r\n                throw \'Required \' + Media.name + \' param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Media.params.api + query,\r\n            request = new HttpRequest();\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'Authorization: \' + Media.params.token);\r\n        request.setProxy(Media.HTTPProxy);\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Failed to parse response.\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if ((request.getStatus() < 200 || request.getStatus() >= 300)\r\n                && (!allow_404 || request.getStatus() !== 404)) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null) {\r\n                if (typeof response.errors === \'object\' && Object.keys(response.errors).length > 0) {\r\n                    message += \': \' + JSON.stringify(response.errors);\r\n                }\r\n                else if (typeof response.errorMessages === \'object\' && Object.keys(response.errorMessages).length > 0) {\r\n                    message += \': \' + JSON.stringify(response.errorMessages);\r\n                }\r\n                else if (typeof response.message === \'string\') {\r\n                    message += \': \' + response.message;\r\n                }\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.getStatus(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    getAlertId: function (requestId) {\r\n        do {\r\n            resp = Media.request(\'get\', \'requests/\' + requestId, undefined, true);\r\n        }\r\n        while (typeof resp.response !== \'object\' || typeof resp.response.data === \'undefined\'\r\n                || resp.response.data.success === false);\r\n\r\n        if (typeof resp.response !== \'object\' || typeof resp.response.data === \'undefined\') {\r\n            throw \'Cannot get \' + Media.name + \' issue ID. Check debug log for more information.\';\r\n        }\r\n\r\n        return resp;\r\n    }\r\n};\r\n\r\ntry {\r\n    var result = {tags: {}},\r\n        params = JSON.parse(value),\r\n        media = {},\r\n        fields = {},\r\n        resp = {},\r\n        responders = [],\r\n        tags = [],\r\n        required_params = [\r\n            \'alert_subject\',\r\n            \'alert_message\',\r\n            \'event_id\',\r\n            \'event_source\',\r\n            \'event_value\',\r\n            \'event_update_status\',\r\n            \'opsgenie_api\',\r\n            \'opsgenie_web\',\r\n            \'opsgenie_token\'\r\n        ],\r\n        severities = [\r\n            \'not_classified\',\r\n            \'information\',\r\n            \'warning\',\r\n            \'average\',\r\n            \'high\',\r\n            \'disaster\',\r\n            \'resolved\',\r\n            \'default\'\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n            if (key.startsWith(\'opsgenie_\')) {\r\n                media[key.substring(9)] = params[key];\r\n            }\r\n        });\r\n\r\n    // Possible values of event_source:\r\n    // 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check event_value for trigger-based and internal events.\r\n    // Possible values: 1 for problem, 0 for recovering\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check event_update_status only for trigger-based events.\r\n    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check event_id for a numeric value.\r\n    if (isNaN(parseInt(params.event_id)) || params.event_id < 1) {\r\n        throw \'Incorrect "event_id" parameter given: \' + params.event_id + \'\\nMust be a positive number.\';\r\n    }\r\n\r\n    if ((params.event_source === \'1\' || params.event_source === \'2\')  && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for Trigger and Internal actions.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity]];\r\n    params.zbxurl = params.zbxurl + (params.zbxurl.endsWith(\'/\') ? \'\' : \'/\');\r\n\r\n    Media.name = \'Opsgenie\';\r\n    Media.setParams(media);\r\n    Media.params.token = \'GenieKey \' + Media.params.token;\r\n    Media.setProxy(params.HTTPProxy);\r\n    Media.setTags(params.event_tags_json); // Set Media.labels\r\n\r\n    // Create an issue.\r\n    // Numeric value of the event that triggered an action (1 for problem, 0 for recovering).\r\n    // Numeric value of of the problem update status. Possible values:\r\n    // 0 - Webhook was called because of problem/recovery event, 1 - Update operation.\r\n    if ((params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0)\r\n            || (params.event_source == 3 && params.event_value == 1)\r\n            || params.event_source == 1 || params.event_source == 2) {\r\n        fields.message = params.alert_subject;\r\n        fields.alias = params.event_id;\r\n        fields.description = params.alert_message;\r\n        fields.priority = priority;\r\n        fields.source = \'Zabbix\';\r\n\r\n        if (params.event_source === \'0\') {\r\n            fields.details = {\r\n                \'Zabbix server\': params.zbxurl,\r\n                Problem: params.zbxurl + \'tr_events.php?triggerid=\' + params.trigger_id + \'&eventid=\' + params.event_id\r\n            };\r\n        }\r\n        else {\r\n            fields.details = {\'Zabbix server\': params.zbxurl};\r\n        }\r\n\r\n        if (typeof params.opsgenie_teams === \'string\') {\r\n            responders = params.opsgenie_teams.split(\',\');\r\n            fields.responders = responders.map(function(team) {\r\n                return {type: \'team\', name: team.trim()};\r\n            });\r\n        }\r\n\r\n        fields.tags = Media.labels;\r\n        if (typeof params.opsgenie_tags === \'string\') {\r\n            tags = params.opsgenie_tags.split(\',\');\r\n            tags.forEach(function(item) {\r\n                fields.tags.push(item.trim());\r\n            });\r\n        }\r\n\r\n        resp = Media.request(\'post\', \'\', fields);\r\n        if (typeof resp.response !== \'object\' || typeof resp.response.result === \'undefined\') {\r\n            throw \'Cannot create \' + Media.name + \' issue. Check debug log for more information.\';\r\n        }\r\n\r\n        if (resp.status === 202) {\r\n            resp = Media.getAlertId(resp.response.requestId);\r\n            if (params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0) {\r\n                result.tags.__zbx_ops_issuekey = resp.response.data.alertId;\r\n                result.tags.__zbx_ops_issuelink = Media.params.web + \'alert/detail/\' + resp.response.data.alertId;\r\n            }\r\n        }\r\n        else {\r\n            throw Media.name + \' response code is unexpected. Check debug log for more information.\';\r\n        }\r\n    }\r\n    // Update a created issue.\r\n    else {\r\n        fields.user = (params.event_value != 0) ? params.zbxuser : \'\';\r\n        fields.note = params.alert_message;\r\n\r\n        resp = Media.request(\'post\', params.event_id + \'/notes?identifierType=alias\', fields);\r\n        if (typeof resp.response !== \'object\' || typeof resp.response.result === \'undefined\') {\r\n            throw \'Cannot update \' + Media.name + \' issue. Check debug log for more information.\';\r\n        }\r\n\r\n        if (resp.status === 202) {\r\n            resp = Media.getAlertId(resp.response.requestId);\r\n        }\r\n        else {\r\n            throw Media.name + \' response code is unexpected. Check debug log for more information.\';\r\n        }\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ \' + Media.name + \' Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_ops_issuelink}','Opsgenie: {EVENT.TAGS.__zbx_ops_issuekey}','Please refer to https://docs.opsgenie.com/docs/alert-api and https://www.zabbix.com/documentation/5.4/manual/config/notifications/media/webhook#example_scripts.\r\n  \r\nSet global macro {$ZABBIX.URL} with your Zabbix server URL.\r\nAdd dedicated user with media type "Opsgenie".\r\nChange the values of the variables opsgenie_api (https://api.opsgenie.com/v2/alerts or https://api.eu.opsgenie.com/v2/alerts),\r\nopsgenie_web (for example, https://myzabbix.app.opsgenie.com), opsgenie_token.');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('7','4','PagerDuty','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','try {\r\n\r\n    var params = JSON.parse(value),\r\n        req = new HttpRequest(),\r\n        fields = {},\r\n        resp = \'\';\r\n\r\n    // Correspondence between the PagerDuty and Zabbix severity level\r\n    var severityMapping = [\r\n        \'info\',    // Not classified\r\n        \'info\',    // Information\r\n        \'warning\', // Warning\r\n        \'warning\', // Average\r\n        \'error\',   // High\r\n        \'critical\' // Disaster\r\n    ];\r\n\r\n    if (!severityMapping[params.severity]) {\r\n        params.severity = \'0\';\r\n    }\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        req.setProxy(params.HTTPProxy);\r\n    }\r\n\r\n    if (isNaN(parseInt(params.eventid)) || params.eventid < 1) {\r\n        throw \'incorrect value for variable "eventid". The value must be a positive number.\';\r\n    }\r\n    if (params.eventname.length < 1) {\r\n        throw \'incorrect value for variable "eventname". The value must be a non-empty string.\';\r\n    }\r\n    if (isNaN(parseInt(params.severity)) || (params.severity < 0 && params.severity > 5)) {\r\n        throw \'incorrect value for variable "severity". The value must be a number 0..5.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.eventvalue !== \'0\' && params.eventvalue !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "eventvalue" parameter given: "\' + params.eventvalue + \'".\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source === \'0\') {\r\n        if (params.hostname.length < 1) {\r\n            throw \'incorrect value for variable "hostname". The value must be a non-empty string.\';\r\n        }\r\n        if (isNaN(parseInt(params.triggerid)) || params.triggerid < 1) {\r\n            throw \'incorrect value for variable "triggerid". The value must be a positive number.\';\r\n        }\r\n        if (params.eventack != \'Yes\' && params.eventack != \'No\') {\r\n            throw \'incorrect value for variable "eventack". The value must be Yes or No.\';\r\n        }\r\n        if (isNaN(parseInt(params.eventupdate)) || (params.eventupdate < 0 || params.eventupdate > 1)) {\r\n            throw \'incorrect value for variable "eventupdate". The value must be 0 or 1.\';\r\n        }\r\n    }\r\n\r\n\r\n\r\n    req.addHeader(\'Content-Type: application/json\');\r\n\r\n    fields.routing_key = params.token;\r\n    fields.dedup_key = params.eventid;\r\n\r\n    if (((params.eventvalue == 1) && (params.eventupdate == 0)) || params.event_source !== \'0\') {\r\n        fields.event_action = \'trigger\';\r\n        fields.payload = {\r\n            summary: params.eventname,\r\n            source: (params.event_source === \'1\') ? \'Discovery\' : params.hostname + \' : \' + params.hostip,\r\n            severity: severityMapping[params.severity],\r\n        };\r\n        \r\n        if (params.event_source === \'0\') {\r\n            fields.payload.custom_details = {\r\n                \'Event date\': params.eventdate,\r\n                \'Event time\': params.eventtime,\r\n                \'Trigger description\': params.triggerdesc,\r\n                \'Trigger opdata\': params.triggeropdata,\r\n                \'Event tags\': params.eventtags,\r\n                \'Event host\': params.hostname,\r\n                \'Event host ip\': params.hostip\r\n            };\r\n            fields.links = [{\r\n                href: params.url + \'/tr_events.php?triggerid=\' + params.triggerid + \'&eventid=\' + params.eventid,\r\n                text: \'Event link\'\r\n            }];\r\n        }\r\n        else {\r\n            fields.payload.custom_details = {\r\n                \'Alert message\': params.alert_message\r\n            };\r\n        }\r\n\r\n        fields.client = \'Zabbix\';\r\n        fields.client_url = params.url;\r\n    }\r\n    else if ((params.eventvalue == 1) && (params.eventupdate == 1) && (params.eventack == \'Yes\'))\r\n        fields.event_action = \'acknowledge\';\r\n    else if (params.eventvalue == 0)\r\n        fields.event_action = \'resolve\';\r\n    else\r\n        throw \'incorrect values. Update message without ack will not be sent.\';\r\n\r\n    Zabbix.log(4, \'[PagerDuty Webhook] Sending request:\' + JSON.stringify(fields));\r\n    resp = req.post(\'https://events.pagerduty.com/v2/enqueue\',\r\n        JSON.stringify(fields)\r\n    );\r\n    Zabbix.log(4, \'[PagerDuty Webhook] Receiving response:\' + resp);\r\n\r\n    try {\r\n        resp = JSON.parse(resp);\r\n    }\r\n    catch (error) {\r\n        throw \'incorrect response. PagerDuty returned a non-JSON object.\';\r\n    }\r\n\r\n    if (req.getStatus() != 202) {\r\n        if (typeof resp === \'object\' && typeof resp.errors === \'object\' && typeof resp.errors[0] === \'string\') {\r\n            throw resp.errors[0];\r\n        }\r\n        else {\r\n            throw \'Unknown error.\';\r\n        }\r\n    }\r\n\r\n    if (resp.status != \'success\') {\r\n        throw \'Unknown error.\';\r\n    }\r\n\r\n    return \'OK\';\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[PagerDuty Webhook] Notification failed : \' + error);\r\n    throw \'PagerDuty notification failed : \' + error;\r\n}','30s','0','0','','','Please refer to https://v2.developer.pagerduty.com/docs/send-an-event-events-api-v2 and https://www.zabbix.com/documentation/5.4/manual/config/notifications/media/webhook#example_scripts.\r\n  \r\nSet global macro {$ZABBIX.URL} with your Zabbix server URL.\r\nAdd a dedicated user with the media type "PagerDuty" and place the integration key in the "token" parameter to integrate into the service.');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('8','4','Pushover','','','','','','','','0','25','0','0','0','0','','0','3','10s','1','try {\r\n    var params = JSON.parse(value),\r\n        request = new HttpRequest(),\r\n        data,\r\n        response,\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        request.setProxy(params.HTTPProxy);\r\n    }\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'priority_\' + severities[params.event_nseverity].name] || params.priority_default;\r\n\r\n    if (isNaN(priority) || priority < -2 || priority > 2) {\r\n        throw \'"priority" should be -2..2\';\r\n    }\r\n\r\n    if (params.event_source === \'0\' && isNaN(params.triggerid)) {\r\n        throw \'field "triggerid" is not a number\';\r\n    }\r\n\r\n    if (isNaN(params.eventid)) {\r\n        throw \'field "eventid" is not a number\';\r\n    }\r\n\r\n    if (typeof params.message !== \'string\' || params.message.trim() === \'\') {\r\n        throw \'field "message" cannot be empty\';\r\n    }\r\n\r\n    data = {\r\n        token: params.token,\r\n        user: params.user,\r\n        title: params.title,\r\n        message: params.message,\r\n        url: (params.event_source === \'0\') \r\n            ? params.url + \'/tr_events.php?triggerid=\' + params.triggerid + \'&eventid=\' + params.eventid\r\n            : params.url,\r\n        url_title: params.url_title,\r\n        priority: priority\r\n    };\r\n\r\n    if (priority == 2) {\r\n        if (isNaN(params.retry) || params.retry < 30) {\r\n            throw \'field "retry" should be a number with value of at least 30 if "priority" is set to 2\';\r\n        }\r\n\r\n        if (isNaN(params.expire) || params.expire > 10800) {\r\n            throw \'field "expire" should be a number with value of at most 10800 if "priority" is set to 2\';\r\n        }\r\n\r\n        data.retry = params.retry;\r\n        data.expire = params.expire;\r\n    }\r\n\r\n    data = JSON.stringify(data);\r\n    Zabbix.log(4, \'[ Pushover Webhook ] Sending request: \' + params.endpoint + \'\\n\' + data);\r\n\r\n    request.addHeader(\'Content-Type: application/json\');\r\n    response = request.post(params.endpoint, data);\r\n\r\n    Zabbix.log(4, \'[ Pushover Webhook ] Received response with status code \' + request.getStatus() + \'\\n\' + response);\r\n\r\n    if (response !== null) {\r\n        try {\r\n            response = JSON.parse(response);\r\n        }\r\n        catch (error) {\r\n            Zabbix.log(4, \'[ Pushover Webhook ] Failed to parse response received from Pushover\');\r\n            response = null;\r\n        }\r\n    }\r\n\r\n    if (request.getStatus() != 200 || response === null || typeof response !== \'object\' || response.status !== 1) {\r\n        if (response !== null && typeof response === \'object\' && typeof response.errors === \'object\'\r\n                && typeof response.errors[0] === \'string\') {\r\n            throw response.errors[0];\r\n        }\r\n        else {\r\n            throw \'Unknown error. Check debug log for more information.\';\r\n        }\r\n    }\r\n\r\n    return \'OK\';\r\n}\r\ncatch (error) {\r\n    Zabbix.log(4, \'[ Pushover Webhook ] Pushover notification failed: \' + error);\r\n    throw \'Pushover notification failed: \' + error;\r\n}','30s','0','0','','','Please refer to setup guide here: https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/pushover\r\n\r\nSet token parameter with to your Pushover application key.\r\nWhen assigning Pushover media to the Zabbix user - add user key into send to field.');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('9','4','Slack','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var SEVERITY_COLORS = [\r\n    \'#97AAB3\', \'#7499FF\', \'#FFC859\',\r\n    \'#FFA059\', \'#E97659\', \'#E45959\'\r\n];\r\n\r\nvar RESOLVE_COLOR = \'#009900\';\r\n\r\nvar SLACK_MODE_HANDLERS = {\r\n    alarm: handlerAlarm,\r\n    event: handlerEvent\r\n};\r\n\r\n\r\nif (!String.prototype.format) {\r\n    String.prototype.format = function() {\r\n        var args = arguments;\r\n\r\n        return this.replace(/{(\\d+)}/g, function(match, number) {\r\n            return number in args\r\n                ? args[number]\r\n                : match\r\n            ;\r\n        });\r\n    };\r\n}\r\n\r\nfunction isEventProblem(params) {\r\n    return params.event_value == 1\r\n        && params.event_update_status == 0\r\n    ;\r\n}\r\n\r\nfunction isEventUpdate(params) {\r\n    return params.event_value == 1\r\n        && params.event_update_status == 1\r\n    ;\r\n}\r\n\r\nfunction isEventResolve(params) {\r\n    return params.event_value == 0;\r\n}\r\n\r\nfunction getPermalink(channelId, messageTimestamp) {\r\n    var req = new HttpRequest();\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        req.setProxy(params.HTTPProxy);\r\n    }\r\n\r\n    req.addHeader(\'Content-Type: application/x-www-form-urlencoded; charset=utf-8\');\r\n    req.addHeader(\'Authorization: Bearer \' + params.bot_token);\r\n\r\n    var query = \'{0}?channel={1}&message_ts={2}\'.format(\r\n            Slack.getPermalink,\r\n            encodeURIComponent(channelId),\r\n            encodeURIComponent(messageTimestamp)),\r\n        resp = JSON.parse(req.get(query));\r\n\r\n    if (req.getStatus() != 200 || !resp.ok || resp.ok === \'false\') {\r\n        throw \'message was created, but getting message link was failed with reason "\' + resp.error + \'"\';\r\n    }\r\n\r\n    return resp.permalink;\r\n}\r\n\r\nfunction createProblemURL(zabbix_url, triggerid, eventid, event_source) {\r\n    var problem_url = \'\';\r\n    if (event_source === \'0\') {\r\n        problem_url = \'{0}/tr_events.php?triggerid={1}&eventid={2}\'\r\n            .format(\r\n                zabbix_url,\r\n                triggerid,\r\n                eventid\r\n            );\r\n    }\r\n    else {\r\n        problem_url = zabbix_url;\r\n    }\r\n\r\n    return problem_url;\r\n}\r\n\r\nfunction handlerAlarm(params) {\r\n    var fields = {\r\n        channel: params.channel,\r\n        as_user: params.slack_as_user,\r\n    };\r\n\r\n    if (isEventProblem(params)) {\r\n        fields.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_date,\r\n                params.event_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        var resp = JSON.parse(req.post(Slack.postMessage, JSON.stringify(fields)));\r\n\r\n        if (req.getStatus() != 200 || !resp.ok || resp.ok === \'false\') {\r\n            throw resp.error;\r\n        }\r\n\r\n        result.tags = {\r\n            [\'__message_ts_\' + params.channel]: resp.ts,\r\n            [\'__channel_id_\' + params.channel]: resp.channel,\r\n            [\'__message_link_\' + params.channel]: getPermalink(resp.channel, resp.ts),\r\n        };\r\n\r\n    }\r\n    else if (isEventUpdate(params)) {\r\n        try {\r\n            var channel_event_tags = JSON.parse(params.event_tags);\r\n        } catch (error) {\r\n            throw \'Cannot process event tags: \' + error;\r\n        }\r\n\r\n        if (Array.isArray(channel_event_tags)) {\r\n            for (i in channel_event_tags) {\r\n                if (channel_event_tags[i].tag.includes(\'__message_ts_\' + params.channel)) {\r\n                    fields.thread_ts = channel_event_tags[i].value;\r\n                    break;\r\n                }\r\n            }\r\n        }\r\n\r\n        fields.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_update_date,\r\n                params.event_update_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),\r\n                true\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.post(Slack.postMessage, JSON.stringify(fields)));\r\n\r\n        if (req.getStatus() != 200 || !resp.ok || resp.ok === \'false\') {\r\n            throw resp.error;\r\n        }\r\n\r\n    }\r\n    else if (isEventResolve(params)) {\r\n\r\n        fields.text = \'\';\r\n\r\n        try {\r\n            var channel_event_tags = JSON.parse(params.event_tags);\r\n        } catch (error) {\r\n            throw \'Cannot process event tags: \' + error;\r\n        }\r\n\r\n        if (Array.isArray(channel_event_tags)) {\r\n            for (i in channel_event_tags) {\r\n                if (channel_event_tags[i].tag.includes(\'__channel_id_\' + params.channel)) {\r\n                    fields.channel = channel_event_tags[i].value;\r\n                    continue;\r\n                }\r\n                if (channel_event_tags[i].tag.includes(\'__message_ts_\' + params.channel)) {\r\n                    fields.ts = channel_event_tags[i].value;\r\n                }\r\n            }\r\n        }\r\n\r\n        fields.attachments = [\r\n            createMessage(\r\n                RESOLVE_COLOR,\r\n                params.event_date,\r\n                params.event_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.post(Slack.chatUpdate, JSON.stringify(fields)));\r\n        if (req.getStatus() != 200 || !resp.ok || resp.ok === \'false\') {\r\n            throw resp.error;\r\n        }\r\n    }\r\n}\r\n\r\nfunction handlerEvent(params) {\r\n    var fields = {\r\n        channel: params.channel,\r\n        as_user: params.slack_as_user\r\n    };\r\n\r\n    if (isEventProblem(params)) {\r\n        fields.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_date,\r\n                params.event_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        var resp = JSON.parse(req.post(Slack.postMessage, JSON.stringify(fields)));\r\n\r\n        if (req.getStatus() != 200 || !resp.ok || resp.ok === \'false\') {\r\n            throw resp.error;\r\n        }\r\n\r\n        result.tags = {\r\n            [\'__message_link_\' + params.channel]: getPermalink(resp.channel, resp.ts)\r\n        }\r\n\r\n    }\r\n    else if (isEventUpdate(params)) {\r\n        fields.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_update_date,\r\n                params.event_update_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),\r\n                false\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.post(Slack.postMessage, JSON.stringify(fields)));\r\n\r\n        if (req.getStatus() != 200 || !resp.ok || resp.ok === \'false\') {\r\n            throw resp.error;\r\n        }\r\n\r\n    }\r\n    else if (isEventResolve(params)) {\r\n        fields.attachments = [\r\n            createMessage(\r\n                RESOLVE_COLOR,\r\n                params.event_recovery_date,\r\n                params.event_recovery_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.post(Slack.postMessage, JSON.stringify(fields)));\r\n\r\n        if (req.getStatus() != 200 || !resp.ok || resp.ok === \'false\') {\r\n            throw resp.error;\r\n        }\r\n    }\r\n}\r\n\r\nfunction createMessage(\r\n    event_severity_color,\r\n    event_date,\r\n    event_time,\r\n    problem_url,\r\n    isShort,\r\n    messageText\r\n) {\r\n    var message = {\r\n        fallback: params.alert_subject,\r\n        title: params.alert_subject,\r\n        color: event_severity_color,\r\n        title_link: problem_url,\r\n        pretext: messageText || \'\',\r\n\r\n        fields: [\r\n            {\r\n                title: \'Host\',\r\n                value: \'{0} [{1}]\'.format(params.host_name, params.host_conn),\r\n                short: true\r\n            },\r\n            {\r\n                title: \'Event time\',\r\n                value: \'{0} {1}\'.format(event_date, event_time),\r\n                short: true\r\n            }\r\n        ],\r\n    };\r\n\r\n    if (params.event_source === \'0\') {\r\n        message.fields.push(\r\n            {\r\n                title: \'Severity\',\r\n                value: params.event_severity,\r\n                short: true\r\n            },\r\n            {\r\n                title: \'Opdata\',\r\n                value: params.event_opdata,\r\n                short: true\r\n            }\r\n        );\r\n    }\r\n\r\n    if (!isShort  && params.event_source === \'0\') {\r\n        message[\'actions\'] = [\r\n            {\r\n                type: \'button\',\r\n                text: \'Open in Zabbix\',\r\n                url: problem_url\r\n            }\r\n        ];\r\n\r\n        message.fields.push(\r\n            {\r\n                title: \'Event tags\',\r\n                value: JSON.parse(params.event_tags).filter(function (e) { return !e.tag.includes(\'__\') }).map(function (e) { return e.tag + \': \' + e.value }).join(\'\\n\') || \'None\',\r\n                short: true\r\n            },\r\n            {\r\n                title: \'Trigger description\',\r\n                value: params.trigger_description,\r\n                short: true\r\n            }\r\n        );\r\n    }\r\n\r\n    if (params.event_source !== \'0\' || params.event_update_status === \'1\') {\r\n        message.fields.push(\r\n            {\r\n                title: \'Details\',\r\n                value: params.alert_message,\r\n                short: false\r\n            }\r\n        );\r\n    }\r\n\r\n    return message;\r\n}\r\n\r\nfunction validateParams(params) {\r\n    if (typeof params.bot_token !== \'string\' || params.bot_token.trim() === \'\') {\r\n        throw \'Field "bot_token" cannot be empty\';\r\n    }\r\n\r\n    if (typeof params.channel !== \'string\' || params.channel.trim() === \'\') {\r\n        throw \'Field "channel" cannot be empty\';\r\n    }\r\n\r\n    if (isNaN(params.event_id)) {\r\n        throw \'Field "event_id" is not a number\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\') {\r\n        params.event_nseverity = \'0\';\r\n        params.event_severity = \'Not classified\';\r\n        params.event_update_status = \'0\';\r\n        params.slack_mode = \'event\';\r\n    }\r\n\r\n    if (params.event_source === \'1\' || params.event_source === \'2\') {\r\n        params.event_value = \'1\';\r\n    }\r\n\r\n    if (params.event_source === \'1\') {\r\n        params.host_name = params.discovery_host_dns;\r\n        params.host_ip = params.discovery_host_ip;\r\n    }\r\n\r\n    if (!~[0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity))) {\r\n        throw \'Incorrect "event_nseverity" parameter given: \' + params.event_nseverity + \'\\nMust be 0-5.\';\r\n    }\r\n\r\n    if (typeof params.event_severity !== \'string\' || params.event_severity.trim() === \'\') {\r\n        throw \'Field "event_severity" cannot be empty\';\r\n    }\r\n\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\') {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (typeof params.host_conn !== \'string\' || params.host_conn.trim() === \'\') {\r\n        throw \'Field "host_conn" cannot be empty\';\r\n    }\r\n\r\n    if (typeof params.host_name !== \'string\' || params.host_name.trim() === \'\') {\r\n        throw \'Field "host_name" cannot be empty\';\r\n    }\r\n\r\n    if (!~[\'true\', \'false\'].indexOf(params.slack_as_user.toLowerCase())) {\r\n        throw \'Incorrect "slack_as_user" parameter given: \' + params.slack_as_user + \'\\nMust be "true" or "false".\';\r\n    }\r\n\r\n    if (!~[\'alarm\', \'event\'].indexOf(params.slack_mode)) {\r\n        throw \'Incorrect "slack_mode" parameter given: \' + params.slack_mode + \'\\nMust be "alarm" or "event".\';\r\n    }\r\n\r\n    if (isNaN(params.trigger_id) && params.event_source === \'0\') {\r\n        throw \'field "trigger_id" is not a number\';\r\n    }\r\n\r\n    if (typeof params.zabbix_url !== \'string\' || params.zabbix_url.trim() === \'\') {\r\n        throw \'Field "zabbix_url" cannot be empty\';\r\n    }\r\n\r\n    if (!/^(http|https):\\/\\/.+/.test(params.zabbix_url)) {\r\n        throw \'Field "zabbix_url" must contain a schema\';\r\n    }\r\n}\r\n\r\ntry {\r\n    var params = JSON.parse(value);\r\n\r\n    validateParams(params);\r\n\r\n    var req = new HttpRequest(),\r\n        result = {tags: {}};\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        req.setProxy(params.HTTPProxy);\r\n    }\r\n\r\n    req.addHeader(\'Content-Type: application/json; charset=utf-8\');\r\n    req.addHeader(\'Authorization: Bearer \' + params.bot_token);\r\n\r\n    var slack_endpoint = \'https://slack.com/api/\';\r\n\r\n    var Slack = {\r\n        postMessage: slack_endpoint + \'chat.postMessage\',\r\n        getPermalink: slack_endpoint + \'chat.getPermalink\',\r\n        chatUpdate: slack_endpoint + \'chat.update\'\r\n    };\r\n\r\n    params.slack_mode = params.slack_mode.toLowerCase();\r\n    params.slack_mode = params.slack_mode in SLACK_MODE_HANDLERS\r\n        ? params.slack_mode\r\n        : \'alarm\';\r\n\r\n    SLACK_MODE_HANDLERS[params.slack_mode](params);\r\n\r\n    if (params.event_source === \'0\') {\r\n        return JSON.stringify(result);\r\n    }\r\n    else {\r\n        return \'OK\';\r\n    }\r\n}\r\ncatch (error) {\r\n    Zabbix.log(4, \'[ Slack Webhook ] Slack notification failed : \' + error);\r\n    throw \'Slack notification failed : \' + error;\r\n}','30s','1','0','','','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('10','4','Discord','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var SEVERITY_COLORS = [\r\n    \'#97AAB3\', // Not classified.\r\n    \'#7499FF\', // Information.\r\n    \'#FFC859\', // Warning.\r\n    \'#FFA059\', // Average.\r\n    \'#E97659\', // High.\r\n    \'#E45959\', // Disaster.\r\n    \'#009900\'  // Resolved.\r\n];\r\n\r\nfunction stringTruncate(str, len) {\r\n    return str.length > len ? str.substring(0, len - 3) + \'...\' : str;\r\n}\r\n\r\ntry {\r\n    Zabbix.log(4, \'[ Discord Webhook ] Executed with params: \' + value);\r\n\r\n    var params = JSON.parse(value);\r\n\r\n    if (!params.discord_endpoint) {\r\n        throw \'Cannot get discord_endpoint\';\r\n    }\r\n    else {\r\n        params.discord_endpoint = params.discord_endpoint.replace(\'/api/\', \'/api/v7/\') + \'?wait=True\';\r\n    }\r\n\r\n    params.zabbix_url = (params.zabbix_url.endsWith(\'/\'))\r\n        ? params.zabbix_url.slice(0, -1) : params.zabbix_url;\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Set params to true for non trigger-based events.\r\n    if (params.event_source !== \'0\') {\r\n        params.use_default_message = \'true\';\r\n        params.event_nseverity = \'0\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: "\' + params.event_value + \'".\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: "\' + params.event_update_status + \'".\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_value == 0) {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    if (!SEVERITY_COLORS[params.event_nseverity]) {\r\n        throw \'Incorrect "event_nseverity" parameter given: \' + params.event_nseverity + \'\\nMust be 0-5.\';\r\n    }\r\n\r\n    var color = parseInt(SEVERITY_COLORS[params.event_nseverity].replace(\'#\', \'\'), 16),\r\n        fields = [],\r\n        body = {\r\n            embeds: [\r\n                {\r\n                    color: color || 0,\r\n                    url: (params.event_source === \'0\')\r\n                        ? params.zabbix_url + \'/tr_events.php?triggerid=\' + params.trigger_id +\r\n                            \'&eventid=\' + params.event_id\r\n                        : params.zabbix_url\r\n                }\r\n            ]\r\n        };\r\n\r\n    // Default message from {ALERT.MESSAGE}.\r\n    if (params.use_default_message.toLowerCase() == \'true\') {\r\n        body.embeds[0].title = stringTruncate(params.alert_subject, 256);\r\n        body.embeds[0].description = stringTruncate(params.alert_message, 2048);\r\n    }\r\n    else {\r\n        fields.push(\r\n            {\r\n                name: \'Host\',\r\n                value: params.host_name + \' [\' + params.host_ip + \']\'\r\n            }\r\n        );\r\n\r\n        // Resolved message.\r\n        if (params.event_value == 0 && params.event_update_status == 0) {\r\n            body.embeds[0].title = stringTruncate(\'OK: \' + params.event_name, 256);\r\n            fields.push(\r\n                {\r\n                    name: \'Recovery time\',\r\n                    value: params.event_recovery_time + \' \' + params.event_recovery_date,\r\n                    inline: \'True\'\r\n                }\r\n            );\r\n        }\r\n\r\n        // Problem message.\r\n        else if (params.event_value == 1 && params.event_update_status == 0) {\r\n            body.embeds[0].title = stringTruncate(\'PROBLEM: \' + params.event_name, 256);\r\n            fields.push(\r\n                {\r\n                    name: \'Event time\',\r\n                    value: params.event_time + \' \' + params.event_date,\r\n                    inline: \'True\'\r\n                }\r\n            );\r\n        }\r\n\r\n        // Update message.\r\n        else if (params.event_update_status == 1) {\r\n            body.embeds[0].title = stringTruncate(\'UPDATE: \' + params.event_name, 256);\r\n            body.embeds[0].description = params.event_update_user + \' \' + params.event_update_action + \'.\';\r\n\r\n            if (params.event_update_message) {\r\n                body.embeds[0].description += \' Comment:\\n>>> \' + params.event_update_message;\r\n            }\r\n\r\n            body.embeds[0].description = stringTruncate(body.embeds[0].description, 2048);\r\n\r\n            fields.push(\r\n                {\r\n                    name: \'Event update time\',\r\n                    value: params.event_update_time + \' \' + params.event_update_date,\r\n                    inline: \'True\'\r\n                }\r\n            );\r\n        }\r\n\r\n        fields.push(\r\n            {\r\n                name: \'Severity\',\r\n                value: params.event_severity,\r\n                inline: \'True\'\r\n            }\r\n        );\r\n\r\n        if (params.event_opdata) {\r\n            fields.push(\r\n                {\r\n                    name: \'Operational data\',\r\n                    value: stringTruncate(params.event_opdata, 1024),\r\n                    inline: \'True\'\r\n                }\r\n            );\r\n        }\r\n\r\n        if (params.event_value == 1 && params.event_update_status == 0 && params.trigger_description) {\r\n            fields.push(\r\n                {\r\n                    name: \'Trigger description\',\r\n                    value: stringTruncate(params.trigger_description, 1024)\r\n                }\r\n            );\r\n        }\r\n\r\n        body.embeds[0].footer = {\r\n            text: \'Event ID: \' + params.event_id\r\n        };\r\n\r\n        if (params.event_tags) {\r\n            body.embeds[0].footer.text += \'\\nEvent tags: \' + params.event_tags;\r\n        }\r\n        body.embeds[0].footer.text = stringTruncate(body.embeds[0].footer.text, 2048);\r\n    }\r\n\r\n    if (fields.length > 0) {\r\n        body.embeds[0].fields = fields;\r\n    }\r\n\r\n    var req = new HttpRequest();\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        req.setProxy(params.HTTPProxy);\r\n    }\r\n\r\n    req.addHeader(\'Content-Type: application/json\');\r\n\r\n    var resp = req.post(params.discord_endpoint, JSON.stringify(body)),\r\n        data = JSON.parse(resp);\r\n\r\n    Zabbix.log(4, \'[ Discord Webhook ] JSON: \' + JSON.stringify(body));\r\n    Zabbix.log(4, \'[ Discord Webhook ] Response: \' + resp);\r\n\r\n    if (data.id) {\r\n        return resp;\r\n    }\r\n    else {\r\n        var message = ((typeof data.message === \'string\') ? data.message : \'Unknown error\');\r\n\r\n        Zabbix.log(3, \'[ Discord Webhook ] FAILED with response: \' + resp);\r\n        throw message + \'. For more details check zabbix server log.\';\r\n    }\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ Discord Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('11','4','SIGNL4','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','// SIGNL4 Webhook\r\ntry {\r\n    var response,\r\n        payload,\r\n        params = JSON.parse(value),\r\n        endpoint = \'https://connect.signl4.com/webhook/\',\r\n        request = new HttpRequest();\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        request.setProxy(params.HTTPProxy);\r\n    }\r\n\r\n    if (typeof params.teamsecret === \'string\' && params.teamsecret.trim() !== \'\') {\r\n        endpoint += params.teamsecret;\r\n        delete params.teamsecret;\r\n    }\r\n    else {\r\n        throw \'The team secret of your SIGNL4 team cannot be empty.\';\r\n    }\r\n\r\n    if (typeof params.Severity === \'string\' && params.Severity === \'{EVENT.SEVERITY}\') {\r\n        params.Severity = \'Not classified\';\r\n    }\r\n\r\nif (typeof params.User === \'string\' && params.User === \'{USER.FULLNAME}\') {\r\n        params.User = \'\';\r\n    }\r\n\r\nif (typeof params.Event_Update_Action === \'string\' && params.Event_Update_Action === \'{EVENT.UPDATE.ACTION}\') {\r\n        params.Event_Update_Action = \'\';\r\n    }\r\n\r\n// Assemble X-S4-ExternalID for two-way integration\r\n// Format: "ZabbixEventID: 222 ZabbixURL: https://your-zabbix-server/zabbix/"\r\nparams[\'X-S4-ExternalID\'] = \'ZabbixEventID: \' + params.Event_ID;\r\nif (typeof params.Zabbix_URL === \'string\' && params.Zabbix_URL.indexOf(\'http\') == 0) {\r\n// Make sure the URL ends with \'/\'\r\nif (params.Zabbix_URL.charAt(params.Zabbix_URL.length - 1) != \'/\') {\r\nparams.Zabbix_URL = params.Zabbix_URL + \'/\';\r\n}\r\n\r\nparams[\'X-S4-ExternalID\'] = params[\'X-S4-ExternalID\'] + \' ZabbixURL: \' +  params.Zabbix_URL;\r\n\r\n// Add Link parameter\r\nparams[\'Link\'] = params.Zabbix_URL + "tr_events.php?triggerid="+params.Trigger_ID + "&eventid=" + params.Event_ID;\r\n}\r\n\r\n// Check if this is a new problem or a recovery\r\nif (params.Trigger_Status == \'OK\') {\r\nparams[\'X-S4-Status\'] = \'resolved\';\r\n}\r\nelse {\r\nparams[\'X-S4-Status\'] = \'new\';\r\n}\r\n\r\n    payload = JSON.stringify(params);\r\n    Zabbix.log(4, \'[ SIGNL4 Webhook ] Sending request: \' + payload);\r\n\r\n    request.addHeader(\'Content-Type: application/json\');\r\n    response = request.post(endpoint, \'payload=\' + payload);\r\n\r\n    Zabbix.log(4, \'[ SIGNL4 Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response\r\n    );\r\n\r\n    if (request.getStatus() !== 201) {\r\n        throw \'Request failed with status code \' + request.getStatus() +\r\n                \'. Check debug log for more information.\';\r\n    }\r\n\r\n    return \'OK\';\r\n}\r\ncatch (error) {\r\n    Zabbix.log(4, \'[ SIGNL4 Webhook ] ERROR: \' + error);\r\n\r\n    throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','SIGNL4 is a mobile alert notification app for powerful alerting, alert management and mobile assignment of work items. It offers alerting via app push, SMS and voice calls including escalations, tracking, and duty scheduling.\r\n\r\nGet the app at https://www.signl4.com.\r\n\r\nFind out more including an integration video here: https://www.signl4.com/blog/portfolio_item/zabbix-mobile-alert-notification-duty-schedule-escalation/');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('12','4','Jira','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Jira = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Jira.params = params;\r\n        if (typeof Jira.params.url === \'string\') {\r\n            if (!Jira.params.url.endsWith(\'/\')) {\r\n                Jira.params.url += \'/\';\r\n            }\r\n\r\n            Jira.params.url += \'rest/api/latest/\';\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        Jira.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    setTags: function(event_tags_json) {\r\n        if (typeof event_tags_json !== \'undefined\' && event_tags_json !== \'\'\r\n            && event_tags_json !== \'{EVENT.TAGSJSON}\') {\r\n            try {\r\n                var tags = JSON.parse(event_tags_json),\r\n                    label;\r\n\r\n                Jira.labels = [];\r\n\r\n                tags.forEach(function (tag) {\r\n                    if (typeof tag.tag !== \'undefined\' && typeof tag.value !== \'undefined\'\r\n                        && !tag.tag.startsWith(\'__zbx\')) {\r\n                        label = (tag.tag + (tag.value ? (\':\' + tag.value) : \'\')).replace(/\\s/g, \'_\');\r\n                        if (label.length < 256) {\r\n                            Jira.labels.push(label);\r\n                        }\r\n                    }\r\n                });\r\n            }\r\n            catch (error) {\r\n                // Code is not missing here.\r\n            }\r\n        }\r\n    },\r\n\r\n    escapeMarkup: function (str) {\r\n        var length = str.length,\r\n            result = \'\',\r\n            markup = [\'{\', \'|\', \'}\', \'~\', \'_\', \'\\\\\', \'[\', \']\', \'^\', \'<\', \'>\', \'?\', \'!\', \'#\', \'+\', \'*\', \'&\'];\r\n\r\n        for (var i = 0; i < length; i++) {\r\n            var char = str[i];\r\n\r\n            result += (markup.indexOf(char) !== -1) ? (\'&#\' + str[i].charCodeAt() + \';\') : char;\r\n        }\r\n\r\n        return result;\r\n    },\r\n\r\n    addCustomFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            var schema = Jira.getSchema(),\r\n                path = [\'projects\', 0, \'issuetypes\', 0, \'fields\'],\r\n                field;\r\n\r\n            while ((field = path.shift()) !== undefined) {\r\n                schema = schema[field];\r\n                if (typeof schema === \'undefined\') {\r\n                    schema = null;\r\n                    break;\r\n                }\r\n            }\r\n\r\n            if (schema) {\r\n                Object.keys(fields)\r\n                    .forEach(function(field) {\r\n                        if (typeof schema[field] === \'object\' && typeof schema[field].schema === \'object\') {\r\n                            switch (schema[field].schema.type) {\r\n                                case \'number\':\r\n                                    data.fields[field] = parseInt(fields[field]);\r\n                                    break;\r\n\r\n                                case \'datetime\':\r\n                                    if (fields[field].match(/\\d+[.-]\\d+[.-]\\d+T\\d+:\\d+:\\d+/) !== null) {\r\n                                        data.fields[field] = fields[field].replace(/\\./g, \'-\');\r\n                                    }\r\n                                    break;\r\n\r\n                                case \'option\':\r\n                                    data.fields[field] = {value: fields[field]};\r\n                                    break;\r\n\r\n                                case \'array\':\r\n                                    if (schema[field].schema.items === \'option\') {\r\n                                        data.fields[field] = [{value: fields[field]}];\r\n                                    }\r\n                                    else {\r\n                                        data.fields[field] = [fields[field]];\r\n                                    }\r\n                                    break;\r\n\r\n                                default:\r\n                                    data.fields[field] = fields[field];\r\n                            }\r\n                        }\r\n                    });\r\n            }\r\n            else {\r\n                Zabbix.log(4, \'[ Jira Webhook ] Failed to retrieve field schema.\');\r\n            }\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'user\', \'password\', \'project_key\', \'issue_type\'].forEach(function (field) {\r\n            if (typeof Jira.params !== \'object\' || typeof Jira.params[field] === \'undefined\'\r\n                || Jira.params[field] === \'\' ) {\r\n                throw \'Required Jira param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Jira.params.url + query,\r\n            request = new HttpRequest();\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'Authorization: Basic \' + btoa(Jira.params.user + \':\' + Jira.params.password));\r\n\r\n        if (typeof Jira.HTTPProxy !== \'undefined\' && Jira.HTTPProxy !== \'\') {\r\n            request.setProxy(Jira.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ Jira Webhook ] Sending request: \' + url + ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ Jira Webhook ] Received response with status code \' + request.getStatus() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ Jira Webhook ] Failed to parse response received from Jira\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null && typeof response.errors !== \'undefined\'\r\n                && Object.keys(response.errors).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errors);\r\n            }\r\n            else if (response !== null && typeof response.errorMessages !== \'undefined\'\r\n                && Object.keys(response.errorMessages).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errorMessages);\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.getStatus(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    getSchema: function() {\r\n        var result = Jira.request(\'get\', \'issue/createmeta?expand=projects.issuetypes.fields&projectKeys=\' +\r\n            encodeURIComponent(Jira.params.project_key) + \'&issuetypeNames=\' +\r\n            encodeURIComponent(Jira.params.issue_type));\r\n\r\n        return result.response;\r\n    },\r\n\r\n    createIssue: function(summary, description, fields) {\r\n        var data = {\r\n            fields: {\r\n                project: {\r\n                    key: Jira.params.project_key\r\n                },\r\n                issuetype: {\r\n                    name: Jira.params.issue_type\r\n                },\r\n                summary: summary,\r\n                description: description\r\n            }\r\n        };\r\n\r\n        if (Jira.labels && Jira.labels.length > 0) {\r\n            data.fields.labels = Jira.labels;\r\n        }\r\n        var result = Jira.request(\'post\', \'issue\', Jira.addCustomFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\' || typeof result.response.key === \'undefined\') {\r\n            throw \'Cannot create Jira issue. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.key;\r\n    },\r\n\r\n    updateIssue: function(summary, fields, update) {\r\n        var data = {fields: {}};\r\n\r\n        if (summary) {\r\n            data.fields.summary = summary;\r\n        }\r\n\r\n        Jira.request(\'put\', \'issue/\' + encodeURIComponent(Jira.params.issue_key), Jira.addCustomFields(data, fields));\r\n        Jira.commentIssue(update);\r\n    },\r\n\r\n    commentIssue: function(update) {\r\n        var data = {};\r\n\r\n        if (typeof update === \'string\') {\r\n            data.body = update;\r\n            Jira.request(\'post\', \'issue/\' + encodeURIComponent(Jira.params.issue_key) + \'/comment\', data);\r\n        }\r\n        else if (update.status === \'1\') {\r\n            data.body = update.user + \' \' + update.action + \'.\';\r\n\r\n            if (update.message) {\r\n                data.body += \'\\nMessage: {quote}\' + Jira.escapeMarkup(update.message) + \'{quote}\';\r\n            }\r\n\r\n            Jira.request(\'post\', \'issue/\' + encodeURIComponent(Jira.params.issue_key) + \'/comment\', data);\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        jira = {},\r\n        update = {},\r\n        result = {tags: {}},\r\n        required_params = [\'alert_subject\', \'summary\', \'event_recovery_value\', \'event_source\', \'event_value\'];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'jira_\')) {\r\n                jira[key.substring(5)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'customfield_\')) {\r\n                fields[key] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    Jira.setParams(jira);\r\n    Jira.setProxy(params.HTTPProxy);\r\n    Jira.setTags(params.event_tags_json);\r\n\r\n    // Create issue for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_recovery_value !== \'0\') {\r\n        Jira.createIssue(params.alert_subject, params.alert_message);\r\n    }\r\n    // Create issue for trigger-based events.\r\n    else if (params.event_value === \'1\' && update.status === \'0\' && !jira.issue_key.startsWith(jira.project_key)) {\r\n        var key = Jira.createIssue(params.alert_subject,\r\n            (Object.keys(fields).length ? params.trigger_description : params.alert_message), fields);\r\n\r\n\r\n        result.tags.__zbx_jira_issuekey = key;\r\n        result.tags.__zbx_jira_issuelink = params.jira_url +\r\n            (params.jira_url.endsWith(\'/\') ? \'\' : \'/\') + \'browse/\' + key;\r\n    }\r\n    // Update created issue for trigger-based event.\r\n    else {\r\n        if (!jira.issue_key.startsWith(jira.project_key)) {\r\n            throw \'Incorrect Issue key given: \' + jira.issue_key;\r\n        }\r\n        Jira.updateIssue(params.alert_subject, fields,\r\n            ((params.event_value === \'0\' && !Object.keys(fields).length)\r\n                ? params.alert_message : update));\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ Jira Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_jira_issuelink}','Jira: {EVENT.TAGS.__zbx_jira_issuekey}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('13','4','Jira with CustomFields','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Jira = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Jira.params = params;\r\n        if (typeof Jira.params.url === \'string\') {\r\n            if (!Jira.params.url.endsWith(\'/\')) {\r\n                Jira.params.url += \'/\';\r\n            }\r\n\r\n            Jira.params.url += \'rest/api/latest/\';\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        Jira.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    setTags: function(event_tags_json) {\r\n        if (typeof event_tags_json !== \'undefined\' && event_tags_json !== \'\'\r\n            && event_tags_json !== \'{EVENT.TAGSJSON}\') {\r\n            try {\r\n                var tags = JSON.parse(event_tags_json),\r\n                    label;\r\n\r\n                Jira.labels = [];\r\n\r\n                tags.forEach(function (tag) {\r\n                    if (typeof tag.tag !== \'undefined\' && typeof tag.value !== \'undefined\' ) {\r\n                        label = (tag.tag + (tag.value ? (\':\' + tag.value) : \'\')).replace(/\\s/g, \'_\');\r\n                        if (label.length < 256) {\r\n                            Jira.labels.push(label);\r\n                        }\r\n                    }\r\n                });\r\n            }\r\n            catch (error) {\r\n                // Code is not missing here.\r\n            }\r\n        }\r\n    },\r\n\r\n    escapeMarkup: function (str) {\r\n        var length = str.length,\r\n            result = \'\',\r\n            markup = [\'{\', \'|\', \'}\', \'~\', \'_\', \'\\\\\', \'[\', \']\', \'^\', \'<\', \'>\', \'?\', \'!\', \'#\', \'+\', \'*\', \'&\'];\r\n\r\n        for (var i = 0; i < length; i++) {\r\n            var char = str[i];\r\n\r\n            result += (markup.indexOf(char) !== -1) ? (\'&#\' + str[i].charCodeAt() + \';\') : char;\r\n        }\r\n\r\n        return result;\r\n    },\r\n\r\n    addCustomFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            var schema = Jira.getSchema(),\r\n                path = [\'projects\', 0, \'issuetypes\', 0, \'fields\'],\r\n                field;\r\n\r\n            while ((field = path.shift()) !== undefined) {\r\n                schema = schema[field];\r\n                if (typeof schema === \'undefined\') {\r\n                    schema = null;\r\n                    break;\r\n                }\r\n            }\r\n\r\n            if (schema) {\r\n                Object.keys(fields)\r\n                    .forEach(function(field) {\r\n                        data.fields[field] = fields[field];\r\n\r\n                        if (typeof schema[field] === \'object\' && typeof schema[field].schema === \'object\'\r\n                            && (schema[field].schema.type === \'number\' || schema[field].schema.type === \'datetime\')) {\r\n                            switch (schema[field].schema.type) {\r\n                                case \'number\':\r\n                                    data.fields[field] = parseInt(fields[field]);\r\n                                    break;\r\n\r\n                                case \'datetime\':\r\n                                    if (fields[field].match(/\\d+[.-]\\d+[.-]\\d+T\\d+:\\d+:\\d+/) !== null) {\r\n                                        data.fields[field] = fields[field].replace(/\\./g, \'-\');\r\n                                    }\r\n                                    else {\r\n                                        delete data.fields[field];\r\n                                    }\r\n                                    break;\r\n                            }\r\n                        }\r\n                    });\r\n            }\r\n            else {\r\n                Zabbix.Log(4, \'[ Jira Webhook ] Failed to retrieve field schema.\');\r\n            }\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'user\', \'password\', \'project_key\', \'issue_type\'].forEach(function (field) {\r\n            if (typeof Jira.params !== \'object\' || typeof Jira.params[field] === \'undefined\'\r\n                || Jira.params[field] === \'\' ) {\r\n                throw \'Required Jira param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Jira.params.url + query,\r\n            request = new CurlHttpRequest();\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        request.AddHeader(\'Authorization: Basic \' + btoa(Jira.params.user + \':\' + Jira.params.password));\r\n\r\n        if (typeof Jira.HTTPProxy !== \'undefined\' && Jira.HTTPProxy !== \'\') {\r\n            request.SetProxy(Jira.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ Jira Webhook ] Sending request: \' + url + ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ Jira Webhook ] Received response with status code \' + request.Status() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ Jira Webhook ] Failed to parse response received from Jira\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (response !== null && typeof response.errors !== \'undefined\'\r\n                && Object.keys(response.errors).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errors);\r\n            }\r\n            else if (response !== null && typeof response.errorMessages !== \'undefined\'\r\n                && Object.keys(response.errorMessages).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errorMessages);\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.Status(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    getSchema: function() {\r\n        var result = Jira.request(\'get\', \'issue/createmeta?expand=projects.issuetypes.fields&projectKeys=\' +\r\n                Jira.params.project_key + \'&issuetypeNames=\' + Jira.params.issue_type);\r\n\r\n        return result.response;\r\n    },\r\n\r\n    createIssue: function(summary, description, fields) {\r\n        var data = {\r\n            fields: {\r\n                project: {\r\n                    key: Jira.params.project_key\r\n                },\r\n                issuetype: {\r\n                    name: Jira.params.issue_type\r\n                },\r\n                summary: summary,\r\n                description: description\r\n            }\r\n        };\r\n\r\n        if (Jira.labels && Jira.labels.length > 0) {\r\n            data.fields.labels = Jira.labels;\r\n        }\r\n        var result = Jira.request(\'post\', \'issue\', Jira.addCustomFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\' || typeof result.response.key === \'undefined\') {\r\n            throw \'Cannot create Jira issue. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.key;\r\n    },\r\n\r\n    updateIssue: function(summary, fields, update) {\r\n        var data = {fields: {}};\r\n\r\n        if (summary) {\r\n            data.fields.summary = summary;\r\n        }\r\n\r\n        Jira.request(\'put\', \'issue/\' + Jira.params.issue_key, Jira.addCustomFields(data, fields));\r\n        Jira.commentIssue(update);\r\n    },\r\n\r\n    commentIssue: function(update) {\r\n        var data = {};\r\n\r\n        if (typeof update === \'string\') {\r\n            data.body = update;\r\n            Jira.request(\'post\', \'issue/\' + Jira.params.issue_key + \'/comment\', data);\r\n        }\r\n        else if (update.status === \'1\') {\r\n            data.body = update.user + \' \' + update.action + \'.\';\r\n\r\n            if (update.message) {\r\n                data.body += \'\\nMessage: {quote}\' + Jira.escapeMarkup(update.message) + \'{quote}\';\r\n            }\r\n\r\n            Jira.request(\'post\', \'issue/\' + Jira.params.issue_key + \'/comment\', data);\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        jira = {},\r\n        update = {},\r\n        result = {tags: {}},\r\n        required_params = [\'alert_subject\', \'summary\', \'event_recovery_value\', \'event_source\', \'event_value\'];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'jira_\')) {\r\n                jira[key.substring(5)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'customfield_\')) {\r\n                fields[key] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    Jira.setParams(jira);\r\n    Jira.setProxy(params.HTTPProxy);\r\n    Jira.setTags(params.event_tags_json);\r\n\r\n    // Create issue for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_recovery_value !== \'0\') {\r\n        Jira.createIssue(params.alert_subject, params.alert_message);\r\n    }\r\n    // Create issue for trigger-based events.\r\n    else if (params.event_value === \'1\' && update.status === \'0\' && !jira.issue_key.startsWith(jira.project_key)) {\r\n        var key = Jira.createIssue(params.alert_subject,\r\n            (Object.keys(fields).length ? params.trigger_description : params.alert_message), fields);\r\n\r\n\r\n        result.tags.__zbx_jira_issuekey = key;\r\n        result.tags.__zbx_jira_issuelink = params.jira_url +\r\n            (params.jira_url.endsWith(\'/\') ? \'\' : \'/\') + \'browse/\' + key;\r\n    }\r\n    // Update created issue for trigger-based event.\r\n    else {\r\n        if (!jira.issue_key.startsWith(jira.project_key)) {\r\n            throw \'Incorrect Issue key given: \' + jira.issue_key;\r\n        }\r\n        Jira.updateIssue(params.alert_subject, fields,\r\n            ((params.event_value === \'0\' && !Object.keys(fields).length)\r\n                ? params.alert_message : update));\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ Jira Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_jira_issuelink}','Jira: {EVENT.TAGS.__zbx_jira_issuekey}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('14','4','MS Teams','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var SEVERITY_COLORS = [\r\n    \'#97AAB3\', // Not classified.\r\n    \'#7499FF\', // Information.\r\n    \'#FFC859\', // Warning.\r\n    \'#FFA059\', // Average.\r\n    \'#E97659\', // High.\r\n    \'#E45959\', // Disaster.\r\n    \'#009900\', // Resolved.\r\n    \'#000000\'  // Default.\r\n];\r\n\r\ntry {\r\n    var params = JSON.parse(value);\r\n\r\n    if (typeof params.teams_endpoint !== \'string\' || params.teams_endpoint.trim() === \'\') {\r\n        throw \'Cannot get teams_endpoint\';\r\n    }\r\n    else if (!params.teams_endpoint.startsWith(\'http\')) {\r\n        throw \'Invalid MS Teams webhook URL: \' + params.teams_endpoint;\r\n    }\r\n\r\n    params.zabbix_url = (params.zabbix_url.endsWith(\'/\'))\r\n        ? params.zabbix_url.slice(0, -1) : params.zabbix_url;\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Set "use_default_message" to true for non trigger-based events.\r\n    if (params.event_source !== \'0\') {\r\n        params.use_default_message = \'true\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n            && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: "\' + params.event_value + \'".\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: "\' + params.event_update_status + \'".\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_value == 0) {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    if (!SEVERITY_COLORS[params.event_nseverity]) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    var request = new HttpRequest(),\r\n        facts = [],\r\n        body = {\r\n            themeColor: SEVERITY_COLORS[params.event_nseverity].replace(\'#\', \'\'),\r\n            summary: \'Zabbix\',\r\n            sections: [\r\n                {\r\n                    markdown: \'false\',\r\n                    activityTitle: params.alert_subject,\r\n                    activitySubtitle: \'On \' + params.host_name + \' [\' + params.host_ip + \']\',\r\n                    text: (params.use_default_message.toLowerCase() == \'true\')\r\n                        ? params.alert_message\r\n                        : params.trigger_description\r\n                }\r\n            ],\r\n            potentialAction: [\r\n                {\r\n                    \'@type\': \'OpenUri\',\r\n                    name: (params.event_source === \'0\')\r\n                        ? \'Event Info\'\r\n                        : \'Zabbix Home\',\r\n                    targets: [\r\n                        {\r\n                            os: \'default\',\r\n                            uri: (params.event_source === \'0\')\r\n                                ? params.zabbix_url + \'/tr_events.php?triggerid=\' +\r\n                                    params.trigger_id + \'&eventid=\' + params.event_id\r\n                                : params.zabbix_url\r\n                        }\r\n                    ]\r\n                }\r\n            ]\r\n        };\r\n\r\n    if (params.use_default_message.toLowerCase() !== \'true\') {\r\n        // Problem message.\r\n        if (params.event_value === \'1\' && params.event_update_status === \'0\') {\r\n            facts.push({\r\n                name: \'Event time\',\r\n                value: params.event_time + \' \' + params.event_date\r\n            });\r\n        }\r\n        // Update message.\r\n        else if (params.event_update_status === \'1\') {\r\n            body.sections[0].text = params.event_update_user + \' \' + params.event_update_action + \'.\';\r\n\r\n            if (params.event_update_message) {\r\n                body.sections[0].text += \'<br>Message:<br>\' + params.event_update_message;\r\n            }\r\n\r\n            facts.push({\r\n                name: \'Event update time\',\r\n                value: params.event_update_time + \' \' + params.event_update_date\r\n            });\r\n        }\r\n        // Resolved message.\r\n        else {\r\n            facts.push({\r\n                name: \'Recovery time\',\r\n                value: params.event_recovery_time + \' \' + params.event_recovery_date\r\n            });\r\n        }\r\n\r\n        if (params.event_severity && params.event_severity !== \'{EVENT.SEVERITY}\') {\r\n            facts.push({\r\n                name: \'Severity\',\r\n                value: params.event_severity\r\n            });\r\n        }\r\n\r\n\r\n        if (params.event_opdata && params.event_opdata !== \'{EVENT.OPDATA}\') {\r\n            facts.push({\r\n                name: \'Operational data\',\r\n                value: params.event_opdata\r\n            });\r\n        }\r\n\r\n        if (params.event_tags && params.event_tags !== \'{EVENT.TAGS}\') {\r\n            facts.push({\r\n                name: \'Event tags\',\r\n                value: params.event_tags\r\n            });\r\n        }\r\n\r\n        Object.keys(params)\r\n            .forEach(function (key) {\r\n                if (key.startsWith(\'fact_\') && params[key] !== \'\') {\r\n                    facts.push({\r\n                        name: key.substring(5),\r\n                        value: params[key]\r\n                    });\r\n                }\r\n                else if (key.startsWith(\'openUri_\') && params[key] !== \'\' && !params[key].startsWith(\'{\')) {\r\n                    body.potentialAction.push({\r\n                        \'@type\': \'OpenUri\',\r\n                        name: key.substring(8),\r\n                        targets: [\r\n                            {\r\n                                os: \'default\',\r\n                                uri: params[key]\r\n                            }\r\n                        ]\r\n                    });\r\n                }\r\n            });\r\n        body.sections[0].facts = facts;\r\n    }\r\n\r\n    body.sections[0].text = body.sections[0].text.replace(/(?:\\r\\n|\\r|\\n)/g, \'<br>\');\r\n\r\n    request.addHeader(\'Content-Type: application/json\');\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy !== \'\') {\r\n        request.setProxy(params.HTTPProxy);\r\n    }\r\n\r\n    Zabbix.log(4, \'[ MS Teams Webhook ] JSON: \' + JSON.stringify(body));\r\n\r\n    var response = request.post(params.teams_endpoint, JSON.stringify(body));\r\n\r\n    Zabbix.log(4, \'[ MS Teams Webhook ] Response: \' + response);\r\n\r\n    if (response === \'1\') {\r\n        return \'OK\';\r\n    }\r\n    else {\r\n        Zabbix.log(4, \'[ MS Teams Webhook ] FAILED with response: \' + response);\r\n        throw response;\r\n    }\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ MS Teams Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('15','4','Redmine','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Redmine = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Redmine.params = params;\r\n        if (typeof Redmine.params.url === \'string\') {\r\n            if (!Redmine.params.url.endsWith(\'/\')) {\r\n                Redmine.params.url += \'/\';\r\n            }\r\n        }\r\n    },\r\n\r\n    addCustomFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            var schema = Redmine.getSchema();\r\n\r\n            if (schema) {\r\n                data.issue.custom_fields = [];\r\n\r\n                Object.keys(fields)\r\n                    .forEach(function(field) {\r\n                        for (var idx in schema.custom_fields) {\r\n                            if (schema.custom_fields[idx].id != field) {\r\n                                continue;\r\n                            }\r\n\r\n                            var field_value;\r\n\r\n                            switch (schema.custom_fields[idx].field_format) {\r\n                                case \'string\':\r\n                                    field_value = fields[field];\r\n                                    break;\r\n\r\n                                case \'int\':\r\n                                    field_value = parseInt(fields[field]);\r\n                                    break;\r\n\r\n                                case \'float\':\r\n                                    field_value = parseFloat(fields[field]);\r\n                                    break;\r\n\r\n                                case \'date\':\r\n                                    if (fields[field].match(/^\\d{4}[.-]\\d{2}[.-]\\d{2}$/)) {\r\n                                        field_value = fields[field].replace(/\\./g, \'-\');\r\n                                    }\r\n                                    break;\r\n                            }\r\n\r\n                            if (field_value !== undefined) {\r\n                                data.issue.custom_fields.push({id: field, value: field_value});\r\n                            }\r\n                        }\r\n                    });\r\n            }\r\n            else {\r\n                Zabbix.log(4, \'[ Redmine Webhook ] Failed to retrieve field schema.\');\r\n            }\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'access_key\'].forEach(function (field) {\r\n            if (typeof Redmine.params !== \'object\' || typeof Redmine.params[field] === \'undefined\'\r\n                || Redmine.params[field] === \'\' ) {\r\n                throw \'Required param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Redmine.params.url + query,\r\n            request = new HttpRequest();\r\n\r\n        if (typeof Redmine.HTTPProxy === \'string\' && Redmine.HTTPProxy.trim() !== \'\') {\r\n            request.setProxy(Redmine.HTTPProxy);\r\n        }\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'X-Redmine-API-Key: \' + Redmine.params.access_key);\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ Redmine Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\' \' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ Redmine Webhook ] Received response with status code \' + request.getStatus() + \': \' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ Redmine Webhook ] Failed to parse response received from Redmine\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null && typeof response.errors !== \'undefined\'\r\n                && Object.keys(response.errors).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errors);\r\n            }\r\n            else if (response !== null && typeof response.errorMessages !== \'undefined\'\r\n                && Object.keys(response.errorMessages).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errorMessages);\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.getStatus(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    getProjectID: function(name) {\r\n        var result = Redmine.request(\'get\', \'projects.json\'),\r\n            project_id;\r\n\r\n        if (result.response) {\r\n            var projects = result.response.projects || [];\r\n\r\n            for (var i in projects) {\r\n                if (projects[i].name === name) {\r\n                    project_id = projects[i].id;\r\n                    break;\r\n                }\r\n            }\r\n        }\r\n        else {\r\n            Zabbix.log(4, \'[ Redmine Webhook ] Failed to retrieve project data.\');\r\n        }\r\n\r\n        if (typeof project_id === \'undefined\') {\r\n            throw \'Cannot find project with name: \' + name;\r\n        }\r\n\r\n        return project_id;\r\n    },\r\n\r\n    getSchema: function() {\r\n        var result = Redmine.request(\'get\', \'custom_fields.json\');\r\n\r\n        return result.response;\r\n    },\r\n\r\n    createIssue: function(subject, description, priority, fields) {\r\n        var project_id = /^\\d+$/.test(Redmine.params.project)\r\n                ? Redmine.params.project\r\n                : Redmine.getProjectID(Redmine.params.project),\r\n            data = {\r\n                issue: {\r\n                    project_id: project_id,\r\n                    tracker_id: Redmine.params.tracker_id,\r\n                    subject: subject,\r\n                    description: description\r\n                }\r\n            },\r\n            result;\r\n\r\n        if (priority) {\r\n            data.issue.priority_id = priority;\r\n        }\r\n\r\n        result = Redmine.request(\'post\', \'issues.json\', Redmine.addCustomFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\'\r\n            || typeof result.response.issue.id === \'undefined\'\r\n            || result.status != 201) {\r\n            throw \'Cannot create Redmine issue. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.issue.id;\r\n    },\r\n\r\n    updateIssue: function(note, fields) {\r\n        var data = {\r\n            issue: {\r\n                notes: note || \'\'\r\n            }\r\n        };\r\n\r\n        Redmine.request(\'put\', \'issues/\' + Redmine.params.issue_key + \'.json\', Redmine.addCustomFields(data, fields));\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        params_redmine = {},\r\n        params_fields = {},\r\n        params_update = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\', \'tracker_id\', \'project\',\r\n            \'event_source\', \'event_value\',  \'event_update_status\'\r\n        ],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: null, color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'redmine_\')) {\r\n                params_redmine[key.substring(8)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'customfield_\')) {\r\n                params_fields[key.substring(12)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                params_update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    if (params.event_source === \'0\'\r\n        && ((params.event_value === \'1\' && params.event_update_status === \'1\')\r\n            || (params.event_value === \'0\'\r\n                && (params.event_update_status === \'0\' || params.event_update_status === \'1\')))\r\n        && (isNaN(parseInt(params.redmine_issue_key)) || parseInt(params.redmine_issue_key) < 1 )) {\r\n        throw \'Incorrect "redmine_issue_key" parameter given: \' + params.redmine_issue_key +\r\n            \'\\nMust be positive integer.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity].name];\r\n    priority = priority && priority.trim() || severities[7].name;\r\n\r\n    Redmine.setParams(params_redmine);\r\n    Redmine.HTTPProxy = params.HTTPProxy;\r\n\r\n    // Create issue for non trigger-based events.\r\n    if (params.event_source !== \'0\'\r\n        && params.event_value !== \'0\') {\r\n        Redmine.createIssue(params.alert_subject, params.alert_message, priority);\r\n    }\r\n    // Create issue for trigger-based events.\r\n    else if (params.event_value === \'1\' && params_update.status === \'0\') {\r\n        var issue_id = Redmine.createIssue(params.alert_subject,\r\n            params.alert_subject + \'\\n\' + params.alert_message + \'\\n\' +\r\n            params.zabbix_url + (params.zabbix_url.endsWith(\'/\') ? \'\' : \'/\') +\r\n            \'tr_events.php?triggerid=\' + params.trigger_id + \'&eventid=\' + params.event_id + \'\\n\',\r\n            priority,\r\n            params_fields);\r\n\r\n        result.tags.__zbx_redmine_issue_id = issue_id;\r\n        result.tags.__zbx_redmine_issuelink = params.redmine_url +\r\n            (params.redmine_url.endsWith(\'/\') ? \'\' : \'/\') + \'issues/\' + issue_id;\r\n    }\r\n    // Update created issue for trigger-based event.\r\n    else {\r\n        Redmine.updateIssue(params.alert_subject + \'\\n\' + params.alert_message, params_fields);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ Redmine Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_redmine_issuelink}','Redmine: issue #{EVENT.TAGS.__zbx_redmine_issue_id}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('16','4','Telegram','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Telegram = {\r\n    token: null,\r\n    to: null,\r\n    message: null,\r\n    proxy: null,\r\n    parse_mode: null,\r\n\r\n    escapeMarkup: function (str, mode) {\r\n        switch (mode) {\r\n            case \'markdown\':\r\n                return str.replace(/([_*\\[`])/g, \'\\\\$&\');\r\n\r\n            case \'markdownv2\':\r\n                return str.replace(/([_*\\[\\]()~`>#+\\-=|{}.!])/g, \'\\\\$&\');\r\n\r\n            default:\r\n                return str;\r\n        }\r\n    },\r\n\r\n    sendMessage: function () {\r\n        var params = {\r\n            chat_id: Telegram.to,\r\n            text: Telegram.message,\r\n            disable_web_page_preview: true,\r\n            disable_notification: false\r\n        },\r\n        data,\r\n        response,\r\n        request = new HttpRequest(),\r\n        url = \'https://api.telegram.org/bot\' + Telegram.token + \'/sendMessage\';\r\n\r\n        if (Telegram.parse_mode !== null) {\r\n            params[\'parse_mode\'] = Telegram.parse_mode;\r\n        }\r\n\r\n        if (Telegram.proxy) {\r\n            request.setProxy(Telegram.proxy);\r\n        }\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        data = JSON.stringify(params);\r\n\r\n        // Remove replace() function if you want to see the exposed token in the log file.\r\n        Zabbix.log(4, \'[Telegram Webhook] URL: \' + url.replace(Telegram.token, \'<TOKEN>\'));\r\n        Zabbix.log(4, \'[Telegram Webhook] params: \' + data);\r\n        response = request.post(url, data);\r\n        Zabbix.log(4, \'[Telegram Webhook] HTTP code: \' + request.getStatus());\r\n\r\n        try {\r\n            response = JSON.parse(response);\r\n        }\r\n        catch (error) {\r\n            response = null;\r\n        }\r\n\r\n        if (request.getStatus() !== 200 || typeof response.ok !== \'boolean\' || response.ok !== true) {\r\n            if (typeof response.description === \'string\') {\r\n                throw response.description;\r\n            }\r\n            else {\r\n                throw \'Unknown error. Check debug log for more information.\';\r\n            }\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value);\r\n\r\n    if (typeof params.Token === \'undefined\') {\r\n        throw \'Incorrect value is given for parameter "Token": parameter is missing\';\r\n    }\r\n\r\n    Telegram.token = params.Token;\r\n\r\n    if (params.HTTPProxy) {\r\n        Telegram.proxy = params.HTTPProxy;\r\n    } \r\n\r\n    params.ParseMode = params.ParseMode.toLowerCase();\r\n\r\n    if ([\'markdown\', \'html\', \'markdownv2\'].indexOf(params.ParseMode) !== -1) {\r\n        Telegram.parse_mode = params.ParseMode;\r\n    }\r\n\r\n    Telegram.to = params.To;\r\n    Telegram.message = params.Subject + \'\\n\' + params.Message;\r\n\r\n    if ([\'markdown\', \'markdownv2\'].indexOf(params.ParseMode) !== -1) {\r\n        Telegram.message = Telegram.escapeMarkup(Telegram.message, params.ParseMode);\r\n    }\r\n\r\n    Telegram.sendMessage();\r\n\r\n    return \'OK\';\r\n}\r\ncatch (error) {\r\n    Zabbix.log(4, \'[Telegram Webhook] notification failed: \' + error);\r\n    throw \'Sending failed: \' + error + \'.\';\r\n}','10s','0','0','','','https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/telegram\r\n\r\n1. Register bot: send "/newbot" to @BotFather and follow instructions\r\n2. Copy and paste the obtained token into the "Token" field above\r\n3. If you want to send personal notifications, you need to get chat id of the user you want to send messages to:\r\n    3.1. Send "/getid" to "@myidbot" in Telegram messenger\r\n    3.2. Copy returned chat id and save it in the "Telegram Webhook" media for the user\r\n    3.3. Ask the user to send "/start" to your bot (Telegram bot won\'t send anything to the user without it)\r\n4. If you want to send group notifications, you need to get group id of the group you want to send messages to:\r\n    4.1. Add "@myidbot" to your group\r\n    4.2. Send "/getgroupid@myidbot" in your group\r\n    4.3. Copy returned group id save it in the "Telegram Webhook" media for the user you created for  group notifications\r\n    4.4. Send "/start@your_bot_name_here" in your group (Telegram bot won\'t send anything to the group without it)');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('17','4','Zendesk','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Zendesk = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Zendesk.params = params;\r\n        if (typeof Zendesk.params.url === \'string\') {\r\n            if (!Zendesk.params.url.endsWith(\'/\')) {\r\n                Zendesk.params.url += \'/\';\r\n            }\r\n            Zendesk.params.url += \'api/v2/\';\r\n        }\r\n    },\r\n\r\n    addCustomFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            var schema = Zendesk.getSchema(),\r\n                arr = [],\r\n                i,\r\n                n;\r\n\r\n            if (schema) {\r\n                Object.keys(fields)\r\n                    .forEach(function(field) {\r\n                        for (i = 0, n = schema.ticket_fields.length; i < n; i++) {\r\n                            if (schema.ticket_fields[i].id == field\r\n                                && [\'text\', \'integer\', \'date\'].indexOf(schema.ticket_fields[i].type) !== -1){\r\n\r\n                                switch (schema.ticket_fields[i].type) {\r\n                                    case \'integer\':\r\n                                        fields[field] = parseInt(fields[field]);\r\n                                        break;\r\n                                    case \'date\':\r\n                                        if (fields[field].match(/^\\d{4}[.-]\\d{2}[.-]\\d{2}$/) !== null) {\r\n                                            fields[field] = fields[field].replace(/\\./g, \'-\');\r\n                                        }\r\n                                        else {\r\n                                            fields[field] = \'\';\r\n                                        }\r\n                                        break;\r\n                                }\r\n\r\n                                arr.push({id: field, value: fields[field]});\r\n                                break;\r\n                            }\r\n                        }\r\n                    });\r\n\r\n                if (arr.length) {\r\n                    data.ticket[\'custom_fields\'] = arr;\r\n                }\r\n            }\r\n            else {\r\n                Zabbix.log(4, \'[Zendesk Webhook] Failed to retrieve field schema.\');\r\n            }\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'token\', \'type\'].forEach(function (field) {\r\n            if (typeof Zendesk.params !== \'object\' || typeof Zendesk.params[field] === \'undefined\') {\r\n                throw \'Required Zendesk param is not set: \' + field + \'\\n\' + Zendesk.params[field];\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Zendesk.params.url + query,\r\n            request = new HttpRequest();\r\n\r\n        if (typeof Zendesk.HTTPProxy === \'string\' && Zendesk.HTTPProxy.trim() !== \'\') {\r\n            request.setProxy(Zendesk.HTTPProxy);\r\n        }\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'Authorization: Basic \' + btoa(Zendesk.params.token));\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[Zendesk Webhook] Sending request: \' + url + ((typeof data === \'string\') ? (\' \' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[Zendesk Webhook] Received response with status code \' + request.getStatus() + \'. \' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[Zendesk Webhook] Failed to parse response received from Zendesk.\');\r\n            }\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null && typeof response.error !== \'undefined\'\r\n                && Object.keys(response.error).length > 0) {\r\n                message += \': \' + JSON.stringify(response.error);\r\n            }\r\n            else if (response !== null && typeof response.description !== \'undefined\'\r\n                && Object.keys(response.description).length > 0) {\r\n                message += \': \' + JSON.stringify(response.description);\r\n            }\r\n            else {\r\n                message += \'. \' + response;\r\n            }\r\n            throw message + \'. Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.getStatus(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    getSchema: function() {\r\n        var result = Zendesk.request(\'get\', \'ticket_fields.json\');\r\n\r\n        return result.response;\r\n    },\r\n\r\n    createIssue: function(data, fields) {\r\n        var result = Zendesk.request(\'post\', \'tickets.json\', Zendesk.addCustomFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\' || typeof result.response.ticket.id === \'undefined\'\r\n            || result.status != 201) {\r\n            throw \'Cannot create Zendesk issue. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.ticket.id;\r\n    },\r\n\r\n    updateIssue: function(data, fields) {\r\n        Zendesk.request(\'put\', \'tickets/\' + Zendesk.params.issue_key + \'.json\', Zendesk.addCustomFields(data, fields));\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        zendesk = {},\r\n        update = {},\r\n        data = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\',\r\n            \'alert_message\',\r\n            \'event_id\',\r\n            \'event_source\',\r\n            \'event_value\',\r\n            \'event_update_status\'\r\n        ],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'zendesk_\')) {\r\n                zendesk[key.substring(8)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'customfield_\')) {\r\n                fields[key.substring(12)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter \' + key + \' cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    // Possible values: question, incident, problems, task\r\n    if ([\'question\', \'incident\', \'problem\', \'task\'].indexOf(params.zendesk_type) === -1) {\r\n        throw \'Incorrect "zendesk_type" parameter given: \' + params.zendesk_type +\r\n            \'\\nMust be one of question, incident, problem, task.\';\r\n    }\r\n\r\n    // Possible values: 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    // Possible values: 1 for problem, 0 for recovering\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    // Zendesk_issue_key must be a positive integer if an update action is being performed.\r\n    if (params.event_source === \'0\' && ((params.event_value === \'1\' && params.event_update_status === \'1\')\r\n        || (params.event_value === \'0\' && (params.event_update_status === \'0\' || params.event_update_status === \'1\')))\r\n        && (isNaN(parseInt(params.zendesk_issue_key)) || parseInt(params.zendesk_issue_key) < 1 )) {\r\n        throw \'Incorrect "zendesk_issue_key" parameter given: \' + params.zendesk_issue_key +\r\n            \'\\nMust be positive integer.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity].name] || severities[7].name;\r\n\r\n    Zendesk.setParams(zendesk);\r\n    Zendesk.HTTPProxy = params.HTTPProxy;\r\n\r\n    // Create issue for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_value !== \'0\') {\r\n        data = {\r\n            ticket: {\r\n                external_id: params.event_id,\r\n                type: Zendesk.params.type,\r\n                status: \'new\',\r\n                subject: params.alert_subject,\r\n                comment: {\r\n                    body: params.alert_message,\r\n                    public: \'false\'\r\n                },\r\n                priority: priority,\r\n                tags: params.event_tags\r\n            }\r\n        };\r\n\r\n        Zendesk.createIssue(data, fields);\r\n    }\r\n    // Create issue for trigger-based events.\r\n    else if (params.event_value === \'1\' && update.status === \'0\') {\r\n        data = {\r\n            ticket: {\r\n                external_id: params.event_id,\r\n                type: Zendesk.params.type,\r\n                status: \'new\',\r\n                subject: params.alert_subject,\r\n                comment: {\r\n                    body: params.zbxurl + (params.zbxurl.endsWith(\'/\') ? \'\' : \'/\') + \'tr_events.php?triggerid=\' +\r\n                        params.trigger_id + \'&eventid=\' + params.event_id + \'\\n\' + params.alert_message,\r\n                    public: \'false\'\r\n                },\r\n                priority: priority,\r\n                tags: params.event_tags\r\n            }\r\n        };\r\n        var key = Zendesk.createIssue(data, fields);\r\n\r\n        result.tags.__zbx_zdk_issuekey = key;\r\n        result.tags.__zbx_zdk_issuelink = params.zendesk_url +\r\n            (params.zendesk_url.endsWith(\'/\') ? \'\' : \'/\') + \'agent/tickets/\' + key;\r\n    }\r\n    // Update created issue for trigger-based event.\r\n    else {\r\n        data = {\r\n            ticket: {\r\n                type: Zendesk.params.type,\r\n                subject: params.alert_subject,\r\n                comment: {\r\n                    body: params.alert_message,\r\n                    public: \'false\'\r\n                }\r\n            }\r\n        };\r\n\r\n        Zendesk.updateIssue(data, fields);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[Zendesk Webhook] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_zdk_issuelink}','Zendesk: {EVENT.TAGS.__zbx_zdk_issuekey}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('18','4','ServiceNow','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var ServiceNow = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        ServiceNow.params = params;\r\n        if (typeof ServiceNow.params.url === \'string\') {\r\n            if (!ServiceNow.params.url.endsWith(\'/\')) {\r\n                ServiceNow.params.url += \'/\';\r\n            }\r\n\r\n            ServiceNow.params.url += \'api/now/table/incident\';\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        ServiceNow.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    setFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            Object.keys(fields)\r\n                .forEach(function(field) {\r\n                    data[field] = (fields[field].match(/^\\d{4}\\.\\d{2}\\.\\d{2}$/) !== null)\r\n                        ? fields[field].replace(/\\./g, \'-\')\r\n                        : fields[field];\r\n                });\r\n        }\r\n    },\r\n\r\n    request: function (method, data) {\r\n        [\'url\', \'user\', \'password\'].forEach(function (field) {\r\n            if (typeof ServiceNow.params !== \'object\' || typeof ServiceNow.params[field] === \'undefined\'\r\n                || ServiceNow.params[field] === \'\' ) {\r\n                throw \'Required ServiceNow param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = ServiceNow.params.url,\r\n            request = new HttpRequest();\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'Authorization: Basic \' + btoa(ServiceNow.params.user + \':\' + ServiceNow.params.password));\r\n\r\n        if (typeof ServiceNow.HTTPProxy !== \'undefined\' && ServiceNow.HTTPProxy !== \'\') {\r\n            request.setProxy(ServiceNow.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ ServiceNow Webhook ] Sending request: \' + url + ((typeof data === \'string\')\r\n            ? (\'\\n\' + data)\r\n            : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ ServiceNow Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ ServiceNow Webhook ] Failed to parse response received from ServiceNow\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null && typeof response.error.message !== \'undefined\'\r\n                && Object.keys(response.error).length > 0) {\r\n                message += \': \' + JSON.stringify(response.error.message);\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n        else if (typeof response.result !== \'object\' || typeof response.result.sys_id === \'undefined\') {\r\n            throw \'Cannot create ServiceNow incident. Check debug log for more information.\';\r\n        }\r\n\r\n        return response.result;\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        servicenow = {},\r\n        data = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\', \'alert_message\', \'event_source\', \'event_value\',\r\n            \'event_update_status\', \'event_recovery_value\', \'event_nseverity\'\r\n        ],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ],\r\n        method = \'post\',\r\n        process_tags = true;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'servicenow_\')) {\r\n                servicenow[key.substring(11)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'u_\')) {\r\n                fields[key] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    data.short_description = params.alert_subject;\r\n    data.description = params.alert_message;\r\n    data.comments = params.alert_message;\r\n\r\n    if (typeof params[\'urgency_for_\' + severities[params.event_nseverity].name] !== \'undefined\') {\r\n        data.urgency = params[\'urgency_for_\' + severities[params.event_nseverity].name];\r\n    }\r\n\r\n    ServiceNow.setParams(servicenow);\r\n    ServiceNow.setProxy(params.HTTPProxy);\r\n    ServiceNow.setFields(data, fields);\r\n\r\n    if (params.event_source === \'0\' && (params.event_value === \'0\' || params.event_update_status === \'1\')) {\r\n        process_tags = false;\r\n        method = \'put\';\r\n        delete data.description;\r\n        delete data.urgency;\r\n        ServiceNow.params.url += \'/\' + params.servicenow_sys_id;\r\n    }\r\n\r\n    var response = ServiceNow.request(method, data);\r\n\r\n    if (process_tags) {\r\n        result.tags.__zbx_servicenow_sys_id = response.sys_id;\r\n        result.tags.__zbx_servicenow_link = params.servicenow_url +\r\n            (params.servicenow_url.endsWith(\'/\') ? \'\' : \'/\') + \'incident.do?sys_id=\' + response.sys_id;\r\n        result.tags.__zbx_servicenow_number = response.number;\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ ServiceNow Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_servicenow_link}','ServiceNow: {EVENT.TAGS.__zbx_servicenow_number}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('19','4','Zammad','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Zammad = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Zammad.params = params;\r\n        if (typeof Zammad.params.url === \'string\') {\r\n            if (!Zammad.params.url.endsWith(\'/\')) {\r\n                Zammad.params.url += \'/\';\r\n            }\r\n        }\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'access_token\'].forEach(function (field) {\r\n            if (typeof Zammad.params !== \'object\' || typeof Zammad.params[field] === \'undefined\'\r\n                || Zammad.params[field] === \'\' ) {\r\n                throw \'Required param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Zammad.params.url + query,\r\n            request = new HttpRequest();\r\n\r\n        if (typeof Zammad.HTTPProxy === \'string\' && Zammad.HTTPProxy.trim() !== \'\') {\r\n            request.setProxy(Zammad.HTTPProxy);\r\n        }\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'Authorization: Token token=\' + Zammad.params.access_token);\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ Zammad Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\' \' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ Zammad Webhook ] Received response with status code \' + request.getStatus() + \': \' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ Zammad Webhook ] Failed to parse response received from Zammad\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null && typeof response.errors !== \'undefined\'\r\n                && Object.keys(response.errors).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errors);\r\n            }\r\n            else if (response !== null && typeof response.errorMessages !== \'undefined\'\r\n                && Object.keys(response.errorMessages).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errorMessages);\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.getStatus(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    setTicketTags: function (tags, ticket_id) {\r\n        var data = {\r\n            item: \'\',\r\n            object: \'Ticket\',\r\n            o_id: ticket_id\r\n        };\r\n\r\n        try {\r\n            var tags_json = JSON.parse(tags),\r\n                result;\r\n\r\n            for (var i in tags_json) {\r\n\r\n                if (tags_json[i].value) {\r\n                    data.item = tags_json[i].tag + ": " + tags_json[i].value;\r\n                } else {\r\n                    data.item = tags_json[i].tag;\r\n                }\r\n                result = Zammad.request(\'post\', \'api/v1/tags/add\', data);\r\n\r\n                if (typeof result.response !== \'object\' || result.status != 200) {\r\n                    Zabbix.log(4, \'[ Zammad Webhook ] Cannot add ticket tag:\' + tags_json[i].tag);\r\n                }\r\n            }\r\n        }\r\n        catch (error) {\r\n            Zabbix.log(4, \'[ Zammad Webhook ] Failed to add ticket tags:\' + error);\r\n        }\r\n\r\n        return;\r\n    },\r\n\r\n    createTicket: function(subject, message, priority) {\r\n        var data = {\r\n                title: subject,\r\n                group: \'Users\',\r\n                article: {\r\n                    subject: subject,\r\n                    body: message,\r\n                    type: \'note\',\r\n                    internal: false\r\n                },\r\n                customer: Zammad.params.customer\r\n            },\r\n            result;\r\n\r\n        if (priority) {\r\n            data.priority_id = priority;\r\n        }\r\n\r\n        result = Zammad.request(\'post\', \'api/v1/tickets\', data);\r\n\r\n        if (typeof result.response !== \'object\'\r\n            || typeof result.response.id === \'undefined\'\r\n            || result.status != 201) {\r\n            throw \'Cannot create Zammad ticket. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.id;\r\n    },\r\n\r\n    updateTicket: function(subject, message) {\r\n        var data = {\r\n            ticket_id: Zammad.params.ticket_id,\r\n            subject: subject,\r\n            body: message || \'\',\r\n            type: \'note\',\r\n            internal: false\r\n        };\r\n\r\n        result = Zammad.request(\'post\', \'api/v1/ticket_articles\', data);\r\n\r\n        if (typeof result.response !== \'object\'\r\n            || typeof result.response.id === \'undefined\'\r\n            || result.status != 201) {\r\n            throw \'Cannot update Zammad ticket. Check debug log for more information.\';\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        params_zammad = {},\r\n        params_update = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\', \'customer\',\r\n            \'event_source\', \'event_value\',\r\n            \'event_update_status\'\r\n        ],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: null, color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'zammad_\')) {\r\n                params_zammad[key.substring(7)] = params[key].trim();\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                params_update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    if (params.event_source === \'0\'\r\n        && ((params.event_value === \'1\' && params.event_update_status === \'1\')\r\n            || (params.event_value === \'0\'\r\n                && (params.event_update_status === \'0\' || params.event_update_status === \'1\')))\r\n        && (isNaN(parseInt(params.zammad_ticket_id)) || parseInt(params.zammad_ticket_id) < 1 )) {\r\n        throw \'Incorrect "zammad_ticket_id" parameter given: \' + params.zammad_ticket_id +\r\n            \'\\nMust be positive integer.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity].name];\r\n    priority = priority && priority.trim() || severities[7].name;\r\n\r\n    Zammad.setParams(params_zammad);\r\n    Zammad.HTTPProxy = params.HTTPProxy;\r\n\r\n    // Create ticket for non trigger-based events.\r\n    if (params.event_source !== \'0\'\r\n        && params.event_value !== \'0\') {\r\n        Zammad.createTicket(params.alert_subject, params.alert_message, priority, params.event_tags);\r\n    }\r\n    // Create ticket for trigger-based events.\r\n    else if (params.event_value === \'1\' && params_update.status === \'0\') {\r\n        var ticket_id = Zammad.createTicket(params.alert_subject,\r\n            params.alert_subject + \'\\n\' + params.alert_message + \'\\n\' +\r\n            params.zabbix_url + (params.zabbix_url.endsWith(\'/\') ? \'\' : \'/\') +\r\n            \'tr_events.php?triggerid=\' + params.trigger_id + \'&eventid=\' + params.event_id + \'\\n\',\r\n            priority);\r\n\r\n        result.tags.__zbx_zammad_ticket_id = ticket_id;\r\n        result.tags.__zbx_zammad_ticketlink = params.zammad_url +\r\n            (params.zammad_url.endsWith(\'/\') ? \'\' : \'/\') + \'#ticket/zoom/\' + ticket_id;\r\n\r\n        if (Zammad.params.enable_tags.toLowerCase() === \'true\') {\r\n            Zammad.setTicketTags(params.event_tags, ticket_id);\r\n        }\r\n    }\r\n    // Update created ticket for trigger-based event.\r\n    else {\r\n        Zammad.updateTicket(params.alert_subject, params.alert_message);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ Zammad Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_zammad_ticketlink}','Zammad: ticket #{EVENT.TAGS.__zbx_zammad_ticket_id}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('20','4','Jira ServiceDesk','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Jira = {\r\n    params: {},\r\n    schema: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Jira.params = params;\r\n        if (typeof Jira.params.url === \'string\') {\r\n            if (!Jira.params.url.endsWith(\'/\')) {\r\n                Jira.params.url += \'/\';\r\n            }\r\n\r\n            Jira.params.url += \'rest/servicedeskapi/\';\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        Jira.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    setTags: function(event_tags_json) {\r\n        if (!Jira.schema) {\r\n            Zabbix.log(4, \'[ Jira Service Desk Webhook ] Cannot add labels because failed to retrieve field schema.\');\r\n\r\n            return;\r\n        }\r\n\r\n        var block = Jira.schema.requestTypeFields.filter(function(object) {\r\n            return object.fieldId == \'labels\';\r\n        });\r\n\r\n        if (block[0] && typeof event_tags_json !== \'undefined\' && event_tags_json !== \'\'\r\n            && event_tags_json !== \'{EVENT.TAGSJSON}\') {\r\n            try {\r\n                var tags = JSON.parse(event_tags_json),\r\n                    label;\r\n\r\n                Jira.labels = [];\r\n\r\n                tags.forEach(function (tag) {\r\n                    if (typeof tag.tag !== \'undefined\' && typeof tag.value !== \'undefined\' ) {\r\n                        label = (tag.tag + (tag.value ? (\':\' + tag.value) : \'\')).replace(/\\s/g, \'_\');\r\n                        if (label.length < 255) {\r\n                            Jira.labels.push(label);\r\n                        }\r\n                    }\r\n                });\r\n            }\r\n            catch (error) {\r\n                // Code is not missing here.\r\n            }\r\n        }\r\n    },\r\n\r\n    addCustomFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            if (Jira.schema) {\r\n                Object.keys(fields)\r\n                    .forEach(function(field) {\r\n                        data.requestFieldValues[field] = fields[field];\r\n\r\n                        var block = Jira.schema.requestTypeFields.filter(function(object) {\r\n                            return object.fieldId == field;\r\n                        });\r\n\r\n                        if (typeof block[0] === \'object\' && typeof block[0].jiraSchema === \'object\'\r\n                            && (block[0].jiraSchema.type === \'number\' || block[0].jiraSchema.type === \'datetime\')) {\r\n                            switch (block[0].jiraSchema.type) {\r\n                                case \'number\':\r\n                                    data.requestFieldValues[field] = parseInt(fields[field]);\r\n                                    break;\r\n\r\n                                case \'datetime\':\r\n                                    if (fields[field].match(/\\d+[.-]\\d+[.-]\\d+T\\d+:\\d+:\\d+/) !== null) {\r\n                                        data.requestFieldValues[field] = fields[field].replace(/\\./g, \'-\');\r\n                                    }\r\n                                    else {\r\n                                        delete data.requestFieldValues[field];\r\n                                    }\r\n                                    break;\r\n                            }\r\n                        }\r\n                    });\r\n            }\r\n            else {\r\n                Zabbix.log(4, \'[ Jira Service Desk Webhook ] Cannot add custom fields\' +\r\n                    \'because failed to retrieve field schema.\');\r\n            }\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'user\', \'password\', \'servicedesk_id\', \'request_type_id\'].forEach(function (field) {\r\n            if (typeof Jira.params !== \'object\' || typeof Jira.params[field] === \'undefined\'\r\n                || Jira.params[field] === \'\' ) {\r\n                throw \'Required Jira param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Jira.params.url + query,\r\n            request = new HttpRequest();\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'Authorization: Basic \' + btoa(Jira.params.user + \':\' + Jira.params.password));\r\n        request.addHeader(\'X-ExperimentalApi: opt-in\');\r\n\r\n        if (typeof Jira.HTTPProxy !== \'undefined\' && Jira.HTTPProxy !== \'\') {\r\n            request.setProxy(Jira.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ Jira Service Desk Webhook ] Sending request: \' + url +\r\n            ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ Jira Service Desk Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ Jira Service Desk Webhook ] Failed to parse response received from Jira\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null && typeof response.errors !== \'undefined\'\r\n                && Object.keys(response.errors).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errors);\r\n            }\r\n            else if (response !== null && typeof response.errorMessage !== \'undefined\'\r\n                && Object.keys(response.errorMessage).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errorMessage);\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.getStatus(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    getSchema: function() {\r\n        var result = Jira.request(\'get\', \'servicedesk/\' + Jira.params.servicedesk_id + \'/requesttype/\' +\r\n            Jira.params.request_type_id + \'/field\');\r\n\r\n        if (typeof Jira.schema !== \'object\' && typeof Jira.schema.requestTypeFields !== \'object\') {\r\n            Jira.schema = null;\r\n        }\r\n        else {\r\n            Jira.schema = result.response;\r\n        }\r\n    },\r\n\r\n    createRequest: function(summary, description, fields) {\r\n        var data = {\r\n            serviceDeskId: Jira.params.servicedesk_id,\r\n            requestTypeId: Jira.params.request_type_id,\r\n            requestFieldValues: {\r\n                summary: summary,\r\n                description: description\r\n            }\r\n        };\r\n\r\n        if (Jira.labels && Jira.labels.length > 0) {\r\n            data.requestFieldValues.labels = Jira.labels;\r\n        }\r\n        var result = Jira.request(\'post\', \'request\', Jira.addCustomFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\' || typeof result.response.issueKey === \'undefined\') {\r\n            throw \'Cannot create Jira request. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.issueKey;\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        jira = {},\r\n        comment = {public: true},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\', \'alert_message\', \'event_source\', \'event_value\',\r\n            \'event_update_status\', \'event_recovery_value\'\r\n        ];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'jira_\')) {\r\n                jira[key.substring(5)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'customfield_\')) {\r\n                fields[key] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    Jira.setParams(jira);\r\n    Jira.setProxy(params.HTTPProxy);\r\n    Jira.getSchema();\r\n    Jira.setTags(params.event_tags_json);\r\n\r\n    // Create request for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_recovery_value !== \'0\') {\r\n        Jira.createRequest(params.alert_subject, params.alert_message);\r\n    }\r\n    // Create request for trigger-based events.\r\n    else if (params.event_value === \'1\' && params.event_update_status === \'0\'\r\n        && jira.request_key === \'{EVENT.TAGS.__zbx_jira_requestkey}\') {\r\n        var key = Jira.createRequest(params.alert_subject, params.alert_message, fields);\r\n\r\n        result.tags.__zbx_jira_requestkey = key;\r\n        result.tags.__zbx_jira_requestlink = params.jira_url +\r\n            (params.jira_url.endsWith(\'/\') ? \'\' : \'/\') + \'browse/\' + key;\r\n    }\r\n    // Comment created request for trigger-based event.\r\n    else {\r\n        if (jira.request_key === \'{EVENT.TAGS.__zbx_jira_requestkey}\' || jira.request_key.trim() === \'\') {\r\n            throw \'Incorrect Request key given: \' + jira.request_key;\r\n        }\r\n        comment.body = params.alert_message;\r\n        Jira.request(\'post\', \'request/\' + Jira.params.request_key + \'/comment\', comment);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ Jira Service Desk Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_jira_requestlink}','Jira ServiceDesk: {EVENT.TAGS.__zbx_jira_requestkey}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('21','4','OTRS','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var OTRS = {\r\n    params: {},\r\n    entrypoint: \'nph-genericinterface.pl/Webservice/ZabbixTicketConnector/Ticket\',\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        OTRS.params = params;\r\n        if (typeof OTRS.params.url === \'string\') {\r\n            if (!OTRS.params.url.endsWith(\'/\')) {\r\n                OTRS.params.url += \'/\';\r\n            }\r\n        }\r\n    },\r\n\r\n    addDynamicFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            data.DynamicField = [];\r\n\r\n            Object.keys(fields)\r\n                .forEach(function(field) {\r\n                    if (field !== undefined) {\r\n                        if (fields[field].match(/^\\d{4}[.-]\\d{2}[.-]\\d{2}$/)) {\r\n                            fields[field] = fields[field].replace(/\\./g, \'-\');\r\n                        }\r\n\r\n                        data.DynamicField.push({Name: field, Value: fields[field]});\r\n                    }\r\n                });\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'auth_user\', \'auth_password\', \'queue\',\r\n            \'customer\', \'ticket_state\', \'default_priority_id\', \'time_unit\'].forEach(function (field) {\r\n            if (typeof OTRS.params !== \'object\' || typeof OTRS.params[field] === \'undefined\'\r\n                || OTRS.params[field] === \'\' ) {\r\n                throw \'Required param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            request = new HttpRequest(),\r\n            url = OTRS.params.url + query +\r\n                \'?UserLogin=\' + encodeURIComponent(OTRS.params.auth_user) +\r\n                \'&Password=\' + encodeURIComponent(OTRS.params.auth_password);\r\n\r\n        if (typeof OTRS.HTTPProxy !== \'undefined\' && OTRS.HTTPProxy.trim() !== \'\') {\r\n            request.setProxy(OTRS.HTTPProxy);\r\n        }\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ OTRS Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\' \' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ OTRS Webhook ] Received response with status code \' + request.getStatus() + \': \' + response);\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            message += \': \' + response;\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ OTRS Webhook ] Failed to parse response received from OTRS\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (typeof response.Error !== \'undefined\'\r\n            && Object.keys(response.Error).length > 0) {\r\n            message = \'Request failed: \' + JSON.stringify(response.Error);\r\n        }\r\n\r\n\r\n        return {\r\n            status: request.getStatus(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    createTicket: function(subject, message, priority, fields) {\r\n        var result,\r\n            data = {\r\n                Ticket: {\r\n                    Title: subject,\r\n                    Queue: OTRS.params.queue,\r\n                    State: OTRS.params.ticket_state,\r\n                    PriorityID: priority || OTRS.params.default_priority_id,\r\n                    CustomerUser: OTRS.params.customer\r\n                },\r\n                Article: {\r\n                    Subject: subject,\r\n                    Body: message,\r\n                    TimeUnit: OTRS.params.time_unit,\r\n                    ContentType: \'text/plain; charset=utf8\'\r\n                }\r\n            };\r\n\r\n        result = OTRS.request(\'post\', OTRS.entrypoint, OTRS.addDynamicFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\'\r\n            || typeof result.response.TicketID === \'undefined\'\r\n            || result.status != 200) {\r\n            throw \'Cannot create OTRS ticket. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.TicketID;\r\n    },\r\n\r\n    updateTicket: function(subject, message) {\r\n        var result,\r\n            data = {\r\n                Article: {\r\n                    Subject: subject,\r\n                    Body: message || \'\',\r\n                    TimeUnit: OTRS.params.time_unit,\r\n                    ContentType: \'text/plain; charset=utf8\'\r\n                }\r\n            };\r\n\r\n        result = OTRS.request(\'put\', OTRS.entrypoint + \'/\' + encodeURIComponent(OTRS.params.ticket_id), data);\r\n\r\n        if (typeof result.response !== \'object\'\r\n            || typeof result.response.TicketID === \'undefined\'\r\n            || result.status != 200) {\r\n            throw \'Cannot update OTRS ticket. Check debug log for more information.\';\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        params_otrs = {},\r\n        params_fields = {},\r\n        params_update = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\', \'event_source\',\r\n            \'event_value\',  \'event_update_status\'\r\n        ],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: null, color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'otrs_\')) {\r\n                params_otrs[key.substring(5)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'dynamicfield_\')) {\r\n                params_fields[key.substring(13)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                params_update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    if (params.event_source === \'0\'\r\n        && ((params.event_value === \'1\' && params.event_update_status === \'1\')\r\n            || (params.event_value === \'0\'\r\n                && (params.event_update_status === \'0\' || params.event_update_status === \'1\')))\r\n        && (isNaN(parseInt(params.otrs_ticket_id)) || parseInt(params.otrs_ticket_id) < 1 )) {\r\n        throw \'Incorrect "otrs_ticket_id" parameter given: \' + params.otrs_ticket_id +\r\n            \'\\nMust be positive integer.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity].name];\r\n    priority = priority && priority.trim() || severities[7].name;\r\n\r\n    OTRS.setParams(params_otrs);\r\n    OTRS.HTTPProxy = params.HTTPProxy;\r\n\r\n    // Create ticket for non trigger-based events.\r\n    if (params.event_source !== \'0\'\r\n        && params.event_value !== \'0\') {\r\n        OTRS.createTicket(params.alert_subject, params.alert_message, priority);\r\n    }\r\n    // Create ticket for trigger-based events.\r\n    else if (params.event_value === \'1\' && params_update.status === \'0\') {\r\n        var ticket_id = OTRS.createTicket(params.alert_subject,\r\n            params.alert_subject + \'\\n\' + params.alert_message + \'\\n\' +\r\n            params.zabbix_url + (params.zabbix_url.endsWith(\'/\') ? \'\' : \'/\') +\r\n            \'tr_events.php?triggerid=\' + params.trigger_id + \'&eventid=\' + params.event_id + \'\\n\',\r\n            priority,\r\n            params_fields);\r\n\r\n        result.tags.__zbx_otrs_ticket_id = ticket_id;\r\n        result.tags.__zbx_otrs_ticketlink = params.otrs_url +\r\n            (params.otrs_url.endsWith(\'/\') ? \'\' : \'/\') + \'index.pl?Action=AgentTicketZoom;TicketID=\' + ticket_id;\r\n    }\r\n    // Update created ticket for trigger-based event.\r\n    else {\r\n        OTRS.updateTicket(params.alert_subject, params.alert_message);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ OTRS Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_otrs_ticketlink}','OTRS: ticket #{EVENT.TAGS.__zbx_otrs_ticket_id}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('22','4','iLert','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','try {\r\n    var result = { tags: {} },\r\n        params = JSON.parse(value),\r\n        req = new HttpRequest(),\r\n        resp = \'\';\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        req.setProxy(params.HTTPProxy);\r\n    }\r\n    var alertSourceKey = params[\'.ILERT.ALERT.SOURCE.KEY\'];\r\n    if (!alertSourceKey || (typeof alertSourceKey === \'string\' && alertSourceKey.trim() === \'\')) {\r\n        throw \'incorrect value for variable "ILERT.ALERT.SOURCE.KEY". The value must be a non-empty string.\';\r\n    }\r\n    delete params[\'.ILERT.ALERT.SOURCE.KEY\'];\r\n    \r\n    var ilertApiBaseURL = "https://api.ilert.com";\r\n    var reqURL = encodeURI(ilertApiBaseURL + "/api/v1/events/zabbix-mt/" + alertSourceKey)\r\n\r\n    var incidentKey = "zabbix-" + params[\'EVENT.ID\'];\r\n    var incidentViewURL = ilertApiBaseURL + "/api/v1/incidents/resolve-ik/" + alertSourceKey + "/" + incidentKey;\r\n\r\n    req.addHeader(\'Accept: application/json\');\r\n    req.addHeader(\'Content-Type: application/json\');\r\n\r\n    Zabbix.log(4, \'[iLert Webhook] Sending request:\' + JSON.stringify(params));\r\n    resp = req.post(reqURL, JSON.stringify(params));\r\n    Zabbix.log(4, \'[iLert Webhook] Receiving response:\' + resp);\r\n\r\n    try {\r\n        resp = JSON.parse(resp);\r\n    }\r\n    catch (error) {\r\n        throw \'incorrect response. iLert returned a non-JSON object.\';\r\n    }\r\n\r\n    if (req.getStatus() == 200) {\r\n        result.tags.__ilert_incident_url = incidentViewURL;\r\n        return JSON.stringify(result);\r\n    }\r\n\r\n    if (req.getStatus() == 400 && typeof resp === \'object\' && typeof resp.code === \'string\') {\r\n        if (resp.code === \'NO_OPEN_INCIDENT_WITH_KEY\') {\r\n          return JSON.stringify(result);\r\n        }\r\n        if (resp.code === \'INCIDENT_ALREADY_ACCEPTED\') {\r\n          result.tags.__ilert_incident_url = incidentViewURL;\r\n          return JSON.stringify(result);\r\n        }\r\n    }\r\n\r\n    if (typeof resp === \'object\' && typeof resp.message === \'string\') {\r\n        throw resp.message;\r\n    }\r\n    else {\r\n        throw \'Unknown error.\';\r\n    }\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[iLert Webhook] Notification failed : \' + error);\r\n    throw \'iLert notification failed : \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__ilert_incident_url}','iLert incident','Please refer to https://docs.ilert.com/integrations/zabbix/native \r\n  \r\nSet global macro {$ZABBIX.URL} with your Zabbix server URL.\r\nAdd a dedicated user with the media type "iLert". You can also rewrite the incident summary via ".ILERT.INCIDENT.SUMMARY" parameter or leave it empty to use the standard pattern.');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('23','4','SolarWinds Service Desk','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var SolarWinds = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        SolarWinds.params = params;\r\n        SolarWinds.params.endpoint = \'https://api.samanage.com/\';\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        SolarWinds.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    addCustomFields: function (data, fields) {\r\n        if (typeof data.incident === \'object\' && typeof fields === \'object\' && Object.keys(fields).length) {\r\n            if (typeof fields.sw_fields === \'object\' && Object.keys(fields.sw_fields).length) {\r\n                Object.keys(fields.sw_fields)\r\n                    .forEach(function(field) {\r\n                        try {\r\n                            data.incident[field] = JSON.parse(fields.sw_fields[field]);\r\n                        }\r\n                        catch (error) {\r\n                            data.incident[field] = fields.sw_fields[field];\r\n                        }\r\n                    });\r\n            }\r\n\r\n            if (typeof fields.sw_customfields === \'object\' && Object.keys(fields.sw_customfields).length) {\r\n                data.incident.custom_fields_values = {custom_fields_value: []};\r\n                Object.keys(fields.sw_customfields)\r\n                    .forEach(function(field) {\r\n                        data.incident.custom_fields_values.custom_fields_value.push({\r\n                            name: field,\r\n                            value: fields.sw_customfields[field]\r\n                        });\r\n                    });\r\n            }\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'token\'].forEach(function (field) {\r\n            if (typeof SolarWinds.params !== \'object\' || typeof SolarWinds.params[field] === \'undefined\'\r\n                || SolarWinds.params[field] === \'\' ) {\r\n                throw \'Required SolarWinds param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = SolarWinds.params.endpoint + query,\r\n            request = new HttpRequest();\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'X-Samanage-Authorization: Bearer \' + SolarWinds.params.token);\r\n        request.addHeader(\'Accept: application/vnd.samanage.v2.1+json\');\r\n\r\n        if (typeof SolarWinds.HTTPProxy !== \'undefined\' && SolarWinds.HTTPProxy !== \'\') {\r\n            request.setProxy(SolarWinds.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ SolarWinds SD Webhook ] Sending request: \' + url + ((typeof data === \'string\')\r\n            ? (\'\\n\' + data)\r\n            : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ SolarWinds SD Webhook ] Received response with status code \' + request.getStatus() +\r\n            \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ SolarWinds SD Webhook ] Failed to parse response received from SolarWinds\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null && typeof response.error !== \'undefined\'\r\n                && Object.keys(response.error).length > 0) {\r\n                message += \': \' + JSON.stringify(response.error);\r\n            }\r\n            else if (response !== null && typeof response === \'object\'\r\n                && Object.keys(response).length > 0) {\r\n                Object.keys(response)\r\n                    .forEach(function(field) {\r\n                        message += \'\\n\' + field + \': \' + response[field][0];\r\n                    });\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.getStatus(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    createIncident: function(name, description, fields) {\r\n        var data = {\r\n            incident: {\r\n                name: name,\r\n                description: description,\r\n                priority: SolarWinds.params.priority\r\n            }\r\n        };\r\n\r\n        var result = SolarWinds.request(\'post\', \'incidents.json\', SolarWinds.addCustomFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\' || typeof result.response.id === \'undefined\') {\r\n            throw \'Cannot create SolarWinds incident. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.id;\r\n    },\r\n\r\n    updateIncident: function(name, fields, message) {\r\n        var data = {\r\n            incident: {\r\n                name: name,\r\n                priority: SolarWinds.params.priority\r\n            }\r\n        };\r\n\r\n        SolarWinds.request(\r\n            \'put\',\r\n            \'incidents/\' + SolarWinds.params.incident_id + \'.json\',\r\n            SolarWinds.addCustomFields(data, fields));\r\n\r\n        SolarWinds.commenIncident(message);\r\n    },\r\n\r\n    commenIncident: function(message) {\r\n        var data = {\r\n            comment: {\r\n                body: message\r\n            }\r\n        };\r\n\r\n        SolarWinds.request(\'post\', \'incidents/\' + SolarWinds.params.incident_id + \'/comments.json\', data);\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        samanage = {},\r\n        result = {tags: {}},\r\n        required_params = [\'alert_subject\', \'event_recovery_value\', \'event_source\', \'event_value\', \'priority_default\'],\r\n        severities = [\r\n            {name: \'not_classified\'},\r\n            {name: \'information\'},\r\n            {name: \'warning\'},\r\n            {name: \'average\'},\r\n            {name: \'high\'},\r\n            {name: \'disaster\'},\r\n            {name: \'resolved\'},\r\n            {name: \'default\'}\r\n        ];\r\n\r\n    fields.sw_fields = {};\r\n    fields.sw_customfields = {};\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'samanage_\')) {\r\n                samanage[key.substring(9)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'sw_field_\')) {\r\n                fields.sw_fields[key.substring(9)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'sw_customfield_\')) {\r\n                fields.sw_customfields[key.substring(15)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    samanage.priority = params[\'priority_\' + severities[params.event_nseverity].name] || params.priority_default;\r\n\r\n    SolarWinds.setParams(samanage);\r\n    SolarWinds.setProxy(params.HTTPProxy);\r\n\r\n    // Create incident for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_recovery_value !== \'0\') {\r\n        SolarWinds.createIncident(params.alert_subject, params.alert_message);\r\n    }\r\n    // Create incident for trigger-based events.\r\n    else if (params.event_value === \'1\' && params.event_update_status === \'0\'\r\n            && samanage.incident_id === \'{EVENT.TAGS.__zbx_solarwinds_inc_id}\') {\r\n        var key = SolarWinds.createIncident(params.alert_subject, params.alert_message, fields);\r\n\r\n\r\n        result.tags.__zbx_solarwinds_inc_id = key;\r\n        result.tags.__zbx_solarwinds_inc_link = params.samanage_url +\r\n            (params.samanage_url.endsWith(\'/\') ? \'\' : \'/\') + \'incidents/\' + key;\r\n    }\r\n    // Update created incident for trigger-based event.\r\n    else {\r\n        if (samanage.incident_id === \'{EVENT.TAGS.__zbx_solarwinds_inc_id}\' || samanage.incident_id === \'\') {\r\n            throw \'Incorrect incident key given: \' + samanage.incident_id;\r\n        }\r\n        if (!params.alert_message) {\r\n            throw \'Parameter "alert_message" can\\\'t be empty.\';\r\n        }\r\n        SolarWinds.updateIncident(params.alert_subject, fields, params.alert_message);\r\n    }\r\n\r\n    if (params.event_source === \'0\') {\r\n        return JSON.stringify(result);\r\n    }\r\n    else {\r\n        return \'OK\';\r\n    }\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ SolarWinds SD Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_solarwinds_inc_link}','SolarWinds incident ID: {EVENT.TAGS.__zbx_solarwinds_inc_id}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('24','4','SysAid','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var SysAid = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        var required = [\'url\', \'auth_user\', \'auth_password\', \'category_level_1\', \'category_level_2\',\r\n            \'category_level_3\', \'incident_id\', \'template_id\', \'urgency_id\', \'incident_state\',\r\n            \'default_priority_id\'\r\n        ];\r\n\r\n        required.forEach(function (field) {\r\n            if (typeof params !== \'object\' || typeof params[field] === \'undefined\' || params[field] === \'\') {\r\n                throw \'Required param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        SysAid.params = params;\r\n        if (typeof SysAid.params.url === \'string\' && !SysAid.params.url.endsWith(\'/\')) {\r\n            SysAid.params.url += \'/\';\r\n        }\r\n    },\r\n\r\n    login: function () {\r\n        var result = SysAid.request(\'post\', \'api/v1/login\', {\r\n            user_name: SysAid.params.auth_user,\r\n            password: SysAid.params.auth_password\r\n        });\r\n\r\n        return result.response.user.id;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        var response,\r\n            request = SysAid.req || (SysAid.req = new HttpRequest()),\r\n            url = SysAid.params.url + query;\r\n\r\n        if (typeof SysAid.HTTPProxy !== \'undefined\' && SysAid.HTTPProxy.trim() !== \'\') {\r\n            request.setProxy(SysAid.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ SysAid Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\' \' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ SysAid Webhook ] Received response with status code \' + request.getStatus() + \': \' + response);\r\n\r\n        if (request.getStatus() !== 200) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            message += \': \' + response;\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ SysAid Webhook ] Failed to parse response received from SysAid\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (response === null || (typeof response.Error !== \'undefined\' && Object.keys(response.Error).length > 0)) {\r\n            throw \'Request failed: \' + JSON.stringify(response.Error);\r\n        }\r\n\r\n        return {\r\n            status: request.getStatus(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    createIncident: function(subject, message, priority) {\r\n        var result = SysAid.request(\'post\', \'api/v1/sr/?template=\' + encodeURIComponent(SysAid.params.template_id), {\r\n            info: [\r\n                {\r\n                    key: \'problem_type\',\r\n                    value: [\r\n                        SysAid.params.category_level_1,\r\n                        SysAid.params.category_level_2,\r\n                        SysAid.params.category_level_3\r\n                    ].join(\'_\')\r\n                },\r\n                {\r\n                    key: \'title\',\r\n                    value: subject\r\n                },\r\n                {\r\n                    key: \'description\',\r\n                    value: message\r\n                },\r\n                {\r\n                    key: \'status\',\r\n                    value: \'1\'\r\n                },\r\n                {\r\n                    key: \'urgency\',\r\n                    value: SysAid.params.urgency_id\r\n                },\r\n                {\r\n                    key: \'priority\',\r\n                    value: priority || SysAid.params.default_priority_id,\r\n                }\r\n            ]\r\n        });\r\n\r\n        if (result.response.id === \'undefined\') {\r\n            throw \'Cannot create SysAid incident. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.id;\r\n    },\r\n\r\n    updateTicket: function(note) {\r\n        var date = new Date().getTime();\r\n\r\n        SysAid.request(\'put\', \'api/v1/sr/\' + encodeURIComponent(SysAid.params.incident_id), {\r\n            id: SysAid.params.incident_id,\r\n            info: [\r\n                {\r\n                    key: \'update_time\',\r\n                    value: date\r\n                },\r\n                {\r\n                    key: \'notes\',\r\n                    value: [\r\n                        {\r\n                            userName: \'Zabbix\',\r\n                            createDate: date,\r\n                            text: note\r\n                        }\r\n                    ]\r\n                }\r\n            ]\r\n        });\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        params_sysaid = {},\r\n        params_update = {},\r\n        result = {tags: {}},\r\n        required_params = [\'alert_subject\', \'event_source\', \'event_value\',  \'event_update_status\'],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: null, color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'sysaid_\')) {\r\n                params_sysaid[key.substring(7)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                params_update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    if (params.event_source === \'0\' && ((params.event_value === \'1\' && params.event_update_status === \'1\')\r\n            || (params.event_value === \'0\' && (params.event_update_status === \'0\' || params.event_update_status === \'1\')))\r\n            && (isNaN(parseInt(params.sysaid_incident_id)) || parseInt(params.sysaid_incident_id) < 1 )) {\r\n        throw \'Incorrect "sysaid_incident_id" parameter given: \' + params.sysaid_incident_id + \'\\nMust be positive integer.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity].name];\r\n    priority = priority && priority.trim() || severities[7].name;\r\n\r\n    SysAid.setParams(params_sysaid);\r\n    SysAid.HTTPProxy = params.HTTPProxy;\r\n    SysAid.login();\r\n\r\n    if (params.event_source !== \'0\' && params.event_value !== \'0\') {\r\n        // Create ticket for non trigger-based events.\r\n        SysAid.createIncident(params.alert_subject, params.alert_message, priority);\r\n    }\r\n    else if (params.event_value === \'1\' && params_update.status === \'0\') {\r\n        // Create ticket for trigger-based events.\r\n        var incident_id = SysAid.createIncident(params.alert_subject, params.alert_subject + \'\\n\' + params.alert_message +\r\n                \'\\n\' + params.zabbix_url + (params.zabbix_url.endsWith(\'/\') ? \'\' : \'/\') + \'tr_events.php?triggerid=\' +\r\n                params.trigger_id + \'&eventid=\' + params.event_id + \'\\n\', priority\r\n        );\r\n\r\n        result.tags.__zbx_sysaid_incident_id = incident_id;\r\n        result.tags.__zbx_sysaid_incidentlink = params.sysaid_url +\r\n            (params.sysaid_url.endsWith(\'/\') ? \'\' : \'/\') + \'SREdit.jsp?id=\' + incident_id + \'&fromId=IncidentsList\';\r\n    }\r\n    else {\r\n        // Update created ticket for trigger-based event.\r\n        SysAid.updateTicket(params.alert_subject + \'\\n\' + params.alert_message);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ SysAid Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_sysaid_incidentlink}','SysAid: incident #{EVENT.TAGS.__zbx_sysaid_incident_id}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('25','4','TOPdesk','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Media = {\r\n    params: {},\r\n    name: \'\',\r\n    labels: [],\r\n    HTTPProxy: \'\',\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Media.params = params;\r\n        Media.params.api += Media.params.api.endsWith(\'/\') ? \'\' : \'/\';\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        if (typeof HTTPProxy !== \'undefined\' && HTTPProxy.trim() !== \'\') {\r\n            Media.HTTPProxy = HTTPProxy;\r\n        }\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'api\', \'token\'].forEach(function (field) {\r\n            if (typeof Media.params !== \'object\' || typeof Media.params[field] === \'undefined\'\r\n                    || Media.params[field] === \'\') {\r\n                throw \'Required \' + Media.name + \' param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Media.params.api + query,\r\n            request = new HttpRequest();\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'Accept: application/json\');\r\n        request.addHeader(\'Authorization: \' + Media.params.token);\r\n        request.setProxy(Media.HTTPProxy);\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Failed to parse response.\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null) {\r\n                if (typeof response.errors === \'object\' && Object.keys(response.errors).length > 0) {\r\n                    message += \': \' + JSON.stringify(response.errors);\r\n                }\r\n                else if (typeof response.errorMessages === \'object\' && Object.keys(response.errorMessages).length > 0) {\r\n                    message += \': \' + JSON.stringify(response.errorMessages);\r\n                }\r\n                else if (typeof response.message === \'string\') {\r\n                    message += \': \' + response.message;\r\n                }\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.getStatus(),\r\n            response: response\r\n        };\r\n    }\r\n};\r\n\r\ntry {\r\n    var result = {tags: {}},\r\n        params = JSON.parse(value),\r\n        media = {},\r\n        fields = {},\r\n        resp = {},\r\n        required_params = [\r\n            \'alert_subject\',\r\n            \'alert_message\',\r\n            \'event_id\',\r\n            \'event_source\',\r\n            \'event_value\',\r\n            \'event_update_status\',\r\n            \'topdesk_api\',\r\n            \'topdesk_user\',\r\n            \'topdesk_password\'\r\n        ],\r\n        severities = [\r\n            \'not_classified\',\r\n            \'information\',\r\n            \'warning\',\r\n            \'average\',\r\n            \'high\',\r\n            \'disaster\',\r\n            \'resolved\',\r\n            \'default\'\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n            if (key.startsWith(\'topdesk_\')) {\r\n                media[key.substring(8)] = params[key];\r\n            }\r\n        });\r\n\r\n    // Possible values of event_source:\r\n    // 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check event_value for trigger-based and internal events.\r\n    // Possible values: 1 for problem, 0 for recovering\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check event_update_status only for trigger-based events.\r\n    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check event_id for a numeric value.\r\n    if (isNaN(parseInt(params.event_id)) || params.event_id < 1) {\r\n        throw \'Incorrect "event_id" parameter given: \' + params.event_id + \'\\nMust be a positive number.\';\r\n    }\r\n\r\n    if ((params.event_source === \'1\' || params.event_source === \'2\')  && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for Trigger and Internal actions.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity]];\r\n    params.zbxurl = params.zbxurl + (params.zbxurl.endsWith(\'/\') ? \'\' : \'/\');\r\n\r\n    Media.name = \'TOPdesk\';\r\n    Media.setParams(media);\r\n    Media.params.token = \'Basic \' + btoa(Media.params.user + \':\' + Media.params.password);\r\n    Media.setProxy(params.HTTPProxy);\r\n\r\n    // Create an issue.\r\n    // Numeric value of the event that triggered an action (1 for problem, 0 for recovering).\r\n    // Numeric value of of the problem update status. Possible values:\r\n    // 0 - Webhook was called because of problem/recovery event, 1 - Update operation.\r\n    if ((params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0)\r\n            || (params.event_source == 3 && params.event_value == 1)\r\n            || params.event_source == 1 || params.event_source == 2) {\r\n        Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Request of the ticket creating.\');\r\n        fields.caller = {dynamicName: \'Zabbix\'};\r\n        fields.briefDescription = params.alert_subject;\r\n        fields.request = params.alert_message.replace(/\\n/g, \'<br>\');\r\n        fields.priority = {name: priority};\r\n        fields.processingStatus = {name: Media.params.status};\r\n        fields.externalNumber = params.event_id;\r\n        fields.request += \'<br>\' + params.zbxurl;\r\n\r\n        if (params.event_source === \'0\') {\r\n            fields.request += \'tr_events.php?triggerid=\' + params.trigger_id + \'&eventid=\' + params.event_id;\r\n        }\r\n\r\n        resp = Media.request(\'post\', \'tas/api/incidents\', fields);\r\n        if (typeof resp.response !== \'object\' || typeof resp.response.id === \'undefined\') {\r\n            throw \'Cannot create \' + Media.name + \' issue. Check debug log for more information.\';\r\n        }\r\n\r\n        if (params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0) {\r\n            result.tags.__zbx_tpd_issuekey = resp.response.number;\r\n            result.tags.__zbx_tpd_issuelink = Media.params.api +\r\n                \'tas/secure/incident?action=show&unid=\' + resp.response.id;\r\n        }\r\n    }\r\n    // Update a created issue.\r\n    else {\r\n        if (params.event_source == 3 && params.event_value == 0) {\r\n            throw \'Internal event recovery actions are not supported.\';\r\n        }\r\n\r\n        Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Request of the ticket updating.\');\r\n        fields.action = params.alert_message.replace(/\\n/g, \'<br>\');\r\n\r\n        resp = Media.request(\'put\', \'tas/api/incidents/number/\' + Media.params.issue_key, fields);\r\n        if (typeof resp.response !== \'object\' || typeof resp.response.id === \'undefined\'\r\n                || resp.response.number !== Media.params.issue_key) {\r\n            throw \'Cannot update \' + Media.name + \' issue. Check debug log for more information.\';\r\n        }\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ \' + Media.name + \' Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_tpd_issuelink}','TOPdesk: {EVENT.TAGS.__zbx_tpd_issuekey}','Please refer to https://developers.topdesk.com/documentation/index.html and https://www.zabbix.com/documentation/5.4/manual/config/notifications/media/webhook#example_scripts.\r\n  \r\nSet global macro {$ZABBIX.URL} with your Zabbix server URL.\r\nAdd a dedicated user with the media type "TOPdesk".\r\nChange the values of the variables topdesk_api (URL), topdesk_password, topdesk_user. The topdesk_status is the default status for creating a new TOPdesk ticket.');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('26','4','iTop','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Itop = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        if (params.log !== \'private_log\' && params.log !== \'public_log\') {\r\n            throw \'Incorrect "itop_log" parameter given: \' + params.log + \'\\nMust be "private_log" or "public_log".\';\r\n        }\r\n\r\n        Itop.params = params;\r\n        if (typeof Itop.params.url === \'string\') {\r\n            if (!Itop.params.url.endsWith(\'/\')) {\r\n                Itop.params.url += \'/\';\r\n            }\r\n\r\n            Itop.params.url += \'webservices/rest.php?version=\' + encodeURIComponent(Itop.params.api_version);\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        Itop.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    setCreatePayload: function () {\r\n        json_data.operation = \'core/create\';\r\n        json_data.fields.org_id = Itop.params.organization_id;\r\n        json_data.fields.title = params.alert_subject;\r\n        json_data.fields.description = params.alert_message.replace(\'<\', \'&lt;\')\r\n            .replace(\'>\', \'&gt;\')\r\n            .replace(/(?:\\r\\n|\\r|\\n)/g, \'<br>\');\r\n    },\r\n\r\n    setUpdatePayload: function () {\r\n        json_data.operation = \'core/update\';\r\n        json_data.key = Itop.params.id;\r\n        json_data.fields.title = params.alert_subject;\r\n        json_data.fields[Itop.params.log] = {\r\n            add_item: {\r\n                message: params.alert_subject + \'\\n\' + params.alert_message,\r\n                format: \'text\'\r\n            }\r\n        };\r\n    },\r\n\r\n    request: function (data) {\r\n        [\'url\', \'user\', \'password\', \'organization_id\', \'class\', \'api_version\', \'id\'].forEach(function (field) {\r\n            if (typeof Itop.params !== \'object\' || typeof Itop.params[field] === \'undefined\'\r\n                    || Itop.params[field] === \'\' ) {\r\n                throw \'Required Itop param is not set: "itop_\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Itop.params.url,\r\n            request = new HttpRequest(),\r\n            object;\r\n\r\n        request.addHeader(\'Content-Type: multipart/form-data\');\r\n        request.addHeader(\'Authorization: Basic \' + btoa(Itop.params.user + \':\' + Itop.params.password));\r\n\r\n        if (Itop.HTTPProxy) {\r\n            request.setProxy(Itop.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ iTop Webhook ] Sending request: \' + url + \'&json_data=\' + data);\r\n\r\n        response = request.post(url + \'&json_data=\' + encodeURIComponent(data));\r\n\r\n        Zabbix.log(4, \'[ iTop Webhook ] Received response with status code \' + request.getStatus() + \'\\n\' + response);\r\n\r\n        try {\r\n            response = JSON.parse(response);\r\n        }\r\n        catch (error) {\r\n            Zabbix.log(4, \'[ iTop Webhook ] Failed to parse response received from iTop\');\r\n            throw \'Failed to parse response received from iTop.\\nRequest status code \' +\r\n                    request.getStatus() + \'. Check debug log for more information.\';\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            throw \'Request failed with status code \' + request.getStatus() + \'. Check debug log for more information.\';\r\n        }\r\n        else if (typeof response.code !== \'undefined\' && response.code !== 0) {\r\n            throw \'Request failed with iTop code \' + response.code + \': \' +\r\n                    JSON.stringify(response.message) + \'. Check debug log for more information.\';\r\n        }\r\n        else {\r\n            Object.keys(response.objects)\r\n                .forEach(function (key) {\r\n                    object = response.objects[key];\r\n                });\r\n    \r\n            return {\r\n                status: request.getStatus(),\r\n                response: object.fields\r\n            };\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        json_data = {},\r\n        itop_params = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\', \'summary\', \'event_recovery_value\',\r\n            \'event_source\', \'event_value\', \'action_name\'\r\n        ];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'itop_\')) {\r\n                itop_params[key.substring(5)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n            && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    Itop.setParams(itop_params);\r\n    Itop.setProxy(params.HTTPProxy);\r\n\r\n    json_data.operation = \'\';\r\n    json_data.class = Itop.params.class;\r\n    json_data.comment = Itop.params.comment;\r\n    json_data.output_fields = \'id, friendlyname\';\r\n    json_data.fields = {};\r\n\r\n    // Create issue for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_recovery_value !== \'0\') {\r\n        Itop.setCreatePayload();\r\n        Itop.request(json_data);\r\n    }\r\n    // Create issue for trigger-based events.\r\n    else if (params.event_value === \'1\' && params.event_update_status === \'0\'\r\n            && Itop.params.id === \'{EVENT.TAGS.__zbx_itop_id}\') {\r\n        Itop.setCreatePayload();\r\n\r\n        var response = Itop.request(json_data);\r\n\r\n        result.tags.__zbx_itop_id = response.response.id;\r\n        result.tags.__zbx_itop_key = response.response.friendlyname;\r\n        result.tags.__zbx_itop_link = params.itop_url + (params.itop_url.endsWith(\'/\') ? \'\' : \'/\') +\r\n                \'pages/UI.php?operation=details&class=\' + encodeURIComponent(Itop.params.class) + \'&id=\' +\r\n                encodeURIComponent(response.response.id);\r\n    }\r\n    // Update created issue for trigger-based event.\r\n    else {\r\n        if (Itop.params.id === \'{EVENT.TAGS.__zbx_itop_id}\') {\r\n            throw \'Incorrect iTop ticket ID given: \' + Itop.params.id;\r\n        }\r\n        Itop.setUpdatePayload();\r\n        Itop.request(json_data);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ iTop Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_itop_link}','iTop: {EVENT.TAGS.__zbx_itop_key}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('27','4','Rocket.Chat','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var RocketChat = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        RocketChat.params = params;\r\n        if (RocketChat.params.url && RocketChat.params.api_url) {\r\n            if (!RocketChat.params.url.endsWith(\'/\')) {\r\n                RocketChat.params.url += \'/\';\r\n            }\r\n            if (!RocketChat.params.api_url.endsWith(\'/\')) {\r\n                RocketChat.params.api_url += \'/\';\r\n            }\r\n            if (RocketChat.params.api_url.startsWith(\'/\')) {\r\n                RocketChat.params.api_url = RocketChat.params.api_url.substring(1);\r\n            }\r\n\r\n            RocketChat.params.url += RocketChat.params.api_url;\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        RocketChat.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    addFields: function (fields) {\r\n        var data = [];\r\n\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            Object.keys(fields)\r\n                .forEach(function(field) {\r\n                    if (fields[field] === \'\') {\r\n                        Zabbix.log(4, \'[ RocketChat Webhook ] Field "\' + field +\r\n                            \'" can\\\'t be empty. The field ignored.\');\r\n                    }\r\n                    else {\r\n                        try {\r\n                            var parts = field.split(\':\'),\r\n                                prefix = parts[0].split(\'_\');\r\n\r\n                            if (typeof prefix[2] === \'undefined\'\r\n                                    || (prefix[2] === \'p\' && params.event_value === \'1\')\r\n                                    || (prefix[2] === \'r\' && params.event_value === \'0\')) {\r\n                                data.push({\r\n                                    title: field.substring(field.indexOf(\':\') + 1),\r\n                                    value: fields[field],\r\n                                    short: prefix[1] === \'short\'\r\n                                });\r\n                            }\r\n                        }\r\n                        catch (error) {\r\n                            Zabbix.log(4, \'[ RocketChat Webhook ] Can\\\'t parse field "\' + field +\r\n                                \'". The field ignored.\');\r\n                        }\r\n                    }\r\n                });\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'api_url\', \'user_id\', \'user_token\', \'send_to\'].forEach(function (field) {\r\n            if (typeof RocketChat.params !== \'object\' || typeof RocketChat.params[field] === \'undefined\'\r\n                    || RocketChat.params[field] === \'\' ) {\r\n                throw \'Required parameter is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = RocketChat.params.url + query,\r\n            request = new HttpRequest();\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'X-Auth-Token:\' + RocketChat.params.user_token);\r\n        request.addHeader(\'X-User-Id:\' + RocketChat.params.user_id);\r\n\r\n        if (typeof RocketChat.HTTPProxy !== \'undefined\' && RocketChat.HTTPProxy !== \'\') {\r\n            request.setProxy(RocketChat.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ RocketChat Webhook ] Sending request: \' + url +\r\n            ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ RocketChat Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ RocketChat Webhook ] Failed to parse response received from RocketChat\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null && typeof response.message !== \'undefined\') {\r\n                message += \': \' + JSON.stringify(response.message);\r\n            }\r\n            else if (response !== null && typeof response.error !== \'undefined\') {\r\n                message += \': \' + JSON.stringify(response.error);\r\n            }\r\n\r\n            throw message + \'. Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.getStatus(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    postMessage: function(use_default_message, message, fields) {\r\n        var data = {\r\n            channel: RocketChat.params.send_to,\r\n            attachments: [{\r\n                collapsed: false,\r\n                color: RocketChat.params.color,\r\n                title: params.alert_subject\r\n            }]\r\n        };\r\n\r\n        if (RocketChat.params.title_link) {\r\n            data.attachments[0].title_link = RocketChat.params.title_link;\r\n        }\r\n\r\n        if (use_default_message) {\r\n            data.attachments[0].text = message;\r\n        }\r\n        else {\r\n            data.attachments[0].fields = RocketChat.addFields(fields);\r\n        }\r\n\r\n        var result = RocketChat.request(\'post\', \'chat.postMessage\', data);\r\n\r\n        if (typeof result.response !== \'object\' || typeof result.response.message._id === \'undefined\') {\r\n            throw \'Cannot send RocketChat message. Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            id: result.response.message._id,\r\n            rid: result.response.message.rid,\r\n            channel: result.response.channel\r\n        };\r\n    },\r\n\r\n    sendMessage: function(update, fields) {\r\n\r\n        var data = {\r\n            message: {\r\n                rid: RocketChat.params.room_id,\r\n                tmid: RocketChat.params.msg_id,\r\n                tshow: true\r\n            }\r\n        };\r\n\r\n        if (update.status === \'0\') {\r\n            data.message.attachments = [{\r\n                collapsed: false,\r\n                color: RocketChat.params.color,\r\n                title: params.alert_subject,\r\n                title_link: RocketChat.params.title_link,\r\n                fields: RocketChat.addFields(fields)\r\n            }];\r\n        }\r\n        else {\r\n            data.message.alias = update.user;\r\n            data.message.msg = update.action;\r\n            if (update.message) {\r\n                data.message.attachments = [{\r\n                    color: RocketChat.params.color,\r\n                    text: update.message\r\n                }];\r\n            }\r\n        }\r\n\r\n        RocketChat.request(\'post\', \'chat.sendMessage\', data);\r\n    },\r\n\r\n    getMessageLink: function(rid, id) {\r\n        var room = RocketChat.request(\'get\', \'rooms.info?roomId=\' + encodeURIComponent(rid)),\r\n            link = params.rc_url +\r\n                (params.rc_url.endsWith(\'/\') ? \'\' : \'/\');\r\n\r\n        switch (room.response.room.t) {\r\n            case \'c\':\r\n                link += \'channel/\' + room.response.room.name + \'?msg=\' + id;\r\n                break;\r\n\r\n            case \'p\':\r\n                link += \'group/\' + room.response.room.name + \'?msg=\' + id;\r\n                break;\r\n\r\n            case \'d\':\r\n                link += \'direct/\' + rid + \'?msg=\' + id;\r\n                break;\r\n\r\n            default:\r\n                Zabbix.log(4, \'[ RocketChat Webhook ] Can\\\'t get room type. Link to message will not be added.\');\r\n        }\r\n\r\n        return link;\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        response,\r\n        fields = {},\r\n        rc = {},\r\n        update = {},\r\n        result = {tags: {}},\r\n        required_params = [\'alert_subject\', \'alert_message\', \'event_source\', \'event_value\'],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'rc_\')) {\r\n                rc[key.substring(3)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'field_\')) {\r\n                fields[key.substring(6)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Forcing parameters for non trigger-based events.\r\n    if (params.event_source !== \'0\') {\r\n        params.use_default_message = \'true\';\r\n        params.event_nseverity = \'0\';\r\n        params.rc_title_link = false;\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n            && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    RocketChat.setParams(rc);\r\n    RocketChat.setProxy(params.HTTPProxy);\r\n    RocketChat.params.color = severities[params.event_nseverity].color;\r\n\r\n    // Send default message if use_default_message === true.\r\n    if (params.use_default_message.toLowerCase() === \'true\') {\r\n        response = RocketChat.postMessage(true, params.alert_message);\r\n        result.tags.__zbx_rc_id = response.id;\r\n        result.tags.__zbx_rc_rid = response.rid;\r\n        result.tags.__zbx_rc_msg_url = RocketChat.getMessageLink(response.rid, response.id);\r\n    }\r\n    // Send message for trigger-based events.\r\n    else if (params.event_value === \'1\' && update.status === \'0\') {\r\n        response = RocketChat.postMessage(false, params.alert_message, fields);\r\n        result.tags.__zbx_rc_id = response.id;\r\n        result.tags.__zbx_rc_rid = response.rid;\r\n        result.tags.__zbx_rc_msg_url = RocketChat.getMessageLink(response.rid, response.id);\r\n    }\r\n    // Send thread message for trigger-based event.\r\n    else {\r\n        RocketChat.sendMessage(update, fields);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ RocketChat Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_rc_msg_url}','Rocket.Chat','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('28','4','VictorOps','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var VictorOps = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        VictorOps.params = params;\r\n        if (VictorOps.params.endpoint) {\r\n            if (!VictorOps.params.endpoint.endsWith(\'/\')) {\r\n                VictorOps.params.endpoint += \'/\';\r\n            }\r\n\r\n            if (typeof VictorOps.params.routing_key !== \'undefined\'\r\n                    && VictorOps.params.routing_key !== \'{ALERT.SENDTO}\'\r\n                    && VictorOps.params.routing_key !== \'Default\') {\r\n                VictorOps.params.endpoint += VictorOps.params.routing_key;\r\n            }\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        VictorOps.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    addFields: function (fields) {\r\n        var data = {};\r\n\r\n        if (typeof fields === \'object\') {\r\n            Object.keys(fields)\r\n                .forEach(function(field) {\r\n                    if (fields[field] === \'\') {\r\n                        Zabbix.log(4, \'[ VictorOps Webhook ] Field "\' + field +\r\n                            \'" can\\\'t be empty. The field ignored.\');\r\n                    }\r\n                    else {\r\n                        try {\r\n                            var parts = field.split(\':\'),\r\n                                prefix = parts[0].split(\'_\');\r\n\r\n                            if (typeof prefix[1] === \'undefined\'\r\n                                    || (prefix[1] === \'p\' && params.event_value === \'1\'\r\n                                        && (params.event_update_status === \'0\'\r\n                                            || params.event_update_status === \'{EVENT.UPDATE.STATUS}\'))\r\n                                    || (prefix[1] === \'r\' && params.event_value === \'0\'\r\n                                        && (params.event_update_status === \'0\'\r\n                                            || params.event_update_status === \'{EVENT.UPDATE.STATUS}\'))\r\n                                    || (prefix[1] === \'u\' && params.event_update_status === \'1\')) {\r\n                                data[field.substring(field.indexOf(\':\') + 1)] = fields[field];\r\n                            }\r\n                        }\r\n                        catch (error) {\r\n                            Zabbix.log(4, \'[ VictorOps Webhook ] Can\\\'t parse field "\' + field +\r\n                                \'". The field ignored.\');\r\n                        }\r\n                    }\r\n                });\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (data) {\r\n        if (typeof VictorOps.params !== \'object\' || typeof VictorOps.params.endpoint === \'undefined\'\r\n                || VictorOps.params.endpoint === \'\' ) {\r\n            throw \'Required parameter is not set: "vops_endpoint".\';\r\n        }\r\n\r\n        var response,\r\n            url = VictorOps.params.endpoint,\r\n            request = new HttpRequest();\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n\r\n        if (typeof VictorOps.HTTPProxy !== \'undefined\' && VictorOps.HTTPProxy !== \'\') {\r\n            request.setProxy(VictorOps.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ VictorOps Webhook ] Sending request: \' + url +\r\n            ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        response = request.post(url, data);\r\n\r\n        Zabbix.log(4, \'[ VictorOps Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ VictorOps Webhook ] Failed to parse response received from VictorOps\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null && typeof response.messages !== \'undefined\') {\r\n                message += \': \' + JSON.stringify(response.messages);\r\n            }\r\n\r\n            throw message + \'. Check debug log for more information.\';\r\n        }\r\n\r\n        return response;\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        vops = {},\r\n        required_params = [\'event_source\', \'event_value\', \'priority_update\'],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'vops_\')) {\r\n                vops[key.substring(5)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'field\')) {\r\n                fields[key.substring(5)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n            && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    if (params.event_update_status === \'1\') {\r\n        fields[\':message_type\'] = params.priority_update;\r\n    }\r\n    else {\r\n        fields[\':message_type\'] = params[\'priority_\' + severities[params.event_nseverity].name]\r\n            || \'INFO\';\r\n    }\r\n\r\n    if (params.event_info && params.event_source === \'0\') {\r\n        fields[\':event_info\'] = params.event_info;\r\n    }\r\n\r\n    VictorOps.setParams(vops);\r\n    VictorOps.setProxy(params.HTTPProxy);\r\n    VictorOps.request(VictorOps.addFields(fields));\r\n\r\n    return \'OK\';\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ VictorOps Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('29','4','Brevis.one','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var BrevisOne = {\r\n    params: [],\r\n\r\n    addParam: function (name, value) {\r\n        BrevisOne.params.push(name + \'=\' + encodeURIComponent(value));\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        BrevisOne.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    setPayload: function (params) {\r\n        var parts = params.send_to.split(\':\'),\r\n            defaultValues = {\r\n                ring: \'true\',\r\n                flash: \'true\',\r\n                telauto: \'false\'\r\n            };\r\n\r\n        BrevisOne.addParam(\'username\', params.username);\r\n        BrevisOne.addParam(\'password\', params.password);\r\n        BrevisOne.addParam(\'text\', params.text);\r\n\r\n        if (parts.length > 1) {\r\n            BrevisOne.addParam(\'mode\', parts[0]);\r\n            BrevisOne.addParam(\'to\', parts[1]);\r\n        }\r\n        else {\r\n            BrevisOne.addParam(\'to\', parts[0]);\r\n        }\r\n\r\n        Object.keys(defaultValues)\r\n            .forEach(function (key) {\r\n                if (params[key] && params[key].trim() && params[key].toLowerCase() === defaultValues[key]) {\r\n                    BrevisOne.addParam(key, defaultValues[key]);\r\n                }\r\n            });\r\n    },\r\n\r\n    request: function () {\r\n        var response,\r\n            request = new HttpRequest(),\r\n            data = \'?\' + BrevisOne.params.join(\'&\');\r\n\r\n        request.addHeader(\'Content-Type: multipart/form-data\');\r\n\r\n        if (typeof BrevisOne.HTTPProxy !== \'undefined\' && BrevisOne.HTTPProxy !== \'\') {\r\n            request.setProxy(BrevisOne.HTTPProxy);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ BrevisOne Webhook ] Sending request.\');\r\n\r\n        response = request.post(params.endpoint + data);\r\n\r\n        Zabbix.log(4, \'[ BrevisOne Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response);\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response) {\r\n                message += \': \' + response;\r\n            }\r\n\r\n            throw message + \'. Check debug log for more information.\';\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value);\r\n\r\n    [\'endpoint\', \'password\', \'username\', \'text\', \'send_to\'].forEach(function (field) {\r\n        if (typeof params !== \'object\' || typeof params[field] === \'undefined\'\r\n                || !params[field].trim()) {\r\n            throw \'Required parameter is not set: "\' + field + \'".\';\r\n        }\r\n    });\r\n\r\n    if (params.send_to === \'{ALERT.SENDTO}\') {\r\n        throw \'Required parameter is not set: "send_to".\';\r\n    }\r\n\r\n    BrevisOne.setProxy(params.HTTPProxy);\r\n    BrevisOne.setPayload(params);\r\n    BrevisOne.request();\r\n\r\n    return \'OK\';\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ BrevisOne Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('30','4','Express.ms','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Express = {\r\n    params: [],\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Express.params = params;\r\n\r\n        if (typeof Express.params.url === \'string\' && !Express.params.url.endsWith(\'/\')) {\r\n            Express.params.url += \'/\';\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        Express.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    request: function (query, data) {\r\n        var response,\r\n            url = Express.params.url + query,\r\n            request = new HttpRequest();\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'Authorization: Bearer \' + Express.params.token);\r\n\r\n        if (typeof Express.HTTPProxy !== \'undefined\' && Express.HTTPProxy !== \'\') {\r\n            request.setProxy(Express.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ Express Webhook ] Sending request: \' + url +\r\n            ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        response = request.post(url, data);\r\n\r\n        Zabbix.log(4, \'[ Express Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ Express Webhook ] Failed to parse response received from Express\');\r\n                response = {};\r\n            }\r\n        }\r\n\r\n        if (response.status !== \'ok\') {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (typeof response.reason !== \'undefined\') {\r\n                message += \': \' + JSON.stringify(response.reason);\r\n            }\r\n\r\n            throw message + \'. Check debug log for more information.\';\r\n        }\r\n\r\n        return response.result;\r\n    },\r\n\r\n    postMessage: function (is_problem) {\r\n        var data,\r\n            url,\r\n            result = {tags: {}},\r\n            response;\r\n\r\n        if (is_problem) {\r\n            data = {\r\n                group_chat_id: Express.params.send_to,\r\n                notification: {\r\n                    status: \'ok\',\r\n                    body: Express.params.message\r\n                }\r\n            };\r\n            url = \'api/v3/botx/notification/callback/direct\';\r\n        }\r\n        else {\r\n            data = {\r\n                reply: {\r\n                    status: \'ok\',\r\n                    body: Express.params.message\r\n                }\r\n            };\r\n            url = \'api/v3/botx/events/reply_event\';\r\n\r\n            try {\r\n                var tags = JSON.parse(Express.params.tags);\r\n            }\r\n            catch (error) {\r\n                throw \'Value of "express_tags" is not JSON. Value: \' + Express.params.tags + \'.\';\r\n            }\r\n\r\n            tags.forEach(function(tag) {\r\n                if (tag.tag === \'__zbx_ex_sync_id_\' + Express.params.send_to) {\r\n                    data.source_sync_id = tag.value;\r\n                }\r\n            });\r\n\r\n            if (!data.source_sync_id) {\r\n                throw \'Cannot update data. sync_id for the provided sender is unknown.\';\r\n            }\r\n        }\r\n\r\n        response = Express.request(url, data);\r\n\r\n        if (is_problem && response.sync_id) {\r\n            result.tags[\'__zbx_ex_sync_id_\' + Express.params.send_to] = response.sync_id;\r\n\r\n            return JSON.stringify(result);\r\n        }\r\n        else {\r\n            return \'OK\';\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        express = {},\r\n        required_params = [\r\n            \'express_url\', \'express_send_to\', \'express_message\', \'express_tags\', \'express_token\',\r\n            \'event_source\', \'event_value\', \'event_update_status\'\r\n        ];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'express_\')) {\r\n                express[key.substring(8)] = params[key];\r\n            }\r\n\r\n            if (required_params.indexOf(key) !== -1\r\n                    && (params[key].trim() === \'\' || params[key] === \'{ALERT.SENDTO}\')) {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Forcing event_value and event_update_status for non trigger-based events.\r\n    if (params.event_source !== \'0\' ) {\r\n        params.event_value = \'1\';\r\n        params.event_update_status = \'0\';\r\n    }\r\n\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\') {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    Express.setParams(express);\r\n    Express.setProxy(params.HTTPProxy);\r\n\r\n    return Express.postMessage(params.event_value === \'1\' && params.event_update_status === \'0\');\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ Express Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','0','','','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('31','4','ManageEngine ServiceDesk','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var MEngine = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        MEngine.params = params;\r\n        if (typeof MEngine.params.url === \'string\') {\r\n            if (!MEngine.params.url.endsWith(\'/\')) {\r\n                MEngine.params.url += \'/\';\r\n            }\r\n\r\n            MEngine.params.url += \'api/v3/\';\r\n        }\r\n\r\n        if (MEngine.params.on_premise.toLowerCase() !== \'true\'\r\n                && typeof MEngine.params.on_demand_url_auth === \'string\') {\r\n            if (!MEngine.params.on_demand_url_auth.endsWith(\'/\')) {\r\n                MEngine.params.on_demand_url_auth += \'/\';\r\n            }\r\n\r\n            MEngine.params.on_demand_url_auth += \'oauth/v2/token?\';\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        MEngine.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    createLink: function (id, url) {\r\n        return url + (url.endsWith(\'/\') ? \'\' : \'/\') +\r\n            ((MEngine.params.on_premise.toLowerCase() === \'true\')\r\n                ? (\'WorkOrder.do?woMode=viewWO&woID=\' + id)\r\n                : (\'app/itdesk/ui/requests/\' + id + \'/details\')\r\n            );\r\n    },\r\n\r\n    refreshAccessToken: function () {\r\n        [\r\n            \'on_demand_url_auth\',\r\n            \'on_demand_refresh_token\',\r\n            \'on_demand_client_id\',\r\n            \'on_demand_client_secret\'\r\n        ].forEach(function (field) {\r\n            if (typeof MEngine.params !== \'object\' || typeof MEngine.params[field] === \'undefined\'\r\n                    || MEngine.params[field].trim() === \'\' ) {\r\n                throw \'Required MEngine param is not set: "sd_\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            request = new HttpRequest(),\r\n            url = MEngine.params.on_demand_url_auth +\r\n                \'refresh_token=\' + encodeURIComponent(MEngine.params.on_demand_refresh_token) +\r\n                \'&grant_type=refresh_token&client_id=\' + encodeURIComponent(MEngine.params.on_demand_client_id) +\r\n                \'&client_secret=\' + encodeURIComponent(MEngine.params.on_demand_client_secret) +\r\n                \'&redirect_uri=https://www.zoho.com&scope=SDPOnDemand.requests.ALL\';\r\n\r\n        if (MEngine.HTTPProxy) {\r\n            request.setProxy(MEngine.HTTPProxy);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ ManageEngine Webhook ] Refreshing access token. Request: \' + url);\r\n\r\n        response = request.post(url);\r\n\r\n        Zabbix.log(4, \'[ ManageEngine Webhook ] Received response with status code \' +\r\n        request.getStatus() + \'\\n\' + response);\r\n\r\n        try {\r\n            response = JSON.parse(response);\r\n        }\r\n        catch (error) {\r\n            Zabbix.log(4, \'[ ManageEngine Webhook ] Failed to parse response received from Zoho Accounts\');\r\n        }\r\n\r\n        if ((request.getStatus() < 200 || request.getStatus() >= 300) && !response.access_token) {\r\n            throw \'Access token refresh failed with HTTP status code \' + request.getStatus() +\r\n                \'. Check debug log for more information.\';\r\n        }\r\n        else {\r\n            MEngine.params.on_demand_auth_token = response.access_token;\r\n        }\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        var response,\r\n            url = MEngine.params.url + query,\r\n            input,\r\n            request = new HttpRequest(),\r\n            message;\r\n\r\n        if (MEngine.params.on_premise.toLowerCase() === \'true\') {\r\n            request.addHeader(\'TECHNICIAN_KEY: \' + MEngine.params.on_premise_auth_token);\r\n        }\r\n        else {\r\n            request.addHeader(\'Authorization: Zoho-oauthtoken \' + MEngine.params.on_demand_auth_token);\r\n            request.addHeader(\'Accept: application/v3+json\');\r\n        }\r\n\r\n        if (MEngine.HTTPProxy) {\r\n            request.setProxy(MEngine.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        input = \'input_data=\' + encodeURIComponent(data);\r\n        Zabbix.log(4, \'[ ManageEngine Webhook ] Sending request: \' + url + \'?\' + input);\r\n\r\n        switch (method) {\r\n            case \'post\':\r\n                response = request.post(url, input);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, input);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ ManageEngine Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response);\r\n\r\n        try {\r\n            response = JSON.parse(response);\r\n        }\r\n        catch (error) {\r\n            Zabbix.log(4, \'[ ManageEngine Webhook ] Failed to parse response received from ManageEngine\');\r\n        }\r\n\r\n        if ((request.getStatus() < 200 || request.getStatus() >= 300)\r\n                && typeof response.response_status !== \'object\') {\r\n            throw \'Request failed with HTTP status code \' + request.getStatus() +\r\n                \'. Check debug log for more information.\';\r\n        }\r\n        else if (typeof response.response_status === \'object\' && response.response_status.status === \'failed\') {\r\n            message = \'Request failed with status_code \';\r\n\r\n            if (typeof response.response_status.messages === \'object\'\r\n                    && response.response_status.messages[0]\r\n                    && response.response_status.messages[0].message) {\r\n                message += response.response_status.messages[0].status_code +\r\n                    \'. Message: \' + response.response_status.messages[0].message;\r\n            }\r\n            else {\r\n                message += response.response_status.status_code;\r\n            }\r\n\r\n            message += \'. Check debug log for more information.\';\r\n            throw message;\r\n        }\r\n        else if (response.request) {\r\n            return response.request.id;\r\n        }\r\n    },\r\n\r\n    createPaylaod: function (fields, isNote) {\r\n        var data = {},\r\n            result;\r\n\r\n        if (isNote) {\r\n            data.description = fields[\'field_string:description\'].replace(/(?:\\r\\n|\\r|\\n)/g, \'<br>\');\r\n            result = {request_note: data};\r\n        }\r\n        else {\r\n            Object.keys(fields)\r\n                .forEach(function(field) {\r\n                    if (fields[field].trim() === \'\') {\r\n                        Zabbix.log(4, \'[ ManageEngine Webhook ] Field "\' + field +\r\n                            \'" can\\\'t be empty. The field ignored.\');\r\n                    }\r\n                    else {\r\n                        try {\r\n                            var prefix = field.split(\':\')[0],\r\n                                root;\r\n\r\n                            if  (prefix.startsWith(\'udf_\') && !data.udf_fields) {\r\n                                data.udf_fields = {};\r\n                                root = data.udf_fields;\r\n                            }\r\n                            else if (prefix.startsWith(\'udf_\')) {\r\n                                root = data.udf_fields;\r\n                            }\r\n                            else {\r\n                                root = data;\r\n                            }\r\n\r\n                            if (prefix.endsWith(\'string\')) {\r\n                                root[field.substring(field.indexOf(\':\') + 1)\r\n                                    .toLowerCase()] = fields[field];\r\n                            }\r\n                            else {\r\n                                root[field.substring(field.indexOf(\':\') + 1)\r\n                                    .toLowerCase()] = {\r\n                                    name: fields[field]\r\n                                };\r\n                            }\r\n                        }\r\n                        catch (error) {\r\n                            Zabbix.log(4, \'[ ManageEngine Webhook ] Can\\\'t parse field "\' + field +\r\n                                \'". The field ignored.\');\r\n                        }\r\n                    }\r\n                });\r\n            if (data.description) {\r\n                data.description = data.description.replace(/(?:\\r\\n|\\r|\\n)/g, \'<br>\');\r\n            }\r\n\r\n            result = {request: data};\r\n        }\r\n\r\n        return result;\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        sd = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'sd_on_premise\', \'field_string:subject\', \'field_string:description\',\r\n            \'event_recovery_value\', \'event_source\', \'event_value\', \'event_update_status\'\r\n        ],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'sd_\')) {\r\n                sd[key.substring(3)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'field_\') || key.startsWith(\'udf_field_\')) {\r\n                fields[key] = params[key];\r\n            }\r\n\r\n            if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    if (params.event_update_status === \'1\' && (typeof params.sd_request_id === \'undefined\'\r\n            || params.sd_request_id.trim() === \'\'\r\n            || params.sd_request_id === \'{EVENT.TAGS.__zbx_sd_request_id}\')) {\r\n        throw \'Parameter "sd_request_id" can\\\'t be empty for update operation.\';\r\n    }\r\n\r\n    MEngine.setParams(sd);\r\n    MEngine.setProxy(params.HTTPProxy);\r\n\r\n    if (MEngine.params.on_premise.toLowerCase() !== \'true\') {\r\n        MEngine.refreshAccessToken();\r\n    }\r\n\r\n    // Create issue for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_recovery_value !== \'0\') {\r\n        fields[\'field_object:priority\'] = params[\'priority_\' + severities[params.event_nseverity].name]\r\n        || \'Normal\';\r\n\r\n        MEngine.request(\'post\', \'requests\', MEngine.createPaylaod(fields));\r\n    }\r\n    // Create issue for trigger-based events.\r\n    else if (params.event_value === \'1\' && params.event_update_status === \'0\') {\r\n        fields[\'field_object:priority\'] = params[\'priority_\' + severities[params.event_nseverity].name]\r\n        || \'Normal\';\r\n\r\n        var id = MEngine.request(\'post\', \'requests\', MEngine.createPaylaod(fields));\r\n\r\n        result.tags.__zbx_sd_request_id = id;\r\n        result.tags.__zbx_sd_request_link = MEngine.createLink(id, params.sd_url);\r\n    }\r\n    // Update created issue for trigger-based event.\r\n    else {\r\n        if (params.event_update_status === \'1\') {\r\n            MEngine.request(\'post\', \'requests/\' + params.sd_request_id + \'/notes\',\r\n                MEngine.createPaylaod(fields, true)\r\n            );\r\n        }\r\n        delete fields[\'field_string:description\'];\r\n        MEngine.request(\'put\', \'requests/\' + params.sd_request_id, MEngine.createPaylaod(fields));\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ ManageEngine Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_sd_request_link}','ManageEngine: {EVENT.TAGS.__zbx_sd_request_id}','');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('1','5','zabbix_url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('2','5','bot_token','<YOUR BOT TOKEN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('3','5','mattermost_url','<YOUR MATTERMOST URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('4','5','send_mode','alarm');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('5','5','send_to','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('6','5','event_tags','{EVENT.TAGS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('8','5','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('10','5','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('11','5','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('12','5','event_date','{EVENT.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('13','5','event_time','{EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('14','5','event_severity','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('15','5','event_opdata','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('16','5','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('18','5','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('19','5','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('20','5','host_name','{HOST.HOST}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('21','5','host_ip','{HOST.IP}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('22','5','event_update_date','{EVENT.UPDATE.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('23','5','event_update_time','{EVENT.UPDATE.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('24','5','event_recovery_date','{EVENT.RECOVERY.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('25','5','event_recovery_time','{EVENT.RECOVERY.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('37','6','zbxurl','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('39','7','token','<put your key>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('40','7','eventid','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('41','7','eventname','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('42','7','hostname','{HOST.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('43','7','hostip','{HOST.IP}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('44','7','severity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('45','7','triggerdesc','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('46','7','triggeropdata','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('47','7','eventtags','{EVENT.TAGS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('48','7','triggerid','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('49','7','eventdate','{EVENT.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('50','7','eventtime','{EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('52','7','eventack','{EVENT.ACK.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('53','7','eventupdate','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('54','7','eventvalue','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('55','7','url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('56','8','token','<PUSHOVER TOKEN HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('57','8','user','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('58','8','message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('59','8','title','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('60','8','url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('61','8','url_title','Zabbix');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('63','8','eventid','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('64','8','triggerid','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('65','9','zabbix_url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('66','9','bot_token','<PLACE YOUR KEY HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('67','9','channel','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('68','9','slack_mode','alarm');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('69','9','slack_as_user','true');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('71','9','event_tags','{EVENT.TAGSJSON}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('73','9','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('75','9','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('76','9','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('77','9','event_date','{EVENT.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('78','9','event_time','{EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('79','9','event_severity','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('80','9','event_opdata','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('81','9','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('83','9','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('84','9','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('85','9','host_name','{HOST.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('87','9','event_update_date','{EVENT.UPDATE.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('88','9','event_update_time','{EVENT.UPDATE.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('89','9','event_recovery_date','{EVENT.RECOVERY.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('90','9','event_recovery_time','{EVENT.RECOVERY.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('91','10','zabbix_url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('92','10','discord_endpoint','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('93','10','use_default_message','false');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('94','10','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('95','10','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('96','10','event_name','{EVENT.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('97','10','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('98','10','event_severity','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('99','10','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('100','10','event_opdata','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('101','10','event_tags','{EVENT.TAGS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('102','10','event_time','{EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('103','10','event_date','{EVENT.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('104','10','event_recovery_date','{EVENT.RECOVERY.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('105','10','event_recovery_time','{EVENT.RECOVERY.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('106','10','event_update_date','{EVENT.UPDATE.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('107','10','event_update_time','{EVENT.UPDATE.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('108','10','event_update_action','{EVENT.UPDATE.ACTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('109','10','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('110','10','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('111','10','event_update_user','{USER.FULLNAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('112','10','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('113','10','host_ip','{HOST.IP}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('114','10','host_name','{HOST.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('115','10','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('116','10','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('117','8','endpoint','https://api.pushover.net/1/messages.json');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('118','8','retry','60');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('119','8','expire','1200');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('120','11','teamsecret','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('121','11','Subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('122','11','Message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('123','11','Severity','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('125','11','Hostname','{HOST.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('127','12','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('128','12','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('129','12','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('130','12','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('131','12','event_tags_json','{EVENT.TAGSJSON}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('132','12','event_update_action','{EVENT.UPDATE.ACTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('133','12','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('134','12','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('135','12','event_update_user','{USER.FULLNAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('136','12','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('137','12','jira_issue_key','{EVENT.TAGS.__zbx_jira_issuekey}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('138','12','jira_issue_type','<PLACE ISSUETYPE NAME>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('139','12','jira_password','<PLACE PASSWORD OR TOKEN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('140','12','jira_project_key','<PLACE PROJECT KEY>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('141','12','jira_url','<PLACE YOUR JIRA URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('142','12','jira_user','<PLACE LOGIN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('143','12','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('144','13','<\'DATETIME\' CUSTOMFIELD FOR EVENT RECOVERY TIME>','{EVENT.RECOVERY.DATE}T{EVENT.RECOVERY.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('145','13','<\'DATETIME\' CUSTOMFIELD FOR EVENT TIME>','{EVENT.DATE}T{EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('146','13','<\'NUMBER\' CUSTOMFIELD FOR EVENT.ID>','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('147','13','<\'NUMBER\' CUSTOMFIELD FOR TRIGGER.ID>','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('148','13','<\'STRING\' CUSTOMFIELD FOR HOST\\IP>','{HOST.HOST} [{HOST.IP}]');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('149','13','<\'STRING\' CUSTOMFIELD FOR OPERATIONAL DATA>','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('150','13','<\'STRING\' CUSTOMFIELD FOR SEVERITY>','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('151','13','<\'URL\' CUSTOMFIELD FOR EVENT URL>','{$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('152','13','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('153','13','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('154','13','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('155','13','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('156','13','event_tags_json','{EVENT.TAGSJSON}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('157','13','event_update_action','{EVENT.UPDATE.ACTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('158','13','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('159','13','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('160','13','event_update_user','{USER.FULLNAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('161','13','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('162','13','jira_issue_key','{EVENT.TAGS.__zbx_jira_issuekey}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('163','13','jira_issue_type','<PLACE ISSUETYPE NAME>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('164','13','jira_password','<PLACE PASSWORD OR TOKEN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('165','13','jira_project_key','<PLACE PROJECT KEY>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('166','13','jira_url','<PLACE YOUR JIRA URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('167','13','jira_user','<PLACE LOGIN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('168','13','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('169','14','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('170','14','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('171','14','event_date','{EVENT.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('172','14','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('173','14','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('174','14','event_opdata','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('175','14','event_recovery_date','{EVENT.RECOVERY.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('176','14','event_recovery_time','{EVENT.RECOVERY.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('177','14','event_severity','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('178','14','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('179','14','event_status','{EVENT.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('180','14','event_tags','{EVENT.TAGS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('181','14','event_time','{EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('182','14','event_update_action','{EVENT.UPDATE.ACTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('183','14','event_update_date','{EVENT.UPDATE.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('184','14','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('185','14','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('186','14','event_update_time','{EVENT.UPDATE.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('187','14','event_update_user','{USER.FULLNAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('188','14','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('189','14','host_ip','{HOST.IP}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('190','14','host_name','{HOST.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('191','14','teams_endpoint','<PLACE WEBHOOK URL HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('192','14','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('193','14','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('194','14','use_default_message','false');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('195','14','zabbix_url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('196','15','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('197','15','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('198','15','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('199','15','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('200','15','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('201','15','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('202','15','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('203','15','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('204','15','redmine_access_key','<PUT YOUR ACCESS KEY>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('205','15','redmine_issue_key','{EVENT.TAGS.__zbx_redmine_issue_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('206','15','redmine_project','<PUT YOUR PROJECT ID OR NAME>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('207','15','redmine_tracker_id','<PUT YOUR TRACKER ID>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('208','15','redmine_url','<PUT YOUR REDMINE URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('209','15','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('210','15','zabbix_url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('211','16','Message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('212','16','ParseMode','');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('213','16','Subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('214','16','To','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('215','16','Token','<PLACE YOUR TOKEN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('216','17','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('217','17','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('218','17','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('219','17','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('220','17','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('221','17','event_tags','{EVENT.TAGS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('222','17','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('223','17','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('224','17','severity_average','normal');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('225','17','severity_default','-');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('226','17','severity_disaster','urgent');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('227','17','severity_high','high');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('228','17','severity_information','low');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('229','17','severity_not_classified','low');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('230','17','severity_warning','normal');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('231','17','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('232','17','zbxurl','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('233','17','zendesk_issue_key','{EVENT.TAGS.__zbx_zdk_issuekey}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('234','17','zendesk_token','<put your {enduser_email_address}/token:{api_token}>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('235','17','zendesk_type','incident');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('236','17','zendesk_url','<put your Zendesk URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('237','18','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('238','18','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('239','18','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('240','18','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('241','18','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('242','18','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('243','18','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('244','18','servicenow_password','<PLACE PASSWORD HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('245','18','servicenow_sys_id','{EVENT.TAGS.__zbx_servicenow_sys_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('246','18','servicenow_url','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('247','18','servicenow_user','<PLACE USERNAME HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('248','18','urgency_for_average','2');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('249','18','urgency_for_disaster','1');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('250','18','urgency_for_high','2');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('251','18','urgency_for_information','3');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('252','18','urgency_for_not_classified','3');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('253','18','urgency_for_warning','3');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('254','19','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('255','19','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('256','19','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('257','19','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('258','19','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('259','19','event_tags','{EVENT.TAGSJSON}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('260','19','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('261','19','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('262','19','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('263','19','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('264','19','zabbix_url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('265','19','zammad_access_token','<PUT YOUR ACCESS TOKEN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('266','19','zammad_customer','<PUT YOUR CUSTOMER EMAIL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('267','19','zammad_enable_tags','true');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('268','19','zammad_ticket_id','{EVENT.TAGS.__zbx_zammad_ticket_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('269','19','zammad_url','<PUT YOUR ZAMMAD URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('270','20','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('271','20','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('272','20','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('273','20','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('274','20','event_tags_json','{EVENT.TAGSJSON}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('275','20','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('276','20','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('277','20','jira_password','<PLACE PASSWORD OR TOKEN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('278','20','jira_request_key','{EVENT.TAGS.__zbx_jira_requestkey}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('279','20','jira_request_type_id','<PLACE REQUEST TYPE ID>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('280','20','jira_servicedesk_id','<PLACE SERVICEDESK ID>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('281','20','jira_url','<PLACE YOUR JIRA URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('282','20','jira_user','<PLACE LOGIN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('283','21','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('284','21','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('285','21','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('286','21','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('287','21','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('288','21','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('289','21','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('290','21','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('291','21','otrs_auth_password','<PUT YOUR USER PASSWORD>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('292','21','otrs_auth_user','<PUT YOUR USER NAME>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('293','21','otrs_customer','<PUT YOUR CUSTOMER EMAIL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('294','21','otrs_default_priority_id','3');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('295','21','otrs_queue','<PUT YOUR QUEUE NAME>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('296','21','otrs_ticket_id','{EVENT.TAGS.__zbx_otrs_ticket_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('297','21','otrs_ticket_state','new');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('298','21','otrs_time_unit','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('299','21','otrs_url','<PUT YOUR OTRS URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('300','21','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('301','21','zabbix_url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('302','11','Event_Ack_Status','{EVENT.ACK.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('303','11','Event_Date_Time','{EVENT.DATE} {EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('304','11','Event_ID','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('305','11','Event_Update_Action','{EVENT.UPDATE.ACTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('306','11','Event_Update_Status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('307','11','Host_IP','{HOST.IP}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('308','11','Trigger_ID','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('309','11','Trigger_Status','{TRIGGER.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('310','11','User','{USER.FULLNAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('311','11','Zabbix_URL','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('312','10','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('313','22','.ILERT.ALERT.SOURCE.KEY','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('314','22','.ILERT.INCIDENT.SUMMARY','');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('315','22','ALERT.MESSAGE','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('316','22','ALERT.SUBJECT','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('317','22','EVENT.ACK.STATUS','{EVENT.ACK.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('318','22','EVENT.DATE','{EVENT.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('319','22','EVENT.ID','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('320','22','EVENT.NAME','{EVENT.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('321','22','EVENT.NSEVERITY','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('322','22','EVENT.OPDATA','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('323','22','EVENT.RECOVERY.DATE','{EVENT.RECOVERY.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('324','22','EVENT.RECOVERY.TIME','{EVENT.RECOVERY.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('325','22','EVENT.RECOVERY.VALUE','{EVENT.RECOVERY.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('326','22','EVENT.SEVERITY','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('327','22','EVENT.TAGS','{EVENT.TAGS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('328','22','EVENT.TIME','{EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('329','22','EVENT.UPDATE.ACTION','{EVENT.UPDATE.ACTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('330','22','EVENT.UPDATE.DATE','{EVENT.UPDATE.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('331','22','EVENT.UPDATE.MESSAGE','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('332','22','EVENT.UPDATE.STATUS','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('333','22','EVENT.UPDATE.TIME','{EVENT.UPDATE.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('334','22','EVENT.VALUE','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('335','22','HOST.HOST','{HOST.HOST}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('336','22','HOST.IP','{HOST.IP}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('337','22','HOST.NAME','{HOST.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('338','22','ITEM.ID1','{ITEM.ID1}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('339','22','ITEM.ID2','{ITEM.ID2}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('340','22','ITEM.ID3','{ITEM.ID3}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('341','22','ITEM.ID4','{ITEM.ID4}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('342','22','ITEM.ID5','{ITEM.ID5}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('343','22','ITEM.NAME1','{ITEM.NAME1}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('344','22','ITEM.NAME2','{ITEM.NAME2}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('345','22','ITEM.NAME3','{ITEM.NAME3}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('346','22','ITEM.NAME4','{ITEM.NAME4}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('347','22','ITEM.NAME5','{ITEM.NAME5}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('348','22','TRIGGER.DESCRIPTION','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('349','22','TRIGGER.ID','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('350','22','TRIGGER.NAME','{TRIGGER.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('351','22','TRIGGER.SEVERITY','{TRIGGER.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('352','22','TRIGGER.STATUS','{TRIGGER.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('353','22','TRIGGER.URL','{TRIGGER.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('354','22','TRIGGER.VALUE','{TRIGGER.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('355','22','USER.FULLNAME','{USER.FULLNAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('356','22','ZABBIX.URL','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('357','5','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('358','5','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('359','5','discovery_host_dns','{DISCOVERY.DEVICE.DNS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('360','5','discovery_host_ip','{DISCOVERY.DEVICE.IPADDRESS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('361','5','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('362','6','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('363','6','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('364','6','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('365','6','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('366','6','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('367','6','event_tags_json','{EVENT.TAGSJSON}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('368','6','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('369','6','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('370','6','opsgenie_api','<put your opsgenie api>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('371','6','opsgenie_tags','');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('372','6','opsgenie_teams','');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('373','6','opsgenie_token','<put your token>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('374','6','opsgenie_web','<put your opsgenie web>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('375','6','severity_average','P3');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('376','6','severity_default','P5');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('377','6','severity_disaster','P1');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('378','6','severity_high','P2');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('379','6','severity_information','P5');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('380','6','severity_not_classified','P5');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('381','6','severity_warning','P4');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('382','6','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('383','6','zbxuser','{USER.FULLNAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('384','7','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('385','7','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('386','8','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('387','8','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('388','8','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('389','8','priority_average','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('390','8','priority_default','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('391','8','priority_disaster','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('392','8','priority_high','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('393','8','priority_information','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('394','8','priority_not_classified','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('395','8','priority_warning','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('396','9','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('397','9','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('398','9','discovery_host_dns','{DISCOVERY.DEVICE.DNS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('399','9','discovery_host_ip','{DISCOVERY.DEVICE.IPADDRESS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('400','9','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('401','9','host_conn','{HOST.CONN}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('402','23','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('403','23','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('404','23','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('405','23','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('406','23','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('407','23','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('408','23','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('409','23','priority_average','Medium');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('410','23','priority_default','Low');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('411','23','priority_disaster','Critical');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('412','23','priority_high','High');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('413','23','samanage_incident_id','{EVENT.TAGS.__zbx_solarwinds_inc_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('414','23','samanage_token','<PUT YOUR TOKEN HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('415','23','samanage_url','<PUT YOUR INSTANCE URL HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('416','24','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('417','24','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('418','24','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('419','24','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('420','24','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('421','24','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('422','24','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('423','24','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('424','24','sysaid_auth_password','<PUT YOUR USER PASSWORD>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('425','24','sysaid_auth_user','<PUT YOUR USER NAME>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('426','24','sysaid_category_level_1','<PUT YOUR CATEGORY>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('427','24','sysaid_category_level_2','<PUT YOUR SUB-CATEGORY>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('428','24','sysaid_category_level_3','<PUT YOUR THIRD LEVEL CATEGORY>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('429','24','sysaid_default_priority_id','1');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('430','24','sysaid_incident_id','{EVENT.TAGS.__zbx_sysaid_incident_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('431','24','sysaid_incident_state','1');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('432','24','sysaid_template_id','<PUT YOUR TEMPLATE ID>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('433','24','sysaid_urgency_id','<PUT YOUR URGENCY ID>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('434','24','sysaid_url','<PUT YOUR SYSAID URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('435','24','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('436','24','zabbix_url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('437','25','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('438','25','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('439','25','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('440','25','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('441','25','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('442','25','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('443','25','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('444','25','severity_average','P3');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('445','25','severity_default','P5');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('446','25','severity_disaster','P1');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('447','25','severity_high','P2');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('448','25','severity_information','P5');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('449','25','severity_not_classified','P5');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('450','25','severity_warning','P4');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('451','25','topdesk_api','<put your TOPdesk API URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('452','25','topdesk_issue_key','{EVENT.TAGS.__zbx_tpd_issuekey}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('453','25','topdesk_password','<put your TOPdesk application password>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('454','25','topdesk_status','<put default status for new tickets>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('455','25','topdesk_user','<put your TOPdesk username>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('456','25','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('457','25','zbxurl','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('458','26','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('459','26','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('460','26','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('461','26','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('462','26','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('463','26','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('464','26','itop_api_version','1.3');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('465','26','itop_class','UserRequest');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('466','26','itop_comment','Created by Zabbix action {ACTION.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('467','26','itop_id','{EVENT.TAGS.__zbx_itop_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('468','26','itop_log','private_log');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('469','26','itop_organization_id','<PLACE ORGANIZATION ID>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('470','26','itop_password','<PLACE PASSWORD OR TOKEN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('471','26','itop_url','<PLACE YOUR ITOP URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('472','26','itop_user','<PLACE LOGIN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('473','27','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('474','27','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('475','27','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('476','27','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('477','27','event_update_action','{EVENT.UPDATE.ACTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('478','27','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('479','27','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('480','27','event_update_user','{USER.FULLNAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('481','27','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('482','27','field_1_full:Host','{HOST.NAME} [{HOST.IP}]');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('483','27','field_2_short:Severity','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('484','27','field_3_short:Event time','{EVENT.DATE} {EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('485','27','field_3_short_r:Recovery time','{EVENT.RECOVERY.DATE} {EVENT.RECOVERY.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('486','27','field_4_short_r:Event duration','{EVENT.DURATION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('487','27','field_5_short:Operational data','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('488','27','field_999_full_p:Trigger description','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('489','27','rc_api_url','api/v1/');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('490','27','rc_msg_id','{EVENT.TAGS.__zbx_rc_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('491','27','rc_room_id','{EVENT.TAGS.__zbx_rc_rid}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('492','27','rc_send_to','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('493','27','rc_title_link','{$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('494','27','rc_url','<PLACE YOUR INSTANCE URL HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('495','27','rc_user_id','<PLACE USER ID HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('496','27','rc_user_token','<PLACE TOKEN HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('497','27','use_default_message','false');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('498','28','event_info','{$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('499','28','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('500','28','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('501','28','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('502','28','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('503','28','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('504','28','field:entity_display_name','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('505','28','field:entity_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('506','28','field:hostname','{HOST.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('507','28','field:monitoring_tool','Zabbix');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('508','28','field:operational_data','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('509','28','field:severity','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('510','28','field:state_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('511','28','field_p:trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('512','28','field_r:event_duration','{EVENT.DURATION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('513','28','field_r:recovery time','{EVENT.RECOVERY.DATE} {EVENT.RECOVERY.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('514','28','priority_average','WARNING');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('515','28','priority_default','INFO');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('516','28','priority_disaster','CRITICAL');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('517','28','priority_high','WARNING');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('518','28','priority_information','INFO');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('519','28','priority_not_classified','INFO');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('520','28','priority_resolved','OK');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('521','28','priority_update','INFO');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('522','28','priority_warning','INFO');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('523','28','vops_endpoint','<PLACE ENDPOINT URL HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('524','28','vops_routing_key','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('525','29','endpoint','<PLACE HTTP API URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('526','29','flash','false');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('527','29','password','<PLACE PASSWORD>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('528','29','ring','false');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('529','29','send_to','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('530','29','telauto','true');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('531','29','text','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('532','29','username','<PLACE USERNAME>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('535','30','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('536','30','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('537','30','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('538','30','express_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('539','30','express_send_to','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('540','30','express_tags','{EVENT.TAGSJSON}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('541','30','express_token','<PLACE BOT TOKEN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('542','30','express_url','<PLACE INSTANCE URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('543','31','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('544','31','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('545','31','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('546','31','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('547','31','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('548','31','field_ref:requester','<PLACE API USER NAME>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('549','31','field_string:description','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('550','31','field_string:subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('551','31','priority_average','Normal');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('552','31','priority_default','Normal');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('553','31','priority_disaster','High');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('554','31','priority_high','High');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('555','31','priority_information','Low');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('556','31','priority_not_classified','Low');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('557','31','priority_warning','Medium');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('558','31','sd_on_demand_client_id','<PLACE ON DEMAND CLIENT ID>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('559','31','sd_on_demand_client_secret','<PLACE ON DEMAND CLIENT SECRET>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('560','31','sd_on_demand_refresh_token','<PLACE ON DEMAND REFRESH TOKEN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('561','31','sd_on_demand_url_auth','<PLACE AUTHENTICATION URL FOR ON DEMAND>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('562','31','sd_on_premise','true');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('563','31','sd_on_premise_auth_token','<PLACE ON PREMISE TECHNICIAN_KEY>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('564','31','sd_request_id','{EVENT.TAGS.__zbx_sd_request_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('565','31','sd_url','<PLACE INSTANCE URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('566','31','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('1','1','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('2','1','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('3','1','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('4','1','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('5','1','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('6','3','0','0','','{EVENT.SEVERITY}: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\n{EVENT.DATE} {EVENT.TIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('7','3','0','1','','Resolved in {EVENT.DURATION}: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\n{EVENT.DATE} {EVENT.TIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('8','3','0','2','','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem in {EVENT.AGE} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('9','3','1','0','','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('10','3','2','0','','Autoregistration: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('11','4','0','0','Problem: {EVENT.NAME}','<b>Problem started</b> at {EVENT.TIME} on {EVENT.DATE}<br><b>Problem name:</b> {EVENT.NAME}<br><b>Host:</b> {HOST.NAME}<br><b>Severity:</b> {EVENT.SEVERITY}<br><b>Operational data:</b> {EVENT.OPDATA}<br><b>Original problem ID:</b> {EVENT.ID}<br>{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('12','4','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<b>Problem has been resolved</b> at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}<br><b>Problem name:</b> {EVENT.NAME}<br><b>Problem duration:</b> {EVENT.DURATION}<br><b>Host:</b> {HOST.NAME}<br><b>Severity:</b> {EVENT.SEVERITY}<br><b>Original problem ID:</b> {EVENT.ID}<br>{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('13','4','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','<b>{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem</b> at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.<br>{EVENT.UPDATE.MESSAGE}<br><br><b>Current problem status:</b> {EVENT.STATUS}<br><b>Age:</b> {EVENT.AGE}<br><b>Acknowledged:</b> {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('14','4','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<b>Discovery rule:</b> {DISCOVERY.RULE.NAME}<br><br><b>Device IP:</b> {DISCOVERY.DEVICE.IPADDRESS}<br><b>Device DNS:</b> {DISCOVERY.DEVICE.DNS}<br><b>Device status:</b> {DISCOVERY.DEVICE.STATUS}<br><b>Device uptime:</b> {DISCOVERY.DEVICE.UPTIME}<br><br><b>Device service name:</b> {DISCOVERY.SERVICE.NAME}<br><b>Device service port:</b> {DISCOVERY.SERVICE.PORT}<br><b>Device service status:</b> {DISCOVERY.SERVICE.STATUS}<br><b>Device service uptime:</b> {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('15','4','2','0','Autoregistration: {HOST.HOST}','<b>Host name:</b> {HOST.HOST}<br><b>Host IP:</b> {HOST.IP}<br><b>Agent port:</b> {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('16','11','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('17','11','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('18','11','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('19','11','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('20','11','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('21','12','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('22','12','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('23','12','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('24','12','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('25','12','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('26','13','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('27','13','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('28','13','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('29','13','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('30','13','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('31','14','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('32','14','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('33','14','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('34','14','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('35','14','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('36','15','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('37','15','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('38','15','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('39','15','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('40','15','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('41','16','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('42','16','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('43','16','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('44','16','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('45','16','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('46','17','0','0','{EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('47','17','0','1','{EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('48','17','0','2','{EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('49','17','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('50','17','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('51','17','3','0','Internal problem: {EVENT.NAME}','Internal problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('52','18','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('53','18','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('54','18','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('55','18','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('56','18','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('57','19','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('58','19','0','1','Resolved: {EVENT.RECOVERY.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.RECOVERY.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('59','19','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('60','19','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('61','19','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('62','20','0','0','{EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('63','20','0','1','{EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('64','20','0','2','{EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('65','20','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('66','20','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('67','21','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('68','21','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('69','21','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('70','21','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('71','21','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('72','10','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('73','10','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('74','10','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('75','10','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('76','10','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('77','22','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('78','22','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('79','22','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('80','5','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('81','5','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('82','5','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('83','5','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('84','5','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('85','6','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('86','6','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('87','6','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('88','6','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('89','6','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('90','7','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('91','7','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('92','7','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('93','7','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('94','7','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('95','8','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('96','8','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('97','8','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('98','8','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('99','8','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('100','9','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('101','9','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('102','9','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('103','9','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('104','9','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('105','23','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n\r\nTrigger description: {TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('106','23','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('107','23','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('108','23','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('109','23','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('110','24','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('111','24','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('112','24','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('113','24','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('114','24','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('115','25','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('116','25','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('117','25','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('118','25','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('119','25','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('120','26','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('121','26','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('122','26','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('123','26','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('124','26','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('125','27','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('126','27','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('127','27','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('128','27','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('129','27','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('130','28','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('131','28','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('132','28','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('133','28','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('134','28','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('135','29','0','0','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}\r\nStarted at {EVENT.TIME} on {EVENT.DATE}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nEvent info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('136','29','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}\r\nResolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nEvent info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('137','29','0','2','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}\r\n\r\n{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('138','29','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}\r\nDiscovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('139','29','2','0','Autoregistration: {HOST.HOST}','Autoregistration: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('140','30','0','0','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}\r\nStarted at {EVENT.TIME} on {EVENT.DATE}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nEvent info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('141','30','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}\r\nResolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nEvent info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('142','30','0','2','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}\r\n\r\n{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('143','30','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}\r\nDiscovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('144','30','2','0','Autoregistration: {HOST.HOST}','Autoregistration: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('145','31','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('146','31','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('147','31','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('148','31','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('149','31','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `usrgrp` (`usrgrpid`,`name`,`gui_access`,`users_status`,`debug_mode`) values ('7','Zabbix administrators','0','0','0');
INSERT INTO `usrgrp` (`usrgrpid`,`name`,`gui_access`,`users_status`,`debug_mode`) values ('8','Guests','1','0','0');
INSERT INTO `usrgrp` (`usrgrpid`,`name`,`gui_access`,`users_status`,`debug_mode`) values ('9','Disabled','0','1','0');
INSERT INTO `usrgrp` (`usrgrpid`,`name`,`gui_access`,`users_status`,`debug_mode`) values ('11','Enabled debug mode','0','0','1');
INSERT INTO `usrgrp` (`usrgrpid`,`name`,`gui_access`,`users_status`,`debug_mode`) values ('12','No access to the frontend','3','0','0');
INSERT INTO `users_groups` (`id`,`usrgrpid`,`userid`) values ('2','8','2');
INSERT INTO `users_groups` (`id`,`usrgrpid`,`userid`) values ('3','9','2');
INSERT INTO `users_groups` (`id`,`usrgrpid`,`userid`) values ('4','7','1');
INSERT INTO `scripts` (`scriptid`,`name`,`command`,`host_access`,`usrgrpid`,`groupid`,`description`,`confirmation`,`type`,`execute_on`,`scope`,`port`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`menu_path`) values ('1','Ping','ping -c 3 {HOST.CONN}; case $? in [01]) true;; *) false;; esac','2',NULL,NULL,'','','0','2','2','','0','','','','','');
INSERT INTO `scripts` (`scriptid`,`name`,`command`,`host_access`,`usrgrpid`,`groupid`,`description`,`confirmation`,`type`,`execute_on`,`scope`,`port`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`menu_path`) values ('2','Traceroute','/usr/bin/traceroute {HOST.CONN}','2',NULL,NULL,'','','0','2','2','','0','','','','','');
INSERT INTO `scripts` (`scriptid`,`name`,`command`,`host_access`,`usrgrpid`,`groupid`,`description`,`confirmation`,`type`,`execute_on`,`scope`,`port`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`menu_path`) values ('3','Detect operating system','sudo /usr/bin/nmap -O {HOST.CONN}','2','7',NULL,'','','0','2','2','','0','','','','','');
INSERT INTO `actions` (`actionid`,`name`,`eventsource`,`evaltype`,`status`,`esc_period`,`formula`,`pause_suppressed`) values ('2','Auto discovery. Linux servers.','1','0','1','0','','1');
INSERT INTO `actions` (`actionid`,`name`,`eventsource`,`evaltype`,`status`,`esc_period`,`formula`,`pause_suppressed`) values ('3','Report problems to Zabbix administrators','0','0','1','1h','','1');
INSERT INTO `actions` (`actionid`,`name`,`eventsource`,`evaltype`,`status`,`esc_period`,`formula`,`pause_suppressed`) values ('4','Report not supported items','3','0','1','1h','','1');
INSERT INTO `actions` (`actionid`,`name`,`eventsource`,`evaltype`,`status`,`esc_period`,`formula`,`pause_suppressed`) values ('5','Report not supported low level discovery rules','3','0','1','1h','','1');
INSERT INTO `actions` (`actionid`,`name`,`eventsource`,`evaltype`,`status`,`esc_period`,`formula`,`pause_suppressed`) values ('6','Report unknown triggers','3','0','1','1h','','1');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('1','2','6','0','1','1','0','0');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('2','2','4','0','1','1','0','0');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('3','3','0','0','1','1','0','0');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('4','4','0','0','1','1','0','0');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('5','5','0','0','1','1','0','0');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('6','6','0','0','1','1','0','0');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('7','3','11','0','1','1','0','1');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('8','4','11','0','1','1','0','1');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('9','5','11','0','1','1','0','1');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('10','6','11','0','1','1','0','1');
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) values ('3','1','','',NULL);
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) values ('4','1','','',NULL);
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) values ('5','1','','',NULL);
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) values ('6','1','','',NULL);
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) values ('7','1','','',NULL);
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) values ('8','1','','',NULL);
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) values ('9','1','','',NULL);
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) values ('10','1','','',NULL);
INSERT INTO `opmessage_grp` (`opmessage_grpid`,`operationid`,`usrgrpid`) values ('1','3','7');
INSERT INTO `opmessage_grp` (`opmessage_grpid`,`operationid`,`usrgrpid`) values ('2','4','7');
INSERT INTO `opmessage_grp` (`opmessage_grpid`,`operationid`,`usrgrpid`) values ('3','5','7');
INSERT INTO `opmessage_grp` (`opmessage_grpid`,`operationid`,`usrgrpid`) values ('4','6','7');
INSERT INTO `opgroup` (`opgroupid`,`operationid`,`groupid`) values ('1','2','2');
INSERT INTO `conditions` (`conditionid`,`actionid`,`conditiontype`,`operator`,`value`,`value2`) values ('2','2','10','0','0','');
INSERT INTO `conditions` (`conditionid`,`actionid`,`conditiontype`,`operator`,`value`,`value2`) values ('3','2','8','0','9','');
INSERT INTO `conditions` (`conditionid`,`actionid`,`conditiontype`,`operator`,`value`,`value2`) values ('4','2','12','2','Linux','');
INSERT INTO `conditions` (`conditionid`,`actionid`,`conditiontype`,`operator`,`value`,`value2`) values ('6','4','23','0','0','');
INSERT INTO `conditions` (`conditionid`,`actionid`,`conditiontype`,`operator`,`value`,`value2`) values ('7','5','23','0','2','');
INSERT INTO `conditions` (`conditionid`,`actionid`,`conditiontype`,`operator`,`value`,`value2`) values ('8','6','23','0','4','');
INSERT INTO `config` (`configid`,`work_period`,`alert_usrgrpid`,`discovery_groupid`) values ('1','1-5,09:00-18:00','7','5');
INSERT INTO `graph_theme` (`graphthemeid`,`theme`,`backgroundcolor`,`graphcolor`,`gridcolor`,`maingridcolor`,`gridbordercolor`,`textcolor`,`highlightcolor`,`leftpercentilecolor`,`rightpercentilecolor`,`nonworktimecolor`,`colorpalette`) values ('1','blue-theme','FFFFFF','FFFFFF','CCD5D9','ACBBC2','ACBBC2','1F2C33','E33734','429E47','E33734','EBEBEB','1A7C11,F63100,2774A4,A54F10,FC6EA3,6C59DC,AC8C14,611F27,F230E0,5CCD18,BB2A02,5A2B57,89ABF8,7EC25C,274482,2B5429,8048B4,FD5434,790E1F,87AC4D,E89DF4');
INSERT INTO `graph_theme` (`graphthemeid`,`theme`,`backgroundcolor`,`graphcolor`,`gridcolor`,`maingridcolor`,`gridbordercolor`,`textcolor`,`highlightcolor`,`leftpercentilecolor`,`rightpercentilecolor`,`nonworktimecolor`,`colorpalette`) values ('2','dark-theme','2B2B2B','2B2B2B','454545','4F4F4F','4F4F4F','F2F2F2','E45959','59DB8F','E45959','333333','199C0D,F63100,2774A4,F7941D,FC6EA3,6C59DC,C7A72D,BA2A5D,F230E0,5CCD18,BB2A02,AC41A5,89ABF8,7EC25C,3165D5,79A277,AA73DE,FD5434,F21C3E,87AC4D,E89DF4');
INSERT INTO `graph_theme` (`graphthemeid`,`theme`,`backgroundcolor`,`graphcolor`,`gridcolor`,`maingridcolor`,`gridbordercolor`,`textcolor`,`highlightcolor`,`leftpercentilecolor`,`rightpercentilecolor`,`nonworktimecolor`,`colorpalette`) values ('3','hc-light','FFFFFF','FFFFFF','555555','000000','333333','000000','333333','000000','000000','EBEBEB','1A7C11,F63100,2774A4,A54F10,FC6EA3,6C59DC,AC8C14,611F27,F230E0,5CCD18,BB2A02,5A2B57,89ABF8,7EC25C,274482,2B5429,8048B4,FD5434,790E1F,87AC4D,E89DF4');
INSERT INTO `graph_theme` (`graphthemeid`,`theme`,`backgroundcolor`,`graphcolor`,`gridcolor`,`maingridcolor`,`gridbordercolor`,`textcolor`,`highlightcolor`,`leftpercentilecolor`,`rightpercentilecolor`,`nonworktimecolor`,`colorpalette`) values ('4','hc-dark','000000','000000','666666','888888','4F4F4F','FFFFFF','FFFFFF','FFFFFF','FFFFFF','333333','199C0D,F63100,2774A4,F7941D,FC6EA3,6C59DC,C7A72D,BA2A5D,F230E0,5CCD18,BB2A02,AC41A5,89ABF8,7EC25C,3165D5,79A277,AA73DE,FD5434,F21C3E,87AC4D,E89DF4');
INSERT INTO `globalmacro` (`globalmacroid`,`macro`,`value`,`description`,`type`) values ('2','{$SNMP_COMMUNITY}','public','','0');
INSERT INTO `regexps` (`regexpid`,`name`,`test_string`) values ('1','File systems for discovery','ext3');
INSERT INTO `regexps` (`regexpid`,`name`,`test_string`) values ('2','Network interfaces for discovery','eth0');
INSERT INTO `regexps` (`regexpid`,`name`,`test_string`) values ('3','Storage devices for SNMP discovery','/boot');
INSERT INTO `regexps` (`regexpid`,`name`,`test_string`) values ('4','Windows service names for discovery','SysmonLog');
INSERT INTO `regexps` (`regexpid`,`name`,`test_string`) values ('5','Windows service startup states for discovery','automatic');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('1','1','^(btrfs|ext2|ext3|ext4|reiser|xfs|ffs|ufs|jfs|jfs2|vxfs|hfs|apfs|refs|ntfs|fat32|zfs)$','3',',','0');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('3','3','^(Physical memory|Virtual memory|Memory buffers|Cached memory|Swap space)$','4',',','1');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('5','4','^(MMCSS|gupdate|SysmonLog|clr_optimization_v2.0.50727_32|clr_optimization_v4.0.30319_32)$','4',',','1');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('6','5','^(automatic|automatic delayed)$','3',',','1');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('7','2','^Software Loopback Interface','4',',','1');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('8','2','^(In)?[Ll]oop[Bb]ack[0-9._]*$','4',',','1');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('9','2','^NULL[0-9.]*$','4',',','1');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('10','2','^[Ll]o[0-9.]*$','4',',','1');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('11','2','^[Ss]ystem$','4',',','1');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('12','2','^Nu[0-9.]*$','4',',','1');
INSERT INTO `config_autoreg_tls` (`autoreg_tlsid`,`tls_psk_identity`,`tls_psk`) values ('1','','');
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('1','1','0','ui.default_access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('2','1','0','modules.default_access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('3','1','0','api.access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('4','1','0','actions.default_access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('5','2','0','ui.default_access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('6','2','0','modules.default_access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('7','2','0','api.access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('8','2','0','actions.default_access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('9','3','0','ui.default_access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('10','3','0','modules.default_access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('11','3','0','api.access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('12','3','0','actions.default_access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('13','4','0','ui.default_access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('14','4','0','modules.default_access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('15','4','0','api.access','0','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('16','4','0','actions.default_access','0','',NULL);
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10001',NULL,'Linux by Zabbix agent','3','-1','2','','','Linux by Zabbix agent','0',NULL,'Official Linux template. Requires agent of Zabbix 3.0.14, 3.4.5 and 4.0.0 or newer.\r\n\r\nKnown Issues:\r\n\r\n  Description: Network discovery. Zabbix agent as of 4.2 doesn\'t support items such as net.if.status, net.if.speed.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','f8f7908280354f2abeed07dc788c3747');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10047',NULL,'Zabbix server health','3','-1','2','','','Zabbix server health','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','e2d2b4e4ac28483996cc11fe42823d57');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10048',NULL,'Zabbix proxy health','3','-1','2','','','Zabbix proxy health','0',NULL,'Template tooling version used: 0.39','1','1','','','','','','1','0','0','dd114bf0fb2f46bc84840f1bb24e2b23');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10050',NULL,'Zabbix agent','3','-1','2','','','Zabbix agent','0',NULL,'Use this template for agents reachable from Zabbix server/proxy (passive mode).\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','8aa4557f6c3f4aadbc03447fca3af9f6');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10074',NULL,'OpenBSD','3','-1','2','','','OpenBSD','0',NULL,'','1','1','','','','','','1','0','0','760be6e1c2194a5bb7c0df47cc5f71ca');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10075',NULL,'FreeBSD','3','-1','2','','','FreeBSD','0',NULL,'','1','1','','','','','','1','0','0','a3dc630729e443139f4e608954fa6e19');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10076',NULL,'AIX','3','-1','2','','','AIX','0',NULL,'','1','1','','','','','','1','0','0','7e6bb0931a72459db9514aa924b420bc');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10077',NULL,'HP-UX','3','-1','2','','','HP-UX','0',NULL,'','1','1','','','','','','1','0','0','b1fd823d262042e08291313f72be9452');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10078',NULL,'Solaris','3','-1','2','','','Solaris','0',NULL,'','1','1','','','','','','1','0','0','eaf36c98b91843b7b79bd5184a23d377');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10079',NULL,'macOS','3','-1','2','','','macOS','0',NULL,'','1','1','','','','','','1','0','0','f895df5b37494f668cde1a2388d7af8b');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10081',NULL,'Windows by Zabbix agent','3','-1','2','','','Windows by Zabbix agent','0',NULL,'Official Windows template. Requires agent of Zabbix 4.4 and newer.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387224-discussion-thread-for-official-zabbix-template-for-windows\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','13b06904a6bf41cbb795e3193d896340');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10084',NULL,'Zabbix server','0','-1','2','','','Zabbix server','0',NULL,'','1','1','','','','','','1','0','0','');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10093',NULL,'FTP Service','3','-1','2','','','FTP Service','0',NULL,'','1','1','','','','','','1','0','0','3324b78f737e42fb8e6e05005c581b39');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10094',NULL,'HTTP Service','3','-1','2','','','HTTP Service','0',NULL,'','1','1','','','','','','1','0','0','ae6029df63724ff4a15819939ef74edd');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10095',NULL,'HTTPS Service','3','-1','2','','','HTTPS Service','0',NULL,'','1','1','','','','','','1','0','0','c3ca7daa5168458f8a00852652a7f99d');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10096',NULL,'IMAP Service','3','-1','2','','','IMAP Service','0',NULL,'','1','1','','','','','','1','0','0','dd0c49d976444f168535b9c1a2db981b');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10097',NULL,'LDAP Service','3','-1','2','','','LDAP Service','0',NULL,'','1','1','','','','','','1','0','0','736d92e82cfb48a592c8a976c45ef76f');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10098',NULL,'NNTP Service','3','-1','2','','','NNTP Service','0',NULL,'','1','1','','','','','','1','0','0','22c53db48be0472cb97209c74418cf16');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10099',NULL,'NTP Service','3','-1','2','','','NTP Service','0',NULL,'','1','1','','','','','','1','0','0','b28c13fdd0194ddcb5f6b18723a575ae');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10100',NULL,'POP Service','3','-1','2','','','POP Service','0',NULL,'','1','1','','','','','','1','0','0','e042c0e455f74e7eb2384c203edcb26e');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10101',NULL,'SMTP Service','3','-1','2','','','SMTP Service','0',NULL,'','1','1','','','','','','1','0','0','ea3cad7f70f9481ea85f797ef6ea684e');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10102',NULL,'SSH Service','3','-1','2','','','SSH Service','0',NULL,'','1','1','','','','','','1','0','0','0bbd5e407d7544b28a508e18db81c235');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10103',NULL,'Telnet Service','3','-1','2','','','Telnet Service','0',NULL,'','1','1','','','','','','1','0','0','7fc69c6afd334bcab0a133174983939f');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10169',NULL,'Generic Java JMX','3','-1','2','','','Generic Java JMX','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','72aab08f7f27406a8f2c291648e5ba95');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10171',NULL,'Intel SR1530 IPMI','3','-1','2','','','Intel SR1530 IPMI','0',NULL,'','1','1','','','','','','1','0','0','f01bd64eef4049fabe087cccae590226');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10172',NULL,'Intel SR1630 IPMI','3','-1','2','','','Intel SR1630 IPMI','0',NULL,'','1','1','','','','','','1','0','0','2327c665b46e4aa781d41240168c3867');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10173',NULL,'VMware','3','-1','2','','','VMware','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','56079badd056419383cc26e6a4fcc7e0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10174',NULL,'VMware Guest','3','-1','2','','','VMware Guest','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','7942fb93ae3b47cf9ca0ea4beb0675ce');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10175',NULL,'VMware Hypervisor','3','-1','2','','','VMware Hypervisor','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','5899b2f0aced4085b5ac25d0461b3425');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10183',NULL,'EtherLike-MIB SNMP','3','-1','2','','','EtherLike-MIB SNMP','0',NULL,'Template EtherLike-MIB (duplex control only)\r\n\r\nMIBs used:\r\nEtherLike-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','3598da1effdf4ed48074608f1422e3fd');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10185',NULL,'HOST-RESOURCES-MIB SNMP','3','-1','2','','','HOST-RESOURCES-MIB SNMP','0',NULL,'HOST-RESOURCES-MIB: CPU, memory and storage(vfs.fs.file) linked together.\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','5c70662d333246668444276cb011e646');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10186',NULL,'ICMP Ping','3','-1','2','','','ICMP Ping','0',NULL,'Template Module ICMP Ping\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','37e5eb5606bc4abba66c8b20381a1e8a');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10188',NULL,'Interfaces Simple SNMP','3','-1','2','','','Interfaces Simple SNMP','0',NULL,'Template Module Interfaces Simple (no ifXTable). This is the exact copy of Template Module Interfaces template with the exception that metrics from ifXTable are replaced with ifTable counters where possible. Use this template with devices where IF-MIB::ifXtable is not available. If supported by the host - use Template Module Interfaces template instead.\r\n\r\nMIBs used:\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: 32bit counters are used in this template (since there is no ifXtable available). If busy interfaces return incorrect bits sent/received - set update interval to 1m or less.\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','7cd8aaa8d18d4b22a79edfb769e839b3');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10190',NULL,'Interfaces SNMP','3','-1','2','','','Interfaces SNMP','0',NULL,'Template Module Interfaces\r\n\r\nMIBs used:\r\nIF-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','809cd59886464ff3ad0a66d16fb1f2d8');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10192',NULL,'Interfaces Windows SNMP','3','-1','2','','','Interfaces Windows SNMP','0',NULL,'Template Interfaces Windows\r\n\r\nMIBs used:\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: 32bit counters are used in this template (since 64bit are not supported by Windows OS). If busy interfaces return incorrect bits sent/received - set update interval to 1m or less.\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','d7af232ed629481e95d2df9952c519c8');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10204',NULL,'Generic SNMP','3','-1','2','','','Generic SNMP','0',NULL,'Template Module Generic\r\n\r\nMIBs used:\r\nSNMPv2-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','4cb1aabe2b704b5c882963c2ef87d8f6');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10207',NULL,'Alcatel Timetra TiMOS SNMP','3','-1','2','','','Alcatel Timetra TiMOS SNMP','0',NULL,'Template Net Alcatel Timetra TiMOS\r\n\r\nMIBs used:\r\nTIMETRA-CHASSIS-MIB\r\nTIMETRA-SYSTEM-MIB\r\nSNMPv2-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','53044571fb864d87af32473e08c76d0b');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10208',NULL,'Brocade FC SNMP','3','-1','2','','','Brocade FC SNMP','0',NULL,'Template Net Brocade FC\r\n\r\nMIBs used:\r\nSW-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: no IF-MIB::ifAlias is available\r\n  Version: v6.3.1c, v7.0.0c,  v7.4.1c\r\n  Device: all\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','de96d02bd5f242bfa31308ae2131d03f');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10209',NULL,'Brocade_Foundry Performance SNMP','3','-1','2','','','Brocade_Foundry Performance SNMP','0',NULL,'Template Module Brocade_Foundry Performance\r\n\r\nMIBs used:\r\nFOUNDRY-SN-AGENT-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','c55052212c774e3fbab00343050b3db5');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10210',NULL,'Brocade_Foundry Nonstackable SNMP','3','-1','2','','','Brocade_Foundry Nonstackable SNMP','0',NULL,'Template Net Brocade_Foundry Nonstackable\r\n\r\nMIBs used:\r\nFOUNDRY-SN-AGENT-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','6ecfb7083ddf45f183ab4be50cfba37a');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10211',NULL,'Brocade_Foundry Stackable SNMP','3','-1','2','','','Brocade_Foundry Stackable SNMP','0',NULL,'Template Brocade_Foundry Stackable\r\n\r\nMIBs used:\r\nFOUNDRY-SN-AGENT-MIB\r\nFOUNDRY-SN-STACKING-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Correct fan(returns fan status as \'other(1)\' and temperature (returns 0) for the non-master Switches are not available in SNMP\r\n  Version: Version 08.0.40b and above\r\n  Device: ICX 7750 in stack\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','f64ad01567914165a493815e492fb315');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10212',NULL,'Cisco CISCO-MEMORY-POOL-MIB SNMP','3','-1','2','','','Cisco CISCO-MEMORY-POOL-MIB SNMP','0',NULL,'Template Cisco CISCO-MEMORY-POOL-MIB\r\n\r\nMIBs used:\r\nCISCO-MEMORY-POOL-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','d7c122cde75447248d4b1613cdc25d5b');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10213',NULL,'Cisco CISCO-PROCESS-MIB SNMP','3','-1','2','','','Cisco CISCO-PROCESS-MIB SNMP','0',NULL,'Template Cisco CISCO-PROCESS-MIB\r\n\r\nMIBs used:\r\nCISCO-PROCESS-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','f934f5e71db642c689ed2f945f73ce6c');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10215',NULL,'Cisco OLD-CISCO-CPU-MIB SNMP','3','-1','2','','','Cisco OLD-CISCO-CPU-MIB SNMP','0',NULL,'Template Cisco OLD-CISCO-CPU-MIB\r\n\r\nMIBs used:\r\nOLD-CISCO-CPU-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','1b0025aaf71f47ec91d08c17a399c6a6');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10216',NULL,'Cisco Inventory SNMP','3','-1','2','','','Cisco Inventory SNMP','0',NULL,'Template Cisco Inventory\r\n\r\nMIBs used:\r\nENTITY-MIB\r\nSNMPv2-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','90c99055648f40df8517005a7670158c');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10217',NULL,'Cisco CISCO-ENVMON-MIB SNMP','3','-1','2','','','Cisco CISCO-ENVMON-MIB SNMP','0',NULL,'Template Cisco CISCO-ENVMON-MIB\r\n\r\nMIBs used:\r\nCISCO-ENVMON-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','51af5cf9312b41d38ab22e02c9af6bbc');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10218',NULL,'Cisco IOS SNMP','3','-1','2','','','Cisco IOS SNMP','0',NULL,'Template Cisco IOS Software releases 12.2(3.5) or later\r\n\r\nKnown Issues:\r\n\r\n  Description: no if(in|out)(Errors|Discards) are available for vlan ifType\r\n  Version: IOS for example: 12.1(22)EA11, 15.4(3)M2\r\n  Device: C2911, C7600\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','aa3ce9bd8c1d40a2b0f83f9e642e88ee');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10220',NULL,'Cisco IOS prior to 12.0_3_T SNMP','3','-1','2','','','Cisco IOS prior to 12.0_3_T SNMP','0',NULL,'Cisco IOS Software releases prior to 12.0(3)T\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','1bb42fbdb9054645a62ff81f14ba3b99');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10221',NULL,'Dell Force S-Series SNMP','3','-1','2','','','Dell Force S-Series SNMP','0',NULL,'Template Dell Force S-Series\r\n\r\nMIBs used:\r\nF10-S-SERIES-CHASSIS-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','e5ec7acc7efc4ac491b6fa552ab077ae');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10222',NULL,'D-Link DES 7200 SNMP','3','-1','2','','','D-Link DES 7200 SNMP','0',NULL,'Template D-Link DES 7200\r\n\r\nMIBs used:\r\nMY-PROCESS-MIB\r\nSNMPv2-MIB\r\nMY-MEMORY-MIB\r\nENTITY-MIB\r\nMY-SYSTEM-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','395184b5d5b048a68e06c91154c56847');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10223',NULL,'D-Link DES_DGS Switch SNMP','3','-1','2','','','D-Link DES_DGS Switch SNMP','0',NULL,'Template D-Link DES_DGS Switch\r\n\r\nMIBs used:\r\nDLINK-AGENT-MIB\r\nSNMPv2-MIB\r\nENTITY-MIB\r\nEQUIPMENT-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: D-Link reports missing PSU as fail(4)\r\n  Version: Firmware: 1.73R008,hardware revision: B1\r\n  Device: DGS-3420-26SC Gigabit Ethernet Switch\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','d3176749a5274264938f487cd89d17eb');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10224',NULL,'Extreme EXOS SNMP','3','-1','2','','','Extreme EXOS SNMP','0',NULL,'Template Extreme EXOS\r\n\r\nMIBs used:\r\nEXTREME-SOFTWARE-MONITOR-MIB\r\nEXTREME-SYSTEM-MIB\r\nENTITY-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','861dbdece18f4b8f85214a319995eb3e');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10226',NULL,'Network Generic Device SNMP','3','-1','2','','','Network Generic Device SNMP','0',NULL,'Template Net Network Generic Device\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','67332e679035423f85090aa985947c36');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10227',NULL,'HP Comware HH3C SNMP','3','-1','2','','','HP Comware HH3C SNMP','0',NULL,'Template Net HP Comware (HH3C)\r\n\r\nMIBs used:\r\nENTITY-MIB\r\nHH3C-ENTITY-EXT-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: No temperature sensors. All entities of them return 0 for HH3C-ENTITY-EXT-MIB::hh3cEntityExtTemperature\r\n  Version: 1910-48 Switch Software Version 5.20.99, Release 1116 Copyright(c)2010-2016 Hewlett Packard Enterprise Development LP\r\n  Device: HP 1910-48\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','57aeccd43b744942b9555269b79a96ad');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10229',NULL,'Huawei VRP SNMP','3','-1','2','','','Huawei VRP SNMP','0',NULL,'Template Net Huawei VRP\r\n\r\nMIBs used:\r\nHUAWEI-ENTITY-EXTENT-MIB\r\nENTITY-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','ad4c3dad4b7b492685d1fd3bd3a664f9');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10230',NULL,'Intel_Qlogic Infiniband SNMP','3','-1','2','','','Intel_Qlogic Infiniband SNMP','0',NULL,'Template Net Intel_Qlogic Infiniband\r\n\r\nMIBs used:\r\nICS-CHASSIS-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','6f7f2c44e13a46a4b219fbb5db92f3f7');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10231',NULL,'Juniper SNMP','3','-1','2','','','Juniper SNMP','0',NULL,'Template Net Juniper\r\n\r\nMIBs used:\r\nJUNIPER-ALARM-MIB\r\nJUNIPER-MIB\r\nSNMPv2-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','a326034825984bbd8a3a5885f3939bb3');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10233',NULL,'Mikrotik SNMP','3','-1','2','','','Mikrotik SNMP','0',NULL,'Template Net Mikrotik\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nMIKROTIK-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Doesn\'t have ifHighSpeed filled. fixed in more recent versions\r\n  Version: RouterOS 6.28 or lower\r\n\r\n  Description: Doesn\'t have any temperature sensors\r\n  Version: RouterOS 6.38.5\r\n  Device: Mikrotik 941-2nD, Mikrotik 951G-2HnD\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','815b5a81b29a477695fddbd533ad9c84');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10234',NULL,'Netgear Fastpath SNMP','3','-1','2','','','Netgear Fastpath SNMP','0',NULL,'Template Net Netgear Fastpath\r\n\r\nMIBs used:\r\nFASTPATH-SWITCHING-MIB\r\nFASTPATH-BOXSERVICES-PRIVATE-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','5920713da492452889adabc25e259caa');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10235',NULL,'QTech QSW SNMP','3','-1','2','','','QTech QSW SNMP','0',NULL,'Template Net QTech QSW\r\n\r\nMIBs used:\r\nQTECH-MIB\r\nENTITY-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','21f3e79e1d2e4f5e868d1ef81c94bbfd');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10236',NULL,'TP-LINK SNMP','3','-1','2','','','TP-LINK SNMP','0',NULL,'Template Net TP-LINK\r\n\r\nMIBs used:\r\nTPLINK-SYSINFO-MIB\r\nTPLINK-SYSMONITOR-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Default sysLocation, sysName and sysContact is not filled with proper data. Real hostname and location can be found only in private branch (TPLINK-SYSINFO-MIB). Please check whether this problem exists in the latest firmware: https://www.tp-link.com/en/support/download/t2600g-28ts/#Firmware\r\n  Version: 2.0.0 Build 20170628 Rel.55184 (Beta)\r\n  Device: T2600G-28TS 2.0\r\n\r\n  Description: The Serial number of the product (tpSysInfoSerialNum) is missing in HW versions prior to V2_170323\r\n  Version: Prior to version V2_170323\r\n  Device: T2600G-28TS 2.0\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','2b9039885edf45b8bdd39f16dd069133');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10237',NULL,'Ubiquiti AirOS SNMP','3','-1','2','','','Ubiquiti AirOS SNMP','0',NULL,'Template Net Ubiquiti AirOS\r\n\r\nMIBs used:\r\nIEEE802dot11-MIB\r\nFROGFOOT-RESOURCES-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: UBNT unifi reports speed: like IF-MIB::ifSpeed.1 = Gauge32: 4294967295 for all interfaces\r\n  Version: Firmware: BZ.ar7240.v3.7.51.6230.170322.1513\r\n  Device: UBNT UAP-LR\r\n\r\n  Description: UBNT AirMax(NanoStation, NanoBridge etc) reports ifSpeed: as 0 for VLAN and wireless(ath0) interfaces\r\n  Version: Firmware: XW.ar934x.v5.6-beta4.22359.140521.1836\r\n  Device: NanoStation M5\r\n\r\n  Description: UBNT AirMax(NanoStation, NanoBridge etc) reports always return ifType: as ethernet(6) even for wifi,vlans and other types\r\n  Version: Firmware: XW.ar934x.v5.6-beta4.22359.140521.1836\r\n  Device: NanoStation M5\r\n\r\n  Description: ifXTable is not provided in IF-MIB. So Interfaces Simple Template is used instead\r\n  Version: all above\r\n  Device: NanoStation, UAP-LR\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','6c235d126c1f4895acfe2156b140a886');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10248',NULL,'Linux SNMP','3','-1','2','','','Linux SNMP','0',NULL,'Template OS Linux\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','4d3a7adbb6964bd08f2b9d28e0da6496');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10249',NULL,'Windows SNMP','3','-1','2','','','Windows SNMP','0',NULL,'Official Windows SNMP template. Requires Zabbix server 4.0.14, 4.2.8, 4.4.0 or newer (JSONPath function avg() used with types autoconversion).\r\n\r\n\r\nKnown Issues:\r\n\r\n  Description: Doesn\'t support In/Out 64 bit counters even though IfxTable is present:\r\nCurrently, Windows gets it\'s interface status from MIB-2. Since these 64bit SNMP counters (ifHCInOctets, ifHCOutOctets, etc.) are defined as an extension to IF-MIB, Microsoft has not implemented it.\r\nhttps://social.technet.microsoft.com/Forums/windowsserver/en-US/07b62ff0-94f6-40ca-a99d-d129c1b33d70/windows-2008-r2-snmp-64bit-counters-support?forum=winservergen\r\n\r\n  Version: Win2008, Win2012R2.\r\n\r\n  Description: Doesn\'t support ifXTable at all\r\n  Version: WindowsXP\r\n\r\n  Description: EtherLike MIB is not supported\r\n  Version: *\r\n  Device: *\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','f9a59315c8944853bb91c0a9ec3056d7');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10250',NULL,'HP Enterprise Switch SNMP','3','-1','2','','','HP Enterprise Switch SNMP','0',NULL,'Template Net HP Enterprise Switch\r\n\r\nMIBs used:\r\nSEMI-MIB\r\nNETSWITCH-MIB\r\nHP-ICF-CHASSIS\r\nENTITY-SENSORS-MIB\r\nENTITY-MIB\r\nSTATISTICS-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','cce20a5d149a48b7ac7f5383c3510883');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10251',NULL,'Mellanox SNMP','3','-1','2','','','Mellanox SNMP','0',NULL,'The updated template for monitoring the Mellanox network switches over SNMP agent. All items collected in one template without any linked templates.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nENTITY-SENSORS-MIB\r\nENTITY-STATE-MIB\r\nENTITY-MIB\r\nIF-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','a60798c651604d93a062bec0f8a89751');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10252',NULL,'Cisco CISCO-PROCESS-MIB IOS versions 12.0_3_T-12.2_3.5 SNMP','3','-1','2','','','Cisco CISCO-PROCESS-MIB IOS versions 12.0_3_T-12.2_3.5 SNMP','0',NULL,'Template Module Cisco CISCO-PROCESS-MIB IOS versions 12.0_3_T-12.2_3.5\r\n\r\nMIBs used:\r\nCISCO-PROCESS-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','3eadb8a2ad4a479cb59bfa6402deee3f');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10253',NULL,'Cisco IOS versions 12.0_3_T-12.2_3.5 SNMP','3','-1','2','','','Cisco IOS versions 12.0_3_T-12.2_3.5 SNMP','0',NULL,'Cisco IOS Software releases later to 12.0(3)T and prior to 12.2(3.5)\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','40c233aaa3424fd29dc378022ff3461d');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10254',NULL,'Arista SNMP','3','-1','2','','','Arista SNMP','0',NULL,'Template Net Arista\r\n\r\nMIBs used:\r\nENTITY-SENSORS-MIB\r\nENTITY-STATE-MIB\r\nENTITY-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','26674f62500e4e79b9f470bbf962130d');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10255',NULL,'Dell iDRAC SNMP','3','-1','2','','','Dell iDRAC SNMP','0',NULL,'Template Server iDRAC\r\n\r\nMIBs used:\r\nIDRAC-MIB-SMIv2\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','43dc5c8a9a0e4786b64e44422c7f32b4');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10256',NULL,'HP iLO SNMP','3','-1','2','','','HP iLO SNMP','0',NULL,'Template Server HP iLO\r\n\r\nMIBs used:\r\nCPQSINFO-MIB\r\nCPQHLTH-MIB\r\nCPQIDA-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','c2a7ddca051d4b4a9553f339c57e47a9');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10258',NULL,'IBM IMM SNMP','3','-1','2','','','IBM IMM SNMP','0',NULL,'Template Server IBM IMM\r\n\r\nMIBs used:\r\nIMM-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Some IMMs (IMM1) do not return disks\r\n  Version: IMM1\r\n  Device: IBM x3250M3\r\n\r\n  Description: Some IMMs (IMM1) do not return fan status: fanHealthStatus\r\n  Version: IMM1\r\n  Device: IBM x3250M3\r\n\r\n  Description: IMM1 servers (M2, M3 generations) sysObjectID is NET-SNMP-MIB::netSnmpAgentOIDs.10\r\n  Version: IMM1\r\n  Device: IMM1 servers (M2,M3 generations)\r\n\r\n  Description: IMM1 servers (M2, M3 generations) only Ambient temperature sensor available\r\n  Version: IMM1\r\n  Device: IMM1 servers (M2,M3 generations)\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','c9e1acd3ae4a427ab39724b6bcaf839e');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10259',NULL,'Supermicro Aten SNMP','3','-1','2','','','Supermicro Aten SNMP','0',NULL,'Template Server Supermicro Aten\r\n\r\nMIBs used:\r\nATEN-IPMI-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','cf0947cc05d3450b9a6d66b2eb180482');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10260',NULL,'Apache Tomcat by JMX','3','-1','2','','','Apache Tomcat by JMX','0',NULL,'The template to monitor Apache Tomcat by Zabbix that work without any external scripts.\r\nThe metrics are collected by JMX.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/411862-discussion-thread-for-official-zabbix-template-tomcat\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','3cc8c9ae7055458c9a803597007f70bd');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10261',NULL,'Remote Zabbix server health','3','-1','2','','','Remote Zabbix server health','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','79b16cbbe593444eae3de66de0cb566b');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10262',NULL,'Remote Zabbix proxy health','3','-1','2','','','Remote Zabbix proxy health','0',NULL,'Template tooling version used: 0.39','1','1','','','','','','1','0','0','970c2342146549768e6b91a26089bcdf');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10264',NULL,'Apache by Zabbix agent','3','-1','2','','','Apache by Zabbix agent','0',NULL,'Get metrics from mod_status module using HTTP agent.\r\nhttps://httpd.apache.org/docs/current/mod/mod_status.html\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384764-discussion-thread-for-official-zabbix-template-apache\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','a8d91e4f36794e32b73090d5edf3d7ae');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10265',NULL,'Apache by HTTP','3','-1','2','','','Apache by HTTP','0',NULL,'Get metrics from mod_status module using HTTP agent.\r\nhttps://httpd.apache.org/docs/current/mod/mod_status.html\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384764-discussion-thread-for-official-zabbix-template-apache\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','86702e8bc514434e8c914d50c206cb94');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10266',NULL,'Nginx by Zabbix agent','3','-1','2','','','Nginx by Zabbix agent','0',NULL,'Get metrics from stub status module using Zabbix agent running on Linux\r\nhttps://nginx.ru/en/docs/http/ngx_http_stub_status_module.html\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384765-discussion-thread-for-official-zabbix-template-nginx\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','27f6424905884dbb96ab9210d987a56c');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10267',NULL,'Nginx by HTTP','3','-1','2','','','Nginx by HTTP','0',NULL,'Get metrics from stub status module using HTTP agent\r\nhttps://nginx.ru/en/docs/http/ngx_http_stub_status_module.html.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384765-discussion-thread-for-official-zabbix-template-nginx\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','13d5bb0a4ae84228bff408aab5be338e');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10268',NULL,'Linux memory SNMP','3','-1','2','','','Linux memory SNMP','0',NULL,'MIBs used:\r\nUCD-SNMP-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Please note that memory utilization is a rough estimate, since memory available is calculated as free+buffers+cached, which is not 100% accurate, but the best we can get using SNMP.\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','443e4897fb0a4eef9d4624a3baa8f174');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10269',NULL,'Linux block devices SNMP','3','-1','2','','','Linux block devices SNMP','0',NULL,'MIBs used:\r\nUCD-DISKIO-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','8278f5e79ef2420cab500a147cc72009');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10270',NULL,'Linux CPU SNMP','3','-1','2','','','Linux CPU SNMP','0',NULL,'MIBs used:\r\nHOST-RESOURCES-MIB\r\nUCD-SNMP-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','f55b1b1c10a44fe8aef0631f6f41b86d');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10271',NULL,'Linux filesystems SNMP','3','-1','2','','','Linux filesystems SNMP','0',NULL,'MIBs used:\r\nHOST-RESOURCES-MIB\r\nUCD-SNMP-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','cbaf0383cb934294ac53a28ddfd49434');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10272',NULL,'Linux CPU by Zabbix agent','3','-1','2','','','Linux CPU by Zabbix agent','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','d4e080814aad467dbf6b95c46b862c28');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10273',NULL,'Linux filesystems by Zabbix agent','3','-1','2','','','Linux filesystems by Zabbix agent','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','fdcdd5810fba49928922a683d32aa76f');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10274',NULL,'Linux memory by Zabbix agent','3','-1','2','','','Linux memory by Zabbix agent','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','06c211e947414638bd00e555e206d03d');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10275',NULL,'Linux block devices by Zabbix agent','3','-1','2','','','Linux block devices by Zabbix agent','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','45486dbbf5bf49f28866fcb212731cf0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10276',NULL,'Linux network interfaces by Zabbix agent','3','-1','2','','','Linux network interfaces by Zabbix agent','0',NULL,'Known Issues:\r\n\r\n  Description: High interface utilization trigger is removed since currently it is not possible to retrieve interface speed to determine the max bandwidth.\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','18ecfb2a7e754315bb8d7f71917153da');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10277',NULL,'Linux generic by Zabbix agent','3','-1','2','','','Linux generic by Zabbix agent','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','38f973ee1556494fadeacb2f6b1ec987');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10285',NULL,'Linux by Prom','3','-1','2','','','Linux by Prom','0',NULL,'Official Linux template using node exporter.\r\n\r\nKnown Issues:\r\n\r\n  Description: node_exporter v0.16.0 renamed many metrics. CPU utilization for \'guest\' and \'guest_nice\' metrics are not supported in this template with node_exporter < 0.16. Disk IO metrics are not supported. Other metrics provided as \'best effort\'.\r\nSee https://github.com/prometheus/node_exporter/releases/tag/v0.16.0 for details.\r\n  Version: below 0.16.0\r\n\r\n  Description: metric node_network_info with label \'device\' cannot be found, so network discovery is not possible.\r\n  Version: below 0.18\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','2506b0ca01884903b547b1e19b76ce6d');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10286',NULL,'Windows CPU by Zabbix agent','3','-1','2','','','Windows CPU by Zabbix agent','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','e358504d59404f688e236444dd82d2c3');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10287',NULL,'Windows memory by Zabbix agent','3','-1','2','','','Windows memory by Zabbix agent','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','539b4b98f6fb4e12bbdf3bcdb85df2d1');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10288',NULL,'Windows filesystems by Zabbix agent','3','-1','2','','','Windows filesystems by Zabbix agent','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','cb28abff977b4b6eb34665ff2218163b');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10289',NULL,'Windows physical disks by Zabbix agent','3','-1','2','','','Windows physical disks by Zabbix agent','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','4026647be95a47de98b0f09dc36ce72f');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10290',NULL,'Windows generic by Zabbix agent','3','-1','2','','','Windows generic by Zabbix agent','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','95c4026f8ade4fa7b72f8140fc152aea');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10291',NULL,'Windows network by Zabbix agent','3','-1','2','','','Windows network by Zabbix agent','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','6ad6a4d1e677461ca6d1d5b2dcaba6d2');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10292',NULL,'Zabbix agent active','3','-1','2','','','Zabbix agent active','0',NULL,'Use this template instead of \'Template Module Zabbix agent\' for agents running in active mode only.\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','650bec3f2f364a478b82317396949459');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10300',NULL,'RabbitMQ cluster by Zabbix agent','3','-1','2','','','RabbitMQ cluster by Zabbix agent','0',NULL,'Get cluster metrics from RabbitMQ management plugin provided an HTTP-based API using Zabbix agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','5fa761bc51e4432a90c6c9eece930c4a');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10301',NULL,'RabbitMQ node by Zabbix agent','3','-1','2','','','RabbitMQ node by Zabbix agent','0',NULL,'Get node metrics from RabbitMQ management plugin provided an HTTP-based API using Zabbix agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','d5dc11ae9ab143a89c4be534bbb35188');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10302',NULL,'RabbitMQ cluster by HTTP','3','-1','2','','','RabbitMQ cluster by HTTP','0',NULL,'Get cluster metrics from RabbitMQ management plugin provided an HTTP-based API using HTTP agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','8c8474148c2a4eaeabe5a9331ea99d77');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10303',NULL,'RabbitMQ node by HTTP','3','-1','2','','','RabbitMQ node by HTTP','0',NULL,'Get node metrics from RabbitMQ management plugin provided an HTTP-based API using HTTP agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','b9514029d03b44de9adf24251778dbf3');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10304',NULL,'Cisco UCS SNMP','3','-1','2','','','Cisco UCS SNMP','0',NULL,'Template Server Cisco UCS\r\n\r\nMIBs used:\r\nCISCO-UNIFIED-COMPUTING-COMPUTE-MIB\r\nCISCO-UNIFIED-COMPUTING-PROCESSOR-MIB\r\nCISCO-UNIFIED-COMPUTING-EQUIPMENT-MIB\r\nCISCO-UNIFIED-COMPUTING-STORAGE-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','cb66d34564e44b3893442fc74cf6e951');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10305',NULL,'HOST-RESOURCES-MIB CPU SNMP','3','-1','2','','','HOST-RESOURCES-MIB CPU SNMP','0',NULL,'Requires Zabbix server 4.0.14, 4.2.8, 4.4.0 or newer (JSONPath function avg() used with types autoconversion).\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','b3dd7c4974f442d68c53a79056bc5388');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10306',NULL,'HOST-RESOURCES-MIB memory SNMP','3','-1','2','','','HOST-RESOURCES-MIB memory SNMP','0',NULL,'MIBs used:\r\nHOST-RESOURCES-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','a2718bb9168a451fae8fc97486176943');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10307',NULL,'HOST-RESOURCES-MIB storage SNMP','3','-1','2','','','HOST-RESOURCES-MIB storage SNMP','0',NULL,'MIBs used:\r\nHOST-RESOURCES-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','f6572ac29240452596e9f7b2a7ebb408');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10308',NULL,'HAProxy by Zabbix agent','3','-1','2','','','HAProxy by Zabbix agent','0',NULL,'Get metrics from status page using Zabbix agent\r\nhttps://www.haproxy.com/blog/exploring-the-haproxy-stats-page/.\r\nExample configuration of HAProxy:\r\n  frontend stats\r\n      bind *:8404\r\n      stats enable\r\n      stats uri /stats\r\n      stats refresh 10s\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/393527-discussion-thread-for-official-zabbix-template-haproxy\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','812073bf8df143bcae2a84b32c3965e5');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10309',NULL,'HAProxy by HTTP','3','-1','2','','','HAProxy by HTTP','0',NULL,'Get metrics from status page using HTTP agent\r\nhttps://www.haproxy.com/blog/exploring-the-haproxy-stats-page/.\r\nExample configuration of HAProxy:\r\n  frontend stats\r\n      bind *:8404\r\n      stats enable\r\n      stats uri /stats\r\n      stats refresh 10s\r\n      #stats auth Username:Password  # Authentication credentials\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/393527-discussion-thread-for-official-zabbix-template-haproxy\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','948d046cb2894e5c8d07767a518cc1a9');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10310',NULL,'Redis by Zabbix agent 2','3','-1','2','','','Redis by Zabbix agent 2','0',NULL,'Get Redis metrics from plugin for the New Zabbix Agent (zabbix-agent2).\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/389050-discussion-thread-for-official-zabbix-template-redis\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','e111446745a1425b862f8727ae63bce4');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10314',NULL,'Windows services by Zabbix agent','3','-1','2','','','Windows services by Zabbix agent','0',NULL,'Template Services OS Windows\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','dfd6f32510a840c29f9cb4b974977770');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10316',NULL,'MySQL by Zabbix agent','3','-1','2','','','MySQL by Zabbix agent','0',NULL,'Requirements for template operation:\r\n1.Install Zabbix agent and MySQL client.\r\n2.Copy template_db_mysql.conf into folder with Zabbix agent configuration (/etc/zabbix/zabbix_agentd.d/ by default). Don\'t forget to restart zabbix-agent.\r\n3.Create MySQL user for monitoring. For example:\r\nCREATE USER \'zbx_monitor\'@\'%\' IDENTIFIED BY \'<password>\';\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO \'zbx_monitor\'@\'%\';\r\nFor more information read the MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html , please.\r\n4.Create .my.cnf in home directory of Zabbix agent for Linux (/var/lib/zabbix by default ) or my.cnf in c:\\ for Windows. For example:\r\n[client]\r\nuser=\'zbx_monitor\'\r\npassword=\'<password>\'\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','f255e3fc32124b55b2a17ef3c961e5f5');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10317',NULL,'MySQL by ODBC','3','-1','2','','','MySQL by ODBC','0',NULL,'Requirements for template operation:\r\n1. Create MySQL user for monitoring. For example:\r\nCREATE USER \'zbx_monitor\'@\'%\' IDENTIFIED BY \'<password>\';\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO \'zbx_monitor\'@\'%\';\r\nFor more information read the MYSQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html , please.\r\n2. Set the user name and password in host macros ({$MYSQL.USER} and {$MYSQL.PASSWORD}).\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','e19c120027e04da69b130e0f6cea29fc');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10318',NULL,'Docker by Zabbix agent 2','3','-1','2','','','Docker by Zabbix agent 2','0',NULL,'Get Docker engine metrics from plugin for the New Zabbix Agent (zabbix-agent2).\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/435429-discussion-thread-for-official-zabbix-template-docker\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','c5fd214cdd0d4b3b8272e73b022ba5c2');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10319',NULL,'Memcached by Zabbix agent 2','3','-1','2','','','Memcached by Zabbix agent 2','0',NULL,'Get Memcached metrics from plugin for the New Zabbix Agent (zabbix-agent2).\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/398623-discussion-thread-for-official-zabbix-template-memcached\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','05894ba2c9184d33992bf1bd21c347f6');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10320',NULL,'MySQL by Zabbix agent 2','3','-1','2','','','MySQL by Zabbix agent 2','0',NULL,'Requirements for template operation:\r\n1. Create MySQL user for monitoring. For example:\r\nCREATE USER \'zbx_monitor\'@\'%\' IDENTIFIED BY \'<password>\';\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO \'zbx_monitor\'@\'%\';\r\nFor more information please read the MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html.\r\n2. Set in the {$MYSQL.DSN} macro the data source name of the MySQL instance either session name from Zabbix agent 2 configuration file or URI.\r\nExamples: MySQL1, tcp://localhost:3306, tcp://172.16.0.10, unix:/var/run/mysql.sock\r\nFor more information about MySQL Unix socket file please read the MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/problems-with-mysql-sock.html.\r\n3. If you had set URI in the {$MYSQL.DSN}, please define the user name and password in host macros ({$MYSQL.USER} and {$MYSQL.PASSWORD}).\r\nLeave macros {$MYSQL.USER} and {$MYSQL.PASSWORD} empty if you use a session name. Set the user name and password in the Plugins.Mysql.<...> section of your Zabbix agent 2 configuration file.\r\nFor more information about configuring the Zabbix MySQL plugin please read the documentation https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/src/go/plugins/mysql/README.md.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','4904f84303c74c5e955b7849730c3155');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10321',NULL,'Chassis by IPMI','3','-1','2','','','Chassis by IPMI','0',NULL,'Template for monitoring servers with BMC over IPMI that work without any external scripts.\r\nAll metrics are collected at once, thanks to Zabbix\'s bulk data collection. The template is available starting from Zabbix version 5.0.\r\nIt collects metrics by polling BMC remotely using an IPMI agent.\r\n\r\n\r\nKnown Issues:\r\n\r\n  Description: If the BMC has a sensor with an empty threshold value, we get the LLD error "Cannot create trigger...".\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/398023-discussion-thread-for-official-zabbix-template-ipmi\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','02f35169a5a54a5aad8b3f06e798ab1f');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10322',NULL,'Elasticsearch Cluster by HTTP','3','-1','2','','','Elasticsearch Cluster by HTTP','0',NULL,'The template to monitor Elasticsearch by Zabbix that work without any external scripts.\r\nIt works with both standalone and cluster instances.\r\nThe metrics are collected in one pass remotely using an HTTP agent.\r\nThey are getting values from REST API _cluster/health, _cluster/stats, _nodes/stats requests.\r\nYou can set {$ELASTICSEARCH.USERNAME} and {$ELASTICSEARCH.PASSWORD} macros in the template for using on the host level.\r\nIf you use an atypical location ES API, don\'t forget to change the macros {$ELASTICSEARCH.SCHEME},{$ELASTICSEARCH.PORT}.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/399473-discussion-thread-for-official-zabbix-template-for-elasticsearch\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','52b2664578884d9eba62e47375c99f8e');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10323',NULL,'ClickHouse by HTTP','3','-1','2','','','ClickHouse by HTTP','0',NULL,'Get node metrics from ClickHouse HTTP interface using HTTP agent.\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','95f2053c21094ad4968440b562cc7ea2');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10324',NULL,'Etcd by HTTP','3','-1','2','','','Etcd by HTTP','0',NULL,'Get Etcd metrics by HTTP agent.\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','b25b8b517a4743c48037bfa10af3dc3c');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10325',NULL,'IIS by Zabbix agent','3','-1','2','','','IIS by Zabbix agent','0',NULL,'Get metrics from IIS using Zabbix agent running on Windows.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/401862-discussion-thread-for-official-zabbix-template-internet-information-services\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','c7c7e5dc319b4801982e719beb1c5191');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10326',NULL,'IIS by Zabbix agent active','3','-1','2','','','IIS by Zabbix agent active','0',NULL,'Get metrics from IIS using Zabbix agent running on Windows.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/401862-discussion-thread-for-official-zabbix-template-internet-information-services\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','4677be3e07bf4f3285496f2f4230b928');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10327',NULL,'MSSQL by ODBC','3','-1','2','','','MSSQL by ODBC','0',NULL,'1. Create an MSSQL user for monitoring.\r\n  View Server State and View Any Definition permissions should be granted to the user.\r\n  Grant this user read permissions to the sysjobschedules, sysjobhistory, sysjobs tables.\r\n  For more information, see MSSQL documentation.\r\n2. Set the user name and password in host macros ({$MSSQL.USER} and {$MSSQL.PASSWORD}).\r\n  Do not forget to install Microsoft ODBC driver on Zabbix server or Zabbix proxy.\r\n  See Microsoft documentation for instructions: https://docs.microsoft.com/en-us/sql/connect/odbc/linux-mac/installing-the-microsoft-odbc-driver-for-sql-server?view=sql-server-ver15.\r\n  Note! Credentials in the odbc.ini do not work for MSSQL.\r\n3. For named instance set the value of {$MSSQL.INSTANCE} macro as MSSQL$instance name.\r\nThe "Service\'s TCP port state" item uses {HOST.CONN} and {$MSSQL.PORT} macros to check the availability of the MSSQL instance.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','001a1677f6a949b6bddfdb2926023300');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10328',NULL,'Oracle by ODBC','3','-1','2','','','Oracle by ODBC','0',NULL,'1. Create an Oracle user for monitoring.\r\n\r\n2. Set the user name and password in host macros ({$ORACLE.USER} and {$ORACLE.PASSWORD}).\r\n  Do not forget to install the Microsoft ODBC driver on the Zabbix server or the Zabbix proxy.\r\n  See Oracle documentation for instructions: https://www.oracle.com/database/technologies/releasenote-odbc-ic.html.\r\n\r\n  Note! Credentials in the odbc.ini do not work for Oracle.\r\n  Note! Be sure that ODBC connects to Oracle with session parameter NLS_NUMERIC_CHARACTERS= \'.,\' It is important for correct display float numbers in Zabbix.\r\nThe "Service\'s TCP port state" item uses {HOST.CONN} and {$ORACLE.PORT} macros to check the availability of the listener.\r\n\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','00ade9277d7c41e8b57d638b22d54372');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10329',NULL,'PostgreSQL by Zabbix agent 2','3','-1','2','','','PostgreSQL by Zabbix agent 2','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384190-%C2%A0discussion-thread-for-official-zabbix-template-db-postgresql\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','d0ef7d659a8f4beaaabfc4b6134e737a');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10330',NULL,'PHP-FPM by Zabbix agent','3','-1','2','','','PHP-FPM by Zabbix agent','0',NULL,'Get PHP-FPM metrics using Zabbix agent running on Linux.\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','1cbda0970410435684135884d0cb7090');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10331',NULL,'PHP-FPM by HTTP','3','-1','2','','','PHP-FPM by HTTP','0',NULL,'Get PHP-FPM metrics using the Zabbix HTTP agent.\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','49c77ce207f8478da53e761526d6eca5');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10332',NULL,'VMware macros','3','-1','2','','','VMware macros','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','214366d2deb14a0ca6d19d8a54a3b88e');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10333',NULL,'{#HV.UUID}','0','-1','2','','','{#HV.NAME}','2',NULL,'','1','1','','','','','','1','0','1','051a1469d4d045cbbf818fcc843a352e');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10334',NULL,'{#VM.UUID}','0','-1','2','','','{#VM.NAME}','2',NULL,'','1','1','','','','','','1','0','1','23b9ae9d6f33414880db1cb107115810');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10335',NULL,'Oracle by Zabbix agent 2','3','-1','2','','','Oracle by Zabbix agent 2','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','d670c32f007d438c9dcd32db57d2b691');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10336',NULL,'Asterisk by HTTP','3','-1','2','','','Asterisk by HTTP','0',NULL,'The template gets Asterisk metrics from AMI by HTTP agent.\r\nYou should enable the mini-HTTP Server, add the option webenabled=yes\r\nin the general section of the manager.conf file and create Asterisk Manager\r\nuser with system and command write permissions within your Asterisk instance.\r\nDisable the PJSIP driver if you do not use PJSIP or do not have PJSIP endpoints.\r\nPlease, define AMI address in the {$AMI.URL} macro. Also, the Zabbix host\r\nshould have an Agent interface with the AMI address to check Asterisk service\r\nstatus.\r\nThen you can define {$AMI.USERNAME} and {$AMI.SECRET} macros in\r\nthe template for using on the host level.\r\nIf there are errors, increase the logging to debug level and see the Zabbix server log.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/410060-discussion-thread-for-official-zabbix-template-asterisk\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','30cc187a4e994c39b07f53d86b5cc6bc');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10337',NULL,'Linux block devices by Zabbix agent active','3','-1','2','','','Linux block devices by Zabbix agent active','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','aa226119d3e94f53b9a2809f1d4ebaee');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10338',NULL,'Linux CPU by Zabbix agent active','3','-1','2','','','Linux CPU by Zabbix agent active','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','da53e44145304098b4c3ff749996e3e7');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10339',NULL,'Linux filesystems by Zabbix agent active','3','-1','2','','','Linux filesystems by Zabbix agent active','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','c626d864a2894d29a9d661d6025536ff');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10340',NULL,'Linux generic by Zabbix agent active','3','-1','2','','','Linux generic by Zabbix agent active','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','7e4dc41320fd48bd97549025f4c3bcc6');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10341',NULL,'Linux memory by Zabbix agent active','3','-1','2','','','Linux memory by Zabbix agent active','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','5f577b9e34a8444c920e8199170f7fe6');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10342',NULL,'Linux network interfaces by Zabbix agent active','3','-1','2','','','Linux network interfaces by Zabbix agent active','0',NULL,'Known Issues:\r\n\r\n  Description: High interface utilization trigger is removed since currently it is not possible to retrieve interface speed to determine the max bandwidth.\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','fac8b6986be24a8c91f7b0b15439bccf');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10343',NULL,'Linux by Zabbix agent active','3','-1','2','','','Linux by Zabbix agent active','0',NULL,'Official Linux template. Requires agent of Zabbix 3.0.14, 3.4.5 and 4.0.0 or newer.\r\n\r\nKnown Issues:\r\n\r\n  Description: Network discovery. Zabbix agent as of 4.2 doesn\'t support items such as net.if.status, net.if.speed.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','e2307c94f1744af7a8f1f458a67af424');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10344',NULL,'Windows CPU by Zabbix agent active','3','-1','2','','','Windows CPU by Zabbix agent active','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','296cb27ad93b4063b77aaf1a8339d40c');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10345',NULL,'Windows filesystems by Zabbix agent active','3','-1','2','','','Windows filesystems by Zabbix agent active','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','1b04ac025fcf474cb97e6c8c95855eeb');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10346',NULL,'Windows generic by Zabbix agent active','3','-1','2','','','Windows generic by Zabbix agent active','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','6dd37a415f4c40aa960d7ba91b6b5143');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10347',NULL,'Windows memory by Zabbix agent active','3','-1','2','','','Windows memory by Zabbix agent active','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','e6535f54a0554463889fb8c65db11250');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10348',NULL,'Windows network by Zabbix agent active','3','-1','2','','','Windows network by Zabbix agent active','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','792cb76a1a6340d8acb36d8802d22c00');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10349',NULL,'Windows physical disks by Zabbix agent active','3','-1','2','','','Windows physical disks by Zabbix agent active','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','222cf73cb40941f6be62db0540524e5e');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10350',NULL,'Windows services by Zabbix agent active','3','-1','2','','','Windows services by Zabbix agent active','0',NULL,'Template Services OS Windows\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','3366a65bbc3e46348bec303e84e23b15');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10351',NULL,'Windows by Zabbix agent active','3','-1','2','','','Windows by Zabbix agent active','0',NULL,'Official Windows template. Requires agent of Zabbix 4.4 and newer.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387224-discussion-thread-for-official-zabbix-template-for-windows\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','5fdd2ca8b8f84962aaea5a218b46ea7d');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10353',NULL,'Ceph by Zabbix agent 2','3','-1','2','','','Ceph by Zabbix agent 2','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/410059-discussion-thread-for-official-zabbix-template-ceph\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','09fb25d089f7467f860895f6e71d3fa2');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10355',NULL,'Squid SNMP','3','-1','2','','','Squid SNMP','0',NULL,'Template for monitoring Squid caching proxy via SNMP\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/409339-discussion-thread-for-official-zabbix-template-squid\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','8e5236f799b347a8ae90a979198be85e');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10357',NULL,'PostgreSQL by user parameters','3','-1','2','','','PostgreSQL by user parameters','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384190-%C2%A0discussion-thread-for-official-zabbix-template-db-postgresql\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','399bd1ee587245ecac6f39beaa99886f');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10358',NULL,'Apache ActiveMQ by JMX','3','-1','2','','','Apache ActiveMQ by JMX','0',NULL,'The template to monitor Apache ActiveMQ by Zabbix that work without any external scripts.\r\nThe metrics are collected by JMX.\r\nYou can set macro values and add macros with context for specific brokers or destinations following macro description.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/411049-discussion-thread-for-official-zabbix-template-amq\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','c87e0a2e0683483ab7c6f3c380e9f840');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10359',NULL,'Aranet Cloud','3','-1','2','','','Aranet Cloud','0',NULL,'Template tooling version used: 0.40','1','1','','','','','','1','0','0','af21edc47557400583e537904ea632aa');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10360',NULL,'Microsoft Exchange Server 2016 by Zabbix agent','3','-1','2','','','Microsoft Exchange Server 2016 by Zabbix agent','0',NULL,'The template to monitor Microsoft Exchange Server 2016 by Zabbix that works without any external scripts.\r\nThe metrics are collected by Zabbix agent.\r\nRecommended to use it with "OS Windows by Zabbix agent" template.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/415007-discussion-thread-for-official-zabbix-template-microsoft-exchange\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','cbf70ed444394566bcf213dd63d4d352');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10361',NULL,'Microsoft Exchange Server 2016 by Zabbix agent active','3','-1','2','','','Microsoft Exchange Server 2016 by Zabbix agent active','0',NULL,'The template to monitor Microsoft Exchange Server 2016 by Zabbix that works without any external scripts.\r\nThe metrics are collected by Zabbix agent active.\r\nRecommended to use it with "OS Windows by Zabbix agent active" template.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/415007-discussion-thread-for-official-zabbix-template-microsoft-exchange\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','a0e05ca631034676821b7e0e1ce25488');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10362',NULL,'GitLab by HTTP','3','-1','2','','','GitLab by HTTP','0',NULL,'Get GitLab metrics by HTTP agent from Prometheus metrics endpoint.\r\n\r\nTo access the metrics, the client IP address must be explicitly allowed. See https://docs.gitlab.com/ee/administration/monitoring/ip_whitelist.html.\r\n\r\nDon\'t forget change macros {$GITLAB.URL}.\r\nSome metrics may not be collected depending on your Gitlab instance version and configuration. See (Gitlab\'s documentation[)https://docs.gitlab.com/ee/administration/monitoring/prometheus/gitlab_metrics.html] for further information about its metric collection.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','f445dac89ff74deabaae9dcb84815998');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10363',NULL,'Hadoop by HTTP','3','-1','2','','','Hadoop by HTTP','0',NULL,'The template gets the Hadoop metrics from cluster\'s hosts (ResourceManager, NodeManagers, NameNode, DataNodes) by HTTP agent. You should define the IP address (or FQDN) and Web-UI port for the ResourceManager in {$HADOOP.RESOURCEMANAGER.HOST} and {$HADOOP.RESOURCEMANAGER.PORT} macros and for the NameNode in {$HADOOP.NAMENODE.HOST} and {$HADOOP.NAMENODE.PORT} macros respectively. Macros can be set in the template or overridden at the host level.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/413459-discussion-thread-for-official-zabbix-template-hadoop\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','e129aeba7c814bf189772cf5919b4bbb');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10364',NULL,'Apache Kafka by JMX','3','-1','2','','','Apache Kafka by JMX','0',NULL,'Official JMX Template for Apache Kafka.\r\n  The metrics are collected by JMX.\r\n  You can set {$KAFKA.USER} and {$KAFKA.PASSWORD} macros in the template for using on the host level.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','2eb43a3c9666467683b9ce09d2bd26d7');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10365',NULL,'HashiCorp Vault by HTTP','3','-1','2','','','HashiCorp Vault by HTTP','0',NULL,'Get HashiCorp Vault metrics from Vault API HTTP Prometheus metrics endpoint.\r\n\r\nSome metrics may not be collected depending on your Vault instance version and configuration.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','2f82248e411340429d390e8389850401');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10366',NULL,'VMware FQDN','3','-1','2','','','VMware FQDN','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','ca02e82e6c414d0aa7aedc8d78468a49');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10367',NULL,'{#HV.UUID}','0','-1','2','','','{#HV.NAME}','2',NULL,'','1','1','','','','','','1','0','1','51cf7ea3e6a74f7e8dde628dbc5347a3');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10368',NULL,'{#VM.DNS}','0','-1','2','','','{#VM.NAME}','2',NULL,'','1','1','','','','','','1','0','1','a12e25c500a14fcf99295c207371ca1b');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10369',NULL,'Zookeeper by HTTP','3','-1','2','','','Zookeeper by HTTP','0',NULL,'Get Apache Zookeeper metrics by HTTP agent.\r\n  This template works with standalone and cluster instances. Metrics are collected from each Zookeper node by requests to AdminServer.\r\n  Don\'t forget to change macros {$ZOOKEEPER.COMMAND_URL}, {$ZOOKEEPER.PORT}, {$ZOOKEEPER.SCHEME}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','b606eda347ea4663a33ad4d12a482750');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10370',NULL,'Apache Cassandra by JMX','3','-1','2','','','Apache Cassandra by JMX','0',NULL,'The template to monitor Apache Cassandra by Zabbix that work without any external scripts.\r\nIt works with both standalone and cluster instances.\r\nThe metrics are collected by JMX.\r\nYou can set {$CASSANDRA.USER} and {$CASSANDRA.PASSWORD} macros in the template for using on the host level.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/410057-discussion-thread-for-official-zabbix-template-apache-cassandra\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','5c42de26643c4b43b23a11159df021ce');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10371',NULL,'Morningstar ProStar MPPT SNMP','3','-1','2','','','Morningstar ProStar MPPT SNMP','0',NULL,'MIBs used:\r\nPROSTAR-MPPT\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','b84324c2a40a496dbbb379bbf5dde8d5');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10372',NULL,'Morningstar ProStar PWM SNMP','3','-1','2','','','Morningstar ProStar PWM SNMP','0',NULL,'MIBs used:\r\nPROSTAR-PWM\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','24bed6339f0a492fab86fe757394b937');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10373',NULL,'Morningstar SunSaver MPPT SNMP','3','-1','2','','','Morningstar SunSaver MPPT SNMP','0',NULL,'MIBs used:\r\nSUNSAVER-MPPT\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','f1336fd88ab0415a9c02892a71e50032');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10374',NULL,'Morningstar SureSine SNMP','3','-1','2','','','Morningstar SureSine SNMP','0',NULL,'MIBs used:\r\nSURESINE\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','3bbfe42c78c74f04a2565431fbdd19e2');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10375',NULL,'Morningstar TriStar MPPT 600V SNMP','3','-1','2','','','Morningstar TriStar MPPT 600V SNMP','0',NULL,'MIBs used:\r\nTRISTAR-MPPT\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','2d20a2fbd540492089fdcafc8feb60e3');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10376',NULL,'Morningstar TriStar MPPT SNMP','3','-1','2','','','Morningstar TriStar MPPT SNMP','0',NULL,'MIBs used:\r\nTRISTAR-MPPT\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','07b32152c3654e8ead4c1eeae24efa8f');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10377',NULL,'Morningstar TriStar PWM SNMP','3','-1','2','','','Morningstar TriStar PWM SNMP','0',NULL,'MIBs used:\r\nTRISTAR\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','230fa9f7c1774821bbe6cdcbbba5cbc6');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10378',NULL,'NetApp FAS3220 SNMP','3','-1','2','','','NetApp FAS3220 SNMP','0',NULL,'The template to monitor SAN NetApp FAS3220 cluster by Zabbix SNMP agent.\r\n\r\nMIBs used:\r\nNETAPP-MIB\r\nIF-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/416694-discussion-thread-for-official-zabbix-template-netapp-fas3220\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','e118ab11c1ec4f9cbe21dfce1441c0f6');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10379',NULL,'Jenkins by HTTP','3','-1','2','','','Jenkins by HTTP','0',NULL,'Get Jenkins metrics by HTTP agent.\r\nMetrics are collected by requests to Metrics API. Install  Metrics plugin and configure access to the Metrics Servlet by issuing API key.\r\nDon\'t forget to change macros {$JENKINS.URL}, {$JENKINS.USER}, {$JENKINS.API.TOKEN}, {$JENKINS.API.KEY}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','2ef2f2eb75ee4a0bae839e22aa76e5fc');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10380',NULL,'Hikvision camera by HTTP','3','-1','2','','','Hikvision camera by HTTP','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0','3fb4020df2984b0ab64dfd8355ff5c65');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10381',NULL,'Ignite by JMX','3','-1','2','','','Ignite by JMX','0',NULL,'The template to monitor Apache Ignite by Zabbix that work without any external scripts.\r\n  It works with both standalone and cluster instances.\r\n  The metrics are discoverable and collected by JMX.\r\n  Current JMX tree hierarchy contains classloader by default. Add the following jvm option `-DIGNITE_MBEAN_APPEND_CLASS_LOADER_ID=false`to will exclude one level with Classloader name.\r\n  You can set {$IGNITE.USER} and {$IGNITE.PASSWORD} macros in the template for using on the host level.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','ab05dbb15ff047f192782f617f0627ac');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10382',NULL,'Microsoft SharePoint by HTTP','3','-1','2','','','Microsoft SharePoint by HTTP','0',NULL,'Overview:\r\nTemplate receives data via HTTP Agent.\r\nSetup:\r\nCreate a new host.\r\nDefine macros according to your Sharepoint web portal.\r\nIt is recommended to fill in the values of the filter macros to avoid getting redundant data.\r\n\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','8d5fe5b4ebb64255a2429b34c7dd3681');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10383',NULL,'SMART by Zabbix agent 2','3','-1','2','','','SMART by Zabbix agent 2','0',NULL,'The template for monitoring S.M.A.R.T. attributes of physical disk that works without any external scripts. It collects metrics by Zabbix agent 2 version 5.0 and later with Smartmontools version 7.1 and later. Disk discovery LLD rule finds all HDD, SSD, NVMe disks with S.M.A.R.T. enabled. Attribute discovery LLD rule finds all Vendor Specific Attributes for each disk. If you want to skip some attributes, please set regular expressions with disk names in {$SMART.DISK.NAME.MATCHES} and with attribute IDs in {$SMART.ATTRIBUTE.ID.MATCHES} macros on the host level.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/415662-discussion-thread-for-official-zabbix-smart-disk-monitoring\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','7b6c6228b25f4586b42cd1bf37ff8034');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10384',NULL,'SMART by Zabbix agent active 2','3','-1','2','','','SMART by Zabbix agent active 2','0',NULL,'The template for monitoring S.M.A.R.T. attributes of physical disk that works without any external scripts. It collects metrics by Zabbix agent 2 version 5.0 and later with Smartmontools version 7.1 and later. Disk discovery LLD rule finds all HDD, SSD, NVMe disks with S.M.A.R.T. enabled. Attribute discovery LLD rule finds all Vendor Specific Attributes for each disk. If you want to skip some attributes, please set regular expressions with disk names in {$SMART.DISK.NAME.MATCHES} and with attribute IDs in {$SMART.ATTRIBUTE.ID.MATCHES} macros on the host level.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/415662-discussion-thread-for-official-zabbix-smart-disk-monitoring\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','e518b1340ce44d7389d2cc7c304a97b4');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10385',NULL,'Huawei OceanStor 5300 V5 SNMP','3','-1','2','','','Huawei OceanStor 5300 V5 SNMP','0',NULL,'The template to monitor SAN Huawei OceanStor 5300 V5 by Zabbix SNMP agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418855-discussion-thread-for-official-zabbix-template-huawei-oceanstor\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','c5564dd58c394b969d5365cc5de3e7f8');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10386',NULL,'MongoDB node by Zabbix agent 2','3','-1','2','','','MongoDB node by Zabbix agent 2','0',NULL,'Get MongoDB metrics from plugin for the zabbix-agent2.\r\n  1. Setup and configure zabbix-agent2 compiled with the MongoDB monitoring plugin.\r\n  2. Set the {$MONGODB.CONNSTRING} such as <protocol(host:port)> or named session.\r\n  3. Set the user name and password in host macros ({$MONGODB.USER}, {$MONGODB.PASSWORD}) if you want to override parameters from the Zabbix agent configuration file.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420659-discussion-thread-for-official-zabbix-template-db-mongodb\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','81aa8c5ab5594f77a2b26fb7f5094048');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10387',NULL,'MongoDB cluster by Zabbix agent 2','3','-1','2','','','MongoDB cluster by Zabbix agent 2','0',NULL,'Get MongoDB metrics from plugin for the zabbix-agent2.\r\n  1. Setup and configure zabbix-agent2 compiled with the MongoDB monitoring plugin.\r\n  2. Set the {$MONGODB.CONNSTRING} such as <protocol(host:port)> or named session.\r\n  3. Set the user name and password in host macros ({$MONGODB.USER}, {$MONGODB.PASSWORD}) if you want to override parameters from the Zabbix agent configuration file.\r\n\r\n  All sharded Mongodb nodes (mongod) will be discovered with attached template "MongoDB node".\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420659-discussion-thread-for-official-zabbix-template-db-mongodb\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','d38b271797bd41f2ad8c79d83b9d8d9c');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10388',NULL,'{#HOSTNAME}','0','-1','2','','','{#HOSTNAME}','2',NULL,'','1','1','','','','','','1','0','0','809db5d8d32a45898e8401f288a42fac');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10389',NULL,'{#HOSTNAME}','0','-1','2','','','{#HOSTNAME}','2',NULL,'','1','1','','','','','','1','0','0','3fcd3244b1234186bda9a35c8f61c850');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10390',NULL,'Cisco Catalyst 3750V2-24FS SNMP','3','-1','2','','','Cisco Catalyst 3750V2-24FS SNMP','0',NULL,'Template Cisco Catalyst 3750V2-24FS\r\n  \r\n  MIBs used:\r\n  CISCO-MEMORY-POOL-MIB\r\n  IF-MIB\r\n  EtherLike-MIB\r\n  SNMPv2-MIB\r\n  CISCO-PROCESS-MIB\r\n  CISCO-ENVMON-MIB\r\n  ENTITY-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','6ff896f545e043cc98de6d98698d41df');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10391',NULL,'Cisco Catalyst 3750V2-24PS SNMP','3','-1','2','','','Cisco Catalyst 3750V2-24PS SNMP','0',NULL,'Template Cisco Catalyst 3750V2-24PS\r\n  \r\n  MIBs used:\r\n  CISCO-MEMORY-POOL-MIB\r\n  IF-MIB\r\n  EtherLike-MIB\r\n  SNMPv2-MIB\r\n  CISCO-PROCESS-MIB\r\n  CISCO-ENVMON-MIB\r\n  ENTITY-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','4583f0c3bc894251a6c5e7129cb5b9aa');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10392',NULL,'Cisco Catalyst 3750V2-24TS SNMP','3','-1','2','','','Cisco Catalyst 3750V2-24TS SNMP','0',NULL,'Template Cisco Catalyst 3750V2-24TS\r\n  \r\n  MIBs used:\r\n  CISCO-MEMORY-POOL-MIB\r\n  IF-MIB\r\n  EtherLike-MIB\r\n  SNMPv2-MIB\r\n  CISCO-PROCESS-MIB\r\n  CISCO-ENVMON-MIB\r\n  ENTITY-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','30d084c6b7844b7cab6cf820b00bb7b2');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10393',NULL,'Cisco Catalyst 3750V2-48PS SNMP','3','-1','2','','','Cisco Catalyst 3750V2-48PS SNMP','0',NULL,'Template Cisco Catalyst 3750V2-48PS\r\n  \r\n  MIBs used:\r\n  CISCO-MEMORY-POOL-MIB\r\n  IF-MIB\r\n  EtherLike-MIB\r\n  SNMPv2-MIB\r\n  CISCO-PROCESS-MIB\r\n  CISCO-ENVMON-MIB\r\n  ENTITY-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','ea096c13a09b4d7a9be0aab1cec95206');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10394',NULL,'Cisco Catalyst 3750V2-48TS SNMP','3','-1','2','','','Cisco Catalyst 3750V2-48TS SNMP','0',NULL,'Template Cisco Catalyst 3750V2-48TS\r\n  \r\n  MIBs used:\r\n  CISCO-MEMORY-POOL-MIB\r\n  IF-MIB\r\n  EtherLike-MIB\r\n  SNMPv2-MIB\r\n  CISCO-PROCESS-MIB\r\n  CISCO-ENVMON-MIB\r\n  ENTITY-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','f744679600844c07b2b4eedda9bc3d0c');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10395',NULL,'APC UPS SNMP','3','-1','2','','','APC UPS SNMP','0',NULL,'Template Power APC UPS\r\n\r\nMIBs used:\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','3ec55c9966624ef5bc1b50502812d581');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10396',NULL,'NetApp AFF A700 by HTTP','3','-1','2','','','NetApp AFF A700 by HTTP','0',NULL,'The template to monitor SAN NetApp AFF A700 cluster by Zabbix HTTP agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','79267c69f54a4e59b4152aba4e8c4bd5');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10397',NULL,'TiDB PD by HTTP','3','-1','2','','','TiDB PD by HTTP','0',NULL,'The template to monitor PD server of TiDB cluster by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\nDon\'t forget to change the macros {$PD.URL}, {$PD.PORT}.\r\n\r\nTemplate `TiDB PD by HTTP` — collects metrics by HTTP agent from PD /metrics endpoint and from monitoring API.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','43596328d4d74a5592906a9e08e3fd96');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10398',NULL,'TiDB by HTTP','3','-1','2','','','TiDB by HTTP','0',NULL,'The template to monitor TiDB server of TiDB cluster by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\nDon\'t forget to change the macros {$TIDB.URL}, {$TIDB.PORT}.\r\n\r\nTemplate `TiDB by HTTP` — collects metrics by HTTP agent from PD /metrics endpoint and from monitoring API.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','8ec72ebbe3204d7789429640abcac610');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10399',NULL,'TiDB TiKV by HTTP','3','-1','2','','','TiDB TiKV by HTTP','0',NULL,'The template to monitor TiKV server of TiDB cluster by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\nDon\'t forget to change the macros {$TIKV.URL}, {$TIKV.PORT}.\r\n\r\nTemplate `TiDB TiKV by HTTP` — collects metrics by HTTP agent from TiKV /metrics endpoint.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','3a0bbbb2ec0a4c58bba3ba3a3d6ce660');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10400',NULL,'APC UPS Galaxy 3500 SNMP','3','-1','2','','','APC UPS Galaxy 3500 SNMP','0',NULL,'Template Power APC UPS Galaxy 3500\r\n\r\nMIBs used:\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','5d3971cd973b46e7915d7ae0750bac57');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10401',NULL,'APC Smart-UPS 2200 RM SNMP','3','-1','2','','','APC Smart-UPS 2200 RM SNMP','0',NULL,'Template Power APC Smart-UPS 2200 RM\r\n\r\nMIBs used:\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','e8c0b2c40e884f1598d86f3edf020ea7');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10402',NULL,'APC Smart-UPS 3000 XLM SNMP','3','-1','2','','','APC Smart-UPS 3000 XLM SNMP','0',NULL,'Template Power APC Smart-UPS 3000 XLM\r\n\r\nMIBs used:\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','eafd78764fde4110b9e46ae184f327ba');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10403',NULL,'APC Smart-UPS RT 1000 RM XL SNMP','3','-1','2','','','APC Smart-UPS RT 1000 RM XL SNMP','0',NULL,'Template Power APC Smart-UPS RT 1000 RM XL\r\n\r\nMIBs used:\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','340ec6917c274ead8fab36925e57f30a');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10404',NULL,'APC Smart-UPS RT 1000 XL SNMP','3','-1','2','','','APC Smart-UPS RT 1000 XL SNMP','0',NULL,'Template Power APC Smart-UPS RT 1000 XL\r\n\r\nMIBs used:\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','32d3c78ff44c4c3c9ff5b893ad7f5fc9');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10405',NULL,'APC Smart-UPS SRT 5000 SNMP bkp','3','-1','2','','','APC Smart-UPS SRT 5000 SNMP bkp','0',NULL,'Template Power APC Smart-UPS SRT 5000\r\n\r\nMIBs used:\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0','77e7f53c88f546a5ac0dc8b318c7cd24');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10406',NULL,'APC Smart-UPS SRT 8000 SNMP','3','-1','2','','','APC Smart-UPS SRT 8000 SNMP','0',NULL,'Template Power APC Smart-UPS SRT 8000\r\n\r\nMIBs used:\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','b3caafda8c5345cc832ac3be3cefa615');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10407',NULL,'APC UPS Symmetra LX SNMP','3','-1','2','','','APC UPS Symmetra LX SNMP','0',NULL,'Template Power APC UPS Symmetra LX\r\n\r\nMIBs used:\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','0b9a899ff8f1467c9fdf999d02b9fd77');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10408',NULL,'APC UPS Symmetra RM SNMP','3','-1','2','','','APC UPS Symmetra RM SNMP','0',NULL,'Template Power APC UPS Symmetra RM\r\n\r\nMIBs used:\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','1dac0a88c3774315b90622a48031e369');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10409',NULL,'APC UPS Symmetra RX SNMP','3','-1','2','','','APC UPS Symmetra RX SNMP','0',NULL,'Template Power APC UPS Symmetra RX\r\n\r\nMIBs used:\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','4ffb0f9103084384a98379ed533865e9');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10410',NULL,'WildFly Domain by JMX','3','-1','2','','','WildFly Domain by JMX','0',NULL,'Official JMX Template for WildFly.\r\nThe metrics are collected by JMX. This template works with Domain Controller.\r\nYou can set {$WILDFLY.USER} and {$WILDFLY.PASSWORD} macros in the template for using on the host level.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','4b27e636b6ad4ce68511d344d5604999');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10411',NULL,'WildFly Server by JMX','3','-1','2','','','WildFly Server by JMX','0',NULL,'Official JMX Template for WildFly.\r\nThe metrics are collected by JMX. This template works with standalone and domain instances.\r\nYou can set {$WILDFLY.USER} and {$WILDFLY.PASSWORD} macros in the template for using on the host level.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','2bf5827343f0420792ad953f290baa05');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10412',NULL,'APC Smart-UPS SRT 5000 SNMP','3','-1','2','','','APC Smart-UPS SRT 5000 SNMP','0',NULL,'Template Power APC Smart-UPS SRT 5000\r\n\r\nMIBs used:\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','8ec76aeb703747a5affdf435bc12f572');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10413',NULL,'Nginx Plus by HTTP','3','-1','2','','','Nginx Plus by HTTP','0',NULL,'Get Nginx Plus metrics by HTTP agent.\r\nMetrics are collected by requests to Nginx Plus API.\r\nDon\'t forget to change macros {$NGINX.API.ENDPOINT}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','8cad0f2564694416b60bd8a414948641');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10414',NULL,'ZYXEL AAM1212-51 IES-612 SNMP','3','-1','2','','','ZYXEL AAM1212-51 IES-612 SNMP','0',NULL,'ZYXEL AAM1212-51 / IES-612\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nADSL-LINE-MIB\r\nZYXEL-IESCOMMON-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL AAM1212-51 / IES-612\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','3a71dcdcfe0b4a0e8284d8939d335cce');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10415',NULL,'ZYXEL ES3500-8PD SNMP','3','-1','2','','','ZYXEL ES3500-8PD SNMP','0',NULL,'ZYXEL ES3500-8PD\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\n ZYXEL-ES3500-8PD-MIB\r\nIF-MIB\r\nZYXEL-ES3500-8PD-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL ES3500-8PD\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','b8a6f34fd5c447b1b9310746a96f4e80');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10416',NULL,'ZYXEL GS-4012F SNMP','3','-1','2','','','ZYXEL GS-4012F SNMP','0',NULL,'ZYXEL GS-4012F\r\n\r\nMIBs used:\r\nZYXEL-GS4012F-MIB\r\nRFC1213-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL GS-4012F\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','73f123bb9ffe4587a0269c7e8752b2ed');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10417',NULL,'ZYXEL IES-500x SNMP','3','-1','2','','','ZYXEL IES-500x SNMP','0',NULL,'ZYXEL IES-500x\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nADSL-LINE-MIB\r\nZYXEL-IES5000-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL IES-500x\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','3db86b0d235e4c7b80f7d6144ca08925');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10418',NULL,'ZYXEL IES-6000 SNMP','3','-1','2','','','ZYXEL IES-6000 SNMP','0',NULL,'ZYXEL IES-6000\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nADSL-LINE-MIB\r\nZYXEL-IES5000-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL IES-6000\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','3645654baaf04f11927b171bcb048349');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10419',NULL,'ZYXEL IES1248-51 SNMP','3','-1','2','','','ZYXEL IES1248-51 SNMP','0',NULL,'ZYXEL IES1248-51\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nADSL-LINE-MIB\r\nZYXEL-IESCOMMON-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL IES1248-51\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','8e6d7067cd094e56a52db999b3199edc');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10420',NULL,'ZYXEL MES-3528 SNMP','3','-1','2','','','ZYXEL MES-3528 SNMP','0',NULL,'ZYXEL MES-3528\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\n ZYXEL-MES3528-MIB\r\nZYXEL-MES3528-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MES-3528\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','249de8d8d21e4dda9c3f766ab6201378');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10421',NULL,'ZYXEL MES3500-10 SNMP','3','-1','2','','','ZYXEL MES3500-10 SNMP','0',NULL,'ZYXEL MES3500-10\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nZYXEL-MES3500-10-MIB\r\n ZYXEL-MES3500-10-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MES3500-10\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','21a95afef0e74fb19691693090403d1d');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10422',NULL,'ZYXEL MES3500-24 SNMP','3','-1','2','','','ZYXEL MES3500-24 SNMP','0',NULL,'ZYXEL MES3500-24\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\n ZYXEL-MES3500-24-MIB\r\nZYXEL-MES3500-24-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MES3500-24\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','292970ad91204722b5e5cb3233fc0026');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10423',NULL,'ZYXEL MGS-3712 SNMP','3','-1','2','','','ZYXEL MGS-3712 SNMP','0',NULL,'ZYXEL MGS-3712\r\n\r\nMIBs used:\r\nZYXEL-MGS3712F-MIB\r\nRFC1213-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MGS-3712\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','8ea7299983f24d0a913606e334f0e526');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10424',NULL,'ZYXEL MGS-3712F SNMP','3','-1','2','','','ZYXEL MGS-3712F SNMP','0',NULL,'ZYXEL MGS-3712F\r\n\r\nMIBs used:\r\nZYXEL-MGS3712F-MIB\r\nRFC1213-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MGS-3712F\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','01deb47efa1f4a9092de67fd61820a7d');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10425',NULL,'ZYXEL MES3500-24S SNMP','3','-1','2','','','ZYXEL MES3500-24S SNMP','0',NULL,'ZYXEL MES3500-24S\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nZYXEL-HW-MONITOR-MIB\r\nZYXEL-PORT-MIB\r\nZYXEL-ES-COMMON\r\nZYXEL-TRANSCEIVER-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MGS3520-28\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','89eef2fe23964f44bf9aec6d00e39efd');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10426',NULL,'ZYXEL MGS3520-28x SNMP','3','-1','2','','','ZYXEL MGS3520-28x SNMP','0',NULL,'ZYXEL MGS3520-28x\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nZYXEL-HW-MONITOR-MIB\r\nZYXEL-PORT-MIB\r\nZYXEL-ES-COMMON\r\nZYXEL-TRANSCEIVER-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MGS3520-28\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','9cc843a085bb4ee5af0dc4d764a7eee9');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10427',NULL,'ZYXEL XGS-4728F SNMP','3','-1','2','','','ZYXEL XGS-4728F SNMP','0',NULL,'ZYXEL XGS-4728F\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nZYXEL-XGS4728F-MIB\r\nIF-MIB\r\n ZYXEL-XGS4728F-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL XGS-4728F\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','ab18a5665b7d4bed876881b5c4e8ce51');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10428',NULL,'Cisco UCS Manager SNMP','3','-1','2','','','Cisco UCS Manager SNMP','0',NULL,'This is a template for Cisco UCS Manager monitoring via Zabbix SNMP Agent that works without any external scripts.\r\n\r\n\r\nMIBs used:\r\nCISCO-UNIFIED-COMPUTING-COMPUTE-MIB\r\nSNMPv2-MIB\r\nCISCO-UNIFIED-COMPUTING-PROCESSOR-MIB\r\nCISCO-UNIFIED-COMPUTING-EQUIPMENT-MIB\r\nCISCO-UNIFIED-COMPUTING-STORAGE-MIB\r\nIF-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','d5eb4ce08a334098a85e6e02c534be90');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10429',NULL,'HPE ProLiant BL460 SNMP','3','-1','2','','','HPE ProLiant BL460 SNMP','0',NULL,'Template for HPE ProLiant BL460 servers with HP iLO version 4 and later.\r\n\r\nMIBs used:\r\nCPQHLTH-MIB\r\nSNMPv2-MIB\r\nCPQNIC-MIB\r\nCPQSINFO-MIB\r\nCPQIDA-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','172ec7e51f1c4a6ba49baffbab3dda97');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10430',NULL,'HPE ProLiant BL920 SNMP','3','-1','2','','','HPE ProLiant BL920 SNMP','0',NULL,'Template for HPE ProLiant BL920 servers with HP iLO version 4 and later.\r\n\r\nMIBs used:\r\nCPQHLTH-MIB\r\nSNMPv2-MIB\r\nCPQNIC-MIB\r\nCPQSINFO-MIB\r\nCPQIDA-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','586119e5e27e4062a3cce8601ecb8d71');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10431',NULL,'HPE ProLiant DL360 SNMP','3','-1','2','','','HPE ProLiant DL360 SNMP','0',NULL,'Template for HPE ProLiant DL360 servers with HP iLO version 4 and later.\r\n\r\nMIBs used:\r\nCPQHLTH-MIB\r\nSNMPv2-MIB\r\nCPQNIC-MIB\r\nCPQSINFO-MIB\r\nCPQIDA-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','60cb9ccb922e4fd194a1d9573db10237');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10432',NULL,'HPE ProLiant DL380 SNMP','3','-1','2','','','HPE ProLiant DL380 SNMP','0',NULL,'Template for HPE ProLiant DL380 servers with HP iLO version 4 and later.\r\n\r\nMIBs used:\r\nCPQHLTH-MIB\r\nSNMPv2-MIB\r\nCPQNIC-MIB\r\nCPQSINFO-MIB\r\nCPQIDA-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','379aaf7e87574debb4f5c3947a22ec68');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10433',NULL,'DELL PowerEdge R720 by HTTP','3','-1','2','','','DELL PowerEdge R720 by HTTP','0',NULL,'Template for DELL PowerEdge R720 servers with iDRAC 8/9 firmware 4.32 and later and Redfish API enabled.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','9643f22821104f809e2486be83e1816e');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10434',NULL,'DELL PowerEdge R720 SNMP','3','-1','2','','','DELL PowerEdge R720 SNMP','0',NULL,'Template for DELL PowerEdge R720 servers with iDRAC version 7 and later.\r\n\r\nMIBs used:\r\nIDRAC-MIB-SMIv2\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','fe5b8448661f41b9a6d948fccd7f9045');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10435',NULL,'DELL PowerEdge R740 by HTTP','3','-1','2','','','DELL PowerEdge R740 by HTTP','0',NULL,'Template for DELL PowerEdge R740 servers with iDRAC 8/9 firmware 4.32 and later and Redfish API enabled.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','3f707f39c32a4b6e8b214c38a260f6f9');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10436',NULL,'DELL PowerEdge R740 SNMP','3','-1','2','','','DELL PowerEdge R740 SNMP','0',NULL,'Template for DELL PowerEdge R740 servers with iDRAC version 7 and later.\r\n\r\nMIBs used:\r\nIDRAC-MIB-SMIv2\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','9fde0e1c36f8453da72f97535d4e74ca');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10437',NULL,'DELL PowerEdge R820 by HTTP','3','-1','2','','','DELL PowerEdge R820 by HTTP','0',NULL,'Template for DELL PowerEdge R820 servers with iDRAC 8/9 firmware 4.32 and later and Redfish API enabled.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','1e9fe6b88c7542638c0f5d94484858b2');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10438',NULL,'DELL PowerEdge R820 SNMP','3','-1','2','','','DELL PowerEdge R820 SNMP','0',NULL,'Template for DELL PowerEdge R820 servers with iDRAC version 7 and later.\r\n\r\nMIBs used:\r\nIDRAC-MIB-SMIv2\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','d41c5d0fa91545d68cced1b5dabe4bf1');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10439',NULL,'DELL PowerEdge R840 by HTTP','3','-1','2','','','DELL PowerEdge R840 by HTTP','0',NULL,'Template for DELL PowerEdge R840 servers with iDRAC 8/9 firmware 4.32 and later and Redfish API enabled.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','20147f00f92d4240aab0b70cf578c022');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10440',NULL,'DELL PowerEdge R840 SNMP','3','-1','2','','','DELL PowerEdge R840 SNMP','0',NULL,'Template for DELL PowerEdge R840 servers with iDRAC version 7 and later.\r\n\r\nMIBs used:\r\nIDRAC-MIB-SMIv2\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','fc834b8da8864678b55557e9a237eac9');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10441',NULL,'Systemd by Zabbix agent 2','3','-1','2','','','Systemd by Zabbix agent 2','0',NULL,'Get systemd units metrics from plugin for the zabbix-agent2.\r\n  1. Setup and configure zabbix-agent2 compiled with the Systemd monitoring plugin.\r\n  2. Set filters with macros if you want to override default filter parameters.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','90ac276995294a6aa88462c032d2ddaf');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10442',NULL,'GridGain by JMX','3','-1','2','','','GridGain by JMX','0',NULL,'The template to monitor GridGain In-Memory Computing Platform by Zabbix that work without any external scripts.\r\n  It works with both standalone and cluster instances.\r\n  The metrics are discoverable and collected by JMX.\r\n  Current JMX tree hierarchy contains classloader by default. Add the following jvm option `-DIGNITE_MBEAN_APPEND_CLASS_LOADER_ID=false`to will exclude one level with Classloader name.\r\n  You can set {$GRIDGAIN.USER} and {$GRIDGAIN.PASSWORD} macros in the template for using on the host level.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','47d87c39c121429b98a18f641aa443ea');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10443',NULL,'F5 Big-IP SNMP','3','-1','2','','','F5 Big-IP SNMP','0',NULL,'MIBs used:\r\nRFC1213-MIB\r\nF5-BIGIP-LOCAL-MIB\r\nF5-BIGIP-SYSTEM-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','44c2c2d94a4447c6a924386640e4854a');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10444',NULL,'Website certificate by Zabbix agent 2','3','-1','2','','','Website certificate by Zabbix agent 2','0',NULL,'The template to monitor TLS/SSL certificate on the website by Zabbix agent 2 that works without any external scripts.\r\nZabbix agent 2 with the WebCertificate plugin requests certificate using the web.certificate.get key and returns JSON with certificate attributes.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/428309-discussion-thread-for-official-zabbix-template-tls-ssl-certificates-monitoring\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','5630ec1b1baf449abe1bc5521f85fe6c');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10445',NULL,'Cloudflare by HTTP','3','-1','2','','','Cloudflare by HTTP','0',NULL,'The template to monitor Cloudflare to see your web traffic and DNS metrics. It works without any external scripts and uses Script item.\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','08ef3d687d754b0aba17e1dcbd77d4bd');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10446',NULL,'Cisco ASAv SNMP','3','-1','2','','','Cisco ASAv SNMP','0',NULL,'Template Net Cisco ASAv\r\n\r\nMIBs used:\r\nCISCO-PORT-MIB\r\nCISCO-MEMORY-POOL-MIB\r\nCISCO-REMOTE-ACCESS-MONITOR-MIB\r\nIF-MIB\r\nRFC1213-MIB\r\nCISCO-PROCESS-MIB\r\nENTITY-MIB\r\n CISCO-REMOTE-ACCESS-MONITOR-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','75d009cd4dc84ee7a8fc479fa2fbaeee');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10447',NULL,'Travis CI by HTTP','3','-1','2','','','Travis CI by HTTP','0',NULL,'Template for monitoring Travis CI https://travis-ci.com\r\nYou must set {$TRAVIS.API.TOKEN} and {$TRAVIS.API.URL} macros.\r\n  {$TRAVIS.API.TOKEN} is a Travis API authentication token located in User -> Settings -> API authentication.\r\n  {$TRAVIS.API.URL} could be in 2 different variations:\r\n   - for a private project : api.travis-ci.com\r\n   - for an enterprise projects: api.example.com (where you replace example.com with the domain Travis CI is running on)\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','8cdbe00a2a3046ee962d28d32567968a');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10448',NULL,'InfluxDB by HTTP','3','-1','2','','','InfluxDB by HTTP','0',NULL,'Get InfluxDB metrics by HTTP agent from Prometheus metrics endpoint.\r\nFor organization discovery template need to use Authorization via API token. See docs: https://docs.influxdata.com/influxdb/v2.0/security/tokens/\r\n\r\nDon\'t forget change macros {$INFLUXDB.URL}, {$INFLUXDB.API.TOKEN}.\r\nSome metrics may not be collected depending on your InfluxDB instance version and configuration.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','a6fe3640b23544e7ae15d438b38ce1cd');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10449',NULL,'VMWare SD-WAN VeloCloud by HTTP','3','-1','2','','','VMWare SD-WAN VeloCloud by HTTP','0',NULL,'Template for monitoring VMWare SD-WAN VeloCloud https://www.vmware.com/products/sd-wan.html\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','e1ca624566424496bff9d90c261ab37b');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`,`uuid`) values ('10450',NULL,'PFSense SNMP','3','-1','2','','','PFSense SNMP','0',NULL,'Template for monitoring pfSense by SNMP\r\nSetup:\r\n  1. Enable SNMP daemon at Services in pfSense web interface https://docs.netgate.com/pfsense/en/latest/services/snmp.html\r\n  2. Setup firewall rule to get access from Zabbix proxy or Zabbix server by SNMP https://docs.netgate.com/pfsense/en/latest/firewall/index.html#managing-firewall-rules\r\n  3. Link template to the host\r\n  \r\n\r\n\r\nMIBs used:\r\nBEGEMOT-PF-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nUCD-DISKIO-MIB\r\nUCD-SNMP-MIB\r\n\r\nTemplate tooling version used: 0.40','1','1','','','','','','1','0','0','16f281aeb8904d3db8b66dda94611fcc');
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('1','10333','{#CLUSTER.NAME}',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('2','10333','{#DATACENTER.NAME}',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('4','10334','{#CLUSTER.NAME} (vm)',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('6','10334','{#HV.NAME}',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('16','10367','{#CLUSTER.NAME}',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('17','10367','{#DATACENTER.NAME}',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('19','10368','{#CLUSTER.NAME} (vm)',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('21','10368','{#HV.NAME}',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('35','10388','MongoDB sharded cluster/{#REPLICASET}',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('37','10389','MongoDB sharded cluster/{#ID}',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('66','10334','{#DATACENTER.NAME}/{#VM.FOLDER} (vm)',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('69','10368','{#DATACENTER.NAME}/{#VM.FOLDER} (vm)',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('133','10333','','12',NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('134','10334','','12',NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('135','10367','','12',NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('136','10368','','12',NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('137','10388','','13',NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('138','10389','','13',NULL);
INSERT INTO `interface` (`interfaceid`,`hostid`,`main`,`type`,`useip`,`ip`,`dns`,`port`) values ('1','10084','1','1','1','127.0.0.1','','10050');
INSERT INTO `interface` (`interfaceid`,`hostid`,`main`,`type`,`useip`,`ip`,`dns`,`port`) values ('2','10333','1','1','1','{#HV.IP}','','10050');
INSERT INTO `interface` (`interfaceid`,`hostid`,`main`,`type`,`useip`,`ip`,`dns`,`port`) values ('3','10334','1','1','1','{#VM.IP}','','10050');
INSERT INTO `interface` (`interfaceid`,`hostid`,`main`,`type`,`useip`,`ip`,`dns`,`port`) values ('4','10367','1','1','1','{#HV.IP}','','10050');
INSERT INTO `interface` (`interfaceid`,`hostid`,`main`,`type`,`useip`,`ip`,`dns`,`port`) values ('5','10368','1','1','1','{#VM.IP}','','10050');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('1','10093','Service state','c363fc0046f4493eb7ba6379c41d3e58');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('2','10094','Service state','2ad1e9aeb097470ba36a09c56c67eadd');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('3','10095','Service state','3fea65dd433444ac86936134d0a28fd2');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('4','10096','Service state','17353d47bd0a4a03a8f3ab799207e157');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('5','10097','Service state','ddbdab3aa88f4ad0b331a65504cceca5');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('6','10098','Service state','e0acc1611fcf43e38d6d1de761c48409');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('7','10099','Service state','1fb344806bc84930a4c45b84fd375cc8');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('8','10100','Service state','603906e741e94b349db9e5116aa2c81b');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('9','10101','Service state','41d22d9ad511457ba57ff86c11453f0b');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('10','10102','Service state','80377235a65c4d119745137e4658ef67');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('11','10103','Service state','1d4d40a040d84b0eae345be144dee1b7');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('12','10186','Service state','bdb5d65d925542eaa61c302dc40fbfe8');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('13','10264','Service state','452297e814a84b08a72730a7b777e378');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('14','10265','Service state','a5d1f911fb264bd4bc087ea582626d7f');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('15','10266','Service state','53c8528c18814f30a45d1540ab9e5c00');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('16','10267','Service state','5c0883d194e8494498474106c22be2ca');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('17','10301','Service state','c369d410303349b4973431b6ff8dcb85');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('18','10303','Service state','aaf7d0b8b306412b8a3272343708518f');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('19','10308','Service state','4980ec41c6644ecb9d5b52027a381fd8');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('20','10309','Service state','a8a0c20f1d404a79900064ac5d11a8b2');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('21','10310','Service state','ae3eec95cd1c440ba6c67ed5d7b7b915');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('22','10316','Service state','4f2d7ca3c89246c6b691557447230031');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('23','10317','Service state','622c38d0af2a4b6ea7a640a5d1a22b93');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('24','10318','Service state','8effc3f81db14540996e2373dde6eca9');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('25','10319','Service state','acd57d4f29a34286a801ce49cd6553fe');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('26','10320','Service state','f2e8233fcf0a4dd2b53a82ca48436a88');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('27','10322','Service state','15d416d869894fdb959ca2cda2c5e37c');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('28','10323','Service state','94147888c7ad4f5bae864eb2698f0237');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('29','10324','Service state','1735a8d251b24c3fbab32e766064536b');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('30','10325','Service state','5f3f78a3470c48b69442d942f21d11d0');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('31','10326','Service state','41be60c561114627b861677603b92acb');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('32','10327','Service state','03cde96b90a641598db572a662dc2064');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('33','10328','Service state','45ad479873b84113a98fa21b21081c65');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('34','10330','Service state','1caa1e7c41e14c7492ab8112f93ea068');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('35','10331','Service state','8e8fa515c14c4ac181db791c2c68c518');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('36','10335','Service state','31c489581d8b4246942c663b88fbaf9f');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('37','10336','Service state','d6e38832f2d44ec0bf6761e36fd7668f');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('38','10353','Service state','22fe6d6c74454775994f07fc05d7bafd');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('39','10355','Service state','1bd791d250e441aeb1c73e499d96e98e');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('40','10357','Service state','372bc939f3924aafa13c4821b83a9276');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('41','10363','Service state','6c967c4df18d4c7ebb0fd4be17df292a');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('42','10365','Service state','547a6b8002d44a8f8f363023c6097b1e');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('43','10175','Service state','25d04e2838af4fcca9ddd21df6781497');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('44','10378','Service state','a84db909cb1841c688acc6b4b1b28af4');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('45','10314','Windows service state','5d9a045df1df48daaa6752bd75f1681d');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('46','10325','Windows service state','d65f1af3c1e24a338983c52c5aa07d27');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('47','10326','Windows service state','6dc834d8e50842d3a7337b0f88540b61');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('48','10350','Windows service state','af7bd46d70ed4058afa4961d130dc0b2');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('49','10050','Zabbix agent ping status','e5a39fd666b04b70b6eea53e2373b564');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('50','10292','Zabbix agent ping status','9bf3eef7e8d8402ca6f826b377ea2db6');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('51','10174','VMware VirtualMachinePowerState','78f08f5c5c0047b999a2e8daa96cf8b7');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('52','10173','VMware status','3c59c22905054d42ac4ee8b72fe5f270');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('53','10175','VMware status','2b324fd8d7624874a3a81449b62c2cd6');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('54','10366','VMware status','5e5e3b01ef334bd39441568ebd0c31c0');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('55','10047','Value cache operating mode','97bbea700550483bbd8405b4dd9d8005');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('56','10261','Value cache operating mode','5dff563dde3c45d8b6d92525111384c6');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('57','10251','ENTITY-SENSORS-MIB::EntitySensorStatus','d42214398aea4362b4fc61a090f188e1');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('58','10254','ENTITY-SENSORS-MIB::EntitySensorStatus','318f3041aea04848a223de86e589c232');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('59','10183','EtherLike-MIB::dot3StatsDuplexStatus','6c35799bc36d413b94c0ac110224f208');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('60','10188','IF-MIB::ifOperStatus','4578589110ec40e19297e1d35d17c82f');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('61','10190','IF-MIB::ifOperStatus','692e46f1836c4e2682a0dc882fec89a0');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('62','10192','IF-MIB::ifOperStatus','4b84f531e2df454a8824070608bfbf49');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('63','10276','ifOperStatus','8513cf23b8d34952b92a31bbd82a31d3');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('64','10285','ifOperStatus','4827063819f14d539f509552c84f5f94');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('65','10342','ifOperStatus','9bc9524635a349409e244ad5215c80c1');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('66','10188','IF-MIB::ifType','4e22cbad0d9146059d9fbf89714e6460');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('67','10190','IF-MIB::ifType','7a288ac5cdbf429b9d568b12b312ad70');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('68','10192','IF-MIB::ifType','41952f292f004232b94f4d201e6bf727');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('69','10204','zabbix.host.available','ced60845a741400390ba002e69e26b0f');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('70','10050','zabbix.host.available','0d5e922550954e6bad89b22f1d9d0c65');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('71','10207','TIMETRA-CHASSIS-MIB::TmnxDeviceState','95a194271a584008a81564fd80189c5a');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('72','10208','SW-MIB::swSensorStatus','73618556ee4b4e8f9ec9acf0893e13ea');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('73','10208','SW-MIB::swOperStatus','54427fdf694547c598e3662df09a980a');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('74','10210','FOUNDRY-SN-AGENT-MIB::snChasPwrSupplyOperStatus','fe1c4f9f35a34b6189110fc95e21b086');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('75','10211','FOUNDRY-SN-AGENT-MIB::snChasPwrSupplyOperStatus','7b767e61825544bb857347f303a1f077');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('76','10210','FOUNDRY-SN-AGENT-MIB::snChasFanOperStatus','d457efd8cee74f168bd88f4fb2376142');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('77','10211','FOUNDRY-SN-AGENT-MIB::snChasFanOperStatus','41fadae69fa64af4a21c853fc00f23c0');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('78','10217','CISCO-ENVMON-MIB::CiscoEnvMonState','96da9a43fa60420696714c57d3e72f13');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('79','10221','F10-S-SERIES-CHASSIS-MIB::chSysFanTrayOperStatus','b389c759db0448ffbe28d4572fbfb3e9');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('80','10221','F10-S-SERIES-CHASSIS-MIB::chSysPowerSupplyOperStatus','2532df482bd348ba8202c3eb2b76340b');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('81','10222','MY-SYSTEM-MIB::mySystemFanIsNormal','5889e276245d411bacd130427ae4a5d4');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('82','10223','EQUIPMENT-MIB::swFanStatus','e7ab460cf1bf4fca8afc22566257fc3a');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('83','10223','EQUIPMENT-MIB::swPowerStatus','a46e6b21933f4aa7be17f9f11b1356ee');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('84','10224','EXTREME-SYSTEM-MIB::extremeFanOperational','b71a1b2d06324275a37a1952f13e29b3');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('85','10224','EXTREME-SYSTEM-MIB::extremeOverTemperatureAlarm','34c686dbaf8649b3b7dcc243068a739a');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('86','10224','EXTREME-SYSTEM-MIB::extremePowerSupplyStatus','85bfdbc16637406fb5f1a23a15f16c77');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('87','10227','HH3C-ENTITY-EXT-MIB::hh3cEntityExtErrorStatus','d7832aa00dd743bb8451cabff4e90e60');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('88','10250','HP-ICF-CHASSIS::hpicfSensorStatus','3c0731bf0669419fa8ebfdf9f7ec14de');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('89','10229','HUAWEI-ENTITY-EXTENT-MIB::hwEntityFanState','5d3f20a830b34f668c5f3ece41a039cd');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('90','10230','ICS-CHASSIS-MIB::icsChassisFanOperStatus','39299506ad14445fa7b7a9e78cc54619');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('91','10230','ICS-CHASSIS-MIB::icsChassisSensorSlotOperStatus','4c80241c4d5d4b949577e9741710a32b');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('92','10230','ICS-CHASSIS-MIB::icsChassisPowerSupplyOperStatus','535cb21845474749994bf7c395e39312');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('93','10231','JUNIPER-ALARM-MIB::jnxRedAlarmState','3aaa451c55cd4e72ab84b65dd8310564');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('94','10231','JUNIPER-ALARM-MIB::jnxOperatingState','64128e7f2adf44988b0ca3edd76cba61');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('95','10251','ENTITY-STATE-MIB::EntityOperState','bd1dc90aa54849d0a5ae9bdf368d03a9');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('96','10254','ENTITY-STATE-MIB::EntityOperState','15ba17df88eb435d9d48145fba8d9029');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('97','10234','FASTPATH-BOXSERVICES-PRIVATE-MIB::boxServicesPowSupplyItemState','d11e2b2f01c641728d1b7f764fa49f37');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('98','10234','FASTPATH-BOXSERVICES-PRIVATE-MIB::boxServicesFanItemState','3046d246b1064c749c1c9144442c0fac');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('99','10234','FASTPATH-BOXSERVICES-PRIVATE-MIB::boxServicesTempSensorState','4da55a4de7284012890e1fd5458f039a');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('100','10235','QTECH-MIB::sysFanStatus','fe2ada3a06844e138b3c4fed1a8c8d2d');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('101','10235','QTECH-MIB::sysPowerStatus','439cee4220954720aa34725fdc6c365e');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('102','10256','CPQSINFO-MIB::status','8374297ea234491b980591a8daa88e1f');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('103','10256','CPQHLTH-MIB::cpqHeTemperatureLocale','f1e590a8cc744e22b900595851833357');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('104','10256','CPQIDA-MIB::cpqDaCntlrModel','140a21785b764c95a3f78c8c05ed0844');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('105','10256','CPQIDA-MIB::cpqDaPhyDrvStatus','68bc7370fb8a43ee9957240e29636562');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('106','10258','IMM-MIB::systemHealthStat','61bded84be1d419083d8bd8a8bd25152');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('107','10255','IDRAC-MIB-SMIv2::ObjectStatusEnum','f90ca4bbf10f41deb68b458b795f6bb2');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('108','10255','IDRAC-MIB-SMIv2::StatusProbeEnum','ba7ff497325e4488af87afcc58e0cd42');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('109','10255','IDRAC-MIB-SMIv2::physicalDiskComponentStatus','3277b276bbb241699ac6011387e90126');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('110','10255','IDRAC-MIB-SMIv2::BooleanType','7648c14caa6e4dd4b0d2bc28e594090c');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('111','10255','IDRAC-MIB-SMIv2::physicalDiskMediaType','3d57a8ee9167490cabf6429d9cd14b4a');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('112','10255','IDRAC-MIB-SMIv2::batteryState','3459ea1c2ec94b3b8e39b8b7f76def81');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('113','10255','IDRAC-MIB-SMIv2::virtualDiskLayout','65e49bfeafcd4a7287ac779cf405d4eb');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('114','10255','IDRAC-MIB-SMIv2::virtualDiskOperationalState','6b8270d891b54aef8d7889ddce498ff2');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('115','10255','IDRAC-MIB-SMIv2::virtualDiskWritePolicy','12019ceefc2e4ab896ea8106efac48b8');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('116','10255','IDRAC-MIB-SMIv2::virtualDiskState','9da59b80065d4c46a270a544e00f18d7');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('117','10256','CPQIDA-MIB::cpqDaPhyDrvSmartStatus','54b288da67e1431c9d401cf47a518bcc');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('118','10256','CPQIDA-MIB::cpqDaAccelStatus','20d96ea63e994ba49244b94a4c24aec3');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('119','10256','CPQIDA-MIB::cpqDaAccelBattery','7502d61cf7644a2d9cff7462f53569ee');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('120','10256','CPQIDA-MIB::cpqDaPhyDrvMediaType','8351a024aa4d42d1915b44abe8acc4aa');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('121','10256','CPQIDA-MIB::cpqDaLogDrvFaultTol','442c9095de9f4aa5bcca659292b2c12b');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('122','10256','CPQIDA-MIB::cpqDaLogDrvStatus','8db38b47aba64739ae9f078f43b42888');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('123','10329','PostgreSQL recovery role','9f38c01c325248d4b538c0582432b541');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('124','10357','PostgreSQL recovery role','2e376ee568d04e7bbe98cbae4181f313');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('125','10329','PostgreSQL replication status','0fba38eefa4c4073b46d3f8579fda314');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('126','10357','PostgreSQL replication status','7f553f18ef6544ceaa4b50c4ebf0e583');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('127','10276','Linux::Interface protocol types','e2db25377a2b49c897bbb8b6c30831e2');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('128','10285','Linux::Interface protocol types','4d912f1ee95942038f306ddefb3a57b3');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('129','10342','Linux::Interface protocol types','8f709b791d1342a48615632e86969c92');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('130','10291','Win32_NetworkAdapter::AdapterTypeId','dd37c51d4ded48ceb449fa633dd707e2');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('131','10348','Win32_NetworkAdapter::AdapterTypeId','7300d3f66dec4f90bcd6889d206db89f');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('132','10291','Win32_NetworkAdapter::NetConnectionStatus','3265d77e34ba44f688b7aaceeeccda6b');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('133','10348','Win32_NetworkAdapter::NetConnectionStatus','a1e647b6b26547bfbc044d213150c71b');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('134','10301','RabbitMQ healthcheck','08ee896f31a1457a8e9b4f6f251700d4');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('135','10303','RabbitMQ healthcheck','55188bbb2ede4300a6292b373ee36ab7');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('136','10301','Alarm state','ce579def20ac488dbce1ff69baaa8c50');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('137','10303','Alarm state','e65c3d3e8ea443a281b37c51ca461c26');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('138','10304','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsEquipmentOperability','e1686896f31e483f9add962dbbd90afb');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('139','10304','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsLsOperState','398aa5bf5eb44a8c8dd96babd98f1bd3');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('140','10304','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsStoragePDriveStatus','9b7c7078039c4e348ab417da71b96f5c');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('141','10304','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsStorageLunType','7d3e38476c894ae59ecac6640b24f833');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('142','10304','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsEquipmentPresence','5055674c42a241e3a2156de1dc1715bf');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('143','10310','Redis bgwrite status','098c2240a8e947fc9f6f0a677ffcbc0e');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('144','10310','Redis flag','3b6cd97c65d14e10bdabf5c42d767ad9');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('145','10310','Redis repl offset','47c80efdf46745f1959eee76f68014e7');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('146','10310','Redis bgsave time','82f4dc4ef0c9471d82dbe3605f4f31d0');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('147','10318','Docker flag','c289195aa4dc47ab883fa95c9cb6fd07');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('148','10322','ES cluster state','d651bdf75d0849d5ab2b0802fab76e22');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('149','10323','Replicas state','4d926c30529447b3816cec3f1440b47a');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('150','10324','Etcd healthcheck','f25e21a70baa4e009bdbcb44acb1a22e');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('151','10324','Etcd leader','7bcaf8a520e24613a96d49e63a91a55b');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('152','10325','Application pool state','63d1ad6b4cf643da870b14c53da6c52f');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('153','10326','Application pool state','636c6915a8154b6ea1ea5b00f015c149');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('154','10327','MSSQL DB state','bac1a10dad134d50add5bc9550e2ebf3');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('155','10327','MSSQL AG Connected state','bfbb00eb85d747dabeda2954a5d659b7');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('156','10327','MSSQL AG Join state','47413c135c094cdc8b59f18a9b195a78');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('157','10327','MSSQL AG Operational state','a570f341d9a8470797aecfebd376b2b8');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('158','10327','MSSQL AG Recovery health','4ec6a96ff6c64756b2f27e47972fd9f6');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('159','10327','MSSQL AG Role','596556fba6064efb8155233371eb2950');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('160','10327','MSSQL AG Synchronization health','2ab0923b3ce14ffc9dd454114f6b15be');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('161','10327','MSSQL - Yes / No','c66ee50a8b3f4b6788b732bb8a6b514e');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('162','10327','MSSQL Mirroring State','f1c105c262c5476798a93eaa4c46fbda');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('163','10327','MSSQL Mirroring Role','09aaa82ccd6a444b80d5d3bb182fbafd');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('164','10327','MSSQL Safety level','e70421b2c3db4ce1937791bdb432040e');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('165','10327','MSSQL Witness state','aa9de6e21d08486db04f29e10d11a94c');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('166','10328','Oracle DB open status','d0912db18fe54941b9345ebf869fd1a6');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('167','10335','Oracle DB open status','015a0c94ba2644c6aa343d3f792a4072');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('168','10328','Oracle DB role','df05d594141f42ebb294cf6adca5fd6b');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('169','10335','Oracle DB role','afade10cda4e453982355342ba9d8d9f');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('170','10328','Oracle instance status','41e105c52bf045899c3c4a1cb4e16865');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('171','10335','Oracle instance status','4893318c780f47719e12e839c9a846c2');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('172','10328','Oracle instance role','97b689d7ddc04bcd9b9f92af6ba783bd');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('173','10335','Oracle instance role','53d97b73db8449959420e03114d345c3');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('174','10328','Oracle archiver state','3afaab75342c4be186fb4f595ed62a31');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('175','10335','Oracle archiver state','f39e64058fef423bb858ba45834a3455');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('176','10328','Oracle tablespace status','c6633e4ef9a84fa7b843529479a06158');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('177','10335','Oracle tablespace status','f14ed94cf12740a19e221ddaa4855c54');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('178','10328','Oracle Archivelog status','79af6c068ba141ba9806f4341edd9266');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('179','10335','Oracle Archivelog status','5a90da8dd6124159a7f82a7a996f0a53');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('180','10328','Oracle force log status','f00ca5c45ab84df788820af2642e4784');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('181','10335','Oracle force log status','1d9f4a44f2f94a799768f147cb712331');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('182','10328','Oracle log mode','809554f521d645ea8e8850c3b1f41579');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('183','10335','Oracle log mode','910dd4a87f75434289fa2e345778d18d');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('184','10353','Ceph cluster status','2a4b2a8c55ba48b2a815e4123c9ea7fa');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('185','10360','Exchange database copy role','4a0e19e58ade4e8c878a6b87f4021416');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('186','10361','Exchange database copy role','0797c152a163407aa9490a63f80a8fd1');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('187','10360','Exchange database state','2d131c4a033c4145a6bd66ec4c0c030a');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('188','10361','Exchange database state','a4fac47b56e4470c9c6d435d7eb06845');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('189','10362','GitLab healthcheck','3b40391bb8b6472e9c3fd8e1f001fe04');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('190','10364','Kafka controller state','cf2440fb69c24371b231cb0a69002333');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('191','10365','Vault flag','46edbd58c7384b53bb31775244c23343');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('192','10371','ProStar MPPT charge state','1703c3aeb1b24641821e1c6d2cb4c8b7');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('193','10371','ProStar MPPT load state','b5403a0805a54b9294f69a1e11a438b1');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('194','10372','ProStar PWM charge state','f94eb6ad54c44281878c7c018c6209d1');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('195','10372','ProStar PWM load state','f0be8765c74e4c4788d4ff99a6c5ccd4');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('196','10373','SunSaver MPPT charge state','b51b9440e801481fbb76f28b4a5431d1');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('197','10373','SunSaver MPPT load state','f21076ed51104b84ba4d78dd74bd1a5b');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('198','10374','SureSine load state','1d6f60ea7d414cb8a26ddad70fc352b2');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('199','10375','TriStar MPPT 600V charge state','8a0dfdf98d254c219905751cccc878d7');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('200','10376','TriStar MPPT charge state','3c6c60ef422c4788bf0c5b74ffab7ef0');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('201','10377','TriStar PWM charge state','4985c4742d5844e7bc0aee5aeeacc436');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('202','10377','TriStar PWM control mode','252c3fb63cc34bb1a36ae6e9cbe5880c');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('203','10377','TriStar PWM load state','735e1a0d990a4c449e59eeb402f3b40e');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('204','10378','FAS3220 HA cannot takeover cause','e078162b11ff49f59c3ab6d905f88f2c');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('205','10378','FAS3220 HA settings','d6993f0258dd4978a85aa5c141f1706e');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('206','10378','FAS3220 NVRAM battery status','1fe2bf70bd63468584708a9d09eb42a1');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('207','10378','FAS3220 Port health','ee5e67c90bca4ded84df2d82589bc2fb');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('208','10378','FAS3220 Port link state','bd6ea858292c414d9bfd435631001ef5');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('209','10378','FAS3220 Port role','c598c387157d4450b5bf8f68e6e794a4');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('210','10378','FAS3220 Port speed','6b0fec10a0eb4c70a8982419c6e635b9');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('211','10378','FAS3220 Port UP by administrator','c50cdd6dbe19482abdb870c12e7c7b8d');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('212','10379','Computer online','d1b719ea85464279bd473fcdb34008da');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('213','10379','Computer state','5313fc2399b24216945ed6416a00d55d');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('214','10379','Jenkins healthcheck','a51dacf033d1423a886ca9dbfdf9b175');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('215','10379','Service state','b45a6b0148074212bf45d6bb311565c2');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('216','10380','Login status','4c14241141504a9d852d83965c309f31');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('217','10256','CPQHLTH-MIB::cpqHeTemperatureCondition','1a03c5602a4a49f8839d820c666434fc');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('218','10382','HTTP response status code','70add725d6a84f6f9ed0917107dfffc9');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('219','10385','Huawei storage: Controller role','b5c6d9d67da54531a918c93a9c98cec8');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('220','10385','Huawei storage: Health status','b7f399070ee0419cac1722f80268ff1a');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('221','10385','Huawei storage: LUN status','e361f6b8fe92430f86d0e3dc70118ba9');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('222','10385','Huawei storage: Running status','ae5093d843784258aa32437cde486574');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('223','10300','RabbitMQ healthcheck','78275d6daacf42b4b97e3d806dfe81fe');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('224','10302','RabbitMQ healthcheck','3380e05a15774dad92e77c983448698b');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('225','10386','MongoDB flag','9f921e1503e74204b8f128966f9562bc');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('226','10386','ReplicaSet node state','a99141555eff42ff8d367f10d9a7c569');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('227','10386','Service state','b37ba44823e34a13a119f86f3d58a65a');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('228','10387','MongoDB flag','2014769595e34d4bb18dbcf4d9eaf112');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('229','10387','Service state','3cedce4712fa4a3eba63ccd7a790ecf6');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('230','10390','CISCO-ENVMON-MIB::CiscoEnvMonState','673c7626d11b4867aba08e96b0fbd149');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('231','10390','EtherLike-MIB::dot3StatsDuplexStatus','4c04fea7546044d9a9c64762a9e1ebdd');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('232','10390','IF-MIB::ifOperStatus','346b197cb4fe42cb9b304ce246e5924f');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('233','10390','IF-MIB::ifType','94e4f1da1ff24b96bdccf04ec663a1ae');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('234','10390','Service state','3a72216b3fea4ad482d0e3655e407747');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('235','10390','zabbix.host.available','868c28a7406c4ab3b48b783a6e7590ba');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('236','10391','CISCO-ENVMON-MIB::CiscoEnvMonState','cbeb53fa3c2a4b16b7f7ee92265efd8c');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('237','10391','EtherLike-MIB::dot3StatsDuplexStatus','5ef472cb5f424ef9a7393156204613ba');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('238','10391','IF-MIB::ifOperStatus','73b7c034142043b689792e1e71dd5872');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('239','10391','IF-MIB::ifType','635461b9ca404cc1b92c1fab0c6327f6');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('240','10391','Service state','142fe822cc424a76899551b6f29799d9');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('241','10391','zabbix.host.available','939c7551b81e40e9b053e624211d0901');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('242','10392','CISCO-ENVMON-MIB::CiscoEnvMonState','fea34445b6cd4847b420d212f9b0201e');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('243','10392','EtherLike-MIB::dot3StatsDuplexStatus','867b0e42f8a24a278ee15476aeadfa0b');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('244','10392','IF-MIB::ifOperStatus','3534f9f22afe4f98a712a86ce755f491');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('245','10392','IF-MIB::ifType','88b99531b08248e8be1fc0a3210acee1');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('246','10392','Service state','653ce2314e6f499b84250048df1314f8');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('247','10392','zabbix.host.available','690c4c1545894d049ac8e26e3de7ec9c');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('248','10393','CISCO-ENVMON-MIB::CiscoEnvMonState','e47b3ba8fb9c4ecf82701ddf571d55b6');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('249','10393','EtherLike-MIB::dot3StatsDuplexStatus','412b00b4bfbc48b4906370635c12dcee');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('250','10393','IF-MIB::ifOperStatus','358db91b44e645df92072f0a1449de2e');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('251','10393','IF-MIB::ifType','877039dc6b0a467783828f3421887b83');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('252','10393','Service state','1d4c62bd989748a0b7947b6455405d96');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('253','10393','zabbix.host.available','ff706c036eac4ef88570e41629e65514');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('254','10394','CISCO-ENVMON-MIB::CiscoEnvMonState','52875f5c6b1b4bb3987c3baa03860d4d');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('255','10394','EtherLike-MIB::dot3StatsDuplexStatus','8decf4d7d8744711b5f2ea68b5e73d14');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('256','10394','IF-MIB::ifOperStatus','e8815fad611e47389c987c88a029cece');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('257','10394','IF-MIB::ifType','93f29c48ad8b4bc7afe036817d946b18');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('258','10394','Service state','ee7cb62782d44458abc9f7cca816dca8');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('259','10394','zabbix.host.available','6273854a740e41718cd1354f227cf4db');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('260','10251','IF-MIB::ifOperStatus','04fa3aad27e044a094dce939b3d361ec');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('261','10251','IF-MIB::ifType','afe0ce28ed5d49dd822cc7013356c599');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('262','10251','Service state','deb16b99706645929e300b0590f013f3');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('263','10251','zabbix.host.available','a85fe23199cd4d779655f690a706d7c7');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('264','10395','PowerNet-MIB::uioSensorStatusAlarmStatus','a808aadebf964e0cb6b8724bf1165013');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('265','10395','PowerNet-MIB::upsAdvBatteryReplaceIndicator','731b036e41d147ba81bfcfb7e99b561b');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('266','10395','PowerNet-MIB::upsAdvInputLineFailCause','f310a0bceb06404d9daee67ab578e4b8');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('267','10395','PowerNet-MIB::upsBasicBatteryStatus','795c75c652124ad282bad3dfd50b8e39');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('268','10395','Service state','cbd3d7c999244cd6a44a8fc566533005');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('269','10395','zabbix.host.available','781c568d935d40f2a43951488cf2e046');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('270','10327','MSSQL Job Run Status','eefa6e0e6f8b4facbc12004437b7ee8f');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('271','10397','Service state','bce54cbdf2b8487985f9c7847a4c4918');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('272','10398','Service state','047f0303f1bc424a959f5d0ceaab77c7');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('273','10400','PowerNet-MIB::uioSensorStatusAlarmStatus','30a78904cbc94fc58609dc1a11aa48ef');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('274','10400','PowerNet-MIB::upsAdvBatteryReplaceIndicator','ace379c23ae247f3b92ccffb9eef920c');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('275','10400','PowerNet-MIB::upsAdvInputLineFailCause','19686fc030ee4c6bb69aacd3b9c735ca');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('276','10400','PowerNet-MIB::upsBasicBatteryStatus','80593b554d0a431aa89a0c4960f8565c');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('277','10400','PowerNet-MIB::upsBasicOutputStatus','f41b7d5469e64557ab0cdb81526aeac0');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('278','10400','zabbix.host.available','edd7578bf71146dd88770a39eec537e0');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('279','10401','PowerNet-MIB::uioSensorStatusAlarmStatus','6940a4d08173433bb4bc8ff3b44e578c');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('280','10401','PowerNet-MIB::upsAdvBatteryReplaceIndicator','add26e1622ed4d1fbdb4a9bdbf7facb8');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('281','10401','PowerNet-MIB::upsAdvInputLineFailCause','2597173167e34be0943fb6c81f2597e5');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('282','10401','PowerNet-MIB::upsBasicBatteryStatus','7d2a66214d4b4b96890aa9e1c9bcf050');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('283','10401','PowerNet-MIB::upsBasicOutputStatus','351383a7383a4472a31c09009cf9d1f5');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('284','10401','zabbix.host.available','3aadc179423b4298b2e8a6e4850466a5');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('285','10402','PowerNet-MIB::uioSensorStatusAlarmStatus','55fecbd639c44c328b4199569a7305ef');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('286','10402','PowerNet-MIB::upsAdvBatteryReplaceIndicator','1ce6860b108948bda40d514fd4e3ed69');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('287','10402','PowerNet-MIB::upsAdvInputLineFailCause','db1fa20d76c8416c83fa0b7fda536fa8');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('288','10402','PowerNet-MIB::upsBasicBatteryStatus','50b6ae187875406ea8ba1669add70899');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('289','10402','PowerNet-MIB::upsBasicOutputStatus','9c5fd52c36f6451ea3f502a871e821d7');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('290','10402','zabbix.host.available','89597d423b454a42aa80fa8f7a20f273');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('291','10403','PowerNet-MIB::uioSensorStatusAlarmStatus','7cf932d3b9304f2cb151134e9ea3be82');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('292','10403','PowerNet-MIB::upsAdvBatteryReplaceIndicator','63c5f0e1601947e5a02abd25a07a9af4');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('293','10403','PowerNet-MIB::upsAdvInputLineFailCause','70d097ce846c45aeb3c8be031c427511');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('294','10403','PowerNet-MIB::upsBasicBatteryStatus','3424a9229a134b47b8544d611be082fb');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('295','10403','PowerNet-MIB::upsBasicOutputStatus','05a60d9c47274f5a8f6c92efe8158b8e');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('296','10403','zabbix.host.available','d4ee88b3cf5d4d95b27be2e7b2f20e3c');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('297','10404','PowerNet-MIB::uioSensorStatusAlarmStatus','b2af1e2dcb874d43949c383f9b347f36');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('298','10404','PowerNet-MIB::upsAdvBatteryReplaceIndicator','b06b54b07e6840e5a0c52ba7a6acf86a');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('299','10404','PowerNet-MIB::upsAdvInputLineFailCause','a62f96735c47467da94b6bcf98cc013d');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('300','10404','PowerNet-MIB::upsBasicBatteryStatus','ed12e8780c384caba8035fbb1c78e115');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('301','10404','PowerNet-MIB::upsBasicOutputStatus','ae2ed0c2c99a4ad496f7a35226e3d4f0');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('302','10404','zabbix.host.available','8cddc4f99ecb4866b1638b82b145ea8b');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('303','10405','PowerNet-MIB::uioSensorStatusAlarmStatus','498a3e64f190462b82c62f47e716b0c3');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('304','10405','PowerNet-MIB::upsAdvBatteryReplaceIndicator','828dc0d0c107463ea57d8c0ef5722199');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('305','10405','PowerNet-MIB::upsAdvInputLineFailCause','7f88ea61e33b4b6c981629dd542c885b');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('306','10405','PowerNet-MIB::upsBasicBatteryStatus','1f0464bf363c485bbaddccfacb7c58c9');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('307','10405','PowerNet-MIB::upsBasicOutputStatus','abac1b0ba200442c97a3fb3368b3f186');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('308','10405','zabbix.host.available','ab59a03434ae443ca2ee1bb2d77b5718');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('309','10406','PowerNet-MIB::uioSensorStatusAlarmStatus','864d59cbfcc8431cb334b812bf7ef3a3');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('310','10406','PowerNet-MIB::upsAdvBatteryReplaceIndicator','cc42cb7a7fb4417fa1c143e214958c1d');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('311','10406','PowerNet-MIB::upsAdvInputLineFailCause','a3bbd0be8c7c4dc1aa9accb9f22292c9');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('312','10406','PowerNet-MIB::upsBasicBatteryStatus','f801d4fb07c644e4be1f01e99ba48aa7');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('313','10406','PowerNet-MIB::upsBasicOutputStatus','28964e9cf2b849fbb2f8d998cecdacda');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('314','10406','zabbix.host.available','12058346f9e046388767c2939bbed2cf');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('315','10395','PowerNet-MIB::upsBasicOutputStatus','c536d9dc64724643a9291c9b601b1eac');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('316','10407','PowerNet-MIB::uioSensorStatusAlarmStatus','aec3362485c242ec928cb8ecfe5e61cf');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('317','10407','PowerNet-MIB::upsAdvBatteryReplaceIndicator','912d8834176b4fe4a2f6bd12ef3ee3c1');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('318','10407','PowerNet-MIB::upsAdvInputLineFailCause','e079fa8cc9614245b0fecf4b8f42feca');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('319','10407','PowerNet-MIB::upsBasicBatteryStatus','24229472978c42739cdbe7aa47e1d34c');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('320','10407','PowerNet-MIB::upsBasicOutputStatus','8c2c9721615c4408976f7632180ecfe3');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('321','10407','zabbix.host.available','625f28bd49f14e49a1a7a4da01429906');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('322','10408','PowerNet-MIB::uioSensorStatusAlarmStatus','8516e97893ed4f2ebe70766d17eeacde');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('323','10408','PowerNet-MIB::upsAdvBatteryReplaceIndicator','84387eb0a5ef4523ac5d990eb4a6a796');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('324','10408','PowerNet-MIB::upsAdvInputLineFailCause','58104ecf15d34fe38922f3fe5fa25027');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('325','10408','PowerNet-MIB::upsBasicBatteryStatus','43715c15fed840fc8e188d062c0ef2da');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('326','10408','PowerNet-MIB::upsBasicOutputStatus','d9b5340729684dd0a450b6de6b14b590');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('327','10408','zabbix.host.available','cdf3578a66db4cfda6c36b4bbb295173');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('328','10409','PowerNet-MIB::uioSensorStatusAlarmStatus','e2877a188bd24918992f8c7878550924');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('329','10409','PowerNet-MIB::upsAdvBatteryReplaceIndicator','33d83523ceee4f3e916c885ebb33e8b9');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('330','10409','PowerNet-MIB::upsAdvInputLineFailCause','c50ef9a9476d47e6935a6026bbb24d06');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('331','10409','PowerNet-MIB::upsBasicBatteryStatus','96a985d8351f48be86c5b00472b48feb');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('332','10409','PowerNet-MIB::upsBasicOutputStatus','160f7a39770d492c93403097650c1568');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('333','10409','zabbix.host.available','cc7a368057bc47eeb834dc9363183c59');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('334','10410','WildFly flag','e23e06cfd0ce4e069b9d996f101f6ee6');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('335','10411','WildFly flag','4004b5f2501f44a69dc86afce3daa4d1');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('336','10412','PowerNet-MIB::uioSensorStatusAlarmStatus','41e166e2a5f948488238198920ab4b17');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('337','10412','PowerNet-MIB::upsAdvBatteryReplaceIndicator','224af0a6a5db48ef9c8861bc61873ea9');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('338','10412','PowerNet-MIB::upsAdvInputLineFailCause','ded19296204545b9ab463d4fc65f3cfd');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('339','10412','PowerNet-MIB::upsBasicBatteryStatus','271d8f0594cf451a8aaa98c84850ebf7');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('340','10412','PowerNet-MIB::upsBasicOutputStatus','171d4d5bf01442e391b04f9e448df5a0');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('341','10412','zabbix.host.available','8b4f199f5e704cbea67182d4abf9b8de');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('342','10414','SNMP available','2b7c7c3eecb743e8a30ab3adc74ffd06');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('343','10414','ZYXEL AAM1212-51 / IES-612 port admin status','db7f61bebcac452c8081b2c58d1013d8');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('344','10414','ZYXEL AAM1212-51 / IES-612 port operational status','6c2a29dac43340399990340fe26a7a72');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('345','10415','SNMP available','494c8983c4cf453789d2f0bbbe5cbbf3');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('346','10415','ZYXEL ES3500-8PD operational mode port link up type','7cfe02e1eb224f6abe5216aaec31402c');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('347','10415','ZYXEL ES3500-8PD operational mode port speed duplex','b568c9f69a1a4dd5951f1121523475c9');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('348','10415','ZYXEL ES3500-8PD port admin status','4a20dd55c16b4c9082f267c532a4507a');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('349','10415','ZYXEL ES3500-8PD port operational status','17635045a1ee4b8bba21b7d44634c57f');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('350','10415','ZYXEL ES3500-8PD SFP status','875833a6ca71431da2b3747c4c1e3008');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('351','10416','SNMP available','c6ba6086ed584ba0a4dd58ffe8564fbf');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('352','10416','ZYXEL GS-4012F operational mode port link up type','82cce670bef64a47b326bb8b1a2f6cd8');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('353','10416','ZYXEL GS-4012F operational mode port speed duplex','d7d38cadffc240f9a01434546659d036');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('354','10416','ZYXEL GS-4012F port admin status','7456d212b8f44f7da215fc86f39e3956');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('355','10416','ZYXEL GS-4012F port operational status','afa699db0bfc4cfbb48729932967230e');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('356','10417','SNMP available','10dd3d9951014a38bc3517df54381a66');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('357','10417','ZYXEL IES-500x module status','efd6a6086011465ca956b1664f7d6474');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('358','10417','ZYXEL IES-500x module type','892651d2b1e3431490f2c531a50e2732');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('359','10417','ZYXEL IES-500x port admin status','9174dafc199e438994256eff4dd87bdd');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('360','10417','ZYXEL IES-500x port operational status','f64c046f1eca45e09dad683603f4674b');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('361','10418','SNMP available','5247e9e5efcd4b29b864e336619eafcf');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('362','10418','ZYXEL IES-6000 module status','0236177f088340ff8ce5adb9361b8df8');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('363','10418','ZYXEL IES-6000 module type','7ad4e124b8184fb8abc454c70c67e309');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('364','10418','ZYXEL IES-6000 port admin status','b20f50ac559f45369de16c04f5ccf523');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('365','10418','ZYXEL IES-6000 port operational status','2f3b061e1d6f46a3b8216b2398fc2896');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('366','10419','SNMP available','34ea860866f24498927b73f4ce438837');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('367','10419','ZYXEL IES1248-51 port admin status','b933d3a98256457d906de8f7da377bac');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('368','10419','ZYXEL IES1248-51 port operational status','e780cc91765849a0ace3d2eb2e4824a0');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('369','10420','SNMP available','ac3d8b1e51074733a8bce57814528d83');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('370','10420','ZYXEL MES-3528 operational mode port link up type','042fc0ecdef34baab224062d4f746b96');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('371','10420','ZYXEL MES-3528 operational mode port speed duplex','cce63413576040fe8df5969886da993d');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('372','10420','ZYXEL MES-3528 port admin status','6220d70f35404dd6834674510e0ae9ea');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('373','10420','ZYXEL MES-3528 port operational status','36e992f6794a492e87c3c5a9749e26b3');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('374','10420','ZYXEL MES-3528 SFP status','da9692b414de47d5bac9cd3287492e0b');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('375','10421','SNMP available','7ad9362759b542d98a67796dd13fc5d4');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('376','10421','ZYXEL MES3500-10 operational mode port link up type','064efc8dae8e47ae9c14713c7b31a36c');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('377','10421','ZYXEL MES3500-10 operational mode port speed duplex','4ad7b4bf94494c93bdcbf36af095d5c3');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('378','10421','ZYXEL MES3500-10 port admin status','e6a8dc82d4ca4b989daafd66ef1ab2ce');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('379','10421','ZYXEL MES3500-10 port operational status','a96f6ed4d9e34a0cb79cee8bdbd672f5');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('380','10421','ZYXEL MES3500-10 SFP status','8e9755ff129740298ab5f5497c6c17a2');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('381','10422','SNMP available','dbb03955eb7043dda4dea1a9d7e8e043');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('382','10422','ZYXEL MES3500-24 operational mode port link up type','c0f699295af740e2aabbb06c6718e8f8');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('383','10422','ZYXEL MES3500-24 operational mode port speed duplex','f94441e46ffe4908a8a57089cbdaeaa7');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('384','10422','ZYXEL MES3500-24 port admin status','df2213aff9984b3f837f99944f3c9bc0');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('385','10422','ZYXEL MES3500-24 port operational status','679674c6b9364083a1eb1c9c9be136a2');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('386','10422','ZYXEL MES3500-24 SFP status','f12de6ba6b4c4556b276f9d5d509ffcf');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('387','10423','SNMP available','6e923e1e3ed34b8f87357b5fd7407c54');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('388','10423','ZYXEL MGS-3712 operational mode port link up type','7c5d7efbd17f48619a3f4211a269b38d');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('389','10423','ZYXEL MGS-3712 operational mode port speed duplex','da42da17340044ea83521107ac4dee04');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('390','10423','ZYXEL MGS-3712 port admin status','7e107b2d754945dbaf833955fcae7f48');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('391','10423','ZYXEL MGS-3712 port operational status','ed71a5038bf34198a3a56b0020ad728e');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('392','10423','ZYXEL MGS-3712 SFP status','b89570749c5d4dcb9378b7951803b8e4');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('393','10424','SNMP available','bf6cbe819fb94c85becf4364c47ef1c4');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('394','10424','ZYXEL MGS-3712F operational mode port link up type','2695f35dedcf41e1aade2037e931c57e');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('395','10424','ZYXEL MGS-3712F operational mode port speed duplex','c2b235ab2e6042568c096fdfb466f7dc');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('396','10424','ZYXEL MGS-3712F port admin status','d145d8ee5ad2423f906335d30bfef592');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('397','10424','ZYXEL MGS-3712F port operational status','655823ba854540c78a8078d4e7594bf9');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('398','10424','ZYXEL MGS-3712F SFP status','bf0d94784c404b209d4c75c8f582a5c6');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('399','10425','SNMP available','9e4265c1129d482fa12a09e657a7cda3');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('400','10425','ZYXEL MES3500-24S operational mode port link up type','615d399b1a6045359dfc262b364b4c55');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('401','10425','ZYXEL MES3500-24S operational mode port speed duplex','4217cd5f5c1f4b438cd4701c023da375');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('402','10425','ZYXEL MES3500-24S port admin status','7e705fdb791341b8a1c86ee7d85fbfea');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('403','10425','ZYXEL MES3500-24S port operational status','08e22f2eac034c9db9bba73040cea453');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('404','10425','ZYXEL MES3500-24S SFP status','161770392cdb4dcd92c3596b5ad6d06a');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('405','10426','SNMP available','5c5037a96f084a8182a5fb00f49ff285');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('406','10426','ZYXEL MGS3520-28x operational mode port link up type','2b38ddd0e1a34cfab7dd6af9ebf28aca');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('407','10426','ZYXEL MGS3520-28x operational mode port speed duplex','f23ebe496cfc4e659a09eff530b81a24');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('408','10426','ZYXEL MGS3520-28x port admin status','3e0566598e394d80988fb49cd3215922');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('409','10426','ZYXEL MGS3520-28x port operational status','2ffe41460977466cb09bc241b8d22739');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('410','10426','ZYXEL MGS3520-28x SFP status','4443c6780c8f4d16a5f1efd5426db02e');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('411','10427','SNMP available','a7acf3b0ac684d4e80c560bcd3dd2dc6');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('412','10427','ZYXEL XGS-4728F operational mode port link up type','042ccfb45b0a4ef7bc8842f731dd8c4f');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('413','10427','ZYXEL XGS-4728F operational mode port speed duplex','d466ff32531d4eaea989c07aa5989d6b');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('414','10427','ZYXEL XGS-4728F port admin status','250f228ead4b433f987d42014255a617');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('415','10427','ZYXEL XGS-4728F port operational status','ed13145eeefd44dda083716080725e60');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('416','10427','ZYXEL XGS-4728F SFP status','49b0a85b7da947ab91e47ed2f2123907');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('417','10428','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsEquipmentOperability','8648df22d8be42359900e11ea395a98c');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('418','10428','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsEquipmentPresence','17dde900e96a47929b0abed0d5006c84');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('419','10428','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsLsOperState','c4a3603d4d8944ad8a8d2529bc3f1278');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('420','10428','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsStorageLunType','7d09a2b8df18410ca871ed9e7dbe6aa1');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('421','10428','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsStoragePDriveStatus','70a906bfe3b447a39e5a0f0ba5210ae2');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('422','10428','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsStorageTechnology','e1407fbe331343d3bda7d7eb122c085a');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('423','10428','IF-MIB::ifOperStatus','2b0fde08268f4ce7b47aae3827ebdf23');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('424','10428','IF-MIB::ifType','be402fda36e64dd2ad807925755735c4');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('425','10428','zabbix.host.available','9ea529bf28a84fae95f1506ca6ca37b8');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('426','10429','CPQHLTH-MIB::cpqHeTemperatureCondition','1b67de295fef454cb89744b101cf5a19');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('427','10429','CPQHLTH-MIB::cpqHeTemperatureLocale','07d063dcbb3d4f1a8642bfd93afcd327');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('428','10429','CPQIDA-MIB::cpqDaAccelBattery','009fd99d3734459285fa037c4a0ca201');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('429','10429','CPQIDA-MIB::cpqDaAccelStatus','e138320082fc4aa69f3b23dad80272b2');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('430','10429','CPQIDA-MIB::cpqDaCntlrModel','4891472973f84343ade2c5b61d96fcef');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('431','10429','CPQIDA-MIB::cpqDaLogDrvFaultTol','a368b7472246477599d6278df8348bc9');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('432','10429','CPQIDA-MIB::cpqDaLogDrvStatus','aab16842347c4e58b9bbee274dad3c62');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('433','10429','CPQIDA-MIB::cpqDaPhyDrvMediaType','b3b110016c8c4272b9228161798a9bbd');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('434','10429','CPQIDA-MIB::cpqDaPhyDrvSmartStatus','5b016d244c6845f7afcc80361aec2af1');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('435','10429','CPQIDA-MIB::cpqDaPhyDrvStatus','2f4e1eb1f32847b3808372d02f752575');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('436','10429','CPQNIC-MIB::cpqNicIfPhysAdapterStatus','3fe7ff0237a54f6cae3a1b8ffdabf157');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('437','10429','CPQSINFO-MIB::status','342d09a1cfe543b9ac1555daee9f2235');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('438','10429','zabbix.host.available','c57a256a525b46b0a1d0646200de57e2');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('439','10430','CPQHLTH-MIB::cpqHeTemperatureCondition','1f0d43fc8b334b6da324b6ce4f838f81');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('440','10430','CPQHLTH-MIB::cpqHeTemperatureLocale','96287ed099c14e09b2e1708487f64d8d');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('441','10430','CPQIDA-MIB::cpqDaAccelBattery','684758347f0740e08af4986ed148e81f');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('442','10430','CPQIDA-MIB::cpqDaAccelStatus','ff25d5d2484f40ea99b212e19c48e375');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('443','10430','CPQIDA-MIB::cpqDaCntlrModel','4dc1441ab9964badbcb73e0dc213fe39');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('444','10430','CPQIDA-MIB::cpqDaLogDrvFaultTol','3fd86d20618b43f39911746d72c2c242');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('445','10430','CPQIDA-MIB::cpqDaLogDrvStatus','e72171bf818e4ee1bdf9638cb0494693');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('446','10430','CPQIDA-MIB::cpqDaPhyDrvMediaType','3d32638b989d4d3e87f727baaef8b051');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('447','10430','CPQIDA-MIB::cpqDaPhyDrvSmartStatus','137c69d61b394c979d7d25d91bcc2f0b');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('448','10430','CPQIDA-MIB::cpqDaPhyDrvStatus','9af698a37bd844069eb2235f7f5d4800');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('449','10430','CPQNIC-MIB::cpqNicIfPhysAdapterStatus','04dcfa6e36ca4a0590475d84186a5d62');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('450','10430','CPQSINFO-MIB::status','83162a1a3b124ab2ae9b4cf1149486f9');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('451','10430','zabbix.host.available','63b879b39b084a318547620421164c05');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('452','10431','CPQHLTH-MIB::cpqHeTemperatureCondition','eb946b7168084341870c9157173b5c1e');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('453','10431','CPQHLTH-MIB::cpqHeTemperatureLocale','a293ad4b90c14fe188623341b954d852');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('454','10431','CPQIDA-MIB::cpqDaAccelBattery','ca2a5be5f3cf4fa7a9812d483ba043c5');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('455','10431','CPQIDA-MIB::cpqDaAccelStatus','f15cd1d7fa7e4e05b46e872daa3a3c83');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('456','10431','CPQIDA-MIB::cpqDaCntlrModel','abaffb0a2a1f47ec8aa64f6264d29092');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('457','10431','CPQIDA-MIB::cpqDaLogDrvFaultTol','204396956bfe4ff5808dfa93bb35705c');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('458','10431','CPQIDA-MIB::cpqDaLogDrvStatus','adb434bee0104007a4c0d053211bc2e7');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('459','10431','CPQIDA-MIB::cpqDaPhyDrvMediaType','6cc6b46021f74cae83b29a62fc2cd1c0');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('460','10431','CPQIDA-MIB::cpqDaPhyDrvSmartStatus','02eab0a3c02d440c82b86ddbd4ed1af6');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('461','10431','CPQIDA-MIB::cpqDaPhyDrvStatus','8ab32bfce9f143da86a458427804a5f4');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('462','10431','CPQNIC-MIB::cpqNicIfPhysAdapterStatus','d7ae95f8b813415c8d35cfe8debf8f2d');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('463','10431','CPQSINFO-MIB::status','365afa633545431482f2ec054750da88');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('464','10431','zabbix.host.available','9665746d6c2a4ad0b85b2f1f7d1cb12d');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('465','10432','CPQHLTH-MIB::cpqHeTemperatureCondition','5655717fa32f4711b3062b97f1e5895b');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('466','10432','CPQHLTH-MIB::cpqHeTemperatureLocale','ae1477baf3c046cbb5519346f28c7017');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('467','10432','CPQIDA-MIB::cpqDaAccelBattery','af8340b5070f47e085eb91eb4580d728');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('468','10432','CPQIDA-MIB::cpqDaAccelStatus','4c4378c0d1af4a6693f8c03bfaa9ad40');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('469','10432','CPQIDA-MIB::cpqDaCntlrModel','23a855763fc346ea8a3559399ffa7428');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('470','10432','CPQIDA-MIB::cpqDaLogDrvFaultTol','87ad87e768bc4d8ab77841e29176c36f');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('471','10432','CPQIDA-MIB::cpqDaLogDrvStatus','46a2f599d46d438899ea4d8c552f51b4');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('472','10432','CPQIDA-MIB::cpqDaPhyDrvMediaType','5f6868416f454beba585a0d2e9038117');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('473','10432','CPQIDA-MIB::cpqDaPhyDrvSmartStatus','f78e361d31d94c479594b9d73257f80a');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('474','10432','CPQIDA-MIB::cpqDaPhyDrvStatus','0efa6b7ed90f4edebc3282af5dbaf6c4');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('475','10432','CPQNIC-MIB::cpqNicIfPhysAdapterStatus','1d312bcad99c43b8931fb128f6250afa');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('476','10432','CPQSINFO-MIB::status','48e68c2789334818b5536be3f8628f66');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('477','10432','zabbix.host.available','1b63c6eea5fc42a99501408d603c158b');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('478','10433','zabbix.host.available','13a9860da38f4727a6f958b5cd3d3468');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('479','10434','IDRAC-MIB-SMIv2::batteryState','662600e752b94992b157724609e6b7ce');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('480','10434','IDRAC-MIB-SMIv2::BooleanType','db5865050a564fb9afa7215e9b1f7b59');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('481','10434','IDRAC-MIB-SMIv2::ObjectStatusEnum','03744c3cbad64946a71c27fa57d1ecc5');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('482','10434','IDRAC-MIB-SMIv2::physicalDiskComponentStatus','6ca166558903480a912a7dd700b10de2');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('483','10434','IDRAC-MIB-SMIv2::physicalDiskMediaType','3ab13a74743f4635afac016594d6fc0f');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('484','10434','IDRAC-MIB-SMIv2::StatusProbeEnum','5de90687104a4a82bf33099f7a53b8e2');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('485','10434','IDRAC-MIB-SMIv2::virtualDiskLayout','742cb11d3e104411bd7b5777f3713d2e');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('486','10434','IDRAC-MIB-SMIv2::virtualDiskOperationalState','cf6ea6091e864b589be59060bf822b3e');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('487','10434','IDRAC-MIB-SMIv2::virtualDiskReadPolicy','bf35de999eed469d95be5d095481d0e4');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('488','10434','IDRAC-MIB-SMIv2::virtualDiskState','fa2c1fd3e71244f2960565b53cf89675');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('489','10434','IDRAC-MIB-SMIv2::virtualDiskWritePolicy','b2e0c35a0f0440ed96fadf89fbd8d730');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('490','10434','zabbix.host.available','e745027008e84545a52a8804e8a8aa05');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('491','10435','zabbix.host.available','182f54d53eab4a2ea6025dfc028a6892');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('492','10436','IDRAC-MIB-SMIv2::batteryState','00de3138244c4b758736da399416b193');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('493','10436','IDRAC-MIB-SMIv2::BooleanType','30da32599eab4478bc8645382d02a460');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('494','10436','IDRAC-MIB-SMIv2::ObjectStatusEnum','c51def0f0ce640e7ae70f9fe0da7589d');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('495','10436','IDRAC-MIB-SMIv2::physicalDiskComponentStatus','349663986938482ca7e4519516a289ea');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('496','10436','IDRAC-MIB-SMIv2::physicalDiskMediaType','1945a0e1d81f495ab41c9ef848e8fde9');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('497','10436','IDRAC-MIB-SMIv2::StatusProbeEnum','b3e8adf66be04293ab6b1416705721a6');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('498','10436','IDRAC-MIB-SMIv2::virtualDiskLayout','c6b9cc21da864d47982d1bb4223d5826');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('499','10436','IDRAC-MIB-SMIv2::virtualDiskOperationalState','4dbff414bf354da499f98c7391453e47');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('500','10436','IDRAC-MIB-SMIv2::virtualDiskReadPolicy','5d2e0552eab844728f62b95db3d9dd24');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('501','10436','IDRAC-MIB-SMIv2::virtualDiskState','2d250d26187e410492725f1022ae7b26');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('502','10436','IDRAC-MIB-SMIv2::virtualDiskWritePolicy','9536e2ee81374408aa40ad069533d6da');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('503','10436','zabbix.host.available','a5ac79d4c3f14ce59155b61cb0780e57');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('504','10437','IDRAC-MIB-SMIv2::batteryState','ce3baf68b6e54ad3a67f77d5e8d5567a');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('505','10437','IDRAC-MIB-SMIv2::ObjectStatusEnum','1ce66d22fc074d6ab113fb5449cb778a');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('506','10437','IDRAC-MIB-SMIv2::physicalDiskComponentStatus','c137d9094e9c434e975bac41ebdff156');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('507','10437','IDRAC-MIB-SMIv2::physicalDiskMediaType','f1ee4057a7394260b877b3a2b1ad0943');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('508','10437','IDRAC-MIB-SMIv2::StatusProbeEnum','660f91b00d694691953b39ac2800bdbe');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('509','10437','IDRAC-MIB-SMIv2::virtualDiskOperationalState','d8f93c2c425d4d8c9c2d5a5a489ba614');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('510','10437','IDRAC-MIB-SMIv2::virtualDiskReadPolicy','335c6dd916ba49cda3f537a6f3371540');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('511','10437','IDRAC-MIB-SMIv2::virtualDiskState','be6fadfed0574457b289dd5beda43e73');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('512','10437','IDRAC-MIB-SMIv2::virtualDiskWritePolicy','2c0f81605b694b7cba7232b102bde235');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('513','10437','zabbix.host.available','42059b2450fd4856a4c38019df326920');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('514','10438','IDRAC-MIB-SMIv2::batteryState','1ac64ea780474ceb91de5038ed9a3046');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('515','10438','IDRAC-MIB-SMIv2::BooleanType','234f3debc9424c38a793d3913a6ae15a');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('516','10438','IDRAC-MIB-SMIv2::ObjectStatusEnum','cafb2094b58742e4a1affff59eff8f3f');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('517','10438','IDRAC-MIB-SMIv2::physicalDiskComponentStatus','8aea183646034b20afa2bb48a2f81099');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('518','10438','IDRAC-MIB-SMIv2::physicalDiskMediaType','e06877de7dd14b52b8338796d6da8e5f');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('519','10438','IDRAC-MIB-SMIv2::StatusProbeEnum','e8b8263d6214491eb17893e0ebba0aed');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('520','10438','IDRAC-MIB-SMIv2::virtualDiskLayout','ef48e8403dc84d048f7177a26224ac99');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('521','10438','IDRAC-MIB-SMIv2::virtualDiskOperationalState','2f814b3be15f438c8e7062645e3b2fd2');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('522','10438','IDRAC-MIB-SMIv2::virtualDiskReadPolicy','a273ff1ff94c44f98e1ff312223712b8');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('523','10438','IDRAC-MIB-SMIv2::virtualDiskState','91fea9a659114dfa90ca363ad879b243');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('524','10438','IDRAC-MIB-SMIv2::virtualDiskWritePolicy','633fb28afa934585abc60c3b91a278fa');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('525','10438','zabbix.host.available','4d5e4fb93a594bac8ef3b9e62da06fa4');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('526','10439','zabbix.host.available','82a264b7c920495ca0de966a3a7c0a14');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('527','10440','IDRAC-MIB-SMIv2::batteryState','644e180666f042d79bed40ac4e55c9bd');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('528','10440','IDRAC-MIB-SMIv2::BooleanType','42f304068b834ba48db2eb28cb29d9f3');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('529','10440','IDRAC-MIB-SMIv2::ObjectStatusEnum','ee86b423d3444d57b7fc11fbb4989177');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('530','10440','IDRAC-MIB-SMIv2::physicalDiskComponentStatus','f655a6ed92e6430d9dbb7eff874f6307');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('531','10440','IDRAC-MIB-SMIv2::physicalDiskMediaType','3b74eb4e2b6144da845dfa5068f2dd08');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('532','10440','IDRAC-MIB-SMIv2::StatusProbeEnum','e87119147cd74d299861d14e1bc9c1af');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('533','10440','IDRAC-MIB-SMIv2::virtualDiskLayout','b513b8f45d6a4d17925669c35a68d7b6');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('534','10440','IDRAC-MIB-SMIv2::virtualDiskOperationalState','18152f06a04b4dfd84ade32d0a316769');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('535','10440','IDRAC-MIB-SMIv2::virtualDiskReadPolicy','09d591b105544625acf40b12b0569c9c');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('536','10440','IDRAC-MIB-SMIv2::virtualDiskState','2cae2d1a9ad74ffe861f09a11f644550');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('537','10440','IDRAC-MIB-SMIv2::virtualDiskWritePolicy','6b19b83ac05e49749f592db773ab6db3');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('538','10440','zabbix.host.available','39239bfc67b84ac9a4854f5d10d72f58');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('539','10441','Unit Active State','fe20979701834a80a823c514d11c19e7');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('540','10441','Unit File State','e0a5e55e5a074a26935386c5e29a0e36');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('541','10441','Unit Load State','0309ef57e92a4ea2ae4404a685f0e7b8');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('542','10443','Chassis status','849febb31f524e9296afc5ec6ffb2fe3');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('543','10443','Module provision level','ed7e1317987b433e9aa7168db3824c94');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('544','10443','Pause state','6e590fa7db7441d5a4b145204ee254bb');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('545','10443','SNMP available','b615a47192fc48f4b2cedb205c33f7d0');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('546','10308','Server mode','bf2e9463450d4f4899abcac85cde0a92');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('547','10309','Server mode','450c1b2c6d58432b8a5b34dd3b5e8870');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('548','10446','Cisco ASAv algorithm validate packets','764f7c162b8a45d9b41e795cf2f5f8da');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('549','10446','Cisco ASAv encryption algorithm','f38e3c5200c941aa831857698eb3ea8b');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('550','10446','Cisco ASAv port admin status','8395b87d3ff3496aabafdfd1d2e1c4be');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('551','10446','Cisco ASAv port operational status','e97c331986454b68917c771c3bba9a3d');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('552','10446','Cisco ASAv session protocol','22e5704487924e4ebca70e2062d40da4');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('553','10446','Cisco ASAv user authenticate method','8dd72ccb744e4bd989ea739e21da7820');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('554','10446','Physical class','3c3b7c75af4b4fedb12e30fb74406a23');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('555','10446','SNMP available','91e8696b05654efca8f03b700ea74b0b');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('556','10448','InfluxDB healthcheck','d1b4478bdfc44c6db79a4a262f605d92');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('557','10443','SNMP ltmPoolStatusEnabledState','74bcf04a70da49f89f04a20a9830fe13');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('558','10443','SNMP ltmVsStatusAvailState','3a8776175b1f4cd7aa62f0182c7e3ed7');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('559','10443','SNMP sysCmFailoverStatusId','6f96920248994bca92eb8d4394346027');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('560','10443','SNMP sysCmSyncStatusId','1a42ed91b734453ab29a4c1f1feaca89');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('561','10449','Edge activation state','6ac13cd1206145919ae7c9776ef5e76b');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('562','10449','Edge HA status','cd8d83dc329144d9925a5c52db95df96');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('563','10449','Edge states','87f150cd23e14448b35980b546dc2cd8');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('564','10449','Link states','249b93828946422c9ef8870a915661ca');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('565','10450','IF-MIB::ifOperStatus','2216d8afb349448394590770ff99e56a');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('566','10450','IF-MIB::ifType','3165b9b6c79e446f9d1029571518004e');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('567','10450','Services status','fc5652614ee94cd8b437b3058886e857');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('568','10450','Service state','c3c721156c624317af993e1a263c16bc');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('569','10450','SNMPv2-TC::TruthValue','f6bb441b7a65446c96c546bd3f3140ee');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('570','10450','zabbix.host.available','d553e33d8b104a5e89d88500e85fa5fc');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('571','10047','Cluster node status','cee1681b12ff49b6b7d442a851e870b4');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) values ('572','10261','Cluster node status','25ab0f5c570b4a7e9d15bd41db79fe25');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('10061','5','','10047','Zabbix server: Number of processed numeric (float) values per second','zabbix[wcache,values,float]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache.\r\nNumber of processed float values.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','de63f78f36e74361b6c9993d12d8b7c8');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('10062','5','','10047','Zabbix server: Number of processed character values per second','zabbix[wcache,values,str]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache.\r\nNumber of processed character/string values.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','b58fdd85cd6a48489d0b983ee8ebe97b');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('10063','5','','10047','Zabbix server: Number of processed log values per second','zabbix[wcache,values,log]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache.\r\nNumber of processed log values.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','dae76dc6c4ce4707be7cf9534efc0233');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('10064','5','','10047','Zabbix server: Number of processed numeric (unsigned) values per second','zabbix[wcache,values,uint]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache.\r\nNumber of processed numeric (unsigned) values.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','47132a8565c943c0abbd4918d6af9339');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('10065','5','','10047','Zabbix server: Number of processed text values per second','zabbix[wcache,values,text]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache.\r\nNumber of processed text values.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','5397d6d4dedc44c29ff25b8fd5611003');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('10066','5','','10047','Zabbix server: Number of processed not supported values per second','zabbix[wcache,values,not supported]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache.\r\nNumber of times item processing resulted in item becoming unsupported or keeping that state.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','c99a99cf7e1e44918736ab860694d3a4');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('10067','5','','10048','Zabbix proxy: Number of processed numeric (float) values per second','zabbix[wcache,values,float]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache.\r\nNumber of processed float values.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','ba5efd0ed21d4ac39e1375788b7198de');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('10068','5','','10048','Zabbix proxy: Number of processed character values per second','zabbix[wcache,values,str]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache.\r\nNumber of processed character/string values.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','5f0c3ed0998e499aaa1e4a30726928fc');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('10069','5','','10048','Zabbix proxy: Number of processed log values per second','zabbix[wcache,values,log]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache.\r\nNumber of processed log values.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','47cdd6ef01734ec1ab15b0ab43d147ca');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('10070','5','','10048','Zabbix proxy: Number of processed numeric (unsigned) values per second','zabbix[wcache,values,uint]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache.\r\nNumber of processed numeric (unsigned) values.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','8e4b9641b173415c8608ee4863bcd547');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('10071','5','','10048','Zabbix proxy: Number of processed text values per second','zabbix[wcache,values,text]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache.\r\nNumber of processed text values.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','1c259b08b3ff445f9b2f24a02c07c5db');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('10072','5','','10048','Zabbix proxy: Number of processed not supported values per second','zabbix[wcache,values,not supported]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache.\r\nNumber of times item processing resulted in item becoming unsupported or keeping that state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','46574db1d70545f6af89e8607d22f5bb');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22183','5','','10047','Zabbix server: History write cache, % used','zabbix[wcache,history,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache. Percentage of used history buffer.\r\nHistory cache is used to store item values. A high number indicates performance problems on the database side.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','1ae8253bb4da434da3ea6bcb0352115d');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22185','5','','10047','Zabbix server: Trend write cache, % used','zabbix[wcache,trend,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache. Percentage of used trend buffer.\r\nTrend cache stores aggregate for the current hour for all items that receive data.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','5cca0fc9878d4e068467d5a3b8558ed5');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22187','5','','10047','Zabbix server: Number of processed values per second','zabbix[wcache,values]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache.\r\nTotal number of values processed by Zabbix server or Zabbix proxy, except unsupported items.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','db364af6bcb24881850f3979933fccb0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22189','5','','10047','Zabbix server: Configuration cache, % used','zabbix[rcache,buffer,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Availability statistics of Zabbix configuration cache. Percentage of used buffer.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','ac2aebc15b084d049538b12e9513c08d');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22191','5','','10047','Zabbix server: Value cache, % used','zabbix[vcache,buffer,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Availability statistics of Zabbix value cache. Percentage of used buffer.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','559ca5966e404c948f99cabf7a9077e8');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22196','5','','10047','Zabbix server: Value cache hits','zabbix[vcache,cache,hits]','1m','1w','365d','0','0','','vps','','',NULL,NULL,'','','0','','','','','0',NULL,'Effectiveness statistics of Zabbix value cache. Number of cache hits (history values taken from the cache).','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','69b14487a9744dbb866f2e6ee131d0e5');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22199','5','','10047','Zabbix server: Value cache misses','zabbix[vcache,cache,misses]','1m','1w','365d','0','0','','vps','','',NULL,NULL,'','','0','','','','','0',NULL,'Effectiveness statistics of Zabbix value cache. Number of cache misses (history values taken from the database).','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','c78439859fd248cdb15e1eee37be2220');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22219','5','','10047','Zabbix server: Queue over 10 minutes','zabbix[queue,10m]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of monitored items in the queue which are delayed at least by 10 minutes.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','2b2f695ed1ef4a7a871c80df9c911e90');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22231','0','','10050','Version of Zabbix agent running','agent.version','1h','7d','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','3a6af03a083b4366bd1d4c6ccf06ca88');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22232','0','','10050','Zabbix agent ping','agent.ping','1m','7d','365d','0','3','','','','',NULL,'49','','','0','','','','','0',NULL,'The agent always returns 1 for this item. It could be used in combination with nodata() for availability check.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','37a952edc12f47d6ac6f3ca04eb41326');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22396','5','','10047','Zabbix server: History index cache, % used','zabbix[wcache,index,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache. Percentage of used history index buffer.\r\nHistory index cache is used to index values stored in history cache.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','9fc7faf5455e4e78bdb1406f947bfa08');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22399','5','','10047','Zabbix server: Utilization of poller data collector processes, in %','zabbix[process,poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time poller processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','cbec202e15be49de93dc0c5f58824ae3');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22400','5','','10047','Zabbix server: Utilization of unreachable poller data collector processes, in %','zabbix[process,unreachable poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time unreachable poller processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','4fd24bdb8935435e8617c9607b9c6ca1');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22401','5','','10047','Zabbix server: Utilization of vmware data collector processes, in %','zabbix[process,vmware collector,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time vmware collector processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','bad00e43cd064a0fb3a4b65b71bea926');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22402','5','','10047','Zabbix server: Utilization of http poller data collector processes, in %','zabbix[process,http poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time http poller processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','419e937c4a1d4fa09c4b50ca88cbe3e2');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22404','5','','10047','Zabbix server: Utilization of trapper data collector processes, in %','zabbix[process,trapper,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time trapper processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','0dd727eddfaf45a9a819a9d64c5b72c7');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22406','5','','10047','Zabbix server: Utilization of history syncer internal processes, in %','zabbix[process,history syncer,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time history syncer processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','4d92eb7b411345cfbd6e2ea2ff5c1788');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22408','5','','10047','Zabbix server: Utilization of housekeeper internal processes, in %','zabbix[process,housekeeper,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time housekeeper processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','23f448b5acba472881857647ca1bb614');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22412','5','','10047','Zabbix server: Utilization of configuration syncer internal processes, in %','zabbix[process,configuration syncer,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time configuration syncer processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','301e7fe93a024444b19766e665e9d156');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22414','5','','10047','Zabbix server: Utilization of self-monitoring internal processes, in %','zabbix[process,self-monitoring,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time self-monitoring processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','6fc9c055d4894c19b3b1075db106d995');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22416','5','','10047','Zabbix server: Utilization of ipmi poller data collector processes, in %','zabbix[process,ipmi poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time ipmi poller processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','c11d415de9c64fd6911f82d49db140d3');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22418','5','','10047','Zabbix server: Utilization of icmp pinger data collector processes, in %','zabbix[process,icmp pinger,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time icmp pinger processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','d5d469d5eb2e4e0ca0afc89b603d4065');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22420','5','','10047','Zabbix server: Utilization of proxy poller data collector processes, in %','zabbix[process,proxy poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time proxy poller processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','baf22e095078435d978a6c4374500db4');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22422','5','','10047','Zabbix server: Utilization of escalator internal processes, in %','zabbix[process,escalator,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time escalator processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','d12ce718fad34644b92d98cf2096e7df');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22424','5','','10047','Zabbix server: Utilization of alerter internal processes, in %','zabbix[process,alerter,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time alerter processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','cac7bb12993945fe848df86f7c4502ed');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22426','5','','10047','Zabbix server: Utilization of timer internal processes, in %','zabbix[process,timer,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time timer processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','3af0ec03af6542e18aaff505e3806089');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22430','5','','10047','Zabbix server: Utilization of discoverer data collector processes, in %','zabbix[process,discoverer,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time discoverer processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','db7fee2552d5487fa608cf12f69aef41');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22689','5','','10047','Zabbix server: Utilization of java poller data collector processes, in %','zabbix[process,java poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time java poller processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','a8168691df3d43f1a1e106062f18ee06');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22835','0','','10074','Maximum number of opened files','kernel.maxfiles','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','56a83dc0e14e47339e13a451adcefef7');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22836','0','','10074','Maximum number of processes','kernel.maxproc','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','e55f8256dd2d48fd9e7fd786f872b4bc');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22837','0','','10074','Number of running processes','proc.num[,,run]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of processes in running state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','7f8fdbc74cf14fa2afda3b57c548c751');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22838','0','','10074','Number of processes','proc.num[]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Total number of processes in any state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','966acafb928b43f8a63ee673b1716d28');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22839','0','','10074','Host boot time','system.boottime','10m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','4e06c5b504c04c169ea1a0d6a7951eeb');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22840','0','','10074','Interrupts per second','system.cpu.intr','1m','1w','365d','0','3','','ips','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','f6ed0de8cbb545298b174b19938a527e');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22841','0','','10074','Processor load (15 min average per core)','system.cpu.load[percpu,avg15]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','0403d3b318a649d4aa0da97e18546bcb');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22842','0','','10074','Processor load (1 min average per core)','system.cpu.load[percpu,avg1]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','7e4eab397cfd43d2a4aef7e2aa8c3a37');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22843','0','','10074','Processor load (5 min average per core)','system.cpu.load[percpu,avg5]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','55ad1da5b20c465f8db86701dcf3e974');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22844','0','','10074','Context switches per second','system.cpu.switches','1m','1w','365d','0','3','','sps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','2226fac821fe4928a9d727770e0af4d0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22845','0','','10074','CPU idle time','system.cpu.util[,idle]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent doing nothing.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','4689c51946c845e5b31cb7ca5b58fbe3');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22846','0','','10074','CPU interrupt time','system.cpu.util[,interrupt]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The amount of time the CPU has been servicing hardware interrupts.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','ad032417f6de4e03a4f956bea65d8ce0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22848','0','','10074','CPU nice time','system.cpu.util[,nice]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users\' processes that have been niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','84030949a4d545b59db4aa3b38402174');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22851','0','','10074','CPU system time','system.cpu.util[,system]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running the kernel and its processes.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','63121eb34bc94eeabd7352992b67befb');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22852','0','','10074','CPU user time','system.cpu.util[,user]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users\' processes that are not niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','c9adb1a7c2fd4db9b176f9008483f2d7');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22853','0','','10074','Host name','system.hostname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'System host name.','3','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','a80cd7ca70954cd1b6b89a686f642b9d');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22854','0','','10074','Host local time','system.localtime','1m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','cfff34f2374c410492b89cce1c6b5198');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22855','0','','10074','Free swap space','system.swap.size[,free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','e758448d5ec242e6a7a17f67c8f62874');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22856','0','','10074','Free swap space in %','system.swap.size[,pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','43648a7f2c79443781a0ad500e7a9e6c');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22857','0','','10074','Total swap space','system.swap.size[,total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','61f33f0c3e35499b999626058048ec66');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22858','0','','10074','System information','system.uname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The information as normally returned by \'uname -a\'.','5','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','b19974c64b4141c2aca0e997b03c2f0a');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22859','0','','10074','System uptime','system.uptime','10m','1w','365d','0','3','','uptime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','d14bcdc15cc24f90baea06a13077a54f');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22860','0','','10074','Number of logged in users','system.users.num','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of users who are currently logged in.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','165a44bf3b9d49378e500acb90aa7957');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22861','0','','10074','Checksum of /etc/passwd','vfs.file.cksum[/etc/passwd]','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','f11f6e3539a244409f1c72dbd6f16b76');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22862','0','','10074','Available memory','vm.memory.size[available]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'Available memory is defined as free+cached+buffers memory.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','5b6c92c92e434dff8ce19e28b3ba785e');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22863','0','','10074','Total memory','vm.memory.size[total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','b32320608732421fac18437006bc1874');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22867','0','','10074','Mounted filesystem discovery','vfs.fs.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of file systems of different types as defined in global regular expression "File systems for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','feb02c707aa64b91a3b340aa5ef23de9');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22868','0','','10074','Free disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','d53bf828e684464a88157fd3dfd1b8d4');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22869','0','','10074','Free inodes on {#FSNAME} (percentage)','vfs.fs.inode[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','c29bc3c6bd844242b9165251dd3266bb');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22870','0','','10074','Total disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','5c27bfca98fc4e709b5fe66e8c181fbd');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22871','0','','10074','Used disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},used]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','840eed51cf264b5698fe4f38fd03ea16');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22872','0','','10074','Free disk space on {#FSNAME} (percentage)','vfs.fs.size[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','bcae23e8404349af87c570c353bfe0fe');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22875','0','','10075','Maximum number of opened files','kernel.maxfiles','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','d1b2d3cc2b7e44af8f9bfee11e04bf21');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22876','0','','10075','Maximum number of processes','kernel.maxproc','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','58244a8e72694ffcbba5a78a910ae818');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22877','0','','10075','Number of running processes','proc.num[,,run]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of processes in running state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','448c6de07b244281a4b1defe2e811773');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22878','0','','10075','Number of processes','proc.num[]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Total number of processes in any state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','5fd5b351d8214eac8f4f4649594c27eb');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22879','0','','10075','Host boot time','system.boottime','10m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','4a533b30c43e42fb8c9eabada0817186');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22880','0','','10075','Interrupts per second','system.cpu.intr','1m','1w','365d','0','3','','ips','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','db555e8318cf4e7aa7beb85aa0250697');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22881','0','','10075','Processor load (15 min average per core)','system.cpu.load[percpu,avg15]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','ad9ebf859f7346ca885c1edcb7333d78');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22882','0','','10075','Processor load (1 min average per core)','system.cpu.load[percpu,avg1]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','2336b2ec03a846f3bed1e64384b2532e');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22883','0','','10075','Processor load (5 min average per core)','system.cpu.load[percpu,avg5]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','de68f40fc96648c0925c1f6a4ca6776e');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22884','0','','10075','Context switches per second','system.cpu.switches','1m','1w','365d','0','3','','sps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','0a140185a5114dd29451bfac68abdde5');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22885','0','','10075','CPU idle time','system.cpu.util[,idle]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent doing nothing.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','7612803821c845889bda84b7f1ac9ae5');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22886','0','','10075','CPU interrupt time','system.cpu.util[,interrupt]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The amount of time the CPU has been servicing hardware interrupts.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','f2acc3cd432546e5a223095a0ea2f096');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22888','0','','10075','CPU nice time','system.cpu.util[,nice]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users\' processes that have been niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','efa92492bec0437ba74f47d694500cab');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22891','0','','10075','CPU system time','system.cpu.util[,system]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running the kernel and its processes.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','c9479b02b04141128b1ce7c8f3726c09');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22892','0','','10075','CPU user time','system.cpu.util[,user]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users\' processes that are not niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','1f3bc82009e04b59845a0e15004637ad');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22893','0','','10075','Host name','system.hostname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'System host name.','3','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','c17d001bd20a4732b8ef487366c6aa42');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22894','0','','10075','Host local time','system.localtime','1m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','4095ed7d606a47439294097a98af2c4f');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22895','0','','10075','Free swap space','system.swap.size[,free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','63fc1259011f4250901889979cdf472c');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22896','0','','10075','Free swap space in %','system.swap.size[,pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','187d11e610b94b468d18b88ca38f2c32');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22897','0','','10075','Total swap space','system.swap.size[,total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','9647b0b857074c4b9c14f15bb04af096');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22898','0','','10075','System information','system.uname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The information as normally returned by \'uname -a\'.','5','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','4523ae069e0b4e16bcb5182c6dbf63f2');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22899','0','','10075','System uptime','system.uptime','10m','1w','365d','0','3','','uptime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','a49b956d592c4e2ba41caac3671e009f');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22900','0','','10075','Number of logged in users','system.users.num','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of users who are currently logged in.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','fec3e877764e4bfd98e77da9d8c73606');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22901','0','','10075','Checksum of /etc/passwd','vfs.file.cksum[/etc/passwd]','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','2bb327cd5f8c49d9b680142825b9c030');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22902','0','','10075','Available memory','vm.memory.size[available]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'Available memory is defined as free+cached+buffers memory.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','561c7a383b944bca9ec5f7c44e322fed');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22903','0','','10075','Total memory','vm.memory.size[total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','ffa54e82b7914672a3f7134134ac2638');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22907','0','','10075','Mounted filesystem discovery','vfs.fs.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of file systems of different types as defined in global regular expression "File systems for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','4fd60a606c6343e9a7d7808d1d1f6008');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22908','0','','10075','Free disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','2ed6230d292a4037b67fe549c719e7ee');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22909','0','','10075','Free inodes on {#FSNAME} (percentage)','vfs.fs.inode[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','a5cdfe771122483fa1a88b2ea5c26b36');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22910','0','','10075','Total disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','6daede58ae8f4e42a4aa2539a552ab08');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22911','0','','10075','Used disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},used]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','6efb08c26e1b439181a17d462ec1dab8');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22912','0','','10075','Free disk space on {#FSNAME} (percentage)','vfs.fs.size[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','aa0dd0eb957a4485b1a62f715381019a');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22917','0','','10076','Number of running processes','proc.num[,,run]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of processes in running state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','2c2d08ab5833493ba45ebfe5154f04c1');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22918','0','','10076','Number of processes','proc.num[]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Total number of processes in any state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','7c64480f840a4778bde5278e1c0a083f');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22920','0','','10076','Interrupts per second','system.cpu.intr','1m','1w','365d','0','3','','ips','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','4a15778222a24f129b8ae7c240a32ded');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22921','0','','10076','Processor load (15 min average per core)','system.cpu.load[percpu,avg15]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','02210ac2faaa4f7bb74e995726706abc');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22922','0','','10076','Processor load (1 min average per core)','system.cpu.load[percpu,avg1]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','4f8665f48aff4fa39e85639fed7b71c5');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22923','0','','10076','Processor load (5 min average per core)','system.cpu.load[percpu,avg5]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','6fa2275f1f83456abfe786c8565c7a2d');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22924','0','','10076','Context switches per second','system.cpu.switches','1m','1w','365d','0','3','','sps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','1ad486947da9428abdebcecb83ca3d8b');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22933','0','','10076','Host name','system.hostname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'System host name.','3','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','f4d10d49fa3c4dababf03d2cb80f044c');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22934','0','','10076','Host local time','system.localtime','1m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','aebc5bb0264a4f55985c96445964dfc4');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22938','0','','10076','System information','system.uname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The information as normally returned by \'uname -a\'.','5','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','d0ef675d313849269890d06c7e003c9e');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22939','0','','10076','System uptime','system.uptime','10m','1w','365d','0','3','','uptime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','2e0ff86c992c4a098af8cb1bee0f0001');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22940','0','','10076','Number of logged in users','system.users.num','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of users who are currently logged in.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','980a59760ef9481298ed35322841f939');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22941','0','','10076','Checksum of /etc/passwd','vfs.file.cksum[/etc/passwd]','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','4771d6d33c2247d6843198152a7065a8');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22942','0','','10076','Available memory','vm.memory.size[available]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'Available memory is defined as free+cached+buffers memory.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','6d4d9deab17b42f4a953c5210acac6f1');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22943','0','','10076','Total memory','vm.memory.size[total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','57d30ccd5db64dc8b9498a36efe768e9');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22944','0','','10076','Network interface discovery','net.if.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of network interfaces as defined in global regular expression "Network interfaces for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','409cce8967b4494bbcc5193a26c69b06');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22945','0','','10076','Incoming network traffic on {#IFNAME}','net.if.in[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','df9710a48eaa4a72911de3971b37c596');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22946','0','','10076','Outgoing network traffic on {#IFNAME}','net.if.out[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','0704fb302aa94f73bedade3a998a0fa3');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22947','0','','10076','Mounted filesystem discovery','vfs.fs.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of file systems of different types as defined in global regular expression "File systems for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','4a0b17decdf1449d9463cf00720a843d');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22948','0','','10076','Free disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','13e212598f744a7fa535c23731190c61');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22949','0','','10076','Free inodes on {#FSNAME} (percentage)','vfs.fs.inode[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','ee5ae5de6f7b40b4a9b064bdc733de91');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22950','0','','10076','Total disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','6f6c92bc72014612b2efb92d12d8c425');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22951','0','','10076','Used disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},used]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','915e72271f134684b2d10d05d4035962');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22952','0','','10076','Free disk space on {#FSNAME} (percentage)','vfs.fs.size[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','428b0314dd574df1970dd2cae7e8889b');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22961','0','','10077','Processor load (15 min average per core)','system.cpu.load[percpu,avg15]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','296dbd5148184004b26ac50ae5e6893b');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22962','0','','10077','Processor load (1 min average per core)','system.cpu.load[percpu,avg1]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','bcba4702a58d48339c6e7e49dea574c4');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22963','0','','10077','Processor load (5 min average per core)','system.cpu.load[percpu,avg5]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','60057d54b81342f4aaa0103a278bf7b6');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22965','0','','10077','CPU idle time','system.cpu.util[,idle]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent doing nothing.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','2b82ccaf9eb1424593e2738a5512e182');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22968','0','','10077','CPU nice time','system.cpu.util[,nice]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users\' processes that have been niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','8665bd2dc84e46daa081a379548b0603');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22971','0','','10077','CPU system time','system.cpu.util[,system]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running the kernel and its processes.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','8419321f4744476ea27b7d1acddcd365');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22972','0','','10077','CPU user time','system.cpu.util[,user]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users\' processes that are not niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','611c9a3c70aa4455b6ec7bebe64b5316');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22973','0','','10077','Host name','system.hostname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'System host name.','3','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','6e3b32f3f92543759ef2f30834899ba0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22974','0','','10077','Host local time','system.localtime','1m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','16c6c420c710498083355361b104f7a2');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22978','0','','10077','System information','system.uname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The information as normally returned by \'uname -a\'.','5','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','b66598337e0e4990a2776d2a42020e72');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22980','0','','10077','Number of logged in users','system.users.num','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of users who are currently logged in.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','bb698e97aa1b45ebadcb48da729b8e64');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22981','0','','10077','Checksum of /etc/passwd','vfs.file.cksum[/etc/passwd]','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','4e11e7c5d43a4566989b39dbc0c23266');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22982','0','','10077','Available memory','vm.memory.size[available]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'Available memory is defined as free+cached+buffers memory.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','767abadfa8be4bccb2c4c5a1d532ba87');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22983','0','','10077','Total memory','vm.memory.size[total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','6da082e7f822465592f66e2bd0a46947');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22984','0','','10077','Network interface discovery','net.if.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of network interfaces as defined in global regular expression "Network interfaces for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','83058e954f1d497d8c33c82c771d2250');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22985','0','','10077','Incoming network traffic on {#IFNAME}','net.if.in[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','1c1dc757da2a43c4827734e4b7b3fcd2');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22986','0','','10077','Outgoing network traffic on {#IFNAME}','net.if.out[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','4de64b1ecae344afa12f892937caa04e');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22987','0','','10077','Mounted filesystem discovery','vfs.fs.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of file systems of different types as defined in global regular expression "File systems for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','883b3a5efab34685b9e6c9a84a6bec84');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22988','0','','10077','Free disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','75efb4ab311848ec9bbb03cf05efef8b');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22989','0','','10077','Free inodes on {#FSNAME} (percentage)','vfs.fs.inode[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','dbf8305aadb049a58b19a50d4e36fde9');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22990','0','','10077','Total disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','3d75a99c05bf41a2b63ce2b0caf4a6cc');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22991','0','','10077','Used disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},used]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','0aa8dd5bbaea4f35808ef735f0cec18d');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22992','0','','10077','Free disk space on {#FSNAME} (percentage)','vfs.fs.size[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','707d7dfb2dc243d49e4623f1d043a5b7');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22996','0','','10078','Maximum number of processes','kernel.maxproc','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','2fa6d58a5c7d48da90b1caf521e867cd');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22997','0','','10078','Number of running processes','proc.num[,,run]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of processes in running state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','7c8c8421fb514e67bc9f14cefe4018f3');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22998','0','','10078','Number of processes','proc.num[]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Total number of processes in any state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','74c805e8bfd947348b206a0d33bfc461');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('22999','0','','10078','Host boot time','system.boottime','10m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','1812e26de9ad4a36abb5498154e6ea3c');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23000','0','','10078','Interrupts per second','system.cpu.intr','1m','1w','365d','0','3','','ips','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','8186ed95ed8c4d6eb52ea2e718984170');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23001','0','','10078','Processor load (15 min average per core)','system.cpu.load[percpu,avg15]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','c13c2ff556594c5d985420dc974659cf');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23002','0','','10078','Processor load (1 min average per core)','system.cpu.load[percpu,avg1]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','1a7cc53a5497427da28f882b1b185fad');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23003','0','','10078','Processor load (5 min average per core)','system.cpu.load[percpu,avg5]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','5b053b6c00464f8b8f5fc49fffda1394');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23004','0','','10078','Context switches per second','system.cpu.switches','1m','1w','365d','0','3','','sps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','320f8803624f4ad2b9e66f1a08f5a145');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23005','0','','10078','CPU idle time','system.cpu.util[,idle]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent doing nothing.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','a653205d5ce4462089da4ed4d6f97f3a');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23007','0','','10078','CPU iowait time','system.cpu.util[,iowait]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Amount of time the CPU has been waiting for I/O to complete.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','9bee92be803c48489509e41c19718abc');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23011','0','','10078','CPU system time','system.cpu.util[,system]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running the kernel and its processes.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','bb32808bf73f489399ecb3e02bc18194');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23012','0','','10078','CPU user time','system.cpu.util[,user]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users\' processes that are not niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','d30ad6a457df4e39819b76fc1be7a562');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23013','0','','10078','Host name','system.hostname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'System host name.','3','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','1945e624e1864f2ba543f9438b1733f1');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23014','0','','10078','Host local time','system.localtime','1m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','0a0a8ab7047b400aaffe99917349291e');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23015','0','','10078','Free swap space','system.swap.size[,free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','71597a2dfdeb4c63acf7505ffb7f4f08');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23016','0','','10078','Free swap space in %','system.swap.size[,pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','b2ee2b52a64841e282915d6de3c7f739');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23017','0','','10078','Total swap space','system.swap.size[,total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','0e7ea1fd204c44f3b0a7880eac21a0df');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23018','0','','10078','System information','system.uname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The information as normally returned by \'uname -a\'.','5','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','034f7934cdb54cc6b99194fac9197bfb');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23019','0','','10078','System uptime','system.uptime','10m','1w','365d','0','3','','uptime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','c15a8b1b6cbd446bad669ead64a172a1');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23020','0','','10078','Number of logged in users','system.users.num','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of users who are currently logged in.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','a2c0d69124424e49aa4fc1f2416ffc37');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23021','0','','10078','Checksum of /etc/passwd','vfs.file.cksum[/etc/passwd]','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','5dd55b892d1b4828bfc570d6bf48251d');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23022','0','','10078','Available memory','vm.memory.size[available]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'Available memory is defined as free+cached+buffers memory.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','6888f0dd6b2e418f8c28a0ee59648fa3');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23023','0','','10078','Total memory','vm.memory.size[total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','d96d5ebfa074428e957335b5fa58189b');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23024','0','','10078','Network interface discovery','net.if.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of network interfaces as defined in global regular expression "Network interfaces for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','6a47f796859241c1aa30f0d731cacf52');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23025','0','','10078','Incoming network traffic on {#IFNAME}','net.if.in[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','548f317737ee4facbed4a371f3476352');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23026','0','','10078','Outgoing network traffic on {#IFNAME}','net.if.out[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','02dbf0af85294ab0bbf042fca79448cc');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23027','0','','10078','Mounted filesystem discovery','vfs.fs.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of file systems of different types as defined in global regular expression "File systems for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','3abf31160b404cf095daca79f2a03188');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23028','0','','10078','Free disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','e4c935091c6c49f185ef0e93963388ff');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23029','0','','10078','Free inodes on {#FSNAME} (percentage)','vfs.fs.inode[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','aa40b3df2229405193c373b00064e420');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23030','0','','10078','Total disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','e15cfb60494944db8e9b2fe929d91fef');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23031','0','','10078','Used disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},used]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','0da8a65250ec4027b3093772f5c26532');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23032','0','','10078','Free disk space on {#FSNAME} (percentage)','vfs.fs.size[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','e2805fb218d64ddd8ea58beae73e1343');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23035','0','','10079','Maximum number of opened files','kernel.maxfiles','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','d25aa1f2eae445ceb18b7e4ee5383585');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23036','0','','10079','Maximum number of processes','kernel.maxproc','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','5c376cae54854613a1533eb804bcee56');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23039','0','','10079','Host boot time','system.boottime','10m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','928f973c004447d099a79e09a8b98cee');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23041','0','','10079','Processor load (15 min average per core)','system.cpu.load[percpu,avg15]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','1ddc219f824541ca9c9ef30afda56df2');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23042','0','','10079','Processor load (1 min average per core)','system.cpu.load[percpu,avg1]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','5abd63bb64114794ae6d253dcc12afb4');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23043','0','','10079','Processor load (5 min average per core)','system.cpu.load[percpu,avg5]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','7e569411a7b4415098d21aaa44068dee');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23053','0','','10079','Host name','system.hostname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'System host name.','3','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','9c0230c0bb944523bd781c37304bb87b');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23054','0','','10079','Host local time','system.localtime','1m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','5a7ce2c61d3a4696ac76e0406308e61b');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23058','0','','10079','System information','system.uname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The information as normally returned by \'uname -a\'.','5','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','5c73ff0f28d24d92955c667e5245cfa0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23059','0','','10079','System uptime','system.uptime','10m','1w','365d','0','3','','uptime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','34c001a77a904224aa90338590375870');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23060','0','','10079','Number of logged in users','system.users.num','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of users who are currently logged in.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','31ea6bafabbe440ea1b8d1b6cea74444');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23061','0','','10079','Checksum of /etc/passwd','vfs.file.cksum[/etc/passwd]','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','6df0d9e8694d45dfa11e433d8de7be41');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23062','0','','10079','Available memory','vm.memory.size[available]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'Available memory is defined as free+cached+buffers memory.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','daf35c33bb84443f893bb06bfe10f870');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23063','0','','10079','Total memory','vm.memory.size[total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','83c0218324a548c4a01054801a4d8b0b');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23067','0','','10079','Mounted filesystem discovery','vfs.fs.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of file systems of different types as defined in global regular expression "File systems for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','c537fbe006d7434dab08add1dcf87537');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23068','0','','10079','Free disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','29340ac4c5d3419cb4508641e85d787d');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23069','0','','10079','Free inodes on {#FSNAME} (percentage)','vfs.fs.inode[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','b7560dc2b6f743458128961cc962bcd3');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23070','0','','10079','Total disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','c311ced2b4204b368af1c8a8c27f9c99');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23071','0','','10079','Used disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},used]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','748612098b4e4befa0f39f11b99eced4');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23072','0','','10079','Free disk space on {#FSNAME} (percentage)','vfs.fs.size[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','6d9aa50bddb642499ad575a0cc71146b');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23073','0','','10075','Incoming network traffic on {#IFNAME}','net.if.in[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','b1f9e472c6ed467d8cb0cc1739c39b59');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23074','0','','10075','Outgoing network traffic on {#IFNAME}','net.if.out[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','ac93068d05084aa0a32a1bee78df3bd8');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23075','0','','10074','Incoming network traffic on {#IFNAME}','net.if.in[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','81dec4b8de8c4ab68aef26d9f00aee87');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23076','0','','10074','Outgoing network traffic on {#IFNAME}','net.if.out[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','16bced1c77eb46799ecedcde5049dbdb');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23077','0','','10079','Incoming network traffic on en0','net.if.in[en0]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','951d874e6b644f9787c7a0d267bafcf8');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23078','0','','10079','Outgoing network traffic on en0','net.if.out[en0]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','ac875bd25d484d38b16cb02c30be6b67');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23108','0','','10076','CPU available physical processors in the shared pool','system.stat[cpu,app]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','081f8986446d43e7a3b72f7084576600');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23109','0','','10076','CPU entitled capacity consumed','system.stat[cpu,ec]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','6a97d56a6c2e45e1b10b97e2395ff30d');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23110','0','','10076','CPU idle time','system.stat[cpu,id]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','142f33d7b2c3469c9664fedf4f053616');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23111','0','','10076','CPU logical processor utilization','system.stat[cpu,lbusy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','752c952fb18e4a0e8e5e3415b107b9f1');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23112','0','','10076','CPU number of physical processors consumed','system.stat[cpu,pc]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','748f1316a33b48658b11dca8f45cfcce');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23113','0','','10076','CPU system time','system.stat[cpu,sy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','2647132edb6647ca9ef43a00ca09ecbd');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23114','0','','10076','CPU user time','system.stat[cpu,us]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','e990898ddbb74c7b9a8c1c67cb9544cf');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23115','0','','10076','CPU iowait time','system.stat[cpu,wa]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','2cd7a00570ad487d9cdf39fd198b2c0b');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23116','0','','10076','Amount of data transferred','system.stat[disk,bps]','1m','1w','365d','0','0','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','6748e4c87589472ca1474f3c7b729e0c');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23117','0','','10076','Number of transfers','system.stat[disk,tps]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','bf0180d8f109451db616749990a113a6');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23118','0','','10076','Processor units is entitled to receive','system.stat[ent]','1h','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','3e1af0261f6a421d8ca554f8eb222716');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23119','0','','10076','Kernel thread context switches','system.stat[faults,cs]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','0fe71698a3c74c93a8cb3a937dc7226c');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23120','0','','10076','Device interrupts','system.stat[faults,in]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','a1e13d2dbd8b4086974ea32a2cd743b1');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23121','0','','10076','System calls','system.stat[faults,sy]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','883c7a12b1d54f4d8189ca0d9cc43102');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23122','0','','10076','Length of the swap queue','system.stat[kthr,b]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','f027ed1c43464d4ab9a13d4b9f647e7e');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23123','0','','10076','Length of the run queue','system.stat[kthr,r]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','6795c2b6914d4303bf30c71c7405ff7d');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23124','0','','10076','Active virtual pages','system.stat[memory,avm]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','12142f133863448c9c937c671e183bbb');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23125','0','','10076','Free real memory','system.stat[memory,fre]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','3b4a5ff768654ff5a87b955684a0d7b5');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23126','0','','10076','File page-ins per second','system.stat[page,fi]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','bf890bf5cd1748a5af9528a111ba43c4');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23127','0','','10076','File page-outs per second','system.stat[page,fo]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','19c4f7132b6c46aa9522bd46da3e8f03');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23128','0','','10076','Pages freed (page replacement)','system.stat[page,fr]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','9ff3f7faa76c414aae7c5babb91fe065');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23129','0','','10076','Pages paged in from paging space','system.stat[page,pi]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','6009d8a0fc2f486db979b226eb975e78');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23130','0','','10076','Pages paged out to paging space','system.stat[page,po]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','26fb1471e08c4c46800e4887d8bccd80');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23131','0','','10076','Pages scanned by page-replacement algorithm','system.stat[page,sr]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','83b1456726d448d6a756e03c0ec02342');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23171','5','','10047','Zabbix server: Utilization of snmp trapper data collector processes, in %','zabbix[process,snmp trapper,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time snmp trapper processes have been busy in the last minute','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','cb9a7c4f3373496da97f3e0b8c978366');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23251','5','','10047','Zabbix server: Queue','zabbix[queue]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of monitored items in the queue which are delayed at least by 6 seconds.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','aaf58555c0774e848f51a351b6ae8462');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23318','0','','10050','Host name of Zabbix agent running','agent.hostname','1h','7d','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','f46c6142cf434df1b6abe9334bf6c84c');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23329','0','','10074','Network interface discovery','net.if.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of network interfaces as defined in global regular expression "Network interfaces for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','d02d41ad698942bfab1fe29fad31010a');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23340','5','','10048','Zabbix proxy: Number of processed values per second','zabbix[wcache,values]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache.\r\nTotal number of values processed by Zabbix server or Zabbix proxy, except unsupported items.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','5229b786efc84f01bb31f2819c47d9f4');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23341','5','','10048','Zabbix proxy: History index cache, % used','zabbix[wcache,index,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache. Percentage of used history index buffer.\r\nHistory index cache is used to index values stored in history cache.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','8c4c7802497d4de4988278edc29f8eb1');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23342','5','','10048','Zabbix proxy: History write cache, % used','zabbix[wcache,history,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Statistics and availability of Zabbix write cache. Percentage of used history buffer.\r\nHistory cache is used to store item values. A high number indicates performance problems on the database side.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','aec73d2a7e444702b352c75998bf636e');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23343','5','','10048','Zabbix proxy: Utilization of self-monitoring internal processes, in %','zabbix[process,self-monitoring,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time self-monitoring processes have been busy in the last minute.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','1fd488bbb4af450cb2b5e8c81b739f29');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23344','5','','10048','Zabbix proxy: Utilization of snmp trapper data collector processes, in %','zabbix[process,snmp trapper,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time snmp trapper processes have been busy in the last minute.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','77ab21500d734deea86938a1a90035e0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23345','5','','10048','Zabbix proxy: Utilization of trapper data collector processes, in %','zabbix[process,trapper,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time trapper processes have been busy in the last minute.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','8d99635291d14ae8a5ba7d794540bde2');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23346','5','','10048','Zabbix proxy: Utilization of unreachable poller data collector processes, in %','zabbix[process,unreachable poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time unreachable poller processes have been busy in the last minute.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','7b0f5b75d4854b84a7e1f51975732e25');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23347','5','','10048','Zabbix proxy: Utilization of configuration syncer internal processes, in %','zabbix[process,configuration syncer,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time configuration syncer processes have been busy in the last minute.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','3d1bfa64a447427da0b463c3617b212e');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23348','5','','10048','Zabbix proxy: Utilization of poller data collector processes, in %','zabbix[process,poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time poller processes have been busy in the last minute.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','334398ad893e4146bc1b9370eef9df59');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23349','5','','10048','Zabbix proxy: Utilization of java poller data collector processes, in %','zabbix[process,java poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time java poller processes have been busy in the last minute.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','02214c0c38394bef8d648369584ae30b');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23350','5','','10048','Zabbix proxy: Utilization of history syncer internal processes, in %','zabbix[process,history syncer,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time history syncer processes have been busy in the last minute.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','7dde8cd03e5043a2bd484f7213a5f112');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23351','5','','10048','Zabbix proxy: Utilization of heartbeat sender internal processes, in %','zabbix[process,heartbeat sender,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time heartbeat sender processes have been busy in the last minute.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','a1a7b0f3c34248a0993c305cd76fea5a');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23352','5','','10048','Zabbix proxy: Utilization of discoverer data collector processes, in %','zabbix[process,discoverer,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time discoverer processes have been busy in the last minute.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','1d00c5ef345f4827a921ff3e3617d316');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23353','5','','10048','Zabbix proxy: Utilization of housekeeper internal processes, in %','zabbix[process,housekeeper,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time housekeeper processes have been busy in the last minute.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','31f0355f4d7c4de6b0d6f206d1ca9fa3');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23354','5','','10048','Zabbix proxy: Utilization of http poller data collector processes, in %','zabbix[process,http poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time http poller processes have been busy in the last minute.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','782b11dbe3ce47e3b9098c43d83057ad');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23355','5','','10048','Zabbix proxy: Utilization of ipmi poller data collector processes, in %','zabbix[process,ipmi poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time ipmi poller processes have been busy in the last minute.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','7cfb2f1504dd4b0aaac804b132d49bc5');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23356','5','','10048','Zabbix proxy: Utilization of icmp pinger data collector processes, in %','zabbix[process,icmp pinger,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time icmp pinger processes have been busy in the last minute.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','9b899ab317b447d1a82d1136e0a2ff6f');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23357','5','','10048','Zabbix proxy: Configuration cache, % used','zabbix[rcache,buffer,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Availability statistics of Zabbix configuration cache. Percentage of used buffer.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','606d1d43812341db8260a233295a4a4e');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23358','5','','10048','Zabbix proxy: Queue','zabbix[queue]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of monitored items in the queue which are delayed at least by 6 seconds.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','cfbb623cca754fd49d4f606ab52f658d');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23359','5','','10048','Zabbix proxy: Queue over 10 minutes','zabbix[queue,10m]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of monitored items in the queue which are delayed at least by 10 minutes.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','2fa1c8d8fcb94d4c83cf4e291420a690');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23360','5','','10048','Zabbix proxy: Utilization of data sender internal processes, in %','zabbix[process,data sender,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time data sender processes have been busy in the last minute.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','69eefd6aba164d71b0a2b8d2df06e9a3');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23540','0','','10075','Network interface discovery','net.if.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of network interfaces as defined in global regular expression "Network interfaces for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','cac3466488a544198f766d1152878456');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23634','5','','10047','Zabbix server: VMware cache, % used','zabbix[vmware,buffer,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Availability statistics of Zabbix vmware cache. Percentage of used buffer.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','d273413004094604ad247c0ff9695879');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23644','3','','10093','FTP service is running','net.tcp.service[ftp]','1m','1w','365d','0','3','','','','',NULL,'1','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','057eaf069912400994e28af132ad5db8');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23645','3','','10094','HTTP service is running','net.tcp.service[http]','1m','1w','365d','0','3','','','','',NULL,'2','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','26ee93987891435ba049c84729559f07');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23646','3','','10095','HTTPS service is running','net.tcp.service[https]','1m','1w','365d','0','3','','','','',NULL,'3','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','7164297bdfa54a5b897fc908bdcfb86c');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23647','3','','10096','IMAP service is running','net.tcp.service[imap]','1m','1w','365d','0','3','','','','',NULL,'4','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','823451f4ebb6437c88c2915ba6d6faad');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23648','3','','10097','LDAP service is running','net.tcp.service[ldap]','1m','1w','365d','0','3','','','','',NULL,'5','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','a0d19592dc5b4ab49240fc7d6101a459');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23649','3','','10098','NNTP service is running','net.tcp.service[nntp]','1m','1w','365d','0','3','','','','',NULL,'6','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','4ac15acb2a1f488eb56088c6f963d1c7');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23650','3','','10099','NTP service is running','net.udp.service[ntp]','1m','1w','365d','0','3','','','','',NULL,'7','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','e6101cf9015e436e82d9203f638f1840');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23651','3','','10100','POP service is running','net.tcp.service[pop]','1m','1w','365d','0','3','','','','',NULL,'8','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','ef6870d87700429a92c3dc496342457a');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23652','3','','10101','SMTP service is running','net.tcp.service[smtp]','1m','1w','365d','0','3','','','','',NULL,'9','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','7edce69c026143258edc03dc8e970ec9');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23653','3','','10102','SSH service is running','net.tcp.service[ssh]','1m','1w','365d','0','3','','','','',NULL,'10','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','096952457aad464e9669a0fef710874b');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23654','3','','10103','Telnet service is running','net.tcp.service[telnet]','1m','1w','365d','0','3','','','','',NULL,'11','','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','55990514600a4a998dbc4bdd94edbcb2');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23661','5','','10047','Zabbix server: Value cache operating mode','zabbix[vcache,cache,mode]','1m','1w','365d','0','3','','','','',NULL,'55','','','0','','','','','0',NULL,'Value cache operating mode.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','07379df0114445b7b06818736f011ca6');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('23663','5','','10047','Zabbix server: Utilization of task manager internal processes, in %','zabbix[process,task manager,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time task manager processes have been busy in the last minute','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','caeb7ecc88cc4c14bb80f901284be9a5');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('25366','5','','10047','Zabbix server: Utilization of ipmi manager internal processes, in %','zabbix[process,ipmi manager,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time ipmi manager processes have been busy in the last minute','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','24b6b466929347f0a8164c89ba5624fe');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('25368','5','','10048','Zabbix proxy: Utilization of ipmi manager internal processes, in %','zabbix[process,ipmi manager,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time ipmi manager processes have been busy in the last minute.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','52b3123dfef94d8bba1b1a13314a9d4f');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('25369','5','','10048','Zabbix proxy: Utilization of task manager internal processes, in %','zabbix[process,task manager,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time task manager processes have been busy in the last minute.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','94d1aa1bff2d499f9e29dd9cafd04b9e');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('25370','5','','10047','Zabbix server: Utilization of alert manager internal processes, in %','zabbix[process,alert manager,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time alert manager processes have been busy in the last minute','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','d098ea71dd22428a8a8a42cf299699b7');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('25665','5','','10047','Zabbix server: Utilization of preprocessing manager internal processes, in %','zabbix[process,preprocessing manager,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time preprocessing manager processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','fc7999dd8d2d41a5a80eeb4b6c4c9b13');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('25666','5','','10047','Zabbix server: Utilization of preprocessing worker internal processes, in %','zabbix[process,preprocessing worker,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Average percentage of time preprocessing worker processes have been busy in the last minute','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','6af695693d41434a96c0c6a020580828');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('26925','12','','10171','Power','power','1m','1w','365d','0','3','','','','',NULL,NULL,'','power','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','1821294a921d401f822678ce1d246163');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('26926','12','','10171','Processor Vcc','processor_vcc','1m','1w','365d','0','0','','V','','',NULL,NULL,'','Processor Vcc','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','efc577d6deba4f46b1fe79e6a1a26fdd');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('26927','12','','10171','System Fan 3','system_fan_3','1m','1w','365d','0','0','','RPM','','',NULL,NULL,'','System Fan 3','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','89e5edc9cd6d4984a7a76320f7800ae9');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('26928','12','','10171','BB Ambient Temp','bb_ambient_temp','1m','1w','365d','0','0','','C','','',NULL,NULL,'','BB Ambient Temp','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','2e6d7059cbb349889c639e9fba09bd8c');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('26929','12','','10171','BB +5.0V','bb_5.0v','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +5.0V','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','7931e499e1894942a4763432a6a446fd');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('26930','12','','10171','BB +3.3V','bb_3.3v','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +3.3V','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','21820c76180446ff9965f8937e6d1ba0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('26931','12','','10171','BB +3.3V STBY','bb_3.3v_stby','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +3.3V STBY','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','7bd5269be38c417aba374c9e8af28f8c');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('26932','12','','10171','BB +1.8V SM','bb_1.8v_sm','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +1.8V SM','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','f1d7b90d87c6411e9d887d223b4f9022');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('26933','12','','10172','Front Panel Temp','front_panel_temp','1m','1w','365d','0','0','','C','','',NULL,NULL,'','Front Panel Temp','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','d59236617a234098b0cd62ac30cba975');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('26934','12','','10172','Power','power','1m','1w','365d','0','3','','','','',NULL,NULL,'','power','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','e4f51e8a51fb4f23afe9d505ede91891');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('26935','12','','10172','System Fan 2','system_fan_2','1m','1w','365d','0','0','','RPM','','',NULL,NULL,'','System Fan 2','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','ede3efc70c794c3390531b41a28411ef');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('26936','12','','10172','System Fan 3','system_fan_3','1m','1w','365d','0','0','','RPM','','',NULL,NULL,'','System Fan 3','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','b51ab327c547413fb94dae69e93458d2');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('26937','12','','10172','BB +5.0V','bb_5.0v','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +5.0V','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','5a60f33969e54742989571dc2f93be57');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('26938','12','','10172','BB +3.3V STBY','bb_3.3v_stby','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +3.3V STBY','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','aef2b61786354719a6d99f60cff59f14');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('26939','12','','10172','BB +1.05V PCH','bb_1.05v_pch','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +1.05V PCH','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','d2827f4cc6c4470daf4fd20868ed94c8');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('26940','12','','10172','BB +1.1V P1 Vccp','bb_1.1v_p1_vccp','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +1.1V P1 Vccp','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','3bbcfcb625fa4805806601284c3eda20');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('26941','12','','10172','BB +1.5V P1 DDR3','bb_1.5v_p1_ddr3','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +1.5V P1 DDR3','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','350b21b2a569489a9c4c7376bf788a0e');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('26942','12','','10172','BB +3.3V','bb_3.3v','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +3.3V','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','6bc6b9c60ce24189b8b0f8a928fab701');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('26943','12','','10172','Baseboard Temp','baseboard_temp','1m','1w','365d','0','0','','C','','',NULL,NULL,'','Baseboard Temp','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','8271dc34162d4657be1a67b5d8a4473b');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('27031','20','discovery[{#SNMPVALUE},1.3.6.1.2.1.10.7.2.1.19,{#IFOPERSTATUS},1.3.6.1.2.1.2.2.1.8,{#IFALIAS},1.3.6.1.2.1.31.1.1.1.18,{#IFNAME},1.3.6.1.2.1.31.1.1.1.1,{#IFDESCR},1.3.6.1.2.1.2.2.1.2]','10183','EtherLike-MIB Discovery','net.if.duplex.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovering interfaces from IF-MIB and EtherLike-MIB. Interfaces with up(1) Operational Status are discovered.','0','30d','1','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','2a04f08ae9504f9dadb73550700960b1');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('27032','20','1.3.6.1.2.1.10.7.2.1.19.{#SNMPINDEX}','10183','Interface {#IFNAME}({#IFALIAS}): Duplex status','net.if.duplex[dot3StatsDuplexStatus.{#SNMPINDEX}]','1m','7d','365d','0','3','','','','',NULL,'59','','','0','','','','','2',NULL,'MIB: EtherLike-MIB\r\nThe current mode of operation of the MAC\r\nentity.  \'unknown\' indicates that the current\r\nduplex mode could not be determined.\r\n\r\nManagement control of the duplex mode is\r\naccomplished through the MAU MIB.  When\r\nan interface does not support autonegotiation,\r\nor when autonegotiation is not enabled, the\r\nduplex mode is controlled using\r\nifMauDefaultType.  When autonegotiation is\r\nsupported and enabled, duplex mode is controlled\r\nusing ifMauAutoNegAdvertisedBits.  In either\r\ncase, the currently operating duplex mode is\r\nreflected both in this object and in ifMauType.\r\n\r\nNote that this object provides redundant\r\ninformation with ifMauType.  Normally, redundant\r\nobjects are discouraged.  However, in this\r\ninstance, it allows a management application to\r\ndetermine the duplex status of an interface\r\nwithout having to know every possible value of\r\nifMauType.  This was felt to be sufficiently\r\nvaluable to justify the redundancy.\r\nReference: [IEEE 802.3 Std.], 30.3.1.1.32,aDuplexStatus.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','6bb6b8b98190429ca7564944885f5bdc');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('27065','3','','10186','ICMP response time','icmppingsec','1m','1w','365d','0','0','','s','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','a79e33e5fd264725b934f603fa071555');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('27066','3','','10186','ICMP loss','icmppingloss','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','04b21adaf422473a88df2c52786474ed');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('27067','3','','10186','ICMP ping','icmpping','1m','1w','365d','0','3','','','','',NULL,'12','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','db5a94f6cea14deba957202b2f014469');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('27078','20','discovery[{#IFOPERSTATUS},1.3.6.1.2.1.2.2.1.8,{#IFADMINSTATUS},1.3.6.1.2.1.2.2.1.7,{#IFNAME},1.3.6.1.2.1.2.2.1.2,{#IFDESCR},1.3.6.1.2.1.2.2.1.2,{#IFTYPE},1.3.6.1.2.1.2.2.1.3]','10188','Network interfaces discovery','net.if.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovering interfaces from IF-MIB.','0','30d','1','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','4d142a571991482da0560cb2faa8f673');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('27079','20','1.3.6.1.2.1.2.2.1.13.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Inbound packets discarded','net.if.in.discards[ifInDiscards.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nThe number of inbound packets which were chosen to be discarded\r\neven though no errors had been detected to prevent their being deliverable to a higher-layer protocol.\r\nOne possible reason for discarding such a packet could be to free up buffer space.\r\nDiscontinuities in the value of this counter can occur at re-initialization of the management system,\r\nand at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','018d93910eef44388fcd1eb1de63262b');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('27080','20','1.3.6.1.2.1.2.2.1.3.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Interface type','net.if.type[ifType.{#SNMPINDEX}]','1h','7d','0d','0','3','','','','',NULL,'66','','','0','','','','','2',NULL,'MIB: IF-MIB\r\nThe type of interface.\r\nAdditional values for ifType are assigned by the Internet Assigned NumbersAuthority (IANA),\r\nthrough updating the syntax of the IANAifType textual convention.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','9470d6a01c4e4ea2a007582ac1c0ce64');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('27081','20','1.3.6.1.2.1.2.2.1.5.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Speed','net.if.speed[ifSpeed.{#SNMPINDEX}]','5m','7d','0d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nAn estimate of the interface\'s current bandwidth in bits per second.\r\nFor interfaces which do not vary in bandwidth or for those where no accurate estimation can be made,\r\nthis object should contain the nominal bandwidth.\r\nIf the bandwidth of the interface is greater than the maximum value reportable by this object then\r\nthis object should report its maximum value (4,294,967,295) and ifHighSpeed must be used to report the interace\'s speed.\r\nFor a sub-layer which has no concept of bandwidth, this object should be zero.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','b93b4164db1c4c838ecfd5c2b261acfb');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('27082','20','1.3.6.1.2.1.2.2.1.19.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Outbound packets discarded','net.if.out.discards[ifOutDiscards.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nThe number of outbound packets which were chosen to be discarded\r\neven though no errors had been detected to prevent their being deliverable to a higher-layer protocol.\r\nOne possible reason for discarding such a packet could be to free up buffer space.\r\nDiscontinuities in the value of this counter can occur at re-initialization of the management system,\r\nand at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','2395b3a694474b9894e64f759dbe805e');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('27083','20','1.3.6.1.2.1.2.2.1.20.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Outbound packets with errors','net.if.out.errors[ifOutErrors.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nFor packet-oriented interfaces, the number of outbound packets that contained errors preventing them from being deliverable to a higher-layer protocol.  For character-oriented or fixed-length interfaces, the number of outbound transmission units that contained errors preventing them from being deliverable to a higher-layer protocol. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','f6872ed88b464c37800738fd5e492896');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('27084','20','1.3.6.1.2.1.2.2.1.10.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Bits received','net.if.in[ifInOctets.{#SNMPINDEX}]','3m','7d','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nThe total number of octets received on the interface,including framing characters. Discontinuities in the value of this counter can occurat re-initialization of the management system, and atother times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','3a971825c99e476aa2c18b1a792ec19d');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('27085','20','1.3.6.1.2.1.2.2.1.16.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Bits sent','net.if.out[ifOutOctets.{#SNMPINDEX}]','3m','7d','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nThe total number of octets transmitted out of the interface, including framing characters. Discontinuities in the value of this counter can occurat re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','2a7b5b7e48444c8c8cf38f89a1a1091e');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('27086','20','1.3.6.1.2.1.2.2.1.14.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Inbound packets with errors','net.if.in.errors[ifInErrors.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nFor packet-oriented interfaces, the number of inbound packets that contained errors preventing them from being deliverable to a higher-layer protocol.  For character-oriented or fixed-length interfaces, the number of inbound transmission units that contained errors preventing them from being deliverable to a higher-layer protocol. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','f97ed0e4b7b3473a988f27a60e5d79ef');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('27087','20','1.3.6.1.2.1.2.2.1.8.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Operational status','net.if.status[ifOperStatus.{#SNMPINDEX}]','1m','7d','0','0','3','','','','',NULL,'60','','','0','','','','','2',NULL,'MIB: IF-MIB\r\nThe current operational state of the interface.\r\n- The testing(3) state indicates that no operational packet scan be passed\r\n- If ifAdminStatus is down(2) then ifOperStatus should be down(2)\r\n- If ifAdminStatus is changed to up(1) then ifOperStatus should change to up(1) if the interface is ready to transmit and receive network traffic\r\n- It should change todormant(5) if the interface is waiting for external actions (such as a serial line waiting for an incoming connection)\r\n- It should remain in the down(2) state if and only if there is a fault that prevents it from going to the up(1) state\r\n- It should remain in the notPresent(6) state if the interface has missing(typically, hardware) components.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','43d9d7883a1b4f6dbe4e118ef12d731e');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`) values ('27098','20','discovery[{#IFOPERSTATUS},1.3.6.1.2.1.2.2.1.8,{#IFADMINSTATUS},1.3.6.1.2.1.2.2.1.7,{#IFALIAS},1.3.6.1.2.1.31.1.1.1.18,{#IFNAME},1.3.6.1.2.1.31.1.1.1.1,{#IFDESCR},1.3.6.1.2.1.2.2.1.2,{#IFTYPE},1.3.6.1.2.1.2.2.1.3]','10190','Network interfaces discovery','net.if.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovering interfaces from IF-MIB.','0','30d','1','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0','ea9babbf98cf48688aa00faf500e171e');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`