/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.meta;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.NullUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.meta.MetaDataContributor;
import com.intellij.psi.meta.MetaDataRegistrar;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MetaRegistry
extends MetaDataRegistrar {
    private static final Logger LOG = Logger.getInstance(MetaRegistry.class);
    private static final List<MyBinding> ourBindings = ContainerUtil.createLockFreeCopyOnWriteList();
    private static volatile boolean ourContributorsLoaded;

    public static PsiMetaData getMeta(PsiElement element) {
        return MetaRegistry.getMetaBase(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearBindings() {
        List<MyBinding> list2 = ourBindings;
        synchronized (list2) {
            ourContributorsLoaded = false;
            ourBindings.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureContributorsLoaded() {
        if (!ourContributorsLoaded) {
            List<MyBinding> list2 = ourBindings;
            synchronized (list2) {
                if (!ourContributorsLoaded) {
                    for (MetaDataContributor contributor : MetaDataContributor.EP_NAME.getExtensionList()) {
                        contributor.contributeMetaData(MetaDataRegistrar.getInstance());
                    }
                    ourContributorsLoaded = true;
                }
            }
        }
    }

    @Nullable
    public static PsiMetaData getMetaBase(PsiElement element) {
        ProgressIndicatorProvider.checkCanceled();
        return (PsiMetaData)CachedValuesManager.getCachedValue(element, () -> {
            MetaRegistry.ensureContributorsLoaded();
            for (MyBinding binding : ourBindings) {
                if (!binding.myFilter.isClassAcceptable(element.getClass()) || !binding.myFilter.isAcceptable(element, element.getParent())) continue;
                PsiMetaData data = (PsiMetaData)binding.myDataClass.get();
                data.init(element);
                Object[] dependencies2 = data.getDependencies();
                if (NullUtils.hasNull(dependencies2)) {
                    LOG.error(data + "(" + binding.myDataClass + ") provided null dependency");
                }
                return new CachedValueProvider.Result<PsiMetaData>(data, ArrayUtil.append(dependencies2, element));
            }
            return new CachedValueProvider.Result<Object>(null, element);
        });
    }

    @Override
    public <T extends PsiMetaData> void registerMetaData(ElementFilter filter2, Class<T> metadataDescriptorClass) {
        Supplier<PsiMetaData> supplier = () -> {
            try {
                return (PsiMetaData)metadataDescriptorClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.error(e);
                return null;
            }
        };
        ourBindings.add(0, new MyBinding(filter2, supplier));
    }

    static {
        MetaDataContributor.EP_NAME.addChangeListener(MetaRegistry::clearBindings, ApplicationManager.getApplication());
    }

    private static class MyBinding {
        private final ElementFilter myFilter;
        private final Supplier<? extends PsiMetaData> myDataClass;

        MyBinding(@NotNull ElementFilter filter2, @NotNull Supplier<? extends PsiMetaData> dataClass) {
            if (filter2 == null) {
                MyBinding.$$$reportNull$$$0(0);
            }
            if (dataClass == null) {
                MyBinding.$$$reportNull$$$0(1);
            }
            this.myFilter = filter2;
            this.myDataClass = dataClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataClass";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/meta/MetaRegistry$MyBinding";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

