/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.references.FirBackingFieldReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirValReassignmentChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirVariableAssignmentChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkValReassignmentOnValueParameter", "checkValReassignmentViaBackingField", "checkers"})
public final class FirValReassignmentChecker
extends FirExpressionChecker<FirVariableAssignment> {
    @NotNull
    public static final FirValReassignmentChecker INSTANCE = new FirValReassignmentChecker();

    private FirValReassignmentChecker() {
    }

    @Override
    public void check(@NotNull FirVariableAssignment expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        this.checkValReassignmentViaBackingField(expression2, context2, reporter);
        this.checkValReassignmentOnValueParameter(expression2, context2, reporter);
    }

    private final void checkValReassignmentViaBackingField(FirVariableAssignment expression2, CheckerContext context2, DiagnosticReporter reporter) {
        FirElement firElement;
        FirBackingFieldSymbol propertySymbol;
        FirBackingFieldReference backingFieldReference;
        block8: {
            FirBackingFieldReference firBackingFieldReference;
            FirReference firReference = expression2.getLValue();
            FirBackingFieldReference firBackingFieldReference2 = firBackingFieldReference = firReference instanceof FirBackingFieldReference ? (FirBackingFieldReference)firReference : null;
            if (firBackingFieldReference == null) {
                return;
            }
            backingFieldReference = firBackingFieldReference;
            propertySymbol = backingFieldReference.getResolvedSymbol();
            if (propertySymbol.isVar()) {
                return;
            }
            CheckerContext $this$findClosest$iv = context2;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest$iv.getContainingDeclarations())) {
                FirElement firElement2;
                FirElement firElement3;
                FirElement firElement4;
                FirDeclaration firDeclaration = it$iv;
                if (!(firDeclaration instanceof FirPropertyAccessor)) {
                    firDeclaration = null;
                }
                if ((firElement4 = (FirElement)((FirPropertyAccessor)firDeclaration)) == null) {
                    firElement3 = null;
                } else {
                    FirElement firElement5 = firElement4;
                    FirPropertyAccessor it = (FirPropertyAccessor)firElement5;
                    boolean bl = false;
                    firElement3 = firElement2 = it.isGetter() ? firElement5 : null;
                }
                if (firElement2 == null) continue;
                firElement = firElement2;
                break block8;
            }
            firElement = null;
        }
        FirPropertyAccessor firPropertyAccessor = (FirPropertyAccessor)firElement;
        if (firPropertyAccessor == null) {
            return;
        }
        FirPropertyAccessorSymbol closestGetter = firPropertyAccessor.getSymbol();
        if (!Intrinsics.areEqual(propertySymbol.getGetterSymbol(), closestGetter)) {
            return;
        }
        DiagnosticReporterKt.reportOn$default(reporter, backingFieldReference.getSource(), FirErrors.INSTANCE.getVAL_REASSIGNMENT_VIA_BACKING_FIELD(), (Object)propertySymbol, context2, null, 16, null);
    }

    private final void checkValReassignmentOnValueParameter(FirVariableAssignment expression2, CheckerContext context2, DiagnosticReporter reporter) {
        FirValueParameterSymbol firValueParameterSymbol;
        FirReference firReference = expression2.getLValue();
        FirResolvedNamedReference firResolvedNamedReference = firReference instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)firReference : null;
        FirBasedSymbol<?> firBasedSymbol = firResolvedNamedReference == null ? null : firResolvedNamedReference.getResolvedSymbol();
        FirValueParameterSymbol firValueParameterSymbol2 = firValueParameterSymbol = firBasedSymbol instanceof FirValueParameterSymbol ? (FirValueParameterSymbol)firBasedSymbol : null;
        if (firValueParameterSymbol == null) {
            return;
        }
        FirValueParameterSymbol valueParameter2 = firValueParameterSymbol;
        DiagnosticReporterKt.reportOn$default(reporter, expression2.getLValue().getSource(), FirErrors.INSTANCE.getVAL_REASSIGNMENT(), (Object)valueParameter2, context2, null, 16, null);
    }
}

