/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.DefaultNamesKt;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.backend.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrSignatureComposer;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverterKt;
import org.jetbrains.kotlin.fir.backend.FirMetadataSource;
import org.jetbrains.kotlin.fir.backend.generators.DataClassMembersGenerator;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.builder.FirSimpleFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBooleanTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitIntTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitNullableAnyTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitStringTypeRef;
import org.jetbrains.kotlin.ir.builders.IrGeneratorContextBase;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrValueParameterSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DataClassMembersGenerator;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator;", "", "components", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;)V", "getComponents", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "generateDataClassComponentBody", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "lookupTag", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "generateDataClassCopyBody", "generateDataClassMembers", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "generateInlineClassMembers", "Companion", "MyDataClassMethodsGenerator", "fir2ir"})
public final class DataClassMembersGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Fir2IrComponents components;

    public DataClassMembersGenerator(@NotNull Fir2IrComponents components2) {
        Intrinsics.checkNotNullParameter(components2, "components");
        this.components = components2;
    }

    @NotNull
    public final Fir2IrComponents getComponents() {
        return this.components;
    }

    @NotNull
    public final List<FirDeclaration> generateInlineClassMembers(@NotNull FirClass klass, @NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        return new MyDataClassMethodsGenerator(irClass2, klass.getSymbol().toLookupTag(), IrDeclarationOrigin.GENERATED_INLINE_CLASS_MEMBER.INSTANCE).generate(klass);
    }

    @NotNull
    public final List<FirDeclaration> generateDataClassMembers(@NotNull FirClass klass, @NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        return new MyDataClassMethodsGenerator(irClass2, klass.getSymbol().toLookupTag(), IrDeclarationOrigin.GENERATED_DATA_CLASS_MEMBER.INSTANCE).generate(klass);
    }

    public final void generateDataClassComponentBody(@NotNull IrFunction irFunction2, @NotNull ConeClassLikeLookupTag lookupTag) {
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        Intrinsics.checkNotNullParameter(lookupTag, "lookupTag");
        new MyDataClassMethodsGenerator(IrUtilsKt.getParentAsClass(irFunction2), lookupTag, IrDeclarationOrigin.GENERATED_DATA_CLASS_MEMBER.INSTANCE).generateComponentBody(irFunction2);
    }

    public final void generateDataClassCopyBody(@NotNull IrFunction irFunction2, @NotNull ConeClassLikeLookupTag lookupTag) {
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        Intrinsics.checkNotNullParameter(lookupTag, "lookupTag");
        new MyDataClassMethodsGenerator(IrUtilsKt.getParentAsClass(irFunction2), lookupTag, IrDeclarationOrigin.GENERATED_DATA_CLASS_MEMBER.INSTANCE).generateCopyBody(irFunction2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000k\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003*\u0001\f\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\u0013H\u0002J*\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010'\u001a\u00020\"2\b\b\u0002\u0010(\u001a\u00020)H\u0002J\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u0002002\u0006\u0010&\u001a\u00020\u001eJ\u000e\u00101\u001a\u0002002\u0006\u0010&\u001a\u00020\u001eJ\u000e\u00102\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00020\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\u00020\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0018\u0010\u0019\u001a\u00020\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0016R\u0018\u0010\u001b\u001a\u00020\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0016\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator$MyDataClassMethodsGenerator;", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "lookupTag", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "origin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "(Lorg/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;)V", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irDataClassMembersGenerator", "org/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator$MyDataClassMethodsGenerator$irDataClassMembersGenerator$1", "Lorg/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator$MyDataClassMethodsGenerator$irDataClassMembersGenerator$1;", "getLookupTag", "()Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "getOrigin", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "matchesDataClassSyntheticMemberSignatures", "", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "getMatchesDataClassSyntheticMemberSignatures", "(Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;)Z", "matchesEqualsSignature", "getMatchesEqualsSignature", "matchesHashCodeSignature", "getMatchesHashCodeSignature", "matchesToStringSignature", "getMatchesToStringSignature", "createSyntheticIrFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "name", "Lorg/jetbrains/kotlin/name/Name;", "returnType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "otherParameterNeeded", "createSyntheticIrParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "irFunction", "type", "index", "", "generate", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "generateComponentBody", "", "generateCopyBody", "generateDispatchReceiverParameter", "fir2ir"})
    private final class MyDataClassMethodsGenerator {
        @NotNull
        private final IrClass irClass;
        @NotNull
        private final ConeClassLikeLookupTag lookupTag;
        @NotNull
        private final IrDeclarationOrigin origin;
        @NotNull
        private final irDataClassMembersGenerator.1 irDataClassMembersGenerator;

        public MyDataClassMethodsGenerator(@NotNull IrClass irClass2, @NotNull ConeClassLikeLookupTag lookupTag, IrDeclarationOrigin origin) {
            Intrinsics.checkNotNullParameter(DataClassMembersGenerator.this, "this$0");
            Intrinsics.checkNotNullParameter(irClass2, "irClass");
            Intrinsics.checkNotNullParameter(lookupTag, "lookupTag");
            Intrinsics.checkNotNullParameter(origin, "origin");
            this.irClass = irClass2;
            this.lookupTag = lookupTag;
            this.origin = origin;
            IrGeneratorContextBase irGeneratorContextBase = new IrGeneratorContextBase(DataClassMembersGenerator.this.getComponents().getIrBuiltIns());
            SymbolTable symbolTable = DataClassMembersGenerator.this.getComponents().getSymbolTable();
            IrClass irClass3 = this.irClass;
            IrDeclarationOrigin irDeclarationOrigin = this.origin;
            this.irDataClassMembersGenerator = new org.jetbrains.kotlin.ir.util.DataClassMembersGenerator(DataClassMembersGenerator.this, irGeneratorContextBase, symbolTable, irClass3, irDeclarationOrigin){
                final /* synthetic */ DataClassMembersGenerator this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4);
                }

                @NotNull
                public IrFunction declareSimpleFunction(int startOffset, int endOffset, @NotNull FunctionDescriptor functionDescriptor) {
                    Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
                    throw new IllegalStateException("Not expect to see function declaration.");
                }

                public void generateSyntheticFunctionParameterDeclarations(@NotNull IrFunction irFunction2) {
                    Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
                }

                @Nullable
                public IrProperty getProperty(@Nullable ValueParameterDescriptor parameter, @Nullable IrValueParameter irValueParameter) {
                    IrProperty irProperty2;
                    IrValueParameter irValueParameter2 = irValueParameter;
                    if (irValueParameter2 == null) {
                        irProperty2 = null;
                    } else {
                        IrValueParameter irValueParameter3;
                        IrValueParameter it = irValueParameter3 = irValueParameter2;
                        boolean bl = false;
                        Sequence<IrProperty> $this$single$iv = IrUtilsKt.getProperties(this.getIrClass());
                        boolean $i$f$single = false;
                        IrProperty single$iv = null;
                        boolean found$iv = false;
                        Iterator<IrProperty> iterator2 = $this$single$iv.iterator();
                        while (iterator2.hasNext()) {
                            IrField irField;
                            IrProperty element$iv;
                            IrProperty irProperty3 = element$iv = iterator2.next();
                            boolean bl2 = false;
                            if (!(Intrinsics.areEqual(irProperty3.getName(), irValueParameter.getName()) && Intrinsics.areEqual((irField = irProperty3.getBackingField()) == null ? null : irField.getType(), irValueParameter.getType()))) continue;
                            if (found$iv) {
                                throw new IllegalArgumentException("Sequence contains more than one matching element.");
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        if (!found$iv) {
                            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                        }
                        irProperty2 = single$iv;
                    }
                    return irProperty2;
                }

                @NotNull
                public IrType transform(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
                    Intrinsics.checkNotNullParameter(typeParameterDescriptor, "typeParameterDescriptor");
                    return this.this$0.getComponents().getIrBuiltIns().getAnyType();
                }

                private final IrSimpleFunctionSymbol getHashCodeFunction(IrClass klass) {
                    IrSimpleFunctionSymbol irSimpleFunctionSymbol;
                    Object object;
                    Object it;
                    Object element$iv;
                    Iterator<Object> iterator2;
                    boolean found$iv;
                    Object single$iv;
                    block7: {
                        Sequence<IrSimpleFunction> $this$singleOrNull$iv = IrUtilsKt.getFunctions(klass);
                        boolean $i$f$singleOrNull = false;
                        single$iv = null;
                        found$iv = false;
                        iterator2 = $this$singleOrNull$iv.iterator();
                        while (iterator2.hasNext()) {
                            it = element$iv = iterator2.next();
                            boolean bl = false;
                            if (!(Intrinsics.areEqual(it.getName().asString(), "hashCode") && ((IrFunction)it).getValueParameters().isEmpty() && ((IrFunction)it).getExtensionReceiverParameter() == null)) continue;
                            if (found$iv) {
                                object = null;
                                break block7;
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        object = !found$iv ? null : single$iv;
                    }
                    IrSimpleFunction irSimpleFunction = (IrSimpleFunction)object;
                    if (irSimpleFunction == null) {
                        Sequence<IrSimpleFunctionSymbol> $this$single$iv = IrUtilsKt.getFunctions(this.getContext().getIrBuiltIns().getAnyClass());
                        boolean $i$f$single = false;
                        single$iv = null;
                        found$iv = false;
                        iterator2 = $this$single$iv.iterator();
                        while (iterator2.hasNext()) {
                            element$iv = iterator2.next();
                            it = (IrSimpleFunctionSymbol)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual(((IrSimpleFunction)it.getOwner()).getName().asString(), "hashCode")) continue;
                            if (found$iv) {
                                throw new IllegalArgumentException("Sequence contains more than one matching element.");
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        if (!found$iv) {
                            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                        }
                        irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)single$iv;
                    } else {
                        irSimpleFunctionSymbol = irSimpleFunction.getSymbol();
                    }
                    return irSimpleFunctionSymbol;
                }

                @NotNull
                public final IrClass getErasedUpperBound(@NotNull IrTypeParameter $this$erasedUpperBound) {
                    IrClass irClass2;
                    IrSymbolOwner firstSuper;
                    Intrinsics.checkNotNullParameter($this$erasedUpperBound, "<this>");
                    for (IrType type2 : $this$erasedUpperBound.getSuperTypes()) {
                        IrClass irClass3;
                        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(type2);
                        if (irClassSymbol == null || IrUtilsKt.isInterface(irClass3 = (IrClass)irClassSymbol.getOwner()) || IrUtilsKt.isAnnotationClass(irClass3)) continue;
                        return irClass3;
                    }
                    IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull(CollectionsKt.first($this$erasedUpperBound.getSuperTypes()));
                    IrSymbolOwner irSymbolOwner = firstSuper = irClassifierSymbol == null ? null : irClassifierSymbol.getOwner();
                    if (firstSuper instanceof IrClass) {
                        irClass2 = (IrClass)firstSuper;
                    } else if (firstSuper instanceof IrTypeParameter) {
                        irClass2 = this.getErasedUpperBound((IrTypeParameter)firstSuper);
                    } else {
                        throw new IllegalStateException(Intrinsics.stringPlus("unknown supertype kind ", firstSuper).toString());
                    }
                    return irClass2;
                }

                @NotNull
                public DataClassMembersGenerator.HashCodeFunctionInfo getHashCodeFunctionInfo(@NotNull IrType type2) {
                    IrSimpleFunctionSymbol irSimpleFunctionSymbol;
                    Intrinsics.checkNotNullParameter(type2, "type");
                    IrClassifierSymbol classifier2 = IrTypesKt.getClassifierOrNull(type2);
                    if (this.isArrayOrPrimitiveArray(classifier2)) {
                        irSimpleFunctionSymbol = this.getContext().getIrBuiltIns().getDataClassArrayMemberHashCodeSymbol();
                    } else if (classifier2 instanceof IrClassSymbol) {
                        irSimpleFunctionSymbol = this.getHashCodeFunction((IrClass)((IrClassSymbol)classifier2).getOwner());
                    } else if (classifier2 instanceof IrTypeParameterSymbol) {
                        irSimpleFunctionSymbol = this.getHashCodeFunction(this.getErasedUpperBound((IrTypeParameter)((IrTypeParameterSymbol)classifier2).getOwner()));
                    } else {
                        throw new IllegalStateException(Intrinsics.stringPlus("Unknown classifier kind ", classifier2).toString());
                    }
                    IrSimpleFunctionSymbol symbol2 = irSimpleFunctionSymbol;
                    return new irDataClassMembersGenerator.Fir2IrHashCodeFunctionInfo(this, symbol2);
                }
            };
        }

        @NotNull
        public final IrClass getIrClass() {
            return this.irClass;
        }

        @NotNull
        public final ConeClassLikeLookupTag getLookupTag() {
            return this.lookupTag;
        }

        @NotNull
        public final IrDeclarationOrigin getOrigin() {
            return this.origin;
        }

        @NotNull
        public final IrValueParameter generateDispatchReceiverParameter(@NotNull IrFunction irFunction2) {
            Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
            return ConversionUtilsKt.declareThisReceiverParameter(irFunction2, DataClassMembersGenerator.this.getComponents().getSymbolTable(), IrUtilsKt.getDefaultType(this.irClass), this.origin, -1, -1);
        }

        private final boolean getMatchesEqualsSignature(FirSimpleFunction $this$matchesEqualsSignature) {
            return $this$matchesEqualsSignature.getValueParameters().size() == 1 && Intrinsics.areEqual(Fir2IrTypeConverterKt.toIrType$default($this$matchesEqualsSignature.getValueParameters().get(0).getReturnTypeRef(), DataClassMembersGenerator.this.getComponents().getTypeConverter(), null, 2, null), DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getAnyNType()) && Intrinsics.areEqual(Fir2IrTypeConverterKt.toIrType$default($this$matchesEqualsSignature.getReturnTypeRef(), DataClassMembersGenerator.this.getComponents().getTypeConverter(), null, 2, null), DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getBooleanType());
        }

        private final boolean getMatchesHashCodeSignature(FirSimpleFunction $this$matchesHashCodeSignature) {
            return $this$matchesHashCodeSignature.getValueParameters().isEmpty() && Intrinsics.areEqual(Fir2IrTypeConverterKt.toIrType$default($this$matchesHashCodeSignature.getReturnTypeRef(), DataClassMembersGenerator.this.getComponents().getTypeConverter(), null, 2, null), DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getIntType());
        }

        private final boolean getMatchesToStringSignature(FirSimpleFunction $this$matchesToStringSignature) {
            return $this$matchesToStringSignature.getValueParameters().isEmpty() && Intrinsics.areEqual(Fir2IrTypeConverterKt.toIrType$default($this$matchesToStringSignature.getReturnTypeRef(), DataClassMembersGenerator.this.getComponents().getTypeConverter(), null, 2, null), DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getStringType());
        }

        private final boolean getMatchesDataClassSyntheticMemberSignatures(FirSimpleFunction $this$matchesDataClassSyntheticMemberSignatures) {
            return Intrinsics.areEqual($this$matchesDataClassSyntheticMemberSignatures.getName(), OperatorNameConventions.EQUALS) && this.getMatchesEqualsSignature($this$matchesDataClassSyntheticMemberSignatures) || Intrinsics.areEqual($this$matchesDataClassSyntheticMemberSignatures.getName(), DefaultNamesKt.getHASHCODE_NAME()) && this.getMatchesHashCodeSignature($this$matchesDataClassSyntheticMemberSignatures) || Intrinsics.areEqual($this$matchesDataClassSyntheticMemberSignatures.getName(), OperatorNameConventions.TO_STRING) && this.getMatchesToStringSignature($this$matchesDataClassSyntheticMemberSignatures);
        }

        @NotNull
        public final List<FirDeclaration> generate(@NotNull FirClass klass) {
            Map<Name, FirSimpleFunction> $this$mapNotNullTo$iv$iv;
            int n;
            Intrinsics.checkNotNullParameter(klass, "klass");
            IrConstructor irConstructor2 = IrUtilsKt.getPrimaryConstructor(this.irClass);
            if (irConstructor2 == null) {
                n = 0;
            } else {
                List<IrValueParameter> list2 = IrUtilsKt.getExplicitParameters(irConstructor2);
                n = list2.size();
            }
            int propertyParametersCount = n;
            List<IrProperty> properties2 = SequencesKt.toList(SequencesKt.take(SequencesKt.filter(IrUtilsKt.getProperties(this.irClass), generate.properties.1.INSTANCE), propertyParametersCount));
            if (properties2.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            List result2 = new ArrayList();
            Iterable $this$mapNotNull$iv = klass.getDeclarations();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Name[] $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Name name;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                FirDeclaration it = (FirDeclaration)element$iv$iv;
                boolean bl2 = false;
                Name name2 = it instanceof FirSimpleFunction && this.getMatchesDataClassSyntheticMemberSignatures((FirSimpleFunction)it) ? ((FirSimpleFunction)it).getName() : null;
                if (name2 == null) continue;
                Name it$iv$iv = name = name2;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List contributedFunctionsInThisType = (List)destination$iv$iv;
            FirTypeScope scope2 = FirKotlinScopeProviderKt.unsubstitutedScope(klass, DataClassMembersGenerator.this.getComponents().getSession(), DataClassMembersGenerator.this.getComponents().getScopeSession(), true);
            Map<Name, FirSimpleFunction> $this$generate_u24lambda_u2d1 = $this$mapNotNullTo$iv$iv = MapsKt.createMapBuilder();
            boolean bl = false;
            $this$forEach$iv$iv$iv = new Name[]{OperatorNameConventions.EQUALS, DefaultNamesKt.getHASHCODE_NAME(), OperatorNameConventions.TO_STRING};
            for (Name name : CollectionsKt.listOf($this$forEach$iv$iv$iv)) {
                if (contributedFunctionsInThisType.contains(name)) continue;
                scope2.processFunctionsByName(name, (Function1<? super FirNamedFunctionSymbol, Unit>)new Function1<FirNamedFunctionSymbol, Unit>(this, $this$generate_u24lambda_u2d1){
                    final /* synthetic */ MyDataClassMethodsGenerator this$0;
                    final /* synthetic */ Map<Name, FirSimpleFunction> $this_buildMap;
                    {
                        this.this$0 = $receiver;
                        this.$this_buildMap = $receiver2;
                        super(1);
                    }

                    public final void invoke(@NotNull FirNamedFunctionSymbol it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        FirSimpleFunction declaration2 = (FirSimpleFunction)it.getFir();
                        if (MyDataClassMethodsGenerator.access$getMatchesDataClassSyntheticMemberSignatures(this.this$0, declaration2)) {
                            FirMemberDeclaration $this$modality$iv = declaration2;
                            boolean $i$f$getModality = false;
                            if ($this$modality$iv.getStatus().getModality() != Modality.FINAL) {
                                this.$this_buildMap.putIfAbsent(declaration2.getName(), declaration2);
                            }
                        }
                    }
                });
            }
            Map contributedFunctionsInSupertypes2 = MapsKt.build($this$mapNotNullTo$iv$iv);
            if (contributedFunctionsInSupertypes2.containsKey(OperatorNameConventions.EQUALS)) {
                result2.add(MapsKt.getValue(contributedFunctionsInSupertypes2, OperatorNameConventions.EQUALS));
                IrFunction equalsFunction = this.createSyntheticIrFunction(OperatorNameConventions.EQUALS, DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getBooleanType(), true);
                this.irDataClassMembersGenerator.generateEqualsMethod(equalsFunction, properties2);
                this.irClass.getDeclarations().add(equalsFunction);
            }
            if (contributedFunctionsInSupertypes2.containsKey(DefaultNamesKt.getHASHCODE_NAME())) {
                result2.add(MapsKt.getValue(contributedFunctionsInSupertypes2, DefaultNamesKt.getHASHCODE_NAME()));
                IrFunction hashCodeFunction = MyDataClassMethodsGenerator.createSyntheticIrFunction$default(this, DefaultNamesKt.getHASHCODE_NAME(), DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getIntType(), false, 4, null);
                this.irDataClassMembersGenerator.generateHashCodeMethod(hashCodeFunction, properties2);
                this.irClass.getDeclarations().add(hashCodeFunction);
            }
            if (contributedFunctionsInSupertypes2.containsKey(OperatorNameConventions.TO_STRING)) {
                result2.add(MapsKt.getValue(contributedFunctionsInSupertypes2, OperatorNameConventions.TO_STRING));
                IrFunction toStringFunction = MyDataClassMethodsGenerator.createSyntheticIrFunction$default(this, OperatorNameConventions.TO_STRING, DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getStringType(), false, 4, null);
                this.irDataClassMembersGenerator.generateToStringMethod(toStringFunction, properties2);
                this.irClass.getDeclarations().add(toStringFunction);
            }
            return result2;
        }

        public final void generateComponentBody(@NotNull IrFunction irFunction2) {
            Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
            Integer n = Companion.getComponentIndex(irFunction2);
            Intrinsics.checkNotNull(n);
            int index2 = n;
            IrConstructor irConstructor2 = IrUtilsKt.getPrimaryConstructor(this.irClass);
            Intrinsics.checkNotNull(irConstructor2);
            IrValueParameter valueParameter2 = irConstructor2.getValueParameters().get(index2 - 1);
            IrProperty irProperty2 = this.irDataClassMembersGenerator.getProperty(null, valueParameter2);
            Intrinsics.checkNotNull(irProperty2);
            IrProperty irProperty3 = irProperty2;
            this.irDataClassMembersGenerator.generateComponentFunction(irFunction2, irProperty3);
        }

        public final void generateCopyBody(@NotNull IrFunction irFunction2) {
            Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
            IrConstructor irConstructor2 = IrUtilsKt.getPrimaryConstructor(this.irClass);
            Intrinsics.checkNotNull(irConstructor2);
            this.irDataClassMembersGenerator.generateCopyFunction(irFunction2, irConstructor2.getSymbol());
        }

        /*
         * WARNING - void declaration
         */
        private final IrFunction createSyntheticIrFunction(Name name, IrType returnType2, boolean otherParameterNeeded) {
            void $this$toTypedArray$iv;
            Collection<ConeStarProjection> collection;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            Object object;
            void $this$createSyntheticIrFunction_u24lambda_u2d4_u24lambda_u2d2;
            Object object2;
            FirTypeRef firTypeRef;
            DataClassMembersGenerator dataClassMembersGenerator = DataClassMembersGenerator.this;
            boolean $i$f$buildSimpleFunction = false;
            Object object3 = new FirSimpleFunctionBuilder();
            FirSimpleFunctionBuilder $this$createSyntheticIrFunction_u24lambda_u2d4 = object3;
            boolean bl = false;
            $this$createSyntheticIrFunction_u24lambda_u2d4.setOrigin(FirDeclarationOrigin.Synthetic.INSTANCE);
            $this$createSyntheticIrFunction_u24lambda_u2d4.setName(name);
            $this$createSyntheticIrFunction_u24lambda_u2d4.setSymbol(new FirNamedFunctionSymbol(new CallableId(this.getLookupTag().getClassId(), name)));
            $this$createSyntheticIrFunction_u24lambda_u2d4.setStatus(new FirDeclarationStatusImpl(Visibilities.Public.INSTANCE, Modality.FINAL));
            $this$createSyntheticIrFunction_u24lambda_u2d4.setModuleData(FirModuleDataKt.getModuleData(dataClassMembersGenerator.getComponents().getSession()));
            Object object4 = returnType2;
            if (Intrinsics.areEqual(object4, dataClassMembersGenerator.getComponents().getIrBuiltIns().getBooleanType())) {
                firTypeRef = new FirImplicitBooleanTypeRef(null);
            } else if (Intrinsics.areEqual(object4, dataClassMembersGenerator.getComponents().getIrBuiltIns().getIntType())) {
                firTypeRef = new FirImplicitIntTypeRef(null);
            } else if (Intrinsics.areEqual(object4, dataClassMembersGenerator.getComponents().getIrBuiltIns().getStringType())) {
                firTypeRef = new FirImplicitStringTypeRef(null);
            } else {
                throw new IllegalStateException(Intrinsics.stringPlus("Unexpected synthetic data class function return type: ", returnType2).toString());
            }
            $this$createSyntheticIrFunction_u24lambda_u2d4.setReturnTypeRef(firTypeRef);
            if (otherParameterNeeded) {
                FirValueParameterBuilder firValueParameterBuilder;
                boolean $i$f$buildValueParameter = false;
                FirValueParameterBuilder firValueParameterBuilder2 = firValueParameterBuilder = new FirValueParameterBuilder();
                object2 = $this$createSyntheticIrFunction_u24lambda_u2d4.getValueParameters();
                boolean bl2 = false;
                Name name2 = Name.identifier("other");
                Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"other\")");
                $this$createSyntheticIrFunction_u24lambda_u2d4_u24lambda_u2d2.setName(name2);
                $this$createSyntheticIrFunction_u24lambda_u2d4_u24lambda_u2d2.setOrigin(FirDeclarationOrigin.Synthetic.INSTANCE);
                $this$createSyntheticIrFunction_u24lambda_u2d4_u24lambda_u2d2.setModuleData(FirModuleDataKt.getModuleData(dataClassMembersGenerator.getComponents().getSession()));
                $this$createSyntheticIrFunction_u24lambda_u2d4_u24lambda_u2d2.setReturnTypeRef(new FirImplicitNullableAnyTypeRef(null));
                $this$createSyntheticIrFunction_u24lambda_u2d4_u24lambda_u2d2.setSymbol(new FirValueParameterSymbol($this$createSyntheticIrFunction_u24lambda_u2d4_u24lambda_u2d2.getName()));
                $this$createSyntheticIrFunction_u24lambda_u2d4_u24lambda_u2d2.setCrossinline(false);
                $this$createSyntheticIrFunction_u24lambda_u2d4_u24lambda_u2d2.setNoinline(false);
                $this$createSyntheticIrFunction_u24lambda_u2d4_u24lambda_u2d2.setVararg(false);
                object = Unit.INSTANCE;
                object2.add(firValueParameterBuilder.build());
            }
            Iterable $i$f$buildValueParameter = new IntRange(1, this.getIrClass().getTypeParameters().size());
            object = this.getLookupTag();
            object2 = $this$createSyntheticIrFunction_u24lambda_u2d4;
            boolean $i$f$map = false;
            $this$createSyntheticIrFunction_u24lambda_u2d4_u24lambda_u2d2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                collection = destination$iv$iv;
                boolean bl3 = false;
                ConeStarProjection coneStarProjection = ConeStarProjection.INSTANCE;
                collection.add(coneStarProjection);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = collection;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            ConeStarProjection[] coneStarProjectionArray = thisCollection$iv.toArray(new ConeStarProjection[0]);
            if (coneStarProjectionArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            ((FirSimpleFunctionBuilder)object2).setDispatchReceiverType(TypeConstructionUtilsKt.constructType$default((ConeClassifierLookupTag)object, coneStarProjectionArray, false, null, 4, null));
            FirSimpleFunction firFunction = ((FirSimpleFunctionBuilder)object3).build();
            IdSignature signature2 = this.lookupTag.getClassId().isLocal() ? null : Fir2IrSignatureComposer.DefaultImpls.composeSignature$default(DataClassMembersGenerator.this.getComponents().getSignatureComposer(), firFunction, null, 2, null);
            IrSimpleFunction irSimpleFunction = DataClassMembersGenerator.this.getComponents().getDeclarationStorage().declareIrSimpleFunction$fir2ir(signature2, null, (Function1<? super IrSimpleFunctionSymbol, ? extends IrSimpleFunction>)new Function1<IrSimpleFunctionSymbol, IrSimpleFunction>(DataClassMembersGenerator.this, this, name, returnType2, otherParameterNeeded, firFunction){
                final /* synthetic */ DataClassMembersGenerator this$0;
                final /* synthetic */ MyDataClassMethodsGenerator this$1;
                final /* synthetic */ Name $name;
                final /* synthetic */ IrType $returnType;
                final /* synthetic */ boolean $otherParameterNeeded;
                final /* synthetic */ FirSimpleFunction $firFunction;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.$name = $name;
                    this.$returnType = $returnType;
                    this.$otherParameterNeeded = $otherParameterNeeded;
                    this.$firFunction = $firFunction;
                    super(1);
                }

                @NotNull
                public final IrSimpleFunction invoke(@NotNull IrSimpleFunctionSymbol symbol2) {
                    Intrinsics.checkNotNullParameter(symbol2, "symbol");
                    IrFactory irFactory = this.this$0.getComponents().getIrFactory();
                    IrDeclarationOrigin irDeclarationOrigin = this.this$1.getOrigin();
                    Object object = DescriptorVisibilities.PUBLIC;
                    Intrinsics.checkNotNullExpressionValue(object, "PUBLIC");
                    object = IrFactory.DefaultImpls.createFunction$default(irFactory, -1, -1, irDeclarationOrigin, symbol2, this.$name, (DescriptorVisibility)object, Modality.OPEN, this.$returnType, false, false, false, false, false, false, false, false, null, 65536, null);
                    boolean bl = this.$otherParameterNeeded;
                    MyDataClassMethodsGenerator myDataClassMethodsGenerator = this.this$1;
                    FirSimpleFunction firSimpleFunction = this.$firFunction;
                    DataClassMembersGenerator dataClassMembersGenerator = this.this$0;
                    Object $this$invoke_u24lambda_u2d0 = object;
                    boolean bl2 = false;
                    if (bl) {
                        IrValueParameter irValueParameter = MyDataClassMethodsGenerator.createSyntheticIrParameter$default(myDataClassMethodsGenerator, (IrFunction)$this$invoke_u24lambda_u2d0, CollectionsKt.first(firSimpleFunction.getValueParameters()).getName(), dataClassMembersGenerator.getComponents().getIrBuiltIns().getAnyNType(), 0, 8, null);
                        ((IrFunction)$this$invoke_u24lambda_u2d0).setValueParameters(CollectionsKt.listOf(irValueParameter));
                    }
                    $this$invoke_u24lambda_u2d0.setMetadata(new FirMetadataSource.Function(firSimpleFunction));
                    return object;
                }
            });
            object3 = DataClassMembersGenerator.this;
            IrSimpleFunction $this$createSyntheticIrFunction_u24lambda_u2d6 = irSimpleFunction;
            boolean bl4 = false;
            $this$createSyntheticIrFunction_u24lambda_u2d6.setParent(this.getIrClass());
            $this$createSyntheticIrFunction_u24lambda_u2d6.setDispatchReceiverParameter(this.generateDispatchReceiverParameter($this$createSyntheticIrFunction_u24lambda_u2d6));
            object4 = CollectionsKt.singleOrNull(((DataClassMembersGenerator)object3).getComponents().getIrBuiltIns().findBuiltInClassMemberFunctions(((DataClassMembersGenerator)object3).getComponents().getIrBuiltIns().getAnyClass(), $this$createSyntheticIrFunction_u24lambda_u2d6.getName()));
            if (object4 != null) {
                Object object5;
                Object it = object5 = object4;
                boolean bl5 = false;
                $this$createSyntheticIrFunction_u24lambda_u2d6.setOverriddenSymbols(CollectionsKt.listOf(it));
            }
            return irSimpleFunction;
        }

        static /* synthetic */ IrFunction createSyntheticIrFunction$default(MyDataClassMethodsGenerator myDataClassMethodsGenerator, Name name, IrType irType, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return myDataClassMethodsGenerator.createSyntheticIrFunction(name, irType, bl);
        }

        private final IrValueParameter createSyntheticIrParameter(IrFunction irFunction2, Name name, IrType type2, int index2) {
            IrValueParameter irValueParameter;
            IrValueParameter $this$createSyntheticIrParameter_u24lambda_u2d7 = irValueParameter = DataClassMembersGenerator.this.getComponents().getIrFactory().createValueParameter(-1, -1, this.origin, new IrValueParameterSymbolImpl(null, 1, null), name, index2, type2, null, false, false, false, false);
            boolean bl = false;
            $this$createSyntheticIrParameter_u24lambda_u2d7.setParent(irFunction2);
            return irValueParameter;
        }

        static /* synthetic */ IrValueParameter createSyntheticIrParameter$default(MyDataClassMethodsGenerator myDataClassMethodsGenerator, IrFunction irFunction2, Name name, IrType irType, int n, int n2, Object object) {
            if ((n2 & 8) != 0) {
                n = 0;
            }
            return myDataClassMethodsGenerator.createSyntheticIrParameter(irFunction2, name, irType, n);
        }

        public static final /* synthetic */ boolean access$getMatchesDataClassSyntheticMemberSignatures(MyDataClassMethodsGenerator $this, FirSimpleFunction $receiver) {
            return $this.getMatchesDataClassSyntheticMemberSignatures($receiver);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator$Companion;", "", "()V", "getComponentIndex", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Ljava/lang/Integer;", "isComponentN", "", "isCopy", "fir2ir"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isCopy(@NotNull IrFunction irFunction2) {
            Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
            return Intrinsics.areEqual(irFunction2.getName(), DefaultNamesKt.getCOPY_NAME());
        }

        public final boolean isComponentN(@NotNull IrFunction irFunction2) {
            Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
            if (irFunction2.getName().isSpecial()) {
                return false;
            }
            String string2 = irFunction2.getName().getIdentifier();
            Intrinsics.checkNotNullExpressionValue(string2, "irFunction.name.identifier");
            String name = string2;
            if (!StringsKt.startsWith$default(name, "component", false, 2, null)) {
                return false;
            }
            Integer n = this.getComponentIndex(irFunction2);
            return n != null && n > 0;
        }

        @Nullable
        public final Integer getComponentIndex(@NotNull IrFunction irFunction2) {
            Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
            String string2 = irFunction2.getName().getIdentifier();
            Intrinsics.checkNotNullExpressionValue(string2, "irFunction.name.identifier");
            String string3 = string2.substring("component".length());
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).substring(startIndex)");
            return StringsKt.toIntOrNull(string3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

