/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsManglerIr;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTable;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrFunctionKt;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.naming.NameSuggestionKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\u001b\u0010\t\u001a\u00020\u0001\"\u0004\b\u0000\u0010\n2\u0006\u0010\u0005\u001a\u0002H\nH\u0002\u00a2\u0006\u0002\u0010\u000b\u001a\u000e\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001\u001a\u0010\u0010\u000e\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00100\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"RESERVED_MEMBER_NAME_SUFFIX", "", "SYNTHETIC_BLOCK_LABEL", "SYNTHETIC_LOOP_LABEL", "jsFunctionSignature", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "mapToKey", "T", "(Ljava/lang/Object;)Ljava/lang/String;", "sanitizeName", "name", "dump", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "backend.js"})
public final class NameTablesKt {
    /*
     * WARNING - void declaration
     */
    private static final <T> String mapToKey(T declaration2) {
        String string2;
        JsManglerIr jsManglerIr;
        JsManglerIr $this$mapToKey_u24lambda_u2d1 = jsManglerIr = JsManglerIr.INSTANCE;
        boolean bl = false;
        if (declaration2 instanceof IrDeclaration) {
            string2 = String.valueOf($this$mapToKey_u24lambda_u2d1.hashedMangle(declaration2, false));
        } else if (declaration2 instanceof String) {
            string2 = String.valueOf($this$mapToKey_u24lambda_u2d1.getHashMangle((String)declaration2));
        } else {
            String string3;
            String string4 = "Key is not generated for ";
            T t = declaration2;
            if (t == null) {
                string3 = null;
            } else {
                void it;
                T t2;
                T t3 = t2 = t;
                String string5 = string4;
                boolean bl2 = false;
                String string6 = Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName();
                string4 = string5;
                string3 = string6;
            }
            String string7 = Intrinsics.stringPlus(string4, string3).toString();
            throw new IllegalStateException(string7);
        }
        return string2;
    }

    @NotNull
    public static final String dump(@NotNull NameTable<IrDeclaration> $this$dump) {
        Intrinsics.checkNotNullParameter($this$dump, "<this>");
        return Intrinsics.stringPlus("Names: \n", CollectionsKt.joinToString$default(MapsKt.toList($this$dump.getNames()), "\n", null, null, 0, null, dump.1.INSTANCE, 30, null));
    }

    @NotNull
    public static final String jsFunctionSignature(@NotNull IrFunction declaration2, @Nullable JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        if (!(!IrFunctionKt.isStaticMethodOfClass(declaration2))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!(declaration2.getDispatchReceiverParameter() != null)) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        String string4 = AnnotationUtilsKt.getJsNameOrKotlinName(declaration2).asString();
        Intrinsics.checkNotNullExpressionValue(string4, "declaration.getJsNameOrKotlinName().asString()");
        String declarationName = string4;
        if (MiscKt.hasStableJsName(declaration2, context2)) {
            boolean bl;
            boolean bl2 = bl = !StringsKt.endsWith$default(declarationName, "_k$", false, 2, null);
            if (!bl) {
                boolean $i$a$-require-NameTablesKt$jsFunctionSignature$22 = false;
                String $i$a$-require-NameTablesKt$jsFunctionSignature$22 = "Function " + IrUtilsKt.getFqNameWhenAvailable(declaration2) + " uses reserved name suffix \"_k$\"";
                throw new IllegalArgumentException($i$a$-require-NameTablesKt$jsFunctionSignature$22.toString());
            }
            return declarationName;
        }
        StringBuilder nameBuilder = new StringBuilder();
        Object $this$ifNotEmpty$iv = declaration2.getTypeParameters();
        boolean $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$jsFunctionSignature_u24lambda_u2d3 = (List)$this$ifNotEmpty$iv;
            boolean bl = false;
            nameBuilder.append("_$t");
            StringBuilder cfr_ignored_0 = (StringBuilder)CollectionsKt.joinTo$default($this$jsFunctionSignature_u24lambda_u2d3, nameBuilder, "", null, null, 0, null, jsFunctionSignature.2.1.INSTANCE, 60, null);
        }
        if (($this$ifNotEmpty$iv = declaration2.getExtensionReceiverParameter()) != null) {
            Object it = $i$f$ifNotEmpty = $this$ifNotEmpty$iv;
            boolean bl = false;
            nameBuilder.append(Intrinsics.stringPlus("_r$", IrTypeUtilsKt.asString(((IrValueDeclaration)it).getType())));
        }
        $this$ifNotEmpty$iv = declaration2.getValueParameters();
        $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$jsFunctionSignature_u24lambda_u2d5 = (List)$this$ifNotEmpty$iv;
            boolean bl = false;
            StringBuilder cfr_ignored_1 = (StringBuilder)CollectionsKt.joinTo$default($this$jsFunctionSignature_u24lambda_u2d5, nameBuilder, "", null, null, 0, null, jsFunctionSignature.4.1.INSTANCE, 60, null);
        }
        Object it = $this$ifNotEmpty$iv = declaration2.getReturnType();
        boolean bl = false;
        if (IrTypeUtilsKt.getJsInlinedClass((IrType)it) != null || IrTypePredicatesKt.isUnit((IrType)it)) {
            nameBuilder.append(Intrinsics.stringPlus("_ret$", IrTypeUtilsKt.asString((IrType)it)));
        }
        String string5 = nameBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string5, "nameBuilder.toString()");
        String signature2 = string5;
        StringBuilder stringBuilder2 = new StringBuilder().append(NameTablesKt.sanitizeName(declarationName)).append('_');
        String string6 = Integer.toString(Math.abs(signature2.hashCode()), CharsKt.checkRadix(36));
        Intrinsics.checkNotNullExpressionValue(string6, "toString(this, checkRadix(radix))");
        return stringBuilder2.append(string6).append("_k$").toString();
    }

    @NotNull
    public static final String sanitizeName(@NotNull String name) {
        int n;
        Intrinsics.checkNotNullParameter(name, "name");
        if (NameSuggestionKt.isValidES5Identifier(name)) {
            return name;
        }
        if (((CharSequence)name).length() == 0) {
            return "_";
        }
        StringBuilder builder2 = new StringBuilder();
        int it = n = StringsKt.first(name);
        boolean bl = false;
        int first = NameSuggestionKt.isES5IdentifierStart((char)it) ? it : 95;
        builder2.append((char)first);
        n = 1;
        int n2 = StringsKt.getLastIndex(name);
        if (n <= n2) {
            int idx;
            do {
                char c;
                builder2.append(NameSuggestionKt.isES5IdentifierPart(c = name.charAt(idx = n++)) ? c : (char)'_');
            } while (idx != n2);
        }
        String string2 = builder2.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "builder.toString()");
        return string2;
    }

    public static final /* synthetic */ String access$mapToKey(Object declaration2) {
        return NameTablesKt.mapToKey(declaration2);
    }
}

