
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include <qapp_macro.h>

QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "searchenginesmanager_wrapper.h"

// inner classes
#include "searchenginesmanager_engine_wrapper.h"

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void SearchEnginesManagerWrapper::pysideInitQtMetaTypes()
{
}

void SearchEnginesManagerWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

SearchEnginesManagerWrapper::SearchEnginesManagerWrapper(QObject * parent) : SearchEnginesManager(parent)
{
    resetPyMethodCache();
    // ... middle
}

void SearchEnginesManagerWrapper::childEvent(QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void SearchEnginesManagerWrapper::connectNotify(const QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void SearchEnginesManagerWrapper::customEvent(QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void SearchEnginesManagerWrapper::disconnectNotify(const QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool SearchEnginesManagerWrapper::event(QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "SearchEnginesManager.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool SearchEnginesManagerWrapper::eventFilter(QObject * watched, QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "SearchEnginesManager.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void SearchEnginesManagerWrapper::timerEvent(QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *SearchEnginesManagerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return SearchEnginesManager::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int SearchEnginesManagerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = SearchEnginesManager::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *SearchEnginesManagerWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< SearchEnginesManagerWrapper *>(this));
        return SearchEnginesManager::qt_metacast(_clname);
}

SearchEnginesManagerWrapper::~SearchEnginesManagerWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_SearchEnginesManager_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const char *argNames[] = {"parent"};
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::SearchEnginesManager >()))
        return -1;

    ::SearchEnginesManagerWrapper *cptr{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:SearchEnginesManager", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: SearchEnginesManager::SearchEnginesManager(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // SearchEnginesManager(QObject*)
    } else if ((pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // SearchEnginesManager(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_SearchEnginesManager_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *keyName = nullptr;
            PyObject *value = nullptr;
            keyName = Py_BuildValue("s","parent");
            if (PyDict_Contains(kwds, keyName)) {
                value = PyDict_GetItem(kwds, keyName);
                if (value && pyArgs[0]) {
                    PyErr_SetString(PyExc_TypeError, "PyFalkon.SearchEnginesManager(): got multiple values for keyword argument 'parent'.");
                    return -1;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_SearchEnginesManager_Init_TypeError;
                }
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // SearchEnginesManager(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::SearchEnginesManagerWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::SearchEnginesManagerWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::SearchEnginesManager >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto Sbk_SearchEnginesManager_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (kwds && !PySide::fillQtProperties(self, metaObject, kwds, argNames, 1))
        return -1;


    return 1;

    Sbk_SearchEnginesManager_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.SearchEnginesManager");
        return -1;
}

static PyObject *Sbk_SearchEnginesManagerFunc_activeEngine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // activeEngine()const
            SearchEnginesManager::Engine cppResult = const_cast<const ::SearchEnginesManagerWrapper *>(cppSelf)->activeEngine();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_SearchEnginesManagerFunc_addEngine(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SearchEnginesManager::addEngine(QUrl)
    // 1: SearchEnginesManager::addEngine(SearchEnginesManager::Engine)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), (pyArg)))) {
        overloadId = 1; // addEngine(SearchEnginesManager::Engine)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // addEngine(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_SearchEnginesManagerFunc_addEngine_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // addEngine(const QUrl & url)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // addEngine(QUrl)
                cppSelf->addEngine(*cppArg0);
            }
            break;
        }
        case 1: // addEngine(const SearchEnginesManager::Engine & engine)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::SearchEnginesManager::Engine cppArg0_local;
            ::SearchEnginesManager::Engine *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // addEngine(SearchEnginesManager::Engine)
                cppSelf->addEngine(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_SearchEnginesManagerFunc_addEngine_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.SearchEnginesManager.addEngine");
        return {};
}

static PyObject *Sbk_SearchEnginesManagerFunc_addEngineFromForm(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addEngineFromForm", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: SearchEnginesManager::addEngineFromForm(QMap<QString,QVariant>,WebView*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPyFalkonTypeConverters[SBK_PYFALKON_QMAP_QSTRING_QVARIANT_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_WEBVIEW_IDX]), (pyArgs[1])))) {
        overloadId = 0; // addEngineFromForm(QMap<QString,QVariant>,WebView*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_SearchEnginesManagerFunc_addEngineFromForm_TypeError;

    // Call function/method
    {
        ::QMap<QString,QVariant > cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::WebView *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // addEngineFromForm(QMap<QString,QVariant>,WebView*)
            cppSelf->addEngineFromForm(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_SearchEnginesManagerFunc_addEngineFromForm_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.SearchEnginesManager.addEngineFromForm");
        return {};
}

static PyObject *Sbk_SearchEnginesManagerFunc_allEngines(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // allEngines()
            QVector<SearchEnginesManager::Engine > cppResult = cppSelf->allEngines();
            pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_SEARCHENGINESMANAGER_ENGINE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_SearchEnginesManagerFunc_defaultEngine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultEngine()const
            SearchEnginesManager::Engine cppResult = const_cast<const ::SearchEnginesManagerWrapper *>(cppSelf)->defaultEngine();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_SearchEnginesManagerFunc_editEngine(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "editEngine", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: SearchEnginesManager::editEngine(SearchEnginesManager::Engine,SearchEnginesManager::Engine)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // editEngine(SearchEnginesManager::Engine,SearchEnginesManager::Engine)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_SearchEnginesManagerFunc_editEngine_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::SearchEnginesManager::Engine cppArg0_local;
        ::SearchEnginesManager::Engine *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::SearchEnginesManager::Engine cppArg1_local;
        ::SearchEnginesManager::Engine *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // editEngine(SearchEnginesManager::Engine,SearchEnginesManager::Engine)
            cppSelf->editEngine(*cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_SearchEnginesManagerFunc_editEngine_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.SearchEnginesManager.editEngine");
        return {};
}

static PyObject *Sbk_SearchEnginesManagerFunc_engineForShortcut(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SearchEnginesManager::engineForShortcut(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // engineForShortcut(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_SearchEnginesManagerFunc_engineForShortcut_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // engineForShortcut(QString)
            SearchEnginesManager::Engine cppResult = cppSelf->engineForShortcut(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_SearchEnginesManagerFunc_engineForShortcut_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.SearchEnginesManager.engineForShortcut");
        return {};
}

static PyObject *Sbk_SearchEnginesManagerFunc_iconForSearchEngine(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static SearchEnginesManager::iconForSearchEngine(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // iconForSearchEngine(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_SearchEnginesManagerFunc_iconForSearchEngine_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // iconForSearchEngine(QUrl)
            QIcon cppResult = ::SearchEnginesManager::iconForSearchEngine(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_SearchEnginesManagerFunc_iconForSearchEngine_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.SearchEnginesManager.iconForSearchEngine");
        return {};
}

static PyObject *Sbk_SearchEnginesManagerFunc_removeEngine(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SearchEnginesManager::removeEngine(SearchEnginesManager::Engine)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), (pyArg)))) {
        overloadId = 0; // removeEngine(SearchEnginesManager::Engine)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_SearchEnginesManagerFunc_removeEngine_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::SearchEnginesManager::Engine cppArg0_local;
        ::SearchEnginesManager::Engine *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // removeEngine(SearchEnginesManager::Engine)
            cppSelf->removeEngine(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_SearchEnginesManagerFunc_removeEngine_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.SearchEnginesManager.removeEngine");
        return {};
}

static PyObject *Sbk_SearchEnginesManagerFunc_restoreDefaults(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // restoreDefaults()
            cppSelf->restoreDefaults();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_SearchEnginesManagerFunc_saveSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // saveSettings()
            cppSelf->saveSettings();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_SearchEnginesManagerFunc_searchResult(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "searchResult", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: SearchEnginesManager::searchResult(QString)
    // 1: SearchEnginesManager::searchResult(SearchEnginesManager::Engine,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 1; // searchResult(SearchEnginesManager::Engine,QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 0; // searchResult(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_SearchEnginesManagerFunc_searchResult_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // searchResult(const QString & string)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // searchResult(QString)
                LoadRequest cppResult = cppSelf->searchResult(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_LOADREQUEST_IDX]), &cppResult);
            }
            break;
        }
        case 1: // searchResult(const SearchEnginesManager::Engine & engine, const QString & string)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::SearchEnginesManager::Engine cppArg0_local;
            ::SearchEnginesManager::Engine *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // searchResult(SearchEnginesManager::Engine,QString)
                LoadRequest cppResult = cppSelf->searchResult(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_LOADREQUEST_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_SearchEnginesManagerFunc_searchResult_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.SearchEnginesManager.searchResult");
        return {};
}

static PyObject *Sbk_SearchEnginesManagerFunc_setActiveEngine(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SearchEnginesManager::setActiveEngine(SearchEnginesManager::Engine)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), (pyArg)))) {
        overloadId = 0; // setActiveEngine(SearchEnginesManager::Engine)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_SearchEnginesManagerFunc_setActiveEngine_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::SearchEnginesManager::Engine cppArg0_local;
        ::SearchEnginesManager::Engine *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setActiveEngine(SearchEnginesManager::Engine)
            cppSelf->setActiveEngine(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_SearchEnginesManagerFunc_setActiveEngine_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.SearchEnginesManager.setActiveEngine");
        return {};
}

static PyObject *Sbk_SearchEnginesManagerFunc_setAllEngines(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SearchEnginesManager::setAllEngines(QVector<SearchEnginesManager::Engine>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_SEARCHENGINESMANAGER_ENGINE_IDX], (pyArg)))) {
        overloadId = 0; // setAllEngines(QVector<SearchEnginesManager::Engine>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_SearchEnginesManagerFunc_setAllEngines_TypeError;

    // Call function/method
    {
        ::QVector<SearchEnginesManager::Engine > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAllEngines(QVector<SearchEnginesManager::Engine>)
            cppSelf->setAllEngines(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_SearchEnginesManagerFunc_setAllEngines_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.SearchEnginesManager.setAllEngines");
        return {};
}

static PyObject *Sbk_SearchEnginesManagerFunc_setDefaultEngine(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SearchEnginesManager::setDefaultEngine(SearchEnginesManager::Engine)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), (pyArg)))) {
        overloadId = 0; // setDefaultEngine(SearchEnginesManager::Engine)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_SearchEnginesManagerFunc_setDefaultEngine_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::SearchEnginesManager::Engine cppArg0_local;
        ::SearchEnginesManager::Engine *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setDefaultEngine(SearchEnginesManager::Engine)
            cppSelf->setDefaultEngine(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_SearchEnginesManagerFunc_setDefaultEngine_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.SearchEnginesManager.setDefaultEngine");
        return {};
}

static PyObject *Sbk_SearchEnginesManagerFunc_startingEngineName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<SearchEnginesManagerWrapper *>(reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // startingEngineName()
            QString cppResult = cppSelf->startingEngineName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_SearchEnginesManager_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_SearchEnginesManager_methods[] = {
    {"activeEngine", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_activeEngine), METH_NOARGS},
    {"addEngine", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_addEngine), METH_O},
    {"addEngineFromForm", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_addEngineFromForm), METH_VARARGS},
    {"allEngines", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_allEngines), METH_NOARGS},
    {"defaultEngine", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_defaultEngine), METH_NOARGS},
    {"editEngine", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_editEngine), METH_VARARGS},
    {"engineForShortcut", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_engineForShortcut), METH_O},
    {"iconForSearchEngine", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_iconForSearchEngine), METH_O|METH_STATIC},
    {"removeEngine", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_removeEngine), METH_O},
    {"restoreDefaults", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_restoreDefaults), METH_NOARGS},
    {"saveSettings", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_saveSettings), METH_NOARGS},
    {"searchResult", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_searchResult), METH_VARARGS},
    {"setActiveEngine", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_setActiveEngine), METH_O},
    {"setAllEngines", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_setAllEngines), METH_O},
    {"setDefaultEngine", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_setDefaultEngine), METH_O},
    {"startingEngineName", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManagerFunc_startingEngineName), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_SearchEnginesManager_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::SearchEnginesManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<SearchEnginesManagerWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_SearchEnginesManager_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_SearchEnginesManager_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_SearchEnginesManager_Type = nullptr;
static SbkObjectType *Sbk_SearchEnginesManager_TypeF(void)
{
    return _Sbk_SearchEnginesManager_Type;
}

static PyType_Slot Sbk_SearchEnginesManager_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_SearchEnginesManager_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_SearchEnginesManager_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_SearchEnginesManager_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_SearchEnginesManager_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_SearchEnginesManager_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_SearchEnginesManager_spec = {
    "1:PyFalkon.SearchEnginesManager",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_SearchEnginesManager_slots
};

} //extern "C"

static void *Sbk_SearchEnginesManager_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::SearchEnginesManager *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void SearchEnginesManager_PythonToCpp_SearchEnginesManager_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_SearchEnginesManager_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_SearchEnginesManager_PythonToCpp_SearchEnginesManager_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_SearchEnginesManager_TypeF())))
        return SearchEnginesManager_PythonToCpp_SearchEnginesManager_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *SearchEnginesManager_PTR_CppToPython_SearchEnginesManager(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::SearchEnginesManager *>(const_cast<void *>(cppIn)), Sbk_SearchEnginesManager_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *SearchEnginesManager_SignatureStrings[] = {
    "PyFalkon.SearchEnginesManager(self,parent:PySide2.QtCore.QObject=0)",
    "PyFalkon.SearchEnginesManager.activeEngine(self)->PyFalkon.SearchEnginesManager.Engine",
    "1:PyFalkon.SearchEnginesManager.addEngine(self,url:PySide2.QtCore.QUrl)",
    "0:PyFalkon.SearchEnginesManager.addEngine(self,engine:PyFalkon.SearchEnginesManager.Engine)",
    "PyFalkon.SearchEnginesManager.addEngineFromForm(self,formData:QMap[QString, QVariant],view:PyFalkon.WebView)",
    "PyFalkon.SearchEnginesManager.allEngines(self)->QVector[PyFalkon.SearchEnginesManager.Engine]",
    "PyFalkon.SearchEnginesManager.defaultEngine(self)->PyFalkon.SearchEnginesManager.Engine",
    "PyFalkon.SearchEnginesManager.editEngine(self,before:PyFalkon.SearchEnginesManager.Engine,after:PyFalkon.SearchEnginesManager.Engine)",
    "PyFalkon.SearchEnginesManager.engineForShortcut(self,shortcut:QString)->PyFalkon.SearchEnginesManager.Engine",
    "PyFalkon.SearchEnginesManager.iconForSearchEngine(url:PySide2.QtCore.QUrl)->PySide2.QtGui.QIcon",
    "PyFalkon.SearchEnginesManager.removeEngine(self,engine:PyFalkon.SearchEnginesManager.Engine)",
    "PyFalkon.SearchEnginesManager.restoreDefaults(self)",
    "PyFalkon.SearchEnginesManager.saveSettings(self)",
    "1:PyFalkon.SearchEnginesManager.searchResult(self,string:QString)->PyFalkon.LoadRequest",
    "0:PyFalkon.SearchEnginesManager.searchResult(self,engine:PyFalkon.SearchEnginesManager.Engine,string:QString)->PyFalkon.LoadRequest",
    "PyFalkon.SearchEnginesManager.setActiveEngine(self,engine:PyFalkon.SearchEnginesManager.Engine)",
    "PyFalkon.SearchEnginesManager.setAllEngines(self,engines:QVector[PyFalkon.SearchEnginesManager.Engine])",
    "PyFalkon.SearchEnginesManager.setDefaultEngine(self,engine:PyFalkon.SearchEnginesManager.Engine)",
    "PyFalkon.SearchEnginesManager.startingEngineName(self)->QString",
    nullptr}; // Sentinel

void init_SearchEnginesManager(PyObject *module)
{
    _Sbk_SearchEnginesManager_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "SearchEnginesManager",
        "SearchEnginesManager*",
        &Sbk_SearchEnginesManager_spec,
        &Shiboken::callCppDestructor< ::SearchEnginesManager >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_SearchEnginesManager_Type);
    InitSignatureStrings(pyType, SearchEnginesManager_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_SearchEnginesManager_Type), Sbk_SearchEnginesManager_PropertyStrings);
    SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_SearchEnginesManager_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_SearchEnginesManager_TypeF(),
        SearchEnginesManager_PythonToCpp_SearchEnginesManager_PTR,
        is_SearchEnginesManager_PythonToCpp_SearchEnginesManager_PTR_Convertible,
        SearchEnginesManager_PTR_CppToPython_SearchEnginesManager);

    Shiboken::Conversions::registerConverterName(converter, "SearchEnginesManager");
    Shiboken::Conversions::registerConverterName(converter, "SearchEnginesManager*");
    Shiboken::Conversions::registerConverterName(converter, "SearchEnginesManager&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::SearchEnginesManager).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::SearchEnginesManagerWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_SearchEnginesManager_TypeF(), &Sbk_SearchEnginesManager_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_SearchEnginesManager_TypeF(), &::SearchEnginesManager::staticMetaObject);

    SearchEnginesManagerWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_SearchEnginesManager_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_SearchEnginesManager_TypeF(), &::SearchEnginesManager::staticMetaObject, sizeof(SearchEnginesManagerWrapper));
}
