/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.Cons;
import clojure.lang.Counted;
import clojure.lang.IHashEq;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.Murmur3;
import clojure.lang.Obj;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.SeqIterator;
import clojure.lang.Sequential;
import clojure.lang.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class ASeq
extends Obj
implements ISeq,
Sequential,
List,
Serializable,
IHashEq {
    transient int _hash;
    transient int _hasheq;

    public String toString() {
        return RT.printString(this);
    }

    @Override
    public IPersistentCollection empty() {
        return PersistentList.EMPTY;
    }

    protected ASeq(IPersistentMap meta) {
        super(meta);
    }

    protected ASeq() {
    }

    @Override
    public boolean equiv(Object obj) {
        if (!(obj instanceof Sequential) && !(obj instanceof List)) {
            return false;
        }
        ISeq ms = RT.seq(obj);
        ISeq s2 = this.seq();
        while (s2 != null) {
            if (ms == null || !Util.equiv(s2.first(), ms.first())) {
                return false;
            }
            s2 = s2.next();
            ms = ms.next();
        }
        return ms == null;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Sequential) && !(obj instanceof List)) {
            return false;
        }
        ISeq ms = RT.seq(obj);
        ISeq s2 = this.seq();
        while (s2 != null) {
            if (ms == null || !Util.equals(s2.first(), ms.first())) {
                return false;
            }
            s2 = s2.next();
            ms = ms.next();
        }
        return ms == null;
    }

    @Override
    public int hashCode() {
        if (this._hash == 0) {
            int hash2 = 1;
            for (ISeq s2 = this.seq(); s2 != null; s2 = s2.next()) {
                hash2 = 31 * hash2 + (s2.first() == null ? 0 : s2.first().hashCode());
            }
            this._hash = hash2;
        }
        return this._hash;
    }

    @Override
    public int hasheq() {
        if (this._hasheq == 0) {
            this._hasheq = Murmur3.hashOrdered(this);
        }
        return this._hasheq;
    }

    @Override
    public int count() {
        int i = 1;
        ISeq s2 = this.next();
        while (s2 != null) {
            if (s2 instanceof Counted) {
                return i + s2.count();
            }
            s2 = s2.next();
            ++i;
        }
        return i;
    }

    @Override
    public final ISeq seq() {
        return this;
    }

    @Override
    public ISeq cons(Object o) {
        return new Cons(o, this);
    }

    @Override
    public ISeq more() {
        ISeq s2 = this.next();
        if (s2 == null) {
            return PersistentList.EMPTY;
        }
        return s2;
    }

    @Override
    public Object[] toArray() {
        return RT.seqToArray(this.seq());
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object[] toArray(Object[] a) {
        return RT.seqToPassedArray(this.seq(), a);
    }

    @Override
    public int size() {
        return this.count();
    }

    @Override
    public boolean isEmpty() {
        return this.seq() == null;
    }

    @Override
    public boolean contains(Object o) {
        for (ISeq s2 = this.seq(); s2 != null; s2 = s2.next()) {
            if (!Util.equiv(s2.first(), o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator iterator() {
        return new SeqIterator(this);
    }

    private List reify() {
        return Collections.unmodifiableList(new ArrayList(this));
    }

    public List subList(int fromIndex, int toIndex) {
        return this.reify().subList(fromIndex, toIndex);
    }

    public Object set(int index2, Object element2) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int index2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        ISeq s2 = this.seq();
        int i = 0;
        while (s2 != null) {
            if (Util.equiv(s2.first(), o)) {
                return i;
            }
            s2 = s2.next();
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.reify().lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.reify().listIterator();
    }

    public ListIterator listIterator(int index2) {
        return this.reify().listIterator(index2);
    }

    public Object get(int index2) {
        return RT.nth(this, index2);
    }

    public void add(int index2, Object element2) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index2, Collection c) {
        throw new UnsupportedOperationException();
    }
}

