/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import javajs.util.PT;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class PWmatReader
extends AtomSetCollectionReader {
    private int nAtoms;

    @Override
    protected void initializeReader() throws Exception {
        this.doApplySymmetry = true;
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.nAtoms == 0) {
            this.setSpaceGroupName("P1");
            this.nAtoms = PT.parseInt(this.line);
            this.setFractionalCoordinates(true);
            return true;
        }
        String lc = this.line.toLowerCase();
        if (lc.startsWith("lattice")) {
            this.readUnitCell();
        } else if (lc.startsWith("position")) {
            this.readCoordinates();
        } else {
            this.continuing = false;
        }
        return true;
    }

    private void readUnitCell() throws Exception {
        float[] unitCellData = new float[9];
        this.fillFloatArray(null, 0, unitCellData);
        this.addExplicitLatticeVector(0, unitCellData, 0);
        this.addExplicitLatticeVector(1, unitCellData, 3);
        this.addExplicitLatticeVector(2, unitCellData, 6);
    }

    private void readCoordinates() throws Exception {
        int i = 0;
        while (this.rd() != null && i++ < this.nAtoms) {
            String[] tokens = this.getTokens();
            this.addAtomXYZSymName(tokens, 1, null, PWmatReader.getElementSymbol(Integer.parseInt(tokens[0])));
        }
    }
}

