/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelkit;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.SymmetryInterface;
import org.jmol.i18n.GT;
import org.jmol.modelkit.ModelKitPopup;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.MeasurementPending;
import org.jmol.modelset.ModelSet;
import org.jmol.script.SV;
import org.jmol.script.ScriptEval;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;
import org.jmol.viewer.MouseState;
import org.jmol.viewer.Viewer;

public class ModelKit {
    private Viewer vwr;
    private ModelKitPopup menu;
    public static final String MODE_OPTIONS = ";view;edit;molecular;";
    public static final String SYMMETRY_OPTIONS = ";none;applylocal;retainlocal;applyfull;";
    public static final String UNITCELL_OPTIONS = ";packed;extend;";
    public static final String BOOLEAN_OPTIONS = ";autobond;hidden;showsymopinfo;clicktosetelement;addhydrogen;addhydrogens;";
    public static final String SET_OPTIONS = ";element;";
    static final int STATE_BITS_XTAL = 3;
    static final int STATE_MOLECULAR = 0;
    static final int STATE_XTALVIEW = 1;
    static final int STATE_XTALEDIT = 2;
    static final int STATE_BITS_SYM_VIEW = 28;
    static final int STATE_SYM_NONE = 0;
    static final int STATE_SYM_SHOW = 8;
    static final int STATE_BITS_SYM_EDIT = 224;
    static final int STATE_SYM_APPLYLOCAL = 32;
    static final int STATE_SYM_RETAINLOCAL = 64;
    static final int STATE_SYM_APPLYFULL = 128;
    static final int STATE_BITS_UNITCELL = 1792;
    static final int STATE_UNITCELL_PACKED = 0;
    static final int STATE_UNITCELL_EXTEND = 256;
    private static final P3 Pt000 = new P3();
    int state = 0;
    float rotationDeg;
    String atomHoverLabel = "C";
    String bondHoverLabel = GT.$("increase order");
    String xtalHoverLabel;
    boolean hasUnitCell;
    String[] allOperators;
    int currentModelIndex = -1;
    boolean alertedNoEdit;
    protected ModelSet lastModelSet;
    String pickAtomAssignType = "C";
    String lastElementType = "C";
    char pickBondAssignType = (char)112;
    boolean isPickAtomAssignCharge;
    BS bsHighlight = new BS();
    int bondIndex = -1;
    int bondAtomIndex1 = -1;
    int bondAtomIndex2 = -1;
    BS bsRotateBranch;
    int branchAtomIndex;
    boolean isRotateBond;
    int[] screenXY = new int[2];
    boolean showSymopInfo = true;
    boolean addXtalHydrogens = true;
    boolean clickToSetElement = true;
    boolean autoBond = false;
    P3 centerPoint;
    P3 spherePoint;
    P3 viewOffset;
    float centerDistance;
    Object symop;
    int centerAtomIndex = -1;
    int secondAtomIndex = -1;
    int atomIndexSphere = -1;
    String drawData;
    String drawScript;
    int iatom0;
    String bondRotationName = ".modelkitMenu.bondMenu.rotateBondP!RD";
    String lastCenter = "0 0 0";
    String lastOffset = "0 0 0";
    private Atom a0;
    private Atom a3;

    public void setMenu(ModelKitPopup menu) {
        this.menu = menu;
        this.vwr = menu.vwr;
        menu.modelkit = this;
        this.initializeForModel();
    }

    public void initializeForModel() {
        this.resetBondFields();
        this.allOperators = null;
        this.currentModelIndex = -999;
        this.iatom0 = 0;
        this.secondAtomIndex = -1;
        this.centerAtomIndex = -1;
        this.atomIndexSphere = -1;
        this.spherePoint = null;
        this.centerPoint = null;
        this.symop = null;
        this.setDefaultState(this.setHasUnitCell() ? 1 : 0);
    }

    public void showMenu(int x, int y) {
        this.menu.jpiShow(x, y);
    }

    public String getDefaultModel() {
        return this.addXtalHydrogens ? "5\n\nC 0 0 0\nH .63 .63 .63\nH -.63 -.63 .63\nH -.63 .63 -.63\nH .63 -.63 -.63" : "1\n\nC 0 0 0\n";
    }

    public void updateMenu() {
        this.menu.jpiUpdateComputedMenus();
    }

    public void dispose() {
        this.menu.jpiDispose();
        this.menu.modelkit = null;
        this.menu = null;
        this.vwr = null;
    }

    public boolean isPickAtomAssignCharge() {
        return this.isPickAtomAssignCharge;
    }

    public boolean isHidden() {
        return this.menu.hidden;
    }

    public String getActiveMenu() {
        return this.menu.activeMenu;
    }

    public int getRotateBondIndex() {
        return this.getMKState() == 0 && this.isRotateBond ? this.bondIndex : -1;
    }

    public Object getProperty(String name) {
        if ((name = name.toLowerCase().intern()) == "ismolecular") {
            return this.getMKState() == 0;
        }
        if (name == "alloperators") {
            return this.allOperators;
        }
        if (name == "data") {
            return this.getinfo();
        }
        return this.setProperty(name, null);
    }

    public synchronized Object setProperty(String name, Object value) {
        try {
            name = name.toLowerCase().intern();
            if (name == "reset") {
                return null;
            }
            if (name == "addhydrogen" || name == "addhydrogens") {
                if (value != null) {
                    this.addXtalHydrogens = ModelKit.isTrue(value);
                }
                return this.addXtalHydrogens;
            }
            if (name == "autobond") {
                if (value != null) {
                    this.autoBond = ModelKit.isTrue(value);
                }
                return this.autoBond;
            }
            if (name == "clicktosetelement") {
                if (value != null) {
                    this.clickToSetElement = ModelKit.isTrue(value);
                }
                return this.clickToSetElement;
            }
            if (name == "hidden") {
                if (value != null) {
                    this.menu.hidden = ModelKit.isTrue(value);
                }
                return this.menu.hidden;
            }
            if (name == "showsymopinfo") {
                if (value != null) {
                    this.showSymopInfo = ModelKit.isTrue(value);
                }
                return this.showSymopInfo;
            }
            if (name == "symop") {
                this.setDefaultState(1);
                if (value != null) {
                    this.symop = value;
                    this.showSymop(this.symop);
                }
                return this.symop;
            }
            if (name == "atomtype") {
                if (value != null) {
                    this.pickAtomAssignType = (String)value;
                    boolean bl = this.isPickAtomAssignCharge = this.pickAtomAssignType.equals("pl") || this.pickAtomAssignType.equals("mi");
                    if (!this.isPickAtomAssignCharge && !"X".equals(this.pickAtomAssignType)) {
                        this.lastElementType = this.pickAtomAssignType;
                    }
                }
                return this.pickAtomAssignType;
            }
            if (name == "bondtype") {
                if (value != null) {
                    String s = ((String)value).substring(0, 1).toLowerCase();
                    if (" 012345pm".indexOf(s) > 0) {
                        this.pickBondAssignType = s.charAt(0);
                    }
                    this.isRotateBond = false;
                }
                return "" + this.pickBondAssignType;
            }
            if (name == "bondindex") {
                if (value != null) {
                    this.setBondIndex((Integer)value, false);
                }
                return this.bondIndex < 0 ? null : Integer.valueOf(this.bondIndex);
            }
            if (name == "rotatebondindex") {
                if (value != null) {
                    this.setBondIndex((Integer)value, true);
                }
                return this.bondIndex < 0 ? null : Integer.valueOf(this.bondIndex);
            }
            if (name == "offset") {
                if (value == "none") {
                    this.viewOffset = null;
                } else if (value != null) {
                    P3 p3 = this.viewOffset = value instanceof P3 ? (P3)value : ModelKit.pointFromTriad(value.toString());
                    if (this.viewOffset != null) {
                        this.setSymViewState(8);
                    }
                }
                this.showXtalSymmetry();
                return this.viewOffset;
            }
            if (name == "screenxy") {
                if (value != null) {
                    this.screenXY = (int[])value;
                }
                return this.screenXY;
            }
            if (name == "bondatomindex") {
                int i = (Integer)value;
                if (i != this.bondAtomIndex2) {
                    this.bondAtomIndex1 = i;
                }
                this.bsRotateBranch = null;
                return null;
            }
            if (name == "highlight") {
                this.bsHighlight = value == null ? new BS() : (BS)value;
                return null;
            }
            if (name == "mode") {
                boolean isEdit = "edit".equals(value);
                this.setMKState("view".equals(value) ? 1 : (isEdit ? 2 : 0));
                if (isEdit) {
                    this.addXtalHydrogens = false;
                }
                return null;
            }
            if (name == "symmetry") {
                this.setDefaultState(2);
                name = ((String)value).toLowerCase().intern();
                this.setSymEdit(name == "applylocal" ? 32 : (name == "retainlocal" ? 64 : (name == "applyfull" ? 128 : 0)));
                this.showXtalSymmetry();
                return null;
            }
            if (name == "unitcell") {
                boolean isPacked = "packed".equals(value);
                this.setUnitCell(isPacked ? 0 : 256);
                this.viewOffset = isPacked ? Pt000 : null;
                return null;
            }
            if (name == "center") {
                this.setDefaultState(1);
                this.centerPoint = (P3)value;
                this.lastCenter = this.centerPoint.x + " " + this.centerPoint.y + " " + this.centerPoint.z;
                this.centerAtomIndex = this.centerPoint instanceof Atom ? ((Atom)this.centerPoint).i : -1;
                this.atomIndexSphere = -1;
                this.secondAtomIndex = -1;
                this.processAtomClick(this.centerAtomIndex);
                return null;
            }
            if (name == "scriptassignbond") {
                this.appRunScript("modelkit assign bond [{" + value + "}] \"" + this.pickBondAssignType + "\"");
                return null;
            }
            if (name == "hoverlabel") {
                return this.getHoverLabel((Integer)value);
            }
            if (name == "invariant") {
                int iatom = value instanceof BS ? ((BS)value).nextSetBit(0) : -1;
                Atom atom = this.vwr.ms.getAtom(iatom);
                return atom == null ? null : this.vwr.getSymmetryInfo(iatom, null, -1, null, atom, atom, 1275068418, null, 0.0f, 0, 0);
            }
            if (name == "distance") {
                float d;
                this.setDefaultState(2);
                float f = value == null ? Float.NaN : (d = value instanceof Float ? ((Float)value).floatValue() : PT.parseFloat((String)value));
                if (!Float.isNaN(d)) {
                    ModelKit.notImplemented("setProperty: distance");
                    this.centerDistance = d;
                }
                return Float.valueOf(this.centerDistance);
            }
            if (name == "point") {
                if (value != null) {
                    ModelKit.notImplemented("setProperty: point");
                    this.setDefaultState(2);
                    this.spherePoint = (P3)value;
                    this.atomIndexSphere = this.spherePoint instanceof Atom ? ((Atom)this.spherePoint).i : -1;
                }
                return this.spherePoint;
            }
            if (name == "addconstraint") {
                ModelKit.notImplemented("setProperty: addConstraint");
                return null;
            }
            if (name == "removeconstraint") {
                ModelKit.notImplemented("setProperty: removeConstraint");
                return null;
            }
            if (name == "removeallconstraints") {
                ModelKit.notImplemented("setProperty: removeAllConstraints");
                return null;
            }
            System.err.println("ModelKitPopup.setProperty? " + name + " " + value);
        }
        catch (Exception e) {
            return "?";
        }
        return null;
    }

    public MeasurementPending setBondMeasure(int bi, MeasurementPending mp) {
        if (this.branchAtomIndex < 0) {
            return null;
        }
        Bond b = this.vwr.ms.bo[bi];
        Atom a1 = b.atom1;
        Atom a2 = b.atom2;
        this.a3 = null;
        this.a0 = null;
        if (a1.getCovalentBondCount() == 1 || a2.getCovalentBondCount() == 1) {
            return null;
        }
        this.a0 = this.getOtherAtomIndex(a1, a2);
        mp.addPoint(this.a0.i, null, true);
        mp.addPoint(a1.i, null, true);
        mp.addPoint(a2.i, null, true);
        this.a3 = this.getOtherAtomIndex(a2, a1);
        mp.addPoint(this.a3.i, null, true);
        mp.mad = 50;
        mp.inFront = true;
        return mp;
    }

    public void actionRotateBond(int deltaX, int deltaY, int x, int y, boolean forceFull) {
        Atom atomFix;
        Atom atomMove;
        if (this.bondIndex < 0) {
            return;
        }
        BS bsBranch = this.bsRotateBranch;
        ModelSet ms = this.vwr.ms;
        Bond b = ms.bo[this.bondIndex];
        if (forceFull) {
            bsBranch = null;
            this.branchAtomIndex = -1;
        }
        if (bsBranch == null) {
            atomMove = this.branchAtomIndex == b.atom1.i ? b.atom1 : b.atom2;
            atomFix = atomMove == b.atom1 ? b.atom2 : b.atom1;
            this.vwr.undoMoveActionClear(atomFix.i, 2, true);
            if (this.branchAtomIndex >= 0) {
                bsBranch = this.vwr.getBranchBitSet(atomMove.i, atomFix.i, true);
            }
            if (bsBranch != null) {
                int n = 0;
                int i = atomFix.bonds.length;
                while (--i >= 0) {
                    if (!bsBranch.get(atomFix.getBondedAtomIndex(i)) || ++n != 2) continue;
                    bsBranch = null;
                    break;
                }
            }
            if (bsBranch == null) {
                bsBranch = ms.getMoleculeBitSetForAtom(atomFix.i);
                forceFull = true;
            }
            this.bsRotateBranch = bsBranch;
            this.bondAtomIndex1 = atomFix.i;
            this.bondAtomIndex2 = atomMove.i;
        } else {
            atomFix = ms.at[this.bondAtomIndex1];
            atomMove = ms.at[this.bondAtomIndex2];
        }
        V3 v1 = V3.new3(atomMove.sX - atomFix.sX, atomMove.sY - atomFix.sY, 0.0f);
        v1.scale(1.0f / v1.length());
        V3 v2 = V3.new3(deltaX, deltaY, 0.0f);
        v1.cross(v1, v2);
        float f = v1.z > 0.0f ? 1 : -1;
        float degrees = f * (float)((int)v2.length() / 2 + 1);
        if (!forceFull && this.a0 != null) {
            float ang0 = Measure.computeTorsion(this.a0, b.atom1, b.atom2, this.a3, true);
            float ang1 = Math.round(ang0 + degrees);
            degrees = ang1 - ang0;
        }
        BS bs = BSUtil.copy(bsBranch);
        bs.andNot(this.vwr.slm.getMotionFixedAtoms());
        this.vwr.rotateAboutPointsInternal(null, atomFix, atomMove, 0.0f, degrees, false, bs, null, null, null, null);
    }

    public boolean handleAssignNew(MouseState pressed, MouseState dragged, MeasurementPending mp, int dragAtomIndex) {
        boolean inRange = pressed.inRange(10, dragged.x, dragged.y);
        if (inRange) {
            dragged.x = pressed.x;
            dragged.y = pressed.y;
        }
        if (this.handleDragAtom(pressed, dragged, mp.countPlusIndices)) {
            return true;
        }
        boolean isCharge = this.isPickAtomAssignCharge;
        String atomType = this.pickAtomAssignType;
        if (mp.count == 2) {
            this.vwr.undoMoveActionClear(-1, 4146, true);
            if (((Atom)mp.getAtom(1)).isBonded((Atom)mp.getAtom(2))) {
                this.appRunScript("modelkit assign bond " + mp.getMeasurementScript(" ", false) + "'p'");
            } else {
                this.appRunScript("modelkit connect " + mp.getMeasurementScript(" ", false));
            }
        } else {
            if (atomType.equals("Xx")) {
                atomType = this.lastElementType;
            }
            if (inRange) {
                String s = "modelkit assign atom ({" + dragAtomIndex + "}) \"" + atomType + "\" true";
                if (isCharge) {
                    s = s + ";{atomindex=" + dragAtomIndex + "}.label='%C'; ";
                    this.vwr.undoMoveActionClear(dragAtomIndex, 4, true);
                } else {
                    this.vwr.undoMoveActionClear(-1, 4146, true);
                }
                this.appRunScript(s);
            } else if (!isCharge) {
                this.vwr.undoMoveActionClear(-1, 4146, true);
                Atom a = this.vwr.ms.at[dragAtomIndex];
                if (a.getElementNumber() == 1) {
                    this.assignAtomClick(dragAtomIndex, "X", null);
                } else {
                    int x = dragged.x;
                    int y = dragged.y;
                    if (this.vwr.antialiased) {
                        x <<= 1;
                        y <<= 1;
                    }
                    P3 ptNew = P3.new3(x, y, a.sZ);
                    this.vwr.tm.unTransformPoint(ptNew, ptNew);
                    this.assignAtomClick(dragAtomIndex, atomType, ptNew);
                }
            }
        }
        return true;
    }

    public void cmdAssignAtom(int atomIndex, P3 pt, String type, String cmd, boolean isClick) {
        Atom atom;
        if (isClick && type.equals("X")) {
            this.vwr.setModelKitRotateBondIndex(-1);
        }
        int ac = this.vwr.ms.ac;
        Atom atom2 = atom = atomIndex < 0 ? null : this.vwr.ms.at[atomIndex];
        if (pt == null) {
            if (atomIndex < 0 || atom == null) {
                return;
            }
            short mi = atom.mi;
            this.vwr.sm.setStatusStructureModified(atomIndex, mi, 1, cmd, 1, null);
            this.assignAtom(atomIndex, type, this.autoBond, true, true);
            if (!PT.isOneOf(type, ";Mi;Pl;X;")) {
                this.vwr.ms.setAtomNamesAndNumbers(0, -ac, null);
            }
            this.vwr.sm.setStatusStructureModified(atomIndex, mi, -1, "OK", 1, null);
            this.vwr.refresh(3, "assignAtom");
            return;
        }
        BS bs = atomIndex < 0 ? new BS() : BSUtil.newAndSetBit(atomIndex);
        P3[] pts = new P3[]{pt};
        Lst<Atom> vConnections = new Lst<Atom>();
        int modelIndex = -1;
        if (atom != null) {
            vConnections.addLast(atom);
            modelIndex = atom.mi;
            this.vwr.sm.setStatusStructureModified(atomIndex, modelIndex, 3, cmd, 1, null);
        }
        try {
            int pickingMode = this.vwr.acm.getAtomPickingMode();
            boolean wasHidden = this.menu.hidden;
            boolean isMK = this.vwr.getBoolean(603983903);
            if (!isMK) {
                this.vwr.setBooleanProperty("modelkitmode", true);
                this.menu.hidden = true;
                this.menu.allowPopup = false;
            }
            bs = this.vwr.addHydrogensInline(bs, vConnections, pts);
            if (!isMK) {
                this.vwr.setBooleanProperty("modelkitmode", false);
                this.menu.hidden = wasHidden;
                this.menu.allowPopup = true;
                this.vwr.acm.setPickingMode(pickingMode);
                this.menu.hidePopup();
            }
            int atomIndex2 = bs.nextSetBit(0);
            int state = this.getMKState();
            this.setMKState(0);
            this.assignAtom(atomIndex2, type, false, atomIndex >= 0, true);
            if (atomIndex >= 0) {
                this.assignAtom(atomIndex, ".", false, true, isClick);
            }
            this.setMKState(state);
            atomIndex = atomIndex2;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.vwr.ms.setAtomNamesAndNumbers(0, -ac, null);
        this.vwr.sm.setStatusStructureModified(atomIndex, modelIndex, -3, "OK", 1, null);
    }

    public void cmdAssignBond(int bondIndex, char type, String cmd) {
        int modelIndex = -1;
        try {
            if (type == '-') {
                type = this.pickBondAssignType;
            }
            modelIndex = this.vwr.ms.bo[bondIndex].atom1.mi;
            int ac = this.vwr.ms.ac;
            this.vwr.sm.setStatusStructureModified(bondIndex, modelIndex, 2, cmd, 1, null);
            BS bsAtoms = this.assignBond(bondIndex, type);
            this.vwr.ms.setAtomNamesAndNumbers(0, -ac, null);
            if (bsAtoms == null || type == '0') {
                this.vwr.refresh(3, "setBondOrder");
            }
            this.vwr.sm.setStatusStructureModified(bondIndex, modelIndex, -2, "" + type, 1, null);
        }
        catch (Exception ex) {
            Logger.error("assignBond failed");
            this.vwr.sm.setStatusStructureModified(bondIndex, modelIndex, -2, "ERROR " + ex, 1, null);
        }
    }

    public void cmdAssignConnect(int index, int index2, char type, String cmd) {
        float[][] connections = AU.newFloat2(1);
        connections[0] = new float[]{index, index2};
        short modelIndex = this.vwr.ms.at[index].mi;
        this.vwr.sm.setStatusStructureModified(index, modelIndex, 2, cmd, 1, null);
        this.vwr.ms.connect(connections);
        int ac = this.vwr.ms.ac;
        this.assignAtom(index, ".", true, true, false);
        this.assignAtom(index2, ".", true, true, false);
        this.vwr.ms.setAtomNamesAndNumbers(0, -ac, null);
        this.vwr.sm.setStatusStructureModified(index, modelIndex, -2, "OK", 1, null);
        if (type != '1') {
            BS bs = BSUtil.newAndSetBit(index);
            bs.set(index2);
            bs = this.vwr.getBondsForSelectedAtoms(bs);
            int bondIndex = bs.nextSetBit(0);
            this.cmdAssignBond(bondIndex, type, cmd);
        }
        this.vwr.refresh(3, "assignConnect");
    }

    public void assignAtomClick(int atomIndex, String element, P3 ptNew) {
        this.vwr.script("modelkit assign atom ({" + atomIndex + "}) \"" + element + "\" " + (ptNew == null ? "" : Escape.eP(ptNew)) + " true");
    }

    boolean isXtalState() {
        return (this.state & 3) != 0;
    }

    void setMKState(int bits) {
        this.state = this.state & 0xFFFFFFFC | (this.hasUnitCell ? bits : 0);
    }

    int getMKState() {
        return this.state & 3;
    }

    void setSymEdit(int bits) {
        this.state = this.state & 0xFFFFFF1F | bits;
    }

    int getSymEditState() {
        return this.state & 0xE0;
    }

    void setSymViewState(int bits) {
        this.state = this.state & 0xFFFFFFE3 | bits;
    }

    int getSymViewState() {
        return this.state & 0x1C;
    }

    void setUnitCell(int bits) {
        this.state = this.state & 0xFFFFF8FF | bits;
    }

    int getUnitCellState() {
        return this.state & 0x700;
    }

    void exitBondRotation(String text) {
        this.isRotateBond = false;
        if (text != null) {
            this.bondHoverLabel = text;
        }
        this.vwr.highlight(null);
        this.vwr.setPickingMode(null, 33);
    }

    void resetBondFields() {
        this.bsRotateBranch = null;
        this.bondAtomIndex2 = -1;
        this.bondAtomIndex1 = -1;
        this.branchAtomIndex = -1;
    }

    void processXtalClick(String id, String action) {
        if (this.processSymop(id, false)) {
            return;
        }
        if ((action = action.intern()).startsWith("mkmode_")) {
            if (!this.alertedNoEdit && action == "mkmode_edit") {
                this.alertedNoEdit = true;
                this.vwr.alert("ModelKit xtal edit has not been implemented");
                return;
            }
            this.processModeClick(action);
        } else if (action.startsWith("mksel_")) {
            this.processSelClick(action);
        } else if (action.startsWith("mkselop_")) {
            while (action != null) {
                action = this.processSelOpClick(action);
            }
        } else if (action.startsWith("mksymmetry_")) {
            this.processSymClick(action);
        } else if (action.startsWith("mkunitcell_")) {
            this.processUCClick(action);
        } else {
            ModelKit.notImplemented("XTAL click " + action);
        }
        this.menu.updateAllXtalMenuOptions();
    }

    boolean processSymop(String id, boolean isFocus) {
        int pt = id.indexOf(".mkop_");
        if (pt >= 0) {
            Object op = this.symop;
            this.symop = Integer.valueOf(id.substring(pt + 6));
            this.showSymop(this.symop);
            if (isFocus) {
                this.symop = op;
            }
            return true;
        }
        return false;
    }

    void setDefaultState(int mode) {
        if (!this.hasUnitCell) {
            mode = 0;
        }
        if (!this.hasUnitCell || this.isXtalState() != this.hasUnitCell) {
            this.setMKState(mode);
            switch (mode) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.getSymViewState() != 0) break;
                    this.setSymViewState(8);
                    break;
                }
            }
        }
    }

    String[] getAllOperators() {
        if (this.allOperators != null) {
            return this.allOperators;
        }
        String data = this.runScriptBuffered("show symop");
        this.allOperators = PT.split(data.trim().replace('\t', ' '), "\n");
        return this.allOperators;
    }

    boolean setHasUnitCell() {
        this.hasUnitCell = this.vwr.getCurrentUnitCell() != null;
        return this.hasUnitCell;
    }

    boolean checkNewModel() {
        boolean isNew = false;
        if (this.vwr.ms != this.lastModelSet) {
            this.lastModelSet = this.vwr.ms;
            isNew = true;
        }
        this.currentModelIndex = Math.max(this.vwr.am.cmi, 0);
        this.iatom0 = this.vwr.ms.am[this.currentModelIndex].firstAtomIndex;
        return isNew;
    }

    String getSymopText() {
        return this.symop == null || this.allOperators == null ? null : (this.symop instanceof Integer ? this.allOperators[(Integer)this.symop - 1] : this.symop.toString());
    }

    String getCenterText() {
        return this.centerAtomIndex < 0 && this.centerPoint == null ? null : (this.centerAtomIndex >= 0 ? this.vwr.getAtomInfo(this.centerAtomIndex) : this.centerPoint.toString());
    }

    void resetAtomPickType() {
        this.pickAtomAssignType = this.lastElementType;
    }

    void setHoverLabel(String activeMenu, String text) {
        if (text == null) {
            return;
        }
        if (activeMenu == "bondMenu") {
            this.bondHoverLabel = text;
        } else if (activeMenu == "atomMenu") {
            this.atomHoverLabel = text;
        } else if (activeMenu == "xtalMenu") {
            this.xtalHoverLabel = this.atomHoverLabel = text;
        }
    }

    String getElementFromUser() {
        String element = this.promptUser(GT.$("Element?"), "");
        return element == null || Elements.elementNumberFromSymbol(element, true) == 0 ? null : element;
    }

    void processMKPropertyItem(String name, boolean TF) {
        int pt = (name = name.substring(2)).indexOf("_");
        if (pt > 0) {
            this.setProperty(name.substring(0, pt), name.substring(pt + 1));
        } else {
            this.setProperty(name, TF);
        }
    }

    private void assignAtom(int atomIndex, String type, boolean autoBond, boolean addHsAndBond, boolean isClick) {
        boolean wasH;
        Atom atom;
        if (isClick) {
            if (this.isVwrRotateBond()) {
                this.bondAtomIndex1 = atomIndex;
                return;
            }
            if (this.processAtomClick(atomIndex) || !this.clickToSetElement && this.vwr.ms.getAtom(atomIndex).getElementNumber() != 1) {
                return;
            }
        }
        if ((atom = this.vwr.ms.at[atomIndex]) == null) {
            return;
        }
        this.vwr.ms.clearDB(atomIndex);
        if (type == null) {
            type = "C";
        }
        BS bs = new BS();
        boolean bl = wasH = atom.getElementNumber() == 1;
        int atomicNumber = type.equals("Xx") ? 0 : (PT.isUpperCase(type.charAt(0)) ? Elements.elementNumberFromSymbol(type, true) : -1);
        boolean isDelete = false;
        if (atomicNumber >= 0) {
            boolean doTaint = atomicNumber > 1 || !addHsAndBond;
            this.vwr.ms.setElement(atom, atomicNumber, doTaint);
            this.vwr.shm.setShapeSizeBs(0, 0, this.vwr.rd, BSUtil.newAndSetBit(atomIndex));
            this.vwr.ms.setAtomName(atomIndex, type + atom.getAtomNumber(), doTaint);
            if (this.vwr.getBoolean(603983903)) {
                this.vwr.ms.am[atom.mi].isModelKit = true;
            }
            if (!this.vwr.ms.am[atom.mi].isModelKit || atomicNumber > 1) {
                this.vwr.ms.taintAtom(atomIndex, 0);
            }
        } else if (type.toLowerCase().equals("pl")) {
            atom.setFormalCharge(atom.getFormalCharge() + 1);
        } else if (type.toLowerCase().equals("mi")) {
            atom.setFormalCharge(atom.getFormalCharge() - 1);
        } else if (type.equals("X")) {
            isDelete = true;
        } else if (!type.equals(".") || !this.addXtalHydrogens) {
            return;
        }
        if (!addHsAndBond) {
            return;
        }
        this.vwr.ms.removeUnnecessaryBonds(atom, isDelete);
        float dx = 0.0f;
        if (atom.getCovalentBondCount() == 1) {
            if (wasH) {
                dx = 1.5f;
            } else if (!wasH && atomicNumber == 1) {
                dx = 1.0f;
            }
        }
        if (dx != 0.0f) {
            V3 v = V3.newVsub(atom, this.vwr.ms.at[atom.getBondedAtomIndex(0)]);
            float d = v.length();
            v.normalize();
            v.scale(dx - d);
            this.vwr.ms.setAtomCoordRelative(atomIndex, v.x, v.y, v.z);
        }
        BS bsA = BSUtil.newAndSetBit(atomIndex);
        if (isDelete) {
            this.vwr.deleteAtoms(bsA, false);
        }
        if (atomicNumber != 1 && autoBond) {
            this.vwr.ms.validateBspf(false);
            bs = this.vwr.ms.getAtomsWithinRadius(1.0f, bsA, false, null);
            bs.andNot(bsA);
            if (bs.nextSetBit(0) >= 0) {
                this.vwr.deleteAtoms(bs, false);
            }
            bs = this.vwr.getModelUndeletedAtomsBitSet(atom.mi);
            bs.andNot(this.vwr.ms.getAtomBitsMDa(1612709900, null, new BS()));
            this.vwr.ms.makeConnections2(0.1f, 1.8f, 1, 0x40000050, bsA, bs, null, false, false, 0.0f);
        }
        if (this.addXtalHydrogens) {
            this.vwr.addHydrogens(bsA, 1);
        }
    }

    private BS assignBond(int bondIndex, char type) {
        int bondOrder = type - 48;
        Bond bond = this.vwr.ms.bo[bondIndex];
        this.vwr.ms.clearDB(bond.atom1.i);
        switch (type) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                break;
            }
            case 'm': 
            case 'p': {
                bondOrder = Edge.getBondOrderNumberFromOrder(bond.getCovalentOrder()).charAt(0) - 48 + (type == 'p' ? 1 : -1);
                if (bondOrder > 3) {
                    bondOrder = 1;
                    break;
                }
                if (bondOrder >= 0) break;
                bondOrder = 3;
                break;
            }
            default: {
                return null;
            }
        }
        BS bsAtoms = new BS();
        try {
            if (bondOrder == 0) {
                BS bs = new BS();
                bs.set(bond.index);
                bsAtoms.set(bond.atom1.i);
                bsAtoms.set(bond.atom2.i);
                this.vwr.ms.deleteBonds(bs, false);
            } else {
                bond.setOrder(bondOrder | 0x20000);
                if (bond.atom1.getElementNumber() != 1 && bond.atom2.getElementNumber() != 1) {
                    this.vwr.ms.removeUnnecessaryBonds(bond.atom1, false);
                    this.vwr.ms.removeUnnecessaryBonds(bond.atom2, false);
                }
                bsAtoms.set(bond.atom1.i);
                bsAtoms.set(bond.atom2.i);
            }
        }
        catch (Exception e) {
            Logger.error("Exception in seBondOrder: " + e.toString());
        }
        if (type != '0' && this.addXtalHydrogens) {
            this.vwr.addHydrogens(bsAtoms, 1);
        }
        return bsAtoms;
    }

    private void setBondIndex(int index, boolean isRotate) {
        boolean haveBond;
        if (!isRotate && this.isVwrRotateBond()) {
            this.vwr.setModelKitRotateBondIndex(index);
            return;
        }
        boolean bl = haveBond = this.bondIndex >= 0;
        if (!haveBond && index < 0) {
            return;
        }
        if (index < 0) {
            this.resetBondFields();
            return;
        }
        this.bsRotateBranch = null;
        this.branchAtomIndex = -1;
        this.bondIndex = index;
        this.isRotateBond = isRotate;
        this.bondAtomIndex1 = this.vwr.ms.bo[index].getAtomIndex1();
        this.bondAtomIndex2 = this.vwr.ms.bo[index].getAtomIndex2();
        this.menu.setActiveMenu("bondMenu");
    }

    private boolean handleDragAtom(MouseState pressed, MouseState dragged, int[] countPlusIndices) {
        switch (this.getMKState()) {
            case 0: {
                return false;
            }
            case 2: {
                if (countPlusIndices[0] > 2) {
                    return true;
                }
                ModelKit.notImplemented("drag atom for XTAL edit");
                break;
            }
            case 1: {
                if (this.getSymViewState() == 0) {
                    this.setSymViewState(8);
                }
                switch (countPlusIndices[0]) {
                    case 1: {
                        this.centerAtomIndex = countPlusIndices[1];
                        this.secondAtomIndex = -1;
                        break;
                    }
                    case 2: {
                        this.centerAtomIndex = countPlusIndices[1];
                        this.secondAtomIndex = countPlusIndices[2];
                    }
                }
                this.showXtalSymmetry();
                return true;
            }
        }
        return true;
    }

    private void showSymop(Object symop) {
        this.secondAtomIndex = -1;
        this.symop = symop;
        this.showXtalSymmetry();
    }

    private void showXtalSymmetry() {
        String script = null;
        switch (this.getSymViewState()) {
            case 0: {
                script = "draw * delete";
                break;
            }
            default: {
                P3 offset = null;
                if (this.secondAtomIndex >= 0) {
                    script = "draw ID sym symop " + (this.centerAtomIndex < 0 ? this.centerPoint : " {atomindex=" + this.centerAtomIndex + "}") + " {atomindex=" + this.secondAtomIndex + "}";
                } else {
                    offset = this.viewOffset;
                    if (this.symop == null) {
                        this.symop = 1;
                    }
                    int iatom = this.centerAtomIndex >= 0 ? this.centerAtomIndex : (this.centerPoint != null ? -1 : this.iatom0);
                    script = "draw ID sym symop " + (this.symop == null ? "1" : (this.symop instanceof String ? "'" + this.symop + "'" : PT.toJSON(null, this.symop))) + (iatom < 0 ? this.centerPoint : " {atomindex=" + iatom + "}") + (offset == null ? "" : " offset " + offset);
                }
                this.drawData = this.runScriptBuffered(script);
                this.drawScript = script;
                this.drawData = this.showSymopInfo ? this.drawData.substring(0, this.drawData.indexOf("\n") + 1) : "";
                this.appRunScript(";refresh;set echo top right;echo " + this.drawData.replace('\t', ' '));
            }
        }
    }

    private Object getinfo() {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        this.addInfo(info, "addHydrogens", this.addXtalHydrogens);
        this.addInfo(info, "autobond", this.autoBond);
        this.addInfo(info, "clickToSetElement", this.clickToSetElement);
        this.addInfo(info, "hidden", this.menu.hidden);
        this.addInfo(info, "showSymopInfo", this.showSymopInfo);
        this.addInfo(info, "centerPoint", this.centerPoint);
        this.addInfo(info, "centerAtomIndex", this.centerAtomIndex);
        this.addInfo(info, "secondAtomIndex", this.secondAtomIndex);
        this.addInfo(info, "symop", this.symop);
        this.addInfo(info, "offset", this.viewOffset);
        this.addInfo(info, "drawData", this.drawData);
        this.addInfo(info, "drawScript", this.drawScript);
        this.addInfo(info, "isMolecular", this.getMKState() == 0);
        return info;
    }

    private void addInfo(Map<String, Object> info, String key, Object value) {
        if (value != null) {
            info.put(key, value);
        }
    }

    private boolean processAtomClick(int atomIndex) {
        switch (this.getMKState()) {
            case 0: {
                return this.isVwrRotateBond();
            }
            case 1: {
                this.centerAtomIndex = atomIndex;
                if (this.getSymViewState() == 0) {
                    this.setSymViewState(8);
                }
                this.showXtalSymmetry();
                return true;
            }
            case 2: {
                if (atomIndex == this.centerAtomIndex) {
                    return true;
                }
                ModelKit.notImplemented("edit click");
                return false;
            }
        }
        ModelKit.notImplemented("atom click unknown XTAL state");
        return false;
    }

    private void processModeClick(String action) {
        this.processMKPropertyItem(action, false);
    }

    private void processSelClick(String action) {
        if (action == "mksel_atom") {
            this.centerPoint = null;
            this.centerAtomIndex = -1;
            this.secondAtomIndex = -1;
        } else if (action == "mksel_position") {
            String pos = this.promptUser("Enter three fractional coordinates", this.lastCenter);
            if (pos == null) {
                return;
            }
            this.lastCenter = pos;
            P3 p = ModelKit.pointFromTriad(pos);
            if (p == null) {
                this.processSelClick(action);
                return;
            }
            this.centerAtomIndex = -2147483647;
            this.centerPoint = p;
            this.showXtalSymmetry();
        }
    }

    private String processSelOpClick(String action) {
        this.secondAtomIndex = -1;
        if (action == "mkselop_addoffset") {
            String pos = this.promptUser("Enter i j k for an offset for viewing the operator - leave blank to clear", this.lastOffset);
            if (pos == null) {
                return null;
            }
            this.lastOffset = pos;
            if (pos.length() == 0 || pos == "none") {
                this.setProperty("offset", "none");
                return null;
            }
            P3 p = ModelKit.pointFromTriad(pos);
            if (p == null) {
                return action;
            }
            this.setProperty("offset", p);
        } else if (action == "mkselop_atom2") {
            ModelKit.notImplemented(action);
        }
        return null;
    }

    private void processSymClick(String action) {
        if (action == "mksymmetry_none") {
            this.setSymEdit(0);
        } else {
            this.processMKPropertyItem(action, false);
        }
    }

    private void processUCClick(String action) {
        this.processMKPropertyItem(action, false);
        this.showXtalSymmetry();
    }

    private String getHoverLabel(int atomIndex) {
        int state = this.getMKState();
        String msg = null;
        block0 : switch (state) {
            case 1: {
                if (this.symop == null) {
                    this.symop = 1;
                }
                msg = "view symop " + this.symop + " for " + this.vwr.getAtomInfo(atomIndex);
                break;
            }
            case 2: {
                msg = "start editing for " + this.vwr.getAtomInfo(atomIndex);
                break;
            }
            case 0: {
                Atom[] atoms = this.vwr.ms.at;
                if (this.isRotateBond) {
                    if (atomIndex == this.bondAtomIndex1 || atomIndex == this.bondAtomIndex2) {
                        msg = "rotate branch " + atoms[atomIndex].getAtomName();
                        this.branchAtomIndex = atomIndex;
                        this.bsRotateBranch = null;
                    } else {
                        msg = "rotate bond" + this.getBondLabel(atoms);
                        this.bsRotateBranch = null;
                        this.branchAtomIndex = -1;
                    }
                }
                if (this.bondIndex < 0) {
                    if (this.atomHoverLabel.length() <= 2) {
                        msg = this.atomHoverLabel = "Click to change to " + this.atomHoverLabel + " or drag to add " + this.atomHoverLabel;
                        break;
                    }
                    msg = atoms[atomIndex].getAtomName() + ": " + this.atomHoverLabel;
                    this.vwr.highlight(BSUtil.newAndSetBit(atomIndex));
                    break;
                }
                if (msg != null) break;
                switch (this.bsHighlight.cardinality()) {
                    case 0: {
                        this.vwr.highlight(BSUtil.newAndSetBit(atomIndex));
                    }
                    case 1: {
                        if (!this.isRotateBond) {
                            this.menu.setActiveMenu("atomMenu");
                        }
                        if (this.atomHoverLabel.indexOf("charge") >= 0) {
                            int ch = this.vwr.ms.at[atomIndex].getFormalCharge();
                            msg = this.atomHoverLabel + " to " + ((ch += this.atomHoverLabel.indexOf("increase") >= 0 ? 1 : -1) > 0 ? "+" : "") + ch;
                        } else {
                            msg = this.atomHoverLabel;
                        }
                        msg = atoms[atomIndex].getAtomName() + ": " + msg;
                        break block0;
                    }
                    case 2: {
                        msg = this.bondHoverLabel + this.getBondLabel(atoms);
                    }
                }
            }
        }
        return msg;
    }

    private String getBondLabel(Atom[] atoms) {
        return " for " + atoms[Math.min(this.bondAtomIndex1, this.bondAtomIndex2)].getAtomName() + "-" + atoms[Math.max(this.bondAtomIndex1, this.bondAtomIndex2)].getAtomName();
    }

    private Atom getOtherAtomIndex(Atom a1, Atom a2) {
        Bond[] b = a1.bonds;
        Atom ret = null;
        int zmin = Integer.MAX_VALUE;
        int i = -1;
        while (++i < b.length) {
            Atom a;
            if (b[i] == null || !b[i].isCovalent() || (a = b[i].getOtherAtom(a1)) == a2 || a.sZ >= zmin) continue;
            zmin = a.sZ;
            ret = a;
        }
        return ret;
    }

    private boolean isVwrRotateBond() {
        return this.vwr.acm.getBondPickingMode() == 34;
    }

    private String promptUser(String msg, String def) {
        return this.vwr.prompt(msg, def, null, false);
    }

    private void appRunScript(String script) {
        this.vwr.evalStringQuiet(script);
    }

    private String runScriptBuffered(String script) {
        SB sb = new SB();
        try {
            ((ScriptEval)this.vwr.eval).runBufferedSafely(script, sb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private static boolean isTrue(Object value) {
        return Boolean.valueOf(value.toString()) == Boolean.TRUE;
    }

    private static P3 pointFromTriad(String pos) {
        float[] a = PT.parseFloatArray(PT.replaceAllCharacters(pos, "{,}", " "));
        return a.length == 3 && !Float.isNaN(a[2]) ? P3.new3(a[0], a[1], a[2]) : null;
    }

    private static void notImplemented(String action) {
        System.err.println("ModelKit.notImplemented(" + action + ")");
    }

    public String cmdAssignSpaceGroup(BS bs) {
        try {
            BS basis;
            String ita;
            T3[] oabc;
            P3 supercell;
            String name;
            Map sg;
            boolean noAtoms;
            if (bs != null && bs.isEmpty()) {
                return "";
            }
            SymmetryInterface uc = this.vwr.getCurrentUnitCell();
            if (uc == null) {
                uc = this.vwr.getSymTemp().setUnitCell(new float[]{10.0f, 10.0f, 10.0f, 90.0f, 90.0f, 90.0f}, false);
            }
            BS bsAtoms = this.vwr.getThisModelAtoms();
            if (bs == null) {
                bs = SV.getBitSet(this.vwr.evaluateExpressionAsVariable("{within(unitcell)}"), true);
            }
            if (bs != null) {
                bsAtoms.and(bs);
            }
            int mi = (noAtoms = bsAtoms.isEmpty()) ? 0 : this.vwr.ms.at[bsAtoms.nextSetBit(0)].getModelIndex();
            T3 m = uc.getUnitCellMultiplier();
            if (m != null && m.z == 1.0f) {
                m.z = 0.0f;
            }
            Map map = sg = noAtoms ? null : (Map)this.vwr.findSpaceGroup(bsAtoms, null, false);
            if (sg == null) {
                name = "P1";
                supercell = P3.new3(1.0f, 1.0f, 1.0f);
                oabc = uc.getUnitCellVectors();
                ita = "1";
                basis = null;
            } else {
                supercell = (P3)sg.get("supercell");
                oabc = (P3[])sg.get("unitcell");
                name = (String)sg.get("name");
                ita = (String)sg.get("itaFull");
                basis = (BS)sg.get("basis");
            }
            uc.getUnitCell(oabc, false, null);
            uc.setSpaceGroupTo(ita);
            uc.setSpaceGroupName(name);
            this.vwr.ms.setSpaceGroup(mi, uc, basis);
            P4 pt = SimpleUnitCell.ptToIJK(supercell, 1);
            this.vwr.ms.setUnitCellOffset(uc, pt, 0);
            return name + " basis=" + basis;
        }
        catch (Exception e) {
            if (!Viewer.isJS) {
                e.printStackTrace();
            }
            return e.getMessage();
        }
    }
}

