/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Map;
import javajs.util.A4;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.VDW;
import org.jmol.modelset.Atom;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Text;
import org.jmol.modelset.TickInfo;
import org.jmol.util.Escape;
import org.jmol.util.Point3fi;
import org.jmol.viewer.Viewer;

public class Measurement {
    public String thisID;
    public ModelSet ms;
    public int index;
    public boolean isVisible = true;
    public boolean isHidden = false;
    public boolean isTrajectory = false;
    public boolean isValid = true;
    public short colix;
    public short labelColix = (short)-1;
    public int mad;
    public TickInfo tickInfo;
    public int traceX = Integer.MIN_VALUE;
    public int traceY;
    public int count;
    public int[] countPlusIndices = new int[5];
    public Point3fi[] pts;
    public float value;
    public String strFormat;
    public String property;
    public String units;
    public Text text;
    private Viewer vwr;
    private String strMeasurement;
    private String type;
    private boolean tainted;
    public A4 renderAxis;
    public P3 renderArc;
    private String newUnits;
    public float fixedValue = Float.NaN;
    private boolean isPending;
    public boolean inFront;
    public static final int NMR_NOT = 0;
    public static final int NMR_DC = 1;
    public static final int NMR_JC = 2;
    public static final int NMR_NOE_OR_J = 3;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTainted() {
        if (!this.tainted) return false;
        this.tainted = false;
        if (false) return false;
        return true;
    }

    public Measurement setM(ModelSet modelSet, Measurement m, float value, short colix, String strFormat, int index) {
        this.ms = modelSet;
        this.index = index;
        this.vwr = modelSet.vwr;
        this.colix = colix;
        this.strFormat = strFormat;
        if (m != null) {
            this.tickInfo = m.tickInfo;
            this.pts = m.pts;
            this.mad = m.mad;
            this.thisID = m.thisID;
            this.text = m.text;
            this.property = m.property;
            this.units = m.units;
            if (this.property == null && "+hz".equals(this.units)) {
                this.property = "property_J";
            }
            if (this.thisID != null && this.text != null) {
                this.labelColix = this.text.colix;
            }
        }
        if (this.pts == null) {
            this.pts = new Point3fi[4];
        }
        int[] indices = m == null ? null : m.countPlusIndices;
        int n = this.count = indices == null ? 0 : indices[0];
        if (this.count > 0) {
            System.arraycopy(indices, 0, this.countPlusIndices, 0, this.count + 1);
            this.isTrajectory = modelSet.isTrajectoryMeasurement(this.countPlusIndices);
        }
        this.isPending = Float.isNaN(value);
        this.value = this.isPending || this.isTrajectory ? this.getMeasurement(null) : value;
        this.formatMeasurement(null);
        return this;
    }

    public Measurement setPoints(ModelSet modelSet, int[] indices, Point3fi[] points, TickInfo tickInfo) {
        this.ms = modelSet;
        this.countPlusIndices = indices;
        this.count = indices[0];
        this.pts = points == null ? new Point3fi[4] : points;
        this.vwr = modelSet.vwr;
        this.tickInfo = tickInfo;
        return this;
    }

    public void setCount(int count) {
        this.setCountM(count);
    }

    protected void setCountM(int count) {
        this.count = this.countPlusIndices[0] = count;
    }

    public int getAtomIndex(int n) {
        return n > 0 && n <= this.count ? this.countPlusIndices[n] : -1;
    }

    public Point3fi getAtom(int n) {
        int pt = this.countPlusIndices[n];
        return pt < -1 ? this.pts[-2 - pt] : this.ms.at[pt];
    }

    public int getLastIndex() {
        return this.count > 0 ? this.countPlusIndices[this.count] : -1;
    }

    public String getString() {
        return this.strMeasurement;
    }

    public String toString() {
        return this.getString();
    }

    String getStringUsing(Viewer vwr, String strFormat, String units) {
        this.vwr = vwr;
        this.value = this.getMeasurement(null);
        this.formatMeasurementAs(strFormat, units, true);
        if (strFormat == null) {
            return this.getInfoAsString(units);
        }
        return this.strMeasurement;
    }

    public String getStringDetail() {
        return (this.count == 2 ? "Distance" : (this.count == 3 ? "Angle" : "Torsion")) + this.getMeasurementScript(" - ", false) + " : " + this.value;
    }

    public void refresh(Point3fi[] pts) {
        this.value = this.getMeasurement(pts);
        this.isTrajectory = this.ms.isTrajectoryMeasurement(this.countPlusIndices);
        this.formatMeasurement(null);
    }

    public String getMeasurementScript(String sep, boolean withModelIndex) {
        SB sb = new SB();
        boolean asBitSet = sep.equals(" ");
        for (int i = 1; i <= this.count; ++i) {
            sb.append(i > 1 ? sep : " ").append(this.getLabel(i, asBitSet, withModelIndex));
        }
        return sb.toString();
    }

    public void formatMeasurementAs(String strFormat, String units, boolean useDefault) {
        if (strFormat != null && strFormat.length() == 0) {
            strFormat = null;
        }
        if (!useDefault && strFormat != null && strFormat.indexOf(this.countPlusIndices[0] + ":") != 0) {
            return;
        }
        this.strFormat = strFormat;
        this.formatMeasurement(units);
    }

    public void formatMeasurement(String units) {
        this.tainted = true;
        switch (Float.isNaN(this.value) ? 0 : this.count) {
            default: {
                this.strMeasurement = null;
                return;
            }
            case 2: {
                this.strMeasurement = this.formatDistance(units);
                return;
            }
            case 3: 
            case 4: 
        }
        this.strMeasurement = this.formatAngle(this.value);
    }

    public void reformatDistanceIfSelected() {
        if (this.count != 2) {
            return;
        }
        if (this.vwr.slm.isSelected(this.countPlusIndices[1]) && this.vwr.slm.isSelected(this.countPlusIndices[2])) {
            this.formatMeasurement(null);
        }
    }

    private String formatDistance(String units) {
        String label = this.getLabelString();
        if (label == null) {
            return "";
        }
        int pt = this.strFormat.indexOf("//");
        if (units == null) {
            units = this.units;
            if (units == null) {
                if (pt >= 0) {
                    units = this.strFormat.substring(pt + 2);
                    this.strFormat = this.strFormat.substring(0, pt);
                } else {
                    units = this.property == null ? this.vwr.g.measureDistanceUnits : "";
                }
            }
        } else if (pt >= 0) {
            this.strFormat = this.strFormat.substring(0, pt);
        }
        this.strFormat = this.strFormat + "//" + units;
        units = Measurement.fixUnits(units);
        pt = label.indexOf("//");
        if (pt >= 0 && (label = label.substring(0, pt)).length() == 0) {
            label = "%VALUE";
        }
        float f = this.fixValue(units, label.indexOf("%V") >= 0);
        return this.formatString(f, this.newUnits, label);
    }

    private static String fixUnits(String units) {
        if (units.equals("nanometers")) {
            return "nm";
        }
        if (units.equals("picometers")) {
            return "pm";
        }
        if (units.equals("angstroms")) {
            return "\u00c5";
        }
        if (units.equals("vanderwaals") || units.equals("vdw")) {
            return "%";
        }
        return units;
    }

    public float fixValue(String units, boolean andRound) {
        this.checkJ(units);
        if (units != null && units.startsWith("+")) {
            if (!this.isPending) {
                this.value = Math.abs(this.value);
            }
            units = units.substring(1);
        }
        this.newUnits = units;
        if (this.count != 2) {
            return this.value;
        }
        float dist = this.value;
        if (units == null && this.property != null) {
            units = "";
        }
        if (units != null) {
            boolean isPercent = units.equals("%");
            if (this.property == null && (isPercent || units.endsWith("hz"))) {
                int i1 = this.getAtomIndex(1);
                int i2 = this.getAtomIndex(2);
                if (i1 >= 0 && i2 >= 0) {
                    boolean isDC;
                    Atom a1 = (Atom)this.getAtom(1);
                    Atom a2 = (Atom)this.getAtom(2);
                    int itype = Measurement.nmrType(units);
                    boolean bl = isDC = !isPercent && itype == 1;
                    String string = isPercent ? "percent" : (isDC ? "dipoleCouplingConstant" : (this.type = itype == 3 ? "NOE or 3JHH" : "J-CouplingConstant"));
                    if (itype == 3) {
                        double[] result = this.vwr.getNMRCalculation().getNOEorJHH(new Atom[]{a1, null, null, a2}, 11);
                        if (result == null) {
                            dist = Float.NaN;
                            units = "";
                            this.newUnits = "";
                        } else {
                            dist = (float)result[1];
                            this.newUnits = result.length == 2 ? "noe" : "hz";
                            units = this.newUnits;
                        }
                    } else {
                        dist = isPercent ? dist / (a1.getVanderwaalsRadiusFloat(this.vwr, VDW.AUTO) + a2.getVanderwaalsRadiusFloat(this.vwr, VDW.AUTO)) : (isDC ? this.vwr.getNMRCalculation().getDipolarConstantHz(a1, a2) : this.vwr.getNMRCalculation().getIsoOrAnisoHz(true, a1, a2, units, null));
                    }
                    boolean bl2 = this.isValid = !Float.isNaN(dist);
                    if (isPercent) {
                        units = "pm";
                    }
                }
            }
            if (Float.isNaN(dist)) {
                return Float.NaN;
            }
            if (units.equals("hz")) {
                return andRound ? (float)Math.round(dist * 10.0f) / 10.0f : dist;
            }
            if (units.equals("noe")) {
                return andRound ? (float)Math.round(dist * 100.0f) / 100.0f : dist;
            }
            if (units.equals("nm")) {
                return andRound ? (float)Math.round(dist * 100.0f) / 1000.0f : dist / 10.0f;
            }
            if (units.equals("pm")) {
                return andRound ? (float)Math.round(dist * 1000.0f) / 10.0f : dist * 100.0f;
            }
            if (units.equals("au")) {
                return andRound ? (float)Math.round(dist / 0.5291772f * 1000.0f) / 1000.0f : dist / 0.5291772f;
            }
            if (units.endsWith("khz")) {
                return andRound ? (float)Math.round(dist / 10.0f) / 100.0f : dist / 1000.0f;
            }
        }
        return andRound ? (float)Math.round(dist * 100.0f) / 100.0f : dist;
    }

    private void checkJ(String units) {
        if (this.property != null || units != null || this.units != null) {
            return;
        }
        units = this.vwr.g.measureDistanceUnits;
        if ("+hz".equals(units)) {
            this.property = "property_J";
            this.units = units;
        }
    }

    public static int nmrType(String units) {
        return units.indexOf("hz") < 0 ? 0 : (units.equals("noe_hz") ? 3 : (units.startsWith("dc_") || units.equals("khz") ? 1 : 2));
    }

    private String formatAngle(float angle) {
        String label = this.getLabelString();
        if (label.indexOf("%V") >= 0) {
            angle = (float)Math.round(angle * 10.0f) / 10.0f;
        }
        return this.formatString(angle, "\u00b0", label);
    }

    private String getLabelString() {
        String s = this.countPlusIndices[0] + ":";
        String label = null;
        if (this.strFormat != null) {
            if (this.strFormat.length() == 0) {
                return null;
            }
            String string = label = this.strFormat.length() > 2 && this.strFormat.indexOf(s) == 0 ? this.strFormat : null;
        }
        if (label == null) {
            this.strFormat = null;
            label = this.vwr.getDefaultMeasurementLabel(this.countPlusIndices[0]);
        }
        if (label.indexOf(s) == 0) {
            label = label.substring(2);
        }
        if (this.strFormat == null) {
            this.strFormat = s + label;
        }
        return label;
    }

    private String formatString(float value, String units, String label) {
        return LabelToken.formatLabelMeasure(this.vwr, this, label, value, units);
    }

    public boolean sameAsPoints(int[] indices, Point3fi[] points) {
        int i;
        if (this.count != indices[0]) {
            return false;
        }
        boolean isSame = true;
        for (i = 1; i <= this.count && isSame; ++i) {
            isSame = this.countPlusIndices[i] == indices[i];
        }
        if (isSame) {
            for (i = 0; i < this.count && isSame; ++i) {
                if (points[i] == null) continue;
                isSame = (double)this.pts[i].distance(points[i]) < 0.01;
            }
        }
        if (isSame) {
            return true;
        }
        switch (this.count) {
            default: {
                return true;
            }
            case 2: {
                return this.sameAsIJ(indices, points, 1, 2) && this.sameAsIJ(indices, points, 2, 1);
            }
            case 3: {
                return this.sameAsIJ(indices, points, 1, 3) && this.sameAsIJ(indices, points, 2, 2) && this.sameAsIJ(indices, points, 3, 1);
            }
            case 4: 
        }
        return this.sameAsIJ(indices, points, 1, 4) && this.sameAsIJ(indices, points, 2, 3) && this.sameAsIJ(indices, points, 3, 2) && this.sameAsIJ(indices, points, 4, 1);
    }

    private boolean sameAsIJ(int[] atoms, Point3fi[] points, int i, int j) {
        int ipt = this.countPlusIndices[i];
        int jpt = atoms[j];
        return ipt >= 0 || jpt >= 0 ? ipt == jpt : (double)this.pts[-2 - ipt].distance(points[-2 - jpt]) < 0.01;
    }

    public boolean sameAs(int i, int j) {
        return this.sameAsIJ(this.countPlusIndices, this.pts, i, j);
    }

    public float getPropMeasurement(Point3fi[] pts) {
        if (this.countPlusIndices == null || this.count != 2) {
            return Float.NaN;
        }
        int i = this.count;
        while (--i >= 0) {
            if (this.countPlusIndices[i + 1] >= 0) continue;
            return Float.NaN;
        }
        try {
            Atom ptA = (Atom)(pts == null ? this.getAtom(1) : pts[0]);
            Atom ptB = (Atom)(pts == null ? this.getAtom(2) : pts[1]);
            float[][] props = (float[][])this.vwr.getDataObj(this.property, null, 2);
            int ia = ptA.i;
            int ib = ptB.i;
            return props == null || ib >= props.length || ia >= props.length ? Float.NaN : props[ia][ib];
        }
        catch (Throwable t) {
            return Float.NaN;
        }
    }

    public float getMeasurement(Point3fi[] pts) {
        this.checkJ(null);
        if (!Float.isNaN(this.fixedValue)) {
            return this.fixedValue;
        }
        if (this.property != null) {
            return this.getPropMeasurement(pts);
        }
        if (this.countPlusIndices == null) {
            return Float.NaN;
        }
        if (this.count < 2) {
            return Float.NaN;
        }
        int i = this.count;
        while (--i >= 0) {
            if (this.countPlusIndices[i + 1] != -1) continue;
            return Float.NaN;
        }
        Point3fi ptA = pts == null ? this.getAtom(1) : pts[0];
        Point3fi ptB = pts == null ? this.getAtom(2) : pts[1];
        switch (this.count) {
            case 2: {
                return ptA.distance(ptB);
            }
            case 3: {
                Point3fi ptC = pts == null ? this.getAtom(3) : pts[2];
                return Measure.computeAngleABC(ptA, ptB, ptC, true);
            }
            case 4: {
                Point3fi ptC = pts == null ? this.getAtom(3) : pts[2];
                Point3fi ptD = pts == null ? this.getAtom(4) : pts[3];
                return Measure.computeTorsion(ptA, ptB, ptC, ptD, true);
            }
        }
        return Float.NaN;
    }

    public String getLabel(int i, boolean asBitSet, boolean withModelIndex) {
        int atomIndex = this.countPlusIndices[i];
        return atomIndex < 0 ? (withModelIndex ? "modelIndex " + this.getAtom((int)i).mi + " " : "") + Escape.eP(this.getAtom(i)) : (asBitSet ? "({" + atomIndex + "})" : this.vwr.getAtomInfo(atomIndex));
    }

    public void setModelIndex(short modelIndex) {
        if (this.pts == null) {
            return;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.pts[i] == null) continue;
            this.pts[i].mi = modelIndex;
        }
    }

    public boolean isValid() {
        return !(this.sameAs(1, 2) || this.count > 2 && this.sameAs(1, 3) || this.count == 4 && this.sameAs(2, 4));
    }

    public static int find(Lst<Measurement> measurements, Measurement m) {
        int[] indices = m.countPlusIndices;
        Point3fi[] points = m.pts;
        int i = measurements.size();
        while (--i >= 0) {
            if (!((Measurement)measurements.get(i)).sameAsPoints(indices, points)) continue;
            return i;
        }
        return -1;
    }

    public boolean isConnected(Atom[] atoms, int count) {
        int atomIndexLast = -1;
        for (int i = 1; i <= count; ++i) {
            int atomIndex = this.getAtomIndex(i);
            if (atomIndex < 0) continue;
            if (atomIndexLast >= 0 && !atoms[atomIndex].isBonded(atoms[atomIndexLast])) {
                return false;
            }
            atomIndexLast = atomIndex;
        }
        return true;
    }

    public String getInfoAsString(String units) {
        float f = this.fixValue(units, true);
        SB sb = new SB();
        sb.append(this.count == 2 ? (this.property != null ? this.property : (this.type == null ? "distance" : this.type)) : (this.count == 3 ? "angle" : "dihedral"));
        sb.append(" \t").appendF(f);
        sb.append(" \t").append(PT.esc(this.strMeasurement));
        for (int i = 1; i <= this.count; ++i) {
            sb.append(" \t").append(this.getLabel(i, false, false));
        }
        if (this.thisID != null) {
            sb.append(" \t").append(this.thisID);
        }
        return sb.toString();
    }

    public boolean isInRange(RadiusData radiusData, float value) {
        if (radiusData.factorType == RadiusData.EnumType.FACTOR) {
            Atom atom1 = (Atom)this.getAtom(1);
            Atom atom2 = (Atom)this.getAtom(2);
            float d = (atom1.getVanderwaalsRadiusFloat(this.vwr, radiusData.vdwType) + atom2.getVanderwaalsRadiusFloat(this.vwr, radiusData.vdwType)) * radiusData.value;
            return value <= d;
        }
        return radiusData.values[0] == Float.MAX_VALUE || value >= radiusData.values[0] && value <= radiusData.values[1];
    }

    public boolean isIntramolecular(Atom[] atoms, int count) {
        int molecule = -1;
        for (int i = 1; i <= count; ++i) {
            int atomIndex = this.getAtomIndex(i);
            if (atomIndex < 0) continue;
            int m = atoms[atomIndex].getMoleculeNumber(false);
            if (molecule < 0) {
                molecule = m;
                continue;
            }
            if (m == molecule) continue;
            return false;
        }
        return true;
    }

    public boolean isMin(Map<String, Integer> htMin) {
        String n2;
        Atom a1 = (Atom)this.getAtom(1);
        Atom a2 = (Atom)this.getAtom(2);
        int d = (int)(a2.distanceSquared(a1) * 100.0f);
        String n1 = a1.getAtomName();
        String key = n1.compareTo(n2 = a2.getAtomName()) < 0 ? n1 + n2 : n2 + n1;
        Integer min = htMin.get(key);
        return min != null && d == min;
    }

    public static boolean isUnits(String s) {
        return PT.isOneOf((s.startsWith("+") ? s.substring(1) : s).toLowerCase(), ";nm;nanometers;pm;picometers;angstroms;angstroms;ang;\u00c5;au;vanderwaals;vdw;%;noe;") || s.indexOf(" ") < 0 && s.endsWith("hz");
    }
}

