/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import org.jmol.api.JmolRendererInterface;
import org.jmol.modelset.Text;
import org.jmol.util.Font;

class TextRenderer {
    TextRenderer() {
    }

    static boolean render(Text text, JmolRendererInterface g3d, float scalePixelsPerMicron, float imageFontScaling, boolean isAbsolute, float[] boxXY, float[] temp, boolean doPointer, short pointerColix, int pointerWidth, boolean isAntialiased) {
        if (text == null || text.image == null && !text.doFormatText && text.lines == null) {
            return false;
        }
        boolean showText = g3d.setC(text.colix);
        if (!(showText || text.image != null || text.bgcolix != 0 && g3d.setC(text.bgcolix))) {
            return false;
        }
        text.setPosition(scalePixelsPerMicron, imageFontScaling, isAbsolute, boxXY);
        if (text.image == null) {
            if (text.bgcolix != 0) {
                if (g3d.setC(text.bgcolix)) {
                    TextRenderer.showBox(g3d, text.colix, (int)text.boxX, (int)text.boxY + text.boxYoff2 * 2, text.z + 2, text.zSlab, (int)text.boxWidth, (int)text.boxHeight, text.fontScale, !text.isEcho);
                }
                if (!showText) {
                    return false;
                }
            }
            for (int i = 0; i < text.lines.length; ++i) {
                text.setXYA(temp, i);
                g3d.drawString(text.lines[i], text.font, (int)temp[0], (int)temp[1], text.z, text.zSlab, text.bgcolix);
            }
        } else {
            g3d.drawImage(text.image, (int)text.boxX, (int)text.boxY, text.z, text.zSlab, text.bgcolix, (int)text.boxWidth, (int)text.boxHeight);
        }
        if (!doPointer) {
            return true;
        }
        TextRenderer.drawLineXYZ(g3d, text.atomX, text.atomY, text.atomZ, text.boxX, text.boxY, text.zSlab, text.boxWidth, text.boxHeight, pointerColix, pointerWidth * (isAntialiased ? 2 : 1));
        return true;
    }

    private static void drawLineXYZ(JmolRendererInterface g3d, int x0, int y0, int z0, float x1, float y1, int z1, float w, float h, short pointerColix, int pointerWidth) {
        boolean setY;
        float offsetX = x1 - (float)x0;
        float offsetY = y1 - (float)y0;
        if (offsetX <= 0.0f && -offsetX <= w && offsetY <= 0.0f && -offsetY <= h) {
            return;
        }
        boolean setX = offsetY > 0.0f || offsetY < -h;
        float pt = Float.NaN;
        x1 += setX ? (offsetX > w / 2.0f ? 0.0f : (offsetX < -w * 3.0f / 2.0f ? w : (pt = w / 2.0f))) : (offsetX > 0.0f ? 0.0f : w);
        boolean bl = setY = !Float.isNaN(pt);
        y1 += setY && offsetY > 0.0f ? 0.0f : (setY && offsetY < -h ? h : h / 2.0f);
        if (pointerWidth > 1) {
            g3d.fillCylinderXYZ(pointerColix, pointerColix, (byte)2, pointerWidth, x0, y0, z0, (int)x1, (int)y1, z1);
        } else {
            g3d.setC(pointerColix);
            g3d.drawLineXYZ(x0, y0, z0, (int)x1, (int)y1, z1);
        }
    }

    static void renderSimpleLabel(JmolRendererInterface g3d, Font font, String strLabel, short colix, short bgcolix, float[] boxXY, int z, int zSlab, int xOffset, int yOffset, float ascent, int descent, boolean isAbsolute, boolean doPointer, short pointerColix, int pointerWidth, boolean isAntialiased) {
        float w = font.stringWidth(strLabel) + 8;
        float h = ascent + (float)descent + 8.0f;
        int x0 = (int)boxXY[0];
        int y0 = (int)boxXY[1];
        Text.setBoxXY(w, h, xOffset, yOffset, boxXY, isAbsolute);
        float x = boxXY[0];
        float y = boxXY[1];
        if (bgcolix != 0 && g3d.setC(bgcolix)) {
            TextRenderer.showBox(g3d, colix, (int)x, (int)y, z, zSlab, (int)w, (int)h, 1.0f, true);
        } else {
            g3d.setC(colix);
        }
        g3d.drawString(strLabel, font, (int)(x + 4.0f), (int)(y + 4.0f + ascent), z - 1, zSlab, bgcolix);
        if (doPointer && (xOffset != 0 || yOffset != 0)) {
            TextRenderer.drawLineXYZ(g3d, x0, y0, zSlab, x, y, zSlab, w, h, pointerColix, pointerWidth * (isAntialiased ? 2 : 1));
        }
    }

    private static void showBox(JmolRendererInterface g3d, short colix, int x, int y, int z, int zSlab, int boxWidth, int boxHeight, float imageFontScaling, boolean atomBased) {
        g3d.fillTextRect(x, y, z, zSlab, boxWidth, boxHeight);
        g3d.setC(colix);
        if (!atomBased) {
            return;
        }
        if (imageFontScaling >= 2.0f) {
            g3d.drawRect(x + 3, y + 3, z - 1, zSlab, boxWidth - 6, boxHeight - 6);
        } else {
            g3d.drawRect(x + 1, y + 1, z - 1, zSlab, boxWidth - 2, boxHeight - 2);
        }
    }
}

