/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.T3;
import javajs.util.T4;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.symmetry.Symmetry;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.BoxInfo;
import org.jmol.util.Escape;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Tensor;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

class UnitCell
extends SimpleUnitCell
implements Cloneable {
    private P3[] vertices;
    private P3 fractionalOffset;
    private boolean allFractionalRelative;
    protected final P3 cartesianOffset = new P3();
    protected T3 unitCellMultiplier;
    private UnitCell unitCellMultiplied;
    public Lst<String> moreInfo;
    public String name = "";
    private static final double twoP2 = 19.739208802178716;
    private static final V3[] unitVectors = new V3[]{JC.axisX, JC.axisY, JC.axisZ};

    private UnitCell() {
    }

    static UnitCell fromOABC(T3[] oabc, boolean setRelative) {
        UnitCell c = new UnitCell();
        if (oabc.length == 3) {
            oabc = new T3[]{new P3(), oabc[0], oabc[1], oabc[2]};
        }
        float[] parameters = new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, oabc[1].x, oabc[1].y, oabc[1].z, oabc[2].x, oabc[2].y, oabc[2].z, oabc[3].x, oabc[3].y, oabc[3].z};
        c.init(parameters);
        c.allFractionalRelative = setRelative;
        c.initUnitcellVertices();
        c.setCartesianOffset(oabc[0]);
        return c;
    }

    public static UnitCell fromParams(float[] params, boolean setRelative) {
        UnitCell c = new UnitCell();
        c.init(params);
        c.initUnitcellVertices();
        c.allFractionalRelative = setRelative;
        return c;
    }

    void initOrientation(M3 mat) {
        if (mat == null) {
            return;
        }
        M4 m = new M4();
        m.setToM3(mat);
        this.matrixFractionalToCartesian.mul2(m, this.matrixFractionalToCartesian);
        this.matrixCartesianToFractional.setM4(this.matrixFractionalToCartesian).invert();
        this.initUnitcellVertices();
    }

    final void toUnitCell(T3 pt, T3 offset) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        if (offset == null) {
            this.matrixCartesianToFractional.rotTrans(pt);
            this.unitize(pt);
            this.matrixFractionalToCartesian.rotTrans(pt);
        } else {
            this.matrixCtoFNoOffset.rotTrans(pt);
            this.unitize(pt);
            pt.add(offset);
            this.matrixFtoCNoOffset.rotTrans(pt);
        }
    }

    public void unitize(T3 pt) {
        UnitCell.unitizeDim(this.dimension, pt);
    }

    public void reset() {
        this.unitCellMultiplier = null;
        this.unitCellMultiplied = null;
        this.setOffset(P3.new3(0.0f, 0.0f, 0.0f));
    }

    void setOffset(T3 pt) {
        boolean isCell555P4;
        if (pt == null) {
            return;
        }
        this.unitCellMultiplied = null;
        T4 pt4 = pt instanceof T4 ? (T4)pt : null;
        float w = pt4 == null ? Float.MIN_VALUE : pt4.w;
        boolean bl = isCell555P4 = w > 999999.0f;
        if (pt4 != null ? w <= 0.0f || isCell555P4 : pt.x >= 100.0f || pt.y >= 100.0f) {
            this.unitCellMultiplier = pt.z == 0.0f && pt.x == pt.y && !isCell555P4 ? null : (isCell555P4 ? P4.newPt((P4)pt4) : P3.newP(pt));
            this.unitCellMultiplied = null;
            if (pt4 == null || pt4.w == 0.0f || isCell555P4) {
                return;
            }
        }
        if (this.hasOffset() || pt.lengthSquared() > 0.0f) {
            this.fractionalOffset = new P3();
            this.fractionalOffset.setT(pt);
        }
        this.matrixCartesianToFractional.m03 = -pt.x;
        this.matrixCartesianToFractional.m13 = -pt.y;
        this.matrixCartesianToFractional.m23 = -pt.z;
        this.cartesianOffset.setT(pt);
        this.matrixFractionalToCartesian.m03 = 0.0f;
        this.matrixFractionalToCartesian.m13 = 0.0f;
        this.matrixFractionalToCartesian.m23 = 0.0f;
        this.matrixFractionalToCartesian.rotTrans(this.cartesianOffset);
        this.matrixFractionalToCartesian.m03 = this.cartesianOffset.x;
        this.matrixFractionalToCartesian.m13 = this.cartesianOffset.y;
        this.matrixFractionalToCartesian.m23 = this.cartesianOffset.z;
        if (this.allFractionalRelative) {
            this.matrixCtoFNoOffset.setM4(this.matrixCartesianToFractional);
            this.matrixFtoCNoOffset.setM4(this.matrixFractionalToCartesian);
        }
    }

    private void setCartesianOffset(T3 origin) {
        this.cartesianOffset.setT(origin);
        this.matrixFractionalToCartesian.m03 = this.cartesianOffset.x;
        this.matrixFractionalToCartesian.m13 = this.cartesianOffset.y;
        this.matrixFractionalToCartesian.m23 = this.cartesianOffset.z;
        boolean wasOffset = this.hasOffset();
        this.fractionalOffset = new P3();
        this.fractionalOffset.setT(this.cartesianOffset);
        this.matrixCartesianToFractional.m03 = 0.0f;
        this.matrixCartesianToFractional.m13 = 0.0f;
        this.matrixCartesianToFractional.m23 = 0.0f;
        this.matrixCartesianToFractional.rotTrans(this.fractionalOffset);
        this.matrixCartesianToFractional.m03 = -this.fractionalOffset.x;
        this.matrixCartesianToFractional.m13 = -this.fractionalOffset.y;
        this.matrixCartesianToFractional.m23 = -this.fractionalOffset.z;
        if (this.allFractionalRelative) {
            this.matrixCtoFNoOffset.setM4(this.matrixCartesianToFractional);
            this.matrixFtoCNoOffset.setM4(this.matrixFractionalToCartesian);
        }
        if (!wasOffset && this.fractionalOffset.lengthSquared() == 0.0f) {
            this.fractionalOffset = null;
        }
    }

    Map<String, Object> getInfo() {
        UnitCell m = this.getUnitCellMultiplied();
        if (m != this) {
            return m.getInfo();
        }
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("params", this.unitCellParams);
        info.put("oabc", this.getUnitCellVectors());
        info.put("volume", this.volume);
        info.put("matFtoC", this.matrixFractionalToCartesian);
        info.put("matCtoF", this.matrixCartesianToFractional);
        return info;
    }

    String dumpInfo(boolean isDebug, boolean multiplied) {
        UnitCell m;
        UnitCell unitCell = m = multiplied ? this.getUnitCellMultiplied() : this;
        if (m != this) {
            return m.dumpInfo(isDebug, false);
        }
        return "a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", alpha=" + this.alpha + ", beta=" + this.beta + ", gamma=" + this.gamma + "\noabc=" + Escape.eAP(this.getUnitCellVectors()) + "\nvolume=" + this.volume + (isDebug ? "\nfractional to cartesian: " + this.matrixFractionalToCartesian + "\ncartesian to fractional: " + this.matrixCartesianToFractional : "");
    }

    UnitCell getUnitCellMultiplied() {
        if (this.unitCellMultiplier == null || this.unitCellMultiplier.z > 0.0f && this.unitCellMultiplier.z == (float)((int)this.unitCellMultiplier.z)) {
            return this;
        }
        if (this.unitCellMultiplied == null) {
            T3[] pts = BoxInfo.toOABC(this.getScaledCell(true), null);
            this.unitCellMultiplied = UnitCell.fromOABC(pts, false);
        }
        return this.unitCellMultiplied;
    }

    P3[] getVertices() {
        return this.vertices;
    }

    P3 getCartesianOffset() {
        return this.cartesianOffset;
    }

    P3 getFractionalOffset() {
        return this.fractionalOffset;
    }

    Tensor getTensor(Viewer vwr, float[] parBorU) {
        Tensor t = (Tensor)Interface.getUtil("Tensor", vwr, "file");
        if (parBorU[0] == 0.0f && parBorU[1] == 0.0f && parBorU[2] == 0.0f) {
            float f = parBorU[7];
            float[] eigenValues = new float[]{f, f, f};
            return t.setFromEigenVectors(unitVectors, eigenValues, "iso", "Uiso=" + f, null);
        }
        t.parBorU = parBorU;
        double[] Bcart = new double[6];
        int ortepType = (int)parBorU[6];
        if (ortepType == 12) {
            Bcart[0] = (double)parBorU[0] * 19.739208802178716;
            Bcart[1] = (double)parBorU[1] * 19.739208802178716;
            Bcart[2] = (double)parBorU[2] * 19.739208802178716;
            Bcart[3] = (double)parBorU[3] * 19.739208802178716 * 2.0;
            Bcart[4] = (double)parBorU[4] * 19.739208802178716 * 2.0;
            Bcart[5] = (double)parBorU[5] * 19.739208802178716 * 2.0;
            parBorU[7] = (parBorU[0] + parBorU[1] + parBorU[3]) / 3.0f;
        } else {
            boolean isFractional = ortepType == 4 || ortepType == 5 || ortepType == 8 || ortepType == 9;
            double cc = 2 - ortepType % 2;
            double dd = ortepType == 8 || ortepType == 9 || ortepType == 10 ? 19.739208802178716 : (ortepType == 4 || ortepType == 5 ? 0.25 : (ortepType == 2 || ortepType == 3 ? Math.log(2.0) : 1.0));
            double B11 = (double)parBorU[0] * dd * (isFractional ? this.a_ * this.a_ : 1.0);
            double B22 = (double)parBorU[1] * dd * (isFractional ? this.b_ * this.b_ : 1.0);
            double B33 = (double)parBorU[2] * dd * (isFractional ? this.c_ * this.c_ : 1.0);
            double B12 = (double)parBorU[3] * dd * (isFractional ? this.a_ * this.b_ : 1.0) * cc;
            double B13 = (double)parBorU[4] * dd * (isFractional ? this.a_ * this.c_ : 1.0) * cc;
            double B23 = (double)parBorU[5] * dd * (isFractional ? this.b_ * this.c_ : 1.0) * cc;
            parBorU[7] = (float)Math.pow(B11 / 19.739208802178716 / this.a_ / this.a_ * B22 / 19.739208802178716 / this.b_ / this.b_ * B33 / 19.739208802178716 / this.c_ / this.c_, 0.3333);
            Bcart[0] = (double)(this.a * this.a) * B11 + (double)(this.b * this.b) * this.cosGamma * this.cosGamma * B22 + (double)(this.c * this.c) * this.cosBeta * this.cosBeta * B33 + (double)(this.a * this.b) * this.cosGamma * B12 + (double)(this.b * this.c) * this.cosGamma * this.cosBeta * B23 + (double)(this.a * this.c) * this.cosBeta * B13;
            Bcart[1] = (double)(this.b * this.b) * this.sinGamma * this.sinGamma * B22 + (double)(this.c * this.c) * this.cA_ * this.cA_ * B33 + (double)(this.b * this.c) * this.cA_ * this.sinGamma * B23;
            Bcart[2] = (double)(this.c * this.c) * this.cB_ * this.cB_ * B33;
            Bcart[3] = (double)(2.0f * this.b * this.b) * this.cosGamma * this.sinGamma * B22 + (double)(2.0f * this.c * this.c) * this.cA_ * this.cosBeta * B33 + (double)(this.a * this.b) * this.sinGamma * B12 + (double)(this.b * this.c) * (this.cA_ * this.cosGamma + this.sinGamma * this.cosBeta) * B23 + (double)(this.a * this.c) * this.cA_ * B13;
            Bcart[4] = (double)(2.0f * this.c * this.c) * this.cB_ * this.cosBeta * B33 + (double)(this.b * this.c) * this.cosGamma * B23 + (double)(this.a * this.c) * this.cB_ * B13;
            Bcart[5] = (double)(2.0f * this.c * this.c) * this.cA_ * this.cB_ * B33 + (double)(this.b * this.c) * this.cB_ * this.sinGamma * B23;
        }
        return t.setFromThermalEquation(Bcart, Escape.eAF(parBorU));
    }

    P3[] getCanonicalCopy(float scale, boolean withOffset) {
        P3[] pts = this.getScaledCell(withOffset);
        return BoxInfo.getCanonicalCopy(pts, scale);
    }

    public P3[] getScaledCell(boolean withOffset) {
        P3[] pts = new P3[8];
        P3 cell0 = null;
        P3 cell1 = null;
        if (withOffset && this.unitCellMultiplier != null && this.unitCellMultiplier.z == 0.0f) {
            cell0 = new P3();
            cell1 = new P3();
            UnitCell.ijkToPoint3f((int)this.unitCellMultiplier.x, cell0, 0, 0);
            UnitCell.ijkToPoint3f((int)this.unitCellMultiplier.y, cell1, 0, 0);
            cell1.sub(cell0);
        }
        float scale = this.unitCellMultiplier == null || this.unitCellMultiplier.z == 0.0f ? 1.0f : Math.abs(this.unitCellMultiplier.z);
        for (int i = 0; i < 8; ++i) {
            P3 pt = pts[i] = P3.newP(BoxInfo.unitCubePoints[i]);
            if (cell0 != null) {
                pts[i].add3(cell0.x + cell1.x * pt.x, cell0.y + cell1.y * pt.y, cell0.z + cell1.z * pt.z);
            }
            pts[i].scale(scale);
            this.matrixFractionalToCartesian.rotTrans(pt);
            if (withOffset) continue;
            pt.sub(this.cartesianOffset);
        }
        return pts;
    }

    private void initUnitcellVertices() {
        if (this.matrixFractionalToCartesian == null) {
            return;
        }
        this.matrixCtoFNoOffset = M4.newM4(this.matrixCartesianToFractional);
        this.matrixFtoCNoOffset = M4.newM4(this.matrixFractionalToCartesian);
        this.vertices = new P3[8];
        int i = 8;
        while (--i >= 0) {
            this.vertices[i] = (P3)this.matrixFractionalToCartesian.rotTrans2(BoxInfo.unitCubePoints[i], new P3());
        }
    }

    public boolean checkDistance(P3 f1, P3 f2, float distance, float dx, int iRange, int jRange, int kRange, P3 ptOffset) {
        P3 p1 = P3.newP(f1);
        this.toCartesian(p1, true);
        for (int i = -iRange; i <= iRange; ++i) {
            for (int j = -jRange; j <= jRange; ++j) {
                for (int k = -kRange; k <= kRange; ++k) {
                    ptOffset.set(f2.x + (float)i, f2.y + (float)j, f2.z + (float)k);
                    this.toCartesian(ptOffset, true);
                    float d = p1.distance(ptOffset);
                    if (!(dx > 0.0f ? Math.abs(d - distance) <= dx : d <= distance && d > 0.1f)) continue;
                    ptOffset.set(i, j, k);
                    return true;
                }
            }
        }
        return false;
    }

    public T3 getUnitCellMultiplier() {
        return this.unitCellMultiplier;
    }

    public P3[] getUnitCellVectors() {
        M4 m = this.matrixFractionalToCartesian;
        return new P3[]{P3.newP(this.cartesianOffset), P3.new3(this.fix(m.m00), this.fix(m.m10), this.fix(m.m20)), P3.new3(this.fix(m.m01), this.fix(m.m11), this.fix(m.m21)), P3.new3(this.fix(m.m02), this.fix(m.m12), this.fix(m.m22))};
    }

    private float fix(float x) {
        return Math.abs(x) < 0.001f ? 0.0f : x;
    }

    public boolean isSameAs(UnitCell uc) {
        if (uc.unitCellParams.length != this.unitCellParams.length) {
            return false;
        }
        int i = this.unitCellParams.length;
        while (--i >= 0) {
            if (this.unitCellParams[i] == uc.unitCellParams[i] || Float.isNaN(this.unitCellParams[i]) && Float.isNaN(uc.unitCellParams[i])) continue;
            return false;
        }
        return this.fractionalOffset == null ? !uc.hasOffset() : (uc.fractionalOffset == null ? !this.hasOffset() : this.fractionalOffset.distanceSquared(uc.fractionalOffset) == 0.0f);
    }

    public boolean hasOffset() {
        return this.fractionalOffset != null && this.fractionalOffset.lengthSquared() != 0.0f;
    }

    public String getState() {
        String s = "";
        if (this.fractionalOffset != null && this.fractionalOffset.lengthSquared() != 0.0f) {
            s = s + "  unitcell offset " + Escape.eP(this.fractionalOffset) + ";\n";
        }
        if (this.unitCellMultiplier != null) {
            s = s + "  unitcell range " + UnitCell.escapeMultiplier(this.unitCellMultiplier) + ";\n";
        }
        return s;
    }

    public Quat getQuaternionRotation(String abc) {
        V3 v2;
        V3 v1;
        int mul;
        V3 a = V3.newVsub(this.vertices[4], this.vertices[0]);
        V3 b = V3.newVsub(this.vertices[2], this.vertices[0]);
        V3 c = V3.newVsub(this.vertices[1], this.vertices[0]);
        V3 x = new V3();
        V3 v = new V3();
        int n = mul = abc.charAt(0) == '-' ? -1 : 1;
        if (mul < 0) {
            abc = abc.substring(1);
        }
        int quadrant = 0;
        if (abc.length() == 2) {
            quadrant = abc.charAt(1) - 48;
            abc = abc.substring(0, 1);
        }
        boolean isEven = quadrant % 2 == 0;
        int axis = "abc".indexOf(abc);
        switch (axis) {
            default: {
                v1 = a;
                v2 = c;
                if (quadrant <= 0 || mul > 0 != isEven) break;
                v2 = b;
                v1.scale(-1.0f);
                break;
            }
            case 1: {
                v1 = b;
                v2 = a;
                if (quadrant <= 0 || mul > 0 != isEven) break;
                v2 = c;
                v1.scale(-1.0f);
                break;
            }
            case 2: {
                v1 = c;
                v2 = a;
                if (quadrant <= 0) break;
                quadrant = 5 - quadrant;
                if (mul > 0 == isEven) break;
                v2 = b;
                v1.scale(-1.0f);
            }
        }
        switch (quadrant) {
            default: {
                break;
            }
            case 2: {
                v1.scale(-1.0f);
                v2.scale(-1.0f);
                break;
            }
            case 3: {
                v2.scale(-1.0f);
                break;
            }
            case 4: {
                v1.scale(-1.0f);
            }
        }
        x.cross(v1, v2);
        v.cross(x, v1);
        return Quat.getQuaternionFrame(null, v, x).inv();
    }

    public T3[] getV0abc(Object def) {
        M4 m;
        if (def instanceof T3[]) {
            return (T3[])def;
        }
        boolean isRev = false;
        T3[] pts = new V3[4];
        V3 pt = pts[0] = V3.new3(0.0f, 0.0f, 0.0f);
        pts[1] = V3.new3(1.0f, 0.0f, 0.0f);
        pts[2] = V3.new3(0.0f, 1.0f, 0.0f);
        pts[3] = V3.new3(0.0f, 0.0f, 1.0f);
        M3 m3 = new M3();
        if (def instanceof String) {
            String sdef = (String)def;
            String strans = "0,0,0";
            if (sdef.indexOf("a=") == 0) {
                return UnitCell.setOabc(sdef, null, pts);
            }
            int ptc = sdef.indexOf(";");
            if (ptc >= 0) {
                strans = sdef.substring(ptc + 1);
                sdef = sdef.substring(0, ptc);
            }
            if (isRev = (sdef = sdef + ";0,0,0").startsWith("!")) {
                sdef = sdef.substring(1);
            }
            Symmetry symTemp = new Symmetry();
            symTemp.setSpaceGroup(false);
            int i = symTemp.addSpaceGroupOperation("=" + sdef, 0);
            if (i < 0) {
                return null;
            }
            m = symTemp.getSpaceGroupOperation(i);
            ((SymmetryOperation)m).doFinalize();
            if (strans != null) {
                String[] atrans = PT.split(strans, ",");
                float[] ftrans = new float[3];
                if (atrans.length == 3) {
                    for (int j = 0; j < 3; ++j) {
                        String s = atrans[j];
                        int sfpt = s.indexOf("/");
                        ftrans[j] = sfpt >= 0 ? PT.parseFloat(s.substring(0, sfpt)) / PT.parseFloat(s.substring(sfpt + 1)) : PT.parseFloat(s);
                    }
                }
                P3 ptrans = P3.new3(ftrans[0], ftrans[1], ftrans[2]);
                m.setTranslation(ptrans);
            }
        } else if (def instanceof M3) {
            m = M4.newMV((M3)def, new P3());
        } else if (def instanceof M4) {
            m = (M4)def;
        } else {
            M4 m2 = (M4)((Object[])def)[0];
            m2.getRotationScale(m3);
            this.toCartesian(pt, false);
            m2.rotTrans(pt);
            for (int i = 1; i < 4; ++i) {
                this.toCartesian(pts[i], true);
                m3.rotate(pts[i]);
            }
            return pts;
        }
        m.getRotationScale(m3);
        m.getTranslation(pt);
        if (isRev) {
            m3.invert();
            m3.transpose();
            m3.rotate(pt);
            pt.scale(-1.0f);
        } else {
            m3.transpose();
        }
        this.toCartesian(pt, false);
        for (int i = 1; i < 4; ++i) {
            m3.rotate(pts[i]);
            this.toCartesian(pts[i], true);
        }
        return pts;
    }

    public boolean toFromPrimitive(boolean toPrimitive, char type, T3[] uc, M3 primitiveToCrystal) {
        int offset = uc.length - 3;
        M3 mf = null;
        if (type == 'r' || primitiveToCrystal == null) {
            switch (type) {
                default: {
                    return false;
                }
                case 'r': {
                    UnitCell.getReciprocal(uc, uc, 1.0f);
                    return true;
                }
                case 'P': {
                    toPrimitive = true;
                    mf = M3.newA9(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f});
                    break;
                }
                case 'A': {
                    mf = M3.newA9(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.0f, -0.5f, 0.5f});
                    break;
                }
                case 'B': {
                    mf = M3.newA9(new float[]{0.5f, 0.0f, 0.5f, 0.0f, 1.0f, 0.0f, -0.5f, 0.0f, 0.5f});
                    break;
                }
                case 'C': {
                    mf = M3.newA9(new float[]{0.5f, 0.5f, 0.0f, -0.5f, 0.5f, 0.0f, 0.0f, 0.0f, 1.0f});
                    break;
                }
                case 'R': {
                    mf = M3.newA9(new float[]{0.6666667f, -0.33333334f, -0.33333334f, 0.33333334f, 0.33333334f, -0.6666667f, 0.33333334f, 0.33333334f, 0.33333334f});
                    break;
                }
                case 'I': {
                    mf = M3.newA9(new float[]{-0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, -0.5f});
                    break;
                }
                case 'F': {
                    mf = M3.newA9(new float[]{0.0f, 0.5f, 0.5f, 0.5f, 0.0f, 0.5f, 0.5f, 0.5f, 0.0f});
                }
            }
            if (!toPrimitive) {
                mf.invert();
            }
        } else {
            mf = M3.newM3(primitiveToCrystal);
            if (toPrimitive) {
                mf.invert();
            }
        }
        int i = uc.length;
        while (--i >= offset) {
            T3 p = uc[i];
            this.toFractional(p, false);
            mf.rotate(p);
            this.toCartesian(p, false);
        }
        return true;
    }

    public T3[] getConventionalUnitCell(String latticeType, M3 primitiveToCrystal) {
        T3[] oabc = this.getUnitCellVectors();
        if (!latticeType.equals("P") || primitiveToCrystal != null) {
            this.toFromPrimitive(false, latticeType.charAt(0), oabc, primitiveToCrystal);
        }
        return oabc;
    }

    public static UnitCell cloneUnitCell(UnitCell uc) {
        UnitCell ucnew = null;
        try {
            ucnew = (UnitCell)uc.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return ucnew;
    }
}

