/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.P3;
import javajs.util.PT;
import org.jmol.api.EventManager;
import org.jmol.api.Interface;
import org.jmol.i18n.GT;
import org.jmol.modelset.MeasurementPending;
import org.jmol.script.SV;
import org.jmol.script.ScriptEval;
import org.jmol.thread.HoverWatcherThread;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Point3fi;
import org.jmol.util.Rectangle;
import org.jmol.viewer.Gesture;
import org.jmol.viewer.MouseState;
import org.jmol.viewer.Viewer;
import org.jmol.viewer.binding.Binding;
import org.jmol.viewer.binding.JmolBinding;

public class ActionManager
implements EventManager {
    protected Viewer vwr;
    protected boolean haveMultiTouchInput;
    protected boolean isMultiTouch;
    public Binding b;
    private Binding jmolBinding;
    private Binding pfaatBinding;
    private Binding dragBinding;
    private Binding rasmolBinding;
    private Binding predragBinding;
    private int LEFT_DRAGGED;
    protected Thread hoverWatcherThread;
    private Gesture dragGesture;
    public static final int ACTION_assignNew = 0;
    public static final int ACTION_center = 1;
    public static final int ACTION_clickFrank = 2;
    public static final int ACTION_connectAtoms = 3;
    public static final int ACTION_deleteAtom = 4;
    public static final int ACTION_deleteBond = 5;
    public static final int ACTION_depth = 6;
    public static final int ACTION_dragAtom = 7;
    public static final int ACTION_dragDrawObject = 8;
    public static final int ACTION_dragDrawPoint = 9;
    public static final int ACTION_dragLabel = 10;
    public static final int ACTION_dragMinimize = 11;
    public static final int ACTION_dragMinimizeMolecule = 12;
    public static final int ACTION_dragSelected = 13;
    public static final int ACTION_dragZ = 14;
    public static final int ACTION_multiTouchSimulation = 15;
    public static final int ACTION_navTranslate = 16;
    public static final int ACTION_pickAtom = 17;
    public static final int ACTION_pickIsosurface = 18;
    public static final int ACTION_pickLabel = 19;
    public static final int ACTION_pickMeasure = 20;
    public static final int ACTION_pickNavigate = 21;
    public static final int ACTION_pickPoint = 22;
    public static final int ACTION_popupMenu = 23;
    public static final int ACTION_reset = 24;
    public static final int ACTION_rotate = 25;
    public static final int ACTION_rotateBranch = 26;
    public static final int ACTION_rotateSelected = 27;
    public static final int ACTION_rotateZ = 28;
    public static final int ACTION_rotateZorZoom = 29;
    public static final int ACTION_select = 30;
    public static final int ACTION_selectAndDrag = 31;
    public static final int ACTION_selectAndNot = 32;
    public static final int ACTION_selectNone = 33;
    public static final int ACTION_selectOr = 34;
    public static final int ACTION_selectToggle = 35;
    public static final int ACTION_selectToggleExtended = 36;
    public static final int ACTION_setMeasure = 37;
    public static final int ACTION_slab = 38;
    public static final int ACTION_slabAndDepth = 39;
    public static final int ACTION_slideZoom = 40;
    public static final int ACTION_spinDrawObjectCCW = 41;
    public static final int ACTION_spinDrawObjectCW = 42;
    public static final int ACTION_stopMotion = 43;
    public static final int ACTION_swipe = 44;
    public static final int ACTION_translate = 45;
    public static final int ACTION_wheelZoom = 46;
    public static final int ACTION_count = 47;
    static final String[] actionInfo = new String[47];
    static final String[] actionNames = new String[47];
    private int apm = 1;
    private int bondPickingMode;
    public static final int PICKING_MK_RESET = -1;
    public static final int PICKING_OFF = 0;
    public static final int PICKING_IDENTIFY = 1;
    public static final int PICKING_LABEL = 2;
    public static final int PICKING_CENTER = 3;
    public static final int PICKING_DRAW = 4;
    public static final int PICKING_SPIN = 5;
    public static final int PICKING_SYMMETRY = 6;
    public static final int PICKING_DELETE_ATOM = 7;
    public static final int PICKING_DELETE_BOND = 8;
    public static final int PICKING_SELECT_ATOM = 9;
    public static final int PICKING_SELECT_GROUP = 10;
    public static final int PICKING_SELECT_CHAIN = 11;
    public static final int PICKING_SELECT_MOLECULE = 12;
    public static final int PICKING_SELECT_POLYMER = 13;
    public static final int PICKING_SELECT_STRUCTURE = 14;
    public static final int PICKING_SELECT_SITE = 15;
    public static final int PICKING_SELECT_MODEL = 16;
    public static final int PICKING_SELECT_ELEMENT = 17;
    public static final int PICKING_MEASURE = 18;
    public static final int PICKING_MEASURE_DISTANCE = 19;
    public static final int PICKING_MEASURE_ANGLE = 20;
    public static final int PICKING_MEASURE_TORSION = 21;
    public static final int PICKING_MEASURE_SEQUENCE = 22;
    public static final int PICKING_NAVIGATE = 23;
    public static final int PICKING_CONNECT = 24;
    public static final int PICKING_STRUTS = 25;
    public static final int PICKING_DRAG_SELECTED = 26;
    public static final int PICKING_DRAG_MOLECULE = 27;
    public static final int PICKING_DRAG_ATOM = 28;
    public static final int PICKING_DRAG_MINIMIZE = 29;
    public static final int PICKING_DRAG_MINIMIZE_MOLECULE = 30;
    public static final int PICKING_INVERT_STEREO = 31;
    public static final int PICKING_ASSIGN_ATOM = 32;
    public static final int PICKING_ASSIGN_BOND = 33;
    public static final int PICKING_ROTATE_BOND = 34;
    public static final int PICKING_IDENTIFY_BOND = 35;
    public static final int PICKING_DRAG_LIGAND = 36;
    public static final int PICKING_DRAG_MODEL = 37;
    public static final int PICKINGSTYLE_SELECT_JMOL = 0;
    public static final int PICKINGSTYLE_SELECT_CHIME = 0;
    public static final int PICKINGSTYLE_SELECT_RASMOL = 1;
    public static final int PICKINGSTYLE_SELECT_PFAAT = 2;
    public static final int PICKINGSTYLE_SELECT_DRAG = 3;
    public static final int PICKINGSTYLE_MEASURE_ON = 4;
    public static final int PICKINGSTYLE_MEASURE_OFF = 5;
    private static final String[] pickingModeNames = "off identify label center draw spin symmetry deleteatom deletebond atom group chain molecule polymer structure site model element measure distance angle torsion sequence navigate connect struts dragselected dragmolecule dragatom dragminimize dragminimizemolecule invertstereo assignatom assignbond rotatebond identifybond dragligand dragmodel".split(" ");
    private static final String[] pickingStyleNames = "toggle selectOrToggle extendedSelect drag measure measureoff".split(" ");
    private int pickingStyle;
    private int pickingStyleSelect = 0;
    private int pickingStyleMeasure = 5;
    private int rootPickingStyle = 0;
    private static final long MAX_DOUBLE_CLICK_MILLIS = 700L;
    protected static final long MININUM_GESTURE_DELAY_MILLISECONDS = 10L;
    private static final int SLIDE_ZOOM_X_PERCENT = 98;
    public static final float DEFAULT_MOUSE_DRAG_FACTOR = 1.0f;
    public static final float DEFAULT_MOUSE_WHEEL_FACTOR = 1.15f;
    public static final float DEFAULT_GESTURE_SWIPE_FACTOR = 1.0f;
    public static final int XY_RANGE = 10;
    private float gestureSwipeFactor = 1.0f;
    protected float mouseDragFactor = 1.0f;
    protected float mouseWheelFactor = 1.15f;
    protected final MouseState current = new MouseState("current");
    protected final MouseState moved = new MouseState("moved");
    private final MouseState clicked = new MouseState("clicked");
    private final MouseState pressed = new MouseState("pressed");
    private final MouseState dragged = new MouseState("dragged");
    protected int pressedCount;
    protected int clickedCount;
    private boolean drawMode;
    private boolean labelMode;
    private boolean dragSelectedMode;
    private boolean measuresEnabled = true;
    private boolean haveSelection;
    private boolean hoverActive = false;
    private MeasurementPending mp;
    private int dragAtomIndex = -1;
    private boolean mkBondPressed;
    private boolean rubberbandSelectionMode = false;
    private final Rectangle rectRubber = new Rectangle();
    private boolean isAltKeyReleased = true;
    private boolean keyProcessing;
    protected boolean isMultiTouchClient;
    protected boolean isMultiTouchServer;
    private int pressAction;
    private int dragAction;
    private int clickAction;
    private MeasurementPending measurementQueued;
    public boolean zoomTrigger;
    private boolean selectionWorking = false;

    public void setViewer(Viewer vwr, String commandOptions) {
        this.vwr = vwr;
        if (!Viewer.isJS) {
            this.createActions();
        }
        this.jmolBinding = new JmolBinding();
        this.setBinding(this.jmolBinding);
        this.LEFT_DRAGGED = Binding.getMouseAction(1, 16, 1);
        this.dragGesture = new Gesture(20, vwr);
    }

    public void checkHover() {
        if (this.zoomTrigger) {
            this.zoomTrigger = false;
            if (this.vwr.currentCursor == 8) {
                this.vwr.setCursor(0);
            }
            this.vwr.setInMotion(false);
            return;
        }
        if (!(this.vwr.getInMotion(true) || this.vwr.tm.spinOn || this.vwr.tm.navOn || this.vwr.checkObjectHovered(this.current.x, this.current.y))) {
            int atomIndex = this.vwr.findNearestAtomIndex(this.current.x, this.current.y);
            if (atomIndex < 0) {
                return;
            }
            boolean isLabel = this.apm == 2 && this.bnd(Binding.getMouseAction(this.clickedCount, this.moved.modifiers, 1), 10);
            this.vwr.hoverOn(atomIndex, isLabel);
        }
    }

    public void processMultitouchEvent(int groupID, int eventType, int touchID, int iData, P3 pt, long time) {
    }

    void bind(String desc, String name) {
        int jmolAction = ActionManager.getActionFromName(name);
        int mouseAction = Binding.getMouseActionStr(desc);
        if (mouseAction == 0) {
            return;
        }
        if (jmolAction >= 0) {
            this.b.bindAction(mouseAction, jmolAction);
        } else {
            this.b.bindName(mouseAction, name);
        }
    }

    protected void clearBindings() {
        this.jmolBinding = new JmolBinding();
        this.setBinding(this.jmolBinding);
        this.pfaatBinding = null;
        this.dragBinding = null;
        this.rasmolBinding = null;
    }

    void unbindAction(String desc, String name) {
        if (desc == null && name == null) {
            this.clearBindings();
            return;
        }
        int jmolAction = ActionManager.getActionFromName(name);
        int mouseAction = Binding.getMouseActionStr(desc);
        if (jmolAction >= 0) {
            this.b.unbindAction(mouseAction, jmolAction);
        } else if (mouseAction != 0) {
            this.b.unbindName(mouseAction, name);
        }
        if (name == null) {
            this.b.unbindUserAction(desc);
        }
    }

    static void newAction(int i, String name, String info) {
        ActionManager.actionInfo[i] = info;
        ActionManager.actionNames[i] = name;
    }

    void createActions() {
        if (actionInfo[0] != null) {
            return;
        }
        ActionManager.newAction(0, "_assignNew", GT.o(GT.$("assign/new atom or bond (requires {0})"), "set picking assignAtom_??/assignBond_?"));
        ActionManager.newAction(1, "_center", GT.$("center"));
        ActionManager.newAction(2, "_clickFrank", GT.$("pop up recent context menu (click on Jmol frank)"));
        ActionManager.newAction(4, "_deleteAtom", GT.o(GT.$("delete atom (requires {0})"), "set picking DELETE ATOM"));
        ActionManager.newAction(5, "_deleteBond", GT.o(GT.$("delete bond (requires {0})"), "set picking DELETE BOND"));
        ActionManager.newAction(6, "_depth", GT.o(GT.$("adjust depth (back plane; requires {0})"), "SLAB ON"));
        ActionManager.newAction(7, "_dragAtom", GT.o(GT.$("move atom (requires {0})"), "set picking DRAGATOM"));
        ActionManager.newAction(8, "_dragDrawObject", GT.o(GT.$("move whole DRAW object (requires {0})"), "set picking DRAW"));
        ActionManager.newAction(9, "_dragDrawPoint", GT.o(GT.$("move specific DRAW point (requires {0})"), "set picking DRAW"));
        ActionManager.newAction(10, "_dragLabel", GT.o(GT.$("move label (requires {0})"), "set picking LABEL"));
        ActionManager.newAction(11, "_dragMinimize", GT.o(GT.$("move atom and minimize molecule (requires {0})"), "set picking DRAGMINIMIZE"));
        ActionManager.newAction(12, "_dragMinimizeMolecule", GT.o(GT.$("move and minimize molecule (requires {0})"), "set picking DRAGMINIMIZEMOLECULE"));
        ActionManager.newAction(13, "_dragSelected", GT.o(GT.$("move selected atoms (requires {0})"), "set DRAGSELECTED"));
        ActionManager.newAction(14, "_dragZ", GT.o(GT.$("drag atoms in Z direction (requires {0})"), "set DRAGSELECTED"));
        ActionManager.newAction(15, "_multiTouchSimulation", GT.$("simulate multi-touch using the mouse)"));
        ActionManager.newAction(16, "_navTranslate", GT.o(GT.$("translate navigation point (requires {0} and {1})"), new String[]{"set NAVIGATIONMODE", "set picking NAVIGATE"}));
        ActionManager.newAction(17, "_pickAtom", GT.$("pick an atom"));
        ActionManager.newAction(3, "_pickConnect", GT.o(GT.$("connect atoms (requires {0})"), "set picking CONNECT"));
        ActionManager.newAction(18, "_pickIsosurface", GT.o(GT.$("pick an ISOSURFACE point (requires {0}"), "set DRAWPICKING"));
        ActionManager.newAction(19, "_pickLabel", GT.o(GT.$("pick a label to toggle it hidden/displayed (requires {0})"), "set picking LABEL"));
        ActionManager.newAction(20, "_pickMeasure", GT.o(GT.$("pick an atom to include it in a measurement (after starting a measurement or after {0})"), "set picking DISTANCE/ANGLE/TORSION"));
        ActionManager.newAction(21, "_pickNavigate", GT.o(GT.$("pick a point or atom to navigate to (requires {0})"), "set NAVIGATIONMODE"));
        ActionManager.newAction(22, "_pickPoint", GT.o(GT.$("pick a DRAW point (for measurements) (requires {0}"), "set DRAWPICKING"));
        ActionManager.newAction(23, "_popupMenu", GT.$("pop up the full context menu"));
        ActionManager.newAction(24, "_reset", GT.$("reset (when clicked off the model)"));
        ActionManager.newAction(25, "_rotate", GT.$("rotate"));
        ActionManager.newAction(26, "_rotateBranch", GT.o(GT.$("rotate branch around bond (requires {0})"), "set picking ROTATEBOND"));
        ActionManager.newAction(27, "_rotateSelected", GT.o(GT.$("rotate selected atoms (requires {0})"), "set DRAGSELECTED"));
        ActionManager.newAction(28, "_rotateZ", GT.$("rotate Z"));
        ActionManager.newAction(29, "_rotateZorZoom", GT.$("rotate Z (horizontal motion of mouse) or zoom (vertical motion of mouse)"));
        ActionManager.newAction(30, "_select", GT.o(GT.$("select an atom (requires {0})"), "set pickingStyle EXTENDEDSELECT"));
        ActionManager.newAction(31, "_selectAndDrag", GT.o(GT.$("select and drag atoms (requires {0})"), "set DRAGSELECTED"));
        ActionManager.newAction(32, "_selectAndNot", GT.o(GT.$("unselect this group of atoms (requires {0})"), "set pickingStyle DRAG/EXTENDEDSELECT"));
        ActionManager.newAction(33, "_selectNone", GT.o(GT.$("select NONE (requires {0})"), "set pickingStyle EXTENDEDSELECT"));
        ActionManager.newAction(34, "_selectOr", GT.o(GT.$("add this group of atoms to the set of selected atoms (requires {0})"), "set pickingStyle DRAG/EXTENDEDSELECT"));
        ActionManager.newAction(35, "_selectToggle", GT.o(GT.$("toggle selection (requires {0})"), "set pickingStyle DRAG/EXTENDEDSELECT/RASMOL"));
        ActionManager.newAction(36, "_selectToggleOr", GT.o(GT.$("if all are selected, unselect all, otherwise add this group of atoms to the set of selected atoms (requires {0})"), "set pickingStyle DRAG"));
        ActionManager.newAction(37, "_setMeasure", GT.$("pick an atom to initiate or conclude a measurement"));
        ActionManager.newAction(38, "_slab", GT.o(GT.$("adjust slab (front plane; requires {0})"), "SLAB ON"));
        ActionManager.newAction(39, "_slabAndDepth", GT.o(GT.$("move slab/depth window (both planes; requires {0})"), "SLAB ON"));
        ActionManager.newAction(40, "_slideZoom", GT.$("zoom (along right edge of window)"));
        ActionManager.newAction(41, "_spinDrawObjectCCW", GT.o(GT.$("click on two points to spin around axis counterclockwise (requires {0})"), "set picking SPIN"));
        ActionManager.newAction(42, "_spinDrawObjectCW", GT.o(GT.$("click on two points to spin around axis clockwise (requires {0})"), "set picking SPIN"));
        ActionManager.newAction(43, "_stopMotion", GT.o(GT.$("stop motion (requires {0})"), "set waitForMoveTo FALSE"));
        ActionManager.newAction(44, "_swipe", GT.$("spin model (swipe and release button and stop motion simultaneously)"));
        ActionManager.newAction(45, "_translate", GT.$("translate"));
        ActionManager.newAction(46, "_wheelZoom", GT.$("zoom"));
    }

    public static String getActionName(int i) {
        return i < actionNames.length ? actionNames[i] : null;
    }

    public static int getActionFromName(String name) {
        for (int i = 0; i < actionNames.length; ++i) {
            if (!actionNames[i].equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    public String getBindingInfo(String qualifiers) {
        return this.b.getBindingInfo(actionInfo, actionNames, qualifiers);
    }

    protected void setBinding(Binding newBinding) {
        this.b = newBinding;
    }

    boolean bnd(int mouseAction, int ... jmolActions) {
        int i = jmolActions.length;
        while (--i >= 0) {
            if (!this.b.isBound(mouseAction, jmolActions[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isDrawOrLabelAction(int a) {
        return this.drawMode && this.bnd(a, 8, 9) || this.labelMode && this.bnd(a, 10);
    }

    public int getBondPickingMode() {
        return this.bondPickingMode;
    }

    public static final String getPickingModeName(int pickingMode) {
        return pickingMode < 0 || pickingMode >= pickingModeNames.length ? "off" : pickingModeNames[pickingMode];
    }

    public static final int getPickingMode(String str) {
        int i = pickingModeNames.length;
        while (--i >= 0) {
            if (!str.equalsIgnoreCase(pickingModeNames[i])) continue;
            return i;
        }
        return -1;
    }

    public static final String getPickingStyleName(int pickingStyle) {
        return pickingStyle < 0 || pickingStyle >= pickingStyleNames.length ? "toggle" : pickingStyleNames[pickingStyle];
    }

    public static final int getPickingStyleIndex(String str) {
        int i = pickingStyleNames.length;
        while (--i >= 0) {
            if (!str.equalsIgnoreCase(pickingStyleNames[i])) continue;
            return i;
        }
        return -1;
    }

    public int getAtomPickingMode() {
        return this.apm;
    }

    public void setPickingMode(int pickingMode) {
        boolean isNew = false;
        switch (pickingMode) {
            case -1: {
                isNew = true;
                this.bondPickingMode = 35;
                pickingMode = 1;
                this.vwr.setStringProperty("pickingStyle", "toggle");
                this.vwr.setBooleanProperty("bondPicking", false);
                break;
            }
            case 8: 
            case 33: 
            case 34: 
            case 35: {
                this.vwr.setBooleanProperty("bondPicking", true);
                this.bondPickingMode = pickingMode;
                this.resetMeasurement();
                return;
            }
        }
        boolean bl = this.apm != pickingMode;
        this.apm = pickingMode;
        if (isNew |= bl) {
            this.resetMeasurement();
        }
    }

    public String getPickingState() {
        String script = ";set modelkitMode " + this.vwr.getBoolean(603983903) + ";set picking " + ActionManager.getPickingModeName(this.apm);
        if (this.apm == 32) {
            script = script + "_" + this.vwr.getModelkitProperty("atomType");
        }
        script = script + ";";
        if (this.bondPickingMode != 0) {
            script = script + "set picking " + ActionManager.getPickingModeName(this.bondPickingMode);
        }
        if (this.bondPickingMode == 33) {
            script = script + "_" + this.vwr.getModelkitProperty("bondType");
        }
        script = script + ";";
        return script;
    }

    int getPickingStyle() {
        return this.pickingStyle;
    }

    void setPickingStyle(int pickingStyle) {
        this.pickingStyle = pickingStyle;
        if (pickingStyle >= 4) {
            this.pickingStyleMeasure = pickingStyle;
            this.resetMeasurement();
        } else {
            if (pickingStyle < 3) {
                this.rootPickingStyle = pickingStyle;
            }
            this.pickingStyleSelect = pickingStyle;
        }
        this.rubberbandSelectionMode = false;
        switch (this.pickingStyleSelect) {
            case 2: {
                if (this.b.name.equals("extendedSelect")) break;
                this.setBinding(this.pfaatBinding == null ? (this.pfaatBinding = Binding.newBinding(this.vwr, "Pfaat")) : this.pfaatBinding);
                break;
            }
            case 3: {
                if (!this.b.name.equals("drag")) {
                    this.setBinding(this.dragBinding == null ? (this.dragBinding = Binding.newBinding(this.vwr, "Drag")) : this.dragBinding);
                }
                this.rubberbandSelectionMode = true;
                break;
            }
            case 1: {
                if (this.b.name.equals("selectOrToggle")) break;
                this.setBinding(this.rasmolBinding == null ? (this.rasmolBinding = Binding.newBinding(this.vwr, "Rasmol")) : this.rasmolBinding);
                break;
            }
            default: {
                if (this.b == this.jmolBinding) break;
                this.setBinding(this.jmolBinding);
            }
        }
        if (!this.b.name.equals("drag")) {
            this.predragBinding = this.b;
        }
    }

    void setGestureSwipeFactor(float factor) {
        this.gestureSwipeFactor = factor;
    }

    void setMouseDragFactor(float factor) {
        this.mouseDragFactor = factor;
    }

    void setMouseWheelFactor(float factor) {
        this.mouseWheelFactor = factor;
    }

    boolean isDraggedIsShiftDown() {
        return (this.dragged.modifiers & 1) != 0;
    }

    protected void setCurrent(long time, int x, int y, int mods) {
        this.vwr.hoverOff();
        this.current.set(time, x, y, mods);
    }

    int getCurrentX() {
        return this.current.x;
    }

    int getCurrentY() {
        return this.current.y;
    }

    public void setMouseMode() {
        this.labelMode = false;
        this.drawMode = false;
        this.dragSelectedMode = this.vwr.getDragSelected();
        boolean bl = this.measuresEnabled = !this.dragSelectedMode;
        if (!this.dragSelectedMode) {
            switch (this.apm) {
                default: {
                    return;
                }
                case 32: {
                    this.measuresEnabled = !this.vwr.getModelkit(false).isPickAtomAssignCharge();
                    return;
                }
                case 4: {
                    this.drawMode = true;
                    this.measuresEnabled = false;
                    break;
                }
                case 2: {
                    this.labelMode = true;
                    this.measuresEnabled = false;
                    break;
                }
                case 9: {
                    this.measuresEnabled = false;
                    break;
                }
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    this.measuresEnabled = false;
                    return;
                }
            }
        }
        this.exitMeasurementMode(null);
    }

    protected void clearMouseInfo() {
        this.clickedCount = 0;
        this.pressedCount = 0;
        this.dragGesture.setAction(0, 0L);
        this.exitMeasurementMode(null);
    }

    public void setDragAtomIndex(int iatom) {
        this.dragAtomIndex = iatom;
        this.setAtomsPicked(BSUtil.newAndSetBit(iatom), "Label picked for atomIndex = " + iatom);
    }

    public boolean isMTClient() {
        return this.isMultiTouchClient;
    }

    public boolean isMTServer() {
        return this.isMultiTouchServer;
    }

    public void dispose() {
        this.clear();
    }

    public void clear() {
        this.startHoverWatcher(false);
        if (this.predragBinding != null) {
            this.b = this.predragBinding;
        }
        this.vwr.setPickingMode(null, 1);
        this.vwr.setPickingStyle(null, this.rootPickingStyle);
        this.isAltKeyReleased = true;
    }

    public synchronized void startHoverWatcher(boolean isStart) {
        if (this.vwr.isPreviewOnly) {
            return;
        }
        try {
            if (isStart) {
                if (this.hoverWatcherThread != null) {
                    return;
                }
                this.current.time = -1L;
                this.hoverWatcherThread = new HoverWatcherThread(this, this.current, this.moved, this.vwr);
            } else {
                if (this.hoverWatcherThread == null) {
                    return;
                }
                this.current.time = -1L;
                this.hoverWatcherThread.interrupt();
                this.hoverWatcherThread = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setModeMouse(int modeMouse) {
        if (modeMouse == -1) {
            this.startHoverWatcher(false);
        }
    }

    @Override
    public boolean keyPressed(int key, int modifiers) {
        if (this.keyProcessing) {
            return false;
        }
        this.keyProcessing = true;
        switch (key) {
            case 18: {
                if (this.dragSelectedMode && this.isAltKeyReleased) {
                    this.vwr.moveSelected(Integer.MIN_VALUE, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, null, false, false, modifiers);
                }
                this.isAltKeyReleased = false;
                this.moved.modifiers |= 8;
                break;
            }
            case 16: {
                this.dragged.modifiers |= 1;
                this.moved.modifiers |= 1;
                break;
            }
            case 17: {
                this.moved.modifiers |= 2;
                break;
            }
            case 27: {
                this.vwr.hoverOff();
                this.exitMeasurementMode("escape");
                break;
            }
            default: {
                this.vwr.hoverOff();
            }
        }
        int action = 0x2110 | this.moved.modifiers;
        if (!this.labelMode && !this.b.isUserAction(action)) {
            this.checkMotionRotateZoom(action, this.current.x, 0, 0, false);
        }
        if (this.vwr.getBoolean(603979889)) {
            switch (key) {
                case 32: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 46: {
                    this.vwr.navigate(key, modifiers);
                }
            }
        }
        this.keyProcessing = false;
        return true;
    }

    @Override
    public boolean keyTyped(int keyChar, int modifiers) {
        return false;
    }

    @Override
    public void keyReleased(int key) {
        switch (key) {
            case 18: {
                this.moved.modifiers &= 0xFFFFFFF7;
                if (this.dragSelectedMode) {
                    this.vwr.moveSelected(Integer.MAX_VALUE, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, null, false, false, this.moved.modifiers);
                }
                this.isAltKeyReleased = true;
                break;
            }
            case 16: {
                this.moved.modifiers &= 0xFFFFFFFE;
                break;
            }
            case 17: {
                this.moved.modifiers &= 0xFFFFFFFD;
            }
        }
        if (this.moved.modifiers == 0) {
            this.vwr.setCursor(0);
        }
        if (!this.vwr.getBoolean(603979889)) {
            return;
        }
        switch (key) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this.vwr.navigate(0, 0);
            }
        }
    }

    @Override
    public void mouseEnterExit(long time, int x, int y, boolean isExit) {
        if (this.vwr.tm.stereoDoubleDTI) {
            x <<= 1;
        }
        this.setCurrent(time, x, y, 0);
        if (isExit) {
            this.exitMeasurementMode("mouseExit");
        }
    }

    private void setMouseActions(int count, int buttonMods, boolean isRelease) {
        this.pressAction = Binding.getMouseAction(count, buttonMods, isRelease ? 5 : 4);
        this.dragAction = Binding.getMouseAction(count, buttonMods, 1);
        this.clickAction = Binding.getMouseAction(count, buttonMods, 2);
    }

    @Override
    public void mouseAction(int mode, long time, int x, int y, int count, int buttonMods) {
        if (!this.vwr.getMouseEnabled()) {
            return;
        }
        if (Logger.debuggingHigh && mode != 0 && this.vwr.getBoolean(603979960)) {
            this.vwr.showString("mouse action: " + mode + " " + buttonMods + " " + Binding.getMouseActionName(Binding.getMouseAction(count, buttonMods, mode), false), false);
        }
        if (this.vwr.tm.stereoDoubleDTI) {
            x <<= 1;
        }
        switch (mode) {
            case 0: {
                this.setCurrent(time, x, y, buttonMods);
                this.moved.setCurrent(this.current, 0);
                if (this.mp != null || this.hoverActive) {
                    this.clickAction = Binding.getMouseAction(this.clickedCount, buttonMods, 0);
                    this.checkClickAction(x, y, time, 0);
                    return;
                }
                if (this.isZoomArea(x)) {
                    this.checkMotionRotateZoom(this.LEFT_DRAGGED, 0, 0, 0, false);
                    return;
                }
                if (this.vwr.currentCursor == 8) {
                    this.vwr.setCursor(0);
                }
                return;
            }
            case 4: {
                this.setMouseMode();
                int n = this.pressedCount = this.pressed.check(20, x, y, buttonMods, time, 700L) ? this.pressedCount + 1 : 1;
                if (this.pressedCount == 1) {
                    this.vwr.checkInMotion(1);
                    this.setCurrent(time, x, y, buttonMods);
                }
                this.pressAction = Binding.getMouseAction(this.pressedCount, buttonMods, 4);
                this.vwr.setCursor(12);
                this.pressed.setCurrent(this.current, 1);
                this.dragged.setCurrent(this.current, 1);
                this.vwr.setFocus();
                this.dragGesture.setAction(this.dragAction, time);
                this.checkPressedAction(x, y, time);
                return;
            }
            case 1: {
                this.setMouseMode();
                this.setMouseActions(this.pressedCount, buttonMods, false);
                int deltaX = x - this.dragged.x;
                int deltaY = y - this.dragged.y;
                this.setCurrent(time, x, y, buttonMods);
                this.dragged.setCurrent(this.current, -1);
                this.dragGesture.add(this.dragAction, x, y, time);
                this.checkDragWheelAction(this.dragAction, x, y, deltaX, deltaY, time, 1);
                return;
            }
            case 5: {
                this.setMouseActions(this.pressedCount, buttonMods, true);
                this.setCurrent(time, x, y, buttonMods);
                this.vwr.spinXYBy(0, 0, 0.0f);
                boolean dragRelease = !this.pressed.check(10, x, y, buttonMods, time, Long.MAX_VALUE);
                this.checkReleaseAction(x, y, time, dragRelease);
                return;
            }
            case 3: {
                if (this.vwr.isApplet && !this.vwr.hasFocus()) {
                    return;
                }
                this.setCurrent(time, this.current.x, this.current.y, buttonMods);
                this.checkDragWheelAction(Binding.getMouseAction(0, buttonMods, 3), this.current.x, this.current.y, 0, y, time, 3);
                return;
            }
            case 2: {
                this.setMouseMode();
                int n = count > 1 ? count : (this.clickedCount = this.clicked.check(10, 0, 0, buttonMods, time, 700L) ? this.clickedCount + 1 : 1);
                if (this.clickedCount == 1) {
                    this.setCurrent(time, x, y, buttonMods);
                }
                this.setMouseActions(this.clickedCount, buttonMods, false);
                this.clicked.setCurrent(this.current, this.clickedCount);
                this.vwr.setFocus();
                if (this.apm != 9 && this.bnd(Binding.getMouseAction(1, buttonMods, 4), 31)) {
                    return;
                }
                this.clickAction = Binding.getMouseAction(this.clickedCount, buttonMods, 2);
                this.checkClickAction(x, y, time, this.clickedCount);
                return;
            }
        }
    }

    private void checkPressedAction(int x, int y, long time) {
        int buttonMods = Binding.getButtonMods(this.pressAction);
        boolean isDragSelectedAction = this.bnd(Binding.getMouseAction(1, buttonMods, 4), 31);
        if (buttonMods != 0) {
            this.pressAction = this.vwr.notifyMouseClicked(x, y, this.pressAction, 4);
            if (this.pressAction == 0) {
                return;
            }
            buttonMods = Binding.getButtonMods(this.pressAction);
        }
        this.setMouseActions(this.pressedCount, buttonMods, false);
        if (Logger.debuggingHigh && this.vwr.getBoolean(603979960)) {
            Logger.debug(Binding.getMouseActionName(this.pressAction, false));
        }
        if (this.isDrawOrLabelAction(this.dragAction) && this.vwr.checkObjectDragged(Integer.MIN_VALUE, 0, x, y, this.dragAction)) {
            return;
        }
        this.checkUserAction(this.pressAction, x, y, 0, 0, time, 4);
        boolean isBound = false;
        switch (this.apm) {
            case 32: {
                isBound = this.bnd(this.clickAction, 0);
                break;
            }
            case 28: {
                isBound = this.bnd(this.dragAction, 7, 14);
                break;
            }
            case 26: 
            case 27: 
            case 36: 
            case 37: {
                isBound = this.bnd(this.dragAction, 7, 14, 27);
                break;
            }
            case 29: {
                isBound = this.bnd(this.dragAction, 11, 14);
                break;
            }
            case 30: {
                isBound = this.bnd(this.dragAction, 11, 14, 27);
            }
        }
        if (isBound) {
            int[] xy;
            this.dragAtomIndex = this.vwr.findNearestAtomIndexMovable(x, y, true);
            if (this.dragAtomIndex >= 0 && (this.apm == 32 || this.apm == 31)) {
                if (this.bondPickingMode == 34) {
                    this.vwr.setModelkitProperty("bondAtomIndex", this.dragAtomIndex);
                }
                this.enterMeasurementMode(this.dragAtomIndex);
                this.mp.addPoint(this.dragAtomIndex, null, false);
            }
            this.mkBondPressed = (xy = (int[])this.vwr.getModelkitProperty("screenXY")) != null && this.pressed.inRange(10, xy[0], xy[1]);
            return;
        }
        if (this.bnd(this.pressAction, 23)) {
            this.vwr.popupMenu(x, y, this.vwr.getBoolean(603983903) ? (char)'m' : 'j');
            return;
        }
        if (this.dragSelectedMode) {
            boolean bl = this.haveSelection = !isDragSelectedAction || this.vwr.findNearestAtomIndexMovable(x, y, true) >= 0;
            if (this.haveSelection && this.bnd(this.dragAction, 13, 14)) {
                this.vwr.moveSelected(Integer.MIN_VALUE, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, null, false, false, buttonMods);
            }
            return;
        }
        this.checkMotionRotateZoom(this.dragAction, x, 0, 0, true);
    }

    private void checkDragWheelAction(int dragWheelAction, int x, int y, int deltaX, int deltaY, long time, int mode) {
        int bi;
        int buttonmods = Binding.getButtonMods(dragWheelAction);
        if (buttonmods != 0) {
            int newAction = this.vwr.notifyMouseClicked(x, y, Binding.getMouseAction(this.pressedCount, buttonmods, mode), mode);
            if (newAction == 0) {
                return;
            }
            if (newAction > 0) {
                dragWheelAction = newAction;
            }
        }
        if (this.isRubberBandSelect(dragWheelAction)) {
            this.calcRectRubberBand();
            this.vwr.refresh(3, "rubberBand selection");
            return;
        }
        if (this.checkUserAction(dragWheelAction, x, y, deltaX, deltaY, time, mode)) {
            return;
        }
        int n = bi = this.vwr.g.modelKitMode ? this.vwr.getModelkit(false).getRotateBondIndex() : -1;
        if (bi >= 0 && (this.dragAtomIndex >= 0 || this.mkBondPressed || this.bnd(dragWheelAction, 26))) {
            if (this.dragAtomIndex >= 0) {
                if (this.measurementQueued == null || this.measurementQueued.numSet == 0) {
                    this.measurementQueued = this.mp = this.getMP();
                    this.vwr.setPendingMeasurement(this.vwr.getModelkit(false).setBondMeasure(bi, this.mp));
                } else {
                    this.measurementQueued.refresh(null);
                }
            }
            this.vwr.moveSelected(deltaX, deltaY, Integer.MIN_VALUE, x, y, null, false, false, this.dragAtomIndex >= 0 ? 0 : 16);
            return;
        }
        BS bs = null;
        if (this.dragAtomIndex >= 0 && this.apm != 2) {
            switch (this.apm) {
                case 26: {
                    this.dragSelected(dragWheelAction, deltaX, deltaY, true);
                    return;
                }
                case 27: 
                case 30: 
                case 36: 
                case 37: {
                    bs = this.vwr.ms.getAtoms(this.apm == 37 ? 1094717454 : 0x41400010, BSUtil.newAndSetBit(this.dragAtomIndex));
                    if (this.apm == 36) {
                        bs.and(this.vwr.getAtomBitSet("ligand"));
                    }
                }
                case 28: 
                case 29: {
                    if (this.dragGesture.getPointCount() == 1) {
                        this.vwr.undoMoveActionClear(this.dragAtomIndex, 2, true);
                    }
                    this.setMotion(13, true);
                    if (this.bnd(dragWheelAction, 27)) {
                        this.vwr.rotateSelected(this.getDegrees(deltaX, true), this.getDegrees(deltaY, false), bs);
                    } else {
                        switch (this.apm) {
                            case 27: 
                            case 30: 
                            case 36: 
                            case 37: {
                                this.vwr.selectStatus(bs, false, 0, true, true);
                            }
                        }
                        this.vwr.moveAtomWithHydrogens(this.dragAtomIndex, deltaX, deltaY, this.bnd(dragWheelAction, 14) ? -deltaY : Integer.MIN_VALUE, bs);
                    }
                    return;
                }
            }
        }
        if (this.dragAtomIndex >= 0 && mode == 1 && this.bnd(this.clickAction, 0) && this.apm == 32) {
            int nearestAtomIndex = this.vwr.findNearestAtomIndexMovable(x, y, false);
            if (nearestAtomIndex >= 0) {
                if (this.mp != null) {
                    this.mp.setCount(1);
                } else if (this.measuresEnabled) {
                    this.enterMeasurementMode(nearestAtomIndex);
                }
                this.addToMeasurement(nearestAtomIndex, null, true);
                this.mp.colix = (short)20;
            } else if (this.mp != null) {
                this.mp.setCount(1);
                this.mp.colix = (short)23;
            }
            if (this.mp == null) {
                return;
            }
            if (this.vwr.antialiased) {
                x <<= 1;
                y <<= 1;
            }
            this.mp.traceX = x;
            this.mp.traceY = y;
            this.vwr.refresh(3, "assignNew");
            return;
        }
        if (!this.drawMode && !this.labelMode && this.bnd(dragWheelAction, 45)) {
            this.vwr.translateXYBy(deltaX, deltaY);
            return;
        }
        if (this.dragSelectedMode && this.haveSelection && this.bnd(dragWheelAction, 13, 27)) {
            int iatom = this.vwr.bsA().nextSetBit(0);
            if (iatom < 0) {
                return;
            }
            if (this.dragGesture.getPointCount() == 1) {
                this.vwr.undoMoveActionClear(iatom, 2, true);
            } else {
                this.vwr.moveSelected(Integer.MAX_VALUE, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, null, false, false, buttonmods);
            }
            this.dragSelected(dragWheelAction, deltaX, deltaY, false);
            return;
        }
        if (this.isDrawOrLabelAction(dragWheelAction)) {
            this.setMotion(13, true);
            if (this.vwr.checkObjectDragged(this.dragged.x, this.dragged.y, x, y, dragWheelAction)) {
                return;
            }
        }
        if (this.checkMotionRotateZoom(dragWheelAction, x, deltaX, deltaY, true)) {
            if (this.vwr.tm.slabEnabled && this.bnd(dragWheelAction, 39)) {
                this.vwr.slabDepthByPixels(deltaY);
            } else {
                this.vwr.zoomBy(deltaY);
            }
            return;
        }
        if (this.bnd(dragWheelAction, 25)) {
            this.vwr.rotateXYBy(this.getDegrees(deltaX, true), this.getDegrees(deltaY, false));
            return;
        }
        if (this.bnd(dragWheelAction, 29)) {
            if (deltaX == 0 && Math.abs(deltaY) > 1) {
                this.setMotion(8, true);
                this.vwr.zoomBy(deltaY + (deltaY > 0 ? -1 : 1));
            } else if (deltaY == 0 && Math.abs(deltaX) > 1) {
                this.setMotion(13, true);
                this.vwr.rotateZBy(-deltaX + (deltaX > 0 ? 1 : -1), Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
            return;
        }
        if (this.vwr.tm.slabEnabled) {
            if (this.bnd(dragWheelAction, 6)) {
                this.vwr.depthByPixels(deltaY);
                return;
            }
            if (this.bnd(dragWheelAction, 38)) {
                this.vwr.slabByPixels(deltaY);
                return;
            }
            if (this.bnd(dragWheelAction, 39)) {
                this.vwr.slabDepthByPixels(deltaY);
                return;
            }
        }
        if (this.bnd(dragWheelAction, 46)) {
            this.zoomByFactor(deltaY, Integer.MAX_VALUE, Integer.MAX_VALUE);
            return;
        }
        if (this.bnd(dragWheelAction, 28)) {
            this.setMotion(13, true);
            this.vwr.rotateZBy(-deltaX, Integer.MAX_VALUE, Integer.MAX_VALUE);
            return;
        }
    }

    private void dragSelected(int a, int deltaX, int deltaY, boolean isPickingDrag) {
        this.setMotion(13, true);
        if (this.bnd(a, 27) && this.vwr.getBoolean(603979785)) {
            this.vwr.rotateSelected(this.getDegrees(deltaX, true), this.getDegrees(deltaY, false), null);
        } else {
            this.vwr.moveSelected(deltaX, deltaY, isPickingDrag && this.bnd(a, 14) ? -deltaY : Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, null, true, false, this.dragged.modifiers);
        }
    }

    private void checkReleaseAction(int x, int y, long time, boolean dragRelease) {
        if (Logger.debuggingHigh && this.vwr.getBoolean(603979960)) {
            Logger.debug(Binding.getMouseActionName(this.pressAction, false));
        }
        this.vwr.checkInMotion(0);
        this.vwr.setInMotion(false);
        this.vwr.setCursor(0);
        this.dragGesture.add(this.dragAction, x, y, time);
        if (this.dragAtomIndex >= 0 && (this.apm == 29 || this.apm == 30)) {
            this.minimize(true);
        }
        if (this.apm == 32 && this.bnd(this.clickAction, 0)) {
            if (this.mp == null || this.dragAtomIndex < 0) {
                this.exitMeasurementMode(null);
                return;
            }
            if (this.bondPickingMode == 34) {
                this.vwr.setModelkitProperty("bondAtomIndex", this.dragAtomIndex);
                this.exitMeasurementMode(null);
                return;
            }
            this.assignNew();
            return;
        }
        this.dragAtomIndex = -1;
        this.mkBondPressed = false;
        boolean isRbAction = this.isRubberBandSelect(this.dragAction);
        if (isRbAction) {
            this.selectRb(this.clickAction);
        }
        this.rubberbandSelectionMode = this.b.name.equals("drag");
        this.rectRubber.x = Integer.MAX_VALUE;
        if (dragRelease) {
            this.vwr.notifyMouseClicked(x, y, Binding.getMouseAction(this.pressedCount, 0, 5), 5);
        }
        if (this.isDrawOrLabelAction(this.dragAction)) {
            this.vwr.checkObjectDragged(Integer.MAX_VALUE, 0, x, y, this.dragAction);
            return;
        }
        if (this.haveSelection && this.dragSelectedMode && this.bnd(this.dragAction, 13)) {
            this.vwr.moveSelected(Integer.MAX_VALUE, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, null, false, false, this.dragged.modifiers);
        }
        if (dragRelease && this.checkUserAction(this.pressAction, x, y, 0, 0, time, 5)) {
            return;
        }
        if (this.vwr.getBoolean(0x24000004) && this.bnd(this.dragAction, 44)) {
            float speed = this.getExitRate();
            if (speed > 0.0f) {
                this.vwr.spinXYBy(this.dragGesture.getDX(4, 2), this.dragGesture.getDY(4, 2), speed * 30.0f * this.gestureSwipeFactor);
            }
            if (this.vwr.g.logGestures) {
                this.vwr.log("$NOW$ swipe " + this.dragGesture + " " + speed);
            }
            return;
        }
    }

    private void checkClickAction(int x, int y, long time, int clickedCount) {
        if (clickedCount > 0) {
            if (this.checkUserAction(this.clickAction, x, y, 0, 0, time, 32768)) {
                return;
            }
            this.clickAction = this.vwr.notifyMouseClicked(x, y, this.clickAction, 32768);
            if (this.clickAction == 0) {
                return;
            }
        }
        if (Logger.debuggingHigh && this.vwr.getBoolean(603979960)) {
            Logger.debug(Binding.getMouseActionName(this.clickAction, false));
        }
        if (this.bnd(this.clickAction, 2)) {
            if (this.vwr.frankClicked(x, y)) {
                this.vwr.popupMenu(-x, y, 'j');
                return;
            }
            if (this.vwr.frankClickedModelKit(x, y)) {
                this.vwr.popupMenu(10, 0, 'm');
                return;
            }
        }
        Point3fi nearestPoint = null;
        boolean isBond = false;
        boolean isIsosurface = false;
        Map<String, Object> map = null;
        if (!this.drawMode && (map = this.vwr.checkObjectClicked(x, y, this.clickAction)) != null) {
            if (this.labelMode) {
                this.pickLabel((Integer)map.get("atomIndex"));
                return;
            }
            isBond = "bond".equals(map.get("type"));
            isIsosurface = "isosurface".equals(map.get("type"));
            nearestPoint = this.getPoint(map);
        }
        if (isBond) {
            clickedCount = 1;
        }
        if (nearestPoint != null && Float.isNaN(nearestPoint.x)) {
            return;
        }
        int nearestAtomIndex = this.findNearestAtom(x, y, nearestPoint, clickedCount > 0);
        if (clickedCount == 0 && this.apm != 32) {
            if (this.mp == null) {
                return;
            }
            if (nearestPoint != null || this.mp.getIndexOf(nearestAtomIndex) == 0) {
                this.mp.addPoint(nearestAtomIndex, nearestPoint, false);
            }
            if (this.mp.haveModified) {
                this.vwr.setPendingMeasurement(this.mp);
            }
            this.vwr.refresh(3, "measurementPending");
            return;
        }
        this.setMouseMode();
        if (this.bnd(this.clickAction, 43)) {
            this.vwr.tm.stopMotion();
        }
        if (this.vwr.getBoolean(603979889) && this.apm == 23 && this.bnd(this.clickAction, 21)) {
            this.vwr.navTranslatePercent((float)x * 100.0f / (float)this.vwr.getScreenWidth() - 50.0f, (float)y * 100.0f / (float)this.vwr.getScreenHeight() - 50.0f);
            return;
        }
        if (isBond) {
            int[] nArray = new int[1];
            int n = nArray[0] = this.bondPickingMode == 34 || this.bondPickingMode == 33 ? 0 : 5;
            if (this.bnd(this.clickAction, nArray)) {
                this.bondPicked((Integer)map.get("index"));
                return;
            }
        } else {
            if (isIsosurface) {
                return;
            }
            if (this.apm != 32 && this.mp != null && this.bnd(this.clickAction, 20)) {
                this.atomOrPointPicked(nearestAtomIndex, nearestPoint);
                if (this.addToMeasurement(nearestAtomIndex, nearestPoint, false) == 4) {
                    this.toggleMeasurement();
                }
                return;
            }
            if (this.bnd(this.clickAction, 37)) {
                if (this.mp != null) {
                    this.addToMeasurement(nearestAtomIndex, nearestPoint, true);
                    this.toggleMeasurement();
                } else if (!this.drawMode && !this.labelMode && !this.dragSelectedMode && this.measuresEnabled) {
                    this.enterMeasurementMode(nearestAtomIndex);
                    this.addToMeasurement(nearestAtomIndex, nearestPoint, true);
                }
                this.atomOrPointPicked(nearestAtomIndex, nearestPoint);
                return;
            }
        }
        if (this.isSelectAction(this.clickAction)) {
            if (!isIsosurface) {
                this.atomOrPointPicked(nearestAtomIndex, nearestPoint);
            }
            return;
        }
        if (this.bnd(this.clickAction, 24)) {
            if (nearestAtomIndex < 0) {
                this.reset();
            }
            return;
        }
    }

    private void pickLabel(int iatom) {
        String label = this.vwr.ms.at[iatom].atomPropertyString(this.vwr, 1825200146);
        if (this.pressedCount == 2) {
            label = this.vwr.apiPlatform.prompt("Set label for atomIndex=" + iatom, label, null, false);
            if (label != null) {
                this.vwr.shm.setAtomLabel(label, iatom);
                this.vwr.refresh(1, "label atom");
            }
        } else {
            this.setAtomsPicked(BSUtil.newAndSetBit(iatom), "Label picked for atomIndex = " + iatom + ": " + label);
        }
    }

    private boolean checkUserAction(int mouseAction, int x, int y, int deltaX, int deltaY, long time, int mode) {
        if (!this.b.isUserAction(mouseAction)) {
            return false;
        }
        boolean passThrough = false;
        Map<String, Object> ht = this.b.getBindings();
        String mkey = mouseAction + "\t";
        for (String key : ht.keySet()) {
            Object obj;
            if (key.indexOf(mkey) != 0 || !AU.isAS(obj = ht.get(key))) continue;
            String script = ((String[])obj)[1];
            P3 nearestPoint = null;
            if (script.indexOf("_ATOM") >= 0) {
                int iatom = this.findNearestAtom(x, y, null, true);
                script = PT.rep(script, "_ATOM", "({" + (iatom >= 0 ? "" + iatom : "") + "})");
                if (iatom >= 0) {
                    script = PT.rep(script, "_POINT", Escape.eP(this.vwr.ms.at[iatom]));
                }
            }
            if (!(this.drawMode || script.indexOf("_POINT") < 0 && script.indexOf("_OBJECT") < 0 && script.indexOf("_BOND") < 0)) {
                Map<String, Object> t = this.vwr.checkObjectClicked(x, y, mouseAction);
                if (t != null && (nearestPoint = (P3)t.get("pt")) != null) {
                    boolean isBond = t.get("type").equals("bond");
                    if (isBond) {
                        script = PT.rep(script, "_BOND", "[{" + t.get("index") + "}]");
                    }
                    script = PT.rep(script, "_POINT", Escape.eP(nearestPoint));
                    script = PT.rep(script, "_OBJECT", Escape.escapeMap(t));
                }
                script = PT.rep(script, "_BOND", "[{}]");
                script = PT.rep(script, "_OBJECT", "{}");
            }
            script = PT.rep(script, "_POINT", "{}");
            script = PT.rep(script, "_ACTION", "" + mouseAction);
            script = PT.rep(script, "_X", "" + x);
            script = PT.rep(script, "_Y", "" + (this.vwr.getScreenHeight() - y));
            script = PT.rep(script, "_DELTAX", "" + deltaX);
            script = PT.rep(script, "_DELTAY", "" + deltaY);
            script = PT.rep(script, "_TIME", "" + time);
            if ((script = PT.rep(script, "_MODE", "" + mode)).startsWith("+:")) {
                passThrough = true;
                script = script.substring(2);
            }
            this.vwr.evalStringQuiet(script);
        }
        return !passThrough;
    }

    private boolean checkMotionRotateZoom(int mouseAction, int x, int deltaX, int deltaY, boolean isDrag) {
        boolean isZoom;
        boolean isSlideZoom = this.bnd(mouseAction, 40) && this.isZoomArea(this.pressed.x);
        boolean isRotateXY = this.bnd(mouseAction, 25);
        boolean isRotateZorZoom = this.bnd(mouseAction, 29);
        if (!(isSlideZoom || isRotateXY || isRotateZorZoom)) {
            return false;
        }
        boolean bl = isZoom = isRotateZorZoom && (deltaX == 0 || Math.abs(deltaY) > 5 * Math.abs(deltaX));
        int cursor = isZoom || this.isZoomArea(this.moved.x) || this.bnd(mouseAction, 46) ? 8 : (isRotateXY || isRotateZorZoom ? 13 : (this.bnd(mouseAction, 1) ? 12 : 0));
        this.setMotion(cursor, isDrag);
        return isZoom || isSlideZoom;
    }

    private float getExitRate() {
        long dt = this.dragGesture.getTimeDifference(2);
        return this.isMultiTouch ? (dt > 80L ? 0.0f : this.dragGesture.getSpeedPixelsPerMillisecond(2, 1)) : (dt > 10L ? 0.0f : this.dragGesture.getSpeedPixelsPerMillisecond(4, 2));
    }

    private boolean isRubberBandSelect(int action) {
        action = action & 0xFFFFDFFF | 0x8000;
        return this.rubberbandSelectionMode && this.bnd(action, 35, 34, 32);
    }

    Rectangle getRubberBand() {
        return this.rubberbandSelectionMode && this.rectRubber.x != Integer.MAX_VALUE ? this.rectRubber : null;
    }

    private void calcRectRubberBand() {
        int factor;
        int n = factor = this.vwr.antialiased ? 2 : 1;
        if (this.current.x < this.pressed.x) {
            this.rectRubber.x = this.current.x * factor;
            this.rectRubber.width = (this.pressed.x - this.current.x) * factor;
        } else {
            this.rectRubber.x = this.pressed.x * factor;
            this.rectRubber.width = (this.current.x - this.pressed.x) * factor;
        }
        if (this.current.y < this.pressed.y) {
            this.rectRubber.y = this.current.y * factor;
            this.rectRubber.height = (this.pressed.y - this.current.y) * factor;
        } else {
            this.rectRubber.y = this.pressed.y * factor;
            this.rectRubber.height = (this.current.y - this.pressed.y) * factor;
        }
    }

    protected float getDegrees(float delta, boolean isX) {
        return delta / (float)Math.min(500, isX ? this.vwr.getScreenWidth() : this.vwr.getScreenHeight()) * 180.0f * this.mouseDragFactor;
    }

    private boolean isZoomArea(int x) {
        return (float)x > (float)(this.vwr.getScreenWidth() * (this.vwr.tm.stereoDoubleFull || this.vwr.tm.stereoDoubleDTI ? 2 : 1) * 98) / 100.0f;
    }

    private Point3fi getPoint(Map<String, Object> t) {
        Point3fi pt = new Point3fi();
        pt.setT((P3)t.get("pt"));
        pt.mi = (short)((Integer)t.get("modelIndex")).intValue();
        return pt;
    }

    private int findNearestAtom(int x, int y, Point3fi nearestPoint, boolean isClicked) {
        int index = this.drawMode || nearestPoint != null ? -1 : this.vwr.findNearestAtomIndexMovable(x, y, false);
        return index >= 0 && (isClicked || this.mp == null) && !this.vwr.slm.isInSelectionSubset(index) ? -1 : index;
    }

    private boolean isSelectAction(int action) {
        return this.bnd(action, 17) || !this.drawMode && !this.labelMode && this.apm == 1 && this.bnd(action, 1) || this.dragSelectedMode && this.bnd(this.dragAction, 27, 13) || this.bnd(action, 22, 35, 32, 34, 36, 30);
    }

    private void enterMeasurementMode(int iAtom) {
        this.vwr.setPicked(iAtom, true);
        this.vwr.setCursor(1);
        this.mp = this.getMP();
        this.vwr.setPendingMeasurement(this.mp);
        this.measurementQueued = this.mp;
    }

    private MeasurementPending getMP() {
        return ((MeasurementPending)Interface.getInterface("org.jmol.modelset.MeasurementPending", this.vwr, "mouse")).set(this.vwr.ms);
    }

    private int addToMeasurement(int atomIndex, Point3fi nearestPoint, boolean dblClick) {
        if (atomIndex == -1 && nearestPoint == null || this.mp == null) {
            this.exitMeasurementMode(null);
            return 0;
        }
        int measurementCount = this.mp.count;
        if (this.mp.traceX != Integer.MIN_VALUE && measurementCount == 2) {
            measurementCount = 1;
            this.mp.setCount(1);
        }
        return measurementCount == 4 && !dblClick ? measurementCount : this.mp.addPoint(atomIndex, nearestPoint, true);
    }

    private void resetMeasurement() {
        this.exitMeasurementMode(null);
        this.measurementQueued = this.getMP();
    }

    void exitMeasurementMode(String refreshWhy) {
        if (this.mp == null) {
            return;
        }
        this.mp = null;
        this.vwr.setPendingMeasurement(null);
        this.vwr.setCursor(0);
        if (refreshWhy != null) {
            this.vwr.refresh(3, refreshWhy);
        }
    }

    private void getSequence() {
        int a1 = this.measurementQueued.getAtomIndex(1);
        int a2 = this.measurementQueued.getAtomIndex(2);
        if (a1 < 0 || a2 < 0) {
            return;
        }
        try {
            String sequence = this.vwr.getSmilesOpt(null, a1, a2, 0x100000, null);
            this.vwr.setStatusMeasuring("measureSequence", -2, sequence, 0.0f);
        }
        catch (Exception e) {
            Logger.error(e.toString());
        }
    }

    private void minimize(boolean dragDone) {
        int iAtom = this.dragAtomIndex;
        if (dragDone) {
            this.dragAtomIndex = -1;
            this.mkBondPressed = false;
        }
        this.vwr.dragMinimizeAtom(iAtom);
    }

    private int queueAtom(int atomIndex, Point3fi ptClicked) {
        int n = this.measurementQueued.addPoint(atomIndex, ptClicked, true);
        if (atomIndex >= 0) {
            this.vwr.setStatusAtomPicked(atomIndex, "Atom #" + n + ":" + this.vwr.getAtomInfo(atomIndex), null, false);
        }
        return n;
    }

    protected void setMotion(int cursor, boolean inMotion) {
        switch (this.vwr.currentCursor) {
            case 3: {
                break;
            }
            default: {
                this.vwr.setCursor(cursor);
            }
        }
        if (inMotion) {
            this.vwr.setInMotion(true);
        }
    }

    protected void zoomByFactor(int dz, int x, int y) {
        if (dz == 0) {
            return;
        }
        this.setMotion(8, true);
        this.vwr.zoomByFactor((float)Math.pow(this.mouseWheelFactor, dz), x, y);
        this.moved.setCurrent(this.current, 0);
        this.vwr.setInMotion(true);
        this.zoomTrigger = true;
        this.startHoverWatcher(true);
    }

    private void runScript(String script) {
        this.vwr.evalStringGUI(script);
    }

    private void atomOrPointPicked(int atomIndex, Point3fi ptClicked) {
        if (atomIndex < 0) {
            this.resetMeasurement();
            if (this.bnd(this.clickAction, 33)) {
                this.runScript("select none");
                return;
            }
            if (this.apm != 5 && this.apm != 6) {
                return;
            }
        }
        int n = 2;
        switch (this.apm) {
            case 28: 
            case 29: {
                return;
            }
            case 0: {
                return;
            }
            case 8: 
            case 24: 
            case 25: {
                boolean isDelete = this.apm == 8;
                boolean isStruts = this.apm == 25;
                int[] nArray = new int[1];
                int n2 = nArray[0] = isDelete ? 5 : 3;
                if (!this.bnd(this.clickAction, nArray)) {
                    return;
                }
                if (this.measurementQueued == null || this.measurementQueued.count == 0 || this.measurementQueued.count > 2) {
                    this.resetMeasurement();
                    this.enterMeasurementMode(atomIndex);
                }
                this.addToMeasurement(atomIndex, ptClicked, true);
                if (this.queueAtom(atomIndex, ptClicked) != 2) {
                    return;
                }
                String cAction = isDelete || this.measurementQueued.isConnected(this.vwr.ms.at, 2) ? " DELETE" : (isStruts ? "STRUTS" : "");
                this.runScript("connect " + this.measurementQueued.getMeasurementScript(" ", true) + cAction);
                this.resetMeasurement();
                return;
            }
            case 21: {
                ++n;
            }
            case 20: {
                ++n;
            }
            case 18: 
            case 19: 
            case 22: {
                if (!this.bnd(this.clickAction, 20)) {
                    return;
                }
                if (this.measurementQueued == null || this.measurementQueued.count == 0 || this.measurementQueued.count > n) {
                    this.resetMeasurement();
                    this.enterMeasurementMode(atomIndex);
                }
                this.addToMeasurement(atomIndex, ptClicked, true);
                this.queueAtom(atomIndex, ptClicked);
                int i = this.measurementQueued.count;
                if (i == 1) {
                    this.vwr.setPicked(atomIndex, true);
                }
                if (i < n) {
                    return;
                }
                if (this.apm == 22) {
                    this.getSequence();
                } else {
                    this.vwr.setStatusMeasuring("measurePicked", n, this.measurementQueued.getStringDetail(), this.measurementQueued.value);
                    if (this.apm == 18 || this.pickingStyleMeasure == 4) {
                        this.runScript("measure " + this.measurementQueued.getMeasurementScript(" ", true));
                    }
                }
                this.resetMeasurement();
                return;
            }
        }
        int mode = this.mp != null && this.apm != 1 ? 1 : this.apm;
        switch (mode) {
            case 3: {
                if (!this.bnd(this.clickAction, 17)) {
                    return;
                }
                if (ptClicked == null) {
                    this.zoomTo(atomIndex);
                } else {
                    this.runScript("zoomTo " + Escape.eP(ptClicked));
                }
                return;
            }
            case 5: 
            case 6: {
                if (!this.bnd(this.clickAction, 17)) break;
                this.checkTwoAtomAction(ptClicked, atomIndex);
            }
        }
        if (ptClicked != null) {
            return;
        }
        switch (mode) {
            case 1: {
                if (!this.drawMode && !this.labelMode && this.bnd(this.clickAction, 1)) {
                    this.zoomTo(atomIndex);
                } else if (this.bnd(this.clickAction, 17)) {
                    this.vwr.setStatusAtomPicked(atomIndex, null, null, false);
                }
                return;
            }
            case 2: {
                if (this.bnd(this.clickAction, 19)) {
                    this.runScript("set labeltoggle {atomindex=" + atomIndex + "}");
                    this.pickLabel(atomIndex);
                }
                return;
            }
            case 31: {
                if (this.bnd(this.clickAction, 0)) {
                    this.vwr.invertAtomCoord(null, null, null, atomIndex, true);
                    this.vwr.setStatusAtomPicked(atomIndex, "invert stereo for atomIndex=" + atomIndex, null, false);
                }
                return;
            }
            case 7: {
                if (this.bnd(this.clickAction, 4)) {
                    BS bs = BSUtil.newAndSetBit(atomIndex);
                    this.vwr.deleteAtoms(bs, false);
                    this.vwr.setStatusAtomPicked(atomIndex, "deleted: " + Escape.eBS(bs), null, false);
                }
                return;
            }
        }
        String spec = "atomindex=" + atomIndex;
        switch (this.apm) {
            default: {
                return;
            }
            case 9: {
                this.selectAtoms(spec);
                break;
            }
            case 10: {
                this.selectAtoms("within(group, " + spec + ")");
                break;
            }
            case 11: {
                this.selectAtoms("within(chain, " + spec + ")");
                break;
            }
            case 13: {
                this.selectAtoms("within(polymer, " + spec + ")");
                break;
            }
            case 14: {
                this.selectAtoms("within(structure, " + spec + ")");
                break;
            }
            case 12: {
                this.selectAtoms("within(molecule, " + spec + ")");
                break;
            }
            case 16: {
                this.selectAtoms("within(model, " + spec + ")");
                break;
            }
            case 17: {
                this.selectAtoms("visible and within(element, " + spec + ")");
                break;
            }
            case 15: {
                this.selectAtoms("visible and within(site, " + spec + ")");
            }
        }
        this.vwr.clearClickCount();
        this.vwr.setStatusAtomPicked(atomIndex, null, null, false);
    }

    private void assignNew() {
        if (!this.vwr.getModelkit(false).handleAssignNew(this.pressed, this.dragged, this.mp, this.dragAtomIndex)) {
            this.exitMeasurementMode("bond dropped");
        }
        this.exitMeasurementMode(null);
    }

    private void bondPicked(int index) {
        if (this.bondPickingMode == 33) {
            this.vwr.undoMoveActionClear(-1, 4146, true);
        }
        switch (this.bondPickingMode) {
            case 33: {
                this.vwr.setModelkitProperty("scriptAssignBond", index);
                break;
            }
            case 34: {
                break;
            }
            case 8: {
                this.vwr.deleteBonds(BSUtil.newAndSetBit(index));
            }
        }
    }

    private void checkTwoAtomAction(Point3fi ptClicked, int atomIndex) {
        int queuedAtomCount;
        boolean isSpin;
        boolean bl = isSpin = this.apm == 5;
        if (this.vwr.tm.spinOn || this.vwr.tm.navOn || this.vwr.getPendingMeasurement() != null) {
            this.resetMeasurement();
            if (this.vwr.tm.spinOn) {
                this.runScript("spin off");
            }
            return;
        }
        if (this.measurementQueued.count >= 2) {
            this.resetMeasurement();
        }
        if ((queuedAtomCount = this.measurementQueued.count) == 1 && (ptClicked == null ? this.measurementQueued.getAtomIndex(1) == atomIndex : this.measurementQueued.getAtom(1).distance(ptClicked) == 0.0f)) {
            return;
        }
        if (atomIndex >= 0 || ptClicked != null) {
            queuedAtomCount = this.queueAtom(atomIndex, ptClicked);
        }
        if (queuedAtomCount < 2) {
            if (isSpin) {
                this.vwr.scriptStatus(queuedAtomCount == 1 ? GT.$("pick one more atom in order to spin the model around an axis") : GT.$("pick two atoms in order to spin the model around an axis"));
            } else {
                this.vwr.scriptStatus(queuedAtomCount == 1 ? GT.$("pick one more atom in order to display the symmetry relationship") : GT.$("pick two atoms in order to display the symmetry relationship between them"));
            }
            return;
        }
        String s = this.measurementQueued.getMeasurementScript(" ", false);
        if (isSpin) {
            this.runScript("spin" + s + " " + this.vwr.getInt(553648157));
        } else {
            this.runScript("draw symop " + s + ";show symop " + s);
        }
    }

    private void reset() {
        this.runScript("!reset");
    }

    private void selectAtoms(String item) {
        String s;
        if (this.mp != null || this.selectionWorking) {
            return;
        }
        this.selectionWorking = true;
        String string = this.rubberbandSelectionMode || this.bnd(this.clickAction, 35) ? "selected and not (" + item + ") or (not selected) and " : (this.bnd(this.clickAction, 32) ? "selected and not " : (this.bnd(this.clickAction, 34) ? "selected or " : (this.clickAction == 0 || this.bnd(this.clickAction, 36) ? "selected tog " : (s = this.bnd(this.clickAction, 30) ? "" : null))));
        if (s != null) {
            s = s + "(" + item + ")";
            try {
                BS bs = this.vwr.getAtomBitSetEval(null, s);
                this.setAtomsPicked(bs, "selected: " + Escape.eBS(bs));
                this.vwr.refresh(3, "selections set");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.selectionWorking = false;
    }

    private void setAtomsPicked(BS bs, String msg) {
        this.vwr.selectStatus(bs, false, 0, false, true);
        this.vwr.setStatusAtomPicked(-1, msg, null, false);
    }

    private void selectRb(int action) {
        BS bs = this.vwr.ms.findAtomsInRectangle(this.rectRubber);
        if (bs.length() > 0) {
            String s = Escape.eBS(bs);
            if (this.bnd(action, 34)) {
                this.runScript("selectionHalos on;select selected or " + s);
            } else if (this.bnd(action, 32)) {
                this.runScript("selectionHalos on;select selected and not " + s);
            } else {
                this.runScript("selectionHalos on;select selected tog " + s);
            }
        }
        this.vwr.refresh(3, "mouseReleased");
    }

    private void toggleMeasurement() {
        if (this.mp == null) {
            return;
        }
        int measurementCount = this.mp.count;
        if (measurementCount >= 2 && measurementCount <= 4) {
            this.runScript("!measure " + this.mp.getMeasurementScript(" ", true));
        }
        this.exitMeasurementMode(null);
    }

    private void zoomTo(int atomIndex) {
        this.runScript("zoomTo (atomindex=" + atomIndex + ")");
        this.vwr.setStatusAtomPicked(atomIndex, null, null, false);
    }

    public boolean userActionEnabled(int action) {
        return this.vwr.isFunction(ActionManager.getActionName(action).toLowerCase());
    }

    public boolean userAction(int action, Object[] params) {
        if (!this.userActionEnabled(action)) {
            return false;
        }
        SV result = ScriptEval.runUserAction(ActionManager.getActionName(action), params, this.vwr);
        return !SV.vF.equals(result);
    }
}

