/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.writers;

import javajs.util.BS;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.V3;
import org.jmol.api.JmolWriter;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.Atom;
import org.jmol.viewer.Viewer;

public class PWMATWriter
implements JmolWriter {
    private Viewer vwr;
    private OC oc;
    private SymmetryInterface uc;

    @Override
    public void set(Viewer viewer, OC oc, Object[] data) {
        this.vwr = viewer;
        this.oc = oc == null ? this.vwr.getOutputChannel(null, null) : oc;
    }

    @Override
    public String write(BS bs) {
        if (bs == null) {
            bs = this.vwr.bsA();
        }
        try {
            int n = bs.cardinality();
            String line = PT.formatStringI("%12i\n", "i", n);
            this.oc.append(line);
            this.uc = this.vwr.ms.getUnitCellForAtom(bs.nextSetBit(0));
            this.writeLattice();
            this.writePositions(bs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.toString();
    }

    private void writeLattice() {
        this.oc.append("Lattice vector\n");
        if (this.uc == null) {
            this.uc = this.vwr.getSymTemp();
            V3 bb = this.vwr.getBoundBoxCornerVector();
            float len = Math.round(bb.length() * 2.0f);
            this.uc.setUnitCell(new float[]{len, len, len, 90.0f, 90.0f, 90.0f}, false);
        }
        P3[] abc = this.uc.getUnitCellVectors();
        String f = "%18.10p%18.10p%18.10p\n";
        this.oc.append(PT.sprintf(f, "p", new Object[]{abc[1]}));
        this.oc.append(PT.sprintf(f, "p", new Object[]{abc[2]}));
        this.oc.append(PT.sprintf(f, "p", new Object[]{abc[3]}));
    }

    private void writePositions(BS bs) {
        this.oc.append("Position, move_x, move_y, move_z\n");
        String f = "%4i%18.12p%18.12p%18.12p  1  1  1\n";
        Atom[] a = this.vwr.ms.at;
        P3 p = new P3();
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            p.setT(a[i]);
            this.uc.toFractional(p, true);
            this.oc.append(PT.sprintf(f, "ip", new Object[]{a[i].getElementNumber(), p}));
            i = bs.nextSetBit(i + 1);
        }
    }

    public String toString() {
        return this.oc == null ? "" : this.oc.toString();
    }
}

