/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.inchi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.P3;
import javajs.util.PT;
import net.sf.jniinchi.INCHI_BOND_TYPE;
import net.sf.jniinchi.INCHI_PARITY;
import net.sf.jniinchi.INCHI_STEREOTYPE;
import net.sf.jniinchi.JniInchiAtom;
import net.sf.jniinchi.JniInchiBond;
import net.sf.jniinchi.JniInchiInput;
import net.sf.jniinchi.JniInchiInputInchi;
import net.sf.jniinchi.JniInchiOutputStructure;
import net.sf.jniinchi.JniInchiStereo0D;
import net.sf.jniinchi.JniInchiStructure;
import net.sf.jniinchi.JniInchiWrapper;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAdapterAtomIterator;
import org.jmol.api.JmolAdapterBondIterator;
import org.jmol.api.JmolInChI;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.util.BSUtil;
import org.jmol.util.Elements;
import org.jmol.util.Node;
import org.jmol.util.SimpleNode;
import org.jmol.viewer.Viewer;

public class InChIJNI
implements JmolInChI {
    private Map<BS, int[]> mapTet;
    private Map<Integer, Boolean> mapPlanar;

    @Override
    public String getInchi(Viewer vwr, BS atoms, String molData, String options) {
        try {
            JniInchiStructure struc;
            Object in;
            String smilesOptions;
            if (atoms == null ? molData == null : atoms.cardinality() == 0) {
                return "";
            }
            boolean getKey = false;
            if (options == null) {
                options = "";
            }
            String inchi = null;
            String lc = options.toLowerCase();
            boolean getSmiles = lc.indexOf("smiles") == 0;
            boolean getStructure = lc.indexOf("structure") >= 0;
            String string = smilesOptions = getSmiles ? options : null;
            if (lc.startsWith("structure/")) {
                inchi = options.substring(10);
                lc = "";
                options = "";
            }
            if (molData != null && molData.startsWith("InChI=")) {
                inchi = molData;
                if (!getSmiles) {
                    options = lc.replace("structure", "");
                    getKey = true;
                }
            } else {
                options = lc;
                boolean bl = getKey = options.indexOf("key") >= 0;
                if (getKey) {
                    options = options.replace("inchikey", "");
                    options = options.replace("key", "");
                }
                if (options.indexOf("fixedh?") >= 0) {
                    String fxd = this.getInchi(vwr, atoms, molData, options.replace('?', ' '));
                    options = PT.rep(options, "fixedh?", "");
                    String std = this.getInchi(vwr, atoms, molData, options);
                    inchi = fxd != null && fxd.length() <= std.length() ? std : fxd;
                } else {
                    in = new JniInchiInput(getSmiles ? "" : options);
                    if (atoms == null) {
                        struc = InChIJNI.newJniInchiStructure(vwr, molData);
                        ((JniInchiStructure)in).setStructure(struc);
                    } else {
                        struc = InChIJNI.newJniInchiStructure(vwr, atoms);
                        ((JniInchiStructure)in).setStructure(struc);
                    }
                    if (getStructure) {
                        return InChIJNI.toString(struc);
                    }
                    inchi = JniInchiWrapper.getInchi((JniInchiInput)in).getInchi();
                }
            }
            if (getSmiles || getStructure) {
                in = new JniInchiInputInchi(inchi);
                struc = JniInchiWrapper.getStructureFromInchi((JniInchiInputInchi)in);
                return getSmiles ? this.getSmiles(vwr, (JniInchiOutputStructure)struc, smilesOptions) : this.getStructure(struc);
            }
            return getKey ? JniInchiWrapper.getInchiKey(inchi).getKey() : inchi;
        }
        catch (Exception e) {
            System.out.println(e);
            if (e.getMessage().indexOf("ption") >= 0) {
                System.out.println(e.getMessage() + ": " + options.toLowerCase() + "\n See https://www.inchi-trust.org/download/104/inchi-faq.pdf for valid options");
            } else {
                e.printStackTrace();
            }
            return "";
        }
    }

    private String getStructure(JniInchiStructure mol) {
        return InChIJNI.toString(mol);
    }

    private static JniInchiStructure newJniInchiStructure(Viewer vwr, BS bsAtoms) {
        JniInchiStructure mol = new JniInchiStructure();
        JniInchiAtom[] atoms = new JniInchiAtom[bsAtoms.cardinality()];
        int[] map = new int[bsAtoms.length()];
        BS bsBonds = vwr.ms.getBondsForSelectedAtoms(bsAtoms, false);
        int pt = 0;
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            Atom a = vwr.ms.at[i];
            String sym = a.getElementSymbol();
            int iso = a.getIsotopeNumber();
            if (a.getElementNumber() == 1) {
                sym = "H";
            }
            atoms[pt] = new JniInchiAtom(a.x, a.y, a.z, sym);
            mol.addAtom(atoms[pt]);
            atoms[pt].setCharge(a.getFormalCharge());
            if (iso > 0) {
                atoms[pt].setIsotopicMass(iso);
            }
            map[i] = pt++;
            i = bsAtoms.nextSetBit(i + 1);
        }
        Bond[] bonds = vwr.ms.bo;
        i = bsBonds.nextSetBit(0);
        while (i >= 0) {
            Bond bond = bonds[i];
            INCHI_BOND_TYPE order = InChIJNI.getOrder(bond.getCovalentOrder());
            if (order != null) {
                mol.addBond(new JniInchiBond(atoms[map[bond.getAtomIndex1()]], atoms[map[bond.getAtomIndex2()]], order));
            }
            i = bsBonds.nextSetBit(i + 1);
        }
        return mol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JniInchiStructure newJniInchiStructure(Viewer vwr, String molData) {
        JniInchiStructure mol = new JniInchiStructure();
        BufferedReader r = new BufferedReader(new StringReader(molData));
        try {
            Hashtable<String, Object> htParams = new Hashtable<String, Object>();
            JmolAdapter adapter = vwr.getModelAdapter();
            Object atomSetReader = adapter.getAtomSetCollectionReader("String", null, r, htParams);
            if (atomSetReader instanceof String) {
                System.err.println("InChIJNI could not read molData");
                JniInchiStructure jniInchiStructure = null;
                return jniInchiStructure;
            }
            AtomSetCollection asc = (AtomSetCollection)adapter.getAtomSetCollection(atomSetReader);
            JmolAdapterAtomIterator ai = adapter.getAtomIterator(asc);
            JmolAdapterBondIterator bi = adapter.getBondIterator(asc);
            JniInchiAtom[] atoms = new JniInchiAtom[asc.getAtomSetAtomCount(0)];
            int n = 0;
            while (ai.hasNext() && n < atoms.length) {
                P3 p = ai.getXYZ();
                JniInchiAtom a = new JniInchiAtom(p.x, p.y, p.z, Elements.elementSymbolFromNumber(ai.getElementNumber()));
                a.setCharge(ai.getFormalCharge());
                mol.addAtom(a);
                atoms[n++] = a;
            }
            while (bi.hasNext()) {
                INCHI_BOND_TYPE order = InChIJNI.getOrder(bi.getEncodedOrder());
                if (order == null) continue;
                mol.addBond(new JniInchiBond(atoms[(Integer)bi.getAtomUniqueID1()], atoms[(Integer)bi.getAtomUniqueID2()], order));
            }
        }
        finally {
            try {
                r.close();
            }
            catch (IOException iOException) {}
        }
        return mol;
    }

    private static INCHI_BOND_TYPE getOrder(int order) {
        switch (order) {
            case 1: {
                return INCHI_BOND_TYPE.SINGLE;
            }
            case 2: {
                return INCHI_BOND_TYPE.DOUBLE;
            }
            case 3: {
                return INCHI_BOND_TYPE.TRIPLE;
            }
        }
        return null;
    }

    private static String toString(JniInchiStructure mol) {
        int i;
        int na = mol.getNumAtoms();
        int nb = mol.getNumBonds();
        String s = "";
        for (i = 0; i < na; ++i) {
            s = s + mol.getAtom(i).getDebugString() + "\n";
        }
        for (i = 0; i < nb; ++i) {
            s = s + mol.getBond(i).getDebugString() + "\n";
        }
        return s;
    }

    private String getSmiles(Viewer vwr, JniInchiOutputStructure struc, String smilesOptions) {
        SmilesBond sb;
        int i;
        int nAtoms = struc.getNumAtoms();
        int nBonds = struc.getNumBonds();
        int nh = 0;
        for (int i2 = 0; i2 < nAtoms; ++i2) {
            JniInchiAtom a = struc.getAtom(i2);
            nh += a.getImplicitH();
        }
        Node[] atoms = new SmilesAtom[nAtoms + nh];
        Hashtable<JniInchiAtom, 1> map = new Hashtable<JniInchiAtom, 1>();
        this.mapTet = new Hashtable<BS, int[]>();
        this.mapPlanar = new Hashtable<Integer, Boolean>();
        int nb = 0;
        int na = 0;
        for (i = 0; i < nAtoms; ++i) {
            JniInchiAtom a = struc.getAtom(i);
            SmilesAtom n = atoms[na] = new SmilesAtom(){

                @Override
                public boolean definesStereo() {
                    return true;
                }

                @Override
                public String getStereoAtAt(SimpleNode[] nodes) {
                    return InChIJNI.this.decodeInchiStereo(nodes);
                }

                @Override
                public Boolean isStereoOpposite(int iatom) {
                    return InChIJNI.this.isInchiOpposite(this.getIndex(), iatom);
                }
            };
            n.set((float)a.getX(), (float)a.getY(), (float)a.getZ());
            n.setIndex(na++);
            n.setCharge(a.getCharge());
            n.setSymbol(a.getElementType());
            nh = a.getImplicitH();
            for (int j = 0; j < nh; ++j) {
                atoms[na] = new SmilesAtom();
                SmilesAtom h = atoms[na];
                h.setIndex(na++);
                h.setSymbol("H");
                sb = new SmilesBond(n, h, 1, false);
                sb.index = nb++;
            }
            map.put(a, n);
        }
        for (i = 0; i < nBonds; ++i) {
            JniInchiBond b = struc.getBond(i);
            JniInchiAtom a1 = b.getOriginAtom();
            JniInchiAtom a2 = b.getTargetAtom();
            int bt = InChIJNI.getJmolBondType(b);
            sb = new SmilesBond((SmilesAtom)map.get(a1), (SmilesAtom)map.get(a2), bt, false);
            sb.index = nb++;
        }
        for (i = 0; i < na; ++i) {
            atoms[i].setBondArray();
        }
        i = struc.getNumStereo0D();
        block11: while (--i >= 0) {
            JniInchiStereo0D sd = struc.getStereo0D(i);
            JniInchiAtom[] an = sd.getNeighbors();
            if (an.length != 4) continue;
            JniInchiAtom ca = sd.getCentralAtom();
            int i0 = ((SmilesAtom)map.get(an[0])).getIndex();
            int i1 = ((SmilesAtom)map.get(an[1])).getIndex();
            int i2 = ((SmilesAtom)map.get(an[2])).getIndex();
            int i3 = ((SmilesAtom)map.get(an[3])).getIndex();
            boolean isEven = sd.getParity() == INCHI_PARITY.EVEN;
            INCHI_STEREOTYPE type = sd.getStereoType();
            switch (type) {
                case ALLENE: 
                case DOUBLEBOND: {
                    i1 = InChIJNI.getOtherEneAtom((SmilesAtom[])atoms, i1, i0);
                    i2 = InChIJNI.getOtherEneAtom((SmilesAtom[])atoms, i2, i3);
                    break;
                }
                case NONE: {
                    continue block11;
                }
            }
            if (ca == null) {
                this.mapPlanar.put(InChIJNI.getIntKey(i0, i3), isEven);
                this.mapPlanar.put(InChIJNI.getIntKey(i0, i2), !isEven);
                this.mapPlanar.put(InChIJNI.getIntKey(i1, i3), !isEven);
                this.mapPlanar.put(InChIJNI.getIntKey(i1, i2), isEven);
                continue;
            }
            int[] list = new int[]{isEven ? i0 : i1, isEven ? i1 : i0, i2, i3};
            this.mapTet.put(InChIJNI.orderList(list), list);
        }
        try {
            SmilesMatcherInterface m = vwr.getSmilesMatcher();
            return m.getSmiles(atoms, na, BSUtil.newBitSet2(0, na), smilesOptions, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    protected Boolean isInchiOpposite(int index, int iatom) {
        return this.mapPlanar.get(InChIJNI.getIntKey(index, iatom));
    }

    protected String decodeInchiStereo(SimpleNode[] nodes) {
        int[] list = new int[]{InChIJNI.getNodeIndex(nodes[0]), InChIJNI.getNodeIndex(nodes[1]), InChIJNI.getNodeIndex(nodes[2]), InChIJNI.getNodeIndex(nodes[3])};
        int[] list2 = this.mapTet.get(InChIJNI.orderList(list));
        return list2 == null ? null : (InChIJNI.isPermutation(list, list2) ? "@@" : "@");
    }

    private static int getNodeIndex(SimpleNode node) {
        return node == null ? -1 : node.getIndex();
    }

    private static Integer getIntKey(int i, int j) {
        return (Math.min(i, j) << 12) + Math.max(i, j);
    }

    private static BS orderList(int[] list) {
        BS bs = new BS();
        for (int i = 0; i < list.length; ++i) {
            bs.set(list[i]);
        }
        return bs;
    }

    private static boolean isPermutation(int[] list, int[] list2) {
        boolean ok = true;
        for (int i = 0; i < 3; ++i) {
            int l1 = list[i];
            for (int j = i + 1; j < 4; ++j) {
                int l2 = list2[j];
                if (l2 != l1 || j == i) continue;
                list2[j] = list2[i];
                list2[i] = l2;
                ok = !ok;
            }
        }
        return ok;
    }

    private static int getOtherEneAtom(SmilesAtom[] atoms, int i0, int i1) {
        SmilesAtom a = atoms[i0];
        int i = a.getBondCount();
        while (--i >= 0) {
            int i2;
            if (a.getBond(i).getBondType() != 1 || (i2 = a.getBondedAtomIndex(i)) == i1) continue;
            return i2;
        }
        return -1;
    }

    private static int getJmolBondType(JniInchiBond b) {
        INCHI_BOND_TYPE type = b.getBondType();
        switch (type) {
            case NONE: {
                return 0;
            }
            case ALTERN: {
                return 515;
            }
            case DOUBLE: {
                return 2;
            }
            case TRIPLE: {
                return 3;
            }
        }
        return 1;
    }
}

