/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import org.jmol.modelset.Atom;
import org.jmol.modelset.Text;
import org.jmol.render.LabelsRenderer;
import org.jmol.render.TextRenderer;
import org.jmol.shape.Echo;
import org.jmol.util.C;
import org.jmol.util.Txt;

public class EchoRenderer
extends LabelsRenderer {
    @Override
    protected boolean render() {
        String frameTitle;
        if (this.vwr.isPreviewOnly) {
            return false;
        }
        Echo echo = (Echo)this.shape;
        this.sppm = this.vwr.getBoolean(603979845) ? this.vwr.getScalePixelsPerAngstrom(true) * 10000.0f : 0.0f;
        this.imageFontScaling = this.vwr.imageFontScaling;
        boolean haveTranslucent = false;
        for (Text t : echo.objects.values()) {
            if (!t.visible || t.hidden || t.pointerPt instanceof Atom && !((Atom)t.pointerPt).checkVisible()) continue;
            if (t.valign == 4) {
                this.tm.transformPtScr(t.xyz, this.pt0i);
                t.setXYZs(this.pt0i.x, this.pt0i.y, this.pt0i.z, this.pt0i.z);
            }
            if (t.pymolOffset != null) {
                t.getPymolScreenOffset(t.xyz, this.pt0i, this.zSlab, this.pTemp, this.sppm);
            } else if (t.movableZPercent != Integer.MAX_VALUE) {
                int z = this.vwr.tm.zValueFromPercent(t.movableZPercent % 1000);
                if (t.valign == 4 && Math.abs(t.movableZPercent) >= 1000) {
                    z = this.pt0i.z - this.vwr.tm.zValueFromPercent(0) + z;
                }
                t.setZs(z, z);
            }
            if (t.pointerPt == null) {
                t.pointer = 0;
            } else {
                t.pointer = 1;
                this.tm.transformPtScr(t.pointerPt, this.pt0i);
                t.atomX = this.pt0i.x;
                t.atomY = this.pt0i.y;
                t.atomZ = this.pt0i.z;
                if (t.zSlab == Integer.MIN_VALUE) {
                    t.zSlab = 1;
                }
            }
            if (TextRenderer.render(t, this.g3d, this.sppm, this.imageFontScaling, false, null, this.xy, false, (short)0, 0, false) && t.valign == 1 && t.align == 12) {
                this.vwr.noFrankEcho = false;
            }
            if (!C.renderPass2(t.bgcolix) && !C.renderPass2(t.colix)) continue;
            haveTranslucent = true;
        }
        if (!this.isExport && (frameTitle = this.vwr.getFrameTitle()) != null && frameTitle.length() > 0 && this.g3d.setC(this.vwr.cm.colixBackgroundContrast)) {
            if (frameTitle.indexOf("%{") >= 0 || frameTitle.indexOf("@{") >= 0) {
                frameTitle = Txt.formatText(this.vwr, frameTitle);
            }
            this.renderFrameTitle(frameTitle);
        }
        return haveTranslucent;
    }

    private void renderFrameTitle(String frameTitle) {
        this.vwr.gdata.setFontBold("arial", (int)(24.0f * this.imageFontScaling));
        int y = (int)Math.floor((float)(this.vwr.getScreenHeight() * (this.g3d.isAntialiased() ? 2 : 1)) - 10.0f * this.imageFontScaling);
        int x = (int)Math.floor(5.0f * this.imageFontScaling);
        this.g3d.drawStringNoSlab(frameTitle, null, x, y, 0, (short)0);
    }
}

