/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.modelset.Atom;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshCollection;
import org.jmol.shapesurface.Isosurface;
import org.jmol.util.C;
import org.jmol.util.Escape;

public class LcaoCartoon
extends Isosurface {
    private String thisType;
    private int myColorPt;
    private String lcaoID;
    private BS thisSet;
    private boolean isMolecular;
    private V3 rotationAxis;
    private Float lcaoScale;
    private boolean lcaoTranslucent;
    private float lcaoTranslucentLevel;
    private Integer lcaoColorPos;
    private Integer lcaoColorNeg;
    boolean isLonePair;
    boolean isRadical;
    private Object cappingObject;
    private Object slabbingObject;
    private String fullCommand;

    @Override
    public void initShape() {
        super.initShape();
        this.myType = "lcaoCartoon";
        this.allowMesh = false;
    }

    @Override
    public void setProperty(String propertyName, Object value, BS bs) {
        boolean setInfo = false;
        if ("init" == propertyName) {
            this.myColorPt = 0;
            this.lcaoID = null;
            this.thisSet = bs;
            this.isRadical = false;
            this.isLonePair = false;
            this.isMolecular = false;
            this.thisType = null;
            this.rotationAxis = null;
            this.fullCommand = (String)value;
            this.setPropI("init", null, null);
            return;
        }
        if ("lcaoID" == propertyName) {
            this.lcaoID = (String)value;
            return;
        }
        if ("thisID" == propertyName) {
            this.lcaoID = (String)value;
        }
        if ("selectType" == propertyName) {
            this.thisType = (String)value;
            return;
        }
        if ("rotationAxis" == propertyName) {
            this.rotationAxis = (V3)value;
            return;
        }
        if ("scale" == propertyName) {
            this.lcaoScale = (Float)value;
        }
        if ("colorRGB" == propertyName) {
            this.lcaoColorPos = (Integer)value;
            if (this.myColorPt++ == 0) {
                this.lcaoColorNeg = this.lcaoColorPos;
            }
        }
        if ("select" == propertyName) {
            this.thisSet = (BS)value;
        }
        if ("translucentLevel" == propertyName) {
            this.lcaoTranslucentLevel = ((Float)value).floatValue();
        }
        if ("settranslucency" == propertyName) {
            this.lcaoTranslucent = ((String)value).equals("translucent");
            return;
        }
        if ("translucency" == propertyName) {
            this.lcaoTranslucent = ((String)value).equals("translucent");
            if (this.lcaoID == null) {
                return;
            }
        }
        if ("molecular" == propertyName) {
            this.isMolecular = true;
            if (value == null) {
                return;
            }
            propertyName = "create";
        }
        if ("create" == propertyName) {
            this.myColorPt = 0;
            this.thisType = (String)value;
            this.createLcaoCartoon();
            return;
        }
        if ("lonePair" == propertyName) {
            this.isLonePair = true;
            return;
        }
        if ("lp" == propertyName) {
            setInfo = true;
            this.isLonePair = true;
        }
        if ("radical" == propertyName) {
            this.isRadical = true;
            return;
        }
        if ("rad" == propertyName) {
            setInfo = true;
            this.isRadical = true;
        }
        if ("delete" == propertyName) {
            this.deleteLcaoCartoon();
            return;
        }
        if ("on" == propertyName) {
            this.setLcaoOn(true);
            return;
        }
        if ("off" == propertyName) {
            this.setLcaoOn(false);
            return;
        }
        if ("slab" == propertyName) {
            this.slabbingObject = value;
        }
        if ("cap" == propertyName) {
            this.cappingObject = value;
        }
        if ("lobe" == propertyName || "sphere" == propertyName) {
            this.getCapSlabInfo(this.fullCommand);
        }
        this.setPropI(propertyName, value, bs);
        if (setInfo || "lobe" == propertyName || "sphere" == propertyName) {
            this.setScriptInfo(null);
        }
    }

    private void setLcaoOn(boolean TF) {
        if (PT.isWild(this.lcaoID)) {
            Lst<Mesh> list = this.getMeshList(this.lcaoID, false);
            int i = list.size();
            while (--i >= 0) {
                ((Mesh)list.get((int)i)).visible = TF;
            }
            return;
        }
        int ac = this.vwr.ms.ac;
        Atom[] at = this.vwr.ms.at;
        int i = ac;
        while (--i >= 0) {
            if (this.lcaoID == null && !this.thisSet.get(i)) continue;
            this.setLcaoOn(i, TF && at[i] != null);
        }
    }

    private void setLcaoOn(int iAtom, boolean TF) {
        String id = this.getID(this.lcaoID, iAtom);
        int i = this.meshCount;
        while (--i >= 0) {
            if (this.meshes[i].thisID.indexOf(id) != 0) continue;
            this.meshes[i].visible = TF;
        }
    }

    private void deleteLcaoCartoon() {
        int ac;
        if (PT.isWild(this.lcaoID)) {
            this.deleteMeshKey(this.lcaoID);
            return;
        }
        int i = ac = this.vwr.ms.ac;
        while (--i >= 0) {
            if (this.lcaoID == null && !this.thisSet.get(i)) continue;
            this.deleteLcaoCartoon(i);
        }
    }

    private void deleteLcaoCartoon(int iAtom) {
        String id = this.getID(this.lcaoID, iAtom);
        int i = this.meshCount;
        while (--i >= 0) {
            if (this.meshes[i].thisID.indexOf(id) != 0) continue;
            this.deleteMeshI(i);
        }
    }

    private void createLcaoCartoon() {
        this.isMolecular = this.isMolecular && (this.thisType.indexOf("px") >= 0 || this.thisType.indexOf("py") >= 0 || this.thisType.indexOf("pz") >= 0);
        String lcaoID0 = this.lcaoID;
        int i = this.thisSet.nextSetBit(0);
        while (i >= 0) {
            this.createLcaoCartoon(i);
            this.lcaoID = lcaoID0;
            i = this.thisSet.nextSetBit(i + 1);
        }
    }

    private void createLcaoCartoon(int iAtom) {
        String id = this.getID(this.lcaoID, iAtom);
        boolean isCpk = this.thisType.equals("cpk");
        int i = this.meshCount;
        while (--i >= 0) {
            if (this.meshes[i].thisID.indexOf(id) != 0) continue;
            this.deleteMeshI(i);
        }
        this.setPropI("init", null, null);
        this.translucentLevel = this.lcaoTranslucentLevel;
        this.setPropI("thisID", id, null);
        if (this.lcaoScale != null) {
            this.setPropI("scale", this.lcaoScale, null);
        }
        if (isCpk) {
            this.setPropI("colorRGB", this.vwr.gdata.getColorArgbOrGray(this.ms.at[iAtom].colixAtom), null);
        } else if (this.lcaoColorNeg != null) {
            this.setPropI("colorRGB", this.lcaoColorNeg, null);
            this.setPropI("colorRGB", this.lcaoColorPos, null);
        }
        if (this.slabbingObject != null) {
            this.setPropI("slab", this.slabbingObject, null);
        }
        if (this.cappingObject != null) {
            this.setPropI("cap", this.cappingObject, null);
        }
        this.setPropI("lcaoType", this.thisType, null);
        this.setPropI("atomIndex", iAtom, null);
        V3[] axes = new V3[]{new V3(), new V3(), V3.newV(this.ms.at[iAtom]), new V3()};
        if (this.rotationAxis != null) {
            axes[3].setT(this.rotationAxis);
        }
        if (this.isMolecular) {
            if (this.thisType.indexOf("px") >= 0) {
                axes[0].set(0.0f, -1.0f, 0.0f);
                axes[1].set(1.0f, 0.0f, 0.0f);
            } else if (this.thisType.indexOf("py") >= 0) {
                axes[0].set(-1.0f, 0.0f, 0.0f);
                axes[1].set(0.0f, 0.0f, 1.0f);
            } else if (this.thisType.indexOf("pz") >= 0) {
                axes[0].set(0.0f, 0.0f, 1.0f);
                axes[1].set(1.0f, 0.0f, 0.0f);
            }
            if (this.thisType.indexOf("-") == 0) {
                axes[0].scale(-1.0f);
            }
        }
        if (this.isMolecular || isCpk || this.thisType.equalsIgnoreCase("s") || this.vwr.getHybridizationAndAxes(iAtom, axes[0], axes[1], this.thisType) != null) {
            this.setPropI(this.isRadical ? "radical" : (this.isLonePair ? "lonePair" : "lcaoCartoon"), axes, null);
        }
        if (isCpk) {
            short colix = this.vwr.ms.at[iAtom].colixAtom;
            if (C.isColixTranslucent(colix)) {
                this.setPropI("translucentLevel", Float.valueOf(C.getColixTranslucencyLevel(colix)), null);
                this.setPropI("translucency", "translucent", null);
            }
        } else if (this.lcaoTranslucent) {
            int i2 = this.meshCount;
            while (--i2 >= 0) {
                if (this.meshes[i2].thisID.indexOf(id) != 0) continue;
                this.meshes[i2].setTranslucent(true, this.translucentLevel);
            }
        }
    }

    private String getID(String id, int i) {
        return (id != null ? id : (this.isLonePair || this.isRadical ? "lp_" : "lcao_") + (i + 1) + "_") + (this.thisType == null ? "" : PT.rep(this.thisType, "-", this.thisType.indexOf("-p") == 0 ? "" : "_"));
    }

    @Override
    public String getShapeState() {
        SB sb = new SB();
        if (this.lcaoScale != null) {
            LcaoCartoon.appendCmd(sb, "lcaoCartoon scale " + this.lcaoScale.floatValue());
        }
        if (this.lcaoColorNeg != null) {
            LcaoCartoon.appendCmd(sb, "lcaoCartoon color " + Escape.escapeColor(this.lcaoColorNeg) + " " + Escape.escapeColor(this.lcaoColorPos));
        }
        if (this.lcaoTranslucent) {
            LcaoCartoon.appendCmd(sb, "lcaoCartoon translucent " + this.translucentLevel);
        }
        int i = this.meshCount;
        while (--i >= 0) {
            if (this.meshes[i].visible) continue;
            LcaoCartoon.appendCmd(sb, "lcaoCartoon ID " + this.meshes[i].thisID + " off");
        }
        return super.getShapeState() + sb.toString();
    }

    @Override
    public void merge(MeshCollection shape) {
        LcaoCartoon lc = (LcaoCartoon)shape;
        this.lcaoScale = lc.lcaoScale;
        this.lcaoColorNeg = lc.lcaoColorNeg;
        this.lcaoTranslucent = lc.lcaoTranslucent;
        this.lcaoTranslucentLevel = lc.lcaoTranslucentLevel;
        super.merge(shape);
    }
}

