/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesStereo;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.SimpleNode;
import org.jmol.viewer.JC;

public class SmilesAtom
extends P3
implements Node {
    static final String UNBRACKETED_SET = "B, C, N, O, P, S, F, Cl, Br, I, *,";
    int patternIndex = -1;
    String pattern;
    int primitiveType;
    boolean isAND;
    SmilesAtom[] subAtoms;
    int nSubAtoms;
    int index;
    String referance;
    String residueName;
    String residueChar;
    char insCode;
    boolean isBioAtom;
    boolean isBioResidue;
    boolean isBioAtomWild;
    char bioType = '\u0000';
    boolean isLeadAtom;
    int notBondedIndex = -1;
    boolean notCrossLinked;
    boolean aromaticAmbiguous = true;
    private int covalentHydrogenCount = -1;
    boolean not;
    boolean selected;
    boolean hasSymbol;
    boolean elementDefined;
    String atomType;
    String bioAtomName;
    boolean isFirst = true;
    int jmolIndex = -1;
    int elementNumber = -2;
    int atomNumber = Integer.MIN_VALUE;
    int residueNumber = Integer.MIN_VALUE;
    int explicitHydrogenCount = Integer.MIN_VALUE;
    int implicitHydrogenCount = Integer.MIN_VALUE;
    SmilesAtom parent;
    SmilesBond[] bonds = new SmilesBond[4];
    int bondCount;
    int iNested = 0;
    boolean isAromatic;
    private int atomicMass = Integer.MIN_VALUE;
    private int charge = Integer.MIN_VALUE;
    private int matchingIndex = -1;
    public SmilesStereo stereo;
    int component = Integer.MIN_VALUE;
    int matchingComponent;
    int atomSite;
    int degree = -1;
    int nonhydrogenDegree = -1;
    int valence = 0;
    int connectivity = -1;
    int ringMembership = Integer.MIN_VALUE;
    int ringSize = Integer.MIN_VALUE;
    int ringConnectivity = -1;
    private Node matchingNode;
    boolean hasSubpattern;
    int mapIndex = -1;
    float atomClass = Float.NaN;
    String symbol;
    private boolean isTopoAtom;
    private int missingHydrogenCount;
    private int cipChirality;

    static boolean allowSmilesUnbracketed(String xx) {
        return UNBRACKETED_SET.indexOf(xx + ",") >= 0;
    }

    @Override
    public String getAtomType() {
        return this.atomType == null ? this.bioAtomName : this.atomType;
    }

    public int getChiralClass() {
        return this.stereo == null ? Integer.MIN_VALUE : this.stereo.getChiralClass(this);
    }

    public boolean isDefined() {
        return this.hasSubpattern || this.iNested != 0 || this.isBioAtom || this.component != Integer.MIN_VALUE || this.elementNumber != -2 || this.nSubAtoms > 0;
    }

    void setBioAtom(char bioType) {
        this.isBioAtom = bioType != '\u0000';
        this.bioType = bioType;
        if (this.parent != null) {
            this.parent.bioType = bioType;
            this.parent.isBioAtom = this.isBioAtom;
            this.parent.isBioAtomWild = this.isBioAtomWild;
        }
    }

    void setAtomName(String name) {
        if (name == null) {
            return;
        }
        if (name.length() > 0) {
            this.bioAtomName = name;
        }
        if (name.equals("\u0000")) {
            this.isLeadAtom = true;
        }
        if (this.parent != null) {
            this.parent.bioAtomName = name;
        }
    }

    public void setBonds(SmilesBond[] bonds) {
        this.bonds = bonds;
    }

    SmilesAtom addSubAtom(SmilesAtom sAtom, boolean isAND) {
        this.isAND = isAND;
        if (this.subAtoms == null) {
            this.subAtoms = new SmilesAtom[2];
        }
        if (this.nSubAtoms >= this.subAtoms.length) {
            this.subAtoms = (SmilesAtom[])AU.doubleLength(this.subAtoms);
        }
        sAtom.setIndex(this.index);
        sAtom.parent = this;
        this.subAtoms[this.nSubAtoms++] = sAtom;
        this.setSymbol("*");
        this.hasSymbol = false;
        return sAtom;
    }

    public SmilesAtom setIndex(int index) {
        this.index = index;
        return this;
    }

    public SmilesAtom setTopoAtom(int iComponent, int ptAtom, String symbol, int charge, int patternIndex) {
        this.component = iComponent;
        this.index = ptAtom;
        this.patternIndex = patternIndex;
        this.setSymbol(symbol);
        this.charge = charge;
        this.isTopoAtom = true;
        return this;
    }

    public boolean setHydrogenCount() {
        this.missingHydrogenCount = this.explicitHydrogenCount;
        if (this.explicitHydrogenCount != Integer.MIN_VALUE) {
            return true;
        }
        int count = SmilesAtom.getDefaultCount(this.elementNumber, this.isAromatic);
        if (count < 0) {
            this.missingHydrogenCount = 0;
            return count == -1;
        }
        if (this.elementNumber == 7 && this.isAromatic && this.bondCount == 2 && this.bonds[0].getBondType() == 1 && this.bonds[1].getBondType() == 1) {
            ++count;
        }
        block6: for (int i = 0; i < this.bondCount; ++i) {
            SmilesBond bond = this.bonds[i];
            switch (bond.getBondType()) {
                case 81: {
                    if (this.elementNumber == 7) {
                        Logger.info("Ambiguous bonding to aromatic N found -- MF may be in error");
                    }
                    --count;
                    continue block6;
                }
                case 1025: 
                case 1041: 
                case 65537: 
                case 65538: {
                    --count;
                    continue block6;
                }
                case 2: {
                    count -= this.isAromatic && this.elementNumber == 6 ? 1 : 2;
                    continue block6;
                }
                case 1: 
                case 3: 
                case 4: {
                    count -= bond.getBondType();
                }
            }
        }
        if (count >= 0) {
            this.missingHydrogenCount = this.explicitHydrogenCount = count;
        }
        return true;
    }

    static int getDefaultCount(int elementNumber, boolean isAromatic) {
        switch (elementNumber) {
            case -2: 
            case -1: 
            case 0: {
                return -1;
            }
            case 6: {
                return isAromatic ? 3 : 4;
            }
            case 8: 
            case 16: {
                return 2;
            }
            case 7: {
                return isAromatic ? 2 : 3;
            }
            case 5: 
            case 15: {
                return 3;
            }
            case 9: 
            case 17: 
            case 35: 
            case 53: {
                return 1;
            }
        }
        return -2;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public boolean setSymbol(String symbol) {
        this.symbol = symbol;
        this.isAromatic = symbol.equals(symbol.toLowerCase());
        this.hasSymbol = true;
        this.elementDefined = true;
        if (symbol.equals("*")) {
            this.isAromatic = false;
            this.elementNumber = -2;
            return true;
        }
        if (symbol.equals("Xx")) {
            this.elementNumber = 0;
            return true;
        }
        this.aromaticAmbiguous = false;
        if (symbol.equals("a") || symbol.equals("A")) {
            if (this.elementNumber < 0) {
                this.elementNumber = -1;
            }
            return true;
        }
        if (this.isAromatic) {
            symbol = symbol.substring(0, 1).toUpperCase() + (symbol.length() == 1 ? "" : symbol.substring(1));
        }
        this.elementNumber = Elements.elementNumberFromSymbol(symbol, true);
        return this.elementNumber != 0;
    }

    @Override
    public int getElementNumber() {
        return this.elementNumber;
    }

    public int getAtomicMass() {
        return this.atomicMass;
    }

    @Override
    public int getAtomNumber() {
        return this.atomNumber;
    }

    public void setAtomicMass(int mass) {
        this.atomicMass = mass;
    }

    public int getCharge() {
        return this.charge;
    }

    public void setCharge(int charge) {
        this.charge = charge;
    }

    public int getMatchingAtomIndex() {
        return this.matchingIndex;
    }

    public Node getMatchingAtom() {
        return this.matchingNode == null ? this : this.matchingNode;
    }

    public void setMatchingAtom(Node jmolAtom, int index) {
        this.matchingNode = jmolAtom;
        this.matchingIndex = index;
    }

    public void setExplicitHydrogenCount(int count) {
        this.explicitHydrogenCount = count;
    }

    public void setImplicitHydrogenCount(int count) {
        this.implicitHydrogenCount = count;
    }

    public void setDegree(int degree) {
        this.degree = degree;
    }

    public void setNonhydrogenDegree(int degree) {
        this.nonhydrogenDegree = degree;
    }

    public void setValence(int valence) {
        this.valence = valence;
    }

    public void setConnectivity(int connectivity) {
        this.connectivity = connectivity;
    }

    public void setRingMembership(int rm) {
        this.ringMembership = rm;
    }

    public void setRingSize(int rs) {
        this.ringSize = rs;
        if (this.ringSize == 500 || this.ringSize == 600) {
            this.isAromatic = true;
        }
    }

    public void setRingConnectivity(int rc) {
        this.ringConnectivity = rc;
    }

    @Override
    public int getModelIndex() {
        return this.component;
    }

    @Override
    public int getMoleculeNumber(boolean inModel) {
        return this.component;
    }

    @Override
    public int getAtomSite() {
        return this.atomSite;
    }

    @Override
    public int getFormalCharge() {
        return this.charge;
    }

    @Override
    public int getIsotopeNumber() {
        return this.atomicMass;
    }

    @Override
    public int getAtomicAndIsotopeNumber() {
        return Elements.getAtomicAndIsotopeNumber(this.elementNumber, this.atomicMass);
    }

    @Override
    public String getAtomName() {
        return this.bioAtomName == null ? "" : this.bioAtomName;
    }

    @Override
    public String getGroup3(boolean allowNull) {
        return this.residueName == null ? "" : this.residueName;
    }

    @Override
    public String getGroup1(char c0) {
        return this.residueChar == null ? "" : this.residueChar;
    }

    void addBond(SmilesBond bond) {
        if (this.bondCount >= this.bonds.length) {
            this.bonds = (SmilesBond[])AU.doubleLength(this.bonds);
        }
        this.bonds[this.bondCount] = bond;
        ++this.bondCount;
    }

    public void setBondArray() {
        if (this.bonds.length > this.bondCount) {
            this.bonds = (SmilesBond[])AU.arrayCopyObject(this.bonds, this.bondCount);
        }
        if (this.subAtoms != null && this.subAtoms.length > this.nSubAtoms) {
            this.subAtoms = (SmilesAtom[])AU.arrayCopyObject(this.subAtoms, this.subAtoms.length);
        }
        for (int i = 0; i < this.bonds.length; ++i) {
            SmilesBond b = this.bonds[i];
            if (this.isBioAtom && b.getBondType() == 17) {
                b.order = 112;
            }
            if (b.atom1.index <= b.atom2.index) continue;
            b.switchAtoms();
        }
    }

    @Override
    public Edge[] getEdges() {
        return this.parent != null ? this.parent.getEdges() : this.bonds;
    }

    public SmilesBond getBond(int number) {
        return this.parent != null ? this.parent.getBond(number) : (number >= 0 && number < this.bondCount ? this.bonds[number] : null);
    }

    @Override
    public int getCovalentBondCount() {
        return this.getBondCount();
    }

    @Override
    public int getBondCount() {
        return this.parent != null ? this.parent.getBondCount() : this.bondCount;
    }

    @Override
    public int getCovalentBondCountPlusMissingH() {
        return this.getBondCount() + (this.isTopoAtom ? 0 : this.missingHydrogenCount);
    }

    @Override
    public int getTotalHydrogenCount() {
        return this.getCovalentHydrogenCount() + (this.isTopoAtom ? 0 : this.missingHydrogenCount);
    }

    @Override
    public int getImplicitHydrogenCount() {
        return this.implicitHydrogenCount;
    }

    public int getExplicitHydrogenCount() {
        return this.explicitHydrogenCount;
    }

    public int getMatchingBondedAtom(int i) {
        if (this.parent != null) {
            return this.parent.getMatchingBondedAtom(i);
        }
        if (i >= this.bondCount) {
            return -1;
        }
        SmilesBond b = this.bonds[i];
        return (b.atom1 == this ? b.atom2 : b.atom1).matchingIndex;
    }

    @Override
    public int getBondedAtomIndex(int j) {
        return this.parent != null ? this.parent.getBondedAtomIndex(j) : this.bonds[j].getOtherAtom((SmilesAtom)this).index;
    }

    @Override
    public int getCovalentHydrogenCount() {
        if (this.covalentHydrogenCount >= 0) {
            return this.covalentHydrogenCount;
        }
        if (this.parent != null) {
            this.covalentHydrogenCount = this.parent.getCovalentHydrogenCount();
            return this.covalentHydrogenCount;
        }
        this.covalentHydrogenCount = 0;
        for (int k = 0; k < this.bonds.length; ++k) {
            if (this.bonds[k].getOtherAtom((SmilesAtom)this).elementNumber != 1) continue;
            ++this.covalentHydrogenCount;
        }
        return this.covalentHydrogenCount;
    }

    @Override
    public int getValence() {
        if (this.parent != null) {
            return this.parent.getValence();
        }
        int n = this.valence;
        if (n <= 0 && this.bonds != null) {
            int i = this.bonds.length;
            while (--i >= 0) {
                n += this.bonds[i].getValence();
            }
        }
        this.valence = n;
        return n;
    }

    @Override
    public int getTotalValence() {
        return this.getValence() + (this.isTopoAtom ? 0 : this.missingHydrogenCount);
    }

    SmilesBond getBondTo(SmilesAtom atom) {
        if (this.parent != null) {
            return this.parent.getBondTo(atom);
        }
        for (int k = 0; k < this.bonds.length; ++k) {
            SmilesBond bond = this.bonds[k];
            if (bond == null || !(atom == null ? bond.atom2 == this : bond.getOtherAtom(this) == atom)) continue;
            return bond;
        }
        return null;
    }

    SmilesBond getBondNotTo(SmilesAtom atom, boolean allowH) {
        for (int k = 0; k < this.bonds.length; ++k) {
            SmilesAtom atom2;
            SmilesBond bond = this.bonds[k];
            if (bond == null || atom == (atom2 = bond.getOtherAtom(this)) || !allowH && atom2.elementNumber == 1) continue;
            return bond;
        }
        return null;
    }

    @Override
    public boolean isLeadAtom() {
        return this.isLeadAtom;
    }

    @Override
    public int getOffsetResidueAtom(String name, int offset) {
        if (this.isBioAtom) {
            if (offset == 0) {
                return this.index;
            }
            for (int k = 0; k < this.bonds.length; ++k) {
                if (this.bonds[k].getAtomIndex1() != this.index || this.bonds[k].getBondType() != 96) continue;
                return this.bonds[k].getOtherAtom((SmilesAtom)this).index;
            }
        }
        return -1;
    }

    @Override
    public void getGroupBits(BS bs) {
        bs.set(this.index);
    }

    @Override
    public boolean isCrossLinked(Node node) {
        SmilesBond bond = this.getBondTo((SmilesAtom)node);
        return bond.isHydrogen();
    }

    @Override
    public boolean getCrossLinkVector(Lst<Integer> vLinks, boolean crosslinkCovalent, boolean crosslinkHBond) {
        boolean haveCrossLinks = false;
        for (int k = 0; k < this.bonds.length; ++k) {
            if (this.bonds[k].order != 112) continue;
            if (vLinks == null) {
                return true;
            }
            vLinks.addLast(this.index);
            vLinks.addLast(this.bonds[k].getOtherAtom((SmilesAtom)this).index);
            vLinks.addLast(this.bonds[k].getOtherAtom((SmilesAtom)this).index);
            haveCrossLinks = true;
        }
        return haveCrossLinks;
    }

    @Override
    public String getBioStructureTypeName() {
        return null;
    }

    @Override
    public char getInsertionCode() {
        return this.insCode;
    }

    @Override
    public int getResno() {
        return this.residueNumber;
    }

    @Override
    public int getChainID() {
        return 0;
    }

    @Override
    public String getChainIDStr() {
        return "";
    }

    static String getAtomLabel(int atomicNumber, int isotopeNumber, int valence, int charge, float osclass, int nH, boolean isAromatic, String stereo, boolean is2D) {
        String sym = Elements.elementSymbolFromNumber(atomicNumber);
        if (isAromatic) {
            sym = sym.toLowerCase();
            if (atomicNumber != 6) {
                valence = Integer.MAX_VALUE;
            }
        }
        boolean simple = valence != Integer.MAX_VALUE && isotopeNumber <= 0 && charge == 0 && Float.isNaN(osclass) && (stereo == null || stereo.length() == 0);
        int norm = SmilesAtom.getDefaultCount(atomicNumber, false);
        if (is2D && nH == 0) {
            if (simple && atomicNumber == 6) {
                return sym;
            }
            nH = norm - valence;
        }
        return simple && norm == valence ? sym : "[" + (isotopeNumber <= 0 ? "" : "" + isotopeNumber) + sym + (stereo == null ? "" : stereo) + (nH > 1 ? "H" + nH : (nH == 1 ? "H" : "")) + (charge < 0 && charge != Integer.MIN_VALUE ? "" + charge : (charge > 0 ? "+" + charge : "")) + (Float.isNaN(osclass) ? "" : ":" + (int)osclass) + "]";
    }

    @Override
    public char getBioSmilesType() {
        return this.bioType;
    }

    public boolean isNucleic() {
        return this.bioType == 'n' || this.bioType == 'r' || this.bioType == 'd';
    }

    @Override
    public boolean isPurine() {
        return this.residueChar != null && this.isNucleic() && "AG".indexOf(this.residueChar) >= 0;
    }

    @Override
    public boolean isPyrimidine() {
        return this.residueChar != null && this.isNucleic() && "CTUI".indexOf(this.residueChar) >= 0;
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public BS findAtomsLike(String substring) {
        return null;
    }

    @Override
    public String toString() {
        String s;
        String string = this.residueChar != null || this.residueName != null ? (this.residueChar == null ? this.residueName : this.residueChar) + "." + this.bioAtomName : (this.bioAtomName != null && this.atomNumber != Integer.MIN_VALUE ? null : (this.elementNumber == -1 ? "A" : (s = this.elementNumber == -2 ? "*" : Elements.elementSymbolFromNumber(this.elementNumber))));
        if (s == null) {
            return this.bioAtomName + " #" + this.atomNumber;
        }
        if (this.isAromatic) {
            s = s.toLowerCase();
        }
        String s2 = "";
        for (int i = 0; i < this.bondCount; ++i) {
            s2 = s2 + this.bonds[i].getOtherAtom((SmilesAtom)this).index + ", ";
        }
        return "[" + s + '.' + this.index + (this.matchingIndex >= 0 ? "(" + this.matchingNode + ")" : "") + "]->" + s2 + "(" + this.x + "," + this.y + "," + this.z + ")";
    }

    @Override
    public float getFloatProperty(String property) {
        if (property == "property_atomclass") {
            return this.atomClass;
        }
        return Float.NaN;
    }

    @Override
    public float getMass() {
        return this.atomicMass;
    }

    @Override
    public String getCIPChirality(boolean doCalculate) {
        return JC.getCIPChiralityName(this.cipChirality & 0xFFFFFF1F);
    }

    @Override
    public void setCIPChirality(int c) {
        this.cipChirality = c;
    }

    @Override
    public int getCIPChiralityCode() {
        return this.cipChirality;
    }

    @Override
    public P3 getXYZ() {
        return this;
    }

    public SmilesStereo getStereo() {
        return this.stereo;
    }

    public int getPatternIndex() {
        return this.patternIndex;
    }

    @Override
    public boolean modelIsRawPDB() {
        return false;
    }

    public boolean definesStereo() {
        return false;
    }

    public String getStereoAtAt(SimpleNode[] nodes) {
        return null;
    }

    public Boolean isStereoOpposite(int iatom) {
        return null;
    }
}

