/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Matrix;
import javajs.util.P3;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.bspt.Bspt;
import org.jmol.bspt.CubeIterator;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;
import org.jmol.symmetry.CIPChirality;
import org.jmol.symmetry.CIPData;
import org.jmol.symmetry.CIPDataSmiles;
import org.jmol.symmetry.PointGroup;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.SpaceGroupFinder;
import org.jmol.symmetry.SymmetryDesc;
import org.jmol.symmetry.SymmetryInfo;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.symmetry.UnitCell;
import org.jmol.symmetry.UnitCellIterator;
import org.jmol.util.Escape;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Tensor;
import org.jmol.viewer.Viewer;

public class Symmetry
implements SymmetryInterface {
    private PointGroup pointGroup;
    SpaceGroup spaceGroup;
    private SymmetryInfo symmetryInfo;
    private UnitCell unitCell;
    private boolean isBio;
    private SymmetryDesc desc;
    CIPChirality cip;

    @Override
    public boolean isBio() {
        return this.isBio;
    }

    @Override
    public SymmetryInterface setPointGroup(SymmetryInterface siLast, T3 center, T3[] atomset, BS bsAtoms, boolean haveVibration, float distanceTolerance, float linearTolerance, boolean localEnvOnly) {
        this.pointGroup = PointGroup.getPointGroup(siLast == null ? null : ((Symmetry)siLast).pointGroup, center, atomset, bsAtoms, haveVibration, distanceTolerance, linearTolerance, localEnvOnly);
        return this;
    }

    @Override
    public String getPointGroupName() {
        return this.pointGroup.getName();
    }

    @Override
    public Object getPointGroupInfo(int modelIndex, String drawID, boolean asInfo, String type, int index, float scale) {
        if (drawID == null && !asInfo && this.pointGroup.textInfo != null) {
            return this.pointGroup.textInfo;
        }
        if (drawID == null && this.pointGroup.isDrawType(type, index, scale)) {
            return this.pointGroup.drawInfo;
        }
        if (asInfo && this.pointGroup.info != null) {
            return this.pointGroup.info;
        }
        return this.pointGroup.getInfo(modelIndex, drawID, asInfo, type, index, scale);
    }

    @Override
    public void setSpaceGroup(boolean doNormalize) {
        if (this.spaceGroup == null) {
            this.spaceGroup = SpaceGroup.getNull(true, doNormalize, false);
        }
    }

    @Override
    public int addSpaceGroupOperation(String xyz, int opId) {
        return this.spaceGroup.addSymmetry(xyz, opId, false);
    }

    @Override
    public int addBioMoleculeOperation(M4 mat, boolean isReverse) {
        this.spaceGroup.isBio = true;
        this.isBio = true;
        return this.spaceGroup.addSymmetry((isReverse ? "!" : "") + "[[bio" + mat, 0, false);
    }

    @Override
    public void setLattice(int latt) {
        this.spaceGroup.setLatticeParam(latt);
    }

    @Override
    public Object getSpaceGroup() {
        return this.spaceGroup;
    }

    @Override
    public boolean createSpaceGroup(int desiredSpaceGroupIndex, String name, Object data, int modDim) {
        this.spaceGroup = SpaceGroup.createSpaceGroup(desiredSpaceGroupIndex, name, data, modDim);
        if (this.spaceGroup != null && Logger.debugging) {
            Logger.debug("using generated space group " + this.spaceGroup.dumpInfo());
        }
        return this.spaceGroup != null;
    }

    @Override
    public Object getSpaceGroupInfoObj(String name, SymmetryInterface cellInfo, boolean isFull, boolean addNonstandard) {
        return SpaceGroup.getInfo(this.spaceGroup, name, cellInfo, isFull, addNonstandard);
    }

    @Override
    public Object getLatticeDesignation() {
        return this.spaceGroup.getLatticeDesignation();
    }

    @Override
    public void setFinalOperations(String name, P3[] atoms, int iAtomFirst, int noSymmetryCount, boolean doNormalize, String filterSymop) {
        if (name != null && (name.startsWith("bio") || name.indexOf(" *(") >= 0)) {
            this.spaceGroup.name = name;
        }
        if (filterSymop != null) {
            Lst<SymmetryOperation> lst = new Lst<SymmetryOperation>();
            lst.addLast(this.spaceGroup.operations[0]);
            for (int i = 1; i < this.spaceGroup.operationCount; ++i) {
                if (!filterSymop.contains(" " + (i + 1) + " ")) continue;
                lst.addLast(this.spaceGroup.operations[i]);
            }
            this.spaceGroup = SpaceGroup.createSpaceGroup(-1, name + " *(" + filterSymop.trim() + ")", lst, -1);
        }
        this.spaceGroup.setFinalOperations(atoms, iAtomFirst, noSymmetryCount, doNormalize);
    }

    @Override
    public M4 getSpaceGroupOperation(int i) {
        return this.spaceGroup == null || this.spaceGroup.operations == null || i >= this.spaceGroup.operations.length ? null : (this.spaceGroup.finalOperations == null ? this.spaceGroup.operations[i] : this.spaceGroup.finalOperations[i]);
    }

    @Override
    public M4 getSpaceGroupOperationRaw(int i) {
        return this.spaceGroup.getRawOperation(i);
    }

    @Override
    public String getSpaceGroupXyz(int i, boolean doNormalize) {
        return this.spaceGroup.getXyz(i, doNormalize);
    }

    @Override
    public void newSpaceGroupPoint(int i, P3 atom1, P3 atom2, int transX, int transY, int transZ, M4 o) {
        if (o == null && this.spaceGroup.finalOperations == null) {
            SymmetryOperation op = this.spaceGroup.operations[i];
            if (!op.isFinalized) {
                op.doFinalize();
            }
            SymmetryOperation.newPoint(op, atom1, atom2, transX, transY, transZ);
            return;
        }
        SymmetryOperation.newPoint(o == null ? this.spaceGroup.finalOperations[i] : o, atom1, atom2, transX, transY, transZ);
    }

    @Override
    public V3[] rotateAxes(int iop, V3[] axes, P3 ptTemp, M3 mTemp) {
        return iop == 0 ? axes : this.spaceGroup.finalOperations[iop].rotateAxes(axes, this.unitCell, ptTemp, mTemp);
    }

    @Override
    public String getSpaceGroupOperationCode(int iOp) {
        return this.spaceGroup.operations[iOp].subsystemCode;
    }

    @Override
    public void setTimeReversal(int op, int val) {
        this.spaceGroup.operations[op].setTimeReversal(val);
    }

    @Override
    public float getSpinOp(int op) {
        return this.spaceGroup.operations[op].getMagneticOp();
    }

    @Override
    public boolean addLatticeVectors(Lst<float[]> lattvecs) {
        return this.spaceGroup.addLatticeVectors(lattvecs);
    }

    @Override
    public int getLatticeOp() {
        return this.spaceGroup.latticeOp;
    }

    @Override
    public Matrix getOperationRsVs(int iop) {
        return (this.spaceGroup.finalOperations == null ? this.spaceGroup.operations : this.spaceGroup.finalOperations)[iop].rsvs;
    }

    @Override
    public int getSiteMultiplicity(P3 pt) {
        return this.spaceGroup.getSiteMultiplicity(pt, this.unitCell);
    }

    @Override
    public String addOp(String code, Matrix rs, Matrix vs, Matrix sigma) {
        this.spaceGroup.isSSG = true;
        String s = SymmetryOperation.getXYZFromRsVs(rs, vs, false);
        int i = this.spaceGroup.addSymmetry(s, -1, true);
        this.spaceGroup.operations[i].setSigma(code, sigma);
        return s;
    }

    @Override
    public String getMatrixFromString(String xyz, float[] rotTransMatrix, boolean allowScaling, int modDim) {
        return SymmetryOperation.getMatrixFromString(null, xyz, rotTransMatrix, allowScaling);
    }

    @Override
    public String getSpaceGroupName() {
        return this.symmetryInfo != null ? this.symmetryInfo.sgName : (this.spaceGroup != null ? this.spaceGroup.getName() : (this.unitCell != null && this.unitCell.name.length() > 0 ? "cell=" + this.unitCell.name : ""));
    }

    @Override
    public String getSpaceGroupNameType(String type) {
        return this.spaceGroup == null ? null : this.spaceGroup.getNameType(type, this);
    }

    @Override
    public void setSpaceGroupName(String name) {
        if (this.spaceGroup != null) {
            this.spaceGroup.setName(name);
        }
    }

    @Override
    public int getSpaceGroupOperationCount() {
        return this.symmetryInfo != null ? this.symmetryInfo.symmetryOperations.length : (this.spaceGroup != null && this.spaceGroup.finalOperations != null ? this.spaceGroup.finalOperations.length : 0);
    }

    @Override
    public String getLatticeType() {
        return this.symmetryInfo != null ? this.symmetryInfo.latticeType : (this.spaceGroup == null ? "P" : this.spaceGroup.latticeType);
    }

    @Override
    public void setLatticeType(String type) {
        if (this.spaceGroup != null) {
            this.spaceGroup.latticeType = type;
        }
    }

    @Override
    public String getIntTableNumber() {
        return this.symmetryInfo != null ? this.symmetryInfo.intlTableNo : (this.spaceGroup == null ? null : this.spaceGroup.intlTableNumber);
    }

    @Override
    public boolean getCoordinatesAreFractional() {
        return this.symmetryInfo == null || this.symmetryInfo.coordinatesAreFractional;
    }

    @Override
    public int[] getCellRange() {
        return this.symmetryInfo == null ? null : this.symmetryInfo.cellRange;
    }

    @Override
    public String getSymmetryInfoStr() {
        if (this.symmetryInfo != null) {
            return this.symmetryInfo.infoStr;
        }
        if (this.spaceGroup == null) {
            return "";
        }
        this.symmetryInfo = new SymmetryInfo();
        this.symmetryInfo.setSymmetryInfo(null, this.getUnitCellParams(), this.spaceGroup);
        return this.symmetryInfo.infoStr;
    }

    @Override
    public M4[] getSymmetryOperations() {
        if (this.symmetryInfo != null) {
            return this.symmetryInfo.symmetryOperations;
        }
        if (this.spaceGroup == null) {
            this.spaceGroup = SpaceGroup.getNull(true, false, true);
        }
        return this.spaceGroup.finalOperations;
    }

    @Override
    public boolean isSimple() {
        return this.spaceGroup == null && (this.symmetryInfo == null || this.symmetryInfo.symmetryOperations == null);
    }

    @Override
    public SymmetryInterface setSymmetryInfo(int modelIndex, Map<String, Object> modelAuxiliaryInfo, float[] unitCellParams) {
        this.symmetryInfo = new SymmetryInfo();
        float[] params = this.symmetryInfo.setSymmetryInfo(modelAuxiliaryInfo, unitCellParams, null);
        if (params != null) {
            this.setUnitCell(params, modelAuxiliaryInfo.containsKey("jmolData"));
            this.unitCell.moreInfo = (Lst)modelAuxiliaryInfo.get("moreUnitCellInfo");
            modelAuxiliaryInfo.put("infoUnitCell", this.getUnitCellAsArray(false));
            this.setOffsetPt((T3)modelAuxiliaryInfo.get("unitCellOffset"));
            M3 matUnitCellOrientation = (M3)modelAuxiliaryInfo.get("matUnitCellOrientation");
            if (matUnitCellOrientation != null) {
                this.initializeOrientation(matUnitCellOrientation);
            }
            if (Logger.debugging) {
                Logger.debug("symmetryInfos[" + modelIndex + "]:\n" + this.unitCell.dumpInfo(true, true));
            }
        }
        return this;
    }

    @Override
    public boolean haveUnitCell() {
        return this.unitCell != null;
    }

    @Override
    public SymmetryInterface setUnitCell(float[] unitCellParams, boolean setRelative) {
        this.unitCell = UnitCell.fromParams(unitCellParams, setRelative);
        return this;
    }

    @Override
    public boolean unitCellEquals(SymmetryInterface uc2) {
        return ((Symmetry)uc2).unitCell.isSameAs(this.unitCell);
    }

    @Override
    public String getUnitCellState() {
        return this.unitCell == null ? "" : this.unitCell.getState();
    }

    @Override
    public Lst<String> getMoreInfo() {
        return this.unitCell.moreInfo;
    }

    public String getUnitsymmetryInfo() {
        return this.unitCell.dumpInfo(false, true);
    }

    @Override
    public void initializeOrientation(M3 mat) {
        this.unitCell.initOrientation(mat);
    }

    @Override
    public void unitize(T3 ptFrac) {
        this.unitCell.unitize(ptFrac);
    }

    @Override
    public void toUnitCell(T3 pt, T3 offset) {
        this.unitCell.toUnitCell(pt, offset);
    }

    @Override
    public P3 toSupercell(P3 fpt) {
        return this.unitCell.toSupercell(fpt);
    }

    @Override
    public void toFractional(T3 pt, boolean ignoreOffset) {
        if (!this.isBio) {
            this.unitCell.toFractional(pt, ignoreOffset);
        }
    }

    @Override
    public void toFractionalM(M4 m) {
        if (!this.isBio) {
            this.unitCell.toFractionalM(m);
        }
    }

    @Override
    public void toCartesian(T3 fpt, boolean ignoreOffset) {
        if (!this.isBio) {
            this.unitCell.toCartesian(fpt, ignoreOffset);
        }
    }

    @Override
    public float[] getUnitCellParams() {
        return this.unitCell.getUnitCellParams();
    }

    @Override
    public float[] getUnitCellAsArray(boolean vectorsOnly) {
        return this.unitCell.getUnitCellAsArray(vectorsOnly);
    }

    @Override
    public Tensor getTensor(Viewer vwr, float[] parBorU) {
        if (parBorU == null) {
            return null;
        }
        if (this.unitCell == null) {
            this.unitCell = UnitCell.fromParams(new float[]{1.0f, 1.0f, 1.0f, 90.0f, 90.0f, 90.0f}, true);
        }
        return this.unitCell.getTensor(vwr, parBorU);
    }

    @Override
    public P3[] getUnitCellVerticesNoOffset() {
        return this.unitCell.getVertices();
    }

    @Override
    public P3 getCartesianOffset() {
        return this.unitCell.getCartesianOffset();
    }

    @Override
    public P3 getFractionalOffset() {
        return this.unitCell.getFractionalOffset();
    }

    @Override
    public void setOffsetPt(T3 pt) {
        this.unitCell.setOffset(pt);
    }

    @Override
    public void setOffset(int nnn) {
        P3 pt = new P3();
        SimpleUnitCell.ijkToPoint3f(nnn, pt, 0, 0);
        this.unitCell.setOffset(pt);
    }

    @Override
    public T3 getUnitCellMultiplier() {
        return this.unitCell.getUnitCellMultiplier();
    }

    @Override
    public SymmetryInterface getUnitCellMultiplied() {
        UnitCell uc = this.unitCell.getUnitCellMultiplied();
        if (uc == this.unitCell) {
            return this;
        }
        Symmetry s = new Symmetry();
        s.unitCell = uc;
        return s;
    }

    @Override
    public P3[] getCanonicalCopy(float scale, boolean withOffset) {
        return this.unitCell.getCanonicalCopy(scale, withOffset);
    }

    @Override
    public float getUnitCellInfoType(int infoType) {
        return this.unitCell.getInfo(infoType);
    }

    @Override
    public String getUnitCellInfo(boolean scaled) {
        return this.unitCell.dumpInfo(false, scaled);
    }

    @Override
    public boolean isSlab() {
        return this.unitCell.isSlab();
    }

    @Override
    public boolean isPolymer() {
        return this.unitCell.isPolymer();
    }

    @Override
    public boolean checkDistance(P3 f1, P3 f2, float distance, float dx, int iRange, int jRange, int kRange, P3 ptOffset) {
        return this.unitCell.checkDistance(f1, f2, distance, dx, iRange, jRange, kRange, ptOffset);
    }

    @Override
    public P3[] getUnitCellVectors() {
        return this.unitCell.getUnitCellVectors();
    }

    @Override
    public SymmetryInterface getUnitCell(T3[] oabc, boolean setRelative, String name) {
        if (oabc == null) {
            return null;
        }
        this.unitCell = UnitCell.fromOABC(oabc, setRelative);
        if (name != null) {
            this.unitCell.name = name;
        }
        return this;
    }

    @Override
    public boolean isSupercell() {
        return this.unitCell.isSupercell();
    }

    @Override
    public BS notInCentroid(ModelSet modelSet, BS bsAtoms, int[] minmax) {
        try {
            BS bsDelete = new BS();
            int iAtom0 = bsAtoms.nextSetBit(0);
            JmolMolecule[] molecules = modelSet.getMolecules();
            int moleculeCount = molecules.length;
            Atom[] atoms = modelSet.at;
            boolean isOneMolecule = molecules[moleculeCount - 1].firstAtomIndex == modelSet.am[atoms[iAtom0].mi].firstAtomIndex;
            P3 center = new P3();
            boolean centroidPacked = minmax[6] == 1;
            int i = moleculeCount;
            block2: while (--i >= 0 && bsAtoms.get(molecules[i].firstAtomIndex)) {
                BS bs = molecules[i].atomList;
                center.set(0.0f, 0.0f, 0.0f);
                int n = 0;
                int j = bs.nextSetBit(0);
                while (j >= 0) {
                    if (isOneMolecule || centroidPacked) {
                        center.setT(atoms[j]);
                        if (this.isNotCentroid(center, 1, minmax, centroidPacked)) {
                            if (isOneMolecule) {
                                bsDelete.set(j);
                            }
                        } else if (!isOneMolecule) {
                            continue block2;
                        }
                    } else {
                        center.add(atoms[j]);
                        ++n;
                    }
                    j = bs.nextSetBit(j + 1);
                }
                if (!centroidPacked && (n <= 0 || !this.isNotCentroid(center, n, minmax, false))) continue;
                bsDelete.or(bs);
            }
            return bsDelete;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isNotCentroid(P3 center, int n, int[] minmax, boolean centroidPacked) {
        center.scale(1.0f / (float)n);
        this.toFractional(center, false);
        if (centroidPacked) {
            return center.x + 5.0E-6f <= (float)minmax[0] || center.x - 5.0E-6f > (float)minmax[3] || center.y + 5.0E-6f <= (float)minmax[1] || center.y - 5.0E-6f > (float)minmax[4] || center.z + 5.0E-6f <= (float)minmax[2] || center.z - 5.0E-6f > (float)minmax[5];
        }
        return center.x + 5.0E-6f <= (float)minmax[0] || center.x + 5.0E-5f > (float)minmax[3] || center.y + 5.0E-6f <= (float)minmax[1] || center.y + 5.0E-5f > (float)minmax[4] || center.z + 5.0E-6f <= (float)minmax[2] || center.z + 5.0E-5f > (float)minmax[5];
    }

    private SymmetryDesc getDesc(ModelSet modelSet) {
        return (this.desc == null ? (this.desc = (SymmetryDesc)Interface.getInterface("org.jmol.symmetry.SymmetryDesc", modelSet.vwr, "eval")) : this.desc).set(modelSet);
    }

    @Override
    public Object getSymmetryInfoAtom(ModelSet modelSet, int iatom, String xyz, int op, P3 translation, P3 pt, P3 pt2, String id, int type, float scaleFactor, int nth, int options) {
        return this.getDesc(modelSet).getSymopInfo(iatom, xyz, op, translation, pt, pt2, id, type, scaleFactor, nth, options);
    }

    @Override
    public Map<String, Object> getSpaceGroupInfo(ModelSet modelSet, String sgName, int modelIndex, boolean isFull, float[] cellParams) {
        Map<String, Object> info;
        boolean isForModel;
        boolean bl = isForModel = sgName == null;
        if (sgName == null && (info = modelSet.getModelAuxiliaryInfo(modelSet.vwr.am.cmi)) != null) {
            sgName = (String)info.get("spaceGroup");
        }
        SymmetryInterface cellInfo = null;
        if (cellParams != null) {
            cellInfo = new Symmetry().setUnitCell(cellParams, false);
        }
        return this.getDesc(modelSet).getSpaceGroupInfo(this, modelIndex, sgName, 0, null, null, null, 0.0f, -1, isFull, isForModel, 0, cellInfo);
    }

    @Override
    public String fcoord(T3 p) {
        return SymmetryOperation.fcoord(p);
    }

    @Override
    public T3[] getV0abc(Object def) {
        return this.unitCell == null ? null : this.unitCell.getV0abc(def);
    }

    @Override
    public Quat getQuaternionRotation(String abc) {
        return this.unitCell == null ? null : this.unitCell.getQuaternionRotation(abc);
    }

    @Override
    public T3 getFractionalOrigin() {
        return this.unitCell.getFractionalOrigin();
    }

    @Override
    public boolean getState(SB commands) {
        T3 pt = this.getFractionalOffset();
        boolean loadUC = false;
        if (pt != null && (pt.x != 0.0f || pt.y != 0.0f || pt.z != 0.0f)) {
            commands.append("; set unitcell ").append(Escape.eP(pt));
            loadUC = true;
        }
        if ((pt = this.getUnitCellMultiplier()) != null) {
            commands.append("; set unitcell ").append(SimpleUnitCell.escapeMultiplier(pt));
            loadUC = true;
        }
        return loadUC;
    }

    @Override
    public AtomIndexIterator getIterator(Viewer vwr, Atom atom, Atom[] atoms, BS bsAtoms, float radius) {
        return ((UnitCellIterator)Interface.getInterface("org.jmol.symmetry.UnitCellIterator", vwr, "script")).set(this, atom, atoms, bsAtoms, radius);
    }

    @Override
    public boolean toFromPrimitive(boolean toPrimitive, char type, T3[] oabc, M3 primitiveToCrystal) {
        if (this.unitCell == null) {
            this.unitCell = UnitCell.fromOABC(oabc, false);
        }
        return this.unitCell.toFromPrimitive(toPrimitive, type, oabc, primitiveToCrystal);
    }

    @Override
    public Lst<P3> generateCrystalClass(P3 pt0) {
        M4[] ops = this.getSymmetryOperations();
        Lst<P3> lst = new Lst<P3>();
        boolean isRandom = pt0 == null;
        float rand1 = 0.0f;
        float rand2 = 0.0f;
        float rand3 = 0.0f;
        if (isRandom) {
            rand1 = (float)Math.E;
            rand2 = (float)Math.PI;
            rand3 = (float)Math.log10(2000.0);
            pt0 = P3.new3(rand1 + 1.0f, rand2 + 2.0f, rand3 + 3.0f);
        } else {
            pt0 = P3.newP(pt0);
        }
        if (ops == null || this.unitCell == null) {
            lst.addLast(pt0);
        } else {
            this.unitCell.toFractional(pt0, true);
            P3 pt1 = null;
            P3 pt2 = null;
            P3 pt3 = null;
            if (isRandom) {
                pt1 = P3.new3(rand2 + 4.0f, rand3 + 5.0f, rand1 + 6.0f);
                this.unitCell.toFractional(pt1, true);
                pt2 = P3.new3(rand3 + 7.0f, rand1 + 8.0f, rand2 + 9.0f);
                this.unitCell.toFractional(pt2, true);
            }
            Bspt bspt = new Bspt(3, 0);
            CubeIterator iter = bspt.allocateCubeIterator();
            P3 pt = new P3();
            int i = ops.length;
            while (--i >= 0) {
                ops[i].rotate2(pt0, pt);
                iter.initialize(pt, 0.001f, false);
                if (iter.hasMoreElements()) continue;
                P3 ptNew = P3.newP(pt);
                lst.addLast(ptNew);
                bspt.addTuple(ptNew);
                if (!isRandom) continue;
                if (pt2 != null) {
                    pt3 = new P3();
                    ops[i].rotate2(pt2, pt3);
                    lst.addLast(pt3);
                }
                if (pt1 == null) continue;
                pt3 = new P3();
                ops[i].rotate2(pt1, pt3);
                lst.addLast(pt3);
            }
            int j = lst.size();
            while (--j >= 0) {
                this.unitCell.toCartesian((T3)lst.get(j), true);
            }
        }
        return lst;
    }

    @Override
    public void calculateCIPChiralityForAtoms(Viewer vwr, BS bsAtoms) {
        vwr.setCursor(3);
        CIPChirality cip = this.getCIPChirality(vwr);
        String dataClass = vwr.getBoolean(603979960) ? "CIPData" : "CIPDataTracker";
        CIPData data = ((CIPData)Interface.getInterface("org.jmol.symmetry." + dataClass, vwr, "script")).set(vwr, bsAtoms);
        data.setRule6Full(vwr.getBoolean(603979823));
        cip.getChiralityForAtoms(data);
        vwr.setCursor(0);
    }

    @Override
    public String[] calculateCIPChiralityForSmiles(Viewer vwr, String smiles) throws Exception {
        vwr.setCursor(3);
        CIPChirality cip = this.getCIPChirality(vwr);
        CIPDataSmiles data = ((CIPDataSmiles)Interface.getInterface("org.jmol.symmetry.CIPDataSmiles", vwr, "script")).setAtomsForSmiles(vwr, smiles);
        cip.getChiralityForAtoms(data);
        vwr.setCursor(0);
        return data.getSmilesChiralityArray();
    }

    private CIPChirality getCIPChirality(Viewer vwr) {
        return this.cip == null ? (this.cip = (CIPChirality)Interface.getInterface("org.jmol.symmetry.CIPChirality", vwr, "script")) : this.cip;
    }

    @Override
    public T3[] getConventionalUnitCell(String latticeType, M3 primitiveToCrystal) {
        return this.unitCell == null || latticeType == null ? null : this.unitCell.getConventionalUnitCell(latticeType, primitiveToCrystal);
    }

    @Override
    public Map<String, Object> getUnitCellInfoMap() {
        return this.unitCell == null ? null : this.unitCell.getInfo();
    }

    @Override
    public void setUnitCell(SymmetryInterface uc) {
        this.unitCell = UnitCell.cloneUnitCell(((Symmetry)uc).unitCell);
    }

    @Override
    public Object findSpaceGroup(Viewer vwr, BS atoms, String opXYZ, boolean asString) {
        return ((SpaceGroupFinder)Interface.getInterface("org.jmol.symmetry.SpaceGroupFinder", vwr, "eval")).findSpaceGroup(vwr, atoms, opXYZ, this, asString);
    }

    @Override
    public void setSpaceGroupTo(Object sg) {
        this.symmetryInfo = null;
        this.spaceGroup = sg instanceof SpaceGroup ? (SpaceGroup)sg : SpaceGroup.getSpaceGroupFromITAName(sg.toString());
    }
}

