/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.PT;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.jmol.console.GenericConsole;
import org.jmol.console.JmolButton;
import org.jmol.console.KeyJCheckBox;
import org.jmol.console.KeyJCheckBoxMenuItem;
import org.jmol.console.KeyJMenu;
import org.jmol.console.KeyJMenuItem;
import org.jmol.console.KeyJRadioButtonMenuItem;
import org.jmol.i18n.GT;
import org.jmol.viewer.JC;
import org.openscience.jmol.app.jmolpanel.JmolResourceHandler;

public class GuiMap {
    private static Object language;
    Map<String, Object> map = new Hashtable<String, Object>();
    protected Map<String, String> labels;
    private static String[] translations;

    private void setupLabels() {
        this.labels = new Hashtable<String, String>();
        this.labels.put("macros", GT.$("&Macros"));
        this.labels.put("idfileMenu", GT.$("&File"));
        this.labels.put("file", GT.$("&File"));
        this.labels.put("newwin", GT.$("&New"));
        this.labels.put("open", GT.$("&Open"));
        this.labels.put("openTip", GT.$("Open a file."));
        this.labels.put("openurl", GT.$("Open &URL"));
        this.labels.put("openpdb", GT.$("&Get PDB"));
        this.labels.put("openmol", GT.$("Get &MOL"));
        this.labels.put("reloadScript", GT.$("&Reload"));
        this.labels.put("spectrumMenu", GT.$("&Spectra"));
        this.labels.put("openJSpecViewScript", "JSpecView");
        this.labels.put("simulate1HSpectrumScript", GT.$("Simulated 1H Spectrum"));
        this.labels.put("simulate13CSpectrumScript", GT.$("Simulated 13C Spectrum"));
        this.labels.put("editor", GT.$("Scrip&t Editor..."));
        this.labels.put("console", GT.$("Conso&le..."));
        this.labels.put("jconsole", GT.$("Jmol Java &Console"));
        this.labels.put("atomsetchooser", GT.$("AtomSet&Chooser..."));
        this.labels.put("saveas", GT.$("&Save As..."));
        this.labels.put("exportMenu", GT.$("&Export"));
        this.labels.put("export", GT.$("Export &Image..."));
        this.labels.put("exportTip", GT.$("Save current view as an image."));
        this.labels.put("toweb", GT.$("Export to &Web Page..."));
        this.labels.put("towebTip", GT.$("Export one or more views to a web page."));
        this.labels.put("povray", GT.$("Render in POV-&Ray..."));
        this.labels.put("povrayTip", GT.$("Render in POV-Ray"));
        this.labels.put("write", GT.$("Write &State..."));
        this.labels.put("writeTip", GT.$("Save current view as a Jmol state script."));
        this.labels.put("print", GT.$("&Print..."));
        this.labels.put("printTip", GT.$("Print view."));
        this.labels.put("close", GT.$("&Close"));
        this.labels.put("exit", GT.$("E&xit"));
        this.labels.put("recentFiles", GT.$("Recent &Files..."));
        this.labels.put("edit", GT.$("&Edit"));
        this.labels.put("selectall", GT.$("Select &All"));
        this.labels.put("deselectall", GT.$("Deselect All"));
        this.labels.put("copyImage", GT.$("Copy &Image"));
        this.labels.put("copyScript", GT.$("Copy Script"));
        this.labels.put("prefs", GT.$("Pr&eferences..."));
        this.labels.put("pasteClipboard", GT.$("&Paste"));
        this.labels.put("editSelectAllScript", GT.$("Select &All"));
        this.labels.put("selectMenu", GT.$("&Select"));
        this.labels.put("selectMenuText", GT.$("&Select"));
        this.labels.put("selectAllScript", GT.$("&All"));
        this.labels.put("selectNoneScript", GT.$("&None"));
        this.labels.put("selectHydrogenScript", GT.$("Hydrogen"));
        this.labels.put("selectCarbonScript", GT.$("Carbon"));
        this.labels.put("selectNitrogenScript", GT.$("Nitrogen"));
        this.labels.put("selectOxygenScript", GT.$("Oxygen"));
        this.labels.put("selectPhosphorusScript", GT.$("Phosphorus"));
        this.labels.put("selectSulfurScript", GT.$("Sulfur"));
        this.labels.put("selectAminoScript", GT.$("Amino"));
        this.labels.put("selectNucleicScript", GT.$("Nucleic"));
        this.labels.put("selectWaterScript", GT.$("Water"));
        this.labels.put("selectHeteroScript", GT.$("Hetero"));
        this.labels.put("display", GT.$("&Display"));
        this.labels.put("atomMenu", GT.$("&Atom"));
        this.labels.put("atomNoneScript", GT.$("&None"));
        this.labels.put("atom15Script", GT.o(GT.$("{0}% van der Waals"), "15"));
        this.labels.put("atom20Script", GT.o(GT.$("{0}% van der Waals"), "20"));
        this.labels.put("atom25Script", GT.o(GT.$("{0}% van der Waals"), "25"));
        this.labels.put("atom100Script", GT.o(GT.$("{0}% van der Waals"), "100"));
        this.labels.put("bondMenu", GT.$("&Bond"));
        this.labels.put("bondNoneScript", GT.$("&None"));
        this.labels.put("bondWireframeScript", GT.$("&Wireframe"));
        this.labels.put("bond100Script", GT.o(GT.$("{0} \u00c5"), "0.10"));
        this.labels.put("bond150Script", GT.o(GT.$("{0} \u00c5"), "0.15"));
        this.labels.put("bond200Script", GT.o(GT.$("{0} \u00c5"), "0.20"));
        this.labels.put("labelMenu", GT.$("&Label"));
        this.labels.put("labelNoneScript", GT.$("&None"));
        this.labels.put("labelSymbolScript", GT.$("&Symbol"));
        this.labels.put("labelNameScript", GT.$("&Name"));
        this.labels.put("labelNumberScript", GT.$("&Number"));
        this.labels.put("labelCenteredScript", GT.$("&Centered"));
        this.labels.put("labelUpperRightScript", GT.$("&Upper right"));
        this.labels.put("vectorMenu", GT.$("&Vector"));
        this.labels.put("vectorOffScript", GT.$("&None"));
        this.labels.put("vectorOnScript", GT.$("&On"));
        this.labels.put("vector3Script", GT.o(GT.$("{0} pixels"), "3"));
        this.labels.put("vector005Script", GT.o(GT.$("{0} \u00c5"), "0.05"));
        this.labels.put("vector01Script", GT.o(GT.$("{0} \u00c5"), "0.1"));
        this.labels.put("vectorScale02Script", GT.o(GT.$("Scale {0}"), "0.2"));
        this.labels.put("vectorScale05Script", GT.o(GT.$("Scale {0}"), "0.5"));
        this.labels.put("vectorScale1Script", GT.o(GT.$("Scale {0}"), "1"));
        this.labels.put("vectorScale2Script", GT.o(GT.$("Scale {0}"), "2"));
        this.labels.put("vectorScale5Script", GT.o(GT.$("Scale {0}"), "5"));
        this.labels.put("zoomMenu", GT.$("&Zoom"));
        this.labels.put("zoom100Script", GT.o(GT.$("{0}%"), "100"));
        this.labels.put("zoom150Script", GT.o(GT.$("{0}%"), "150"));
        this.labels.put("zoom200Script", GT.o(GT.$("{0}%"), "200"));
        this.labels.put("zoom400Script", GT.o(GT.$("{0}%"), "400"));
        this.labels.put("zoom800Script", GT.o(GT.$("{0}%"), "800"));
        this.labels.put("perspectiveCheck", GT.$("&Perspective Depth"));
        this.labels.put("axesCheck", GT.$("A&xes"));
        this.labels.put("boundboxCheck", GT.$("B&ounding Box"));
        this.labels.put("hydrogensCheck", GT.$("&Hydrogens"));
        this.labels.put("vectorsCheck", GT.$("V&ectors"));
        this.labels.put("measurementsCheck", GT.$("&Measurements"));
        this.labels.put("resize", GT.$("Resi&ze"));
        this.labels.put("view", GT.$("&View"));
        this.labels.put("front", GT.$("&Front"));
        this.labels.put("top", GT.$("&Top"));
        this.labels.put("bottom", GT.$("&Bottom"));
        this.labels.put("right", GT.$("&Right"));
        this.labels.put("left", GT.$("&Left"));
        this.labels.put("axisaScript", GT.$("Axis a"));
        this.labels.put("axisbScript", GT.$("Axis b"));
        this.labels.put("axiscScript", GT.$("Axis c"));
        this.labels.put("axisxScript", GT.$("Axis x"));
        this.labels.put("axisyScript", GT.$("Axis y"));
        this.labels.put("axiszScript", GT.$("Axis z"));
        this.labels.put("transform", GT.$("Tr&ansform..."));
        this.labels.put("definecenter", GT.$("Define &Center"));
        this.labels.put("tools", GT.$("&Tools"));
        this.labels.put("gauss", GT.$("&Gaussian..."));
        this.labels.put("viewMeasurementTable", GT.$("&Measurements") + "...");
        this.labels.put("distanceUnitsMenu", GT.$("Distance &Units"));
        this.labels.put("distanceNanometersScript", GT.$("&Nanometers 1E-9"));
        this.labels.put("distanceAngstromsScript", GT.$("&Angstroms 1E-10"));
        this.labels.put("distancePicometersScript", GT.$("&Picometers 1E-12"));
        this.labels.put("distanceHzScript", GT.$("&Hz (NMR J-coupling)"));
        this.labels.put("animateMenu", GT.$("&Animate..."));
        this.labels.put("vibrateMenu", GT.$("&Vibrate..."));
        this.labels.put("graph", GT.$("&Graph..."));
        this.labels.put("chemicalShifts", GT.$("Calculate chemical &shifts..."));
        this.labels.put("crystprop", GT.$("&Crystal Properties"));
        this.labels.put("animateOnceScript", GT.$("&Once"));
        this.labels.put("animateLoopScript", GT.$("&Loop"));
        this.labels.put("animatePalindromeScript", GT.$("P&alindrome"));
        this.labels.put("animateStopScript", GT.$("&Stop animation"));
        this.labels.put("animateRewindScript", GT.$("&Rewind to first frame"));
        this.labels.put("animateRewindScriptTip", GT.$("Rewind to first frame"));
        this.labels.put("animateNextScript", GT.$("Go to &next frame"));
        this.labels.put("animateNextScriptTip", GT.$("Go to next frame"));
        this.labels.put("animatePrevScript", GT.$("Go to &previous frame"));
        this.labels.put("animatePrevScriptTip", GT.$("Go to previous frame"));
        this.labels.put("animateAllScript", GT.$("All &frames"));
        this.labels.put("animateAllScriptTip", GT.$("All frames"));
        this.labels.put("animateLastScript", GT.$("Go to &last frame"));
        this.labels.put("animateLastScriptTip", GT.$("Go to last frame"));
        this.labels.put("vibrateStartScript", GT.$("Start &vibration"));
        this.labels.put("vibrateStopScript", GT.$("&Stop vibration"));
        this.labels.put("vibrateRewindScript", GT.$("&First frequency"));
        this.labels.put("vibrateNextScript", GT.$("&Next frequency"));
        this.labels.put("vibratePrevScript", GT.$("&Previous frequency"));
        this.labels.put("surfaceTool", GT.$("SurfaceTool..."));
        this.labels.put("surfaceToolTip", GT.$("Control Display of Surfaces"));
        this.labels.put("help", GT.$("&Help"));
        this.labels.put("about", GT.$("About Jmol"));
        this.labels.put("uguide", GT.$("Jmol Wiki"));
        this.labels.put("whatsnew", GT.$("What's New"));
        this.labels.put("credits", GT.$("Credits"));
        this.labels.put("Prefs.showHydrogens", GT.$("Hydrogens"));
        this.labels.put("Prefs.showMeasurements", GT.$("Measurements"));
        this.labels.put("Prefs.perspectiveDepth", GT.$("Perspective Depth"));
        this.labels.put("Prefs.showAxes", GT.$("Axes"));
        this.labels.put("Prefs.showBoundingBox", GT.$("Bounding Box"));
        this.labels.put("Prefs.axesOrientationRasmol", GT.$("RasMol/Chime compatible axes orientation/rotations"));
        this.labels.put("Prefs.openFilePreview", GT.$("File Preview (requires restarting Jmol)"));
        this.labels.put("Prefs.clearHistory", GT.$("Clear history (requires restarting Jmol)"));
        this.labels.put("Prefs.largeFont", GT.$("Large Console Font"));
        this.labels.put("Prefs.isLabelAtomColor", GT.$("Use Atom Color"));
        this.labels.put("Prefs.isBondAtomColor", GT.$("Use Atom Color"));
        this.labels.put("rotateScriptTip", GT.$("Rotate molecule."));
        this.labels.put("pickScriptTip", GT.$("Select a set of atoms using SHIFT-LEFT-DRAG."));
        this.labels.put("pickMeasureScriptTip", GT.$("Click atoms to measure distances"));
        this.labels.put("pickCenterScriptTip", GT.$("Click an atom to center on it"));
        this.labels.put("pickLabelScriptTip", GT.$("click an atom to toggle label;DOUBLE-Click a label to set; drag to move"));
        this.labels.put("homeTip", GT.$("Return molecule to home position."));
        this.labels.put("modelkitScriptTip", GT.$("Open the model kit."));
        this.labels.put("JavaConsole.Clear", GT.$("Clear"));
        this.labels.put("plugins", GT.$("&Plugins"));
        this.moreLabels(this.labels);
    }

    protected void moreLabels(Map<String, String> labels) {
    }

    public String getLabel(String key) {
        String s;
        if (this.labels == null) {
            this.setupLabels();
        }
        if ((s = this.labels.get(key)) == null || s.length() == 0) {
            System.err.println("GUI key? " + key);
            return key;
        }
        return s;
    }

    public JMenu newJMenu(String key) {
        return new KeyJMenu(key, this.getLabel(key), this.map);
    }

    public JMenuItem newJMenuItem(String key) {
        return new KeyJMenuItem(key, this.getLabel(key), this.map);
    }

    public JCheckBoxMenuItem newJCheckBoxMenuItem(String key, boolean isChecked) {
        return new KeyJCheckBoxMenuItem(key, this.getLabel(key), this.map, isChecked);
    }

    public JRadioButtonMenuItem newJRadioButtonMenuItem(String key) {
        return new KeyJRadioButtonMenuItem(key, this.getLabel(key), this.map);
    }

    public JCheckBox newJCheckBox(String key, boolean isChecked) {
        return new KeyJCheckBox(key, this.getLabel(key), this.map, isChecked);
    }

    public JButton newJButton(String key) {
        JmolButton jb = new JmolButton(this.getLabel(key));
        this.map.put(key, jb);
        return jb;
    }

    public Object get(String key) {
        return this.map.get(key);
    }

    public void setSelected(String key, boolean b) {
        ((AbstractButton)this.get(key)).setSelected(b);
    }

    public void setEnabled(String key, boolean b) {
        ((AbstractButton)this.get(key)).setEnabled(b);
    }

    public void updateLabels() {
        boolean doTranslate = GT.setDoTranslate(true);
        this.setupLabels();
        GenericConsole.setAbstractButtonLabels(this.map, this.labels);
        GT.setDoTranslate(doTranslate);
    }

    public static String translate(String str) {
        if (translations == null || !GT.getLanguage().equals(language)) {
            GuiMap.setTranslations();
        }
        language = GT.getLanguage();
        for (int i = 0; i < translations.length; i += 2) {
            String t = translations[i];
            if (str.indexOf(t) < 0) continue;
            String s = translations[i + 1];
            if (s.equals("see Jmol-resources.properties")) {
                s = JmolResourceHandler.getStringX(t);
            }
            str = PT.rep(str, t, s);
        }
        return str;
    }

    public static URL getResource(Object object, String fileName) {
        return GuiMap.getResource(object, fileName, true);
    }

    public static URL getHtmlResource(Object object, String root) {
        String lang = GT.getLanguage();
        String fileName = root + "_" + lang + ".html";
        URL url = GuiMap.getResource(object, fileName, false);
        if (url == null && lang.length() == 5) {
            fileName = root + "_" + lang.substring(0, 2) + ".html";
            url = GuiMap.getResource(object, fileName, false);
        }
        if (url == null) {
            fileName = root + ".html";
            url = GuiMap.getResource(object, fileName, true);
        }
        return url;
    }

    public static URL getResource(Object object, String fileName, boolean flagError) {
        URL url = null;
        if (fileName.indexOf("/org/") > 0) {
            fileName = fileName.substring(fileName.indexOf("/org/") + 1);
        }
        if (!fileName.contains("/")) {
            fileName = "org/openscience/jmol/app/webexport/html/" + fileName;
        }
        try {
            url = ClassLoader.getSystemResource(fileName);
            if (url == null && flagError) {
                System.err.println("Couldn't find file: " + fileName);
            }
        }
        catch (Exception e) {
            System.err.println("Exception " + e.getMessage() + " in getResource " + fileName);
        }
        return url;
    }

    public static String getResourceString(Object object, String name) throws IOException {
        URL url;
        URL uRL = url = name.indexOf(".") >= 0 ? GuiMap.getResource(object, name) : GuiMap.getHtmlResource(object, name);
        if (url == null) {
            throw new FileNotFoundException("Error loading resource " + name);
        }
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)url.getContent()));
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return GuiMap.translate(sb.toString());
    }

    private static void setTranslations() {
        translations = new String[]{"GT_JmolPopIn.js_TOGETA3DMODEL", GT.escapeHTML(GT.o(GT.$("To get a 3-D model you can manipulate, click {0}here{1}. Download time may be significant the first time the applet is loaded."), new String[]{"<a href=\"HREF\">", "</a>"})), "GT_pop_in_template.html_INSERTTITLE", GT.escapeHTML(GT.$("Insert the page TITLE here.")), "GT_pop_in_template.html_INSERTINTRO", GT.escapeHTML(GT.$("Insert the page INTRODUCTION here.")), "GT_pop_in_template2.html_INSERTCAPTION", GT.escapeHTML(GT.o(GT.$("CLICK IMAGE TO ACTIVATE 3D <br/> Insert a caption for {0} here."), "@NAME@")), "GT_pop_in_template2.html_INSERTADDITIONAL", GT.escapeHTML(GT.o(GT.$("Insert additional explanatory text here. Long text will wrap around Jmol model {0}."), "@NAME@")), "GT_script_btn_template.html_INSERT", GT.escapeHTML(GT.$("Insert your TITLE and INTRODUCTION here.")), "GT_script_btn_template.html_LOADING", GT.escapeHTML(GT.o(GT.$("Once the molecule file is fully loaded, the image at right will become live.  At that time the \"activate 3-D\" icon {0} will disappear."), new String[]{"<img id=\"make_live_icon\" src=\"\" height=\"15px\" />"})), "GT_script_btn_template.html_VIEWAGAIN", GT.escapeHTML(GT.$("You may look at any of these intermediate views again by clicking on the appropriate button.")), "GT_script_btn_template.html_JAVACAPABLE", GT.escapeHTML(GT.$("If your browser/OS combination is Java capable, you will get snappier performance if you <a href=\"?use=JAVA\">use Java</a>")), "GT_script_btn_template2.html_BUTTONINFO", GT.escapeHTML(GT.o(GT.$("The button {0} will appear below.  Insert information for {0} here and below."), "@NAME@")), "GT_script_btn_template2.html_MORE", GT.escapeHTML(GT.o(GT.$("Insert more information for {0} here."), "@NAME@")), "About.html#version", "<p><b>Jmol " + JC.version + " (" + JC.date + ")</b></p>", "About.html#splash", "see Jmol-resources.properties", "About.html#weblinks", "see Jmol-resources.properties", "About.html#libraries", "see Jmol-resources.properties"};
    }
}

