/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel.console;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.Map;
import javajs.util.PT;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jmol.api.JmolAbstractButton;
import org.jmol.api.JmolDropEditor;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.awt.FileDropper;
import org.jmol.awt.Platform;
import org.jmol.console.JmolConsole;
import org.jmol.console.ScriptEditor;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.PreferencesDialog;
import org.openscience.jmol.app.jmolpanel.console.EnterListener;

public class AppConsole
extends JmolConsole
implements EnterListener,
JmolDropEditor {
    public static final String ALL_BUTTONS = "Editor Variables Clear History State UndoRedo Close Font Help";
    public JDialog jcd;
    protected ConsoleTextPane console;
    protected ConsoleDocument consoleDoc;
    private JmolAbstractButton varButton;
    private JmolAbstractButton haltButton;
    private JmolAbstractButton closeButton;
    private JmolAbstractButton clearButton;
    private JmolAbstractButton stepButton;
    private JmolAbstractButton helpButton;
    private JmolAbstractButton undoButton;
    private JmolAbstractButton redoButton;
    private JmolAbstractButton checkButton;
    private JmolAbstractButton topButton;
    private JmolAbstractButton fontButton;
    private JPanel buttonPanel = new JPanel();
    protected JScrollBar vBar;
    protected JScrollBar hBar;
    private int fontSize;
    private boolean noPrefs;
    boolean isError = false;
    ExecuteCommandThread execThread;
    private static int MAXUNDO = 10;
    private String[] undoStack = new String[MAXUNDO + 1];
    private int undoPointer = 0;
    private boolean undoSaved = false;
    static final int UNDO_NONE = 0;
    static final int UNDO_CONSOLE = 1;
    static final int UNDO_USER = 2;
    private boolean dontsave;
    private JmolStatusListener statusListener;

    @Override
    public void loadContent(String script) {
        this.getScriptEditor().setVisible(true);
        this.getScriptEditor().loadContent(script);
    }

    @Override
    public void loadFile(String fileName) {
        ScriptEditor se = (ScriptEditor)this.getScriptEditor();
        boolean isVisible = se.isVisible();
        this.getScriptEditor().loadFile(fileName);
        if (!isVisible) {
            se.setVisible(false);
        }
        this.vwr.openFileAsyncSpecial(fileName, 41);
    }

    public AppConsole() {
    }

    @Override
    public void start(Viewer vwr) {
        this.setup(vwr, null, null);
    }

    public AppConsole(JmolViewer vwr, Container externalContainer, String enabledButtons) {
        this.setup((Viewer)vwr, externalContainer, enabledButtons);
    }

    private void setup(Viewer vwr, Container externalContainer, String enabledButtons) {
        if (!Viewer.isJS) {
            InputMap im = (InputMap)UIManager.get("TextPane.focusInputMap");
            im.put(KeyStroke.getKeyStroke(65, 256), "select-all");
            im.put(KeyStroke.getKeyStroke(67, 256), "copy-to-clipboard");
            im.put(KeyStroke.getKeyStroke(86, 256), "paste-from-clipboard");
        }
        this.setViewer(vwr);
        Window w = Platform.getWindow((Container)vwr.display);
        JFrame jFrame = this.vwrFrame = w instanceof JFrame ? (JFrame)w : null;
        if (externalContainer == null) {
            this.jcd = new JDialog(this.vwrFrame, null, false);
            this.jcd.setName("JmolConsole");
            this.jcd.setSize(700, 400);
            this.jcd.setLocationRelativeTo(this.vwrFrame);
            this.externalContainer = this.jcd;
        } else {
            this.externalContainer = externalContainer;
            vwr.setConsole(this);
        }
        this.addWindowListener();
        this.layoutWindow(enabledButtons);
        new FileDropper(this.statusListener, vwr, this);
    }

    @Override
    public void updateFontSize() {
        int scale = Viewer.isJS || this.noPrefs ? this.vwr.getConsoleFontScale() : PT.parseInt("" + (String)this.vwr.getProperty("DATA_API", "getPreference", "consoleFontScale"));
        scale = (scale < 0 ? 1 : scale) % 5;
        this.fontSize = scale * 4 + 12;
        if (this.console != null) {
            this.console.setFont(new Font("dialog", 0, this.fontSize));
        }
        this.vwr.notifyScriptEditor(Integer.MAX_VALUE, new Object[]{this.fontSize});
    }

    @Override
    public void sendConsoleEcho(String strEcho) {
        if (strEcho == null) {
            this.updateLabels();
        } else if (strEcho.equals("\u0000")) {
            this.sendConsoleMessage(null);
        } else {
            this.console.outputEcho(strEcho);
        }
        this.setError(false);
    }

    @Override
    public void sendConsoleMessage(String strStatus) {
        if (strStatus == null) {
            this.console.clearContent(null);
            this.console.outputStatus("");
        } else if (strStatus.indexOf("ERROR:") >= 0) {
            this.console.outputError(strStatus);
            this.setError(true);
        } else {
            this.console.outputStatus(strStatus);
            this.isError = false;
        }
    }

    @Override
    protected JmolAbstractButton setButton(String label) {
        JmolAbstractButton b = super.setButton(label);
        this.buttonPanel.add((JButton)((Object)b));
        return b;
    }

    @Override
    protected void setupLabels0(Map<String, String> labels) {
        labels.put("Check", GT.$("Check"));
        labels.put("Clear", GT.$("Clear"));
        labels.put("Close", GT.$("Close"));
        labels.put("Halt", GT.$("Halt"));
        labels.put("Help", GT.$("Help"));
        labels.put("Editor", GT.$("Editor"));
        labels.put("History", GT.$("History"));
        labels.put("State", GT.$("State"));
        labels.put("Step", GT.$("Step"));
        labels.put("Top", GT.$("Top"));
        labels.put("Undo", GT.$("Undo"));
        labels.put("Redo", GT.$("Redo"));
        labels.put("Font", GT.$("Font"));
        labels.put("Variables", GT.$("Variables"));
    }

    @Override
    protected void layoutWindow(String enabledButtons) {
        this.setTitle();
        this.console = new ConsoleTextPane(this);
        this.console.setName("JmolConsole");
        this.console.setDropTarget(new DropTarget(this.console, new FileDropper(null, this.vwr, this)));
        this.console.setPrompt();
        this.console.setDragEnabled(true);
        if (enabledButtons == null) {
            enabledButtons = ALL_BUTTONS;
        }
        JScrollPane consolePane = new JScrollPane(this.console);
        this.vBar = consolePane.getVerticalScrollBar();
        this.hBar = consolePane.getHorizontalScrollBar();
        String[] tokens = PT.getTokens(enabledButtons);
        for (int i = 0; i < tokens.length; ++i) {
            this.enableButton(tokens[i]);
        }
        AppConsole.setEnabled(this.undoButton, false);
        AppConsole.setEnabled(this.redoButton, false);
        JPanel buttonPanelWrapper = new JPanel();
        buttonPanelWrapper.setLayout(new BorderLayout());
        buttonPanelWrapper.add((Component)this.buttonPanel, "Center");
        JSplitPane spane = new JSplitPane(0, consolePane, buttonPanelWrapper);
        spane.setName("JmolConsoleSplitPane");
        consolePane.setMinimumSize(new Dimension(300, 300));
        consolePane.setPreferredSize(new Dimension(5000, 5000));
        buttonPanelWrapper.setMinimumSize(new Dimension(60, 60));
        buttonPanelWrapper.setMaximumSize(new Dimension(1000, 60));
        buttonPanelWrapper.setPreferredSize(new Dimension(60, 60));
        spane.setDividerSize(0);
        spane.setResizeWeight(0.95);
        this.getPane().add(spane);
    }

    private static void setEnabled(JmolAbstractButton button, boolean TF) {
        if (button != null) {
            button.setEnabled(TF);
        }
    }

    private void enableButton(String name) {
        switch ("Check     Clear     Close     Editor    Halt      Help      History   State     Step      Top       UndoRedo  Font      Variables ".indexOf(name)) {
            case 0: {
                this.checkButton = this.setButton("Check");
                break;
            }
            case 10: {
                this.clearButton = this.setButton("Clear");
                break;
            }
            case 20: {
                this.closeButton = this.setButton("Close");
                break;
            }
            case 30: {
                this.editButton = this.setButton("Editor");
                break;
            }
            case 40: {
                this.haltButton = this.setButton("Halt");
                break;
            }
            case 50: {
                this.helpButton = this.setButton("Help");
                break;
            }
            case 60: {
                this.historyButton = this.setButton("History");
                break;
            }
            case 70: {
                this.stateButton = this.setButton("State");
                break;
            }
            case 80: {
                this.stepButton = this.setButton("Step");
                break;
            }
            case 90: {
                this.topButton = this.setButton("Top");
                break;
            }
            case 100: {
                this.undoButton = this.setButton("Undo");
                this.redoButton = this.setButton("Redo");
                break;
            }
            case 110: {
                this.varButton = this.setButton("Variables");
                break;
            }
            case 120: {
                this.fontButton = this.setButton("Font");
                this.fontButton.setToolTipText(GT.$("toggle font size"));
            }
        }
    }

    private void setError(boolean TF) {
        this.isError = TF;
    }

    @Override
    public void enterPressed() {
        this.executeCommandAsThread(null);
    }

    @Override
    protected void execute(String strCommand) {
        this.executeCommandAsThread(strCommand);
    }

    void executeCommandAsThread(String strCommand) {
        boolean isUndo;
        if (strCommand == null) {
            strCommand = this.console.getCommandString().trim();
        }
        if (((isUndo = strCommand.equalsIgnoreCase("undo")) || strCommand.equalsIgnoreCase("redo")) && this.checkUndoEnabled() != 2) {
            this.undoRedo(isUndo);
            this.console.appendNewline();
            this.console.setPrompt();
            return;
        }
        if (strCommand.equalsIgnoreCase("exitJmol")) {
            System.exit(0);
        } else if (strCommand.startsWith("font console")) {
            String s = strCommand.substring(12);
            if (PT.parseInt(s) > 0) {
                s = "sansserif-" + s;
            }
            this.console.setFont(Font.decode(s));
            strCommand = " ";
        } else if (strCommand.length() == 0) {
            strCommand = "!resume";
            this.checkUndoEnabled();
        }
        if (strCommand.length() > 0) {
            this.execThread = new ExecuteCommandThread(strCommand);
            this.execThread.start();
        }
    }

    private void undoClear() {
        if (this.undoButton == null) {
            return;
        }
        for (int i = 0; i <= MAXUNDO; ++i) {
            this.undoStack[i] = null;
        }
        this.undoPointer = 0;
        this.undoButton.setEnabled(false);
        this.redoButton.setEnabled(false);
    }

    public int checkUndoEnabled() {
        boolean undoAllowed = this.vwr.getBooleanProperty("undoAuto");
        if (undoAllowed) {
            if (this.undoButton == null) {
                return 0;
            }
            undoAllowed = this.vwr.getBooleanProperty("preserveState");
            this.undoButton.setEnabled(undoAllowed && this.undoPointer > 0 && this.undoStack[this.undoPointer - 1] != null);
            this.redoButton.setEnabled(undoAllowed && this.undoPointer < MAXUNDO && this.undoStack[this.undoPointer + 1] != null);
            return 1;
        }
        if (this.undoButton != null && this.vwr.stm.getUndoMax() > 0) {
            this.undoButton.setEnabled(this.vwr.stm.canDo(603984065));
            this.redoButton.setEnabled(this.vwr.stm.canDo(4139));
        }
        return 2;
    }

    private void undoRedo(boolean isRedo) {
        switch (this.checkUndoEnabled()) {
            case 0: {
                return;
            }
            case 2: {
                this.executeCommand(isRedo ? "redo" : "undo");
                return;
            }
        }
        int ptr = this.undoPointer + (isRedo ? 1 : -1);
        if (!this.undoSaved) {
            this.undoSave(false);
        }
        if (ptr > MAXUNDO || ptr < 0) {
            return;
        }
        String state = this.undoStack[ptr];
        if (state != null) {
            state = state + "#----";
            this.setError(false);
            this.vwr.evalStringQuiet(state);
            this.undoPointer = ptr;
        }
        this.checkUndoEnabled();
    }

    private void undoSave(boolean incrementPtr) {
        int i;
        if (this.undoButton == null) {
            return;
        }
        if (!this.vwr.getBooleanProperty("undoAuto") || !this.vwr.getBooleanProperty("preserveState")) {
            return;
        }
        for (i = this.undoPointer + 1; i <= MAXUNDO; ++i) {
            this.undoStack[i] = null;
        }
        Logger.startTimer("(console");
        try {
            this.undoStack[this.undoPointer] = (String)this.vwr.getProperty("readable", "stateInfo", null);
            if (incrementPtr && this.undoPointer == MAXUNDO) {
                for (i = 1; i <= MAXUNDO; ++i) {
                    this.undoStack[i - 1] = this.undoStack[i];
                }
                this.undoStack[AppConsole.MAXUNDO] = null;
            } else if (incrementPtr) {
                ++this.undoPointer;
            }
        }
        catch (Error e) {
            this.dontsave = true;
        }
        if (this.dontsave || Logger.checkTimer("(console", false) > 2000) {
            this.vwr.setBooleanProperty("undoAuto", false);
            this.undoClear();
            Logger.info("command processing slow; undo disabled");
        } else {
            this.checkUndoEnabled();
        }
        this.undoSaved = true;
    }

    void executeCommand(String strCommand) {
        this.console.appendNewline();
        this.console.setPrompt();
        if (strCommand.length() == 0) {
            this.console.grabFocus();
            return;
        }
        if (strCommand.charAt(0) != '!' && this.vwr.getBooleanProperty("executionPaused")) {
            strCommand = "!" + strCommand;
        }
        if (strCommand.charAt(0) != '!' && !this.isError) {
            this.undoSave(true);
        }
        this.setError(false);
        this.undoSaved = false;
        String strErrorMessage = null;
        boolean doWait = strCommand.indexOf("WAITTEST ") == 0;
        boolean hasExtension = false;
        if (doWait) {
            Object o = this.vwr.scriptWaitStatus(strCommand.substring(5), "+fileLoaded,+scriptStarted,+scriptStatus,+scriptEcho,+scriptTerminated");
            if (o instanceof List) {
                List info = (List)o;
                for (int i = 0; i < info.size(); ++i) {
                    List statusRecordSet = (List)info.get(i);
                    for (int j = 0; j < statusRecordSet.size(); ++j) {
                        List statusRecord = (List)statusRecordSet.get(j);
                        Logger.info("msg#=" + statusRecord.get(0) + " " + statusRecord.get(1) + " intInfo=" + statusRecord.get(2) + " stringInfo=" + statusRecord.get(3));
                    }
                }
            }
            this.console.appendNewline();
        } else {
            boolean isScriptExecuting = this.vwr.isScriptExecuting();
            strErrorMessage = "";
            String str = strCommand;
            boolean isInterrupt = str.charAt(0) == '!';
            boolean bl = hasExtension = strCommand.indexOf("\u0001##") >= 0;
            if (isInterrupt) {
                str = str.substring(1);
            }
            if (this.vwr.checkHalt(str, isInterrupt)) {
                String string = strErrorMessage = isScriptExecuting ? "script execution halted with " + strCommand : "no script was executing - use exitJmol to exit Jmol";
            }
            if (strErrorMessage.length() > 0) {
                if (!hasExtension) {
                    this.console.outputError(strErrorMessage);
                }
            } else {
                this.vwr.script(strCommand + "; ## GUI ##" + (strCommand.indexOf("\u0001##") >= 0 ? "" : "\u0001## EDITOR_IGNORE ##"));
            }
        }
        if (!hasExtension) {
            this.console.grabFocus();
        }
    }

    @Override
    protected void clearContent(String text) {
        this.console.clearContent(text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.console.grabFocus();
        Object source = e.getSource();
        if (source == this.topButton) {
            if (this.scriptEditor != null) {
                this.scriptEditor.gotoTop();
            }
            return;
        }
        if (source == this.checkButton && this.scriptEditor != null) {
            this.scriptEditor.checkScript(0);
        }
        if (source == this.stepButton) {
            if (this.scriptEditor != null) {
                this.scriptEditor.doStep();
            }
            return;
        }
        if (source == this.closeButton) {
            this.setVisible(false);
            return;
        }
        if (source == this.haltButton) {
            this.vwr.haltScriptExecution();
            return;
        }
        if (source == this.varButton) {
            this.execute("!show variables");
            return;
        }
        if (source == this.clearButton) {
            this.console.clearContent(null);
            return;
        }
        if (source == this.undoButton) {
            this.undoRedo(false);
            return;
        }
        if (source == this.redoButton) {
            this.undoRedo(true);
            return;
        }
        if (source == this.fontButton) {
            if (!Viewer.isJS && !this.noPrefs && this.updateFont()) {
                return;
            }
            this.vwr.setConsoleFontScale((this.vwr.getConsoleFontScale() + 1) % 5);
            this.updateFontSize();
            return;
        }
        if (source == this.helpButton) {
            this.vwr.script("help");
        }
        super.actionPerformed(e);
    }

    private boolean updateFont() {
        PreferencesDialog d = null;
        try {
            d = (PreferencesDialog)this.vwr.getProperty("DATA_API", "getPreference", null);
            if (d != null) {
                d.setFontScale(-1);
            }
            return true;
        }
        catch (Exception ee) {
            this.noPrefs = true;
            return false;
        }
    }

    @Override
    protected void recallCommand(boolean up, boolean pageup) {
        String cmd;
        String string = pageup ? this.vwr.historyFind(this.console.pageUpBuffer == null ? (this.console.pageUpBuffer = this.consoleDoc.getCommandString()) : this.console.pageUpBuffer, up ? -1 : 1) : (cmd = this.vwr.getSetHistory(up ? -1 : 1));
        if (cmd == null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        AppConsole.this.hBar.setValue(0);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            return;
        }
        boolean isError = false;
        try {
            if (cmd.endsWith("#??")) {
                isError = true;
                cmd = cmd.substring(0, cmd.indexOf("#??"));
            }
            cmd = this.trimGUI(cmd);
            this.consoleDoc.replaceCommand(cmd, isError);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getText() {
        return this.console.getText();
    }

    public void setStatusListener(JmolStatusListener myStatusListener) {
        this.statusListener = myStatusListener;
    }

    class ConsoleDocument
    extends DefaultStyledDocument {
        private ConsoleTextPane consoleTextPane;
        SimpleAttributeSet attError = new SimpleAttributeSet();
        SimpleAttributeSet attEcho;
        SimpleAttributeSet attPrompt;
        SimpleAttributeSet attUserInput;
        SimpleAttributeSet attStatus;
        private Position positionBeforePrompt;
        private Position positionAfterPrompt;
        private int offsetAfterPrompt;

        ConsoleDocument() {
            StyleConstants.setForeground(this.attError, Color.red);
            this.attPrompt = new SimpleAttributeSet();
            StyleConstants.setForeground(this.attPrompt, Color.magenta);
            this.attUserInput = new SimpleAttributeSet();
            StyleConstants.setForeground(this.attUserInput, Color.black);
            this.attEcho = new SimpleAttributeSet();
            StyleConstants.setForeground(this.attEcho, Color.blue);
            StyleConstants.setBold(this.attEcho, true);
            this.attStatus = new SimpleAttributeSet();
            StyleConstants.setForeground(this.attStatus, Color.black);
            StyleConstants.setItalic(this.attStatus, true);
        }

        void setConsoleTextPane(ConsoleTextPane consoleTextPane) {
            this.consoleTextPane = consoleTextPane;
        }

        boolean isAtEnd() {
            return this.consoleTextPane.getCaretPosition() == this.getLength();
        }

        void clearContent() {
            try {
                super.remove(0, this.getLength());
            }
            catch (BadLocationException exception) {
                Logger.errorEx("Could not clear script window content", exception);
            }
        }

        void setPrompt() {
            try {
                super.insertString(this.getLength(), "$ ", this.attPrompt);
                this.setOffsetPositions();
                this.setCaretPosition(this.offsetAfterPrompt);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        void setOffsetPositions() {
            try {
                this.offsetAfterPrompt = this.getLength();
                this.positionBeforePrompt = this.createPosition(this.offsetAfterPrompt - 2);
                this.positionAfterPrompt = this.createPosition(this.offsetAfterPrompt - 1);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        void setNoPrompt() {
            try {
                this.offsetAfterPrompt = this.getLength();
                this.positionAfterPrompt = this.positionBeforePrompt = this.createPosition(this.offsetAfterPrompt);
                this.setCaretPosition(this.offsetAfterPrompt);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        void outputBeforePrompt(String str, SimpleAttributeSet attribute) {
            try {
                int pt = this.consoleTextPane.getCaretPosition();
                Position caretPosition = this.createPosition(pt);
                pt = this.positionBeforePrompt.getOffset();
                super.insertString(pt, str + "\n", attribute);
                this.offsetAfterPrompt += str.length() + 1;
                this.positionBeforePrompt = this.createPosition(this.offsetAfterPrompt - 2);
                this.positionAfterPrompt = this.createPosition(this.offsetAfterPrompt - 1);
                pt = caretPosition.getOffset();
                this.setCaretPosition(pt);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setCaretPosition(this.getLength());
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        AppConsole.this.vBar.setValue(AppConsole.this.vBar.getMaximum());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }

        void outputError(String strError) {
            this.outputBeforePrompt(strError, this.attError);
        }

        void outputErrorForeground(String strError) {
            try {
                super.insertString(this.getLength(), strError + "\n", this.attError);
                this.setCaretPosition(this.getLength());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        void outputEcho(String strEcho) {
            this.outputBeforePrompt(strEcho, this.attEcho);
        }

        void outputStatus(String strStatus) {
            this.outputBeforePrompt(strStatus, this.attStatus);
        }

        void appendNewline() {
            try {
                super.insertString(this.getLength(), "\n", this.attUserInput);
                this.setCaretPosition(this.getLength());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        @Override
        public synchronized void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            int ichNewline = str.indexOf(10);
            if (ichNewline != 0 || str != "\n" && str.length() > 0) {
                if (offs < this.offsetAfterPrompt) {
                    offs = this.getLength();
                }
                super.insertString(offs, str, a == this.attError ? a : this.attUserInput);
                this.setCaretPosition(offs + str.length());
            }
            if (ichNewline >= 0) {
                this.consoleTextPane.enterPressed();
            }
        }

        private void setCaretPosition(int p) {
            this.consoleTextPane.setCaretPosition(p);
        }

        String getCommandString() {
            String strCommand = "";
            try {
                int cmdStart = this.positionAfterPrompt.getOffset();
                strCommand = this.getText(cmdStart, this.getLength() - cmdStart);
                while (strCommand.length() > 0 && strCommand.charAt(0) == ' ') {
                    strCommand = strCommand.substring(1);
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            return strCommand;
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            if (offs < this.offsetAfterPrompt) {
                if ((len -= this.offsetAfterPrompt - offs) <= 0) {
                    return;
                }
                offs = this.offsetAfterPrompt;
            }
            super.remove(offs, len);
        }

        @Override
        public void replace(int offs, int length, String str, AttributeSet attrs) throws BadLocationException {
            if (offs < this.offsetAfterPrompt) {
                if (offs + length < this.offsetAfterPrompt) {
                    offs = this.getLength();
                    length = 0;
                } else {
                    length -= this.offsetAfterPrompt - offs;
                    offs = this.offsetAfterPrompt;
                }
            }
            super.replace(offs, length, str, attrs);
        }

        void replaceCommand(String newCommand, boolean isError) throws BadLocationException {
            if (this.positionAfterPrompt == this.positionBeforePrompt) {
                return;
            }
            this.replace(this.offsetAfterPrompt, this.getLength() - this.offsetAfterPrompt, newCommand, isError ? this.attError : this.attUserInput);
        }

        void colorCommand(SimpleAttributeSet att) {
            if (this.positionAfterPrompt == this.positionBeforePrompt) {
                return;
            }
            this.setCharacterAttributes(this.offsetAfterPrompt, this.getLength() - this.offsetAfterPrompt, att, true);
        }
    }

    class ConsoleTextPane
    extends JTextPane
    implements KeyListener {
        private EnterListener enterListener;
        boolean checking;
        String pageUpBuffer;
        boolean checkingCommand;
        private Timer checkTimer;

        ConsoleTextPane(AppConsole appConsole) {
            super(new ConsoleDocument());
            this.checking = false;
            AppConsole.this.updateFontSize();
            AppConsole.this.consoleDoc = (ConsoleDocument)this.getDocument();
            AppConsole.this.consoleDoc.setConsoleTextPane(this);
            this.enterListener = appConsole;
            this.addKeyListener(this);
        }

        public String getCommandString() {
            String cmd = AppConsole.this.consoleDoc.getCommandString();
            return cmd;
        }

        public void setPrompt() {
            AppConsole.this.consoleDoc.setPrompt();
        }

        public void appendNewline() {
            AppConsole.this.consoleDoc.appendNewline();
        }

        public void outputError(String strError) {
            AppConsole.this.consoleDoc.outputError(strError);
        }

        public void outputErrorForeground(String strError) {
            AppConsole.this.consoleDoc.outputErrorForeground(strError);
        }

        public void outputEcho(String strEcho) {
            AppConsole.this.consoleDoc.outputEcho(strEcho);
        }

        public void outputStatus(String strStatus) {
            AppConsole.this.consoleDoc.outputStatus(strStatus);
        }

        public void enterPressed() {
            if (this.enterListener != null) {
                this.enterListener.enterPressed();
            }
        }

        public void clearContent(String text) {
            AppConsole.this.consoleDoc.clearContent();
            if (text != null) {
                AppConsole.this.consoleDoc.outputEcho(text);
            }
            this.setPrompt();
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.processKey(e);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.processKey(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.processKey(e);
        }

        protected void processKey(KeyEvent ke) {
            int kcode = ke.getKeyCode();
            int kid = ke.getID();
            if (kid == 401) {
                switch (kcode) {
                    case 67: {
                        if (!ke.isControlDown() || !ke.isAltDown()) break;
                        ke.consume();
                        AppConsole.this.vwr.script("!quit");
                        return;
                    }
                    case 9: {
                        ke.consume();
                        if (!AppConsole.this.consoleDoc.isAtEnd()) break;
                        String cmd = AppConsole.this.completeCommand(AppConsole.this.consoleDoc.getCommandString());
                        if (cmd != null) {
                            try {
                                AppConsole.this.consoleDoc.replaceCommand(cmd, false);
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                        ++AppConsole.this.nTab;
                        return;
                    }
                    case 27: {
                        ke.consume();
                        try {
                            AppConsole.this.consoleDoc.replaceCommand("", false);
                            break;
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                }
                AppConsole.this.nTab = 0;
            }
            if ((kcode == 38 || kcode == 40) && ke.isControlDown() && AppConsole.this.consoleDoc.isAtEnd()) {
                if (kid == 401) {
                    AppConsole.this.recallCommand(kcode == 38, true);
                }
                ke.consume();
                return;
            }
            this.pageUpBuffer = null;
            switch (kid) {
                case 401: {
                    switch (kcode) {
                        case 38: 
                        case 40: {
                            if (!AppConsole.this.consoleDoc.isAtEnd()) break;
                            AppConsole.this.recallCommand(kcode == 38, false);
                            ke.consume();
                        }
                    }
                    break;
                }
                case 402: {
                    if (this.checkingCommand || ke.getModifiers() >= 2 || kcode != 32 && (kcode <= 40 || kcode >= 400) && kcode != 8) break;
                    this.checkingCommand = true;
                    if (this.checkTimer == null) {
                        this.checkTimer = new Timer(100, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                ConsoleTextPane.this.checkingCommand = false;
                                ConsoleTextPane.this.checkCommand();
                            }
                        });
                        this.checkTimer.setRepeats(false);
                        this.checkTimer.start();
                        break;
                    }
                    this.checkTimer.restart();
                }
            }
        }

        synchronized void checkCommand() {
            String strCommand = AppConsole.this.consoleDoc.getCommandString();
            if (strCommand.length() == 0 || strCommand.charAt(0) == '!' || AppConsole.this.vwr.isScriptExecuting() || AppConsole.this.vwr.getBooleanProperty("executionPaused")) {
                return;
            }
            this.checking = true;
            Object res = AppConsole.this.vwr.scriptCheck(strCommand);
            AppConsole.this.consoleDoc.colorCommand(res instanceof String ? AppConsole.this.consoleDoc.attError : AppConsole.this.consoleDoc.attUserInput);
            this.checking = false;
        }
    }

    class ExecuteCommandThread
    extends Thread {
        String strCommand;

        ExecuteCommandThread(String command) {
            this.strCommand = command;
            this.setName("appConsoleExecuteCommandThread");
        }

        @Override
        public void run() {
            try {
                AppConsole.this.executeCommand(this.strCommand);
            }
            catch (Exception ie) {
                Logger.errorEx("execution command interrupted!", ie);
            }
        }
    }
}

