
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include <qapp_macro.h>

QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "searchenginesmanager_engine_wrapper.h"

// inner classes

// Extra includes
#include <searchenginesmanager.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_SearchEnginesManager_Engine_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::SearchEnginesManager::Engine >()))
        return -1;

    ::SearchEnginesManager::Engine *cptr{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "Engine", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: Engine::Engine()
    // 1: Engine::Engine(SearchEnginesManager::Engine)
    if (numArgs == 0) {
        overloadId = 0; // Engine()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // Engine(SearchEnginesManager::Engine)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_SearchEnginesManager_Engine_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // Engine()
        {

            if (!PyErr_Occurred()) {
                // Engine()
                cptr = new ::SearchEnginesManager::Engine();
            }
            break;
        }
        case 1: // Engine(const SearchEnginesManager::Engine & Engine)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::SearchEnginesManager::Engine cppArg0_local;
            ::SearchEnginesManager::Engine *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // Engine(SearchEnginesManager::Engine)
                cptr = new ::SearchEnginesManager::Engine(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::SearchEnginesManager::Engine >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto Sbk_SearchEnginesManager_Engine_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_SearchEnginesManager_Engine_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.SearchEnginesManager.Engine");
        return -1;
}

static PyObject *Sbk_SearchEnginesManager_EngineFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::SearchEnginesManager::Engine *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_SearchEnginesManager_Engine___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_SearchEnginesManager_Engine_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_SearchEnginesManager_Engine_methods[] = {
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManager_EngineFunc_isValid), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_SearchEnginesManager_Engine___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_SearchEnginesManager_Engine_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), (pyArg)))) {
                // operator==(const SearchEnginesManager::Engine & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::SearchEnginesManager::Engine cppArg0_local;
                ::SearchEnginesManager::Engine *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_SearchEnginesManager_Engine_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_SearchEnginesManager_Engine_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

static PyObject *Sbk_SearchEnginesManager_Engine_get_name(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->name);
    return pyOut;
}
static int Sbk_SearchEnginesManager_Engine_set_name(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'name' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'name', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->name;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_SearchEnginesManager_Engine_get_icon(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->icon)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->icon))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->icon)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), &(cppSelf->icon), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_SearchEnginesManager_Engine_set_icon(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'icon' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'icon', 'QIcon' or convertible type expected");
        return -1;
    }

    ::QIcon& cppOut_ptr = cppSelf->icon;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_SearchEnginesManager_Engine_get_url(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->url);
    return pyOut;
}
static int Sbk_SearchEnginesManager_Engine_set_url(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'url' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'url', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->url;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_SearchEnginesManager_Engine_get_shortcut(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->shortcut);
    return pyOut;
}
static int Sbk_SearchEnginesManager_Engine_set_shortcut(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'shortcut' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'shortcut', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->shortcut;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_SearchEnginesManager_Engine_get_suggestionsUrl(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->suggestionsUrl);
    return pyOut;
}
static int Sbk_SearchEnginesManager_Engine_set_suggestionsUrl(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'suggestionsUrl' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'suggestionsUrl', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->suggestionsUrl;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_SearchEnginesManager_Engine_get_suggestionsParameters(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->suggestionsParameters)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->suggestionsParameters))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->suggestionsParameters)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &(cppSelf->suggestionsParameters), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_SearchEnginesManager_Engine_set_suggestionsParameters(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'suggestionsParameters' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'suggestionsParameters', 'QByteArray' or convertible type expected");
        return -1;
    }

    ::QByteArray& cppOut_ptr = cppSelf->suggestionsParameters;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_SearchEnginesManager_Engine_get_postData(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->postData)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->postData))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->postData)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &(cppSelf->postData), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_SearchEnginesManager_Engine_set_postData(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'postData' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'postData', 'QByteArray' or convertible type expected");
        return -1;
    }

    ::QByteArray& cppOut_ptr = cppSelf->postData;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for Engine
static PyGetSetDef Sbk_SearchEnginesManager_Engine_getsetlist[] = {
    {const_cast<char *>("name"), Sbk_SearchEnginesManager_Engine_get_name, Sbk_SearchEnginesManager_Engine_set_name},
    {const_cast<char *>("icon"), Sbk_SearchEnginesManager_Engine_get_icon, Sbk_SearchEnginesManager_Engine_set_icon},
    {const_cast<char *>("url"), Sbk_SearchEnginesManager_Engine_get_url, Sbk_SearchEnginesManager_Engine_set_url},
    {const_cast<char *>("shortcut"), Sbk_SearchEnginesManager_Engine_get_shortcut, Sbk_SearchEnginesManager_Engine_set_shortcut},
    {const_cast<char *>("suggestionsUrl"), Sbk_SearchEnginesManager_Engine_get_suggestionsUrl, Sbk_SearchEnginesManager_Engine_set_suggestionsUrl},
    {const_cast<char *>("suggestionsParameters"), Sbk_SearchEnginesManager_Engine_get_suggestionsParameters, Sbk_SearchEnginesManager_Engine_set_suggestionsParameters},
    {const_cast<char *>("postData"), Sbk_SearchEnginesManager_Engine_get_postData, Sbk_SearchEnginesManager_Engine_set_postData},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_SearchEnginesManager_Engine_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_SearchEnginesManager_Engine_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_SearchEnginesManager_Engine_Type = nullptr;
static SbkObjectType *Sbk_SearchEnginesManager_Engine_TypeF(void)
{
    return _Sbk_SearchEnginesManager_Engine_Type;
}

static PyType_Slot Sbk_SearchEnginesManager_Engine_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_SearchEnginesManager_Engine_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_SearchEnginesManager_Engine_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_SearchEnginesManager_Engine_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_SearchEnginesManager_Engine_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_SearchEnginesManager_Engine_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_SearchEnginesManager_Engine_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_SearchEnginesManager_Engine_spec = {
    "1:PyFalkon.SearchEnginesManager.Engine",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_SearchEnginesManager_Engine_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void Engine_PythonToCpp_Engine_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_SearchEnginesManager_Engine_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_Engine_PythonToCpp_Engine_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_SearchEnginesManager_Engine_TypeF())))
        return Engine_PythonToCpp_Engine_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *Engine_PTR_CppToPython_Engine(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::SearchEnginesManager::Engine *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_SearchEnginesManager_Engine_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *Engine_COPY_CppToPython_Engine(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_SearchEnginesManager_Engine_TypeF(), new ::SearchEnginesManager::Engine(*reinterpret_cast<const ::SearchEnginesManager::Engine *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void Engine_PythonToCpp_Engine_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::SearchEnginesManager::Engine *>(cppOut) = *reinterpret_cast< ::SearchEnginesManager::Engine *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_Engine_PythonToCpp_Engine_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_SearchEnginesManager_Engine_TypeF())))
        return Engine_PythonToCpp_Engine_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *SearchEnginesManager_Engine_SignatureStrings[] = {
    "1:PyFalkon.SearchEnginesManager.Engine(self)",
    "0:PyFalkon.SearchEnginesManager.Engine(self,Engine:PyFalkon.SearchEnginesManager.Engine)",
    "PyFalkon.SearchEnginesManager.Engine.isValid(self)->bool",
    "PyFalkon.SearchEnginesManager.Engine.__copy__()",
    nullptr}; // Sentinel

void init_SearchEnginesManager_Engine(PyObject *enclosingClass)
{
    _Sbk_SearchEnginesManager_Engine_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "Engine",
        "SearchEnginesManager::Engine",
        &Sbk_SearchEnginesManager_Engine_spec,
        &Shiboken::callCppDestructor< ::SearchEnginesManager::Engine >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_SearchEnginesManager_Engine_Type);
    InitSignatureStrings(pyType, SearchEnginesManager_Engine_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_SearchEnginesManager_Engine_Type), Sbk_SearchEnginesManager_Engine_PropertyStrings);
    SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_SearchEnginesManager_Engine_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_SearchEnginesManager_Engine_TypeF(),
        Engine_PythonToCpp_Engine_PTR,
        is_Engine_PythonToCpp_Engine_PTR_Convertible,
        Engine_PTR_CppToPython_Engine,
        Engine_COPY_CppToPython_Engine);

    Shiboken::Conversions::registerConverterName(converter, "SearchEnginesManager::Engine");
    Shiboken::Conversions::registerConverterName(converter, "SearchEnginesManager::Engine*");
    Shiboken::Conversions::registerConverterName(converter, "SearchEnginesManager::Engine&");
    Shiboken::Conversions::registerConverterName(converter, "Engine");
    Shiboken::Conversions::registerConverterName(converter, "Engine*");
    Shiboken::Conversions::registerConverterName(converter, "Engine&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::SearchEnginesManager::Engine).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        Engine_PythonToCpp_Engine_COPY,
        is_Engine_PythonToCpp_Engine_COPY_Convertible);


    qRegisterMetaType< ::SearchEnginesManager::Engine >("Engine");
    qRegisterMetaType< ::SearchEnginesManager::Engine >("SearchEnginesManager::Engine");
}
