/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public final class PatchByteCode {
    private static final String DISABLE_PATCHING = PatchByteCode.class.getName() + ".disable";
    private static final Logger LOG = Logger.getLogger(PatchByteCode.class.getName());
    private static final byte[] RUNTIME_INVISIBLE_ANNOTATIONS;
    private static final byte[] PATCHED_PUBLIC;
    private static final String DESC_CTOR_ANNOTATION = "Lorg/openide/modules/ConstructorDelegate;";
    private static final String DESC_PATCHED_PUBLIC_ANNOTATION = "Lorg/openide/modules/PatchedPublic;";
    private static final String DESC_DEFAULT_CTOR = "()V";
    private static final String CONSTRUCTOR_NAME = "<init>";
    private static final String PREFIX_EXTEND = "extend.";
    private static final PatchByteCode NOP;
    private static final PatchByteCode PUBLIC_ONLY;
    private final boolean patchPublic;
    private final Map<String, String> classToExtend;
    private final ClassLoader theClassLoader;
    private static Method patchAsmMethod;

    private PatchByteCode() {
        this(false, null, null);
    }

    private PatchByteCode(boolean bl, Map<String, String> map, ClassLoader classLoader) {
        this.patchPublic = bl;
        this.classToExtend = map;
        this.theClassLoader = classLoader;
    }

    private void load(URL uRL) throws IOException {
        try (InputStream inputStream = uRL.openStream();){
            Properties properties = new Properties();
            properties.load(new InputStreamReader(inputStream, "UTF-8"));
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string;
                String string2;
                String string3;
                String string4 = (String)enumeration.nextElement();
                if (!string4.startsWith(PREFIX_EXTEND) || (string3 = this.classToExtend.put(string2 = string4.substring(PREFIX_EXTEND.length()), string = properties.getProperty(string4))) == null) continue;
                throw new IOException("Multiple extend instructions for class" + string2 + ": " + string + " and " + string3);
            }
        }
    }

    private PatchByteCode purify() {
        if (this.classToExtend == null || this.classToExtend.isEmpty()) {
            return PUBLIC_ONLY;
        }
        return this;
    }

    static PatchByteCode fromStream(Enumeration<URL> enumeration, ClassLoader classLoader) {
        if (System.getProperty(DISABLE_PATCHING) != null) {
            return NOP;
        }
        PatchByteCode patchByteCode = new PatchByteCode(false, new HashMap<String, String>(3), classLoader);
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            try {
                patchByteCode.load(uRL);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            bl = true;
        }
        return bl ? patchByteCode.purify() : NOP;
    }

    byte[] apply(String string, byte[] byArray) throws IOException {
        if (this.patchPublic) {
            return PatchByteCode.patch(byArray);
        }
        if (this.classToExtend == null) {
            return byArray;
        }
        String string2 = this.classToExtend.get(string);
        if (string2 == null) {
            return PatchByteCode.patch(byArray);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = PatchByteCode.class.getClassLoader();
        }
        try {
            return (byte[])this.patchAsmMethod(classLoader).invoke(null, byArray, string2, this.theClassLoader);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    private Method patchAsmMethod(ClassLoader classLoader) throws NoSuchMethodException, SecurityException, ClassNotFoundException {
        if (patchAsmMethod == null) {
            Class<?> clazz = Class.forName("org.netbeans.core.startup.Asm", true, classLoader);
            patchAsmMethod = clazz.getDeclaredMethod("patch", byte[].class, String.class, ClassLoader.class);
            patchAsmMethod.setAccessible(true);
        }
        return patchAsmMethod;
    }

    public static byte[] patch(byte[] byArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = PatchByteCode.u2(byArray, 8);
        int[] nArray = new int[n7];
        int n8 = 10;
        block7: for (n6 = 1; n6 < n7; ++n6) {
            n5 = PatchByteCode.u1(byArray, n8++);
            nArray[n6] = n8;
            switch (n5) {
                case 1: {
                    n4 = PatchByteCode.u2(byArray, n8);
                    n8 += n4 + 2;
                    continue block7;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 17: 
                case 18: {
                    n8 += 4;
                    continue block7;
                }
                case 7: 
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    n8 += 2;
                    continue block7;
                }
                case 5: 
                case 6: {
                    n8 += 8;
                    ++n6;
                    continue block7;
                }
                case 15: {
                    n8 += 3;
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("illegal constant pool tag " + n5 + " at index " + n6 + " out of " + n7);
                }
            }
        }
        n6 = PatchByteCode.u2(byArray, n8 += 6);
        n8 += 2;
        n5 = PatchByteCode.u2(byArray, n8 += 2 * n6);
        n8 += 2;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = PatchByteCode.u2(byArray, n8 += 6);
            n8 += 2;
            for (n2 = 0; n2 < n3; ++n2) {
                n = PatchByteCode.u4(byArray, n8 += 2);
                n8 += 4;
                n8 += n;
            }
        }
        n4 = PatchByteCode.u2(byArray, n8);
        n8 += 2;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = n8;
            n = PatchByteCode.u2(byArray, n8 += 6);
            n8 += 2;
            for (int i = 0; i < n; ++i) {
                int n9 = nArray[PatchByteCode.u2(byArray, n8)];
                int n10 = PatchByteCode.u4(byArray, n8 += 2);
                n8 += 4;
                if (PatchByteCode.utf8Matches(byArray, n9, RUNTIME_INVISIBLE_ANNOTATIONS)) {
                    int n11 = PatchByteCode.u2(byArray, n8);
                    int n12 = n8 + 2;
                    for (int j = 0; j < n11; ++j) {
                        if (!PatchByteCode.utf8Matches(byArray, nArray[PatchByteCode.u2(byArray, n12)], PATCHED_PUBLIC)) continue;
                        int n13 = n2 + 1;
                        byArray[n13] = (byte)(byArray[n13] & 0xF9);
                        int n14 = n2 + 1;
                        byArray[n14] = (byte)(byArray[n14] | 1);
                    }
                }
                n8 += n10;
            }
        }
        return byArray;
    }

    private static int u1(byte[] byArray, int n) {
        int n2 = byArray[n];
        return n2 >= 0 ? n2 : n2 + 256;
    }

    private static int u2(byte[] byArray, int n) {
        return (PatchByteCode.u1(byArray, n) << 8) + PatchByteCode.u1(byArray, n + 1);
    }

    private static int u4(byte[] byArray, int n) {
        return (PatchByteCode.u2(byArray, n) << 16) + PatchByteCode.u2(byArray, n + 2);
    }

    private static boolean utf8Matches(byte[] byArray, int n, byte[] byArray2) {
        if (PatchByteCode.u2(byArray, n) != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[n + 2 + i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    static {
        try {
            RUNTIME_INVISIBLE_ANNOTATIONS = "RuntimeInvisibleAnnotations".getBytes("UTF-8");
            PATCHED_PUBLIC = DESC_PATCHED_PUBLIC_ANNOTATION.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ExceptionInInitializerError(unsupportedEncodingException);
        }
        NOP = new PatchByteCode(false, null, null);
        PUBLIC_ONLY = new PatchByteCode(true, null, null);
    }
}

