/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Iterator;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.ast.util.SexpMaker;
import org.jruby.compiler.Compilable;
import org.jruby.compiler.JITCompiler;
import org.jruby.compiler.MethodJITClassGenerator;
import org.jruby.internal.runtime.methods.CompiledIRMethod;
import org.jruby.internal.runtime.methods.MixedModeIRMethod;
import org.jruby.ir.targets.JVMVisitor;
import org.jruby.ir.targets.JVMVisitorMethodContext;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.util.collections.IntHashMap;

class MethodJITTask
extends JITCompiler.Task {
    private final String className;
    private final MixedModeIRMethod method;
    private final String methodName;

    public MethodJITTask(JITCompiler jitCompiler, MixedModeIRMethod method2, String className) {
        super(jitCompiler);
        this.method = method2;
        this.className = className;
        this.methodName = method2.getName();
    }

    @Override
    public void exec() throws NoSuchMethodException, IllegalAccessException {
        block4: {
            IntHashMap<MethodType> signatures;
            MethodHandle variable;
            Class<?> sourceClass;
            JVMVisitorMethodContext context;
            block3: {
                String excludeModuleName = MethodJITTask.checkExcludedMethod(this.jitCompiler.config, this.className, this.methodName, this.method);
                if (excludeModuleName != null) {
                    this.method.setCallCount(-1);
                    if (this.jitCompiler.config.isJitLogging()) {
                        this.logImpl("skipping method in " + excludeModuleName, new Object[0]);
                    }
                    return;
                }
                String key2 = SexpMaker.sha1(this.method.getIRScope());
                Ruby runtime2 = this.jitCompiler.runtime;
                JVMVisitor visitor = JVMVisitor.newForJIT(runtime2);
                MethodJITClassGenerator generator = new MethodJITClassGenerator(this.className, this.methodName, key2, runtime2, this.method, visitor);
                context = new JVMVisitorMethodContext();
                generator.compile(context);
                sourceClass = this.defineClass(generator, visitor, this.method.getIRScope(), this.method.ensureInstrsReady());
                if (sourceClass == null) {
                    return;
                }
                String variableName = context.getVariableName();
                variable = JITCompiler.PUBLIC_LOOKUP.findStatic(sourceClass, variableName, context.getNativeSignature(-1));
                signatures = context.getNativeSignaturesExceptVariable();
                if (signatures.size() != 0) break block3;
                this.method.completeBuild(new CompiledIRMethod(variable, null, -1, this.method.getIRScope(), this.method.getVisibility(), this.method.getImplementationClass(), ArgumentDescriptor.encode(this.method.getArgumentDescriptors())));
                break block4;
            }
            Iterator<IntHashMap.Entry<MethodType>> iterator = signatures.entrySet().iterator();
            if (!iterator.hasNext()) break block4;
            IntHashMap.Entry<MethodType> entry = iterator.next();
            this.method.completeBuild(new CompiledIRMethod(variable, JITCompiler.PUBLIC_LOOKUP.findStatic(sourceClass, context.getSpecificName(), entry.getValue()), entry.getKey(), this.method.getIRScope(), this.method.getVisibility(), this.method.getImplementationClass(), ArgumentDescriptor.encode(this.method.getArgumentDescriptors())));
        }
    }

    @Override
    protected String getSourceFile() {
        return this.method.getFile();
    }

    @Override
    protected void logJitted() {
        this.logImpl("method done jitting", new Object[0]);
    }

    @Override
    protected void logFailed(Throwable ex) {
        this.logImpl("could not compile method; passes run: " + this.method.getIRScope().getExecutedPasses(), ex);
    }

    @Override
    protected void logImpl(String message2, Object ... reason2) {
        JITCompiler.log(this.method, this.methodName, message2, reason2);
    }

    static String checkExcludedMethod(RubyInstanceConfig config, String className, String methodName, Compilable target) {
        if (config.getExcludedMethods().size() > 0) {
            RubyBasicObject possibleRealClass;
            RubyModule implementationClass = target.getImplementationClass();
            String excludeModuleName = className;
            if (implementationClass.getMethodLocation().isSingleton() && (possibleRealClass = ((MetaClass)implementationClass).getAttached()) instanceof RubyModule) {
                excludeModuleName = "Meta:" + ((RubyModule)possibleRealClass).getName();
            }
            if (config.getExcludedMethods().contains(excludeModuleName) || config.getExcludedMethods().contains(methodName) || config.getExcludedMethods().contains(excludeModuleName + '#' + methodName) || config.getExcludedMethods().contains(target.getFile()) || config.getExcludedMethods().contains(target.getFile() + ':' + target.getLine())) {
                return excludeModuleName;
            }
        }
        return null;
    }
}

