/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.selection;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.protege.editor.owl.model.selection.OWLSelectionModel;
import org.protege.editor.owl.model.selection.OWLSelectionModelListener;
import org.protege.editor.owl.model.util.OWLAxiomInstance;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLSelectionModelImpl
implements OWLSelectionModel {
    private final Logger logger = LoggerFactory.getLogger(OWLSelectionModelImpl.class);
    private final List<OWLSelectionModelListener> listeners = new ArrayList<OWLSelectionModelListener>();
    private OWLObject selectedObject;
    private OWLEntity lastSelectedEntity;
    private OWLClass lastSelectedClass;
    private OWLDataProperty lastSelectedDataProperty;
    private OWLObjectProperty lastSelectedObjectProperty;
    private OWLAnnotationProperty lastSelectedAnnotationProperty;
    private OWLNamedIndividual lastSelectedIndividual;
    private OWLDatatype lastSelectedDatatype;
    private OWLAxiomInstance lastSelectedAxiomInstance;
    private final OWLEntityVisitor updateVisitor = new OWLEntityVisitor(){

        public void visit(@Nonnull OWLClass cls) {
            OWLSelectionModelImpl.this.lastSelectedClass = cls;
        }

        public void visit(@Nonnull OWLObjectProperty property) {
            OWLSelectionModelImpl.this.lastSelectedObjectProperty = property;
        }

        public void visit(@Nonnull OWLDataProperty property) {
            OWLSelectionModelImpl.this.lastSelectedDataProperty = property;
        }

        public void visit(@Nonnull OWLAnnotationProperty owlAnnotationProperty) {
            OWLSelectionModelImpl.this.lastSelectedAnnotationProperty = owlAnnotationProperty;
        }

        public void visit(@Nonnull OWLNamedIndividual individual) {
            OWLSelectionModelImpl.this.lastSelectedIndividual = individual;
        }

        public void visit(@Nonnull OWLDatatype dataType) {
            OWLSelectionModelImpl.this.lastSelectedDatatype = dataType;
        }
    };
    private final OWLEntityVisitor clearVisitor = new OWLEntityVisitor(){

        public void visit(@Nonnull OWLClass cls) {
            if (OWLSelectionModelImpl.this.lastSelectedClass != null && OWLSelectionModelImpl.this.lastSelectedClass.equals(cls)) {
                OWLSelectionModelImpl.this.lastSelectedClass = null;
                OWLSelectionModelImpl.this.fireSelectionChanged();
            }
        }

        public void visit(@Nonnull OWLObjectProperty property) {
            if (OWLSelectionModelImpl.this.lastSelectedObjectProperty != null && OWLSelectionModelImpl.this.lastSelectedObjectProperty.equals(property)) {
                OWLSelectionModelImpl.this.lastSelectedObjectProperty = null;
                OWLSelectionModelImpl.this.fireSelectionChanged();
            }
        }

        public void visit(@Nonnull OWLDataProperty property) {
            if (OWLSelectionModelImpl.this.lastSelectedDataProperty != null && OWLSelectionModelImpl.this.lastSelectedDataProperty.equals(property)) {
                OWLSelectionModelImpl.this.lastSelectedDataProperty = null;
                OWLSelectionModelImpl.this.fireSelectionChanged();
            }
        }

        public void visit(@Nonnull OWLAnnotationProperty property) {
            if (OWLSelectionModelImpl.this.lastSelectedAnnotationProperty != null && OWLSelectionModelImpl.this.lastSelectedAnnotationProperty.equals(property)) {
                OWLSelectionModelImpl.this.lastSelectedAnnotationProperty = null;
                OWLSelectionModelImpl.this.fireSelectionChanged();
            }
        }

        public void visit(@Nonnull OWLNamedIndividual individual) {
            if (OWLSelectionModelImpl.this.lastSelectedIndividual != null && OWLSelectionModelImpl.this.lastSelectedIndividual.equals(individual)) {
                OWLSelectionModelImpl.this.lastSelectedIndividual = null;
                OWLSelectionModelImpl.this.fireSelectionChanged();
            }
        }

        public void visit(@Nonnull OWLDatatype dataType) {
            if (OWLSelectionModelImpl.this.lastSelectedDatatype != null && OWLSelectionModelImpl.this.lastSelectedDatatype.equals(dataType)) {
                OWLSelectionModelImpl.this.lastSelectedDatatype = null;
                OWLSelectionModelImpl.this.fireSelectionChanged();
            }
        }
    };

    @Override
    public void addListener(@Nonnull OWLSelectionModelListener listener) {
        this.listeners.add((OWLSelectionModelListener)Preconditions.checkNotNull((Object)listener));
    }

    @Override
    public void removeListener(@Nonnull OWLSelectionModelListener listener) {
        this.listeners.remove(Preconditions.checkNotNull((Object)listener));
    }

    @Override
    @Nullable
    public OWLObject getSelectedObject() {
        return this.selectedObject;
    }

    @Override
    public void setSelectedObject(@Nullable OWLObject object) {
        if (object == null) {
            if (this.selectedObject != null) {
                this.updateSelectedObject(null);
            }
        } else if (this.selectedObject == null) {
            this.updateSelectedObject(object);
        } else if (!this.selectedObject.equals(object)) {
            this.updateSelectedObject(object);
        }
    }

    private void updateSelectedObject(OWLObject selObj) {
        this.selectedObject = selObj;
        this.updateLastSelection();
        this.logger.debug("Set the selected object to: {}", (Object)selObj);
        this.fireSelectionChanged();
    }

    @Override
    public OWLEntity getSelectedEntity() {
        return this.lastSelectedEntity;
    }

    private void fireSelectionChanged() {
        for (OWLSelectionModelListener listener : new ArrayList<OWLSelectionModelListener>(this.listeners)) {
            try {
                listener.selectionChanged();
            }
            catch (Exception e) {
                this.logger.warn("A selection model listener threw an error whilst handling a selection changed event: {}", (Throwable)e);
            }
        }
    }

    @Override
    public void setSelectedEntity(@Nullable OWLEntity entity) {
        this.setSelectedObject((OWLObject)entity);
    }

    @Override
    public void setSelectedAxiom(@Nonnull OWLAxiomInstance axiomInstance) {
        this.lastSelectedAxiomInstance = axiomInstance;
        this.setSelectedObject((OWLObject)axiomInstance.getAxiom());
    }

    @Override
    public void clearLastSelectedEntity(@Nonnull OWLEntity entity) {
        entity.accept(this.clearVisitor);
        if (this.lastSelectedEntity != null && entity.equals(this.lastSelectedEntity)) {
            this.lastSelectedEntity = null;
            this.fireSelectionChanged();
        }
    }

    private void updateLastSelection() {
        if (this.selectedObject == null) {
            return;
        }
        if (this.selectedObject instanceof OWLEntity) {
            this.lastSelectedEntity = (OWLEntity)this.selectedObject;
            this.lastSelectedEntity.accept(this.updateVisitor);
            this.lastSelectedAxiomInstance = null;
        }
    }

    @Override
    public OWLClass getLastSelectedClass() {
        return this.lastSelectedClass;
    }

    @Override
    public OWLObjectProperty getLastSelectedObjectProperty() {
        return this.lastSelectedObjectProperty;
    }

    @Override
    public OWLDataProperty getLastSelectedDataProperty() {
        return this.lastSelectedDataProperty;
    }

    @Override
    public OWLAnnotationProperty getLastSelectedAnnotationProperty() {
        return this.lastSelectedAnnotationProperty;
    }

    @Override
    public OWLNamedIndividual getLastSelectedIndividual() {
        return this.lastSelectedIndividual;
    }

    @Override
    public OWLDatatype getLastSelectedDatatype() {
        return this.lastSelectedDatatype;
    }

    @Override
    public OWLAxiomInstance getLastSelectedAxiomInstance() {
        return this.lastSelectedAxiomInstance;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OWLSelectionModelImpl").add("selectedObject", (Object)this.selectedObject).add("lastSelectedEntity", (Object)this.lastSelectedEntity).add("lastSelectedClass", (Object)this.lastSelectedClass).add("lastSelectedObjectProperty", (Object)this.lastSelectedObjectProperty).add("lastSelectedDataProperty", (Object)this.lastSelectedDataProperty).add("lastSelectedAnnotationProperty", (Object)this.lastSelectedAnnotationProperty).add("lastSelectedNamedIndividual", (Object)this.lastSelectedIndividual).add("lastSelectedDatatype", (Object)this.lastSelectedDatatype).add("lastSelectedAxiom", (Object)this.lastSelectedAxiomInstance).toString();
    }
}

