# -*- coding: utf-8 -*-
# Auto-generated by Stone, do not modify.
# @generated
# flake8: noqa
# pylint: skip-file
from __future__ import unicode_literals
from stone.backends.python_rsrc import stone_base as bb
from stone.backends.python_rsrc import stone_validators as bv

from dropbox import common
from dropbox import file_requests
from dropbox import files
from dropbox import sharing
from dropbox import team
from dropbox import team_common
from dropbox import team_policies
from dropbox import users_common

class AccessMethodLogInfo(bb.Union):
    """
    Indicates the method in which the action was performed.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar WebSessionLogInfo AccessMethodLogInfo.admin_console: Admin console
        session details.
    :ivar ApiSessionLogInfo AccessMethodLogInfo.api: Api session details.
    :ivar WebSessionLogInfo AccessMethodLogInfo.content_manager: Content manager
        session details.
    :ivar SessionLogInfo AccessMethodLogInfo.end_user: End user session details.
    :ivar WebSessionLogInfo AccessMethodLogInfo.enterprise_console: Enterprise
        console session details.
    :ivar WebSessionLogInfo AccessMethodLogInfo.sign_in_as: Sign in as session
        details.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def admin_console(cls, val):
        """
        Create an instance of this class set to the ``admin_console`` tag with
        value ``val``.

        :param WebSessionLogInfo val:
        :rtype: AccessMethodLogInfo
        """
        return cls('admin_console', val)

    @classmethod
    def api(cls, val):
        """
        Create an instance of this class set to the ``api`` tag with value
        ``val``.

        :param ApiSessionLogInfo val:
        :rtype: AccessMethodLogInfo
        """
        return cls('api', val)

    @classmethod
    def content_manager(cls, val):
        """
        Create an instance of this class set to the ``content_manager`` tag with
        value ``val``.

        :param WebSessionLogInfo val:
        :rtype: AccessMethodLogInfo
        """
        return cls('content_manager', val)

    @classmethod
    def end_user(cls, val):
        """
        Create an instance of this class set to the ``end_user`` tag with value
        ``val``.

        :param SessionLogInfo val:
        :rtype: AccessMethodLogInfo
        """
        return cls('end_user', val)

    @classmethod
    def enterprise_console(cls, val):
        """
        Create an instance of this class set to the ``enterprise_console`` tag
        with value ``val``.

        :param WebSessionLogInfo val:
        :rtype: AccessMethodLogInfo
        """
        return cls('enterprise_console', val)

    @classmethod
    def sign_in_as(cls, val):
        """
        Create an instance of this class set to the ``sign_in_as`` tag with
        value ``val``.

        :param WebSessionLogInfo val:
        :rtype: AccessMethodLogInfo
        """
        return cls('sign_in_as', val)

    def is_admin_console(self):
        """
        Check if the union tag is ``admin_console``.

        :rtype: bool
        """
        return self._tag == 'admin_console'

    def is_api(self):
        """
        Check if the union tag is ``api``.

        :rtype: bool
        """
        return self._tag == 'api'

    def is_content_manager(self):
        """
        Check if the union tag is ``content_manager``.

        :rtype: bool
        """
        return self._tag == 'content_manager'

    def is_end_user(self):
        """
        Check if the union tag is ``end_user``.

        :rtype: bool
        """
        return self._tag == 'end_user'

    def is_enterprise_console(self):
        """
        Check if the union tag is ``enterprise_console``.

        :rtype: bool
        """
        return self._tag == 'enterprise_console'

    def is_sign_in_as(self):
        """
        Check if the union tag is ``sign_in_as``.

        :rtype: bool
        """
        return self._tag == 'sign_in_as'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_admin_console(self):
        """
        Admin console session details.

        Only call this if :meth:`is_admin_console` is true.

        :rtype: WebSessionLogInfo
        """
        if not self.is_admin_console():
            raise AttributeError("tag 'admin_console' not set")
        return self._value

    def get_api(self):
        """
        Api session details.

        Only call this if :meth:`is_api` is true.

        :rtype: ApiSessionLogInfo
        """
        if not self.is_api():
            raise AttributeError("tag 'api' not set")
        return self._value

    def get_content_manager(self):
        """
        Content manager session details.

        Only call this if :meth:`is_content_manager` is true.

        :rtype: WebSessionLogInfo
        """
        if not self.is_content_manager():
            raise AttributeError("tag 'content_manager' not set")
        return self._value

    def get_end_user(self):
        """
        End user session details.

        Only call this if :meth:`is_end_user` is true.

        :rtype: SessionLogInfo
        """
        if not self.is_end_user():
            raise AttributeError("tag 'end_user' not set")
        return self._value

    def get_enterprise_console(self):
        """
        Enterprise console session details.

        Only call this if :meth:`is_enterprise_console` is true.

        :rtype: WebSessionLogInfo
        """
        if not self.is_enterprise_console():
            raise AttributeError("tag 'enterprise_console' not set")
        return self._value

    def get_sign_in_as(self):
        """
        Sign in as session details.

        Only call this if :meth:`is_sign_in_as` is true.

        :rtype: WebSessionLogInfo
        """
        if not self.is_sign_in_as():
            raise AttributeError("tag 'sign_in_as' not set")
        return self._value

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AccessMethodLogInfo, self)._process_custom_annotations(annotation_type, field_path, processor)

AccessMethodLogInfo_validator = bv.Union(AccessMethodLogInfo)

class AccountCaptureAvailability(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    available = None
    # Attribute is overwritten below the class definition
    unavailable = None
    # Attribute is overwritten below the class definition
    other = None

    def is_available(self):
        """
        Check if the union tag is ``available``.

        :rtype: bool
        """
        return self._tag == 'available'

    def is_unavailable(self):
        """
        Check if the union tag is ``unavailable``.

        :rtype: bool
        """
        return self._tag == 'unavailable'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AccountCaptureAvailability, self)._process_custom_annotations(annotation_type, field_path, processor)

AccountCaptureAvailability_validator = bv.Union(AccountCaptureAvailability)

class AccountCaptureChangeAvailabilityDetails(bb.Struct):
    """
    Granted/revoked option to enable account capture on team domains.

    :ivar team_log.AccountCaptureChangeAvailabilityDetails.new_value: New
        account capture availabilty value.
    :ivar team_log.AccountCaptureChangeAvailabilityDetails.previous_value:
        Previous account capture availabilty value. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_previous_value_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = bb.NOT_SET
        self._previous_value_value = bb.NOT_SET
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    # Instance attribute type: AccountCaptureAvailability (validator is set below)
    new_value = bb.Attribute("new_value", user_defined=True)

    # Instance attribute type: AccountCaptureAvailability (validator is set below)
    previous_value = bb.Attribute("previous_value", nullable=True, user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AccountCaptureChangeAvailabilityDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

AccountCaptureChangeAvailabilityDetails_validator = bv.Struct(AccountCaptureChangeAvailabilityDetails)

class AccountCaptureChangeAvailabilityType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AccountCaptureChangeAvailabilityType, self)._process_custom_annotations(annotation_type, field_path, processor)

AccountCaptureChangeAvailabilityType_validator = bv.Struct(AccountCaptureChangeAvailabilityType)

class AccountCaptureChangePolicyDetails(bb.Struct):
    """
    Changed account capture setting on team domain.

    :ivar team_log.AccountCaptureChangePolicyDetails.new_value: New account
        capture policy.
    :ivar team_log.AccountCaptureChangePolicyDetails.previous_value: Previous
        account capture policy. Might be missing due to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_previous_value_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = bb.NOT_SET
        self._previous_value_value = bb.NOT_SET
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    # Instance attribute type: AccountCapturePolicy (validator is set below)
    new_value = bb.Attribute("new_value", user_defined=True)

    # Instance attribute type: AccountCapturePolicy (validator is set below)
    previous_value = bb.Attribute("previous_value", nullable=True, user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AccountCaptureChangePolicyDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

AccountCaptureChangePolicyDetails_validator = bv.Struct(AccountCaptureChangePolicyDetails)

class AccountCaptureChangePolicyType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AccountCaptureChangePolicyType, self)._process_custom_annotations(annotation_type, field_path, processor)

AccountCaptureChangePolicyType_validator = bv.Struct(AccountCaptureChangePolicyType)

class AccountCaptureMigrateAccountDetails(bb.Struct):
    """
    Account-captured user migrated account to team.

    :ivar team_log.AccountCaptureMigrateAccountDetails.domain_name: Domain name.
    """

    __slots__ = [
        '_domain_name_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 domain_name=None):
        self._domain_name_value = bb.NOT_SET
        if domain_name is not None:
            self.domain_name = domain_name

    # Instance attribute type: str (validator is set below)
    domain_name = bb.Attribute("domain_name")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AccountCaptureMigrateAccountDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

AccountCaptureMigrateAccountDetails_validator = bv.Struct(AccountCaptureMigrateAccountDetails)

class AccountCaptureMigrateAccountType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AccountCaptureMigrateAccountType, self)._process_custom_annotations(annotation_type, field_path, processor)

AccountCaptureMigrateAccountType_validator = bv.Struct(AccountCaptureMigrateAccountType)

class AccountCaptureNotificationEmailsSentDetails(bb.Struct):
    """
    Sent account capture email to all unmanaged members.

    :ivar team_log.AccountCaptureNotificationEmailsSentDetails.domain_name:
        Domain name.
    :ivar
        team_log.AccountCaptureNotificationEmailsSentDetails.notification_type:
        Account-capture email notification type.
    """

    __slots__ = [
        '_domain_name_value',
        '_notification_type_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 domain_name=None,
                 notification_type=None):
        self._domain_name_value = bb.NOT_SET
        self._notification_type_value = bb.NOT_SET
        if domain_name is not None:
            self.domain_name = domain_name
        if notification_type is not None:
            self.notification_type = notification_type

    # Instance attribute type: str (validator is set below)
    domain_name = bb.Attribute("domain_name")

    # Instance attribute type: AccountCaptureNotificationType (validator is set below)
    notification_type = bb.Attribute("notification_type", nullable=True, user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AccountCaptureNotificationEmailsSentDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

AccountCaptureNotificationEmailsSentDetails_validator = bv.Struct(AccountCaptureNotificationEmailsSentDetails)

class AccountCaptureNotificationEmailsSentType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AccountCaptureNotificationEmailsSentType, self)._process_custom_annotations(annotation_type, field_path, processor)

AccountCaptureNotificationEmailsSentType_validator = bv.Struct(AccountCaptureNotificationEmailsSentType)

class AccountCaptureNotificationType(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    actionable_notification = None
    # Attribute is overwritten below the class definition
    proactive_warning_notification = None
    # Attribute is overwritten below the class definition
    other = None

    def is_actionable_notification(self):
        """
        Check if the union tag is ``actionable_notification``.

        :rtype: bool
        """
        return self._tag == 'actionable_notification'

    def is_proactive_warning_notification(self):
        """
        Check if the union tag is ``proactive_warning_notification``.

        :rtype: bool
        """
        return self._tag == 'proactive_warning_notification'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AccountCaptureNotificationType, self)._process_custom_annotations(annotation_type, field_path, processor)

AccountCaptureNotificationType_validator = bv.Union(AccountCaptureNotificationType)

class AccountCapturePolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    all_users = None
    # Attribute is overwritten below the class definition
    disabled = None
    # Attribute is overwritten below the class definition
    invited_users = None
    # Attribute is overwritten below the class definition
    other = None

    def is_all_users(self):
        """
        Check if the union tag is ``all_users``.

        :rtype: bool
        """
        return self._tag == 'all_users'

    def is_disabled(self):
        """
        Check if the union tag is ``disabled``.

        :rtype: bool
        """
        return self._tag == 'disabled'

    def is_invited_users(self):
        """
        Check if the union tag is ``invited_users``.

        :rtype: bool
        """
        return self._tag == 'invited_users'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AccountCapturePolicy, self)._process_custom_annotations(annotation_type, field_path, processor)

AccountCapturePolicy_validator = bv.Union(AccountCapturePolicy)

class AccountCaptureRelinquishAccountDetails(bb.Struct):
    """
    Account-captured user changed account email to personal email.

    :ivar team_log.AccountCaptureRelinquishAccountDetails.domain_name: Domain
        name.
    """

    __slots__ = [
        '_domain_name_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 domain_name=None):
        self._domain_name_value = bb.NOT_SET
        if domain_name is not None:
            self.domain_name = domain_name

    # Instance attribute type: str (validator is set below)
    domain_name = bb.Attribute("domain_name")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AccountCaptureRelinquishAccountDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

AccountCaptureRelinquishAccountDetails_validator = bv.Struct(AccountCaptureRelinquishAccountDetails)

class AccountCaptureRelinquishAccountType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AccountCaptureRelinquishAccountType, self)._process_custom_annotations(annotation_type, field_path, processor)

AccountCaptureRelinquishAccountType_validator = bv.Struct(AccountCaptureRelinquishAccountType)

class AccountLockOrUnlockedDetails(bb.Struct):
    """
    Unlocked/locked account after failed sign in attempts.

    :ivar team_log.AccountLockOrUnlockedDetails.previous_value: The previous
        account status.
    :ivar team_log.AccountLockOrUnlockedDetails.new_value: The new account
        status.
    """

    __slots__ = [
        '_previous_value_value',
        '_new_value_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 previous_value=None,
                 new_value=None):
        self._previous_value_value = bb.NOT_SET
        self._new_value_value = bb.NOT_SET
        if previous_value is not None:
            self.previous_value = previous_value
        if new_value is not None:
            self.new_value = new_value

    # Instance attribute type: AccountState (validator is set below)
    previous_value = bb.Attribute("previous_value", user_defined=True)

    # Instance attribute type: AccountState (validator is set below)
    new_value = bb.Attribute("new_value", user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AccountLockOrUnlockedDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

AccountLockOrUnlockedDetails_validator = bv.Struct(AccountLockOrUnlockedDetails)

class AccountLockOrUnlockedType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AccountLockOrUnlockedType, self)._process_custom_annotations(annotation_type, field_path, processor)

AccountLockOrUnlockedType_validator = bv.Struct(AccountLockOrUnlockedType)

class AccountState(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    locked = None
    # Attribute is overwritten below the class definition
    unlocked = None
    # Attribute is overwritten below the class definition
    other = None

    def is_locked(self):
        """
        Check if the union tag is ``locked``.

        :rtype: bool
        """
        return self._tag == 'locked'

    def is_unlocked(self):
        """
        Check if the union tag is ``unlocked``.

        :rtype: bool
        """
        return self._tag == 'unlocked'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AccountState, self)._process_custom_annotations(annotation_type, field_path, processor)

AccountState_validator = bv.Union(AccountState)

class ActionDetails(bb.Union):
    """
    Additional information indicating the action taken that caused status
    change.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar MemberRemoveActionType ActionDetails.remove_action: Define how the
        user was removed from the team.
    :ivar TeamInviteDetails ActionDetails.team_invite_details: Additional
        information relevant when someone is invited to the team.
    :ivar JoinTeamDetails ActionDetails.team_join_details: Additional
        information relevant when a new member joins the team.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def remove_action(cls, val):
        """
        Create an instance of this class set to the ``remove_action`` tag with
        value ``val``.

        :param MemberRemoveActionType val:
        :rtype: ActionDetails
        """
        return cls('remove_action', val)

    @classmethod
    def team_invite_details(cls, val):
        """
        Create an instance of this class set to the ``team_invite_details`` tag
        with value ``val``.

        :param TeamInviteDetails val:
        :rtype: ActionDetails
        """
        return cls('team_invite_details', val)

    @classmethod
    def team_join_details(cls, val):
        """
        Create an instance of this class set to the ``team_join_details`` tag
        with value ``val``.

        :param JoinTeamDetails val:
        :rtype: ActionDetails
        """
        return cls('team_join_details', val)

    def is_remove_action(self):
        """
        Check if the union tag is ``remove_action``.

        :rtype: bool
        """
        return self._tag == 'remove_action'

    def is_team_invite_details(self):
        """
        Check if the union tag is ``team_invite_details``.

        :rtype: bool
        """
        return self._tag == 'team_invite_details'

    def is_team_join_details(self):
        """
        Check if the union tag is ``team_join_details``.

        :rtype: bool
        """
        return self._tag == 'team_join_details'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_remove_action(self):
        """
        Define how the user was removed from the team.

        Only call this if :meth:`is_remove_action` is true.

        :rtype: MemberRemoveActionType
        """
        if not self.is_remove_action():
            raise AttributeError("tag 'remove_action' not set")
        return self._value

    def get_team_invite_details(self):
        """
        Additional information relevant when someone is invited to the team.

        Only call this if :meth:`is_team_invite_details` is true.

        :rtype: TeamInviteDetails
        """
        if not self.is_team_invite_details():
            raise AttributeError("tag 'team_invite_details' not set")
        return self._value

    def get_team_join_details(self):
        """
        Additional information relevant when a new member joins the team.

        Only call this if :meth:`is_team_join_details` is true.

        :rtype: JoinTeamDetails
        """
        if not self.is_team_join_details():
            raise AttributeError("tag 'team_join_details' not set")
        return self._value

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ActionDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

ActionDetails_validator = bv.Union(ActionDetails)

class ActorLogInfo(bb.Union):
    """
    The entity who performed the action.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar UserLogInfo ActorLogInfo.admin: The admin who did the action.
    :ivar team_log.ActorLogInfo.anonymous: Anonymous actor.
    :ivar AppLogInfo ActorLogInfo.app: The application who did the action.
    :ivar team_log.ActorLogInfo.dropbox: Action done by Dropbox.
    :ivar ResellerLogInfo ActorLogInfo.reseller: Action done by reseller.
    :ivar UserLogInfo ActorLogInfo.user: The user who did the action.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    anonymous = None
    # Attribute is overwritten below the class definition
    dropbox = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def admin(cls, val):
        """
        Create an instance of this class set to the ``admin`` tag with value
        ``val``.

        :param UserLogInfo val:
        :rtype: ActorLogInfo
        """
        return cls('admin', val)

    @classmethod
    def app(cls, val):
        """
        Create an instance of this class set to the ``app`` tag with value
        ``val``.

        :param AppLogInfo val:
        :rtype: ActorLogInfo
        """
        return cls('app', val)

    @classmethod
    def reseller(cls, val):
        """
        Create an instance of this class set to the ``reseller`` tag with value
        ``val``.

        :param ResellerLogInfo val:
        :rtype: ActorLogInfo
        """
        return cls('reseller', val)

    @classmethod
    def user(cls, val):
        """
        Create an instance of this class set to the ``user`` tag with value
        ``val``.

        :param UserLogInfo val:
        :rtype: ActorLogInfo
        """
        return cls('user', val)

    def is_admin(self):
        """
        Check if the union tag is ``admin``.

        :rtype: bool
        """
        return self._tag == 'admin'

    def is_anonymous(self):
        """
        Check if the union tag is ``anonymous``.

        :rtype: bool
        """
        return self._tag == 'anonymous'

    def is_app(self):
        """
        Check if the union tag is ``app``.

        :rtype: bool
        """
        return self._tag == 'app'

    def is_dropbox(self):
        """
        Check if the union tag is ``dropbox``.

        :rtype: bool
        """
        return self._tag == 'dropbox'

    def is_reseller(self):
        """
        Check if the union tag is ``reseller``.

        :rtype: bool
        """
        return self._tag == 'reseller'

    def is_user(self):
        """
        Check if the union tag is ``user``.

        :rtype: bool
        """
        return self._tag == 'user'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_admin(self):
        """
        The admin who did the action.

        Only call this if :meth:`is_admin` is true.

        :rtype: UserLogInfo
        """
        if not self.is_admin():
            raise AttributeError("tag 'admin' not set")
        return self._value

    def get_app(self):
        """
        The application who did the action.

        Only call this if :meth:`is_app` is true.

        :rtype: AppLogInfo
        """
        if not self.is_app():
            raise AttributeError("tag 'app' not set")
        return self._value

    def get_reseller(self):
        """
        Action done by reseller.

        Only call this if :meth:`is_reseller` is true.

        :rtype: ResellerLogInfo
        """
        if not self.is_reseller():
            raise AttributeError("tag 'reseller' not set")
        return self._value

    def get_user(self):
        """
        The user who did the action.

        Only call this if :meth:`is_user` is true.

        :rtype: UserLogInfo
        """
        if not self.is_user():
            raise AttributeError("tag 'user' not set")
        return self._value

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ActorLogInfo, self)._process_custom_annotations(annotation_type, field_path, processor)

ActorLogInfo_validator = bv.Union(ActorLogInfo)

class AdminAlertCategoryEnum(bb.Union):
    """
    Alert category

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    account_takeover = None
    # Attribute is overwritten below the class definition
    data_loss_protection = None
    # Attribute is overwritten below the class definition
    information_governance = None
    # Attribute is overwritten below the class definition
    malware_sharing = None
    # Attribute is overwritten below the class definition
    massive_file_operation = None
    # Attribute is overwritten below the class definition
    na = None
    # Attribute is overwritten below the class definition
    threat_management = None
    # Attribute is overwritten below the class definition
    other = None

    def is_account_takeover(self):
        """
        Check if the union tag is ``account_takeover``.

        :rtype: bool
        """
        return self._tag == 'account_takeover'

    def is_data_loss_protection(self):
        """
        Check if the union tag is ``data_loss_protection``.

        :rtype: bool
        """
        return self._tag == 'data_loss_protection'

    def is_information_governance(self):
        """
        Check if the union tag is ``information_governance``.

        :rtype: bool
        """
        return self._tag == 'information_governance'

    def is_malware_sharing(self):
        """
        Check if the union tag is ``malware_sharing``.

        :rtype: bool
        """
        return self._tag == 'malware_sharing'

    def is_massive_file_operation(self):
        """
        Check if the union tag is ``massive_file_operation``.

        :rtype: bool
        """
        return self._tag == 'massive_file_operation'

    def is_na(self):
        """
        Check if the union tag is ``na``.

        :rtype: bool
        """
        return self._tag == 'na'

    def is_threat_management(self):
        """
        Check if the union tag is ``threat_management``.

        :rtype: bool
        """
        return self._tag == 'threat_management'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AdminAlertCategoryEnum, self)._process_custom_annotations(annotation_type, field_path, processor)

AdminAlertCategoryEnum_validator = bv.Union(AdminAlertCategoryEnum)

class AdminAlertGeneralStateEnum(bb.Union):
    """
    Alert state

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    active = None
    # Attribute is overwritten below the class definition
    dismissed = None
    # Attribute is overwritten below the class definition
    in_progress = None
    # Attribute is overwritten below the class definition
    na = None
    # Attribute is overwritten below the class definition
    resolved = None
    # Attribute is overwritten below the class definition
    other = None

    def is_active(self):
        """
        Check if the union tag is ``active``.

        :rtype: bool
        """
        return self._tag == 'active'

    def is_dismissed(self):
        """
        Check if the union tag is ``dismissed``.

        :rtype: bool
        """
        return self._tag == 'dismissed'

    def is_in_progress(self):
        """
        Check if the union tag is ``in_progress``.

        :rtype: bool
        """
        return self._tag == 'in_progress'

    def is_na(self):
        """
        Check if the union tag is ``na``.

        :rtype: bool
        """
        return self._tag == 'na'

    def is_resolved(self):
        """
        Check if the union tag is ``resolved``.

        :rtype: bool
        """
        return self._tag == 'resolved'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AdminAlertGeneralStateEnum, self)._process_custom_annotations(annotation_type, field_path, processor)

AdminAlertGeneralStateEnum_validator = bv.Union(AdminAlertGeneralStateEnum)

class AdminAlertSeverityEnum(bb.Union):
    """
    Alert severity

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    high = None
    # Attribute is overwritten below the class definition
    info = None
    # Attribute is overwritten below the class definition
    low = None
    # Attribute is overwritten below the class definition
    medium = None
    # Attribute is overwritten below the class definition
    na = None
    # Attribute is overwritten below the class definition
    other = None

    def is_high(self):
        """
        Check if the union tag is ``high``.

        :rtype: bool
        """
        return self._tag == 'high'

    def is_info(self):
        """
        Check if the union tag is ``info``.

        :rtype: bool
        """
        return self._tag == 'info'

    def is_low(self):
        """
        Check if the union tag is ``low``.

        :rtype: bool
        """
        return self._tag == 'low'

    def is_medium(self):
        """
        Check if the union tag is ``medium``.

        :rtype: bool
        """
        return self._tag == 'medium'

    def is_na(self):
        """
        Check if the union tag is ``na``.

        :rtype: bool
        """
        return self._tag == 'na'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AdminAlertSeverityEnum, self)._process_custom_annotations(annotation_type, field_path, processor)

AdminAlertSeverityEnum_validator = bv.Union(AdminAlertSeverityEnum)

class AdminAlertingAlertConfiguration(bb.Struct):
    """
    Alert configurations

    :ivar team_log.AdminAlertingAlertConfiguration.alert_state: Alert state.
    :ivar team_log.AdminAlertingAlertConfiguration.sensitivity_level:
        Sensitivity level.
    :ivar team_log.AdminAlertingAlertConfiguration.recipients_settings:
        Recipient settings.
    """

    __slots__ = [
        '_alert_state_value',
        '_sensitivity_level_value',
        '_recipients_settings_value',
    ]

    _has_required_fields = False

    def __init__(self,
                 alert_state=None,
                 sensitivity_level=None,
                 recipients_settings=None):
        self._alert_state_value = bb.NOT_SET
        self._sensitivity_level_value = bb.NOT_SET
        self._recipients_settings_value = bb.NOT_SET
        if alert_state is not None:
            self.alert_state = alert_state
        if sensitivity_level is not None:
            self.sensitivity_level = sensitivity_level
        if recipients_settings is not None:
            self.recipients_settings = recipients_settings

    # Instance attribute type: AdminAlertingAlertStatePolicy (validator is set below)
    alert_state = bb.Attribute("alert_state", nullable=True, user_defined=True)

    # Instance attribute type: AdminAlertingAlertSensitivity (validator is set below)
    sensitivity_level = bb.Attribute("sensitivity_level", nullable=True, user_defined=True)

    # Instance attribute type: RecipientsConfiguration (validator is set below)
    recipients_settings = bb.Attribute("recipients_settings", nullable=True, user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AdminAlertingAlertConfiguration, self)._process_custom_annotations(annotation_type, field_path, processor)

AdminAlertingAlertConfiguration_validator = bv.Struct(AdminAlertingAlertConfiguration)

class AdminAlertingAlertSensitivity(bb.Union):
    """
    Alert sensitivity

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    high = None
    # Attribute is overwritten below the class definition
    highest = None
    # Attribute is overwritten below the class definition
    invalid = None
    # Attribute is overwritten below the class definition
    low = None
    # Attribute is overwritten below the class definition
    lowest = None
    # Attribute is overwritten below the class definition
    medium = None
    # Attribute is overwritten below the class definition
    other = None

    def is_high(self):
        """
        Check if the union tag is ``high``.

        :rtype: bool
        """
        return self._tag == 'high'

    def is_highest(self):
        """
        Check if the union tag is ``highest``.

        :rtype: bool
        """
        return self._tag == 'highest'

    def is_invalid(self):
        """
        Check if the union tag is ``invalid``.

        :rtype: bool
        """
        return self._tag == 'invalid'

    def is_low(self):
        """
        Check if the union tag is ``low``.

        :rtype: bool
        """
        return self._tag == 'low'

    def is_lowest(self):
        """
        Check if the union tag is ``lowest``.

        :rtype: bool
        """
        return self._tag == 'lowest'

    def is_medium(self):
        """
        Check if the union tag is ``medium``.

        :rtype: bool
        """
        return self._tag == 'medium'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AdminAlertingAlertSensitivity, self)._process_custom_annotations(annotation_type, field_path, processor)

AdminAlertingAlertSensitivity_validator = bv.Union(AdminAlertingAlertSensitivity)

class AdminAlertingAlertStateChangedDetails(bb.Struct):
    """
    Changed an alert state.

    :ivar team_log.AdminAlertingAlertStateChangedDetails.alert_name: Alert name.
    :ivar team_log.AdminAlertingAlertStateChangedDetails.alert_severity: Alert
        severity.
    :ivar team_log.AdminAlertingAlertStateChangedDetails.alert_category: Alert
        category.
    :ivar team_log.AdminAlertingAlertStateChangedDetails.alert_instance_id:
        Alert ID.
    :ivar team_log.AdminAlertingAlertStateChangedDetails.previous_value: Alert
        state before the change.
    :ivar team_log.AdminAlertingAlertStateChangedDetails.new_value: Alert state
        after the change.
    """

    __slots__ = [
        '_alert_name_value',
        '_alert_severity_value',
        '_alert_category_value',
        '_alert_instance_id_value',
        '_previous_value_value',
        '_new_value_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 alert_name=None,
                 alert_severity=None,
                 alert_category=None,
                 alert_instance_id=None,
                 previous_value=None,
                 new_value=None):
        self._alert_name_value = bb.NOT_SET
        self._alert_severity_value = bb.NOT_SET
        self._alert_category_value = bb.NOT_SET
        self._alert_instance_id_value = bb.NOT_SET
        self._previous_value_value = bb.NOT_SET
        self._new_value_value = bb.NOT_SET
        if alert_name is not None:
            self.alert_name = alert_name
        if alert_severity is not None:
            self.alert_severity = alert_severity
        if alert_category is not None:
            self.alert_category = alert_category
        if alert_instance_id is not None:
            self.alert_instance_id = alert_instance_id
        if previous_value is not None:
            self.previous_value = previous_value
        if new_value is not None:
            self.new_value = new_value

    # Instance attribute type: str (validator is set below)
    alert_name = bb.Attribute("alert_name")

    # Instance attribute type: AdminAlertSeverityEnum (validator is set below)
    alert_severity = bb.Attribute("alert_severity", user_defined=True)

    # Instance attribute type: AdminAlertCategoryEnum (validator is set below)
    alert_category = bb.Attribute("alert_category", user_defined=True)

    # Instance attribute type: str (validator is set below)
    alert_instance_id = bb.Attribute("alert_instance_id")

    # Instance attribute type: AdminAlertGeneralStateEnum (validator is set below)
    previous_value = bb.Attribute("previous_value", user_defined=True)

    # Instance attribute type: AdminAlertGeneralStateEnum (validator is set below)
    new_value = bb.Attribute("new_value", user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AdminAlertingAlertStateChangedDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

AdminAlertingAlertStateChangedDetails_validator = bv.Struct(AdminAlertingAlertStateChangedDetails)

class AdminAlertingAlertStateChangedType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AdminAlertingAlertStateChangedType, self)._process_custom_annotations(annotation_type, field_path, processor)

AdminAlertingAlertStateChangedType_validator = bv.Struct(AdminAlertingAlertStateChangedType)

class AdminAlertingAlertStatePolicy(bb.Union):
    """
    Policy for controlling whether an alert can be triggered or not

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    off = None
    # Attribute is overwritten below the class definition
    on = None
    # Attribute is overwritten below the class definition
    other = None

    def is_off(self):
        """
        Check if the union tag is ``off``.

        :rtype: bool
        """
        return self._tag == 'off'

    def is_on(self):
        """
        Check if the union tag is ``on``.

        :rtype: bool
        """
        return self._tag == 'on'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AdminAlertingAlertStatePolicy, self)._process_custom_annotations(annotation_type, field_path, processor)

AdminAlertingAlertStatePolicy_validator = bv.Union(AdminAlertingAlertStatePolicy)

class AdminAlertingChangedAlertConfigDetails(bb.Struct):
    """
    Changed an alert setting.

    :ivar team_log.AdminAlertingChangedAlertConfigDetails.alert_name: Alert
        Name.
    :ivar team_log.AdminAlertingChangedAlertConfigDetails.previous_alert_config:
        Previous alert configuration.
    :ivar team_log.AdminAlertingChangedAlertConfigDetails.new_alert_config: New
        alert configuration.
    """

    __slots__ = [
        '_alert_name_value',
        '_previous_alert_config_value',
        '_new_alert_config_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 alert_name=None,
                 previous_alert_config=None,
                 new_alert_config=None):
        self._alert_name_value = bb.NOT_SET
        self._previous_alert_config_value = bb.NOT_SET
        self._new_alert_config_value = bb.NOT_SET
        if alert_name is not None:
            self.alert_name = alert_name
        if previous_alert_config is not None:
            self.previous_alert_config = previous_alert_config
        if new_alert_config is not None:
            self.new_alert_config = new_alert_config

    # Instance attribute type: str (validator is set below)
    alert_name = bb.Attribute("alert_name")

    # Instance attribute type: AdminAlertingAlertConfiguration (validator is set below)
    previous_alert_config = bb.Attribute("previous_alert_config", user_defined=True)

    # Instance attribute type: AdminAlertingAlertConfiguration (validator is set below)
    new_alert_config = bb.Attribute("new_alert_config", user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AdminAlertingChangedAlertConfigDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

AdminAlertingChangedAlertConfigDetails_validator = bv.Struct(AdminAlertingChangedAlertConfigDetails)

class AdminAlertingChangedAlertConfigType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AdminAlertingChangedAlertConfigType, self)._process_custom_annotations(annotation_type, field_path, processor)

AdminAlertingChangedAlertConfigType_validator = bv.Struct(AdminAlertingChangedAlertConfigType)

class AdminAlertingTriggeredAlertDetails(bb.Struct):
    """
    Triggered security alert.

    :ivar team_log.AdminAlertingTriggeredAlertDetails.alert_name: Alert name.
    :ivar team_log.AdminAlertingTriggeredAlertDetails.alert_severity: Alert
        severity.
    :ivar team_log.AdminAlertingTriggeredAlertDetails.alert_category: Alert
        category.
    :ivar team_log.AdminAlertingTriggeredAlertDetails.alert_instance_id: Alert
        ID.
    """

    __slots__ = [
        '_alert_name_value',
        '_alert_severity_value',
        '_alert_category_value',
        '_alert_instance_id_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 alert_name=None,
                 alert_severity=None,
                 alert_category=None,
                 alert_instance_id=None):
        self._alert_name_value = bb.NOT_SET
        self._alert_severity_value = bb.NOT_SET
        self._alert_category_value = bb.NOT_SET
        self._alert_instance_id_value = bb.NOT_SET
        if alert_name is not None:
            self.alert_name = alert_name
        if alert_severity is not None:
            self.alert_severity = alert_severity
        if alert_category is not None:
            self.alert_category = alert_category
        if alert_instance_id is not None:
            self.alert_instance_id = alert_instance_id

    # Instance attribute type: str (validator is set below)
    alert_name = bb.Attribute("alert_name")

    # Instance attribute type: AdminAlertSeverityEnum (validator is set below)
    alert_severity = bb.Attribute("alert_severity", user_defined=True)

    # Instance attribute type: AdminAlertCategoryEnum (validator is set below)
    alert_category = bb.Attribute("alert_category", user_defined=True)

    # Instance attribute type: str (validator is set below)
    alert_instance_id = bb.Attribute("alert_instance_id")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AdminAlertingTriggeredAlertDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

AdminAlertingTriggeredAlertDetails_validator = bv.Struct(AdminAlertingTriggeredAlertDetails)

class AdminAlertingTriggeredAlertType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AdminAlertingTriggeredAlertType, self)._process_custom_annotations(annotation_type, field_path, processor)

AdminAlertingTriggeredAlertType_validator = bv.Struct(AdminAlertingTriggeredAlertType)

class AdminConsoleAppPermission(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    default_for_listed_apps = None
    # Attribute is overwritten below the class definition
    default_for_unlisted_apps = None
    # Attribute is overwritten below the class definition
    other = None

    def is_default_for_listed_apps(self):
        """
        Check if the union tag is ``default_for_listed_apps``.

        :rtype: bool
        """
        return self._tag == 'default_for_listed_apps'

    def is_default_for_unlisted_apps(self):
        """
        Check if the union tag is ``default_for_unlisted_apps``.

        :rtype: bool
        """
        return self._tag == 'default_for_unlisted_apps'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AdminConsoleAppPermission, self)._process_custom_annotations(annotation_type, field_path, processor)

AdminConsoleAppPermission_validator = bv.Union(AdminConsoleAppPermission)

class AdminConsoleAppPolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    allow = None
    # Attribute is overwritten below the class definition
    block = None
    # Attribute is overwritten below the class definition
    default = None
    # Attribute is overwritten below the class definition
    other = None

    def is_allow(self):
        """
        Check if the union tag is ``allow``.

        :rtype: bool
        """
        return self._tag == 'allow'

    def is_block(self):
        """
        Check if the union tag is ``block``.

        :rtype: bool
        """
        return self._tag == 'block'

    def is_default(self):
        """
        Check if the union tag is ``default``.

        :rtype: bool
        """
        return self._tag == 'default'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AdminConsoleAppPolicy, self)._process_custom_annotations(annotation_type, field_path, processor)

AdminConsoleAppPolicy_validator = bv.Union(AdminConsoleAppPolicy)

class AdminRole(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    billing_admin = None
    # Attribute is overwritten below the class definition
    compliance_admin = None
    # Attribute is overwritten below the class definition
    content_admin = None
    # Attribute is overwritten below the class definition
    limited_admin = None
    # Attribute is overwritten below the class definition
    member_only = None
    # Attribute is overwritten below the class definition
    reporting_admin = None
    # Attribute is overwritten below the class definition
    security_admin = None
    # Attribute is overwritten below the class definition
    support_admin = None
    # Attribute is overwritten below the class definition
    team_admin = None
    # Attribute is overwritten below the class definition
    user_management_admin = None
    # Attribute is overwritten below the class definition
    other = None

    def is_billing_admin(self):
        """
        Check if the union tag is ``billing_admin``.

        :rtype: bool
        """
        return self._tag == 'billing_admin'

    def is_compliance_admin(self):
        """
        Check if the union tag is ``compliance_admin``.

        :rtype: bool
        """
        return self._tag == 'compliance_admin'

    def is_content_admin(self):
        """
        Check if the union tag is ``content_admin``.

        :rtype: bool
        """
        return self._tag == 'content_admin'

    def is_limited_admin(self):
        """
        Check if the union tag is ``limited_admin``.

        :rtype: bool
        """
        return self._tag == 'limited_admin'

    def is_member_only(self):
        """
        Check if the union tag is ``member_only``.

        :rtype: bool
        """
        return self._tag == 'member_only'

    def is_reporting_admin(self):
        """
        Check if the union tag is ``reporting_admin``.

        :rtype: bool
        """
        return self._tag == 'reporting_admin'

    def is_security_admin(self):
        """
        Check if the union tag is ``security_admin``.

        :rtype: bool
        """
        return self._tag == 'security_admin'

    def is_support_admin(self):
        """
        Check if the union tag is ``support_admin``.

        :rtype: bool
        """
        return self._tag == 'support_admin'

    def is_team_admin(self):
        """
        Check if the union tag is ``team_admin``.

        :rtype: bool
        """
        return self._tag == 'team_admin'

    def is_user_management_admin(self):
        """
        Check if the union tag is ``user_management_admin``.

        :rtype: bool
        """
        return self._tag == 'user_management_admin'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AdminRole, self)._process_custom_annotations(annotation_type, field_path, processor)

AdminRole_validator = bv.Union(AdminRole)

class AlertRecipientsSettingType(bb.Union):
    """
    Alert recipients setting type

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    custom_list = None
    # Attribute is overwritten below the class definition
    invalid = None
    # Attribute is overwritten below the class definition
    none = None
    # Attribute is overwritten below the class definition
    team_admins = None
    # Attribute is overwritten below the class definition
    other = None

    def is_custom_list(self):
        """
        Check if the union tag is ``custom_list``.

        :rtype: bool
        """
        return self._tag == 'custom_list'

    def is_invalid(self):
        """
        Check if the union tag is ``invalid``.

        :rtype: bool
        """
        return self._tag == 'invalid'

    def is_none(self):
        """
        Check if the union tag is ``none``.

        :rtype: bool
        """
        return self._tag == 'none'

    def is_team_admins(self):
        """
        Check if the union tag is ``team_admins``.

        :rtype: bool
        """
        return self._tag == 'team_admins'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AlertRecipientsSettingType, self)._process_custom_annotations(annotation_type, field_path, processor)

AlertRecipientsSettingType_validator = bv.Union(AlertRecipientsSettingType)

class AllowDownloadDisabledDetails(bb.Struct):
    """
    Disabled downloads.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AllowDownloadDisabledDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

AllowDownloadDisabledDetails_validator = bv.Struct(AllowDownloadDisabledDetails)

class AllowDownloadDisabledType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AllowDownloadDisabledType, self)._process_custom_annotations(annotation_type, field_path, processor)

AllowDownloadDisabledType_validator = bv.Struct(AllowDownloadDisabledType)

class AllowDownloadEnabledDetails(bb.Struct):
    """
    Enabled downloads.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AllowDownloadEnabledDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

AllowDownloadEnabledDetails_validator = bv.Struct(AllowDownloadEnabledDetails)

class AllowDownloadEnabledType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AllowDownloadEnabledType, self)._process_custom_annotations(annotation_type, field_path, processor)

AllowDownloadEnabledType_validator = bv.Struct(AllowDownloadEnabledType)

class ApiSessionLogInfo(bb.Struct):
    """
    Api session.

    :ivar team_log.ApiSessionLogInfo.request_id: Api request ID.
    """

    __slots__ = [
        '_request_id_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 request_id=None):
        self._request_id_value = bb.NOT_SET
        if request_id is not None:
            self.request_id = request_id

    # Instance attribute type: str (validator is set below)
    request_id = bb.Attribute("request_id")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ApiSessionLogInfo, self)._process_custom_annotations(annotation_type, field_path, processor)

ApiSessionLogInfo_validator = bv.Struct(ApiSessionLogInfo)

class AppBlockedByPermissionsDetails(bb.Struct):
    """
    Failed to connect app for member.

    :ivar team_log.AppBlockedByPermissionsDetails.app_info: Relevant application
        details.
    """

    __slots__ = [
        '_app_info_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 app_info=None):
        self._app_info_value = bb.NOT_SET
        if app_info is not None:
            self.app_info = app_info

    # Instance attribute type: AppLogInfo (validator is set below)
    app_info = bb.Attribute("app_info", user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AppBlockedByPermissionsDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

AppBlockedByPermissionsDetails_validator = bv.Struct(AppBlockedByPermissionsDetails)

class AppBlockedByPermissionsType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AppBlockedByPermissionsType, self)._process_custom_annotations(annotation_type, field_path, processor)

AppBlockedByPermissionsType_validator = bv.Struct(AppBlockedByPermissionsType)

class AppLinkTeamDetails(bb.Struct):
    """
    Linked app for team.

    :ivar team_log.AppLinkTeamDetails.app_info: Relevant application details.
    """

    __slots__ = [
        '_app_info_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 app_info=None):
        self._app_info_value = bb.NOT_SET
        if app_info is not None:
            self.app_info = app_info

    # Instance attribute type: AppLogInfo (validator is set below)
    app_info = bb.Attribute("app_info", user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AppLinkTeamDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

AppLinkTeamDetails_validator = bv.Struct(AppLinkTeamDetails)

class AppLinkTeamType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AppLinkTeamType, self)._process_custom_annotations(annotation_type, field_path, processor)

AppLinkTeamType_validator = bv.Struct(AppLinkTeamType)

class AppLinkUserDetails(bb.Struct):
    """
    Linked app for member.

    :ivar team_log.AppLinkUserDetails.app_info: Relevant application details.
    """

    __slots__ = [
        '_app_info_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 app_info=None):
        self._app_info_value = bb.NOT_SET
        if app_info is not None:
            self.app_info = app_info

    # Instance attribute type: AppLogInfo (validator is set below)
    app_info = bb.Attribute("app_info", user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AppLinkUserDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

AppLinkUserDetails_validator = bv.Struct(AppLinkUserDetails)

class AppLinkUserType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AppLinkUserType, self)._process_custom_annotations(annotation_type, field_path, processor)

AppLinkUserType_validator = bv.Struct(AppLinkUserType)

class AppLogInfo(bb.Struct):
    """
    App's logged information.

    :ivar team_log.AppLogInfo.app_id: App unique ID.
    :ivar team_log.AppLogInfo.display_name: App display name.
    """

    __slots__ = [
        '_app_id_value',
        '_display_name_value',
    ]

    _has_required_fields = False

    def __init__(self,
                 app_id=None,
                 display_name=None):
        self._app_id_value = bb.NOT_SET
        self._display_name_value = bb.NOT_SET
        if app_id is not None:
            self.app_id = app_id
        if display_name is not None:
            self.display_name = display_name

    # Instance attribute type: str (validator is set below)
    app_id = bb.Attribute("app_id", nullable=True)

    # Instance attribute type: str (validator is set below)
    display_name = bb.Attribute("display_name", nullable=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AppLogInfo, self)._process_custom_annotations(annotation_type, field_path, processor)

AppLogInfo_validator = bv.StructTree(AppLogInfo)

class AppPermissionsChangedDetails(bb.Struct):
    """
    Changed app permissions.

    :ivar team_log.AppPermissionsChangedDetails.app_name: Name of the app.
    :ivar team_log.AppPermissionsChangedDetails.permission: Permission that was
        changed.
    :ivar team_log.AppPermissionsChangedDetails.previous_value: Previous policy.
    :ivar team_log.AppPermissionsChangedDetails.new_value: New policy.
    """

    __slots__ = [
        '_app_name_value',
        '_permission_value',
        '_previous_value_value',
        '_new_value_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 previous_value=None,
                 new_value=None,
                 app_name=None,
                 permission=None):
        self._app_name_value = bb.NOT_SET
        self._permission_value = bb.NOT_SET
        self._previous_value_value = bb.NOT_SET
        self._new_value_value = bb.NOT_SET
        if app_name is not None:
            self.app_name = app_name
        if permission is not None:
            self.permission = permission
        if previous_value is not None:
            self.previous_value = previous_value
        if new_value is not None:
            self.new_value = new_value

    # Instance attribute type: str (validator is set below)
    app_name = bb.Attribute("app_name", nullable=True)

    # Instance attribute type: AdminConsoleAppPermission (validator is set below)
    permission = bb.Attribute("permission", nullable=True, user_defined=True)

    # Instance attribute type: AdminConsoleAppPolicy (validator is set below)
    previous_value = bb.Attribute("previous_value", user_defined=True)

    # Instance attribute type: AdminConsoleAppPolicy (validator is set below)
    new_value = bb.Attribute("new_value", user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AppPermissionsChangedDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

AppPermissionsChangedDetails_validator = bv.Struct(AppPermissionsChangedDetails)

class AppPermissionsChangedType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AppPermissionsChangedType, self)._process_custom_annotations(annotation_type, field_path, processor)

AppPermissionsChangedType_validator = bv.Struct(AppPermissionsChangedType)

class AppUnlinkTeamDetails(bb.Struct):
    """
    Unlinked app for team.

    :ivar team_log.AppUnlinkTeamDetails.app_info: Relevant application details.
    """

    __slots__ = [
        '_app_info_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 app_info=None):
        self._app_info_value = bb.NOT_SET
        if app_info is not None:
            self.app_info = app_info

    # Instance attribute type: AppLogInfo (validator is set below)
    app_info = bb.Attribute("app_info", user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AppUnlinkTeamDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

AppUnlinkTeamDetails_validator = bv.Struct(AppUnlinkTeamDetails)

class AppUnlinkTeamType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AppUnlinkTeamType, self)._process_custom_annotations(annotation_type, field_path, processor)

AppUnlinkTeamType_validator = bv.Struct(AppUnlinkTeamType)

class AppUnlinkUserDetails(bb.Struct):
    """
    Unlinked app for member.

    :ivar team_log.AppUnlinkUserDetails.app_info: Relevant application details.
    """

    __slots__ = [
        '_app_info_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 app_info=None):
        self._app_info_value = bb.NOT_SET
        if app_info is not None:
            self.app_info = app_info

    # Instance attribute type: AppLogInfo (validator is set below)
    app_info = bb.Attribute("app_info", user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AppUnlinkUserDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

AppUnlinkUserDetails_validator = bv.Struct(AppUnlinkUserDetails)

class AppUnlinkUserType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AppUnlinkUserType, self)._process_custom_annotations(annotation_type, field_path, processor)

AppUnlinkUserType_validator = bv.Struct(AppUnlinkUserType)

class ApplyNamingConventionDetails(bb.Struct):
    """
    Applied naming convention.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ApplyNamingConventionDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

ApplyNamingConventionDetails_validator = bv.Struct(ApplyNamingConventionDetails)

class ApplyNamingConventionType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ApplyNamingConventionType, self)._process_custom_annotations(annotation_type, field_path, processor)

ApplyNamingConventionType_validator = bv.Struct(ApplyNamingConventionType)

class AssetLogInfo(bb.Union):
    """
    Asset details.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar FileLogInfo AssetLogInfo.file: File's details.
    :ivar FolderLogInfo AssetLogInfo.folder: Folder's details.
    :ivar PaperDocumentLogInfo AssetLogInfo.paper_document: Paper document's
        details.
    :ivar PaperFolderLogInfo AssetLogInfo.paper_folder: Paper folder's details.
    :ivar ShowcaseDocumentLogInfo AssetLogInfo.showcase_document: Showcase
        document's details.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def file(cls, val):
        """
        Create an instance of this class set to the ``file`` tag with value
        ``val``.

        :param FileLogInfo val:
        :rtype: AssetLogInfo
        """
        return cls('file', val)

    @classmethod
    def folder(cls, val):
        """
        Create an instance of this class set to the ``folder`` tag with value
        ``val``.

        :param FolderLogInfo val:
        :rtype: AssetLogInfo
        """
        return cls('folder', val)

    @classmethod
    def paper_document(cls, val):
        """
        Create an instance of this class set to the ``paper_document`` tag with
        value ``val``.

        :param PaperDocumentLogInfo val:
        :rtype: AssetLogInfo
        """
        return cls('paper_document', val)

    @classmethod
    def paper_folder(cls, val):
        """
        Create an instance of this class set to the ``paper_folder`` tag with
        value ``val``.

        :param PaperFolderLogInfo val:
        :rtype: AssetLogInfo
        """
        return cls('paper_folder', val)

    @classmethod
    def showcase_document(cls, val):
        """
        Create an instance of this class set to the ``showcase_document`` tag
        with value ``val``.

        :param ShowcaseDocumentLogInfo val:
        :rtype: AssetLogInfo
        """
        return cls('showcase_document', val)

    def is_file(self):
        """
        Check if the union tag is ``file``.

        :rtype: bool
        """
        return self._tag == 'file'

    def is_folder(self):
        """
        Check if the union tag is ``folder``.

        :rtype: bool
        """
        return self._tag == 'folder'

    def is_paper_document(self):
        """
        Check if the union tag is ``paper_document``.

        :rtype: bool
        """
        return self._tag == 'paper_document'

    def is_paper_folder(self):
        """
        Check if the union tag is ``paper_folder``.

        :rtype: bool
        """
        return self._tag == 'paper_folder'

    def is_showcase_document(self):
        """
        Check if the union tag is ``showcase_document``.

        :rtype: bool
        """
        return self._tag == 'showcase_document'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_file(self):
        """
        File's details.

        Only call this if :meth:`is_file` is true.

        :rtype: FileLogInfo
        """
        if not self.is_file():
            raise AttributeError("tag 'file' not set")
        return self._value

    def get_folder(self):
        """
        Folder's details.

        Only call this if :meth:`is_folder` is true.

        :rtype: FolderLogInfo
        """
        if not self.is_folder():
            raise AttributeError("tag 'folder' not set")
        return self._value

    def get_paper_document(self):
        """
        Paper document's details.

        Only call this if :meth:`is_paper_document` is true.

        :rtype: PaperDocumentLogInfo
        """
        if not self.is_paper_document():
            raise AttributeError("tag 'paper_document' not set")
        return self._value

    def get_paper_folder(self):
        """
        Paper folder's details.

        Only call this if :meth:`is_paper_folder` is true.

        :rtype: PaperFolderLogInfo
        """
        if not self.is_paper_folder():
            raise AttributeError("tag 'paper_folder' not set")
        return self._value

    def get_showcase_document(self):
        """
        Showcase document's details.

        Only call this if :meth:`is_showcase_document` is true.

        :rtype: ShowcaseDocumentLogInfo
        """
        if not self.is_showcase_document():
            raise AttributeError("tag 'showcase_document' not set")
        return self._value

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(AssetLogInfo, self)._process_custom_annotations(annotation_type, field_path, processor)

AssetLogInfo_validator = bv.Union(AssetLogInfo)

class BackupStatus(bb.Union):
    """
    Backup status

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    disabled = None
    # Attribute is overwritten below the class definition
    enabled = None
    # Attribute is overwritten below the class definition
    other = None

    def is_disabled(self):
        """
        Check if the union tag is ``disabled``.

        :rtype: bool
        """
        return self._tag == 'disabled'

    def is_enabled(self):
        """
        Check if the union tag is ``enabled``.

        :rtype: bool
        """
        return self._tag == 'enabled'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(BackupStatus, self)._process_custom_annotations(annotation_type, field_path, processor)

BackupStatus_validator = bv.Union(BackupStatus)

class BinderAddPageDetails(bb.Struct):
    """
    Added Binder page.

    :ivar team_log.BinderAddPageDetails.event_uuid: Event unique identifier.
    :ivar team_log.BinderAddPageDetails.doc_title: Title of the Binder doc.
    :ivar team_log.BinderAddPageDetails.binder_item_name: Name of the Binder
        page/section.
    """

    __slots__ = [
        '_event_uuid_value',
        '_doc_title_value',
        '_binder_item_name_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None,
                 doc_title=None,
                 binder_item_name=None):
        self._event_uuid_value = bb.NOT_SET
        self._doc_title_value = bb.NOT_SET
        self._binder_item_name_value = bb.NOT_SET
        if event_uuid is not None:
            self.event_uuid = event_uuid
        if doc_title is not None:
            self.doc_title = doc_title
        if binder_item_name is not None:
            self.binder_item_name = binder_item_name

    # Instance attribute type: str (validator is set below)
    event_uuid = bb.Attribute("event_uuid")

    # Instance attribute type: str (validator is set below)
    doc_title = bb.Attribute("doc_title")

    # Instance attribute type: str (validator is set below)
    binder_item_name = bb.Attribute("binder_item_name")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(BinderAddPageDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

BinderAddPageDetails_validator = bv.Struct(BinderAddPageDetails)

class BinderAddPageType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(BinderAddPageType, self)._process_custom_annotations(annotation_type, field_path, processor)

BinderAddPageType_validator = bv.Struct(BinderAddPageType)

class BinderAddSectionDetails(bb.Struct):
    """
    Added Binder section.

    :ivar team_log.BinderAddSectionDetails.event_uuid: Event unique identifier.
    :ivar team_log.BinderAddSectionDetails.doc_title: Title of the Binder doc.
    :ivar team_log.BinderAddSectionDetails.binder_item_name: Name of the Binder
        page/section.
    """

    __slots__ = [
        '_event_uuid_value',
        '_doc_title_value',
        '_binder_item_name_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None,
                 doc_title=None,
                 binder_item_name=None):
        self._event_uuid_value = bb.NOT_SET
        self._doc_title_value = bb.NOT_SET
        self._binder_item_name_value = bb.NOT_SET
        if event_uuid is not None:
            self.event_uuid = event_uuid
        if doc_title is not None:
            self.doc_title = doc_title
        if binder_item_name is not None:
            self.binder_item_name = binder_item_name

    # Instance attribute type: str (validator is set below)
    event_uuid = bb.Attribute("event_uuid")

    # Instance attribute type: str (validator is set below)
    doc_title = bb.Attribute("doc_title")

    # Instance attribute type: str (validator is set below)
    binder_item_name = bb.Attribute("binder_item_name")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(BinderAddSectionDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

BinderAddSectionDetails_validator = bv.Struct(BinderAddSectionDetails)

class BinderAddSectionType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(BinderAddSectionType, self)._process_custom_annotations(annotation_type, field_path, processor)

BinderAddSectionType_validator = bv.Struct(BinderAddSectionType)

class BinderRemovePageDetails(bb.Struct):
    """
    Removed Binder page.

    :ivar team_log.BinderRemovePageDetails.event_uuid: Event unique identifier.
    :ivar team_log.BinderRemovePageDetails.doc_title: Title of the Binder doc.
    :ivar team_log.BinderRemovePageDetails.binder_item_name: Name of the Binder
        page/section.
    """

    __slots__ = [
        '_event_uuid_value',
        '_doc_title_value',
        '_binder_item_name_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None,
                 doc_title=None,
                 binder_item_name=None):
        self._event_uuid_value = bb.NOT_SET
        self._doc_title_value = bb.NOT_SET
        self._binder_item_name_value = bb.NOT_SET
        if event_uuid is not None:
            self.event_uuid = event_uuid
        if doc_title is not None:
            self.doc_title = doc_title
        if binder_item_name is not None:
            self.binder_item_name = binder_item_name

    # Instance attribute type: str (validator is set below)
    event_uuid = bb.Attribute("event_uuid")

    # Instance attribute type: str (validator is set below)
    doc_title = bb.Attribute("doc_title")

    # Instance attribute type: str (validator is set below)
    binder_item_name = bb.Attribute("binder_item_name")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(BinderRemovePageDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

BinderRemovePageDetails_validator = bv.Struct(BinderRemovePageDetails)

class BinderRemovePageType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(BinderRemovePageType, self)._process_custom_annotations(annotation_type, field_path, processor)

BinderRemovePageType_validator = bv.Struct(BinderRemovePageType)

class BinderRemoveSectionDetails(bb.Struct):
    """
    Removed Binder section.

    :ivar team_log.BinderRemoveSectionDetails.event_uuid: Event unique
        identifier.
    :ivar team_log.BinderRemoveSectionDetails.doc_title: Title of the Binder
        doc.
    :ivar team_log.BinderRemoveSectionDetails.binder_item_name: Name of the
        Binder page/section.
    """

    __slots__ = [
        '_event_uuid_value',
        '_doc_title_value',
        '_binder_item_name_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None,
                 doc_title=None,
                 binder_item_name=None):
        self._event_uuid_value = bb.NOT_SET
        self._doc_title_value = bb.NOT_SET
        self._binder_item_name_value = bb.NOT_SET
        if event_uuid is not None:
            self.event_uuid = event_uuid
        if doc_title is not None:
            self.doc_title = doc_title
        if binder_item_name is not None:
            self.binder_item_name = binder_item_name

    # Instance attribute type: str (validator is set below)
    event_uuid = bb.Attribute("event_uuid")

    # Instance attribute type: str (validator is set below)
    doc_title = bb.Attribute("doc_title")

    # Instance attribute type: str (validator is set below)
    binder_item_name = bb.Attribute("binder_item_name")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(BinderRemoveSectionDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

BinderRemoveSectionDetails_validator = bv.Struct(BinderRemoveSectionDetails)

class BinderRemoveSectionType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(BinderRemoveSectionType, self)._process_custom_annotations(annotation_type, field_path, processor)

BinderRemoveSectionType_validator = bv.Struct(BinderRemoveSectionType)

class BinderRenamePageDetails(bb.Struct):
    """
    Renamed Binder page.

    :ivar team_log.BinderRenamePageDetails.event_uuid: Event unique identifier.
    :ivar team_log.BinderRenamePageDetails.doc_title: Title of the Binder doc.
    :ivar team_log.BinderRenamePageDetails.binder_item_name: Name of the Binder
        page/section.
    :ivar team_log.BinderRenamePageDetails.previous_binder_item_name: Previous
        name of the Binder page/section.
    """

    __slots__ = [
        '_event_uuid_value',
        '_doc_title_value',
        '_binder_item_name_value',
        '_previous_binder_item_name_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None,
                 doc_title=None,
                 binder_item_name=None,
                 previous_binder_item_name=None):
        self._event_uuid_value = bb.NOT_SET
        self._doc_title_value = bb.NOT_SET
        self._binder_item_name_value = bb.NOT_SET
        self._previous_binder_item_name_value = bb.NOT_SET
        if event_uuid is not None:
            self.event_uuid = event_uuid
        if doc_title is not None:
            self.doc_title = doc_title
        if binder_item_name is not None:
            self.binder_item_name = binder_item_name
        if previous_binder_item_name is not None:
            self.previous_binder_item_name = previous_binder_item_name

    # Instance attribute type: str (validator is set below)
    event_uuid = bb.Attribute("event_uuid")

    # Instance attribute type: str (validator is set below)
    doc_title = bb.Attribute("doc_title")

    # Instance attribute type: str (validator is set below)
    binder_item_name = bb.Attribute("binder_item_name")

    # Instance attribute type: str (validator is set below)
    previous_binder_item_name = bb.Attribute("previous_binder_item_name", nullable=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(BinderRenamePageDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

BinderRenamePageDetails_validator = bv.Struct(BinderRenamePageDetails)

class BinderRenamePageType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(BinderRenamePageType, self)._process_custom_annotations(annotation_type, field_path, processor)

BinderRenamePageType_validator = bv.Struct(BinderRenamePageType)

class BinderRenameSectionDetails(bb.Struct):
    """
    Renamed Binder section.

    :ivar team_log.BinderRenameSectionDetails.event_uuid: Event unique
        identifier.
    :ivar team_log.BinderRenameSectionDetails.doc_title: Title of the Binder
        doc.
    :ivar team_log.BinderRenameSectionDetails.binder_item_name: Name of the
        Binder page/section.
    :ivar team_log.BinderRenameSectionDetails.previous_binder_item_name:
        Previous name of the Binder page/section.
    """

    __slots__ = [
        '_event_uuid_value',
        '_doc_title_value',
        '_binder_item_name_value',
        '_previous_binder_item_name_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None,
                 doc_title=None,
                 binder_item_name=None,
                 previous_binder_item_name=None):
        self._event_uuid_value = bb.NOT_SET
        self._doc_title_value = bb.NOT_SET
        self._binder_item_name_value = bb.NOT_SET
        self._previous_binder_item_name_value = bb.NOT_SET
        if event_uuid is not None:
            self.event_uuid = event_uuid
        if doc_title is not None:
            self.doc_title = doc_title
        if binder_item_name is not None:
            self.binder_item_name = binder_item_name
        if previous_binder_item_name is not None:
            self.previous_binder_item_name = previous_binder_item_name

    # Instance attribute type: str (validator is set below)
    event_uuid = bb.Attribute("event_uuid")

    # Instance attribute type: str (validator is set below)
    doc_title = bb.Attribute("doc_title")

    # Instance attribute type: str (validator is set below)
    binder_item_name = bb.Attribute("binder_item_name")

    # Instance attribute type: str (validator is set below)
    previous_binder_item_name = bb.Attribute("previous_binder_item_name", nullable=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(BinderRenameSectionDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

BinderRenameSectionDetails_validator = bv.Struct(BinderRenameSectionDetails)

class BinderRenameSectionType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(BinderRenameSectionType, self)._process_custom_annotations(annotation_type, field_path, processor)

BinderRenameSectionType_validator = bv.Struct(BinderRenameSectionType)

class BinderReorderPageDetails(bb.Struct):
    """
    Reordered Binder page.

    :ivar team_log.BinderReorderPageDetails.event_uuid: Event unique identifier.
    :ivar team_log.BinderReorderPageDetails.doc_title: Title of the Binder doc.
    :ivar team_log.BinderReorderPageDetails.binder_item_name: Name of the Binder
        page/section.
    """

    __slots__ = [
        '_event_uuid_value',
        '_doc_title_value',
        '_binder_item_name_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None,
                 doc_title=None,
                 binder_item_name=None):
        self._event_uuid_value = bb.NOT_SET
        self._doc_title_value = bb.NOT_SET
        self._binder_item_name_value = bb.NOT_SET
        if event_uuid is not None:
            self.event_uuid = event_uuid
        if doc_title is not None:
            self.doc_title = doc_title
        if binder_item_name is not None:
            self.binder_item_name = binder_item_name

    # Instance attribute type: str (validator is set below)
    event_uuid = bb.Attribute("event_uuid")

    # Instance attribute type: str (validator is set below)
    doc_title = bb.Attribute("doc_title")

    # Instance attribute type: str (validator is set below)
    binder_item_name = bb.Attribute("binder_item_name")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(BinderReorderPageDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

BinderReorderPageDetails_validator = bv.Struct(BinderReorderPageDetails)

class BinderReorderPageType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(BinderReorderPageType, self)._process_custom_annotations(annotation_type, field_path, processor)

BinderReorderPageType_validator = bv.Struct(BinderReorderPageType)

class BinderReorderSectionDetails(bb.Struct):
    """
    Reordered Binder section.

    :ivar team_log.BinderReorderSectionDetails.event_uuid: Event unique
        identifier.
    :ivar team_log.BinderReorderSectionDetails.doc_title: Title of the Binder
        doc.
    :ivar team_log.BinderReorderSectionDetails.binder_item_name: Name of the
        Binder page/section.
    """

    __slots__ = [
        '_event_uuid_value',
        '_doc_title_value',
        '_binder_item_name_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None,
                 doc_title=None,
                 binder_item_name=None):
        self._event_uuid_value = bb.NOT_SET
        self._doc_title_value = bb.NOT_SET
        self._binder_item_name_value = bb.NOT_SET
        if event_uuid is not None:
            self.event_uuid = event_uuid
        if doc_title is not None:
            self.doc_title = doc_title
        if binder_item_name is not None:
            self.binder_item_name = binder_item_name

    # Instance attribute type: str (validator is set below)
    event_uuid = bb.Attribute("event_uuid")

    # Instance attribute type: str (validator is set below)
    doc_title = bb.Attribute("doc_title")

    # Instance attribute type: str (validator is set below)
    binder_item_name = bb.Attribute("binder_item_name")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(BinderReorderSectionDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

BinderReorderSectionDetails_validator = bv.Struct(BinderReorderSectionDetails)

class BinderReorderSectionType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(BinderReorderSectionType, self)._process_custom_annotations(annotation_type, field_path, processor)

BinderReorderSectionType_validator = bv.Struct(BinderReorderSectionType)

class CameraUploadsPolicy(bb.Union):
    """
    Policy for controlling if team members can activate camera uploads

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    disabled = None
    # Attribute is overwritten below the class definition
    enabled = None
    # Attribute is overwritten below the class definition
    other = None

    def is_disabled(self):
        """
        Check if the union tag is ``disabled``.

        :rtype: bool
        """
        return self._tag == 'disabled'

    def is_enabled(self):
        """
        Check if the union tag is ``enabled``.

        :rtype: bool
        """
        return self._tag == 'enabled'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(CameraUploadsPolicy, self)._process_custom_annotations(annotation_type, field_path, processor)

CameraUploadsPolicy_validator = bv.Union(CameraUploadsPolicy)

class CameraUploadsPolicyChangedDetails(bb.Struct):
    """
    Changed camera uploads setting for team.

    :ivar team_log.CameraUploadsPolicyChangedDetails.new_value: New camera
        uploads setting.
    :ivar team_log.CameraUploadsPolicyChangedDetails.previous_value: Previous
        camera uploads setting.
    """

    __slots__ = [
        '_new_value_value',
        '_previous_value_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = bb.NOT_SET
        self._previous_value_value = bb.NOT_SET
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    # Instance attribute type: CameraUploadsPolicy (validator is set below)
    new_value = bb.Attribute("new_value", user_defined=True)

    # Instance attribute type: CameraUploadsPolicy (validator is set below)
    previous_value = bb.Attribute("previous_value", user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(CameraUploadsPolicyChangedDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

CameraUploadsPolicyChangedDetails_validator = bv.Struct(CameraUploadsPolicyChangedDetails)

class CameraUploadsPolicyChangedType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(CameraUploadsPolicyChangedType, self)._process_custom_annotations(annotation_type, field_path, processor)

CameraUploadsPolicyChangedType_validator = bv.Struct(CameraUploadsPolicyChangedType)

class CaptureTranscriptPolicy(bb.Union):
    """
    Policy for deciding whether team users can transcription in Capture

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    default = None
    # Attribute is overwritten below the class definition
    disabled = None
    # Attribute is overwritten below the class definition
    enabled = None
    # Attribute is overwritten below the class definition
    other = None

    def is_default(self):
        """
        Check if the union tag is ``default``.

        :rtype: bool
        """
        return self._tag == 'default'

    def is_disabled(self):
        """
        Check if the union tag is ``disabled``.

        :rtype: bool
        """
        return self._tag == 'disabled'

    def is_enabled(self):
        """
        Check if the union tag is ``enabled``.

        :rtype: bool
        """
        return self._tag == 'enabled'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(CaptureTranscriptPolicy, self)._process_custom_annotations(annotation_type, field_path, processor)

CaptureTranscriptPolicy_validator = bv.Union(CaptureTranscriptPolicy)

class CaptureTranscriptPolicyChangedDetails(bb.Struct):
    """
    Changed Capture transcription policy for team.

    :ivar team_log.CaptureTranscriptPolicyChangedDetails.new_value: To.
    :ivar team_log.CaptureTranscriptPolicyChangedDetails.previous_value: From.
    """

    __slots__ = [
        '_new_value_value',
        '_previous_value_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = bb.NOT_SET
        self._previous_value_value = bb.NOT_SET
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    # Instance attribute type: CaptureTranscriptPolicy (validator is set below)
    new_value = bb.Attribute("new_value", user_defined=True)

    # Instance attribute type: CaptureTranscriptPolicy (validator is set below)
    previous_value = bb.Attribute("previous_value", user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(CaptureTranscriptPolicyChangedDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

CaptureTranscriptPolicyChangedDetails_validator = bv.Struct(CaptureTranscriptPolicyChangedDetails)

class CaptureTranscriptPolicyChangedType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(CaptureTranscriptPolicyChangedType, self)._process_custom_annotations(annotation_type, field_path, processor)

CaptureTranscriptPolicyChangedType_validator = bv.Struct(CaptureTranscriptPolicyChangedType)

class Certificate(bb.Struct):
    """
    Certificate details.

    :ivar team_log.Certificate.subject: Certificate subject.
    :ivar team_log.Certificate.issuer: Certificate issuer.
    :ivar team_log.Certificate.issue_date: Certificate issue date.
    :ivar team_log.Certificate.expiration_date: Certificate expiration date.
    :ivar team_log.Certificate.serial_number: Certificate serial number.
    :ivar team_log.Certificate.sha1_fingerprint: Certificate sha1 fingerprint.
    :ivar team_log.Certificate.common_name: Certificate common name.
    """

    __slots__ = [
        '_subject_value',
        '_issuer_value',
        '_issue_date_value',
        '_expiration_date_value',
        '_serial_number_value',
        '_sha1_fingerprint_value',
        '_common_name_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 subject=None,
                 issuer=None,
                 issue_date=None,
                 expiration_date=None,
                 serial_number=None,
                 sha1_fingerprint=None,
                 common_name=None):
        self._subject_value = bb.NOT_SET
        self._issuer_value = bb.NOT_SET
        self._issue_date_value = bb.NOT_SET
        self._expiration_date_value = bb.NOT_SET
        self._serial_number_value = bb.NOT_SET
        self._sha1_fingerprint_value = bb.NOT_SET
        self._common_name_value = bb.NOT_SET
        if subject is not None:
            self.subject = subject
        if issuer is not None:
            self.issuer = issuer
        if issue_date is not None:
            self.issue_date = issue_date
        if expiration_date is not None:
            self.expiration_date = expiration_date
        if serial_number is not None:
            self.serial_number = serial_number
        if sha1_fingerprint is not None:
            self.sha1_fingerprint = sha1_fingerprint
        if common_name is not None:
            self.common_name = common_name

    # Instance attribute type: str (validator is set below)
    subject = bb.Attribute("subject")

    # Instance attribute type: str (validator is set below)
    issuer = bb.Attribute("issuer")

    # Instance attribute type: str (validator is set below)
    issue_date = bb.Attribute("issue_date")

    # Instance attribute type: str (validator is set below)
    expiration_date = bb.Attribute("expiration_date")

    # Instance attribute type: str (validator is set below)
    serial_number = bb.Attribute("serial_number")

    # Instance attribute type: str (validator is set below)
    sha1_fingerprint = bb.Attribute("sha1_fingerprint")

    # Instance attribute type: str (validator is set below)
    common_name = bb.Attribute("common_name", nullable=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(Certificate, self)._process_custom_annotations(annotation_type, field_path, processor)

Certificate_validator = bv.Struct(Certificate)

class ChangeLinkExpirationPolicy(bb.Union):
    """
    Policy for deciding whether the team's default expiration days policy must
    be enforced when an externally shared link is updated

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    allowed = None
    # Attribute is overwritten below the class definition
    not_allowed = None
    # Attribute is overwritten below the class definition
    other = None

    def is_allowed(self):
        """
        Check if the union tag is ``allowed``.

        :rtype: bool
        """
        return self._tag == 'allowed'

    def is_not_allowed(self):
        """
        Check if the union tag is ``not_allowed``.

        :rtype: bool
        """
        return self._tag == 'not_allowed'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ChangeLinkExpirationPolicy, self)._process_custom_annotations(annotation_type, field_path, processor)

ChangeLinkExpirationPolicy_validator = bv.Union(ChangeLinkExpirationPolicy)

class ChangedEnterpriseAdminRoleDetails(bb.Struct):
    """
    Changed enterprise admin role.

    :ivar team_log.ChangedEnterpriseAdminRoleDetails.previous_value: The
        member&#x2019s previous enterprise admin role.
    :ivar team_log.ChangedEnterpriseAdminRoleDetails.new_value: The
        member&#x2019s new enterprise admin role.
    :ivar team_log.ChangedEnterpriseAdminRoleDetails.team_name: The name of the
        member&#x2019s team.
    """

    __slots__ = [
        '_previous_value_value',
        '_new_value_value',
        '_team_name_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 previous_value=None,
                 new_value=None,
                 team_name=None):
        self._previous_value_value = bb.NOT_SET
        self._new_value_value = bb.NOT_SET
        self._team_name_value = bb.NOT_SET
        if previous_value is not None:
            self.previous_value = previous_value
        if new_value is not None:
            self.new_value = new_value
        if team_name is not None:
            self.team_name = team_name

    # Instance attribute type: FedAdminRole (validator is set below)
    previous_value = bb.Attribute("previous_value", user_defined=True)

    # Instance attribute type: FedAdminRole (validator is set below)
    new_value = bb.Attribute("new_value", user_defined=True)

    # Instance attribute type: str (validator is set below)
    team_name = bb.Attribute("team_name")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ChangedEnterpriseAdminRoleDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

ChangedEnterpriseAdminRoleDetails_validator = bv.Struct(ChangedEnterpriseAdminRoleDetails)

class ChangedEnterpriseAdminRoleType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ChangedEnterpriseAdminRoleType, self)._process_custom_annotations(annotation_type, field_path, processor)

ChangedEnterpriseAdminRoleType_validator = bv.Struct(ChangedEnterpriseAdminRoleType)

class ChangedEnterpriseConnectedTeamStatusDetails(bb.Struct):
    """
    Changed enterprise-connected team status.

    :ivar team_log.ChangedEnterpriseConnectedTeamStatusDetails.action: The
        preformed change in the team&#x2019s connection status.
    :ivar team_log.ChangedEnterpriseConnectedTeamStatusDetails.additional_info:
        Additional information about the organization or team.
    :ivar team_log.ChangedEnterpriseConnectedTeamStatusDetails.previous_value:
        Previous request state.
    :ivar team_log.ChangedEnterpriseConnectedTeamStatusDetails.new_value: New
        request state.
    """

    __slots__ = [
        '_action_value',
        '_additional_info_value',
        '_previous_value_value',
        '_new_value_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 action=None,
                 additional_info=None,
                 previous_value=None,
                 new_value=None):
        self._action_value = bb.NOT_SET
        self._additional_info_value = bb.NOT_SET
        self._previous_value_value = bb.NOT_SET
        self._new_value_value = bb.NOT_SET
        if action is not None:
            self.action = action
        if additional_info is not None:
            self.additional_info = additional_info
        if previous_value is not None:
            self.previous_value = previous_value
        if new_value is not None:
            self.new_value = new_value

    # Instance attribute type: FedHandshakeAction (validator is set below)
    action = bb.Attribute("action", user_defined=True)

    # Instance attribute type: FederationStatusChangeAdditionalInfo (validator is set below)
    additional_info = bb.Attribute("additional_info", user_defined=True)

    # Instance attribute type: TrustedTeamsRequestState (validator is set below)
    previous_value = bb.Attribute("previous_value", user_defined=True)

    # Instance attribute type: TrustedTeamsRequestState (validator is set below)
    new_value = bb.Attribute("new_value", user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ChangedEnterpriseConnectedTeamStatusDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

ChangedEnterpriseConnectedTeamStatusDetails_validator = bv.Struct(ChangedEnterpriseConnectedTeamStatusDetails)

class ChangedEnterpriseConnectedTeamStatusType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ChangedEnterpriseConnectedTeamStatusType, self)._process_custom_annotations(annotation_type, field_path, processor)

ChangedEnterpriseConnectedTeamStatusType_validator = bv.Struct(ChangedEnterpriseConnectedTeamStatusType)

class ClassificationChangePolicyDetails(bb.Struct):
    """
    Changed classification policy for team.

    :ivar team_log.ClassificationChangePolicyDetails.previous_value: Previous
        classification policy.
    :ivar team_log.ClassificationChangePolicyDetails.new_value: New
        classification policy.
    :ivar team_log.ClassificationChangePolicyDetails.classification_type: Policy
        type.
    """

    __slots__ = [
        '_previous_value_value',
        '_new_value_value',
        '_classification_type_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 previous_value=None,
                 new_value=None,
                 classification_type=None):
        self._previous_value_value = bb.NOT_SET
        self._new_value_value = bb.NOT_SET
        self._classification_type_value = bb.NOT_SET
        if previous_value is not None:
            self.previous_value = previous_value
        if new_value is not None:
            self.new_value = new_value
        if classification_type is not None:
            self.classification_type = classification_type

    # Instance attribute type: ClassificationPolicyEnumWrapper (validator is set below)
    previous_value = bb.Attribute("previous_value", user_defined=True)

    # Instance attribute type: ClassificationPolicyEnumWrapper (validator is set below)
    new_value = bb.Attribute("new_value", user_defined=True)

    # Instance attribute type: ClassificationType (validator is set below)
    classification_type = bb.Attribute("classification_type", user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ClassificationChangePolicyDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

ClassificationChangePolicyDetails_validator = bv.Struct(ClassificationChangePolicyDetails)

class ClassificationChangePolicyType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ClassificationChangePolicyType, self)._process_custom_annotations(annotation_type, field_path, processor)

ClassificationChangePolicyType_validator = bv.Struct(ClassificationChangePolicyType)

class ClassificationCreateReportDetails(bb.Struct):
    """
    Created Classification report.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ClassificationCreateReportDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

ClassificationCreateReportDetails_validator = bv.Struct(ClassificationCreateReportDetails)

class ClassificationCreateReportFailDetails(bb.Struct):
    """
    Couldn't create Classification report.

    :ivar team_log.ClassificationCreateReportFailDetails.failure_reason: Failure
        reason.
    """

    __slots__ = [
        '_failure_reason_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 failure_reason=None):
        self._failure_reason_value = bb.NOT_SET
        if failure_reason is not None:
            self.failure_reason = failure_reason

    # Instance attribute type: team.TeamReportFailureReason (validator is set below)
    failure_reason = bb.Attribute("failure_reason", user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ClassificationCreateReportFailDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

ClassificationCreateReportFailDetails_validator = bv.Struct(ClassificationCreateReportFailDetails)

class ClassificationCreateReportFailType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ClassificationCreateReportFailType, self)._process_custom_annotations(annotation_type, field_path, processor)

ClassificationCreateReportFailType_validator = bv.Struct(ClassificationCreateReportFailType)

class ClassificationCreateReportType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ClassificationCreateReportType, self)._process_custom_annotations(annotation_type, field_path, processor)

ClassificationCreateReportType_validator = bv.Struct(ClassificationCreateReportType)

class ClassificationPolicyEnumWrapper(bb.Union):
    """
    Policy for controlling team access to the classification feature

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    disabled = None
    # Attribute is overwritten below the class definition
    enabled = None
    # Attribute is overwritten below the class definition
    member_and_team_folders = None
    # Attribute is overwritten below the class definition
    team_folders = None
    # Attribute is overwritten below the class definition
    other = None

    def is_disabled(self):
        """
        Check if the union tag is ``disabled``.

        :rtype: bool
        """
        return self._tag == 'disabled'

    def is_enabled(self):
        """
        Check if the union tag is ``enabled``.

        :rtype: bool
        """
        return self._tag == 'enabled'

    def is_member_and_team_folders(self):
        """
        Check if the union tag is ``member_and_team_folders``.

        :rtype: bool
        """
        return self._tag == 'member_and_team_folders'

    def is_team_folders(self):
        """
        Check if the union tag is ``team_folders``.

        :rtype: bool
        """
        return self._tag == 'team_folders'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ClassificationPolicyEnumWrapper, self)._process_custom_annotations(annotation_type, field_path, processor)

ClassificationPolicyEnumWrapper_validator = bv.Union(ClassificationPolicyEnumWrapper)

class ClassificationType(bb.Union):
    """
    The type of classification (currently only personal information)

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    personal_information = None
    # Attribute is overwritten below the class definition
    pii = None
    # Attribute is overwritten below the class definition
    other = None

    def is_personal_information(self):
        """
        Check if the union tag is ``personal_information``.

        :rtype: bool
        """
        return self._tag == 'personal_information'

    def is_pii(self):
        """
        Check if the union tag is ``pii``.

        :rtype: bool
        """
        return self._tag == 'pii'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ClassificationType, self)._process_custom_annotations(annotation_type, field_path, processor)

ClassificationType_validator = bv.Union(ClassificationType)

class CollectionShareDetails(bb.Struct):
    """
    Shared album.

    :ivar team_log.CollectionShareDetails.album_name: Album name.
    """

    __slots__ = [
        '_album_name_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 album_name=None):
        self._album_name_value = bb.NOT_SET
        if album_name is not None:
            self.album_name = album_name

    # Instance attribute type: str (validator is set below)
    album_name = bb.Attribute("album_name")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(CollectionShareDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

CollectionShareDetails_validator = bv.Struct(CollectionShareDetails)

class CollectionShareType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(CollectionShareType, self)._process_custom_annotations(annotation_type, field_path, processor)

CollectionShareType_validator = bv.Struct(CollectionShareType)

class ComputerBackupPolicy(bb.Union):
    """
    Policy for controlling team access to computer backup feature

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    default = None
    # Attribute is overwritten below the class definition
    disabled = None
    # Attribute is overwritten below the class definition
    enabled = None
    # Attribute is overwritten below the class definition
    other = None

    def is_default(self):
        """
        Check if the union tag is ``default``.

        :rtype: bool
        """
        return self._tag == 'default'

    def is_disabled(self):
        """
        Check if the union tag is ``disabled``.

        :rtype: bool
        """
        return self._tag == 'disabled'

    def is_enabled(self):
        """
        Check if the union tag is ``enabled``.

        :rtype: bool
        """
        return self._tag == 'enabled'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ComputerBackupPolicy, self)._process_custom_annotations(annotation_type, field_path, processor)

ComputerBackupPolicy_validator = bv.Union(ComputerBackupPolicy)

class ComputerBackupPolicyChangedDetails(bb.Struct):
    """
    Changed computer backup policy for team.

    :ivar team_log.ComputerBackupPolicyChangedDetails.new_value: New computer
        backup policy.
    :ivar team_log.ComputerBackupPolicyChangedDetails.previous_value: Previous
        computer backup policy.
    """

    __slots__ = [
        '_new_value_value',
        '_previous_value_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = bb.NOT_SET
        self._previous_value_value = bb.NOT_SET
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    # Instance attribute type: ComputerBackupPolicy (validator is set below)
    new_value = bb.Attribute("new_value", user_defined=True)

    # Instance attribute type: ComputerBackupPolicy (validator is set below)
    previous_value = bb.Attribute("previous_value", user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ComputerBackupPolicyChangedDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

ComputerBackupPolicyChangedDetails_validator = bv.Struct(ComputerBackupPolicyChangedDetails)

class ComputerBackupPolicyChangedType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ComputerBackupPolicyChangedType, self)._process_custom_annotations(annotation_type, field_path, processor)

ComputerBackupPolicyChangedType_validator = bv.Struct(ComputerBackupPolicyChangedType)

class ConnectedTeamName(bb.Struct):
    """
    The name of the team

    :ivar team_log.ConnectedTeamName.team: The name of the team.
    """

    __slots__ = [
        '_team_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 team=None):
        self._team_value = bb.NOT_SET
        if team is not None:
            self.team = team

    # Instance attribute type: str (validator is set below)
    team = bb.Attribute("team")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ConnectedTeamName, self)._process_custom_annotations(annotation_type, field_path, processor)

ConnectedTeamName_validator = bv.Struct(ConnectedTeamName)

class ContentAdministrationPolicyChangedDetails(bb.Struct):
    """
    Changed content management setting.

    :ivar team_log.ContentAdministrationPolicyChangedDetails.new_value: New
        content administration policy.
    :ivar team_log.ContentAdministrationPolicyChangedDetails.previous_value:
        Previous content administration policy.
    """

    __slots__ = [
        '_new_value_value',
        '_previous_value_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = bb.NOT_SET
        self._previous_value_value = bb.NOT_SET
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    # Instance attribute type: str (validator is set below)
    new_value = bb.Attribute("new_value")

    # Instance attribute type: str (validator is set below)
    previous_value = bb.Attribute("previous_value")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ContentAdministrationPolicyChangedDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

ContentAdministrationPolicyChangedDetails_validator = bv.Struct(ContentAdministrationPolicyChangedDetails)

class ContentAdministrationPolicyChangedType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ContentAdministrationPolicyChangedType, self)._process_custom_annotations(annotation_type, field_path, processor)

ContentAdministrationPolicyChangedType_validator = bv.Struct(ContentAdministrationPolicyChangedType)

class ContentPermanentDeletePolicy(bb.Union):
    """
    Policy for pemanent content deletion

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    disabled = None
    # Attribute is overwritten below the class definition
    enabled = None
    # Attribute is overwritten below the class definition
    other = None

    def is_disabled(self):
        """
        Check if the union tag is ``disabled``.

        :rtype: bool
        """
        return self._tag == 'disabled'

    def is_enabled(self):
        """
        Check if the union tag is ``enabled``.

        :rtype: bool
        """
        return self._tag == 'enabled'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ContentPermanentDeletePolicy, self)._process_custom_annotations(annotation_type, field_path, processor)

ContentPermanentDeletePolicy_validator = bv.Union(ContentPermanentDeletePolicy)

class ContextLogInfo(bb.Union):
    """
    The primary entity on which the action was done.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar team_log.ContextLogInfo.anonymous: Anonymous context.
    :ivar NonTeamMemberLogInfo ContextLogInfo.non_team_member: Action was done
        on behalf of a non team member.
    :ivar TeamLogInfo ContextLogInfo.organization_team: Action was done on
        behalf of a team that's part of an organization.
    :ivar team_log.ContextLogInfo.team: Action was done on behalf of the team.
    :ivar TeamMemberLogInfo ContextLogInfo.team_member: Action was done on
        behalf of a team member.
    :ivar TrustedNonTeamMemberLogInfo ContextLogInfo.trusted_non_team_member:
        Action was done on behalf of a trusted non team member.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    anonymous = None
    # Attribute is overwritten below the class definition
    team = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def non_team_member(cls, val):
        """
        Create an instance of this class set to the ``non_team_member`` tag with
        value ``val``.

        :param NonTeamMemberLogInfo val:
        :rtype: ContextLogInfo
        """
        return cls('non_team_member', val)

    @classmethod
    def organization_team(cls, val):
        """
        Create an instance of this class set to the ``organization_team`` tag
        with value ``val``.

        :param TeamLogInfo val:
        :rtype: ContextLogInfo
        """
        return cls('organization_team', val)

    @classmethod
    def team_member(cls, val):
        """
        Create an instance of this class set to the ``team_member`` tag with
        value ``val``.

        :param TeamMemberLogInfo val:
        :rtype: ContextLogInfo
        """
        return cls('team_member', val)

    @classmethod
    def trusted_non_team_member(cls, val):
        """
        Create an instance of this class set to the ``trusted_non_team_member``
        tag with value ``val``.

        :param TrustedNonTeamMemberLogInfo val:
        :rtype: ContextLogInfo
        """
        return cls('trusted_non_team_member', val)

    def is_anonymous(self):
        """
        Check if the union tag is ``anonymous``.

        :rtype: bool
        """
        return self._tag == 'anonymous'

    def is_non_team_member(self):
        """
        Check if the union tag is ``non_team_member``.

        :rtype: bool
        """
        return self._tag == 'non_team_member'

    def is_organization_team(self):
        """
        Check if the union tag is ``organization_team``.

        :rtype: bool
        """
        return self._tag == 'organization_team'

    def is_team(self):
        """
        Check if the union tag is ``team``.

        :rtype: bool
        """
        return self._tag == 'team'

    def is_team_member(self):
        """
        Check if the union tag is ``team_member``.

        :rtype: bool
        """
        return self._tag == 'team_member'

    def is_trusted_non_team_member(self):
        """
        Check if the union tag is ``trusted_non_team_member``.

        :rtype: bool
        """
        return self._tag == 'trusted_non_team_member'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_non_team_member(self):
        """
        Action was done on behalf of a non team member.

        Only call this if :meth:`is_non_team_member` is true.

        :rtype: NonTeamMemberLogInfo
        """
        if not self.is_non_team_member():
            raise AttributeError("tag 'non_team_member' not set")
        return self._value

    def get_organization_team(self):
        """
        Action was done on behalf of a team that's part of an organization.

        Only call this if :meth:`is_organization_team` is true.

        :rtype: TeamLogInfo
        """
        if not self.is_organization_team():
            raise AttributeError("tag 'organization_team' not set")
        return self._value

    def get_team_member(self):
        """
        Action was done on behalf of a team member.

        Only call this if :meth:`is_team_member` is true.

        :rtype: TeamMemberLogInfo
        """
        if not self.is_team_member():
            raise AttributeError("tag 'team_member' not set")
        return self._value

    def get_trusted_non_team_member(self):
        """
        Action was done on behalf of a trusted non team member.

        Only call this if :meth:`is_trusted_non_team_member` is true.

        :rtype: TrustedNonTeamMemberLogInfo
        """
        if not self.is_trusted_non_team_member():
            raise AttributeError("tag 'trusted_non_team_member' not set")
        return self._value

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ContextLogInfo, self)._process_custom_annotations(annotation_type, field_path, processor)

ContextLogInfo_validator = bv.Union(ContextLogInfo)

class CreateFolderDetails(bb.Struct):
    """
    Created folders.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(CreateFolderDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

CreateFolderDetails_validator = bv.Struct(CreateFolderDetails)

class CreateFolderType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(CreateFolderType, self)._process_custom_annotations(annotation_type, field_path, processor)

CreateFolderType_validator = bv.Struct(CreateFolderType)

class CreateTeamInviteLinkDetails(bb.Struct):
    """
    Created team invite link.

    :ivar team_log.CreateTeamInviteLinkDetails.link_url: The invite link url
        that was created.
    :ivar team_log.CreateTeamInviteLinkDetails.expiry_date: The expiration date
        of the invite link.
    """

    __slots__ = [
        '_link_url_value',
        '_expiry_date_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 link_url=None,
                 expiry_date=None):
        self._link_url_value = bb.NOT_SET
        self._expiry_date_value = bb.NOT_SET
        if link_url is not None:
            self.link_url = link_url
        if expiry_date is not None:
            self.expiry_date = expiry_date

    # Instance attribute type: str (validator is set below)
    link_url = bb.Attribute("link_url")

    # Instance attribute type: str (validator is set below)
    expiry_date = bb.Attribute("expiry_date")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(CreateTeamInviteLinkDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

CreateTeamInviteLinkDetails_validator = bv.Struct(CreateTeamInviteLinkDetails)

class CreateTeamInviteLinkType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(CreateTeamInviteLinkType, self)._process_custom_annotations(annotation_type, field_path, processor)

CreateTeamInviteLinkType_validator = bv.Struct(CreateTeamInviteLinkType)

class DataPlacementRestrictionChangePolicyDetails(bb.Struct):
    """
    Set restrictions on data center locations where team data resides.

    :ivar team_log.DataPlacementRestrictionChangePolicyDetails.previous_value:
        Previous placement restriction.
    :ivar team_log.DataPlacementRestrictionChangePolicyDetails.new_value: New
        placement restriction.
    """

    __slots__ = [
        '_previous_value_value',
        '_new_value_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 previous_value=None,
                 new_value=None):
        self._previous_value_value = bb.NOT_SET
        self._new_value_value = bb.NOT_SET
        if previous_value is not None:
            self.previous_value = previous_value
        if new_value is not None:
            self.new_value = new_value

    # Instance attribute type: PlacementRestriction (validator is set below)
    previous_value = bb.Attribute("previous_value", user_defined=True)

    # Instance attribute type: PlacementRestriction (validator is set below)
    new_value = bb.Attribute("new_value", user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DataPlacementRestrictionChangePolicyDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DataPlacementRestrictionChangePolicyDetails_validator = bv.Struct(DataPlacementRestrictionChangePolicyDetails)

class DataPlacementRestrictionChangePolicyType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DataPlacementRestrictionChangePolicyType, self)._process_custom_annotations(annotation_type, field_path, processor)

DataPlacementRestrictionChangePolicyType_validator = bv.Struct(DataPlacementRestrictionChangePolicyType)

class DataPlacementRestrictionSatisfyPolicyDetails(bb.Struct):
    """
    Completed restrictions on data center locations where team data resides.

    :ivar
        team_log.DataPlacementRestrictionSatisfyPolicyDetails.placement_restriction:
        Placement restriction.
    """

    __slots__ = [
        '_placement_restriction_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 placement_restriction=None):
        self._placement_restriction_value = bb.NOT_SET
        if placement_restriction is not None:
            self.placement_restriction = placement_restriction

    # Instance attribute type: PlacementRestriction (validator is set below)
    placement_restriction = bb.Attribute("placement_restriction", user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DataPlacementRestrictionSatisfyPolicyDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DataPlacementRestrictionSatisfyPolicyDetails_validator = bv.Struct(DataPlacementRestrictionSatisfyPolicyDetails)

class DataPlacementRestrictionSatisfyPolicyType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DataPlacementRestrictionSatisfyPolicyType, self)._process_custom_annotations(annotation_type, field_path, processor)

DataPlacementRestrictionSatisfyPolicyType_validator = bv.Struct(DataPlacementRestrictionSatisfyPolicyType)

class DataResidencyMigrationRequestSuccessfulDetails(bb.Struct):
    """
    Requested data residency migration for team data.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DataResidencyMigrationRequestSuccessfulDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DataResidencyMigrationRequestSuccessfulDetails_validator = bv.Struct(DataResidencyMigrationRequestSuccessfulDetails)

class DataResidencyMigrationRequestSuccessfulType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DataResidencyMigrationRequestSuccessfulType, self)._process_custom_annotations(annotation_type, field_path, processor)

DataResidencyMigrationRequestSuccessfulType_validator = bv.Struct(DataResidencyMigrationRequestSuccessfulType)

class DataResidencyMigrationRequestUnsuccessfulDetails(bb.Struct):
    """
    Request for data residency migration for team data has failed.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DataResidencyMigrationRequestUnsuccessfulDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DataResidencyMigrationRequestUnsuccessfulDetails_validator = bv.Struct(DataResidencyMigrationRequestUnsuccessfulDetails)

class DataResidencyMigrationRequestUnsuccessfulType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DataResidencyMigrationRequestUnsuccessfulType, self)._process_custom_annotations(annotation_type, field_path, processor)

DataResidencyMigrationRequestUnsuccessfulType_validator = bv.Struct(DataResidencyMigrationRequestUnsuccessfulType)

class DefaultLinkExpirationDaysPolicy(bb.Union):
    """
    Policy for the default number of days until an externally shared link
    expires

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    day_1 = None
    # Attribute is overwritten below the class definition
    day_180 = None
    # Attribute is overwritten below the class definition
    day_3 = None
    # Attribute is overwritten below the class definition
    day_30 = None
    # Attribute is overwritten below the class definition
    day_7 = None
    # Attribute is overwritten below the class definition
    day_90 = None
    # Attribute is overwritten below the class definition
    none = None
    # Attribute is overwritten below the class definition
    year_1 = None
    # Attribute is overwritten below the class definition
    other = None

    def is_day_1(self):
        """
        Check if the union tag is ``day_1``.

        :rtype: bool
        """
        return self._tag == 'day_1'

    def is_day_180(self):
        """
        Check if the union tag is ``day_180``.

        :rtype: bool
        """
        return self._tag == 'day_180'

    def is_day_3(self):
        """
        Check if the union tag is ``day_3``.

        :rtype: bool
        """
        return self._tag == 'day_3'

    def is_day_30(self):
        """
        Check if the union tag is ``day_30``.

        :rtype: bool
        """
        return self._tag == 'day_30'

    def is_day_7(self):
        """
        Check if the union tag is ``day_7``.

        :rtype: bool
        """
        return self._tag == 'day_7'

    def is_day_90(self):
        """
        Check if the union tag is ``day_90``.

        :rtype: bool
        """
        return self._tag == 'day_90'

    def is_none(self):
        """
        Check if the union tag is ``none``.

        :rtype: bool
        """
        return self._tag == 'none'

    def is_year_1(self):
        """
        Check if the union tag is ``year_1``.

        :rtype: bool
        """
        return self._tag == 'year_1'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DefaultLinkExpirationDaysPolicy, self)._process_custom_annotations(annotation_type, field_path, processor)

DefaultLinkExpirationDaysPolicy_validator = bv.Union(DefaultLinkExpirationDaysPolicy)

class DeleteTeamInviteLinkDetails(bb.Struct):
    """
    Deleted team invite link.

    :ivar team_log.DeleteTeamInviteLinkDetails.link_url: The invite link url
        that was deleted.
    """

    __slots__ = [
        '_link_url_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 link_url=None):
        self._link_url_value = bb.NOT_SET
        if link_url is not None:
            self.link_url = link_url

    # Instance attribute type: str (validator is set below)
    link_url = bb.Attribute("link_url")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeleteTeamInviteLinkDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DeleteTeamInviteLinkDetails_validator = bv.Struct(DeleteTeamInviteLinkDetails)

class DeleteTeamInviteLinkType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeleteTeamInviteLinkType, self)._process_custom_annotations(annotation_type, field_path, processor)

DeleteTeamInviteLinkType_validator = bv.Struct(DeleteTeamInviteLinkType)

class DeviceSessionLogInfo(bb.Struct):
    """
    Device's session logged information.

    :ivar team_log.DeviceSessionLogInfo.ip_address: The IP address of the last
        activity from this session.
    :ivar team_log.DeviceSessionLogInfo.created: The time this session was
        created.
    :ivar team_log.DeviceSessionLogInfo.updated: The time of the last activity
        from this session.
    """

    __slots__ = [
        '_ip_address_value',
        '_created_value',
        '_updated_value',
    ]

    _has_required_fields = False

    def __init__(self,
                 ip_address=None,
                 created=None,
                 updated=None):
        self._ip_address_value = bb.NOT_SET
        self._created_value = bb.NOT_SET
        self._updated_value = bb.NOT_SET
        if ip_address is not None:
            self.ip_address = ip_address
        if created is not None:
            self.created = created
        if updated is not None:
            self.updated = updated

    # Instance attribute type: str (validator is set below)
    ip_address = bb.Attribute("ip_address", nullable=True)

    # Instance attribute type: datetime.datetime (validator is set below)
    created = bb.Attribute("created", nullable=True)

    # Instance attribute type: datetime.datetime (validator is set below)
    updated = bb.Attribute("updated", nullable=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceSessionLogInfo, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceSessionLogInfo_validator = bv.StructTree(DeviceSessionLogInfo)

class DesktopDeviceSessionLogInfo(DeviceSessionLogInfo):
    """
    Information about linked Dropbox desktop client sessions

    :ivar team_log.DesktopDeviceSessionLogInfo.session_info: Desktop session
        unique id.
    :ivar team_log.DesktopDeviceSessionLogInfo.host_name: Name of the hosting
        desktop.
    :ivar team_log.DesktopDeviceSessionLogInfo.client_type: The Dropbox desktop
        client type.
    :ivar team_log.DesktopDeviceSessionLogInfo.client_version: The Dropbox
        client version.
    :ivar team_log.DesktopDeviceSessionLogInfo.platform: Information on the
        hosting platform.
    :ivar team_log.DesktopDeviceSessionLogInfo.is_delete_on_unlink_supported:
        Whether itu2019s possible to delete all of the account files upon
        unlinking.
    """

    __slots__ = [
        '_session_info_value',
        '_host_name_value',
        '_client_type_value',
        '_client_version_value',
        '_platform_value',
        '_is_delete_on_unlink_supported_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 host_name=None,
                 client_type=None,
                 platform=None,
                 is_delete_on_unlink_supported=None,
                 ip_address=None,
                 created=None,
                 updated=None,
                 session_info=None,
                 client_version=None):
        super(DesktopDeviceSessionLogInfo, self).__init__(ip_address,
                                                          created,
                                                          updated)
        self._session_info_value = bb.NOT_SET
        self._host_name_value = bb.NOT_SET
        self._client_type_value = bb.NOT_SET
        self._client_version_value = bb.NOT_SET
        self._platform_value = bb.NOT_SET
        self._is_delete_on_unlink_supported_value = bb.NOT_SET
        if session_info is not None:
            self.session_info = session_info
        if host_name is not None:
            self.host_name = host_name
        if client_type is not None:
            self.client_type = client_type
        if client_version is not None:
            self.client_version = client_version
        if platform is not None:
            self.platform = platform
        if is_delete_on_unlink_supported is not None:
            self.is_delete_on_unlink_supported = is_delete_on_unlink_supported

    # Instance attribute type: DesktopSessionLogInfo (validator is set below)
    session_info = bb.Attribute("session_info", nullable=True, user_defined=True)

    # Instance attribute type: str (validator is set below)
    host_name = bb.Attribute("host_name")

    # Instance attribute type: team.DesktopPlatform (validator is set below)
    client_type = bb.Attribute("client_type", user_defined=True)

    # Instance attribute type: str (validator is set below)
    client_version = bb.Attribute("client_version", nullable=True)

    # Instance attribute type: str (validator is set below)
    platform = bb.Attribute("platform")

    # Instance attribute type: bool (validator is set below)
    is_delete_on_unlink_supported = bb.Attribute("is_delete_on_unlink_supported")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DesktopDeviceSessionLogInfo, self)._process_custom_annotations(annotation_type, field_path, processor)

DesktopDeviceSessionLogInfo_validator = bv.Struct(DesktopDeviceSessionLogInfo)

class SessionLogInfo(bb.Struct):
    """
    Session's logged information.

    :ivar team_log.SessionLogInfo.session_id: Session ID.
    """

    __slots__ = [
        '_session_id_value',
    ]

    _has_required_fields = False

    def __init__(self,
                 session_id=None):
        self._session_id_value = bb.NOT_SET
        if session_id is not None:
            self.session_id = session_id

    # Instance attribute type: str (validator is set below)
    session_id = bb.Attribute("session_id", nullable=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(SessionLogInfo, self)._process_custom_annotations(annotation_type, field_path, processor)

SessionLogInfo_validator = bv.StructTree(SessionLogInfo)

class DesktopSessionLogInfo(SessionLogInfo):
    """
    Desktop session.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self,
                 session_id=None):
        super(DesktopSessionLogInfo, self).__init__(session_id)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DesktopSessionLogInfo, self)._process_custom_annotations(annotation_type, field_path, processor)

DesktopSessionLogInfo_validator = bv.Struct(DesktopSessionLogInfo)

class DeviceApprovalsAddExceptionDetails(bb.Struct):
    """
    Added members to device approvals exception list.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceApprovalsAddExceptionDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceApprovalsAddExceptionDetails_validator = bv.Struct(DeviceApprovalsAddExceptionDetails)

class DeviceApprovalsAddExceptionType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceApprovalsAddExceptionType, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceApprovalsAddExceptionType_validator = bv.Struct(DeviceApprovalsAddExceptionType)

class DeviceApprovalsChangeDesktopPolicyDetails(bb.Struct):
    """
    Set/removed limit on number of computers member can link to team Dropbox
    account.

    :ivar team_log.DeviceApprovalsChangeDesktopPolicyDetails.new_value: New
        desktop device approvals policy. Might be missing due to historical data
        gap.
    :ivar team_log.DeviceApprovalsChangeDesktopPolicyDetails.previous_value:
        Previous desktop device approvals policy. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_previous_value_value',
    ]

    _has_required_fields = False

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = bb.NOT_SET
        self._previous_value_value = bb.NOT_SET
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    # Instance attribute type: DeviceApprovalsPolicy (validator is set below)
    new_value = bb.Attribute("new_value", nullable=True, user_defined=True)

    # Instance attribute type: DeviceApprovalsPolicy (validator is set below)
    previous_value = bb.Attribute("previous_value", nullable=True, user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceApprovalsChangeDesktopPolicyDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceApprovalsChangeDesktopPolicyDetails_validator = bv.Struct(DeviceApprovalsChangeDesktopPolicyDetails)

class DeviceApprovalsChangeDesktopPolicyType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceApprovalsChangeDesktopPolicyType, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceApprovalsChangeDesktopPolicyType_validator = bv.Struct(DeviceApprovalsChangeDesktopPolicyType)

class DeviceApprovalsChangeMobilePolicyDetails(bb.Struct):
    """
    Set/removed limit on number of mobile devices member can link to team
    Dropbox account.

    :ivar team_log.DeviceApprovalsChangeMobilePolicyDetails.new_value: New
        mobile device approvals policy. Might be missing due to historical data
        gap.
    :ivar team_log.DeviceApprovalsChangeMobilePolicyDetails.previous_value:
        Previous mobile device approvals policy. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_previous_value_value',
    ]

    _has_required_fields = False

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = bb.NOT_SET
        self._previous_value_value = bb.NOT_SET
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    # Instance attribute type: DeviceApprovalsPolicy (validator is set below)
    new_value = bb.Attribute("new_value", nullable=True, user_defined=True)

    # Instance attribute type: DeviceApprovalsPolicy (validator is set below)
    previous_value = bb.Attribute("previous_value", nullable=True, user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceApprovalsChangeMobilePolicyDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceApprovalsChangeMobilePolicyDetails_validator = bv.Struct(DeviceApprovalsChangeMobilePolicyDetails)

class DeviceApprovalsChangeMobilePolicyType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceApprovalsChangeMobilePolicyType, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceApprovalsChangeMobilePolicyType_validator = bv.Struct(DeviceApprovalsChangeMobilePolicyType)

class DeviceApprovalsChangeOverageActionDetails(bb.Struct):
    """
    Changed device approvals setting when member is over limit.

    :ivar team_log.DeviceApprovalsChangeOverageActionDetails.new_value: New over
        the limits policy. Might be missing due to historical data gap.
    :ivar team_log.DeviceApprovalsChangeOverageActionDetails.previous_value:
        Previous over the limit policy. Might be missing due to historical data
        gap.
    """

    __slots__ = [
        '_new_value_value',
        '_previous_value_value',
    ]

    _has_required_fields = False

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = bb.NOT_SET
        self._previous_value_value = bb.NOT_SET
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    # Instance attribute type: team_policies.RolloutMethod (validator is set below)
    new_value = bb.Attribute("new_value", nullable=True, user_defined=True)

    # Instance attribute type: team_policies.RolloutMethod (validator is set below)
    previous_value = bb.Attribute("previous_value", nullable=True, user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceApprovalsChangeOverageActionDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceApprovalsChangeOverageActionDetails_validator = bv.Struct(DeviceApprovalsChangeOverageActionDetails)

class DeviceApprovalsChangeOverageActionType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceApprovalsChangeOverageActionType, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceApprovalsChangeOverageActionType_validator = bv.Struct(DeviceApprovalsChangeOverageActionType)

class DeviceApprovalsChangeUnlinkActionDetails(bb.Struct):
    """
    Changed device approvals setting when member unlinks approved device.

    :ivar team_log.DeviceApprovalsChangeUnlinkActionDetails.new_value: New
        device unlink policy. Might be missing due to historical data gap.
    :ivar team_log.DeviceApprovalsChangeUnlinkActionDetails.previous_value:
        Previous device unlink policy. Might be missing due to historical data
        gap.
    """

    __slots__ = [
        '_new_value_value',
        '_previous_value_value',
    ]

    _has_required_fields = False

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = bb.NOT_SET
        self._previous_value_value = bb.NOT_SET
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    # Instance attribute type: DeviceUnlinkPolicy (validator is set below)
    new_value = bb.Attribute("new_value", nullable=True, user_defined=True)

    # Instance attribute type: DeviceUnlinkPolicy (validator is set below)
    previous_value = bb.Attribute("previous_value", nullable=True, user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceApprovalsChangeUnlinkActionDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceApprovalsChangeUnlinkActionDetails_validator = bv.Struct(DeviceApprovalsChangeUnlinkActionDetails)

class DeviceApprovalsChangeUnlinkActionType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceApprovalsChangeUnlinkActionType, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceApprovalsChangeUnlinkActionType_validator = bv.Struct(DeviceApprovalsChangeUnlinkActionType)

class DeviceApprovalsPolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    limited = None
    # Attribute is overwritten below the class definition
    unlimited = None
    # Attribute is overwritten below the class definition
    other = None

    def is_limited(self):
        """
        Check if the union tag is ``limited``.

        :rtype: bool
        """
        return self._tag == 'limited'

    def is_unlimited(self):
        """
        Check if the union tag is ``unlimited``.

        :rtype: bool
        """
        return self._tag == 'unlimited'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceApprovalsPolicy, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceApprovalsPolicy_validator = bv.Union(DeviceApprovalsPolicy)

class DeviceApprovalsRemoveExceptionDetails(bb.Struct):
    """
    Removed members from device approvals exception list.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceApprovalsRemoveExceptionDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceApprovalsRemoveExceptionDetails_validator = bv.Struct(DeviceApprovalsRemoveExceptionDetails)

class DeviceApprovalsRemoveExceptionType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceApprovalsRemoveExceptionType, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceApprovalsRemoveExceptionType_validator = bv.Struct(DeviceApprovalsRemoveExceptionType)

class DeviceChangeIpDesktopDetails(bb.Struct):
    """
    Changed IP address associated with active desktop session.

    :ivar team_log.DeviceChangeIpDesktopDetails.device_session_info: Device's
        session logged information.
    """

    __slots__ = [
        '_device_session_info_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 device_session_info=None):
        self._device_session_info_value = bb.NOT_SET
        if device_session_info is not None:
            self.device_session_info = device_session_info

    # Instance attribute type: DeviceSessionLogInfo (validator is set below)
    device_session_info = bb.Attribute("device_session_info", user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceChangeIpDesktopDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceChangeIpDesktopDetails_validator = bv.Struct(DeviceChangeIpDesktopDetails)

class DeviceChangeIpDesktopType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceChangeIpDesktopType, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceChangeIpDesktopType_validator = bv.Struct(DeviceChangeIpDesktopType)

class DeviceChangeIpMobileDetails(bb.Struct):
    """
    Changed IP address associated with active mobile session.

    :ivar team_log.DeviceChangeIpMobileDetails.device_session_info: Device's
        session logged information.
    """

    __slots__ = [
        '_device_session_info_value',
    ]

    _has_required_fields = False

    def __init__(self,
                 device_session_info=None):
        self._device_session_info_value = bb.NOT_SET
        if device_session_info is not None:
            self.device_session_info = device_session_info

    # Instance attribute type: DeviceSessionLogInfo (validator is set below)
    device_session_info = bb.Attribute("device_session_info", nullable=True, user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceChangeIpMobileDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceChangeIpMobileDetails_validator = bv.Struct(DeviceChangeIpMobileDetails)

class DeviceChangeIpMobileType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceChangeIpMobileType, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceChangeIpMobileType_validator = bv.Struct(DeviceChangeIpMobileType)

class DeviceChangeIpWebDetails(bb.Struct):
    """
    Changed IP address associated with active web session.

    :ivar team_log.DeviceChangeIpWebDetails.user_agent: Web browser name.
    """

    __slots__ = [
        '_user_agent_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 user_agent=None):
        self._user_agent_value = bb.NOT_SET
        if user_agent is not None:
            self.user_agent = user_agent

    # Instance attribute type: str (validator is set below)
    user_agent = bb.Attribute("user_agent")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceChangeIpWebDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceChangeIpWebDetails_validator = bv.Struct(DeviceChangeIpWebDetails)

class DeviceChangeIpWebType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceChangeIpWebType, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceChangeIpWebType_validator = bv.Struct(DeviceChangeIpWebType)

class DeviceDeleteOnUnlinkFailDetails(bb.Struct):
    """
    Failed to delete all files from unlinked device.

    :ivar team_log.DeviceDeleteOnUnlinkFailDetails.session_info: Session unique
        id.
    :ivar team_log.DeviceDeleteOnUnlinkFailDetails.display_name: The device
        name. Might be missing due to historical data gap.
    :ivar team_log.DeviceDeleteOnUnlinkFailDetails.num_failures: The number of
        times that remote file deletion failed.
    """

    __slots__ = [
        '_session_info_value',
        '_display_name_value',
        '_num_failures_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 num_failures=None,
                 session_info=None,
                 display_name=None):
        self._session_info_value = bb.NOT_SET
        self._display_name_value = bb.NOT_SET
        self._num_failures_value = bb.NOT_SET
        if session_info is not None:
            self.session_info = session_info
        if display_name is not None:
            self.display_name = display_name
        if num_failures is not None:
            self.num_failures = num_failures

    # Instance attribute type: SessionLogInfo (validator is set below)
    session_info = bb.Attribute("session_info", nullable=True, user_defined=True)

    # Instance attribute type: str (validator is set below)
    display_name = bb.Attribute("display_name", nullable=True)

    # Instance attribute type: int (validator is set below)
    num_failures = bb.Attribute("num_failures")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceDeleteOnUnlinkFailDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceDeleteOnUnlinkFailDetails_validator = bv.Struct(DeviceDeleteOnUnlinkFailDetails)

class DeviceDeleteOnUnlinkFailType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceDeleteOnUnlinkFailType, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceDeleteOnUnlinkFailType_validator = bv.Struct(DeviceDeleteOnUnlinkFailType)

class DeviceDeleteOnUnlinkSuccessDetails(bb.Struct):
    """
    Deleted all files from unlinked device.

    :ivar team_log.DeviceDeleteOnUnlinkSuccessDetails.session_info: Session
        unique id.
    :ivar team_log.DeviceDeleteOnUnlinkSuccessDetails.display_name: The device
        name. Might be missing due to historical data gap.
    """

    __slots__ = [
        '_session_info_value',
        '_display_name_value',
    ]

    _has_required_fields = False

    def __init__(self,
                 session_info=None,
                 display_name=None):
        self._session_info_value = bb.NOT_SET
        self._display_name_value = bb.NOT_SET
        if session_info is not None:
            self.session_info = session_info
        if display_name is not None:
            self.display_name = display_name

    # Instance attribute type: SessionLogInfo (validator is set below)
    session_info = bb.Attribute("session_info", nullable=True, user_defined=True)

    # Instance attribute type: str (validator is set below)
    display_name = bb.Attribute("display_name", nullable=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceDeleteOnUnlinkSuccessDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceDeleteOnUnlinkSuccessDetails_validator = bv.Struct(DeviceDeleteOnUnlinkSuccessDetails)

class DeviceDeleteOnUnlinkSuccessType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceDeleteOnUnlinkSuccessType, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceDeleteOnUnlinkSuccessType_validator = bv.Struct(DeviceDeleteOnUnlinkSuccessType)

class DeviceLinkFailDetails(bb.Struct):
    """
    Failed to link device.

    :ivar team_log.DeviceLinkFailDetails.ip_address: IP address. Might be
        missing due to historical data gap.
    :ivar team_log.DeviceLinkFailDetails.device_type: A description of the
        device used while user approval blocked.
    """

    __slots__ = [
        '_ip_address_value',
        '_device_type_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 device_type=None,
                 ip_address=None):
        self._ip_address_value = bb.NOT_SET
        self._device_type_value = bb.NOT_SET
        if ip_address is not None:
            self.ip_address = ip_address
        if device_type is not None:
            self.device_type = device_type

    # Instance attribute type: str (validator is set below)
    ip_address = bb.Attribute("ip_address", nullable=True)

    # Instance attribute type: DeviceType (validator is set below)
    device_type = bb.Attribute("device_type", user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceLinkFailDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceLinkFailDetails_validator = bv.Struct(DeviceLinkFailDetails)

class DeviceLinkFailType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceLinkFailType, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceLinkFailType_validator = bv.Struct(DeviceLinkFailType)

class DeviceLinkSuccessDetails(bb.Struct):
    """
    Linked device.

    :ivar team_log.DeviceLinkSuccessDetails.device_session_info: Device's
        session logged information.
    """

    __slots__ = [
        '_device_session_info_value',
    ]

    _has_required_fields = False

    def __init__(self,
                 device_session_info=None):
        self._device_session_info_value = bb.NOT_SET
        if device_session_info is not None:
            self.device_session_info = device_session_info

    # Instance attribute type: DeviceSessionLogInfo (validator is set below)
    device_session_info = bb.Attribute("device_session_info", nullable=True, user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceLinkSuccessDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceLinkSuccessDetails_validator = bv.Struct(DeviceLinkSuccessDetails)

class DeviceLinkSuccessType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceLinkSuccessType, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceLinkSuccessType_validator = bv.Struct(DeviceLinkSuccessType)

class DeviceManagementDisabledDetails(bb.Struct):
    """
    Disabled device management.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceManagementDisabledDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceManagementDisabledDetails_validator = bv.Struct(DeviceManagementDisabledDetails)

class DeviceManagementDisabledType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceManagementDisabledType, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceManagementDisabledType_validator = bv.Struct(DeviceManagementDisabledType)

class DeviceManagementEnabledDetails(bb.Struct):
    """
    Enabled device management.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceManagementEnabledDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceManagementEnabledDetails_validator = bv.Struct(DeviceManagementEnabledDetails)

class DeviceManagementEnabledType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceManagementEnabledType, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceManagementEnabledType_validator = bv.Struct(DeviceManagementEnabledType)

class DeviceSyncBackupStatusChangedDetails(bb.Struct):
    """
    Enabled/disabled backup for computer.

    :ivar
        team_log.DeviceSyncBackupStatusChangedDetails.desktop_device_session_info:
        Device's session logged information.
    :ivar team_log.DeviceSyncBackupStatusChangedDetails.previous_value: Previous
        status of computer backup on the device.
    :ivar team_log.DeviceSyncBackupStatusChangedDetails.new_value: Next status
        of computer backup on the device.
    """

    __slots__ = [
        '_desktop_device_session_info_value',
        '_previous_value_value',
        '_new_value_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 desktop_device_session_info=None,
                 previous_value=None,
                 new_value=None):
        self._desktop_device_session_info_value = bb.NOT_SET
        self._previous_value_value = bb.NOT_SET
        self._new_value_value = bb.NOT_SET
        if desktop_device_session_info is not None:
            self.desktop_device_session_info = desktop_device_session_info
        if previous_value is not None:
            self.previous_value = previous_value
        if new_value is not None:
            self.new_value = new_value

    # Instance attribute type: DesktopDeviceSessionLogInfo (validator is set below)
    desktop_device_session_info = bb.Attribute("desktop_device_session_info", user_defined=True)

    # Instance attribute type: BackupStatus (validator is set below)
    previous_value = bb.Attribute("previous_value", user_defined=True)

    # Instance attribute type: BackupStatus (validator is set below)
    new_value = bb.Attribute("new_value", user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceSyncBackupStatusChangedDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceSyncBackupStatusChangedDetails_validator = bv.Struct(DeviceSyncBackupStatusChangedDetails)

class DeviceSyncBackupStatusChangedType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceSyncBackupStatusChangedType, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceSyncBackupStatusChangedType_validator = bv.Struct(DeviceSyncBackupStatusChangedType)

class DeviceType(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    desktop = None
    # Attribute is overwritten below the class definition
    mobile = None
    # Attribute is overwritten below the class definition
    other = None

    def is_desktop(self):
        """
        Check if the union tag is ``desktop``.

        :rtype: bool
        """
        return self._tag == 'desktop'

    def is_mobile(self):
        """
        Check if the union tag is ``mobile``.

        :rtype: bool
        """
        return self._tag == 'mobile'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceType, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceType_validator = bv.Union(DeviceType)

class DeviceUnlinkDetails(bb.Struct):
    """
    Disconnected device.

    :ivar team_log.DeviceUnlinkDetails.session_info: Session unique id.
    :ivar team_log.DeviceUnlinkDetails.display_name: The device name. Might be
        missing due to historical data gap.
    :ivar team_log.DeviceUnlinkDetails.delete_data: True if the user requested
        to delete data after device unlink, false otherwise.
    """

    __slots__ = [
        '_session_info_value',
        '_display_name_value',
        '_delete_data_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 delete_data=None,
                 session_info=None,
                 display_name=None):
        self._session_info_value = bb.NOT_SET
        self._display_name_value = bb.NOT_SET
        self._delete_data_value = bb.NOT_SET
        if session_info is not None:
            self.session_info = session_info
        if display_name is not None:
            self.display_name = display_name
        if delete_data is not None:
            self.delete_data = delete_data

    # Instance attribute type: SessionLogInfo (validator is set below)
    session_info = bb.Attribute("session_info", nullable=True, user_defined=True)

    # Instance attribute type: str (validator is set below)
    display_name = bb.Attribute("display_name", nullable=True)

    # Instance attribute type: bool (validator is set below)
    delete_data = bb.Attribute("delete_data")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceUnlinkDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceUnlinkDetails_validator = bv.Struct(DeviceUnlinkDetails)

class DeviceUnlinkPolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    keep = None
    # Attribute is overwritten below the class definition
    remove = None
    # Attribute is overwritten below the class definition
    other = None

    def is_keep(self):
        """
        Check if the union tag is ``keep``.

        :rtype: bool
        """
        return self._tag == 'keep'

    def is_remove(self):
        """
        Check if the union tag is ``remove``.

        :rtype: bool
        """
        return self._tag == 'remove'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceUnlinkPolicy, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceUnlinkPolicy_validator = bv.Union(DeviceUnlinkPolicy)

class DeviceUnlinkType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DeviceUnlinkType, self)._process_custom_annotations(annotation_type, field_path, processor)

DeviceUnlinkType_validator = bv.Struct(DeviceUnlinkType)

class DirectoryRestrictionsAddMembersDetails(bb.Struct):
    """
    Added members to directory restrictions list.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DirectoryRestrictionsAddMembersDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DirectoryRestrictionsAddMembersDetails_validator = bv.Struct(DirectoryRestrictionsAddMembersDetails)

class DirectoryRestrictionsAddMembersType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DirectoryRestrictionsAddMembersType, self)._process_custom_annotations(annotation_type, field_path, processor)

DirectoryRestrictionsAddMembersType_validator = bv.Struct(DirectoryRestrictionsAddMembersType)

class DirectoryRestrictionsRemoveMembersDetails(bb.Struct):
    """
    Removed members from directory restrictions list.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DirectoryRestrictionsRemoveMembersDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DirectoryRestrictionsRemoveMembersDetails_validator = bv.Struct(DirectoryRestrictionsRemoveMembersDetails)

class DirectoryRestrictionsRemoveMembersType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DirectoryRestrictionsRemoveMembersType, self)._process_custom_annotations(annotation_type, field_path, processor)

DirectoryRestrictionsRemoveMembersType_validator = bv.Struct(DirectoryRestrictionsRemoveMembersType)

class DisabledDomainInvitesDetails(bb.Struct):
    """
    Disabled domain invites.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DisabledDomainInvitesDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DisabledDomainInvitesDetails_validator = bv.Struct(DisabledDomainInvitesDetails)

class DisabledDomainInvitesType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DisabledDomainInvitesType, self)._process_custom_annotations(annotation_type, field_path, processor)

DisabledDomainInvitesType_validator = bv.Struct(DisabledDomainInvitesType)

class DispositionActionType(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    automatic_delete = None
    # Attribute is overwritten below the class definition
    automatic_permanently_delete = None
    # Attribute is overwritten below the class definition
    other = None

    def is_automatic_delete(self):
        """
        Check if the union tag is ``automatic_delete``.

        :rtype: bool
        """
        return self._tag == 'automatic_delete'

    def is_automatic_permanently_delete(self):
        """
        Check if the union tag is ``automatic_permanently_delete``.

        :rtype: bool
        """
        return self._tag == 'automatic_permanently_delete'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DispositionActionType, self)._process_custom_annotations(annotation_type, field_path, processor)

DispositionActionType_validator = bv.Union(DispositionActionType)

class DomainInvitesApproveRequestToJoinTeamDetails(bb.Struct):
    """
    Approved user's request to join team.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DomainInvitesApproveRequestToJoinTeamDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DomainInvitesApproveRequestToJoinTeamDetails_validator = bv.Struct(DomainInvitesApproveRequestToJoinTeamDetails)

class DomainInvitesApproveRequestToJoinTeamType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DomainInvitesApproveRequestToJoinTeamType, self)._process_custom_annotations(annotation_type, field_path, processor)

DomainInvitesApproveRequestToJoinTeamType_validator = bv.Struct(DomainInvitesApproveRequestToJoinTeamType)

class DomainInvitesDeclineRequestToJoinTeamDetails(bb.Struct):
    """
    Declined user's request to join team.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DomainInvitesDeclineRequestToJoinTeamDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DomainInvitesDeclineRequestToJoinTeamDetails_validator = bv.Struct(DomainInvitesDeclineRequestToJoinTeamDetails)

class DomainInvitesDeclineRequestToJoinTeamType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DomainInvitesDeclineRequestToJoinTeamType, self)._process_custom_annotations(annotation_type, field_path, processor)

DomainInvitesDeclineRequestToJoinTeamType_validator = bv.Struct(DomainInvitesDeclineRequestToJoinTeamType)

class DomainInvitesEmailExistingUsersDetails(bb.Struct):
    """
    Sent domain invites to existing domain accounts.

    :ivar team_log.DomainInvitesEmailExistingUsersDetails.domain_name: Domain
        names.
    :ivar team_log.DomainInvitesEmailExistingUsersDetails.num_recipients: Number
        of recipients.
    """

    __slots__ = [
        '_domain_name_value',
        '_num_recipients_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 domain_name=None,
                 num_recipients=None):
        self._domain_name_value = bb.NOT_SET
        self._num_recipients_value = bb.NOT_SET
        if domain_name is not None:
            self.domain_name = domain_name
        if num_recipients is not None:
            self.num_recipients = num_recipients

    # Instance attribute type: str (validator is set below)
    domain_name = bb.Attribute("domain_name")

    # Instance attribute type: int (validator is set below)
    num_recipients = bb.Attribute("num_recipients")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DomainInvitesEmailExistingUsersDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DomainInvitesEmailExistingUsersDetails_validator = bv.Struct(DomainInvitesEmailExistingUsersDetails)

class DomainInvitesEmailExistingUsersType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DomainInvitesEmailExistingUsersType, self)._process_custom_annotations(annotation_type, field_path, processor)

DomainInvitesEmailExistingUsersType_validator = bv.Struct(DomainInvitesEmailExistingUsersType)

class DomainInvitesRequestToJoinTeamDetails(bb.Struct):
    """
    Requested to join team.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DomainInvitesRequestToJoinTeamDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DomainInvitesRequestToJoinTeamDetails_validator = bv.Struct(DomainInvitesRequestToJoinTeamDetails)

class DomainInvitesRequestToJoinTeamType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DomainInvitesRequestToJoinTeamType, self)._process_custom_annotations(annotation_type, field_path, processor)

DomainInvitesRequestToJoinTeamType_validator = bv.Struct(DomainInvitesRequestToJoinTeamType)

class DomainInvitesSetInviteNewUserPrefToNoDetails(bb.Struct):
    """
    Disabled "Automatically invite new users".
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DomainInvitesSetInviteNewUserPrefToNoDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DomainInvitesSetInviteNewUserPrefToNoDetails_validator = bv.Struct(DomainInvitesSetInviteNewUserPrefToNoDetails)

class DomainInvitesSetInviteNewUserPrefToNoType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DomainInvitesSetInviteNewUserPrefToNoType, self)._process_custom_annotations(annotation_type, field_path, processor)

DomainInvitesSetInviteNewUserPrefToNoType_validator = bv.Struct(DomainInvitesSetInviteNewUserPrefToNoType)

class DomainInvitesSetInviteNewUserPrefToYesDetails(bb.Struct):
    """
    Enabled "Automatically invite new users".
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DomainInvitesSetInviteNewUserPrefToYesDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DomainInvitesSetInviteNewUserPrefToYesDetails_validator = bv.Struct(DomainInvitesSetInviteNewUserPrefToYesDetails)

class DomainInvitesSetInviteNewUserPrefToYesType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DomainInvitesSetInviteNewUserPrefToYesType, self)._process_custom_annotations(annotation_type, field_path, processor)

DomainInvitesSetInviteNewUserPrefToYesType_validator = bv.Struct(DomainInvitesSetInviteNewUserPrefToYesType)

class DomainVerificationAddDomainFailDetails(bb.Struct):
    """
    Failed to verify team domain.

    :ivar team_log.DomainVerificationAddDomainFailDetails.domain_name: Domain
        name.
    :ivar team_log.DomainVerificationAddDomainFailDetails.verification_method:
        Domain name verification method. Might be missing due to historical data
        gap.
    """

    __slots__ = [
        '_domain_name_value',
        '_verification_method_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 domain_name=None,
                 verification_method=None):
        self._domain_name_value = bb.NOT_SET
        self._verification_method_value = bb.NOT_SET
        if domain_name is not None:
            self.domain_name = domain_name
        if verification_method is not None:
            self.verification_method = verification_method

    # Instance attribute type: str (validator is set below)
    domain_name = bb.Attribute("domain_name")

    # Instance attribute type: str (validator is set below)
    verification_method = bb.Attribute("verification_method", nullable=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DomainVerificationAddDomainFailDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DomainVerificationAddDomainFailDetails_validator = bv.Struct(DomainVerificationAddDomainFailDetails)

class DomainVerificationAddDomainFailType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DomainVerificationAddDomainFailType, self)._process_custom_annotations(annotation_type, field_path, processor)

DomainVerificationAddDomainFailType_validator = bv.Struct(DomainVerificationAddDomainFailType)

class DomainVerificationAddDomainSuccessDetails(bb.Struct):
    """
    Verified team domain.

    :ivar team_log.DomainVerificationAddDomainSuccessDetails.domain_names:
        Domain names.
    :ivar
        team_log.DomainVerificationAddDomainSuccessDetails.verification_method:
        Domain name verification method. Might be missing due to historical data
        gap.
    """

    __slots__ = [
        '_domain_names_value',
        '_verification_method_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 domain_names=None,
                 verification_method=None):
        self._domain_names_value = bb.NOT_SET
        self._verification_method_value = bb.NOT_SET
        if domain_names is not None:
            self.domain_names = domain_names
        if verification_method is not None:
            self.verification_method = verification_method

    # Instance attribute type: list of [str] (validator is set below)
    domain_names = bb.Attribute("domain_names")

    # Instance attribute type: str (validator is set below)
    verification_method = bb.Attribute("verification_method", nullable=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DomainVerificationAddDomainSuccessDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DomainVerificationAddDomainSuccessDetails_validator = bv.Struct(DomainVerificationAddDomainSuccessDetails)

class DomainVerificationAddDomainSuccessType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DomainVerificationAddDomainSuccessType, self)._process_custom_annotations(annotation_type, field_path, processor)

DomainVerificationAddDomainSuccessType_validator = bv.Struct(DomainVerificationAddDomainSuccessType)

class DomainVerificationRemoveDomainDetails(bb.Struct):
    """
    Removed domain from list of verified team domains.

    :ivar team_log.DomainVerificationRemoveDomainDetails.domain_names: Domain
        names.
    """

    __slots__ = [
        '_domain_names_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 domain_names=None):
        self._domain_names_value = bb.NOT_SET
        if domain_names is not None:
            self.domain_names = domain_names

    # Instance attribute type: list of [str] (validator is set below)
    domain_names = bb.Attribute("domain_names")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DomainVerificationRemoveDomainDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DomainVerificationRemoveDomainDetails_validator = bv.Struct(DomainVerificationRemoveDomainDetails)

class DomainVerificationRemoveDomainType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DomainVerificationRemoveDomainType, self)._process_custom_annotations(annotation_type, field_path, processor)

DomainVerificationRemoveDomainType_validator = bv.Struct(DomainVerificationRemoveDomainType)

class DownloadPolicyType(bb.Union):
    """
    Shared content downloads policy

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    allow = None
    # Attribute is overwritten below the class definition
    disallow = None
    # Attribute is overwritten below the class definition
    other = None

    def is_allow(self):
        """
        Check if the union tag is ``allow``.

        :rtype: bool
        """
        return self._tag == 'allow'

    def is_disallow(self):
        """
        Check if the union tag is ``disallow``.

        :rtype: bool
        """
        return self._tag == 'disallow'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DownloadPolicyType, self)._process_custom_annotations(annotation_type, field_path, processor)

DownloadPolicyType_validator = bv.Union(DownloadPolicyType)

class DropboxPasswordsExportedDetails(bb.Struct):
    """
    Exported passwords.

    :ivar team_log.DropboxPasswordsExportedDetails.platform: The platform the
        device runs export.
    """

    __slots__ = [
        '_platform_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 platform=None):
        self._platform_value = bb.NOT_SET
        if platform is not None:
            self.platform = platform

    # Instance attribute type: str (validator is set below)
    platform = bb.Attribute("platform")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DropboxPasswordsExportedDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DropboxPasswordsExportedDetails_validator = bv.Struct(DropboxPasswordsExportedDetails)

class DropboxPasswordsExportedType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DropboxPasswordsExportedType, self)._process_custom_annotations(annotation_type, field_path, processor)

DropboxPasswordsExportedType_validator = bv.Struct(DropboxPasswordsExportedType)

class DropboxPasswordsNewDeviceEnrolledDetails(bb.Struct):
    """
    Enrolled new Dropbox Passwords device.

    :ivar team_log.DropboxPasswordsNewDeviceEnrolledDetails.is_first_device:
        Whether it's a first device enrolled.
    :ivar team_log.DropboxPasswordsNewDeviceEnrolledDetails.platform: The
        platform the device is enrolled.
    """

    __slots__ = [
        '_is_first_device_value',
        '_platform_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 is_first_device=None,
                 platform=None):
        self._is_first_device_value = bb.NOT_SET
        self._platform_value = bb.NOT_SET
        if is_first_device is not None:
            self.is_first_device = is_first_device
        if platform is not None:
            self.platform = platform

    # Instance attribute type: bool (validator is set below)
    is_first_device = bb.Attribute("is_first_device")

    # Instance attribute type: str (validator is set below)
    platform = bb.Attribute("platform")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DropboxPasswordsNewDeviceEnrolledDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

DropboxPasswordsNewDeviceEnrolledDetails_validator = bv.Struct(DropboxPasswordsNewDeviceEnrolledDetails)

class DropboxPasswordsNewDeviceEnrolledType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DropboxPasswordsNewDeviceEnrolledType, self)._process_custom_annotations(annotation_type, field_path, processor)

DropboxPasswordsNewDeviceEnrolledType_validator = bv.Struct(DropboxPasswordsNewDeviceEnrolledType)

class DurationLogInfo(bb.Struct):
    """
    Represents a time duration: unit and amount

    :ivar team_log.DurationLogInfo.unit: Time unit.
    :ivar team_log.DurationLogInfo.amount: Amount of time.
    """

    __slots__ = [
        '_unit_value',
        '_amount_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 unit=None,
                 amount=None):
        self._unit_value = bb.NOT_SET
        self._amount_value = bb.NOT_SET
        if unit is not None:
            self.unit = unit
        if amount is not None:
            self.amount = amount

    # Instance attribute type: TimeUnit (validator is set below)
    unit = bb.Attribute("unit", user_defined=True)

    # Instance attribute type: int (validator is set below)
    amount = bb.Attribute("amount")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(DurationLogInfo, self)._process_custom_annotations(annotation_type, field_path, processor)

DurationLogInfo_validator = bv.Struct(DurationLogInfo)

class EmailIngestPolicy(bb.Union):
    """
    Policy for deciding whether a team can use Email to my Dropbox feature

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    disabled = None
    # Attribute is overwritten below the class definition
    enabled = None
    # Attribute is overwritten below the class definition
    other = None

    def is_disabled(self):
        """
        Check if the union tag is ``disabled``.

        :rtype: bool
        """
        return self._tag == 'disabled'

    def is_enabled(self):
        """
        Check if the union tag is ``enabled``.

        :rtype: bool
        """
        return self._tag == 'enabled'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EmailIngestPolicy, self)._process_custom_annotations(annotation_type, field_path, processor)

EmailIngestPolicy_validator = bv.Union(EmailIngestPolicy)

class EmailIngestPolicyChangedDetails(bb.Struct):
    """
    Changed email to my Dropbox policy for team.

    :ivar team_log.EmailIngestPolicyChangedDetails.new_value: To.
    :ivar team_log.EmailIngestPolicyChangedDetails.previous_value: From.
    """

    __slots__ = [
        '_new_value_value',
        '_previous_value_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = bb.NOT_SET
        self._previous_value_value = bb.NOT_SET
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    # Instance attribute type: EmailIngestPolicy (validator is set below)
    new_value = bb.Attribute("new_value", user_defined=True)

    # Instance attribute type: EmailIngestPolicy (validator is set below)
    previous_value = bb.Attribute("previous_value", user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EmailIngestPolicyChangedDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

EmailIngestPolicyChangedDetails_validator = bv.Struct(EmailIngestPolicyChangedDetails)

class EmailIngestPolicyChangedType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EmailIngestPolicyChangedType, self)._process_custom_annotations(annotation_type, field_path, processor)

EmailIngestPolicyChangedType_validator = bv.Struct(EmailIngestPolicyChangedType)

class EmailIngestReceiveFileDetails(bb.Struct):
    """
    Received files via Email to my Dropbox.

    :ivar team_log.EmailIngestReceiveFileDetails.inbox_name: Inbox name.
    :ivar team_log.EmailIngestReceiveFileDetails.attachment_names: Submitted
        file names.
    :ivar team_log.EmailIngestReceiveFileDetails.subject: Subject of the email.
    :ivar team_log.EmailIngestReceiveFileDetails.from_name: The name as provided
        by the submitter.
    :ivar team_log.EmailIngestReceiveFileDetails.from_email: The email as
        provided by the submitter.
    """

    __slots__ = [
        '_inbox_name_value',
        '_attachment_names_value',
        '_subject_value',
        '_from_name_value',
        '_from_email_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 inbox_name=None,
                 attachment_names=None,
                 subject=None,
                 from_name=None,
                 from_email=None):
        self._inbox_name_value = bb.NOT_SET
        self._attachment_names_value = bb.NOT_SET
        self._subject_value = bb.NOT_SET
        self._from_name_value = bb.NOT_SET
        self._from_email_value = bb.NOT_SET
        if inbox_name is not None:
            self.inbox_name = inbox_name
        if attachment_names is not None:
            self.attachment_names = attachment_names
        if subject is not None:
            self.subject = subject
        if from_name is not None:
            self.from_name = from_name
        if from_email is not None:
            self.from_email = from_email

    # Instance attribute type: str (validator is set below)
    inbox_name = bb.Attribute("inbox_name")

    # Instance attribute type: list of [str] (validator is set below)
    attachment_names = bb.Attribute("attachment_names")

    # Instance attribute type: str (validator is set below)
    subject = bb.Attribute("subject", nullable=True)

    # Instance attribute type: str (validator is set below)
    from_name = bb.Attribute("from_name", nullable=True)

    # Instance attribute type: str (validator is set below)
    from_email = bb.Attribute("from_email", nullable=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EmailIngestReceiveFileDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

EmailIngestReceiveFileDetails_validator = bv.Struct(EmailIngestReceiveFileDetails)

class EmailIngestReceiveFileType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EmailIngestReceiveFileType, self)._process_custom_annotations(annotation_type, field_path, processor)

EmailIngestReceiveFileType_validator = bv.Struct(EmailIngestReceiveFileType)

class EmmAddExceptionDetails(bb.Struct):
    """
    Added members to EMM exception list.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EmmAddExceptionDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

EmmAddExceptionDetails_validator = bv.Struct(EmmAddExceptionDetails)

class EmmAddExceptionType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EmmAddExceptionType, self)._process_custom_annotations(annotation_type, field_path, processor)

EmmAddExceptionType_validator = bv.Struct(EmmAddExceptionType)

class EmmChangePolicyDetails(bb.Struct):
    """
    Enabled/disabled enterprise mobility management for members.

    :ivar team_log.EmmChangePolicyDetails.new_value: New enterprise mobility
        management policy.
    :ivar team_log.EmmChangePolicyDetails.previous_value: Previous enterprise
        mobility management policy. Might be missing due to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_previous_value_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = bb.NOT_SET
        self._previous_value_value = bb.NOT_SET
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    # Instance attribute type: team_policies.EmmState (validator is set below)
    new_value = bb.Attribute("new_value", user_defined=True)

    # Instance attribute type: team_policies.EmmState (validator is set below)
    previous_value = bb.Attribute("previous_value", nullable=True, user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EmmChangePolicyDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

EmmChangePolicyDetails_validator = bv.Struct(EmmChangePolicyDetails)

class EmmChangePolicyType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EmmChangePolicyType, self)._process_custom_annotations(annotation_type, field_path, processor)

EmmChangePolicyType_validator = bv.Struct(EmmChangePolicyType)

class EmmCreateExceptionsReportDetails(bb.Struct):
    """
    Created EMM-excluded users report.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EmmCreateExceptionsReportDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

EmmCreateExceptionsReportDetails_validator = bv.Struct(EmmCreateExceptionsReportDetails)

class EmmCreateExceptionsReportType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EmmCreateExceptionsReportType, self)._process_custom_annotations(annotation_type, field_path, processor)

EmmCreateExceptionsReportType_validator = bv.Struct(EmmCreateExceptionsReportType)

class EmmCreateUsageReportDetails(bb.Struct):
    """
    Created EMM mobile app usage report.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EmmCreateUsageReportDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

EmmCreateUsageReportDetails_validator = bv.Struct(EmmCreateUsageReportDetails)

class EmmCreateUsageReportType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EmmCreateUsageReportType, self)._process_custom_annotations(annotation_type, field_path, processor)

EmmCreateUsageReportType_validator = bv.Struct(EmmCreateUsageReportType)

class EmmErrorDetails(bb.Struct):
    """
    Failed to sign in via EMM.

    :ivar team_log.EmmErrorDetails.error_details: Error details.
    """

    __slots__ = [
        '_error_details_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 error_details=None):
        self._error_details_value = bb.NOT_SET
        if error_details is not None:
            self.error_details = error_details

    # Instance attribute type: FailureDetailsLogInfo (validator is set below)
    error_details = bb.Attribute("error_details", user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EmmErrorDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

EmmErrorDetails_validator = bv.Struct(EmmErrorDetails)

class EmmErrorType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EmmErrorType, self)._process_custom_annotations(annotation_type, field_path, processor)

EmmErrorType_validator = bv.Struct(EmmErrorType)

class EmmRefreshAuthTokenDetails(bb.Struct):
    """
    Refreshed auth token used for setting up EMM.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EmmRefreshAuthTokenDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

EmmRefreshAuthTokenDetails_validator = bv.Struct(EmmRefreshAuthTokenDetails)

class EmmRefreshAuthTokenType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EmmRefreshAuthTokenType, self)._process_custom_annotations(annotation_type, field_path, processor)

EmmRefreshAuthTokenType_validator = bv.Struct(EmmRefreshAuthTokenType)

class EmmRemoveExceptionDetails(bb.Struct):
    """
    Removed members from EMM exception list.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EmmRemoveExceptionDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

EmmRemoveExceptionDetails_validator = bv.Struct(EmmRemoveExceptionDetails)

class EmmRemoveExceptionType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EmmRemoveExceptionType, self)._process_custom_annotations(annotation_type, field_path, processor)

EmmRemoveExceptionType_validator = bv.Struct(EmmRemoveExceptionType)

class EnabledDomainInvitesDetails(bb.Struct):
    """
    Enabled domain invites.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EnabledDomainInvitesDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

EnabledDomainInvitesDetails_validator = bv.Struct(EnabledDomainInvitesDetails)

class EnabledDomainInvitesType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EnabledDomainInvitesType, self)._process_custom_annotations(annotation_type, field_path, processor)

EnabledDomainInvitesType_validator = bv.Struct(EnabledDomainInvitesType)

class EndedEnterpriseAdminSessionDeprecatedDetails(bb.Struct):
    """
    Ended enterprise admin session.

    :ivar
        team_log.EndedEnterpriseAdminSessionDeprecatedDetails.federation_extra_details:
        More information about the organization or team.
    """

    __slots__ = [
        '_federation_extra_details_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 federation_extra_details=None):
        self._federation_extra_details_value = bb.NOT_SET
        if federation_extra_details is not None:
            self.federation_extra_details = federation_extra_details

    # Instance attribute type: FedExtraDetails (validator is set below)
    federation_extra_details = bb.Attribute("federation_extra_details", user_defined=True)

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EndedEnterpriseAdminSessionDeprecatedDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

EndedEnterpriseAdminSessionDeprecatedDetails_validator = bv.Struct(EndedEnterpriseAdminSessionDeprecatedDetails)

class EndedEnterpriseAdminSessionDeprecatedType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EndedEnterpriseAdminSessionDeprecatedType, self)._process_custom_annotations(annotation_type, field_path, processor)

EndedEnterpriseAdminSessionDeprecatedType_validator = bv.Struct(EndedEnterpriseAdminSessionDeprecatedType)

class EndedEnterpriseAdminSessionDetails(bb.Struct):
    """
    Ended enterprise admin session.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EndedEnterpriseAdminSessionDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

EndedEnterpriseAdminSessionDetails_validator = bv.Struct(EndedEnterpriseAdminSessionDetails)

class EndedEnterpriseAdminSessionType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EndedEnterpriseAdminSessionType, self)._process_custom_annotations(annotation_type, field_path, processor)

EndedEnterpriseAdminSessionType_validator = bv.Struct(EndedEnterpriseAdminSessionType)

class EnforceLinkPasswordPolicy(bb.Union):
    """
    Policy for deciding whether password must be enforced when an externally
    shared link is updated

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    optional = None
    # Attribute is overwritten below the class definition
    required = None
    # Attribute is overwritten below the class definition
    other = None

    def is_optional(self):
        """
        Check if the union tag is ``optional``.

        :rtype: bool
        """
        return self._tag == 'optional'

    def is_required(self):
        """
        Check if the union tag is ``required``.

        :rtype: bool
        """
        return self._tag == 'required'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EnforceLinkPasswordPolicy, self)._process_custom_annotations(annotation_type, field_path, processor)

EnforceLinkPasswordPolicy_validator = bv.Union(EnforceLinkPasswordPolicy)

class EnterpriseSettingsLockingDetails(bb.Struct):
    """
    Changed who can update a setting.

    :ivar team_log.EnterpriseSettingsLockingDetails.team_name: The secondary
        team name.
    :ivar team_log.EnterpriseSettingsLockingDetails.settings_page_name: Settings
        page name.
    :ivar
        team_log.EnterpriseSettingsLockingDetails.previous_settings_page_locking_state:
        Previous locked settings page state.
    :ivar
        team_log.EnterpriseSettingsLockingDetails.new_settings_page_locking_state:
        New locked settings page state.
    """

    __slots__ = [
        '_team_name_value',
        '_settings_page_name_value',
        '_previous_settings_page_locking_state_value',
        '_new_settings_page_locking_state_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 team_name=None,
                 settings_page_name=None,
                 previous_settings_page_locking_state=None,
                 new_settings_page_locking_state=None):
        self._team_name_value = bb.NOT_SET
        self._settings_page_name_value = bb.NOT_SET
        self._previous_settings_page_locking_state_value = bb.NOT_SET
        self._new_settings_page_locking_state_value = bb.NOT_SET
        if team_name is not None:
            self.team_name = team_name
        if settings_page_name is not None:
            self.settings_page_name = settings_page_name
        if previous_settings_page_locking_state is not None:
            self.previous_settings_page_locking_state = previous_settings_page_locking_state
        if new_settings_page_locking_state is not None:
            self.new_settings_page_locking_state = new_settings_page_locking_state

    # Instance attribute type: str (validator is set below)
    team_name = bb.Attribute("team_name")

    # Instance attribute type: str (validator is set below)
    settings_page_name = bb.Attribute("settings_page_name")

    # Instance attribute type: str (validator is set below)
    previous_settings_page_locking_state = bb.Attribute("previous_settings_page_locking_state")

    # Instance attribute type: str (validator is set below)
    new_settings_page_locking_state = bb.Attribute("new_settings_page_locking_state")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EnterpriseSettingsLockingDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

EnterpriseSettingsLockingDetails_validator = bv.Struct(EnterpriseSettingsLockingDetails)

class EnterpriseSettingsLockingType(bb.Struct):

    __slots__ = [
        '_description_value',
    ]

    _has_required_fields = True

    def __init__(self,
                 description=None):
        self._description_value = bb.NOT_SET
        if description is not None:
            self.description = description

    # Instance attribute type: str (validator is set below)
    description = bb.Attribute("description")

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EnterpriseSettingsLockingType, self)._process_custom_annotations(annotation_type, field_path, processor)

EnterpriseSettingsLockingType_validator = bv.Struct(EnterpriseSettingsLockingType)

class EventCategory(bb.Union):
    """
    Category of events in event audit log.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar team_log.EventCategory.admin_alerting: Events that involve team
        related alerts.
    :ivar team_log.EventCategory.apps: Events that apply to management of linked
        apps.
    :ivar team_log.EventCategory.comments: Events that have to do with comments
        on files and Paper documents.
    :ivar team_log.EventCategory.data_governance: Events that involve data
        governance actions
    :ivar team_log.EventCategory.devices: Events that apply to linked devices on
        mobile, desktop and Web platforms.
    :ivar team_log.EventCategory.domains: Events that involve domain management
        feature: domain verification, invite enforcement and account capture.
    :ivar team_log.EventCategory.file_operations: Events that have to do with
        filesystem operations on files and folders: copy, move, delete, etc.
    :ivar team_log.EventCategory.file_requests: Events that apply to the file
        requests feature.
    :ivar team_log.EventCategory.groups: Events that involve group management.
    :ivar team_log.EventCategory.logins: Events that involve users signing in to
        or out of Dropbox.
    :ivar team_log.EventCategory.members: Events that involve team member
        management.
    :ivar team_log.EventCategory.paper: Events that apply to Dropbox Paper.
    :ivar team_log.EventCategory.passwords: Events that involve using, changing
        or resetting passwords.
    :ivar team_log.EventCategory.reports: Events that concern generation of
        admin reports, including team activity and device usage.
    :ivar team_log.EventCategory.sharing: Events that apply to all types of
        sharing and collaboration.
    :ivar team_log.EventCategory.showcase: Events that apply to Dropbox
        Showcase.
    :ivar team_log.EventCategory.sso: Events that involve using or configuring
        single sign-on as well as administrative policies concerning single
        sign-on.
    :ivar team_log.EventCategory.team_folders: Events that involve team folder
        management.
    :ivar team_log.EventCategory.team_policies: Events that involve a change in
        team-wide policies.
    :ivar team_log.EventCategory.team_profile: Events that involve a change in
        the team profile.
    :ivar team_log.EventCategory.tfa: Events that involve using or configuring
        two factor authentication as well as administrative policies concerning
        two factor authentication.
    :ivar team_log.EventCategory.trusted_teams: Events that apply to cross-team
        trust establishment.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    admin_alerting = None
    # Attribute is overwritten below the class definition
    apps = None
    # Attribute is overwritten below the class definition
    comments = None
    # Attribute is overwritten below the class definition
    data_governance = None
    # Attribute is overwritten below the class definition
    devices = None
    # Attribute is overwritten below the class definition
    domains = None
    # Attribute is overwritten below the class definition
    file_operations = None
    # Attribute is overwritten below the class definition
    file_requests = None
    # Attribute is overwritten below the class definition
    groups = None
    # Attribute is overwritten below the class definition
    logins = None
    # Attribute is overwritten below the class definition
    members = None
    # Attribute is overwritten below the class definition
    paper = None
    # Attribute is overwritten below the class definition
    passwords = None
    # Attribute is overwritten below the class definition
    reports = None
    # Attribute is overwritten below the class definition
    sharing = None
    # Attribute is overwritten below the class definition
    showcase = None
    # Attribute is overwritten below the class definition
    sso = None
    # Attribute is overwritten below the class definition
    team_folders = None
    # Attribute is overwritten below the class definition
    team_policies = None
    # Attribute is overwritten below the class definition
    team_profile = None
    # Attribute is overwritten below the class definition
    tfa = None
    # Attribute is overwritten below the class definition
    trusted_teams = None
    # Attribute is overwritten below the class definition
    other = None

    def is_admin_alerting(self):
        """
        Check if the union tag is ``admin_alerting``.

        :rtype: bool
        """
        return self._tag == 'admin_alerting'

    def is_apps(self):
        """
        Check if the union tag is ``apps``.

        :rtype: bool
        """
        return self._tag == 'apps'

    def is_comments(self):
        """
        Check if the union tag is ``comments``.

        :rtype: bool
        """
        return self._tag == 'comments'

    def is_data_governance(self):
        """
        Check if the union tag is ``data_governance``.

        :rtype: bool
        """
        return self._tag == 'data_governance'

    def is_devices(self):
        """
        Check if the union tag is ``devices``.

        :rtype: bool
        """
        return self._tag == 'devices'

    def is_domains(self):
        """
        Check if the union tag is ``domains``.

        :rtype: bool
        """
        return self._tag == 'domains'

    def is_file_operations(self):
        """
        Check if the union tag is ``file_operations``.

        :rtype: bool
        """
        return self._tag == 'file_operations'

    def is_file_requests(self):
        """
        Check if the union tag is ``file_requests``.

        :rtype: bool
        """
        return self._tag == 'file_requests'

    def is_groups(self):
        """
        Check if the union tag is ``groups``.

        :rtype: bool
        """
        return self._tag == 'groups'

    def is_logins(self):
        """
        Check if the union tag is ``logins``.

        :rtype: bool
        """
        return self._tag == 'logins'

    def is_members(self):
        """
        Check if the union tag is ``members``.

        :rtype: bool
        """
        return self._tag == 'members'

    def is_paper(self):
        """
        Check if the union tag is ``paper``.

        :rtype: bool
        """
        return self._tag == 'paper'

    def is_passwords(self):
        """
        Check if the union tag is ``passwords``.

        :rtype: bool
        """
        return self._tag == 'passwords'

    def is_reports(self):
        """
        Check if the union tag is ``reports``.

        :rtype: bool
        """
        return self._tag == 'reports'

    def is_sharing(self):
        """
        Check if the union tag is ``sharing``.

        :rtype: bool
        """
        return self._tag == 'sharing'

    def is_showcase(self):
        """
        Check if the union tag is ``showcase``.

        :rtype: bool
        """
        return self._tag == 'showcase'

    def is_sso(self):
        """
        Check if the union tag is ``sso``.

        :rtype: bool
        """
        return self._tag == 'sso'

    def is_team_folders(self):
        """
        Check if the union tag is ``team_folders``.

        :rtype: bool
        """
        return self._tag == 'team_folders'

    def is_team_policies(self):
        """
        Check if the union tag is ``team_policies``.

        :rtype: bool
        """
        return self._tag == 'team_policies'

    def is_team_profile(self):
        """
        Check if the union tag is ``team_profile``.

        :rtype: bool
        """
        return self._tag == 'team_profile'

    def is_tfa(self):
        """
        Check if the union tag is ``tfa``.

        :rtype: bool
        """
        return self._tag == 'tfa'

    def is_trusted_teams(self):
        """
        Check if the union tag is ``trusted_teams``.

        :rtype: bool
        """
        return self._tag == 'trusted_teams'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EventCategory, self)._process_custom_annotations(annotation_type, field_path, processor)

EventCategory_validator = bv.Union(EventCategory)

class EventDetails(bb.Union):
    """
    Additional fields depending on the event type.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar MissingDetails EventDetails.missing_details: Hints that this event was
        returned with missing details due to an internal error.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def admin_alerting_alert_state_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``admin_alerting_alert_state_changed_details`` tag with value ``val``.

        :param AdminAlertingAlertStateChangedDetails val:
        :rtype: EventDetails
        """
        return cls('admin_alerting_alert_state_changed_details', val)

    @classmethod
    def admin_alerting_changed_alert_config_details(cls, val):
        """
        Create an instance of this class set to the
        ``admin_alerting_changed_alert_config_details`` tag with value ``val``.

        :param AdminAlertingChangedAlertConfigDetails val:
        :rtype: EventDetails
        """
        return cls('admin_alerting_changed_alert_config_details', val)

    @classmethod
    def admin_alerting_triggered_alert_details(cls, val):
        """
        Create an instance of this class set to the
        ``admin_alerting_triggered_alert_details`` tag with value ``val``.

        :param AdminAlertingTriggeredAlertDetails val:
        :rtype: EventDetails
        """
        return cls('admin_alerting_triggered_alert_details', val)

    @classmethod
    def app_blocked_by_permissions_details(cls, val):
        """
        Create an instance of this class set to the
        ``app_blocked_by_permissions_details`` tag with value ``val``.

        :param AppBlockedByPermissionsDetails val:
        :rtype: EventDetails
        """
        return cls('app_blocked_by_permissions_details', val)

    @classmethod
    def app_link_team_details(cls, val):
        """
        Create an instance of this class set to the ``app_link_team_details``
        tag with value ``val``.

        :param AppLinkTeamDetails val:
        :rtype: EventDetails
        """
        return cls('app_link_team_details', val)

    @classmethod
    def app_link_user_details(cls, val):
        """
        Create an instance of this class set to the ``app_link_user_details``
        tag with value ``val``.

        :param AppLinkUserDetails val:
        :rtype: EventDetails
        """
        return cls('app_link_user_details', val)

    @classmethod
    def app_unlink_team_details(cls, val):
        """
        Create an instance of this class set to the ``app_unlink_team_details``
        tag with value ``val``.

        :param AppUnlinkTeamDetails val:
        :rtype: EventDetails
        """
        return cls('app_unlink_team_details', val)

    @classmethod
    def app_unlink_user_details(cls, val):
        """
        Create an instance of this class set to the ``app_unlink_user_details``
        tag with value ``val``.

        :param AppUnlinkUserDetails val:
        :rtype: EventDetails
        """
        return cls('app_unlink_user_details', val)

    @classmethod
    def integration_connected_details(cls, val):
        """
        Create an instance of this class set to the
        ``integration_connected_details`` tag with value ``val``.

        :param IntegrationConnectedDetails val:
        :rtype: EventDetails
        """
        return cls('integration_connected_details', val)

    @classmethod
    def integration_disconnected_details(cls, val):
        """
        Create an instance of this class set to the
        ``integration_disconnected_details`` tag with value ``val``.

        :param IntegrationDisconnectedDetails val:
        :rtype: EventDetails
        """
        return cls('integration_disconnected_details', val)

    @classmethod
    def file_add_comment_details(cls, val):
        """
        Create an instance of this class set to the ``file_add_comment_details``
        tag with value ``val``.

        :param FileAddCommentDetails val:
        :rtype: EventDetails
        """
        return cls('file_add_comment_details', val)

    @classmethod
    def file_change_comment_subscription_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_change_comment_subscription_details`` tag with value ``val``.

        :param FileChangeCommentSubscriptionDetails val:
        :rtype: EventDetails
        """
        return cls('file_change_comment_subscription_details', val)

    @classmethod
    def file_delete_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_delete_comment_details`` tag with value ``val``.

        :param FileDeleteCommentDetails val:
        :rtype: EventDetails
        """
        return cls('file_delete_comment_details', val)

    @classmethod
    def file_edit_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_edit_comment_details`` tag with value ``val``.

        :param FileEditCommentDetails val:
        :rtype: EventDetails
        """
        return cls('file_edit_comment_details', val)

    @classmethod
    def file_like_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_like_comment_details`` tag with value ``val``.

        :param FileLikeCommentDetails val:
        :rtype: EventDetails
        """
        return cls('file_like_comment_details', val)

    @classmethod
    def file_resolve_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_resolve_comment_details`` tag with value ``val``.

        :param FileResolveCommentDetails val:
        :rtype: EventDetails
        """
        return cls('file_resolve_comment_details', val)

    @classmethod
    def file_unlike_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_unlike_comment_details`` tag with value ``val``.

        :param FileUnlikeCommentDetails val:
        :rtype: EventDetails
        """
        return cls('file_unlike_comment_details', val)

    @classmethod
    def file_unresolve_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_unresolve_comment_details`` tag with value ``val``.

        :param FileUnresolveCommentDetails val:
        :rtype: EventDetails
        """
        return cls('file_unresolve_comment_details', val)

    @classmethod
    def governance_policy_add_folders_details(cls, val):
        """
        Create an instance of this class set to the
        ``governance_policy_add_folders_details`` tag with value ``val``.

        :param GovernancePolicyAddFoldersDetails val:
        :rtype: EventDetails
        """
        return cls('governance_policy_add_folders_details', val)

    @classmethod
    def governance_policy_add_folder_failed_details(cls, val):
        """
        Create an instance of this class set to the
        ``governance_policy_add_folder_failed_details`` tag with value ``val``.

        :param GovernancePolicyAddFolderFailedDetails val:
        :rtype: EventDetails
        """
        return cls('governance_policy_add_folder_failed_details', val)

    @classmethod
    def governance_policy_content_disposed_details(cls, val):
        """
        Create an instance of this class set to the
        ``governance_policy_content_disposed_details`` tag with value ``val``.

        :param GovernancePolicyContentDisposedDetails val:
        :rtype: EventDetails
        """
        return cls('governance_policy_content_disposed_details', val)

    @classmethod
    def governance_policy_create_details(cls, val):
        """
        Create an instance of this class set to the
        ``governance_policy_create_details`` tag with value ``val``.

        :param GovernancePolicyCreateDetails val:
        :rtype: EventDetails
        """
        return cls('governance_policy_create_details', val)

    @classmethod
    def governance_policy_delete_details(cls, val):
        """
        Create an instance of this class set to the
        ``governance_policy_delete_details`` tag with value ``val``.

        :param GovernancePolicyDeleteDetails val:
        :rtype: EventDetails
        """
        return cls('governance_policy_delete_details', val)

    @classmethod
    def governance_policy_edit_details_details(cls, val):
        """
        Create an instance of this class set to the
        ``governance_policy_edit_details_details`` tag with value ``val``.

        :param GovernancePolicyEditDetailsDetails val:
        :rtype: EventDetails
        """
        return cls('governance_policy_edit_details_details', val)

    @classmethod
    def governance_policy_edit_duration_details(cls, val):
        """
        Create an instance of this class set to the
        ``governance_policy_edit_duration_details`` tag with value ``val``.

        :param GovernancePolicyEditDurationDetails val:
        :rtype: EventDetails
        """
        return cls('governance_policy_edit_duration_details', val)

    @classmethod
    def governance_policy_export_created_details(cls, val):
        """
        Create an instance of this class set to the
        ``governance_policy_export_created_details`` tag with value ``val``.

        :param GovernancePolicyExportCreatedDetails val:
        :rtype: EventDetails
        """
        return cls('governance_policy_export_created_details', val)

    @classmethod
    def governance_policy_export_removed_details(cls, val):
        """
        Create an instance of this class set to the
        ``governance_policy_export_removed_details`` tag with value ``val``.

        :param GovernancePolicyExportRemovedDetails val:
        :rtype: EventDetails
        """
        return cls('governance_policy_export_removed_details', val)

    @classmethod
    def governance_policy_remove_folders_details(cls, val):
        """
        Create an instance of this class set to the
        ``governance_policy_remove_folders_details`` tag with value ``val``.

        :param GovernancePolicyRemoveFoldersDetails val:
        :rtype: EventDetails
        """
        return cls('governance_policy_remove_folders_details', val)

    @classmethod
    def governance_policy_report_created_details(cls, val):
        """
        Create an instance of this class set to the
        ``governance_policy_report_created_details`` tag with value ``val``.

        :param GovernancePolicyReportCreatedDetails val:
        :rtype: EventDetails
        """
        return cls('governance_policy_report_created_details', val)

    @classmethod
    def governance_policy_zip_part_downloaded_details(cls, val):
        """
        Create an instance of this class set to the
        ``governance_policy_zip_part_downloaded_details`` tag with value
        ``val``.

        :param GovernancePolicyZipPartDownloadedDetails val:
        :rtype: EventDetails
        """
        return cls('governance_policy_zip_part_downloaded_details', val)

    @classmethod
    def legal_holds_activate_a_hold_details(cls, val):
        """
        Create an instance of this class set to the
        ``legal_holds_activate_a_hold_details`` tag with value ``val``.

        :param LegalHoldsActivateAHoldDetails val:
        :rtype: EventDetails
        """
        return cls('legal_holds_activate_a_hold_details', val)

    @classmethod
    def legal_holds_add_members_details(cls, val):
        """
        Create an instance of this class set to the
        ``legal_holds_add_members_details`` tag with value ``val``.

        :param LegalHoldsAddMembersDetails val:
        :rtype: EventDetails
        """
        return cls('legal_holds_add_members_details', val)

    @classmethod
    def legal_holds_change_hold_details_details(cls, val):
        """
        Create an instance of this class set to the
        ``legal_holds_change_hold_details_details`` tag with value ``val``.

        :param LegalHoldsChangeHoldDetailsDetails val:
        :rtype: EventDetails
        """
        return cls('legal_holds_change_hold_details_details', val)

    @classmethod
    def legal_holds_change_hold_name_details(cls, val):
        """
        Create an instance of this class set to the
        ``legal_holds_change_hold_name_details`` tag with value ``val``.

        :param LegalHoldsChangeHoldNameDetails val:
        :rtype: EventDetails
        """
        return cls('legal_holds_change_hold_name_details', val)

    @classmethod
    def legal_holds_export_a_hold_details(cls, val):
        """
        Create an instance of this class set to the
        ``legal_holds_export_a_hold_details`` tag with value ``val``.

        :param LegalHoldsExportAHoldDetails val:
        :rtype: EventDetails
        """
        return cls('legal_holds_export_a_hold_details', val)

    @classmethod
    def legal_holds_export_cancelled_details(cls, val):
        """
        Create an instance of this class set to the
        ``legal_holds_export_cancelled_details`` tag with value ``val``.

        :param LegalHoldsExportCancelledDetails val:
        :rtype: EventDetails
        """
        return cls('legal_holds_export_cancelled_details', val)

    @classmethod
    def legal_holds_export_downloaded_details(cls, val):
        """
        Create an instance of this class set to the
        ``legal_holds_export_downloaded_details`` tag with value ``val``.

        :param LegalHoldsExportDownloadedDetails val:
        :rtype: EventDetails
        """
        return cls('legal_holds_export_downloaded_details', val)

    @classmethod
    def legal_holds_export_removed_details(cls, val):
        """
        Create an instance of this class set to the
        ``legal_holds_export_removed_details`` tag with value ``val``.

        :param LegalHoldsExportRemovedDetails val:
        :rtype: EventDetails
        """
        return cls('legal_holds_export_removed_details', val)

    @classmethod
    def legal_holds_release_a_hold_details(cls, val):
        """
        Create an instance of this class set to the
        ``legal_holds_release_a_hold_details`` tag with value ``val``.

        :param LegalHoldsReleaseAHoldDetails val:
        :rtype: EventDetails
        """
        return cls('legal_holds_release_a_hold_details', val)

    @classmethod
    def legal_holds_remove_members_details(cls, val):
        """
        Create an instance of this class set to the
        ``legal_holds_remove_members_details`` tag with value ``val``.

        :param LegalHoldsRemoveMembersDetails val:
        :rtype: EventDetails
        """
        return cls('legal_holds_remove_members_details', val)

    @classmethod
    def legal_holds_report_a_hold_details(cls, val):
        """
        Create an instance of this class set to the
        ``legal_holds_report_a_hold_details`` tag with value ``val``.

        :param LegalHoldsReportAHoldDetails val:
        :rtype: EventDetails
        """
        return cls('legal_holds_report_a_hold_details', val)

    @classmethod
    def device_change_ip_desktop_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_change_ip_desktop_details`` tag with value ``val``.

        :param DeviceChangeIpDesktopDetails val:
        :rtype: EventDetails
        """
        return cls('device_change_ip_desktop_details', val)

    @classmethod
    def device_change_ip_mobile_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_change_ip_mobile_details`` tag with value ``val``.

        :param DeviceChangeIpMobileDetails val:
        :rtype: EventDetails
        """
        return cls('device_change_ip_mobile_details', val)

    @classmethod
    def device_change_ip_web_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_change_ip_web_details`` tag with value ``val``.

        :param DeviceChangeIpWebDetails val:
        :rtype: EventDetails
        """
        return cls('device_change_ip_web_details', val)

    @classmethod
    def device_delete_on_unlink_fail_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_delete_on_unlink_fail_details`` tag with value ``val``.

        :param DeviceDeleteOnUnlinkFailDetails val:
        :rtype: EventDetails
        """
        return cls('device_delete_on_unlink_fail_details', val)

    @classmethod
    def device_delete_on_unlink_success_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_delete_on_unlink_success_details`` tag with value ``val``.

        :param DeviceDeleteOnUnlinkSuccessDetails val:
        :rtype: EventDetails
        """
        return cls('device_delete_on_unlink_success_details', val)

    @classmethod
    def device_link_fail_details(cls, val):
        """
        Create an instance of this class set to the ``device_link_fail_details``
        tag with value ``val``.

        :param DeviceLinkFailDetails val:
        :rtype: EventDetails
        """
        return cls('device_link_fail_details', val)

    @classmethod
    def device_link_success_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_link_success_details`` tag with value ``val``.

        :param DeviceLinkSuccessDetails val:
        :rtype: EventDetails
        """
        return cls('device_link_success_details', val)

    @classmethod
    def device_management_disabled_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_management_disabled_details`` tag with value ``val``.

        :param DeviceManagementDisabledDetails val:
        :rtype: EventDetails
        """
        return cls('device_management_disabled_details', val)

    @classmethod
    def device_management_enabled_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_management_enabled_details`` tag with value ``val``.

        :param DeviceManagementEnabledDetails val:
        :rtype: EventDetails
        """
        return cls('device_management_enabled_details', val)

    @classmethod
    def device_sync_backup_status_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_sync_backup_status_changed_details`` tag with value ``val``.

        :param DeviceSyncBackupStatusChangedDetails val:
        :rtype: EventDetails
        """
        return cls('device_sync_backup_status_changed_details', val)

    @classmethod
    def device_unlink_details(cls, val):
        """
        Create an instance of this class set to the ``device_unlink_details``
        tag with value ``val``.

        :param DeviceUnlinkDetails val:
        :rtype: EventDetails
        """
        return cls('device_unlink_details', val)

    @classmethod
    def dropbox_passwords_exported_details(cls, val):
        """
        Create an instance of this class set to the
        ``dropbox_passwords_exported_details`` tag with value ``val``.

        :param DropboxPasswordsExportedDetails val:
        :rtype: EventDetails
        """
        return cls('dropbox_passwords_exported_details', val)

    @classmethod
    def dropbox_passwords_new_device_enrolled_details(cls, val):
        """
        Create an instance of this class set to the
        ``dropbox_passwords_new_device_enrolled_details`` tag with value
        ``val``.

        :param DropboxPasswordsNewDeviceEnrolledDetails val:
        :rtype: EventDetails
        """
        return cls('dropbox_passwords_new_device_enrolled_details', val)

    @classmethod
    def emm_refresh_auth_token_details(cls, val):
        """
        Create an instance of this class set to the
        ``emm_refresh_auth_token_details`` tag with value ``val``.

        :param EmmRefreshAuthTokenDetails val:
        :rtype: EventDetails
        """
        return cls('emm_refresh_auth_token_details', val)

    @classmethod
    def account_capture_change_availability_details(cls, val):
        """
        Create an instance of this class set to the
        ``account_capture_change_availability_details`` tag with value ``val``.

        :param AccountCaptureChangeAvailabilityDetails val:
        :rtype: EventDetails
        """
        return cls('account_capture_change_availability_details', val)

    @classmethod
    def account_capture_migrate_account_details(cls, val):
        """
        Create an instance of this class set to the
        ``account_capture_migrate_account_details`` tag with value ``val``.

        :param AccountCaptureMigrateAccountDetails val:
        :rtype: EventDetails
        """
        return cls('account_capture_migrate_account_details', val)

    @classmethod
    def account_capture_notification_emails_sent_details(cls, val):
        """
        Create an instance of this class set to the
        ``account_capture_notification_emails_sent_details`` tag with value
        ``val``.

        :param AccountCaptureNotificationEmailsSentDetails val:
        :rtype: EventDetails
        """
        return cls('account_capture_notification_emails_sent_details', val)

    @classmethod
    def account_capture_relinquish_account_details(cls, val):
        """
        Create an instance of this class set to the
        ``account_capture_relinquish_account_details`` tag with value ``val``.

        :param AccountCaptureRelinquishAccountDetails val:
        :rtype: EventDetails
        """
        return cls('account_capture_relinquish_account_details', val)

    @classmethod
    def disabled_domain_invites_details(cls, val):
        """
        Create an instance of this class set to the
        ``disabled_domain_invites_details`` tag with value ``val``.

        :param DisabledDomainInvitesDetails val:
        :rtype: EventDetails
        """
        return cls('disabled_domain_invites_details', val)

    @classmethod
    def domain_invites_approve_request_to_join_team_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_approve_request_to_join_team_details`` tag with value
        ``val``.

        :param DomainInvitesApproveRequestToJoinTeamDetails val:
        :rtype: EventDetails
        """
        return cls('domain_invites_approve_request_to_join_team_details', val)

    @classmethod
    def domain_invites_decline_request_to_join_team_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_decline_request_to_join_team_details`` tag with value
        ``val``.

        :param DomainInvitesDeclineRequestToJoinTeamDetails val:
        :rtype: EventDetails
        """
        return cls('domain_invites_decline_request_to_join_team_details', val)

    @classmethod
    def domain_invites_email_existing_users_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_email_existing_users_details`` tag with value ``val``.

        :param DomainInvitesEmailExistingUsersDetails val:
        :rtype: EventDetails
        """
        return cls('domain_invites_email_existing_users_details', val)

    @classmethod
    def domain_invites_request_to_join_team_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_request_to_join_team_details`` tag with value ``val``.

        :param DomainInvitesRequestToJoinTeamDetails val:
        :rtype: EventDetails
        """
        return cls('domain_invites_request_to_join_team_details', val)

    @classmethod
    def domain_invites_set_invite_new_user_pref_to_no_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_set_invite_new_user_pref_to_no_details`` tag with value
        ``val``.

        :param DomainInvitesSetInviteNewUserPrefToNoDetails val:
        :rtype: EventDetails
        """
        return cls('domain_invites_set_invite_new_user_pref_to_no_details', val)

    @classmethod
    def domain_invites_set_invite_new_user_pref_to_yes_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_set_invite_new_user_pref_to_yes_details`` tag with
        value ``val``.

        :param DomainInvitesSetInviteNewUserPrefToYesDetails val:
        :rtype: EventDetails
        """
        return cls('domain_invites_set_invite_new_user_pref_to_yes_details', val)

    @classmethod
    def domain_verification_add_domain_fail_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_verification_add_domain_fail_details`` tag with value ``val``.

        :param DomainVerificationAddDomainFailDetails val:
        :rtype: EventDetails
        """
        return cls('domain_verification_add_domain_fail_details', val)

    @classmethod
    def domain_verification_add_domain_success_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_verification_add_domain_success_details`` tag with value
        ``val``.

        :param DomainVerificationAddDomainSuccessDetails val:
        :rtype: EventDetails
        """
        return cls('domain_verification_add_domain_success_details', val)

    @classmethod
    def domain_verification_remove_domain_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_verification_remove_domain_details`` tag with value ``val``.

        :param DomainVerificationRemoveDomainDetails val:
        :rtype: EventDetails
        """
        return cls('domain_verification_remove_domain_details', val)

    @classmethod
    def enabled_domain_invites_details(cls, val):
        """
        Create an instance of this class set to the
        ``enabled_domain_invites_details`` tag with value ``val``.

        :param EnabledDomainInvitesDetails val:
        :rtype: EventDetails
        """
        return cls('enabled_domain_invites_details', val)

    @classmethod
    def apply_naming_convention_details(cls, val):
        """
        Create an instance of this class set to the
        ``apply_naming_convention_details`` tag with value ``val``.

        :param ApplyNamingConventionDetails val:
        :rtype: EventDetails
        """
        return cls('apply_naming_convention_details', val)

    @classmethod
    def create_folder_details(cls, val):
        """
        Create an instance of this class set to the ``create_folder_details``
        tag with value ``val``.

        :param CreateFolderDetails val:
        :rtype: EventDetails
        """
        return cls('create_folder_details', val)

    @classmethod
    def file_add_details(cls, val):
        """
        Create an instance of this class set to the ``file_add_details`` tag
        with value ``val``.

        :param FileAddDetails val:
        :rtype: EventDetails
        """
        return cls('file_add_details', val)

    @classmethod
    def file_copy_details(cls, val):
        """
        Create an instance of this class set to the ``file_copy_details`` tag
        with value ``val``.

        :param FileCopyDetails val:
        :rtype: EventDetails
        """
        return cls('file_copy_details', val)

    @classmethod
    def file_delete_details(cls, val):
        """
        Create an instance of this class set to the ``file_delete_details`` tag
        with value ``val``.

        :param FileDeleteDetails val:
        :rtype: EventDetails
        """
        return cls('file_delete_details', val)

    @classmethod
    def file_download_details(cls, val):
        """
        Create an instance of this class set to the ``file_download_details``
        tag with value ``val``.

        :param FileDownloadDetails val:
        :rtype: EventDetails
        """
        return cls('file_download_details', val)

    @classmethod
    def file_edit_details(cls, val):
        """
        Create an instance of this class set to the ``file_edit_details`` tag
        with value ``val``.

        :param FileEditDetails val:
        :rtype: EventDetails
        """
        return cls('file_edit_details', val)

    @classmethod
    def file_get_copy_reference_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_get_copy_reference_details`` tag with value ``val``.

        :param FileGetCopyReferenceDetails val:
        :rtype: EventDetails
        """
        return cls('file_get_copy_reference_details', val)

    @classmethod
    def file_locking_lock_status_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_locking_lock_status_changed_details`` tag with value ``val``.

        :param FileLockingLockStatusChangedDetails val:
        :rtype: EventDetails
        """
        return cls('file_locking_lock_status_changed_details', val)

    @classmethod
    def file_move_details(cls, val):
        """
        Create an instance of this class set to the ``file_move_details`` tag
        with value ``val``.

        :param FileMoveDetails val:
        :rtype: EventDetails
        """
        return cls('file_move_details', val)

    @classmethod
    def file_permanently_delete_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_permanently_delete_details`` tag with value ``val``.

        :param FilePermanentlyDeleteDetails val:
        :rtype: EventDetails
        """
        return cls('file_permanently_delete_details', val)

    @classmethod
    def file_preview_details(cls, val):
        """
        Create an instance of this class set to the ``file_preview_details`` tag
        with value ``val``.

        :param FilePreviewDetails val:
        :rtype: EventDetails
        """
        return cls('file_preview_details', val)

    @classmethod
    def file_rename_details(cls, val):
        """
        Create an instance of this class set to the ``file_rename_details`` tag
        with value ``val``.

        :param FileRenameDetails val:
        :rtype: EventDetails
        """
        return cls('file_rename_details', val)

    @classmethod
    def file_restore_details(cls, val):
        """
        Create an instance of this class set to the ``file_restore_details`` tag
        with value ``val``.

        :param FileRestoreDetails val:
        :rtype: EventDetails
        """
        return cls('file_restore_details', val)

    @classmethod
    def file_revert_details(cls, val):
        """
        Create an instance of this class set to the ``file_revert_details`` tag
        with value ``val``.

        :param FileRevertDetails val:
        :rtype: EventDetails
        """
        return cls('file_revert_details', val)

    @classmethod
    def file_rollback_changes_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_rollback_changes_details`` tag with value ``val``.

        :param FileRollbackChangesDetails val:
        :rtype: EventDetails
        """
        return cls('file_rollback_changes_details', val)

    @classmethod
    def file_save_copy_reference_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_save_copy_reference_details`` tag with value ``val``.

        :param FileSaveCopyReferenceDetails val:
        :rtype: EventDetails
        """
        return cls('file_save_copy_reference_details', val)

    @classmethod
    def folder_overview_description_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``folder_overview_description_changed_details`` tag with value ``val``.

        :param FolderOverviewDescriptionChangedDetails val:
        :rtype: EventDetails
        """
        return cls('folder_overview_description_changed_details', val)

    @classmethod
    def folder_overview_item_pinned_details(cls, val):
        """
        Create an instance of this class set to the
        ``folder_overview_item_pinned_details`` tag with value ``val``.

        :param FolderOverviewItemPinnedDetails val:
        :rtype: EventDetails
        """
        return cls('folder_overview_item_pinned_details', val)

    @classmethod
    def folder_overview_item_unpinned_details(cls, val):
        """
        Create an instance of this class set to the
        ``folder_overview_item_unpinned_details`` tag with value ``val``.

        :param FolderOverviewItemUnpinnedDetails val:
        :rtype: EventDetails
        """
        return cls('folder_overview_item_unpinned_details', val)

    @classmethod
    def object_label_added_details(cls, val):
        """
        Create an instance of this class set to the
        ``object_label_added_details`` tag with value ``val``.

        :param ObjectLabelAddedDetails val:
        :rtype: EventDetails
        """
        return cls('object_label_added_details', val)

    @classmethod
    def object_label_removed_details(cls, val):
        """
        Create an instance of this class set to the
        ``object_label_removed_details`` tag with value ``val``.

        :param ObjectLabelRemovedDetails val:
        :rtype: EventDetails
        """
        return cls('object_label_removed_details', val)

    @classmethod
    def object_label_updated_value_details(cls, val):
        """
        Create an instance of this class set to the
        ``object_label_updated_value_details`` tag with value ``val``.

        :param ObjectLabelUpdatedValueDetails val:
        :rtype: EventDetails
        """
        return cls('object_label_updated_value_details', val)

    @classmethod
    def organize_folder_with_tidy_details(cls, val):
        """
        Create an instance of this class set to the
        ``organize_folder_with_tidy_details`` tag with value ``val``.

        :param OrganizeFolderWithTidyDetails val:
        :rtype: EventDetails
        """
        return cls('organize_folder_with_tidy_details', val)

    @classmethod
    def rewind_folder_details(cls, val):
        """
        Create an instance of this class set to the ``rewind_folder_details``
        tag with value ``val``.

        :param RewindFolderDetails val:
        :rtype: EventDetails
        """
        return cls('rewind_folder_details', val)

    @classmethod
    def undo_naming_convention_details(cls, val):
        """
        Create an instance of this class set to the
        ``undo_naming_convention_details`` tag with value ``val``.

        :param UndoNamingConventionDetails val:
        :rtype: EventDetails
        """
        return cls('undo_naming_convention_details', val)

    @classmethod
    def undo_organize_folder_with_tidy_details(cls, val):
        """
        Create an instance of this class set to the
        ``undo_organize_folder_with_tidy_details`` tag with value ``val``.

        :param UndoOrganizeFolderWithTidyDetails val:
        :rtype: EventDetails
        """
        return cls('undo_organize_folder_with_tidy_details', val)

    @classmethod
    def user_tags_added_details(cls, val):
        """
        Create an instance of this class set to the ``user_tags_added_details``
        tag with value ``val``.

        :param UserTagsAddedDetails val:
        :rtype: EventDetails
        """
        return cls('user_tags_added_details', val)

    @classmethod
    def user_tags_removed_details(cls, val):
        """
        Create an instance of this class set to the
        ``user_tags_removed_details`` tag with value ``val``.

        :param UserTagsRemovedDetails val:
        :rtype: EventDetails
        """
        return cls('user_tags_removed_details', val)

    @classmethod
    def email_ingest_receive_file_details(cls, val):
        """
        Create an instance of this class set to the
        ``email_ingest_receive_file_details`` tag with value ``val``.

        :param EmailIngestReceiveFileDetails val:
        :rtype: EventDetails
        """
        return cls('email_ingest_receive_file_details', val)

    @classmethod
    def file_request_change_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_request_change_details`` tag with value ``val``.

        :param FileRequestChangeDetails val:
        :rtype: EventDetails
        """
        return cls('file_request_change_details', val)

    @classmethod
    def file_request_close_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_request_close_details`` tag with value ``val``.

        :param FileRequestCloseDetails val:
        :rtype: EventDetails
        """
        return cls('file_request_close_details', val)

    @classmethod
    def file_request_create_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_request_create_details`` tag with value ``val``.

        :param FileRequestCreateDetails val:
        :rtype: EventDetails
        """
        return cls('file_request_create_details', val)

    @classmethod
    def file_request_delete_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_request_delete_details`` tag with value ``val``.

        :param FileRequestDeleteDetails val:
        :rtype: EventDetails
        """
        return cls('file_request_delete_details', val)

    @classmethod
    def file_request_receive_file_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_request_receive_file_details`` tag with value ``val``.

        :param FileRequestReceiveFileDetails val:
        :rtype: EventDetails
        """
        return cls('file_request_receive_file_details', val)

    @classmethod
    def group_add_external_id_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_add_external_id_details`` tag with value ``val``.

        :param GroupAddExternalIdDetails val:
        :rtype: EventDetails
        """
        return cls('group_add_external_id_details', val)

    @classmethod
    def group_add_member_details(cls, val):
        """
        Create an instance of this class set to the ``group_add_member_details``
        tag with value ``val``.

        :param GroupAddMemberDetails val:
        :rtype: EventDetails
        """
        return cls('group_add_member_details', val)

    @classmethod
    def group_change_external_id_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_change_external_id_details`` tag with value ``val``.

        :param GroupChangeExternalIdDetails val:
        :rtype: EventDetails
        """
        return cls('group_change_external_id_details', val)

    @classmethod
    def group_change_management_type_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_change_management_type_details`` tag with value ``val``.

        :param GroupChangeManagementTypeDetails val:
        :rtype: EventDetails
        """
        return cls('group_change_management_type_details', val)

    @classmethod
    def group_change_member_role_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_change_member_role_details`` tag with value ``val``.

        :param GroupChangeMemberRoleDetails val:
        :rtype: EventDetails
        """
        return cls('group_change_member_role_details', val)

    @classmethod
    def group_create_details(cls, val):
        """
        Create an instance of this class set to the ``group_create_details`` tag
        with value ``val``.

        :param GroupCreateDetails val:
        :rtype: EventDetails
        """
        return cls('group_create_details', val)

    @classmethod
    def group_delete_details(cls, val):
        """
        Create an instance of this class set to the ``group_delete_details`` tag
        with value ``val``.

        :param GroupDeleteDetails val:
        :rtype: EventDetails
        """
        return cls('group_delete_details', val)

    @classmethod
    def group_description_updated_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_description_updated_details`` tag with value ``val``.

        :param GroupDescriptionUpdatedDetails val:
        :rtype: EventDetails
        """
        return cls('group_description_updated_details', val)

    @classmethod
    def group_join_policy_updated_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_join_policy_updated_details`` tag with value ``val``.

        :param GroupJoinPolicyUpdatedDetails val:
        :rtype: EventDetails
        """
        return cls('group_join_policy_updated_details', val)

    @classmethod
    def group_moved_details(cls, val):
        """
        Create an instance of this class set to the ``group_moved_details`` tag
        with value ``val``.

        :param GroupMovedDetails val:
        :rtype: EventDetails
        """
        return cls('group_moved_details', val)

    @classmethod
    def group_remove_external_id_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_remove_external_id_details`` tag with value ``val``.

        :param GroupRemoveExternalIdDetails val:
        :rtype: EventDetails
        """
        return cls('group_remove_external_id_details', val)

    @classmethod
    def group_remove_member_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_remove_member_details`` tag with value ``val``.

        :param GroupRemoveMemberDetails val:
        :rtype: EventDetails
        """
        return cls('group_remove_member_details', val)

    @classmethod
    def group_rename_details(cls, val):
        """
        Create an instance of this class set to the ``group_rename_details`` tag
        with value ``val``.

        :param GroupRenameDetails val:
        :rtype: EventDetails
        """
        return cls('group_rename_details', val)

    @classmethod
    def account_lock_or_unlocked_details(cls, val):
        """
        Create an instance of this class set to the
        ``account_lock_or_unlocked_details`` tag with value ``val``.

        :param AccountLockOrUnlockedDetails val:
        :rtype: EventDetails
        """
        return cls('account_lock_or_unlocked_details', val)

    @classmethod
    def emm_error_details(cls, val):
        """
        Create an instance of this class set to the ``emm_error_details`` tag
        with value ``val``.

        :param EmmErrorDetails val:
        :rtype: EventDetails
        """
        return cls('emm_error_details', val)

    @classmethod
    def guest_admin_signed_in_via_trusted_teams_details(cls, val):
        """
        Create an instance of this class set to the
        ``guest_admin_signed_in_via_trusted_teams_details`` tag with value
        ``val``.

        :param GuestAdminSignedInViaTrustedTeamsDetails val:
        :rtype: EventDetails
        """
        return cls('guest_admin_signed_in_via_trusted_teams_details', val)

    @classmethod
    def guest_admin_signed_out_via_trusted_teams_details(cls, val):
        """
        Create an instance of this class set to the
        ``guest_admin_signed_out_via_trusted_teams_details`` tag with value
        ``val``.

        :param GuestAdminSignedOutViaTrustedTeamsDetails val:
        :rtype: EventDetails
        """
        return cls('guest_admin_signed_out_via_trusted_teams_details', val)

    @classmethod
    def login_fail_details(cls, val):
        """
        Create an instance of this class set to the ``login_fail_details`` tag
        with value ``val``.

        :param LoginFailDetails val:
        :rtype: EventDetails
        """
        return cls('login_fail_details', val)

    @classmethod
    def login_success_details(cls, val):
        """
        Create an instance of this class set to the ``login_success_details``
        tag with value ``val``.

        :param LoginSuccessDetails val:
        :rtype: EventDetails
        """
        return cls('login_success_details', val)

    @classmethod
    def logout_details(cls, val):
        """
        Create an instance of this class set to the ``logout_details`` tag with
        value ``val``.

        :param LogoutDetails val:
        :rtype: EventDetails
        """
        return cls('logout_details', val)

    @classmethod
    def reseller_support_session_end_details(cls, val):
        """
        Create an instance of this class set to the
        ``reseller_support_session_end_details`` tag with value ``val``.

        :param ResellerSupportSessionEndDetails val:
        :rtype: EventDetails
        """
        return cls('reseller_support_session_end_details', val)

    @classmethod
    def reseller_support_session_start_details(cls, val):
        """
        Create an instance of this class set to the
        ``reseller_support_session_start_details`` tag with value ``val``.

        :param ResellerSupportSessionStartDetails val:
        :rtype: EventDetails
        """
        return cls('reseller_support_session_start_details', val)

    @classmethod
    def sign_in_as_session_end_details(cls, val):
        """
        Create an instance of this class set to the
        ``sign_in_as_session_end_details`` tag with value ``val``.

        :param SignInAsSessionEndDetails val:
        :rtype: EventDetails
        """
        return cls('sign_in_as_session_end_details', val)

    @classmethod
    def sign_in_as_session_start_details(cls, val):
        """
        Create an instance of this class set to the
        ``sign_in_as_session_start_details`` tag with value ``val``.

        :param SignInAsSessionStartDetails val:
        :rtype: EventDetails
        """
        return cls('sign_in_as_session_start_details', val)

    @classmethod
    def sso_error_details(cls, val):
        """
        Create an instance of this class set to the ``sso_error_details`` tag
        with value ``val``.

        :param SsoErrorDetails val:
        :rtype: EventDetails
        """
        return cls('sso_error_details', val)

    @classmethod
    def create_team_invite_link_details(cls, val):
        """
        Create an instance of this class set to the
        ``create_team_invite_link_details`` tag with value ``val``.

        :param CreateTeamInviteLinkDetails val:
        :rtype: EventDetails
        """
        return cls('create_team_invite_link_details', val)

    @classmethod
    def delete_team_invite_link_details(cls, val):
        """
        Create an instance of this class set to the
        ``delete_team_invite_link_details`` tag with value ``val``.

        :param DeleteTeamInviteLinkDetails val:
        :rtype: EventDetails
        """
        return cls('delete_team_invite_link_details', val)

    @classmethod
    def member_add_external_id_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_add_external_id_details`` tag with value ``val``.

        :param MemberAddExternalIdDetails val:
        :rtype: EventDetails
        """
        return cls('member_add_external_id_details', val)

    @classmethod
    def member_add_name_details(cls, val):
        """
        Create an instance of this class set to the ``member_add_name_details``
        tag with value ``val``.

        :param MemberAddNameDetails val:
        :rtype: EventDetails
        """
        return cls('member_add_name_details', val)

    @classmethod
    def member_change_admin_role_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_change_admin_role_details`` tag with value ``val``.

        :param MemberChangeAdminRoleDetails val:
        :rtype: EventDetails
        """
        return cls('member_change_admin_role_details', val)

    @classmethod
    def member_change_email_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_change_email_details`` tag with value ``val``.

        :param MemberChangeEmailDetails val:
        :rtype: EventDetails
        """
        return cls('member_change_email_details', val)

    @classmethod
    def member_change_external_id_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_change_external_id_details`` tag with value ``val``.

        :param MemberChangeExternalIdDetails val:
        :rtype: EventDetails
        """
        return cls('member_change_external_id_details', val)

    @classmethod
    def member_change_membership_type_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_change_membership_type_details`` tag with value ``val``.

        :param MemberChangeMembershipTypeDetails val:
        :rtype: EventDetails
        """
        return cls('member_change_membership_type_details', val)

    @classmethod
    def member_change_name_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_change_name_details`` tag with value ``val``.

        :param MemberChangeNameDetails val:
        :rtype: EventDetails
        """
        return cls('member_change_name_details', val)

    @classmethod
    def member_change_reseller_role_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_change_reseller_role_details`` tag with value ``val``.

        :param MemberChangeResellerRoleDetails val:
        :rtype: EventDetails
        """
        return cls('member_change_reseller_role_details', val)

    @classmethod
    def member_change_status_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_change_status_details`` tag with value ``val``.

        :param MemberChangeStatusDetails val:
        :rtype: EventDetails
        """
        return cls('member_change_status_details', val)

    @classmethod
    def member_delete_manual_contacts_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_delete_manual_contacts_details`` tag with value ``val``.

        :param MemberDeleteManualContactsDetails val:
        :rtype: EventDetails
        """
        return cls('member_delete_manual_contacts_details', val)

    @classmethod
    def member_delete_profile_photo_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_delete_profile_photo_details`` tag with value ``val``.

        :param MemberDeleteProfilePhotoDetails val:
        :rtype: EventDetails
        """
        return cls('member_delete_profile_photo_details', val)

    @classmethod
    def member_permanently_delete_account_contents_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_permanently_delete_account_contents_details`` tag with value
        ``val``.

        :param MemberPermanentlyDeleteAccountContentsDetails val:
        :rtype: EventDetails
        """
        return cls('member_permanently_delete_account_contents_details', val)

    @classmethod
    def member_remove_external_id_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_remove_external_id_details`` tag with value ``val``.

        :param MemberRemoveExternalIdDetails val:
        :rtype: EventDetails
        """
        return cls('member_remove_external_id_details', val)

    @classmethod
    def member_set_profile_photo_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_set_profile_photo_details`` tag with value ``val``.

        :param MemberSetProfilePhotoDetails val:
        :rtype: EventDetails
        """
        return cls('member_set_profile_photo_details', val)

    @classmethod
    def member_space_limits_add_custom_quota_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_add_custom_quota_details`` tag with value ``val``.

        :param MemberSpaceLimitsAddCustomQuotaDetails val:
        :rtype: EventDetails
        """
        return cls('member_space_limits_add_custom_quota_details', val)

    @classmethod
    def member_space_limits_change_custom_quota_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_change_custom_quota_details`` tag with value
        ``val``.

        :param MemberSpaceLimitsChangeCustomQuotaDetails val:
        :rtype: EventDetails
        """
        return cls('member_space_limits_change_custom_quota_details', val)

    @classmethod
    def member_space_limits_change_status_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_change_status_details`` tag with value ``val``.

        :param MemberSpaceLimitsChangeStatusDetails val:
        :rtype: EventDetails
        """
        return cls('member_space_limits_change_status_details', val)

    @classmethod
    def member_space_limits_remove_custom_quota_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_remove_custom_quota_details`` tag with value
        ``val``.

        :param MemberSpaceLimitsRemoveCustomQuotaDetails val:
        :rtype: EventDetails
        """
        return cls('member_space_limits_remove_custom_quota_details', val)

    @classmethod
    def member_suggest_details(cls, val):
        """
        Create an instance of this class set to the ``member_suggest_details``
        tag with value ``val``.

        :param MemberSuggestDetails val:
        :rtype: EventDetails
        """
        return cls('member_suggest_details', val)

    @classmethod
    def member_transfer_account_contents_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_transfer_account_contents_details`` tag with value ``val``.

        :param MemberTransferAccountContentsDetails val:
        :rtype: EventDetails
        """
        return cls('member_transfer_account_contents_details', val)

    @classmethod
    def pending_secondary_email_added_details(cls, val):
        """
        Create an instance of this class set to the
        ``pending_secondary_email_added_details`` tag with value ``val``.

        :param PendingSecondaryEmailAddedDetails val:
        :rtype: EventDetails
        """
        return cls('pending_secondary_email_added_details', val)

    @classmethod
    def secondary_email_deleted_details(cls, val):
        """
        Create an instance of this class set to the
        ``secondary_email_deleted_details`` tag with value ``val``.

        :param SecondaryEmailDeletedDetails val:
        :rtype: EventDetails
        """
        return cls('secondary_email_deleted_details', val)

    @classmethod
    def secondary_email_verified_details(cls, val):
        """
        Create an instance of this class set to the
        ``secondary_email_verified_details`` tag with value ``val``.

        :param SecondaryEmailVerifiedDetails val:
        :rtype: EventDetails
        """
        return cls('secondary_email_verified_details', val)

    @classmethod
    def secondary_mails_policy_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``secondary_mails_policy_changed_details`` tag with value ``val``.

        :param SecondaryMailsPolicyChangedDetails val:
        :rtype: EventDetails
        """
        return cls('secondary_mails_policy_changed_details', val)

    @classmethod
    def binder_add_page_details(cls, val):
        """
        Create an instance of this class set to the ``binder_add_page_details``
        tag with value ``val``.

        :param BinderAddPageDetails val:
        :rtype: EventDetails
        """
        return cls('binder_add_page_details', val)

    @classmethod
    def binder_add_section_details(cls, val):
        """
        Create an instance of this class set to the
        ``binder_add_section_details`` tag with value ``val``.

        :param BinderAddSectionDetails val:
        :rtype: EventDetails
        """
        return cls('binder_add_section_details', val)

    @classmethod
    def binder_remove_page_details(cls, val):
        """
        Create an instance of this class set to the
        ``binder_remove_page_details`` tag with value ``val``.

        :param BinderRemovePageDetails val:
        :rtype: EventDetails
        """
        return cls('binder_remove_page_details', val)

    @classmethod
    def binder_remove_section_details(cls, val):
        """
        Create an instance of this class set to the
        ``binder_remove_section_details`` tag with value ``val``.

        :param BinderRemoveSectionDetails val:
        :rtype: EventDetails
        """
        return cls('binder_remove_section_details', val)

    @classmethod
    def binder_rename_page_details(cls, val):
        """
        Create an instance of this class set to the
        ``binder_rename_page_details`` tag with value ``val``.

        :param BinderRenamePageDetails val:
        :rtype: EventDetails
        """
        return cls('binder_rename_page_details', val)

    @classmethod
    def binder_rename_section_details(cls, val):
        """
        Create an instance of this class set to the
        ``binder_rename_section_details`` tag with value ``val``.

        :param BinderRenameSectionDetails val:
        :rtype: EventDetails
        """
        return cls('binder_rename_section_details', val)

    @classmethod
    def binder_reorder_page_details(cls, val):
        """
        Create an instance of this class set to the
        ``binder_reorder_page_details`` tag with value ``val``.

        :param BinderReorderPageDetails val:
        :rtype: EventDetails
        """
        return cls('binder_reorder_page_details', val)

    @classmethod
    def binder_reorder_section_details(cls, val):
        """
        Create an instance of this class set to the
        ``binder_reorder_section_details`` tag with value ``val``.

        :param BinderReorderSectionDetails val:
        :rtype: EventDetails
        """
        return cls('binder_reorder_section_details', val)

    @classmethod
    def paper_content_add_member_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_add_member_details`` tag with value ``val``.

        :param PaperContentAddMemberDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_add_member_details', val)

    @classmethod
    def paper_content_add_to_folder_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_add_to_folder_details`` tag with value ``val``.

        :param PaperContentAddToFolderDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_add_to_folder_details', val)

    @classmethod
    def paper_content_archive_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_archive_details`` tag with value ``val``.

        :param PaperContentArchiveDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_archive_details', val)

    @classmethod
    def paper_content_create_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_create_details`` tag with value ``val``.

        :param PaperContentCreateDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_create_details', val)

    @classmethod
    def paper_content_permanently_delete_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_permanently_delete_details`` tag with value ``val``.

        :param PaperContentPermanentlyDeleteDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_permanently_delete_details', val)

    @classmethod
    def paper_content_remove_from_folder_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_remove_from_folder_details`` tag with value ``val``.

        :param PaperContentRemoveFromFolderDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_remove_from_folder_details', val)

    @classmethod
    def paper_content_remove_member_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_remove_member_details`` tag with value ``val``.

        :param PaperContentRemoveMemberDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_remove_member_details', val)

    @classmethod
    def paper_content_rename_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_rename_details`` tag with value ``val``.

        :param PaperContentRenameDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_rename_details', val)

    @classmethod
    def paper_content_restore_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_restore_details`` tag with value ``val``.

        :param PaperContentRestoreDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_restore_details', val)

    @classmethod
    def paper_doc_add_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_add_comment_details`` tag with value ``val``.

        :param PaperDocAddCommentDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_add_comment_details', val)

    @classmethod
    def paper_doc_change_member_role_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_change_member_role_details`` tag with value ``val``.

        :param PaperDocChangeMemberRoleDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_change_member_role_details', val)

    @classmethod
    def paper_doc_change_sharing_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_change_sharing_policy_details`` tag with value ``val``.

        :param PaperDocChangeSharingPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_change_sharing_policy_details', val)

    @classmethod
    def paper_doc_change_subscription_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_change_subscription_details`` tag with value ``val``.

        :param PaperDocChangeSubscriptionDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_change_subscription_details', val)

    @classmethod
    def paper_doc_deleted_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_deleted_details`` tag with value ``val``.

        :param PaperDocDeletedDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_deleted_details', val)

    @classmethod
    def paper_doc_delete_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_delete_comment_details`` tag with value ``val``.

        :param PaperDocDeleteCommentDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_delete_comment_details', val)

    @classmethod
    def paper_doc_download_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_download_details`` tag with value ``val``.

        :param PaperDocDownloadDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_download_details', val)

    @classmethod
    def paper_doc_edit_details(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_edit_details``
        tag with value ``val``.

        :param PaperDocEditDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_edit_details', val)

    @classmethod
    def paper_doc_edit_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_edit_comment_details`` tag with value ``val``.

        :param PaperDocEditCommentDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_edit_comment_details', val)

    @classmethod
    def paper_doc_followed_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_followed_details`` tag with value ``val``.

        :param PaperDocFollowedDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_followed_details', val)

    @classmethod
    def paper_doc_mention_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_mention_details`` tag with value ``val``.

        :param PaperDocMentionDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_mention_details', val)

    @classmethod
    def paper_doc_ownership_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_ownership_changed_details`` tag with value ``val``.

        :param PaperDocOwnershipChangedDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_ownership_changed_details', val)

    @classmethod
    def paper_doc_request_access_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_request_access_details`` tag with value ``val``.

        :param PaperDocRequestAccessDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_request_access_details', val)

    @classmethod
    def paper_doc_resolve_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_resolve_comment_details`` tag with value ``val``.

        :param PaperDocResolveCommentDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_resolve_comment_details', val)

    @classmethod
    def paper_doc_revert_details(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_revert_details``
        tag with value ``val``.

        :param PaperDocRevertDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_revert_details', val)

    @classmethod
    def paper_doc_slack_share_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_slack_share_details`` tag with value ``val``.

        :param PaperDocSlackShareDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_slack_share_details', val)

    @classmethod
    def paper_doc_team_invite_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_team_invite_details`` tag with value ``val``.

        :param PaperDocTeamInviteDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_team_invite_details', val)

    @classmethod
    def paper_doc_trashed_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_trashed_details`` tag with value ``val``.

        :param PaperDocTrashedDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_trashed_details', val)

    @classmethod
    def paper_doc_unresolve_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_unresolve_comment_details`` tag with value ``val``.

        :param PaperDocUnresolveCommentDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_unresolve_comment_details', val)

    @classmethod
    def paper_doc_untrashed_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_untrashed_details`` tag with value ``val``.

        :param PaperDocUntrashedDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_untrashed_details', val)

    @classmethod
    def paper_doc_view_details(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_view_details``
        tag with value ``val``.

        :param PaperDocViewDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_view_details', val)

    @classmethod
    def paper_external_view_allow_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_external_view_allow_details`` tag with value ``val``.

        :param PaperExternalViewAllowDetails val:
        :rtype: EventDetails
        """
        return cls('paper_external_view_allow_details', val)

    @classmethod
    def paper_external_view_default_team_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_external_view_default_team_details`` tag with value ``val``.

        :param PaperExternalViewDefaultTeamDetails val:
        :rtype: EventDetails
        """
        return cls('paper_external_view_default_team_details', val)

    @classmethod
    def paper_external_view_forbid_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_external_view_forbid_details`` tag with value ``val``.

        :param PaperExternalViewForbidDetails val:
        :rtype: EventDetails
        """
        return cls('paper_external_view_forbid_details', val)

    @classmethod
    def paper_folder_change_subscription_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_folder_change_subscription_details`` tag with value ``val``.

        :param PaperFolderChangeSubscriptionDetails val:
        :rtype: EventDetails
        """
        return cls('paper_folder_change_subscription_details', val)

    @classmethod
    def paper_folder_deleted_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_folder_deleted_details`` tag with value ``val``.

        :param PaperFolderDeletedDetails val:
        :rtype: EventDetails
        """
        return cls('paper_folder_deleted_details', val)

    @classmethod
    def paper_folder_followed_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_folder_followed_details`` tag with value ``val``.

        :param PaperFolderFollowedDetails val:
        :rtype: EventDetails
        """
        return cls('paper_folder_followed_details', val)

    @classmethod
    def paper_folder_team_invite_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_folder_team_invite_details`` tag with value ``val``.

        :param PaperFolderTeamInviteDetails val:
        :rtype: EventDetails
        """
        return cls('paper_folder_team_invite_details', val)

    @classmethod
    def paper_published_link_change_permission_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_published_link_change_permission_details`` tag with value
        ``val``.

        :param PaperPublishedLinkChangePermissionDetails val:
        :rtype: EventDetails
        """
        return cls('paper_published_link_change_permission_details', val)

    @classmethod
    def paper_published_link_create_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_published_link_create_details`` tag with value ``val``.

        :param PaperPublishedLinkCreateDetails val:
        :rtype: EventDetails
        """
        return cls('paper_published_link_create_details', val)

    @classmethod
    def paper_published_link_disabled_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_published_link_disabled_details`` tag with value ``val``.

        :param PaperPublishedLinkDisabledDetails val:
        :rtype: EventDetails
        """
        return cls('paper_published_link_disabled_details', val)

    @classmethod
    def paper_published_link_view_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_published_link_view_details`` tag with value ``val``.

        :param PaperPublishedLinkViewDetails val:
        :rtype: EventDetails
        """
        return cls('paper_published_link_view_details', val)

    @classmethod
    def password_change_details(cls, val):
        """
        Create an instance of this class set to the ``password_change_details``
        tag with value ``val``.

        :param PasswordChangeDetails val:
        :rtype: EventDetails
        """
        return cls('password_change_details', val)

    @classmethod
    def password_reset_details(cls, val):
        """
        Create an instance of this class set to the ``password_reset_details``
        tag with value ``val``.

        :param PasswordResetDetails val:
        :rtype: EventDetails
        """
        return cls('password_reset_details', val)

    @classmethod
    def password_reset_all_details(cls, val):
        """
        Create an instance of this class set to the
        ``password_reset_all_details`` tag with value ``val``.

        :param PasswordResetAllDetails val:
        :rtype: EventDetails
        """
        return cls('password_reset_all_details', val)

    @classmethod
    def classification_create_report_details(cls, val):
        """
        Create an instance of this class set to the
        ``classification_create_report_details`` tag with value ``val``.

        :param ClassificationCreateReportDetails val:
        :rtype: EventDetails
        """
        return cls('classification_create_report_details', val)

    @classmethod
    def classification_create_report_fail_details(cls, val):
        """
        Create an instance of this class set to the
        ``classification_create_report_fail_details`` tag with value ``val``.

        :param ClassificationCreateReportFailDetails val:
        :rtype: EventDetails
        """
        return cls('classification_create_report_fail_details', val)

    @classmethod
    def emm_create_exceptions_report_details(cls, val):
        """
        Create an instance of this class set to the
        ``emm_create_exceptions_report_details`` tag with value ``val``.

        :param EmmCreateExceptionsReportDetails val:
        :rtype: EventDetails
        """
        return cls('emm_create_exceptions_report_details', val)

    @classmethod
    def emm_create_usage_report_details(cls, val):
        """
        Create an instance of this class set to the
        ``emm_create_usage_report_details`` tag with value ``val``.

        :param EmmCreateUsageReportDetails val:
        :rtype: EventDetails
        """
        return cls('emm_create_usage_report_details', val)

    @classmethod
    def export_members_report_details(cls, val):
        """
        Create an instance of this class set to the
        ``export_members_report_details`` tag with value ``val``.

        :param ExportMembersReportDetails val:
        :rtype: EventDetails
        """
        return cls('export_members_report_details', val)

    @classmethod
    def export_members_report_fail_details(cls, val):
        """
        Create an instance of this class set to the
        ``export_members_report_fail_details`` tag with value ``val``.

        :param ExportMembersReportFailDetails val:
        :rtype: EventDetails
        """
        return cls('export_members_report_fail_details', val)

    @classmethod
    def external_sharing_create_report_details(cls, val):
        """
        Create an instance of this class set to the
        ``external_sharing_create_report_details`` tag with value ``val``.

        :param ExternalSharingCreateReportDetails val:
        :rtype: EventDetails
        """
        return cls('external_sharing_create_report_details', val)

    @classmethod
    def external_sharing_report_failed_details(cls, val):
        """
        Create an instance of this class set to the
        ``external_sharing_report_failed_details`` tag with value ``val``.

        :param ExternalSharingReportFailedDetails val:
        :rtype: EventDetails
        """
        return cls('external_sharing_report_failed_details', val)

    @classmethod
    def no_expiration_link_gen_create_report_details(cls, val):
        """
        Create an instance of this class set to the
        ``no_expiration_link_gen_create_report_details`` tag with value ``val``.

        :param NoExpirationLinkGenCreateReportDetails val:
        :rtype: EventDetails
        """
        return cls('no_expiration_link_gen_create_report_details', val)

    @classmethod
    def no_expiration_link_gen_report_failed_details(cls, val):
        """
        Create an instance of this class set to the
        ``no_expiration_link_gen_report_failed_details`` tag with value ``val``.

        :param NoExpirationLinkGenReportFailedDetails val:
        :rtype: EventDetails
        """
        return cls('no_expiration_link_gen_report_failed_details', val)

    @classmethod
    def no_password_link_gen_create_report_details(cls, val):
        """
        Create an instance of this class set to the
        ``no_password_link_gen_create_report_details`` tag with value ``val``.

        :param NoPasswordLinkGenCreateReportDetails val:
        :rtype: EventDetails
        """
        return cls('no_password_link_gen_create_report_details', val)

    @classmethod
    def no_password_link_gen_report_failed_details(cls, val):
        """
        Create an instance of this class set to the
        ``no_password_link_gen_report_failed_details`` tag with value ``val``.

        :param NoPasswordLinkGenReportFailedDetails val:
        :rtype: EventDetails
        """
        return cls('no_password_link_gen_report_failed_details', val)

    @classmethod
    def no_password_link_view_create_report_details(cls, val):
        """
        Create an instance of this class set to the
        ``no_password_link_view_create_report_details`` tag with value ``val``.

        :param NoPasswordLinkViewCreateReportDetails val:
        :rtype: EventDetails
        """
        return cls('no_password_link_view_create_report_details', val)

    @classmethod
    def no_password_link_view_report_failed_details(cls, val):
        """
        Create an instance of this class set to the
        ``no_password_link_view_report_failed_details`` tag with value ``val``.

        :param NoPasswordLinkViewReportFailedDetails val:
        :rtype: EventDetails
        """
        return cls('no_password_link_view_report_failed_details', val)

    @classmethod
    def outdated_link_view_create_report_details(cls, val):
        """
        Create an instance of this class set to the
        ``outdated_link_view_create_report_details`` tag with value ``val``.

        :param OutdatedLinkViewCreateReportDetails val:
        :rtype: EventDetails
        """
        return cls('outdated_link_view_create_report_details', val)

    @classmethod
    def outdated_link_view_report_failed_details(cls, val):
        """
        Create an instance of this class set to the
        ``outdated_link_view_report_failed_details`` tag with value ``val``.

        :param OutdatedLinkViewReportFailedDetails val:
        :rtype: EventDetails
        """
        return cls('outdated_link_view_report_failed_details', val)

    @classmethod
    def paper_admin_export_start_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_admin_export_start_details`` tag with value ``val``.

        :param PaperAdminExportStartDetails val:
        :rtype: EventDetails
        """
        return cls('paper_admin_export_start_details', val)

    @classmethod
    def smart_sync_create_admin_privilege_report_details(cls, val):
        """
        Create an instance of this class set to the
        ``smart_sync_create_admin_privilege_report_details`` tag with value
        ``val``.

        :param SmartSyncCreateAdminPrivilegeReportDetails val:
        :rtype: EventDetails
        """
        return cls('smart_sync_create_admin_privilege_report_details', val)

    @classmethod
    def team_activity_create_report_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_activity_create_report_details`` tag with value ``val``.

        :param TeamActivityCreateReportDetails val:
        :rtype: EventDetails
        """
        return cls('team_activity_create_report_details', val)

    @classmethod
    def team_activity_create_report_fail_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_activity_create_report_fail_details`` tag with value ``val``.

        :param TeamActivityCreateReportFailDetails val:
        :rtype: EventDetails
        """
        return cls('team_activity_create_report_fail_details', val)

    @classmethod
    def collection_share_details(cls, val):
        """
        Create an instance of this class set to the ``collection_share_details``
        tag with value ``val``.

        :param CollectionShareDetails val:
        :rtype: EventDetails
        """
        return cls('collection_share_details', val)

    @classmethod
    def file_transfers_file_add_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_transfers_file_add_details`` tag with value ``val``.

        :param FileTransfersFileAddDetails val:
        :rtype: EventDetails
        """
        return cls('file_transfers_file_add_details', val)

    @classmethod
    def file_transfers_transfer_delete_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_transfers_transfer_delete_details`` tag with value ``val``.

        :param FileTransfersTransferDeleteDetails val:
        :rtype: EventDetails
        """
        return cls('file_transfers_transfer_delete_details', val)

    @classmethod
    def file_transfers_transfer_download_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_transfers_transfer_download_details`` tag with value ``val``.

        :param FileTransfersTransferDownloadDetails val:
        :rtype: EventDetails
        """
        return cls('file_transfers_transfer_download_details', val)

    @classmethod
    def file_transfers_transfer_send_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_transfers_transfer_send_details`` tag with value ``val``.

        :param FileTransfersTransferSendDetails val:
        :rtype: EventDetails
        """
        return cls('file_transfers_transfer_send_details', val)

    @classmethod
    def file_transfers_transfer_view_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_transfers_transfer_view_details`` tag with value ``val``.

        :param FileTransfersTransferViewDetails val:
        :rtype: EventDetails
        """
        return cls('file_transfers_transfer_view_details', val)

    @classmethod
    def note_acl_invite_only_details(cls, val):
        """
        Create an instance of this class set to the
        ``note_acl_invite_only_details`` tag with value ``val``.

        :param NoteAclInviteOnlyDetails val:
        :rtype: EventDetails
        """
        return cls('note_acl_invite_only_details', val)

    @classmethod
    def note_acl_link_details(cls, val):
        """
        Create an instance of this class set to the ``note_acl_link_details``
        tag with value ``val``.

        :param NoteAclLinkDetails val:
        :rtype: EventDetails
        """
        return cls('note_acl_link_details', val)

    @classmethod
    def note_acl_team_link_details(cls, val):
        """
        Create an instance of this class set to the
        ``note_acl_team_link_details`` tag with value ``val``.

        :param NoteAclTeamLinkDetails val:
        :rtype: EventDetails
        """
        return cls('note_acl_team_link_details', val)

    @classmethod
    def note_shared_details(cls, val):
        """
        Create an instance of this class set to the ``note_shared_details`` tag
        with value ``val``.

        :param NoteSharedDetails val:
        :rtype: EventDetails
        """
        return cls('note_shared_details', val)

    @classmethod
    def note_share_receive_details(cls, val):
        """
        Create an instance of this class set to the
        ``note_share_receive_details`` tag with value ``val``.

        :param NoteShareReceiveDetails val:
        :rtype: EventDetails
        """
        return cls('note_share_receive_details', val)

    @classmethod
    def open_note_shared_details(cls, val):
        """
        Create an instance of this class set to the ``open_note_shared_details``
        tag with value ``val``.

        :param OpenNoteSharedDetails val:
        :rtype: EventDetails
        """
        return cls('open_note_shared_details', val)

    @classmethod
    def sf_add_group_details(cls, val):
        """
        Create an instance of this class set to the ``sf_add_group_details`` tag
        with value ``val``.

        :param SfAddGroupDetails val:
        :rtype: EventDetails
        """
        return cls('sf_add_group_details', val)

    @classmethod
    def sf_allow_non_members_to_view_shared_links_details(cls, val):
        """
        Create an instance of this class set to the
        ``sf_allow_non_members_to_view_shared_links_details`` tag with value
        ``val``.

        :param SfAllowNonMembersToViewSharedLinksDetails val:
        :rtype: EventDetails
        """
        return cls('sf_allow_non_members_to_view_shared_links_details', val)

    @classmethod
    def sf_external_invite_warn_details(cls, val):
        """
        Create an instance of this class set to the
        ``sf_external_invite_warn_details`` tag with value ``val``.

        :param SfExternalInviteWarnDetails val:
        :rtype: EventDetails
        """
        return cls('sf_external_invite_warn_details', val)

    @classmethod
    def sf_fb_invite_details(cls, val):
        """
        Create an instance of this class set to the ``sf_fb_invite_details`` tag
        with value ``val``.

        :param SfFbInviteDetails val:
        :rtype: EventDetails
        """
        return cls('sf_fb_invite_details', val)

    @classmethod
    def sf_fb_invite_change_role_details(cls, val):
        """
        Create an instance of this class set to the
        ``sf_fb_invite_change_role_details`` tag with value ``val``.

        :param SfFbInviteChangeRoleDetails val:
        :rtype: EventDetails
        """
        return cls('sf_fb_invite_change_role_details', val)

    @classmethod
    def sf_fb_uninvite_details(cls, val):
        """
        Create an instance of this class set to the ``sf_fb_uninvite_details``
        tag with value ``val``.

        :param SfFbUninviteDetails val:
        :rtype: EventDetails
        """
        return cls('sf_fb_uninvite_details', val)

    @classmethod
    def sf_invite_group_details(cls, val):
        """
        Create an instance of this class set to the ``sf_invite_group_details``
        tag with value ``val``.

        :param SfInviteGroupDetails val:
        :rtype: EventDetails
        """
        return cls('sf_invite_group_details', val)

    @classmethod
    def sf_team_grant_access_details(cls, val):
        """
        Create an instance of this class set to the
        ``sf_team_grant_access_details`` tag with value ``val``.

        :param SfTeamGrantAccessDetails val:
        :rtype: EventDetails
        """
        return cls('sf_team_grant_access_details', val)

    @classmethod
    def sf_team_invite_details(cls, val):
        """
        Create an instance of this class set to the ``sf_team_invite_details``
        tag with value ``val``.

        :param SfTeamInviteDetails val:
        :rtype: EventDetails
        """
        return cls('sf_team_invite_details', val)

    @classmethod
    def sf_team_invite_change_role_details(cls, val):
        """
        Create an instance of this class set to the
        ``sf_team_invite_change_role_details`` tag with value ``val``.

        :param SfTeamInviteChangeRoleDetails val:
        :rtype: EventDetails
        """
        return cls('sf_team_invite_change_role_details', val)

    @classmethod
    def sf_team_join_details(cls, val):
        """
        Create an instance of this class set to the ``sf_team_join_details`` tag
        with value ``val``.

        :param SfTeamJoinDetails val:
        :rtype: EventDetails
        """
        return cls('sf_team_join_details', val)

    @classmethod
    def sf_team_join_from_oob_link_details(cls, val):
        """
        Create an instance of this class set to the
        ``sf_team_join_from_oob_link_details`` tag with value ``val``.

        :param SfTeamJoinFromOobLinkDetails val:
        :rtype: EventDetails
        """
        return cls('sf_team_join_from_oob_link_details', val)

    @classmethod
    def sf_team_uninvite_details(cls, val):
        """
        Create an instance of this class set to the ``sf_team_uninvite_details``
        tag with value ``val``.

        :param SfTeamUninviteDetails val:
        :rtype: EventDetails
        """
        return cls('sf_team_uninvite_details', val)

    @classmethod
    def shared_content_add_invitees_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_add_invitees_details`` tag with value ``val``.

        :param SharedContentAddInviteesDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_add_invitees_details', val)

    @classmethod
    def shared_content_add_link_expiry_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_add_link_expiry_details`` tag with value ``val``.

        :param SharedContentAddLinkExpiryDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_add_link_expiry_details', val)

    @classmethod
    def shared_content_add_link_password_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_add_link_password_details`` tag with value ``val``.

        :param SharedContentAddLinkPasswordDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_add_link_password_details', val)

    @classmethod
    def shared_content_add_member_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_add_member_details`` tag with value ``val``.

        :param SharedContentAddMemberDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_add_member_details', val)

    @classmethod
    def shared_content_change_downloads_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_downloads_policy_details`` tag with value
        ``val``.

        :param SharedContentChangeDownloadsPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_change_downloads_policy_details', val)

    @classmethod
    def shared_content_change_invitee_role_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_invitee_role_details`` tag with value ``val``.

        :param SharedContentChangeInviteeRoleDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_change_invitee_role_details', val)

    @classmethod
    def shared_content_change_link_audience_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_link_audience_details`` tag with value ``val``.

        :param SharedContentChangeLinkAudienceDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_change_link_audience_details', val)

    @classmethod
    def shared_content_change_link_expiry_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_link_expiry_details`` tag with value ``val``.

        :param SharedContentChangeLinkExpiryDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_change_link_expiry_details', val)

    @classmethod
    def shared_content_change_link_password_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_link_password_details`` tag with value ``val``.

        :param SharedContentChangeLinkPasswordDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_change_link_password_details', val)

    @classmethod
    def shared_content_change_member_role_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_member_role_details`` tag with value ``val``.

        :param SharedContentChangeMemberRoleDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_change_member_role_details', val)

    @classmethod
    def shared_content_change_viewer_info_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_viewer_info_policy_details`` tag with value
        ``val``.

        :param SharedContentChangeViewerInfoPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_change_viewer_info_policy_details', val)

    @classmethod
    def shared_content_claim_invitation_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_claim_invitation_details`` tag with value ``val``.

        :param SharedContentClaimInvitationDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_claim_invitation_details', val)

    @classmethod
    def shared_content_copy_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_copy_details`` tag with value ``val``.

        :param SharedContentCopyDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_copy_details', val)

    @classmethod
    def shared_content_download_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_download_details`` tag with value ``val``.

        :param SharedContentDownloadDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_download_details', val)

    @classmethod
    def shared_content_relinquish_membership_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_relinquish_membership_details`` tag with value ``val``.

        :param SharedContentRelinquishMembershipDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_relinquish_membership_details', val)

    @classmethod
    def shared_content_remove_invitees_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_remove_invitees_details`` tag with value ``val``.

        :param SharedContentRemoveInviteesDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_remove_invitees_details', val)

    @classmethod
    def shared_content_remove_link_expiry_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_remove_link_expiry_details`` tag with value ``val``.

        :param SharedContentRemoveLinkExpiryDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_remove_link_expiry_details', val)

    @classmethod
    def shared_content_remove_link_password_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_remove_link_password_details`` tag with value ``val``.

        :param SharedContentRemoveLinkPasswordDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_remove_link_password_details', val)

    @classmethod
    def shared_content_remove_member_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_remove_member_details`` tag with value ``val``.

        :param SharedContentRemoveMemberDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_remove_member_details', val)

    @classmethod
    def shared_content_request_access_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_request_access_details`` tag with value ``val``.

        :param SharedContentRequestAccessDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_request_access_details', val)

    @classmethod
    def shared_content_restore_invitees_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_restore_invitees_details`` tag with value ``val``.

        :param SharedContentRestoreInviteesDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_restore_invitees_details', val)

    @classmethod
    def shared_content_restore_member_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_restore_member_details`` tag with value ``val``.

        :param SharedContentRestoreMemberDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_restore_member_details', val)

    @classmethod
    def shared_content_unshare_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_unshare_details`` tag with value ``val``.

        :param SharedContentUnshareDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_unshare_details', val)

    @classmethod
    def shared_content_view_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_view_details`` tag with value ``val``.

        :param SharedContentViewDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_view_details', val)

    @classmethod
    def shared_folder_change_link_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_change_link_policy_details`` tag with value ``val``.

        :param SharedFolderChangeLinkPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_change_link_policy_details', val)

    @classmethod
    def shared_folder_change_members_inheritance_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_change_members_inheritance_policy_details`` tag with
        value ``val``.

        :param SharedFolderChangeMembersInheritancePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_change_members_inheritance_policy_details', val)

    @classmethod
    def shared_folder_change_members_management_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_change_members_management_policy_details`` tag with
        value ``val``.

        :param SharedFolderChangeMembersManagementPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_change_members_management_policy_details', val)

    @classmethod
    def shared_folder_change_members_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_change_members_policy_details`` tag with value ``val``.

        :param SharedFolderChangeMembersPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_change_members_policy_details', val)

    @classmethod
    def shared_folder_create_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_create_details`` tag with value ``val``.

        :param SharedFolderCreateDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_create_details', val)

    @classmethod
    def shared_folder_decline_invitation_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_decline_invitation_details`` tag with value ``val``.

        :param SharedFolderDeclineInvitationDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_decline_invitation_details', val)

    @classmethod
    def shared_folder_mount_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_mount_details`` tag with value ``val``.

        :param SharedFolderMountDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_mount_details', val)

    @classmethod
    def shared_folder_nest_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_nest_details`` tag with value ``val``.

        :param SharedFolderNestDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_nest_details', val)

    @classmethod
    def shared_folder_transfer_ownership_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_transfer_ownership_details`` tag with value ``val``.

        :param SharedFolderTransferOwnershipDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_transfer_ownership_details', val)

    @classmethod
    def shared_folder_unmount_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_unmount_details`` tag with value ``val``.

        :param SharedFolderUnmountDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_unmount_details', val)

    @classmethod
    def shared_link_add_expiry_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_add_expiry_details`` tag with value ``val``.

        :param SharedLinkAddExpiryDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_add_expiry_details', val)

    @classmethod
    def shared_link_change_expiry_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_change_expiry_details`` tag with value ``val``.

        :param SharedLinkChangeExpiryDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_change_expiry_details', val)

    @classmethod
    def shared_link_change_visibility_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_change_visibility_details`` tag with value ``val``.

        :param SharedLinkChangeVisibilityDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_change_visibility_details', val)

    @classmethod
    def shared_link_copy_details(cls, val):
        """
        Create an instance of this class set to the ``shared_link_copy_details``
        tag with value ``val``.

        :param SharedLinkCopyDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_copy_details', val)

    @classmethod
    def shared_link_create_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_create_details`` tag with value ``val``.

        :param SharedLinkCreateDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_create_details', val)

    @classmethod
    def shared_link_disable_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_disable_details`` tag with value ``val``.

        :param SharedLinkDisableDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_disable_details', val)

    @classmethod
    def shared_link_download_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_download_details`` tag with value ``val``.

        :param SharedLinkDownloadDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_download_details', val)

    @classmethod
    def shared_link_remove_expiry_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_remove_expiry_details`` tag with value ``val``.

        :param SharedLinkRemoveExpiryDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_remove_expiry_details', val)

    @classmethod
    def shared_link_settings_add_expiration_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_settings_add_expiration_details`` tag with value ``val``.

        :param SharedLinkSettingsAddExpirationDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_settings_add_expiration_details', val)

    @classmethod
    def shared_link_settings_add_password_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_settings_add_password_details`` tag with value ``val``.

        :param SharedLinkSettingsAddPasswordDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_settings_add_password_details', val)

    @classmethod
    def shared_link_settings_allow_download_disabled_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_settings_allow_download_disabled_details`` tag with value
        ``val``.

        :param SharedLinkSettingsAllowDownloadDisabledDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_settings_allow_download_disabled_details', val)

    @classmethod
    def shared_link_settings_allow_download_enabled_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_settings_allow_download_enabled_details`` tag with value
        ``val``.

        :param SharedLinkSettingsAllowDownloadEnabledDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_settings_allow_download_enabled_details', val)

    @classmethod
    def shared_link_settings_change_audience_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_settings_change_audience_details`` tag with value ``val``.

        :param SharedLinkSettingsChangeAudienceDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_settings_change_audience_details', val)

    @classmethod
    def shared_link_settings_change_expiration_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_settings_change_expiration_details`` tag with value
        ``val``.

        :param SharedLinkSettingsChangeExpirationDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_settings_change_expiration_details', val)

    @classmethod
    def shared_link_settings_change_password_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_settings_change_password_details`` tag with value ``val``.

        :param SharedLinkSettingsChangePasswordDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_settings_change_password_details', val)

    @classmethod
    def shared_link_settings_remove_expiration_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_settings_remove_expiration_details`` tag with value
        ``val``.

        :param SharedLinkSettingsRemoveExpirationDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_settings_remove_expiration_details', val)

    @classmethod
    def shared_link_settings_remove_password_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_settings_remove_password_details`` tag with value ``val``.

        :param SharedLinkSettingsRemovePasswordDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_settings_remove_password_details', val)

    @classmethod
    def shared_link_share_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_share_details`` tag with value ``val``.

        :param SharedLinkShareDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_share_details', val)

    @classmethod
    def shared_link_view_details(cls, val):
        """
        Create an instance of this class set to the ``shared_link_view_details``
        tag with value ``val``.

        :param SharedLinkViewDetails val:
        :rtype: EventDetails
        """
        return cls('shared_link_view_details', val)

    @classmethod
    def shared_note_opened_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_note_opened_details`` tag with value ``val``.

        :param SharedNoteOpenedDetails val:
        :rtype: EventDetails
        """
        return cls('shared_note_opened_details', val)

    @classmethod
    def shmodel_disable_downloads_details(cls, val):
        """
        Create an instance of this class set to the
        ``shmodel_disable_downloads_details`` tag with value ``val``.

        :param ShmodelDisableDownloadsDetails val:
        :rtype: EventDetails
        """
        return cls('shmodel_disable_downloads_details', val)

    @classmethod
    def shmodel_enable_downloads_details(cls, val):
        """
        Create an instance of this class set to the
        ``shmodel_enable_downloads_details`` tag with value ``val``.

        :param ShmodelEnableDownloadsDetails val:
        :rtype: EventDetails
        """
        return cls('shmodel_enable_downloads_details', val)

    @classmethod
    def shmodel_group_share_details(cls, val):
        """
        Create an instance of this class set to the
        ``shmodel_group_share_details`` tag with value ``val``.

        :param ShmodelGroupShareDetails val:
        :rtype: EventDetails
        """
        return cls('shmodel_group_share_details', val)

    @classmethod
    def showcase_access_granted_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_access_granted_details`` tag with value ``val``.

        :param ShowcaseAccessGrantedDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_access_granted_details', val)

    @classmethod
    def showcase_add_member_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_add_member_details`` tag with value ``val``.

        :param ShowcaseAddMemberDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_add_member_details', val)

    @classmethod
    def showcase_archived_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_archived_details`` tag with value ``val``.

        :param ShowcaseArchivedDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_archived_details', val)

    @classmethod
    def showcase_created_details(cls, val):
        """
        Create an instance of this class set to the ``showcase_created_details``
        tag with value ``val``.

        :param ShowcaseCreatedDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_created_details', val)

    @classmethod
    def showcase_delete_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_delete_comment_details`` tag with value ``val``.

        :param ShowcaseDeleteCommentDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_delete_comment_details', val)

    @classmethod
    def showcase_edited_details(cls, val):
        """
        Create an instance of this class set to the ``showcase_edited_details``
        tag with value ``val``.

        :param ShowcaseEditedDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_edited_details', val)

    @classmethod
    def showcase_edit_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_edit_comment_details`` tag with value ``val``.

        :param ShowcaseEditCommentDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_edit_comment_details', val)

    @classmethod
    def showcase_file_added_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_file_added_details`` tag with value ``val``.

        :param ShowcaseFileAddedDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_file_added_details', val)

    @classmethod
    def showcase_file_download_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_file_download_details`` tag with value ``val``.

        :param ShowcaseFileDownloadDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_file_download_details', val)

    @classmethod
    def showcase_file_removed_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_file_removed_details`` tag with value ``val``.

        :param ShowcaseFileRemovedDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_file_removed_details', val)

    @classmethod
    def showcase_file_view_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_file_view_details`` tag with value ``val``.

        :param ShowcaseFileViewDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_file_view_details', val)

    @classmethod
    def showcase_permanently_deleted_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_permanently_deleted_details`` tag with value ``val``.

        :param ShowcasePermanentlyDeletedDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_permanently_deleted_details', val)

    @classmethod
    def showcase_post_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_post_comment_details`` tag with value ``val``.

        :param ShowcasePostCommentDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_post_comment_details', val)

    @classmethod
    def showcase_remove_member_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_remove_member_details`` tag with value ``val``.

        :param ShowcaseRemoveMemberDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_remove_member_details', val)

    @classmethod
    def showcase_renamed_details(cls, val):
        """
        Create an instance of this class set to the ``showcase_renamed_details``
        tag with value ``val``.

        :param ShowcaseRenamedDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_renamed_details', val)

    @classmethod
    def showcase_request_access_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_request_access_details`` tag with value ``val``.

        :param ShowcaseRequestAccessDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_request_access_details', val)

    @classmethod
    def showcase_resolve_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_resolve_comment_details`` tag with value ``val``.

        :param ShowcaseResolveCommentDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_resolve_comment_details', val)

    @classmethod
    def showcase_restored_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_restored_details`` tag with value ``val``.

        :param ShowcaseRestoredDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_restored_details', val)

    @classmethod
    def showcase_trashed_details(cls, val):
        """
        Create an instance of this class set to the ``showcase_trashed_details``
        tag with value ``val``.

        :param ShowcaseTrashedDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_trashed_details', val)

    @classmethod
    def showcase_trashed_deprecated_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_trashed_deprecated_details`` tag with value ``val``.

        :param ShowcaseTrashedDeprecatedDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_trashed_deprecated_details', val)

    @classmethod
    def showcase_unresolve_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_unresolve_comment_details`` tag with value ``val``.

        :param ShowcaseUnresolveCommentDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_unresolve_comment_details', val)

    @classmethod
    def showcase_untrashed_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_untrashed_details`` tag with value ``val``.

        :param ShowcaseUntrashedDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_untrashed_details', val)

    @classmethod
    def showcase_untrashed_deprecated_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_untrashed_deprecated_details`` tag with value ``val``.

        :param ShowcaseUntrashedDeprecatedDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_untrashed_deprecated_details', val)

    @classmethod
    def showcase_view_details(cls, val):
        """
        Create an instance of this class set to the ``showcase_view_details``
        tag with value ``val``.

        :param ShowcaseViewDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_view_details', val)

    @classmethod
    def sso_add_cert_details(cls, val):
        """
        Create an instance of this class set to the ``sso_add_cert_details`` tag
        with value ``val``.

        :param SsoAddCertDetails val:
        :rtype: EventDetails
        """
        return cls('sso_add_cert_details', val)

    @classmethod
    def sso_add_login_url_details(cls, val):
        """
        Create an instance of this class set to the
        ``sso_add_login_url_details`` tag with value ``val``.

        :param SsoAddLoginUrlDetails val:
        :rtype: EventDetails
        """
        return cls('sso_add_login_url_details', val)

    @classmethod
    def sso_add_logout_url_details(cls, val):
        """
        Create an instance of this class set to the
        ``sso_add_logout_url_details`` tag with value ``val``.

        :param SsoAddLogoutUrlDetails val:
        :rtype: EventDetails
        """
        return cls('sso_add_logout_url_details', val)

    @classmethod
    def sso_change_cert_details(cls, val):
        """
        Create an instance of this class set to the ``sso_change_cert_details``
        tag with value ``val``.

        :param SsoChangeCertDetails val:
        :rtype: EventDetails
        """
        return cls('sso_change_cert_details', val)

    @classmethod
    def sso_change_login_url_details(cls, val):
        """
        Create an instance of this class set to the
        ``sso_change_login_url_details`` tag with value ``val``.

        :param SsoChangeLoginUrlDetails val:
        :rtype: EventDetails
        """
        return cls('sso_change_login_url_details', val)

    @classmethod
    def sso_change_logout_url_details(cls, val):
        """
        Create an instance of this class set to the
        ``sso_change_logout_url_details`` tag with value ``val``.

        :param SsoChangeLogoutUrlDetails val:
        :rtype: EventDetails
        """
        return cls('sso_change_logout_url_details', val)

    @classmethod
    def sso_change_saml_identity_mode_details(cls, val):
        """
        Create an instance of this class set to the
        ``sso_change_saml_identity_mode_details`` tag with value ``val``.

        :param SsoChangeSamlIdentityModeDetails val:
        :rtype: EventDetails
        """
        return cls('sso_change_saml_identity_mode_details', val)

    @classmethod
    def sso_remove_cert_details(cls, val):
        """
        Create an instance of this class set to the ``sso_remove_cert_details``
        tag with value ``val``.

        :param SsoRemoveCertDetails val:
        :rtype: EventDetails
        """
        return cls('sso_remove_cert_details', val)

    @classmethod
    def sso_remove_login_url_details(cls, val):
        """
        Create an instance of this class set to the
        ``sso_remove_login_url_details`` tag with value ``val``.

        :param SsoRemoveLoginUrlDetails val:
        :rtype: EventDetails
        """
        return cls('sso_remove_login_url_details', val)

    @classmethod
    def sso_remove_logout_url_details(cls, val):
        """
        Create an instance of this class set to the
        ``sso_remove_logout_url_details`` tag with value ``val``.

        :param SsoRemoveLogoutUrlDetails val:
        :rtype: EventDetails
        """
        return cls('sso_remove_logout_url_details', val)

    @classmethod
    def team_folder_change_status_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_folder_change_status_details`` tag with value ``val``.

        :param TeamFolderChangeStatusDetails val:
        :rtype: EventDetails
        """
        return cls('team_folder_change_status_details', val)

    @classmethod
    def team_folder_create_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_folder_create_details`` tag with value ``val``.

        :param TeamFolderCreateDetails val:
        :rtype: EventDetails
        """
        return cls('team_folder_create_details', val)

    @classmethod
    def team_folder_downgrade_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_folder_downgrade_details`` tag with value ``val``.

        :param TeamFolderDowngradeDetails val:
        :rtype: EventDetails
        """
        return cls('team_folder_downgrade_details', val)

    @classmethod
    def team_folder_permanently_delete_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_folder_permanently_delete_details`` tag with value ``val``.

        :param TeamFolderPermanentlyDeleteDetails val:
        :rtype: EventDetails
        """
        return cls('team_folder_permanently_delete_details', val)

    @classmethod
    def team_folder_rename_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_folder_rename_details`` tag with value ``val``.

        :param TeamFolderRenameDetails val:
        :rtype: EventDetails
        """
        return cls('team_folder_rename_details', val)

    @classmethod
    def team_selective_sync_settings_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_selective_sync_settings_changed_details`` tag with value ``val``.

        :param TeamSelectiveSyncSettingsChangedDetails val:
        :rtype: EventDetails
        """
        return cls('team_selective_sync_settings_changed_details', val)

    @classmethod
    def account_capture_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``account_capture_change_policy_details`` tag with value ``val``.

        :param AccountCaptureChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('account_capture_change_policy_details', val)

    @classmethod
    def allow_download_disabled_details(cls, val):
        """
        Create an instance of this class set to the
        ``allow_download_disabled_details`` tag with value ``val``.

        :param AllowDownloadDisabledDetails val:
        :rtype: EventDetails
        """
        return cls('allow_download_disabled_details', val)

    @classmethod
    def allow_download_enabled_details(cls, val):
        """
        Create an instance of this class set to the
        ``allow_download_enabled_details`` tag with value ``val``.

        :param AllowDownloadEnabledDetails val:
        :rtype: EventDetails
        """
        return cls('allow_download_enabled_details', val)

    @classmethod
    def app_permissions_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``app_permissions_changed_details`` tag with value ``val``.

        :param AppPermissionsChangedDetails val:
        :rtype: EventDetails
        """
        return cls('app_permissions_changed_details', val)

    @classmethod
    def camera_uploads_policy_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``camera_uploads_policy_changed_details`` tag with value ``val``.

        :param CameraUploadsPolicyChangedDetails val:
        :rtype: EventDetails
        """
        return cls('camera_uploads_policy_changed_details', val)

    @classmethod
    def capture_transcript_policy_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``capture_transcript_policy_changed_details`` tag with value ``val``.

        :param CaptureTranscriptPolicyChangedDetails val:
        :rtype: EventDetails
        """
        return cls('capture_transcript_policy_changed_details', val)

    @classmethod
    def classification_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``classification_change_policy_details`` tag with value ``val``.

        :param ClassificationChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('classification_change_policy_details', val)

    @classmethod
    def computer_backup_policy_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``computer_backup_policy_changed_details`` tag with value ``val``.

        :param ComputerBackupPolicyChangedDetails val:
        :rtype: EventDetails
        """
        return cls('computer_backup_policy_changed_details', val)

    @classmethod
    def content_administration_policy_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``content_administration_policy_changed_details`` tag with value
        ``val``.

        :param ContentAdministrationPolicyChangedDetails val:
        :rtype: EventDetails
        """
        return cls('content_administration_policy_changed_details', val)

    @classmethod
    def data_placement_restriction_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``data_placement_restriction_change_policy_details`` tag with value
        ``val``.

        :param DataPlacementRestrictionChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('data_placement_restriction_change_policy_details', val)

    @classmethod
    def data_placement_restriction_satisfy_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``data_placement_restriction_satisfy_policy_details`` tag with value
        ``val``.

        :param DataPlacementRestrictionSatisfyPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('data_placement_restriction_satisfy_policy_details', val)

    @classmethod
    def device_approvals_add_exception_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_approvals_add_exception_details`` tag with value ``val``.

        :param DeviceApprovalsAddExceptionDetails val:
        :rtype: EventDetails
        """
        return cls('device_approvals_add_exception_details', val)

    @classmethod
    def device_approvals_change_desktop_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_approvals_change_desktop_policy_details`` tag with value
        ``val``.

        :param DeviceApprovalsChangeDesktopPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('device_approvals_change_desktop_policy_details', val)

    @classmethod
    def device_approvals_change_mobile_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_approvals_change_mobile_policy_details`` tag with value
        ``val``.

        :param DeviceApprovalsChangeMobilePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('device_approvals_change_mobile_policy_details', val)

    @classmethod
    def device_approvals_change_overage_action_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_approvals_change_overage_action_details`` tag with value
        ``val``.

        :param DeviceApprovalsChangeOverageActionDetails val:
        :rtype: EventDetails
        """
        return cls('device_approvals_change_overage_action_details', val)

    @classmethod
    def device_approvals_change_unlink_action_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_approvals_change_unlink_action_details`` tag with value
        ``val``.

        :param DeviceApprovalsChangeUnlinkActionDetails val:
        :rtype: EventDetails
        """
        return cls('device_approvals_change_unlink_action_details', val)

    @classmethod
    def device_approvals_remove_exception_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_approvals_remove_exception_details`` tag with value ``val``.

        :param DeviceApprovalsRemoveExceptionDetails val:
        :rtype: EventDetails
        """
        return cls('device_approvals_remove_exception_details', val)

    @classmethod
    def directory_restrictions_add_members_details(cls, val):
        """
        Create an instance of this class set to the
        ``directory_restrictions_add_members_details`` tag with value ``val``.

        :param DirectoryRestrictionsAddMembersDetails val:
        :rtype: EventDetails
        """
        return cls('directory_restrictions_add_members_details', val)

    @classmethod
    def directory_restrictions_remove_members_details(cls, val):
        """
        Create an instance of this class set to the
        ``directory_restrictions_remove_members_details`` tag with value
        ``val``.

        :param DirectoryRestrictionsRemoveMembersDetails val:
        :rtype: EventDetails
        """
        return cls('directory_restrictions_remove_members_details', val)

    @classmethod
    def email_ingest_policy_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``email_ingest_policy_changed_details`` tag with value ``val``.

        :param EmailIngestPolicyChangedDetails val:
        :rtype: EventDetails
        """
        return cls('email_ingest_policy_changed_details', val)

    @classmethod
    def emm_add_exception_details(cls, val):
        """
        Create an instance of this class set to the
        ``emm_add_exception_details`` tag with value ``val``.

        :param EmmAddExceptionDetails val:
        :rtype: EventDetails
        """
        return cls('emm_add_exception_details', val)

    @classmethod
    def emm_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``emm_change_policy_details`` tag with value ``val``.

        :param EmmChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('emm_change_policy_details', val)

    @classmethod
    def emm_remove_exception_details(cls, val):
        """
        Create an instance of this class set to the
        ``emm_remove_exception_details`` tag with value ``val``.

        :param EmmRemoveExceptionDetails val:
        :rtype: EventDetails
        """
        return cls('emm_remove_exception_details', val)

    @classmethod
    def extended_version_history_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``extended_version_history_change_policy_details`` tag with value
        ``val``.

        :param ExtendedVersionHistoryChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('extended_version_history_change_policy_details', val)

    @classmethod
    def external_drive_backup_policy_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``external_drive_backup_policy_changed_details`` tag with value ``val``.

        :param ExternalDriveBackupPolicyChangedDetails val:
        :rtype: EventDetails
        """
        return cls('external_drive_backup_policy_changed_details', val)

    @classmethod
    def file_comments_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_comments_change_policy_details`` tag with value ``val``.

        :param FileCommentsChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('file_comments_change_policy_details', val)

    @classmethod
    def file_locking_policy_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_locking_policy_changed_details`` tag with value ``val``.

        :param FileLockingPolicyChangedDetails val:
        :rtype: EventDetails
        """
        return cls('file_locking_policy_changed_details', val)

    @classmethod
    def file_requests_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_requests_change_policy_details`` tag with value ``val``.

        :param FileRequestsChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('file_requests_change_policy_details', val)

    @classmethod
    def file_requests_emails_enabled_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_requests_emails_enabled_details`` tag with value ``val``.

        :param FileRequestsEmailsEnabledDetails val:
        :rtype: EventDetails
        """
        return cls('file_requests_emails_enabled_details', val)

    @classmethod
    def file_requests_emails_restricted_to_team_only_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_requests_emails_restricted_to_team_only_details`` tag with value
        ``val``.

        :param FileRequestsEmailsRestrictedToTeamOnlyDetails val:
        :rtype: EventDetails
        """
        return cls('file_requests_emails_restricted_to_team_only_details', val)

    @classmethod
    def file_transfers_policy_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_transfers_policy_changed_details`` tag with value ``val``.

        :param FileTransfersPolicyChangedDetails val:
        :rtype: EventDetails
        """
        return cls('file_transfers_policy_changed_details', val)

    @classmethod
    def google_sso_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``google_sso_change_policy_details`` tag with value ``val``.

        :param GoogleSsoChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('google_sso_change_policy_details', val)

    @classmethod
    def group_user_management_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_user_management_change_policy_details`` tag with value ``val``.

        :param GroupUserManagementChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('group_user_management_change_policy_details', val)

    @classmethod
    def integration_policy_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``integration_policy_changed_details`` tag with value ``val``.

        :param IntegrationPolicyChangedDetails val:
        :rtype: EventDetails
        """
        return cls('integration_policy_changed_details', val)

    @classmethod
    def invite_acceptance_email_policy_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``invite_acceptance_email_policy_changed_details`` tag with value
        ``val``.

        :param InviteAcceptanceEmailPolicyChangedDetails val:
        :rtype: EventDetails
        """
        return cls('invite_acceptance_email_policy_changed_details', val)

    @classmethod
    def member_requests_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_requests_change_policy_details`` tag with value ``val``.

        :param MemberRequestsChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('member_requests_change_policy_details', val)

    @classmethod
    def member_send_invite_policy_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_send_invite_policy_changed_details`` tag with value ``val``.

        :param MemberSendInvitePolicyChangedDetails val:
        :rtype: EventDetails
        """
        return cls('member_send_invite_policy_changed_details', val)

    @classmethod
    def member_space_limits_add_exception_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_add_exception_details`` tag with value ``val``.

        :param MemberSpaceLimitsAddExceptionDetails val:
        :rtype: EventDetails
        """
        return cls('member_space_limits_add_exception_details', val)

    @classmethod
    def member_space_limits_change_caps_type_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_change_caps_type_policy_details`` tag with value
        ``val``.

        :param MemberSpaceLimitsChangeCapsTypePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('member_space_limits_change_caps_type_policy_details', val)

    @classmethod
    def member_space_limits_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_change_policy_details`` tag with value ``val``.

        :param MemberSpaceLimitsChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('member_space_limits_change_policy_details', val)

    @classmethod
    def member_space_limits_remove_exception_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_remove_exception_details`` tag with value ``val``.

        :param MemberSpaceLimitsRemoveExceptionDetails val:
        :rtype: EventDetails
        """
        return cls('member_space_limits_remove_exception_details', val)

    @classmethod
    def member_suggestions_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_suggestions_change_policy_details`` tag with value ``val``.

        :param MemberSuggestionsChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('member_suggestions_change_policy_details', val)

    @classmethod
    def microsoft_office_addin_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``microsoft_office_addin_change_policy_details`` tag with value ``val``.

        :param MicrosoftOfficeAddinChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('microsoft_office_addin_change_policy_details', val)

    @classmethod
    def network_control_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``network_control_change_policy_details`` tag with value ``val``.

        :param NetworkControlChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('network_control_change_policy_details', val)

    @classmethod
    def paper_change_deployment_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_change_deployment_policy_details`` tag with value ``val``.

        :param PaperChangeDeploymentPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('paper_change_deployment_policy_details', val)

    @classmethod
    def paper_change_member_link_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_change_member_link_policy_details`` tag with value ``val``.

        :param PaperChangeMemberLinkPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('paper_change_member_link_policy_details', val)

    @classmethod
    def paper_change_member_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_change_member_policy_details`` tag with value ``val``.

        :param PaperChangeMemberPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('paper_change_member_policy_details', val)

    @classmethod
    def paper_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_change_policy_details`` tag with value ``val``.

        :param PaperChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('paper_change_policy_details', val)

    @classmethod
    def paper_default_folder_policy_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_default_folder_policy_changed_details`` tag with value ``val``.

        :param PaperDefaultFolderPolicyChangedDetails val:
        :rtype: EventDetails
        """
        return cls('paper_default_folder_policy_changed_details', val)

    @classmethod
    def paper_desktop_policy_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_desktop_policy_changed_details`` tag with value ``val``.

        :param PaperDesktopPolicyChangedDetails val:
        :rtype: EventDetails
        """
        return cls('paper_desktop_policy_changed_details', val)

    @classmethod
    def paper_enabled_users_group_addition_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_enabled_users_group_addition_details`` tag with value ``val``.

        :param PaperEnabledUsersGroupAdditionDetails val:
        :rtype: EventDetails
        """
        return cls('paper_enabled_users_group_addition_details', val)

    @classmethod
    def paper_enabled_users_group_removal_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_enabled_users_group_removal_details`` tag with value ``val``.

        :param PaperEnabledUsersGroupRemovalDetails val:
        :rtype: EventDetails
        """
        return cls('paper_enabled_users_group_removal_details', val)

    @classmethod
    def password_strength_requirements_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``password_strength_requirements_change_policy_details`` tag with value
        ``val``.

        :param PasswordStrengthRequirementsChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('password_strength_requirements_change_policy_details', val)

    @classmethod
    def permanent_delete_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``permanent_delete_change_policy_details`` tag with value ``val``.

        :param PermanentDeleteChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('permanent_delete_change_policy_details', val)

    @classmethod
    def reseller_support_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``reseller_support_change_policy_details`` tag with value ``val``.

        :param ResellerSupportChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('reseller_support_change_policy_details', val)

    @classmethod
    def rewind_policy_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``rewind_policy_changed_details`` tag with value ``val``.

        :param RewindPolicyChangedDetails val:
        :rtype: EventDetails
        """
        return cls('rewind_policy_changed_details', val)

    @classmethod
    def send_for_signature_policy_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``send_for_signature_policy_changed_details`` tag with value ``val``.

        :param SendForSignaturePolicyChangedDetails val:
        :rtype: EventDetails
        """
        return cls('send_for_signature_policy_changed_details', val)

    @classmethod
    def sharing_change_folder_join_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``sharing_change_folder_join_policy_details`` tag with value ``val``.

        :param SharingChangeFolderJoinPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('sharing_change_folder_join_policy_details', val)

    @classmethod
    def sharing_change_link_allow_change_expiration_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``sharing_change_link_allow_change_expiration_policy_details`` tag with
        value ``val``.

        :param SharingChangeLinkAllowChangeExpirationPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('sharing_change_link_allow_change_expiration_policy_details', val)

    @classmethod
    def sharing_change_link_default_expiration_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``sharing_change_link_default_expiration_policy_details`` tag with value
        ``val``.

        :param SharingChangeLinkDefaultExpirationPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('sharing_change_link_default_expiration_policy_details', val)

    @classmethod
    def sharing_change_link_enforce_password_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``sharing_change_link_enforce_password_policy_details`` tag with value
        ``val``.

        :param SharingChangeLinkEnforcePasswordPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('sharing_change_link_enforce_password_policy_details', val)

    @classmethod
    def sharing_change_link_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``sharing_change_link_policy_details`` tag with value ``val``.

        :param SharingChangeLinkPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('sharing_change_link_policy_details', val)

    @classmethod
    def sharing_change_member_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``sharing_change_member_policy_details`` tag with value ``val``.

        :param SharingChangeMemberPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('sharing_change_member_policy_details', val)

    @classmethod
    def showcase_change_download_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_change_download_policy_details`` tag with value ``val``.

        :param ShowcaseChangeDownloadPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_change_download_policy_details', val)

    @classmethod
    def showcase_change_enabled_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_change_enabled_policy_details`` tag with value ``val``.

        :param ShowcaseChangeEnabledPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_change_enabled_policy_details', val)

    @classmethod
    def showcase_change_external_sharing_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_change_external_sharing_policy_details`` tag with value
        ``val``.

        :param ShowcaseChangeExternalSharingPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('showcase_change_external_sharing_policy_details', val)

    @classmethod
    def smarter_smart_sync_policy_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``smarter_smart_sync_policy_changed_details`` tag with value ``val``.

        :param SmarterSmartSyncPolicyChangedDetails val:
        :rtype: EventDetails
        """
        return cls('smarter_smart_sync_policy_changed_details', val)

    @classmethod
    def smart_sync_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``smart_sync_change_policy_details`` tag with value ``val``.

        :param SmartSyncChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('smart_sync_change_policy_details', val)

    @classmethod
    def smart_sync_not_opt_out_details(cls, val):
        """
        Create an instance of this class set to the
        ``smart_sync_not_opt_out_details`` tag with value ``val``.

        :param SmartSyncNotOptOutDetails val:
        :rtype: EventDetails
        """
        return cls('smart_sync_not_opt_out_details', val)

    @classmethod
    def smart_sync_opt_out_details(cls, val):
        """
        Create an instance of this class set to the
        ``smart_sync_opt_out_details`` tag with value ``val``.

        :param SmartSyncOptOutDetails val:
        :rtype: EventDetails
        """
        return cls('smart_sync_opt_out_details', val)

    @classmethod
    def sso_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``sso_change_policy_details`` tag with value ``val``.

        :param SsoChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('sso_change_policy_details', val)

    @classmethod
    def team_branding_policy_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_branding_policy_changed_details`` tag with value ``val``.

        :param TeamBrandingPolicyChangedDetails val:
        :rtype: EventDetails
        """
        return cls('team_branding_policy_changed_details', val)

    @classmethod
    def team_extensions_policy_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_extensions_policy_changed_details`` tag with value ``val``.

        :param TeamExtensionsPolicyChangedDetails val:
        :rtype: EventDetails
        """
        return cls('team_extensions_policy_changed_details', val)

    @classmethod
    def team_selective_sync_policy_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_selective_sync_policy_changed_details`` tag with value ``val``.

        :param TeamSelectiveSyncPolicyChangedDetails val:
        :rtype: EventDetails
        """
        return cls('team_selective_sync_policy_changed_details', val)

    @classmethod
    def team_sharing_whitelist_subjects_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_sharing_whitelist_subjects_changed_details`` tag with value
        ``val``.

        :param TeamSharingWhitelistSubjectsChangedDetails val:
        :rtype: EventDetails
        """
        return cls('team_sharing_whitelist_subjects_changed_details', val)

    @classmethod
    def tfa_add_exception_details(cls, val):
        """
        Create an instance of this class set to the
        ``tfa_add_exception_details`` tag with value ``val``.

        :param TfaAddExceptionDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_add_exception_details', val)

    @classmethod
    def tfa_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``tfa_change_policy_details`` tag with value ``val``.

        :param TfaChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_change_policy_details', val)

    @classmethod
    def tfa_remove_exception_details(cls, val):
        """
        Create an instance of this class set to the
        ``tfa_remove_exception_details`` tag with value ``val``.

        :param TfaRemoveExceptionDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_remove_exception_details', val)

    @classmethod
    def two_account_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``two_account_change_policy_details`` tag with value ``val``.

        :param TwoAccountChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('two_account_change_policy_details', val)

    @classmethod
    def viewer_info_policy_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``viewer_info_policy_changed_details`` tag with value ``val``.

        :param ViewerInfoPolicyChangedDetails val:
        :rtype: EventDetails
        """
        return cls('viewer_info_policy_changed_details', val)

    @classmethod
    def watermarking_policy_changed_details(cls, val):
        """
        Create an instance of this class set to the
        ``watermarking_policy_changed_details`` tag with value ``val``.

        :param WatermarkingPolicyChangedDetails val:
        :rtype: EventDetails
        """
        return cls('watermarking_policy_changed_details', val)

    @classmethod
    def web_sessions_change_active_session_limit_details(cls, val):
        """
        Create an instance of this class set to the
        ``web_sessions_change_active_session_limit_details`` tag with value
        ``val``.

        :param WebSessionsChangeActiveSessionLimitDetails val:
        :rtype: EventDetails
        """
        return cls('web_sessions_change_active_session_limit_details', val)

    @classmethod
    def web_sessions_change_fixed_length_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``web_sessions_change_fixed_length_policy_details`` tag with value
        ``val``.

        :param WebSessionsChangeFixedLengthPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('web_sessions_change_fixed_length_policy_details', val)

    @classmethod
    def web_sessions_change_idle_length_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``web_sessions_change_idle_length_policy_details`` tag with value
        ``val``.

        :param WebSessionsChangeIdleLengthPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('web_sessions_change_idle_length_policy_details', val)

    @classmethod
    def data_residency_migration_request_successful_details(cls, val):
        """
        Create an instance of this class set to the
        ``data_residency_migration_request_successful_details`` tag with value
        ``val``.

        :param DataResidencyMigrationRequestSuccessfulDetails val:
        :rtype: EventDetails
        """
        return cls('data_residency_migration_request_successful_details', val)

    @classmethod
    def data_residency_migration_request_unsuccessful_details(cls, val):
        """
        Create an instance of this class set to the
        ``data_residency_migration_request_unsuccessful_details`` tag with value
        ``val``.

        :param DataResidencyMigrationRequestUnsuccessfulDetails val:
        :rtype: EventDetails
        """
        return cls('data_residency_migration_request_unsuccessful_details', val)

    @classmethod
    def team_merge_from_details(cls, val):
        """
        Create an instance of this class set to the ``team_merge_from_details``
        tag with value ``val``.

        :param TeamMergeFromDetails val:
        :rtype: EventDetails
        """
        return cls('team_merge_from_details', val)

    @classmethod
    def team_merge_to_details(cls, val):
        """
        Create an instance of this class set to the ``team_merge_to_details``
        tag with value ``val``.

        :param TeamMergeToDetails val:
        :rtype: EventDetails
        """
        return cls('team_merge_to_details', val)

    @classmethod
    def team_profile_add_background_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_profile_add_background_details`` tag with value ``val``.

        :param TeamProfileAddBackgroundDetails val:
        :rtype: EventDetails
        """
        return cls('team_profile_add_background_details', val)

    @classmethod
    def team_profile_add_logo_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_profile_add_logo_details`` tag with value ``val``.

        :param TeamProfileAddLogoDetails val:
        :rtype: EventDetails
        """
        return cls('team_profile_add_logo_details', val)

    @classmethod
    def team_profile_change_background_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_profile_change_background_details`` tag with value ``val``.

        :param TeamProfileChangeBackgroundDetails val:
        :rtype: EventDetails
        """
        return cls('team_profile_change_background_details', val)

    @classmethod
    def team_profile_change_default_language_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_profile_change_default_language_details`` tag with value ``val``.

        :param TeamProfileChangeDefaultLanguageDetails val:
        :rtype: EventDetails
        """
        return cls('team_profile_change_default_language_details', val)

    @classmethod
    def team_profile_change_logo_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_profile_change_logo_details`` tag with value ``val``.

        :param TeamProfileChangeLogoDetails val:
        :rtype: EventDetails
        """
        return cls('team_profile_change_logo_details', val)

    @classmethod
    def team_profile_change_name_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_profile_change_name_details`` tag with value ``val``.

        :param TeamProfileChangeNameDetails val:
        :rtype: EventDetails
        """
        return cls('team_profile_change_name_details', val)

    @classmethod
    def team_profile_remove_background_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_profile_remove_background_details`` tag with value ``val``.

        :param TeamProfileRemoveBackgroundDetails val:
        :rtype: EventDetails
        """
        return cls('team_profile_remove_background_details', val)

    @classmethod
    def team_profile_remove_logo_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_profile_remove_logo_details`` tag with value ``val``.

        :param TeamProfileRemoveLogoDetails val:
        :rtype: EventDetails
        """
        return cls('team_profile_remove_logo_details', val)

    @classmethod
    def tfa_add_backup_phone_details(cls, val):
        """
        Create an instance of this class set to the
        ``tfa_add_backup_phone_details`` tag with value ``val``.

        :param TfaAddBackupPhoneDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_add_backup_phone_details', val)

    @classmethod
    def tfa_add_security_key_details(cls, val):
        """
        Create an instance of this class set to the
        ``tfa_add_security_key_details`` tag with value ``val``.

        :param TfaAddSecurityKeyDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_add_security_key_details', val)

    @classmethod
    def tfa_change_backup_phone_details(cls, val):
        """
        Create an instance of this class set to the
        ``tfa_change_backup_phone_details`` tag with value ``val``.

        :param TfaChangeBackupPhoneDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_change_backup_phone_details', val)

    @classmethod
    def tfa_change_status_details(cls, val):
        """
        Create an instance of this class set to the
        ``tfa_change_status_details`` tag with value ``val``.

        :param TfaChangeStatusDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_change_status_details', val)

    @classmethod
    def tfa_remove_backup_phone_details(cls, val):
        """
        Create an instance of this class set to the
        ``tfa_remove_backup_phone_details`` tag with value ``val``.

        :param TfaRemoveBackupPhoneDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_remove_backup_phone_details', val)

    @classmethod
    def tfa_remove_security_key_details(cls, val):
        """
        Create an instance of this class set to the
        ``tfa_remove_security_key_details`` tag with value ``val``.

        :param TfaRemoveSecurityKeyDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_remove_security_key_details', val)

    @classmethod
    def tfa_reset_details(cls, val):
        """
        Create an instance of this class set to the ``tfa_reset_details`` tag
        with value ``val``.

        :param TfaResetDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_reset_details', val)

    @classmethod
    def changed_enterprise_admin_role_details(cls, val):
        """
        Create an instance of this class set to the
        ``changed_enterprise_admin_role_details`` tag with value ``val``.

        :param ChangedEnterpriseAdminRoleDetails val:
        :rtype: EventDetails
        """
        return cls('changed_enterprise_admin_role_details', val)

    @classmethod
    def changed_enterprise_connected_team_status_details(cls, val):
        """
        Create an instance of this class set to the
        ``changed_enterprise_connected_team_status_details`` tag with value
        ``val``.

        :param ChangedEnterpriseConnectedTeamStatusDetails val:
        :rtype: EventDetails
        """
        return cls('changed_enterprise_connected_team_status_details', val)

    @classmethod
    def ended_enterprise_admin_session_details(cls, val):
        """
        Create an instance of this class set to the
        ``ended_enterprise_admin_session_details`` tag with value ``val``.

        :param EndedEnterpriseAdminSessionDetails val:
        :rtype: EventDetails
        """
        return cls('ended_enterprise_admin_session_details', val)

    @classmethod
    def ended_enterprise_admin_session_deprecated_details(cls, val):
        """
        Create an instance of this class set to the
        ``ended_enterprise_admin_session_deprecated_details`` tag with value
        ``val``.

        :param EndedEnterpriseAdminSessionDeprecatedDetails val:
        :rtype: EventDetails
        """
        return cls('ended_enterprise_admin_session_deprecated_details', val)

    @classmethod
    def enterprise_settings_locking_details(cls, val):
        """
        Create an instance of this class set to the
        ``enterprise_settings_locking_details`` tag with value ``val``.

        :param EnterpriseSettingsLockingDetails val:
        :rtype: EventDetails
        """
        return cls('enterprise_settings_locking_details', val)

    @classmethod
    def guest_admin_change_status_details(cls, val):
        """
        Create an instance of this class set to the
        ``guest_admin_change_status_details`` tag with value ``val``.

        :param GuestAdminChangeStatusDetails val:
        :rtype: EventDetails
        """
        return cls('guest_admin_change_status_details', val)

    @classmethod
    def started_enterprise_admin_session_details(cls, val):
        """
        Create an instance of this class set to the
        ``started_enterprise_admin_session_details`` tag with value ``val``.

        :param StartedEnterpriseAdminSessionDetails val:
        :rtype: EventDetails
        """
        return cls('started_enterprise_admin_session_details', val)

    @classmethod
    def team_merge_request_accepted_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_accepted_details`` tag with value ``val``.

        :param TeamMergeRequestAcceptedDetails val:
        :rtype: EventDetails
        """
        return cls('team_merge_request_accepted_details', val)

    @classmethod
    def team_merge_request_accepted_shown_to_primary_team_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_accepted_shown_to_primary_team_details`` tag with
        value ``val``.

        :param TeamMergeRequestAcceptedShownToPrimaryTeamDetails val:
        :rtype: EventDetails
        """
        return cls('team_merge_request_accepted_shown_to_primary_team_details', val)

    @classmethod
    def team_merge_request_accepted_shown_to_secondary_team_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_accepted_shown_to_secondary_team_details`` tag with
        value ``val``.

        :param TeamMergeRequestAcceptedShownToSecondaryTeamDetails val:
        :rtype: EventDetails
        """
        return cls('team_merge_request_accepted_shown_to_secondary_team_details', val)

    @classmethod
    def team_merge_request_auto_canceled_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_auto_canceled_details`` tag with value ``val``.

        :param TeamMergeRequestAutoCanceledDetails val:
        :rtype: EventDetails
        """
        return cls('team_merge_request_auto_canceled_details', val)

    @classmethod
    def team_merge_request_canceled_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_canceled_details`` tag with value ``val``.

        :param TeamMergeRequestCanceledDetails val:
        :rtype: EventDetails
        """
        return cls('team_merge_request_canceled_details', val)

    @classmethod
    def team_merge_request_canceled_shown_to_primary_team_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_canceled_shown_to_primary_team_details`` tag with
        value ``val``.

        :param TeamMergeRequestCanceledShownToPrimaryTeamDetails val:
        :rtype: EventDetails
        """
        return cls('team_merge_request_canceled_shown_to_primary_team_details', val)

    @classmethod
    def team_merge_request_canceled_shown_to_secondary_team_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_canceled_shown_to_secondary_team_details`` tag with
        value ``val``.

        :param TeamMergeRequestCanceledShownToSecondaryTeamDetails val:
        :rtype: EventDetails
        """
        return cls('team_merge_request_canceled_shown_to_secondary_team_details', val)

    @classmethod
    def team_merge_request_expired_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_expired_details`` tag with value ``val``.

        :param TeamMergeRequestExpiredDetails val:
        :rtype: EventDetails
        """
        return cls('team_merge_request_expired_details', val)

    @classmethod
    def team_merge_request_expired_shown_to_primary_team_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_expired_shown_to_primary_team_details`` tag with
        value ``val``.

        :param TeamMergeRequestExpiredShownToPrimaryTeamDetails val:
        :rtype: EventDetails
        """
        return cls('team_merge_request_expired_shown_to_primary_team_details', val)

    @classmethod
    def team_merge_request_expired_shown_to_secondary_team_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_expired_shown_to_secondary_team_details`` tag with
        value ``val``.

        :param TeamMergeRequestExpiredShownToSecondaryTeamDetails val:
        :rtype: EventDetails
        """
        return cls('team_merge_request_expired_shown_to_secondary_team_details', val)

    @classmethod
    def team_merge_request_rejected_shown_to_primary_team_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_rejected_shown_to_primary_team_details`` tag with
        value ``val``.

        :param TeamMergeRequestRejectedShownToPrimaryTeamDetails val:
        :rtype: EventDetails
        """
        return cls('team_merge_request_rejected_shown_to_primary_team_details', val)

    @classmethod
    def team_merge_request_rejected_shown_to_secondary_team_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_rejected_shown_to_secondary_team_details`` tag with
        value ``val``.

        :param TeamMergeRequestRejectedShownToSecondaryTeamDetails val:
        :rtype: EventDetails
        """
        return cls('team_merge_request_rejected_shown_to_secondary_team_details', val)

    @classmethod
    def team_merge_request_reminder_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_reminder_details`` tag with value ``val``.

        :param TeamMergeRequestReminderDetails val:
        :rtype: EventDetails
        """
        return cls('team_merge_request_reminder_details', val)

    @classmethod
    def team_merge_request_reminder_shown_to_primary_team_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_reminder_shown_to_primary_team_details`` tag with
        value ``val``.

        :param TeamMergeRequestReminderShownToPrimaryTeamDetails val:
        :rtype: EventDetails
        """
        return cls('team_merge_request_reminder_shown_to_primary_team_details', val)

    @classmethod
    def team_merge_request_reminder_shown_to_secondary_team_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_reminder_shown_to_secondary_team_details`` tag with
        value ``val``.

        :param TeamMergeRequestReminderShownToSecondaryTeamDetails val:
        :rtype: EventDetails
        """
        return cls('team_merge_request_reminder_shown_to_secondary_team_details', val)

    @classmethod
    def team_merge_request_revoked_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_revoked_details`` tag with value ``val``.

        :param TeamMergeRequestRevokedDetails val:
        :rtype: EventDetails
        """
        return cls('team_merge_request_revoked_details', val)

    @classmethod
    def team_merge_request_sent_shown_to_primary_team_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_sent_shown_to_primary_team_details`` tag with value
        ``val``.

        :param TeamMergeRequestSentShownToPrimaryTeamDetails val:
        :rtype: EventDetails
        """
        return cls('team_merge_request_sent_shown_to_primary_team_details', val)

    @classmethod
    def team_merge_request_sent_shown_to_secondary_team_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_sent_shown_to_secondary_team_details`` tag with
        value ``val``.

        :param TeamMergeRequestSentShownToSecondaryTeamDetails val:
        :rtype: EventDetails
        """
        return cls('team_merge_request_sent_shown_to_secondary_team_details', val)

    @classmethod
    def missing_details(cls, val):
        """
        Create an instance of this class set to the ``missing_details`` tag with
        value ``val``.

        :param MissingDetails val:
        :rtype: EventDetails
        """
        return cls('missing_details', val)

    def is_admin_alerting_alert_state_changed_details(self):
        """
        Check if the union tag is ``admin_alerting_alert_state_changed_details``.

        :rtype: bool
        """
        return self._tag == 'admin_alerting_alert_state_changed_details'

    def is_admin_alerting_changed_alert_config_details(self):
        """
        Check if the union tag is ``admin_alerting_changed_alert_config_details``.

        :rtype: bool
        """
        return self._tag == 'admin_alerting_changed_alert_config_details'

    def is_admin_alerting_triggered_alert_details(self):
        """
        Check if the union tag is ``admin_alerting_triggered_alert_details``.

        :rtype: bool
        """
        return self._tag == 'admin_alerting_triggered_alert_details'

    def is_app_blocked_by_permissions_details(self):
        """
        Check if the union tag is ``app_blocked_by_permissions_details``.

        :rtype: bool
        """
        return self._tag == 'app_blocked_by_permissions_details'

    def is_app_link_team_details(self):
        """
        Check if the union tag is ``app_link_team_details``.

        :rtype: bool
        """
        return self._tag == 'app_link_team_details'

    def is_app_link_user_details(self):
        """
        Check if the union tag is ``app_link_user_details``.

        :rtype: bool
        """
        return self._tag == 'app_link_user_details'

    def is_app_unlink_team_details(self):
        """
        Check if the union tag is ``app_unlink_team_details``.

        :rtype: bool
        """
        return self._tag == 'app_unlink_team_details'

    def is_app_unlink_user_details(self):
        """
        Check if the union tag is ``app_unlink_user_details``.

        :rtype: bool
        """
        return self._tag == 'app_unlink_user_details'

    def is_integration_connected_details(self):
        """
        Check if the union tag is ``integration_connected_details``.

        :rtype: bool
        """
        return self._tag == 'integration_connected_details'

    def is_integration_disconnected_details(self):
        """
        Check if the union tag is ``integration_disconnected_details``.

        :rtype: bool
        """
        return self._tag == 'integration_disconnected_details'

    def is_file_add_comment_details(self):
        """
        Check if the union tag is ``file_add_comment_details``.

        :rtype: bool
        """
        return self._tag == 'file_add_comment_details'

    def is_file_change_comment_subscription_details(self):
        """
        Check if the union tag is ``file_change_comment_subscription_details``.

        :rtype: bool
        """
        return self._tag == 'file_change_comment_subscription_details'

    def is_file_delete_comment_details(self):
        """
        Check if the union tag is ``file_delete_comment_details``.

        :rtype: bool
        """
        return self._tag == 'file_delete_comment_details'

    def is_file_edit_comment_details(self):
        """
        Check if the union tag is ``file_edit_comment_details``.

        :rtype: bool
        """
        return self._tag == 'file_edit_comment_details'

    def is_file_like_comment_details(self):
        """
        Check if the union tag is ``file_like_comment_details``.

        :rtype: bool
        """
        return self._tag == 'file_like_comment_details'

    def is_file_resolve_comment_details(self):
        """
        Check if the union tag is ``file_resolve_comment_details``.

        :rtype: bool
        """
        return self._tag == 'file_resolve_comment_details'

    def is_file_unlike_comment_details(self):
        """
        Check if the union tag is ``file_unlike_comment_details``.

        :rtype: bool
        """
        return self._tag == 'file_unlike_comment_details'

    def is_file_unresolve_comment_details(self):
        """
        Check if the union tag is ``file_unresolve_comment_details``.

        :rtype: bool
        """
        return self._tag == 'file_unresolve_comment_details'

    def is_governance_policy_add_folders_details(self):
        """
        Check if the union tag is ``governance_policy_add_folders_details``.

        :rtype: bool
        """
        return self._tag == 'governance_policy_add_folders_details'

    def is_governance_policy_add_folder_failed_details(self):
        """
        Check if the union tag is ``governance_policy_add_folder_failed_details``.

        :rtype: bool
        """
        return self._tag == 'governance_policy_add_folder_failed_details'

    def is_governance_policy_content_disposed_details(self):
        """
        Check if the union tag is ``governance_policy_content_disposed_details``.

        :rtype: bool
        """
        return self._tag == 'governance_policy_content_disposed_details'

    def is_governance_policy_create_details(self):
        """
        Check if the union tag is ``governance_policy_create_details``.

        :rtype: bool
        """
        return self._tag == 'governance_policy_create_details'

    def is_governance_policy_delete_details(self):
        """
        Check if the union tag is ``governance_policy_delete_details``.

        :rtype: bool
        """
        return self._tag == 'governance_policy_delete_details'

    def is_governance_policy_edit_details_details(self):
        """
        Check if the union tag is ``governance_policy_edit_details_details``.

        :rtype: bool
        """
        return self._tag == 'governance_policy_edit_details_details'

    def is_governance_policy_edit_duration_details(self):
        """
        Check if the union tag is ``governance_policy_edit_duration_details``.

        :rtype: bool
        """
        return self._tag == 'governance_policy_edit_duration_details'

    def is_governance_policy_export_created_details(self):
        """
        Check if the union tag is ``governance_policy_export_created_details``.

        :rtype: bool
        """
        return self._tag == 'governance_policy_export_created_details'

    def is_governance_policy_export_removed_details(self):
        """
        Check if the union tag is ``governance_policy_export_removed_details``.

        :rtype: bool
        """
        return self._tag == 'governance_policy_export_removed_details'

    def is_governance_policy_remove_folders_details(self):
        """
        Check if the union tag is ``governance_policy_remove_folders_details``.

        :rtype: bool
        """
        return self._tag == 'governance_policy_remove_folders_details'

    def is_governance_policy_report_created_details(self):
        """
        Check if the union tag is ``governance_policy_report_created_details``.

        :rtype: bool
        """
        return self._tag == 'governance_policy_report_created_details'

    def is_governance_policy_zip_part_downloaded_details(self):
        """
        Check if the union tag is ``governance_policy_zip_part_downloaded_details``.

        :rtype: bool
        """
        return self._tag == 'governance_policy_zip_part_downloaded_details'

    def is_legal_holds_activate_a_hold_details(self):
        """
        Check if the union tag is ``legal_holds_activate_a_hold_details``.

        :rtype: bool
        """
        return self._tag == 'legal_holds_activate_a_hold_details'

    def is_legal_holds_add_members_details(self):
        """
        Check if the union tag is ``legal_holds_add_members_details``.

        :rtype: bool
        """
        return self._tag == 'legal_holds_add_members_details'

    def is_legal_holds_change_hold_details_details(self):
        """
        Check if the union tag is ``legal_holds_change_hold_details_details``.

        :rtype: bool
        """
        return self._tag == 'legal_holds_change_hold_details_details'

    def is_legal_holds_change_hold_name_details(self):
        """
        Check if the union tag is ``legal_holds_change_hold_name_details``.

        :rtype: bool
        """
        return self._tag == 'legal_holds_change_hold_name_details'

    def is_legal_holds_export_a_hold_details(self):
        """
        Check if the union tag is ``legal_holds_export_a_hold_details``.

        :rtype: bool
        """
        return self._tag == 'legal_holds_export_a_hold_details'

    def is_legal_holds_export_cancelled_details(self):
        """
        Check if the union tag is ``legal_holds_export_cancelled_details``.

        :rtype: bool
        """
        return self._tag == 'legal_holds_export_cancelled_details'

    def is_legal_holds_export_downloaded_details(self):
        """
        Check if the union tag is ``legal_holds_export_downloaded_details``.

        :rtype: bool
        """
        return self._tag == 'legal_holds_export_downloaded_details'

    def is_legal_holds_export_removed_details(self):
        """
        Check if the union tag is ``legal_holds_export_removed_details``.

        :rtype: bool
        """
        return self._tag == 'legal_holds_export_removed_details'

    def is_legal_holds_release_a_hold_details(self):
        """
        Check if the union tag is ``legal_holds_release_a_hold_details``.

        :rtype: bool
        """
        return self._tag == 'legal_holds_release_a_hold_details'

    def is_legal_holds_remove_members_details(self):
        """
        Check if the union tag is ``legal_holds_remove_members_details``.

        :rtype: bool
        """
        return self._tag == 'legal_holds_remove_members_details'

    def is_legal_holds_report_a_hold_details(self):
        """
        Check if the union tag is ``legal_holds_report_a_hold_details``.

        :rtype: bool
        """
        return self._tag == 'legal_holds_report_a_hold_details'

    def is_device_change_ip_desktop_details(self):
        """
        Check if the union tag is ``device_change_ip_desktop_details``.

        :rtype: bool
        """
        return self._tag == 'device_change_ip_desktop_details'

    def is_device_change_ip_mobile_details(self):
        """
        Check if the union tag is ``device_change_ip_mobile_details``.

        :rtype: bool
        """
        return self._tag == 'device_change_ip_mobile_details'

    def is_device_change_ip_web_details(self):
        """
        Check if the union tag is ``device_change_ip_web_details``.

        :rtype: bool
        """
        return self._tag == 'device_change_ip_web_details'

    def is_device_delete_on_unlink_fail_details(self):
        """
        Check if the union tag is ``device_delete_on_unlink_fail_details``.

        :rtype: bool
        """
        return self._tag == 'device_delete_on_unlink_fail_details'

    def is_device_delete_on_unlink_success_details(self):
        """
        Check if the union tag is ``device_delete_on_unlink_success_details``.

        :rtype: bool
        """
        return self._tag == 'device_delete_on_unlink_success_details'

    def is_device_link_fail_details(self):
        """
        Check if the union tag is ``device_link_fail_details``.

        :rtype: bool
        """
        return self._tag == 'device_link_fail_details'

    def is_device_link_success_details(self):
        """
        Check if the union tag is ``device_link_success_details``.

        :rtype: bool
        """
        return self._tag == 'device_link_success_details'

    def is_device_management_disabled_details(self):
        """
        Check if the union tag is ``device_management_disabled_details``.

        :rtype: bool
        """
        return self._tag == 'device_management_disabled_details'

    def is_device_management_enabled_details(self):
        """
        Check if the union tag is ``device_management_enabled_details``.

        :rtype: bool
        """
        return self._tag == 'device_management_enabled_details'

    def is_device_sync_backup_status_changed_details(self):
        """
        Check if the union tag is ``device_sync_backup_status_changed_details``.

        :rtype: bool
        """
        return self._tag == 'device_sync_backup_status_changed_details'

    def is_device_unlink_details(self):
        """
        Check if the union tag is ``device_unlink_details``.

        :rtype: bool
        """
        return self._tag == 'device_unlink_details'

    def is_dropbox_passwords_exported_details(self):
        """
        Check if the union tag is ``dropbox_passwords_exported_details``.

        :rtype: bool
        """
        return self._tag == 'dropbox_passwords_exported_details'

    def is_dropbox_passwords_new_device_enrolled_details(self):
        """
        Check if the union tag is ``dropbox_passwords_new_device_enrolled_details``.

        :rtype: bool
        """
        return self._tag == 'dropbox_passwords_new_device_enrolled_details'

    def is_emm_refresh_auth_token_details(self):
        """
        Check if the union tag is ``emm_refresh_auth_token_details``.

        :rtype: bool
        """
        return self._tag == 'emm_refresh_auth_token_details'

    def is_account_capture_change_availability_details(self):
        """
        Check if the union tag is ``account_capture_change_availability_details``.

        :rtype: bool
        """
        return self._tag == 'account_capture_change_availability_details'

    def is_account_capture_migrate_account_details(self):
        """
        Check if the union tag is ``account_capture_migrate_account_details``.

        :rtype: bool
        """
        return self._tag == 'account_capture_migrate_account_details'

    def is_account_capture_notification_emails_sent_details(self):
        """
        Check if the union tag is ``account_capture_notification_emails_sent_details``.

        :rtype: bool
        """
        return self._tag == 'account_capture_notification_emails_sent_details'

    def is_account_capture_relinquish_account_details(self):
        """
        Check if the union tag is ``account_capture_relinquish_account_details``.

        :rtype: bool
        """
        return self._tag == 'account_capture_relinquish_account_details'

    def is_disabled_domain_invites_details(self):
        """
        Check if the union tag is ``disabled_domain_invites_details``.

        :rtype: bool
        """
        return self._tag == 'disabled_domain_invites_details'

    def is_domain_invites_approve_request_to_join_team_details(self):
        """
        Check if the union tag is ``domain_invites_approve_request_to_join_team_details``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_approve_request_to_join_team_details'

    def is_domain_invites_decline_request_to_join_team_details(self):
        """
        Check if the union tag is ``domain_invites_decline_request_to_join_team_details``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_decline_request_to_join_team_details'

    def is_domain_invites_email_existing_users_details(self):
        """
        Check if the union tag is ``domain_invites_email_existing_users_details``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_email_existing_users_details'

    def is_domain_invites_request_to_join_team_details(self):
        """
        Check if the union tag is ``domain_invites_request_to_join_team_details``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_request_to_join_team_details'

    def is_domain_invites_set_invite_new_user_pref_to_no_details(self):
        """
        Check if the union tag is ``domain_invites_set_invite_new_user_pref_to_no_details``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_set_invite_new_user_pref_to_no_details'

    def is_domain_invites_set_invite_new_user_pref_to_yes_details(self):
        """
        Check if the union tag is ``domain_invites_set_invite_new_user_pref_to_yes_details``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_set_invite_new_user_pref_to_yes_details'

    def is_domain_verification_add_domain_fail_details(self):
        """
        Check if the union tag is ``domain_verification_add_domain_fail_details``.

        :rtype: bool
        """
        return self._tag == 'domain_verification_add_domain_fail_details'

    def is_domain_verification_add_domain_success_details(self):
        """
        Check if the union tag is ``domain_verification_add_domain_success_details``.

        :rtype: bool
        """
        return self._tag == 'domain_verification_add_domain_success_details'

    def is_domain_verification_remove_domain_details(self):
        """
        Check if the union tag is ``domain_verification_remove_domain_details``.

        :rtype: bool
        """
        return self._tag == 'domain_verification_remove_domain_details'

    def is_enabled_domain_invites_details(self):
        """
        Check if the union tag is ``enabled_domain_invites_details``.

        :rtype: bool
        """
        return self._tag == 'enabled_domain_invites_details'

    def is_apply_naming_convention_details(self):
        """
        Check if the union tag is ``apply_naming_convention_details``.

        :rtype: bool
        """
        return self._tag == 'apply_naming_convention_details'

    def is_create_folder_details(self):
        """
        Check if the union tag is ``create_folder_details``.

        :rtype: bool
        """
        return self._tag == 'create_folder_details'

    def is_file_add_details(self):
        """
        Check if the union tag is ``file_add_details``.

        :rtype: bool
        """
        return self._tag == 'file_add_details'

    def is_file_copy_details(self):
        """
        Check if the union tag is ``file_copy_details``.

        :rtype: bool
        """
        return self._tag == 'file_copy_details'

    def is_file_delete_details(self):
        """
        Check if the union tag is ``file_delete_details``.

        :rtype: bool
        """
        return self._tag == 'file_delete_details'

    def is_file_download_details(self):
        """
        Check if the union tag is ``file_download_details``.

        :rtype: bool
        """
        return self._tag == 'file_download_details'

    def is_file_edit_details(self):
        """
        Check if the union tag is ``file_edit_details``.

        :rtype: bool
        """
        return self._tag == 'file_edit_details'

    def is_file_get_copy_reference_details(self):
        """
        Check if the union tag is ``file_get_copy_reference_details``.

        :rtype: bool
        """
        return self._tag == 'file_get_copy_reference_details'

    def is_file_locking_lock_status_changed_details(self):
        """
        Check if the union tag is ``file_locking_lock_status_changed_details``.

        :rtype: bool
        """
        return self._tag == 'file_locking_lock_status_changed_details'

    def is_file_move_details(self):
        """
        Check if the union tag is ``file_move_details``.

        :rtype: bool
        """
        return self._tag == 'file_move_details'

    def is_file_permanently_delete_details(self):
        """
        Check if the union tag is ``file_permanently_delete_details``.

        :rtype: bool
        """
        return self._tag == 'file_permanently_delete_details'

    def is_file_preview_details(self):
        """
        Check if the union tag is ``file_preview_details``.

        :rtype: bool
        """
        return self._tag == 'file_preview_details'

    def is_file_rename_details(self):
        """
        Check if the union tag is ``file_rename_details``.

        :rtype: bool
        """
        return self._tag == 'file_rename_details'

    def is_file_restore_details(self):
        """
        Check if the union tag is ``file_restore_details``.

        :rtype: bool
        """
        return self._tag == 'file_restore_details'

    def is_file_revert_details(self):
        """
        Check if the union tag is ``file_revert_details``.

        :rtype: bool
        """
        return self._tag == 'file_revert_details'

    def is_file_rollback_changes_details(self):
        """
        Check if the union tag is ``file_rollback_changes_details``.

        :rtype: bool
        """
        return self._tag == 'file_rollback_changes_details'

    def is_file_save_copy_reference_details(self):
        """
        Check if the union tag is ``file_save_copy_reference_details``.

        :rtype: bool
        """
        return self._tag == 'file_save_copy_reference_details'

    def is_folder_overview_description_changed_details(self):
        """
        Check if the union tag is ``folder_overview_description_changed_details``.

        :rtype: bool
        """
        return self._tag == 'folder_overview_description_changed_details'

    def is_folder_overview_item_pinned_details(self):
        """
        Check if the union tag is ``folder_overview_item_pinned_details``.

        :rtype: bool
        """
        return self._tag == 'folder_overview_item_pinned_details'

    def is_folder_overview_item_unpinned_details(self):
        """
        Check if the union tag is ``folder_overview_item_unpinned_details``.

        :rtype: bool
        """
        return self._tag == 'folder_overview_item_unpinned_details'

    def is_object_label_added_details(self):
        """
        Check if the union tag is ``object_label_added_details``.

        :rtype: bool
        """
        return self._tag == 'object_label_added_details'

    def is_object_label_removed_details(self):
        """
        Check if the union tag is ``object_label_removed_details``.

        :rtype: bool
        """
        return self._tag == 'object_label_removed_details'

    def is_object_label_updated_value_details(self):
        """
        Check if the union tag is ``object_label_updated_value_details``.

        :rtype: bool
        """
        return self._tag == 'object_label_updated_value_details'

    def is_organize_folder_with_tidy_details(self):
        """
        Check if the union tag is ``organize_folder_with_tidy_details``.

        :rtype: bool
        """
        return self._tag == 'organize_folder_with_tidy_details'

    def is_rewind_folder_details(self):
        """
        Check if the union tag is ``rewind_folder_details``.

        :rtype: bool
        """
        return self._tag == 'rewind_folder_details'

    def is_undo_naming_convention_details(self):
        """
        Check if the union tag is ``undo_naming_convention_details``.

        :rtype: bool
        """
        return self._tag == 'undo_naming_convention_details'

    def is_undo_organize_folder_with_tidy_details(self):
        """
        Check if the union tag is ``undo_organize_folder_with_tidy_details``.

        :rtype: bool
        """
        return self._tag == 'undo_organize_folder_with_tidy_details'

    def is_user_tags_added_details(self):
        """
        Check if the union tag is ``user_tags_added_details``.

        :rtype: bool
        """
        return self._tag == 'user_tags_added_details'

    def is_user_tags_removed_details(self):
        """
        Check if the union tag is ``user_tags_removed_details``.

        :rtype: bool
        """
        return self._tag == 'user_tags_removed_details'

    def is_email_ingest_receive_file_details(self):
        """
        Check if the union tag is ``email_ingest_receive_file_details``.

        :rtype: bool
        """
        return self._tag == 'email_ingest_receive_file_details'

    def is_file_request_change_details(self):
        """
        Check if the union tag is ``file_request_change_details``.

        :rtype: bool
        """
        return self._tag == 'file_request_change_details'

    def is_file_request_close_details(self):
        """
        Check if the union tag is ``file_request_close_details``.

        :rtype: bool
        """
        return self._tag == 'file_request_close_details'

    def is_file_request_create_details(self):
        """
        Check if the union tag is ``file_request_create_details``.

        :rtype: bool
        """
        return self._tag == 'file_request_create_details'

    def is_file_request_delete_details(self):
        """
        Check if the union tag is ``file_request_delete_details``.

        :rtype: bool
        """
        return self._tag == 'file_request_delete_details'

    def is_file_request_receive_file_details(self):
        """
        Check if the union tag is ``file_request_receive_file_details``.

        :rtype: bool
        """
        return self._tag == 'file_request_receive_file_details'

    def is_group_add_external_id_details(self):
        """
        Check if the union tag is ``group_add_external_id_details``.

        :rtype: bool
        """
        return self._tag == 'group_add_external_id_details'

    def is_group_add_member_details(self):
        """
        Check if the union tag is ``group_add_member_details``.

        :rtype: bool
        """
        return self._tag == 'group_add_member_details'

    def is_group_change_external_id_details(self):
        """
        Check if the union tag is ``group_change_external_id_details``.

        :rtype: bool
        """
        return self._tag == 'group_change_external_id_details'

    def is_group_change_management_type_details(self):
        """
        Check if the union tag is ``group_change_management_type_details``.

        :rtype: bool
        """
        return self._tag == 'group_change_management_type_details'

    def is_group_change_member_role_details(self):
        """
        Check if the union tag is ``group_change_member_role_details``.

        :rtype: bool
        """
        return self._tag == 'group_change_member_role_details'

    def is_group_create_details(self):
        """
        Check if the union tag is ``group_create_details``.

        :rtype: bool
        """
        return self._tag == 'group_create_details'

    def is_group_delete_details(self):
        """
        Check if the union tag is ``group_delete_details``.

        :rtype: bool
        """
        return self._tag == 'group_delete_details'

    def is_group_description_updated_details(self):
        """
        Check if the union tag is ``group_description_updated_details``.

        :rtype: bool
        """
        return self._tag == 'group_description_updated_details'

    def is_group_join_policy_updated_details(self):
        """
        Check if the union tag is ``group_join_policy_updated_details``.

        :rtype: bool
        """
        return self._tag == 'group_join_policy_updated_details'

    def is_group_moved_details(self):
        """
        Check if the union tag is ``group_moved_details``.

        :rtype: bool
        """
        return self._tag == 'group_moved_details'

    def is_group_remove_external_id_details(self):
        """
        Check if the union tag is ``group_remove_external_id_details``.

        :rtype: bool
        """
        return self._tag == 'group_remove_external_id_details'

    def is_group_remove_member_details(self):
        """
        Check if the union tag is ``group_remove_member_details``.

        :rtype: bool
        """
        return self._tag == 'group_remove_member_details'

    def is_group_rename_details(self):
        """
        Check if the union tag is ``group_rename_details``.

        :rtype: bool
        """
        return self._tag == 'group_rename_details'

    def is_account_lock_or_unlocked_details(self):
        """
        Check if the union tag is ``account_lock_or_unlocked_details``.

        :rtype: bool
        """
        return self._tag == 'account_lock_or_unlocked_details'

    def is_emm_error_details(self):
        """
        Check if the union tag is ``emm_error_details``.

        :rtype: bool
        """
        return self._tag == 'emm_error_details'

    def is_guest_admin_signed_in_via_trusted_teams_details(self):
        """
        Check if the union tag is ``guest_admin_signed_in_via_trusted_teams_details``.

        :rtype: bool
        """
        return self._tag == 'guest_admin_signed_in_via_trusted_teams_details'

    def is_guest_admin_signed_out_via_trusted_teams_details(self):
        """
        Check if the union tag is ``guest_admin_signed_out_via_trusted_teams_details``.

        :rtype: bool
        """
        return self._tag == 'guest_admin_signed_out_via_trusted_teams_details'

    def is_login_fail_details(self):
        """
        Check if the union tag is ``login_fail_details``.

        :rtype: bool
        """
        return self._tag == 'login_fail_details'

    def is_login_success_details(self):
        """
        Check if the union tag is ``login_success_details``.

        :rtype: bool
        """
        return self._tag == 'login_success_details'

    def is_logout_details(self):
        """
        Check if the union tag is ``logout_details``.

        :rtype: bool
        """
        return self._tag == 'logout_details'

    def is_reseller_support_session_end_details(self):
        """
        Check if the union tag is ``reseller_support_session_end_details``.

        :rtype: bool
        """
        return self._tag == 'reseller_support_session_end_details'

    def is_reseller_support_session_start_details(self):
        """
        Check if the union tag is ``reseller_support_session_start_details``.

        :rtype: bool
        """
        return self._tag == 'reseller_support_session_start_details'

    def is_sign_in_as_session_end_details(self):
        """
        Check if the union tag is ``sign_in_as_session_end_details``.

        :rtype: bool
        """
        return self._tag == 'sign_in_as_session_end_details'

    def is_sign_in_as_session_start_details(self):
        """
        Check if the union tag is ``sign_in_as_session_start_details``.

        :rtype: bool
        """
        return self._tag == 'sign_in_as_session_start_details'

    def is_sso_error_details(self):
        """
        Check if the union tag is ``sso_error_details``.

        :rtype: bool
        """
        return self._tag == 'sso_error_details'

    def is_create_team_invite_link_details(self):
        """
        Check if the union tag is ``create_team_invite_link_details``.

        :rtype: bool
        """
        return self._tag == 'create_team_invite_link_details'

    def is_delete_team_invite_link_details(self):
        """
        Check if the union tag is ``delete_team_invite_link_details``.

        :rtype: bool
        """
        return self._tag == 'delete_team_invite_link_details'

    def is_member_add_external_id_details(self):
        """
        Check if the union tag is ``member_add_external_id_details``.

        :rtype: bool
        """
        return self._tag == 'member_add_external_id_details'

    def is_member_add_name_details(self):
        """
        Check if the union tag is ``member_add_name_details``.

        :rtype: bool
        """
        return self._tag == 'member_add_name_details'

    def is_member_change_admin_role_details(self):
        """
        Check if the union tag is ``member_change_admin_role_details``.

        :rtype: bool
        """
        return self._tag == 'member_change_admin_role_details'

    def is_member_change_email_details(self):
        """
        Check if the union tag is ``member_change_email_details``.

        :rtype: bool
        """
        return self._tag == 'member_change_email_details'

    def is_member_change_external_id_details(self):
        """
        Check if the union tag is ``member_change_external_id_details``.

        :rtype: bool
        """
        return self._tag == 'member_change_external_id_details'

    def is_member_change_membership_type_details(self):
        """
        Check if the union tag is ``member_change_membership_type_details``.

        :rtype: bool
        """
        return self._tag == 'member_change_membership_type_details'

    def is_member_change_name_details(self):
        """
        Check if the union tag is ``member_change_name_details``.

        :rtype: bool
        """
        return self._tag == 'member_change_name_details'

    def is_member_change_reseller_role_details(self):
        """
        Check if the union tag is ``member_change_reseller_role_details``.

        :rtype: bool
        """
        return self._tag == 'member_change_reseller_role_details'

    def is_member_change_status_details(self):
        """
        Check if the union tag is ``member_change_status_details``.

        :rtype: bool
        """
        return self._tag == 'member_change_status_details'

    def is_member_delete_manual_contacts_details(self):
        """
        Check if the union tag is ``member_delete_manual_contacts_details``.

        :rtype: bool
        """
        return self._tag == 'member_delete_manual_contacts_details'

    def is_member_delete_profile_photo_details(self):
        """
        Check if the union tag is ``member_delete_profile_photo_details``.

        :rtype: bool
        """
        return self._tag == 'member_delete_profile_photo_details'

    def is_member_permanently_delete_account_contents_details(self):
        """
        Check if the union tag is ``member_permanently_delete_account_contents_details``.

        :rtype: bool
        """
        return self._tag == 'member_permanently_delete_account_contents_details'

    def is_member_remove_external_id_details(self):
        """
        Check if the union tag is ``member_remove_external_id_details``.

        :rtype: bool
        """
        return self._tag == 'member_remove_external_id_details'

    def is_member_set_profile_photo_details(self):
        """
        Check if the union tag is ``member_set_profile_photo_details``.

        :rtype: bool
        """
        return self._tag == 'member_set_profile_photo_details'

    def is_member_space_limits_add_custom_quota_details(self):
        """
        Check if the union tag is ``member_space_limits_add_custom_quota_details``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_add_custom_quota_details'

    def is_member_space_limits_change_custom_quota_details(self):
        """
        Check if the union tag is ``member_space_limits_change_custom_quota_details``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_change_custom_quota_details'

    def is_member_space_limits_change_status_details(self):
        """
        Check if the union tag is ``member_space_limits_change_status_details``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_change_status_details'

    def is_member_space_limits_remove_custom_quota_details(self):
        """
        Check if the union tag is ``member_space_limits_remove_custom_quota_details``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_remove_custom_quota_details'

    def is_member_suggest_details(self):
        """
        Check if the union tag is ``member_suggest_details``.

        :rtype: bool
        """
        return self._tag == 'member_suggest_details'

    def is_member_transfer_account_contents_details(self):
        """
        Check if the union tag is ``member_transfer_account_contents_details``.

        :rtype: bool
        """
        return self._tag == 'member_transfer_account_contents_details'

    def is_pending_secondary_email_added_details(self):
        """
        Check if the union tag is ``pending_secondary_email_added_details``.

        :rtype: bool
        """
        return self._tag == 'pending_secondary_email_added_details'

    def is_secondary_email_deleted_details(self):
        """
        Check if the union tag is ``secondary_email_deleted_details``.

        :rtype: bool
        """
        return self._tag == 'secondary_email_deleted_details'

    def is_secondary_email_verified_details(self):
        """
        Check if the union tag is ``secondary_email_verified_details``.

        :rtype: bool
        """
        return self._tag == 'secondary_email_verified_details'

    def is_secondary_mails_policy_changed_details(self):
        """
        Check if the union tag is ``secondary_mails_policy_changed_details``.

        :rtype: bool
        """
        return self._tag == 'secondary_mails_policy_changed_details'

    def is_binder_add_page_details(self):
        """
        Check if the union tag is ``binder_add_page_details``.

        :rtype: bool
        """
        return self._tag == 'binder_add_page_details'

    def is_binder_add_section_details(self):
        """
        Check if the union tag is ``binder_add_section_details``.

        :rtype: bool
        """
        return self._tag == 'binder_add_section_details'

    def is_binder_remove_page_details(self):
        """
        Check if the union tag is ``binder_remove_page_details``.

        :rtype: bool
        """
        return self._tag == 'binder_remove_page_details'

    def is_binder_remove_section_details(self):
        """
        Check if the union tag is ``binder_remove_section_details``.

        :rtype: bool
        """
        return self._tag == 'binder_remove_section_details'

    def is_binder_rename_page_details(self):
        """
        Check if the union tag is ``binder_rename_page_details``.

        :rtype: bool
        """
        return self._tag == 'binder_rename_page_details'

    def is_binder_rename_section_details(self):
        """
        Check if the union tag is ``binder_rename_section_details``.

        :rtype: bool
        """
        return self._tag == 'binder_rename_section_details'

    def is_binder_reorder_page_details(self):
        """
        Check if the union tag is ``binder_reorder_page_details``.

        :rtype: bool
        """
        return self._tag == 'binder_reorder_page_details'

    def is_binder_reorder_section_details(self):
        """
        Check if the union tag is ``binder_reorder_section_details``.

        :rtype: bool
        """
        return self._tag == 'binder_reorder_section_details'

    def is_paper_content_add_member_details(self):
        """
        Check if the union tag is ``paper_content_add_member_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_add_member_details'

    def is_paper_content_add_to_folder_details(self):
        """
        Check if the union tag is ``paper_content_add_to_folder_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_add_to_folder_details'

    def is_paper_content_archive_details(self):
        """
        Check if the union tag is ``paper_content_archive_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_archive_details'

    def is_paper_content_create_details(self):
        """
        Check if the union tag is ``paper_content_create_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_create_details'

    def is_paper_content_permanently_delete_details(self):
        """
        Check if the union tag is ``paper_content_permanently_delete_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_permanently_delete_details'

    def is_paper_content_remove_from_folder_details(self):
        """
        Check if the union tag is ``paper_content_remove_from_folder_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_remove_from_folder_details'

    def is_paper_content_remove_member_details(self):
        """
        Check if the union tag is ``paper_content_remove_member_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_remove_member_details'

    def is_paper_content_rename_details(self):
        """
        Check if the union tag is ``paper_content_rename_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_rename_details'

    def is_paper_content_restore_details(self):
        """
        Check if the union tag is ``paper_content_restore_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_restore_details'

    def is_paper_doc_add_comment_details(self):
        """
        Check if the union tag is ``paper_doc_add_comment_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_add_comment_details'

    def is_paper_doc_change_member_role_details(self):
        """
        Check if the union tag is ``paper_doc_change_member_role_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_change_member_role_details'

    def is_paper_doc_change_sharing_policy_details(self):
        """
        Check if the union tag is ``paper_doc_change_sharing_policy_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_change_sharing_policy_details'

    def is_paper_doc_change_subscription_details(self):
        """
        Check if the union tag is ``paper_doc_change_subscription_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_change_subscription_details'

    def is_paper_doc_deleted_details(self):
        """
        Check if the union tag is ``paper_doc_deleted_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_deleted_details'

    def is_paper_doc_delete_comment_details(self):
        """
        Check if the union tag is ``paper_doc_delete_comment_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_delete_comment_details'

    def is_paper_doc_download_details(self):
        """
        Check if the union tag is ``paper_doc_download_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_download_details'

    def is_paper_doc_edit_details(self):
        """
        Check if the union tag is ``paper_doc_edit_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_edit_details'

    def is_paper_doc_edit_comment_details(self):
        """
        Check if the union tag is ``paper_doc_edit_comment_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_edit_comment_details'

    def is_paper_doc_followed_details(self):
        """
        Check if the union tag is ``paper_doc_followed_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_followed_details'

    def is_paper_doc_mention_details(self):
        """
        Check if the union tag is ``paper_doc_mention_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_mention_details'

    def is_paper_doc_ownership_changed_details(self):
        """
        Check if the union tag is ``paper_doc_ownership_changed_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_ownership_changed_details'

    def is_paper_doc_request_access_details(self):
        """
        Check if the union tag is ``paper_doc_request_access_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_request_access_details'

    def is_paper_doc_resolve_comment_details(self):
        """
        Check if the union tag is ``paper_doc_resolve_comment_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_resolve_comment_details'

    def is_paper_doc_revert_details(self):
        """
        Check if the union tag is ``paper_doc_revert_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_revert_details'

    def is_paper_doc_slack_share_details(self):
        """
        Check if the union tag is ``paper_doc_slack_share_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_slack_share_details'

    def is_paper_doc_team_invite_details(self):
        """
        Check if the union tag is ``paper_doc_team_invite_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_team_invite_details'

    def is_paper_doc_trashed_details(self):
        """
        Check if the union tag is ``paper_doc_trashed_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_trashed_details'

    def is_paper_doc_unresolve_comment_details(self):
        """
        Check if the union tag is ``paper_doc_unresolve_comment_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_unresolve_comment_details'

    def is_paper_doc_untrashed_details(self):
        """
        Check if the union tag is ``paper_doc_untrashed_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_untrashed_details'

    def is_paper_doc_view_details(self):
        """
        Check if the union tag is ``paper_doc_view_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_view_details'

    def is_paper_external_view_allow_details(self):
        """
        Check if the union tag is ``paper_external_view_allow_details``.

        :rtype: bool
        """
        return self._tag == 'paper_external_view_allow_details'

    def is_paper_external_view_default_team_details(self):
        """
        Check if the union tag is ``paper_external_view_default_team_details``.

        :rtype: bool
        """
        return self._tag == 'paper_external_view_default_team_details'

    def is_paper_external_view_forbid_details(self):
        """
        Check if the union tag is ``paper_external_view_forbid_details``.

        :rtype: bool
        """
        return self._tag == 'paper_external_view_forbid_details'

    def is_paper_folder_change_subscription_details(self):
        """
        Check if the union tag is ``paper_folder_change_subscription_details``.

        :rtype: bool
        """
        return self._tag == 'paper_folder_change_subscription_details'

    def is_paper_folder_deleted_details(self):
        """
        Check if the union tag is ``paper_folder_deleted_details``.

        :rtype: bool
        """
        return self._tag == 'paper_folder_deleted_details'

    def is_paper_folder_followed_details(self):
        """
        Check if the union tag is ``paper_folder_followed_details``.

        :rtype: bool
        """
        return self._tag == 'paper_folder_followed_details'

    def is_paper_folder_team_invite_details(self):
        """
        Check if the union tag is ``paper_folder_team_invite_details``.

        :rtype: bool
        """
        return self._tag == 'paper_folder_team_invite_details'

    def is_paper_published_link_change_permission_details(self):
        """
        Check if the union tag is ``paper_published_link_change_permission_details``.

        :rtype: bool
        """
        return self._tag == 'paper_published_link_change_permission_details'

    def is_paper_published_link_create_details(self):
        """
        Check if the union tag is ``paper_published_link_create_details``.

        :rtype: bool
        """
        return self._tag == 'paper_published_link_create_details'

    def is_paper_published_link_disabled_details(self):
        """
        Check if the union tag is ``paper_published_link_disabled_details``.

        :rtype: bool
        """
        return self._tag == 'paper_published_link_disabled_details'

    def is_paper_published_link_view_details(self):
        """
        Check if the union tag is ``paper_published_link_view_details``.

        :rtype: bool
        """
        return self._tag == 'paper_published_link_view_details'

    def is_password_change_details(self):
        """
        Check if the union tag is ``password_change_details``.

        :rtype: bool
        """
        return self._tag == 'password_change_details'

    def is_password_reset_details(self):
        """
        Check if the union tag is ``password_reset_details``.

        :rtype: bool
        """
        return self._tag == 'password_reset_details'

    def is_password_reset_all_details(self):
        """
        Check if the union tag is ``password_reset_all_details``.

        :rtype: bool
        """
        return self._tag == 'password_reset_all_details'

    def is_classification_create_report_details(self):
        """
        Check if the union tag is ``classification_create_report_details``.

        :rtype: bool
        """
        return self._tag == 'classification_create_report_details'

    def is_classification_create_report_fail_details(self):
        """
        Check if the union tag is ``classification_create_report_fail_details``.

        :rtype: bool
        """
        return self._tag == 'classification_create_report_fail_details'

    def is_emm_create_exceptions_report_details(self):
        """
        Check if the union tag is ``emm_create_exceptions_report_details``.

        :rtype: bool
        """
        return self._tag == 'emm_create_exceptions_report_details'

    def is_emm_create_usage_report_details(self):
        """
        Check if the union tag is ``emm_create_usage_report_details``.

        :rtype: bool
        """
        return self._tag == 'emm_create_usage_report_details'

    def is_export_members_report_details(self):
        """
        Check if the union tag is ``export_members_report_details``.

        :rtype: bool
        """
        return self._tag == 'export_members_report_details'

    def is_export_members_report_fail_details(self):
        """
        Check if the union tag is ``export_members_report_fail_details``.

        :rtype: bool
        """
        return self._tag == 'export_members_report_fail_details'

    def is_external_sharing_create_report_details(self):
        """
        Check if the union tag is ``external_sharing_create_report_details``.

        :rtype: bool
        """
        return self._tag == 'external_sharing_create_report_details'

    def is_external_sharing_report_failed_details(self):
        """
        Check if the union tag is ``external_sharing_report_failed_details``.

        :rtype: bool
        """
        return self._tag == 'external_sharing_report_failed_details'

    def is_no_expiration_link_gen_create_report_details(self):
        """
        Check if the union tag is ``no_expiration_link_gen_create_report_details``.

        :rtype: bool
        """
        return self._tag == 'no_expiration_link_gen_create_report_details'

    def is_no_expiration_link_gen_report_failed_details(self):
        """
        Check if the union tag is ``no_expiration_link_gen_report_failed_details``.

        :rtype: bool
        """
        return self._tag == 'no_expiration_link_gen_report_failed_details'

    def is_no_password_link_gen_create_report_details(self):
        """
        Check if the union tag is ``no_password_link_gen_create_report_details``.

        :rtype: bool
        """
        return self._tag == 'no_password_link_gen_create_report_details'

    def is_no_password_link_gen_report_failed_details(self):
        """
        Check if the union tag is ``no_password_link_gen_report_failed_details``.

        :rtype: bool
        """
        return self._tag == 'no_password_link_gen_report_failed_details'

    def is_no_password_link_view_create_report_details(self):
        """
        Check if the union tag is ``no_password_link_view_create_report_details``.

        :rtype: bool
        """
        return self._tag == 'no_password_link_view_create_report_details'

    def is_no_password_link_view_report_failed_details(self):
        """
        Check if the union tag is ``no_password_link_view_report_failed_details``.

        :rtype: bool
        """
        return self._tag == 'no_password_link_view_report_failed_details'

    def is_outdated_link_view_create_report_details(self):
        """
        Check if the union tag is ``outdated_link_view_create_report_details``.

        :rtype: bool
        """
        return self._tag == 'outdated_link_view_create_report_details'

    def is_outdated_link_view_report_failed_details(self):
        """
        Check if the union tag is ``outdated_link_view_report_failed_details``.

        :rtype: bool
        """
        return self._tag == 'outdated_link_view_report_failed_details'

    def is_paper_admin_export_start_details(self):
        """
        Check if the union tag is ``paper_admin_export_start_details``.

        :rtype: bool
        """
        return self._tag == 'paper_admin_export_start_details'

    def is_smart_sync_create_admin_privilege_report_details(self):
        """
        Check if the union tag is ``smart_sync_create_admin_privilege_report_details``.

        :rtype: bool
        """
        return self._tag == 'smart_sync_create_admin_privilege_report_details'

    def is_team_activity_create_report_details(self):
        """
        Check if the union tag is ``team_activity_create_report_details``.

        :rtype: bool
        """
        return self._tag == 'team_activity_create_report_details'

    def is_team_activity_create_report_fail_details(self):
        """
        Check if the union tag is ``team_activity_create_report_fail_details``.

        :rtype: bool
        """
        return self._tag == 'team_activity_create_report_fail_details'

    def is_collection_share_details(self):
        """
        Check if the union tag is ``collection_share_details``.

        :rtype: bool
        """
        return self._tag == 'collection_share_details'

    def is_file_transfers_file_add_details(self):
        """
        Check if the union tag is ``file_transfers_file_add_details``.

        :rtype: bool
        """
        return self._tag == 'file_transfers_file_add_details'

    def is_file_transfers_transfer_delete_details(self):
        """
        Check if the union tag is ``file_transfers_transfer_delete_details``.

        :rtype: bool
        """
        return self._tag == 'file_transfers_transfer_delete_details'

    def is_file_transfers_transfer_download_details(self):
        """
        Check if the union tag is ``file_transfers_transfer_download_details``.

        :rtype: bool
        """
        return self._tag == 'file_transfers_transfer_download_details'

    def is_file_transfers_transfer_send_details(self):
        """
        Check if the union tag is ``file_transfers_transfer_send_details``.

        :rtype: bool
        """
        return self._tag == 'file_transfers_transfer_send_details'

    def is_file_transfers_transfer_view_details(self):
        """
        Check if the union tag is ``file_transfers_transfer_view_details``.

        :rtype: bool
        """
        return self._tag == 'file_transfers_transfer_view_details'

    def is_note_acl_invite_only_details(self):
        """
        Check if the union tag is ``note_acl_invite_only_details``.

        :rtype: bool
        """
        return self._tag == 'note_acl_invite_only_details'

    def is_note_acl_link_details(self):
        """
        Check if the union tag is ``note_acl_link_details``.

        :rtype: bool
        """
        return self._tag == 'note_acl_link_details'

    def is_note_acl_team_link_details(self):
        """
        Check if the union tag is ``note_acl_team_link_details``.

        :rtype: bool
        """
        return self._tag == 'note_acl_team_link_details'

    def is_note_shared_details(self):
        """
        Check if the union tag is ``note_shared_details``.

        :rtype: bool
        """
        return self._tag == 'note_shared_details'

    def is_note_share_receive_details(self):
        """
        Check if the union tag is ``note_share_receive_details``.

        :rtype: bool
        """
        return self._tag == 'note_share_receive_details'

    def is_open_note_shared_details(self):
        """
        Check if the union tag is ``open_note_shared_details``.

        :rtype: bool
        """
        return self._tag == 'open_note_shared_details'

    def is_sf_add_group_details(self):
        """
        Check if the union tag is ``sf_add_group_details``.

        :rtype: bool
        """
        return self._tag == 'sf_add_group_details'

    def is_sf_allow_non_members_to_view_shared_links_details(self):
        """
        Check if the union tag is ``sf_allow_non_members_to_view_shared_links_details``.

        :rtype: bool
        """
        return self._tag == 'sf_allow_non_members_to_view_shared_links_details'

    def is_sf_external_invite_warn_details(self):
        """
        Check if the union tag is ``sf_external_invite_warn_details``.

        :rtype: bool
        """
        return self._tag == 'sf_external_invite_warn_details'

    def is_sf_fb_invite_details(self):
        """
        Check if the union tag is ``sf_fb_invite_details``.

        :rtype: bool
        """
        return self._tag == 'sf_fb_invite_details'

    def is_sf_fb_invite_change_role_details(self):
        """
        Check if the union tag is ``sf_fb_invite_change_role_details``.

        :rtype: bool
        """
        return self._tag == 'sf_fb_invite_change_role_details'

    def is_sf_fb_uninvite_details(self):
        """
        Check if the union tag is ``sf_fb_uninvite_details``.

        :rtype: bool
        """
        return self._tag == 'sf_fb_uninvite_details'

    def is_sf_invite_group_details(self):
        """
        Check if the union tag is ``sf_invite_group_details``.

        :rtype: bool
        """
        return self._tag == 'sf_invite_group_details'

    def is_sf_team_grant_access_details(self):
        """
        Check if the union tag is ``sf_team_grant_access_details``.

        :rtype: bool
        """
        return self._tag == 'sf_team_grant_access_details'

    def is_sf_team_invite_details(self):
        """
        Check if the union tag is ``sf_team_invite_details``.

        :rtype: bool
        """
        return self._tag == 'sf_team_invite_details'

    def is_sf_team_invite_change_role_details(self):
        """
        Check if the union tag is ``sf_team_invite_change_role_details``.

        :rtype: bool
        """
        return self._tag == 'sf_team_invite_change_role_details'

    def is_sf_team_join_details(self):
        """
        Check if the union tag is ``sf_team_join_details``.

        :rtype: bool
        """
        return self._tag == 'sf_team_join_details'

    def is_sf_team_join_from_oob_link_details(self):
        """
        Check if the union tag is ``sf_team_join_from_oob_link_details``.

        :rtype: bool
        """
        return self._tag == 'sf_team_join_from_oob_link_details'

    def is_sf_team_uninvite_details(self):
        """
        Check if the union tag is ``sf_team_uninvite_details``.

        :rtype: bool
        """
        return self._tag == 'sf_team_uninvite_details'

    def is_shared_content_add_invitees_details(self):
        """
        Check if the union tag is ``shared_content_add_invitees_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_add_invitees_details'

    def is_shared_content_add_link_expiry_details(self):
        """
        Check if the union tag is ``shared_content_add_link_expiry_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_add_link_expiry_details'

    def is_shared_content_add_link_password_details(self):
        """
        Check if the union tag is ``shared_content_add_link_password_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_add_link_password_details'

    def is_shared_content_add_member_details(self):
        """
        Check if the union tag is ``shared_content_add_member_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_add_member_details'

    def is_shared_content_change_downloads_policy_details(self):
        """
        Check if the union tag is ``shared_content_change_downloads_policy_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_downloads_policy_details'

    def is_shared_content_change_invitee_role_details(self):
        """
        Check if the union tag is ``shared_content_change_invitee_role_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_invitee_role_details'

    def is_shared_content_change_link_audience_details(self):
        """
        Check if the union tag is ``shared_content_change_link_audience_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_link_audience_details'

    def is_shared_content_change_link_expiry_details(self):
        """
        Check if the union tag is ``shared_content_change_link_expiry_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_link_expiry_details'

    def is_shared_content_change_link_password_details(self):
        """
        Check if the union tag is ``shared_content_change_link_password_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_link_password_details'

    def is_shared_content_change_member_role_details(self):
        """
        Check if the union tag is ``shared_content_change_member_role_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_member_role_details'

    def is_shared_content_change_viewer_info_policy_details(self):
        """
        Check if the union tag is ``shared_content_change_viewer_info_policy_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_viewer_info_policy_details'

    def is_shared_content_claim_invitation_details(self):
        """
        Check if the union tag is ``shared_content_claim_invitation_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_claim_invitation_details'

    def is_shared_content_copy_details(self):
        """
        Check if the union tag is ``shared_content_copy_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_copy_details'

    def is_shared_content_download_details(self):
        """
        Check if the union tag is ``shared_content_download_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_download_details'

    def is_shared_content_relinquish_membership_details(self):
        """
        Check if the union tag is ``shared_content_relinquish_membership_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_relinquish_membership_details'

    def is_shared_content_remove_invitees_details(self):
        """
        Check if the union tag is ``shared_content_remove_invitees_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_remove_invitees_details'

    def is_shared_content_remove_link_expiry_details(self):
        """
        Check if the union tag is ``shared_content_remove_link_expiry_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_remove_link_expiry_details'

    def is_shared_content_remove_link_password_details(self):
        """
        Check if the union tag is ``shared_content_remove_link_password_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_remove_link_password_details'

    def is_shared_content_remove_member_details(self):
        """
        Check if the union tag is ``shared_content_remove_member_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_remove_member_details'

    def is_shared_content_request_access_details(self):
        """
        Check if the union tag is ``shared_content_request_access_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_request_access_details'

    def is_shared_content_restore_invitees_details(self):
        """
        Check if the union tag is ``shared_content_restore_invitees_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_restore_invitees_details'

    def is_shared_content_restore_member_details(self):
        """
        Check if the union tag is ``shared_content_restore_member_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_restore_member_details'

    def is_shared_content_unshare_details(self):
        """
        Check if the union tag is ``shared_content_unshare_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_unshare_details'

    def is_shared_content_view_details(self):
        """
        Check if the union tag is ``shared_content_view_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_view_details'

    def is_shared_folder_change_link_policy_details(self):
        """
        Check if the union tag is ``shared_folder_change_link_policy_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_change_link_policy_details'

    def is_shared_folder_change_members_inheritance_policy_details(self):
        """
        Check if the union tag is ``shared_folder_change_members_inheritance_policy_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_change_members_inheritance_policy_details'

    def is_shared_folder_change_members_management_policy_details(self):
        """
        Check if the union tag is ``shared_folder_change_members_management_policy_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_change_members_management_policy_details'

    def is_shared_folder_change_members_policy_details(self):
        """
        Check if the union tag is ``shared_folder_change_members_policy_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_change_members_policy_details'

    def is_shared_folder_create_details(self):
        """
        Check if the union tag is ``shared_folder_create_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_create_details'

    def is_shared_folder_decline_invitation_details(self):
        """
        Check if the union tag is ``shared_folder_decline_invitation_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_decline_invitation_details'

    def is_shared_folder_mount_details(self):
        """
        Check if the union tag is ``shared_folder_mount_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_mount_details'

    def is_shared_folder_nest_details(self):
        """
        Check if the union tag is ``shared_folder_nest_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_nest_details'

    def is_shared_folder_transfer_ownership_details(self):
        """
        Check if the union tag is ``shared_folder_transfer_ownership_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_transfer_ownership_details'

    def is_shared_folder_unmount_details(self):
        """
        Check if the union tag is ``shared_folder_unmount_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_unmount_details'

    def is_shared_link_add_expiry_details(self):
        """
        Check if the union tag is ``shared_link_add_expiry_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_add_expiry_details'

    def is_shared_link_change_expiry_details(self):
        """
        Check if the union tag is ``shared_link_change_expiry_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_change_expiry_details'

    def is_shared_link_change_visibility_details(self):
        """
        Check if the union tag is ``shared_link_change_visibility_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_change_visibility_details'

    def is_shared_link_copy_details(self):
        """
        Check if the union tag is ``shared_link_copy_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_copy_details'

    def is_shared_link_create_details(self):
        """
        Check if the union tag is ``shared_link_create_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_create_details'

    def is_shared_link_disable_details(self):
        """
        Check if the union tag is ``shared_link_disable_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_disable_details'

    def is_shared_link_download_details(self):
        """
        Check if the union tag is ``shared_link_download_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_download_details'

    def is_shared_link_remove_expiry_details(self):
        """
        Check if the union tag is ``shared_link_remove_expiry_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_remove_expiry_details'

    def is_shared_link_settings_add_expiration_details(self):
        """
        Check if the union tag is ``shared_link_settings_add_expiration_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_settings_add_expiration_details'

    def is_shared_link_settings_add_password_details(self):
        """
        Check if the union tag is ``shared_link_settings_add_password_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_settings_add_password_details'

    def is_shared_link_settings_allow_download_disabled_details(self):
        """
        Check if the union tag is ``shared_link_settings_allow_download_disabled_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_settings_allow_download_disabled_details'

    def is_shared_link_settings_allow_download_enabled_details(self):
        """
        Check if the union tag is ``shared_link_settings_allow_download_enabled_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_settings_allow_download_enabled_details'

    def is_shared_link_settings_change_audience_details(self):
        """
        Check if the union tag is ``shared_link_settings_change_audience_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_settings_change_audience_details'

    def is_shared_link_settings_change_expiration_details(self):
        """
        Check if the union tag is ``shared_link_settings_change_expiration_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_settings_change_expiration_details'

    def is_shared_link_settings_change_password_details(self):
        """
        Check if the union tag is ``shared_link_settings_change_password_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_settings_change_password_details'

    def is_shared_link_settings_remove_expiration_details(self):
        """
        Check if the union tag is ``shared_link_settings_remove_expiration_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_settings_remove_expiration_details'

    def is_shared_link_settings_remove_password_details(self):
        """
        Check if the union tag is ``shared_link_settings_remove_password_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_settings_remove_password_details'

    def is_shared_link_share_details(self):
        """
        Check if the union tag is ``shared_link_share_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_share_details'

    def is_shared_link_view_details(self):
        """
        Check if the union tag is ``shared_link_view_details``.

        :rtype: bool
        """
        return self._tag == 'shared_link_view_details'

    def is_shared_note_opened_details(self):
        """
        Check if the union tag is ``shared_note_opened_details``.

        :rtype: bool
        """
        return self._tag == 'shared_note_opened_details'

    def is_shmodel_disable_downloads_details(self):
        """
        Check if the union tag is ``shmodel_disable_downloads_details``.

        :rtype: bool
        """
        return self._tag == 'shmodel_disable_downloads_details'

    def is_shmodel_enable_downloads_details(self):
        """
        Check if the union tag is ``shmodel_enable_downloads_details``.

        :rtype: bool
        """
        return self._tag == 'shmodel_enable_downloads_details'

    def is_shmodel_group_share_details(self):
        """
        Check if the union tag is ``shmodel_group_share_details``.

        :rtype: bool
        """
        return self._tag == 'shmodel_group_share_details'

    def is_showcase_access_granted_details(self):
        """
        Check if the union tag is ``showcase_access_granted_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_access_granted_details'

    def is_showcase_add_member_details(self):
        """
        Check if the union tag is ``showcase_add_member_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_add_member_details'

    def is_showcase_archived_details(self):
        """
        Check if the union tag is ``showcase_archived_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_archived_details'

    def is_showcase_created_details(self):
        """
        Check if the union tag is ``showcase_created_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_created_details'

    def is_showcase_delete_comment_details(self):
        """
        Check if the union tag is ``showcase_delete_comment_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_delete_comment_details'

    def is_showcase_edited_details(self):
        """
        Check if the union tag is ``showcase_edited_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_edited_details'

    def is_showcase_edit_comment_details(self):
        """
        Check if the union tag is ``showcase_edit_comment_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_edit_comment_details'

    def is_showcase_file_added_details(self):
        """
        Check if the union tag is ``showcase_file_added_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_file_added_details'

    def is_showcase_file_download_details(self):
        """
        Check if the union tag is ``showcase_file_download_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_file_download_details'

    def is_showcase_file_removed_details(self):
        """
        Check if the union tag is ``showcase_file_removed_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_file_removed_details'

    def is_showcase_file_view_details(self):
        """
        Check if the union tag is ``showcase_file_view_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_file_view_details'

    def is_showcase_permanently_deleted_details(self):
        """
        Check if the union tag is ``showcase_permanently_deleted_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_permanently_deleted_details'

    def is_showcase_post_comment_details(self):
        """
        Check if the union tag is ``showcase_post_comment_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_post_comment_details'

    def is_showcase_remove_member_details(self):
        """
        Check if the union tag is ``showcase_remove_member_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_remove_member_details'

    def is_showcase_renamed_details(self):
        """
        Check if the union tag is ``showcase_renamed_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_renamed_details'

    def is_showcase_request_access_details(self):
        """
        Check if the union tag is ``showcase_request_access_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_request_access_details'

    def is_showcase_resolve_comment_details(self):
        """
        Check if the union tag is ``showcase_resolve_comment_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_resolve_comment_details'

    def is_showcase_restored_details(self):
        """
        Check if the union tag is ``showcase_restored_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_restored_details'

    def is_showcase_trashed_details(self):
        """
        Check if the union tag is ``showcase_trashed_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_trashed_details'

    def is_showcase_trashed_deprecated_details(self):
        """
        Check if the union tag is ``showcase_trashed_deprecated_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_trashed_deprecated_details'

    def is_showcase_unresolve_comment_details(self):
        """
        Check if the union tag is ``showcase_unresolve_comment_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_unresolve_comment_details'

    def is_showcase_untrashed_details(self):
        """
        Check if the union tag is ``showcase_untrashed_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_untrashed_details'

    def is_showcase_untrashed_deprecated_details(self):
        """
        Check if the union tag is ``showcase_untrashed_deprecated_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_untrashed_deprecated_details'

    def is_showcase_view_details(self):
        """
        Check if the union tag is ``showcase_view_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_view_details'

    def is_sso_add_cert_details(self):
        """
        Check if the union tag is ``sso_add_cert_details``.

        :rtype: bool
        """
        return self._tag == 'sso_add_cert_details'

    def is_sso_add_login_url_details(self):
        """
        Check if the union tag is ``sso_add_login_url_details``.

        :rtype: bool
        """
        return self._tag == 'sso_add_login_url_details'

    def is_sso_add_logout_url_details(self):
        """
        Check if the union tag is ``sso_add_logout_url_details``.

        :rtype: bool
        """
        return self._tag == 'sso_add_logout_url_details'

    def is_sso_change_cert_details(self):
        """
        Check if the union tag is ``sso_change_cert_details``.

        :rtype: bool
        """
        return self._tag == 'sso_change_cert_details'

    def is_sso_change_login_url_details(self):
        """
        Check if the union tag is ``sso_change_login_url_details``.

        :rtype: bool
        """
        return self._tag == 'sso_change_login_url_details'

    def is_sso_change_logout_url_details(self):
        """
        Check if the union tag is ``sso_change_logout_url_details``.

        :rtype: bool
        """
        return self._tag == 'sso_change_logout_url_details'

    def is_sso_change_saml_identity_mode_details(self):
        """
        Check if the union tag is ``sso_change_saml_identity_mode_details``.

        :rtype: bool
        """
        return self._tag == 'sso_change_saml_identity_mode_details'

    def is_sso_remove_cert_details(self):
        """
        Check if the union tag is ``sso_remove_cert_details``.

        :rtype: bool
        """
        return self._tag == 'sso_remove_cert_details'

    def is_sso_remove_login_url_details(self):
        """
        Check if the union tag is ``sso_remove_login_url_details``.

        :rtype: bool
        """
        return self._tag == 'sso_remove_login_url_details'

    def is_sso_remove_logout_url_details(self):
        """
        Check if the union tag is ``sso_remove_logout_url_details``.

        :rtype: bool
        """
        return self._tag == 'sso_remove_logout_url_details'

    def is_team_folder_change_status_details(self):
        """
        Check if the union tag is ``team_folder_change_status_details``.

        :rtype: bool
        """
        return self._tag == 'team_folder_change_status_details'

    def is_team_folder_create_details(self):
        """
        Check if the union tag is ``team_folder_create_details``.

        :rtype: bool
        """
        return self._tag == 'team_folder_create_details'

    def is_team_folder_downgrade_details(self):
        """
        Check if the union tag is ``team_folder_downgrade_details``.

        :rtype: bool
        """
        return self._tag == 'team_folder_downgrade_details'

    def is_team_folder_permanently_delete_details(self):
        """
        Check if the union tag is ``team_folder_permanently_delete_details``.

        :rtype: bool
        """
        return self._tag == 'team_folder_permanently_delete_details'

    def is_team_folder_rename_details(self):
        """
        Check if the union tag is ``team_folder_rename_details``.

        :rtype: bool
        """
        return self._tag == 'team_folder_rename_details'

    def is_team_selective_sync_settings_changed_details(self):
        """
        Check if the union tag is ``team_selective_sync_settings_changed_details``.

        :rtype: bool
        """
        return self._tag == 'team_selective_sync_settings_changed_details'

    def is_account_capture_change_policy_details(self):
        """
        Check if the union tag is ``account_capture_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'account_capture_change_policy_details'

    def is_allow_download_disabled_details(self):
        """
        Check if the union tag is ``allow_download_disabled_details``.

        :rtype: bool
        """
        return self._tag == 'allow_download_disabled_details'

    def is_allow_download_enabled_details(self):
        """
        Check if the union tag is ``allow_download_enabled_details``.

        :rtype: bool
        """
        return self._tag == 'allow_download_enabled_details'

    def is_app_permissions_changed_details(self):
        """
        Check if the union tag is ``app_permissions_changed_details``.

        :rtype: bool
        """
        return self._tag == 'app_permissions_changed_details'

    def is_camera_uploads_policy_changed_details(self):
        """
        Check if the union tag is ``camera_uploads_policy_changed_details``.

        :rtype: bool
        """
        return self._tag == 'camera_uploads_policy_changed_details'

    def is_capture_transcript_policy_changed_details(self):
        """
        Check if the union tag is ``capture_transcript_policy_changed_details``.

        :rtype: bool
        """
        return self._tag == 'capture_transcript_policy_changed_details'

    def is_classification_change_policy_details(self):
        """
        Check if the union tag is ``classification_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'classification_change_policy_details'

    def is_computer_backup_policy_changed_details(self):
        """
        Check if the union tag is ``computer_backup_policy_changed_details``.

        :rtype: bool
        """
        return self._tag == 'computer_backup_policy_changed_details'

    def is_content_administration_policy_changed_details(self):
        """
        Check if the union tag is ``content_administration_policy_changed_details``.

        :rtype: bool
        """
        return self._tag == 'content_administration_policy_changed_details'

    def is_data_placement_restriction_change_policy_details(self):
        """
        Check if the union tag is ``data_placement_restriction_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'data_placement_restriction_change_policy_details'

    def is_data_placement_restriction_satisfy_policy_details(self):
        """
        Check if the union tag is ``data_placement_restriction_satisfy_policy_details``.

        :rtype: bool
        """
        return self._tag == 'data_placement_restriction_satisfy_policy_details'

    def is_device_approvals_add_exception_details(self):
        """
        Check if the union tag is ``device_approvals_add_exception_details``.

        :rtype: bool
        """
        return self._tag == 'device_approvals_add_exception_details'

    def is_device_approvals_change_desktop_policy_details(self):
        """
        Check if the union tag is ``device_approvals_change_desktop_policy_details``.

        :rtype: bool
        """
        return self._tag == 'device_approvals_change_desktop_policy_details'

    def is_device_approvals_change_mobile_policy_details(self):
        """
        Check if the union tag is ``device_approvals_change_mobile_policy_details``.

        :rtype: bool
        """
        return self._tag == 'device_approvals_change_mobile_policy_details'

    def is_device_approvals_change_overage_action_details(self):
        """
        Check if the union tag is ``device_approvals_change_overage_action_details``.

        :rtype: bool
        """
        return self._tag == 'device_approvals_change_overage_action_details'

    def is_device_approvals_change_unlink_action_details(self):
        """
        Check if the union tag is ``device_approvals_change_unlink_action_details``.

        :rtype: bool
        """
        return self._tag == 'device_approvals_change_unlink_action_details'

    def is_device_approvals_remove_exception_details(self):
        """
        Check if the union tag is ``device_approvals_remove_exception_details``.

        :rtype: bool
        """
        return self._tag == 'device_approvals_remove_exception_details'

    def is_directory_restrictions_add_members_details(self):
        """
        Check if the union tag is ``directory_restrictions_add_members_details``.

        :rtype: bool
        """
        return self._tag == 'directory_restrictions_add_members_details'

    def is_directory_restrictions_remove_members_details(self):
        """
        Check if the union tag is ``directory_restrictions_remove_members_details``.

        :rtype: bool
        """
        return self._tag == 'directory_restrictions_remove_members_details'

    def is_email_ingest_policy_changed_details(self):
        """
        Check if the union tag is ``email_ingest_policy_changed_details``.

        :rtype: bool
        """
        return self._tag == 'email_ingest_policy_changed_details'

    def is_emm_add_exception_details(self):
        """
        Check if the union tag is ``emm_add_exception_details``.

        :rtype: bool
        """
        return self._tag == 'emm_add_exception_details'

    def is_emm_change_policy_details(self):
        """
        Check if the union tag is ``emm_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'emm_change_policy_details'

    def is_emm_remove_exception_details(self):
        """
        Check if the union tag is ``emm_remove_exception_details``.

        :rtype: bool
        """
        return self._tag == 'emm_remove_exception_details'

    def is_extended_version_history_change_policy_details(self):
        """
        Check if the union tag is ``extended_version_history_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'extended_version_history_change_policy_details'

    def is_external_drive_backup_policy_changed_details(self):
        """
        Check if the union tag is ``external_drive_backup_policy_changed_details``.

        :rtype: bool
        """
        return self._tag == 'external_drive_backup_policy_changed_details'

    def is_file_comments_change_policy_details(self):
        """
        Check if the union tag is ``file_comments_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'file_comments_change_policy_details'

    def is_file_locking_policy_changed_details(self):
        """
        Check if the union tag is ``file_locking_policy_changed_details``.

        :rtype: bool
        """
        return self._tag == 'file_locking_policy_changed_details'

    def is_file_requests_change_policy_details(self):
        """
        Check if the union tag is ``file_requests_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'file_requests_change_policy_details'

    def is_file_requests_emails_enabled_details(self):
        """
        Check if the union tag is ``file_requests_emails_enabled_details``.

        :rtype: bool
        """
        return self._tag == 'file_requests_emails_enabled_details'

    def is_file_requests_emails_restricted_to_team_only_details(self):
        """
        Check if the union tag is ``file_requests_emails_restricted_to_team_only_details``.

        :rtype: bool
        """
        return self._tag == 'file_requests_emails_restricted_to_team_only_details'

    def is_file_transfers_policy_changed_details(self):
        """
        Check if the union tag is ``file_transfers_policy_changed_details``.

        :rtype: bool
        """
        return self._tag == 'file_transfers_policy_changed_details'

    def is_google_sso_change_policy_details(self):
        """
        Check if the union tag is ``google_sso_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'google_sso_change_policy_details'

    def is_group_user_management_change_policy_details(self):
        """
        Check if the union tag is ``group_user_management_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'group_user_management_change_policy_details'

    def is_integration_policy_changed_details(self):
        """
        Check if the union tag is ``integration_policy_changed_details``.

        :rtype: bool
        """
        return self._tag == 'integration_policy_changed_details'

    def is_invite_acceptance_email_policy_changed_details(self):
        """
        Check if the union tag is ``invite_acceptance_email_policy_changed_details``.

        :rtype: bool
        """
        return self._tag == 'invite_acceptance_email_policy_changed_details'

    def is_member_requests_change_policy_details(self):
        """
        Check if the union tag is ``member_requests_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'member_requests_change_policy_details'

    def is_member_send_invite_policy_changed_details(self):
        """
        Check if the union tag is ``member_send_invite_policy_changed_details``.

        :rtype: bool
        """
        return self._tag == 'member_send_invite_policy_changed_details'

    def is_member_space_limits_add_exception_details(self):
        """
        Check if the union tag is ``member_space_limits_add_exception_details``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_add_exception_details'

    def is_member_space_limits_change_caps_type_policy_details(self):
        """
        Check if the union tag is ``member_space_limits_change_caps_type_policy_details``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_change_caps_type_policy_details'

    def is_member_space_limits_change_policy_details(self):
        """
        Check if the union tag is ``member_space_limits_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_change_policy_details'

    def is_member_space_limits_remove_exception_details(self):
        """
        Check if the union tag is ``member_space_limits_remove_exception_details``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_remove_exception_details'

    def is_member_suggestions_change_policy_details(self):
        """
        Check if the union tag is ``member_suggestions_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'member_suggestions_change_policy_details'

    def is_microsoft_office_addin_change_policy_details(self):
        """
        Check if the union tag is ``microsoft_office_addin_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'microsoft_office_addin_change_policy_details'

    def is_network_control_change_policy_details(self):
        """
        Check if the union tag is ``network_control_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'network_control_change_policy_details'

    def is_paper_change_deployment_policy_details(self):
        """
        Check if the union tag is ``paper_change_deployment_policy_details``.

        :rtype: bool
        """
        return self._tag == 'paper_change_deployment_policy_details'

    def is_paper_change_member_link_policy_details(self):
        """
        Check if the union tag is ``paper_change_member_link_policy_details``.

        :rtype: bool
        """
        return self._tag == 'paper_change_member_link_policy_details'

    def is_paper_change_member_policy_details(self):
        """
        Check if the union tag is ``paper_change_member_policy_details``.

        :rtype: bool
        """
        return self._tag == 'paper_change_member_policy_details'

    def is_paper_change_policy_details(self):
        """
        Check if the union tag is ``paper_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'paper_change_policy_details'

    def is_paper_default_folder_policy_changed_details(self):
        """
        Check if the union tag is ``paper_default_folder_policy_changed_details``.

        :rtype: bool
        """
        return self._tag == 'paper_default_folder_policy_changed_details'

    def is_paper_desktop_policy_changed_details(self):
        """
        Check if the union tag is ``paper_desktop_policy_changed_details``.

        :rtype: bool
        """
        return self._tag == 'paper_desktop_policy_changed_details'

    def is_paper_enabled_users_group_addition_details(self):
        """
        Check if the union tag is ``paper_enabled_users_group_addition_details``.

        :rtype: bool
        """
        return self._tag == 'paper_enabled_users_group_addition_details'

    def is_paper_enabled_users_group_removal_details(self):
        """
        Check if the union tag is ``paper_enabled_users_group_removal_details``.

        :rtype: bool
        """
        return self._tag == 'paper_enabled_users_group_removal_details'

    def is_password_strength_requirements_change_policy_details(self):
        """
        Check if the union tag is ``password_strength_requirements_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'password_strength_requirements_change_policy_details'

    def is_permanent_delete_change_policy_details(self):
        """
        Check if the union tag is ``permanent_delete_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'permanent_delete_change_policy_details'

    def is_reseller_support_change_policy_details(self):
        """
        Check if the union tag is ``reseller_support_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'reseller_support_change_policy_details'

    def is_rewind_policy_changed_details(self):
        """
        Check if the union tag is ``rewind_policy_changed_details``.

        :rtype: bool
        """
        return self._tag == 'rewind_policy_changed_details'

    def is_send_for_signature_policy_changed_details(self):
        """
        Check if the union tag is ``send_for_signature_policy_changed_details``.

        :rtype: bool
        """
        return self._tag == 'send_for_signature_policy_changed_details'

    def is_sharing_change_folder_join_policy_details(self):
        """
        Check if the union tag is ``sharing_change_folder_join_policy_details``.

        :rtype: bool
        """
        return self._tag == 'sharing_change_folder_join_policy_details'

    def is_sharing_change_link_allow_change_expiration_policy_details(self):
        """
        Check if the union tag is ``sharing_change_link_allow_change_expiration_policy_details``.

        :rtype: bool
        """
        return self._tag == 'sharing_change_link_allow_change_expiration_policy_details'

    def is_sharing_change_link_default_expiration_policy_details(self):
        """
        Check if the union tag is ``sharing_change_link_default_expiration_policy_details``.

        :rtype: bool
        """
        return self._tag == 'sharing_change_link_default_expiration_policy_details'

    def is_sharing_change_link_enforce_password_policy_details(self):
        """
        Check if the union tag is ``sharing_change_link_enforce_password_policy_details``.

        :rtype: bool
        """
        return self._tag == 'sharing_change_link_enforce_password_policy_details'

    def is_sharing_change_link_policy_details(self):
        """
        Check if the union tag is ``sharing_change_link_policy_details``.

        :rtype: bool
        """
        return self._tag == 'sharing_change_link_policy_details'

    def is_sharing_change_member_policy_details(self):
        """
        Check if the union tag is ``sharing_change_member_policy_details``.

        :rtype: bool
        """
        return self._tag == 'sharing_change_member_policy_details'

    def is_showcase_change_download_policy_details(self):
        """
        Check if the union tag is ``showcase_change_download_policy_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_change_download_policy_details'

    def is_showcase_change_enabled_policy_details(self):
        """
        Check if the union tag is ``showcase_change_enabled_policy_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_change_enabled_policy_details'

    def is_showcase_change_external_sharing_policy_details(self):
        """
        Check if the union tag is ``showcase_change_external_sharing_policy_details``.

        :rtype: bool
        """
        return self._tag == 'showcase_change_external_sharing_policy_details'

    def is_smarter_smart_sync_policy_changed_details(self):
        """
        Check if the union tag is ``smarter_smart_sync_policy_changed_details``.

        :rtype: bool
        """
        return self._tag == 'smarter_smart_sync_policy_changed_details'

    def is_smart_sync_change_policy_details(self):
        """
        Check if the union tag is ``smart_sync_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'smart_sync_change_policy_details'

    def is_smart_sync_not_opt_out_details(self):
        """
        Check if the union tag is ``smart_sync_not_opt_out_details``.

        :rtype: bool
        """
        return self._tag == 'smart_sync_not_opt_out_details'

    def is_smart_sync_opt_out_details(self):
        """
        Check if the union tag is ``smart_sync_opt_out_details``.

        :rtype: bool
        """
        return self._tag == 'smart_sync_opt_out_details'

    def is_sso_change_policy_details(self):
        """
        Check if the union tag is ``sso_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'sso_change_policy_details'

    def is_team_branding_policy_changed_details(self):
        """
        Check if the union tag is ``team_branding_policy_changed_details``.

        :rtype: bool
        """
        return self._tag == 'team_branding_policy_changed_details'

    def is_team_extensions_policy_changed_details(self):
        """
        Check if the union tag is ``team_extensions_policy_changed_details``.

        :rtype: bool
        """
        return self._tag == 'team_extensions_policy_changed_details'

    def is_team_selective_sync_policy_changed_details(self):
        """
        Check if the union tag is ``team_selective_sync_policy_changed_details``.

        :rtype: bool
        """
        return self._tag == 'team_selective_sync_policy_changed_details'

    def is_team_sharing_whitelist_subjects_changed_details(self):
        """
        Check if the union tag is ``team_sharing_whitelist_subjects_changed_details``.

        :rtype: bool
        """
        return self._tag == 'team_sharing_whitelist_subjects_changed_details'

    def is_tfa_add_exception_details(self):
        """
        Check if the union tag is ``tfa_add_exception_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_add_exception_details'

    def is_tfa_change_policy_details(self):
        """
        Check if the union tag is ``tfa_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_change_policy_details'

    def is_tfa_remove_exception_details(self):
        """
        Check if the union tag is ``tfa_remove_exception_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_remove_exception_details'

    def is_two_account_change_policy_details(self):
        """
        Check if the union tag is ``two_account_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'two_account_change_policy_details'

    def is_viewer_info_policy_changed_details(self):
        """
        Check if the union tag is ``viewer_info_policy_changed_details``.

        :rtype: bool
        """
        return self._tag == 'viewer_info_policy_changed_details'

    def is_watermarking_policy_changed_details(self):
        """
        Check if the union tag is ``watermarking_policy_changed_details``.

        :rtype: bool
        """
        return self._tag == 'watermarking_policy_changed_details'

    def is_web_sessions_change_active_session_limit_details(self):
        """
        Check if the union tag is ``web_sessions_change_active_session_limit_details``.

        :rtype: bool
        """
        return self._tag == 'web_sessions_change_active_session_limit_details'

    def is_web_sessions_change_fixed_length_policy_details(self):
        """
        Check if the union tag is ``web_sessions_change_fixed_length_policy_details``.

        :rtype: bool
        """
        return self._tag == 'web_sessions_change_fixed_length_policy_details'

    def is_web_sessions_change_idle_length_policy_details(self):
        """
        Check if the union tag is ``web_sessions_change_idle_length_policy_details``.

        :rtype: bool
        """
        return self._tag == 'web_sessions_change_idle_length_policy_details'

    def is_data_residency_migration_request_successful_details(self):
        """
        Check if the union tag is ``data_residency_migration_request_successful_details``.

        :rtype: bool
        """
        return self._tag == 'data_residency_migration_request_successful_details'

    def is_data_residency_migration_request_unsuccessful_details(self):
        """
        Check if the union tag is ``data_residency_migration_request_unsuccessful_details``.

        :rtype: bool
        """
        return self._tag == 'data_residency_migration_request_unsuccessful_details'

    def is_team_merge_from_details(self):
        """
        Check if the union tag is ``team_merge_from_details``.

        :rtype: bool
        """
        return self._tag == 'team_merge_from_details'

    def is_team_merge_to_details(self):
        """
        Check if the union tag is ``team_merge_to_details``.

        :rtype: bool
        """
        return self._tag == 'team_merge_to_details'

    def is_team_profile_add_background_details(self):
        """
        Check if the union tag is ``team_profile_add_background_details``.

        :rtype: bool
        """
        return self._tag == 'team_profile_add_background_details'

    def is_team_profile_add_logo_details(self):
        """
        Check if the union tag is ``team_profile_add_logo_details``.

        :rtype: bool
        """
        return self._tag == 'team_profile_add_logo_details'

    def is_team_profile_change_background_details(self):
        """
        Check if the union tag is ``team_profile_change_background_details``.

        :rtype: bool
        """
        return self._tag == 'team_profile_change_background_details'

    def is_team_profile_change_default_language_details(self):
        """
        Check if the union tag is ``team_profile_change_default_language_details``.

        :rtype: bool
        """
        return self._tag == 'team_profile_change_default_language_details'

    def is_team_profile_change_logo_details(self):
        """
        Check if the union tag is ``team_profile_change_logo_details``.

        :rtype: bool
        """
        return self._tag == 'team_profile_change_logo_details'

    def is_team_profile_change_name_details(self):
        """
        Check if the union tag is ``team_profile_change_name_details``.

        :rtype: bool
        """
        return self._tag == 'team_profile_change_name_details'

    def is_team_profile_remove_background_details(self):
        """
        Check if the union tag is ``team_profile_remove_background_details``.

        :rtype: bool
        """
        return self._tag == 'team_profile_remove_background_details'

    def is_team_profile_remove_logo_details(self):
        """
        Check if the union tag is ``team_profile_remove_logo_details``.

        :rtype: bool
        """
        return self._tag == 'team_profile_remove_logo_details'

    def is_tfa_add_backup_phone_details(self):
        """
        Check if the union tag is ``tfa_add_backup_phone_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_add_backup_phone_details'

    def is_tfa_add_security_key_details(self):
        """
        Check if the union tag is ``tfa_add_security_key_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_add_security_key_details'

    def is_tfa_change_backup_phone_details(self):
        """
        Check if the union tag is ``tfa_change_backup_phone_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_change_backup_phone_details'

    def is_tfa_change_status_details(self):
        """
        Check if the union tag is ``tfa_change_status_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_change_status_details'

    def is_tfa_remove_backup_phone_details(self):
        """
        Check if the union tag is ``tfa_remove_backup_phone_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_remove_backup_phone_details'

    def is_tfa_remove_security_key_details(self):
        """
        Check if the union tag is ``tfa_remove_security_key_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_remove_security_key_details'

    def is_tfa_reset_details(self):
        """
        Check if the union tag is ``tfa_reset_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_reset_details'

    def is_changed_enterprise_admin_role_details(self):
        """
        Check if the union tag is ``changed_enterprise_admin_role_details``.

        :rtype: bool
        """
        return self._tag == 'changed_enterprise_admin_role_details'

    def is_changed_enterprise_connected_team_status_details(self):
        """
        Check if the union tag is ``changed_enterprise_connected_team_status_details``.

        :rtype: bool
        """
        return self._tag == 'changed_enterprise_connected_team_status_details'

    def is_ended_enterprise_admin_session_details(self):
        """
        Check if the union tag is ``ended_enterprise_admin_session_details``.

        :rtype: bool
        """
        return self._tag == 'ended_enterprise_admin_session_details'

    def is_ended_enterprise_admin_session_deprecated_details(self):
        """
        Check if the union tag is ``ended_enterprise_admin_session_deprecated_details``.

        :rtype: bool
        """
        return self._tag == 'ended_enterprise_admin_session_deprecated_details'

    def is_enterprise_settings_locking_details(self):
        """
        Check if the union tag is ``enterprise_settings_locking_details``.

        :rtype: bool
        """
        return self._tag == 'enterprise_settings_locking_details'

    def is_guest_admin_change_status_details(self):
        """
        Check if the union tag is ``guest_admin_change_status_details``.

        :rtype: bool
        """
        return self._tag == 'guest_admin_change_status_details'

    def is_started_enterprise_admin_session_details(self):
        """
        Check if the union tag is ``started_enterprise_admin_session_details``.

        :rtype: bool
        """
        return self._tag == 'started_enterprise_admin_session_details'

    def is_team_merge_request_accepted_details(self):
        """
        Check if the union tag is ``team_merge_request_accepted_details``.

        :rtype: bool
        """
        return self._tag == 'team_merge_request_accepted_details'

    def is_team_merge_request_accepted_shown_to_primary_team_details(self):
        """
        Check if the union tag is ``team_merge_request_accepted_shown_to_primary_team_details``.

        :rtype: bool
        """
        return self._tag == 'team_merge_request_accepted_shown_to_primary_team_details'

    def is_team_merge_request_accepted_shown_to_secondary_team_details(self):
        """
        Check if the union tag is ``team_merge_request_accepted_shown_to_secondary_team_details``.

        :rtype: bool
        """
        return self._tag == 'team_merge_request_accepted_shown_to_secondary_team_details'

    def is_team_merge_request_auto_canceled_details(self):
        """
        Check if the union tag is ``team_merge_request_auto_canceled_details``.

        :rtype: bool
        """
        return self._tag == 'team_merge_request_auto_canceled_details'

    def is_team_merge_request_canceled_details(self):
        """
        Check if the union tag is ``team_merge_request_canceled_details``.

        :rtype: bool
        """
        return self._tag == 'team_merge_request_canceled_details'

    def is_team_merge_request_canceled_shown_to_primary_team_details(self):
        """
        Check if the union tag is ``team_merge_request_canceled_shown_to_primary_team_details``.

        :rtype: bool
        """
        return self._tag == 'team_merge_request_canceled_shown_to_primary_team_details'

    def is_team_merge_request_canceled_shown_to_secondary_team_details(self):
        """
        Check if the union tag is ``team_merge_request_canceled_shown_to_secondary_team_details``.

        :rtype: bool
        """
        return self._tag == 'team_merge_request_canceled_shown_to_secondary_team_details'

    def is_team_merge_request_expired_details(self):
        """
        Check if the union tag is ``team_merge_request_expired_details``.

        :rtype: bool
        """
        return self._tag == 'team_merge_request_expired_details'

    def is_team_merge_request_expired_shown_to_primary_team_details(self):
        """
        Check if the union tag is ``team_merge_request_expired_shown_to_primary_team_details``.

        :rtype: bool
        """
        return self._tag == 'team_merge_request_expired_shown_to_primary_team_details'

    def is_team_merge_request_expired_shown_to_secondary_team_details(self):
        """
        Check if the union tag is ``team_merge_request_expired_shown_to_secondary_team_details``.

        :rtype: bool
        """
        return self._tag == 'team_merge_request_expired_shown_to_secondary_team_details'

    def is_team_merge_request_rejected_shown_to_primary_team_details(self):
        """
        Check if the union tag is ``team_merge_request_rejected_shown_to_primary_team_details``.

        :rtype: bool
        """
        return self._tag == 'team_merge_request_rejected_shown_to_primary_team_details'

    def is_team_merge_request_rejected_shown_to_secondary_team_details(self):
        """
        Check if the union tag is ``team_merge_request_rejected_shown_to_secondary_team_details``.

        :rtype: bool
        """
        return self._tag == 'team_merge_request_rejected_shown_to_secondary_team_details'

    def is_team_merge_request_reminder_details(self):
        """
        Check if the union tag is ``team_merge_request_reminder_details``.

        :rtype: bool
        """
        return self._tag == 'team_merge_request_reminder_details'

    def is_team_merge_request_reminder_shown_to_primary_team_details(self):
        """
        Check if the union tag is ``team_merge_request_reminder_shown_to_primary_team_details``.

        :rtype: bool
        """
        return self._tag == 'team_merge_request_reminder_shown_to_primary_team_details'

    def is_team_merge_request_reminder_shown_to_secondary_team_details(self):
        """
        Check if the union tag is ``team_merge_request_reminder_shown_to_secondary_team_details``.

        :rtype: bool
        """
        return self._tag == 'team_merge_request_reminder_shown_to_secondary_team_details'

    def is_team_merge_request_revoked_details(self):
        """
        Check if the union tag is ``team_merge_request_revoked_details``.

        :rtype: bool
        """
        return self._tag == 'team_merge_request_revoked_details'

    def is_team_merge_request_sent_shown_to_primary_team_details(self):
        """
        Check if the union tag is ``team_merge_request_sent_shown_to_primary_team_details``.

        :rtype: bool
        """
        return self._tag == 'team_merge_request_sent_shown_to_primary_team_details'

    def is_team_merge_request_sent_shown_to_secondary_team_details(self):
        """
        Check if the union tag is ``team_merge_request_sent_shown_to_secondary_team_details``.

        :rtype: bool
        """
        return self._tag == 'team_merge_request_sent_shown_to_secondary_team_details'

    def is_missing_details(self):
        """
        Check if the union tag is ``missing_details``.

        :rtype: bool
        """
        return self._tag == 'missing_details'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_admin_alerting_alert_state_changed_details(self):
        """
        Only call this if :meth:`is_admin_alerting_alert_state_changed_details` is true.

        :rtype: AdminAlertingAlertStateChangedDetails
        """
        if not self.is_admin_alerting_alert_state_changed_details():
            raise AttributeError("tag 'admin_alerting_alert_state_changed_details' not set")
        return self._value

    def get_admin_alerting_changed_alert_config_details(self):
        """
        Only call this if :meth:`is_admin_alerting_changed_alert_config_details` is true.

        :rtype: AdminAlertingChangedAlertConfigDetails
        """
        if not self.is_admin_alerting_changed_alert_config_details():
            raise AttributeError("tag 'admin_alerting_changed_alert_config_details' not set")
        return self._value

    def get_admin_alerting_triggered_alert_details(self):
        """
        Only call this if :meth:`is_admin_alerting_triggered_alert_details` is true.

        :rtype: AdminAlertingTriggeredAlertDetails
        """
        if not self.is_admin_alerting_triggered_alert_details():
            raise AttributeError("tag 'admin_alerting_triggered_alert_details' not set")
        return self._value

    def get_app_blocked_by_permissions_details(self):
        """
        Only call this if :meth:`is_app_blocked_by_permissions_details` is true.

        :rtype: AppBlockedByPermissionsDetails
        """
        if not self.is_app_blocked_by_permissions_details():
            raise AttributeError("tag 'app_blocked_by_permissions_details' not set")
        return self._value

    def get_app_link_team_details(self):
        """
        Only call this if :meth:`is_app_link_team_details` is true.

        :rtype: AppLinkTeamDetails
        """
        if not self.is_app_link_team_details():
            raise AttributeError("tag 'app_link_team_details' not set")
        return self._value

    def get_app_link_user_details(self):
        """
        Only call this if :meth:`is_app_link_user_details` is true.

        :rtype: AppLinkUserDetails
        """
        if not self.is_app_link_user_details():
            raise AttributeError("tag 'app_link_user_details' not set")
        return self._value

    def get_app_unlink_team_details(self):
        """
        Only call this if :meth:`is_app_unlink_team_details` is true.

        :rtype: AppUnlinkTeamDetails
        """
        if not self.is_app_unlink_team_details():
            raise AttributeError("tag 'app_unlink_team_details' not set")
        return self._value

    def get_app_unlink_user_details(self):
        """
        Only call this if :meth:`is_app_unlink_user_details` is true.

        :rtype: AppUnlinkUserDetails
        """
        if not self.is_app_unlink_user_details():
            raise AttributeError("tag 'app_unlink_user_details' not set")
        return self._value

    def get_integration_connected_details(self):
        """
        Only call this if :meth:`is_integration_connected_details` is true.

        :rtype: IntegrationConnectedDetails
        """
        if not self.is_integration_connected_details():
            raise AttributeError("tag 'integration_connected_details' not set")
        return self._value

    def get_integration_disconnected_details(self):
        """
        Only call this if :meth:`is_integration_disconnected_details` is true.

        :rtype: IntegrationDisconnectedDetails
        """
        if not self.is_integration_disconnected_details():
            raise AttributeError("tag 'integration_disconnected_details' not set")
        return self._value

    def get_file_add_comment_details(self):
        """
        Only call this if :meth:`is_file_add_comment_details` is true.

        :rtype: FileAddCommentDetails
        """
        if not self.is_file_add_comment_details():
            raise AttributeError("tag 'file_add_comment_details' not set")
        return self._value

    def get_file_change_comment_subscription_details(self):
        """
        Only call this if :meth:`is_file_change_comment_subscription_details` is true.

        :rtype: FileChangeCommentSubscriptionDetails
        """
        if not self.is_file_change_comment_subscription_details():
            raise AttributeError("tag 'file_change_comment_subscription_details' not set")
        return self._value

    def get_file_delete_comment_details(self):
        """
        Only call this if :meth:`is_file_delete_comment_details` is true.

        :rtype: FileDeleteCommentDetails
        """
        if not self.is_file_delete_comment_details():
            raise AttributeError("tag 'file_delete_comment_details' not set")
        return self._value

    def get_file_edit_comment_details(self):
        """
        Only call this if :meth:`is_file_edit_comment_details` is true.

        :rtype: FileEditCommentDetails
        """
        if not self.is_file_edit_comment_details():
            raise AttributeError("tag 'file_edit_comment_details' not set")
        return self._value

    def get_file_like_comment_details(self):
        """
        Only call this if :meth:`is_file_like_comment_details` is true.

        :rtype: FileLikeCommentDetails
        """
        if not self.is_file_like_comment_details():
            raise AttributeError("tag 'file_like_comment_details' not set")
        return self._value

    def get_file_resolve_comment_details(self):
        """
        Only call this if :meth:`is_file_resolve_comment_details` is true.

        :rtype: FileResolveCommentDetails
        """
        if not self.is_file_resolve_comment_details():
            raise AttributeError("tag 'file_resolve_comment_details' not set")
        return self._value

    def get_file_unlike_comment_details(self):
        """
        Only call this if :meth:`is_file_unlike_comment_details` is true.

        :rtype: FileUnlikeCommentDetails
        """
        if not self.is_file_unlike_comment_details():
            raise AttributeError("tag 'file_unlike_comment_details' not set")
        return self._value

    def get_file_unresolve_comment_details(self):
        """
        Only call this if :meth:`is_file_unresolve_comment_details` is true.

        :rtype: FileUnresolveCommentDetails
        """
        if not self.is_file_unresolve_comment_details():
            raise AttributeError("tag 'file_unresolve_comment_details' not set")
        return self._value

    def get_governance_policy_add_folders_details(self):
        """
        Only call this if :meth:`is_governance_policy_add_folders_details` is true.

        :rtype: GovernancePolicyAddFoldersDetails
        """
        if not self.is_governance_policy_add_folders_details():
            raise AttributeError("tag 'governance_policy_add_folders_details' not set")
        return self._value

    def get_governance_policy_add_folder_failed_details(self):
        """
        Only call this if :meth:`is_governance_policy_add_folder_failed_details` is true.

        :rtype: GovernancePolicyAddFolderFailedDetails
        """
        if not self.is_governance_policy_add_folder_failed_details():
            raise AttributeError("tag 'governance_policy_add_folder_failed_details' not set")
        return self._value

    def get_governance_policy_content_disposed_details(self):
        """
        Only call this if :meth:`is_governance_policy_content_disposed_details` is true.

        :rtype: GovernancePolicyContentDisposedDetails
        """
        if not self.is_governance_policy_content_disposed_details():
            raise AttributeError("tag 'governance_policy_content_disposed_details' not set")
        return self._value

    def get_governance_policy_create_details(self):
        """
        Only call this if :meth:`is_governance_policy_create_details` is true.

        :rtype: GovernancePolicyCreateDetails
        """
        if not self.is_governance_policy_create_details():
            raise AttributeError("tag 'governance_policy_create_details' not set")
        return self._value

    def get_governance_policy_delete_details(self):
        """
        Only call this if :meth:`is_governance_policy_delete_details` is true.

        :rtype: GovernancePolicyDeleteDetails
        """
        if not self.is_governance_policy_delete_details():
            raise AttributeError("tag 'governance_policy_delete_details' not set")
        return self._value

    def get_governance_policy_edit_details_details(self):
        """
        Only call this if :meth:`is_governance_policy_edit_details_details` is true.

        :rtype: GovernancePolicyEditDetailsDetails
        """
        if not self.is_governance_policy_edit_details_details():
            raise AttributeError("tag 'governance_policy_edit_details_details' not set")
        return self._value

    def get_governance_policy_edit_duration_details(self):
        """
        Only call this if :meth:`is_governance_policy_edit_duration_details` is true.

        :rtype: GovernancePolicyEditDurationDetails
        """
        if not self.is_governance_policy_edit_duration_details():
            raise AttributeError("tag 'governance_policy_edit_duration_details' not set")
        return self._value

    def get_governance_policy_export_created_details(self):
        """
        Only call this if :meth:`is_governance_policy_export_created_details` is true.

        :rtype: GovernancePolicyExportCreatedDetails
        """
        if not self.is_governance_policy_export_created_details():
            raise AttributeError("tag 'governance_policy_export_created_details' not set")
        return self._value

    def get_governance_policy_export_removed_details(self):
        """
        Only call this if :meth:`is_governance_policy_export_removed_details` is true.

        :rtype: GovernancePolicyExportRemovedDetails
        """
        if not self.is_governance_policy_export_removed_details():
            raise AttributeError("tag 'governance_policy_export_removed_details' not set")
        return self._value

    def get_governance_policy_remove_folders_details(self):
        """
        Only call this if :meth:`is_governance_policy_remove_folders_details` is true.

        :rtype: GovernancePolicyRemoveFoldersDetails
        """
        if not self.is_governance_policy_remove_folders_details():
            raise AttributeError("tag 'governance_policy_remove_folders_details' not set")
        return self._value

    def get_governance_policy_report_created_details(self):
        """
        Only call this if :meth:`is_governance_policy_report_created_details` is true.

        :rtype: GovernancePolicyReportCreatedDetails
        """
        if not self.is_governance_policy_report_created_details():
            raise AttributeError("tag 'governance_policy_report_created_details' not set")
        return self._value

    def get_governance_policy_zip_part_downloaded_details(self):
        """
        Only call this if :meth:`is_governance_policy_zip_part_downloaded_details` is true.

        :rtype: GovernancePolicyZipPartDownloadedDetails
        """
        if not self.is_governance_policy_zip_part_downloaded_details():
            raise AttributeError("tag 'governance_policy_zip_part_downloaded_details' not set")
        return self._value

    def get_legal_holds_activate_a_hold_details(self):
        """
        Only call this if :meth:`is_legal_holds_activate_a_hold_details` is true.

        :rtype: LegalHoldsActivateAHoldDetails
        """
        if not self.is_legal_holds_activate_a_hold_details():
            raise AttributeError("tag 'legal_holds_activate_a_hold_details' not set")
        return self._value

    def get_legal_holds_add_members_details(self):
        """
        Only call this if :meth:`is_legal_holds_add_members_details` is true.

        :rtype: LegalHoldsAddMembersDetails
        """
        if not self.is_legal_holds_add_members_details():
            raise AttributeError("tag 'legal_holds_add_members_details' not set")
        return self._value

    def get_legal_holds_change_hold_details_details(self):
        """
        Only call this if :meth:`is_legal_holds_change_hold_details_details` is true.

        :rtype: LegalHoldsChangeHoldDetailsDetails
        """
        if not self.is_legal_holds_change_hold_details_details():
            raise AttributeError("tag 'legal_holds_change_hold_details_details' not set")
        return self._value

    def get_legal_holds_change_hold_name_details(self):
        """
        Only call this if :meth:`is_legal_holds_change_hold_name_details` is true.

        :rtype: LegalHoldsChangeHoldNameDetails
        """
        if not self.is_legal_holds_change_hold_name_details():
            raise AttributeError("tag 'legal_holds_change_hold_name_details' not set")
        return self._value

    def get_legal_holds_export_a_hold_details(self):
        """
        Only call this if :meth:`is_legal_holds_export_a_hold_details` is true.

        :rtype: LegalHoldsExportAHoldDetails
        """
        if not self.is_legal_holds_export_a_hold_details():
            raise AttributeError("tag 'legal_holds_export_a_hold_details' not set")
        return self._value

    def get_legal_holds_export_cancelled_details(self):
        """
        Only call this if :meth:`is_legal_holds_export_cancelled_details` is true.

        :rtype: LegalHoldsExportCancelledDetails
        """
        if not self.is_legal_holds_export_cancelled_details():
            raise AttributeError("tag 'legal_holds_export_cancelled_details' not set")
        return self._value

    def get_legal_holds_export_downloaded_details(self):
        """
        Only call this if :meth:`is_legal_holds_export_downloaded_details` is true.

        :rtype: LegalHoldsExportDownloadedDetails
        """
        if not self.is_legal_holds_export_downloaded_details():
            raise AttributeError("tag 'legal_holds_export_downloaded_details' not set")
        return self._value

    def get_legal_holds_export_removed_details(self):
        """
        Only call this if :meth:`is_legal_holds_export_removed_details` is true.

        :rtype: LegalHoldsExportRemovedDetails
        """
        if not self.is_legal_holds_export_removed_details():
            raise AttributeError("tag 'legal_holds_export_removed_details' not set")
        return self._value

    def get_legal_holds_release_a_hold_details(self):
        """
        Only call this if :meth:`is_legal_holds_release_a_hold_details` is true.

        :rtype: LegalHoldsReleaseAHoldDetails
        """
        if not self.is_legal_holds_release_a_hold_details():
            raise AttributeError("tag 'legal_holds_release_a_hold_details' not set")
        return self._value

    def get_legal_holds_remove_members_details(self):
        """
        Only call this if :meth:`is_legal_holds_remove_members_details` is true.

        :rtype: LegalHoldsRemoveMembersDetails
        """
        if not self.is_legal_holds_remove_members_details():
            raise AttributeError("tag 'legal_holds_remove_members_details' not set")
        return self._value

    def get_legal_holds_report_a_hold_details(self):
        """
        Only call this if :meth:`is_legal_holds_report_a_hold_details` is true.

        :rtype: LegalHoldsReportAHoldDetails
        """
        if not self.is_legal_holds_report_a_hold_details():
            raise AttributeError("tag 'legal_holds_report_a_hold_details' not set")
        return self._value

    def get_device_change_ip_desktop_details(self):
        """
        Only call this if :meth:`is_device_change_ip_desktop_details` is true.

        :rtype: DeviceChangeIpDesktopDetails
        """
        if not self.is_device_change_ip_desktop_details():
            raise AttributeError("tag 'device_change_ip_desktop_details' not set")
        return self._value

    def get_device_change_ip_mobile_details(self):
        """
        Only call this if :meth:`is_device_change_ip_mobile_details` is true.

        :rtype: DeviceChangeIpMobileDetails
        """
        if not self.is_device_change_ip_mobile_details():
            raise AttributeError("tag 'device_change_ip_mobile_details' not set")
        return self._value

    def get_device_change_ip_web_details(self):
        """
        Only call this if :meth:`is_device_change_ip_web_details` is true.

        :rtype: DeviceChangeIpWebDetails
        """
        if not self.is_device_change_ip_web_details():
            raise AttributeError("tag 'device_change_ip_web_details' not set")
        return self._value

    def get_device_delete_on_unlink_fail_details(self):
        """
        Only call this if :meth:`is_device_delete_on_unlink_fail_details` is true.

        :rtype: DeviceDeleteOnUnlinkFailDetails
        """
        if not self.is_device_delete_on_unlink_fail_details():
            raise AttributeError("tag 'device_delete_on_unlink_fail_details' not set")
        return self._value

    def get_device_delete_on_unlink_success_details(self):
        """
        Only call this if :meth:`is_device_delete_on_unlink_success_details` is true.

        :rtype: DeviceDeleteOnUnlinkSuccessDetails
        """
        if not self.is_device_delete_on_unlink_success_details():
            raise AttributeError("tag 'device_delete_on_unlink_success_details' not set")
        return self._value

    def get_device_link_fail_details(self):
        """
        Only call this if :meth:`is_device_link_fail_details` is true.

        :rtype: DeviceLinkFailDetails
        """
        if not self.is_device_link_fail_details():
            raise AttributeError("tag 'device_link_fail_details' not set")
        return self._value

    def get_device_link_success_details(self):
        """
        Only call this if :meth:`is_device_link_success_details` is true.

        :rtype: DeviceLinkSuccessDetails
        """
        if not self.is_device_link_success_details():
            raise AttributeError("tag 'device_link_success_details' not set")
        return self._value

    def get_device_management_disabled_details(self):
        """
        Only call this if :meth:`is_device_management_disabled_details` is true.

        :rtype: DeviceManagementDisabledDetails
        """
        if not self.is_device_management_disabled_details():
            raise AttributeError("tag 'device_management_disabled_details' not set")
        return self._value

    def get_device_management_enabled_details(self):
        """
        Only call this if :meth:`is_device_management_enabled_details` is true.

        :rtype: DeviceManagementEnabledDetails
        """
        if not self.is_device_management_enabled_details():
            raise AttributeError("tag 'device_management_enabled_details' not set")
        return self._value

    def get_device_sync_backup_status_changed_details(self):
        """
        Only call this if :meth:`is_device_sync_backup_status_changed_details` is true.

        :rtype: DeviceSyncBackupStatusChangedDetails
        """
        if not self.is_device_sync_backup_status_changed_details():
            raise AttributeError("tag 'device_sync_backup_status_changed_details' not set")
        return self._value

    def get_device_unlink_details(self):
        """
        Only call this if :meth:`is_device_unlink_details` is true.

        :rtype: DeviceUnlinkDetails
        """
        if not self.is_device_unlink_details():
            raise AttributeError("tag 'device_unlink_details' not set")
        return self._value

    def get_dropbox_passwords_exported_details(self):
        """
        Only call this if :meth:`is_dropbox_passwords_exported_details` is true.

        :rtype: DropboxPasswordsExportedDetails
        """
        if not self.is_dropbox_passwords_exported_details():
            raise AttributeError("tag 'dropbox_passwords_exported_details' not set")
        return self._value

    def get_dropbox_passwords_new_device_enrolled_details(self):
        """
        Only call this if :meth:`is_dropbox_passwords_new_device_enrolled_details` is true.

        :rtype: DropboxPasswordsNewDeviceEnrolledDetails
        """
        if not self.is_dropbox_passwords_new_device_enrolled_details():
            raise AttributeError("tag 'dropbox_passwords_new_device_enrolled_details' not set")
        return self._value

    def get_emm_refresh_auth_token_details(self):
        """
        Only call this if :meth:`is_emm_refresh_auth_token_details` is true.

        :rtype: EmmRefreshAuthTokenDetails
        """
        if not self.is_emm_refresh_auth_token_details():
            raise AttributeError("tag 'emm_refresh_auth_token_details' not set")
        return self._value

    def get_account_capture_change_availability_details(self):
        """
        Only call this if :meth:`is_account_capture_change_availability_details` is true.

        :rtype: AccountCaptureChangeAvailabilityDetails
        """
        if not self.is_account_capture_change_availability_details():
            raise AttributeError("tag 'account_capture_change_availability_details' not set")
        return self._value

    def get_account_capture_migrate_account_details(self):
        """
        Only call this if :meth:`is_account_capture_migrate_account_details` is true.

        :rtype: AccountCaptureMigrateAccountDetails
        """
        if not self.is_account_capture_migrate_account_details():
            raise AttributeError("tag 'account_capture_migrate_account_details' not set")
        return self._value

    def get_account_capture_notification_emails_sent_details(self):
        """
        Only call this if :meth:`is_account_capture_notification_emails_sent_details` is true.

        :rtype: AccountCaptureNotificationEmailsSentDetails
        """
        if not self.is_account_capture_notification_emails_sent_details():
            raise AttributeError("tag 'account_capture_notification_emails_sent_details' not set")
        return self._value

    def get_account_capture_relinquish_account_details(self):
        """
        Only call this if :meth:`is_account_capture_relinquish_account_details` is true.

        :rtype: AccountCaptureRelinquishAccountDetails
        """
        if not self.is_account_capture_relinquish_account_details():
            raise AttributeError("tag 'account_capture_relinquish_account_details' not set")
        return self._value

    def get_disabled_domain_invites_details(self):
        """
        Only call this if :meth:`is_disabled_domain_invites_details` is true.

        :rtype: DisabledDomainInvitesDetails
        """
        if not self.is_disabled_domain_invites_details():
            raise AttributeError("tag 'disabled_domain_invites_details' not set")
        return self._value

    def get_domain_invites_approve_request_to_join_team_details(self):
        """
        Only call this if :meth:`is_domain_invites_approve_request_to_join_team_details` is true.

        :rtype: DomainInvitesApproveRequestToJoinTeamDetails
        """
        if not self.is_domain_invites_approve_request_to_join_team_details():
            raise AttributeError("tag 'domain_invites_approve_request_to_join_team_details' not set")
        return self._value

    def get_domain_invites_decline_request_to_join_team_details(self):
        """
        Only call this if :meth:`is_domain_invites_decline_request_to_join_team_details` is true.

        :rtype: DomainInvitesDeclineRequestToJoinTeamDetails
        """
        if not self.is_domain_invites_decline_request_to_join_team_details():
            raise AttributeError("tag 'domain_invites_decline_request_to_join_team_details' not set")
        return self._value

    def get_domain_invites_email_existing_users_details(self):
        """
        Only call this if :meth:`is_domain_invites_email_existing_users_details` is true.

        :rtype: DomainInvitesEmailExistingUsersDetails
        """
        if not self.is_domain_invites_email_existing_users_details():
            raise AttributeError("tag 'domain_invites_email_existing_users_details' not set")
        return self._value

    def get_domain_invites_request_to_join_team_details(self):
        """
        Only call this if :meth:`is_domain_invites_request_to_join_team_details` is true.

        :rtype: DomainInvitesRequestToJoinTeamDetails
        """
        if not self.is_domain_invites_request_to_join_team_details():
            raise AttributeError("tag 'domain_invites_request_to_join_team_details' not set")
        return self._value

    def get_domain_invites_set_invite_new_user_pref_to_no_details(self):
        """
        Only call this if :meth:`is_domain_invites_set_invite_new_user_pref_to_no_details` is true.

        :rtype: DomainInvitesSetInviteNewUserPrefToNoDetails
        """
        if not self.is_domain_invites_set_invite_new_user_pref_to_no_details():
            raise AttributeError("tag 'domain_invites_set_invite_new_user_pref_to_no_details' not set")
        return self._value

    def get_domain_invites_set_invite_new_user_pref_to_yes_details(self):
        """
        Only call this if :meth:`is_domain_invites_set_invite_new_user_pref_to_yes_details` is true.

        :rtype: DomainInvitesSetInviteNewUserPrefToYesDetails
        """
        if not self.is_domain_invites_set_invite_new_user_pref_to_yes_details():
            raise AttributeError("tag 'domain_invites_set_invite_new_user_pref_to_yes_details' not set")
        return self._value

    def get_domain_verification_add_domain_fail_details(self):
        """
        Only call this if :meth:`is_domain_verification_add_domain_fail_details` is true.

        :rtype: DomainVerificationAddDomainFailDetails
        """
        if not self.is_domain_verification_add_domain_fail_details():
            raise AttributeError("tag 'domain_verification_add_domain_fail_details' not set")
        return self._value

    def get_domain_verification_add_domain_success_details(self):
        """
        Only call this if :meth:`is_domain_verification_add_domain_success_details` is true.

        :rtype: DomainVerificationAddDomainSuccessDetails
        """
        if not self.is_domain_verification_add_domain_success_details():
            raise AttributeError("tag 'domain_verification_add_domain_success_details' not set")
        return self._value

    def get_domain_verification_remove_domain_details(self):
        """
        Only call this if :meth:`is_domain_verification_remove_domain_details` is true.

        :rtype: DomainVerificationRemoveDomainDetails
        """
        if not self.is_domain_verification_remove_domain_details():
            raise AttributeError("tag 'domain_verification_remove_domain_details' not set")
        return self._value

    def get_enabled_domain_invites_details(self):
        """
        Only call this if :meth:`is_enabled_domain_invites_details` is true.

        :rtype: EnabledDomainInvitesDetails
        """
        if not self.is_enabled_domain_invites_details():
            raise AttributeError("tag 'enabled_domain_invites_details' not set")
        return self._value

    def get_apply_naming_convention_details(self):
        """
        Only call this if :meth:`is_apply_naming_convention_details` is true.

        :rtype: ApplyNamingConventionDetails
        """
        if not self.is_apply_naming_convention_details():
            raise AttributeError("tag 'apply_naming_convention_details' not set")
        return self._value

    def get_create_folder_details(self):
        """
        Only call this if :meth:`is_create_folder_details` is true.

        :rtype: CreateFolderDetails
        """
        if not self.is_create_folder_details():
            raise AttributeError("tag 'create_folder_details' not set")
        return self._value

    def get_file_add_details(self):
        """
        Only call this if :meth:`is_file_add_details` is true.

        :rtype: FileAddDetails
        """
        if not self.is_file_add_details():
            raise AttributeError("tag 'file_add_details' not set")
        return self._value

    def get_file_copy_details(self):
        """
        Only call this if :meth:`is_file_copy_details` is true.

        :rtype: FileCopyDetails
        """
        if not self.is_file_copy_details():
            raise AttributeError("tag 'file_copy_details' not set")
        return self._value

    def get_file_delete_details(self):
        """
        Only call this if :meth:`is_file_delete_details` is true.

        :rtype: FileDeleteDetails
        """
        if not self.is_file_delete_details():
            raise AttributeError("tag 'file_delete_details' not set")
        return self._value

    def get_file_download_details(self):
        """
        Only call this if :meth:`is_file_download_details` is true.

        :rtype: FileDownloadDetails
        """
        if not self.is_file_download_details():
            raise AttributeError("tag 'file_download_details' not set")
        return self._value

    def get_file_edit_details(self):
        """
        Only call this if :meth:`is_file_edit_details` is true.

        :rtype: FileEditDetails
        """
        if not self.is_file_edit_details():
            raise AttributeError("tag 'file_edit_details' not set")
        return self._value

    def get_file_get_copy_reference_details(self):
        """
        Only call this if :meth:`is_file_get_copy_reference_details` is true.

        :rtype: FileGetCopyReferenceDetails
        """
        if not self.is_file_get_copy_reference_details():
            raise AttributeError("tag 'file_get_copy_reference_details' not set")
        return self._value

    def get_file_locking_lock_status_changed_details(self):
        """
        Only call this if :meth:`is_file_locking_lock_status_changed_details` is true.

        :rtype: FileLockingLockStatusChangedDetails
        """
        if not self.is_file_locking_lock_status_changed_details():
            raise AttributeError("tag 'file_locking_lock_status_changed_details' not set")
        return self._value

    def get_file_move_details(self):
        """
        Only call this if :meth:`is_file_move_details` is true.

        :rtype: FileMoveDetails
        """
        if not self.is_file_move_details():
            raise AttributeError("tag 'file_move_details' not set")
        return self._value

    def get_file_permanently_delete_details(self):
        """
        Only call this if :meth:`is_file_permanently_delete_details` is true.

        :rtype: FilePermanentlyDeleteDetails
        """
        if not self.is_file_permanently_delete_details():
            raise AttributeError("tag 'file_permanently_delete_details' not set")
        return self._value

    def get_file_preview_details(self):
        """
        Only call this if :meth:`is_file_preview_details` is true.

        :rtype: FilePreviewDetails
        """
        if not self.is_file_preview_details():
            raise AttributeError("tag 'file_preview_details' not set")
        return self._value

    def get_file_rename_details(self):
        """
        Only call this if :meth:`is_file_rename_details` is true.

        :rtype: FileRenameDetails
        """
        if not self.is_file_rename_details():
            raise AttributeError("tag 'file_rename_details' not set")
        return self._value

    def get_file_restore_details(self):
        """
        Only call this if :meth:`is_file_restore_details` is true.

        :rtype: FileRestoreDetails
        """
        if not self.is_file_restore_details():
            raise AttributeError("tag 'file_restore_details' not set")
        return self._value

    def get_file_revert_details(self):
        """
        Only call this if :meth:`is_file_revert_details` is true.

        :rtype: FileRevertDetails
        """
        if not self.is_file_revert_details():
            raise AttributeError("tag 'file_revert_details' not set")
        return self._value

    def get_file_rollback_changes_details(self):
        """
        Only call this if :meth:`is_file_rollback_changes_details` is true.

        :rtype: FileRollbackChangesDetails
        """
        if not self.is_file_rollback_changes_details():
            raise AttributeError("tag 'file_rollback_changes_details' not set")
        return self._value

    def get_file_save_copy_reference_details(self):
        """
        Only call this if :meth:`is_file_save_copy_reference_details` is true.

        :rtype: FileSaveCopyReferenceDetails
        """
        if not self.is_file_save_copy_reference_details():
            raise AttributeError("tag 'file_save_copy_reference_details' not set")
        return self._value

    def get_folder_overview_description_changed_details(self):
        """
        Only call this if :meth:`is_folder_overview_description_changed_details` is true.

        :rtype: FolderOverviewDescriptionChangedDetails
        """
        if not self.is_folder_overview_description_changed_details():
            raise AttributeError("tag 'folder_overview_description_changed_details' not set")
        return self._value

    def get_folder_overview_item_pinned_details(self):
        """
        Only call this if :meth:`is_folder_overview_item_pinned_details` is true.

        :rtype: FolderOverviewItemPinnedDetails
        """
        if not self.is_folder_overview_item_pinned_details():
            raise AttributeError("tag 'folder_overview_item_pinned_details' not set")
        return self._value

    def get_folder_overview_item_unpinned_details(self):
        """
        Only call this if :meth:`is_folder_overview_item_unpinned_details` is true.

        :rtype: FolderOverviewItemUnpinnedDetails
        """
        if not self.is_folder_overview_item_unpinned_details():
            raise AttributeError("tag 'folder_overview_item_unpinned_details' not set")
        return self._value

    def get_object_label_added_details(self):
        """
        Only call this if :meth:`is_object_label_added_details` is true.

        :rtype: ObjectLabelAddedDetails
        """
        if not self.is_object_label_added_details():
            raise AttributeError("tag 'object_label_added_details' not set")
        return self._value

    def get_object_label_removed_details(self):
        """
        Only call this if :meth:`is_object_label_removed_details` is true.

        :rtype: ObjectLabelRemovedDetails
        """
        if not self.is_object_label_removed_details():
            raise AttributeError("tag 'object_label_removed_details' not set")
        return self._value

    def get_object_label_updated_value_details(self):
        """
        Only call this if :meth:`is_object_label_updated_value_details` is true.

        :rtype: ObjectLabelUpdatedValueDetails
        """
        if not self.is_object_label_updated_value_details():
            raise AttributeError("tag 'object_label_updated_value_details' not set")
        return self._value

    def get_organize_folder_with_tidy_details(self):
        """
        Only call this if :meth:`is_organize_folder_with_tidy_details` is true.

        :rtype: OrganizeFolderWithTidyDetails
        """
        if not self.is_organize_folder_with_tidy_details():
            raise AttributeError("tag 'organize_folder_with_tidy_details' not set")
        return self._value

    def get_rewind_folder_details(self):
        """
        Only call this if :meth:`is_rewind_folder_details` is true.

        :rtype: RewindFolderDetails
        """
        if not self.is_rewind_folder_details():
            raise AttributeError("tag 'rewind_folder_details' not set")
        return self._value

    def get_undo_naming_convention_details(self):
        """
        Only call this if :meth:`is_undo_naming_convention_details` is true.

        :rtype: UndoNamingConventionDetails
        """
        if not self.is_undo_naming_convention_details():
            raise AttributeError("tag 'undo_naming_convention_details' not set")
        return self._value

    def get_undo_organize_folder_with_tidy_details(self):
        """
        Only call this if :meth:`is_undo_organize_folder_with_tidy_details` is true.

        :rtype: UndoOrganizeFolderWithTidyDetails
        """
        if not self.is_undo_organize_folder_with_tidy_details():
            raise AttributeError("tag 'undo_organize_folder_with_tidy_details' not set")
        return self._value

    def get_user_tags_added_details(self):
        """
        Only call this if :meth:`is_user_tags_added_details` is true.

        :rtype: UserTagsAddedDetails
        """
        if not self.is_user_tags_added_details():
            raise AttributeError("tag 'user_tags_added_details' not set")
        return self._value

    def get_user_tags_removed_details(self):
        """
        Only call this if :meth:`is_user_tags_removed_details` is true.

        :rtype: UserTagsRemovedDetails
        """
        if not self.is_user_tags_removed_details():
            raise AttributeError("tag 'user_tags_removed_details' not set")
        return self._value

    def get_email_ingest_receive_file_details(self):
        """
        Only call this if :meth:`is_email_ingest_receive_file_details` is true.

        :rtype: EmailIngestReceiveFileDetails
        """
        if not self.is_email_ingest_receive_file_details():
            raise AttributeError("tag 'email_ingest_receive_file_details' not set")
        return self._value

    def get_file_request_change_details(self):
        """
        Only call this if :meth:`is_file_request_change_details` is true.

        :rtype: FileRequestChangeDetails
        """
        if not self.is_file_request_change_details():
            raise AttributeError("tag 'file_request_change_details' not set")
        return self._value

    def get_file_request_close_details(self):
        """
        Only call this if :meth:`is_file_request_close_details` is true.

        :rtype: FileRequestCloseDetails
        """
        if not self.is_file_request_close_details():
            raise AttributeError("tag 'file_request_close_details' not set")
        return self._value

    def get_file_request_create_details(self):
        """
        Only call this if :meth:`is_file_request_create_details` is true.

        :rtype: FileRequestCreateDetails
        """
        if not self.is_file_request_create_details():
            raise AttributeError("tag 'file_request_create_details' not set")
        return self._value

    def get_file_request_delete_details(self):
        """
        Only call this if :meth:`is_file_request_delete_details` is true.

        :rtype: FileRequestDeleteDetails
        """
        if not self.is_file_request_delete_details():
            raise AttributeError("tag 'file_request_delete_details' not set")
        return self._value

    def get_file_request_receive_file_details(self):
        """
        Only call this if :meth:`is_file_request_receive_file_details` is true.

        :rtype: FileRequestReceiveFileDetails
        """
        if not self.is_file_request_receive_file_details():
            raise AttributeError("tag 'file_request_receive_file_details' not set")
        return self._value

    def get_group_add_external_id_details(self):
        """
        Only call this if :meth:`is_group_add_external_id_details` is true.

        :rtype: GroupAddExternalIdDetails
        """
        if not self.is_group_add_external_id_details():
            raise AttributeError("tag 'group_add_external_id_details' not set")
        return self._value

    def get_group_add_member_details(self):
        """
        Only call this if :meth:`is_group_add_member_details` is true.

        :rtype: GroupAddMemberDetails
        """
        if not self.is_group_add_member_details():
            raise AttributeError("tag 'group_add_member_details' not set")
        return self._value

    def get_group_change_external_id_details(self):
        """
        Only call this if :meth:`is_group_change_external_id_details` is true.

        :rtype: GroupChangeExternalIdDetails
        """
        if not self.is_group_change_external_id_details():
            raise AttributeError("tag 'group_change_external_id_details' not set")
        return self._value

    def get_group_change_management_type_details(self):
        """
        Only call this if :meth:`is_group_change_management_type_details` is true.

        :rtype: GroupChangeManagementTypeDetails
        """
        if not self.is_group_change_management_type_details():
            raise AttributeError("tag 'group_change_management_type_details' not set")
        return self._value

    def get_group_change_member_role_details(self):
        """
        Only call this if :meth:`is_group_change_member_role_details` is true.

        :rtype: GroupChangeMemberRoleDetails
        """
        if not self.is_group_change_member_role_details():
            raise AttributeError("tag 'group_change_member_role_details' not set")
        return self._value

    def get_group_create_details(self):
        """
        Only call this if :meth:`is_group_create_details` is true.

        :rtype: GroupCreateDetails
        """
        if not self.is_group_create_details():
            raise AttributeError("tag 'group_create_details' not set")
        return self._value

    def get_group_delete_details(self):
        """
        Only call this if :meth:`is_group_delete_details` is true.

        :rtype: GroupDeleteDetails
        """
        if not self.is_group_delete_details():
            raise AttributeError("tag 'group_delete_details' not set")
        return self._value

    def get_group_description_updated_details(self):
        """
        Only call this if :meth:`is_group_description_updated_details` is true.

        :rtype: GroupDescriptionUpdatedDetails
        """
        if not self.is_group_description_updated_details():
            raise AttributeError("tag 'group_description_updated_details' not set")
        return self._value

    def get_group_join_policy_updated_details(self):
        """
        Only call this if :meth:`is_group_join_policy_updated_details` is true.

        :rtype: GroupJoinPolicyUpdatedDetails
        """
        if not self.is_group_join_policy_updated_details():
            raise AttributeError("tag 'group_join_policy_updated_details' not set")
        return self._value

    def get_group_moved_details(self):
        """
        Only call this if :meth:`is_group_moved_details` is true.

        :rtype: GroupMovedDetails
        """
        if not self.is_group_moved_details():
            raise AttributeError("tag 'group_moved_details' not set")
        return self._value

    def get_group_remove_external_id_details(self):
        """
        Only call this if :meth:`is_group_remove_external_id_details` is true.

        :rtype: GroupRemoveExternalIdDetails
        """
        if not self.is_group_remove_external_id_details():
            raise AttributeError("tag 'group_remove_external_id_details' not set")
        return self._value

    def get_group_remove_member_details(self):
        """
        Only call this if :meth:`is_group_remove_member_details` is true.

        :rtype: GroupRemoveMemberDetails
        """
        if not self.is_group_remove_member_details():
            raise AttributeError("tag 'group_remove_member_details' not set")
        return self._value

    def get_group_rename_details(self):
        """
        Only call this if :meth:`is_group_rename_details` is true.

        :rtype: GroupRenameDetails
        """
        if not self.is_group_rename_details():
            raise AttributeError("tag 'group_rename_details' not set")
        return self._value

    def get_account_lock_or_unlocked_details(self):
        """
        Only call this if :meth:`is_account_lock_or_unlocked_details` is true.

        :rtype: AccountLockOrUnlockedDetails
        """
        if not self.is_account_lock_or_unlocked_details():
            raise AttributeError("tag 'account_lock_or_unlocked_details' not set")
        return self._value

    def get_emm_error_details(self):
        """
        Only call this if :meth:`is_emm_error_details` is true.

        :rtype: EmmErrorDetails
        """
        if not self.is_emm_error_details():
            raise AttributeError("tag 'emm_error_details' not set")
        return self._value

    def get_guest_admin_signed_in_via_trusted_teams_details(self):
        """
        Only call this if :meth:`is_guest_admin_signed_in_via_trusted_teams_details` is true.

        :rtype: GuestAdminSignedInViaTrustedTeamsDetails
        """
        if not self.is_guest_admin_signed_in_via_trusted_teams_details():
            raise AttributeError("tag 'guest_admin_signed_in_via_trusted_teams_details' not set")
        return self._value

    def get_guest_admin_signed_out_via_trusted_teams_details(self):
        """
        Only call this if :meth:`is_guest_admin_signed_out_via_trusted_teams_details` is true.

        :rtype: GuestAdminSignedOutViaTrustedTeamsDetails
        """
        if not self.is_guest_admin_signed_out_via_trusted_teams_details():
            raise AttributeError("tag 'guest_admin_signed_out_via_trusted_teams_details' not set")
        return self._value

    def get_login_fail_details(self):
        """
        Only call this if :meth:`is_login_fail_details` is true.

        :rtype: LoginFailDetails
        """
        if not self.is_login_fail_details():
            raise AttributeError("tag 'login_fail_details' not set")
        return self._value

    def get_login_success_details(self):
        """
        Only call this if :meth:`is_login_success_details` is true.

        :rtype: LoginSuccessDetails
        """
        if not self.is_login_success_details():
            raise AttributeError("tag 'login_success_details' not set")
        return self._value

    def get_logout_details(self):
        """
        Only call this if :meth:`is_logout_details` is true.

        :rtype: LogoutDetails
        """
        if not self.is_logout_details():
            raise AttributeError("tag 'logout_details' not set")
        return self._value

    def get_reseller_support_session_end_details(self):
        """
        Only call this if :meth:`is_reseller_support_session_end_details` is true.

        :rtype: ResellerSupportSessionEndDetails
        """
        if not self.is_reseller_support_session_end_details():
            raise AttributeError("tag 'reseller_support_session_end_details' not set")
        return self._value

    def get_reseller_support_session_start_details(self):
        """
        Only call this if :meth:`is_reseller_support_session_start_details` is true.

        :rtype: ResellerSupportSessionStartDetails
        """
        if not self.is_reseller_support_session_start_details():
            raise AttributeError("tag 'reseller_support_session_start_details' not set")
        return self._value

    def get_sign_in_as_session_end_details(self):
        """
        Only call this if :meth:`is_sign_in_as_session_end_details` is true.

        :rtype: SignInAsSessionEndDetails
        """
        if not self.is_sign_in_as_session_end_details():
            raise AttributeError("tag 'sign_in_as_session_end_details' not set")
        return self._value

    def get_sign_in_as_session_start_details(self):
        """
        Only call this if :meth:`is_sign_in_as_session_start_details` is true.

        :rtype: SignInAsSessionStartDetails
        """
        if not self.is_sign_in_as_session_start_details():
            raise AttributeError("tag 'sign_in_as_session_start_details' not set")
        return self._value

    def get_sso_error_details(self):
        """
        Only call this if :meth:`is_sso_error_details` is true.

        :rtype: SsoErrorDetails
        """
        if not self.is_sso_error_details():
            raise AttributeError("tag 'sso_error_details' not set")
        return self._value

    def get_create_team_invite_link_details(self):
        """
        Only call this if :meth:`is_create_team_invite_link_details` is true.

        :rtype: CreateTeamInviteLinkDetails
        """
        if not self.is_create_team_invite_link_details():
            raise AttributeError("tag 'create_team_invite_link_details' not set")
        return self._value

    def get_delete_team_invite_link_details(self):
        """
        Only call this if :meth:`is_delete_team_invite_link_details` is true.

        :rtype: DeleteTeamInviteLinkDetails
        """
        if not self.is_delete_team_invite_link_details():
            raise AttributeError("tag 'delete_team_invite_link_details' not set")
        return self._value

    def get_member_add_external_id_details(self):
        """
        Only call this if :meth:`is_member_add_external_id_details` is true.

        :rtype: MemberAddExternalIdDetails
        """
        if not self.is_member_add_external_id_details():
            raise AttributeError("tag 'member_add_external_id_details' not set")
        return self._value

    def get_member_add_name_details(self):
        """
        Only call this if :meth:`is_member_add_name_details` is true.

        :rtype: MemberAddNameDetails
        """
        if not self.is_member_add_name_details():
            raise AttributeError("tag 'member_add_name_details' not set")
        return self._value

    def get_member_change_admin_role_details(self):
        """
        Only call this if :meth:`is_member_change_admin_role_details` is true.

        :rtype: MemberChangeAdminRoleDetails
        """
        if not self.is_member_change_admin_role_details():
            raise AttributeError("tag 'member_change_admin_role_details' not set")
        return self._value

    def get_member_change_email_details(self):
        """
        Only call this if :meth:`is_member_change_email_details` is true.

        :rtype: MemberChangeEmailDetails
        """
        if not self.is_member_change_email_details():
            raise AttributeError("tag 'member_change_email_details' not set")
        return self._value

    def get_member_change_external_id_details(self):
        """
        Only call this if :meth:`is_member_change_external_id_details` is true.

        :rtype: MemberChangeExternalIdDetails
        """
        if not self.is_member_change_external_id_details():
            raise AttributeError("tag 'member_change_external_id_details' not set")
        return self._value

    def get_member_change_membership_type_details(self):
        """
        Only call this if :meth:`is_member_change_membership_type_details` is true.

        :rtype: MemberChangeMembershipTypeDetails
        """
        if not self.is_member_change_membership_type_details():
            raise AttributeError("tag 'member_change_membership_type_details' not set")
        return self._value

    def get_member_change_name_details(self):
        """
        Only call this if :meth:`is_member_change_name_details` is true.

        :rtype: MemberChangeNameDetails
        """
        if not self.is_member_change_name_details():
            raise AttributeError("tag 'member_change_name_details' not set")
        return self._value

    def get_member_change_reseller_role_details(self):
        """
        Only call this if :meth:`is_member_change_reseller_role_details` is true.

        :rtype: MemberChangeResellerRoleDetails
        """
        if not self.is_member_change_reseller_role_details():
            raise AttributeError("tag 'member_change_reseller_role_details' not set")
        return self._value

    def get_member_change_status_details(self):
        """
        Only call this if :meth:`is_member_change_status_details` is true.

        :rtype: MemberChangeStatusDetails
        """
        if not self.is_member_change_status_details():
            raise AttributeError("tag 'member_change_status_details' not set")
        return self._value

    def get_member_delete_manual_contacts_details(self):
        """
        Only call this if :meth:`is_member_delete_manual_contacts_details` is true.

        :rtype: MemberDeleteManualContactsDetails
        """
        if not self.is_member_delete_manual_contacts_details():
            raise AttributeError("tag 'member_delete_manual_contacts_details' not set")
        return self._value

    def get_member_delete_profile_photo_details(self):
        """
        Only call this if :meth:`is_member_delete_profile_photo_details` is true.

        :rtype: MemberDeleteProfilePhotoDetails
        """
        if not self.is_member_delete_profile_photo_details():
            raise AttributeError("tag 'member_delete_profile_photo_details' not set")
        return self._value

    def get_member_permanently_delete_account_contents_details(self):
        """
        Only call this if :meth:`is_member_permanently_delete_account_contents_details` is true.

        :rtype: MemberPermanentlyDeleteAccountContentsDetails
        """
        if not self.is_member_permanently_delete_account_contents_details():
            raise AttributeError("tag 'member_permanently_delete_account_contents_details' not set")
        return self._value

    def get_member_remove_external_id_details(self):
        """
        Only call this if :meth:`is_member_remove_external_id_details` is true.

        :rtype: MemberRemoveExternalIdDetails
        """
        if not self.is_member_remove_external_id_details():
            raise AttributeError("tag 'member_remove_external_id_details' not set")
        return self._value

    def get_member_set_profile_photo_details(self):
        """
        Only call this if :meth:`is_member_set_profile_photo_details` is true.

        :rtype: MemberSetProfilePhotoDetails
        """
        if not self.is_member_set_profile_photo_details():
            raise AttributeError("tag 'member_set_profile_photo_details' not set")
        return self._value

    def get_member_space_limits_add_custom_quota_details(self):
        """
        Only call this if :meth:`is_member_space_limits_add_custom_quota_details` is true.

        :rtype: MemberSpaceLimitsAddCustomQuotaDetails
        """
        if not self.is_member_space_limits_add_custom_quota_details():
            raise AttributeError("tag 'member_space_limits_add_custom_quota_details' not set")
        return self._value

    def get_member_space_limits_change_custom_quota_details(self):
        """
        Only call this if :meth:`is_member_space_limits_change_custom_quota_details` is true.

        :rtype: MemberSpaceLimitsChangeCustomQuotaDetails
        """
        if not self.is_member_space_limits_change_custom_quota_details():
            raise AttributeError("tag 'member_space_limits_change_custom_quota_details' not set")
        return self._value

    def get_member_space_limits_change_status_details(self):
        """
        Only call this if :meth:`is_member_space_limits_change_status_details` is true.

        :rtype: MemberSpaceLimitsChangeStatusDetails
        """
        if not self.is_member_space_limits_change_status_details():
            raise AttributeError("tag 'member_space_limits_change_status_details' not set")
        return self._value

    def get_member_space_limits_remove_custom_quota_details(self):
        """
        Only call this if :meth:`is_member_space_limits_remove_custom_quota_details` is true.

        :rtype: MemberSpaceLimitsRemoveCustomQuotaDetails
        """
        if not self.is_member_space_limits_remove_custom_quota_details():
            raise AttributeError("tag 'member_space_limits_remove_custom_quota_details' not set")
        return self._value

    def get_member_suggest_details(self):
        """
        Only call this if :meth:`is_member_suggest_details` is true.

        :rtype: MemberSuggestDetails
        """
        if not self.is_member_suggest_details():
            raise AttributeError("tag 'member_suggest_details' not set")
        return self._value

    def get_member_transfer_account_contents_details(self):
        """
        Only call this if :meth:`is_member_transfer_account_contents_details` is true.

        :rtype: MemberTransferAccountContentsDetails
        """
        if not self.is_member_transfer_account_contents_details():
            raise AttributeError("tag 'member_transfer_account_contents_details' not set")
        return self._value

    def get_pending_secondary_email_added_details(self):
        """
        Only call this if :meth:`is_pending_secondary_email_added_details` is true.

        :rtype: PendingSecondaryEmailAddedDetails
        """
        if not self.is_pending_secondary_email_added_details():
            raise AttributeError("tag 'pending_secondary_email_added_details' not set")
        return self._value

    def get_secondary_email_deleted_details(self):
        """
        Only call this if :meth:`is_secondary_email_deleted_details` is true.

        :rtype: SecondaryEmailDeletedDetails
        """
        if not self.is_secondary_email_deleted_details():
            raise AttributeError("tag 'secondary_email_deleted_details' not set")
        return self._value

    def get_secondary_email_verified_details(self):
        """
        Only call this if :meth:`is_secondary_email_verified_details` is true.

        :rtype: SecondaryEmailVerifiedDetails
        """
        if not self.is_secondary_email_verified_details():
            raise AttributeError("tag 'secondary_email_verified_details' not set")
        return self._value

    def get_secondary_mails_policy_changed_details(self):
        """
        Only call this if :meth:`is_secondary_mails_policy_changed_details` is true.

        :rtype: SecondaryMailsPolicyChangedDetails
        """
        if not self.is_secondary_mails_policy_changed_details():
            raise AttributeError("tag 'secondary_mails_policy_changed_details' not set")
        return self._value

    def get_binder_add_page_details(self):
        """
        Only call this if :meth:`is_binder_add_page_details` is true.

        :rtype: BinderAddPageDetails
        """
        if not self.is_binder_add_page_details():
            raise AttributeError("tag 'binder_add_page_details' not set")
        return self._value

    def get_binder_add_section_details(self):
        """
        Only call this if :meth:`is_binder_add_section_details` is true.

        :rtype: BinderAddSectionDetails
        """
        if not self.is_binder_add_section_details():
            raise AttributeError("tag 'binder_add_section_details' not set")
        return self._value

    def get_binder_remove_page_details(self):
        """
        Only call this if :meth:`is_binder_remove_page_details` is true.

        :rtype: BinderRemovePageDetails
        """
        if not self.is_binder_remove_page_details():
            raise AttributeError("tag 'binder_remove_page_details' not set")
        return self._value

    def get_binder_remove_section_details(self):
        """
        Only call this if :meth:`is_binder_remove_section_details` is true.

        :rtype: BinderRemoveSectionDetails
        """
        if not self.is_binder_remove_section_details():
            raise AttributeError("tag 'binder_remove_section_details' not set")
        return self._value

    def get_binder_rename_page_details(self):
        """
        Only call this if :meth:`is_binder_rename_page_details` is true.

        :rtype: BinderRenamePageDetails
        """
        if not self.is_binder_rename_page_details():
            raise AttributeError("tag 'binder_rename_page_details' not set")
        return self._value

    def get_binder_rename_section_details(self):
        """
        Only call this if :meth:`is_binder_rename_section_details` is true.

        :rtype: BinderRenameSectionDetails
        """
        if not self.is_binder_rename_section_details():
            raise AttributeError("tag 'binder_rename_section_details' not set")
        return self._value

    def get_binder_reorder_page_details(self):
        """
        Only call this if :meth:`is_binder_reorder_page_details` is true.

        :rtype: BinderReorderPageDetails
        """
        if not self.is_binder_reorder_page_details():
            raise AttributeError("tag 'binder_reorder_page_details' not set")
        return self._value

    def get_binder_reorder_section_details(self):
        """
        Only call this if :meth:`is_binder_reorder_section_details` is true.

        :rtype: BinderReorderSectionDetails
        """
        if not self.is_binder_reorder_section_details():
            raise AttributeError("tag 'binder_reorder_section_details' not set")
        return self._value

    def get_paper_content_add_member_details(self):
        """
        Only call this if :meth:`is_paper_content_add_member_details` is true.

        :rtype: PaperContentAddMemberDetails
        """
        if not self.is_paper_content_add_member_details():
            raise AttributeError("tag 'paper_content_add_member_details' not set")
        return self._value

    def get_paper_content_add_to_folder_details(self):
        """
        Only call this if :meth:`is_paper_content_add_to_folder_details` is true.

        :rtype: PaperContentAddToFolderDetails
        """
        if not self.is_paper_content_add_to_folder_details():
            raise AttributeError("tag 'paper_content_add_to_folder_details' not set")
        return self._value

    def get_paper_content_archive_details(self):
        """
        Only call this if :meth:`is_paper_content_archive_details` is true.

        :rtype: PaperContentArchiveDetails
        """
        if not self.is_paper_content_archive_details():
            raise AttributeError("tag 'paper_content_archive_details' not set")
        return self._value

    def get_paper_content_create_details(self):
        """
        Only call this if :meth:`is_paper_content_create_details` is true.

        :rtype: PaperContentCreateDetails
        """
        if not self.is_paper_content_create_details():
            raise AttributeError("tag 'paper_content_create_details' not set")
        return self._value

    def get_paper_content_permanently_delete_details(self):
        """
        Only call this if :meth:`is_paper_content_permanently_delete_details` is true.

        :rtype: PaperContentPermanentlyDeleteDetails
        """
        if not self.is_paper_content_permanently_delete_details():
            raise AttributeError("tag 'paper_content_permanently_delete_details' not set")
        return self._value

    def get_paper_content_remove_from_folder_details(self):
        """
        Only call this if :meth:`is_paper_content_remove_from_folder_details` is true.

        :rtype: PaperContentRemoveFromFolderDetails
        """
        if not self.is_paper_content_remove_from_folder_details():
            raise AttributeError("tag 'paper_content_remove_from_folder_details' not set")
        return self._value

    def get_paper_content_remove_member_details(self):
        """
        Only call this if :meth:`is_paper_content_remove_member_details` is true.

        :rtype: PaperContentRemoveMemberDetails
        """
        if not self.is_paper_content_remove_member_details():
            raise AttributeError("tag 'paper_content_remove_member_details' not set")
        return self._value

    def get_paper_content_rename_details(self):
        """
        Only call this if :meth:`is_paper_content_rename_details` is true.

        :rtype: PaperContentRenameDetails
        """
        if not self.is_paper_content_rename_details():
            raise AttributeError("tag 'paper_content_rename_details' not set")
        return self._value

    def get_paper_content_restore_details(self):
        """
        Only call this if :meth:`is_paper_content_restore_details` is true.

        :rtype: PaperContentRestoreDetails
        """
        if not self.is_paper_content_restore_details():
            raise AttributeError("tag 'paper_content_restore_details' not set")
        return self._value

    def get_paper_doc_add_comment_details(self):
        """
        Only call this if :meth:`is_paper_doc_add_comment_details` is true.

        :rtype: PaperDocAddCommentDetails
        """
        if not self.is_paper_doc_add_comment_details():
            raise AttributeError("tag 'paper_doc_add_comment_details' not set")
        return self._value

    def get_paper_doc_change_member_role_details(self):
        """
        Only call this if :meth:`is_paper_doc_change_member_role_details` is true.

        :rtype: PaperDocChangeMemberRoleDetails
        """
        if not self.is_paper_doc_change_member_role_details():
            raise AttributeError("tag 'paper_doc_change_member_role_details' not set")
        return self._value

    def get_paper_doc_change_sharing_policy_details(self):
        """
        Only call this if :meth:`is_paper_doc_change_sharing_policy_details` is true.

        :rtype: PaperDocChangeSharingPolicyDetails
        """
        if not self.is_paper_doc_change_sharing_policy_details():
            raise AttributeError("tag 'paper_doc_change_sharing_policy_details' not set")
        return self._value

    def get_paper_doc_change_subscription_details(self):
        """
        Only call this if :meth:`is_paper_doc_change_subscription_details` is true.

        :rtype: PaperDocChangeSubscriptionDetails
        """
        if not self.is_paper_doc_change_subscription_details():
            raise AttributeError("tag 'paper_doc_change_subscription_details' not set")
        return self._value

    def get_paper_doc_deleted_details(self):
        """
        Only call this if :meth:`is_paper_doc_deleted_details` is true.

        :rtype: PaperDocDeletedDetails
        """
        if not self.is_paper_doc_deleted_details():
            raise AttributeError("tag 'paper_doc_deleted_details' not set")
        return self._value

    def get_paper_doc_delete_comment_details(self):
        """
        Only call this if :meth:`is_paper_doc_delete_comment_details` is true.

        :rtype: PaperDocDeleteCommentDetails
        """
        if not self.is_paper_doc_delete_comment_details():
            raise AttributeError("tag 'paper_doc_delete_comment_details' not set")
        return self._value

    def get_paper_doc_download_details(self):
        """
        Only call this if :meth:`is_paper_doc_download_details` is true.

        :rtype: PaperDocDownloadDetails
        """
        if not self.is_paper_doc_download_details():
            raise AttributeError("tag 'paper_doc_download_details' not set")
        return self._value

    def get_paper_doc_edit_details(self):
        """
        Only call this if :meth:`is_paper_doc_edit_details` is true.

        :rtype: PaperDocEditDetails
        """
        if not self.is_paper_doc_edit_details():
            raise AttributeError("tag 'paper_doc_edit_details' not set")
        return self._value

    def get_paper_doc_edit_comment_details(self):
        """
        Only call this if :meth:`is_paper_doc_edit_comment_details` is true.

        :rtype: PaperDocEditCommentDetails
        """
        if not self.is_paper_doc_edit_comment_details():
            raise AttributeError("tag 'paper_doc_edit_comment_details' not set")
        return self._value

    def get_paper_doc_followed_details(self):
        """
        Only call this if :meth:`is_paper_doc_followed_details` is true.

        :rtype: PaperDocFollowedDetails
        """
        if not self.is_paper_doc_followed_details():
            raise AttributeError("tag 'paper_doc_followed_details' not set")
        return self._value

    def get_paper_doc_mention_details(self):
        """
        Only call this if :meth:`is_paper_doc_mention_details` is true.

        :rtype: PaperDocMentionDetails
        """
        if not self.is_paper_doc_mention_details():
            raise AttributeError("tag 'paper_doc_mention_details' not set")
        return self._value

    def get_paper_doc_ownership_changed_details(self):
        """
        Only call this if :meth:`is_paper_doc_ownership_changed_details` is true.

        :rtype: PaperDocOwnershipChangedDetails
        """
        if not self.is_paper_doc_ownership_changed_details():
            raise AttributeError("tag 'paper_doc_ownership_changed_details' not set")
        return self._value

    def get_paper_doc_request_access_details(self):
        """
        Only call this if :meth:`is_paper_doc_request_access_details` is true.

        :rtype: PaperDocRequestAccessDetails
        """
        if not self.is_paper_doc_request_access_details():
            raise AttributeError("tag 'paper_doc_request_access_details' not set")
        return self._value

    def get_paper_doc_resolve_comment_details(self):
        """
        Only call this if :meth:`is_paper_doc_resolve_comment_details` is true.

        :rtype: PaperDocResolveCommentDetails
        """
        if not self.is_paper_doc_resolve_comment_details():
            raise AttributeError("tag 'paper_doc_resolve_comment_details' not set")
        return self._value

    def get_paper_doc_revert_details(self):
        """
        Only call this if :meth:`is_paper_doc_revert_details` is true.

        :rtype: PaperDocRevertDetails
        """
        if not self.is_paper_doc_revert_details():
            raise AttributeError("tag 'paper_doc_revert_details' not set")
        return self._value

    def get_paper_doc_slack_share_details(self):
        """
        Only call this if :meth:`is_paper_doc_slack_share_details` is true.

        :rtype: PaperDocSlackShareDetails
        """
        if not self.is_paper_doc_slack_share_details():
            raise AttributeError("tag 'paper_doc_slack_share_details' not set")
        return self._value

    def get_paper_doc_team_invite_details(self):
        """
        Only call this if :meth:`is_paper_doc_team_invite_details` is true.

        :rtype: PaperDocTeamInviteDetails
        """
        if not self.is_paper_doc_team_invite_details():
            raise AttributeError("tag 'paper_doc_team_invite_details' not set")
        return self._value

    def get_paper_doc_trashed_details(self):
        """
        Only call this if :meth:`is_paper_doc_trashed_details` is true.

        :rtype: PaperDocTrashedDetails
        """
        if not self.is_paper_doc_trashed_details():
            raise AttributeError("tag 'paper_doc_trashed_details' not set")
        return self._value

    def get_paper_doc_unresolve_comment_details(self):
        """
        Only call this if :meth:`is_paper_doc_unresolve_comment_details` is true.

        :rtype: PaperDocUnresolveCommentDetails
        """
        if not self.is_paper_doc_unresolve_comment_details():
            raise AttributeError("tag 'paper_doc_unresolve_comment_details' not set")
        return self._value

    def get_paper_doc_untrashed_details(self):
        """
        Only call this if :meth:`is_paper_doc_untrashed_details` is true.

        :rtype: PaperDocUntrashedDetails
        """
        if not self.is_paper_doc_untrashed_details():
            raise AttributeError("tag 'paper_doc_untrashed_details' not set")
        return self._value

    def get_paper_doc_view_details(self):
        """
        Only call this if :meth:`is_paper_doc_view_details` is true.

        :rtype: PaperDocViewDetails
        """
        if not self.is_paper_doc_view_details():
            raise AttributeError("tag 'paper_doc_view_details' not set")
        return self._value

    def get_paper_external_view_allow_details(self):
        """
        Only call this if :meth:`is_paper_external_view_allow_details` is true.

        :rtype: PaperExternalViewAllowDetails
        """
        if not self.is_paper_external_view_allow_details():
            raise AttributeError("tag 'paper_external_view_allow_details' not set")
        return self._value

    def get_paper_external_view_default_team_details(self):
        """
        Only call this if :meth:`is_paper_external_view_default_team_details` is true.

        :rtype: PaperExternalViewDefaultTeamDetails
        """
        if not self.is_paper_external_view_default_team_details():
            raise AttributeError("tag 'paper_external_view_default_team_details' not set")
        return self._value

    def get_paper_external_view_forbid_details(self):
        """
        Only call this if :meth:`is_paper_external_view_forbid_details` is true.

        :rtype: PaperExternalViewForbidDetails
        """
        if not self.is_paper_external_view_forbid_details():
            raise AttributeError("tag 'paper_external_view_forbid_details' not set")
        return self._value

    def get_paper_folder_change_subscription_details(self):
        """
        Only call this if :meth:`is_paper_folder_change_subscription_details` is true.

        :rtype: PaperFolderChangeSubscriptionDetails
        """
        if not self.is_paper_folder_change_subscription_details():
            raise AttributeError("tag 'paper_folder_change_subscription_details' not set")
        return self._value

    def get_paper_folder_deleted_details(self):
        """
        Only call this if :meth:`is_paper_folder_deleted_details` is true.

        :rtype: PaperFolderDeletedDetails
        """
        if not self.is_paper_folder_deleted_details():
            raise AttributeError("tag 'paper_folder_deleted_details' not set")
        return self._value

    def get_paper_folder_followed_details(self):
        """
        Only call this if :meth:`is_paper_folder_followed_details` is true.

        :rtype: PaperFolderFollowedDetails
        """
        if not self.is_paper_folder_followed_details():
            raise AttributeError("tag 'paper_folder_followed_details' not set")
        return self._value

    def get_paper_folder_team_invite_details(self):
        """
        Only call this if :meth:`is_paper_folder_team_invite_details` is true.

        :rtype: PaperFolderTeamInviteDetails
        """
        if not self.is_paper_folder_team_invite_details():
            raise AttributeError("tag 'paper_folder_team_invite_details' not set")
        return self._value

    def get_paper_published_link_change_permission_details(self):
        """
        Only call this if :meth:`is_paper_published_link_change_permission_details` is true.

        :rtype: PaperPublishedLinkChangePermissionDetails
        """
        if not self.is_paper_published_link_change_permission_details():
            raise AttributeError("tag 'paper_published_link_change_permission_details' not set")
        return self._value

    def get_paper_published_link_create_details(self):
        """
        Only call this if :meth:`is_paper_published_link_create_details` is true.

        :rtype: PaperPublishedLinkCreateDetails
        """
        if not self.is_paper_published_link_create_details():
            raise AttributeError("tag 'paper_published_link_create_details' not set")
        return self._value

    def get_paper_published_link_disabled_details(self):
        """
        Only call this if :meth:`is_paper_published_link_disabled_details` is true.

        :rtype: PaperPublishedLinkDisabledDetails
        """
        if not self.is_paper_published_link_disabled_details():
            raise AttributeError("tag 'paper_published_link_disabled_details' not set")
        return self._value

    def get_paper_published_link_view_details(self):
        """
        Only call this if :meth:`is_paper_published_link_view_details` is true.

        :rtype: PaperPublishedLinkViewDetails
        """
        if not self.is_paper_published_link_view_details():
            raise AttributeError("tag 'paper_published_link_view_details' not set")
        return self._value

    def get_password_change_details(self):
        """
        Only call this if :meth:`is_password_change_details` is true.

        :rtype: PasswordChangeDetails
        """
        if not self.is_password_change_details():
            raise AttributeError("tag 'password_change_details' not set")
        return self._value

    def get_password_reset_details(self):
        """
        Only call this if :meth:`is_password_reset_details` is true.

        :rtype: PasswordResetDetails
        """
        if not self.is_password_reset_details():
            raise AttributeError("tag 'password_reset_details' not set")
        return self._value

    def get_password_reset_all_details(self):
        """
        Only call this if :meth:`is_password_reset_all_details` is true.

        :rtype: PasswordResetAllDetails
        """
        if not self.is_password_reset_all_details():
            raise AttributeError("tag 'password_reset_all_details' not set")
        return self._value

    def get_classification_create_report_details(self):
        """
        Only call this if :meth:`is_classification_create_report_details` is true.

        :rtype: ClassificationCreateReportDetails
        """
        if not self.is_classification_create_report_details():
            raise AttributeError("tag 'classification_create_report_details' not set")
        return self._value

    def get_classification_create_report_fail_details(self):
        """
        Only call this if :meth:`is_classification_create_report_fail_details` is true.

        :rtype: ClassificationCreateReportFailDetails
        """
        if not self.is_classification_create_report_fail_details():
            raise AttributeError("tag 'classification_create_report_fail_details' not set")
        return self._value

    def get_emm_create_exceptions_report_details(self):
        """
        Only call this if :meth:`is_emm_create_exceptions_report_details` is true.

        :rtype: EmmCreateExceptionsReportDetails
        """
        if not self.is_emm_create_exceptions_report_details():
            raise AttributeError("tag 'emm_create_exceptions_report_details' not set")
        return self._value

    def get_emm_create_usage_report_details(self):
        """
        Only call this if :meth:`is_emm_create_usage_report_details` is true.

        :rtype: EmmCreateUsageReportDetails
        """
        if not self.is_emm_create_usage_report_details():
            raise AttributeError("tag 'emm_create_usage_report_details' not set")
        return self._value

    def get_export_members_report_details(self):
        """
        Only call this if :meth:`is_export_members_report_details` is true.

        :rtype: ExportMembersReportDetails
        """
        if not self.is_export_members_report_details():
            raise AttributeError("tag 'export_members_report_details' not set")
        return self._value

    def get_export_members_report_fail_details(self):
        """
        Only call this if :meth:`is_export_members_report_fail_details` is true.

        :rtype: ExportMembersReportFailDetails
        """
        if not self.is_export_members_report_fail_details():
            raise AttributeError("tag 'export_members_report_fail_details' not set")
        return self._value

    def get_external_sharing_create_report_details(self):
        """
        Only call this if :meth:`is_external_sharing_create_report_details` is true.

        :rtype: ExternalSharingCreateReportDetails
        """
        if not self.is_external_sharing_create_report_details():
            raise AttributeError("tag 'external_sharing_create_report_details' not set")
        return self._value

    def get_external_sharing_report_failed_details(self):
        """
        Only call this if :meth:`is_external_sharing_report_failed_details` is true.

        :rtype: ExternalSharingReportFailedDetails
        """
        if not self.is_external_sharing_report_failed_details():
            raise AttributeError("tag 'external_sharing_report_failed_details' not set")
        return self._value

    def get_no_expiration_link_gen_create_report_details(self):
        """
        Only call this if :meth:`is_no_expiration_link_gen_create_report_details` is true.

        :rtype: NoExpirationLinkGenCreateReportDetails
        """
        if not self.is_no_expiration_link_gen_create_report_details():
            raise AttributeError("tag 'no_expiration_link_gen_create_report_details' not set")
        return self._value

    def get_no_expiration_link_gen_report_failed_details(self):
        """
        Only call this if :meth:`is_no_expiration_link_gen_report_failed_details` is true.

        :rtype: NoExpirationLinkGenReportFailedDetails
        """
        if not self.is_no_expiration_link_gen_report_failed_details():
            raise AttributeError("tag 'no_expiration_link_gen_report_failed_details' not set")
        return self._value

    def get_no_password_link_gen_create_report_details(self):
        """
        Only call this if :meth:`is_no_password_link_gen_create_report_details` is true.

        :rtype: NoPasswordLinkGenCreateReportDetails
        """
        if not self.is_no_password_link_gen_create_report_details():
            raise AttributeError("tag 'no_password_link_gen_create_report_details' not set")
        return self._value

    def get_no_password_link_gen_report_failed_details(self):
        """
        Only call this if :meth:`is_no_password_link_gen_report_failed_details` is true.

        :rtype: NoPasswordLinkGenReportFailedDetails
        """
        if not self.is_no_password_link_gen_report_failed_details():
            raise AttributeError("tag 'no_password_link_gen_report_failed_details' not set")
        return self._value

    def get_no_password_link_view_create_report_details(self):
        """
        Only call this if :meth:`is_no_password_link_view_create_report_details` is true.

        :rtype: NoPasswordLinkViewCreateReportDetails
        """
        if not self.is_no_password_link_view_create_report_details():
            raise AttributeError("tag 'no_password_link_view_create_report_details' not set")
        return self._value

    def get_no_password_link_view_report_failed_details(self):
        """
        Only call this if :meth:`is_no_password_link_view_report_failed_details` is true.

        :rtype: NoPasswordLinkViewReportFailedDetails
        """
        if not self.is_no_password_link_view_report_failed_details():
            raise AttributeError("tag 'no_password_link_view_report_failed_details' not set")
        return self._value

    def get_outdated_link_view_create_report_details(self):
        """
        Only call this if :meth:`is_outdated_link_view_create_report_details` is true.

        :rtype: OutdatedLinkViewCreateReportDetails
        """
        if not self.is_outdated_link_view_create_report_details():
            raise AttributeError("tag 'outdated_link_view_create_report_details' not set")
        return self._value

    def get_outdated_link_view_report_failed_details(self):
        """
        Only call this if :meth:`is_outdated_link_view_report_failed_details` is true.

        :rtype: OutdatedLinkViewReportFailedDetails
        """
        if not self.is_outdated_link_view_report_failed_details():
            raise AttributeError("tag 'outdated_link_view_report_failed_details' not set")
        return self._value

    def get_paper_admin_export_start_details(self):
        """
        Only call this if :meth:`is_paper_admin_export_start_details` is true.

        :rtype: PaperAdminExportStartDetails
        """
        if not self.is_paper_admin_export_start_details():
            raise AttributeError("tag 'paper_admin_export_start_details' not set")
        return self._value

    def get_smart_sync_create_admin_privilege_report_details(self):
        """
        Only call this if :meth:`is_smart_sync_create_admin_privilege_report_details` is true.

        :rtype: SmartSyncCreateAdminPrivilegeReportDetails
        """
        if not self.is_smart_sync_create_admin_privilege_report_details():
            raise AttributeError("tag 'smart_sync_create_admin_privilege_report_details' not set")
        return self._value

    def get_team_activity_create_report_details(self):
        """
        Only call this if :meth:`is_team_activity_create_report_details` is true.

        :rtype: TeamActivityCreateReportDetails
        """
        if not self.is_team_activity_create_report_details():
            raise AttributeError("tag 'team_activity_create_report_details' not set")
        return self._value

    def get_team_activity_create_report_fail_details(self):
        """
        Only call this if :meth:`is_team_activity_create_report_fail_details` is true.

        :rtype: TeamActivityCreateReportFailDetails
        """
        if not self.is_team_activity_create_report_fail_details():
            raise AttributeError("tag 'team_activity_create_report_fail_details' not set")
        return self._value

    def get_collection_share_details(self):
        """
        Only call this if :meth:`is_collection_share_details` is true.

        :rtype: CollectionShareDetails
        """
        if not self.is_collection_share_details():
            raise AttributeError("tag 'collection_share_details' not set")
        return self._value

    def get_file_transfers_file_add_details(self):
        """
        Only call this if :meth:`is_file_transfers_file_add_details` is true.

        :rtype: FileTransfersFileAddDetails
        """
        if not self.is_file_transfers_file_add_details():
            raise AttributeError("tag 'file_transfers_file_add_details' not set")
        return self._value

    def get_file_transfers_transfer_delete_details(self):
        """
        Only call this if :meth:`is_file_transfers_transfer_delete_details` is true.

        :rtype: FileTransfersTransferDeleteDetails
        """
        if not self.is_file_transfers_transfer_delete_details():
            raise AttributeError("tag 'file_transfers_transfer_delete_details' not set")
        return self._value

    def get_file_transfers_transfer_download_details(self):
        """
        Only call this if :meth:`is_file_transfers_transfer_download_details` is true.

        :rtype: FileTransfersTransferDownloadDetails
        """
        if not self.is_file_transfers_transfer_download_details():
            raise AttributeError("tag 'file_transfers_transfer_download_details' not set")
        return self._value

    def get_file_transfers_transfer_send_details(self):
        """
        Only call this if :meth:`is_file_transfers_transfer_send_details` is true.

        :rtype: FileTransfersTransferSendDetails
        """
        if not self.is_file_transfers_transfer_send_details():
            raise AttributeError("tag 'file_transfers_transfer_send_details' not set")
        return self._value

    def get_file_transfers_transfer_view_details(self):
        """
        Only call this if :meth:`is_file_transfers_transfer_view_details` is true.

        :rtype: FileTransfersTransferViewDetails
        """
        if not self.is_file_transfers_transfer_view_details():
            raise AttributeError("tag 'file_transfers_transfer_view_details' not set")
        return self._value

    def get_note_acl_invite_only_details(self):
        """
        Only call this if :meth:`is_note_acl_invite_only_details` is true.

        :rtype: NoteAclInviteOnlyDetails
        """
        if not self.is_note_acl_invite_only_details():
            raise AttributeError("tag 'note_acl_invite_only_details' not set")
        return self._value

    def get_note_acl_link_details(self):
        """
        Only call this if :meth:`is_note_acl_link_details` is true.

        :rtype: NoteAclLinkDetails
        """
        if not self.is_note_acl_link_details():
            raise AttributeError("tag 'note_acl_link_details' not set")
        return self._value

    def get_note_acl_team_link_details(self):
        """
        Only call this if :meth:`is_note_acl_team_link_details` is true.

        :rtype: NoteAclTeamLinkDetails
        """
        if not self.is_note_acl_team_link_details():
            raise AttributeError("tag 'note_acl_team_link_details' not set")
        return self._value

    def get_note_shared_details(self):
        """
        Only call this if :meth:`is_note_shared_details` is true.

        :rtype: NoteSharedDetails
        """
        if not self.is_note_shared_details():
            raise AttributeError("tag 'note_shared_details' not set")
        return self._value

    def get_note_share_receive_details(self):
        """
        Only call this if :meth:`is_note_share_receive_details` is true.

        :rtype: NoteShareReceiveDetails
        """
        if not self.is_note_share_receive_details():
            raise AttributeError("tag 'note_share_receive_details' not set")
        return self._value

    def get_open_note_shared_details(self):
        """
        Only call this if :meth:`is_open_note_shared_details` is true.

        :rtype: OpenNoteSharedDetails
        """
        if not self.is_open_note_shared_details():
            raise AttributeError("tag 'open_note_shared_details' not set")
        return self._value

    def get_sf_add_group_details(self):
        """
        Only call this if :meth:`is_sf_add_group_details` is true.

        :rtype: SfAddGroupDetails
        """
        if not self.is_sf_add_group_details():
            raise AttributeError("tag 'sf_add_group_details' not set")
        return self._value

    def get_sf_allow_non_members_to_view_shared_links_details(self):
        """
        Only call this if :meth:`is_sf_allow_non_members_to_view_shared_links_details` is true.

        :rtype: SfAllowNonMembersToViewSharedLinksDetails
        """
        if not self.is_sf_allow_non_members_to_view_shared_links_details():
            raise AttributeError("tag 'sf_allow_non_members_to_view_shared_links_details' not set")
        return self._value

    def get_sf_external_invite_warn_details(self):
        """
        Only call this if :meth:`is_sf_external_invite_warn_details` is true.

        :rtype: SfExternalInviteWarnDetails
        """
        if not self.is_sf_external_invite_warn_details():
            raise AttributeError("tag 'sf_external_invite_warn_details' not set")
        return self._value

    def get_sf_fb_invite_details(self):
        """
        Only call this if :meth:`is_sf_fb_invite_details` is true.

        :rtype: SfFbInviteDetails
        """
        if not self.is_sf_fb_invite_details():
            raise AttributeError("tag 'sf_fb_invite_details' not set")
        return self._value

    def get_sf_fb_invite_change_role_details(self):
        """
        Only call this if :meth:`is_sf_fb_invite_change_role_details` is true.

        :rtype: SfFbInviteChangeRoleDetails
        """
        if not self.is_sf_fb_invite_change_role_details():
            raise AttributeError("tag 'sf_fb_invite_change_role_details' not set")
        return self._value

    def get_sf_fb_uninvite_details(self):
        """
        Only call this if :meth:`is_sf_fb_uninvite_details` is true.

        :rtype: SfFbUninviteDetails
        """
        if not self.is_sf_fb_uninvite_details():
            raise AttributeError("tag 'sf_fb_uninvite_details' not set")
        return self._value

    def get_sf_invite_group_details(self):
        """
        Only call this if :meth:`is_sf_invite_group_details` is true.

        :rtype: SfInviteGroupDetails
        """
        if not self.is_sf_invite_group_details():
            raise AttributeError("tag 'sf_invite_group_details' not set")
        return self._value

    def get_sf_team_grant_access_details(self):
        """
        Only call this if :meth:`is_sf_team_grant_access_details` is true.

        :rtype: SfTeamGrantAccessDetails
        """
        if not self.is_sf_team_grant_access_details():
            raise AttributeError("tag 'sf_team_grant_access_details' not set")
        return self._value

    def get_sf_team_invite_details(self):
        """
        Only call this if :meth:`is_sf_team_invite_details` is true.

        :rtype: SfTeamInviteDetails
        """
        if not self.is_sf_team_invite_details():
            raise AttributeError("tag 'sf_team_invite_details' not set")
        return self._value

    def get_sf_team_invite_change_role_details(self):
        """
        Only call this if :meth:`is_sf_team_invite_change_role_details` is true.

        :rtype: SfTeamInviteChangeRoleDetails
        """
        if not self.is_sf_team_invite_change_role_details():
            raise AttributeError("tag 'sf_team_invite_change_role_details' not set")
        return self._value

    def get_sf_team_join_details(self):
        """
        Only call this if :meth:`is_sf_team_join_details` is true.

        :rtype: SfTeamJoinDetails
        """
        if not self.is_sf_team_join_details():
            raise AttributeError("tag 'sf_team_join_details' not set")
        return self._value

    def get_sf_team_join_from_oob_link_details(self):
        """
        Only call this if :meth:`is_sf_team_join_from_oob_link_details` is true.

        :rtype: SfTeamJoinFromOobLinkDetails
        """
        if not self.is_sf_team_join_from_oob_link_details():
            raise AttributeError("tag 'sf_team_join_from_oob_link_details' not set")
        return self._value

    def get_sf_team_uninvite_details(self):
        """
        Only call this if :meth:`is_sf_team_uninvite_details` is true.

        :rtype: SfTeamUninviteDetails
        """
        if not self.is_sf_team_uninvite_details():
            raise AttributeError("tag 'sf_team_uninvite_details' not set")
        return self._value

    def get_shared_content_add_invitees_details(self):
        """
        Only call this if :meth:`is_shared_content_add_invitees_details` is true.

        :rtype: SharedContentAddInviteesDetails
        """
        if not self.is_shared_content_add_invitees_details():
            raise AttributeError("tag 'shared_content_add_invitees_details' not set")
        return self._value

    def get_shared_content_add_link_expiry_details(self):
        """
        Only call this if :meth:`is_shared_content_add_link_expiry_details` is true.

        :rtype: SharedContentAddLinkExpiryDetails
        """
        if not self.is_shared_content_add_link_expiry_details():
            raise AttributeError("tag 'shared_content_add_link_expiry_details' not set")
        return self._value

    def get_shared_content_add_link_password_details(self):
        """
        Only call this if :meth:`is_shared_content_add_link_password_details` is true.

        :rtype: SharedContentAddLinkPasswordDetails
        """
        if not self.is_shared_content_add_link_password_details():
            raise AttributeError("tag 'shared_content_add_link_password_details' not set")
        return self._value

    def get_shared_content_add_member_details(self):
        """
        Only call this if :meth:`is_shared_content_add_member_details` is true.

        :rtype: SharedContentAddMemberDetails
        """
        if not self.is_shared_content_add_member_details():
            raise AttributeError("tag 'shared_content_add_member_details' not set")
        return self._value

    def get_shared_content_change_downloads_policy_details(self):
        """
        Only call this if :meth:`is_shared_content_change_downloads_policy_details` is true.

        :rtype: SharedContentChangeDownloadsPolicyDetails
        """
        if not self.is_shared_content_change_downloads_policy_details():
            raise AttributeError("tag 'shared_content_change_downloads_policy_details' not set")
        return self._value

    def get_shared_content_change_invitee_role_details(self):
        """
        Only call this if :meth:`is_shared_content_change_invitee_role_details` is true.

        :rtype: SharedContentChangeInviteeRoleDetails
        """
        if not self.is_shared_content_change_invitee_role_details():
            raise AttributeError("tag 'shared_content_change_invitee_role_details' not set")
        return self._value

    def get_shared_content_change_link_audience_details(self):
        """
        Only call this if :meth:`is_shared_content_change_link_audience_details` is true.

        :rtype: SharedContentChangeLinkAudienceDetails
        """
        if not self.is_shared_content_change_link_audience_details():
            raise AttributeError("tag 'shared_content_change_link_audience_details' not set")
        return self._value

    def get_shared_content_change_link_expiry_details(self):
        """
        Only call this if :meth:`is_shared_content_change_link_expiry_details` is true.

        :rtype: SharedContentChangeLinkExpiryDetails
        """
        if not self.is_shared_content_change_link_expiry_details():
            raise AttributeError("tag 'shared_content_change_link_expiry_details' not set")
        return self._value

    def get_shared_content_change_link_password_details(self):
        """
        Only call this if :meth:`is_shared_content_change_link_password_details` is true.

        :rtype: SharedContentChangeLinkPasswordDetails
        """
        if not self.is_shared_content_change_link_password_details():
            raise AttributeError("tag 'shared_content_change_link_password_details' not set")
        return self._value

    def get_shared_content_change_member_role_details(self):
        """
        Only call this if :meth:`is_shared_content_change_member_role_details` is true.

        :rtype: SharedContentChangeMemberRoleDetails
        """
        if not self.is_shared_content_change_member_role_details():
            raise AttributeError("tag 'shared_content_change_member_role_details' not set")
        return self._value

    def get_shared_content_change_viewer_info_policy_details(self):
        """
        Only call this if :meth:`is_shared_content_change_viewer_info_policy_details` is true.

        :rtype: SharedContentChangeViewerInfoPolicyDetails
        """
        if not self.is_shared_content_change_viewer_info_policy_details():
            raise AttributeError("tag 'shared_content_change_viewer_info_policy_details' not set")
        return self._value

    def get_shared_content_claim_invitation_details(self):
        """
        Only call this if :meth:`is_shared_content_claim_invitation_details` is true.

        :rtype: SharedContentClaimInvitationDetails
        """
        if not self.is_shared_content_claim_invitation_details():
            raise AttributeError("tag 'shared_content_claim_invitation_details' not set")
        return self._value

    def get_shared_content_copy_details(self):
        """
        Only call this if :meth:`is_shared_content_copy_details` is true.

        :rtype: SharedContentCopyDetails
        """
        if not self.is_shared_content_copy_details():
            raise AttributeError("tag 'shared_content_copy_details' not set")
        return self._value

    def get_shared_content_download_details(self):
        """
        Only call this if :meth:`is_shared_content_download_details` is true.

        :rtype: SharedContentDownloadDetails
        """
        if not self.is_shared_content_download_details():
            raise AttributeError("tag 'shared_content_download_details' not set")
        return self._value

    def get_shared_content_relinquish_membership_details(self):
        """
        Only call this if :meth:`is_shared_content_relinquish_membership_details` is true.

        :rtype: SharedContentRelinquishMembershipDetails
        """
        if not self.is_shared_content_relinquish_membership_details():
            raise AttributeError("tag 'shared_content_relinquish_membership_details' not set")
        return self._value

    def get_shared_content_remove_invitees_details(self):
        """
        Only call this if :meth:`is_shared_content_remove_invitees_details` is true.

        :rtype: SharedContentRemoveInviteesDetails
        """
        if not self.is_shared_content_remove_invitees_details():
            raise AttributeError("tag 'shared_content_remove_invitees_details' not set")
        return self._value

    def get_shared_content_remove_link_expiry_details(self):
        """
        Only call this if :meth:`is_shared_content_remove_link_expiry_details` is true.

        :rtype: SharedContentRemoveLinkExpiryDetails
        """
        if not self.is_shared_content_remove_link_expiry_details():
            raise AttributeError("tag 'shared_content_remove_link_expiry_details' not set")
        return self._value

    def get_shared_content_remove_link_password_details(self):
        """
        Only call this if :meth:`is_shared_content_remove_link_password_details` is true.

        :rtype: SharedContentRemoveLinkPasswordDetails
        """
        if not self.is_shared_content_remove_link_password_details():
            raise AttributeError("tag 'shared_content_remove_link_password_details' not set")
        return self._value

    def get_shared_content_remove_member_details(self):
        """
        Only call this if :meth:`is_shared_content_remove_member_details` is true.

        :rtype: SharedContentRemoveMemberDetails
        """
        if not self.is_shared_content_remove_member_details():
            raise AttributeError("tag 'shared_content_remove_member_details' not set")
        return self._value

    def get_shared_content_request_access_details(self):
        """
        Only call this if :meth:`is_shared_content_request_access_details` is true.

        :rtype: SharedContentRequestAccessDetails
        """
        if not self.is_shared_content_request_access_details():
            raise AttributeError("tag 'shared_content_request_access_details' not set")
        return self._value

    def get_shared_content_restore_invitees_details(self):
        """
        Only call this if :meth:`is_shared_content_restore_invitees_details` is true.

        :rtype: SharedContentRestoreInviteesDetails
        """
        if not self.is_shared_content_restore_invitees_details():
            raise AttributeError("tag 'shared_content_restore_invitees_details' not set")
        return self._value

    def get_shared_content_restore_member_details(self):
        """
        Only call this if :meth:`is_shared_content_restore_member_details` is true.

        :rtype: SharedContentRestoreMemberDetails
        """
        if not self.is_shared_content_restore_member_details():
            raise AttributeError("tag 'shared_content_restore_member_details' not set")
        return self._value

    def get_shared_content_unshare_details(self):
        """
        Only call this if :meth:`is_shared_content_unshare_details` is true.

        :rtype: SharedContentUnshareDetails
        """
        if not self.is_shared_content_unshare_details():
            raise AttributeError("tag 'shared_content_unshare_details' not set")
        return self._value

    def get_shared_content_view_details(self):
        """
        Only call this if :meth:`is_shared_content_view_details` is true.

        :rtype: SharedContentViewDetails
        """
        if not self.is_shared_content_view_details():
            raise AttributeError("tag 'shared_content_view_details' not set")
        return self._value

    def get_shared_folder_change_link_policy_details(self):
        """
        Only call this if :meth:`is_shared_folder_change_link_policy_details` is true.

        :rtype: SharedFolderChangeLinkPolicyDetails
        """
        if not self.is_shared_folder_change_link_policy_details():
            raise AttributeError("tag 'shared_folder_change_link_policy_details' not set")
        return self._value

    def get_shared_folder_change_members_inheritance_policy_details(self):
        """
        Only call this if :meth:`is_shared_folder_change_members_inheritance_policy_details` is true.

        :rtype: SharedFolderChangeMembersInheritancePolicyDetails
        """
        if not self.is_shared_folder_change_members_inheritance_policy_details():
            raise AttributeError("tag 'shared_folder_change_members_inheritance_policy_details' not set")
        return self._value

    def get_shared_folder_change_members_management_policy_details(self):
        """
        Only call this if :meth:`is_shared_folder_change_members_management_policy_details` is true.

        :rtype: SharedFolderChangeMembersManagementPolicyDetails
        """
        if not self.is_shared_folder_change_members_management_policy_details():
            raise AttributeError("tag 'shared_folder_change_members_management_policy_details' not set")
        return self._value

    def get_shared_folder_change_members_policy_details(self):
        """
        Only call this if :meth:`is_shared_folder_change_members_policy_details` is true.

        :rtype: SharedFolderChangeMembersPolicyDetails
        """
        if not self.is_shared_folder_change_members_policy_details():
            raise AttributeError("tag 'shared_folder_change_members_policy_details' not set")
        return self._value

    def get_shared_folder_create_details(self):
        """
        Only call this if :meth:`is_shared_folder_create_details` is true.

        :rtype: SharedFolderCreateDetails
        """
        if not self.is_shared_folder_create_details():
            raise AttributeError("tag 'shared_folder_create_details' not set")
        return self._value

    def get_shared_folder_decline_invitation_details(self):
        """
        Only call this if :meth:`is_shared_folder_decline_invitation_details` is true.

        :rtype: SharedFolderDeclineInvitationDetails
        """
        if not self.is_shared_folder_decline_invitation_details():
            raise AttributeError("tag 'shared_folder_decline_invitation_details' not set")
        return self._value

    def get_shared_folder_mount_details(self):
        """
        Only call this if :meth:`is_shared_folder_mount_details` is true.

        :rtype: SharedFolderMountDetails
        """
        if not self.is_shared_folder_mount_details():
            raise AttributeError("tag 'shared_folder_mount_details' not set")
        return self._value

    def get_shared_folder_nest_details(self):
        """
        Only call this if :meth:`is_shared_folder_nest_details` is true.

        :rtype: SharedFolderNestDetails
        """
        if not self.is_shared_folder_nest_details():
            raise AttributeError("tag 'shared_folder_nest_details' not set")
        return self._value

    def get_shared_folder_transfer_ownership_details(self):
        """
        Only call this if :meth:`is_shared_folder_transfer_ownership_details` is true.

        :rtype: SharedFolderTransferOwnershipDetails
        """
        if not self.is_shared_folder_transfer_ownership_details():
            raise AttributeError("tag 'shared_folder_transfer_ownership_details' not set")
        return self._value

    def get_shared_folder_unmount_details(self):
        """
        Only call this if :meth:`is_shared_folder_unmount_details` is true.

        :rtype: SharedFolderUnmountDetails
        """
        if not self.is_shared_folder_unmount_details():
            raise AttributeError("tag 'shared_folder_unmount_details' not set")
        return self._value

    def get_shared_link_add_expiry_details(self):
        """
        Only call this if :meth:`is_shared_link_add_expiry_details` is true.

        :rtype: SharedLinkAddExpiryDetails
        """
        if not self.is_shared_link_add_expiry_details():
            raise AttributeError("tag 'shared_link_add_expiry_details' not set")
        return self._value

    def get_shared_link_change_expiry_details(self):
        """
        Only call this if :meth:`is_shared_link_change_expiry_details` is true.

        :rtype: SharedLinkChangeExpiryDetails
        """
        if not self.is_shared_link_change_expiry_details():
            raise AttributeError("tag 'shared_link_change_expiry_details' not set")
        return self._value

    def get_shared_link_change_visibility_details(self):
        """
        Only call this if :meth:`is_shared_link_change_visibility_details` is true.

        :rtype: SharedLinkChangeVisibilityDetails
        """
        if not self.is_shared_link_change_visibility_details():
            raise AttributeError("tag 'shared_link_change_visibility_details' not set")
        return self._value

    def get_shared_link_copy_details(self):
        """
        Only call this if :meth:`is_shared_link_copy_details` is true.

        :rtype: SharedLinkCopyDetails
        """
        if not self.is_shared_link_copy_details():
            raise AttributeError("tag 'shared_link_copy_details' not set")
        return self._value

    def get_shared_link_create_details(self):
        """
        Only call this if :meth:`is_shared_link_create_details` is true.

        :rtype: SharedLinkCreateDetails
        """
        if not self.is_shared_link_create_details():
            raise AttributeError("tag 'shared_link_create_details' not set")
        return self._value

    def get_shared_link_disable_details(self):
        """
        Only call this if :meth:`is_shared_link_disable_details` is true.

        :rtype: SharedLinkDisableDetails
        """
        if not self.is_shared_link_disable_details():
            raise AttributeError("tag 'shared_link_disable_details' not set")
        return self._value

    def get_shared_link_download_details(self):
        """
        Only call this if :meth:`is_shared_link_download_details` is true.

        :rtype: SharedLinkDownloadDetails
        """
        if not self.is_shared_link_download_details():
            raise AttributeError("tag 'shared_link_download_details' not set")
        return self._value

    def get_shared_link_remove_expiry_details(self):
        """
        Only call this if :meth:`is_shared_link_remove_expiry_details` is true.

        :rtype: SharedLinkRemoveExpiryDetails
        """
        if not self.is_shared_link_remove_expiry_details():
            raise AttributeError("tag 'shared_link_remove_expiry_details' not set")
        return self._value

    def get_shared_link_settings_add_expiration_details(self):
        """
        Only call this if :meth:`is_shared_link_settings_add_expiration_details` is true.

        :rtype: SharedLinkSettingsAddExpirationDetails
        """
        if not self.is_shared_link_settings_add_expiration_details():
            raise AttributeError("tag 'shared_link_settings_add_expiration_details' not set")
        return self._value

    def get_shared_link_settings_add_password_details(self):
        """
        Only call this if :meth:`is_shared_link_settings_add_password_details` is true.

        :rtype: SharedLinkSettingsAddPasswordDetails
        """
        if not self.is_shared_link_settings_add_password_details():
            raise AttributeError("tag 'shared_link_settings_add_password_details' not set")
        return self._value

    def get_shared_link_settings_allow_download_disabled_details(self):
        """
        Only call this if :meth:`is_shared_link_settings_allow_download_disabled_details` is true.

        :rtype: SharedLinkSettingsAllowDownloadDisabledDetails
        """
        if not self.is_shared_link_settings_allow_download_disabled_details():
            raise AttributeError("tag 'shared_link_settings_allow_download_disabled_details' not set")
        return self._value

    def get_shared_link_settings_allow_download_enabled_details(self):
        """
        Only call this if :meth:`is_shared_link_settings_allow_download_enabled_details` is true.

        :rtype: SharedLinkSettingsAllowDownloadEnabledDetails
        """
        if not self.is_shared_link_settings_allow_download_enabled_details():
            raise AttributeError("tag 'shared_link_settings_allow_download_enabled_details' not set")
        return self._value

    def get_shared_link_settings_change_audience_details(self):
        """
        Only call this if :meth:`is_shared_link_settings_change_audience_details` is true.

        :rtype: SharedLinkSettingsChangeAudienceDetails
        """
        if not self.is_shared_link_settings_change_audience_details():
            raise AttributeError("tag 'shared_link_settings_change_audience_details' not set")
        return self._value

    def get_shared_link_settings_change_expiration_details(self):
        """
        Only call this if :meth:`is_shared_link_settings_change_expiration_details` is true.

        :rtype: SharedLinkSettingsChangeExpirationDetails
        """
        if not self.is_shared_link_settings_change_expiration_details():
            raise AttributeError("tag 'shared_link_settings_change_expiration_details' not set")
        return self._value

    def get_shared_link_settings_change_password_details(self):
        """
        Only call this if :meth:`is_shared_link_settings_change_password_details` is true.

        :rtype: SharedLinkSettingsChangePasswordDetails
        """
        if not self.is_shared_link_settings_change_password_details():
            raise AttributeError("tag 'shared_link_settings_change_password_details' not set")
        return self._value

    def get_shared_link_settings_remove_expiration_details(self):
        """
        Only call this if :meth:`is_shared_link_settings_remove_expiration_details` is true.

        :rtype: SharedLinkSettingsRemoveExpirationDetails
        """
        if not self.is_shared_link_settings_remove_expiration_details():
            raise AttributeError("tag 'shared_link_settings_remove_expiration_details' not set")
        return self._value

    def get_shared_link_settings_remove_password_details(self):
        """
        Only call this if :meth:`is_shared_link_settings_remove_password_details` is true.

        :rtype: SharedLinkSettingsRemovePasswordDetails
        """
        if not self.is_shared_link_settings_remove_password_details():
            raise AttributeError("tag 'shared_link_settings_remove_password_details' not set")
        return self._value

    def get_shared_link_share_details(self):
        """
        Only call this if :meth:`is_shared_link_share_details` is true.

        :rtype: SharedLinkShareDetails
        """
        if not self.is_shared_link_share_details():
            raise AttributeError("tag 'shared_link_share_details' not set")
        return self._value

    def get_shared_link_view_details(self):
        """
        Only call this if :meth:`is_shared_link_view_details` is true.

        :rtype: SharedLinkViewDetails
        """
        if not self.is_shared_link_view_details():
            raise AttributeError("tag 'shared_link_view_details' not set")
        return self._value

    def get_shared_note_opened_details(self):
        """
        Only call this if :meth:`is_shared_note_opened_details` is true.

        :rtype: SharedNoteOpenedDetails
        """
        if not self.is_shared_note_opened_details():
            raise AttributeError("tag 'shared_note_opened_details' not set")
        return self._value

    def get_shmodel_disable_downloads_details(self):
        """
        Only call this if :meth:`is_shmodel_disable_downloads_details` is true.

        :rtype: ShmodelDisableDownloadsDetails
        """
        if not self.is_shmodel_disable_downloads_details():
            raise AttributeError("tag 'shmodel_disable_downloads_details' not set")
        return self._value

    def get_shmodel_enable_downloads_details(self):
        """
        Only call this if :meth:`is_shmodel_enable_downloads_details` is true.

        :rtype: ShmodelEnableDownloadsDetails
        """
        if not self.is_shmodel_enable_downloads_details():
            raise AttributeError("tag 'shmodel_enable_downloads_details' not set")
        return self._value

    def get_shmodel_group_share_details(self):
        """
        Only call this if :meth:`is_shmodel_group_share_details` is true.

        :rtype: ShmodelGroupShareDetails
        """
        if not self.is_shmodel_group_share_details():
            raise AttributeError("tag 'shmodel_group_share_details' not set")
        return self._value

    def get_showcase_access_granted_details(self):
        """
        Only call this if :meth:`is_showcase_access_granted_details` is true.

        :rtype: ShowcaseAccessGrantedDetails
        """
        if not self.is_showcase_access_granted_details():
            raise AttributeError("tag 'showcase_access_granted_details' not set")
        return self._value

    def get_showcase_add_member_details(self):
        """
        Only call this if :meth:`is_showcase_add_member_details` is true.

        :rtype: ShowcaseAddMemberDetails
        """
        if not self.is_showcase_add_member_details():
            raise AttributeError("tag 'showcase_add_member_details' not set")
        return self._value

    def get_showcase_archived_details(self):
        """
        Only call this if :meth:`is_showcase_archived_details` is true.

        :rtype: ShowcaseArchivedDetails
        """
        if not self.is_showcase_archived_details():
            raise AttributeError("tag 'showcase_archived_details' not set")
        return self._value

    def get_showcase_created_details(self):
        """
        Only call this if :meth:`is_showcase_created_details` is true.

        :rtype: ShowcaseCreatedDetails
        """
        if not self.is_showcase_created_details():
            raise AttributeError("tag 'showcase_created_details' not set")
        return self._value

    def get_showcase_delete_comment_details(self):
        """
        Only call this if :meth:`is_showcase_delete_comment_details` is true.

        :rtype: ShowcaseDeleteCommentDetails
        """
        if not self.is_showcase_delete_comment_details():
            raise AttributeError("tag 'showcase_delete_comment_details' not set")
        return self._value

    def get_showcase_edited_details(self):
        """
        Only call this if :meth:`is_showcase_edited_details` is true.

        :rtype: ShowcaseEditedDetails
        """
        if not self.is_showcase_edited_details():
            raise AttributeError("tag 'showcase_edited_details' not set")
        return self._value

    def get_showcase_edit_comment_details(self):
        """
        Only call this if :meth:`is_showcase_edit_comment_details` is true.

        :rtype: ShowcaseEditCommentDetails
        """
        if not self.is_showcase_edit_comment_details():
            raise AttributeError("tag 'showcase_edit_comment_details' not set")
        return self._value

    def get_showcase_file_added_details(self):
        """
        Only call this if :meth:`is_showcase_file_added_details` is true.

        :rtype: ShowcaseFileAddedDetails
        """
        if not self.is_showcase_file_added_details():
            raise AttributeError("tag 'showcase_file_added_details' not set")
        return self._value

    def get_showcase_file_download_details(self):
        """
        Only call this if :meth:`is_showcase_file_download_details` is true.

        :rtype: ShowcaseFileDownloadDetails
        """
        if not self.is_showcase_file_download_details():
            raise AttributeError("tag 'showcase_file_download_details' not set")
        return self._value

    def get_showcase_file_removed_details(self):
        """
        Only call this if :meth:`is_showcase_file_removed_details` is true.

        :rtype: ShowcaseFileRemovedDetails
        """
        if not self.is_showcase_file_removed_details():
            raise AttributeError("tag 'showcase_file_removed_details' not set")
        return self._value

    def get_showcase_file_view_details(self):
        """
        Only call this if :meth:`is_showcase_file_view_details` is true.

        :rtype: ShowcaseFileViewDetails
        """
        if not self.is_showcase_file_view_details():
            raise AttributeError("tag 'showcase_file_view_details' not set")
        return self._value

    def get_showcase_permanently_deleted_details(self):
        """
        Only call this if :meth:`is_showcase_permanently_deleted_details` is true.

        :rtype: ShowcasePermanentlyDeletedDetails
        """
        if not self.is_showcase_permanently_deleted_details():
            raise AttributeError("tag 'showcase_permanently_deleted_details' not set")
        return self._value

    def get_showcase_post_comment_details(self):
        """
        Only call this if :meth:`is_showcase_post_comment_details` is true.

        :rtype: ShowcasePostCommentDetails
        """
        if not self.is_showcase_post_comment_details():
            raise AttributeError("tag 'showcase_post_comment_details' not set")
        return self._value

    def get_showcase_remove_member_details(self):
        """
        Only call this if :meth:`is_showcase_remove_member_details` is true.

        :rtype: ShowcaseRemoveMemberDetails
        """
        if not self.is_showcase_remove_member_details():
            raise AttributeError("tag 'showcase_remove_member_details' not set")
        return self._value

    def get_showcase_renamed_details(self):
        """
        Only call this if :meth:`is_showcase_renamed_details` is true.

        :rtype: ShowcaseRenamedDetails
        """
        if not self.is_showcase_renamed_details():
            raise AttributeError("tag 'showcase_renamed_details' not set")
        return self._value

    def get_showcase_request_access_details(self):
        """
        Only call this if :meth:`is_showcase_request_access_details` is true.

        :rtype: ShowcaseRequestAccessDetails
        """
        if not self.is_showcase_request_access_details():
            raise AttributeError("tag 'showcase_request_access_details' not set")
        return self._value

    def get_showcase_resolve_comment_details(self):
        """
        Only call this if :meth:`is_showcase_resolve_comment_details` is true.

        :rtype: ShowcaseResolveCommentDetails
        """
        if not self.is_showcase_resolve_comment_details():
            raise AttributeError("tag 'showcase_resolve_comment_details' not set")
        return self._value

    def get_showcase_restored_details(self):
        """
        Only call this if :meth:`is_showcase_restored_details` is true.

        :rtype: ShowcaseRestoredDetails
        """
        if not self.is_showcase_restored_details():
            raise AttributeError("tag 'showcase_restored_details' not set")
        return self._value

    def get_showcase_trashed_details(self):
        """
        Only call this if :meth:`is_showcase_trashed_details` is true.

        :rtype: ShowcaseTrashedDetails
        """
        if not self.is_showcase_trashed_details():
            raise AttributeError("tag 'showcase_trashed_details' not set")
        return self._value

    def get_showcase_trashed_deprecated_details(self):
        """
        Only call this if :meth:`is_showcase_trashed_deprecated_details` is true.

        :rtype: ShowcaseTrashedDeprecatedDetails
        """
        if not self.is_showcase_trashed_deprecated_details():
            raise AttributeError("tag 'showcase_trashed_deprecated_details' not set")
        return self._value

    def get_showcase_unresolve_comment_details(self):
        """
        Only call this if :meth:`is_showcase_unresolve_comment_details` is true.

        :rtype: ShowcaseUnresolveCommentDetails
        """
        if not self.is_showcase_unresolve_comment_details():
            raise AttributeError("tag 'showcase_unresolve_comment_details' not set")
        return self._value

    def get_showcase_untrashed_details(self):
        """
        Only call this if :meth:`is_showcase_untrashed_details` is true.

        :rtype: ShowcaseUntrashedDetails
        """
        if not self.is_showcase_untrashed_details():
            raise AttributeError("tag 'showcase_untrashed_details' not set")
        return self._value

    def get_showcase_untrashed_deprecated_details(self):
        """
        Only call this if :meth:`is_showcase_untrashed_deprecated_details` is true.

        :rtype: ShowcaseUntrashedDeprecatedDetails
        """
        if not self.is_showcase_untrashed_deprecated_details():
            raise AttributeError("tag 'showcase_untrashed_deprecated_details' not set")
        return self._value

    def get_showcase_view_details(self):
        """
        Only call this if :meth:`is_showcase_view_details` is true.

        :rtype: ShowcaseViewDetails
        """
        if not self.is_showcase_view_details():
            raise AttributeError("tag 'showcase_view_details' not set")
        return self._value

    def get_sso_add_cert_details(self):
        """
        Only call this if :meth:`is_sso_add_cert_details` is true.

        :rtype: SsoAddCertDetails
        """
        if not self.is_sso_add_cert_details():
            raise AttributeError("tag 'sso_add_cert_details' not set")
        return self._value

    def get_sso_add_login_url_details(self):
        """
        Only call this if :meth:`is_sso_add_login_url_details` is true.

        :rtype: SsoAddLoginUrlDetails
        """
        if not self.is_sso_add_login_url_details():
            raise AttributeError("tag 'sso_add_login_url_details' not set")
        return self._value

    def get_sso_add_logout_url_details(self):
        """
        Only call this if :meth:`is_sso_add_logout_url_details` is true.

        :rtype: SsoAddLogoutUrlDetails
        """
        if not self.is_sso_add_logout_url_details():
            raise AttributeError("tag 'sso_add_logout_url_details' not set")
        return self._value

    def get_sso_change_cert_details(self):
        """
        Only call this if :meth:`is_sso_change_cert_details` is true.

        :rtype: SsoChangeCertDetails
        """
        if not self.is_sso_change_cert_details():
            raise AttributeError("tag 'sso_change_cert_details' not set")
        return self._value

    def get_sso_change_login_url_details(self):
        """
        Only call this if :meth:`is_sso_change_login_url_details` is true.

        :rtype: SsoChangeLoginUrlDetails
        """
        if not self.is_sso_change_login_url_details():
            raise AttributeError("tag 'sso_change_login_url_details' not set")
        return self._value

    def get_sso_change_logout_url_details(self):
        """
        Only call this if :meth:`is_sso_change_logout_url_details` is true.

        :rtype: SsoChangeLogoutUrlDetails
        """
        if not self.is_sso_change_logout_url_details():
            raise AttributeError("tag 'sso_change_logout_url_details' not set")
        return self._value

    def get_sso_change_saml_identity_mode_details(self):
        """
        Only call this if :meth:`is_sso_change_saml_identity_mode_details` is true.

        :rtype: SsoChangeSamlIdentityModeDetails
        """
        if not self.is_sso_change_saml_identity_mode_details():
            raise AttributeError("tag 'sso_change_saml_identity_mode_details' not set")
        return self._value

    def get_sso_remove_cert_details(self):
        """
        Only call this if :meth:`is_sso_remove_cert_details` is true.

        :rtype: SsoRemoveCertDetails
        """
        if not self.is_sso_remove_cert_details():
            raise AttributeError("tag 'sso_remove_cert_details' not set")
        return self._value

    def get_sso_remove_login_url_details(self):
        """
        Only call this if :meth:`is_sso_remove_login_url_details` is true.

        :rtype: SsoRemoveLoginUrlDetails
        """
        if not self.is_sso_remove_login_url_details():
            raise AttributeError("tag 'sso_remove_login_url_details' not set")
        return self._value

    def get_sso_remove_logout_url_details(self):
        """
        Only call this if :meth:`is_sso_remove_logout_url_details` is true.

        :rtype: SsoRemoveLogoutUrlDetails
        """
        if not self.is_sso_remove_logout_url_details():
            raise AttributeError("tag 'sso_remove_logout_url_details' not set")
        return self._value

    def get_team_folder_change_status_details(self):
        """
        Only call this if :meth:`is_team_folder_change_status_details` is true.

        :rtype: TeamFolderChangeStatusDetails
        """
        if not self.is_team_folder_change_status_details():
            raise AttributeError("tag 'team_folder_change_status_details' not set")
        return self._value

    def get_team_folder_create_details(self):
        """
        Only call this if :meth:`is_team_folder_create_details` is true.

        :rtype: TeamFolderCreateDetails
        """
        if not self.is_team_folder_create_details():
            raise AttributeError("tag 'team_folder_create_details' not set")
        return self._value

    def get_team_folder_downgrade_details(self):
        """
        Only call this if :meth:`is_team_folder_downgrade_details` is true.

        :rtype: TeamFolderDowngradeDetails
        """
        if not self.is_team_folder_downgrade_details():
            raise AttributeError("tag 'team_folder_downgrade_details' not set")
        return self._value

    def get_team_folder_permanently_delete_details(self):
        """
        Only call this if :meth:`is_team_folder_permanently_delete_details` is true.

        :rtype: TeamFolderPermanentlyDeleteDetails
        """
        if not self.is_team_folder_permanently_delete_details():
            raise AttributeError("tag 'team_folder_permanently_delete_details' not set")
        return self._value

    def get_team_folder_rename_details(self):
        """
        Only call this if :meth:`is_team_folder_rename_details` is true.

        :rtype: TeamFolderRenameDetails
        """
        if not self.is_team_folder_rename_details():
            raise AttributeError("tag 'team_folder_rename_details' not set")
        return self._value

    def get_team_selective_sync_settings_changed_details(self):
        """
        Only call this if :meth:`is_team_selective_sync_settings_changed_details` is true.

        :rtype: TeamSelectiveSyncSettingsChangedDetails
        """
        if not self.is_team_selective_sync_settings_changed_details():
            raise AttributeError("tag 'team_selective_sync_settings_changed_details' not set")
        return self._value

    def get_account_capture_change_policy_details(self):
        """
        Only call this if :meth:`is_account_capture_change_policy_details` is true.

        :rtype: AccountCaptureChangePolicyDetails
        """
        if not self.is_account_capture_change_policy_details():
            raise AttributeError("tag 'account_capture_change_policy_details' not set")
        return self._value

    def get_allow_download_disabled_details(self):
        """
        Only call this if :meth:`is_allow_download_disabled_details` is true.

        :rtype: AllowDownloadDisabledDetails
        """
        if not self.is_allow_download_disabled_details():
            raise AttributeError("tag 'allow_download_disabled_details' not set")
        return self._value

    def get_allow_download_enabled_details(self):
        """
        Only call this if :meth:`is_allow_download_enabled_details` is true.

        :rtype: AllowDownloadEnabledDetails
        """
        if not self.is_allow_download_enabled_details():
            raise AttributeError("tag 'allow_download_enabled_details' not set")
        return self._value

    def get_app_permissions_changed_details(self):
        """
        Only call this if :meth:`is_app_permissions_changed_details` is true.

        :rtype: AppPermissionsChangedDetails
        """
        if not self.is_app_permissions_changed_details():
            raise AttributeError("tag 'app_permissions_changed_details' not set")
        return self._value

    def get_camera_uploads_policy_changed_details(self):
        """
        Only call this if :meth:`is_camera_uploads_policy_changed_details` is true.

        :rtype: CameraUploadsPolicyChangedDetails
        """
        if not self.is_camera_uploads_policy_changed_details():
            raise AttributeError("tag 'camera_uploads_policy_changed_details' not set")
        return self._value

    def get_capture_transcript_policy_changed_details(self):
        """
        Only call this if :meth:`is_capture_transcript_policy_changed_details` is true.

        :rtype: CaptureTranscriptPolicyChangedDetails
        """
        if not self.is_capture_transcript_policy_changed_details():
            raise AttributeError("tag 'capture_transcript_policy_changed_details' not set")
        return self._value

    def get_classification_change_policy_details(self):
        """
        Only call this if :meth:`is_classification_change_policy_details` is true.

        :rtype: ClassificationChangePolicyDetails
        """
        if not self.is_classification_change_policy_details():
            raise AttributeError("tag 'classification_change_policy_details' not set")
        return self._value

    def get_computer_backup_policy_changed_details(self):
        """
        Only call this if :meth:`is_computer_backup_policy_changed_details` is true.

        :rtype: ComputerBackupPolicyChangedDetails
        """
        if not self.is_computer_backup_policy_changed_details():
            raise AttributeError("tag 'computer_backup_policy_changed_details' not set")
        return self._value

    def get_content_administration_policy_changed_details(self):
        """
        Only call this if :meth:`is_content_administration_policy_changed_details` is true.

        :rtype: ContentAdministrationPolicyChangedDetails
        """
        if not self.is_content_administration_policy_changed_details():
            raise AttributeError("tag 'content_administration_policy_changed_details' not set")
        return self._value

    def get_data_placement_restriction_change_policy_details(self):
        """
        Only call this if :meth:`is_data_placement_restriction_change_policy_details` is true.

        :rtype: DataPlacementRestrictionChangePolicyDetails
        """
        if not self.is_data_placement_restriction_change_policy_details():
            raise AttributeError("tag 'data_placement_restriction_change_policy_details' not set")
        return self._value

    def get_data_placement_restriction_satisfy_policy_details(self):
        """
        Only call this if :meth:`is_data_placement_restriction_satisfy_policy_details` is true.

        :rtype: DataPlacementRestrictionSatisfyPolicyDetails
        """
        if not self.is_data_placement_restriction_satisfy_policy_details():
            raise AttributeError("tag 'data_placement_restriction_satisfy_policy_details' not set")
        return self._value

    def get_device_approvals_add_exception_details(self):
        """
        Only call this if :meth:`is_device_approvals_add_exception_details` is true.

        :rtype: DeviceApprovalsAddExceptionDetails
        """
        if not self.is_device_approvals_add_exception_details():
            raise AttributeError("tag 'device_approvals_add_exception_details' not set")
        return self._value

    def get_device_approvals_change_desktop_policy_details(self):
        """
        Only call this if :meth:`is_device_approvals_change_desktop_policy_details` is true.

        :rtype: DeviceApprovalsChangeDesktopPolicyDetails
        """
        if not self.is_device_approvals_change_desktop_policy_details():
            raise AttributeError("tag 'device_approvals_change_desktop_policy_details' not set")
        return self._value

    def get_device_approvals_change_mobile_policy_details(self):
        """
        Only call this if :meth:`is_device_approvals_change_mobile_policy_details` is true.

        :rtype: DeviceApprovalsChangeMobilePolicyDetails
        """
        if not self.is_device_approvals_change_mobile_policy_details():
            raise AttributeError("tag 'device_approvals_change_mobile_policy_details' not set")
        return self._value

    def get_device_approvals_change_overage_action_details(self):
        """
        Only call this if :meth:`is_device_approvals_change_overage_action_details` is true.

        :rtype: DeviceApprovalsChangeOverageActionDetails
        """
        if not self.is_device_approvals_change_overage_action_details():
            raise AttributeError("tag 'device_approvals_change_overage_action_details' not set")
        return self._value

    def get_device_approvals_change_unlink_action_details(self):
        """
        Only call this if :meth:`is_device_approvals_change_unlink_action_details` is true.

        :rtype: DeviceApprovalsChangeUnlinkActionDetails
        """
        if not self.is_device_approvals_change_unlink_action_details():
            raise AttributeError("tag 'device_approvals_change_unlink_action_details' not set")
        return self._value

    def get_device_approvals_remove_exception_details(self):
        """
        Only call this if :meth:`is_device_approvals_remove_exception_details` is true.

        :rtype: DeviceApprovalsRemoveExceptionDetails
        """
        if not self.is_device_approvals_remove_exception_details():
            raise AttributeError("tag 'device_approvals_remove_exception_details' not set")
        return self._value

    def get_directory_restrictions_add_members_details(self):
        """
        Only call this if :meth:`is_directory_restrictions_add_members_details` is true.

        :rtype: DirectoryRestrictionsAddMembersDetails
        """
        if not self.is_directory_restrictions_add_members_details():
            raise AttributeError("tag 'directory_restrictions_add_members_details' not set")
        return self._value

    def get_directory_restrictions_remove_members_details(self):
        """
        Only call this if :meth:`is_directory_restrictions_remove_members_details` is true.

        :rtype: DirectoryRestrictionsRemoveMembersDetails
        """
        if not self.is_directory_restrictions_remove_members_details():
            raise AttributeError("tag 'directory_restrictions_remove_members_details' not set")
        return self._value

    def get_email_ingest_policy_changed_details(self):
        """
        Only call this if :meth:`is_email_ingest_policy_changed_details` is true.

        :rtype: EmailIngestPolicyChangedDetails
        """
        if not self.is_email_ingest_policy_changed_details():
            raise AttributeError("tag 'email_ingest_policy_changed_details' not set")
        return self._value

    def get_emm_add_exception_details(self):
        """
        Only call this if :meth:`is_emm_add_exception_details` is true.

        :rtype: EmmAddExceptionDetails
        """
        if not self.is_emm_add_exception_details():
            raise AttributeError("tag 'emm_add_exception_details' not set")
        return self._value

    def get_emm_change_policy_details(self):
        """
        Only call this if :meth:`is_emm_change_policy_details` is true.

        :rtype: EmmChangePolicyDetails
        """
        if not self.is_emm_change_policy_details():
            raise AttributeError("tag 'emm_change_policy_details' not set")
        return self._value

    def get_emm_remove_exception_details(self):
        """
        Only call this if :meth:`is_emm_remove_exception_details` is true.

        :rtype: EmmRemoveExceptionDetails
        """
        if not self.is_emm_remove_exception_details():
            raise AttributeError("tag 'emm_remove_exception_details' not set")
        return self._value

    def get_extended_version_history_change_policy_details(self):
        """
        Only call this if :meth:`is_extended_version_history_change_policy_details` is true.

        :rtype: ExtendedVersionHistoryChangePolicyDetails
        """
        if not self.is_extended_version_history_change_policy_details():
            raise AttributeError("tag 'extended_version_history_change_policy_details' not set")
        return self._value

    def get_external_drive_backup_policy_changed_details(self):
        """
        Only call this if :meth:`is_external_drive_backup_policy_changed_details` is true.

        :rtype: ExternalDriveBackupPolicyChangedDetails
        """
        if not self.is_external_drive_backup_policy_changed_details():
            raise AttributeError("tag 'external_drive_backup_policy_changed_details' not set")
        return self._value

    def get_file_comments_change_policy_details(self):
        """
        Only call this if :meth:`is_file_comments_change_policy_details` is true.

        :rtype: FileCommentsChangePolicyDetails
        """
        if not self.is_file_comments_change_policy_details():
            raise AttributeError("tag 'file_comments_change_policy_details' not set")
        return self._value

    def get_file_locking_policy_changed_details(self):
        """
        Only call this if :meth:`is_file_locking_policy_changed_details` is true.

        :rtype: FileLockingPolicyChangedDetails
        """
        if not self.is_file_locking_policy_changed_details():
            raise AttributeError("tag 'file_locking_policy_changed_details' not set")
        return self._value

    def get_file_requests_change_policy_details(self):
        """
        Only call this if :meth:`is_file_requests_change_policy_details` is true.

        :rtype: FileRequestsChangePolicyDetails
        """
        if not self.is_file_requests_change_policy_details():
            raise AttributeError("tag 'file_requests_change_policy_details' not set")
        return self._value

    def get_file_requests_emails_enabled_details(self):
        """
        Only call this if :meth:`is_file_requests_emails_enabled_details` is true.

        :rtype: FileRequestsEmailsEnabledDetails
        """
        if not self.is_file_requests_emails_enabled_details():
            raise AttributeError("tag 'file_requests_emails_enabled_details' not set")
        return self._value

    def get_file_requests_emails_restricted_to_team_only_details(self):
        """
        Only call this if :meth:`is_file_requests_emails_restricted_to_team_only_details` is true.

        :rtype: FileRequestsEmailsRestrictedToTeamOnlyDetails
        """
        if not self.is_file_requests_emails_restricted_to_team_only_details():
            raise AttributeError("tag 'file_requests_emails_restricted_to_team_only_details' not set")
        return self._value

    def get_file_transfers_policy_changed_details(self):
        """
        Only call this if :meth:`is_file_transfers_policy_changed_details` is true.

        :rtype: FileTransfersPolicyChangedDetails
        """
        if not self.is_file_transfers_policy_changed_details():
            raise AttributeError("tag 'file_transfers_policy_changed_details' not set")
        return self._value

    def get_google_sso_change_policy_details(self):
        """
        Only call this if :meth:`is_google_sso_change_policy_details` is true.

        :rtype: GoogleSsoChangePolicyDetails
        """
        if not self.is_google_sso_change_policy_details():
            raise AttributeError("tag 'google_sso_change_policy_details' not set")
        return self._value

    def get_group_user_management_change_policy_details(self):
        """
        Only call this if :meth:`is_group_user_management_change_policy_details` is true.

        :rtype: GroupUserManagementChangePolicyDetails
        """
        if not self.is_group_user_management_change_policy_details():
            raise AttributeError("tag 'group_user_management_change_policy_details' not set")
        return self._value

    def get_integration_policy_changed_details(self):
        """
        Only call this if :meth:`is_integration_policy_changed_details` is true.

        :rtype: IntegrationPolicyChangedDetails
        """
        if not self.is_integration_policy_changed_details():
            raise AttributeError("tag 'integration_policy_changed_details' not set")
        return self._value

    def get_invite_acceptance_email_policy_changed_details(self):
        """
        Only call this if :meth:`is_invite_acceptance_email_policy_changed_details` is true.

        :rtype: InviteAcceptanceEmailPolicyChangedDetails
        """
        if not self.is_invite_acceptance_email_policy_changed_details():
            raise AttributeError("tag 'invite_acceptance_email_policy_changed_details' not set")
        return self._value

    def get_member_requests_change_policy_details(self):
        """
        Only call this if :meth:`is_member_requests_change_policy_details` is true.

        :rtype: MemberRequestsChangePolicyDetails
        """
        if not self.is_member_requests_change_policy_details():
            raise AttributeError("tag 'member_requests_change_policy_details' not set")
        return self._value

    def get_member_send_invite_policy_changed_details(self):
        """
        Only call this if :meth:`is_member_send_invite_policy_changed_details` is true.

        :rtype: MemberSendInvitePolicyChangedDetails
        """
        if not self.is_member_send_invite_policy_changed_details():
            raise AttributeError("tag 'member_send_invite_policy_changed_details' not set")
        return self._value

    def get_member_space_limits_add_exception_details(self):
        """
        Only call this if :meth:`is_member_space_limits_add_exception_details` is true.

        :rtype: MemberSpaceLimitsAddExceptionDetails
        """
        if not self.is_member_space_limits_add_exception_details():
            raise AttributeError("tag 'member_space_limits_add_exception_details' not set")
        return self._value

    def get_member_space_limits_change_caps_type_policy_details(self):
        """
        Only call this if :meth:`is_member_space_limits_change_caps_type_policy_details` is true.

        :rtype: MemberSpaceLimitsChangeCapsTypePolicyDetails
        """
        if not self.is_member_space_limits_change_caps_type_policy_details():
            raise AttributeError("tag 'member_space_limits_change_caps_type_policy_details' not set")
        return self._value

    def get_member_space_limits_change_policy_details(self):
        """
        Only call this if :meth:`is_member_space_limits_change_policy_details` is true.

        :rtype: MemberSpaceLimitsChangePolicyDetails
        """
        if not self.is_member_space_limits_change_policy_details():
            raise AttributeError("tag 'member_space_limits_change_policy_details' not set")
        return self._value

    def get_member_space_limits_remove_exception_details(self):
        """
        Only call this if :meth:`is_member_space_limits_remove_exception_details` is true.

        :rtype: MemberSpaceLimitsRemoveExceptionDetails
        """
        if not self.is_member_space_limits_remove_exception_details():
            raise AttributeError("tag 'member_space_limits_remove_exception_details' not set")
        return self._value

    def get_member_suggestions_change_policy_details(self):
        """
        Only call this if :meth:`is_member_suggestions_change_policy_details` is true.

        :rtype: MemberSuggestionsChangePolicyDetails
        """
        if not self.is_member_suggestions_change_policy_details():
            raise AttributeError("tag 'member_suggestions_change_policy_details' not set")
        return self._value

    def get_microsoft_office_addin_change_policy_details(self):
        """
        Only call this if :meth:`is_microsoft_office_addin_change_policy_details` is true.

        :rtype: MicrosoftOfficeAddinChangePolicyDetails
        """
        if not self.is_microsoft_office_addin_change_policy_details():
            raise AttributeError("tag 'microsoft_office_addin_change_policy_details' not set")
        return self._value

    def get_network_control_change_policy_details(self):
        """
        Only call this if :meth:`is_network_control_change_policy_details` is true.

        :rtype: NetworkControlChangePolicyDetails
        """
        if not self.is_network_control_change_policy_details():
            raise AttributeError("tag 'network_control_change_policy_details' not set")
        return self._value

    def get_paper_change_deployment_policy_details(self):
        """
        Only call this if :meth:`is_paper_change_deployment_policy_details` is true.

        :rtype: PaperChangeDeploymentPolicyDetails
        """
        if not self.is_paper_change_deployment_policy_details():
            raise AttributeError("tag 'paper_change_deployment_policy_details' not set")
        return self._value

    def get_paper_change_member_link_policy_details(self):
        """
        Only call this if :meth:`is_paper_change_member_link_policy_details` is true.

        :rtype: PaperChangeMemberLinkPolicyDetails
        """
        if not self.is_paper_change_member_link_policy_details():
            raise AttributeError("tag 'paper_change_member_link_policy_details' not set")
        return self._value

    def get_paper_change_member_policy_details(self):
        """
        Only call this if :meth:`is_paper_change_member_policy_details` is true.

        :rtype: PaperChangeMemberPolicyDetails
        """
        if not self.is_paper_change_member_policy_details():
            raise AttributeError("tag 'paper_change_member_policy_details' not set")
        return self._value

    def get_paper_change_policy_details(self):
        """
        Only call this if :meth:`is_paper_change_policy_details` is true.

        :rtype: PaperChangePolicyDetails
        """
        if not self.is_paper_change_policy_details():
            raise AttributeError("tag 'paper_change_policy_details' not set")
        return self._value

    def get_paper_default_folder_policy_changed_details(self):
        """
        Only call this if :meth:`is_paper_default_folder_policy_changed_details` is true.

        :rtype: PaperDefaultFolderPolicyChangedDetails
        """
        if not self.is_paper_default_folder_policy_changed_details():
            raise AttributeError("tag 'paper_default_folder_policy_changed_details' not set")
        return self._value

    def get_paper_desktop_policy_changed_details(self):
        """
        Only call this if :meth:`is_paper_desktop_policy_changed_details` is true.

        :rtype: PaperDesktopPolicyChangedDetails
        """
        if not self.is_paper_desktop_policy_changed_details():
            raise AttributeError("tag 'paper_desktop_policy_changed_details' not set")
        return self._value

    def get_paper_enabled_users_group_addition_details(self):
        """
        Only call this if :meth:`is_paper_enabled_users_group_addition_details` is true.

        :rtype: PaperEnabledUsersGroupAdditionDetails
        """
        if not self.is_paper_enabled_users_group_addition_details():
            raise AttributeError("tag 'paper_enabled_users_group_addition_details' not set")
        return self._value

    def get_paper_enabled_users_group_removal_details(self):
        """
        Only call this if :meth:`is_paper_enabled_users_group_removal_details` is true.

        :rtype: PaperEnabledUsersGroupRemovalDetails
        """
        if not self.is_paper_enabled_users_group_removal_details():
            raise AttributeError("tag 'paper_enabled_users_group_removal_details' not set")
        return self._value

    def get_password_strength_requirements_change_policy_details(self):
        """
        Only call this if :meth:`is_password_strength_requirements_change_policy_details` is true.

        :rtype: PasswordStrengthRequirementsChangePolicyDetails
        """
        if not self.is_password_strength_requirements_change_policy_details():
            raise AttributeError("tag 'password_strength_requirements_change_policy_details' not set")
        return self._value

    def get_permanent_delete_change_policy_details(self):
        """
        Only call this if :meth:`is_permanent_delete_change_policy_details` is true.

        :rtype: PermanentDeleteChangePolicyDetails
        """
        if not self.is_permanent_delete_change_policy_details():
            raise AttributeError("tag 'permanent_delete_change_policy_details' not set")
        return self._value

    def get_reseller_support_change_policy_details(self):
        """
        Only call this if :meth:`is_reseller_support_change_policy_details` is true.

        :rtype: ResellerSupportChangePolicyDetails
        """
        if not self.is_reseller_support_change_policy_details():
            raise AttributeError("tag 'reseller_support_change_policy_details' not set")
        return self._value

    def get_rewind_policy_changed_details(self):
        """
        Only call this if :meth:`is_rewind_policy_changed_details` is true.

        :rtype: RewindPolicyChangedDetails
        """
        if not self.is_rewind_policy_changed_details():
            raise AttributeError("tag 'rewind_policy_changed_details' not set")
        return self._value

    def get_send_for_signature_policy_changed_details(self):
        """
        Only call this if :meth:`is_send_for_signature_policy_changed_details` is true.

        :rtype: SendForSignaturePolicyChangedDetails
        """
        if not self.is_send_for_signature_policy_changed_details():
            raise AttributeError("tag 'send_for_signature_policy_changed_details' not set")
        return self._value

    def get_sharing_change_folder_join_policy_details(self):
        """
        Only call this if :meth:`is_sharing_change_folder_join_policy_details` is true.

        :rtype: SharingChangeFolderJoinPolicyDetails
        """
        if not self.is_sharing_change_folder_join_policy_details():
            raise AttributeError("tag 'sharing_change_folder_join_policy_details' not set")
        return self._value

    def get_sharing_change_link_allow_change_expiration_policy_details(self):
        """
        Only call this if :meth:`is_sharing_change_link_allow_change_expiration_policy_details` is true.

        :rtype: SharingChangeLinkAllowChangeExpirationPolicyDetails
        """
        if not self.is_sharing_change_link_allow_change_expiration_policy_details():
            raise AttributeError("tag 'sharing_change_link_allow_change_expiration_policy_details' not set")
        return self._value

    def get_sharing_change_link_default_expiration_policy_details(self):
        """
        Only call this if :meth:`is_sharing_change_link_default_expiration_policy_details` is true.

        :rtype: SharingChangeLinkDefaultExpirationPolicyDetails
        """
        if not self.is_sharing_change_link_default_expiration_policy_details():
            raise AttributeError("tag 'sharing_change_link_default_expiration_policy_details' not set")
        return self._value

    def get_sharing_change_link_enforce_password_policy_details(self):
        """
        Only call this if :meth:`is_sharing_change_link_enforce_password_policy_details` is true.

        :rtype: SharingChangeLinkEnforcePasswordPolicyDetails
        """
        if not self.is_sharing_change_link_enforce_password_policy_details():
            raise AttributeError("tag 'sharing_change_link_enforce_password_policy_details' not set")
        return self._value

    def get_sharing_change_link_policy_details(self):
        """
        Only call this if :meth:`is_sharing_change_link_policy_details` is true.

        :rtype: SharingChangeLinkPolicyDetails
        """
        if not self.is_sharing_change_link_policy_details():
            raise AttributeError("tag 'sharing_change_link_policy_details' not set")
        return self._value

    def get_sharing_change_member_policy_details(self):
        """
        Only call this if :meth:`is_sharing_change_member_policy_details` is true.

        :rtype: SharingChangeMemberPolicyDetails
        """
        if not self.is_sharing_change_member_policy_details():
            raise AttributeError("tag 'sharing_change_member_policy_details' not set")
        return self._value

    def get_showcase_change_download_policy_details(self):
        """
        Only call this if :meth:`is_showcase_change_download_policy_details` is true.

        :rtype: ShowcaseChangeDownloadPolicyDetails
        """
        if not self.is_showcase_change_download_policy_details():
            raise AttributeError("tag 'showcase_change_download_policy_details' not set")
        return self._value

    def get_showcase_change_enabled_policy_details(self):
        """
        Only call this if :meth:`is_showcase_change_enabled_policy_details` is true.

        :rtype: ShowcaseChangeEnabledPolicyDetails
        """
        if not self.is_showcase_change_enabled_policy_details():
            raise AttributeError("tag 'showcase_change_enabled_policy_details' not set")
        return self._value

    def get_showcase_change_external_sharing_policy_details(self):
        """
        Only call this if :meth:`is_showcase_change_external_sharing_policy_details` is true.

        :rtype: ShowcaseChangeExternalSharingPolicyDetails
        """
        if not self.is_showcase_change_external_sharing_policy_details():
            raise AttributeError("tag 'showcase_change_external_sharing_policy_details' not set")
        return self._value

    def get_smarter_smart_sync_policy_changed_details(self):
        """
        Only call this if :meth:`is_smarter_smart_sync_policy_changed_details` is true.

        :rtype: SmarterSmartSyncPolicyChangedDetails
        """
        if not self.is_smarter_smart_sync_policy_changed_details():
            raise AttributeError("tag 'smarter_smart_sync_policy_changed_details' not set")
        return self._value

    def get_smart_sync_change_policy_details(self):
        """
        Only call this if :meth:`is_smart_sync_change_policy_details` is true.

        :rtype: SmartSyncChangePolicyDetails
        """
        if not self.is_smart_sync_change_policy_details():
            raise AttributeError("tag 'smart_sync_change_policy_details' not set")
        return self._value

    def get_smart_sync_not_opt_out_details(self):
        """
        Only call this if :meth:`is_smart_sync_not_opt_out_details` is true.

        :rtype: SmartSyncNotOptOutDetails
        """
        if not self.is_smart_sync_not_opt_out_details():
            raise AttributeError("tag 'smart_sync_not_opt_out_details' not set")
        return self._value

    def get_smart_sync_opt_out_details(self):
        """
        Only call this if :meth:`is_smart_sync_opt_out_details` is true.

        :rtype: SmartSyncOptOutDetails
        """
        if not self.is_smart_sync_opt_out_details():
            raise AttributeError("tag 'smart_sync_opt_out_details' not set")
        return self._value

    def get_sso_change_policy_details(self):
        """
        Only call this if :meth:`is_sso_change_policy_details` is true.

        :rtype: SsoChangePolicyDetails
        """
        if not self.is_sso_change_policy_details():
            raise AttributeError("tag 'sso_change_policy_details' not set")
        return self._value

    def get_team_branding_policy_changed_details(self):
        """
        Only call this if :meth:`is_team_branding_policy_changed_details` is true.

        :rtype: TeamBrandingPolicyChangedDetails
        """
        if not self.is_team_branding_policy_changed_details():
            raise AttributeError("tag 'team_branding_policy_changed_details' not set")
        return self._value

    def get_team_extensions_policy_changed_details(self):
        """
        Only call this if :meth:`is_team_extensions_policy_changed_details` is true.

        :rtype: TeamExtensionsPolicyChangedDetails
        """
        if not self.is_team_extensions_policy_changed_details():
            raise AttributeError("tag 'team_extensions_policy_changed_details' not set")
        return self._value

    def get_team_selective_sync_policy_changed_details(self):
        """
        Only call this if :meth:`is_team_selective_sync_policy_changed_details` is true.

        :rtype: TeamSelectiveSyncPolicyChangedDetails
        """
        if not self.is_team_selective_sync_policy_changed_details():
            raise AttributeError("tag 'team_selective_sync_policy_changed_details' not set")
        return self._value

    def get_team_sharing_whitelist_subjects_changed_details(self):
        """
        Only call this if :meth:`is_team_sharing_whitelist_subjects_changed_details` is true.

        :rtype: TeamSharingWhitelistSubjectsChangedDetails
        """
        if not self.is_team_sharing_whitelist_subjects_changed_details():
            raise AttributeError("tag 'team_sharing_whitelist_subjects_changed_details' not set")
        return self._value

    def get_tfa_add_exception_details(self):
        """
        Only call this if :meth:`is_tfa_add_exception_details` is true.

        :rtype: TfaAddExceptionDetails
        """
        if not self.is_tfa_add_exception_details():
            raise AttributeError("tag 'tfa_add_exception_details' not set")
        return self._value

    def get_tfa_change_policy_details(self):
        """
        Only call this if :meth:`is_tfa_change_policy_details` is true.

        :rtype: TfaChangePolicyDetails
        """
        if not self.is_tfa_change_policy_details():
            raise AttributeError("tag 'tfa_change_policy_details' not set")
        return self._value

    def get_tfa_remove_exception_details(self):
        """
        Only call this if :meth:`is_tfa_remove_exception_details` is true.

        :rtype: TfaRemoveExceptionDetails
        """
        if not self.is_tfa_remove_exception_details():
            raise AttributeError("tag 'tfa_remove_exception_details' not set")
        return self._value

    def get_two_account_change_policy_details(self):
        """
        Only call this if :meth:`is_two_account_change_policy_details` is true.

        :rtype: TwoAccountChangePolicyDetails
        """
        if not self.is_two_account_change_policy_details():
            raise AttributeError("tag 'two_account_change_policy_details' not set")
        return self._value

    def get_viewer_info_policy_changed_details(self):
        """
        Only call this if :meth:`is_viewer_info_policy_changed_details` is true.

        :rtype: ViewerInfoPolicyChangedDetails
        """
        if not self.is_viewer_info_policy_changed_details():
            raise AttributeError("tag 'viewer_info_policy_changed_details' not set")
        return self._value

    def get_watermarking_policy_changed_details(self):
        """
        Only call this if :meth:`is_watermarking_policy_changed_details` is true.

        :rtype: WatermarkingPolicyChangedDetails
        """
        if not self.is_watermarking_policy_changed_details():
            raise AttributeError("tag 'watermarking_policy_changed_details' not set")
        return self._value

    def get_web_sessions_change_active_session_limit_details(self):
        """
        Only call this if :meth:`is_web_sessions_change_active_session_limit_details` is true.

        :rtype: WebSessionsChangeActiveSessionLimitDetails
        """
        if not self.is_web_sessions_change_active_session_limit_details():
            raise AttributeError("tag 'web_sessions_change_active_session_limit_details' not set")
        return self._value

    def get_web_sessions_change_fixed_length_policy_details(self):
        """
        Only call this if :meth:`is_web_sessions_change_fixed_length_policy_details` is true.

        :rtype: WebSessionsChangeFixedLengthPolicyDetails
        """
        if not self.is_web_sessions_change_fixed_length_policy_details():
            raise AttributeError("tag 'web_sessions_change_fixed_length_policy_details' not set")
        return self._value

    def get_web_sessions_change_idle_length_policy_details(self):
        """
        Only call this if :meth:`is_web_sessions_change_idle_length_policy_details` is true.

        :rtype: WebSessionsChangeIdleLengthPolicyDetails
        """
        if not self.is_web_sessions_change_idle_length_policy_details():
            raise AttributeError("tag 'web_sessions_change_idle_length_policy_details' not set")
        return self._value

    def get_data_residency_migration_request_successful_details(self):
        """
        Only call this if :meth:`is_data_residency_migration_request_successful_details` is true.

        :rtype: DataResidencyMigrationRequestSuccessfulDetails
        """
        if not self.is_data_residency_migration_request_successful_details():
            raise AttributeError("tag 'data_residency_migration_request_successful_details' not set")
        return self._value

    def get_data_residency_migration_request_unsuccessful_details(self):
        """
        Only call this if :meth:`is_data_residency_migration_request_unsuccessful_details` is true.

        :rtype: DataResidencyMigrationRequestUnsuccessfulDetails
        """
        if not self.is_data_residency_migration_request_unsuccessful_details():
            raise AttributeError("tag 'data_residency_migration_request_unsuccessful_details' not set")
        return self._value

    def get_team_merge_from_details(self):
        """
        Only call this if :meth:`is_team_merge_from_details` is true.

        :rtype: TeamMergeFromDetails
        """
        if not self.is_team_merge_from_details():
            raise AttributeError("tag 'team_merge_from_details' not set")
        return self._value

    def get_team_merge_to_details(self):
        """
        Only call this if :meth:`is_team_merge_to_details` is true.

        :rtype: TeamMergeToDetails
        """
        if not self.is_team_merge_to_details():
            raise AttributeError("tag 'team_merge_to_details' not set")
        return self._value

    def get_team_profile_add_background_details(self):
        """
        Only call this if :meth:`is_team_profile_add_background_details` is true.

        :rtype: TeamProfileAddBackgroundDetails
        """
        if not self.is_team_profile_add_background_details():
            raise AttributeError("tag 'team_profile_add_background_details' not set")
        return self._value

    def get_team_profile_add_logo_details(self):
        """
        Only call this if :meth:`is_team_profile_add_logo_details` is true.

        :rtype: TeamProfileAddLogoDetails
        """
        if not self.is_team_profile_add_logo_details():
            raise AttributeError("tag 'team_profile_add_logo_details' not set")
        return self._value

    def get_team_profile_change_background_details(self):
        """
        Only call this if :meth:`is_team_profile_change_background_details` is true.

        :rtype: TeamProfileChangeBackgroundDetails
        """
        if not self.is_team_profile_change_background_details():
            raise AttributeError("tag 'team_profile_change_background_details' not set")
        return self._value

    def get_team_profile_change_default_language_details(self):
        """
        Only call this if :meth:`is_team_profile_change_default_language_details` is true.

        :rtype: TeamProfileChangeDefaultLanguageDetails
        """
        if not self.is_team_profile_change_default_language_details():
            raise AttributeError("tag 'team_profile_change_default_language_details' not set")
        return self._value

    def get_team_profile_change_logo_details(self):
        """
        Only call this if :meth:`is_team_profile_change_logo_details` is true.

        :rtype: TeamProfileChangeLogoDetails
        """
        if not self.is_team_profile_change_logo_details():
            raise AttributeError("tag 'team_profile_change_logo_details' not set")
        return self._value

    def get_team_profile_change_name_details(self):
        """
        Only call this if :meth:`is_team_profile_change_name_details` is true.

        :rtype: TeamProfileChangeNameDetails
        """
        if not self.is_team_profile_change_name_details():
            raise AttributeError("tag 'team_profile_change_name_details' not set")
        return self._value

    def get_team_profile_remove_background_details(self):
        """
        Only call this if :meth:`is_team_profile_remove_background_details` is true.

        :rtype: TeamProfileRemoveBackgroundDetails
        """
        if not self.is_team_profile_remove_background_details():
            raise AttributeError("tag 'team_profile_remove_background_details' not set")
        return self._value

    def get_team_profile_remove_logo_details(self):
        """
        Only call this if :meth:`is_team_profile_remove_logo_details` is true.

        :rtype: TeamProfileRemoveLogoDetails
        """
        if not self.is_team_profile_remove_logo_details():
            raise AttributeError("tag 'team_profile_remove_logo_details' not set")
        return self._value

    def get_tfa_add_backup_phone_details(self):
        """
        Only call this if :meth:`is_tfa_add_backup_phone_details` is true.

        :rtype: TfaAddBackupPhoneDetails
        """
        if not self.is_tfa_add_backup_phone_details():
            raise AttributeError("tag 'tfa_add_backup_phone_details' not set")
        return self._value

    def get_tfa_add_security_key_details(self):
        """
        Only call this if :meth:`is_tfa_add_security_key_details` is true.

        :rtype: TfaAddSecurityKeyDetails
        """
        if not self.is_tfa_add_security_key_details():
            raise AttributeError("tag 'tfa_add_security_key_details' not set")
        return self._value

    def get_tfa_change_backup_phone_details(self):
        """
        Only call this if :meth:`is_tfa_change_backup_phone_details` is true.

        :rtype: TfaChangeBackupPhoneDetails
        """
        if not self.is_tfa_change_backup_phone_details():
            raise AttributeError("tag 'tfa_change_backup_phone_details' not set")
        return self._value

    def get_tfa_change_status_details(self):
        """
        Only call this if :meth:`is_tfa_change_status_details` is true.

        :rtype: TfaChangeStatusDetails
        """
        if not self.is_tfa_change_status_details():
            raise AttributeError("tag 'tfa_change_status_details' not set")
        return self._value

    def get_tfa_remove_backup_phone_details(self):
        """
        Only call this if :meth:`is_tfa_remove_backup_phone_details` is true.

        :rtype: TfaRemoveBackupPhoneDetails
        """
        if not self.is_tfa_remove_backup_phone_details():
            raise AttributeError("tag 'tfa_remove_backup_phone_details' not set")
        return self._value

    def get_tfa_remove_security_key_details(self):
        """
        Only call this if :meth:`is_tfa_remove_security_key_details` is true.

        :rtype: TfaRemoveSecurityKeyDetails
        """
        if not self.is_tfa_remove_security_key_details():
            raise AttributeError("tag 'tfa_remove_security_key_details' not set")
        return self._value

    def get_tfa_reset_details(self):
        """
        Only call this if :meth:`is_tfa_reset_details` is true.

        :rtype: TfaResetDetails
        """
        if not self.is_tfa_reset_details():
            raise AttributeError("tag 'tfa_reset_details' not set")
        return self._value

    def get_changed_enterprise_admin_role_details(self):
        """
        Only call this if :meth:`is_changed_enterprise_admin_role_details` is true.

        :rtype: ChangedEnterpriseAdminRoleDetails
        """
        if not self.is_changed_enterprise_admin_role_details():
            raise AttributeError("tag 'changed_enterprise_admin_role_details' not set")
        return self._value

    def get_changed_enterprise_connected_team_status_details(self):
        """
        Only call this if :meth:`is_changed_enterprise_connected_team_status_details` is true.

        :rtype: ChangedEnterpriseConnectedTeamStatusDetails
        """
        if not self.is_changed_enterprise_connected_team_status_details():
            raise AttributeError("tag 'changed_enterprise_connected_team_status_details' not set")
        return self._value

    def get_ended_enterprise_admin_session_details(self):
        """
        Only call this if :meth:`is_ended_enterprise_admin_session_details` is true.

        :rtype: EndedEnterpriseAdminSessionDetails
        """
        if not self.is_ended_enterprise_admin_session_details():
            raise AttributeError("tag 'ended_enterprise_admin_session_details' not set")
        return self._value

    def get_ended_enterprise_admin_session_deprecated_details(self):
        """
        Only call this if :meth:`is_ended_enterprise_admin_session_deprecated_details` is true.

        :rtype: EndedEnterpriseAdminSessionDeprecatedDetails
        """
        if not self.is_ended_enterprise_admin_session_deprecated_details():
            raise AttributeError("tag 'ended_enterprise_admin_session_deprecated_details' not set")
        return self._value

    def get_enterprise_settings_locking_details(self):
        """
        Only call this if :meth:`is_enterprise_settings_locking_details` is true.

        :rtype: EnterpriseSettingsLockingDetails
        """
        if not self.is_enterprise_settings_locking_details():
            raise AttributeError("tag 'enterprise_settings_locking_details' not set")
        return self._value

    def get_guest_admin_change_status_details(self):
        """
        Only call this if :meth:`is_guest_admin_change_status_details` is true.

        :rtype: GuestAdminChangeStatusDetails
        """
        if not self.is_guest_admin_change_status_details():
            raise AttributeError("tag 'guest_admin_change_status_details' not set")
        return self._value

    def get_started_enterprise_admin_session_details(self):
        """
        Only call this if :meth:`is_started_enterprise_admin_session_details` is true.

        :rtype: StartedEnterpriseAdminSessionDetails
        """
        if not self.is_started_enterprise_admin_session_details():
            raise AttributeError("tag 'started_enterprise_admin_session_details' not set")
        return self._value

    def get_team_merge_request_accepted_details(self):
        """
        Only call this if :meth:`is_team_merge_request_accepted_details` is true.

        :rtype: TeamMergeRequestAcceptedDetails
        """
        if not self.is_team_merge_request_accepted_details():
            raise AttributeError("tag 'team_merge_request_accepted_details' not set")
        return self._value

    def get_team_merge_request_accepted_shown_to_primary_team_details(self):
        """
        Only call this if :meth:`is_team_merge_request_accepted_shown_to_primary_team_details` is true.

        :rtype: TeamMergeRequestAcceptedShownToPrimaryTeamDetails
        """
        if not self.is_team_merge_request_accepted_shown_to_primary_team_details():
            raise AttributeError("tag 'team_merge_request_accepted_shown_to_primary_team_details' not set")
        return self._value

    def get_team_merge_request_accepted_shown_to_secondary_team_details(self):
        """
        Only call this if :meth:`is_team_merge_request_accepted_shown_to_secondary_team_details` is true.

        :rtype: TeamMergeRequestAcceptedShownToSecondaryTeamDetails
        """
        if not self.is_team_merge_request_accepted_shown_to_secondary_team_details():
            raise AttributeError("tag 'team_merge_request_accepted_shown_to_secondary_team_details' not set")
        return self._value

    def get_team_merge_request_auto_canceled_details(self):
        """
        Only call this if :meth:`is_team_merge_request_auto_canceled_details` is true.

        :rtype: TeamMergeRequestAutoCanceledDetails
        """
        if not self.is_team_merge_request_auto_canceled_details():
            raise AttributeError("tag 'team_merge_request_auto_canceled_details' not set")
        return self._value

    def get_team_merge_request_canceled_details(self):
        """
        Only call this if :meth:`is_team_merge_request_canceled_details` is true.

        :rtype: TeamMergeRequestCanceledDetails
        """
        if not self.is_team_merge_request_canceled_details():
            raise AttributeError("tag 'team_merge_request_canceled_details' not set")
        return self._value

    def get_team_merge_request_canceled_shown_to_primary_team_details(self):
        """
        Only call this if :meth:`is_team_merge_request_canceled_shown_to_primary_team_details` is true.

        :rtype: TeamMergeRequestCanceledShownToPrimaryTeamDetails
        """
        if not self.is_team_merge_request_canceled_shown_to_primary_team_details():
            raise AttributeError("tag 'team_merge_request_canceled_shown_to_primary_team_details' not set")
        return self._value

    def get_team_merge_request_canceled_shown_to_secondary_team_details(self):
        """
        Only call this if :meth:`is_team_merge_request_canceled_shown_to_secondary_team_details` is true.

        :rtype: TeamMergeRequestCanceledShownToSecondaryTeamDetails
        """
        if not self.is_team_merge_request_canceled_shown_to_secondary_team_details():
            raise AttributeError("tag 'team_merge_request_canceled_shown_to_secondary_team_details' not set")
        return self._value

    def get_team_merge_request_expired_details(self):
        """
        Only call this if :meth:`is_team_merge_request_expired_details` is true.

        :rtype: TeamMergeRequestExpiredDetails
        """
        if not self.is_team_merge_request_expired_details():
            raise AttributeError("tag 'team_merge_request_expired_details' not set")
        return self._value

    def get_team_merge_request_expired_shown_to_primary_team_details(self):
        """
        Only call this if :meth:`is_team_merge_request_expired_shown_to_primary_team_details` is true.

        :rtype: TeamMergeRequestExpiredShownToPrimaryTeamDetails
        """
        if not self.is_team_merge_request_expired_shown_to_primary_team_details():
            raise AttributeError("tag 'team_merge_request_expired_shown_to_primary_team_details' not set")
        return self._value

    def get_team_merge_request_expired_shown_to_secondary_team_details(self):
        """
        Only call this if :meth:`is_team_merge_request_expired_shown_to_secondary_team_details` is true.

        :rtype: TeamMergeRequestExpiredShownToSecondaryTeamDetails
        """
        if not self.is_team_merge_request_expired_shown_to_secondary_team_details():
            raise AttributeError("tag 'team_merge_request_expired_shown_to_secondary_team_details' not set")
        return self._value

    def get_team_merge_request_rejected_shown_to_primary_team_details(self):
        """
        Only call this if :meth:`is_team_merge_request_rejected_shown_to_primary_team_details` is true.

        :rtype: TeamMergeRequestRejectedShownToPrimaryTeamDetails
        """
        if not self.is_team_merge_request_rejected_shown_to_primary_team_details():
            raise AttributeError("tag 'team_merge_request_rejected_shown_to_primary_team_details' not set")
        return self._value

    def get_team_merge_request_rejected_shown_to_secondary_team_details(self):
        """
        Only call this if :meth:`is_team_merge_request_rejected_shown_to_secondary_team_details` is true.

        :rtype: TeamMergeRequestRejectedShownToSecondaryTeamDetails
        """
        if not self.is_team_merge_request_rejected_shown_to_secondary_team_details():
            raise AttributeError("tag 'team_merge_request_rejected_shown_to_secondary_team_details' not set")
        return self._value

    def get_team_merge_request_reminder_details(self):
        """
        Only call this if :meth:`is_team_merge_request_reminder_details` is true.

        :rtype: TeamMergeRequestReminderDetails
        """
        if not self.is_team_merge_request_reminder_details():
            raise AttributeError("tag 'team_merge_request_reminder_details' not set")
        return self._value

    def get_team_merge_request_reminder_shown_to_primary_team_details(self):
        """
        Only call this if :meth:`is_team_merge_request_reminder_shown_to_primary_team_details` is true.

        :rtype: TeamMergeRequestReminderShownToPrimaryTeamDetails
        """
        if not self.is_team_merge_request_reminder_shown_to_primary_team_details():
            raise AttributeError("tag 'team_merge_request_reminder_shown_to_primary_team_details' not set")
        return self._value

    def get_team_merge_request_reminder_shown_to_secondary_team_details(self):
        """
        Only call this if :meth:`is_team_merge_request_reminder_shown_to_secondary_team_details` is true.

        :rtype: TeamMergeRequestReminderShownToSecondaryTeamDetails
        """
        if not self.is_team_merge_request_reminder_shown_to_secondary_team_details():
            raise AttributeError("tag 'team_merge_request_reminder_shown_to_secondary_team_details' not set")
        return self._value

    def get_team_merge_request_revoked_details(self):
        """
        Only call this if :meth:`is_team_merge_request_revoked_details` is true.

        :rtype: TeamMergeRequestRevokedDetails
        """
        if not self.is_team_merge_request_revoked_details():
            raise AttributeError("tag 'team_merge_request_revoked_details' not set")
        return self._value

    def get_team_merge_request_sent_shown_to_primary_team_details(self):
        """
        Only call this if :meth:`is_team_merge_request_sent_shown_to_primary_team_details` is true.

        :rtype: TeamMergeRequestSentShownToPrimaryTeamDetails
        """
        if not self.is_team_merge_request_sent_shown_to_primary_team_details():
            raise AttributeError("tag 'team_merge_request_sent_shown_to_primary_team_details' not set")
        return self._value

    def get_team_merge_request_sent_shown_to_secondary_team_details(self):
        """
        Only call this if :meth:`is_team_merge_request_sent_shown_to_secondary_team_details` is true.

        :rtype: TeamMergeRequestSentShownToSecondaryTeamDetails
        """
        if not self.is_team_merge_request_sent_shown_to_secondary_team_details():
            raise AttributeError("tag 'team_merge_request_sent_shown_to_secondary_team_details' not set")
        return self._value

    def get_missing_details(self):
        """
        Hints that this event was returned with missing details due to an
        internal error.

        Only call this if :meth:`is_missing_details` is true.

        :rtype: MissingDetails
        """
        if not self.is_missing_details():
            raise AttributeError("tag 'missing_details' not set")
        return self._value

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(EventDetails, self)._process_custom_annotations(annotation_type, field_path, processor)

EventDetails_validator = bv.Union(EventDetails)

class EventType(bb.Union):
    """
    The type of the event with description.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar AdminAlertingAlertStateChangedType
        EventType.admin_alerting_alert_state_changed: (admin_alerting) Changed
        an alert state
    :ivar AdminAlertingChangedAlertConfigType
        EventType.admin_alerting_changed_alert_config: (admin_alerting) Changed
        an alert setting
    :ivar AdminAlertingTriggeredAlertType
        EventType.admin_alerting_triggered_alert: (admin_alerting) Triggered
        security alert
    :ivar AppBlockedByPermissionsType EventType.app_blocked_by_permissions:
        (apps) Failed to connect app for member
    :ivar AppLinkTeamType EventType.app_link_team: (apps) Linked app for team
    :ivar AppLinkUserType EventType.app_link_user: (apps) Linked app for member
    :ivar AppUnlinkTeamType EventType.app_unlink_team: (apps) Unlinked app for
        team
    :ivar AppUnlinkUserType EventType.app_unlink_user: (apps) Unlinked app for
        member
    :ivar IntegrationConnectedType EventType.integration_connected: (apps)
        Connected integration for member
    :ivar IntegrationDisconnectedType EventType.integration_disconnected: (apps)
        Disconnected integration for member
    :ivar FileAddCommentType EventType.file_add_comment: (comments) Added file
        comment
    :ivar FileChangeCommentSubscriptionType
        EventType.file_change_comment_subscription: (comments) Subscribed to or
        unsubscribed from comment notifications for file
    :ivar FileDeleteCommentType EventType.file_delete_comment: (comments)
        Deleted file comment
    :ivar FileEditCommentType EventType.file_edit_comment: (comments) Edited
        file comment
    :ivar FileLikeCommentType EventType.file_like_comment: (comments) Liked file
        comment (deprecated, no longer logged)
    :ivar FileResolveCommentType EventType.file_resolve_comment: (comments)
        Resolved file comment
    :ivar FileUnlikeCommentType EventType.file_unlike_comment: (comments)
        Unliked file comment (deprecated, no longer logged)
    :ivar FileUnresolveCommentType EventType.file_unresolve_comment: (comments)
        Unresolved file comment
    :ivar GovernancePolicyAddFoldersType
        EventType.governance_policy_add_folders: (data_governance) Added folders
        to policy
    :ivar GovernancePolicyAddFolderFailedType
        EventType.governance_policy_add_folder_failed: (data_governance)
        Couldn't add a folder to a policy
    :ivar GovernancePolicyContentDisposedType
        EventType.governance_policy_content_disposed: (data_governance) Content
        disposed
    :ivar GovernancePolicyCreateType EventType.governance_policy_create:
        (data_governance) Activated a new policy
    :ivar GovernancePolicyDeleteType EventType.governance_policy_delete:
        (data_governance) Deleted a policy
    :ivar GovernancePolicyEditDetailsType
        EventType.governance_policy_edit_details: (data_governance) Edited
        policy
    :ivar GovernancePolicyEditDurationType
        EventType.governance_policy_edit_duration: (data_governance) Changed
        policy duration
    :ivar GovernancePolicyExportCreatedType
        EventType.governance_policy_export_created: (data_governance) Created a
        policy download
    :ivar GovernancePolicyExportRemovedType
        EventType.governance_policy_export_removed: (data_governance) Removed a
        policy download
    :ivar GovernancePolicyRemoveFoldersType
        EventType.governance_policy_remove_folders: (data_governance) Removed
        folders from policy
    :ivar GovernancePolicyReportCreatedType
        EventType.governance_policy_report_created: (data_governance) Created a
        summary report for a policy
    :ivar GovernancePolicyZipPartDownloadedType
        EventType.governance_policy_zip_part_downloaded: (data_governance)
        Downloaded content from a policy
    :ivar LegalHoldsActivateAHoldType EventType.legal_holds_activate_a_hold:
        (data_governance) Activated a hold
    :ivar LegalHoldsAddMembersType EventType.legal_holds_add_members:
        (data_governance) Added members to a hold
    :ivar LegalHoldsChangeHoldDetailsType
        EventType.legal_holds_change_hold_details: (data_governance) Edited
        details for a hold
    :ivar LegalHoldsChangeHoldNameType EventType.legal_holds_change_hold_name:
        (data_governance) Renamed a hold
    :ivar LegalHoldsExportAHoldType EventType.legal_holds_export_a_hold:
        (data_governance) Exported hold
    :ivar LegalHoldsExportCancelledType EventType.legal_holds_export_cancelled:
        (data_governance) Canceled export for a hold
    :ivar LegalHoldsExportDownloadedType
        EventType.legal_holds_export_downloaded: (data_governance) Downloaded
        export for a hold
    :ivar LegalHoldsExportRemovedType EventType.legal_holds_export_removed:
        (data_governance) Removed export for a hold
    :ivar LegalHoldsReleaseAHoldType EventType.legal_holds_release_a_hold:
        (data_governance) Released a hold
    :ivar LegalHoldsRemoveMembersType EventType.legal_holds_remove_members:
        (data_governance) Removed members from a hold
    :ivar LegalHoldsReportAHoldType EventType.legal_holds_report_a_hold:
        (data_governance) Created a summary report for a hold
    :ivar DeviceChangeIpDesktopType EventType.device_change_ip_desktop:
        (devices) Changed IP address associated with active desktop session
    :ivar DeviceChangeIpMobileType EventType.device_change_ip_mobile: (devices)
        Changed IP address associated with active mobile session
    :ivar DeviceChangeIpWebType EventType.device_change_ip_web: (devices)
        Changed IP address associated with active web session
    :ivar DeviceDeleteOnUnlinkFailType EventType.device_delete_on_unlink_fail:
        (devices) Failed to delete all files from unlinked device
    :ivar DeviceDeleteOnUnlinkSuccessType
        EventType.device_delete_on_unlink_success: (devices) Deleted all files
        from unlinked device
    :ivar DeviceLinkFailType EventType.device_link_fail: (devices) Failed to
        link device
    :ivar DeviceLinkSuccessType EventType.device_link_success: (devices) Linked
        device
    :ivar DeviceManagementDisabledType EventType.device_management_disabled:
        (devices) Disabled device management (deprecated, no longer logged)
    :ivar DeviceManagementEnabledType EventType.device_management_enabled:
        (devices) Enabled device management (deprecated, no longer logged)
    :ivar DeviceSyncBackupStatusChangedType
        EventType.device_sync_backup_status_changed: (devices) Enabled/disabled
        backup for computer
    :ivar DeviceUnlinkType EventType.device_unlink: (devices) Disconnected
        device
    :ivar DropboxPasswordsExportedType EventType.dropbox_passwords_exported:
        (devices) Exported passwords
    :ivar DropboxPasswordsNewDeviceEnrolledType
        EventType.dropbox_passwords_new_device_enrolled: (devices) Enrolled new
        Dropbox Passwords device
    :ivar EmmRefreshAuthTokenType EventType.emm_refresh_auth_token: (devices)
        Refreshed auth token used for setting up EMM
    :ivar AccountCaptureChangeAvailabilityType
        EventType.account_capture_change_availability: (domains) Granted/revoked
        option to enable account capture on team domains
    :ivar AccountCaptureMigrateAccountType
        EventType.account_capture_migrate_account: (domains) Account-captured
        user migrated account to team
    :ivar AccountCaptureNotificationEmailsSentType
        EventType.account_capture_notification_emails_sent: (domains) Sent
        account capture email to all unmanaged members
    :ivar AccountCaptureRelinquishAccountType
        EventType.account_capture_relinquish_account: (domains) Account-captured
        user changed account email to personal email
    :ivar DisabledDomainInvitesType EventType.disabled_domain_invites: (domains)
        Disabled domain invites (deprecated, no longer logged)
    :ivar DomainInvitesApproveRequestToJoinTeamType
        EventType.domain_invites_approve_request_to_join_team: (domains)
        Approved user's request to join team
    :ivar DomainInvitesDeclineRequestToJoinTeamType
        EventType.domain_invites_decline_request_to_join_team: (domains)
        Declined user's request to join team
    :ivar DomainInvitesEmailExistingUsersType
        EventType.domain_invites_email_existing_users: (domains) Sent domain
        invites to existing domain accounts (deprecated, no longer logged)
    :ivar DomainInvitesRequestToJoinTeamType
        EventType.domain_invites_request_to_join_team: (domains) Requested to
        join team
    :ivar DomainInvitesSetInviteNewUserPrefToNoType
        EventType.domain_invites_set_invite_new_user_pref_to_no: (domains)
        Disabled "Automatically invite new users" (deprecated, no longer logged)
    :ivar DomainInvitesSetInviteNewUserPrefToYesType
        EventType.domain_invites_set_invite_new_user_pref_to_yes: (domains)
        Enabled "Automatically invite new users" (deprecated, no longer logged)
    :ivar DomainVerificationAddDomainFailType
        EventType.domain_verification_add_domain_fail: (domains) Failed to
        verify team domain
    :ivar DomainVerificationAddDomainSuccessType
        EventType.domain_verification_add_domain_success: (domains) Verified
        team domain
    :ivar DomainVerificationRemoveDomainType
        EventType.domain_verification_remove_domain: (domains) Removed domain
        from list of verified team domains
    :ivar EnabledDomainInvitesType EventType.enabled_domain_invites: (domains)
        Enabled domain invites (deprecated, no longer logged)
    :ivar ApplyNamingConventionType EventType.apply_naming_convention:
        (file_operations) Applied naming convention
    :ivar CreateFolderType EventType.create_folder: (file_operations) Created
        folders (deprecated, no longer logged)
    :ivar FileAddType EventType.file_add: (file_operations) Added files and/or
        folders
    :ivar FileCopyType EventType.file_copy: (file_operations) Copied files
        and/or folders
    :ivar FileDeleteType EventType.file_delete: (file_operations) Deleted files
        and/or folders
    :ivar FileDownloadType EventType.file_download: (file_operations) Downloaded
        files and/or folders
    :ivar FileEditType EventType.file_edit: (file_operations) Edited files
    :ivar FileGetCopyReferenceType EventType.file_get_copy_reference:
        (file_operations) Created copy reference to file/folder
    :ivar FileLockingLockStatusChangedType
        EventType.file_locking_lock_status_changed: (file_operations)
        Locked/unlocked editing for a file
    :ivar FileMoveType EventType.file_move: (file_operations) Moved files and/or
        folders
    :ivar FilePermanentlyDeleteType EventType.file_permanently_delete:
        (file_operations) Permanently deleted files and/or folders
    :ivar FilePreviewType EventType.file_preview: (file_operations) Previewed
        files and/or folders
    :ivar FileRenameType EventType.file_rename: (file_operations) Renamed files
        and/or folders
    :ivar FileRestoreType EventType.file_restore: (file_operations) Restored
        deleted files and/or folders
    :ivar FileRevertType EventType.file_revert: (file_operations) Reverted files
        to previous version
    :ivar FileRollbackChangesType EventType.file_rollback_changes:
        (file_operations) Rolled back file actions
    :ivar FileSaveCopyReferenceType EventType.file_save_copy_reference:
        (file_operations) Saved file/folder using copy reference
    :ivar FolderOverviewDescriptionChangedType
        EventType.folder_overview_description_changed: (file_operations) Updated
        folder overview
    :ivar FolderOverviewItemPinnedType EventType.folder_overview_item_pinned:
        (file_operations) Pinned item to folder overview
    :ivar FolderOverviewItemUnpinnedType
        EventType.folder_overview_item_unpinned: (file_operations) Unpinned item
        from folder overview
    :ivar ObjectLabelAddedType EventType.object_label_added: (file_operations)
        Added a label
    :ivar ObjectLabelRemovedType EventType.object_label_removed:
        (file_operations) Removed a label
    :ivar ObjectLabelUpdatedValueType EventType.object_label_updated_value:
        (file_operations) Updated a label's value
    :ivar OrganizeFolderWithTidyType EventType.organize_folder_with_tidy:
        (file_operations) Organized a folder with multi-file organize
    :ivar RewindFolderType EventType.rewind_folder: (file_operations) Rewound a
        folder
    :ivar UndoNamingConventionType EventType.undo_naming_convention:
        (file_operations) Reverted naming convention
    :ivar UndoOrganizeFolderWithTidyType
        EventType.undo_organize_folder_with_tidy: (file_operations) Removed
        multi-file organize
    :ivar UserTagsAddedType EventType.user_tags_added: (file_operations) Tagged
        a file
    :ivar UserTagsRemovedType EventType.user_tags_removed: (file_operations)
        Removed tags
    :ivar EmailIngestReceiveFileType EventType.email_ingest_receive_file:
        (file_requests) Received files via Email to my Dropbox
    :ivar FileRequestChangeType EventType.file_request_change: (file_requests)
        Changed file request
    :ivar FileRequestCloseType EventType.file_request_close: (file_requests)
        Closed file request
    :ivar FileRequestCreateType EventType.file_request_create: (file_requests)
        Created file request
    :ivar FileRequestDeleteType EventType.file_request_delete: (file_requests)
        Delete file request
    :ivar FileRequestReceiveFileType EventType.file_request_receive_file:
        (file_requests) Received files for file request
    :ivar GroupAddExternalIdType EventType.group_add_external_id: (groups) Added
        external ID for group
    :ivar GroupAddMemberType EventType.group_add_member: (groups) Added team
        members to group
    :ivar GroupChangeExternalIdType EventType.group_change_external_id: (groups)
        Changed external ID for group
    :ivar GroupChangeManagementTypeType EventType.group_change_management_type:
        (groups) Changed group management type
    :ivar GroupChangeMemberRoleType EventType.group_change_member_role: (groups)
        Changed manager permissions of group member
    :ivar GroupCreateType EventType.group_create: (groups) Created group
    :ivar GroupDeleteType EventType.group_delete: (groups) Deleted group
    :ivar GroupDescriptionUpdatedType EventType.group_description_updated:
        (groups) Updated group (deprecated, no longer logged)
    :ivar GroupJoinPolicyUpdatedType EventType.group_join_policy_updated:
        (groups) Updated group join policy (deprecated, no longer logged)
    :ivar GroupMovedType EventType.group_moved: (groups) Moved group
        (deprecated, no longer logged)
    :ivar GroupRemoveExternalIdType EventType.group_remove_external_id: (groups)
        Removed external ID for group
    :ivar GroupRemoveMemberType EventType.group_remove_member: (groups) Removed
        team members from group
    :ivar GroupRenameType EventType.group_rename: (groups) Renamed group
    :ivar AccountLockOrUnlockedType EventType.account_lock_or_unlocked: (logins)
        Unlocked/locked account after failed sign in attempts
    :ivar EmmErrorType EventType.emm_error: (logins) Failed to sign in via EMM
        (deprecated, replaced by 'Failed to sign in')
    :ivar GuestAdminSignedInViaTrustedTeamsType
        EventType.guest_admin_signed_in_via_trusted_teams: (logins) Started
        trusted team admin session
    :ivar GuestAdminSignedOutViaTrustedTeamsType
        EventType.guest_admin_signed_out_via_trusted_teams: (logins) Ended
        trusted team admin session
    :ivar LoginFailType EventType.login_fail: (logins) Failed to sign in
    :ivar LoginSuccessType EventType.login_success: (logins) Signed in
    :ivar LogoutType EventType.logout: (logins) Signed out
    :ivar ResellerSupportSessionEndType EventType.reseller_support_session_end:
        (logins) Ended reseller support session
    :ivar ResellerSupportSessionStartType
        EventType.reseller_support_session_start: (logins) Started reseller
        support session
    :ivar SignInAsSessionEndType EventType.sign_in_as_session_end: (logins)
        Ended admin sign-in-as session
    :ivar SignInAsSessionStartType EventType.sign_in_as_session_start: (logins)
        Started admin sign-in-as session
    :ivar SsoErrorType EventType.sso_error: (logins) Failed to sign in via SSO
        (deprecated, replaced by 'Failed to sign in')
    :ivar CreateTeamInviteLinkType EventType.create_team_invite_link: (members)
        Created team invite link
    :ivar DeleteTeamInviteLinkType EventType.delete_team_invite_link: (members)
        Deleted team invite link
    :ivar MemberAddExternalIdType EventType.member_add_external_id: (members)
        Added an external ID for team member
    :ivar MemberAddNameType EventType.member_add_name: (members) Added team
        member name
    :ivar MemberChangeAdminRoleType EventType.member_change_admin_role:
        (members) Changed team member admin role
    :ivar MemberChangeEmailType EventType.member_change_email: (members) Changed
        team member email
    :ivar MemberChangeExternalIdType EventType.member_change_external_id:
        (members) Changed the external ID for team member
    :ivar MemberChangeMembershipTypeType
        EventType.member_change_membership_type: (members) Changed membership
        type (limited/full) of member (deprecated, no longer logged)
    :ivar MemberChangeNameType EventType.member_change_name: (members) Changed
        team member name
    :ivar MemberChangeResellerRoleType EventType.member_change_reseller_role:
        (members) Changed team member reseller role
    :ivar MemberChangeStatusType EventType.member_change_status: (members)
        Changed member status (invited, joined, suspended, etc.)
    :ivar MemberDeleteManualContactsType
        EventType.member_delete_manual_contacts: (members) Cleared manually
        added contacts
    :ivar MemberDeleteProfilePhotoType EventType.member_delete_profile_photo:
        (members) Deleted team member profile photo
    :ivar MemberPermanentlyDeleteAccountContentsType
        EventType.member_permanently_delete_account_contents: (members)
        Permanently deleted contents of deleted team member account
    :ivar MemberRemoveExternalIdType EventType.member_remove_external_id:
        (members) Removed the external ID for team member
    :ivar MemberSetProfilePhotoType EventType.member_set_profile_photo:
        (members) Set team member profile photo
    :ivar MemberSpaceLimitsAddCustomQuotaType
        EventType.member_space_limits_add_custom_quota: (members) Set custom
        member space limit
    :ivar MemberSpaceLimitsChangeCustomQuotaType
        EventType.member_space_limits_change_custom_quota: (members) Changed
        custom member space limit
    :ivar MemberSpaceLimitsChangeStatusType
        EventType.member_space_limits_change_status: (members) Changed space
        limit status
    :ivar MemberSpaceLimitsRemoveCustomQuotaType
        EventType.member_space_limits_remove_custom_quota: (members) Removed
        custom member space limit
    :ivar MemberSuggestType EventType.member_suggest: (members) Suggested person
        to add to team
    :ivar MemberTransferAccountContentsType
        EventType.member_transfer_account_contents: (members) Transferred
        contents of deleted member account to another member
    :ivar PendingSecondaryEmailAddedType
        EventType.pending_secondary_email_added: (members) Added pending
        secondary email
    :ivar SecondaryEmailDeletedType EventType.secondary_email_deleted: (members)
        Deleted secondary email
    :ivar SecondaryEmailVerifiedType EventType.secondary_email_verified:
        (members) Verified secondary email
    :ivar SecondaryMailsPolicyChangedType
        EventType.secondary_mails_policy_changed: (members) Secondary mails
        policy changed
    :ivar BinderAddPageType EventType.binder_add_page: (paper) Added Binder page
        (deprecated, replaced by 'Edited files')
    :ivar BinderAddSectionType EventType.binder_add_section: (paper) Added
        Binder section (deprecated, replaced by 'Edited files')
    :ivar BinderRemovePageType EventType.binder_remove_page: (paper) Removed
        Binder page (deprecated, replaced by 'Edited files')
    :ivar BinderRemoveSectionType EventType.binder_remove_section: (paper)
        Removed Binder section (deprecated, replaced by 'Edited files')
    :ivar BinderRenamePageType EventType.binder_rename_page: (paper) Renamed
        Binder page (deprecated, replaced by 'Edited files')
    :ivar BinderRenameSectionType EventType.binder_rename_section: (paper)
        Renamed Binder section (deprecated, replaced by 'Edited files')
    :ivar BinderReorderPageType EventType.binder_reorder_page: (paper) Reordered
        Binder page (deprecated, replaced by 'Edited files')
    :ivar BinderReorderSectionType EventType.binder_reorder_section: (paper)
        Reordered Binder section (deprecated, replaced by 'Edited files')
    :ivar PaperContentAddMemberType EventType.paper_content_add_member: (paper)
        Added users and/or groups to Paper doc/folder
    :ivar PaperContentAddToFolderType EventType.paper_content_add_to_folder:
        (paper) Added Paper doc/folder to folder
    :ivar PaperContentArchiveType EventType.paper_content_archive: (paper)
        Archived Paper doc/folder
    :ivar PaperContentCreateType EventType.paper_content_create: (paper) Created
        Paper doc/folder
    :ivar PaperContentPermanentlyDeleteType
        EventType.paper_content_permanently_delete: (paper) Permanently deleted
        Paper doc/folder
    :ivar PaperContentRemoveFromFolderType
        EventType.paper_content_remove_from_folder: (paper) Removed Paper
        doc/folder from folder
    :ivar PaperContentRemoveMemberType EventType.paper_content_remove_member:
        (paper) Removed users and/or groups from Paper doc/folder
    :ivar PaperContentRenameType EventType.paper_content_rename: (paper) Renamed
        Paper doc/folder
    :ivar PaperContentRestoreType EventType.paper_content_restore: (paper)
        Restored archived Paper doc/folder
    :ivar PaperDocAddCommentType EventType.paper_doc_add_comment: (paper) Added
        Paper doc comment
    :ivar PaperDocChangeMemberRoleType EventType.paper_doc_change_member_role:
        (paper) Changed member permissions for Paper doc
    :ivar PaperDocChangeSharingPolicyType
        EventType.paper_doc_change_sharing_policy: (paper) Changed sharing
        setting for Paper doc
    :ivar PaperDocChangeSubscriptionType
        EventType.paper_doc_change_subscription: (paper) Followed/unfollowed
        Paper doc
    :ivar PaperDocDeletedType EventType.paper_doc_deleted: (paper) Archived
        Paper doc (deprecated, no longer logged)
    :ivar PaperDocDeleteCommentType EventType.paper_doc_delete_comment: (paper)
        Deleted Paper doc comment
    :ivar PaperDocDownloadType EventType.paper_doc_download: (paper) Downloaded
        Paper doc in specific format
    :ivar PaperDocEditType EventType.paper_doc_edit: (paper) Edited Paper doc
    :ivar PaperDocEditCommentType EventType.paper_doc_edit_comment: (paper)
        Edited Paper doc comment
    :ivar PaperDocFollowedType EventType.paper_doc_followed: (paper) Followed
        Paper doc (deprecated, replaced by 'Followed/unfollowed Paper doc')
    :ivar PaperDocMentionType EventType.paper_doc_mention: (paper) Mentioned
        user in Paper doc
    :ivar PaperDocOwnershipChangedType EventType.paper_doc_ownership_changed:
        (paper) Transferred ownership of Paper doc
    :ivar PaperDocRequestAccessType EventType.paper_doc_request_access: (paper)
        Requested access to Paper doc
    :ivar PaperDocResolveCommentType EventType.paper_doc_resolve_comment:
        (paper) Resolved Paper doc comment
    :ivar PaperDocRevertType EventType.paper_doc_revert: (paper) Restored Paper
        doc to previous version
    :ivar PaperDocSlackShareType EventType.paper_doc_slack_share: (paper) Shared
        Paper doc via Slack
    :ivar PaperDocTeamInviteType EventType.paper_doc_team_invite: (paper) Shared
        Paper doc with users and/or groups (deprecated, no longer logged)
    :ivar PaperDocTrashedType EventType.paper_doc_trashed: (paper) Deleted Paper
        doc
    :ivar PaperDocUnresolveCommentType EventType.paper_doc_unresolve_comment:
        (paper) Unresolved Paper doc comment
    :ivar PaperDocUntrashedType EventType.paper_doc_untrashed: (paper) Restored
        Paper doc
    :ivar PaperDocViewType EventType.paper_doc_view: (paper) Viewed Paper doc
    :ivar PaperExternalViewAllowType EventType.paper_external_view_allow:
        (paper) Changed Paper external sharing setting to anyone (deprecated, no
        longer logged)
    :ivar PaperExternalViewDefaultTeamType
        EventType.paper_external_view_default_team: (paper) Changed Paper
        external sharing setting to default team (deprecated, no longer logged)
    :ivar PaperExternalViewForbidType EventType.paper_external_view_forbid:
        (paper) Changed Paper external sharing setting to team-only (deprecated,
        no longer logged)
    :ivar PaperFolderChangeSubscriptionType
        EventType.paper_folder_change_subscription: (paper) Followed/unfollowed
        Paper folder
    :ivar PaperFolderDeletedType EventType.paper_folder_deleted: (paper)
        Archived Paper folder (deprecated, no longer logged)
    :ivar PaperFolderFollowedType EventType.paper_folder_followed: (paper)
        Followed Paper folder (deprecated, replaced by 'Followed/unfollowed
        Paper folder')
    :ivar PaperFolderTeamInviteType EventType.paper_folder_team_invite: (paper)
        Shared Paper folder with users and/or groups (deprecated, no longer
        logged)
    :ivar PaperPublishedLinkChangePermissionType
        EventType.paper_published_link_change_permission: (paper) Changed
        permissions for published doc
    :ivar PaperPublishedLinkCreateType EventType.paper_published_link_create:
        (paper) Published doc
    :ivar PaperPublishedLinkDisabledType
        EventType.paper_published_link_disabled: (paper) Unpublished doc
    :ivar PaperPublishedLinkViewType EventType.paper_published_link_view:
        (paper) Viewed published doc
    :ivar PasswordChangeType EventType.password_change: (passwords) Changed
        password
    :ivar PasswordResetType EventType.password_reset: (passwords) Reset password
    :ivar PasswordResetAllType EventType.password_reset_all: (passwords) Reset
        all team member passwords
    :ivar ClassificationCreateReportType EventType.classification_create_report:
        (reports) Created Classification report
    :ivar ClassificationCreateReportFailType
        EventType.classification_create_report_fail: (reports) Couldn't create
        Classification report
    :ivar EmmCreateExceptionsReportType EventType.emm_create_exceptions_report:
        (reports) Created EMM-excluded users report
    :ivar EmmCreateUsageReportType EventType.emm_create_usage_report: (reports)
        Created EMM mobile app usage report
    :ivar ExportMembersReportType EventType.export_members_report: (reports)
        Created member data report
    :ivar ExportMembersReportFailType EventType.export_members_report_fail:
        (reports) Failed to create members data report
    :ivar ExternalSharingCreateReportType
        EventType.external_sharing_create_report: (reports) Created External
        sharing report
    :ivar ExternalSharingReportFailedType
        EventType.external_sharing_report_failed: (reports) Couldn't create
        External sharing report
    :ivar NoExpirationLinkGenCreateReportType
        EventType.no_expiration_link_gen_create_report: (reports) Report
        created: Links created with no expiration
    :ivar NoExpirationLinkGenReportFailedType
        EventType.no_expiration_link_gen_report_failed: (reports) Couldn't
        create report: Links created with no expiration
    :ivar NoPasswordLinkGenCreateReportType
        EventType.no_password_link_gen_create_report: (reports) Report created:
        Links created without passwords
    :ivar NoPasswordLinkGenReportFailedType
        EventType.no_password_link_gen_report_failed: (reports) Couldn't create
        report: Links created without passwords
    :ivar NoPasswordLinkViewCreateReportType
        EventType.no_password_link_view_create_report: (reports) Report created:
        Views of links without passwords
    :ivar NoPasswordLinkViewReportFailedType
        EventType.no_password_link_view_report_failed: (reports) Couldn't create
        report: Views of links without passwords
    :ivar OutdatedLinkViewCreateReportType
        EventType.outdated_link_view_create_report: (reports) Report created:
        Views of old links
    :ivar OutdatedLinkViewReportFailedType
        EventType.outdated_link_view_report_failed: (reports) Couldn't create
        report: Views of old links
    :ivar PaperAdminExportStartType EventType.paper_admin_export_start:
        (reports) Exported all team Paper docs
    :ivar SmartSyncCreateAdminPrivilegeReportType
        EventType.smart_sync_create_admin_privilege_report: (reports) Created
        Smart Sync non-admin devices report
    :ivar TeamActivityCreateReportType EventType.team_activity_create_report:
        (reports) Created team activity report
    :ivar TeamActivityCreateReportFailType
        EventType.team_activity_create_report_fail: (reports) Couldn't generate
        team activity report
    :ivar CollectionShareType EventType.collection_share: (sharing) Shared album
    :ivar FileTransfersFileAddType EventType.file_transfers_file_add: (sharing)
        Transfer files added
    :ivar FileTransfersTransferDeleteType
        EventType.file_transfers_transfer_delete: (sharing) Deleted transfer
    :ivar FileTransfersTransferDownloadType
        EventType.file_transfers_transfer_download: (sharing) Transfer
        downloaded
    :ivar FileTransfersTransferSendType EventType.file_transfers_transfer_send:
        (sharing) Sent transfer
    :ivar FileTransfersTransferViewType EventType.file_transfers_transfer_view:
        (sharing) Viewed transfer
    :ivar NoteAclInviteOnlyType EventType.note_acl_invite_only: (sharing)
        Changed Paper doc to invite-only (deprecated, no longer logged)
    :ivar NoteAclLinkType EventType.note_acl_link: (sharing) Changed Paper doc
        to link-accessible (deprecated, no longer logged)
    :ivar NoteAclTeamLinkType EventType.note_acl_team_link: (sharing) Changed
        Paper doc to link-accessible for team (deprecated, no longer logged)
    :ivar NoteSharedType EventType.note_shared: (sharing) Shared Paper doc
        (deprecated, no longer logged)
    :ivar NoteShareReceiveType EventType.note_share_receive: (sharing) Shared
        received Paper doc (deprecated, no longer logged)
    :ivar OpenNoteSharedType EventType.open_note_shared: (sharing) Opened shared
        Paper doc (deprecated, no longer logged)
    :ivar SfAddGroupType EventType.sf_add_group: (sharing) Added team to shared
        folder (deprecated, no longer logged)
    :ivar SfAllowNonMembersToViewSharedLinksType
        EventType.sf_allow_non_members_to_view_shared_links: (sharing) Allowed
        non-collaborators to view links to files in shared folder (deprecated,
        no longer logged)
    :ivar SfExternalInviteWarnType EventType.sf_external_invite_warn: (sharing)
        Set team members to see warning before sharing folders outside team
        (deprecated, no longer logged)
    :ivar SfFbInviteType EventType.sf_fb_invite: (sharing) Invited Facebook
        users to shared folder (deprecated, no longer logged)
    :ivar SfFbInviteChangeRoleType EventType.sf_fb_invite_change_role: (sharing)
        Changed Facebook user's role in shared folder (deprecated, no longer
        logged)
    :ivar SfFbUninviteType EventType.sf_fb_uninvite: (sharing) Uninvited
        Facebook user from shared folder (deprecated, no longer logged)
    :ivar SfInviteGroupType EventType.sf_invite_group: (sharing) Invited group
        to shared folder (deprecated, no longer logged)
    :ivar SfTeamGrantAccessType EventType.sf_team_grant_access: (sharing)
        Granted access to shared folder (deprecated, no longer logged)
    :ivar SfTeamInviteType EventType.sf_team_invite: (sharing) Invited team
        members to shared folder (deprecated, replaced by 'Invited user to
        Dropbox and added them to shared file/folder')
    :ivar SfTeamInviteChangeRoleType EventType.sf_team_invite_change_role:
        (sharing) Changed team member's role in shared folder (deprecated, no
        longer logged)
    :ivar SfTeamJoinType EventType.sf_team_join: (sharing) Joined team member's
        shared folder (deprecated, no longer logged)
    :ivar SfTeamJoinFromOobLinkType EventType.sf_team_join_from_oob_link:
        (sharing) Joined team member's shared folder from link (deprecated, no
        longer logged)
    :ivar SfTeamUninviteType EventType.sf_team_uninvite: (sharing) Unshared
        folder with team member (deprecated, replaced by 'Removed invitee from
        shared file/folder before invite was accepted')
    :ivar SharedContentAddInviteesType EventType.shared_content_add_invitees:
        (sharing) Invited user to Dropbox and added them to shared file/folder
    :ivar SharedContentAddLinkExpiryType
        EventType.shared_content_add_link_expiry: (sharing) Added expiration
        date to link for shared file/folder (deprecated, no longer logged)
    :ivar SharedContentAddLinkPasswordType
        EventType.shared_content_add_link_password: (sharing) Added password to
        link for shared file/folder (deprecated, no longer logged)
    :ivar SharedContentAddMemberType EventType.shared_content_add_member:
        (sharing) Added users and/or groups to shared file/folder
    :ivar SharedContentChangeDownloadsPolicyType
        EventType.shared_content_change_downloads_policy: (sharing) Changed
        whether members can download shared file/folder (deprecated, no longer
        logged)
    :ivar SharedContentChangeInviteeRoleType
        EventType.shared_content_change_invitee_role: (sharing) Changed access
        type of invitee to shared file/folder before invite was accepted
    :ivar SharedContentChangeLinkAudienceType
        EventType.shared_content_change_link_audience: (sharing) Changed link
        audience of shared file/folder (deprecated, no longer logged)
    :ivar SharedContentChangeLinkExpiryType
        EventType.shared_content_change_link_expiry: (sharing) Changed link
        expiration of shared file/folder (deprecated, no longer logged)
    :ivar SharedContentChangeLinkPasswordType
        EventType.shared_content_change_link_password: (sharing) Changed link
        password of shared file/folder (deprecated, no longer logged)
    :ivar SharedContentChangeMemberRoleType
        EventType.shared_content_change_member_role: (sharing) Changed access
        type of shared file/folder member
    :ivar SharedContentChangeViewerInfoPolicyType
        EventType.shared_content_change_viewer_info_policy: (sharing) Changed
        whether members can see who viewed shared file/folder
    :ivar SharedContentClaimInvitationType
        EventType.shared_content_claim_invitation: (sharing) Acquired membership
        of shared file/folder by accepting invite
    :ivar SharedContentCopyType EventType.shared_content_copy: (sharing) Copied
        shared file/folder to own Dropbox
    :ivar SharedContentDownloadType EventType.shared_content_download: (sharing)
        Downloaded shared file/folder
    :ivar SharedContentRelinquishMembershipType
        EventType.shared_content_relinquish_membership: (sharing) Left shared
        file/folder
    :ivar SharedContentRemoveInviteesType
        EventType.shared_content_remove_invitees: (sharing) Removed invitee from
        shared file/folder before invite was accepted
    :ivar SharedContentRemoveLinkExpiryType
        EventType.shared_content_remove_link_expiry: (sharing) Removed link
        expiration date of shared file/folder (deprecated, no longer logged)
    :ivar SharedContentRemoveLinkPasswordType
        EventType.shared_content_remove_link_password: (sharing) Removed link
        password of shared file/folder (deprecated, no longer logged)
    :ivar SharedContentRemoveMemberType EventType.shared_content_remove_member:
        (sharing) Removed user/group from shared file/folder
    :ivar SharedContentRequestAccessType
        EventType.shared_content_request_access: (sharing) Requested access to
        shared file/folder
    :ivar SharedContentRestoreInviteesType
        EventType.shared_content_restore_invitees: (sharing) Restored shared
        file/folder invitees
    :ivar SharedContentRestoreMemberType
        EventType.shared_content_restore_member: (sharing) Restored users and/or
        groups to membership of shared file/folder
    :ivar SharedContentUnshareType EventType.shared_content_unshare: (sharing)
        Unshared file/folder by clearing membership
    :ivar SharedContentViewType EventType.shared_content_view: (sharing)
        Previewed shared file/folder
    :ivar SharedFolderChangeLinkPolicyType
        EventType.shared_folder_change_link_policy: (sharing) Changed who can
        access shared folder via link
    :ivar SharedFolderChangeMembersInheritancePolicyType
        EventType.shared_folder_change_members_inheritance_policy: (sharing)
        Changed whether shared folder inherits members from parent folder
    :ivar SharedFolderChangeMembersManagementPolicyType
        EventType.shared_folder_change_members_management_policy: (sharing)
        Changed who can add/remove members of shared folder
    :ivar SharedFolderChangeMembersPolicyType
        EventType.shared_folder_change_members_policy: (sharing) Changed who can
        become member of shared folder
    :ivar SharedFolderCreateType EventType.shared_folder_create: (sharing)
        Created shared folder
    :ivar SharedFolderDeclineInvitationType
        EventType.shared_folder_decline_invitation: (sharing) Declined team
        member's invite to shared folder
    :ivar SharedFolderMountType EventType.shared_folder_mount: (sharing) Added
        shared folder to own Dropbox
    :ivar SharedFolderNestType EventType.shared_folder_nest: (sharing) Changed
        parent of shared folder
    :ivar SharedFolderTransferOwnershipType
        EventType.shared_folder_transfer_ownership: (sharing) Transferred
        ownership of shared folder to another member
    :ivar SharedFolderUnmountType EventType.shared_folder_unmount: (sharing)
        Deleted shared folder from Dropbox
    :ivar SharedLinkAddExpiryType EventType.shared_link_add_expiry: (sharing)
        Added shared link expiration date
    :ivar SharedLinkChangeExpiryType EventType.shared_link_change_expiry:
        (sharing) Changed shared link expiration date
    :ivar SharedLinkChangeVisibilityType
        EventType.shared_link_change_visibility: (sharing) Changed visibility of
        shared link
    :ivar SharedLinkCopyType EventType.shared_link_copy: (sharing) Added
        file/folder to Dropbox from shared link
    :ivar SharedLinkCreateType EventType.shared_link_create: (sharing) Created
        shared link
    :ivar SharedLinkDisableType EventType.shared_link_disable: (sharing) Removed
        shared link
    :ivar SharedLinkDownloadType EventType.shared_link_download: (sharing)
        Downloaded file/folder from shared link
    :ivar SharedLinkRemoveExpiryType EventType.shared_link_remove_expiry:
        (sharing) Removed shared link expiration date
    :ivar SharedLinkSettingsAddExpirationType
        EventType.shared_link_settings_add_expiration: (sharing) Added an
        expiration date to the shared link
    :ivar SharedLinkSettingsAddPasswordType
        EventType.shared_link_settings_add_password: (sharing) Added a password
        to the shared link
    :ivar SharedLinkSettingsAllowDownloadDisabledType
        EventType.shared_link_settings_allow_download_disabled: (sharing)
        Disabled downloads
    :ivar SharedLinkSettingsAllowDownloadEnabledType
        EventType.shared_link_settings_allow_download_enabled: (sharing) Enabled
        downloads
    :ivar SharedLinkSettingsChangeAudienceType
        EventType.shared_link_settings_change_audience: (sharing) Changed the
        audience of the shared link
    :ivar SharedLinkSettingsChangeExpirationType
        EventType.shared_link_settings_change_expiration: (sharing) Changed the
        expiration date of the shared link
    :ivar SharedLinkSettingsChangePasswordType
        EventType.shared_link_settings_change_password: (sharing) Changed the
        password of the shared link
    :ivar SharedLinkSettingsRemoveExpirationType
        EventType.shared_link_settings_remove_expiration: (sharing) Removed the
        expiration date from the shared link
    :ivar SharedLinkSettingsRemovePasswordType
        EventType.shared_link_settings_remove_password: (sharing) Removed the
        password from the shared link
    :ivar SharedLinkShareType EventType.shared_link_share: (sharing) Added
        members as audience of shared link
    :ivar SharedLinkViewType EventType.shared_link_view: (sharing) Opened shared
        link
    :ivar SharedNoteOpenedType EventType.shared_note_opened: (sharing) Opened
        shared Paper doc (deprecated, no longer logged)
    :ivar ShmodelDisableDownloadsType EventType.shmodel_disable_downloads:
        (sharing) Disabled downloads for link (deprecated, no longer logged)
    :ivar ShmodelEnableDownloadsType EventType.shmodel_enable_downloads:
        (sharing) Enabled downloads for link (deprecated, no longer logged)
    :ivar ShmodelGroupShareType EventType.shmodel_group_share: (sharing) Shared
        link with group (deprecated, no longer logged)
    :ivar ShowcaseAccessGrantedType EventType.showcase_access_granted:
        (showcase) Granted access to showcase
    :ivar ShowcaseAddMemberType EventType.showcase_add_member: (showcase) Added
        member to showcase
    :ivar ShowcaseArchivedType EventType.showcase_archived: (showcase) Archived
        showcase
    :ivar ShowcaseCreatedType EventType.showcase_created: (showcase) Created
        showcase
    :ivar ShowcaseDeleteCommentType EventType.showcase_delete_comment:
        (showcase) Deleted showcase comment
    :ivar ShowcaseEditedType EventType.showcase_edited: (showcase) Edited
        showcase
    :ivar ShowcaseEditCommentType EventType.showcase_edit_comment: (showcase)
        Edited showcase comment
    :ivar ShowcaseFileAddedType EventType.showcase_file_added: (showcase) Added
        file to showcase
    :ivar ShowcaseFileDownloadType EventType.showcase_file_download: (showcase)
        Downloaded file from showcase
    :ivar ShowcaseFileRemovedType EventType.showcase_file_removed: (showcase)
        Removed file from showcase
    :ivar ShowcaseFileViewType EventType.showcase_file_view: (showcase) Viewed
        file in showcase
    :ivar ShowcasePermanentlyDeletedType EventType.showcase_permanently_deleted:
        (showcase) Permanently deleted showcase
    :ivar ShowcasePostCommentType EventType.showcase_post_comment: (showcase)
        Added showcase comment
    :ivar ShowcaseRemoveMemberType EventType.showcase_remove_member: (showcase)
        Removed member from showcase
    :ivar ShowcaseRenamedType EventType.showcase_renamed: (showcase) Renamed
        showcase
    :ivar ShowcaseRequestAccessType EventType.showcase_request_access:
        (showcase) Requested access to showcase
    :ivar ShowcaseResolveCommentType EventType.showcase_resolve_comment:
        (showcase) Resolved showcase comment
    :ivar ShowcaseRestoredType EventType.showcase_restored: (showcase)
        Unarchived showcase
    :ivar ShowcaseTrashedType EventType.showcase_trashed: (showcase) Deleted
        showcase
    :ivar ShowcaseTrashedDeprecatedType EventType.showcase_trashed_deprecated:
        (showcase) Deleted showcase (old version) (deprecated, replaced by
        'Deleted showcase')
    :ivar ShowcaseUnresolveCommentType EventType.showcase_unresolve_comment:
        (showcase) Unresolved showcase comment
    :ivar ShowcaseUntrashedType EventType.showcase_untrashed: (showcase)
        Restored showcase
    :ivar ShowcaseUntrashedDeprecatedType
        EventType.showcase_untrashed_deprecated: (showcase) Restored showcase
        (old version) (deprecated, replaced by 'Restored showcase')
    :ivar ShowcaseViewType EventType.showcase_view: (showcase) Viewed showcase
    :ivar SsoAddCertType EventType.sso_add_cert: (sso) Added X.509 certificate
        for SSO
    :ivar SsoAddLoginUrlType EventType.sso_add_login_url: (sso) Added sign-in
        URL for SSO
    :ivar SsoAddLogoutUrlType EventType.sso_add_logout_url: (sso) Added sign-out
        URL for SSO
    :ivar SsoChangeCertType EventType.sso_change_cert: (sso) Changed X.509
        certificate for SSO
    :ivar SsoChangeLoginUrlType EventType.sso_change_login_url: (sso) Changed
        sign-in URL for SSO
    :ivar SsoChangeLogoutUrlType EventType.sso_change_logout_url: (sso) Changed
        sign-out URL for SSO
    :ivar SsoChangeSamlIdentityModeType EventType.sso_change_saml_identity_mode:
        (sso) Changed SAML identity mode for SSO
    :ivar SsoRemoveCertType EventType.sso_remove_cert: (sso) Removed X.509
        certificate for SSO
    :ivar SsoRemoveLoginUrlType EventType.sso_remove_login_url: (sso) Removed
        sign-in URL for SSO
    :ivar SsoRemoveLogoutUrlType EventType.sso_remove_logout_url: (sso) Removed
        sign-out URL for SSO
    :ivar TeamFolderChangeStatusType EventType.team_folder_change_status:
        (team_folders) Changed archival status of team folder
    :ivar TeamFolderCreateType EventType.team_folder_create: (team_folders)
        Created team folder in active status
    :ivar TeamFolderDowngradeType EventType.team_folder_downgrade:
        (team_folders) Downgraded team folder to regular shared folder
    :ivar TeamFolderPermanentlyDeleteType
        EventType.team_folder_permanently_delete: (team_folders) Permanently
        deleted archived team folder
    :ivar TeamFolderRenameType EventType.team_folder_rename: (team_folders)
        Renamed active/archived team folder
    :ivar TeamSelectiveSyncSettingsChangedType
        EventType.team_selective_sync_settings_changed: (team_folders) Changed
        sync default
    :ivar AccountCaptureChangePolicyType
        EventType.account_capture_change_policy: (team_policies) Changed account
        capture setting on team domain
    :ivar AllowDownloadDisabledType EventType.allow_download_disabled:
        (team_policies) Disabled downloads (deprecated, no longer logged)
    :ivar AllowDownloadEnabledType EventType.allow_download_enabled:
        (team_policies) Enabled downloads (deprecated, no longer logged)
    :ivar AppPermissionsChangedType EventType.app_permissions_changed:
        (team_policies) Changed app permissions
    :ivar CameraUploadsPolicyChangedType
        EventType.camera_uploads_policy_changed: (team_policies) Changed camera
        uploads setting for team
    :ivar CaptureTranscriptPolicyChangedType
        EventType.capture_transcript_policy_changed: (team_policies) Changed
        Capture transcription policy for team
    :ivar ClassificationChangePolicyType EventType.classification_change_policy:
        (team_policies) Changed classification policy for team
    :ivar ComputerBackupPolicyChangedType
        EventType.computer_backup_policy_changed: (team_policies) Changed
        computer backup policy for team
    :ivar ContentAdministrationPolicyChangedType
        EventType.content_administration_policy_changed: (team_policies) Changed
        content management setting
    :ivar DataPlacementRestrictionChangePolicyType
        EventType.data_placement_restriction_change_policy: (team_policies) Set
        restrictions on data center locations where team data resides
    :ivar DataPlacementRestrictionSatisfyPolicyType
        EventType.data_placement_restriction_satisfy_policy: (team_policies)
        Completed restrictions on data center locations where team data resides
    :ivar DeviceApprovalsAddExceptionType
        EventType.device_approvals_add_exception: (team_policies) Added members
        to device approvals exception list
    :ivar DeviceApprovalsChangeDesktopPolicyType
        EventType.device_approvals_change_desktop_policy: (team_policies)
        Set/removed limit on number of computers member can link to team Dropbox
        account
    :ivar DeviceApprovalsChangeMobilePolicyType
        EventType.device_approvals_change_mobile_policy: (team_policies)
        Set/removed limit on number of mobile devices member can link to team
        Dropbox account
    :ivar DeviceApprovalsChangeOverageActionType
        EventType.device_approvals_change_overage_action: (team_policies)
        Changed device approvals setting when member is over limit
    :ivar DeviceApprovalsChangeUnlinkActionType
        EventType.device_approvals_change_unlink_action: (team_policies) Changed
        device approvals setting when member unlinks approved device
    :ivar DeviceApprovalsRemoveExceptionType
        EventType.device_approvals_remove_exception: (team_policies) Removed
        members from device approvals exception list
    :ivar DirectoryRestrictionsAddMembersType
        EventType.directory_restrictions_add_members: (team_policies) Added
        members to directory restrictions list
    :ivar DirectoryRestrictionsRemoveMembersType
        EventType.directory_restrictions_remove_members: (team_policies) Removed
        members from directory restrictions list
    :ivar EmailIngestPolicyChangedType EventType.email_ingest_policy_changed:
        (team_policies) Changed email to my Dropbox policy for team
    :ivar EmmAddExceptionType EventType.emm_add_exception: (team_policies) Added
        members to EMM exception list
    :ivar EmmChangePolicyType EventType.emm_change_policy: (team_policies)
        Enabled/disabled enterprise mobility management for members
    :ivar EmmRemoveExceptionType EventType.emm_remove_exception: (team_policies)
        Removed members from EMM exception list
    :ivar ExtendedVersionHistoryChangePolicyType
        EventType.extended_version_history_change_policy: (team_policies)
        Accepted/opted out of extended version history
    :ivar ExternalDriveBackupPolicyChangedType
        EventType.external_drive_backup_policy_changed: (team_policies) Changed
        external drive backup policy for team
    :ivar FileCommentsChangePolicyType EventType.file_comments_change_policy:
        (team_policies) Enabled/disabled commenting on team files
    :ivar FileLockingPolicyChangedType EventType.file_locking_policy_changed:
        (team_policies) Changed file locking policy for team
    :ivar FileRequestsChangePolicyType EventType.file_requests_change_policy:
        (team_policies) Enabled/disabled file requests
    :ivar FileRequestsEmailsEnabledType EventType.file_requests_emails_enabled:
        (team_policies) Enabled file request emails for everyone (deprecated, no
        longer logged)
    :ivar FileRequestsEmailsRestrictedToTeamOnlyType
        EventType.file_requests_emails_restricted_to_team_only: (team_policies)
        Enabled file request emails for team (deprecated, no longer logged)
    :ivar FileTransfersPolicyChangedType
        EventType.file_transfers_policy_changed: (team_policies) Changed file
        transfers policy for team
    :ivar GoogleSsoChangePolicyType EventType.google_sso_change_policy:
        (team_policies) Enabled/disabled Google single sign-on for team
    :ivar GroupUserManagementChangePolicyType
        EventType.group_user_management_change_policy: (team_policies) Changed
        who can create groups
    :ivar IntegrationPolicyChangedType EventType.integration_policy_changed:
        (team_policies) Changed integration policy for team
    :ivar InviteAcceptanceEmailPolicyChangedType
        EventType.invite_acceptance_email_policy_changed: (team_policies)
        Changed invite accept email policy for team
    :ivar MemberRequestsChangePolicyType
        EventType.member_requests_change_policy: (team_policies) Changed whether
        users can find team when not invited
    :ivar MemberSendInvitePolicyChangedType
        EventType.member_send_invite_policy_changed: (team_policies) Changed
        member send invite policy for team
    :ivar MemberSpaceLimitsAddExceptionType
        EventType.member_space_limits_add_exception: (team_policies) Added
        members to member space limit exception list
    :ivar MemberSpaceLimitsChangeCapsTypePolicyType
        EventType.member_space_limits_change_caps_type_policy: (team_policies)
        Changed member space limit type for team
    :ivar MemberSpaceLimitsChangePolicyType
        EventType.member_space_limits_change_policy: (team_policies) Changed
        team default member space limit
    :ivar MemberSpaceLimitsRemoveExceptionType
        EventType.member_space_limits_remove_exception: (team_policies) Removed
        members from member space limit exception list
    :ivar MemberSuggestionsChangePolicyType
        EventType.member_suggestions_change_policy: (team_policies)
        Enabled/disabled option for team members to suggest people to add to
        team
    :ivar MicrosoftOfficeAddinChangePolicyType
        EventType.microsoft_office_addin_change_policy: (team_policies)
        Enabled/disabled Microsoft Office add-in
    :ivar NetworkControlChangePolicyType
        EventType.network_control_change_policy: (team_policies)
        Enabled/disabled network control
    :ivar PaperChangeDeploymentPolicyType
        EventType.paper_change_deployment_policy: (team_policies) Changed
        whether Dropbox Paper, when enabled, is deployed to all members or to
        specific members
    :ivar PaperChangeMemberLinkPolicyType
        EventType.paper_change_member_link_policy: (team_policies) Changed
        whether non-members can view Paper docs with link (deprecated, no longer
        logged)
    :ivar PaperChangeMemberPolicyType EventType.paper_change_member_policy:
        (team_policies) Changed whether members can share Paper docs outside
        team, and if docs are accessible only by team members or anyone by
        default
    :ivar PaperChangePolicyType EventType.paper_change_policy: (team_policies)
        Enabled/disabled Dropbox Paper for team
    :ivar PaperDefaultFolderPolicyChangedType
        EventType.paper_default_folder_policy_changed: (team_policies) Changed
        Paper Default Folder Policy setting for team
    :ivar PaperDesktopPolicyChangedType EventType.paper_desktop_policy_changed:
        (team_policies) Enabled/disabled Paper Desktop for team
    :ivar PaperEnabledUsersGroupAdditionType
        EventType.paper_enabled_users_group_addition: (team_policies) Added
        users to Paper-enabled users list
    :ivar PaperEnabledUsersGroupRemovalType
        EventType.paper_enabled_users_group_removal: (team_policies) Removed
        users from Paper-enabled users list
    :ivar PasswordStrengthRequirementsChangePolicyType
        EventType.password_strength_requirements_change_policy: (team_policies)
        Changed team password strength requirements
    :ivar PermanentDeleteChangePolicyType
        EventType.permanent_delete_change_policy: (team_policies)
        Enabled/disabled ability of team members to permanently delete content
    :ivar ResellerSupportChangePolicyType
        EventType.reseller_support_change_policy: (team_policies)
        Enabled/disabled reseller support
    :ivar RewindPolicyChangedType EventType.rewind_policy_changed:
        (team_policies) Changed Rewind policy for team
    :ivar SendForSignaturePolicyChangedType
        EventType.send_for_signature_policy_changed: (team_policies) Changed
        send for signature policy for team
    :ivar SharingChangeFolderJoinPolicyType
        EventType.sharing_change_folder_join_policy: (team_policies) Changed
        whether team members can join shared folders owned outside team
    :ivar SharingChangeLinkAllowChangeExpirationPolicyType
        EventType.sharing_change_link_allow_change_expiration_policy:
        (team_policies) Changed the allow remove or change expiration policy for
        the links shared outside of the team
    :ivar SharingChangeLinkDefaultExpirationPolicyType
        EventType.sharing_change_link_default_expiration_policy: (team_policies)
        Changed the default expiration for the links shared outside of the team
    :ivar SharingChangeLinkEnforcePasswordPolicyType
        EventType.sharing_change_link_enforce_password_policy: (team_policies)
        Changed the password requirement for the links shared outside of the
        team
    :ivar SharingChangeLinkPolicyType EventType.sharing_change_link_policy:
        (team_policies) Changed whether members can share links outside team,
        and if links are accessible only by team members or anyone by default
    :ivar SharingChangeMemberPolicyType EventType.sharing_change_member_policy:
        (team_policies) Changed whether members can share files/folders outside
        team
    :ivar ShowcaseChangeDownloadPolicyType
        EventType.showcase_change_download_policy: (team_policies)
        Enabled/disabled downloading files from Dropbox Showcase for team
    :ivar ShowcaseChangeEnabledPolicyType
        EventType.showcase_change_enabled_policy: (team_policies)
        Enabled/disabled Dropbox Showcase for team
    :ivar ShowcaseChangeExternalSharingPolicyType
        EventType.showcase_change_external_sharing_policy: (team_policies)
        Enabled/disabled sharing Dropbox Showcase externally for team
    :ivar SmarterSmartSyncPolicyChangedType
        EventType.smarter_smart_sync_policy_changed: (team_policies) Changed
        automatic Smart Sync setting for team
    :ivar SmartSyncChangePolicyType EventType.smart_sync_change_policy:
        (team_policies) Changed default Smart Sync setting for team members
    :ivar SmartSyncNotOptOutType EventType.smart_sync_not_opt_out:
        (team_policies) Opted team into Smart Sync
    :ivar SmartSyncOptOutType EventType.smart_sync_opt_out: (team_policies)
        Opted team out of Smart Sync
    :ivar SsoChangePolicyType EventType.sso_change_policy: (team_policies)
        Changed single sign-on setting for team
    :ivar TeamBrandingPolicyChangedType EventType.team_branding_policy_changed:
        (team_policies) Changed team branding policy for team
    :ivar TeamExtensionsPolicyChangedType
        EventType.team_extensions_policy_changed: (team_policies) Changed App
        Integrations setting for team
    :ivar TeamSelectiveSyncPolicyChangedType
        EventType.team_selective_sync_policy_changed: (team_policies)
        Enabled/disabled Team Selective Sync for team
    :ivar TeamSharingWhitelistSubjectsChangedType
        EventType.team_sharing_whitelist_subjects_changed: (team_policies)
        Edited the approved list for sharing externally
    :ivar TfaAddExceptionType EventType.tfa_add_exception: (team_policies) Added
        members to two factor authentication exception list
    :ivar TfaChangePolicyType EventType.tfa_change_policy: (team_policies)
        Changed two-step verification setting for team
    :ivar TfaRemoveExceptionType EventType.tfa_remove_exception: (team_policies)
        Removed members from two factor authentication exception list
    :ivar TwoAccountChangePolicyType EventType.two_account_change_policy:
        (team_policies) Enabled/disabled option for members to link personal
        Dropbox account and team account to same computer
    :ivar ViewerInfoPolicyChangedType EventType.viewer_info_policy_changed:
        (team_policies) Changed team policy for viewer info
    :ivar WatermarkingPolicyChangedType EventType.watermarking_policy_changed:
        (team_policies) Changed watermarking policy for team
    :ivar WebSessionsChangeActiveSessionLimitType
        EventType.web_sessions_change_active_session_limit: (team_policies)
        Changed limit on active sessions per member
    :ivar WebSessionsChangeFixedLengthPolicyType
        EventType.web_sessions_change_fixed_length_policy: (team_policies)
        Changed how long members can stay signed in to Dropbox.com
    :ivar WebSessionsChangeIdleLengthPolicyType
        EventType.web_sessions_change_idle_length_policy: (team_policies)
        Changed how long team members can be idle while signed in to Dropbox.com
    :ivar DataResidencyMigrationRequestSuccessfulType
        EventType.data_residency_migration_request_successful: (team_profile)
        Requested data residency migration for team data
    :ivar DataResidencyMigrationRequestUnsuccessfulType
        EventType.data_residency_migration_request_unsuccessful: (team_profile)
        Request for data residency migration for team data has failed
    :ivar TeamMergeFromType EventType.team_merge_from: (team_profile) Merged
        another team into this team
    :ivar TeamMergeToType EventType.team_merge_to: (team_profile) Merged this
        team into another team
    :ivar TeamProfileAddBackgroundType EventType.team_profile_add_background:
        (team_profile) Added team background to display on shared link headers
    :ivar TeamProfileAddLogoType EventType.team_profile_add_logo: (team_profile)
        Added team logo to display on shared link headers
    :ivar TeamProfileChangeBackgroundType
        EventType.team_profile_change_background: (team_profile) Changed team
        background displayed on shared link headers
    :ivar TeamProfileChangeDefaultLanguageType
        EventType.team_profile_change_default_language: (team_profile) Changed
        default language for team
    :ivar TeamProfileChangeLogoType EventType.team_profile_change_logo:
        (team_profile) Changed team logo displayed on shared link headers
    :ivar TeamProfileChangeNameType EventType.team_profile_change_name:
        (team_profile) Changed team name
    :ivar TeamProfileRemoveBackgroundType
        EventType.team_profile_remove_background: (team_profile) Removed team
        background displayed on shared link headers
    :ivar TeamProfileRemoveLogoType EventType.team_profile_remove_logo:
        (team_profile) Removed team logo displayed on shared link headers
    :ivar TfaAddBackupPhoneType EventType.tfa_add_backup_phone: (tfa) Added
        backup phone for two-step verification
    :ivar TfaAddSecurityKeyType EventType.tfa_add_security_key: (tfa) Added
        security key for two-step verification
    :ivar TfaChangeBackupPhoneType EventType.tfa_change_backup_phone: (tfa)
        Changed backup phone for two-step verification
    :ivar TfaChangeStatusType EventType.tfa_change_status: (tfa)
        Enabled/disabled/changed two-step verification setting
    :ivar TfaRemoveBackupPhoneType EventType.tfa_remove_backup_phone: (tfa)
        Removed backup phone for two-step verification
    :ivar TfaRemoveSecurityKeyType EventType.tfa_remove_security_key: (tfa)
        Removed security key for two-step verification
    :ivar TfaResetType EventType.tfa_reset: (tfa) Reset two-step verification
        for team member
    :ivar ChangedEnterpriseAdminRoleType
        EventType.changed_enterprise_admin_role: (trusted_teams) Changed
        enterprise admin role
    :ivar ChangedEnterpriseConnectedTeamStatusType
        EventType.changed_enterprise_connected_team_status: (trusted_teams)
        Changed enterprise-connected team status
    :ivar EndedEnterpriseAdminSessionType
        EventType.ended_enterprise_admin_session: (trusted_teams) Ended
        enterprise admin session
    :ivar EndedEnterpriseAdminSessionDeprecatedType
        EventType.ended_enterprise_admin_session_deprecated: (trusted_teams)
        Ended enterprise admin session (deprecated, replaced by 'Ended
        enterprise admin session')
    :ivar EnterpriseSettingsLockingType EventType.enterprise_settings_locking:
        (trusted_teams) Changed who can update a setting
    :ivar GuestAdminChangeStatusType EventType.guest_admin_change_status:
        (trusted_teams) Changed guest team admin status
    :ivar StartedEnterpriseAdminSessionType
        EventType.started_enterprise_admin_session: (trusted_teams) Started
        enterprise admin session
    :ivar TeamMergeRequestAcceptedType EventType.team_merge_request_accepted:
        (trusted_teams) Accepted a team merge request
    :ivar TeamMergeRequestAcceptedShownToPrimaryTeamType
        EventType.team_merge_request_accepted_shown_to_primary_team:
        (trusted_teams) Accepted a team merge request (deprecated, replaced by
        'Accepted a team merge request')
    :ivar TeamMergeRequestAcceptedShownToSecondaryTeamType
        EventType.team_merge_request_accepted_shown_to_secondary_team:
        (trusted_teams) Accepted a team merge request (deprecated, replaced by
        'Accepted a team merge request')
    :ivar TeamMergeRequestAutoCanceledType
        EventType.team_merge_request_auto_canceled: (trusted_teams)
        Automatically canceled team merge request
    :ivar TeamMergeRequestCanceledType EventType.team_merge_request_canceled:
        (trusted_teams) Canceled a team merge request
    :ivar TeamMergeRequestCanceledShownToPrimaryTeamType
        EventType.team_merge_request_canceled_shown_to_primary_team:
        (trusted_teams) Canceled a team merge request (deprecated, replaced by
        'Canceled a team merge request')
    :ivar TeamMergeRequestCanceledShownToSecondaryTeamType
        EventType.team_merge_request_canceled_shown_to_secondary_team:
        (trusted_teams) Canceled a team merge request (deprecated, replaced by
        'Canceled a team merge request')
    :ivar TeamMergeRequestExpiredType EventType.team_merge_request_expired:
        (trusted_teams) Team merge request expired
    :ivar TeamMergeRequestExpiredShownToPrimaryTeamType
        EventType.team_merge_request_expired_shown_to_primary_team:
        (trusted_teams) Team merge request expired (deprecated, replaced by
        'Team merge request expired')
    :ivar TeamMergeRequestExpiredShownToSecondaryTeamType
        EventType.team_merge_request_expired_shown_to_secondary_team:
        (trusted_teams) Team merge request expired (deprecated, replaced by
        'Team merge request expired')
    :ivar TeamMergeRequestRejectedShownToPrimaryTeamType
        EventType.team_merge_request_rejected_shown_to_primary_team:
        (trusted_teams) Rejected a team merge request (deprecated, no longer
        logged)
    :ivar TeamMergeRequestRejectedShownToSecondaryTeamType
        EventType.team_merge_request_rejected_shown_to_secondary_team:
        (trusted_teams) Rejected a team merge request (deprecated, no longer
        logged)
    :ivar TeamMergeRequestReminderType EventType.team_merge_request_reminder:
        (trusted_teams) Sent a team merge request reminder
    :ivar TeamMergeRequestReminderShownToPrimaryTeamType
        EventType.team_merge_request_reminder_shown_to_primary_team:
        (trusted_teams) Sent a team merge request reminder (deprecated, replaced
        by 'Sent a team merge request reminder')
    :ivar TeamMergeRequestReminderShownToSecondaryTeamType
        EventType.team_merge_request_reminder_shown_to_secondary_team:
        (trusted_teams) Sent a team merge request reminder (deprecated, replaced
        by 'Sent a team merge request reminder')
    :ivar TeamMergeRequestRevokedType EventType.team_merge_request_revoked:
        (trusted_teams) Canceled the team merge
    :ivar TeamMergeRequestSentShownToPrimaryTeamType
        EventType.team_merge_request_sent_shown_to_primary_team: (trusted_teams)
        Requested to merge their Dropbox team into yours
    :ivar TeamMergeRequestSentShownToSecondaryTeamType
        EventType.team_merge_request_sent_shown_to_secondary_team:
        (trusted_teams) Requested to merge your team into another Dropbox team
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def admin_alerting_alert_state_changed(cls, val):
        """
        Create an instance of this class set to the
        ``admin_alerting_alert_state_changed`` tag with value ``val``.

        :param AdminAlertingAlertStateChangedType val:
        :rtype: EventType
        """
        return cls('admin_alerting_alert_state_changed', val)

    @classmethod
    def admin_alerting_changed_alert_config(cls, val):
        """
        Create an instance of this class set to the
        ``admin_alerting_changed_alert_config`` tag with value ``val``.

        :param AdminAlertingChangedAlertConfigType val:
        :rtype: EventType
        """
        return cls('admin_alerting_changed_alert_config', val)

    @classmethod
    def admin_alerting_triggered_alert(cls, val):
        """
        Create an instance of this class set to the
        ``admin_alerting_triggered_alert`` tag with value ``val``.

        :param AdminAlertingTriggeredAlertType val:
        :rtype: EventType
        """
        return cls('admin_alerting_triggered_alert', val)

    @classmethod
    def app_blocked_by_permissions(cls, val):
        """
        Create an instance of this class set to the
        ``app_blocked_by_permissions`` tag with value ``val``.

        :param AppBlockedByPermissionsType val:
        :rtype: EventType
        """
        return cls('app_blocked_by_permissions', val)

    @classmethod
    def app_link_team(cls, val):
        """
        Create an instance of this class set to the ``app_link_team`` tag with
        value ``val``.

        :param AppLinkTeamType val:
        :rtype: EventType
        """
        return cls('app_link_team', val)

    @classmethod
    def app_link_user(cls, val):
        """
        Create an instance of this class set to the ``app_link_user`` tag with
        value ``val``.

        :param AppLinkUserType val:
        :rtype: EventType
        """
        return cls('app_link_user', val)

    @classmethod
    def app_unlink_team(cls, val):
        """
        Create an instance of this class set to the ``app_unlink_team`` tag with
        value ``val``.

        :param AppUnlinkTeamType val:
        :rtype: EventType
        """
        return cls('app_unlink_team', val)

    @classmethod
    def app_unlink_user(cls, val):
        """
        Create an instance of this class set to the ``app_unlink_user`` tag with
        value ``val``.

        :param AppUnlinkUserType val:
        :rtype: EventType
        """
        return cls('app_unlink_user', val)

    @classmethod
    def integration_connected(cls, val):
        """
        Create an instance of this class set to the ``integration_connected``
        tag with value ``val``.

        :param IntegrationConnectedType val:
        :rtype: EventType
        """
        return cls('integration_connected', val)

    @classmethod
    def integration_disconnected(cls, val):
        """
        Create an instance of this class set to the ``integration_disconnected``
        tag with value ``val``.

        :param IntegrationDisconnectedType val:
        :rtype: EventType
        """
        return cls('integration_disconnected', val)

    @classmethod
    def file_add_comment(cls, val):
        """
        Create an instance of this class set to the ``file_add_comment`` tag
        with value ``val``.

        :param FileAddCommentType val:
        :rtype: EventType
        """
        return cls('file_add_comment', val)

    @classmethod
    def file_change_comment_subscription(cls, val):
        """
        Create an instance of this class set to the
        ``file_change_comment_subscription`` tag with value ``val``.

        :param FileChangeCommentSubscriptionType val:
        :rtype: EventType
        """
        return cls('file_change_comment_subscription', val)

    @classmethod
    def file_delete_comment(cls, val):
        """
        Create an instance of this class set to the ``file_delete_comment`` tag
        with value ``val``.

        :param FileDeleteCommentType val:
        :rtype: EventType
        """
        return cls('file_delete_comment', val)

    @classmethod
    def file_edit_comment(cls, val):
        """
        Create an instance of this class set to the ``file_edit_comment`` tag
        with value ``val``.

        :param FileEditCommentType val:
        :rtype: EventType
        """
        return cls('file_edit_comment', val)

    @classmethod
    def file_like_comment(cls, val):
        """
        Create an instance of this class set to the ``file_like_comment`` tag
        with value ``val``.

        :param FileLikeCommentType val:
        :rtype: EventType
        """
        return cls('file_like_comment', val)

    @classmethod
    def file_resolve_comment(cls, val):
        """
        Create an instance of this class set to the ``file_resolve_comment`` tag
        with value ``val``.

        :param FileResolveCommentType val:
        :rtype: EventType
        """
        return cls('file_resolve_comment', val)

    @classmethod
    def file_unlike_comment(cls, val):
        """
        Create an instance of this class set to the ``file_unlike_comment`` tag
        with value ``val``.

        :param FileUnlikeCommentType val:
        :rtype: EventType
        """
        return cls('file_unlike_comment', val)

    @classmethod
    def file_unresolve_comment(cls, val):
        """
        Create an instance of this class set to the ``file_unresolve_comment``
        tag with value ``val``.

        :param FileUnresolveCommentType val:
        :rtype: EventType
        """
        return cls('file_unresolve_comment', val)

    @classmethod
    def governance_policy_add_folders(cls, val):
        """
        Create an instance of this class set to the
        ``governance_policy_add_folders`` tag with value ``val``.

        :param GovernancePolicyAddFoldersType val:
        :rtype: EventType
        """
        return cls('governance_policy_add_folders', val)

    @classmethod
    def governance_policy_add_folder_failed(cls, val):
        """
        Create an instance of this class set to the
        ``governance_policy_add_folder_failed`` tag with value ``val``.

        :param GovernancePolicyAddFolderFailedType val:
        :rtype: EventType
        """
        return cls('governance_policy_add_folder_failed', val)

    @classmethod
    def governance_policy_content_disposed(cls, val):
        """
        Create an instance of this class set to the
        ``governance_policy_content_disposed`` tag with value ``val``.

        :param GovernancePolicyContentDisposedType val:
        :rtype: EventType
        """
        return cls('governance_policy_content_disposed', val)

    @classmethod
    def governance_policy_create(cls, val):
        """
        Create an instance of this class set to the ``governance_policy_create``
        tag with value ``val``.

        :param GovernancePolicyCreateType val:
        :rtype: EventType
        """
        return cls('governance_policy_create', val)

    @classmethod
    def governance_policy_delete(cls, val):
        """
        Create an instance of this class set to the ``governance_policy_delete``
        tag with value ``val``.

        :param GovernancePolicyDeleteType val:
        :rtype: EventType
        """
        return cls('governance_policy_delete', val)

    @classmethod
    def governance_policy_edit_details(cls, val):
        """
        Create an instance of this class set to the
        ``governance_policy_edit_details`` tag with value ``val``.

        :param GovernancePolicyEditDetailsType val:
        :rtype: EventType
        """
        return cls('governance_policy_edit_details', val)

    @classmethod
    def governance_policy_edit_duration(cls, val):
        """
        Create an instance of this class set to the
        ``governance_policy_edit_duration`` tag with value ``val``.

        :param GovernancePolicyEditDurationType val:
        :rtype: EventType
        """
        return cls('governance_policy_edit_duration', val)

    @classmethod
    def governance_policy_export_created(cls, val):
        """
        Create an instance of this class set to the
        ``governance_policy_export_created`` tag with value ``val``.

        :param GovernancePolicyExportCreatedType val:
        :rtype: EventType
        """
        return cls('governance_policy_export_created', val)

    @classmethod
    def governance_policy_export_removed(cls, val):
        """
        Create an instance of this class set to the
        ``governance_policy_export_removed`` tag with value ``val``.

        :param GovernancePolicyExportRemovedType val:
        :rtype: EventType
        """
        return cls('governance_policy_export_removed', val)

    @classmethod
    def governance_policy_remove_folders(cls, val):
        """
        Create an instance of this class set to the
        ``governance_policy_remove_folders`` tag with value ``val``.

        :param GovernancePolicyRemoveFoldersType val:
        :rtype: EventType
        """
        return cls('governance_policy_remove_folders', val)

    @classmethod
    def governance_policy_report_created(cls, val):
        """
        Create an instance of this class set to the
        ``governance_policy_report_created`` tag with value ``val``.

        :param GovernancePolicyReportCreatedType val:
        :rtype: EventType
        """
        return cls('governance_policy_report_created', val)

    @classmethod
    def governance_policy_zip_part_downloaded(cls, val):
        """
        Create an instance of this class set to the
        ``governance_policy_zip_part_downloaded`` tag with value ``val``.

        :param GovernancePolicyZipPartDownloadedType val:
        :rtype: EventType
        """
        return cls('governance_policy_zip_part_downloaded', val)

    @classmethod
    def legal_holds_activate_a_hold(cls, val):
        """
        Create an instance of this class set to the
        ``legal_holds_activate_a_hold`` tag with value ``val``.

        :param LegalHoldsActivateAHoldType val:
        :rtype: EventType
        """
        return cls('legal_holds_activate_a_hold', val)

    @classmethod
    def legal_holds_add_members(cls, val):
        """
        Create an instance of this class set to the ``legal_holds_add_members``
        tag with value ``val``.

        :param LegalHoldsAddMembersType val:
        :rtype: EventType
        """
        return cls('legal_holds_add_members', val)

    @classmethod
    def legal_holds_change_hold_details(cls, val):
        """
        Create an instance of this class set to the
        ``legal_holds_change_hold_details`` tag with value ``val``.

        :param LegalHoldsChangeHoldDetailsType val:
        :rtype: EventType
        """
        return cls('legal_holds_change_hold_details', val)

    @classmethod
    def legal_holds_change_hold_name(cls, val):
        """
        Create an instance of this class set to the
        ``legal_holds_change_hold_name`` tag with value ``val``.

        :param LegalHoldsChangeHoldNameType val:
        :rtype: EventType
        """
        return cls('legal_holds_change_hold_name', val)

    @classmethod
    def legal_holds_export_a_hold(cls, val):
        """
        Create an instance of this class set to the
        ``legal_holds_export_a_hold`` tag with value ``val``.

        :param LegalHoldsExportAHoldType val:
        :rtype: EventType
        """
        return cls('legal_holds_export_a_hold', val)

    @classmethod
    def legal_holds_export_cancelled(cls, val):
        """
        Create an instance of this class set to the
        ``legal_holds_export_cancelled`` tag with value ``val``.

        :param LegalHoldsExportCancelledType val:
        :rtype: EventType
        """
        return cls('legal_holds_export_cancelled', val)

    @classmethod
    def legal_holds_export_downloaded(cls, val):
        """
        Create an instance of this class set to the
        ``legal_holds_export_downloaded`` tag with value ``val``.

        :param LegalHoldsExportDownloadedType val:
        :rtype: EventType
        """
        return cls('legal_holds_export_downloaded', val)

    @classmethod
    def legal_holds_export_removed(cls, val):
        """
        Create an instance of this class set to the
        ``legal_holds_export_removed`` tag with value ``val``.

        :param LegalHoldsExportRemovedType val:
        :rtype: EventType
        """
        return cls('legal_holds_export_removed', val)

    @classmethod
    def legal_holds_release_a_hold(cls, val):
        """
        Create an instance of this class set to the
        ``legal_holds_release_a_hold`` tag with value ``val``.

        :param LegalHoldsReleaseAHoldType val:
        :rtype: EventType
        """
        return cls('legal_holds_release_a_hold', val)

    @classmethod
    def legal_holds_remove_members(cls, val):
        """
        Create an instance of this class set to the
        ``legal_holds_remove_members`` tag with value ``val``.

        :param LegalHoldsRemoveMembersType val:
        :rtype: EventType
        """
        return cls('legal_holds_remove_members', val)

    @classmethod
    def legal_holds_report_a_hold(cls, val):
        """
        Create an instance of this class set to the
        ``legal_holds_report_a_hold`` tag with value ``val``.

        :param LegalHoldsReportAHoldType val:
        :rtype: EventType
        """
        return cls('legal_holds_report_a_hold', val)

    @classmethod
    def device_change_ip_desktop(cls, val):
        """
        Create an instance of this class set to the ``device_change_ip_desktop``
        tag with value ``val``.

        :param DeviceChangeIpDesktopType val:
        :rtype: EventType
        """
        return cls('device_change_ip_desktop', val)

    @classmethod
    def device_change_ip_mobile(cls, val):
        """
        Create an instance of this class set to the ``device_change_ip_mobile``
        tag with value ``val``.

        :param DeviceChangeIpMobileType val:
        :rtype: EventType
        """
        return cls('device_change_ip_mobile', val)

    @classmethod
    def device_change_ip_web(cls, val):
        """
        Create an instance of this class set to the ``device_change_ip_web`` tag
        with value ``val``.

        :param DeviceChangeIpWebType val:
        :rtype: EventType
        """
        return cls('device_change_ip_web', val)

    @classmethod
    def device_delete_on_unlink_fail(cls, val):
        """
        Create an instance of this class set to the
        ``device_delete_on_unlink_fail`` tag with value ``val``.

        :param DeviceDeleteOnUnlinkFailType val:
        :rtype: EventType
        """
        return cls('device_delete_on_unlink_fail', val)

    @classmethod
    def device_delete_on_unlink_success(cls, val):
        """
        Create an instance of this class set to the
        ``device_delete_on_unlink_success`` tag with value ``val``.

        :param DeviceDeleteOnUnlinkSuccessType val:
        :rtype: EventType
        """
        return cls('device_delete_on_unlink_success', val)

    @classmethod
    def device_link_fail(cls, val):
        """
        Create an instance of this class set to the ``device_link_fail`` tag
        with value ``val``.

        :param DeviceLinkFailType val:
        :rtype: EventType
        """
        return cls('device_link_fail', val)

    @classmethod
    def device_link_success(cls, val):
        """
        Create an instance of this class set to the ``device_link_success`` tag
        with value ``val``.

        :param DeviceLinkSuccessType val:
        :rtype: EventType
        """
        return cls('device_link_success', val)

    @classmethod
    def device_management_disabled(cls, val):
        """
        Create an instance of this class set to the
        ``device_management_disabled`` tag with value ``val``.

        :param DeviceManagementDisabledType val:
        :rtype: EventType
        """
        return cls('device_management_disabled', val)

    @classmethod
    def device_management_enabled(cls, val):
        """
        Create an instance of this class set to the
        ``device_management_enabled`` tag with value ``val``.

        :param DeviceManagementEnabledType val:
        :rtype: EventType
        """
        return cls('device_management_enabled', val)

    @classmethod
    def device_sync_backup_status_changed(cls, val):
        """
        Create an instance of this class set to the
        ``device_sync_backup_status_changed`` tag with value ``val``.

        :param DeviceSyncBackupStatusChangedType val:
        :rtype: EventType
        """
        return cls('device_sync_backup_status_changed', val)

    @classmethod
    def device_unlink(cls, val):
        """
        Create an instance of this class set to the ``device_unlink`` tag with
        value ``val``.

        :param DeviceUnlinkType val:
        :rtype: EventType
        """
        return cls('device_unlink', val)

    @classmethod
    def dropbox_passwords_exported(cls, val):
        """
        Create an instance of this class set to the
        ``dropbox_passwords_exported`` tag with value ``val``.

        :param DropboxPasswordsExportedType val:
        :rtype: EventType
        """
        return cls('dropbox_passwords_exported', val)

    @classmethod
    def dropbox_passwords_new_device_enrolled(cls, val):
        """
        Create an instance of this class set to the
        ``dropbox_passwords_new_device_enrolled`` tag with value ``val``.

        :param DropboxPasswordsNewDeviceEnrolledType val:
        :rtype: EventType
        """
        return cls('dropbox_passwords_new_device_enrolled', val)

    @classmethod
    def emm_refresh_auth_token(cls, val):
        """
        Create an instance of this class set to the ``emm_refresh_auth_token``
        tag with value ``val``.

        :param EmmRefreshAuthTokenType val:
        :rtype: EventType
        """
        return cls('emm_refresh_auth_token', val)

    @classmethod
    def account_capture_change_availability(cls, val):
        """
        Create an instance of this class set to the
        ``account_capture_change_availability`` tag with value ``val``.

        :param AccountCaptureChangeAvailabilityType val:
        :rtype: EventType
        """
        return cls('account_capture_change_availability', val)

    @classmethod
    def account_capture_migrate_account(cls, val):
        """
        Create an instance of this class set to the
        ``account_capture_migrate_account`` tag with value ``val``.

        :param AccountCaptureMigrateAccountType val:
        :rtype: EventType
        """
        return cls('account_capture_migrate_account', val)

    @classmethod
    def account_capture_notification_emails_sent(cls, val):
        """
        Create an instance of this class set to the
        ``account_capture_notification_emails_sent`` tag with value ``val``.

        :param AccountCaptureNotificationEmailsSentType val:
        :rtype: EventType
        """
        return cls('account_capture_notification_emails_sent', val)

    @classmethod
    def account_capture_relinquish_account(cls, val):
        """
        Create an instance of this class set to the
        ``account_capture_relinquish_account`` tag with value ``val``.

        :param AccountCaptureRelinquishAccountType val:
        :rtype: EventType
        """
        return cls('account_capture_relinquish_account', val)

    @classmethod
    def disabled_domain_invites(cls, val):
        """
        Create an instance of this class set to the ``disabled_domain_invites``
        tag with value ``val``.

        :param DisabledDomainInvitesType val:
        :rtype: EventType
        """
        return cls('disabled_domain_invites', val)

    @classmethod
    def domain_invites_approve_request_to_join_team(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_approve_request_to_join_team`` tag with value ``val``.

        :param DomainInvitesApproveRequestToJoinTeamType val:
        :rtype: EventType
        """
        return cls('domain_invites_approve_request_to_join_team', val)

    @classmethod
    def domain_invites_decline_request_to_join_team(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_decline_request_to_join_team`` tag with value ``val``.

        :param DomainInvitesDeclineRequestToJoinTeamType val:
        :rtype: EventType
        """
        return cls('domain_invites_decline_request_to_join_team', val)

    @classmethod
    def domain_invites_email_existing_users(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_email_existing_users`` tag with value ``val``.

        :param DomainInvitesEmailExistingUsersType val:
        :rtype: EventType
        """
        return cls('domain_invites_email_existing_users', val)

    @classmethod
    def domain_invites_request_to_join_team(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_request_to_join_team`` tag with value ``val``.

        :param DomainInvitesRequestToJoinTeamType val:
        :rtype: EventType
        """
        return cls('domain_invites_request_to_join_team', val)

    @classmethod
    def domain_invites_set_invite_new_user_pref_to_no(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_set_invite_new_user_pref_to_no`` tag with value
        ``val``.

        :param DomainInvitesSetInviteNewUserPrefToNoType val:
        :rtype: EventType
        """
        return cls('domain_invites_set_invite_new_user_pref_to_no', val)

    @classmethod
    def domain_invites_set_invite_new_user_pref_to_yes(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_set_invite_new_user_pref_to_yes`` tag with value
        ``val``.

        :param DomainInvitesSetInviteNewUserPrefToYesType val:
        :rtype: EventType
        """
        return cls('domain_invites_set_invite_new_user_pref_to_yes', val)

    @classmethod
    def domain_verification_add_domain_fail(cls, val):
        """
        Create an instance of this class set to the
        ``domain_verification_add_domain_fail`` tag with value ``val``.

        :param DomainVerificationAddDomainFailType val:
        :rtype: EventType
        """
        return cls('domain_verification_add_domain_fail', val)

    @classmethod
    def domain_verification_add_domain_success(cls, val):
        """
        Create an instance of this class set to the
        ``domain_verification_add_domain_success`` tag with value ``val``.

        :param DomainVerificationAddDomainSuccessType val:
        :rtype: EventType
        """
        return cls('domain_verification_add_domain_success', val)

    @classmethod
    def domain_verification_remove_domain(cls, val):
        """
        Create an instance of this class set to the
        ``domain_verification_remove_domain`` tag with value ``val``.

        :param DomainVerificationRemoveDomainType val:
        :rtype: EventType
        """
        return cls('domain_verification_remove_domain', val)

    @classmethod
    def enabled_domain_invites(cls, val):
        """
        Create an instance of this class set to the ``enabled_domain_invites``
        tag with value ``val``.

        :param EnabledDomainInvitesType val:
        :rtype: EventType
        """
        return cls('enabled_domain_invites', val)

    @classmethod
    def apply_naming_convention(cls, val):
        """
        Create an instance of this class set to the ``apply_naming_convention``
        tag with value ``val``.

        :param ApplyNamingConventionType val:
        :rtype: EventType
        """
        return cls('apply_naming_convention', val)

    @classmethod
    def create_folder(cls, val):
        """
        Create an instance of this class set to the ``create_folder`` tag with
        value ``val``.

        :param CreateFolderType val:
        :rtype: EventType
        """
        return cls('create_folder', val)

    @classmethod
    def file_add(cls, val):
        """
        Create an instance of this class set to the ``file_add`` tag with value
        ``val``.

        :param FileAddType val:
        :rtype: EventType
        """
        return cls('file_add', val)

    @classmethod
    def file_copy(cls, val):
        """
        Create an instance of this class set to the ``file_copy`` tag with value
        ``val``.

        :param FileCopyType val:
        :rtype: EventType
        """
        return cls('file_copy', val)

    @classmethod
    def file_delete(cls, val):
        """
        Create an instance of this class set to the ``file_delete`` tag with
        value ``val``.

        :param FileDeleteType val:
        :rtype: EventType
        """
        return cls('file_delete', val)

    @classmethod
    def file_download(cls, val):
        """
        Create an instance of this class set to the ``file_download`` tag with
        value ``val``.

        :param FileDownloadType val:
        :rtype: EventType
        """
        return cls('file_download', val)

    @classmethod
    def file_edit(cls, val):
        """
        Create an instance of this class set to the ``file_edit`` tag with value
        ``val``.

        :param FileEditType val:
        :rtype: EventType
        """
        return cls('file_edit', val)

    @classmethod
    def file_get_copy_reference(cls, val):
        """
        Create an instance of this class set to the ``file_get_copy_reference``
        tag with value ``val``.

        :param FileGetCopyReferenceType val:
        :rtype: EventType
        """
        return cls('file_get_copy_reference', val)

    @classmethod
    def file_locking_lock_status_changed(cls, val):
        """
        Create an instance of this class set to the
        ``file_locking_lock_status_changed`` tag with value ``val``.

        :param FileLockingLockStatusChangedType val:
        :rtype: EventType
        """
        return cls('file_locking_lock_status_changed', val)

    @classmethod
    def file_move(cls, val):
        """
        Create an instance of this class set to the ``file_move`` tag with value
        ``val``.

        :param FileMoveType val:
        :rtype: EventType
        """
        return cls('file_move', val)

    @classmethod
    def file_permanently_delete(cls, val):
        """
        Create an instance of this class set to the ``file_permanently_delete``
        tag with value ``val``.

        :param FilePermanentlyDeleteType val:
        :rtype: EventType
        """
        return cls('file_permanently_delete', val)

    @classmethod
    def file_preview(cls, val):
        """
        Create an instance of this class set to the ``file_preview`` tag with
        value ``val``.

        :param FilePreviewType val:
        :rtype: EventType
        """
        return cls('file_preview', val)

    @classmethod
    def file_rename(cls, val):
        """
        Create an instance of this class set to the ``file_rename`` tag with
        value ``val``.

        :param FileRenameType val:
        :rtype: EventType
        """
        return cls('file_rename', val)

    @classmethod
    def file_restore(cls, val):
        """
        Create an instance of this class set to the ``file_restore`` tag with
        value ``val``.

        :param FileRestoreType val:
        :rtype: EventType
        """
        return cls('file_restore', val)

    @classmethod
    def file_revert(cls, val):
        """
        Create an instance of this class set to the ``file_revert`` tag with
        value ``val``.

        :param FileRevertType val:
        :rtype: EventType
        """
        return cls('file_revert', val)

    @classmethod
    def file_rollback_changes(cls, val):
        """
        Create an instance of this class set to the ``file_rollback_changes``
        tag with value ``val``.

        :param FileRollbackChangesType val:
        :rtype: EventType
        """
        return cls('file_rollback_changes', val)

    @classmethod
    def file_save_copy_reference(cls, val):
        """
        Create an instance of this class set to the ``file_save_copy_reference``
        tag with value ``val``.

        :param FileSaveCopyReferenceType val:
        :rtype: EventType
        """
        return cls('file_save_copy_reference', val)

    @classmethod
    def folder_overview_description_changed(cls, val):
        """
        Create an instance of this class set to the
        ``folder_overview_description_changed`` tag with value ``val``.

        :param FolderOverviewDescriptionChangedType val:
        :rtype: EventType
        """
        return cls('folder_overview_description_changed', val)

    @classmethod
    def folder_overview_item_pinned(cls, val):
        """
        Create an instance of this class set to the
        ``folder_overview_item_pinned`` tag with value ``val``.

        :param FolderOverviewItemPinnedType val:
        :rtype: EventType
        """
        return cls('folder_overview_item_pinned', val)

    @classmethod
    def folder_overview_item_unpinned(cls, val):
        """
        Create an instance of this class set to the
        ``folder_overview_item_unpinned`` tag with value ``val``.

        :param FolderOverviewItemUnpinnedType val:
        :rtype: EventType
        """
        return cls('folder_overview_item_unpinned', val)

    @classmethod
    def object_label_added(cls, val):
        """
        Create an instance of this class set to the ``object_label_added`` tag
        with value ``val``.

        :param ObjectLabelAddedType val:
        :rtype: EventType
        """
        return cls('object_label_added', val)

    @classmethod
    def object_label_removed(cls, val):
        """
        Create an instance of this class set to the ``object_label_removed`` tag
        with value ``val``.

        :param ObjectLabelRemovedType val:
        :rtype: EventType
        """
        return cls('object_label_removed', val)

    @classmethod
    def object_label_updated_value(cls, val):
        """
        Create an instance of this class set to the
        ``object_label_updated_value`` tag with value ``val``.

        :param ObjectLabelUpdatedValueType val:
        :rtype: EventType
        """
        return cls('object_label_updated_value', val)

    @classmethod
    def organize_folder_with_tidy(cls, val):
        """
        Create an instance of this class set to the
        ``organize_folder_with_tidy`` tag with value ``val``.

        :param OrganizeFolderWithTidyType val:
        :rtype: EventType
        """
        return cls('organize_folder_with_tidy', val)

    @classmethod
    def rewind_folder(cls, val):
        """
        Create an instance of this class set to the ``rewind_folder`` tag with
        value ``val``.

        :param RewindFolderType val:
        :rtype: EventType
        """
        return cls('rewind_folder', val)

    @classmethod
    def undo_naming_convention(cls, val):
        """
        Create an instance of this class set to the ``undo_naming_convention``
        tag with value ``val``.

        :param UndoNamingConventionType val:
        :rtype: EventType
        """
        return cls('undo_naming_convention', val)

    @classmethod
    def undo_organize_folder_with_tidy(cls, val):
        """
        Create an instance of this class set to the
        ``undo_organize_folder_with_tidy`` tag with value ``val``.

        :param UndoOrganizeFolderWithTidyType val:
        :rtype: EventType
        """
        return cls('undo_organize_folder_with_tidy', val)

    @classmethod
    def user_tags_added(cls, val):
        """
        Create an instance of this class set to the ``user_tags_added`` tag with
        value ``val``.

        :param UserTagsAddedType val:
        :rtype: EventType
        """
        return cls('user_tags_added', val)

    @classmethod
    def user_tags_removed(cls, val):
        """
        Create an instance of this class set to the ``user_tags_removed`` tag
        with value ``val``.

        :param UserTagsRemovedType val:
        :rtype: EventType
        """
        return cls('user_tags_removed', val)

    @classmethod
    def email_ingest_receive_file(cls, val):
        """
        Create an instance of this class set to the
        ``email_ingest_receive_file`` tag with value ``val``.

        :param EmailIngestReceiveFileType val:
        :rtype: EventType
        """
        return cls('email_ingest_receive_file', val)

    @classmethod
    def file_request_change(cls, val):
        """
        Create an instance of this class set to the ``file_request_change`` tag
        with value ``val``.

        :param FileRequestChangeType val:
        :rtype: EventType
        """
        return cls('file_request_change', val)

    @classmethod
    def file_request_close(cls, val):
        """
        Create an instance of this class set to the ``file_request_close`` tag
        with value ``val``.

        :param FileRequestCloseType val:
        :rtype: EventType
        """
        return cls('file_request_close', val)

    @classmethod
    def file_request_create(cls, val):
        """
        Create an instance of this class set to the ``file_request_create`` tag
        with value ``val``.

        :param FileRequestCreateType val:
        :rtype: EventType
        """
        return cls('file_request_create', val)

    @classmethod
    def file_request_delete(cls, val):
        """
        Create an instance of this class set to the ``file_request_delete`` tag
        with value ``val``.

        :param FileRequestDeleteType val:
        :rtype: EventType
        """
        return cls('file_request_delete', val)

    @classmethod
    def file_request_receive_file(cls, val):
        """
        Create an instance of this class set to the
        ``file_request_receive_file`` tag with value ``val``.

        :param FileRequestReceiveFileType val:
        :rtype: EventType
        """
        return cls('file_request_receive_file', val)

    @classmethod
    def group_add_external_id(cls, val):
        """
        Create an instance of this class set to the ``group_add_external_id``
        tag with value ``val``.

        :param GroupAddExternalIdType val:
        :rtype: EventType
        """
        return cls('group_add_external_id', val)

    @classmethod
    def group_add_member(cls, val):
        """
        Create an instance of this class set to the ``group_add_member`` tag
        with value ``val``.

        :param GroupAddMemberType val:
        :rtype: EventType
        """
        return cls('group_add_member', val)

    @classmethod
    def group_change_external_id(cls, val):
        """
        Create an instance of this class set to the ``group_change_external_id``
        tag with value ``val``.

        :param GroupChangeExternalIdType val:
        :rtype: EventType
        """
        return cls('group_change_external_id', val)

    @classmethod
    def group_change_management_type(cls, val):
        """
        Create an instance of this class set to the
        ``group_change_management_type`` tag with value ``val``.

        :param GroupChangeManagementTypeType val:
        :rtype: EventType
        """
        return cls('group_change_management_type', val)

    @classmethod
    def group_change_member_role(cls, val):
        """
        Create an instance of this class set to the ``group_change_member_role``
        tag with value ``val``.

        :param GroupChangeMemberRoleType val:
        :rtype: EventType
        """
        return cls('group_change_member_role', val)

    @classmethod
    def group_create(cls, val):
        """
        Create an instance of this class set to the ``group_create`` tag with
        value ``val``.

        :param GroupCreateType val:
        :rtype: EventType
        """
        return cls('group_create', val)

    @classmethod
    def group_delete(cls, val):
        """
        Create an instance of this class set to the ``group_delete`` tag with
        value ``val``.

        :param GroupDeleteType val:
        :rtype: EventType
        """
        return cls('group_delete', val)

    @classmethod
    def group_description_updated(cls, val):
        """
        Create an instance of this class set to the
        ``group_description_updated`` tag with value ``val``.

        :param GroupDescriptionUpdatedType val:
        :rtype: EventType
        """
        return cls('group_description_updated', val)

    @classmethod
    def group_join_policy_updated(cls, val):
        """
        Create an instance of this class set to the
        ``group_join_policy_updated`` tag with value ``val``.

        :param GroupJoinPolicyUpdatedType val:
        :rtype: EventType
        """
        return cls('group_join_policy_updated', val)

    @classmethod
    def group_moved(cls, val):
        """
        Create an instance of this class set to the ``group_moved`` tag with
        value ``val``.

        :param GroupMovedType val:
        :rtype: EventType
        """
        return cls('group_moved', val)

    @classmethod
    def group_remove_external_id(cls, val):
        """
        Create an instance of this class set to the ``group_remove_external_id``
        tag with value ``val``.

        :param GroupRemoveExternalIdType val:
        :rtype: EventType
        """
        return cls('group_remove_external_id', val)

    @classmethod
    def group_remove_member(cls, val):
        """
        Create an instance of this class set to the ``group_remove_member`` tag
        with value ``val``.

        :param GroupRemoveMemberType val:
        :rtype: EventType
        """
        return cls('group_remove_member', val)

    @classmethod
    def group_rename(cls, val):
        """
        Create an instance of this class set to the ``group_rename`` tag with
        value ``val``.

        :param GroupRenameType val:
        :rtype: EventType
        """
        return cls('group_rename', val)

    @classmethod
    def account_lock_or_unlocked(cls, val):
        """
        Create an instance of this class set to the ``account_lock_or_unlocked``
        tag with value ``val``.

        :param AccountLockOrUnlockedType val:
        :rtype: EventType
        """
        return cls('account_lock_or_unlocked', val)

    @classmethod
    def emm_error(cls, val):
        """
        Create an instance of this class set to the ``emm_error`` tag with value
        ``val``.

        :param EmmErrorType val:
        :rtype: EventType
        """
        return cls('emm_error', val)

    @classmethod
    def guest_admin_signed_in_via_trusted_teams(cls, val):
        """
        Create an instance of this class set to the
        ``guest_admin_signed_in_via_trusted_teams`` tag with value ``val``.

        :param GuestAdminSignedInViaTrustedTeamsType val:
        :rtype: EventType
        """
        return cls('guest_admin_signed_in_via_trusted_teams', val)

    @classmethod
    def guest_admin_signed_out_via_trusted_teams(cls, val):
        """
        Create an instance of this class set to the
        ``guest_admin_signed_out_via_trusted_teams`` tag with value ``val``.

        :param GuestAdminSignedOutViaTrustedTeamsType val:
        :rtype: EventType
        """
        return cls('guest_admin_signed_out_via_trusted_teams', val)

    @classmethod
    def login_fail(cls, val):
        """
        Create an instance of this class set to the ``login_fail`` tag with
        value ``val``.

        :param LoginFailType val:
        :rtype: EventType
        """
        return cls('login_fail', val)

    @classmethod
    def login_success(cls, val):
        """
        Create an instance of this class set to the ``login_success`` tag with
        value ``val``.

        :param LoginSuccessType val:
        :rtype: EventType
        """
        return cls('login_success', val)

    @classmethod
    def logout(cls, val):
        """
        Create an instance of this class set to the ``logout`` tag with value
        ``val``.

        :param LogoutType val:
        :rtype: EventType
        """
        return cls('logout', val)

    @classmethod
    def reseller_support_session_end(cls, val):
        """
        Create an instance of this class set to the
        ``reseller_support_session_end`` tag with value ``val``.

        :param ResellerSupportSessionEndType val:
        :rtype: EventType
        """
        return cls('reseller_support_session_end', val)

    @classmethod
    def reseller_support_session_start(cls, val):
        """
        Create an instance of this class set to the
        ``reseller_support_session_start`` tag with value ``val``.

        :param ResellerSupportSessionStartType val:
        :rtype: EventType
        """
        return cls('reseller_support_session_start', val)

    @classmethod
    def sign_in_as_session_end(cls, val):
        """
        Create an instance of this class set to the ``sign_in_as_session_end``
        tag with value ``val``.

        :param SignInAsSessionEndType val:
        :rtype: EventType
        """
        return cls('sign_in_as_session_end', val)

    @classmethod
    def sign_in_as_session_start(cls, val):
        """
        Create an instance of this class set to the ``sign_in_as_session_start``
        tag with value ``val``.

        :param SignInAsSessionStartType val:
        :rtype: EventType
        """
        return cls('sign_in_as_session_start', val)

    @classmethod
    def sso_error(cls, val):
        """
        Create an instance of this class set to the ``sso_error`` tag with value
        ``val``.

        :param SsoErrorType val:
        :rtype: EventType
        """
        return cls('sso_error', val)

    @classmethod
    def create_team_invite_link(cls, val):
        """
        Create an instance of this class set to the ``create_team_invite_link``
        tag with value ``val``.

        :param CreateTeamInviteLinkType val:
        :rtype: EventType
        """
        return cls('create_team_invite_link', val)

    @classmethod
    def delete_team_invite_link(cls, val):
        """
        Create an instance of this class set to the ``delete_team_invite_link``
        tag with value ``val``.

        :param DeleteTeamInviteLinkType val:
        :rtype: EventType
        """
        return cls('delete_team_invite_link', val)

    @classmethod
    def member_add_external_id(cls, val):
        """
        Create an instance of this class set to the ``member_add_external_id``
        tag with value ``val``.

        :param MemberAddExternalIdType val:
        :rtype: EventType
        """
        return cls('member_add_external_id', val)

    @classmethod
    def member_add_name(cls, val):
        """
        Create an instance of this class set to the ``member_add_name`` tag with
        value ``val``.

        :param MemberAddNameType val:
        :rtype: EventType
        """
        return cls('member_add_name', val)

    @classmethod
    def member_change_admin_role(cls, val):
        """
        Create an instance of this class set to the ``member_change_admin_role``
        tag with value ``val``.

        :param MemberChangeAdminRoleType val:
        :rtype: EventType
        """
        return cls('member_change_admin_role', val)

    @classmethod
    def member_change_email(cls, val):
        """
        Create an instance of this class set to the ``member_change_email`` tag
        with value ``val``.

        :param MemberChangeEmailType val:
        :rtype: EventType
        """
        return cls('member_change_email', val)

    @classmethod
    def member_change_external_id(cls, val):
        """
        Create an instance of this class set to the
        ``member_change_external_id`` tag with value ``val``.

        :param MemberChangeExternalIdType val:
        :rtype: EventType
        """
        return cls('member_change_external_id', val)

    @classmethod
    def member_change_membership_type(cls, val):
        """
        Create an instance of this class set to the
        ``member_change_membership_type`` tag with value ``val``.

        :param MemberChangeMembershipTypeType val:
        :rtype: EventType
        """
        return cls('member_change_membership_type', val)

    @classmethod
    def member_change_name(cls, val):
        """
        Create an instance of this class set to the ``member_change_name`` tag
        with value ``val``.

        :param MemberChangeNameType val:
        :rtype: EventType
        """
        return cls('member_change_name', val)

    @classmethod
    def member_change_reseller_role(cls, val):
        """
        Create an instance of this class set to the
        ``member_change_reseller_role`` tag with value ``val``.

        :param MemberChangeResellerRoleType val:
        :rtype: EventType
        """
        return cls('member_change_reseller_role', val)

    @classmethod
    def member_change_status(cls, val):
        """
        Create an instance of this class set to the ``member_change_status`` tag
        with value ``val``.

        :param MemberChangeStatusType val:
        :rtype: EventType
        """
        return cls('member_change_status', val)

    @classmethod
    def member_delete_manual_contacts(cls, val):
        """
        Create an instance of this class set to the
        ``member_delete_manual_contacts`` tag with value ``val``.

        :param MemberDeleteManualContactsType val:
        :rtype: EventType
        """
        return cls('member_delete_manual_contacts', val)

    @classmethod
    def member_delete_profile_photo(cls, val):
        """
        Create an instance of this class set to the
        ``member_delete_profile_photo`` tag with value ``val``.

        :param MemberDeleteProfilePhotoType val:
        :rtype: EventType
        """
        return cls('member_delete_profile_photo', val)

    @classmethod
    def member_permanently_delete_account_contents(cls, val):
        """
        Create an instance of this class set to the
        ``member_permanently_delete_account_contents`` tag with value ``val``.

        :param MemberPermanentlyDeleteAccountContentsType val:
        :rtype: EventType
        """
        return cls('member_permanently_delete_account_contents', val)

    @classmethod
    def member_remove_external_id(cls, val):
        """
        Create an instance of this class set to the
        ``member_remove_external_id`` tag with value ``val``.

        :param MemberRemoveExternalIdType val:
        :rtype: EventType
        """
        return cls('member_remove_external_id', val)

    @classmethod
    def member_set_profile_photo(cls, val):
        """
        Create an instance of this class set to the ``member_set_profile_photo``
        tag with value ``val``.

        :param MemberSetProfilePhotoType val:
        :rtype: EventType
        """
        return cls('member_set_profile_photo', val)

    @classmethod
    def member_space_limits_add_custom_quota(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_add_custom_quota`` tag with value ``val``.

        :param MemberSpaceLimitsAddCustomQuotaType val:
        :rtype: EventType
        """
        return cls('member_space_limits_add_custom_quota', val)

    @classmethod
    def member_space_limits_change_custom_quota(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_change_custom_quota`` tag with value ``val``.

        :param MemberSpaceLimitsChangeCustomQuotaType val:
        :rtype: EventType
        """
        return cls('member_space_limits_change_custom_quota', val)

    @classmethod
    def member_space_limits_change_status(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_change_status`` tag with value ``val``.

        :param MemberSpaceLimitsChangeStatusType val:
        :rtype: EventType
        """
        return cls('member_space_limits_change_status', val)

    @classmethod
    def member_space_limits_remove_custom_quota(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_remove_custom_quota`` tag with value ``val``.

        :param MemberSpaceLimitsRemoveCustomQuotaType val:
        :rtype: EventType
        """
        return cls('member_space_limits_remove_custom_quota', val)

    @classmethod
    def member_suggest(cls, val):
        """
        Create an instance of this class set to the ``member_suggest`` tag with
        value ``val``.

        :param MemberSuggestType val:
        :rtype: EventType
        """
        return cls('member_suggest', val)

    @classmethod
    def member_transfer_account_contents(cls, val):
        """
        Create an instance of this class set to the
        ``member_transfer_account_contents`` tag with value ``val``.

        :param MemberTransferAccountContentsType val:
        :rtype: EventType
        """
        return cls('member_transfer_account_contents', val)

    @classmethod
    def pending_secondary_email_added(cls, val):
        """
        Create an instance of this class set to the
        ``pending_secondary_email_added`` tag with value ``val``.

        :param PendingSecondaryEmailAddedType val:
        :rtype: EventType
        """
        return cls('pending_secondary_email_added', val)

    @classmethod
    def secondary_email_deleted(cls, val):
        """
        Create an instance of this class set to the ``secondary_email_deleted``
        tag with value ``val``.

        :param SecondaryEmailDeletedType val:
        :rtype: EventType
        """
        return cls('secondary_email_deleted', val)

    @classmethod
    def secondary_email_verified(cls, val):
        """
        Create an instance of this class set to the ``secondary_email_verified``
        tag with value ``val``.

        :param SecondaryEmailVerifiedType val:
        :rtype: EventType
        """
        return cls('secondary_email_verified', val)

    @classmethod
    def secondary_mails_policy_changed(cls, val):
        """
        Create an instance of this class set to the
        ``secondary_mails_policy_changed`` tag with value ``val``.

        :param SecondaryMailsPolicyChangedType val:
        :rtype: EventType
        """
        return cls('secondary_mails_policy_changed', val)

    @classmethod
    def binder_add_page(cls, val):
        """
        Create an instance of this class set to the ``binder_add_page`` tag with
        value ``val``.

        :param BinderAddPageType val:
        :rtype: EventType
        """
        return cls('binder_add_page', val)

    @classmethod
    def binder_add_section(cls, val):
        """
        Create an instance of this class set to the ``binder_add_section`` tag
        with value ``val``.

        :param BinderAddSectionType val:
        :rtype: EventType
        """
        return cls('binder_add_section', val)

    @classmethod
    def binder_remove_page(cls, val):
        """
        Create an instance of this class set to the ``binder_remove_page`` tag
        with value ``val``.

        :param BinderRemovePageType val:
        :rtype: EventType
        """
        return cls('binder_remove_page', val)

    @classmethod
    def binder_remove_section(cls, val):
        """
        Create an instance of this class set to the ``binder_remove_section``
        tag with value ``val``.

        :param BinderRemoveSectionType val:
        :rtype: EventType
        """
        return cls('binder_remove_section', val)

    @classmethod
    def binder_rename_page(cls, val):
        """
        Create an instance of this class set to the ``binder_rename_page`` tag
        with value ``val``.

        :param BinderRenamePageType val:
        :rtype: EventType
        """
        return cls('binder_rename_page', val)

    @classmethod
    def binder_rename_section(cls, val):
        """
        Create an instance of this class set to the ``binder_rename_section``
        tag with value ``val``.

        :param BinderRenameSectionType val:
        :rtype: EventType
        """
        return cls('binder_rename_section', val)

    @classmethod
    def binder_reorder_page(cls, val):
        """
        Create an instance of this class set to the ``binder_reorder_page`` tag
        with value ``val``.

        :param BinderReorderPageType val:
        :rtype: EventType
        """
        return cls('binder_reorder_page', val)

    @classmethod
    def binder_reorder_section(cls, val):
        """
        Create an instance of this class set to the ``binder_reorder_section``
        tag with value ``val``.

        :param BinderReorderSectionType val:
        :rtype: EventType
        """
        return cls('binder_reorder_section', val)

    @classmethod
    def paper_content_add_member(cls, val):
        """
        Create an instance of this class set to the ``paper_content_add_member``
        tag with value ``val``.

        :param PaperContentAddMemberType val:
        :rtype: EventType
        """
        return cls('paper_content_add_member', val)

    @classmethod
    def paper_content_add_to_folder(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_add_to_folder`` tag with value ``val``.

        :param PaperContentAddToFolderType val:
        :rtype: EventType
        """
        return cls('paper_content_add_to_folder', val)

    @classmethod
    def paper_content_archive(cls, val):
        """
        Create an instance of this class set to the ``paper_content_archive``
        tag with value ``val``.

        :param PaperContentArchiveType val:
        :rtype: EventType
        """
        return cls('paper_content_archive', val)

    @classmethod
    def paper_content_create(cls, val):
        """
        Create an instance of this class set to the ``paper_content_create`` tag
        with value ``val``.

        :param PaperContentCreateType val:
        :rtype: EventType
        """
        return cls('paper_content_create', val)

    @classmethod
    def paper_content_permanently_delete(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_permanently_delete`` tag with value ``val``.

        :param PaperContentPermanentlyDeleteType val:
        :rtype: EventType
        """
        return cls('paper_content_permanently_delete', val)

    @classmethod
    def paper_content_remove_from_folder(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_remove_from_folder`` tag with value ``val``.

        :param PaperContentRemoveFromFolderType val:
        :rtype: EventType
        """
        return cls('paper_content_remove_from_folder', val)

    @classmethod
    def paper_content_remove_member(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_remove_member`` tag with value ``val``.

        :param PaperContentRemoveMemberType val:
        :rtype: EventType
        """
        return cls('paper_content_remove_member', val)

    @classmethod
    def paper_content_rename(cls, val):
        """
        Create an instance of this class set to the ``paper_content_rename`` tag
        with value ``val``.

        :param PaperContentRenameType val:
        :rtype: EventType
        """
        return cls('paper_content_rename', val)

    @classmethod
    def paper_content_restore(cls, val):
        """
        Create an instance of this class set to the ``paper_content_restore``
        tag with value ``val``.

        :param PaperContentRestoreType val:
        :rtype: EventType
        """
        return cls('paper_content_restore', val)

    @classmethod
    def paper_doc_add_comment(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_add_comment``
        tag with value ``val``.

        :param PaperDocAddCommentType val:
        :rtype: EventType
        """
        return cls('paper_doc_add_comment', val)

    @classmethod
    def paper_doc_change_member_role(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_change_member_role`` tag with value ``val``.

        :param PaperDocChangeMemberRoleType val:
        :rtype: EventType
        """
        return cls('paper_doc_change_member_role', val)

    @classmethod
    def paper_doc_change_sharing_policy(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_change_sharing_policy`` tag with value ``val``.

        :param PaperDocChangeSharingPolicyType val:
        :rtype: EventType
        """
        return cls('paper_doc_change_sharing_policy', val)

    @classmethod
    def paper_doc_change_subscription(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_change_subscription`` tag with value ``val``.

        :param PaperDocChangeSubscriptionType val:
        :rtype: EventType
        """
        return cls('paper_doc_change_subscription', val)

    @classmethod
    def paper_doc_deleted(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_deleted`` tag
        with value ``val``.

        :param PaperDocDeletedType val:
        :rtype: EventType
        """
        return cls('paper_doc_deleted', val)

    @classmethod
    def paper_doc_delete_comment(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_delete_comment``
        tag with value ``val``.

        :param PaperDocDeleteCommentType val:
        :rtype: EventType
        """
        return cls('paper_doc_delete_comment', val)

    @classmethod
    def paper_doc_download(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_download`` tag
        with value ``val``.

        :param PaperDocDownloadType val:
        :rtype: EventType
        """
        return cls('paper_doc_download', val)

    @classmethod
    def paper_doc_edit(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_edit`` tag with
        value ``val``.

        :param PaperDocEditType val:
        :rtype: EventType
        """
        return cls('paper_doc_edit', val)

    @classmethod
    def paper_doc_edit_comment(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_edit_comment``
        tag with value ``val``.

        :param PaperDocEditCommentType val:
        :rtype: EventType
        """
        return cls('paper_doc_edit_comment', val)

    @classmethod
    def paper_doc_followed(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_followed`` tag
        with value ``val``.

        :param PaperDocFollowedType val:
        :rtype: EventType
        """
        return cls('paper_doc_followed', val)

    @classmethod
    def paper_doc_mention(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_mention`` tag
        with value ``val``.

        :param PaperDocMentionType val:
        :rtype: EventType
        """
        return cls('paper_doc_mention', val)

    @classmethod
    def paper_doc_ownership_changed(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_ownership_changed`` tag with value ``val``.

        :param PaperDocOwnershipChangedType val:
        :rtype: EventType
        """
        return cls('paper_doc_ownership_changed', val)

    @classmethod
    def paper_doc_request_access(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_request_access``
        tag with value ``val``.

        :param PaperDocRequestAccessType val:
        :rtype: EventType
        """
        return cls('paper_doc_request_access', val)

    @classmethod
    def paper_doc_resolve_comment(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_resolve_comment`` tag with value ``val``.

        :param PaperDocResolveCommentType val:
        :rtype: EventType
        """
        return cls('paper_doc_resolve_comment', val)

    @classmethod
    def paper_doc_revert(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_revert`` tag
        with value ``val``.

        :param PaperDocRevertType val:
        :rtype: EventType
        """
        return cls('paper_doc_revert', val)

    @classmethod
    def paper_doc_slack_share(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_slack_share``
        tag with value ``val``.

        :param PaperDocSlackShareType val:
        :rtype: EventType
        """
        return cls('paper_doc_slack_share', val)

    @classmethod
    def paper_doc_team_invite(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_team_invite``
        tag with value ``val``.

        :param PaperDocTeamInviteType val:
        :rtype: EventType
        """
        return cls('paper_doc_team_invite', val)

    @classmethod
    def paper_doc_trashed(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_trashed`` tag
        with value ``val``.

        :param PaperDocTrashedType val:
        :rtype: EventType
        """
        return cls('paper_doc_trashed', val)

    @classmethod
    def paper_doc_unresolve_comment(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_unresolve_comment`` tag with value ``val``.

        :param PaperDocUnresolveCommentType val:
        :rtype: EventType
        """
        return cls('paper_doc_unresolve_comment', val)

    @classmethod
    def paper_doc_untrashed(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_untrashed`` tag
        with value ``val``.

        :param PaperDocUntrashedType val:
        :rtype: EventType
        """
        return cls('paper_doc_untrashed', val)

    @classmethod
    def paper_doc_view(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_view`` tag with
        value ``val``.

        :param PaperDocViewType val:
        :rtype: EventType
        """
        return cls('paper_doc_view', val)

    @classmethod
    def paper_external_view_allow(cls, val):
        """
        Create an instance of this class set to the
        ``paper_external_view_allow`` tag with value ``val``.

        :param PaperExternalViewAllowType val:
        :rtype: EventType
        """
        return cls('paper_external_view_allow', val)

    @classmethod
    def paper_external_view_default_team(cls, val):
        """
        Create an instance of this class set to the
        ``paper_external_view_default_team`` tag with value ``val``.

        :param PaperExternalViewDefaultTeamType val:
        :rtype: EventType
        """
        return cls('paper_external_view_default_team', val)

    @classmethod
    def paper_external_view_forbid(cls, val):
        """
        Create an instance of this class set to the
        ``paper_external_view_forbid`` tag with value ``val``.

        :param PaperExternalViewForbidType val:
        :rtype: EventType
        """
        return cls('paper_external_view_forbid', val)

    @classmethod
    def paper_folder_change_subscription(cls, val):
        """
        Create an instance of this class set to the
        ``paper_folder_change_subscription`` tag with value ``val``.

        :param PaperFolderChangeSubscriptionType val:
        :rtype: EventType
        """
        return cls('paper_folder_change_subscription', val)

    @classmethod
    def paper_folder_deleted(cls, val):
        """
        Create an instance of this class set to the ``paper_folder_deleted`` tag
        with value ``val``.

        :param PaperFolderDeletedType val:
        :rtype: EventType
        """
        return cls('paper_folder_deleted', val)

    @classmethod
    def paper_folder_followed(cls, val):
        """
        Create an instance of this class set to the ``paper_folder_followed``
        tag with value ``val``.

        :param PaperFolderFollowedType val:
        :rtype: EventType
        """
        return cls('paper_folder_followed', val)

    @classmethod
    def paper_folder_team_invite(cls, val):
        """
        Create an instance of this class set to the ``paper_folder_team_invite``
        tag with value ``val``.

        :param PaperFolderTeamInviteType val:
        :rtype: EventType
        """
        return cls('paper_folder_team_invite', val)

    @classmethod
    def paper_published_link_change_permission(cls, val):
        """
        Create an instance of this class set to the
        ``paper_published_link_change_permission`` tag with value ``val``.

        :param PaperPublishedLinkChangePermissionType val:
        :rtype: EventType
        """
        return cls('paper_published_link_change_permission', val)

    @classmethod
    def paper_published_link_create(cls, val):
        """
        Create an instance of this class set to the
        ``paper_published_link_create`` tag with value ``val``.

        :param PaperPublishedLinkCreateType val:
        :rtype: EventType
        """
        return cls('paper_published_link_create', val)

    @classmethod
    def paper_published_link_disabled(cls, val):
        """
        Create an instance of this class set to the
        ``paper_published_link_disabled`` tag with value ``val``.

        :param PaperPublishedLinkDisabledType val:
        :rtype: EventType
        """
        return cls('paper_published_link_disabled', val)

    @classmethod
    def paper_published_link_view(cls, val):
        """
        Create an instance of this class set to the
        ``paper_published_link_view`` tag with value ``val``.

        :param PaperPublishedLinkViewType val:
        :rtype: EventType
        """
        return cls('paper_published_link_view', val)

    @classmethod
    def password_change(cls, val):
        """
        Create an instance of this class set to the ``password_change`` tag with
        value ``val``.

        :param PasswordChangeType val:
        :rtype: EventType
        """
        return cls('password_change', val)

    @classmethod
    def password_reset(cls, val):
        """
        Create an instance of this class set to the ``password_reset`` tag with
        value ``val``.

        :param PasswordResetType val:
        :rtype: EventType
        """
        return cls('password_reset', val)

    @classmethod
    def password_reset_all(cls, val):
        """
        Create an instance of this class set to the ``password_reset_all`` tag
        with value ``val``.

        :param PasswordResetAllType val:
        :rtype: EventType
        """
        return cls('password_reset_all', val)

    @classmethod
    def classification_create_report(cls, val):
        """
        Create an instance of this class set to the
        ``classification_create_report`` tag with value ``val``.

        :param ClassificationCreateReportType val:
        :rtype: EventType
        """
        return cls('classification_create_report', val)

    @classmethod
    def classification_create_report_fail(cls, val):
        """
        Create an instance of this class set to the
        ``classification_create_report_fail`` tag with value ``val``.

        :param ClassificationCreateReportFailType val:
        :rtype: EventType
        """
        return cls('classification_create_report_fail', val)

    @classmethod
    def emm_create_exceptions_report(cls, val):
        """
        Create an instance of this class set to the
        ``emm_create_exceptions_report`` tag with value ``val``.

        :param EmmCreateExceptionsReportType val:
        :rtype: EventType
        """
        return cls('emm_create_exceptions_report', val)

    @classmethod
    def emm_create_usage_report(cls, val):
        """
        Create an instance of this class set to the ``emm_create_usage_report``
        tag with value ``val``.

        :param EmmCreateUsageReportType val:
        :rtype: EventType
        """
        return cls('emm_create_usage_report', val)

    @classmethod
    def export_members_report(cls, val):
        """
        Create an instance of this class set to the ``export_members_report``
        tag with value ``val``.

        :param ExportMembersReportType val:
        :rtype: EventType
        """
        return cls('export_members_report', val)

    @classmethod
    def export_members_report_fail(cls, val):
        """
        Create an instance of this class set to the
        ``export_members_report_fail`` tag with value ``val``.

        :param ExportMembersReportFailType val:
        :rtype: EventType
        """
        return cls('export_members_report_fail', val)

    @classmethod
    def external_sharing_create_report(cls, val):
        """
        Create an instance of this class set to the
        ``external_sharing_create_report`` tag with value ``val``.

        :param ExternalSharingCreateReportType val:
        :rtype: EventType
        """
        return cls('external_sharing_create_report', val)

    @classmethod
    def external_sharing_report_failed(cls, val):
        """
        Create an instance of this class set to the
        ``external_sharing_report_failed`` tag with value ``val``.

        :param ExternalSharingReportFailedType val:
        :rtype: EventType
        """
        return cls('external_sharing_report_failed', val)

    @classmethod
    def no_expiration_link_gen_create_report(cls, val):
        """
        Create an instance of this class set to the
        ``no_expiration_link_gen_create_report`` tag with value ``val``.

        :param NoExpirationLinkGenCreateReportType val:
        :rtype: EventType
        """
        return cls('no_expiration_link_gen_create_report', val)

    @classmethod
    def no_expiration_link_gen_report_failed(cls, val):
        """
        Create an instance of this class set to the
        ``no_expiration_link_gen_report_failed`` tag with value ``val``.

        :param NoExpirationLinkGenReportFailedType val:
        :rtype: EventType
        """
        return cls('no_expiration_link_gen_report_failed', val)

    @classmethod
    def no_password_link_gen_create_report(cls, val):
        """
        Create an instance of this class set to the
        ``no_password_link_gen_create_report`` tag with value ``val``.

        :param NoPasswordLinkGenCreateReportType val:
        :rtype: EventType
        """
        return cls('no_password_link_gen_create_report', val)

    @classmethod
    def no_password_link_gen_report_failed(cls, val):
        """
        Create an instance of this class set to the
        ``no_password_link_gen_report_failed`` tag with value ``val``.

        :param NoPasswordLinkGenReportFailedType val:
        :rtype: EventType
        """
        return cls('no_password_link_gen_report_failed', val)

    @classmethod
    def no_password_link_view_create_report(cls, val):
        """
        Create an instance of this class set to the
        ``no_password_link_view_create_report`` tag with value ``val``.

        :param NoPasswordLinkViewCreateReportType val:
        :rtype: EventType
        """
        return cls('no_password_link_view_create_report', val)

    @classmethod
    def no_password_link_view_report_failed(cls, val):
        """
        Create an instance of this class set to the
        ``no_password_link_view_report_failed`` tag with value ``val``.

        :param NoPasswordLinkViewReportFailedType val:
        :rtype: EventType
        """
        return cls('no_password_link_view_report_failed', val)

    @classmethod
    def outdated_link_view_create_report(cls, val):
        """
        Create an instance of this class set to the
        ``outdated_link_view_create_report`` tag with value ``val``.

        :param OutdatedLinkViewCreateReportType val:
        :rtype: EventType
        """
        return cls('outdated_link_view_create_report', val)

    @classmethod
    def outdated_link_view_report_failed(cls, val):
        """
        Create an instance of this class set to the
        ``outdated_link_view_report_failed`` tag with value ``val``.

        :param OutdatedLinkViewReportFailedType val:
        :rtype: EventType
        """
        return cls('outdated_link_view_report_failed', val)

    @classmethod
    def paper_admin_export_start(cls, val):
        """
        Create an instance of this class set to the ``paper_admin_export_start``
        tag with value ``val``.

        :param PaperAdminExportStartType val:
        :rtype: EventType
        """
        return cls('paper_admin_export_start', val)

    @classmethod
    def smart_sync_create_admin_privilege_report(cls, val):
        """
        Create an instance of this class set to the
        ``smart_sync_create_admin_privilege_report`` tag with value ``val``.

        :param SmartSyncCreateAdminPrivilegeReportType val:
        :rtype: EventType
        """
        return cls('smart_sync_create_admin_privilege_report', val)

    @classmethod
    def team_activity_create_report(cls, val):
        """
        Create an instance of this class set to the
        ``team_activity_create_report`` tag with value ``val``.

        :param TeamActivityCreateReportType val:
        :rtype: EventType
        """
        return cls('team_activity_create_report', val)

    @classmethod
    def team_activity_create_report_fail(cls, val):
        """
        Create an instance of this class set to the
        ``team_activity_create_report_fail`` tag with value ``val``.

        :param TeamActivityCreateReportFailType val:
        :rtype: EventType
        """
        return cls('team_activity_create_report_fail', val)

    @classmethod
    def collection_share(cls, val):
        """
        Create an instance of this class set to the ``collection_share`` tag
        with value ``val``.

        :param CollectionShareType val:
        :rtype: EventType
        """
        return cls('collection_share', val)

    @classmethod
    def file_transfers_file_add(cls, val):
        """
        Create an instance of this class set to the ``file_transfers_file_add``
        tag with value ``val``.

        :param FileTransfersFileAddType val:
        :rtype: EventType
        """
        return cls('file_transfers_file_add', val)

    @classmethod
    def file_transfers_transfer_delete(cls, val):
        """
        Create an instance of this class set to the
        ``file_transfers_transfer_delete`` tag with value ``val``.

        :param FileTransfersTransferDeleteType val:
        :rtype: EventType
        """
        return cls('file_transfers_transfer_delete', val)

    @classmethod
    def file_transfers_transfer_download(cls, val):
        """
        Create an instance of this class set to the
        ``file_transfers_transfer_download`` tag with value ``val``.

        :param FileTransfersTransferDownloadType val:
        :rtype: EventType
        """
        return cls('file_transfers_transfer_download', val)

    @classmethod
    def file_transfers_transfer_send(cls, val):
        """
        Create an instance of this class set to the
        ``file_transfers_transfer_send`` tag with value ``val``.

        :param FileTransfersTransferSendType val:
        :rtype: EventType
        """
        return cls('file_transfers_transfer_send', val)

    @classmethod
    def file_transfers_transfer_view(cls, val):
        """
        Create an instance of this class set to the
        ``file_transfers_transfer_view`` tag with value ``val``.

        :param FileTransfersTransferViewType val:
        :rtype: EventType
        """
        return cls('file_transfers_transfer_view', val)

    @classmethod
    def note_acl_invite_only(cls, val):
        """
        Create an instance of this class set to the ``note_acl_invite_only`` tag
        with value ``val``.

        :param NoteAclInviteOnlyType val:
        :rtype: EventType
        """
        return cls('note_acl_invite_only', val)

    @classmethod
    def note_acl_link(cls, val):
        """
        Create an instance of this class set to the ``note_acl_link`` tag with
        value ``val``.

        :param NoteAclLinkType val:
        :rtype: EventType
        """
        return cls('note_acl_link', val)

    @classmethod
    def note_acl_team_link(cls, val):
        """
        Create an instance of this class set to the ``note_acl_team_link`` tag
        with value ``val``.

        :param NoteAclTeamLinkType val:
        :rtype: EventType
        """
        return cls('note_acl_team_link', val)

    @classmethod
    def note_shared(cls, val):
        """
        Create an instance of this class set to the ``note_shared`` tag with
        value ``val``.

        :param NoteSharedType val:
        :rtype: EventType
        """
        return cls('note_shared', val)

    @classmethod
    def note_share_receive(cls, val):
        """
        Create an instance of this class set to the ``note_share_receive`` tag
        with value ``val``.

        :param NoteShareReceiveType val:
        :rtype: EventType
        """
        return cls('note_share_receive', val)

    @classmethod
    def open_note_shared(cls, val):
        """
        Create an instance of this class set to the ``open_note_shared`` tag
        with value ``val``.

        :param OpenNoteSharedType val:
        :rtype: EventType
        """
        return cls('open_note_shared', val)

    @classmethod
    def sf_add_group(cls, val):
        """
        Create an instance of this class set to the ``sf_add_group`` tag with
        value ``val``.

        :param SfAddGroupType val:
        :rtype: EventType
        """
        return cls('sf_add_group', val)

    @classmethod
    def sf_allow_non_members_to_view_shared_links(cls, val):
        """
        Create an instance of this class set to the
        ``sf_allow_non_members_to_view_shared_links`` tag with value ``val``.

        :param SfAllowNonMembersToViewSharedLinksType val:
        :rtype: EventType
        """
        return cls('sf_allow_non_members_to_view_shared_links', val)

    @classmethod
    def sf_external_invite_warn(cls, val):
        """
        Create an instance of this class set to the ``sf_external_invite_warn``
        tag with value ``val``.

        :param SfExternalInviteWarnType val:
        :rtype: EventType
        """
        return cls('sf_external_invite_warn', val)

    @classmethod
    def sf_fb_invite(cls, val):
        """
        Create an instance of this class set to the ``sf_fb_invite`` tag with
        value ``val``.

        :param SfFbInviteType val:
        :rtype: EventType
        """
        return cls('sf_fb_invite', val)

    @classmethod
    def sf_fb_invite_change_role(cls, val):
        """
        Create an instance of this class set to the ``sf_fb_invite_change_role``
        tag with value ``val``.

        :param SfFbInviteChangeRoleType val:
        :rtype: EventType
        """
        return cls('sf_fb_invite_change_role', val)

    @classmethod
    def sf_fb_uninvite(cls, val):
        """
        Create an instance of this class set to the ``sf_fb_uninvite`` tag with
        value ``val``.

        :param SfFbUninviteType val:
        :rtype: EventType
        """
        return cls('sf_fb_uninvite', val)

    @classmethod
    def sf_invite_group(cls, val):
        """
        Create an instance of this class set to the ``sf_invite_group`` tag with
        value ``val``.

        :param SfInviteGroupType val:
        :rtype: EventType
        """
        return cls('sf_invite_group', val)

    @classmethod
    def sf_team_grant_access(cls, val):
        """
        Create an instance of this class set to the ``sf_team_grant_access`` tag
        with value ``val``.

        :param SfTeamGrantAccessType val:
        :rtype: EventType
        """
        return cls('sf_team_grant_access', val)

    @classmethod
    def sf_team_invite(cls, val):
        """
        Create an instance of this class set to the ``sf_team_invite`` tag with
        value ``val``.

        :param SfTeamInviteType val:
        :rtype: EventType
        """
        return cls('sf_team_invite', val)

    @classmethod
    def sf_team_invite_change_role(cls, val):
        """
        Create an instance of this class set to the
        ``sf_team_invite_change_role`` tag with value ``val``.

        :param SfTeamInviteChangeRoleType val:
        :rtype: EventType
        """
        return cls('sf_team_invite_change_role', val)

    @classmethod
    def sf_team_join(cls, val):
        """
        Create an instance of this class set to the ``sf_team_join`` tag with
        value ``val``.

        :param SfTeamJoinType val:
        :rtype: EventType
        """
        return cls('sf_team_join', val)

    @classmethod
    def sf_team_join_from_oob_link(cls, val):
        """
        Create an instance of this class set to the
        ``sf_team_join_from_oob_link`` tag with value ``val``.

        :param SfTeamJoinFromOobLinkType val:
        :rtype: EventType
        """
        return cls('sf_team_join_from_oob_link', val)

    @classmethod
    def sf_team_uninvite(cls, val):
        """
        Create an instance of this class set to the ``sf_team_uninvite`` tag
        with value ``val``.

        :param SfTeamUninviteType val:
        :rtype: EventType
        """
        return cls('sf_team_uninvite', val)

    @classmethod
    def shared_content_add_invitees(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_add_invitees`` tag with value ``val``.

        :param SharedContentAddInviteesType val:
        :rtype: EventType
        """
        return cls('shared_content_add_invitees', val)

    @classmethod
    def shared_content_add_link_expiry(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_add_link_expiry`` tag with value ``val``.

        :param SharedContentAddLinkExpiryType val:
        :rtype: EventType
        """
        return cls('shared_content_add_link_expiry', val)

    @classmethod
    def shared_content_add_link_password(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_add_link_password`` tag with value ``val``.

        :param SharedContentAddLinkPasswordType val:
        :rtype: EventType
        """
        return cls('shared_content_add_link_password', val)

    @classmethod
    def shared_content_add_member(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_add_member`` tag with value ``val``.

        :param SharedContentAddMemberType val:
        :rtype: EventType
        """
        return cls('shared_content_add_member', val)

    @classmethod
    def shared_content_change_downloads_policy(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_downloads_policy`` tag with value ``val``.

        :param SharedContentChangeDownloadsPolicyType val:
        :rtype: EventType
        """
        return cls('shared_content_change_downloads_policy', val)

    @classmethod
    def shared_content_change_invitee_role(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_invitee_role`` tag with value ``val``.

        :param SharedContentChangeInviteeRoleType val:
        :rtype: EventType
        """
        return cls('shared_content_change_invitee_role', val)

    @classmethod
    def shared_content_change_link_audience(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_link_audience`` tag with value ``val``.

        :param SharedContentChangeLinkAudienceType val:
        :rtype: EventType
        """
        return cls('shared_content_change_link_audience', val)

    @classmethod
    def shared_content_change_link_expiry(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_link_expiry`` tag with value ``val``.

        :param SharedContentChangeLinkExpiryType val:
        :rtype: EventType
        """
        return cls('shared_content_change_link_expiry', val)

    @classmethod
    def shared_content_change_link_password(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_link_password`` tag with value ``val``.

        :param SharedContentChangeLinkPasswordType val:
        :rtype: EventType
        """
        return cls('shared_content_change_link_password', val)

    @classmethod
    def shared_content_change_member_role(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_member_role`` tag with value ``val``.

        :param SharedContentChangeMemberRoleType val:
        :rtype: EventType
        """
        return cls('shared_content_change_member_role', val)

    @classmethod
    def shared_content_change_viewer_info_policy(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_viewer_info_policy`` tag with value ``val``.

        :param SharedContentChangeViewerInfoPolicyType val:
        :rtype: EventType
        """
        return cls('shared_content_change_viewer_info_policy', val)

    @classmethod
    def shared_content_claim_invitation(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_claim_invitation`` tag with value ``val``.

        :param SharedContentClaimInvitationType val:
        :rtype: EventType
        """
        return cls('shared_content_claim_invitation', val)

    @classmethod
    def shared_content_copy(cls, val):
        """
        Create an instance of this class set to the ``shared_content_copy`` tag
        with value ``val``.

        :param SharedContentCopyType val:
        :rtype: EventType
        """
        return cls('shared_content_copy', val)

    @classmethod
    def shared_content_download(cls, val):
        """
        Create an instance of this class set to the ``shared_content_download``
        tag with value ``val``.

        :param SharedContentDownloadType val:
        :rtype: EventType
        """
        return cls('shared_content_download', val)

    @classmethod
    def shared_content_relinquish_membership(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_relinquish_membership`` tag with value ``val``.

        :param SharedContentRelinquishMembershipType val:
        :rtype: EventType
        """
        return cls('shared_content_relinquish_membership', val)

    @classmethod
    def shared_content_remove_invitees(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_remove_invitees`` tag with value ``val``.

        :param SharedContentRemoveInviteesType val:
        :rtype: EventType
        """
        return cls('shared_content_remove_invitees', val)

    @classmethod
    def shared_content_remove_link_expiry(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_remove_link_expiry`` tag with value ``val``.

        :param SharedContentRemoveLinkExpiryType val:
        :rtype: EventType
        """
        return cls('shared_content_remove_link_expiry', val)

    @classmethod
    def shared_content_remove_link_password(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_remove_link_password`` tag with value ``val``.

        :param SharedContentRemoveLinkPasswordType val:
        :rtype: EventType
        """
        return cls('shared_content_remove_link_password', val)

    @classmethod
    def shared_content_remove_member(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_remove_member`` tag with value ``val``.

        :param SharedContentRemoveMemberType val:
        :rtype: EventType
        """
        return cls('shared_content_remove_member', val)

    @classmethod
    def shared_content_request_access(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_request_access`` tag with value ``val``.

        :param SharedContentRequestAccessType val:
        :rtype: EventType
        """
        return cls('shared_content_request_access', val)

    @classmethod
    def shared_content_restore_invitees(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_restore_invitees`` tag with value ``val``.

        :param SharedContentRestoreInviteesType val:
        :rtype: EventType
        """
        return cls('shared_content_restore_invitees', val)

    @classmethod
    def shared_content_restore_member(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_restore_member`` tag with value ``val``.

        :param SharedContentRestoreMemberType val:
        :rtype: EventType
        """
        return cls('shared_content_restore_member', val)

    @classmethod
    def shared_content_unshare(cls, val):
        """
        Create an instance of this class set to the ``shared_content_unshare``
        tag with value ``val``.

        :param SharedContentUnshareType val:
        :rtype: EventType
        """
        return cls('shared_content_unshare', val)

    @classmethod
    def shared_content_view(cls, val):
        """
        Create an instance of this class set to the ``shared_content_view`` tag
        with value ``val``.

        :param SharedContentViewType val:
        :rtype: EventType
        """
        return cls('shared_content_view', val)

    @classmethod
    def shared_folder_change_link_policy(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_change_link_policy`` tag with value ``val``.

        :param SharedFolderChangeLinkPolicyType val:
        :rtype: EventType
        """
        return cls('shared_folder_change_link_policy', val)

    @classmethod
    def shared_folder_change_members_inheritance_policy(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_change_members_inheritance_policy`` tag with value
        ``val``.

        :param SharedFolderChangeMembersInheritancePolicyType val:
        :rtype: EventType
        """
        return cls('shared_folder_change_members_inheritance_policy', val)

    @classmethod
    def shared_folder_change_members_management_policy(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_change_members_management_policy`` tag with value
        ``val``.

        :param SharedFolderChangeMembersManagementPolicyType val:
        :rtype: EventType
        """
        return cls('shared_folder_change_members_management_policy', val)

    @classmethod
    def shared_folder_change_members_policy(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_change_members_policy`` tag with value ``val``.

        :param SharedFolderChangeMembersPolicyType val:
        :rtype: EventType
        """
        return cls('shared_folder_change_members_policy', val)

    @classmethod
    def shared_folder_create(cls, val):
        """
        Create an instance of this class set to the ``shared_folder_create`` tag
        with value ``val``.

        :param SharedFolderCreateType val:
        :rtype: EventType
        """
        return cls('shared_folder_create', val)

    @classmethod
    def shared_folder_decline_invitation(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_decline_invitation`` tag with value ``val``.

        :param SharedFolderDeclineInvitationType val:
        :rtype: EventType
        """
        return cls('shared_folder_decline_invitation', val)

    @classmethod
    def shared_folder_mount(cls, val):
        """
        Create an instance of this class set to the ``shared_folder_mount`` tag
        with value ``val``.

        :param SharedFolderMountType val:
        :rtype: EventType
        """
        return cls('shared_folder_mount', val)

    @classmethod
    def shared_folder_nest(cls, val):
        """
        Create an instance of this class set to the ``shared_folder_nest`` tag
        with value ``val``.

        :param SharedFolderNestType val:
        :rtype: EventType
        """
        return cls('shared_folder_nest', val)

    @classmethod
    def shared_folder_transfer_ownership(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_transfer_ownership`` tag with value ``val``.

        :param SharedFolderTransferOwnershipType val:
        :rtype: EventType
        """
        return cls('shared_folder_transfer_ownership', val)

    @classmethod
    def shared_folder_unmount(cls, val):
        """
        Create an instance of this class set to the ``shared_folder_unmount``
        tag with value ``val``.

        :param SharedFolderUnmountType val:
        :rtype: EventType
        """
        return cls('shared_folder_unmount', val)

    @classmethod
    def shared_link_add_expiry(cls, val):
        """
        Create an instance of this class set to the ``shared_link_add_expiry``
        tag with value ``val``.

        :param SharedLinkAddExpiryType val:
        :rtype: EventType
        """
        return cls('shared_link_add_expiry', val)

    @classmethod
    def shared_link_change_expiry(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_change_expiry`` tag with value ``val``.

        :param SharedLinkChangeExpiryType val:
        :rtype: EventType
        """
        return cls('shared_link_change_expiry', val)

    @classmethod
    def shared_link_change_visibility(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_change_visibility`` tag with value ``val``.

        :param SharedLinkChangeVisibilityType val:
        :rtype: EventType
        """
        return cls('shared_link_change_visibility', val)

    @classmethod
    def shared_link_copy(cls, val):
        """
        Create an instance of this class set to the ``shared_link_copy`` tag
        with value ``val``.

        :param SharedLinkCopyType val:
        :rtype: EventType
        """
        return cls('shared_link_copy', val)

    @classmethod
    def shared_link_create(cls, val):
        """
        Create an instance of this class set to the ``shared_link_create`` tag
        with value ``val``.

        :param SharedLinkCreateType val:
        :rtype: EventType
        """
        return cls('shared_link_create', val)

    @classmethod
    def shared_link_disable(cls, val):
        """
        Create an instance of this class set to the ``shared_link_disable`` tag
        with value ``val``.

        :param SharedLinkDisableType val:
        :rtype: EventType
        """
        return cls('shared_link_disable', val)

    @classmethod
    def shared_link_download(cls, val):
        """
        Create an instance of this class set to the ``shared_link_download`` tag
        with value ``val``.

        :param SharedLinkDownloadType val:
        :rtype: EventType
        """
        return cls('shared_link_download', val)

    @classmethod
    def shared_link_remove_expiry(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_remove_expiry`` tag with value ``val``.

        :param SharedLinkRemoveExpiryType val:
        :rtype: EventType
        """
        return cls('shared_link_remove_expiry', val)

    @classmethod
    def shared_link_settings_add_expiration(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_settings_add_expiration`` tag with value ``val``.

        :param SharedLinkSettingsAddExpirationType val:
        :rtype: EventType
        """
        return cls('shared_link_settings_add_expiration', val)

    @classmethod
    def shared_link_settings_add_password(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_settings_add_password`` tag with value ``val``.

        :param SharedLinkSettingsAddPasswordType val:
        :rtype: EventType
        """
        return cls('shared_link_settings_add_password', val)

    @classmethod
    def shared_link_settings_allow_download_disabled(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_settings_allow_download_disabled`` tag with value ``val``.

        :param SharedLinkSettingsAllowDownloadDisabledType val:
        :rtype: EventType
        """
        return cls('shared_link_settings_allow_download_disabled', val)

    @classmethod
    def shared_link_settings_allow_download_enabled(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_settings_allow_download_enabled`` tag with value ``val``.

        :param SharedLinkSettingsAllowDownloadEnabledType val:
        :rtype: EventType
        """
        return cls('shared_link_settings_allow_download_enabled', val)

    @classmethod
    def shared_link_settings_change_audience(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_settings_change_audience`` tag with value ``val``.

        :param SharedLinkSettingsChangeAudienceType val:
        :rtype: EventType
        """
        return cls('shared_link_settings_change_audience', val)

    @classmethod
    def shared_link_settings_change_expiration(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_settings_change_expiration`` tag with value ``val``.

        :param SharedLinkSettingsChangeExpirationType val:
        :rtype: EventType
        """
        return cls('shared_link_settings_change_expiration', val)

    @classmethod
    def shared_link_settings_change_password(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_settings_change_password`` tag with value ``val``.

        :param SharedLinkSettingsChangePasswordType val:
        :rtype: EventType
        """
        return cls('shared_link_settings_change_password', val)

    @classmethod
    def shared_link_settings_remove_expiration(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_settings_remove_expiration`` tag with value ``val``.

        :param SharedLinkSettingsRemoveExpirationType val:
        :rtype: EventType
        """
        return cls('shared_link_settings_remove_expiration', val)

    @classmethod
    def shared_link_settings_remove_password(cls, val):
        """
        Create an instance of this class set to the
        ``shared_link_settings_remove_password`` tag with value ``val``.

        :param SharedLinkSettingsRemovePasswordType val:
        :rtype: EventType
        """
        return cls('shared_link_settings_remove_password', val)

    @classmethod
    def shared_link_share(cls, val):
        """
        Create an instance of this class set to the ``shared_link_share`` tag
        with value ``val``.

        :param SharedLinkShareType val:
        :rtype: EventType
        """
        return cls('shared_link_share', val)

    @classmethod
    def shared_link_view(cls, val):
        """
        Create an instance of this class set to the ``shared_link_view`` tag
        with value ``val``.

        :param SharedLinkViewType val:
        :rtype: EventType
        """
        return cls('shared_link_view', val)

    @classmethod
    def shared_note_opened(cls, val):
        """
        Create an instance of this class set to the ``shared_note_opened`` tag
        with value ``val``.

        :param SharedNoteOpenedType val:
        :rtype: EventType
        """
        return cls('shared_note_opened', val)

    @classmethod
    def shmodel_disable_downloads(cls, val):
        """
        Create an instance of this class set to the
        ``shmodel_disable_downloads`` tag with value ``val``.

        :param ShmodelDisableDownloadsType val:
        :rtype: EventType
        """
        return cls('shmodel_disable_downloads', val)

    @classmethod
    def shmodel_enable_downloads(cls, val):
        """
        Create an instance of this class set to the ``shmodel_enable_downloads``
        tag with value ``val``.

        :param ShmodelEnableDownloadsType val:
        :rtype: EventType
        """
        return cls('shmodel_enable_downloads', val)

    @classmethod
    def shmodel_group_share(cls, val):
        """
        Create an instance of this class set to the ``shmodel_group_share`` tag
        with value ``val``.

        :param ShmodelGroupShareType val:
        :rtype: EventType
        """
        return cls('shmodel_group_share', val)

    @classmethod
    def showcase_access_granted(cls, val):
        """
        Create an instance of this class set to the ``showcase_access_granted``
        tag with value ``val``.

        :param ShowcaseAccessGrantedType val:
        :rtype: EventType
        """
        return cls('showcase_access_granted', val)

    @classmethod
    def showcase_add_member(cls, val):
        """
        Create an instance of this class set to the ``showcase_add_member`` tag
        with value ``val``.

        :param ShowcaseAddMemberType val:
        :rtype: EventType
        """
        return cls('showcase_add_member', val)

    @classmethod
    def showcase_archived(cls, val):
        """
        Create an instance of this class set to the ``showcase_archived`` tag
        with value ``val``.

        :param ShowcaseArchivedType val:
        :rtype: EventType
        """
        return cls('showcase_archived', val)

    @classmethod
    def showcase_created(cls, val):
        """
        Create an instance of this class set to the ``showcase_created`` tag
        with value ``val``.

        :param ShowcaseCreatedType val:
        :rtype: EventType
        """
        return cls('showcase_created', val)

    @classmethod
    def showcase_delete_comment(cls, val):
        """
        Create an instance of this class set to the ``showcase_delete_comment``
        tag with value ``val``.

        :param ShowcaseDeleteCommentType val:
        :rtype: EventType
        """
        return cls('showcase_delete_comment', val)

    @classmethod
    def showcase_edited(cls, val):
        """
        Create an instance of this class set to the ``showcase_edited`` tag with
        value ``val``.

        :param ShowcaseEditedType val:
        :rtype: EventType
        """
        return cls('showcase_edited', val)

    @classmethod
    def showcase_edit_comment(cls, val):
        """
        Create an instance of this class set to the ``showcase_edit_comment``
        tag with value ``val``.

        :param ShowcaseEditCommentType val:
        :rtype: EventType
        """
        return cls('showcase_edit_comment', val)

    @classmethod
    def showcase_file_added(cls, val):
        """
        Create an instance of this class set to the ``showcase_file_added`` tag
        with value ``val``.

        :param ShowcaseFileAddedType val:
        :rtype: EventType
        """
        return cls('showcase_file_added', val)

    @classmethod
    def showcase_file_download(cls, val):
        """
        Create an instance of this class set to the ``showcase_file_download``
        tag with value ``val``.

        :param ShowcaseFileDownloadType val:
        :rtype: EventType
        """
        return cls('showcase_file_download', val)

    @classmethod
    def showcase_file_removed(cls, val):
        """
        Create an instance of this class set to the ``showcase_file_removed``
        tag with value ``val``.

        :param ShowcaseFileRemovedType val:
        :rtype: EventType
        """
        return cls('showcase_file_removed', val)

    @classmethod
    def showcase_file_view(cls, val):
        """
        Create an instance of this class set to the ``showcase_file_view`` tag
        with value ``val``.

        :param ShowcaseFileViewType val:
        :rtype: EventType
        """
        return cls('showcase_file_view', val)

    @classmethod
    def showcase_permanently_deleted(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_permanently_deleted`` tag with value ``val``.

        :param ShowcasePermanentlyDeletedType val:
        :rtype: EventType
        """
        return cls('showcase_permanently_deleted', val)

    @classmethod
    def showcase_post_comment(cls, val):
        """
        Create an instance of this class set to the ``showcase_post_comment``
        tag with value ``val``.

        :param ShowcasePostCommentType val:
        :rtype: EventType
        """
        return cls('showcase_post_comment', val)

    @classmethod
    def showcase_remove_member(cls, val):
        """
        Create an instance of this class set to the ``showcase_remove_member``
        tag with value ``val``.

        :param ShowcaseRemoveMemberType val:
        :rtype: EventType
        """
        return cls('showcase_remove_member', val)

    @classmethod
    def showcase_renamed(cls, val):
        """
        Create an instance of this class set to the ``showcase_renamed`` tag
        with value ``val``.

        :param ShowcaseRenamedType val:
        :rtype: EventType
        """
        return cls('showcase_renamed', val)

    @classmethod
    def showcase_request_access(cls, val):
        """
        Create an instance of this class set to the ``showcase_request_access``
        tag with value ``val``.

        :param ShowcaseRequestAccessType val:
        :rtype: EventType
        """
        return cls('showcase_request_access', val)

    @classmethod
    def showcase_resolve_comment(cls, val):
        """
        Create an instance of this class set to the ``showcase_resolve_comment``
        tag with value ``val``.

        :param ShowcaseResolveCommentType val:
        :rtype: EventType
        """
        return cls('showcase_resolve_comment', val)

    @classmethod
    def showcase_restored(cls, val):
        """
        Create an instance of this class set to the ``showcase_restored`` tag
        with value ``val``.

        :param ShowcaseRestoredType val:
        :rtype: EventType
        """
        return cls('showcase_restored', val)

    @classmethod
    def showcase_trashed(cls, val):
        """
        Create an instance of this class set to the ``showcase_trashed`` tag
        with value ``val``.

        :param ShowcaseTrashedType val:
        :rtype: EventType
        """
        return cls('showcase_trashed', val)

    @classmethod
    def showcase_trashed_deprecated(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_trashed_deprecated`` tag with value ``val``.

        :param ShowcaseTrashedDeprecatedType val:
        :rtype: EventType
        """
        return cls('showcase_trashed_deprecated', val)

    @classmethod
    def showcase_unresolve_comment(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_unresolve_comment`` tag with value ``val``.

        :param ShowcaseUnresolveCommentType val:
        :rtype: EventType
        """
        return cls('showcase_unresolve_comment', val)

    @classmethod
    def showcase_untrashed(cls, val):
        """
        Create an instance of this class set to the ``showcase_untrashed`` tag
        with value ``val``.

        :param ShowcaseUntrashedType val:
        :rtype: EventType
        """
        return cls('showcase_untrashed', val)

    @classmethod
    def showcase_untrashed_deprecated(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_untrashed_deprecated`` tag with value ``val``.

        :param ShowcaseUntrashedDeprecatedType val:
        :rtype: EventType
        """
        return cls('showcase_untrashed_deprecated', val)

    @classmethod
    def showcase_view(cls, val):
        """
        Create an instance of this class set to the ``showcase_view`` tag with
        value ``val``.

        :param ShowcaseViewType val:
        :rtype: EventType
        """
        return cls('showcase_view', val)

    @classmethod
    def sso_add_cert(cls, val):
        """
        Create an instance of this class set to the ``sso_add_cert`` tag with
        value ``val``.

        :param SsoAddCertType val:
        :rtype: EventType
        """
        return cls('sso_add_cert', val)

    @classmethod
    def sso_add_login_url(cls, val):
        """
        Create an instance of this class set to the ``sso_add_login_url`` tag
        with value ``val``.

        :param SsoAddLoginUrlType val:
        :rtype: EventType
        """
        return cls('sso_add_login_url', val)

    @classmethod
    def sso_add_logout_url(cls, val):
        """
        Create an instance of this class set to the ``sso_add_logout_url`` tag
        with value ``val``.

        :param SsoAddLogoutUrlType val:
        :rtype: EventType
        """
        return cls('sso_add_logout_url', val)

    @classmethod
    def sso_change_cert(cls, val):
        """
        Create an instance of this class set to the ``sso_change_cert`` tag with
        value ``val``.

        :param SsoChangeCertType val:
        :rtype: EventType
        """
        return cls('sso_change_cert', val)

    @classmethod
    def sso_change_login_url(cls, val):
        """
        Create an instance of this class set to the ``sso_change_login_url`` tag
        with value ``val``.

        :param SsoChangeLoginUrlType val:
        :rtype: EventType
        """
        return cls('sso_change_login_url', val)

    @classmethod
    def sso_change_logout_url(cls, val):
        """
        Create an instance of this class set to the ``sso_change_logout_url``
        tag with value ``val``.

        :param SsoChangeLogoutUrlType val:
        :rtype: EventType
        """
        return cls('sso_change_logout_url', val)

    @classmethod
    def sso_change_saml_identity_mode(cls, val):
        """
        Create an instance of this class set to the
        ``sso_change_saml_identity_mode`` tag with value ``val``.

        :param SsoChangeSamlIdentityModeType val:
        :rtype: EventType
        """
        return cls('sso_change_saml_identity_mode', val)

    @classmethod
    def sso_remove_cert(cls, val):
        """
        Create an instance of this class set to the ``sso_remove_cert`` tag with
        value ``val``.

        :param SsoRemoveCertType val:
        :rtype: EventType
        """
        return cls('sso_remove_cert', val)

    @classmethod
    def sso_remove_login_url(cls, val):
        """
        Create an instance of this class set to the ``sso_remove_login_url`` tag
        with value ``val``.

        :param SsoRemoveLoginUrlType val:
        :rtype: EventType
        """
        return cls('sso_remove_login_url', val)

    @classmethod
    def sso_remove_logout_url(cls, val):
        """
        Create an instance of this class set to the ``sso_remove_logout_url``
        tag with value ``val``.

        :param SsoRemoveLogoutUrlType val:
        :rtype: EventType
        """
        return cls('sso_remove_logout_url', val)

    @classmethod
    def team_folder_change_status(cls, val):
        """
        Create an instance of this class set to the
        ``team_folder_change_status`` tag with value ``val``.

        :param TeamFolderChangeStatusType val:
        :rtype: EventType
        """
        return cls('team_folder_change_status', val)

    @classmethod
    def team_folder_create(cls, val):
        """
        Create an instance of this class set to the ``team_folder_create`` tag
        with value ``val``.

        :param TeamFolderCreateType val:
        :rtype: EventType
        """
        return cls('team_folder_create', val)

    @classmethod
    def team_folder_downgrade(cls, val):
        """
        Create an instance of this class set to the ``team_folder_downgrade``
        tag with value ``val``.

        :param TeamFolderDowngradeType val:
        :rtype: EventType
        """
        return cls('team_folder_downgrade', val)

    @classmethod
    def team_folder_permanently_delete(cls, val):
        """
        Create an instance of this class set to the
        ``team_folder_permanently_delete`` tag with value ``val``.

        :param TeamFolderPermanentlyDeleteType val:
        :rtype: EventType
        """
        return cls('team_folder_permanently_delete', val)

    @classmethod
    def team_folder_rename(cls, val):
        """
        Create an instance of this class set to the ``team_folder_rename`` tag
        with value ``val``.

        :param TeamFolderRenameType val:
        :rtype: EventType
        """
        return cls('team_folder_rename', val)

    @classmethod
    def team_selective_sync_settings_changed(cls, val):
        """
        Create an instance of this class set to the
        ``team_selective_sync_settings_changed`` tag with value ``val``.

        :param TeamSelectiveSyncSettingsChangedType val:
        :rtype: EventType
        """
        return cls('team_selective_sync_settings_changed', val)

    @classmethod
    def account_capture_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``account_capture_change_policy`` tag with value ``val``.

        :param AccountCaptureChangePolicyType val:
        :rtype: EventType
        """
        return cls('account_capture_change_policy', val)

    @classmethod
    def allow_download_disabled(cls, val):
        """
        Create an instance of this class set to the ``allow_download_disabled``
        tag with value ``val``.

        :param AllowDownloadDisabledType val:
        :rtype: EventType
        """
        return cls('allow_download_disabled', val)

    @classmethod
    def allow_download_enabled(cls, val):
        """
        Create an instance of this class set to the ``allow_download_enabled``
        tag with value ``val``.

        :param AllowDownloadEnabledType val:
        :rtype: EventType
        """
        return cls('allow_download_enabled', val)

    @classmethod
    def app_permissions_changed(cls, val):
        """
        Create an instance of this class set to the ``app_permissions_changed``
        tag with value ``val``.

        :param AppPermissionsChangedType val:
        :rtype: EventType
        """
        return cls('app_permissions_changed', val)

    @classmethod
    def camera_uploads_policy_changed(cls, val):
        """
        Create an instance of this class set to the
        ``camera_uploads_policy_changed`` tag with value ``val``.

        :param CameraUploadsPolicyChangedType val:
        :rtype: EventType
        """
        return cls('camera_uploads_policy_changed', val)

    @classmethod
    def capture_transcript_policy_changed(cls, val):
        """
        Create an instance of this class set to the
        ``capture_transcript_policy_changed`` tag with value ``val``.

        :param CaptureTranscriptPolicyChangedType val:
        :rtype: EventType
        """
        return cls('capture_transcript_policy_changed', val)

    @classmethod
    def classification_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``classification_change_policy`` tag with value ``val``.

        :param ClassificationChangePolicyType val:
        :rtype: EventType
        """
        return cls('classification_change_policy', val)

    @classmethod
    def computer_backup_policy_changed(cls, val):
        """
        Create an instance of this class set to the
        ``computer_backup_policy_changed`` tag with value ``val``.

        :param ComputerBackupPolicyChangedType val:
        :rtype: EventType
        """
        return cls('computer_backup_policy_changed', val)

    @classmethod
    def content_administration_policy_changed(cls, val):
        """
        Create an instance of this class set to the
        ``content_administration_policy_changed`` tag with value ``val``.

        :param ContentAdministrationPolicyChangedType val:
        :rtype: EventType
        """
        return cls('content_administration_policy_changed', val)

    @classmethod
    def data_placement_restriction_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``data_placement_restriction_change_policy`` tag with value ``val``.

        :param DataPlacementRestrictionChangePolicyType val:
        :rtype: EventType
        """
        return cls('data_placement_restriction_change_policy', val)

    @classmethod
    def data_placement_restriction_satisfy_policy(cls, val):
        """
        Create an instance of this class set to the
        ``data_placement_restriction_satisfy_policy`` tag with value ``val``.

        :param DataPlacementRestrictionSatisfyPolicyType val:
        :rtype: EventType
        """
        return cls('data_placement_restriction_satisfy_policy', val)

    @classmethod
    def device_approvals_add_exception(cls, val):
        """
        Create an instance of this class set to the
        ``device_approvals_add_exception`` tag with value ``val``.

        :param DeviceApprovalsAddExceptionType val:
        :rtype: EventType
        """
        return cls('device_approvals_add_exception', val)

    @classmethod
    def device_approvals_change_desktop_policy(cls, val):
        """
        Create an instance of this class set to the
        ``device_approvals_change_desktop_policy`` tag with value ``val``.

        :param DeviceApprovalsChangeDesktopPolicyType val:
        :rtype: EventType
        """
        return cls('device_approvals_change_desktop_policy', val)

    @classmethod
    def device_approvals_change_mobile_policy(cls, val):
        """
        Create an instance of this class set to the
        ``device_approvals_change_mobile_policy`` tag with value ``val``.

        :param DeviceApprovalsChangeMobilePolicyType val:
        :rtype: EventType
        """
        return cls('device_approvals_change_mobile_policy', val)

    @classmethod
    def device_approvals_change_overage_action(cls, val):
        """
        Create an instance of this class set to the
        ``device_approvals_change_overage_action`` tag with value ``val``.

        :param DeviceApprovalsChangeOverageActionType val:
        :rtype: EventType
        """
        return cls('device_approvals_change_overage_action', val)

    @classmethod
    def device_approvals_change_unlink_action(cls, val):
        """
        Create an instance of this class set to the
        ``device_approvals_change_unlink_action`` tag with value ``val``.

        :param DeviceApprovalsChangeUnlinkActionType val:
        :rtype: EventType
        """
        return cls('device_approvals_change_unlink_action', val)

    @classmethod
    def device_approvals_remove_exception(cls, val):
        """
        Create an instance of this class set to the
        ``device_approvals_remove_exception`` tag with value ``val``.

        :param DeviceApprovalsRemoveExceptionType val:
        :rtype: EventType
        """
        return cls('device_approvals_remove_exception', val)

    @classmethod
    def directory_restrictions_add_members(cls, val):
        """
        Create an instance of this class set to the
        ``directory_restrictions_add_members`` tag with value ``val``.

        :param DirectoryRestrictionsAddMembersType val:
        :rtype: EventType
        """
        return cls('directory_restrictions_add_members', val)

    @classmethod
    def directory_restrictions_remove_members(cls, val):
        """
        Create an instance of this class set to the
        ``directory_restrictions_remove_members`` tag with value ``val``.

        :param DirectoryRestrictionsRemoveMembersType val:
        :rtype: EventType
        """
        return cls('directory_restrictions_remove_members', val)

    @classmethod
    def email_ingest_policy_changed(cls, val):
        """
        Create an instance of this class set to the
        ``email_ingest_policy_changed`` tag with value ``val``.

        :param EmailIngestPolicyChangedType val:
        :rtype: EventType
        """
        return cls('email_ingest_policy_changed', val)

    @classmethod
    def emm_add_exception(cls, val):
        """
        Create an instance of this class set to the ``emm_add_exception`` tag
        with value ``val``.

        :param EmmAddExceptionType val:
        :rtype: EventType
        """
        return cls('emm_add_exception', val)

    @classmethod
    def emm_change_policy(cls, val):
        """
        Create an instance of this class set to the ``emm_change_policy`` tag
        with value ``val``.

        :param EmmChangePolicyType val:
        :rtype: EventType
        """
        return cls('emm_change_policy', val)

    @classmethod
    def emm_remove_exception(cls, val):
        """
        Create an instance of this class set to the ``emm_remove_exception`` tag
        with value ``val``.

        :param EmmRemoveExceptionType val:
        :rtype: EventType
        """
        return cls('emm_remove_exception', val)

    @classmethod
    def extended_version_history_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``extended_version_history_change_policy`` tag with value ``val``.

        :param ExtendedVersionHistoryChangePolicyType val:
        :rtype: EventType
        """
        return cls('extended_version_history_change_policy', val)

    @classmethod
    def external_drive_backup_policy_changed(cls, val):
        """
        Create an instance of this class set to the
        ``external_drive_backup_policy_changed`` tag with value ``val``.

        :param ExternalDriveBackupPolicyChangedType val:
        :rtype: EventType
        """
        return cls('external_drive_backup_policy_changed', val)

    @classmethod
    def file_comments_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``file_comments_change_policy`` tag with value ``val``.

        :param FileCommentsChangePolicyType val:
        :rtype: EventType
        """
        return cls('file_comments_change_policy', val)

    @classmethod
    def file_locking_policy_changed(cls, val):
        """
        Create an instance of this class set to the
        ``file_locking_policy_changed`` tag with value ``val``.

        :param FileLockingPolicyChangedType val:
        :rtype: EventType
        """
        return cls('file_locking_policy_changed', val)

    @classmethod
    def file_requests_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``file_requests_change_policy`` tag with value ``val``.

        :param FileRequestsChangePolicyType val:
        :rtype: EventType
        """
        return cls('file_requests_change_policy', val)

    @classmethod
    def file_requests_emails_enabled(cls, val):
        """
        Create an instance of this class set to the
        ``file_requests_emails_enabled`` tag with value ``val``.

        :param FileRequestsEmailsEnabledType val:
        :rtype: EventType
        """
        return cls('file_requests_emails_enabled', val)

    @classmethod
    def file_requests_emails_restricted_to_team_only(cls, val):
        """
        Create an instance of this class set to the
        ``file_requests_emails_restricted_to_team_only`` tag with value ``val``.

        :param FileRequestsEmailsRestrictedToTeamOnlyType val:
        :rtype: EventType
        """
        return cls('file_requests_emails_restricted_to_team_only', val)

    @classmethod
    def file_transfers_policy_changed(cls, val):
        """
        Create an instance of this class set to the
        ``file_transfers_policy_changed`` tag with value ``val``.

        :param FileTransfersPolicyChangedType val:
        :rtype: EventType
        """
        return cls('file_transfers_policy_changed', val)

    @classmethod
    def google_sso_change_policy(cls, val):
        """
        Create an instance of this class set to the ``google_sso_change_policy``
        tag with value ``val``.

        :param GoogleSsoChangePolicyType val:
        :rtype: EventType
        """
        return cls('google_sso_change_policy', val)

    @classmethod
    def group_user_management_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``group_user_management_change_policy`` tag with value ``val``.

        :param GroupUserManagementChangePolicyType val:
        :rtype: EventType
        """
        return cls('group_user_management_change_policy', val)

    @classmethod
    def integration_policy_changed(cls, val):
        """
        Create an instance of this class set to the
        ``integration_policy_changed`` tag with value ``val``.

        :param IntegrationPolicyChangedType val:
        :rtype: EventType
        """
        return cls('integration_policy_changed', val)

    @classmethod
    def invite_acceptance_email_policy_changed(cls, val):
        """
        Create an instance of this class set to the
        ``invite_acceptance_email_policy_changed`` tag with value ``val``.

        :param InviteAcceptanceEmailPolicyChangedType val:
        :rtype: EventType
        """
        return cls('invite_acceptance_email_policy_changed', val)

    @classmethod
    def member_requests_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``member_requests_change_policy`` tag with value ``val``.

        :param MemberRequestsChangePolicyType val:
        :rtype: EventType
        """
        return cls('member_requests_change_policy', val)

    @classmethod
    def member_send_invite_policy_changed(cls, val):
        """
        Create an instance of this class set to the
        ``member_send_invite_policy_changed`` tag with value ``val``.

        :param MemberSendInvitePolicyChangedType val:
        :rtype: EventType
        """
        return cls('member_send_invite_policy_changed', val)

    @classmethod
    def member_space_limits_add_exception(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_add_exception`` tag with value ``val``.

        :param MemberSpaceLimitsAddExceptionType val:
        :rtype: EventType
        """
        return cls('member_space_limits_add_exception', val)

    @classmethod
    def member_space_limits_change_caps_type_policy(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_change_caps_type_policy`` tag with value ``val``.

        :param MemberSpaceLimitsChangeCapsTypePolicyType val:
        :rtype: EventType
        """
        return cls('member_space_limits_change_caps_type_policy', val)

    @classmethod
    def member_space_limits_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_change_policy`` tag with value ``val``.

        :param MemberSpaceLimitsChangePolicyType val:
        :rtype: EventType
        """
        return cls('member_space_limits_change_policy', val)

    @classmethod
    def member_space_limits_remove_exception(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_remove_exception`` tag with value ``val``.

        :param MemberSpaceLimitsRemoveExceptionType val:
        :rtype: EventType
        """
        return cls('member_space_limits_remove_exception', val)

    @classmethod
    def member_suggestions_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``member_suggestions_change_policy`` tag with value ``val``.

        :param MemberSuggestionsChangePolicyType val:
        :rtype: EventType
        """
        return cls('member_suggestions_change_policy', val)

    @classmethod
    def microsoft_office_addin_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``microsoft_office_addin_change_policy`` tag with value ``val``.

        :param MicrosoftOfficeAddinChangePolicyType val:
        :rtype: EventType
        """
        return cls('microsoft_office_addin_change_policy', val)

    @classmethod
    def network_control_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``network_control_change_policy`` tag with value ``val``.

        :param NetworkControlChangePolicyType val:
        :rtype: EventType
        """
        return cls('network_control_change_policy', val)

    @classmethod
    def paper_change_deployment_policy(cls, val):
        """
        Create an instance of this class set to the
        ``paper_change_deployment_policy`` tag with value ``val``.

        :param PaperChangeDeploymentPolicyType val:
        :rtype: EventType
        """
        return cls('paper_change_deployment_policy', val)

    @classmethod
    def paper_change_member_link_policy(cls, val):
        """
        Create an instance of this class set to the
        ``paper_change_member_link_policy`` tag with value ``val``.

        :param PaperChangeMemberLinkPolicyType val:
        :rtype: EventType
        """
        return cls('paper_change_member_link_policy', val)

    @classmethod
    def paper_change_member_policy(cls, val):
        """
        Create an instance of this class set to the
        ``paper_change_member_policy`` tag with value ``val``.

        :param PaperChangeMemberPolicyType val:
        :rtype: EventType
        """
        return cls('paper_change_member_policy', val)

    @classmethod
    def paper_change_policy(cls, val):
        """
        Create an instance of this class set to the ``paper_change_policy`` tag
        with value ``val``.

        :param PaperChangePolicyType val:
        :rtype: EventType
        """
        return cls('paper_change_policy', val)

    @classmethod
    def paper_default_folder_policy_changed(cls, val):
        """
        Create an instance of this class set to the
        ``paper_default_folder_policy_changed`` tag with value ``val``.

        :param PaperDefaultFolderPolicyChangedType val:
        :rtype: EventType
        """
        return cls('paper_default_folder_policy_changed', val)

    @classmethod
    def paper_desktop_policy_changed(cls, val):
        """
        Create an instance of this class set to the
        ``paper_desktop_policy_changed`` tag with value ``val``.

        :param PaperDesktopPolicyChangedType val:
        :rtype: EventType
        """
        return cls('paper_desktop_policy_changed', val)

    @classmethod
    def paper_enabled_users_group_addition(cls, val):
        """
        Create an instance of this class set to the
        ``paper_enabled_users_group_addition`` tag with value ``val``.

        :param PaperEnabledUsersGroupAdditionType val:
        :rtype: EventType
        """
        return cls('paper_enabled_users_group_addition', val)

    @classmethod
    def paper_enabled_users_group_removal(cls, val):
        """
        Create an instance of this class set to the
        ``paper_enabled_users_group_removal`` tag with value ``val``.

        :param PaperEnabledUsersGroupRemovalType val:
        :rtype: EventType
        """
        return cls('paper_enabled_users_group_removal', val)

    @classmethod
    def password_strength_requirements_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``password_strength_requirements_change_policy`` tag with value ``val``.

        :param PasswordStrengthRequirementsChangePolicyType val:
        :rtype: EventType
        """
        return cls('password_strength_requirements_change_policy', val)

    @classmethod
    def permanent_delete_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``permanent_delete_change_policy`` tag with value ``val``.

        :param PermanentDeleteChangePolicyType val:
        :rtype: EventType
        """
        return cls('permanent_delete_change_policy', val)

    @classmethod
    def reseller_support_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``reseller_support_change_policy`` tag with value ``val``.

        :param ResellerSupportChangePolicyType val:
        :rtype: EventType
        """
        return cls('reseller_support_change_policy', val)

    @classmethod
    def rewind_policy_changed(cls, val):
        """
        Create an instance of this class set to the ``rewind_policy_changed``
        tag with value ``val``.

        :param RewindPolicyChangedType val:
        :rtype: EventType
        """
        return cls('rewind_policy_changed', val)

    @classmethod
    def send_for_signature_policy_changed(cls, val):
        """
        Create an instance of this class set to the
        ``send_for_signature_policy_changed`` tag with value ``val``.

        :param SendForSignaturePolicyChangedType val:
        :rtype: EventType
        """
        return cls('send_for_signature_policy_changed', val)

    @classmethod
    def sharing_change_folder_join_policy(cls, val):
        """
        Create an instance of this class set to the
        ``sharing_change_folder_join_policy`` tag with value ``val``.

        :param SharingChangeFolderJoinPolicyType val:
        :rtype: EventType
        """
        return cls('sharing_change_folder_join_policy', val)

    @classmethod
    def sharing_change_link_allow_change_expiration_policy(cls, val):
        """
        Create an instance of this class set to the
        ``sharing_change_link_allow_change_expiration_policy`` tag with value
        ``val``.

        :param SharingChangeLinkAllowChangeExpirationPolicyType val:
        :rtype: EventType
        """
        return cls('sharing_change_link_allow_change_expiration_policy', val)

    @classmethod
    def sharing_change_link_default_expiration_policy(cls, val):
        """
        Create an instance of this class set to the
        ``sharing_change_link_default_expiration_policy`` tag with value
        ``val``.

        :param SharingChangeLinkDefaultExpirationPolicyType val:
        :rtype: EventType
        """
        return cls('sharing_change_link_default_expiration_policy', val)

    @classmethod
    def sharing_change_link_enforce_password_policy(cls, val):
        """
        Create an instance of this class set to the
        ``sharing_change_link_enforce_password_policy`` tag with value ``val``.

        :param SharingChangeLinkEnforcePasswordPolicyType val:
        :rtype: EventType
        """
        return cls('sharing_change_link_enforce_password_policy', val)

    @classmethod
    def sharing_change_link_policy(cls, val):
        """
        Create an instance of this class set to the
        ``sharing_change_link_policy`` tag with value ``val``.

        :param SharingChangeLinkPolicyType val:
        :rtype: EventType
        """
        return cls('sharing_change_link_policy', val)

    @classmethod
    def sharing_change_member_policy(cls, val):
        """
        Create an instance of this class set to the
        ``sharing_change_member_policy`` tag with value ``val``.

        :param SharingChangeMemberPolicyType val:
        :rtype: EventType
        """
        return cls('sharing_change_member_policy', val)

    @classmethod
    def showcase_change_download_policy(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_change_download_policy`` tag with value ``val``.

        :param ShowcaseChangeDownloadPolicyType val:
        :rtype: EventType
        """
        return cls('showcase_change_download_policy', val)

    @classmethod
    def showcase_change_enabled_policy(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_change_enabled_policy`` tag with value ``val``.

        :param ShowcaseChangeEnabledPolicyType val:
        :rtype: EventType
        """
        return cls('showcase_change_enabled_policy', val)

    @classmethod
    def showcase_change_external_sharing_policy(cls, val):
        """
        Create an instance of this class set to the
        ``showcase_change_external_sharing_policy`` tag with value ``val``.

        :param ShowcaseChangeExternalSharingPolicyType val:
        :rtype: EventType
        """
        return cls('showcase_change_external_sharing_policy', val)

    @classmethod
    def smarter_smart_sync_policy_changed(cls, val):
        """
        Create an instance of this class set to the
        ``smarter_smart_sync_policy_changed`` tag with value ``val``.

        :param SmarterSmartSyncPolicyChangedType val:
        :rtype: EventType
        """
        return cls('smarter_smart_sync_policy_changed', val)

    @classmethod
    def smart_sync_change_policy(cls, val):
        """
        Create an instance of this class set to the ``smart_sync_change_policy``
        tag with value ``val``.

        :param SmartSyncChangePolicyType val:
        :rtype: EventType
        """
        return cls('smart_sync_change_policy', val)

    @classmethod
    def smart_sync_not_opt_out(cls, val):
        """
        Create an instance of this class set to the ``smart_sync_not_opt_out``
        tag with value ``val``.

        :param SmartSyncNotOptOutType val:
        :rtype: EventType
        """
        return cls('smart_sync_not_opt_out', val)

    @classmethod
    def smart_sync_opt_out(cls, val):
        """
        Create an instance of this class set to the ``smart_sync_opt_out`` tag
        with value ``val``.

        :param SmartSyncOptOutType val:
        :rtype: EventType
        """
        return cls('smart_sync_opt_out', val)

    @classmethod
    def sso_change_policy(cls, val):
        """
        Create an instance of this class set to the ``sso_change_policy`` tag
        with value ``val``.

        :param SsoChangePolicyType val:
        :rtype: EventType
        """
        return cls('sso_change_policy', val)

    @classmethod
    def team_branding_policy_changed(cls, val):
        """
        Create an instance of this class set to the
        ``team_branding_policy_changed`` tag with value ``val``.

        :param TeamBrandingPolicyChangedType val:
        :rtype: EventType
        """
        return cls('team_branding_policy_changed', val)

    @classmethod
    def team_extensions_policy_changed(cls, val):
        """
        Create an instance of this class set to the
        ``team_extensions_policy_changed`` tag with value ``val``.

        :param TeamExtensionsPolicyChangedType val:
        :rtype: EventType
        """
        return cls('team_extensions_policy_changed', val)

    @classmethod
    def team_selective_sync_policy_changed(cls, val):
        """
        Create an instance of this class set to the
        ``team_selective_sync_policy_changed`` tag with value ``val``.

        :param TeamSelectiveSyncPolicyChangedType val:
        :rtype: EventType
        """
        return cls('team_selective_sync_policy_changed', val)

    @classmethod
    def team_sharing_whitelist_subjects_changed(cls, val):
        """
        Create an instance of this class set to the
        ``team_sharing_whitelist_subjects_changed`` tag with value ``val``.

        :param TeamSharingWhitelistSubjectsChangedType val:
        :rtype: EventType
        """
        return cls('team_sharing_whitelist_subjects_changed', val)

    @classmethod
    def tfa_add_exception(cls, val):
        """
        Create an instance of this class set to the ``tfa_add_exception`` tag
        with value ``val``.

        :param TfaAddExceptionType val:
        :rtype: EventType
        """
        return cls('tfa_add_exception', val)

    @classmethod
    def tfa_change_policy(cls, val):
        """
        Create an instance of this class set to the ``tfa_change_policy`` tag
        with value ``val``.

        :param TfaChangePolicyType val:
        :rtype: EventType
        """
        return cls('tfa_change_policy', val)

    @classmethod
    def tfa_remove_exception(cls, val):
        """
        Create an instance of this class set to the ``tfa_remove_exception`` tag
        with value ``val``.

        :param TfaRemoveExceptionType val:
        :rtype: EventType
        """
        return cls('tfa_remove_exception', val)

    @classmethod
    def two_account_change_policy(cls, val):
        """
        Create an instance of this class set to the
        ``two_account_change_policy`` tag with value ``val``.

        :param TwoAccountChangePolicyType val:
        :rtype: EventType
        """
        return cls('two_account_change_policy', val)

    @classmethod
    def viewer_info_policy_changed(cls, val):
        """
        Create an instance of this class set to the
        ``viewer_info_policy_changed`` tag with value ``val``.

        :param ViewerInfoPolicyChangedType val:
        :rtype: EventType
        """
        return cls('viewer_info_policy_changed', val)

    @classmethod
    def watermarking_policy_changed(cls, val):
        """
        Create an instance of this class set to the
        ``watermarking_policy_changed`` tag with value ``val``.

        :param WatermarkingPolicyChangedType val:
        :rtype: EventType
        """
        return cls('watermarking_policy_changed', val)

    @classmethod
    def web_sessions_change_active_session_limit(cls, val):
        """
        Create an instance of this class set to the
        ``web_sessions_change_active_session_limit`` tag with value ``val``.

        :param WebSessionsChangeActiveSessionLimitType val:
        :rtype: EventType
        """
        return cls('web_sessions_change_active_session_limit', val)

    @classmethod
    def web_sessions_change_fixed_length_policy(cls, val):
        """
        Create an instance of this class set to the
        ``web_sessions_change_fixed_length_policy`` tag with value ``val``.

        :param WebSessionsChangeFixedLengthPolicyType val:
        :rtype: EventType
        """
        return cls('web_sessions_change_fixed_length_policy', val)

    @classmethod
    def web_sessions_change_idle_length_policy(cls, val):
        """
        Create an instance of this class set to the
        ``web_sessions_change_idle_length_policy`` tag with value ``val``.

        :param WebSessionsChangeIdleLengthPolicyType val:
        :rtype: EventType
        """
        return cls('web_sessions_change_idle_length_policy', val)

    @classmethod
    def data_residency_migration_request_successful(cls, val):
        """
        Create an instance of this class set to the
        ``data_residency_migration_request_successful`` tag with value ``val``.

        :param DataResidencyMigrationRequestSuccessfulType val:
        :rtype: EventType
        """
        return cls('data_residency_migration_request_successful', val)

    @classmethod
    def data_residency_migration_request_unsuccessful(cls, val):
        """
        Create an instance of this class set to the
        ``data_residency_migration_request_unsuccessful`` tag with value
        ``val``.

        :param DataResidencyMigrationRequestUnsuccessfulType val:
        :rtype: EventType
        """
        return cls('data_residency_migration_request_unsuccessful', val)

    @classmethod
    def team_merge_from(cls, val):
        """
        Create an instance of this class set to the ``team_merge_from`` tag with
        value ``val``.

        :param TeamMergeFromType val:
        :rtype: EventType
        """
        return cls('team_merge_from', val)

    @classmethod
    def team_merge_to(cls, val):
        """
        Create an instance of this class set to the ``team_merge_to`` tag with
        value ``val``.

        :param TeamMergeToType val:
        :rtype: EventType
        """
        return cls('team_merge_to', val)

    @classmethod
    def team_profile_add_background(cls, val):
        """
        Create an instance of this class set to the
        ``team_profile_add_background`` tag with value ``val``.

        :param TeamProfileAddBackgroundType val:
        :rtype: EventType
        """
        return cls('team_profile_add_background', val)

    @classmethod
    def team_profile_add_logo(cls, val):
        """
        Create an instance of this class set to the ``team_profile_add_logo``
        tag with value ``val``.

        :param TeamProfileAddLogoType val:
        :rtype: EventType
        """
        return cls('team_profile_add_logo', val)

    @classmethod
    def team_profile_change_background(cls, val):
        """
        Create an instance of this class set to the
        ``team_profile_change_background`` tag with value ``val``.

        :param TeamProfileChangeBackgroundType val:
        :rtype: EventType
        """
        return cls('team_profile_change_background', val)

    @classmethod
    def team_profile_change_default_language(cls, val):
        """
        Create an instance of this class set to the
        ``team_profile_change_default_language`` tag with value ``val``.

        :param TeamProfileChangeDefaultLanguageType val:
        :rtype: EventType
        """
        return cls('team_profile_change_default_language', val)

    @classmethod
    def team_profile_change_logo(cls, val):
        """
        Create an instance of this class set to the ``team_profile_change_logo``
        tag with value ``val``.

        :param TeamProfileChangeLogoType val:
        :rtype: EventType
        """
        return cls('team_profile_change_logo', val)

    @classmethod
    def team_profile_change_name(cls, val):
        """
        Create an instance of this class set to the ``team_profile_change_name``
        tag with value ``val``.

        :param TeamProfileChangeNameType val:
        :rtype: EventType
        """
        return cls('team_profile_change_name', val)

    @classmethod
    def team_profile_remove_background(cls, val):
        """
        Create an instance of this class set to the
        ``team_profile_remove_background`` tag with value ``val``.

        :param TeamProfileRemoveBackgroundType val:
        :rtype: EventType
        """
        return cls('team_profile_remove_background', val)

    @classmethod
    def team_profile_remove_logo(cls, val):
        """
        Create an instance of this class set to the ``team_profile_remove_logo``
        tag with value ``val``.

        :param TeamProfileRemoveLogoType val:
        :rtype: EventType
        """
        return cls('team_profile_remove_logo', val)

    @classmethod
    def tfa_add_backup_phone(cls, val):
        """
        Create an instance of this class set to the ``tfa_add_backup_phone`` tag
        with value ``val``.

        :param TfaAddBackupPhoneType val:
        :rtype: EventType
        """
        return cls('tfa_add_backup_phone', val)

    @classmethod
    def tfa_add_security_key(cls, val):
        """
        Create an instance of this class set to the ``tfa_add_security_key`` tag
        with value ``val``.

        :param TfaAddSecurityKeyType val:
        :rtype: EventType
        """
        return cls('tfa_add_security_key', val)

    @classmethod
    def tfa_change_backup_phone(cls, val):
        """
        Create an instance of this class set to the ``tfa_change_backup_phone``
        tag with value ``val``.

        :param TfaChangeBackupPhoneType val:
        :rtype: EventType
        """
        return cls('tfa_change_backup_phone', val)

    @classmethod
    def tfa_change_status(cls, val):
        """
        Create an instance of this class set to the ``tfa_change_status`` tag
        with value ``val``.

        :param TfaChangeStatusType val:
        :rtype: EventType
        """
        return cls('tfa_change_status', val)

    @classmethod
    def tfa_remove_backup_phone(cls, val):
        """
        Create an instance of this class set to the ``tfa_remove_backup_phone``
        tag with value ``val``.

        :param TfaRemoveBackupPhoneType val:
        :rtype: EventType
        """
        return cls('tfa_remove_backup_phone', val)

    @classmethod
    def tfa_remove_security_key(cls, val):
        """
        Create an instance of this class set to the ``tfa_remove_security_key``
        tag with value ``val``.

        :param TfaRemoveSecurityKeyType val:
        :rtype: EventType
        """
        return cls('tfa_remove_security_key', val)

    @classmethod
    def tfa_reset(cls, val):
        """
        Create an instance of this class set to the ``tfa_reset`` tag with value
        ``val``.

        :param TfaResetType val:
        :rtype: EventType
        """
        return cls('tfa_reset', val)

    @classmethod
    def changed_enterprise_admin_role(cls, val):
        """
        Create an instance of this class set to the
        ``changed_enterprise_admin_role`` tag with value ``val``.

        :param ChangedEnterpriseAdminRoleType val:
        :rtype: EventType
        """
        return cls('changed_enterprise_admin_role', val)

    @classmethod
    def changed_enterprise_connected_team_status(cls, val):
        """
        Create an instance of this class set to the
        ``changed_enterprise_connected_team_status`` tag with value ``val``.

        :param ChangedEnterpriseConnectedTeamStatusType val:
        :rtype: EventType
        """
        return cls('changed_enterprise_connected_team_status', val)

    @classmethod
    def ended_enterprise_admin_session(cls, val):
        """
        Create an instance of this class set to the
        ``ended_enterprise_admin_session`` tag with value ``val``.

        :param EndedEnterpriseAdminSessionType val:
        :rtype: EventType
        """
        return cls('ended_enterprise_admin_session', val)

    @classmethod
    def ended_enterprise_admin_session_deprecated(cls, val):
        """
        Create an instance of this class set to the
        ``ended_enterprise_admin_session_deprecated`` tag with value ``val``.

        :param EndedEnterpriseAdminSessionDeprecatedType val:
        :rtype: EventType
        """
        return cls('ended_enterprise_admin_session_deprecated', val)

    @classmethod
    def enterprise_settings_locking(cls, val):
        """
        Create an instance of this class set to the
        ``enterprise_settings_locking`` tag with value ``val``.

        :param EnterpriseSettingsLockingType val:
        :rtype: EventType
        """
        return cls('enterprise_settings_locking', val)

    @classmethod
    def guest_admin_change_status(cls, val):
        """
        Create an instance of this class set to the
        ``guest_admin_change_status`` tag with value ``val``.

        :param GuestAdminChangeStatusType val:
        :rtype: EventType
        """
        return cls('guest_admin_change_status', val)

    @classmethod
    def started_enterprise_admin_session(cls, val):
        """
        Create an instance of this class set to the
        ``started_enterprise_admin_session`` tag with value ``val``.

        :param StartedEnterpriseAdminSessionType val:
        :rtype: EventType
        """
        return cls('started_enterprise_admin_session', val)

    @classmethod
    def team_merge_request_accepted(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_accepted`` tag with value ``val``.

        :param TeamMergeRequestAcceptedType val:
        :rtype: EventType
        """
        return cls('team_merge_request_accepted', val)

    @classmethod
    def team_merge_request_accepted_shown_to_primary_team(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_accepted_shown_to_primary_team`` tag with value
        ``val``.

        :param TeamMergeRequestAcceptedShownToPrimaryTeamType val:
        :rtype: EventType
        """
        return cls('team_merge_request_accepted_shown_to_primary_team', val)

    @classmethod
    def team_merge_request_accepted_shown_to_secondary_team(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_accepted_shown_to_secondary_team`` tag with value
        ``val``.

        :param TeamMergeRequestAcceptedShownToSecondaryTeamType val:
        :rtype: EventType
        """
        return cls('team_merge_request_accepted_shown_to_secondary_team', val)

    @classmethod
    def team_merge_request_auto_canceled(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_auto_canceled`` tag with value ``val``.

        :param TeamMergeRequestAutoCanceledType val:
        :rtype: EventType
        """
        return cls('team_merge_request_auto_canceled', val)

    @classmethod
    def team_merge_request_canceled(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_canceled`` tag with value ``val``.

        :param TeamMergeRequestCanceledType val:
        :rtype: EventType
        """
        return cls('team_merge_request_canceled', val)

    @classmethod
    def team_merge_request_canceled_shown_to_primary_team(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_canceled_shown_to_primary_team`` tag with value
        ``val``.

        :param TeamMergeRequestCanceledShownToPrimaryTeamType val:
        :rtype: EventType
        """
        return cls('team_merge_request_canceled_shown_to_primary_team', val)

    @classmethod
    def team_merge_request_canceled_shown_to_secondary_team(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_canceled_shown_to_secondary_team`` tag with value
        ``val``.

        :param TeamMergeRequestCanceledShownToSecondaryTeamType val:
        :rtype: EventType
        """
        return cls('team_merge_request_canceled_shown_to_secondary_team', val)

    @classmethod
    def team_merge_request_expired(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_expired`` tag with value ``val``.

        :param TeamMergeRequestExpiredType val:
        :rtype: EventType
        """
        return cls('team_merge_request_expired', val)

    @classmethod
    def team_merge_request_expired_shown_to_primary_team(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_expired_shown_to_primary_team`` tag with value
        ``val``.

        :param TeamMergeRequestExpiredShownToPrimaryTeamType val:
        :rtype: EventType
        """
        return cls('team_merge_request_expired_shown_to_primary_team', val)

    @classmethod
    def team_merge_request_expired_shown_to_secondary_team(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_expired_shown_to_secondary_team`` tag with value
        ``val``.

        :param TeamMergeRequestExpiredShownToSecondaryTeamType val:
        :rtype: EventType
        """
        return cls('team_merge_request_expired_shown_to_secondary_team', val)

    @classmethod
    def team_merge_request_rejected_shown_to_primary_team(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_rejected_shown_to_primary_team`` tag with value
        ``val``.

        :param TeamMergeRequestRejectedShownToPrimaryTeamType val:
        :rtype: EventType
        """
        return cls('team_merge_request_rejected_shown_to_primary_team', val)

    @classmethod
    def team_merge_request_rejected_shown_to_secondary_team(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_rejected_shown_to_secondary_team`` tag with value
        ``val``.

        :param TeamMergeRequestRejectedShownToSecondaryTeamType val:
        :rtype: EventType
        """
        return cls('team_merge_request_rejected_shown_to_secondary_team', val)

    @classmethod
    def team_merge_request_reminder(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_reminder`` tag with value ``val``.

        :param TeamMergeRequestReminderType val:
        :rtype: EventType
        """
        return cls('team_merge_request_reminder', val)

    @classmethod
    def team_merge_request_reminder_shown_to_primary_team(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_reminder_shown_to_primary_team`` tag with value
        ``val``.

        :param TeamMergeRequestReminderShownToPrimaryTeamType val:
        :rtype: EventType
        """
        return cls('team_merge_request_reminder_shown_to_primary_team', val)

    @classmethod
    def team_merge_request_reminder_shown_to_secondary_team(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_reminder_shown_to_secondary_team`` tag with value
        ``val``.

        :param TeamMergeRequestReminderShownToSecondaryTeamType val:
        :rtype: EventType
        """
        return cls('team_merge_request_reminder_shown_to_secondary_team', val)

    @classmethod
    def team_merge_request_revoked(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_revoked`` tag with value ``val``.

        :param TeamMergeRequestRevokedType val:
        :rtype: EventType
        """
        return cls('team_merge_request_revoked', val)

    @classmethod
    def team_merge_request_sent_shown_to_primary_team(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_sent_shown_to_primary_team`` tag with value
        ``val``.

        :param TeamMergeRequestSentShownToPrimaryTeamType val:
        :rtype: EventType
        """
        return cls('team_merge_request_sent_shown_to_primary_team', val)

    @classmethod
    def team_merge_request_sent_shown_to_secondary_team(cls, val):
        """
        Create an instance of this class set to the
        ``team_merge_request_sent_shown_to_secondary_team`` tag with value
        ``val``.

        :param TeamMergeRequestSentShownToSecondaryTeamType val:
        :rtype: EventType
        """
        return cls('team_merge_request_sent_shown_to_secondary_team', val)

    def is_admin_alerting_alert_state_changed(self):
        """
        Check if the union tag is ``admin_alerting_alert_state_changed``.

        :rtype: bool
        """
        return self._tag == 'admin_alerting_alert_state_changed'

    def is_admin_alerting_changed_alert_config(self):
        """
        Check if the union tag is ``admin_alerting_changed_alert_config``.

        :rtype: bool
        """
        return self._tag == 'admin_alerting_changed_alert_config'

    def is_admin_alerting_triggered_alert(self):
        """
        Check if the union tag is ``admin_alerting_triggered_alert``.

        :rtype: bool
        """
        return self._tag == 'admin_alerting_triggered_alert'

    def is_app_blocked_by_permissions(self):
        """
        Check if the union tag is ``app_blocked_by_permissions``.

        :rtype: bool
        """
        return self._tag == 'app_blocked_by_permissions'

    def is_app_link_team(self):
        """
        Check if the union tag is ``app_link_team``.

        :rtype: bool
        """
        return self._tag == 'app_link_team'

    def is_app_link_user(self):
        """
        Check if the union tag is ``app_link_user``.

        :rtype: bool
        """
        return self._tag == 'app_link_user'

    def is_app_unlink_team(self):
        """
        Check if the union tag is ``app_unlink_team``.

        :rtype: bool
        """
        return self._tag == 'app_unlink_team'

    def is_app_unlink_user(self):
        """
        Check if the union tag is ``app_unlink_user``.

        :rtype: bool
        """
        return self._tag == 'app_unlink_user'

    def is_integration_connected(self):
        """
        Check if the union tag is ``integration_connected``.

        :rtype: bool
        """
        return self._tag == 'integration_connected'

    def is_integration_disconnected(self):
        """
        Check if the union tag is ``integration_disconnected``.

        :rtype: bool
        """
        return self._tag == 'integration_disconnected'

    def is_file_add_comment(self):
        """
        Check if the union tag is ``file_add_comment``.

        :rtype: bool
        """
        return self._tag == 'file_add_comment'

    def is_file_change_comment_subscription(self):
        """
        Check if the union tag is ``file_change_comment_subscription``.

        :rtype: bool
        """
        return self._tag == 'file_change_comment_subscription'

    def is_file_delete_comment(self):
        """
        Check if the union tag is ``file_delete_comment``.

        :rtype: bool
        """
        return self._tag == 'file_delete_comment'

    def is_file_edit_comment(self):
        """
        Check if the union tag is ``file_edit_comment``.

        :rtype: bool
        """
        return self._tag == 'file_edit_comment'

    def is_file_like_comment(self):
        """
        Check if the union tag is ``file_like_comment``.

        :rtype: bool
        """
        return self._tag == 'file_like_comment'

    def is_file_resolve_comment(self):
        """
        Check if the union tag is ``file_resolve_comment``.

        :rtype: bool
        """
        return self._tag == 'file_resolve_comment'

    def is_file_unlike_comment(self):
        """
        Check if the union tag is ``file_unlike_comment``.

        :rtype: bool
        """
        return self._tag == 'file_unlike_comment'

    def is_file_unresolve_comment(self):
        """
        Check if the union tag is ``file_unresolve_comment``.

        :rtype: bool
        """
        return self._tag == 'file_unresolve_comment'

    def is_governance_policy_add_folders(self):
        """
        Check if the union tag is ``governance_policy_add_folders``.

        :rtype: bool
        """
        return self._tag == 'governance_policy_add_folders'

    def is_governance_policy_add_folder_failed(self):
        """
        Check if the union tag is ``governance_policy_add_folder_failed``.

        :rtype: bool
        """
        return self._tag == 'governance_policy_add_folder_failed'

    def is_governance_policy_content_disposed(self):
        """
        Check if the union tag is ``governance_policy_content_disposed``.

        :rtype: bool
        """
        return self._tag == 'governance_policy_content_disposed'

    def is_governance_policy_create(self):
        """
        Check if the union tag is ``governance_policy_create``.

        :rtype: bool
        """
        return self._tag == 'governance_policy_create'

    def is_governance_policy_delete(self):
        """
        Check if the union tag is ``governance_policy_delete``.

        :rtype: bool
        """
        return self._tag == 'governance_policy_delete'

    def is_governance_policy_edit_details(self):
        """
        Check if the union tag is ``governance_policy_edit_details``.

        :rtype: bool
        """
        return self._tag == 'governance_policy_edit_details'

    def is_governance_policy_edit_duration(self):
        """
        Check if the union tag is ``governance_policy_edit_duration``.

        :rtype: bool
        """
        return self._tag == 'governance_policy_edit_duration'

    def is_governance_policy_export_created(self):
        """
        Check if the union tag is ``governance_policy_export_created``.

        :rtype: bool
        """
        return self._tag == 'governance_policy_export_created'

    def is_governance_policy_export_removed(self):
        """
        Check if the union tag is ``governance_policy_export_removed``.

        :rtype: bool
        """
        return self._tag == 'governance_policy_export_removed'

    def is_governance_policy_remove_folders(self):
        """
        Check if the union tag is ``governance_policy_remove_folders``.

        :rtype: bool
        """
        return self._tag == 'governance_policy_remove_folders'

    def is_governance_policy_report_created(self):
        """
        Check if the union tag is ``governance_policy_report_created``.

        :rtype: bool
        """
        return self._tag == 'governance_policy_report_created'

    def is_governance_policy_zip_part_downloaded(self):
        """
        Check if the union tag is ``governance_policy_zip_part_downloaded``.

        :rtype: bool
        """
        return self._tag == 'governance_policy_zip_part_downloaded'

    def is_legal_holds_activate_a_hold(self):
        """
        Check if the union tag is ``legal_holds_activate_a_hold``.

        :rtype: bool
        """
        return self._tag == 'legal_holds_activate_a_hold'

    def is_legal_holds_add_members(self):
        """
        Check if the union tag is ``legal_holds_add_members``.

        :rtype: bool
        """
        return self._tag == 'legal_holds_add_members'

    def is_legal_holds_change_hold_details(self):
        """
        Check if the union tag is ``legal_holds_change_hold_details``.

        :rtype: bool
        """
        return self._tag == 'legal_holds_change_hold_details'

    def is_legal_holds_change_hold_name(self):
        """
        Check if the union tag is ``legal_holds_change_hold_name``.

        :rtype: bool
        """
        return self._tag == 'legal_holds_change_hold_name'

    def is_legal_holds_export_a_hold(self):
        """
        Check if the union tag is ``legal_holds_export_a_hold``.

        :rtype: bool
        """
        return self._tag == 'legal_holds_export_a_hold'

    def is_legal_holds_export_cancelled(self):
        """
        Check if the union tag is ``legal_holds_export_cancelled``.

        :rtype: bool
        """
        return self._tag == 'legal_holds_export_cancelled'

    def is_legal_holds_export_downloaded(self):
        """
        Check if the union tag is ``legal_holds_export_downloaded``.

        :rtype: bool
        """
        return self._tag == 'legal_holds_export_downloaded'

    def is_legal_holds_export_removed(self):
        """
        Check if the union tag is ``legal_holds_export_removed``.

        :rtype: bool
        """
        return self._tag == 'legal_holds_export_removed'

    def is_legal_holds_release_a_hold(self):
        """
        Check if the union tag is ``legal_holds_release_a_hold``.

        :rtype: bool
        """
        return self._tag == 'legal_holds_release_a_hold'

    def is_legal_holds_remove_members(self):
        """
        Check if the union tag is ``legal_holds_remove_members``.

        :rtype: bool
        """
        return self._tag == 'legal_holds_remove_members'

    def is_legal_holds_report_a_hold(self):
        """
        Check if the union tag is ``legal_holds_report_a_hold``.

        :rtype: bool
        """
        return self._tag == 'legal_holds_report_a_hold'

    def is_device_change_ip_desktop(self):
        """
        Check if the union tag is ``device_change_ip_desktop``.

        :rtype: bool
        """
        return self._tag == 'device_change_ip_desktop'

    def is_device_change_ip_mobile(self):
        """
        Check if the union tag is ``device_change_ip_mobile``.

        :rtype: bool
        """
        return self._tag == 'device_change_ip_mobile'

    def is_device_change_ip_web(self):
        """
        Check if the union tag is ``device_change_ip_web``.

        :rtype: bool
        """
        return self._tag == 'device_change_ip_web'

    def is_device_delete_on_unlink_fail(self):
        """
        Check if the union tag is ``device_delete_on_unlink_fail``.

        :rtype: bool
        """
        return self._tag == 'device_delete_on_unlink_fail'

    def is_device_delete_on_unlink_success(self):
        """
        Check if the union tag is ``device_delete_on_unlink_success``.

        :rtype: bool
        """
        return self._tag == 'device_delete_on_unlink_success'

    def is_device_link_fail(self):
        """
        Check if the union tag is ``device_link_fail``.

        :rtype: bool
        """
        return self._tag == 'device_link_fail'

    def is_device_link_success(self):
        """
        Check if the union tag is ``device_link_success``.

        :rtype: bool
        """
        return self._tag == 'device_link_success'

    def is_device_management_disabled(self):
        """
        Check if the union tag is ``device_management_disabled``.

        :rtype: bool
        """
        return self._tag == 'device_management_disabled'

    def is_device_management_enabled(self):
        """
        Check if the union tag is ``device_management_enabled``.

        :rtype: bool
        """
        return self._tag == 'device_management_enabled'

    def is_device_sync_backup_status_changed(self):
        """
        Check if the union tag is ``device_sync_backup_status_changed``.

        :rtype: bool
        """
        return self._tag == 'device_sync_backup_status_changed'

    def is_device_unlink(self):
        """
        Check if the union tag is ``device_unlink``.

        :rtype: bool
        """
        return self._tag == 'device_unlink'

    def is_dropbox_passwords_exported(self):
        """
        Check if the union tag is ``dropbox_passwords_exported``.

        :rtype: bool
        """
        return self._tag == 'dropbox_passwords_exported'

    def is_dropbox_passwords_new_device_enrolled(self):
        """
        Check if the union tag is ``dropbox_passwords_new_device_enrolled``.

        :rtype: bool
        """
        return self._tag == 'dropbox_passwords_new_device_enrolled'

    def is_emm_refresh_auth_token(self):
        """
        Check if the union tag is ``emm_refresh_auth_token``.

        :rtype: bool
        """
        return self._tag == 'emm_refresh_auth_token'

    def is_account_capture_change_availability(self):
        """
        Check if the union tag is ``account_capture_change_availability``.

        :rtype: bool
        """
        return self._tag == 'account_capture_change_availability'

    def is_account_capture_migrate_account(self):
        """
        Check if the union tag is ``account_capture_migrate_account``.

        :rtype: bool
        """
        return self._tag == 'account_capture_migrate_account'

    def is_account_capture_notification_emails_sent(self):
        """
        Check if the union tag is ``account_capture_notification_emails_sent``.

        :rtype: bool
        """
        return self._tag == 'account_capture_notification_emails_sent'

    def is_account_capture_relinquish_account(self):
        """
        Check if the union tag is ``account_capture_relinquish_account``.

        :rtype: bool
        """
        return self._tag == 'account_capture_relinquish_account'

    def is_disabled_domain_invites(self):
        """
        Check if the union tag is ``disabled_domain_invites``.

        :rtype: bool
        """
        return self._tag == 'disabled_domain_invites'

    def is_domain_invites_approve_request_to_join_team(self):
        """
        Check if the union tag is ``domain_invites_approve_request_to_join_team``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_approve_request_to_join_team'

    def is_domain_invites_decline_request_to_join_team(self):
        """
        Check if the union tag is ``domain_invites_decline_request_to_join_team``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_decline_request_to_join_team'

    def is_domain_invites_email_existing_users(self):
        """
        Check if the union tag is ``domain_invites_email_existing_users``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_email_existing_users'

    def is_domain_invites_request_to_join_team(self):
        """
        Check if the union tag is ``domain_invites_request_to_join_team``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_request_to_join_team'

    def is_domain_invites_set_invite_new_user_pref_to_no(self):
        """
        Check if the union tag is ``domain_invites_set_invite_new_user_pref_to_no``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_set_invite_new_user_pref_to_no'

    def is_domain_invites_set_invite_new_user_pref_to_yes(self):
        """
        Check if the union tag is ``domain_invites_set_invite_new_user_pref_to_yes``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_set_invite_new_user_pref_to_yes'

    def is_domain_verification_add_domain_fail(self):
        """
        Check if the union tag is ``domain_verification_add_domain_fail``.

        :rtype: bool
        """
        return self._tag == 'domain_verification_add_domain_fail'

    def is_domain_verification_add_domain_success(self):
        """
        Check if the union tag is ``domain_verification_add_domain_success``.

        :rtype: bool
        """
        return self._tag == 'domain_verification_add_domain_success'

    def is_domain_verification_remove_domain(self):
        """
        Check if the union tag is ``domain_verification_remove_domain``.

        :rtype: bool
        """
        return self._tag == 'domain_verification_remove_domain'

    def is_enabled_domain_invites(self):
        """
        Check if the union tag is ``enabled_domain_invites``.

        :rtype: bool
        """
        return self._tag == 'enabled_domain_invites'

    def is_apply_naming_convention(self):
        """
        Check if the union tag is ``apply_naming_convention``.

        :rtype: bool
        """
        return self._tag == 'apply_naming_convention'

    def is_create_folder(self):
        """
        Check if the union tag is ``create_folder``.

        :rtype: bool
        """
        return self._tag == 'create_folder'

    def is_file_add(self):
        """
        Check if the union tag is ``file_add``.

        :rtype: bool
        """
        return self._tag == 'file_add'

    def is_file_copy(self):
        """
        Check if the union tag is ``file_copy``.

        :rtype: bool
        """
        return self._tag == 'file_copy'

    def is_file_delete(self):
        """
        Check if the union tag is ``file_delete``.

        :rtype: bool
        """
        return self._tag == 'file_delete'

    def is_file_download(self):
        """
        Check if the union tag is ``file_download``.

        :rtype: bool
        """
        return self._tag == 'file_download'

    def is_file_edit(self):
        """
        Check if the union tag is ``file_edit``.

        :rtype: bool
        """
        return self._tag == 'file_edit'

    def is_file_get_copy_reference(self):
        """
        Check if the union tag is ``file_get_copy_reference``.

        :rtype: bool
        """
        return self._tag == 'file_get_copy_reference'

    def is_file_locking_lock_status_changed(self):
        """
        Check if the union tag is ``file_locking_lock_status_changed``.

        :rtype: bool
        """
        return self._tag == 'file_locking_lock_status_changed'

    def is_file_move(self):
        """
        Check if the union tag is ``file_move``.

        :rtype: bool
        """
        return self._tag == 'file_move'

    def is_file_permanently_delete(self):
        """
        Check if the union tag is ``file_permanently_delete``.

        :rtype: bool
        """
        return self._tag == 'file_permanently_delete'

    def is_file_preview(self):
        """
        Check if the union tag is ``file_preview``.

        :rtype: bool
        """
        return self._tag == 'file_preview'

    def is_file_rename(self):
        """
        Check if the union tag is ``file_rename``.

        :rtype: bool
        """
        return self._tag == 'file_rename'

    def is_file_restore(self):
        """
        Check if the union tag is ``file_restore``.

        :rtype: bool
        """
        return self._tag == 'file_restore'

    def is_file_revert(self):
        """
        Check if the union tag is ``file_revert``.

        :rtype: bool
        """
        return self._tag == 'file_revert'

    def is_file_rollback_changes(self):
        """
        Check if the union tag is ``file_rollback_changes``.

        :rtype: bool
        """
        return self._tag == 'file_rollback_changes'

    def is_file_save_copy_reference(self):
        """
        Check if the union tag is ``file_save_copy_reference``.

        :rtype: bool
        """
        return self._tag == 'file_save_copy_reference'

    def is_folder_overview_description_changed(self):
        """
        Check if the union tag is ``folder_overview_description_changed``.

        :rtype: bool
        """
        return self._tag == 'folder_overview_description_changed'

    def is_folder_overview_item_pinned(self):
        """
        Check if the union tag is ``folder_overview_item_pinned``.

        :rtype: bool
        """
        return self._tag == 'folder_overview_item_pinned'

    def is_folder_overview_item_unpinned(self):
        """
        Check if the union tag is ``folder_overview_item_unpinned``.

        :rtype: bool
        """
        return self._tag == 'folder_overview_item_unpinned'

    def is_object_label_added(self):
        """
        Check if the union tag is ``object_label_added``.

        :rtype: bool
        """
        return self._tag == 'object_label_added'

    def is_object_label_removed(self):
        """
        Check if the union tag is ``object_label_removed``.

        :rtype: bool
        """
        return self._tag == 'object_label_removed'

    def is_object_label_updated_value(self):
        """
        Check if the union tag is ``object_label_updated_value``.

        :rtype: bool
        """
        return self._tag == 'object_label_updated_value'

    def is_organize_folder_with_tidy(self):
        """
        Check if the union tag is ``organize_folder_with_tidy``.

        :rtype: bool
        """
        return self._tag == 'organize_folder_with_tidy'

    def is_rewind_folder(self):
        """
        Check if the union tag is ``rewind_folder``.

        :rtype: bool
        """
        return self._tag == 'rewind_folder'

    def is_undo_naming_convention(self):
        """
        Check if the union tag is ``undo_naming_convention``.

        :rtype: bool
        """
        return self._tag == 'undo_naming_convention'

    def is_undo_organize_folder_with_tidy(self):
        """
        Check if the union tag is ``undo_organize_folder_with_tidy``.

        :rtype: bool
        """
        return self._tag == 'undo_organize_folder_with_tidy'

    def is_user_tags_added(self):
        """
        Check if the union tag is ``user_tags_added``.

        :rtype: bool
        """
        return self._tag == 'user_tags_added'

    def is_user_tags_removed(self):
        """
        Check if the union tag is ``user_tags_removed``.

        :rtype: bool
        """
        return self._tag == 'user_tags_removed'

    def is_email_ingest_receive_file(self):
        """
        Check if the union tag is ``email_ingest_receive_file``.

        :rtype: bool
        """
        return self._tag == 'email_ingest_receive_file'

    def is_file_request_change(self):
        """
        Check if the union tag is ``file_request_change``.

        :rtype: bool
        """
        return self._tag == 'file_request_change'

    def is_file_request_close(self):
        """
        Check if the union tag is ``file_request_close``.

        :rtype: bool
        """
        return self._tag == 'file_request_close'

    def is_file_request_create(self):
        """
        Check if the union tag is ``file_request_create``.

        :rtype: bool
        """
        return self._tag == 'file_request_create'

    def is_file_request_delete(self):
        """
        Check if the union tag is ``file_request_delete``.

        :rtype: bool
        """
        return self._tag == 'file_request_delete'

    def is_file_request_receive_file(self):
        """
        Check if the union tag is ``file_request_receive_file``.

        :rtype: bool
        """
        return self._tag == 'file_request_receive_file'

    def is_group_add_external_id(self):
        """
        Check if the union tag is ``group_add_external_id``.

        :rtype: bool
        """
        return self._tag == 'group_add_external_id'

    def is_group_add_member(self):
        """
        Check if the union tag is ``group_add_member``.

        :rtype: bool
        """
        return self._tag == 'group_add_member'

    def is_group_change_external_id(self):
        """
        Check if the union tag is ``group_change_external_id``.

        :rtype: bool
        """
        return self._tag == 'group_change_external_id'

    def is_group_change_management_type(self):
        """
        Check if the union tag is ``group_change_management_type``.

        :rtype: bool
        """
        return self._tag == 'group_change_management_type'

    def is_group_change_member_role(self):
        """
        Check if the union tag is ``group_change_member_role``.

        :rtype: bool
        """
        return self._tag == 'group_change_member_role'

    def is_group_create(self):
        """
        Check if the union tag is ``group_create``.

        :rtype: bool
        """
        return self._tag == 'group_create'

    def is_group_delete(self):
        """
        Check if the union tag is ``group_delete``.

        :rtype: bool
        """
        return self._tag == 'group_delete'

    def is_group_description_updated(self):
        """
        Check if the union tag is ``group_description_updated``.

        :rtype: bool
        """
        return self._tag == 'group_description_updated'

    def is_group_join_policy_updated(self):
        """
        Check if the union tag is ``group_join_policy_updated``.

        :rtype: bool
        """
        return self._tag == 'group_join_policy_updated'

    def is_group_moved(self):
        """
        Check if the union tag is ``group_moved``.

        :rtype: bool
        """
        return self._tag == 'group_moved'

    def is_group_remove_external_id(self):
        """
        Check if the union tag is ``group_remove_external_id``.

        :rtype: bool
        """
        return self._tag == 'group_remove_external_id'

    def is_group_remove_member(self):
        """
        Check if the union tag is ``group_remove_member``.

        :rtype: bool
        """
        return self._tag == 'group_remove_member'

    def is_group_rename(self):
        """
        Check if the union tag is ``group_rename``.

        :rtype: bool
        """
        return self._tag == 'group_rename'

    def is_account_lock_or_unlocked(self):
        """
        Check if the union tag is ``account_lock_or_unlocked``.

        :rtype: bool
        """
        return self._tag == 'account_lock_or_unlocked'

    def is_emm_error(self):
        """
        Check if the union tag is ``emm_error``.

        :rtype: bool
        """
        return self._tag == 'emm_error'

    def is_guest_admin_signed_in_via_trusted_teams(self):
        """
        Check if the union tag is ``guest_admin_signed_in_via_trusted_teams``.

        :rtype: bool
        """
        return self._tag == 'guest_admin_signed_in_via_trusted_teams'

    def is_guest_admin_signed_out_via_trusted_teams(self):
        """
        Check if the union tag is ``guest_admin_signed_out_via_trusted_teams``.

        :rtype: bool
        """
        return self._tag == 'guest_admin_signed_out_via_trusted_teams'

    def is_login_fail(self):
        """
        Check if the union tag is ``login_fail``.

        :rtype: bool
        """
        return self._tag == 'login_fail'

    def is_login_success(self):
        """
        Check if the union tag is ``login_success``.

        :rtype: bool
        """
        return self._tag == 'login_success'

    def is_logout(self):
        """
        Check if the union tag is ``logout``.

        :rtype: bool
        """
        return self._tag == 'logout'

    def is_reseller_support_session_end(self):
        """
        Check if the union tag is ``reseller_support_session_end``.

        :rtype: bool
        """
        return self._tag == 'reseller_support_session_end'

    def is_reseller_support_session_start(self):
        """
        Check if the union tag is ``reseller_support_session_start``.

        :rtype: bool
        """
        return self._tag == 'reseller_support_session_start'

    def is_sign_in_as_session_end(self):
        """
        Check if the union tag is ``sign_in_as_session_end``.

        :rtype: bool
        """
        return self._tag == 'sign_in_as_session_end'

    def is_sign_in_as_session_start(self):
        """
        Check if the union tag is ``sign_in_as_session_start``.

        :rtype: bool
        """
        return self._tag == 'sign_in_as_session_start'

    def is_sso_error(self):
        """
        Check if the union tag is ``sso_error``.

        :rtype: bool
        """
        return self._tag == 'sso_error'

    def is_create_team_invite_link(self):
        """
        Check if the union tag is ``create_team_invite_link``.

        :rtype: bool
        """
        return self._tag == 'create_team_invite_link'

    def is_delete_team_invite_link(self):
        """
        Check if the union tag is ``delete_team_invite_link``.

        :rtype: bool
        """
        return self._tag == 'delete_team_invite_link'

    def is_member_add_external_id(self):
        """
        Check if the union tag is ``member_add_external_id``.

        :rtype: bool
        """
        return self._tag == 'member_add_external_id'

    def is_member_add_name(self):
        """
        Check if the union tag is ``member_add_name``.

        :rtype: bool
        """
        return self._tag == 'member_add_name'

    def is_member_change_admin_role(self):
        """
        Check if the union tag is ``member_change_admin_role``.

        :rtype: bool
        """
        return self._tag == 'member_change_admin_role'

    def is_member_change_email(self):
        """
        Check if the union tag is ``member_change_email``.

        :rtype: bool
        """
        return self._tag == 'member_change_email'

    def is_member_change_external_id(self):
        """
        Check if the union tag is ``member_change_external_id``.

        :rtype: bool
        """
        return self._tag == 'member_change_external_id'

    def is_member_change_membership_type(self):
        """
        Check if the union tag is ``member_change_membership_type``.

        :rtype: bool
        """
        return self._tag == 'member_change_membership_type'

    def is_member_change_name(self):
        """
        Check if the union tag is ``member_change_name``.

        :rtype: bool
        """
        return self._tag == 'member_change_name'

    def is_member_change_reseller_role(self):
        """
        Check if the union tag is ``member_change_reseller_role``.

        :rtype: bool
        """
        return self._tag == 'member_change_reseller_role'

    def is_member_change_status(self):
        """
        Check if the union tag is ``member_change_status``.

        :rtype: bool
        """
        return self._tag == 'member_change_status'

    def is_member_delete_manual_contacts(self):
        """
        Check if the union tag is ``member_delete_manual_contacts``.

        :rtype: bool
        """
        return self._tag == 'member_delete_manual_contacts'

    def is_member_delete_profile_photo(self):
        """
        Check if the union tag is ``member_delete_profile_photo``.

        :rtype: bool
        """
        return self._tag == 'member_delete_profile_photo'

    def is_member_permanently_delete_account_contents(self):
        """
        Check if the union tag is ``member_permanently_delete_account_contents``.

        :rtype: bool
        """
        return self._tag == 'member_permanently_delete_account_contents'

    def is_member_remove_external_id(self):
        """
        Check if the union tag is ``member_remove_external_id``.

        :rtype: bool
        """
        return self._tag == 'member_remove_external_id'

    def is_member_set_profile_photo(self):
        """
        Check if the union tag is ``member_set_profile_photo``.

        :rtype: bool
        """
        return self._tag == 'member_set_profile_photo'

    def is_member_space_limits_add_custom_quota(self):
        """
        Check if the union tag is ``member_space_limits_add_custom_quota``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_add_custom_quota'

    def is_member_space_limits_change_custom_quota(self):
        """
        Check if the union tag is ``member_space_limits_change_custom_quota``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_change_custom_quota'

    def is_member_space_limits_change_status(self):
        """
        Check if the union tag is ``member_space_limits_change_status``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_change_status'

    def is_member_space_limits_remove_custom_quota(self):
        """
        Check if the union tag is ``member_space_limits_remove_custom_quota``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_remove_custom_quota'

    def is_member_suggest(self):
        """
        Check if the union tag is ``member_suggest``.

        :rtype: bool
        """
        return self._tag == 'member_suggest'

    def is_member_transfer_account_contents(self):
        """
        Check if the union tag is ``member_transfer_account_contents``.

        :rtype: bool
        """
        return self._tag == 'member_transfer_account_contents'

    def is_pending_secondary_email_added(self):
        """
        Check if the union tag is ``pending_secondary_email_added``.

        :rtype: bool
        """
        return self._tag == 'pending_secondary_email_added'

    def is_secondary_email_deleted(self):
        """
        Check if the union tag is ``secondary_email_deleted``.

        :rtype: bool
        """
        return self._tag == 'secondary_email_deleted'

    def is_secondary_email_verified(self):
        """
        Check if the union tag is ``secondary_email_verified``.

        :rtype: bool
        """
        return self._tag == 'secondary_email_verified'

    def is_secondary_mails_policy_changed(self):
        """
        Check if the union tag is ``secondary_mails_policy_changed``.

        :rtype: bool
        """
        return self._tag == 'secondary_mails_policy_changed'

    def is_binder_add_page(self):
        """
        Check if the union tag is ``binder_add_page``.

        :rtype: bool
        """
        return self._tag == 'binder_add_page'

    def is_binder_add_section(self):
        """
        Check if the union tag is ``binder_add_section``.

        :rtype: bool
        """
        return self._tag == 'binder_add_section'

    def is_binder_remove_page(self):
        """
        Check if the union tag is ``binder_remove_page``.

        :rtype: bool
        """
        return self._tag == 'binder_remove_page'

    def is_binder_remove_section(self):
        """
        Check if the union tag is ``binder_remove_section``.

        :rtype: bool
        """
        return self._tag == 'binder_remove_section'

    def is_binder_rename_page(self):
        """
        Check if the union tag is ``binder_rename_page``.

        :rtype: bool
        """
        return self._tag == 'binder_rename_page'

    def is_binder_rename_section(self):
        """
        Check if the union tag is ``binder_rename_section``.

        :rtype: bool
        """
        return self._tag == 'binder_rename_section'

    def is_binder_reorder_page(self):
        """
        Check if the union tag is ``binder_reorder_page``.

        :rtype: bool
        """
        return self._tag == 'binder_reorder_page'

    def is_binder_reorder_section(self):
        """
        Check if the union tag is ``binder_reorder_section``.

        :rtype: bool
        """
        return self._tag == 'binder_reorder_section'

    def is_paper_content_add_member(self):
        """
        Check if the union tag is ``paper_content_add_member``.

        :rtype: bool
        """
        return self._tag == 'paper_content_add_member'

    def is_paper_content_add_to_folder(self):
        """
        Check if the union tag is ``paper_content_add_to_folder``.

        :rtype: bool
        """
        return self._tag == 'paper_content_add_to_folder'

    def is_paper_content_archive(self):
        """
        Check if the union tag is ``paper_content_archive``.

        :rtype: bool
        """
        return self._tag == 'paper_content_archive'

    def is_paper_content_create(self):
        """
        Check if the union tag is ``paper_content_create``.

        :rtype: bool
        """
        return self._tag == 'paper_content_create'

    def is_paper_content_permanently_delete(self):
        """
        Check if the union tag is ``paper_content_permanently_delete``.

        :rtype: bool
        """
        return self._tag == 'paper_content_permanently_delete'

    def is_paper_content_remove_from_folder(self):
        """
        Check if the union tag is ``paper_content_remove_from_folder``.

        :rtype: bool
        """
        return self._tag == 'paper_content_remove_from_folder'

    def is_paper_content_remove_member(self):
        """
        Check if the union tag is ``paper_content_remove_member``.

        :rtype: bool
        """
        return self._tag == 'paper_content_remove_member'

    def is_paper_content_rename(self):
        """
        Check if the union tag is ``paper_content_rename``.

        :rtype: bool
        """
        return self._tag == 'paper_content_rename'

    def is_paper_content_restore(self):
        """
        Check if the union tag is ``paper_content_restore``.

        :rtype: bool
        """
        return self._tag == 'paper_content_restore'

    def is_paper_doc_add_comment(self):
        """
        Check if the union tag is ``paper_doc_add_comment``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_add_comment'

    def is_paper_doc_change_member_role(self):
        """
        Check if the union tag is ``paper_doc_change_member_role``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_change_member_role'

    def is_paper_doc_change_sharing_policy(self):
        """
        Check if the union tag is ``paper_doc_change_sharing_policy``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_change_sharing_policy'

    def is_paper_doc_change_subscription(self):
        """
        Check if the union tag is ``paper_doc_change_subscription``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_change_subscription'

    def is_paper_doc_deleted(self):
        """
        Check if the union tag is ``paper_doc_deleted``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_deleted'

    def is_paper_doc_delete_comment(self):
        """
        Check if the union tag is ``paper_doc_delete_comment``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_delete_comment'

    def is_paper_doc_download(self):
        """
        Check if the union tag is ``paper_doc_download``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_download'

    def is_paper_doc_edit(self):
        """
        Check if the union tag is ``paper_doc_edit``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_edit'

    def is_paper_doc_edit_comment(self):
        """
        Check if the union tag is ``paper_doc_edit_comment``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_edit_comment'

    def is_paper_doc_followed(self):
        """
        Check if the union tag is ``paper_doc_followed``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_followed'

    def is_paper_doc_mention(self):
        """
        Check if the union tag is ``paper_doc_mention``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_mentio