// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32wl5x_cm0p.svd, see https://github.com/tinygo-org/stm32-svd

//go:build stm32 && stm32wl5x_cm0p
// +build stm32,stm32wl5x_cm0p

// STM32WL5x_CM0P
//

package stm32

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "STM32WL5X_CM0P"
	CPU          = "CM0"
	FPUPresent   = false
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// TrustZone Interrupt Control
	IRQ_TZIC_ILA = 0

	// External interrupt/event controller
	IRQ_PVD_PVM_3 = 1

	// Real-time clock
	IRQ_TAMP_RTCSTAMP_LSECSS_RTCALARM_RTCSSRU_RTCWKUP = 2

	// Flash
	IRQ_FLASH_RCC_C1SEV = 3

	// External interrupt/event controller
	IRQ_EXTI1_0 = 4

	// External interrupt/event controller
	IRQ_EXTI3_2 = 5

	// External interrupt/event controller
	IRQ_EXTI15_4 = 6

	// Analog to digital convertor
	IRQ_ADC_COMP_DAC = 7

	// Direct memory access controller
	IRQ_DMA1_CH3_1 = 8

	// Direct memory access controller
	IRQ_DMA1_CH7_4 = 9

	IRQ_DMA2_CH7_1_DMAMUX1_OVR = 10

	// Low-power timer
	IRQ_LPTIM1 = 11

	// Low-power timer
	IRQ_LPTIM2 = 12

	// Low-power timer
	IRQ_LPTIM3 = 13

	// Advanced-control timers
	IRQ_TIM1_BRK_TIM1_UP_TIM1_TRG_COM_TIM1_CC = 14

	// General-purpose-timers
	IRQ_TIM2 = 15

	// General-purpose timers
	IRQ_TIM16 = 16

	// General-purpose timers
	IRQ_TIM17 = 17

	// Inter Processor communication controller
	IRQ_IPCC_C2_RX_IT_IPCC_C2_TX_IT = 18

	// Hardware semaphore
	IRQ_HSEM = 19

	// True random number generator
	IRQ_True_RNG = 20

	// Advanced encryption standard hardware accelerator 1
	IRQ_AES_PKA = 21

	// Inter-integrated circuit
	IRQ_I2C1_EV_I2C1_ER = 22

	IRQ_I2C2_EV_I2C2_ER = 23

	IRQ_I2C3_EV_I2C3_ER = 24

	// Serial peripheral interface/Inter-IC sound
	IRQ_SPI1 = 25

	IRQ_SPI2S2 = 26

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART1 = 27

	IRQ_USART2 = 28

	// Universal synchronous asynchronous receiver transmitter
	IRQ_LPUART1 = 29

	IRQ_SUBGHZSPI = 30

	// External interrupt/event controller
	IRQ_Radio_IRQ_Busy = 31

	// Highest interrupt number on this device.
	IRQ_max = 31
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export TZIC_ILA_IRQHandler
func interruptTZIC_ILA() {
	callHandlers(IRQ_TZIC_ILA)
}

//export PVD_PVM_3_IRQHandler
func interruptPVD_PVM_3() {
	callHandlers(IRQ_PVD_PVM_3)
}

//export TAMP_RTCSTAMP_LSECSS_RTCALARM_RTCSSRU_RTCWKUP_IRQHandler
func interruptTAMP_RTCSTAMP_LSECSS_RTCALARM_RTCSSRU_RTCWKUP() {
	callHandlers(IRQ_TAMP_RTCSTAMP_LSECSS_RTCALARM_RTCSSRU_RTCWKUP)
}

//export FLASH_RCC_C1SEV_IRQHandler
func interruptFLASH_RCC_C1SEV() {
	callHandlers(IRQ_FLASH_RCC_C1SEV)
}

//export EXTI1_0_IRQHandler
func interruptEXTI1_0() {
	callHandlers(IRQ_EXTI1_0)
}

//export EXTI3_2_IRQHandler
func interruptEXTI3_2() {
	callHandlers(IRQ_EXTI3_2)
}

//export EXTI15_4_IRQHandler
func interruptEXTI15_4() {
	callHandlers(IRQ_EXTI15_4)
}

//export ADC_COMP_DAC_IRQHandler
func interruptADC_COMP_DAC() {
	callHandlers(IRQ_ADC_COMP_DAC)
}

//export DMA1_CH3_1_IRQHandler
func interruptDMA1_CH3_1() {
	callHandlers(IRQ_DMA1_CH3_1)
}

//export DMA1_CH7_4_IRQHandler
func interruptDMA1_CH7_4() {
	callHandlers(IRQ_DMA1_CH7_4)
}

//export DMA2_CH7_1_DMAMUX1_OVR_IRQHandler
func interruptDMA2_CH7_1_DMAMUX1_OVR() {
	callHandlers(IRQ_DMA2_CH7_1_DMAMUX1_OVR)
}

//export LPTIM1_IRQHandler
func interruptLPTIM1() {
	callHandlers(IRQ_LPTIM1)
}

//export LPTIM2_IRQHandler
func interruptLPTIM2() {
	callHandlers(IRQ_LPTIM2)
}

//export LPTIM3_IRQHandler
func interruptLPTIM3() {
	callHandlers(IRQ_LPTIM3)
}

//export TIM1_BRK_TIM1_UP_TIM1_TRG_COM_TIM1_CC_IRQHandler
func interruptTIM1_BRK_TIM1_UP_TIM1_TRG_COM_TIM1_CC() {
	callHandlers(IRQ_TIM1_BRK_TIM1_UP_TIM1_TRG_COM_TIM1_CC)
}

//export TIM2_IRQHandler
func interruptTIM2() {
	callHandlers(IRQ_TIM2)
}

//export TIM16_IRQHandler
func interruptTIM16() {
	callHandlers(IRQ_TIM16)
}

//export TIM17_IRQHandler
func interruptTIM17() {
	callHandlers(IRQ_TIM17)
}

//export IPCC_C2_RX_IT_IPCC_C2_TX_IT_IRQHandler
func interruptIPCC_C2_RX_IT_IPCC_C2_TX_IT() {
	callHandlers(IRQ_IPCC_C2_RX_IT_IPCC_C2_TX_IT)
}

//export HSEM_IRQHandler
func interruptHSEM() {
	callHandlers(IRQ_HSEM)
}

//export True_RNG_IRQHandler
func interruptTrue_RNG() {
	callHandlers(IRQ_True_RNG)
}

//export AES_PKA_IRQHandler
func interruptAES_PKA() {
	callHandlers(IRQ_AES_PKA)
}

//export I2C1_EV_I2C1_ER_IRQHandler
func interruptI2C1_EV_I2C1_ER() {
	callHandlers(IRQ_I2C1_EV_I2C1_ER)
}

//export I2C2_EV_I2C2_ER_IRQHandler
func interruptI2C2_EV_I2C2_ER() {
	callHandlers(IRQ_I2C2_EV_I2C2_ER)
}

//export I2C3_EV_I2C3_ER_IRQHandler
func interruptI2C3_EV_I2C3_ER() {
	callHandlers(IRQ_I2C3_EV_I2C3_ER)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export SPI2S2_IRQHandler
func interruptSPI2S2() {
	callHandlers(IRQ_SPI2S2)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export LPUART1_IRQHandler
func interruptLPUART1() {
	callHandlers(IRQ_LPUART1)
}

//export SUBGHZSPI_IRQHandler
func interruptSUBGHZSPI() {
	callHandlers(IRQ_SUBGHZSPI)
}

//export Radio_IRQ_Busy_IRQHandler
func interruptRadio_IRQ_Busy() {
	callHandlers(IRQ_Radio_IRQ_Busy)
}

// Peripherals.
var (
	// Analog to digital convertor
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012400)))

	// Advanced encryption standard hardware accelerator 1
	AES = (*AES_Type)(unsafe.Pointer(uintptr(0x58001800)))

	// Comparator
	COMP = (*COMP_Type)(unsafe.Pointer(uintptr(0x40010200)))

	// Cyclic redundancy check calculation unit
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// Digital-to-analog converter
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))

	// Direct memory access controller
	DMA1 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// DMA request multiplexer
	DMAMUX = (*DMAMUX_Type)(unsafe.Pointer(uintptr(0x40020800)))

	// External interrupt/event controller
	EXTI = (*EXTI_Type)(unsafe.Pointer(uintptr(0x58000800)))

	// Flash
	FLASH = (*Flash_Type)(unsafe.Pointer(uintptr(0x58004000)))

	// General-purpose I/Os
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000000)))

	// General-purpose I/Os
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000400)))

	// General-purpose I/Os
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000800)))

	// General-purpose I/Os
	GPIOH = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001c00)))

	// Hardware semaphore
	HSEM = (*HSEM_Type)(unsafe.Pointer(uintptr(0x58001400)))

	// Inter-integrated circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// Inter Processor communication controller
	IPCC = (*IPCC_Type)(unsafe.Pointer(uintptr(0x58000c00)))

	// Independent watchdog
	IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// Low-power timer
	LPTIM1 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40007c00)))

	// Low-power timer
	LPTIM2 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40009400)))

	// Low-power timer
	LPTIM3 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40009800)))

	// Universal synchronous asynchronous receiver transmitter
	LPUART = (*USART_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Memory protection unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Nested vectored interrupt controller
	NVIC_STIR = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))

	// Public key accelerator
	PKA = (*PKA_Type)(unsafe.Pointer(uintptr(0x58002000)))

	// Power control
	PWR = (*PWR_Type)(unsafe.Pointer(uintptr(0x58000400)))

	// Reset and clock control
	RCC = (*RCC_Type)(unsafe.Pointer(uintptr(0x58000000)))

	// True random number generator
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x58001000)))

	// Real-time clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))

	// System control block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// System control block ACTLR
	SCB_ACTRL = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))

	// Serial peripheral interface/Inter-IC sound
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// SysTick timer
	STK = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// System configuration controller
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// System configuration controller
	SYSCFG_continue = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40010100)))

	// Tamper and backup registers
	TAMP = (*TAMP_Type)(unsafe.Pointer(uintptr(0x4000b000)))

	// Advanced-control timers
	TIM1 = (*AdavanceTIM_Type)(unsafe.Pointer(uintptr(0x40012c00)))

	// General-purpose-timers
	TIM2 = (*GPTIM_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// General-purpose timers
	TIM16 = (*GPTIM_Type)(unsafe.Pointer(uintptr(0x40014400)))

	// General-purpose timers
	TIM17 = (*GPTIM_Type)(unsafe.Pointer(uintptr(0x40014800)))

	// TrustZone Interrupt Control
	TZIC = (*TZSC_Type)(unsafe.Pointer(uintptr(0x58004800)))

	// Global TrustZone Controller
	TZSC = (*TZSC_Type)(unsafe.Pointer(uintptr(0x58004400)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40013800)))

	// Voltage reference buffer
	VREFBUF = (*VREFBUF_Type)(unsafe.Pointer(uintptr(0x40010030)))

	// System window watchdog
	WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// Direct memory access controller
	DMA2 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020400)))

	// Inter-integrated circuit
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))

	// Inter-integrated circuit
	I2C3 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005c00)))

	// Serial peripheral interface/Inter-IC sound
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))

	// Serial peripheral interface/Inter-IC sound
	SPI3 = (*SPI_Type)(unsafe.Pointer(uintptr(0x58010000)))

	// Universal synchronous asynchronous receiver transmitter
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))
)

// Analog to digital convertor
type ADC_Type struct {
	ADC_ISR     volatile.Register32 // 0x0
	ADC_IER     volatile.Register32 // 0x4
	ADC_CR      volatile.Register32 // 0x8
	ADC_CFGR1   volatile.Register32 // 0xC
	ADC_CFGR2   volatile.Register32 // 0x10
	ADC_SMPR    volatile.Register32 // 0x14
	_           [8]byte
	ADC_AWD1TR  volatile.Register32 // 0x20
	ADC_AWD2TR  volatile.Register32 // 0x24
	ADC_CHSELR0 volatile.Register32 // 0x28
	ADC_AWD3TR  volatile.Register32 // 0x2C
	_           [16]byte
	ADC_DR      volatile.Register32 // 0x40
	_           [92]byte
	ADC_AWD2CR  volatile.Register32 // 0xA0
	ADC_AWD3CR  volatile.Register32 // 0xA4
	_           [12]byte
	ADC_CALFACT volatile.Register32 // 0xB4
	_           [592]byte
	ADC_CCR     volatile.Register32 // 0x308
}

// Advanced encryption standard hardware accelerator 1
type AES_Type struct {
	CR     volatile.Register32 // 0x0
	SR     volatile.Register32 // 0x4
	DINR   volatile.Register32 // 0x8
	DOUTR  volatile.Register32 // 0xC
	KEYR0  volatile.Register32 // 0x10
	KEYR1  volatile.Register32 // 0x14
	KEYR2  volatile.Register32 // 0x18
	KEYR3  volatile.Register32 // 0x1C
	IVR0   volatile.Register32 // 0x20
	IVR1   volatile.Register32 // 0x24
	IVR2   volatile.Register32 // 0x28
	IVR3   volatile.Register32 // 0x2C
	KEYR4  volatile.Register32 // 0x30
	KEYR5  volatile.Register32 // 0x34
	KEYR6  volatile.Register32 // 0x38
	KEYR7  volatile.Register32 // 0x3C
	SUSP0R volatile.Register32 // 0x40
	SUSP1R volatile.Register32 // 0x44
	SUSP2R volatile.Register32 // 0x48
	SUSP3R volatile.Register32 // 0x4C
	SUSP4R volatile.Register32 // 0x50
	SUSP5R volatile.Register32 // 0x54
	SUSP6R volatile.Register32 // 0x58
	SUSP7R volatile.Register32 // 0x5C
}

// Comparator
type COMP_Type struct {
	COMP1_CSR volatile.Register32 // 0x0
	COMP2_CSR volatile.Register32 // 0x4
}

// Cyclic redundancy check calculation unit
type CRC_Type struct {
	DR   volatile.Register32 // 0x0
	IDR  volatile.Register32 // 0x4
	CR   volatile.Register32 // 0x8
	_    [4]byte
	INIT volatile.Register32 // 0x10
	POL  volatile.Register32 // 0x14
}

// Digital-to-analog converter
type DAC_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRGR  volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	_       [12]byte
	DHR12RD volatile.Register32 // 0x20
	DHR12LD volatile.Register32 // 0x24
	DHR8RD  volatile.Register32 // 0x28
	DOR1    volatile.Register32 // 0x2C
	_       [4]byte
	SR      volatile.Register32 // 0x34
	CCR     volatile.Register32 // 0x38
	MCR     volatile.Register32 // 0x3C
	SHSR1   volatile.Register32 // 0x40
	_       [4]byte
	SHHR    volatile.Register32 // 0x48
	SHRR    volatile.Register32 // 0x4C
}

// Direct memory access controller
type DMA_Type struct {
	ISR    volatile.Register32 // 0x0
	IFCR   volatile.Register32 // 0x4
	CCR1   volatile.Register32 // 0x8
	CNDTR1 volatile.Register32 // 0xC
	CPAR1  volatile.Register32 // 0x10
	CMAR1  volatile.Register32 // 0x14
	_      [4]byte
	CCR2   volatile.Register32 // 0x1C
	CNDTR2 volatile.Register32 // 0x20
	CPAR2  volatile.Register32 // 0x24
	CMAR2  volatile.Register32 // 0x28
	_      [4]byte
	CCR3   volatile.Register32 // 0x30
	CNDTR3 volatile.Register32 // 0x34
	CPAR3  volatile.Register32 // 0x38
	CMAR3  volatile.Register32 // 0x3C
	_      [4]byte
	CCR4   volatile.Register32 // 0x44
	CNDTR4 volatile.Register32 // 0x48
	CPAR4  volatile.Register32 // 0x4C
	CMAR4  volatile.Register32 // 0x50
	_      [4]byte
	CCR5   volatile.Register32 // 0x58
	CNDTR5 volatile.Register32 // 0x5C
	CPAR5  volatile.Register32 // 0x60
	CMAR5  volatile.Register32 // 0x64
	_      [4]byte
	CCR6   volatile.Register32 // 0x6C
	CNDTR6 volatile.Register32 // 0x70
	CPAR6  volatile.Register32 // 0x74
	CMAR6  volatile.Register32 // 0x78
	_      [4]byte
	CCR7   volatile.Register32 // 0x80
	CNDTR7 volatile.Register32 // 0x84
	CPAR7  volatile.Register32 // 0x88
	CMAR7  volatile.Register32 // 0x8C
}

// DMA request multiplexer
type DMAMUX_Type struct {
	C0CR  volatile.Register32 // 0x0
	C1CR  volatile.Register32 // 0x4
	C2CR  volatile.Register32 // 0x8
	C3CR  volatile.Register32 // 0xC
	C4CR  volatile.Register32 // 0x10
	C5CR  volatile.Register32 // 0x14
	C6CR  volatile.Register32 // 0x18
	C7CR  volatile.Register32 // 0x1C
	C8CR  volatile.Register32 // 0x20
	C9CR  volatile.Register32 // 0x24
	C10CR volatile.Register32 // 0x28
	C11CR volatile.Register32 // 0x2C
	C12CR volatile.Register32 // 0x30
	C13CR volatile.Register32 // 0x34
	_     [72]byte
	CSR   volatile.Register32 // 0x80
	CCFR  volatile.Register32 // 0x84
	_     [120]byte
	RG0CR volatile.Register32 // 0x100
	RG1CR volatile.Register32 // 0x104
	RG2CR volatile.Register32 // 0x108
	RG3CR volatile.Register32 // 0x10C
	_     [48]byte
	RGSR  volatile.Register32 // 0x140
	RGCFR volatile.Register32 // 0x144
}

// External interrupt/event controller
type EXTI_Type struct {
	RTSR1  volatile.Register32 // 0x0
	FTSR1  volatile.Register32 // 0x4
	SWIER1 volatile.Register32 // 0x8
	PR1    volatile.Register32 // 0xC
	_      [16]byte
	RTSR2  volatile.Register32 // 0x20
	FTSR2  volatile.Register32 // 0x24
	SWIER2 volatile.Register32 // 0x28
	PR2    volatile.Register32 // 0x2C
	_      [80]byte
	C1IMR1 volatile.Register32 // 0x80
	C1EMR1 volatile.Register32 // 0x84
	_      [8]byte
	C1IMR2 volatile.Register32 // 0x90
	C1EMR2 volatile.Register32 // 0x94
	_      [40]byte
	C2IMR1 volatile.Register32 // 0xC0
	C2EMR1 volatile.Register32 // 0xC4
	_      [8]byte
	C2IMR2 volatile.Register32 // 0xD0
	C2EMR2 volatile.Register32 // 0xD4
}

// Flash
type Flash_Type struct {
	ACR       volatile.Register32 // 0x0
	ACR2      volatile.Register32 // 0x4
	KEYR      volatile.Register32 // 0x8
	OPTKEYR   volatile.Register32 // 0xC
	SR        volatile.Register32 // 0x10
	CR        volatile.Register32 // 0x14
	ECCR      volatile.Register32 // 0x18
	_         [4]byte
	OPTR      volatile.Register32 // 0x20
	PCROP1ASR volatile.Register32 // 0x24
	PCROP1AER volatile.Register32 // 0x28
	WRP1AR    volatile.Register32 // 0x2C
	WRP1BR    volatile.Register32 // 0x30
	PCROP1BSR volatile.Register32 // 0x34
	PCROP1BER volatile.Register32 // 0x38
	IPCCBR    volatile.Register32 // 0x3C
	_         [28]byte
	C2ACR     volatile.Register32 // 0x5C
	C2SR      volatile.Register32 // 0x60
	C2CR      volatile.Register32 // 0x64
	_         [24]byte
	SFR       volatile.Register32 // 0x80
	SRRVR     volatile.Register32 // 0x84
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
	BRR     volatile.Register32 // 0x28
}

// Hardware semaphore
type HSEM_Type struct {
	HSEM_R0     volatile.Register32 // 0x0
	HSEM_R1     volatile.Register32 // 0x4
	HSEM_R2     volatile.Register32 // 0x8
	HSEM_R3     volatile.Register32 // 0xC
	HSEM_R4     volatile.Register32 // 0x10
	HSEM_R5     volatile.Register32 // 0x14
	HSEM_R6     volatile.Register32 // 0x18
	HSEM_R7     volatile.Register32 // 0x1C
	HSEM_R8     volatile.Register32 // 0x20
	HSEM_R9     volatile.Register32 // 0x24
	HSEM_R10    volatile.Register32 // 0x28
	HSEM_R11    volatile.Register32 // 0x2C
	HSEM_R12    volatile.Register32 // 0x30
	HSEM_R13    volatile.Register32 // 0x34
	HSEM_R14    volatile.Register32 // 0x38
	HSEM_R15    volatile.Register32 // 0x3C
	_           [64]byte
	HSEM_RLR0   volatile.Register32 // 0x80
	HSEM_RLR1   volatile.Register32 // 0x84
	HSEM_RLR2   volatile.Register32 // 0x88
	HSEM_RLR3   volatile.Register32 // 0x8C
	HSEM_RLR4   volatile.Register32 // 0x90
	HSEM_RLR5   volatile.Register32 // 0x94
	HSEM_RLR6   volatile.Register32 // 0x98
	HSEM_RLR7   volatile.Register32 // 0x9C
	HSEM_RLR8   volatile.Register32 // 0xA0
	HSEM_RLR9   volatile.Register32 // 0xA4
	HSEM_RLR10  volatile.Register32 // 0xA8
	HSEM_RLR11  volatile.Register32 // 0xAC
	HSEM_RLR12  volatile.Register32 // 0xB0
	HSEM_RLR13  volatile.Register32 // 0xB4
	HSEM_RLR14  volatile.Register32 // 0xB8
	HSEM_RLR15  volatile.Register32 // 0xBC
	_           [64]byte
	HSEM_C1IER  volatile.Register32 // 0x100
	HSEM_C1ICR  volatile.Register32 // 0x104
	HSEM_C1ISR  volatile.Register32 // 0x108
	HSEM_C1MISR volatile.Register32 // 0x10C
	HSEM_C2IER  volatile.Register32 // 0x110
	HSEM_C2ICR  volatile.Register32 // 0x114
	HSEM_C2ISR  volatile.Register32 // 0x118
	HSEM_C2MISR volatile.Register32 // 0x11C
	_           [32]byte
	HSEM_CR     volatile.Register32 // 0x140
	HSEM_KEYR   volatile.Register32 // 0x144
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	OAR1     volatile.Register32 // 0x8
	OAR2     volatile.Register32 // 0xC
	TIMINGR  volatile.Register32 // 0x10
	TIMEOUTR volatile.Register32 // 0x14
	ISR      volatile.Register32 // 0x18
	ICR      volatile.Register32 // 0x1C
	PECR     volatile.Register32 // 0x20
	RXDR     volatile.Register32 // 0x24
	TXDR     volatile.Register32 // 0x28
}

// Inter Processor communication controller
type IPCC_Type struct {
	IPCC_C1CR     volatile.Register32 // 0x0
	IPCC_C1MR     volatile.Register32 // 0x4
	IPCC_C1SCR    volatile.Register32 // 0x8
	IPCC_C1TOC2SR volatile.Register32 // 0xC
	IPCC_C2CR     volatile.Register32 // 0x10
	IPCC_C2MR     volatile.Register32 // 0x14
	IPCC_C2SCR    volatile.Register32 // 0x18
	IPCC_C2TOC1SR volatile.Register32 // 0x1C
	_             [976]byte
	IPCC_HWCFGR   volatile.Register32 // 0x3F0
	IPCC_VERR     volatile.Register32 // 0x3F4
	IPCC_IPIDR    volatile.Register32 // 0x3F8
	IPCC_SIDR     volatile.Register32 // 0x3FC
}

// Independent watchdog
type IWDG_Type struct {
	KR   volatile.Register32 // 0x0
	PR   volatile.Register32 // 0x4
	RLR  volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	WINR volatile.Register32 // 0x10
}

// Low-power timer
type LPTIM_Type struct {
	ISR       volatile.Register32 // 0x0
	ICR       volatile.Register32 // 0x4
	IER       volatile.Register32 // 0x8
	CFGR      volatile.Register32 // 0xC
	CR        volatile.Register32 // 0x10
	CMP       volatile.Register32 // 0x14
	ARR       volatile.Register32 // 0x18
	CNT       volatile.Register32 // 0x1C
	LPTIM1_OR volatile.Register32 // 0x20
	_         [4]byte
	RCR       volatile.Register32 // 0x28
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	CR1_enabled volatile.Register32 // 0x0
	CR2         volatile.Register32 // 0x4
	CR3         volatile.Register32 // 0x8
	BRR         volatile.Register32 // 0xC
	_           [8]byte
	RQR         volatile.Register32 // 0x18
	ISR_enabled volatile.Register32 // 0x1C
	ICR         volatile.Register32 // 0x20
	RDR         volatile.Register32 // 0x24
	TDR         volatile.Register32 // 0x28
	PRESC       volatile.Register32 // 0x2C
}

// Memory protection unit
type MPU_Type struct {
	MPU_TYPER volatile.Register32 // 0x0
	MPU_CTRL  volatile.Register32 // 0x4
	MPU_RNR   volatile.Register32 // 0x8
	MPU_RBAR  volatile.Register32 // 0xC
	MPU_RASR  volatile.Register32 // 0x10
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER0 volatile.Register32 // 0x0
	_     [124]byte
	ICER0 volatile.Register32 // 0x80
	_     [124]byte
	ISPR0 volatile.Register32 // 0x100
	_     [124]byte
	ICPR0 volatile.Register32 // 0x180
	_     [124]byte
	IABR0 volatile.Register32 // 0x200
	IABR1 volatile.Register32 // 0x204
	_     [248]byte
	IPR0  volatile.Register32 // 0x300
	IPR1  volatile.Register32 // 0x304
	IPR2  volatile.Register32 // 0x308
	IPR3  volatile.Register32 // 0x30C
	IPR4  volatile.Register32 // 0x310
	IPR5  volatile.Register32 // 0x314
	IPR6  volatile.Register32 // 0x318
	IPR7  volatile.Register32 // 0x31C
	IPR8  volatile.Register32 // 0x320
}

// Public key accelerator
type PKA_Type struct {
	CR    volatile.Register32 // 0x0
	SR    volatile.Register32 // 0x4
	CLRFR volatile.Register32 // 0x8
}

// Power control
type PWR_Type struct {
	CR1         volatile.Register32 // 0x0
	CR2         volatile.Register32 // 0x4
	CR3         volatile.Register32 // 0x8
	CR4         volatile.Register32 // 0xC
	SR1         volatile.Register32 // 0x10
	SR2         volatile.Register32 // 0x14
	SCR         volatile.Register32 // 0x18
	CR5         volatile.Register32 // 0x1C
	PUCRA       volatile.Register32 // 0x20
	PDCRA       volatile.Register32 // 0x24
	PUCRB       volatile.Register32 // 0x28
	PDCRB       volatile.Register32 // 0x2C
	PUCRC       volatile.Register32 // 0x30
	PDCRC       volatile.Register32 // 0x34
	_           [32]byte
	PUCRH       volatile.Register32 // 0x58
	PDCRH       volatile.Register32 // 0x5C
	_           [32]byte
	C2CR1       volatile.Register32 // 0x80
	C2CR3       volatile.Register32 // 0x84
	EXTSCR      volatile.Register32 // 0x88
	SECCFGR     volatile.Register32 // 0x8C
	SUBGHZSPICR volatile.Register32 // 0x90
	_           [4]byte
	RSSCMDR     volatile.Register32 // 0x98
}

// Reset and clock control
type RCC_Type struct {
	CR           volatile.Register32 // 0x0
	ICSCR        volatile.Register32 // 0x4
	CFGR         volatile.Register32 // 0x8
	PLLCFGR      volatile.Register32 // 0xC
	_            [8]byte
	CIER         volatile.Register32 // 0x18
	CIFR         volatile.Register32 // 0x1C
	CICR         volatile.Register32 // 0x20
	_            [4]byte
	AHB1RSTR     volatile.Register32 // 0x28
	AHB2RSTR     volatile.Register32 // 0x2C
	AHB3RSTR     volatile.Register32 // 0x30
	_            [4]byte
	APB1RSTR1    volatile.Register32 // 0x38
	APB1RSTR2    volatile.Register32 // 0x3C
	APB2RSTR     volatile.Register32 // 0x40
	APB3RSTR     volatile.Register32 // 0x44
	AHB1ENR      volatile.Register32 // 0x48
	AHB2ENR      volatile.Register32 // 0x4C
	AHB3ENR      volatile.Register32 // 0x50
	_            [4]byte
	APB1ENR1     volatile.Register32 // 0x58
	APB1ENR2     volatile.Register32 // 0x5C
	APB2ENR      volatile.Register32 // 0x60
	APB3ENR      volatile.Register32 // 0x64
	AHB1SMENR    volatile.Register32 // 0x68
	AHB2SMENR    volatile.Register32 // 0x6C
	AHB3SMENR    volatile.Register32 // 0x70
	_            [4]byte
	APB1SMENR1   volatile.Register32 // 0x78
	APB1SMENR2   volatile.Register32 // 0x7C
	APB2SMENR    volatile.Register32 // 0x80
	APB3SMENR    volatile.Register32 // 0x84
	CCIPR        volatile.Register32 // 0x88
	_            [4]byte
	BDCR         volatile.Register32 // 0x90
	CSR          volatile.Register32 // 0x94
	_            [112]byte
	EXTCFGR      volatile.Register32 // 0x108
	_            [60]byte
	C2AHB1ENR    volatile.Register32 // 0x148
	C2AHB2ENR    volatile.Register32 // 0x14C
	C2AHB3ENR    volatile.Register32 // 0x150
	_            [4]byte
	C2APB1ENR1   volatile.Register32 // 0x158
	C2APB1ENR2   volatile.Register32 // 0x15C
	C2APB2ENR    volatile.Register32 // 0x160
	C2APB3ENR    volatile.Register32 // 0x164
	C2AHB1SMENR  volatile.Register32 // 0x168
	C2AHB2SMENR  volatile.Register32 // 0x16C
	C2AHB3SMENR  volatile.Register32 // 0x170
	_            [4]byte
	C2APB1SMENR1 volatile.Register32 // 0x178
	C2APB1SMENR2 volatile.Register32 // 0x17C
	C2APB2SMENR  volatile.Register32 // 0x180
	C2APB3SMENR  volatile.Register32 // 0x184
}

// True random number generator
type RNG_Type struct {
	CR   volatile.Register32 // 0x0
	SR   volatile.Register32 // 0x4
	DR   volatile.Register32 // 0x8
	_    [4]byte
	HTCR volatile.Register32 // 0x10
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	SSR      volatile.Register32 // 0x8
	ICSR     volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	CR       volatile.Register32 // 0x18
	_        [8]byte
	WPR      volatile.Register32 // 0x24
	CALR     volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	_        [4]byte
	ALRMAR   volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBR   volatile.Register32 // 0x48
	ALRMBSSR volatile.Register32 // 0x4C
	SR       volatile.Register32 // 0x50
	MISR     volatile.Register32 // 0x54
	_        [4]byte
	SCR      volatile.Register32 // 0x5C
	_        [16]byte
	ALRABINR volatile.Register32 // 0x70
	ALRBBINR volatile.Register32 // 0x74
}

// System control block
type SCB_Type struct {
	CPUID                volatile.Register32 // 0x0
	ICSR                 volatile.Register32 // 0x4
	VTOR                 volatile.Register32 // 0x8
	AIRCR                volatile.Register32 // 0xC
	SCR                  volatile.Register32 // 0x10
	CCR                  volatile.Register32 // 0x14
	SHPR1                volatile.Register32 // 0x18
	SHPR2                volatile.Register32 // 0x1C
	SHPR3                volatile.Register32 // 0x20
	SHCSR                volatile.Register32 // 0x24
	CFSR_UFSR_BFSR_MMFSR volatile.Register32 // 0x28
	HFSR                 volatile.Register32 // 0x2C
	_                    [4]byte
	MMFAR                volatile.Register32 // 0x34
	BFAR                 volatile.Register32 // 0x38
	AFSR                 volatile.Register32 // 0x3C
}

// Serial peripheral interface/Inter-IC sound
type SPI_Type struct {
	CR1     volatile.Register32 // 0x0
	CR2     volatile.Register32 // 0x4
	SR      volatile.Register32 // 0x8
	DR      volatile.Register32 // 0xC
	CRCPR   volatile.Register32 // 0x10
	RXCRCR  volatile.Register32 // 0x14
	TXCRCR  volatile.Register32 // 0x18
	I2SCFGR volatile.Register32 // 0x1C
	I2SPR   volatile.Register32 // 0x20
}

// SysTick timer
type STK_Type struct {
	CTRL  volatile.Register32 // 0x0
	LOAD  volatile.Register32 // 0x4
	VAL   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// System configuration controller
type SYSCFG_Type struct {
	MEMRMP  volatile.Register32 // 0x0
	CFGR1   volatile.Register32 // 0x4
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
	SCSR    volatile.Register32 // 0x18
	CFGR2   volatile.Register32 // 0x1C
	SWPR    volatile.Register32 // 0x20
	SKR     volatile.Register32 // 0x24
	_       [216]byte
	IMR1    volatile.Register32 // 0x100
	IMR2    volatile.Register32 // 0x104
	C2IMR1  volatile.Register32 // 0x108
	C2IMR2  volatile.Register32 // 0x10C
	_       [248]byte
	RFDCR   volatile.Register32 // 0x208
}

// Tamper and backup registers
type TAMP_Type struct {
	CR1    volatile.Register32 // 0x0
	CR2    volatile.Register32 // 0x4
	CR3    volatile.Register32 // 0x8
	FLTCR  volatile.Register32 // 0xC
	_      [28]byte
	IER    volatile.Register32 // 0x2C
	SR     volatile.Register32 // 0x30
	MISR   volatile.Register32 // 0x34
	_      [4]byte
	SCR    volatile.Register32 // 0x3C
	COUNTR volatile.Register32 // 0x40
	_      [188]byte
	BKP0R  volatile.Register32 // 0x100
	BKP1R  volatile.Register32 // 0x104
	BKP2R  volatile.Register32 // 0x108
	BKP3R  volatile.Register32 // 0x10C
	BKP4R  volatile.Register32 // 0x110
	BKP5R  volatile.Register32 // 0x114
	BKP6R  volatile.Register32 // 0x118
	BKP7R  volatile.Register32 // 0x11C
	BKP8R  volatile.Register32 // 0x120
	BKP9R  volatile.Register32 // 0x124
	_      [24]byte
	BKP10R volatile.Register32 // 0x140
	BKP11R volatile.Register32 // 0x144
	BKP12R volatile.Register32 // 0x148
	BKP13R volatile.Register32 // 0x14C
	BKP14R volatile.Register32 // 0x150
	BKP15R volatile.Register32 // 0x154
	BKP16R volatile.Register32 // 0x158
	BKP17R volatile.Register32 // 0x15C
	BKP18R volatile.Register32 // 0x160
	BKP19R volatile.Register32 // 0x164
}

// Advanced-control timers
type AdavanceTIM_Type struct {
	CR1                    volatile.Register32 // 0x0
	CR2                    volatile.Register32 // 0x4
	SMCR                   volatile.Register32 // 0x8
	DIER                   volatile.Register32 // 0xC
	SR                     volatile.Register32 // 0x10
	EGR                    volatile.Register32 // 0x14
	CCMR1_Output           volatile.Register32 // 0x18
	CCMR2_Output           volatile.Register32 // 0x1C
	CCER                   volatile.Register32 // 0x20
	CNT                    volatile.Register32 // 0x24
	PSC                    volatile.Register32 // 0x28
	ARR                    volatile.Register32 // 0x2C
	RCR                    volatile.Register32 // 0x30
	CCR1                   volatile.Register32 // 0x34
	CCR2                   volatile.Register32 // 0x38
	CCR3                   volatile.Register32 // 0x3C
	CCR4                   volatile.Register32 // 0x40
	BDTR                   volatile.Register32 // 0x44
	DCR                    volatile.Register32 // 0x48
	DMAR                   volatile.Register32 // 0x4C
	OR1                    volatile.Register32 // 0x50
	CCMR3OutputComparemode volatile.Register32 // 0x54
	CCR5                   volatile.Register32 // 0x58
	CCR6                   volatile.Register32 // 0x5C
	AF1                    volatile.Register32 // 0x60
	AF2                    volatile.Register32 // 0x64
	TISEL                  volatile.Register32 // 0x68
}

// General-purpose-timers
type GPTIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	_            [4]byte
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	_            [4]byte
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
	TIM2_OR1     volatile.Register32 // 0x50
	_            [12]byte
	TIM2_AF1     volatile.Register32 // 0x60
	_            [4]byte
	TIM2_TISEL   volatile.Register32 // 0x68
}

// TrustZone Interrupt Control
type TZSC_Type struct {
	IER1  volatile.Register32 // 0x0
	_     [12]byte
	MISR1 volatile.Register32 // 0x10
	_     [12]byte
	ICR1  volatile.Register32 // 0x20
}

// Voltage reference buffer
type VREFBUF_Type struct {
	CSR volatile.Register32 // 0x0
	CCR volatile.Register32 // 0x4
}

// System window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// Bitfields for ADC: Analog to digital convertor
const (
	// ADC_ISR: ADC interrupt and status register
	// Position of ADRDY field.
	ADC_ADC_ISR_ADRDY_Pos = 0x0
	// Bit mask of ADRDY field.
	ADC_ADC_ISR_ADRDY_Msk = 0x1
	// Bit ADRDY.
	ADC_ADC_ISR_ADRDY = 0x1
	// Position of EOSMP field.
	ADC_ADC_ISR_EOSMP_Pos = 0x1
	// Bit mask of EOSMP field.
	ADC_ADC_ISR_EOSMP_Msk = 0x2
	// Bit EOSMP.
	ADC_ADC_ISR_EOSMP = 0x2
	// Position of EOC field.
	ADC_ADC_ISR_EOC_Pos = 0x2
	// Bit mask of EOC field.
	ADC_ADC_ISR_EOC_Msk = 0x4
	// Bit EOC.
	ADC_ADC_ISR_EOC = 0x4
	// Position of EOS field.
	ADC_ADC_ISR_EOS_Pos = 0x3
	// Bit mask of EOS field.
	ADC_ADC_ISR_EOS_Msk = 0x8
	// Bit EOS.
	ADC_ADC_ISR_EOS = 0x8
	// Position of OVR field.
	ADC_ADC_ISR_OVR_Pos = 0x4
	// Bit mask of OVR field.
	ADC_ADC_ISR_OVR_Msk = 0x10
	// Bit OVR.
	ADC_ADC_ISR_OVR = 0x10
	// Position of AWD1 field.
	ADC_ADC_ISR_AWD1_Pos = 0x7
	// Bit mask of AWD1 field.
	ADC_ADC_ISR_AWD1_Msk = 0x80
	// Bit AWD1.
	ADC_ADC_ISR_AWD1 = 0x80
	// Position of AWD2 field.
	ADC_ADC_ISR_AWD2_Pos = 0x8
	// Bit mask of AWD2 field.
	ADC_ADC_ISR_AWD2_Msk = 0x100
	// Bit AWD2.
	ADC_ADC_ISR_AWD2 = 0x100
	// Position of AWD3 field.
	ADC_ADC_ISR_AWD3_Pos = 0x9
	// Bit mask of AWD3 field.
	ADC_ADC_ISR_AWD3_Msk = 0x200
	// Bit AWD3.
	ADC_ADC_ISR_AWD3 = 0x200
	// Position of EOCAL field.
	ADC_ADC_ISR_EOCAL_Pos = 0xb
	// Bit mask of EOCAL field.
	ADC_ADC_ISR_EOCAL_Msk = 0x800
	// Bit EOCAL.
	ADC_ADC_ISR_EOCAL = 0x800
	// Position of CCRDY field.
	ADC_ADC_ISR_CCRDY_Pos = 0xd
	// Bit mask of CCRDY field.
	ADC_ADC_ISR_CCRDY_Msk = 0x2000
	// Bit CCRDY.
	ADC_ADC_ISR_CCRDY = 0x2000

	// ADC_IER: ADC interrupt enable register
	// Position of ADRDYIE field.
	ADC_ADC_IER_ADRDYIE_Pos = 0x0
	// Bit mask of ADRDYIE field.
	ADC_ADC_IER_ADRDYIE_Msk = 0x1
	// Bit ADRDYIE.
	ADC_ADC_IER_ADRDYIE = 0x1
	// Position of EOSMPIE field.
	ADC_ADC_IER_EOSMPIE_Pos = 0x1
	// Bit mask of EOSMPIE field.
	ADC_ADC_IER_EOSMPIE_Msk = 0x2
	// Bit EOSMPIE.
	ADC_ADC_IER_EOSMPIE = 0x2
	// Position of EOCIE field.
	ADC_ADC_IER_EOCIE_Pos = 0x2
	// Bit mask of EOCIE field.
	ADC_ADC_IER_EOCIE_Msk = 0x4
	// Bit EOCIE.
	ADC_ADC_IER_EOCIE = 0x4
	// Position of EOSIE field.
	ADC_ADC_IER_EOSIE_Pos = 0x3
	// Bit mask of EOSIE field.
	ADC_ADC_IER_EOSIE_Msk = 0x8
	// Bit EOSIE.
	ADC_ADC_IER_EOSIE = 0x8
	// Position of OVRIE field.
	ADC_ADC_IER_OVRIE_Pos = 0x4
	// Bit mask of OVRIE field.
	ADC_ADC_IER_OVRIE_Msk = 0x10
	// Bit OVRIE.
	ADC_ADC_IER_OVRIE = 0x10
	// Position of AWD1IE field.
	ADC_ADC_IER_AWD1IE_Pos = 0x7
	// Bit mask of AWD1IE field.
	ADC_ADC_IER_AWD1IE_Msk = 0x80
	// Bit AWD1IE.
	ADC_ADC_IER_AWD1IE = 0x80
	// Position of AWD2IE field.
	ADC_ADC_IER_AWD2IE_Pos = 0x8
	// Bit mask of AWD2IE field.
	ADC_ADC_IER_AWD2IE_Msk = 0x100
	// Bit AWD2IE.
	ADC_ADC_IER_AWD2IE = 0x100
	// Position of AWD3IE field.
	ADC_ADC_IER_AWD3IE_Pos = 0x9
	// Bit mask of AWD3IE field.
	ADC_ADC_IER_AWD3IE_Msk = 0x200
	// Bit AWD3IE.
	ADC_ADC_IER_AWD3IE = 0x200
	// Position of EOCALIE field.
	ADC_ADC_IER_EOCALIE_Pos = 0xb
	// Bit mask of EOCALIE field.
	ADC_ADC_IER_EOCALIE_Msk = 0x800
	// Bit EOCALIE.
	ADC_ADC_IER_EOCALIE = 0x800
	// Position of CCRDYIE field.
	ADC_ADC_IER_CCRDYIE_Pos = 0xd
	// Bit mask of CCRDYIE field.
	ADC_ADC_IER_CCRDYIE_Msk = 0x2000
	// Bit CCRDYIE.
	ADC_ADC_IER_CCRDYIE = 0x2000

	// ADC_CR: ADC control register
	// Position of ADEN field.
	ADC_ADC_CR_ADEN_Pos = 0x0
	// Bit mask of ADEN field.
	ADC_ADC_CR_ADEN_Msk = 0x1
	// Bit ADEN.
	ADC_ADC_CR_ADEN = 0x1
	// Position of ADDIS field.
	ADC_ADC_CR_ADDIS_Pos = 0x1
	// Bit mask of ADDIS field.
	ADC_ADC_CR_ADDIS_Msk = 0x2
	// Bit ADDIS.
	ADC_ADC_CR_ADDIS = 0x2
	// Position of ADSTART field.
	ADC_ADC_CR_ADSTART_Pos = 0x2
	// Bit mask of ADSTART field.
	ADC_ADC_CR_ADSTART_Msk = 0x4
	// Bit ADSTART.
	ADC_ADC_CR_ADSTART = 0x4
	// Position of ADSTP field.
	ADC_ADC_CR_ADSTP_Pos = 0x4
	// Bit mask of ADSTP field.
	ADC_ADC_CR_ADSTP_Msk = 0x10
	// Bit ADSTP.
	ADC_ADC_CR_ADSTP = 0x10
	// Position of ADVREGEN field.
	ADC_ADC_CR_ADVREGEN_Pos = 0x1c
	// Bit mask of ADVREGEN field.
	ADC_ADC_CR_ADVREGEN_Msk = 0x10000000
	// Bit ADVREGEN.
	ADC_ADC_CR_ADVREGEN = 0x10000000
	// Position of ADCAL field.
	ADC_ADC_CR_ADCAL_Pos = 0x1f
	// Bit mask of ADCAL field.
	ADC_ADC_CR_ADCAL_Msk = 0x80000000
	// Bit ADCAL.
	ADC_ADC_CR_ADCAL = 0x80000000

	// ADC_CFGR1: ADC configuration register 1
	// Position of DMAEN field.
	ADC_ADC_CFGR1_DMAEN_Pos = 0x0
	// Bit mask of DMAEN field.
	ADC_ADC_CFGR1_DMAEN_Msk = 0x1
	// Bit DMAEN.
	ADC_ADC_CFGR1_DMAEN = 0x1
	// Position of DMACFG field.
	ADC_ADC_CFGR1_DMACFG_Pos = 0x1
	// Bit mask of DMACFG field.
	ADC_ADC_CFGR1_DMACFG_Msk = 0x2
	// Bit DMACFG.
	ADC_ADC_CFGR1_DMACFG = 0x2
	// Position of SCANDIR field.
	ADC_ADC_CFGR1_SCANDIR_Pos = 0x2
	// Bit mask of SCANDIR field.
	ADC_ADC_CFGR1_SCANDIR_Msk = 0x4
	// Bit SCANDIR.
	ADC_ADC_CFGR1_SCANDIR = 0x4
	// Position of RES field.
	ADC_ADC_CFGR1_RES_Pos = 0x3
	// Bit mask of RES field.
	ADC_ADC_CFGR1_RES_Msk = 0x18
	// Position of ALIGN field.
	ADC_ADC_CFGR1_ALIGN_Pos = 0x5
	// Bit mask of ALIGN field.
	ADC_ADC_CFGR1_ALIGN_Msk = 0x20
	// Bit ALIGN.
	ADC_ADC_CFGR1_ALIGN = 0x20
	// Position of EXTSEL field.
	ADC_ADC_CFGR1_EXTSEL_Pos = 0x6
	// Bit mask of EXTSEL field.
	ADC_ADC_CFGR1_EXTSEL_Msk = 0x1c0
	// Position of EXTEN field.
	ADC_ADC_CFGR1_EXTEN_Pos = 0xa
	// Bit mask of EXTEN field.
	ADC_ADC_CFGR1_EXTEN_Msk = 0xc00
	// Position of OVRMOD field.
	ADC_ADC_CFGR1_OVRMOD_Pos = 0xc
	// Bit mask of OVRMOD field.
	ADC_ADC_CFGR1_OVRMOD_Msk = 0x1000
	// Bit OVRMOD.
	ADC_ADC_CFGR1_OVRMOD = 0x1000
	// Position of CONT field.
	ADC_ADC_CFGR1_CONT_Pos = 0xd
	// Bit mask of CONT field.
	ADC_ADC_CFGR1_CONT_Msk = 0x2000
	// Bit CONT.
	ADC_ADC_CFGR1_CONT = 0x2000
	// Position of WAIT field.
	ADC_ADC_CFGR1_WAIT_Pos = 0xe
	// Bit mask of WAIT field.
	ADC_ADC_CFGR1_WAIT_Msk = 0x4000
	// Bit WAIT.
	ADC_ADC_CFGR1_WAIT = 0x4000
	// Position of AUTOFF field.
	ADC_ADC_CFGR1_AUTOFF_Pos = 0xf
	// Bit mask of AUTOFF field.
	ADC_ADC_CFGR1_AUTOFF_Msk = 0x8000
	// Bit AUTOFF.
	ADC_ADC_CFGR1_AUTOFF = 0x8000
	// Position of DISCEN field.
	ADC_ADC_CFGR1_DISCEN_Pos = 0x10
	// Bit mask of DISCEN field.
	ADC_ADC_CFGR1_DISCEN_Msk = 0x10000
	// Bit DISCEN.
	ADC_ADC_CFGR1_DISCEN = 0x10000
	// Position of CHSELRMOD field.
	ADC_ADC_CFGR1_CHSELRMOD_Pos = 0x15
	// Bit mask of CHSELRMOD field.
	ADC_ADC_CFGR1_CHSELRMOD_Msk = 0x200000
	// Bit CHSELRMOD.
	ADC_ADC_CFGR1_CHSELRMOD = 0x200000
	// Position of AWD1SGL field.
	ADC_ADC_CFGR1_AWD1SGL_Pos = 0x16
	// Bit mask of AWD1SGL field.
	ADC_ADC_CFGR1_AWD1SGL_Msk = 0x400000
	// Bit AWD1SGL.
	ADC_ADC_CFGR1_AWD1SGL = 0x400000
	// Position of AWD1EN field.
	ADC_ADC_CFGR1_AWD1EN_Pos = 0x17
	// Bit mask of AWD1EN field.
	ADC_ADC_CFGR1_AWD1EN_Msk = 0x800000
	// Bit AWD1EN.
	ADC_ADC_CFGR1_AWD1EN = 0x800000
	// Position of AWD1CH field.
	ADC_ADC_CFGR1_AWD1CH_Pos = 0x1a
	// Bit mask of AWD1CH field.
	ADC_ADC_CFGR1_AWD1CH_Msk = 0x7c000000

	// ADC_CFGR2: ADC configuration register 2
	// Position of OVSE field.
	ADC_ADC_CFGR2_OVSE_Pos = 0x0
	// Bit mask of OVSE field.
	ADC_ADC_CFGR2_OVSE_Msk = 0x1
	// Bit OVSE.
	ADC_ADC_CFGR2_OVSE = 0x1
	// Position of OVSR0 field.
	ADC_ADC_CFGR2_OVSR0_Pos = 0x2
	// Bit mask of OVSR0 field.
	ADC_ADC_CFGR2_OVSR0_Msk = 0x4
	// Bit OVSR0.
	ADC_ADC_CFGR2_OVSR0 = 0x4
	// Position of OVSR1 field.
	ADC_ADC_CFGR2_OVSR1_Pos = 0x3
	// Bit mask of OVSR1 field.
	ADC_ADC_CFGR2_OVSR1_Msk = 0x8
	// Bit OVSR1.
	ADC_ADC_CFGR2_OVSR1 = 0x8
	// Position of OVSR2 field.
	ADC_ADC_CFGR2_OVSR2_Pos = 0x4
	// Bit mask of OVSR2 field.
	ADC_ADC_CFGR2_OVSR2_Msk = 0x10
	// Bit OVSR2.
	ADC_ADC_CFGR2_OVSR2 = 0x10
	// Position of OVSS0 field.
	ADC_ADC_CFGR2_OVSS0_Pos = 0x5
	// Bit mask of OVSS0 field.
	ADC_ADC_CFGR2_OVSS0_Msk = 0x20
	// Bit OVSS0.
	ADC_ADC_CFGR2_OVSS0 = 0x20
	// Position of OVSS1 field.
	ADC_ADC_CFGR2_OVSS1_Pos = 0x6
	// Bit mask of OVSS1 field.
	ADC_ADC_CFGR2_OVSS1_Msk = 0x40
	// Bit OVSS1.
	ADC_ADC_CFGR2_OVSS1 = 0x40
	// Position of OVSS2 field.
	ADC_ADC_CFGR2_OVSS2_Pos = 0x7
	// Bit mask of OVSS2 field.
	ADC_ADC_CFGR2_OVSS2_Msk = 0x80
	// Bit OVSS2.
	ADC_ADC_CFGR2_OVSS2 = 0x80
	// Position of OVSS3 field.
	ADC_ADC_CFGR2_OVSS3_Pos = 0x8
	// Bit mask of OVSS3 field.
	ADC_ADC_CFGR2_OVSS3_Msk = 0x100
	// Bit OVSS3.
	ADC_ADC_CFGR2_OVSS3 = 0x100
	// Position of TOVS field.
	ADC_ADC_CFGR2_TOVS_Pos = 0x9
	// Bit mask of TOVS field.
	ADC_ADC_CFGR2_TOVS_Msk = 0x200
	// Bit TOVS.
	ADC_ADC_CFGR2_TOVS = 0x200
	// Position of LFTRIG field.
	ADC_ADC_CFGR2_LFTRIG_Pos = 0x1d
	// Bit mask of LFTRIG field.
	ADC_ADC_CFGR2_LFTRIG_Msk = 0x20000000
	// Bit LFTRIG.
	ADC_ADC_CFGR2_LFTRIG = 0x20000000
	// Position of CKMODE field.
	ADC_ADC_CFGR2_CKMODE_Pos = 0x1e
	// Bit mask of CKMODE field.
	ADC_ADC_CFGR2_CKMODE_Msk = 0xc0000000

	// ADC_SMPR: ADC sampling time register
	// Position of SMP1 field.
	ADC_ADC_SMPR_SMP1_Pos = 0x0
	// Bit mask of SMP1 field.
	ADC_ADC_SMPR_SMP1_Msk = 0x7
	// Position of SMP2 field.
	ADC_ADC_SMPR_SMP2_Pos = 0x4
	// Bit mask of SMP2 field.
	ADC_ADC_SMPR_SMP2_Msk = 0x70
	// Position of SMPSEL field.
	ADC_ADC_SMPR_SMPSEL_Pos = 0x8
	// Bit mask of SMPSEL field.
	ADC_ADC_SMPR_SMPSEL_Msk = 0x3ffff00

	// ADC_AWD1TR: ADC watchdog threshold register
	// Position of LT1 field.
	ADC_ADC_AWD1TR_LT1_Pos = 0x0
	// Bit mask of LT1 field.
	ADC_ADC_AWD1TR_LT1_Msk = 0xfff
	// Position of HT1 field.
	ADC_ADC_AWD1TR_HT1_Pos = 0x10
	// Bit mask of HT1 field.
	ADC_ADC_AWD1TR_HT1_Msk = 0xfff0000

	// ADC_AWD2TR: ADC watchdog threshold register
	// Position of LT2 field.
	ADC_ADC_AWD2TR_LT2_Pos = 0x0
	// Bit mask of LT2 field.
	ADC_ADC_AWD2TR_LT2_Msk = 0xfff
	// Position of HT2 field.
	ADC_ADC_AWD2TR_HT2_Pos = 0x10
	// Bit mask of HT2 field.
	ADC_ADC_AWD2TR_HT2_Msk = 0xfff0000

	// ADC_CHSELR0: channel selection register
	// Position of CHSEL field.
	ADC_ADC_CHSELR0_CHSEL_Pos = 0x0
	// Bit mask of CHSEL field.
	ADC_ADC_CHSELR0_CHSEL_Msk = 0x3ffff

	// ADC_CHSELR1: channel selection register
	// Position of SQ1 field.
	ADC_ADC_CHSELR1_SQ1_Pos = 0x0
	// Bit mask of SQ1 field.
	ADC_ADC_CHSELR1_SQ1_Msk = 0xf
	// Position of SQ2 field.
	ADC_ADC_CHSELR1_SQ2_Pos = 0x4
	// Bit mask of SQ2 field.
	ADC_ADC_CHSELR1_SQ2_Msk = 0xf0
	// Position of SQ3 field.
	ADC_ADC_CHSELR1_SQ3_Pos = 0x8
	// Bit mask of SQ3 field.
	ADC_ADC_CHSELR1_SQ3_Msk = 0xf00
	// Position of SQ4 field.
	ADC_ADC_CHSELR1_SQ4_Pos = 0xc
	// Bit mask of SQ4 field.
	ADC_ADC_CHSELR1_SQ4_Msk = 0xf000
	// Position of SQ5 field.
	ADC_ADC_CHSELR1_SQ5_Pos = 0x10
	// Bit mask of SQ5 field.
	ADC_ADC_CHSELR1_SQ5_Msk = 0xf0000
	// Position of SQ6 field.
	ADC_ADC_CHSELR1_SQ6_Pos = 0x14
	// Bit mask of SQ6 field.
	ADC_ADC_CHSELR1_SQ6_Msk = 0xf00000
	// Position of SQ7 field.
	ADC_ADC_CHSELR1_SQ7_Pos = 0x18
	// Bit mask of SQ7 field.
	ADC_ADC_CHSELR1_SQ7_Msk = 0xf000000
	// Position of SQ8 field.
	ADC_ADC_CHSELR1_SQ8_Pos = 0x1c
	// Bit mask of SQ8 field.
	ADC_ADC_CHSELR1_SQ8_Msk = 0xf0000000

	// ADC_AWD3TR: ADC watchdog threshold register
	// Position of LT3 field.
	ADC_ADC_AWD3TR_LT3_Pos = 0x0
	// Bit mask of LT3 field.
	ADC_ADC_AWD3TR_LT3_Msk = 0xfff
	// Position of HT3 field.
	ADC_ADC_AWD3TR_HT3_Pos = 0x10
	// Bit mask of HT3 field.
	ADC_ADC_AWD3TR_HT3_Msk = 0xfff0000

	// ADC_DR: ADC data register
	// Position of DATA field.
	ADC_ADC_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	ADC_ADC_DR_DATA_Msk = 0xffff

	// ADC_AWD2CR: ADC Analog Watchdog 2 Configuration register
	// Position of AWD2CH field.
	ADC_ADC_AWD2CR_AWD2CH_Pos = 0x0
	// Bit mask of AWD2CH field.
	ADC_ADC_AWD2CR_AWD2CH_Msk = 0x3ffff

	// ADC_AWD3CR: ADC Analog Watchdog 3 Configuration register
	// Position of AWD3CH field.
	ADC_ADC_AWD3CR_AWD3CH_Pos = 0x0
	// Bit mask of AWD3CH field.
	ADC_ADC_AWD3CR_AWD3CH_Msk = 0x3ffff

	// ADC_CALFACT: ADC Calibration factor
	// Position of CALFACT field.
	ADC_ADC_CALFACT_CALFACT_Pos = 0x0
	// Bit mask of CALFACT field.
	ADC_ADC_CALFACT_CALFACT_Msk = 0x7f

	// ADC_CCR: ADC common configuration register
	// Position of PRESC0 field.
	ADC_ADC_CCR_PRESC0_Pos = 0x12
	// Bit mask of PRESC0 field.
	ADC_ADC_CCR_PRESC0_Msk = 0x40000
	// Bit PRESC0.
	ADC_ADC_CCR_PRESC0 = 0x40000
	// Position of PRESC1 field.
	ADC_ADC_CCR_PRESC1_Pos = 0x13
	// Bit mask of PRESC1 field.
	ADC_ADC_CCR_PRESC1_Msk = 0x80000
	// Bit PRESC1.
	ADC_ADC_CCR_PRESC1 = 0x80000
	// Position of PRESC2 field.
	ADC_ADC_CCR_PRESC2_Pos = 0x14
	// Bit mask of PRESC2 field.
	ADC_ADC_CCR_PRESC2_Msk = 0x100000
	// Bit PRESC2.
	ADC_ADC_CCR_PRESC2 = 0x100000
	// Position of PRESC3 field.
	ADC_ADC_CCR_PRESC3_Pos = 0x15
	// Bit mask of PRESC3 field.
	ADC_ADC_CCR_PRESC3_Msk = 0x200000
	// Bit PRESC3.
	ADC_ADC_CCR_PRESC3 = 0x200000
	// Position of VREFEN field.
	ADC_ADC_CCR_VREFEN_Pos = 0x16
	// Bit mask of VREFEN field.
	ADC_ADC_CCR_VREFEN_Msk = 0x400000
	// Bit VREFEN.
	ADC_ADC_CCR_VREFEN = 0x400000
	// Position of TSEN field.
	ADC_ADC_CCR_TSEN_Pos = 0x17
	// Bit mask of TSEN field.
	ADC_ADC_CCR_TSEN_Msk = 0x800000
	// Bit TSEN.
	ADC_ADC_CCR_TSEN = 0x800000
	// Position of VBATEN field.
	ADC_ADC_CCR_VBATEN_Pos = 0x18
	// Bit mask of VBATEN field.
	ADC_ADC_CCR_VBATEN_Msk = 0x1000000
	// Bit VBATEN.
	ADC_ADC_CCR_VBATEN = 0x1000000
)

// Bitfields for AES: Advanced encryption standard hardware accelerator 1
const (
	// CR: control register
	// Position of NPBLB field.
	AES_CR_NPBLB_Pos = 0x14
	// Bit mask of NPBLB field.
	AES_CR_NPBLB_Msk = 0xf00000
	// Position of KEYSIZE field.
	AES_CR_KEYSIZE_Pos = 0x12
	// Bit mask of KEYSIZE field.
	AES_CR_KEYSIZE_Msk = 0x40000
	// Bit KEYSIZE.
	AES_CR_KEYSIZE = 0x40000
	// Position of CHMOD2 field.
	AES_CR_CHMOD2_Pos = 0x10
	// Bit mask of CHMOD2 field.
	AES_CR_CHMOD2_Msk = 0x10000
	// Bit CHMOD2.
	AES_CR_CHMOD2 = 0x10000
	// Position of GCMPH field.
	AES_CR_GCMPH_Pos = 0xd
	// Bit mask of GCMPH field.
	AES_CR_GCMPH_Msk = 0x6000
	// Position of DMAOUTEN field.
	AES_CR_DMAOUTEN_Pos = 0xc
	// Bit mask of DMAOUTEN field.
	AES_CR_DMAOUTEN_Msk = 0x1000
	// Bit DMAOUTEN.
	AES_CR_DMAOUTEN = 0x1000
	// Position of DMAINEN field.
	AES_CR_DMAINEN_Pos = 0xb
	// Bit mask of DMAINEN field.
	AES_CR_DMAINEN_Msk = 0x800
	// Bit DMAINEN.
	AES_CR_DMAINEN = 0x800
	// Position of ERRIE field.
	AES_CR_ERRIE_Pos = 0xa
	// Bit mask of ERRIE field.
	AES_CR_ERRIE_Msk = 0x400
	// Bit ERRIE.
	AES_CR_ERRIE = 0x400
	// Position of CCFIE field.
	AES_CR_CCFIE_Pos = 0x9
	// Bit mask of CCFIE field.
	AES_CR_CCFIE_Msk = 0x200
	// Bit CCFIE.
	AES_CR_CCFIE = 0x200
	// Position of ERRC field.
	AES_CR_ERRC_Pos = 0x8
	// Bit mask of ERRC field.
	AES_CR_ERRC_Msk = 0x100
	// Bit ERRC.
	AES_CR_ERRC = 0x100
	// Position of CCFC field.
	AES_CR_CCFC_Pos = 0x7
	// Bit mask of CCFC field.
	AES_CR_CCFC_Msk = 0x80
	// Bit CCFC.
	AES_CR_CCFC = 0x80
	// Position of CHMOD10 field.
	AES_CR_CHMOD10_Pos = 0x5
	// Bit mask of CHMOD10 field.
	AES_CR_CHMOD10_Msk = 0x60
	// Position of MODE field.
	AES_CR_MODE_Pos = 0x3
	// Bit mask of MODE field.
	AES_CR_MODE_Msk = 0x18
	// Position of DATATYPE field.
	AES_CR_DATATYPE_Pos = 0x1
	// Bit mask of DATATYPE field.
	AES_CR_DATATYPE_Msk = 0x6
	// Position of EN field.
	AES_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	AES_CR_EN_Msk = 0x1
	// Bit EN.
	AES_CR_EN = 0x1

	// SR: status register
	// Position of BUSY field.
	AES_SR_BUSY_Pos = 0x3
	// Bit mask of BUSY field.
	AES_SR_BUSY_Msk = 0x8
	// Bit BUSY.
	AES_SR_BUSY = 0x8
	// Position of WRERR field.
	AES_SR_WRERR_Pos = 0x2
	// Bit mask of WRERR field.
	AES_SR_WRERR_Msk = 0x4
	// Bit WRERR.
	AES_SR_WRERR = 0x4
	// Position of RDERR field.
	AES_SR_RDERR_Pos = 0x1
	// Bit mask of RDERR field.
	AES_SR_RDERR_Msk = 0x2
	// Bit RDERR.
	AES_SR_RDERR = 0x2
	// Position of CCF field.
	AES_SR_CCF_Pos = 0x0
	// Bit mask of CCF field.
	AES_SR_CCF_Msk = 0x1
	// Bit CCF.
	AES_SR_CCF = 0x1

	// DINR: data input register
	// Position of AES_DINR field.
	AES_DINR_AES_DINR_Pos = 0x0
	// Bit mask of AES_DINR field.
	AES_DINR_AES_DINR_Msk = 0xffffffff

	// DOUTR: data output register
	// Position of AES_DOUTR field.
	AES_DOUTR_AES_DOUTR_Pos = 0x0
	// Bit mask of AES_DOUTR field.
	AES_DOUTR_AES_DOUTR_Msk = 0xffffffff

	// KEYR0: key register 0
	// Position of AES_KEYR0 field.
	AES_KEYR0_AES_KEYR0_Pos = 0x0
	// Bit mask of AES_KEYR0 field.
	AES_KEYR0_AES_KEYR0_Msk = 0xffffffff

	// KEYR1: key register 1
	// Position of AES_KEYR1 field.
	AES_KEYR1_AES_KEYR1_Pos = 0x0
	// Bit mask of AES_KEYR1 field.
	AES_KEYR1_AES_KEYR1_Msk = 0xffffffff

	// KEYR2: key register 2
	// Position of AES_KEYR2 field.
	AES_KEYR2_AES_KEYR2_Pos = 0x0
	// Bit mask of AES_KEYR2 field.
	AES_KEYR2_AES_KEYR2_Msk = 0xffffffff

	// KEYR3: key register 3
	// Position of AES_KEYR3 field.
	AES_KEYR3_AES_KEYR3_Pos = 0x0
	// Bit mask of AES_KEYR3 field.
	AES_KEYR3_AES_KEYR3_Msk = 0xffffffff

	// IVR0: initialization vector register 0
	// Position of AES_IVR0 field.
	AES_IVR0_AES_IVR0_Pos = 0x0
	// Bit mask of AES_IVR0 field.
	AES_IVR0_AES_IVR0_Msk = 0xffffffff

	// IVR1: initialization vector register 1
	// Position of AES_IVR1 field.
	AES_IVR1_AES_IVR1_Pos = 0x0
	// Bit mask of AES_IVR1 field.
	AES_IVR1_AES_IVR1_Msk = 0xffffffff

	// IVR2: initialization vector register 2
	// Position of AES_IVR2 field.
	AES_IVR2_AES_IVR2_Pos = 0x0
	// Bit mask of AES_IVR2 field.
	AES_IVR2_AES_IVR2_Msk = 0xffffffff

	// IVR3: initialization vector register 3
	// Position of AES_IVR3 field.
	AES_IVR3_AES_IVR3_Pos = 0x0
	// Bit mask of AES_IVR3 field.
	AES_IVR3_AES_IVR3_Msk = 0xffffffff

	// KEYR4: key register 4
	// Position of AES_KEYR4 field.
	AES_KEYR4_AES_KEYR4_Pos = 0x0
	// Bit mask of AES_KEYR4 field.
	AES_KEYR4_AES_KEYR4_Msk = 0xffffffff

	// KEYR5: key register 5
	// Position of AES_KEYR5 field.
	AES_KEYR5_AES_KEYR5_Pos = 0x0
	// Bit mask of AES_KEYR5 field.
	AES_KEYR5_AES_KEYR5_Msk = 0xffffffff

	// KEYR6: key register 6
	// Position of AES_KEYR6 field.
	AES_KEYR6_AES_KEYR6_Pos = 0x0
	// Bit mask of AES_KEYR6 field.
	AES_KEYR6_AES_KEYR6_Msk = 0xffffffff

	// KEYR7: key register 7
	// Position of AES_KEYR7 field.
	AES_KEYR7_AES_KEYR7_Pos = 0x0
	// Bit mask of AES_KEYR7 field.
	AES_KEYR7_AES_KEYR7_Msk = 0xffffffff

	// SUSP0R: AES suspend register 0
	// Position of AES_SUSP0R field.
	AES_SUSP0R_AES_SUSP0R_Pos = 0x0
	// Bit mask of AES_SUSP0R field.
	AES_SUSP0R_AES_SUSP0R_Msk = 0xffffffff

	// SUSP1R: AES suspend register 1
	// Position of AES_SUSP1R field.
	AES_SUSP1R_AES_SUSP1R_Pos = 0x0
	// Bit mask of AES_SUSP1R field.
	AES_SUSP1R_AES_SUSP1R_Msk = 0xffffffff

	// SUSP2R: AES suspend register 2
	// Position of AES_SUSP2R field.
	AES_SUSP2R_AES_SUSP2R_Pos = 0x0
	// Bit mask of AES_SUSP2R field.
	AES_SUSP2R_AES_SUSP2R_Msk = 0xffffffff

	// SUSP3R: AES suspend register 3
	// Position of AES_SUSP3R field.
	AES_SUSP3R_AES_SUSP3R_Pos = 0x0
	// Bit mask of AES_SUSP3R field.
	AES_SUSP3R_AES_SUSP3R_Msk = 0xffffffff

	// SUSP4R: AES suspend register 4
	// Position of AES_SUSP4R field.
	AES_SUSP4R_AES_SUSP4R_Pos = 0x0
	// Bit mask of AES_SUSP4R field.
	AES_SUSP4R_AES_SUSP4R_Msk = 0xffffffff

	// SUSP5R: AES suspend register 5
	// Position of AES_SUSP5R field.
	AES_SUSP5R_AES_SUSP5R_Pos = 0x0
	// Bit mask of AES_SUSP5R field.
	AES_SUSP5R_AES_SUSP5R_Msk = 0xffffffff

	// SUSP6R: AES suspend register 6
	// Position of AES_SUSP6R field.
	AES_SUSP6R_AES_SUSP6R_Pos = 0x0
	// Bit mask of AES_SUSP6R field.
	AES_SUSP6R_AES_SUSP6R_Msk = 0xffffffff

	// SUSP7R: AES suspend register 7
	// Position of AES_SUSP7R field.
	AES_SUSP7R_AES_SUSP7R_Pos = 0x0
	// Bit mask of AES_SUSP7R field.
	AES_SUSP7R_AES_SUSP7R_Msk = 0xffffffff
)

// Bitfields for COMP: Comparator
const (
	// COMP1_CSR: COMP1_CSR
	// Position of LOCK field.
	COMP_COMP1_CSR_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	COMP_COMP1_CSR_LOCK_Msk = 0x80000000
	// Bit LOCK.
	COMP_COMP1_CSR_LOCK = 0x80000000
	// Position of VALUE field.
	COMP_COMP1_CSR_VALUE_Pos = 0x1e
	// Bit mask of VALUE field.
	COMP_COMP1_CSR_VALUE_Msk = 0x40000000
	// Bit VALUE.
	COMP_COMP1_CSR_VALUE = 0x40000000
	// Position of INMESEL field.
	COMP_COMP1_CSR_INMESEL_Pos = 0x19
	// Bit mask of INMESEL field.
	COMP_COMP1_CSR_INMESEL_Msk = 0x6000000
	// Position of SCALEN field.
	COMP_COMP1_CSR_SCALEN_Pos = 0x17
	// Bit mask of SCALEN field.
	COMP_COMP1_CSR_SCALEN_Msk = 0x800000
	// Bit SCALEN.
	COMP_COMP1_CSR_SCALEN = 0x800000
	// Position of BRGEN field.
	COMP_COMP1_CSR_BRGEN_Pos = 0x16
	// Bit mask of BRGEN field.
	COMP_COMP1_CSR_BRGEN_Msk = 0x400000
	// Bit BRGEN.
	COMP_COMP1_CSR_BRGEN = 0x400000
	// Position of BLANKING field.
	COMP_COMP1_CSR_BLANKING_Pos = 0x12
	// Bit mask of BLANKING field.
	COMP_COMP1_CSR_BLANKING_Msk = 0x1c0000
	// Position of HYST field.
	COMP_COMP1_CSR_HYST_Pos = 0x10
	// Bit mask of HYST field.
	COMP_COMP1_CSR_HYST_Msk = 0x30000
	// Position of POLARITY field.
	COMP_COMP1_CSR_POLARITY_Pos = 0xf
	// Bit mask of POLARITY field.
	COMP_COMP1_CSR_POLARITY_Msk = 0x8000
	// Bit POLARITY.
	COMP_COMP1_CSR_POLARITY = 0x8000
	// Position of INPSEL field.
	COMP_COMP1_CSR_INPSEL_Pos = 0x7
	// Bit mask of INPSEL field.
	COMP_COMP1_CSR_INPSEL_Msk = 0x180
	// Position of INMSEL field.
	COMP_COMP1_CSR_INMSEL_Pos = 0x4
	// Bit mask of INMSEL field.
	COMP_COMP1_CSR_INMSEL_Msk = 0x70
	// Position of PWRMODE field.
	COMP_COMP1_CSR_PWRMODE_Pos = 0x2
	// Bit mask of PWRMODE field.
	COMP_COMP1_CSR_PWRMODE_Msk = 0xc
	// Position of EN field.
	COMP_COMP1_CSR_EN_Pos = 0x0
	// Bit mask of EN field.
	COMP_COMP1_CSR_EN_Msk = 0x1
	// Bit EN.
	COMP_COMP1_CSR_EN = 0x1

	// COMP2_CSR: COMP2_CSR
	// Position of LOCK field.
	COMP_COMP2_CSR_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	COMP_COMP2_CSR_LOCK_Msk = 0x80000000
	// Bit LOCK.
	COMP_COMP2_CSR_LOCK = 0x80000000
	// Position of VALUE field.
	COMP_COMP2_CSR_VALUE_Pos = 0x1e
	// Bit mask of VALUE field.
	COMP_COMP2_CSR_VALUE_Msk = 0x40000000
	// Bit VALUE.
	COMP_COMP2_CSR_VALUE = 0x40000000
	// Position of INMESEL field.
	COMP_COMP2_CSR_INMESEL_Pos = 0x19
	// Bit mask of INMESEL field.
	COMP_COMP2_CSR_INMESEL_Msk = 0x6000000
	// Position of SCALEN field.
	COMP_COMP2_CSR_SCALEN_Pos = 0x17
	// Bit mask of SCALEN field.
	COMP_COMP2_CSR_SCALEN_Msk = 0x800000
	// Bit SCALEN.
	COMP_COMP2_CSR_SCALEN = 0x800000
	// Position of BRGEN field.
	COMP_COMP2_CSR_BRGEN_Pos = 0x16
	// Bit mask of BRGEN field.
	COMP_COMP2_CSR_BRGEN_Msk = 0x400000
	// Bit BRGEN.
	COMP_COMP2_CSR_BRGEN = 0x400000
	// Position of BLANKING field.
	COMP_COMP2_CSR_BLANKING_Pos = 0x12
	// Bit mask of BLANKING field.
	COMP_COMP2_CSR_BLANKING_Msk = 0x1c0000
	// Position of HYST field.
	COMP_COMP2_CSR_HYST_Pos = 0x10
	// Bit mask of HYST field.
	COMP_COMP2_CSR_HYST_Msk = 0x30000
	// Position of POLARITY field.
	COMP_COMP2_CSR_POLARITY_Pos = 0xf
	// Bit mask of POLARITY field.
	COMP_COMP2_CSR_POLARITY_Msk = 0x8000
	// Bit POLARITY.
	COMP_COMP2_CSR_POLARITY = 0x8000
	// Position of WINMODE field.
	COMP_COMP2_CSR_WINMODE_Pos = 0x9
	// Bit mask of WINMODE field.
	COMP_COMP2_CSR_WINMODE_Msk = 0x200
	// Bit WINMODE.
	COMP_COMP2_CSR_WINMODE = 0x200
	// Position of INPSEL field.
	COMP_COMP2_CSR_INPSEL_Pos = 0x7
	// Bit mask of INPSEL field.
	COMP_COMP2_CSR_INPSEL_Msk = 0x180
	// Position of INMSEL field.
	COMP_COMP2_CSR_INMSEL_Pos = 0x4
	// Bit mask of INMSEL field.
	COMP_COMP2_CSR_INMSEL_Msk = 0x70
	// Position of PWRMODE field.
	COMP_COMP2_CSR_PWRMODE_Pos = 0x2
	// Bit mask of PWRMODE field.
	COMP_COMP2_CSR_PWRMODE_Msk = 0xc
	// Position of EN field.
	COMP_COMP2_CSR_EN_Pos = 0x0
	// Bit mask of EN field.
	COMP_COMP2_CSR_EN_Msk = 0x1
	// Bit EN.
	COMP_COMP2_CSR_EN = 0x1
)

// Bitfields for CRC: Cyclic redundancy check calculation unit
const (
	// DR: Data register
	// Position of DR field.
	CRC_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	CRC_DR_DR_Msk = 0xffffffff

	// IDR: Independent data register
	// Position of IDR field.
	CRC_IDR_IDR_Pos = 0x0
	// Bit mask of IDR field.
	CRC_IDR_IDR_Msk = 0xffffffff

	// CR: Control register
	// Position of REV_OUT field.
	CRC_CR_REV_OUT_Pos = 0x7
	// Bit mask of REV_OUT field.
	CRC_CR_REV_OUT_Msk = 0x80
	// Bit REV_OUT.
	CRC_CR_REV_OUT = 0x80
	// Position of REV_IN field.
	CRC_CR_REV_IN_Pos = 0x5
	// Bit mask of REV_IN field.
	CRC_CR_REV_IN_Msk = 0x60
	// Position of POLYSIZE field.
	CRC_CR_POLYSIZE_Pos = 0x3
	// Bit mask of POLYSIZE field.
	CRC_CR_POLYSIZE_Msk = 0x18
	// Position of RESET field.
	CRC_CR_RESET_Pos = 0x0
	// Bit mask of RESET field.
	CRC_CR_RESET_Msk = 0x1
	// Bit RESET.
	CRC_CR_RESET = 0x1

	// INIT: Initial CRC value
	// Position of CRC_INIT field.
	CRC_INIT_CRC_INIT_Pos = 0x0
	// Bit mask of CRC_INIT field.
	CRC_INIT_CRC_INIT_Msk = 0xffffffff

	// POL: polynomial
	// Position of POL field.
	CRC_POL_POL_Pos = 0x0
	// Bit mask of POL field.
	CRC_POL_POL_Msk = 0xffffffff
)

// Bitfields for DAC: Digital-to-analog converter
const (
	// CR: control register
	// Position of CEN1 field.
	DAC_CR_CEN1_Pos = 0xe
	// Bit mask of CEN1 field.
	DAC_CR_CEN1_Msk = 0x4000
	// Bit CEN1.
	DAC_CR_CEN1 = 0x4000
	// Position of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Pos = 0xd
	// Bit mask of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Msk = 0x2000
	// Bit DMAUDRIE1.
	DAC_CR_DMAUDRIE1 = 0x2000
	// Position of DMAEN1 field.
	DAC_CR_DMAEN1_Pos = 0xc
	// Bit mask of DMAEN1 field.
	DAC_CR_DMAEN1_Msk = 0x1000
	// Bit DMAEN1.
	DAC_CR_DMAEN1 = 0x1000
	// Position of MAMP1 field.
	DAC_CR_MAMP1_Pos = 0x8
	// Bit mask of MAMP1 field.
	DAC_CR_MAMP1_Msk = 0xf00
	// Position of WAVE1 field.
	DAC_CR_WAVE1_Pos = 0x6
	// Bit mask of WAVE1 field.
	DAC_CR_WAVE1_Msk = 0xc0
	// Position of TSEL13 field.
	DAC_CR_TSEL13_Pos = 0x5
	// Bit mask of TSEL13 field.
	DAC_CR_TSEL13_Msk = 0x20
	// Bit TSEL13.
	DAC_CR_TSEL13 = 0x20
	// Position of TSEL12 field.
	DAC_CR_TSEL12_Pos = 0x4
	// Bit mask of TSEL12 field.
	DAC_CR_TSEL12_Msk = 0x10
	// Bit TSEL12.
	DAC_CR_TSEL12 = 0x10
	// Position of TSEL11 field.
	DAC_CR_TSEL11_Pos = 0x3
	// Bit mask of TSEL11 field.
	DAC_CR_TSEL11_Msk = 0x8
	// Bit TSEL11.
	DAC_CR_TSEL11 = 0x8
	// Position of TSEL10 field.
	DAC_CR_TSEL10_Pos = 0x2
	// Bit mask of TSEL10 field.
	DAC_CR_TSEL10_Msk = 0x4
	// Bit TSEL10.
	DAC_CR_TSEL10 = 0x4
	// Position of TEN1 field.
	DAC_CR_TEN1_Pos = 0x1
	// Bit mask of TEN1 field.
	DAC_CR_TEN1_Msk = 0x2
	// Bit TEN1.
	DAC_CR_TEN1 = 0x2
	// Position of EN1 field.
	DAC_CR_EN1_Pos = 0x0
	// Bit mask of EN1 field.
	DAC_CR_EN1_Msk = 0x1
	// Bit EN1.
	DAC_CR_EN1 = 0x1

	// SWTRGR: software trigger register
	// Position of SWTRIG1 field.
	DAC_SWTRGR_SWTRIG1_Pos = 0x0
	// Bit mask of SWTRIG1 field.
	DAC_SWTRGR_SWTRIG1_Msk = 0x1
	// Bit SWTRIG1.
	DAC_SWTRGR_SWTRIG1 = 0x1

	// DHR12R1: channel1 12-bit right-aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Msk = 0xfff

	// DHR12L1: channel1 12-bit left aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Msk = 0xfff0

	// DHR8R1: channel1 8-bit right aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Msk = 0xff

	// DHR12RD: Dual DAC 12-bit right-aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Msk = 0xfff

	// DHR12LD: Dual DAC 12-bit left aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Msk = 0xfff0

	// DHR8RD: Dual DAC 8-bit right aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Msk = 0xff

	// DOR1: DAC channel1 data output register
	// Position of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Pos = 0x0
	// Bit mask of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Msk = 0xfff

	// SR: status register
	// Position of BWST1 field.
	DAC_SR_BWST1_Pos = 0xf
	// Bit mask of BWST1 field.
	DAC_SR_BWST1_Msk = 0x8000
	// Bit BWST1.
	DAC_SR_BWST1 = 0x8000
	// Position of CAL_FLAG1 field.
	DAC_SR_CAL_FLAG1_Pos = 0xe
	// Bit mask of CAL_FLAG1 field.
	DAC_SR_CAL_FLAG1_Msk = 0x4000
	// Bit CAL_FLAG1.
	DAC_SR_CAL_FLAG1 = 0x4000
	// Position of DMAUDR1 field.
	DAC_SR_DMAUDR1_Pos = 0xd
	// Bit mask of DMAUDR1 field.
	DAC_SR_DMAUDR1_Msk = 0x2000
	// Bit DMAUDR1.
	DAC_SR_DMAUDR1 = 0x2000

	// CCR: calibration control register
	// Position of OTRIM1 field.
	DAC_CCR_OTRIM1_Pos = 0x0
	// Bit mask of OTRIM1 field.
	DAC_CCR_OTRIM1_Msk = 0x1f

	// MCR: mode control register
	// Position of MODE1 field.
	DAC_MCR_MODE1_Pos = 0x0
	// Bit mask of MODE1 field.
	DAC_MCR_MODE1_Msk = 0x7

	// SHSR1: Sample and Hold sample time register 1
	// Position of TSAMPLE1 field.
	DAC_SHSR1_TSAMPLE1_Pos = 0x0
	// Bit mask of TSAMPLE1 field.
	DAC_SHSR1_TSAMPLE1_Msk = 0x3ff

	// SHHR: Sample and Hold hold time register
	// Position of THOLD1 field.
	DAC_SHHR_THOLD1_Pos = 0x0
	// Bit mask of THOLD1 field.
	DAC_SHHR_THOLD1_Msk = 0x3ff

	// SHRR: Sample and Hold refresh time register
	// Position of TREFRESH1 field.
	DAC_SHRR_TREFRESH1_Pos = 0x0
	// Bit mask of TREFRESH1 field.
	DAC_SHRR_TREFRESH1_Msk = 0xff
)

// Bitfields for DMA1: Direct memory access controller
const (
	// ISR: interrupt status register
	// Position of TEIF7 field.
	DMA_ISR_TEIF7_Pos = 0x1b
	// Bit mask of TEIF7 field.
	DMA_ISR_TEIF7_Msk = 0x8000000
	// Bit TEIF7.
	DMA_ISR_TEIF7 = 0x8000000
	// Position of HTIF7 field.
	DMA_ISR_HTIF7_Pos = 0x1a
	// Bit mask of HTIF7 field.
	DMA_ISR_HTIF7_Msk = 0x4000000
	// Bit HTIF7.
	DMA_ISR_HTIF7 = 0x4000000
	// Position of TCIF7 field.
	DMA_ISR_TCIF7_Pos = 0x19
	// Bit mask of TCIF7 field.
	DMA_ISR_TCIF7_Msk = 0x2000000
	// Bit TCIF7.
	DMA_ISR_TCIF7 = 0x2000000
	// Position of GIF7 field.
	DMA_ISR_GIF7_Pos = 0x18
	// Bit mask of GIF7 field.
	DMA_ISR_GIF7_Msk = 0x1000000
	// Bit GIF7.
	DMA_ISR_GIF7 = 0x1000000
	// Position of TEIF6 field.
	DMA_ISR_TEIF6_Pos = 0x17
	// Bit mask of TEIF6 field.
	DMA_ISR_TEIF6_Msk = 0x800000
	// Bit TEIF6.
	DMA_ISR_TEIF6 = 0x800000
	// Position of HTIF6 field.
	DMA_ISR_HTIF6_Pos = 0x16
	// Bit mask of HTIF6 field.
	DMA_ISR_HTIF6_Msk = 0x400000
	// Bit HTIF6.
	DMA_ISR_HTIF6 = 0x400000
	// Position of TCIF6 field.
	DMA_ISR_TCIF6_Pos = 0x15
	// Bit mask of TCIF6 field.
	DMA_ISR_TCIF6_Msk = 0x200000
	// Bit TCIF6.
	DMA_ISR_TCIF6 = 0x200000
	// Position of GIF6 field.
	DMA_ISR_GIF6_Pos = 0x14
	// Bit mask of GIF6 field.
	DMA_ISR_GIF6_Msk = 0x100000
	// Bit GIF6.
	DMA_ISR_GIF6 = 0x100000
	// Position of TEIF5 field.
	DMA_ISR_TEIF5_Pos = 0x13
	// Bit mask of TEIF5 field.
	DMA_ISR_TEIF5_Msk = 0x80000
	// Bit TEIF5.
	DMA_ISR_TEIF5 = 0x80000
	// Position of HTIF5 field.
	DMA_ISR_HTIF5_Pos = 0x12
	// Bit mask of HTIF5 field.
	DMA_ISR_HTIF5_Msk = 0x40000
	// Bit HTIF5.
	DMA_ISR_HTIF5 = 0x40000
	// Position of TCIF5 field.
	DMA_ISR_TCIF5_Pos = 0x11
	// Bit mask of TCIF5 field.
	DMA_ISR_TCIF5_Msk = 0x20000
	// Bit TCIF5.
	DMA_ISR_TCIF5 = 0x20000
	// Position of GIF5 field.
	DMA_ISR_GIF5_Pos = 0x10
	// Bit mask of GIF5 field.
	DMA_ISR_GIF5_Msk = 0x10000
	// Bit GIF5.
	DMA_ISR_GIF5 = 0x10000
	// Position of TEIF4 field.
	DMA_ISR_TEIF4_Pos = 0xf
	// Bit mask of TEIF4 field.
	DMA_ISR_TEIF4_Msk = 0x8000
	// Bit TEIF4.
	DMA_ISR_TEIF4 = 0x8000
	// Position of HTIF4 field.
	DMA_ISR_HTIF4_Pos = 0xe
	// Bit mask of HTIF4 field.
	DMA_ISR_HTIF4_Msk = 0x4000
	// Bit HTIF4.
	DMA_ISR_HTIF4 = 0x4000
	// Position of TCIF4 field.
	DMA_ISR_TCIF4_Pos = 0xd
	// Bit mask of TCIF4 field.
	DMA_ISR_TCIF4_Msk = 0x2000
	// Bit TCIF4.
	DMA_ISR_TCIF4 = 0x2000
	// Position of GIF4 field.
	DMA_ISR_GIF4_Pos = 0xc
	// Bit mask of GIF4 field.
	DMA_ISR_GIF4_Msk = 0x1000
	// Bit GIF4.
	DMA_ISR_GIF4 = 0x1000
	// Position of TEIF3 field.
	DMA_ISR_TEIF3_Pos = 0xb
	// Bit mask of TEIF3 field.
	DMA_ISR_TEIF3_Msk = 0x800
	// Bit TEIF3.
	DMA_ISR_TEIF3 = 0x800
	// Position of HTIF3 field.
	DMA_ISR_HTIF3_Pos = 0xa
	// Bit mask of HTIF3 field.
	DMA_ISR_HTIF3_Msk = 0x400
	// Bit HTIF3.
	DMA_ISR_HTIF3 = 0x400
	// Position of TCIF3 field.
	DMA_ISR_TCIF3_Pos = 0x9
	// Bit mask of TCIF3 field.
	DMA_ISR_TCIF3_Msk = 0x200
	// Bit TCIF3.
	DMA_ISR_TCIF3 = 0x200
	// Position of GIF3 field.
	DMA_ISR_GIF3_Pos = 0x8
	// Bit mask of GIF3 field.
	DMA_ISR_GIF3_Msk = 0x100
	// Bit GIF3.
	DMA_ISR_GIF3 = 0x100
	// Position of TEIF2 field.
	DMA_ISR_TEIF2_Pos = 0x7
	// Bit mask of TEIF2 field.
	DMA_ISR_TEIF2_Msk = 0x80
	// Bit TEIF2.
	DMA_ISR_TEIF2 = 0x80
	// Position of HTIF2 field.
	DMA_ISR_HTIF2_Pos = 0x6
	// Bit mask of HTIF2 field.
	DMA_ISR_HTIF2_Msk = 0x40
	// Bit HTIF2.
	DMA_ISR_HTIF2 = 0x40
	// Position of TCIF2 field.
	DMA_ISR_TCIF2_Pos = 0x5
	// Bit mask of TCIF2 field.
	DMA_ISR_TCIF2_Msk = 0x20
	// Bit TCIF2.
	DMA_ISR_TCIF2 = 0x20
	// Position of GIF2 field.
	DMA_ISR_GIF2_Pos = 0x4
	// Bit mask of GIF2 field.
	DMA_ISR_GIF2_Msk = 0x10
	// Bit GIF2.
	DMA_ISR_GIF2 = 0x10
	// Position of TEIF1 field.
	DMA_ISR_TEIF1_Pos = 0x3
	// Bit mask of TEIF1 field.
	DMA_ISR_TEIF1_Msk = 0x8
	// Bit TEIF1.
	DMA_ISR_TEIF1 = 0x8
	// Position of HTIF1 field.
	DMA_ISR_HTIF1_Pos = 0x2
	// Bit mask of HTIF1 field.
	DMA_ISR_HTIF1_Msk = 0x4
	// Bit HTIF1.
	DMA_ISR_HTIF1 = 0x4
	// Position of TCIF1 field.
	DMA_ISR_TCIF1_Pos = 0x1
	// Bit mask of TCIF1 field.
	DMA_ISR_TCIF1_Msk = 0x2
	// Bit TCIF1.
	DMA_ISR_TCIF1 = 0x2
	// Position of GIF1 field.
	DMA_ISR_GIF1_Pos = 0x0
	// Bit mask of GIF1 field.
	DMA_ISR_GIF1_Msk = 0x1
	// Bit GIF1.
	DMA_ISR_GIF1 = 0x1

	// IFCR: interrupt flag clear register
	// Position of TEIF7 field.
	DMA_IFCR_TEIF7_Pos = 0x1b
	// Bit mask of TEIF7 field.
	DMA_IFCR_TEIF7_Msk = 0x8000000
	// Bit TEIF7.
	DMA_IFCR_TEIF7 = 0x8000000
	// Position of HTIF7 field.
	DMA_IFCR_HTIF7_Pos = 0x1a
	// Bit mask of HTIF7 field.
	DMA_IFCR_HTIF7_Msk = 0x4000000
	// Bit HTIF7.
	DMA_IFCR_HTIF7 = 0x4000000
	// Position of TCIF7 field.
	DMA_IFCR_TCIF7_Pos = 0x19
	// Bit mask of TCIF7 field.
	DMA_IFCR_TCIF7_Msk = 0x2000000
	// Bit TCIF7.
	DMA_IFCR_TCIF7 = 0x2000000
	// Position of GIF7 field.
	DMA_IFCR_GIF7_Pos = 0x18
	// Bit mask of GIF7 field.
	DMA_IFCR_GIF7_Msk = 0x1000000
	// Bit GIF7.
	DMA_IFCR_GIF7 = 0x1000000
	// Position of TEIF6 field.
	DMA_IFCR_TEIF6_Pos = 0x17
	// Bit mask of TEIF6 field.
	DMA_IFCR_TEIF6_Msk = 0x800000
	// Bit TEIF6.
	DMA_IFCR_TEIF6 = 0x800000
	// Position of HTIF6 field.
	DMA_IFCR_HTIF6_Pos = 0x16
	// Bit mask of HTIF6 field.
	DMA_IFCR_HTIF6_Msk = 0x400000
	// Bit HTIF6.
	DMA_IFCR_HTIF6 = 0x400000
	// Position of TCIF6 field.
	DMA_IFCR_TCIF6_Pos = 0x15
	// Bit mask of TCIF6 field.
	DMA_IFCR_TCIF6_Msk = 0x200000
	// Bit TCIF6.
	DMA_IFCR_TCIF6 = 0x200000
	// Position of GIF6 field.
	DMA_IFCR_GIF6_Pos = 0x14
	// Bit mask of GIF6 field.
	DMA_IFCR_GIF6_Msk = 0x100000
	// Bit GIF6.
	DMA_IFCR_GIF6 = 0x100000
	// Position of TEIF5 field.
	DMA_IFCR_TEIF5_Pos = 0x13
	// Bit mask of TEIF5 field.
	DMA_IFCR_TEIF5_Msk = 0x80000
	// Bit TEIF5.
	DMA_IFCR_TEIF5 = 0x80000
	// Position of HTIF5 field.
	DMA_IFCR_HTIF5_Pos = 0x12
	// Bit mask of HTIF5 field.
	DMA_IFCR_HTIF5_Msk = 0x40000
	// Bit HTIF5.
	DMA_IFCR_HTIF5 = 0x40000
	// Position of TCIF5 field.
	DMA_IFCR_TCIF5_Pos = 0x11
	// Bit mask of TCIF5 field.
	DMA_IFCR_TCIF5_Msk = 0x20000
	// Bit TCIF5.
	DMA_IFCR_TCIF5 = 0x20000
	// Position of GIF5 field.
	DMA_IFCR_GIF5_Pos = 0x10
	// Bit mask of GIF5 field.
	DMA_IFCR_GIF5_Msk = 0x10000
	// Bit GIF5.
	DMA_IFCR_GIF5 = 0x10000
	// Position of TEIF4 field.
	DMA_IFCR_TEIF4_Pos = 0xf
	// Bit mask of TEIF4 field.
	DMA_IFCR_TEIF4_Msk = 0x8000
	// Bit TEIF4.
	DMA_IFCR_TEIF4 = 0x8000
	// Position of HTIF4 field.
	DMA_IFCR_HTIF4_Pos = 0xe
	// Bit mask of HTIF4 field.
	DMA_IFCR_HTIF4_Msk = 0x4000
	// Bit HTIF4.
	DMA_IFCR_HTIF4 = 0x4000
	// Position of TCIF4 field.
	DMA_IFCR_TCIF4_Pos = 0xd
	// Bit mask of TCIF4 field.
	DMA_IFCR_TCIF4_Msk = 0x2000
	// Bit TCIF4.
	DMA_IFCR_TCIF4 = 0x2000
	// Position of GIF4 field.
	DMA_IFCR_GIF4_Pos = 0xc
	// Bit mask of GIF4 field.
	DMA_IFCR_GIF4_Msk = 0x1000
	// Bit GIF4.
	DMA_IFCR_GIF4 = 0x1000
	// Position of TEIF3 field.
	DMA_IFCR_TEIF3_Pos = 0xb
	// Bit mask of TEIF3 field.
	DMA_IFCR_TEIF3_Msk = 0x800
	// Bit TEIF3.
	DMA_IFCR_TEIF3 = 0x800
	// Position of HTIF3 field.
	DMA_IFCR_HTIF3_Pos = 0xa
	// Bit mask of HTIF3 field.
	DMA_IFCR_HTIF3_Msk = 0x400
	// Bit HTIF3.
	DMA_IFCR_HTIF3 = 0x400
	// Position of TCIF3 field.
	DMA_IFCR_TCIF3_Pos = 0x9
	// Bit mask of TCIF3 field.
	DMA_IFCR_TCIF3_Msk = 0x200
	// Bit TCIF3.
	DMA_IFCR_TCIF3 = 0x200
	// Position of GIF3 field.
	DMA_IFCR_GIF3_Pos = 0x8
	// Bit mask of GIF3 field.
	DMA_IFCR_GIF3_Msk = 0x100
	// Bit GIF3.
	DMA_IFCR_GIF3 = 0x100
	// Position of TEIF2 field.
	DMA_IFCR_TEIF2_Pos = 0x7
	// Bit mask of TEIF2 field.
	DMA_IFCR_TEIF2_Msk = 0x80
	// Bit TEIF2.
	DMA_IFCR_TEIF2 = 0x80
	// Position of HTIF2 field.
	DMA_IFCR_HTIF2_Pos = 0x6
	// Bit mask of HTIF2 field.
	DMA_IFCR_HTIF2_Msk = 0x40
	// Bit HTIF2.
	DMA_IFCR_HTIF2 = 0x40
	// Position of TCIF2 field.
	DMA_IFCR_TCIF2_Pos = 0x5
	// Bit mask of TCIF2 field.
	DMA_IFCR_TCIF2_Msk = 0x20
	// Bit TCIF2.
	DMA_IFCR_TCIF2 = 0x20
	// Position of GIF2 field.
	DMA_IFCR_GIF2_Pos = 0x4
	// Bit mask of GIF2 field.
	DMA_IFCR_GIF2_Msk = 0x10
	// Bit GIF2.
	DMA_IFCR_GIF2 = 0x10
	// Position of TEIF1 field.
	DMA_IFCR_TEIF1_Pos = 0x3
	// Bit mask of TEIF1 field.
	DMA_IFCR_TEIF1_Msk = 0x8
	// Bit TEIF1.
	DMA_IFCR_TEIF1 = 0x8
	// Position of HTIF1 field.
	DMA_IFCR_HTIF1_Pos = 0x2
	// Bit mask of HTIF1 field.
	DMA_IFCR_HTIF1_Msk = 0x4
	// Bit HTIF1.
	DMA_IFCR_HTIF1 = 0x4
	// Position of TCIF1 field.
	DMA_IFCR_TCIF1_Pos = 0x1
	// Bit mask of TCIF1 field.
	DMA_IFCR_TCIF1_Msk = 0x2
	// Bit TCIF1.
	DMA_IFCR_TCIF1 = 0x2
	// Position of GIF1 field.
	DMA_IFCR_GIF1_Pos = 0x0
	// Bit mask of GIF1 field.
	DMA_IFCR_GIF1_Msk = 0x1
	// Bit GIF1.
	DMA_IFCR_GIF1 = 0x1

	// CCR1: channel x configuration register
	// Position of PRIV field.
	DMA_CCR1_PRIV_Pos = 0x14
	// Bit mask of PRIV field.
	DMA_CCR1_PRIV_Msk = 0x100000
	// Bit PRIV.
	DMA_CCR1_PRIV = 0x100000
	// Position of DSEC field.
	DMA_CCR1_DSEC_Pos = 0x13
	// Bit mask of DSEC field.
	DMA_CCR1_DSEC_Msk = 0x80000
	// Bit DSEC.
	DMA_CCR1_DSEC = 0x80000
	// Position of SSEC field.
	DMA_CCR1_SSEC_Pos = 0x12
	// Bit mask of SSEC field.
	DMA_CCR1_SSEC_Msk = 0x40000
	// Bit SSEC.
	DMA_CCR1_SSEC = 0x40000
	// Position of SECM field.
	DMA_CCR1_SECM_Pos = 0x11
	// Bit mask of SECM field.
	DMA_CCR1_SECM_Msk = 0x20000
	// Bit SECM.
	DMA_CCR1_SECM = 0x20000
	// Position of MEM2MEM field.
	DMA_CCR1_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR1_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR1_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR1_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR1_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR1_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR1_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR1_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR1_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR1_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR1_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR1_MINC = 0x80
	// Position of PINC field.
	DMA_CCR1_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR1_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR1_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR1_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR1_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR1_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR1_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR1_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR1_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR1_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR1_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR1_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR1_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR1_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR1_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR1_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR1_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR1_TCIE = 0x2
	// Position of EN field.
	DMA_CCR1_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR1_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR1_EN = 0x1

	// CNDTR1: channel x number of data to transfer register
	// Position of NDT field.
	DMA_CNDTR1_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR1_NDT_Msk = 0x3ffff

	// CPAR1: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR1_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR1_PA_Msk = 0xffffffff

	// CMAR1: channel x memory address register
	// Position of MA field.
	DMA_CMAR1_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR1_MA_Msk = 0xffffffff

	// CCR2: channel x configuration register
	// Position of PRIV field.
	DMA_CCR2_PRIV_Pos = 0x14
	// Bit mask of PRIV field.
	DMA_CCR2_PRIV_Msk = 0x100000
	// Bit PRIV.
	DMA_CCR2_PRIV = 0x100000
	// Position of DSEC field.
	DMA_CCR2_DSEC_Pos = 0x13
	// Bit mask of DSEC field.
	DMA_CCR2_DSEC_Msk = 0x80000
	// Bit DSEC.
	DMA_CCR2_DSEC = 0x80000
	// Position of SSEC field.
	DMA_CCR2_SSEC_Pos = 0x12
	// Bit mask of SSEC field.
	DMA_CCR2_SSEC_Msk = 0x40000
	// Bit SSEC.
	DMA_CCR2_SSEC = 0x40000
	// Position of SECM field.
	DMA_CCR2_SECM_Pos = 0x11
	// Bit mask of SECM field.
	DMA_CCR2_SECM_Msk = 0x20000
	// Bit SECM.
	DMA_CCR2_SECM = 0x20000
	// Position of MEM2MEM field.
	DMA_CCR2_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR2_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR2_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR2_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR2_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR2_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR2_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR2_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR2_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR2_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR2_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR2_MINC = 0x80
	// Position of PINC field.
	DMA_CCR2_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR2_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR2_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR2_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR2_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR2_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR2_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR2_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR2_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR2_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR2_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR2_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR2_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR2_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR2_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR2_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR2_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR2_TCIE = 0x2
	// Position of EN field.
	DMA_CCR2_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR2_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR2_EN = 0x1

	// CNDTR2: channel x number of data to transfer register
	// Position of NDT field.
	DMA_CNDTR2_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR2_NDT_Msk = 0x3ffff

	// CPAR2: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR2_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR2_PA_Msk = 0xffffffff

	// CMAR2: channel x memory address register
	// Position of MA field.
	DMA_CMAR2_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR2_MA_Msk = 0xffffffff

	// CCR3: channel x configuration register
	// Position of PRIV field.
	DMA_CCR3_PRIV_Pos = 0x14
	// Bit mask of PRIV field.
	DMA_CCR3_PRIV_Msk = 0x100000
	// Bit PRIV.
	DMA_CCR3_PRIV = 0x100000
	// Position of DSEC field.
	DMA_CCR3_DSEC_Pos = 0x13
	// Bit mask of DSEC field.
	DMA_CCR3_DSEC_Msk = 0x80000
	// Bit DSEC.
	DMA_CCR3_DSEC = 0x80000
	// Position of SSEC field.
	DMA_CCR3_SSEC_Pos = 0x12
	// Bit mask of SSEC field.
	DMA_CCR3_SSEC_Msk = 0x40000
	// Bit SSEC.
	DMA_CCR3_SSEC = 0x40000
	// Position of SECM field.
	DMA_CCR3_SECM_Pos = 0x11
	// Bit mask of SECM field.
	DMA_CCR3_SECM_Msk = 0x20000
	// Bit SECM.
	DMA_CCR3_SECM = 0x20000
	// Position of MEM2MEM field.
	DMA_CCR3_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR3_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR3_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR3_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR3_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR3_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR3_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR3_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR3_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR3_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR3_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR3_MINC = 0x80
	// Position of PINC field.
	DMA_CCR3_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR3_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR3_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR3_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR3_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR3_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR3_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR3_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR3_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR3_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR3_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR3_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR3_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR3_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR3_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR3_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR3_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR3_TCIE = 0x2
	// Position of EN field.
	DMA_CCR3_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR3_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR3_EN = 0x1

	// CNDTR3: channel x number of data to transfer register
	// Position of NDT field.
	DMA_CNDTR3_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR3_NDT_Msk = 0x3ffff

	// CPAR3: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR3_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR3_PA_Msk = 0xffffffff

	// CMAR3: channel x memory address register
	// Position of MA field.
	DMA_CMAR3_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR3_MA_Msk = 0xffffffff

	// CCR4: channel x configuration register
	// Position of PRIV field.
	DMA_CCR4_PRIV_Pos = 0x14
	// Bit mask of PRIV field.
	DMA_CCR4_PRIV_Msk = 0x100000
	// Bit PRIV.
	DMA_CCR4_PRIV = 0x100000
	// Position of DSEC field.
	DMA_CCR4_DSEC_Pos = 0x13
	// Bit mask of DSEC field.
	DMA_CCR4_DSEC_Msk = 0x80000
	// Bit DSEC.
	DMA_CCR4_DSEC = 0x80000
	// Position of SSEC field.
	DMA_CCR4_SSEC_Pos = 0x12
	// Bit mask of SSEC field.
	DMA_CCR4_SSEC_Msk = 0x40000
	// Bit SSEC.
	DMA_CCR4_SSEC = 0x40000
	// Position of SECM field.
	DMA_CCR4_SECM_Pos = 0x11
	// Bit mask of SECM field.
	DMA_CCR4_SECM_Msk = 0x20000
	// Bit SECM.
	DMA_CCR4_SECM = 0x20000
	// Position of MEM2MEM field.
	DMA_CCR4_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR4_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR4_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR4_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR4_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR4_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR4_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR4_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR4_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR4_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR4_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR4_MINC = 0x80
	// Position of PINC field.
	DMA_CCR4_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR4_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR4_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR4_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR4_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR4_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR4_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR4_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR4_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR4_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR4_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR4_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR4_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR4_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR4_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR4_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR4_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR4_TCIE = 0x2
	// Position of EN field.
	DMA_CCR4_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR4_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR4_EN = 0x1

	// CNDTR4: channel x number of data to transfer register
	// Position of NDT field.
	DMA_CNDTR4_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR4_NDT_Msk = 0x3ffff

	// CPAR4: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR4_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR4_PA_Msk = 0xffffffff

	// CMAR4: channel x memory address register
	// Position of MA field.
	DMA_CMAR4_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR4_MA_Msk = 0xffffffff

	// CCR5: channel x configuration register
	// Position of PRIV field.
	DMA_CCR5_PRIV_Pos = 0x14
	// Bit mask of PRIV field.
	DMA_CCR5_PRIV_Msk = 0x100000
	// Bit PRIV.
	DMA_CCR5_PRIV = 0x100000
	// Position of DSEC field.
	DMA_CCR5_DSEC_Pos = 0x13
	// Bit mask of DSEC field.
	DMA_CCR5_DSEC_Msk = 0x80000
	// Bit DSEC.
	DMA_CCR5_DSEC = 0x80000
	// Position of SSEC field.
	DMA_CCR5_SSEC_Pos = 0x12
	// Bit mask of SSEC field.
	DMA_CCR5_SSEC_Msk = 0x40000
	// Bit SSEC.
	DMA_CCR5_SSEC = 0x40000
	// Position of SECM field.
	DMA_CCR5_SECM_Pos = 0x11
	// Bit mask of SECM field.
	DMA_CCR5_SECM_Msk = 0x20000
	// Bit SECM.
	DMA_CCR5_SECM = 0x20000
	// Position of MEM2MEM field.
	DMA_CCR5_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR5_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR5_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR5_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR5_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR5_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR5_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR5_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR5_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR5_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR5_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR5_MINC = 0x80
	// Position of PINC field.
	DMA_CCR5_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR5_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR5_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR5_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR5_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR5_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR5_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR5_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR5_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR5_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR5_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR5_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR5_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR5_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR5_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR5_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR5_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR5_TCIE = 0x2
	// Position of EN field.
	DMA_CCR5_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR5_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR5_EN = 0x1

	// CNDTR5: channel x number of data to transfer register
	// Position of NDT field.
	DMA_CNDTR5_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR5_NDT_Msk = 0x3ffff

	// CPAR5: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR5_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR5_PA_Msk = 0xffffffff

	// CMAR5: channel x memory address register
	// Position of MA field.
	DMA_CMAR5_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR5_MA_Msk = 0xffffffff

	// CCR6: channel x configuration register
	// Position of PRIV field.
	DMA_CCR6_PRIV_Pos = 0x14
	// Bit mask of PRIV field.
	DMA_CCR6_PRIV_Msk = 0x100000
	// Bit PRIV.
	DMA_CCR6_PRIV = 0x100000
	// Position of DSEC field.
	DMA_CCR6_DSEC_Pos = 0x13
	// Bit mask of DSEC field.
	DMA_CCR6_DSEC_Msk = 0x80000
	// Bit DSEC.
	DMA_CCR6_DSEC = 0x80000
	// Position of SSEC field.
	DMA_CCR6_SSEC_Pos = 0x12
	// Bit mask of SSEC field.
	DMA_CCR6_SSEC_Msk = 0x40000
	// Bit SSEC.
	DMA_CCR6_SSEC = 0x40000
	// Position of SECM field.
	DMA_CCR6_SECM_Pos = 0x11
	// Bit mask of SECM field.
	DMA_CCR6_SECM_Msk = 0x20000
	// Bit SECM.
	DMA_CCR6_SECM = 0x20000
	// Position of MEM2MEM field.
	DMA_CCR6_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR6_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR6_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR6_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR6_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR6_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR6_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR6_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR6_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR6_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR6_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR6_MINC = 0x80
	// Position of PINC field.
	DMA_CCR6_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR6_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR6_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR6_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR6_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR6_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR6_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR6_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR6_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR6_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR6_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR6_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR6_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR6_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR6_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR6_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR6_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR6_TCIE = 0x2
	// Position of EN field.
	DMA_CCR6_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR6_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR6_EN = 0x1

	// CNDTR6: channel x number of data to transfer register
	// Position of NDT field.
	DMA_CNDTR6_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR6_NDT_Msk = 0x3ffff

	// CPAR6: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR6_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR6_PA_Msk = 0xffffffff

	// CMAR6: channel x memory address register
	// Position of MA field.
	DMA_CMAR6_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR6_MA_Msk = 0xffffffff

	// CCR7: channel x configuration register
	// Position of PRIV field.
	DMA_CCR7_PRIV_Pos = 0x14
	// Bit mask of PRIV field.
	DMA_CCR7_PRIV_Msk = 0x100000
	// Bit PRIV.
	DMA_CCR7_PRIV = 0x100000
	// Position of DSEC field.
	DMA_CCR7_DSEC_Pos = 0x13
	// Bit mask of DSEC field.
	DMA_CCR7_DSEC_Msk = 0x80000
	// Bit DSEC.
	DMA_CCR7_DSEC = 0x80000
	// Position of SSEC field.
	DMA_CCR7_SSEC_Pos = 0x12
	// Bit mask of SSEC field.
	DMA_CCR7_SSEC_Msk = 0x40000
	// Bit SSEC.
	DMA_CCR7_SSEC = 0x40000
	// Position of SECM field.
	DMA_CCR7_SECM_Pos = 0x11
	// Bit mask of SECM field.
	DMA_CCR7_SECM_Msk = 0x20000
	// Bit SECM.
	DMA_CCR7_SECM = 0x20000
	// Position of MEM2MEM field.
	DMA_CCR7_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR7_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR7_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR7_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR7_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR7_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR7_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR7_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR7_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR7_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR7_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR7_MINC = 0x80
	// Position of PINC field.
	DMA_CCR7_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR7_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR7_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR7_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR7_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR7_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR7_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR7_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR7_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR7_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR7_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR7_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR7_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR7_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR7_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR7_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR7_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR7_TCIE = 0x2
	// Position of EN field.
	DMA_CCR7_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR7_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR7_EN = 0x1

	// CNDTR7: channel x number of data to transfer register
	// Position of NDT field.
	DMA_CNDTR7_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR7_NDT_Msk = 0x3ffff

	// CPAR7: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR7_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR7_PA_Msk = 0xffffffff

	// CMAR7: channel x memory address register
	// Position of MA field.
	DMA_CMAR7_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR7_MA_Msk = 0xffffffff
)

// Bitfields for DMAMUX: DMA request multiplexer
const (
	// C0CR: request line multiplexer channel x configuration register
	// Position of SYNC_ID field.
	DMAMUX_C0CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C0CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C0CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C0CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C0CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C0CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C0CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C0CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C0CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C0CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C0CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C0CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C0CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C0CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C0CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C0CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C0CR_DMAREQ_ID_Msk = 0xff

	// C1CR: request line multiplexer channel x configuration register
	// Position of SYNC_ID field.
	DMAMUX_C1CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C1CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C1CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C1CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C1CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C1CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C1CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C1CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C1CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C1CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C1CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C1CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C1CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C1CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C1CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C1CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C1CR_DMAREQ_ID_Msk = 0xff

	// C2CR: request line multiplexer channel x configuration register
	// Position of SYNC_ID field.
	DMAMUX_C2CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C2CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C2CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C2CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C2CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C2CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C2CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C2CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C2CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C2CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C2CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C2CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C2CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C2CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C2CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C2CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C2CR_DMAREQ_ID_Msk = 0xff

	// C3CR: request line multiplexer channel x configuration register
	// Position of SYNC_ID field.
	DMAMUX_C3CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C3CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C3CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C3CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C3CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C3CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C3CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C3CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C3CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C3CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C3CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C3CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C3CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C3CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C3CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C3CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C3CR_DMAREQ_ID_Msk = 0xff

	// C4CR: request line multiplexer channel x configuration register
	// Position of SYNC_ID field.
	DMAMUX_C4CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C4CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C4CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C4CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C4CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C4CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C4CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C4CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C4CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C4CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C4CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C4CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C4CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C4CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C4CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C4CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C4CR_DMAREQ_ID_Msk = 0xff

	// C5CR: request line multiplexer channel x configuration register
	// Position of SYNC_ID field.
	DMAMUX_C5CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C5CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C5CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C5CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C5CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C5CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C5CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C5CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C5CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C5CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C5CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C5CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C5CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C5CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C5CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C5CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C5CR_DMAREQ_ID_Msk = 0xff

	// C6CR: request line multiplexer channel x configuration register
	// Position of SYNC_ID field.
	DMAMUX_C6CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C6CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C6CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C6CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C6CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C6CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C6CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C6CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C6CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C6CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C6CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C6CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C6CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C6CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C6CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C6CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C6CR_DMAREQ_ID_Msk = 0xff

	// C7CR: request line multiplexer channel x configuration register
	// Position of SYNC_ID field.
	DMAMUX_C7CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C7CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C7CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C7CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C7CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C7CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C7CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C7CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C7CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C7CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C7CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C7CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C7CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C7CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C7CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C7CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C7CR_DMAREQ_ID_Msk = 0xff

	// C8CR: request line multiplexer channel x configuration register
	// Position of SYNC_ID field.
	DMAMUX_C8CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C8CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C8CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C8CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C8CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C8CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C8CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C8CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C8CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C8CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C8CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C8CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C8CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C8CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C8CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C8CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C8CR_DMAREQ_ID_Msk = 0xff

	// C9CR: request line multiplexer channel x configuration register
	// Position of SYNC_ID field.
	DMAMUX_C9CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C9CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C9CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C9CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C9CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C9CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C9CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C9CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C9CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C9CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C9CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C9CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C9CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C9CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C9CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C9CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C9CR_DMAREQ_ID_Msk = 0xff

	// C10CR: C10CR
	// Position of SYNC_ID field.
	DMAMUX_C10CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C10CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C10CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C10CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C10CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C10CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C10CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C10CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C10CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C10CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C10CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C10CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C10CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C10CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C10CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C10CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C10CR_DMAREQ_ID_Msk = 0xff

	// C11CR: C11CR
	// Position of SYNC_ID field.
	DMAMUX_C11CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C11CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C11CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C11CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C11CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C11CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C11CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C11CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C11CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C11CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C11CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C11CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C11CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C11CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C11CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C11CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C11CR_DMAREQ_ID_Msk = 0xff

	// C12CR: C12CR
	// Position of SYNC_ID field.
	DMAMUX_C12CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C12CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C12CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C12CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C12CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C12CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C12CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C12CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C12CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C12CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C12CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C12CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C12CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C12CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C12CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C12CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C12CR_DMAREQ_ID_Msk = 0xff

	// C13CR: C13CR
	// Position of SYNC_ID field.
	DMAMUX_C13CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C13CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C13CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C13CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C13CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C13CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C13CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C13CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C13CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C13CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C13CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C13CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C13CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C13CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C13CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C13CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C13CR_DMAREQ_ID_Msk = 0xff

	// CSR: request line multiplexer interrupt channel status register
	// Position of SOF13 field.
	DMAMUX_CSR_SOF13_Pos = 0xd
	// Bit mask of SOF13 field.
	DMAMUX_CSR_SOF13_Msk = 0x2000
	// Bit SOF13.
	DMAMUX_CSR_SOF13 = 0x2000
	// Position of SOF12 field.
	DMAMUX_CSR_SOF12_Pos = 0xc
	// Bit mask of SOF12 field.
	DMAMUX_CSR_SOF12_Msk = 0x1000
	// Bit SOF12.
	DMAMUX_CSR_SOF12 = 0x1000
	// Position of SOF11 field.
	DMAMUX_CSR_SOF11_Pos = 0xb
	// Bit mask of SOF11 field.
	DMAMUX_CSR_SOF11_Msk = 0x800
	// Bit SOF11.
	DMAMUX_CSR_SOF11 = 0x800
	// Position of SOF10 field.
	DMAMUX_CSR_SOF10_Pos = 0xa
	// Bit mask of SOF10 field.
	DMAMUX_CSR_SOF10_Msk = 0x400
	// Bit SOF10.
	DMAMUX_CSR_SOF10 = 0x400
	// Position of SOF9 field.
	DMAMUX_CSR_SOF9_Pos = 0x9
	// Bit mask of SOF9 field.
	DMAMUX_CSR_SOF9_Msk = 0x200
	// Bit SOF9.
	DMAMUX_CSR_SOF9 = 0x200
	// Position of SOF8 field.
	DMAMUX_CSR_SOF8_Pos = 0x8
	// Bit mask of SOF8 field.
	DMAMUX_CSR_SOF8_Msk = 0x100
	// Bit SOF8.
	DMAMUX_CSR_SOF8 = 0x100
	// Position of SOF7 field.
	DMAMUX_CSR_SOF7_Pos = 0x7
	// Bit mask of SOF7 field.
	DMAMUX_CSR_SOF7_Msk = 0x80
	// Bit SOF7.
	DMAMUX_CSR_SOF7 = 0x80
	// Position of SOF6 field.
	DMAMUX_CSR_SOF6_Pos = 0x6
	// Bit mask of SOF6 field.
	DMAMUX_CSR_SOF6_Msk = 0x40
	// Bit SOF6.
	DMAMUX_CSR_SOF6 = 0x40
	// Position of SOF5 field.
	DMAMUX_CSR_SOF5_Pos = 0x5
	// Bit mask of SOF5 field.
	DMAMUX_CSR_SOF5_Msk = 0x20
	// Bit SOF5.
	DMAMUX_CSR_SOF5 = 0x20
	// Position of SOF4 field.
	DMAMUX_CSR_SOF4_Pos = 0x4
	// Bit mask of SOF4 field.
	DMAMUX_CSR_SOF4_Msk = 0x10
	// Bit SOF4.
	DMAMUX_CSR_SOF4 = 0x10
	// Position of SOF3 field.
	DMAMUX_CSR_SOF3_Pos = 0x3
	// Bit mask of SOF3 field.
	DMAMUX_CSR_SOF3_Msk = 0x8
	// Bit SOF3.
	DMAMUX_CSR_SOF3 = 0x8
	// Position of SOF2 field.
	DMAMUX_CSR_SOF2_Pos = 0x2
	// Bit mask of SOF2 field.
	DMAMUX_CSR_SOF2_Msk = 0x4
	// Bit SOF2.
	DMAMUX_CSR_SOF2 = 0x4
	// Position of SOF1 field.
	DMAMUX_CSR_SOF1_Pos = 0x1
	// Bit mask of SOF1 field.
	DMAMUX_CSR_SOF1_Msk = 0x2
	// Bit SOF1.
	DMAMUX_CSR_SOF1 = 0x2
	// Position of SOF0 field.
	DMAMUX_CSR_SOF0_Pos = 0x0
	// Bit mask of SOF0 field.
	DMAMUX_CSR_SOF0_Msk = 0x1
	// Bit SOF0.
	DMAMUX_CSR_SOF0 = 0x1

	// CCFR: request line multiplexer interrupt channel clear flag register
	// Position of CSOF13 field.
	DMAMUX_CCFR_CSOF13_Pos = 0xd
	// Bit mask of CSOF13 field.
	DMAMUX_CCFR_CSOF13_Msk = 0x2000
	// Bit CSOF13.
	DMAMUX_CCFR_CSOF13 = 0x2000
	// Position of CSOF12 field.
	DMAMUX_CCFR_CSOF12_Pos = 0xc
	// Bit mask of CSOF12 field.
	DMAMUX_CCFR_CSOF12_Msk = 0x1000
	// Bit CSOF12.
	DMAMUX_CCFR_CSOF12 = 0x1000
	// Position of CSOF11 field.
	DMAMUX_CCFR_CSOF11_Pos = 0xb
	// Bit mask of CSOF11 field.
	DMAMUX_CCFR_CSOF11_Msk = 0x800
	// Bit CSOF11.
	DMAMUX_CCFR_CSOF11 = 0x800
	// Position of CSOF10 field.
	DMAMUX_CCFR_CSOF10_Pos = 0xa
	// Bit mask of CSOF10 field.
	DMAMUX_CCFR_CSOF10_Msk = 0x400
	// Bit CSOF10.
	DMAMUX_CCFR_CSOF10 = 0x400
	// Position of CSOF9 field.
	DMAMUX_CCFR_CSOF9_Pos = 0x9
	// Bit mask of CSOF9 field.
	DMAMUX_CCFR_CSOF9_Msk = 0x200
	// Bit CSOF9.
	DMAMUX_CCFR_CSOF9 = 0x200
	// Position of CSOF8 field.
	DMAMUX_CCFR_CSOF8_Pos = 0x8
	// Bit mask of CSOF8 field.
	DMAMUX_CCFR_CSOF8_Msk = 0x100
	// Bit CSOF8.
	DMAMUX_CCFR_CSOF8 = 0x100
	// Position of CSOF7 field.
	DMAMUX_CCFR_CSOF7_Pos = 0x7
	// Bit mask of CSOF7 field.
	DMAMUX_CCFR_CSOF7_Msk = 0x80
	// Bit CSOF7.
	DMAMUX_CCFR_CSOF7 = 0x80
	// Position of CSOF6 field.
	DMAMUX_CCFR_CSOF6_Pos = 0x6
	// Bit mask of CSOF6 field.
	DMAMUX_CCFR_CSOF6_Msk = 0x40
	// Bit CSOF6.
	DMAMUX_CCFR_CSOF6 = 0x40
	// Position of CSOF5 field.
	DMAMUX_CCFR_CSOF5_Pos = 0x5
	// Bit mask of CSOF5 field.
	DMAMUX_CCFR_CSOF5_Msk = 0x20
	// Bit CSOF5.
	DMAMUX_CCFR_CSOF5 = 0x20
	// Position of CSOF4 field.
	DMAMUX_CCFR_CSOF4_Pos = 0x4
	// Bit mask of CSOF4 field.
	DMAMUX_CCFR_CSOF4_Msk = 0x10
	// Bit CSOF4.
	DMAMUX_CCFR_CSOF4 = 0x10
	// Position of CSOF3 field.
	DMAMUX_CCFR_CSOF3_Pos = 0x3
	// Bit mask of CSOF3 field.
	DMAMUX_CCFR_CSOF3_Msk = 0x8
	// Bit CSOF3.
	DMAMUX_CCFR_CSOF3 = 0x8
	// Position of CSOF2 field.
	DMAMUX_CCFR_CSOF2_Pos = 0x2
	// Bit mask of CSOF2 field.
	DMAMUX_CCFR_CSOF2_Msk = 0x4
	// Bit CSOF2.
	DMAMUX_CCFR_CSOF2 = 0x4
	// Position of CSOF1 field.
	DMAMUX_CCFR_CSOF1_Pos = 0x1
	// Bit mask of CSOF1 field.
	DMAMUX_CCFR_CSOF1_Msk = 0x2
	// Bit CSOF1.
	DMAMUX_CCFR_CSOF1 = 0x2
	// Position of CSOF0 field.
	DMAMUX_CCFR_CSOF0_Pos = 0x0
	// Bit mask of CSOF0 field.
	DMAMUX_CCFR_CSOF0_Msk = 0x1
	// Bit CSOF0.
	DMAMUX_CCFR_CSOF0 = 0x1

	// RG0CR: request generator channel x configuration register
	// Position of GNBREQ field.
	DMAMUX_RG0CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG0CR_GNBREQ_Msk = 0xf80000
	// Position of GPOL field.
	DMAMUX_RG0CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG0CR_GPOL_Msk = 0x60000
	// Position of GE field.
	DMAMUX_RG0CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG0CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG0CR_GE = 0x10000
	// Position of OIE field.
	DMAMUX_RG0CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG0CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG0CR_OIE = 0x100
	// Position of SIG_ID field.
	DMAMUX_RG0CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG0CR_SIG_ID_Msk = 0x1f

	// RG1CR: request generator channel x configuration register
	// Position of GNBREQ field.
	DMAMUX_RG1CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG1CR_GNBREQ_Msk = 0xf80000
	// Position of GPOL field.
	DMAMUX_RG1CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG1CR_GPOL_Msk = 0x60000
	// Position of GE field.
	DMAMUX_RG1CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG1CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG1CR_GE = 0x10000
	// Position of OIE field.
	DMAMUX_RG1CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG1CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG1CR_OIE = 0x100
	// Position of SIG_ID field.
	DMAMUX_RG1CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG1CR_SIG_ID_Msk = 0x1f

	// RG2CR: request generator channel x configuration register
	// Position of GNBREQ field.
	DMAMUX_RG2CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG2CR_GNBREQ_Msk = 0xf80000
	// Position of GPOL field.
	DMAMUX_RG2CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG2CR_GPOL_Msk = 0x60000
	// Position of GE field.
	DMAMUX_RG2CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG2CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG2CR_GE = 0x10000
	// Position of OIE field.
	DMAMUX_RG2CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG2CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG2CR_OIE = 0x100
	// Position of SIG_ID field.
	DMAMUX_RG2CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG2CR_SIG_ID_Msk = 0x1f

	// RG3CR: request generator channel x configuration register
	// Position of GNBREQ field.
	DMAMUX_RG3CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG3CR_GNBREQ_Msk = 0xf80000
	// Position of GPOL field.
	DMAMUX_RG3CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG3CR_GPOL_Msk = 0x60000
	// Position of GE field.
	DMAMUX_RG3CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG3CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG3CR_GE = 0x10000
	// Position of OIE field.
	DMAMUX_RG3CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG3CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG3CR_OIE = 0x100
	// Position of SIG_ID field.
	DMAMUX_RG3CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG3CR_SIG_ID_Msk = 0x1f

	// RGSR: request generator interrupt status register
	// Position of OF3 field.
	DMAMUX_RGSR_OF3_Pos = 0x3
	// Bit mask of OF3 field.
	DMAMUX_RGSR_OF3_Msk = 0x8
	// Bit OF3.
	DMAMUX_RGSR_OF3 = 0x8
	// Position of OF2 field.
	DMAMUX_RGSR_OF2_Pos = 0x2
	// Bit mask of OF2 field.
	DMAMUX_RGSR_OF2_Msk = 0x4
	// Bit OF2.
	DMAMUX_RGSR_OF2 = 0x4
	// Position of OF1 field.
	DMAMUX_RGSR_OF1_Pos = 0x1
	// Bit mask of OF1 field.
	DMAMUX_RGSR_OF1_Msk = 0x2
	// Bit OF1.
	DMAMUX_RGSR_OF1 = 0x2
	// Position of OF0 field.
	DMAMUX_RGSR_OF0_Pos = 0x0
	// Bit mask of OF0 field.
	DMAMUX_RGSR_OF0_Msk = 0x1
	// Bit OF0.
	DMAMUX_RGSR_OF0 = 0x1

	// RGCFR: request generator interrupt clear flag register
	// Position of COF3 field.
	DMAMUX_RGCFR_COF3_Pos = 0x3
	// Bit mask of COF3 field.
	DMAMUX_RGCFR_COF3_Msk = 0x8
	// Bit COF3.
	DMAMUX_RGCFR_COF3 = 0x8
	// Position of COF2 field.
	DMAMUX_RGCFR_COF2_Pos = 0x2
	// Bit mask of COF2 field.
	DMAMUX_RGCFR_COF2_Msk = 0x4
	// Bit COF2.
	DMAMUX_RGCFR_COF2 = 0x4
	// Position of COF1 field.
	DMAMUX_RGCFR_COF1_Pos = 0x1
	// Bit mask of COF1 field.
	DMAMUX_RGCFR_COF1_Msk = 0x2
	// Bit COF1.
	DMAMUX_RGCFR_COF1 = 0x2
	// Position of COF0 field.
	DMAMUX_RGCFR_COF0_Pos = 0x0
	// Bit mask of COF0 field.
	DMAMUX_RGCFR_COF0_Msk = 0x1
	// Bit COF0.
	DMAMUX_RGCFR_COF0 = 0x1
)

// Bitfields for EXTI: External interrupt/event controller
const (
	// RTSR1: rising trigger selection register
	// Position of RT field.
	EXTI_RTSR1_RT_Pos = 0x0
	// Bit mask of RT field.
	EXTI_RTSR1_RT_Msk = 0x1ffff
	// Position of RT21 field.
	EXTI_RTSR1_RT21_Pos = 0x15
	// Bit mask of RT21 field.
	EXTI_RTSR1_RT21_Msk = 0x600000

	// FTSR1: falling trigger selection register
	// Position of FT field.
	EXTI_FTSR1_FT_Pos = 0x0
	// Bit mask of FT field.
	EXTI_FTSR1_FT_Msk = 0x1ffff
	// Position of FT21 field.
	EXTI_FTSR1_FT21_Pos = 0x15
	// Bit mask of FT21 field.
	EXTI_FTSR1_FT21_Msk = 0x600000

	// SWIER1: software interrupt event register
	// Position of SWI field.
	EXTI_SWIER1_SWI_Pos = 0x0
	// Bit mask of SWI field.
	EXTI_SWIER1_SWI_Msk = 0x1ffff
	// Position of SWI21 field.
	EXTI_SWIER1_SWI21_Pos = 0x15
	// Bit mask of SWI21 field.
	EXTI_SWIER1_SWI21_Msk = 0x600000

	// PR1: EXTI pending register
	// Position of PIF field.
	EXTI_PR1_PIF_Pos = 0x0
	// Bit mask of PIF field.
	EXTI_PR1_PIF_Msk = 0x1ffff
	// Position of PIF21 field.
	EXTI_PR1_PIF21_Pos = 0x15
	// Bit mask of PIF21 field.
	EXTI_PR1_PIF21_Msk = 0x600000

	// RTSR2: rising trigger selection register
	// Position of RT34 field.
	EXTI_RTSR2_RT34_Pos = 0x2
	// Bit mask of RT34 field.
	EXTI_RTSR2_RT34_Msk = 0x4
	// Bit RT34.
	EXTI_RTSR2_RT34 = 0x4
	// Position of RT40 field.
	EXTI_RTSR2_RT40_Pos = 0x8
	// Bit mask of RT40 field.
	EXTI_RTSR2_RT40_Msk = 0x100
	// Bit RT40.
	EXTI_RTSR2_RT40 = 0x100
	// Position of RT41 field.
	EXTI_RTSR2_RT41_Pos = 0x9
	// Bit mask of RT41 field.
	EXTI_RTSR2_RT41_Msk = 0x200
	// Bit RT41.
	EXTI_RTSR2_RT41 = 0x200
	// Position of RT45 field.
	EXTI_RTSR2_RT45_Pos = 0xd
	// Bit mask of RT45 field.
	EXTI_RTSR2_RT45_Msk = 0x2000
	// Bit RT45.
	EXTI_RTSR2_RT45 = 0x2000

	// FTSR2: falling trigger selection register
	// Position of FT34 field.
	EXTI_FTSR2_FT34_Pos = 0x2
	// Bit mask of FT34 field.
	EXTI_FTSR2_FT34_Msk = 0x4
	// Bit FT34.
	EXTI_FTSR2_FT34 = 0x4
	// Position of FT40 field.
	EXTI_FTSR2_FT40_Pos = 0x8
	// Bit mask of FT40 field.
	EXTI_FTSR2_FT40_Msk = 0x100
	// Bit FT40.
	EXTI_FTSR2_FT40 = 0x100
	// Position of FT41 field.
	EXTI_FTSR2_FT41_Pos = 0x9
	// Bit mask of FT41 field.
	EXTI_FTSR2_FT41_Msk = 0x200
	// Bit FT41.
	EXTI_FTSR2_FT41 = 0x200
	// Position of FT45 field.
	EXTI_FTSR2_FT45_Pos = 0xd
	// Bit mask of FT45 field.
	EXTI_FTSR2_FT45_Msk = 0x2000
	// Bit FT45.
	EXTI_FTSR2_FT45 = 0x2000

	// SWIER2: software interrupt event register
	// Position of SWI34 field.
	EXTI_SWIER2_SWI34_Pos = 0x2
	// Bit mask of SWI34 field.
	EXTI_SWIER2_SWI34_Msk = 0x4
	// Bit SWI34.
	EXTI_SWIER2_SWI34 = 0x4
	// Position of SWI40 field.
	EXTI_SWIER2_SWI40_Pos = 0x8
	// Bit mask of SWI40 field.
	EXTI_SWIER2_SWI40_Msk = 0x100
	// Bit SWI40.
	EXTI_SWIER2_SWI40 = 0x100
	// Position of SWI41 field.
	EXTI_SWIER2_SWI41_Pos = 0x9
	// Bit mask of SWI41 field.
	EXTI_SWIER2_SWI41_Msk = 0x200
	// Bit SWI41.
	EXTI_SWIER2_SWI41 = 0x200
	// Position of SWI45 field.
	EXTI_SWIER2_SWI45_Pos = 0xd
	// Bit mask of SWI45 field.
	EXTI_SWIER2_SWI45_Msk = 0x2000
	// Bit SWI45.
	EXTI_SWIER2_SWI45 = 0x2000

	// PR2: pending register
	// Position of PIF34 field.
	EXTI_PR2_PIF34_Pos = 0x2
	// Bit mask of PIF34 field.
	EXTI_PR2_PIF34_Msk = 0x4
	// Bit PIF34.
	EXTI_PR2_PIF34 = 0x4
	// Position of PIF40 field.
	EXTI_PR2_PIF40_Pos = 0x8
	// Bit mask of PIF40 field.
	EXTI_PR2_PIF40_Msk = 0x100
	// Bit PIF40.
	EXTI_PR2_PIF40 = 0x100
	// Position of PIF41 field.
	EXTI_PR2_PIF41_Pos = 0x9
	// Bit mask of PIF41 field.
	EXTI_PR2_PIF41_Msk = 0x200
	// Bit PIF41.
	EXTI_PR2_PIF41 = 0x200
	// Position of PIF45 field.
	EXTI_PR2_PIF45_Pos = 0xd
	// Bit mask of PIF45 field.
	EXTI_PR2_PIF45_Msk = 0x2000
	// Bit PIF45.
	EXTI_PR2_PIF45 = 0x2000

	// C1IMR1: interrupt mask register
	// Position of IM field.
	EXTI_C1IMR1_IM_Pos = 0x0
	// Bit mask of IM field.
	EXTI_C1IMR1_IM_Msk = 0xffffffff

	// C1EMR1: event mask register
	// Position of EM0 field.
	EXTI_C1EMR1_EM0_Pos = 0x0
	// Bit mask of EM0 field.
	EXTI_C1EMR1_EM0_Msk = 0x1
	// Bit EM0.
	EXTI_C1EMR1_EM0 = 0x1
	// Position of EM1 field.
	EXTI_C1EMR1_EM1_Pos = 0x1
	// Bit mask of EM1 field.
	EXTI_C1EMR1_EM1_Msk = 0x2
	// Bit EM1.
	EXTI_C1EMR1_EM1 = 0x2
	// Position of EM2 field.
	EXTI_C1EMR1_EM2_Pos = 0x2
	// Bit mask of EM2 field.
	EXTI_C1EMR1_EM2_Msk = 0x4
	// Bit EM2.
	EXTI_C1EMR1_EM2 = 0x4
	// Position of EM3 field.
	EXTI_C1EMR1_EM3_Pos = 0x3
	// Bit mask of EM3 field.
	EXTI_C1EMR1_EM3_Msk = 0x8
	// Bit EM3.
	EXTI_C1EMR1_EM3 = 0x8
	// Position of EM4 field.
	EXTI_C1EMR1_EM4_Pos = 0x4
	// Bit mask of EM4 field.
	EXTI_C1EMR1_EM4_Msk = 0x10
	// Bit EM4.
	EXTI_C1EMR1_EM4 = 0x10
	// Position of EM5 field.
	EXTI_C1EMR1_EM5_Pos = 0x5
	// Bit mask of EM5 field.
	EXTI_C1EMR1_EM5_Msk = 0x20
	// Bit EM5.
	EXTI_C1EMR1_EM5 = 0x20
	// Position of EM6 field.
	EXTI_C1EMR1_EM6_Pos = 0x6
	// Bit mask of EM6 field.
	EXTI_C1EMR1_EM6_Msk = 0x40
	// Bit EM6.
	EXTI_C1EMR1_EM6 = 0x40
	// Position of EM7 field.
	EXTI_C1EMR1_EM7_Pos = 0x7
	// Bit mask of EM7 field.
	EXTI_C1EMR1_EM7_Msk = 0x80
	// Bit EM7.
	EXTI_C1EMR1_EM7 = 0x80
	// Position of EM8 field.
	EXTI_C1EMR1_EM8_Pos = 0x8
	// Bit mask of EM8 field.
	EXTI_C1EMR1_EM8_Msk = 0x100
	// Bit EM8.
	EXTI_C1EMR1_EM8 = 0x100
	// Position of EM9 field.
	EXTI_C1EMR1_EM9_Pos = 0x9
	// Bit mask of EM9 field.
	EXTI_C1EMR1_EM9_Msk = 0x200
	// Bit EM9.
	EXTI_C1EMR1_EM9 = 0x200
	// Position of EM10 field.
	EXTI_C1EMR1_EM10_Pos = 0xa
	// Bit mask of EM10 field.
	EXTI_C1EMR1_EM10_Msk = 0x400
	// Bit EM10.
	EXTI_C1EMR1_EM10 = 0x400
	// Position of EM11 field.
	EXTI_C1EMR1_EM11_Pos = 0xb
	// Bit mask of EM11 field.
	EXTI_C1EMR1_EM11_Msk = 0x800
	// Bit EM11.
	EXTI_C1EMR1_EM11 = 0x800
	// Position of EM12 field.
	EXTI_C1EMR1_EM12_Pos = 0xc
	// Bit mask of EM12 field.
	EXTI_C1EMR1_EM12_Msk = 0x1000
	// Bit EM12.
	EXTI_C1EMR1_EM12 = 0x1000
	// Position of EM13 field.
	EXTI_C1EMR1_EM13_Pos = 0xd
	// Bit mask of EM13 field.
	EXTI_C1EMR1_EM13_Msk = 0x2000
	// Bit EM13.
	EXTI_C1EMR1_EM13 = 0x2000
	// Position of EM14 field.
	EXTI_C1EMR1_EM14_Pos = 0xe
	// Bit mask of EM14 field.
	EXTI_C1EMR1_EM14_Msk = 0x4000
	// Bit EM14.
	EXTI_C1EMR1_EM14 = 0x4000
	// Position of EM15 field.
	EXTI_C1EMR1_EM15_Pos = 0xf
	// Bit mask of EM15 field.
	EXTI_C1EMR1_EM15_Msk = 0x8000
	// Bit EM15.
	EXTI_C1EMR1_EM15 = 0x8000
	// Position of EM17 field.
	EXTI_C1EMR1_EM17_Pos = 0x11
	// Bit mask of EM17 field.
	EXTI_C1EMR1_EM17_Msk = 0x20000
	// Bit EM17.
	EXTI_C1EMR1_EM17 = 0x20000
	// Position of EM18 field.
	EXTI_C1EMR1_EM18_Pos = 0x12
	// Bit mask of EM18 field.
	EXTI_C1EMR1_EM18_Msk = 0x40000
	// Bit EM18.
	EXTI_C1EMR1_EM18 = 0x40000
	// Position of EM19 field.
	EXTI_C1EMR1_EM19_Pos = 0x13
	// Bit mask of EM19 field.
	EXTI_C1EMR1_EM19_Msk = 0x80000
	// Bit EM19.
	EXTI_C1EMR1_EM19 = 0x80000
	// Position of EM20 field.
	EXTI_C1EMR1_EM20_Pos = 0x14
	// Bit mask of EM20 field.
	EXTI_C1EMR1_EM20_Msk = 0x100000
	// Bit EM20.
	EXTI_C1EMR1_EM20 = 0x100000
	// Position of EM21 field.
	EXTI_C1EMR1_EM21_Pos = 0x15
	// Bit mask of EM21 field.
	EXTI_C1EMR1_EM21_Msk = 0x200000
	// Bit EM21.
	EXTI_C1EMR1_EM21 = 0x200000
	// Position of EM22 field.
	EXTI_C1EMR1_EM22_Pos = 0x16
	// Bit mask of EM22 field.
	EXTI_C1EMR1_EM22_Msk = 0x400000
	// Bit EM22.
	EXTI_C1EMR1_EM22 = 0x400000

	// C1IMR2: wakeup with interrupt mask register
	// Position of IM34 field.
	EXTI_C1IMR2_IM34_Pos = 0x2
	// Bit mask of IM34 field.
	EXTI_C1IMR2_IM34_Msk = 0x4
	// Bit IM34.
	EXTI_C1IMR2_IM34 = 0x4
	// Position of IM36 field.
	EXTI_C1IMR2_IM36_Pos = 0x4
	// Bit mask of IM36 field.
	EXTI_C1IMR2_IM36_Msk = 0x10
	// Bit IM36.
	EXTI_C1IMR2_IM36 = 0x10
	// Position of IM37 field.
	EXTI_C1IMR2_IM37_Pos = 0x5
	// Bit mask of IM37 field.
	EXTI_C1IMR2_IM37_Msk = 0x20
	// Bit IM37.
	EXTI_C1IMR2_IM37 = 0x20
	// Position of IM38 field.
	EXTI_C1IMR2_IM38_Pos = 0x6
	// Bit mask of IM38 field.
	EXTI_C1IMR2_IM38_Msk = 0x40
	// Bit IM38.
	EXTI_C1IMR2_IM38 = 0x40
	// Position of IM39 field.
	EXTI_C1IMR2_IM39_Pos = 0x7
	// Bit mask of IM39 field.
	EXTI_C1IMR2_IM39_Msk = 0x80
	// Bit IM39.
	EXTI_C1IMR2_IM39 = 0x80
	// Position of IM40 field.
	EXTI_C1IMR2_IM40_Pos = 0x8
	// Bit mask of IM40 field.
	EXTI_C1IMR2_IM40_Msk = 0x100
	// Bit IM40.
	EXTI_C1IMR2_IM40 = 0x100
	// Position of IM41 field.
	EXTI_C1IMR2_IM41_Pos = 0x9
	// Bit mask of IM41 field.
	EXTI_C1IMR2_IM41_Msk = 0x200
	// Bit IM41.
	EXTI_C1IMR2_IM41 = 0x200
	// Position of IM42 field.
	EXTI_C1IMR2_IM42_Pos = 0xa
	// Bit mask of IM42 field.
	EXTI_C1IMR2_IM42_Msk = 0x400
	// Bit IM42.
	EXTI_C1IMR2_IM42 = 0x400
	// Position of IM43 field.
	EXTI_C1IMR2_IM43_Pos = 0xb
	// Bit mask of IM43 field.
	EXTI_C1IMR2_IM43_Msk = 0x800
	// Bit IM43.
	EXTI_C1IMR2_IM43 = 0x800
	// Position of IM44 field.
	EXTI_C1IMR2_IM44_Pos = 0xc
	// Bit mask of IM44 field.
	EXTI_C1IMR2_IM44_Msk = 0x1000
	// Bit IM44.
	EXTI_C1IMR2_IM44 = 0x1000
	// Position of IM45 field.
	EXTI_C1IMR2_IM45_Pos = 0xd
	// Bit mask of IM45 field.
	EXTI_C1IMR2_IM45_Msk = 0x2000
	// Bit IM45.
	EXTI_C1IMR2_IM45 = 0x2000
	// Position of IM46 field.
	EXTI_C1IMR2_IM46_Pos = 0xe
	// Bit mask of IM46 field.
	EXTI_C1IMR2_IM46_Msk = 0x4000
	// Bit IM46.
	EXTI_C1IMR2_IM46 = 0x4000

	// C1EMR2: wakeup with event mask register
	// Position of EM40 field.
	EXTI_C1EMR2_EM40_Pos = 0x8
	// Bit mask of EM40 field.
	EXTI_C1EMR2_EM40_Msk = 0x100
	// Bit EM40.
	EXTI_C1EMR2_EM40 = 0x100
	// Position of EM41 field.
	EXTI_C1EMR2_EM41_Pos = 0x9
	// Bit mask of EM41 field.
	EXTI_C1EMR2_EM41_Msk = 0x200
	// Bit EM41.
	EXTI_C1EMR2_EM41 = 0x200

	// C2IMR1: interrupt mask register
	// Position of IM field.
	EXTI_C2IMR1_IM_Pos = 0x0
	// Bit mask of IM field.
	EXTI_C2IMR1_IM_Msk = 0xffffffff

	// C2EMR1: event mask register
	// Position of EM0 field.
	EXTI_C2EMR1_EM0_Pos = 0x0
	// Bit mask of EM0 field.
	EXTI_C2EMR1_EM0_Msk = 0x1
	// Bit EM0.
	EXTI_C2EMR1_EM0 = 0x1
	// Position of EM1 field.
	EXTI_C2EMR1_EM1_Pos = 0x1
	// Bit mask of EM1 field.
	EXTI_C2EMR1_EM1_Msk = 0x2
	// Bit EM1.
	EXTI_C2EMR1_EM1 = 0x2
	// Position of EM2 field.
	EXTI_C2EMR1_EM2_Pos = 0x2
	// Bit mask of EM2 field.
	EXTI_C2EMR1_EM2_Msk = 0x4
	// Bit EM2.
	EXTI_C2EMR1_EM2 = 0x4
	// Position of EM3 field.
	EXTI_C2EMR1_EM3_Pos = 0x3
	// Bit mask of EM3 field.
	EXTI_C2EMR1_EM3_Msk = 0x8
	// Bit EM3.
	EXTI_C2EMR1_EM3 = 0x8
	// Position of EM4 field.
	EXTI_C2EMR1_EM4_Pos = 0x4
	// Bit mask of EM4 field.
	EXTI_C2EMR1_EM4_Msk = 0x10
	// Bit EM4.
	EXTI_C2EMR1_EM4 = 0x10
	// Position of EM5 field.
	EXTI_C2EMR1_EM5_Pos = 0x5
	// Bit mask of EM5 field.
	EXTI_C2EMR1_EM5_Msk = 0x20
	// Bit EM5.
	EXTI_C2EMR1_EM5 = 0x20
	// Position of EM6 field.
	EXTI_C2EMR1_EM6_Pos = 0x6
	// Bit mask of EM6 field.
	EXTI_C2EMR1_EM6_Msk = 0x40
	// Bit EM6.
	EXTI_C2EMR1_EM6 = 0x40
	// Position of EM7 field.
	EXTI_C2EMR1_EM7_Pos = 0x7
	// Bit mask of EM7 field.
	EXTI_C2EMR1_EM7_Msk = 0x80
	// Bit EM7.
	EXTI_C2EMR1_EM7 = 0x80
	// Position of EM8 field.
	EXTI_C2EMR1_EM8_Pos = 0x8
	// Bit mask of EM8 field.
	EXTI_C2EMR1_EM8_Msk = 0x100
	// Bit EM8.
	EXTI_C2EMR1_EM8 = 0x100
	// Position of EM9 field.
	EXTI_C2EMR1_EM9_Pos = 0x9
	// Bit mask of EM9 field.
	EXTI_C2EMR1_EM9_Msk = 0x200
	// Bit EM9.
	EXTI_C2EMR1_EM9 = 0x200
	// Position of EM10 field.
	EXTI_C2EMR1_EM10_Pos = 0xa
	// Bit mask of EM10 field.
	EXTI_C2EMR1_EM10_Msk = 0x400
	// Bit EM10.
	EXTI_C2EMR1_EM10 = 0x400
	// Position of EM11 field.
	EXTI_C2EMR1_EM11_Pos = 0xb
	// Bit mask of EM11 field.
	EXTI_C2EMR1_EM11_Msk = 0x800
	// Bit EM11.
	EXTI_C2EMR1_EM11 = 0x800
	// Position of EM12 field.
	EXTI_C2EMR1_EM12_Pos = 0xc
	// Bit mask of EM12 field.
	EXTI_C2EMR1_EM12_Msk = 0x1000
	// Bit EM12.
	EXTI_C2EMR1_EM12 = 0x1000
	// Position of EM13 field.
	EXTI_C2EMR1_EM13_Pos = 0xd
	// Bit mask of EM13 field.
	EXTI_C2EMR1_EM13_Msk = 0x2000
	// Bit EM13.
	EXTI_C2EMR1_EM13 = 0x2000
	// Position of EM14 field.
	EXTI_C2EMR1_EM14_Pos = 0xe
	// Bit mask of EM14 field.
	EXTI_C2EMR1_EM14_Msk = 0x4000
	// Bit EM14.
	EXTI_C2EMR1_EM14 = 0x4000
	// Position of EM15 field.
	EXTI_C2EMR1_EM15_Pos = 0xf
	// Bit mask of EM15 field.
	EXTI_C2EMR1_EM15_Msk = 0x8000
	// Bit EM15.
	EXTI_C2EMR1_EM15 = 0x8000
	// Position of EM17 field.
	EXTI_C2EMR1_EM17_Pos = 0x11
	// Bit mask of EM17 field.
	EXTI_C2EMR1_EM17_Msk = 0x20000
	// Bit EM17.
	EXTI_C2EMR1_EM17 = 0x20000
	// Position of EM18 field.
	EXTI_C2EMR1_EM18_Pos = 0x12
	// Bit mask of EM18 field.
	EXTI_C2EMR1_EM18_Msk = 0x40000
	// Bit EM18.
	EXTI_C2EMR1_EM18 = 0x40000
	// Position of EM19 field.
	EXTI_C2EMR1_EM19_Pos = 0x13
	// Bit mask of EM19 field.
	EXTI_C2EMR1_EM19_Msk = 0x80000
	// Bit EM19.
	EXTI_C2EMR1_EM19 = 0x80000
	// Position of EM20 field.
	EXTI_C2EMR1_EM20_Pos = 0x14
	// Bit mask of EM20 field.
	EXTI_C2EMR1_EM20_Msk = 0x100000
	// Bit EM20.
	EXTI_C2EMR1_EM20 = 0x100000
	// Position of EM21 field.
	EXTI_C2EMR1_EM21_Pos = 0x15
	// Bit mask of EM21 field.
	EXTI_C2EMR1_EM21_Msk = 0x200000
	// Bit EM21.
	EXTI_C2EMR1_EM21 = 0x200000
	// Position of EM22 field.
	EXTI_C2EMR1_EM22_Pos = 0x16
	// Bit mask of EM22 field.
	EXTI_C2EMR1_EM22_Msk = 0x400000
	// Bit EM22.
	EXTI_C2EMR1_EM22 = 0x400000

	// C2IMR2: wakeup with interrupt mask register
	// Position of IM34 field.
	EXTI_C2IMR2_IM34_Pos = 0x2
	// Bit mask of IM34 field.
	EXTI_C2IMR2_IM34_Msk = 0x4
	// Bit IM34.
	EXTI_C2IMR2_IM34 = 0x4
	// Position of IM36 field.
	EXTI_C2IMR2_IM36_Pos = 0x4
	// Bit mask of IM36 field.
	EXTI_C2IMR2_IM36_Msk = 0x10
	// Bit IM36.
	EXTI_C2IMR2_IM36 = 0x10
	// Position of IM37 field.
	EXTI_C2IMR2_IM37_Pos = 0x5
	// Bit mask of IM37 field.
	EXTI_C2IMR2_IM37_Msk = 0x20
	// Bit IM37.
	EXTI_C2IMR2_IM37 = 0x20
	// Position of IM38 field.
	EXTI_C2IMR2_IM38_Pos = 0x6
	// Bit mask of IM38 field.
	EXTI_C2IMR2_IM38_Msk = 0x40
	// Bit IM38.
	EXTI_C2IMR2_IM38 = 0x40
	// Position of IM39 field.
	EXTI_C2IMR2_IM39_Pos = 0x7
	// Bit mask of IM39 field.
	EXTI_C2IMR2_IM39_Msk = 0x80
	// Bit IM39.
	EXTI_C2IMR2_IM39 = 0x80
	// Position of IM40 field.
	EXTI_C2IMR2_IM40_Pos = 0x8
	// Bit mask of IM40 field.
	EXTI_C2IMR2_IM40_Msk = 0x100
	// Bit IM40.
	EXTI_C2IMR2_IM40 = 0x100
	// Position of IM41 field.
	EXTI_C2IMR2_IM41_Pos = 0x9
	// Bit mask of IM41 field.
	EXTI_C2IMR2_IM41_Msk = 0x200
	// Bit IM41.
	EXTI_C2IMR2_IM41 = 0x200
	// Position of IM42 field.
	EXTI_C2IMR2_IM42_Pos = 0xa
	// Bit mask of IM42 field.
	EXTI_C2IMR2_IM42_Msk = 0x400
	// Bit IM42.
	EXTI_C2IMR2_IM42 = 0x400
	// Position of IM43 field.
	EXTI_C2IMR2_IM43_Pos = 0xb
	// Bit mask of IM43 field.
	EXTI_C2IMR2_IM43_Msk = 0x800
	// Bit IM43.
	EXTI_C2IMR2_IM43 = 0x800
	// Position of IM44 field.
	EXTI_C2IMR2_IM44_Pos = 0xc
	// Bit mask of IM44 field.
	EXTI_C2IMR2_IM44_Msk = 0x1000
	// Bit IM44.
	EXTI_C2IMR2_IM44 = 0x1000
	// Position of IM45 field.
	EXTI_C2IMR2_IM45_Pos = 0xd
	// Bit mask of IM45 field.
	EXTI_C2IMR2_IM45_Msk = 0x2000
	// Bit IM45.
	EXTI_C2IMR2_IM45 = 0x2000
	// Position of IM46 field.
	EXTI_C2IMR2_IM46_Pos = 0xe
	// Bit mask of IM46 field.
	EXTI_C2IMR2_IM46_Msk = 0x4000
	// Bit IM46.
	EXTI_C2IMR2_IM46 = 0x4000

	// C2EMR2: wakeup with event mask register
	// Position of EM40 field.
	EXTI_C2EMR2_EM40_Pos = 0x8
	// Bit mask of EM40 field.
	EXTI_C2EMR2_EM40_Msk = 0x100
	// Bit EM40.
	EXTI_C2EMR2_EM40 = 0x100
	// Position of EM41 field.
	EXTI_C2EMR2_EM41_Pos = 0x9
	// Bit mask of EM41 field.
	EXTI_C2EMR2_EM41_Msk = 0x200
	// Bit EM41.
	EXTI_C2EMR2_EM41 = 0x200
)

// Bitfields for FLASH: Flash
const (
	// ACR: Access control register
	// Position of LATENCY field.
	Flash_ACR_LATENCY_Pos = 0x0
	// Bit mask of LATENCY field.
	Flash_ACR_LATENCY_Msk = 0x7
	// Position of PRFTEN field.
	Flash_ACR_PRFTEN_Pos = 0x8
	// Bit mask of PRFTEN field.
	Flash_ACR_PRFTEN_Msk = 0x100
	// Bit PRFTEN.
	Flash_ACR_PRFTEN = 0x100
	// Position of ICEN field.
	Flash_ACR_ICEN_Pos = 0x9
	// Bit mask of ICEN field.
	Flash_ACR_ICEN_Msk = 0x200
	// Bit ICEN.
	Flash_ACR_ICEN = 0x200
	// Position of DCEN field.
	Flash_ACR_DCEN_Pos = 0xa
	// Bit mask of DCEN field.
	Flash_ACR_DCEN_Msk = 0x400
	// Bit DCEN.
	Flash_ACR_DCEN = 0x400
	// Position of ICRST field.
	Flash_ACR_ICRST_Pos = 0xb
	// Bit mask of ICRST field.
	Flash_ACR_ICRST_Msk = 0x800
	// Bit ICRST.
	Flash_ACR_ICRST = 0x800
	// Position of DCRST field.
	Flash_ACR_DCRST_Pos = 0xc
	// Bit mask of DCRST field.
	Flash_ACR_DCRST_Msk = 0x1000
	// Bit DCRST.
	Flash_ACR_DCRST = 0x1000
	// Position of PES field.
	Flash_ACR_PES_Pos = 0xf
	// Bit mask of PES field.
	Flash_ACR_PES_Msk = 0x8000
	// Bit PES.
	Flash_ACR_PES = 0x8000
	// Position of EMPTY field.
	Flash_ACR_EMPTY_Pos = 0x10
	// Bit mask of EMPTY field.
	Flash_ACR_EMPTY_Msk = 0x10000
	// Bit EMPTY.
	Flash_ACR_EMPTY = 0x10000

	// ACR2: Flash access control register 2
	// Position of PRIVMODE field.
	Flash_ACR2_PRIVMODE_Pos = 0x0
	// Bit mask of PRIVMODE field.
	Flash_ACR2_PRIVMODE_Msk = 0x1
	// Bit PRIVMODE.
	Flash_ACR2_PRIVMODE = 0x1
	// Position of HDPADIS field.
	Flash_ACR2_HDPADIS_Pos = 0x1
	// Bit mask of HDPADIS field.
	Flash_ACR2_HDPADIS_Msk = 0x2
	// Bit HDPADIS.
	Flash_ACR2_HDPADIS = 0x2
	// Position of C2SWDBGEN field.
	Flash_ACR2_C2SWDBGEN_Pos = 0x2
	// Bit mask of C2SWDBGEN field.
	Flash_ACR2_C2SWDBGEN_Msk = 0x4
	// Bit C2SWDBGEN.
	Flash_ACR2_C2SWDBGEN = 0x4

	// KEYR: Flash key register
	// Position of KEY field.
	Flash_KEYR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	Flash_KEYR_KEY_Msk = 0xffffffff

	// OPTKEYR: Option byte key register
	// Position of OPTKEY field.
	Flash_OPTKEYR_OPTKEY_Pos = 0x0
	// Bit mask of OPTKEY field.
	Flash_OPTKEYR_OPTKEY_Msk = 0xffffffff

	// SR: Status register
	// Position of EOP field.
	Flash_SR_EOP_Pos = 0x0
	// Bit mask of EOP field.
	Flash_SR_EOP_Msk = 0x1
	// Bit EOP.
	Flash_SR_EOP = 0x1
	// Position of OPERR field.
	Flash_SR_OPERR_Pos = 0x1
	// Bit mask of OPERR field.
	Flash_SR_OPERR_Msk = 0x2
	// Bit OPERR.
	Flash_SR_OPERR = 0x2
	// Position of PROGERR field.
	Flash_SR_PROGERR_Pos = 0x3
	// Bit mask of PROGERR field.
	Flash_SR_PROGERR_Msk = 0x8
	// Bit PROGERR.
	Flash_SR_PROGERR = 0x8
	// Position of WRPERR field.
	Flash_SR_WRPERR_Pos = 0x4
	// Bit mask of WRPERR field.
	Flash_SR_WRPERR_Msk = 0x10
	// Bit WRPERR.
	Flash_SR_WRPERR = 0x10
	// Position of PGAERR field.
	Flash_SR_PGAERR_Pos = 0x5
	// Bit mask of PGAERR field.
	Flash_SR_PGAERR_Msk = 0x20
	// Bit PGAERR.
	Flash_SR_PGAERR = 0x20
	// Position of SIZERR field.
	Flash_SR_SIZERR_Pos = 0x6
	// Bit mask of SIZERR field.
	Flash_SR_SIZERR_Msk = 0x40
	// Bit SIZERR.
	Flash_SR_SIZERR = 0x40
	// Position of PGSERR field.
	Flash_SR_PGSERR_Pos = 0x7
	// Bit mask of PGSERR field.
	Flash_SR_PGSERR_Msk = 0x80
	// Bit PGSERR.
	Flash_SR_PGSERR = 0x80
	// Position of MISERR field.
	Flash_SR_MISERR_Pos = 0x8
	// Bit mask of MISERR field.
	Flash_SR_MISERR_Msk = 0x100
	// Bit MISERR.
	Flash_SR_MISERR = 0x100
	// Position of FASTERR field.
	Flash_SR_FASTERR_Pos = 0x9
	// Bit mask of FASTERR field.
	Flash_SR_FASTERR_Msk = 0x200
	// Bit FASTERR.
	Flash_SR_FASTERR = 0x200
	// Position of OPTVN field.
	Flash_SR_OPTVN_Pos = 0xd
	// Bit mask of OPTVN field.
	Flash_SR_OPTVN_Msk = 0x2000
	// Bit OPTVN.
	Flash_SR_OPTVN = 0x2000
	// Position of RDERR field.
	Flash_SR_RDERR_Pos = 0xe
	// Bit mask of RDERR field.
	Flash_SR_RDERR_Msk = 0x4000
	// Bit RDERR.
	Flash_SR_RDERR = 0x4000
	// Position of OPTVERR field.
	Flash_SR_OPTVERR_Pos = 0xf
	// Bit mask of OPTVERR field.
	Flash_SR_OPTVERR_Msk = 0x8000
	// Bit OPTVERR.
	Flash_SR_OPTVERR = 0x8000
	// Position of BSY field.
	Flash_SR_BSY_Pos = 0x10
	// Bit mask of BSY field.
	Flash_SR_BSY_Msk = 0x10000
	// Bit BSY.
	Flash_SR_BSY = 0x10000
	// Position of CFGBSY field.
	Flash_SR_CFGBSY_Pos = 0x12
	// Bit mask of CFGBSY field.
	Flash_SR_CFGBSY_Msk = 0x40000
	// Bit CFGBSY.
	Flash_SR_CFGBSY = 0x40000
	// Position of PESD field.
	Flash_SR_PESD_Pos = 0x13
	// Bit mask of PESD field.
	Flash_SR_PESD_Msk = 0x80000
	// Bit PESD.
	Flash_SR_PESD = 0x80000

	// CR: Flash control register
	// Position of PG field.
	Flash_CR_PG_Pos = 0x0
	// Bit mask of PG field.
	Flash_CR_PG_Msk = 0x1
	// Bit PG.
	Flash_CR_PG = 0x1
	// Position of PER field.
	Flash_CR_PER_Pos = 0x1
	// Bit mask of PER field.
	Flash_CR_PER_Msk = 0x2
	// Bit PER.
	Flash_CR_PER = 0x2
	// Position of MER field.
	Flash_CR_MER_Pos = 0x2
	// Bit mask of MER field.
	Flash_CR_MER_Msk = 0x4
	// Bit MER.
	Flash_CR_MER = 0x4
	// Position of PNB field.
	Flash_CR_PNB_Pos = 0x3
	// Bit mask of PNB field.
	Flash_CR_PNB_Msk = 0x3f8
	// Position of STRT field.
	Flash_CR_STRT_Pos = 0x10
	// Bit mask of STRT field.
	Flash_CR_STRT_Msk = 0x10000
	// Bit STRT.
	Flash_CR_STRT = 0x10000
	// Position of OPTSTRT field.
	Flash_CR_OPTSTRT_Pos = 0x11
	// Bit mask of OPTSTRT field.
	Flash_CR_OPTSTRT_Msk = 0x20000
	// Bit OPTSTRT.
	Flash_CR_OPTSTRT = 0x20000
	// Position of FSTPG field.
	Flash_CR_FSTPG_Pos = 0x12
	// Bit mask of FSTPG field.
	Flash_CR_FSTPG_Msk = 0x40000
	// Bit FSTPG.
	Flash_CR_FSTPG = 0x40000
	// Position of EOPIE field.
	Flash_CR_EOPIE_Pos = 0x18
	// Bit mask of EOPIE field.
	Flash_CR_EOPIE_Msk = 0x1000000
	// Bit EOPIE.
	Flash_CR_EOPIE = 0x1000000
	// Position of ERRIE field.
	Flash_CR_ERRIE_Pos = 0x19
	// Bit mask of ERRIE field.
	Flash_CR_ERRIE_Msk = 0x2000000
	// Bit ERRIE.
	Flash_CR_ERRIE = 0x2000000
	// Position of RDERRIE field.
	Flash_CR_RDERRIE_Pos = 0x1a
	// Bit mask of RDERRIE field.
	Flash_CR_RDERRIE_Msk = 0x4000000
	// Bit RDERRIE.
	Flash_CR_RDERRIE = 0x4000000
	// Position of OBL_LAUNCH field.
	Flash_CR_OBL_LAUNCH_Pos = 0x1b
	// Bit mask of OBL_LAUNCH field.
	Flash_CR_OBL_LAUNCH_Msk = 0x8000000
	// Bit OBL_LAUNCH.
	Flash_CR_OBL_LAUNCH = 0x8000000
	// Position of OPTLOCK field.
	Flash_CR_OPTLOCK_Pos = 0x1e
	// Bit mask of OPTLOCK field.
	Flash_CR_OPTLOCK_Msk = 0x40000000
	// Bit OPTLOCK.
	Flash_CR_OPTLOCK = 0x40000000
	// Position of LOCK field.
	Flash_CR_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Flash_CR_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Flash_CR_LOCK = 0x80000000

	// ECCR: Flash ECC register
	// Position of ADDR_ECC field.
	Flash_ECCR_ADDR_ECC_Pos = 0x0
	// Bit mask of ADDR_ECC field.
	Flash_ECCR_ADDR_ECC_Msk = 0x1ffff
	// Position of SYSF_ECC field.
	Flash_ECCR_SYSF_ECC_Pos = 0x14
	// Bit mask of SYSF_ECC field.
	Flash_ECCR_SYSF_ECC_Msk = 0x100000
	// Bit SYSF_ECC.
	Flash_ECCR_SYSF_ECC = 0x100000
	// Position of ECCCIE field.
	Flash_ECCR_ECCCIE_Pos = 0x18
	// Bit mask of ECCCIE field.
	Flash_ECCR_ECCCIE_Msk = 0x1000000
	// Bit ECCCIE.
	Flash_ECCR_ECCCIE = 0x1000000
	// Position of CPUID field.
	Flash_ECCR_CPUID_Pos = 0x1a
	// Bit mask of CPUID field.
	Flash_ECCR_CPUID_Msk = 0x1c000000
	// Position of ECCC field.
	Flash_ECCR_ECCC_Pos = 0x1e
	// Bit mask of ECCC field.
	Flash_ECCR_ECCC_Msk = 0x40000000
	// Bit ECCC.
	Flash_ECCR_ECCC = 0x40000000
	// Position of ECCD field.
	Flash_ECCR_ECCD_Pos = 0x1f
	// Bit mask of ECCD field.
	Flash_ECCR_ECCD_Msk = 0x80000000
	// Bit ECCD.
	Flash_ECCR_ECCD = 0x80000000

	// OPTR: Flash option register
	// Position of RDP field.
	Flash_OPTR_RDP_Pos = 0x0
	// Bit mask of RDP field.
	Flash_OPTR_RDP_Msk = 0xff
	// Position of ESE field.
	Flash_OPTR_ESE_Pos = 0x8
	// Bit mask of ESE field.
	Flash_OPTR_ESE_Msk = 0x100
	// Bit ESE.
	Flash_OPTR_ESE = 0x100
	// Position of BOR_LEV field.
	Flash_OPTR_BOR_LEV_Pos = 0x9
	// Bit mask of BOR_LEV field.
	Flash_OPTR_BOR_LEV_Msk = 0xe00
	// Position of NRST_STOP field.
	Flash_OPTR_NRST_STOP_Pos = 0xc
	// Bit mask of NRST_STOP field.
	Flash_OPTR_NRST_STOP_Msk = 0x1000
	// Bit NRST_STOP.
	Flash_OPTR_NRST_STOP = 0x1000
	// Position of NRST_STDBY field.
	Flash_OPTR_NRST_STDBY_Pos = 0xd
	// Bit mask of NRST_STDBY field.
	Flash_OPTR_NRST_STDBY_Msk = 0x2000
	// Bit NRST_STDBY.
	Flash_OPTR_NRST_STDBY = 0x2000
	// Position of NRST_SHDW field.
	Flash_OPTR_NRST_SHDW_Pos = 0xe
	// Bit mask of NRST_SHDW field.
	Flash_OPTR_NRST_SHDW_Msk = 0x4000
	// Bit NRST_SHDW.
	Flash_OPTR_NRST_SHDW = 0x4000
	// Position of IWDG_SW field.
	Flash_OPTR_IWDG_SW_Pos = 0x10
	// Bit mask of IWDG_SW field.
	Flash_OPTR_IWDG_SW_Msk = 0x10000
	// Bit IWDG_SW.
	Flash_OPTR_IWDG_SW = 0x10000
	// Position of IWDG_STOP field.
	Flash_OPTR_IWDG_STOP_Pos = 0x11
	// Bit mask of IWDG_STOP field.
	Flash_OPTR_IWDG_STOP_Msk = 0x20000
	// Bit IWDG_STOP.
	Flash_OPTR_IWDG_STOP = 0x20000
	// Position of IWDG_STDBY field.
	Flash_OPTR_IWDG_STDBY_Pos = 0x12
	// Bit mask of IWDG_STDBY field.
	Flash_OPTR_IWDG_STDBY_Msk = 0x40000
	// Bit IWDG_STDBY.
	Flash_OPTR_IWDG_STDBY = 0x40000
	// Position of WWDG_SW field.
	Flash_OPTR_WWDG_SW_Pos = 0x13
	// Bit mask of WWDG_SW field.
	Flash_OPTR_WWDG_SW_Msk = 0x80000
	// Bit WWDG_SW.
	Flash_OPTR_WWDG_SW = 0x80000
	// Position of NBOOT1 field.
	Flash_OPTR_NBOOT1_Pos = 0x17
	// Bit mask of NBOOT1 field.
	Flash_OPTR_NBOOT1_Msk = 0x800000
	// Bit NBOOT1.
	Flash_OPTR_NBOOT1 = 0x800000
	// Position of SRAM2_PE field.
	Flash_OPTR_SRAM2_PE_Pos = 0x18
	// Bit mask of SRAM2_PE field.
	Flash_OPTR_SRAM2_PE_Msk = 0x1000000
	// Bit SRAM2_PE.
	Flash_OPTR_SRAM2_PE = 0x1000000
	// Position of SRAM2_RST field.
	Flash_OPTR_SRAM2_RST_Pos = 0x19
	// Bit mask of SRAM2_RST field.
	Flash_OPTR_SRAM2_RST_Msk = 0x2000000
	// Bit SRAM2_RST.
	Flash_OPTR_SRAM2_RST = 0x2000000
	// Position of NSWBOOT0 field.
	Flash_OPTR_NSWBOOT0_Pos = 0x1a
	// Bit mask of NSWBOOT0 field.
	Flash_OPTR_NSWBOOT0_Msk = 0x4000000
	// Bit NSWBOOT0.
	Flash_OPTR_NSWBOOT0 = 0x4000000
	// Position of NBOOT0 field.
	Flash_OPTR_NBOOT0_Pos = 0x1b
	// Bit mask of NBOOT0 field.
	Flash_OPTR_NBOOT0_Msk = 0x8000000
	// Bit NBOOT0.
	Flash_OPTR_NBOOT0 = 0x8000000
	// Position of BOOT_LOCK field.
	Flash_OPTR_BOOT_LOCK_Pos = 0x1e
	// Bit mask of BOOT_LOCK field.
	Flash_OPTR_BOOT_LOCK_Msk = 0x40000000
	// Bit BOOT_LOCK.
	Flash_OPTR_BOOT_LOCK = 0x40000000
	// Position of C2BOOT_LOCK field.
	Flash_OPTR_C2BOOT_LOCK_Pos = 0x1f
	// Bit mask of C2BOOT_LOCK field.
	Flash_OPTR_C2BOOT_LOCK_Msk = 0x80000000
	// Bit C2BOOT_LOCK.
	Flash_OPTR_C2BOOT_LOCK = 0x80000000

	// PCROP1ASR: Flash PCROP zone A Start address register
	// Position of PCROP1A_STRT field.
	Flash_PCROP1ASR_PCROP1A_STRT_Pos = 0x0
	// Bit mask of PCROP1A_STRT field.
	Flash_PCROP1ASR_PCROP1A_STRT_Msk = 0xff

	// PCROP1AER: Flash PCROP zone A End address register
	// Position of PCROP1A_END field.
	Flash_PCROP1AER_PCROP1A_END_Pos = 0x0
	// Bit mask of PCROP1A_END field.
	Flash_PCROP1AER_PCROP1A_END_Msk = 0xff
	// Position of PCROP_RDP field.
	Flash_PCROP1AER_PCROP_RDP_Pos = 0x1f
	// Bit mask of PCROP_RDP field.
	Flash_PCROP1AER_PCROP_RDP_Msk = 0x80000000
	// Bit PCROP_RDP.
	Flash_PCROP1AER_PCROP_RDP = 0x80000000

	// WRP1AR: Flash WRP area A address register
	// Position of WRP1A_STRT field.
	Flash_WRP1AR_WRP1A_STRT_Pos = 0x0
	// Bit mask of WRP1A_STRT field.
	Flash_WRP1AR_WRP1A_STRT_Msk = 0x7f
	// Position of WRP1A_END field.
	Flash_WRP1AR_WRP1A_END_Pos = 0x10
	// Bit mask of WRP1A_END field.
	Flash_WRP1AR_WRP1A_END_Msk = 0x7f0000

	// WRP1BR: Flash WRP area B address register
	// Position of WRP1B_STRT field.
	Flash_WRP1BR_WRP1B_STRT_Pos = 0x0
	// Bit mask of WRP1B_STRT field.
	Flash_WRP1BR_WRP1B_STRT_Msk = 0x7f
	// Position of WRP1B_END field.
	Flash_WRP1BR_WRP1B_END_Pos = 0x10
	// Bit mask of WRP1B_END field.
	Flash_WRP1BR_WRP1B_END_Msk = 0x7f0000

	// PCROP1BSR: Flash PCROP zone B Start address register
	// Position of PCROP1B_STRT field.
	Flash_PCROP1BSR_PCROP1B_STRT_Pos = 0x0
	// Bit mask of PCROP1B_STRT field.
	Flash_PCROP1BSR_PCROP1B_STRT_Msk = 0xff

	// PCROP1BER: Flash PCROP zone B End address register
	// Position of PCROP1B_END field.
	Flash_PCROP1BER_PCROP1B_END_Pos = 0x0
	// Bit mask of PCROP1B_END field.
	Flash_PCROP1BER_PCROP1B_END_Msk = 0xff

	// IPCCBR: Flash IPCC data buffer address register
	// Position of IPCCDBA field.
	Flash_IPCCBR_IPCCDBA_Pos = 0x0
	// Bit mask of IPCCDBA field.
	Flash_IPCCBR_IPCCDBA_Msk = 0x3fff

	// C2ACR: Flash CPU2 access control register
	// Position of PRFTEN field.
	Flash_C2ACR_PRFTEN_Pos = 0x8
	// Bit mask of PRFTEN field.
	Flash_C2ACR_PRFTEN_Msk = 0x100
	// Bit PRFTEN.
	Flash_C2ACR_PRFTEN = 0x100
	// Position of ICEN field.
	Flash_C2ACR_ICEN_Pos = 0x9
	// Bit mask of ICEN field.
	Flash_C2ACR_ICEN_Msk = 0x200
	// Bit ICEN.
	Flash_C2ACR_ICEN = 0x200
	// Position of ICRST field.
	Flash_C2ACR_ICRST_Pos = 0xb
	// Bit mask of ICRST field.
	Flash_C2ACR_ICRST_Msk = 0x800
	// Bit ICRST.
	Flash_C2ACR_ICRST = 0x800
	// Position of PES field.
	Flash_C2ACR_PES_Pos = 0xf
	// Bit mask of PES field.
	Flash_C2ACR_PES_Msk = 0x8000
	// Bit PES.
	Flash_C2ACR_PES = 0x8000

	// C2SR: Flash CPU2 status register
	// Position of EOP field.
	Flash_C2SR_EOP_Pos = 0x0
	// Bit mask of EOP field.
	Flash_C2SR_EOP_Msk = 0x1
	// Bit EOP.
	Flash_C2SR_EOP = 0x1
	// Position of OPERR field.
	Flash_C2SR_OPERR_Pos = 0x1
	// Bit mask of OPERR field.
	Flash_C2SR_OPERR_Msk = 0x2
	// Bit OPERR.
	Flash_C2SR_OPERR = 0x2
	// Position of PROGERR field.
	Flash_C2SR_PROGERR_Pos = 0x3
	// Bit mask of PROGERR field.
	Flash_C2SR_PROGERR_Msk = 0x8
	// Bit PROGERR.
	Flash_C2SR_PROGERR = 0x8
	// Position of WRPERR field.
	Flash_C2SR_WRPERR_Pos = 0x4
	// Bit mask of WRPERR field.
	Flash_C2SR_WRPERR_Msk = 0x10
	// Bit WRPERR.
	Flash_C2SR_WRPERR = 0x10
	// Position of PGAERR field.
	Flash_C2SR_PGAERR_Pos = 0x5
	// Bit mask of PGAERR field.
	Flash_C2SR_PGAERR_Msk = 0x20
	// Bit PGAERR.
	Flash_C2SR_PGAERR = 0x20
	// Position of SIZERR field.
	Flash_C2SR_SIZERR_Pos = 0x6
	// Bit mask of SIZERR field.
	Flash_C2SR_SIZERR_Msk = 0x40
	// Bit SIZERR.
	Flash_C2SR_SIZERR = 0x40
	// Position of PGSERR field.
	Flash_C2SR_PGSERR_Pos = 0x7
	// Bit mask of PGSERR field.
	Flash_C2SR_PGSERR_Msk = 0x80
	// Bit PGSERR.
	Flash_C2SR_PGSERR = 0x80
	// Position of MISERR field.
	Flash_C2SR_MISERR_Pos = 0x8
	// Bit mask of MISERR field.
	Flash_C2SR_MISERR_Msk = 0x100
	// Bit MISERR.
	Flash_C2SR_MISERR = 0x100
	// Position of FASTERR field.
	Flash_C2SR_FASTERR_Pos = 0x9
	// Bit mask of FASTERR field.
	Flash_C2SR_FASTERR_Msk = 0x200
	// Bit FASTERR.
	Flash_C2SR_FASTERR = 0x200
	// Position of RDERR field.
	Flash_C2SR_RDERR_Pos = 0xe
	// Bit mask of RDERR field.
	Flash_C2SR_RDERR_Msk = 0x4000
	// Bit RDERR.
	Flash_C2SR_RDERR = 0x4000
	// Position of BSY field.
	Flash_C2SR_BSY_Pos = 0x10
	// Bit mask of BSY field.
	Flash_C2SR_BSY_Msk = 0x10000
	// Bit BSY.
	Flash_C2SR_BSY = 0x10000
	// Position of CFGBSY field.
	Flash_C2SR_CFGBSY_Pos = 0x12
	// Bit mask of CFGBSY field.
	Flash_C2SR_CFGBSY_Msk = 0x40000
	// Bit CFGBSY.
	Flash_C2SR_CFGBSY = 0x40000
	// Position of PESD field.
	Flash_C2SR_PESD_Pos = 0x13
	// Bit mask of PESD field.
	Flash_C2SR_PESD_Msk = 0x80000
	// Bit PESD.
	Flash_C2SR_PESD = 0x80000

	// C2CR: Flash CPU2 control register
	// Position of PG field.
	Flash_C2CR_PG_Pos = 0x0
	// Bit mask of PG field.
	Flash_C2CR_PG_Msk = 0x1
	// Bit PG.
	Flash_C2CR_PG = 0x1
	// Position of PER field.
	Flash_C2CR_PER_Pos = 0x1
	// Bit mask of PER field.
	Flash_C2CR_PER_Msk = 0x2
	// Bit PER.
	Flash_C2CR_PER = 0x2
	// Position of MER field.
	Flash_C2CR_MER_Pos = 0x2
	// Bit mask of MER field.
	Flash_C2CR_MER_Msk = 0x4
	// Bit MER.
	Flash_C2CR_MER = 0x4
	// Position of PNB field.
	Flash_C2CR_PNB_Pos = 0x3
	// Bit mask of PNB field.
	Flash_C2CR_PNB_Msk = 0x3f8
	// Position of STRT field.
	Flash_C2CR_STRT_Pos = 0x10
	// Bit mask of STRT field.
	Flash_C2CR_STRT_Msk = 0x10000
	// Bit STRT.
	Flash_C2CR_STRT = 0x10000
	// Position of FSTPG field.
	Flash_C2CR_FSTPG_Pos = 0x12
	// Bit mask of FSTPG field.
	Flash_C2CR_FSTPG_Msk = 0x40000
	// Bit FSTPG.
	Flash_C2CR_FSTPG = 0x40000
	// Position of EOPIE field.
	Flash_C2CR_EOPIE_Pos = 0x18
	// Bit mask of EOPIE field.
	Flash_C2CR_EOPIE_Msk = 0x1000000
	// Bit EOPIE.
	Flash_C2CR_EOPIE = 0x1000000
	// Position of ERRIE field.
	Flash_C2CR_ERRIE_Pos = 0x19
	// Bit mask of ERRIE field.
	Flash_C2CR_ERRIE_Msk = 0x2000000
	// Bit ERRIE.
	Flash_C2CR_ERRIE = 0x2000000
	// Position of RDERRIE field.
	Flash_C2CR_RDERRIE_Pos = 0x1a
	// Bit mask of RDERRIE field.
	Flash_C2CR_RDERRIE_Msk = 0x4000000
	// Bit RDERRIE.
	Flash_C2CR_RDERRIE = 0x4000000

	// SFR: Flash secure Flash start address register
	// Position of SFSA field.
	Flash_SFR_SFSA_Pos = 0x0
	// Bit mask of SFSA field.
	Flash_SFR_SFSA_Msk = 0x7f
	// Position of FSD field.
	Flash_SFR_FSD_Pos = 0x7
	// Bit mask of FSD field.
	Flash_SFR_FSD_Msk = 0x80
	// Bit FSD.
	Flash_SFR_FSD = 0x80
	// Position of DDS field.
	Flash_SFR_DDS_Pos = 0xc
	// Bit mask of DDS field.
	Flash_SFR_DDS_Msk = 0x1000
	// Bit DDS.
	Flash_SFR_DDS = 0x1000
	// Position of HDPSA field.
	Flash_SFR_HDPSA_Pos = 0x10
	// Bit mask of HDPSA field.
	Flash_SFR_HDPSA_Msk = 0x7f0000
	// Position of HDPAD field.
	Flash_SFR_HDPAD_Pos = 0x17
	// Bit mask of HDPAD field.
	Flash_SFR_HDPAD_Msk = 0x800000
	// Bit HDPAD.
	Flash_SFR_HDPAD = 0x800000
	// Position of SUBGHSPISD field.
	Flash_SFR_SUBGHSPISD_Pos = 0x1f
	// Bit mask of SUBGHSPISD field.
	Flash_SFR_SUBGHSPISD_Msk = 0x80000000
	// Bit SUBGHSPISD.
	Flash_SFR_SUBGHSPISD = 0x80000000

	// SRRVR: Flash secure SRAM start address and CPU2 reset vector register
	// Position of SBRV field.
	Flash_SRRVR_SBRV_Pos = 0x0
	// Bit mask of SBRV field.
	Flash_SRRVR_SBRV_Msk = 0xffff
	// Position of SBRSA field.
	Flash_SRRVR_SBRSA_Pos = 0x12
	// Bit mask of SBRSA field.
	Flash_SRRVR_SBRSA_Msk = 0x7c0000
	// Position of BRSD field.
	Flash_SRRVR_BRSD_Pos = 0x17
	// Bit mask of BRSD field.
	Flash_SRRVR_BRSD_Msk = 0x800000
	// Bit BRSD.
	Flash_SRRVR_BRSD = 0x800000
	// Position of SNBRSA field.
	Flash_SRRVR_SNBRSA_Pos = 0x19
	// Bit mask of SNBRSA field.
	Flash_SRRVR_SNBRSA_Msk = 0x3e000000
	// Position of NBRSD field.
	Flash_SRRVR_NBRSD_Pos = 0x1e
	// Bit mask of NBRSD field.
	Flash_SRRVR_NBRSD_Msk = 0x40000000
	// Bit NBRSD.
	Flash_SRRVR_NBRSD = 0x40000000
	// Position of C2OPT field.
	Flash_SRRVR_C2OPT_Pos = 0x1f
	// Bit mask of C2OPT field.
	Flash_SRRVR_C2OPT_Msk = 0x80000000
	// Bit C2OPT.
	Flash_SRRVR_C2OPT = 0x80000000
)

// Bitfields for GPIOA: General-purpose I/Os
const (
	// MODER: GPIO port mode register
	// Position of MODER15 field.
	GPIO_MODER_MODER15_Pos = 0x1e
	// Bit mask of MODER15 field.
	GPIO_MODER_MODER15_Msk = 0xc0000000
	// Position of MODER14 field.
	GPIO_MODER_MODER14_Pos = 0x1c
	// Bit mask of MODER14 field.
	GPIO_MODER_MODER14_Msk = 0x30000000
	// Position of MODER13 field.
	GPIO_MODER_MODER13_Pos = 0x1a
	// Bit mask of MODER13 field.
	GPIO_MODER_MODER13_Msk = 0xc000000
	// Position of MODER12 field.
	GPIO_MODER_MODER12_Pos = 0x18
	// Bit mask of MODER12 field.
	GPIO_MODER_MODER12_Msk = 0x3000000
	// Position of MODER11 field.
	GPIO_MODER_MODER11_Pos = 0x16
	// Bit mask of MODER11 field.
	GPIO_MODER_MODER11_Msk = 0xc00000
	// Position of MODER10 field.
	GPIO_MODER_MODER10_Pos = 0x14
	// Bit mask of MODER10 field.
	GPIO_MODER_MODER10_Msk = 0x300000
	// Position of MODER9 field.
	GPIO_MODER_MODER9_Pos = 0x12
	// Bit mask of MODER9 field.
	GPIO_MODER_MODER9_Msk = 0xc0000
	// Position of MODER8 field.
	GPIO_MODER_MODER8_Pos = 0x10
	// Bit mask of MODER8 field.
	GPIO_MODER_MODER8_Msk = 0x30000
	// Position of MODER7 field.
	GPIO_MODER_MODER7_Pos = 0xe
	// Bit mask of MODER7 field.
	GPIO_MODER_MODER7_Msk = 0xc000
	// Position of MODER6 field.
	GPIO_MODER_MODER6_Pos = 0xc
	// Bit mask of MODER6 field.
	GPIO_MODER_MODER6_Msk = 0x3000
	// Position of MODER5 field.
	GPIO_MODER_MODER5_Pos = 0xa
	// Bit mask of MODER5 field.
	GPIO_MODER_MODER5_Msk = 0xc00
	// Position of MODER4 field.
	GPIO_MODER_MODER4_Pos = 0x8
	// Bit mask of MODER4 field.
	GPIO_MODER_MODER4_Msk = 0x300
	// Position of MODER3 field.
	GPIO_MODER_MODER3_Pos = 0x6
	// Bit mask of MODER3 field.
	GPIO_MODER_MODER3_Msk = 0xc0
	// Position of MODER2 field.
	GPIO_MODER_MODER2_Pos = 0x4
	// Bit mask of MODER2 field.
	GPIO_MODER_MODER2_Msk = 0x30
	// Position of MODER1 field.
	GPIO_MODER_MODER1_Pos = 0x2
	// Bit mask of MODER1 field.
	GPIO_MODER_MODER1_Msk = 0xc
	// Position of MODER0 field.
	GPIO_MODER_MODER0_Pos = 0x0
	// Bit mask of MODER0 field.
	GPIO_MODER_MODER0_Msk = 0x3

	// OTYPER: GPIO port output type register
	// Position of OT15 field.
	GPIO_OTYPER_OT15_Pos = 0xf
	// Bit mask of OT15 field.
	GPIO_OTYPER_OT15_Msk = 0x8000
	// Bit OT15.
	GPIO_OTYPER_OT15 = 0x8000
	// Position of OT14 field.
	GPIO_OTYPER_OT14_Pos = 0xe
	// Bit mask of OT14 field.
	GPIO_OTYPER_OT14_Msk = 0x4000
	// Bit OT14.
	GPIO_OTYPER_OT14 = 0x4000
	// Position of OT13 field.
	GPIO_OTYPER_OT13_Pos = 0xd
	// Bit mask of OT13 field.
	GPIO_OTYPER_OT13_Msk = 0x2000
	// Bit OT13.
	GPIO_OTYPER_OT13 = 0x2000
	// Position of OT12 field.
	GPIO_OTYPER_OT12_Pos = 0xc
	// Bit mask of OT12 field.
	GPIO_OTYPER_OT12_Msk = 0x1000
	// Bit OT12.
	GPIO_OTYPER_OT12 = 0x1000
	// Position of OT11 field.
	GPIO_OTYPER_OT11_Pos = 0xb
	// Bit mask of OT11 field.
	GPIO_OTYPER_OT11_Msk = 0x800
	// Bit OT11.
	GPIO_OTYPER_OT11 = 0x800
	// Position of OT10 field.
	GPIO_OTYPER_OT10_Pos = 0xa
	// Bit mask of OT10 field.
	GPIO_OTYPER_OT10_Msk = 0x400
	// Bit OT10.
	GPIO_OTYPER_OT10 = 0x400
	// Position of OT9 field.
	GPIO_OTYPER_OT9_Pos = 0x9
	// Bit mask of OT9 field.
	GPIO_OTYPER_OT9_Msk = 0x200
	// Bit OT9.
	GPIO_OTYPER_OT9 = 0x200
	// Position of OT8 field.
	GPIO_OTYPER_OT8_Pos = 0x8
	// Bit mask of OT8 field.
	GPIO_OTYPER_OT8_Msk = 0x100
	// Bit OT8.
	GPIO_OTYPER_OT8 = 0x100
	// Position of OT7 field.
	GPIO_OTYPER_OT7_Pos = 0x7
	// Bit mask of OT7 field.
	GPIO_OTYPER_OT7_Msk = 0x80
	// Bit OT7.
	GPIO_OTYPER_OT7 = 0x80
	// Position of OT6 field.
	GPIO_OTYPER_OT6_Pos = 0x6
	// Bit mask of OT6 field.
	GPIO_OTYPER_OT6_Msk = 0x40
	// Bit OT6.
	GPIO_OTYPER_OT6 = 0x40
	// Position of OT5 field.
	GPIO_OTYPER_OT5_Pos = 0x5
	// Bit mask of OT5 field.
	GPIO_OTYPER_OT5_Msk = 0x20
	// Bit OT5.
	GPIO_OTYPER_OT5 = 0x20
	// Position of OT4 field.
	GPIO_OTYPER_OT4_Pos = 0x4
	// Bit mask of OT4 field.
	GPIO_OTYPER_OT4_Msk = 0x10
	// Bit OT4.
	GPIO_OTYPER_OT4 = 0x10
	// Position of OT3 field.
	GPIO_OTYPER_OT3_Pos = 0x3
	// Bit mask of OT3 field.
	GPIO_OTYPER_OT3_Msk = 0x8
	// Bit OT3.
	GPIO_OTYPER_OT3 = 0x8
	// Position of OT2 field.
	GPIO_OTYPER_OT2_Pos = 0x2
	// Bit mask of OT2 field.
	GPIO_OTYPER_OT2_Msk = 0x4
	// Bit OT2.
	GPIO_OTYPER_OT2 = 0x4
	// Position of OT1 field.
	GPIO_OTYPER_OT1_Pos = 0x1
	// Bit mask of OT1 field.
	GPIO_OTYPER_OT1_Msk = 0x2
	// Bit OT1.
	GPIO_OTYPER_OT1 = 0x2
	// Position of OT0 field.
	GPIO_OTYPER_OT0_Pos = 0x0
	// Bit mask of OT0 field.
	GPIO_OTYPER_OT0_Msk = 0x1
	// Bit OT0.
	GPIO_OTYPER_OT0 = 0x1

	// OSPEEDR: GPIO port output speed register
	// Position of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Pos = 0x1e
	// Bit mask of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Msk = 0xc0000000
	// Position of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Pos = 0x1c
	// Bit mask of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Msk = 0x30000000
	// Position of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Pos = 0x1a
	// Bit mask of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Msk = 0xc000000
	// Position of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Pos = 0x18
	// Bit mask of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Msk = 0x3000000
	// Position of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Pos = 0x16
	// Bit mask of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Msk = 0xc00000
	// Position of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Pos = 0x14
	// Bit mask of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Msk = 0x300000
	// Position of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Pos = 0x12
	// Bit mask of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Msk = 0xc0000
	// Position of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Pos = 0x10
	// Bit mask of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Msk = 0x30000
	// Position of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Pos = 0xe
	// Bit mask of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Msk = 0xc000
	// Position of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Pos = 0xc
	// Bit mask of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Msk = 0x3000
	// Position of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Pos = 0xa
	// Bit mask of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Msk = 0xc00
	// Position of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Pos = 0x8
	// Bit mask of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Msk = 0x300
	// Position of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Pos = 0x6
	// Bit mask of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Msk = 0xc0
	// Position of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Pos = 0x4
	// Bit mask of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Msk = 0x30
	// Position of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Pos = 0x2
	// Bit mask of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Msk = 0xc
	// Position of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Pos = 0x0
	// Bit mask of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Msk = 0x3

	// PUPDR: GPIO port pull-up/pull-down register
	// Position of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Pos = 0x1e
	// Bit mask of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Msk = 0xc0000000
	// Position of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Pos = 0x1c
	// Bit mask of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Msk = 0x30000000
	// Position of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Pos = 0x1a
	// Bit mask of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Msk = 0xc000000
	// Position of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Pos = 0x18
	// Bit mask of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Msk = 0x3000000
	// Position of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Pos = 0x16
	// Bit mask of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Msk = 0xc00000
	// Position of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Pos = 0x14
	// Bit mask of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Msk = 0x300000
	// Position of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Pos = 0x12
	// Bit mask of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Msk = 0xc0000
	// Position of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Pos = 0x10
	// Bit mask of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Msk = 0x30000
	// Position of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Pos = 0xe
	// Bit mask of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Msk = 0xc000
	// Position of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Pos = 0xc
	// Bit mask of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Msk = 0x3000
	// Position of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Pos = 0xa
	// Bit mask of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Msk = 0xc00
	// Position of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Pos = 0x8
	// Bit mask of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Msk = 0x300
	// Position of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Pos = 0x6
	// Bit mask of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Msk = 0xc0
	// Position of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Pos = 0x4
	// Bit mask of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Msk = 0x30
	// Position of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Pos = 0x2
	// Bit mask of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Msk = 0xc
	// Position of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Pos = 0x0
	// Bit mask of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Msk = 0x3

	// IDR: GPIO port input data register
	// Position of IDR15 field.
	GPIO_IDR_IDR15_Pos = 0xf
	// Bit mask of IDR15 field.
	GPIO_IDR_IDR15_Msk = 0x8000
	// Bit IDR15.
	GPIO_IDR_IDR15 = 0x8000
	// Position of IDR14 field.
	GPIO_IDR_IDR14_Pos = 0xe
	// Bit mask of IDR14 field.
	GPIO_IDR_IDR14_Msk = 0x4000
	// Bit IDR14.
	GPIO_IDR_IDR14 = 0x4000
	// Position of IDR13 field.
	GPIO_IDR_IDR13_Pos = 0xd
	// Bit mask of IDR13 field.
	GPIO_IDR_IDR13_Msk = 0x2000
	// Bit IDR13.
	GPIO_IDR_IDR13 = 0x2000
	// Position of IDR12 field.
	GPIO_IDR_IDR12_Pos = 0xc
	// Bit mask of IDR12 field.
	GPIO_IDR_IDR12_Msk = 0x1000
	// Bit IDR12.
	GPIO_IDR_IDR12 = 0x1000
	// Position of IDR11 field.
	GPIO_IDR_IDR11_Pos = 0xb
	// Bit mask of IDR11 field.
	GPIO_IDR_IDR11_Msk = 0x800
	// Bit IDR11.
	GPIO_IDR_IDR11 = 0x800
	// Position of IDR10 field.
	GPIO_IDR_IDR10_Pos = 0xa
	// Bit mask of IDR10 field.
	GPIO_IDR_IDR10_Msk = 0x400
	// Bit IDR10.
	GPIO_IDR_IDR10 = 0x400
	// Position of IDR9 field.
	GPIO_IDR_IDR9_Pos = 0x9
	// Bit mask of IDR9 field.
	GPIO_IDR_IDR9_Msk = 0x200
	// Bit IDR9.
	GPIO_IDR_IDR9 = 0x200
	// Position of IDR8 field.
	GPIO_IDR_IDR8_Pos = 0x8
	// Bit mask of IDR8 field.
	GPIO_IDR_IDR8_Msk = 0x100
	// Bit IDR8.
	GPIO_IDR_IDR8 = 0x100
	// Position of IDR7 field.
	GPIO_IDR_IDR7_Pos = 0x7
	// Bit mask of IDR7 field.
	GPIO_IDR_IDR7_Msk = 0x80
	// Bit IDR7.
	GPIO_IDR_IDR7 = 0x80
	// Position of IDR6 field.
	GPIO_IDR_IDR6_Pos = 0x6
	// Bit mask of IDR6 field.
	GPIO_IDR_IDR6_Msk = 0x40
	// Bit IDR6.
	GPIO_IDR_IDR6 = 0x40
	// Position of IDR5 field.
	GPIO_IDR_IDR5_Pos = 0x5
	// Bit mask of IDR5 field.
	GPIO_IDR_IDR5_Msk = 0x20
	// Bit IDR5.
	GPIO_IDR_IDR5 = 0x20
	// Position of IDR4 field.
	GPIO_IDR_IDR4_Pos = 0x4
	// Bit mask of IDR4 field.
	GPIO_IDR_IDR4_Msk = 0x10
	// Bit IDR4.
	GPIO_IDR_IDR4 = 0x10
	// Position of IDR3 field.
	GPIO_IDR_IDR3_Pos = 0x3
	// Bit mask of IDR3 field.
	GPIO_IDR_IDR3_Msk = 0x8
	// Bit IDR3.
	GPIO_IDR_IDR3 = 0x8
	// Position of IDR2 field.
	GPIO_IDR_IDR2_Pos = 0x2
	// Bit mask of IDR2 field.
	GPIO_IDR_IDR2_Msk = 0x4
	// Bit IDR2.
	GPIO_IDR_IDR2 = 0x4
	// Position of IDR1 field.
	GPIO_IDR_IDR1_Pos = 0x1
	// Bit mask of IDR1 field.
	GPIO_IDR_IDR1_Msk = 0x2
	// Bit IDR1.
	GPIO_IDR_IDR1 = 0x2
	// Position of IDR0 field.
	GPIO_IDR_IDR0_Pos = 0x0
	// Bit mask of IDR0 field.
	GPIO_IDR_IDR0_Msk = 0x1
	// Bit IDR0.
	GPIO_IDR_IDR0 = 0x1

	// ODR: GPIO port output data register
	// Position of ODR15 field.
	GPIO_ODR_ODR15_Pos = 0xf
	// Bit mask of ODR15 field.
	GPIO_ODR_ODR15_Msk = 0x8000
	// Bit ODR15.
	GPIO_ODR_ODR15 = 0x8000
	// Position of ODR14 field.
	GPIO_ODR_ODR14_Pos = 0xe
	// Bit mask of ODR14 field.
	GPIO_ODR_ODR14_Msk = 0x4000
	// Bit ODR14.
	GPIO_ODR_ODR14 = 0x4000
	// Position of ODR13 field.
	GPIO_ODR_ODR13_Pos = 0xd
	// Bit mask of ODR13 field.
	GPIO_ODR_ODR13_Msk = 0x2000
	// Bit ODR13.
	GPIO_ODR_ODR13 = 0x2000
	// Position of ODR12 field.
	GPIO_ODR_ODR12_Pos = 0xc
	// Bit mask of ODR12 field.
	GPIO_ODR_ODR12_Msk = 0x1000
	// Bit ODR12.
	GPIO_ODR_ODR12 = 0x1000
	// Position of ODR11 field.
	GPIO_ODR_ODR11_Pos = 0xb
	// Bit mask of ODR11 field.
	GPIO_ODR_ODR11_Msk = 0x800
	// Bit ODR11.
	GPIO_ODR_ODR11 = 0x800
	// Position of ODR10 field.
	GPIO_ODR_ODR10_Pos = 0xa
	// Bit mask of ODR10 field.
	GPIO_ODR_ODR10_Msk = 0x400
	// Bit ODR10.
	GPIO_ODR_ODR10 = 0x400
	// Position of ODR9 field.
	GPIO_ODR_ODR9_Pos = 0x9
	// Bit mask of ODR9 field.
	GPIO_ODR_ODR9_Msk = 0x200
	// Bit ODR9.
	GPIO_ODR_ODR9 = 0x200
	// Position of ODR8 field.
	GPIO_ODR_ODR8_Pos = 0x8
	// Bit mask of ODR8 field.
	GPIO_ODR_ODR8_Msk = 0x100
	// Bit ODR8.
	GPIO_ODR_ODR8 = 0x100
	// Position of ODR7 field.
	GPIO_ODR_ODR7_Pos = 0x7
	// Bit mask of ODR7 field.
	GPIO_ODR_ODR7_Msk = 0x80
	// Bit ODR7.
	GPIO_ODR_ODR7 = 0x80
	// Position of ODR6 field.
	GPIO_ODR_ODR6_Pos = 0x6
	// Bit mask of ODR6 field.
	GPIO_ODR_ODR6_Msk = 0x40
	// Bit ODR6.
	GPIO_ODR_ODR6 = 0x40
	// Position of ODR5 field.
	GPIO_ODR_ODR5_Pos = 0x5
	// Bit mask of ODR5 field.
	GPIO_ODR_ODR5_Msk = 0x20
	// Bit ODR5.
	GPIO_ODR_ODR5 = 0x20
	// Position of ODR4 field.
	GPIO_ODR_ODR4_Pos = 0x4
	// Bit mask of ODR4 field.
	GPIO_ODR_ODR4_Msk = 0x10
	// Bit ODR4.
	GPIO_ODR_ODR4 = 0x10
	// Position of ODR3 field.
	GPIO_ODR_ODR3_Pos = 0x3
	// Bit mask of ODR3 field.
	GPIO_ODR_ODR3_Msk = 0x8
	// Bit ODR3.
	GPIO_ODR_ODR3 = 0x8
	// Position of ODR2 field.
	GPIO_ODR_ODR2_Pos = 0x2
	// Bit mask of ODR2 field.
	GPIO_ODR_ODR2_Msk = 0x4
	// Bit ODR2.
	GPIO_ODR_ODR2 = 0x4
	// Position of ODR1 field.
	GPIO_ODR_ODR1_Pos = 0x1
	// Bit mask of ODR1 field.
	GPIO_ODR_ODR1_Msk = 0x2
	// Bit ODR1.
	GPIO_ODR_ODR1 = 0x2
	// Position of ODR0 field.
	GPIO_ODR_ODR0_Pos = 0x0
	// Bit mask of ODR0 field.
	GPIO_ODR_ODR0_Msk = 0x1
	// Bit ODR0.
	GPIO_ODR_ODR0 = 0x1

	// BSRR: GPIO port bit set/reset register
	// Position of BR15 field.
	GPIO_BSRR_BR15_Pos = 0x1f
	// Bit mask of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000
	// Bit BR15.
	GPIO_BSRR_BR15 = 0x80000000
	// Position of BR14 field.
	GPIO_BSRR_BR14_Pos = 0x1e
	// Bit mask of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000
	// Bit BR14.
	GPIO_BSRR_BR14 = 0x40000000
	// Position of BR13 field.
	GPIO_BSRR_BR13_Pos = 0x1d
	// Bit mask of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000
	// Bit BR13.
	GPIO_BSRR_BR13 = 0x20000000
	// Position of BR12 field.
	GPIO_BSRR_BR12_Pos = 0x1c
	// Bit mask of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000
	// Bit BR12.
	GPIO_BSRR_BR12 = 0x10000000
	// Position of BR11 field.
	GPIO_BSRR_BR11_Pos = 0x1b
	// Bit mask of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000
	// Bit BR11.
	GPIO_BSRR_BR11 = 0x8000000
	// Position of BR10 field.
	GPIO_BSRR_BR10_Pos = 0x1a
	// Bit mask of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000
	// Bit BR10.
	GPIO_BSRR_BR10 = 0x4000000
	// Position of BR9 field.
	GPIO_BSRR_BR9_Pos = 0x19
	// Bit mask of BR9 field.
	GPIO_BSRR_BR9_Msk = 0x2000000
	// Bit BR9.
	GPIO_BSRR_BR9 = 0x2000000
	// Position of BR8 field.
	GPIO_BSRR_BR8_Pos = 0x18
	// Bit mask of BR8 field.
	GPIO_BSRR_BR8_Msk = 0x1000000
	// Bit BR8.
	GPIO_BSRR_BR8 = 0x1000000
	// Position of BR7 field.
	GPIO_BSRR_BR7_Pos = 0x17
	// Bit mask of BR7 field.
	GPIO_BSRR_BR7_Msk = 0x800000
	// Bit BR7.
	GPIO_BSRR_BR7 = 0x800000
	// Position of BR6 field.
	GPIO_BSRR_BR6_Pos = 0x16
	// Bit mask of BR6 field.
	GPIO_BSRR_BR6_Msk = 0x400000
	// Bit BR6.
	GPIO_BSRR_BR6 = 0x400000
	// Position of BR5 field.
	GPIO_BSRR_BR5_Pos = 0x15
	// Bit mask of BR5 field.
	GPIO_BSRR_BR5_Msk = 0x200000
	// Bit BR5.
	GPIO_BSRR_BR5 = 0x200000
	// Position of BR4 field.
	GPIO_BSRR_BR4_Pos = 0x14
	// Bit mask of BR4 field.
	GPIO_BSRR_BR4_Msk = 0x100000
	// Bit BR4.
	GPIO_BSRR_BR4 = 0x100000
	// Position of BR3 field.
	GPIO_BSRR_BR3_Pos = 0x13
	// Bit mask of BR3 field.
	GPIO_BSRR_BR3_Msk = 0x80000
	// Bit BR3.
	GPIO_BSRR_BR3 = 0x80000
	// Position of BR2 field.
	GPIO_BSRR_BR2_Pos = 0x12
	// Bit mask of BR2 field.
	GPIO_BSRR_BR2_Msk = 0x40000
	// Bit BR2.
	GPIO_BSRR_BR2 = 0x40000
	// Position of BR1 field.
	GPIO_BSRR_BR1_Pos = 0x11
	// Bit mask of BR1 field.
	GPIO_BSRR_BR1_Msk = 0x20000
	// Bit BR1.
	GPIO_BSRR_BR1 = 0x20000
	// Position of BR0 field.
	GPIO_BSRR_BR0_Pos = 0x10
	// Bit mask of BR0 field.
	GPIO_BSRR_BR0_Msk = 0x10000
	// Bit BR0.
	GPIO_BSRR_BR0 = 0x10000
	// Position of BS15 field.
	GPIO_BSRR_BS15_Pos = 0xf
	// Bit mask of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000
	// Bit BS15.
	GPIO_BSRR_BS15 = 0x8000
	// Position of BS14 field.
	GPIO_BSRR_BS14_Pos = 0xe
	// Bit mask of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000
	// Bit BS14.
	GPIO_BSRR_BS14 = 0x4000
	// Position of BS13 field.
	GPIO_BSRR_BS13_Pos = 0xd
	// Bit mask of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000
	// Bit BS13.
	GPIO_BSRR_BS13 = 0x2000
	// Position of BS12 field.
	GPIO_BSRR_BS12_Pos = 0xc
	// Bit mask of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000
	// Bit BS12.
	GPIO_BSRR_BS12 = 0x1000
	// Position of BS11 field.
	GPIO_BSRR_BS11_Pos = 0xb
	// Bit mask of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800
	// Bit BS11.
	GPIO_BSRR_BS11 = 0x800
	// Position of BS10 field.
	GPIO_BSRR_BS10_Pos = 0xa
	// Bit mask of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400
	// Bit BS10.
	GPIO_BSRR_BS10 = 0x400
	// Position of BS9 field.
	GPIO_BSRR_BS9_Pos = 0x9
	// Bit mask of BS9 field.
	GPIO_BSRR_BS9_Msk = 0x200
	// Bit BS9.
	GPIO_BSRR_BS9 = 0x200
	// Position of BS8 field.
	GPIO_BSRR_BS8_Pos = 0x8
	// Bit mask of BS8 field.
	GPIO_BSRR_BS8_Msk = 0x100
	// Bit BS8.
	GPIO_BSRR_BS8 = 0x100
	// Position of BS7 field.
	GPIO_BSRR_BS7_Pos = 0x7
	// Bit mask of BS7 field.
	GPIO_BSRR_BS7_Msk = 0x80
	// Bit BS7.
	GPIO_BSRR_BS7 = 0x80
	// Position of BS6 field.
	GPIO_BSRR_BS6_Pos = 0x6
	// Bit mask of BS6 field.
	GPIO_BSRR_BS6_Msk = 0x40
	// Bit BS6.
	GPIO_BSRR_BS6 = 0x40
	// Position of BS5 field.
	GPIO_BSRR_BS5_Pos = 0x5
	// Bit mask of BS5 field.
	GPIO_BSRR_BS5_Msk = 0x20
	// Bit BS5.
	GPIO_BSRR_BS5 = 0x20
	// Position of BS4 field.
	GPIO_BSRR_BS4_Pos = 0x4
	// Bit mask of BS4 field.
	GPIO_BSRR_BS4_Msk = 0x10
	// Bit BS4.
	GPIO_BSRR_BS4 = 0x10
	// Position of BS3 field.
	GPIO_BSRR_BS3_Pos = 0x3
	// Bit mask of BS3 field.
	GPIO_BSRR_BS3_Msk = 0x8
	// Bit BS3.
	GPIO_BSRR_BS3 = 0x8
	// Position of BS2 field.
	GPIO_BSRR_BS2_Pos = 0x2
	// Bit mask of BS2 field.
	GPIO_BSRR_BS2_Msk = 0x4
	// Bit BS2.
	GPIO_BSRR_BS2 = 0x4
	// Position of BS1 field.
	GPIO_BSRR_BS1_Pos = 0x1
	// Bit mask of BS1 field.
	GPIO_BSRR_BS1_Msk = 0x2
	// Bit BS1.
	GPIO_BSRR_BS1 = 0x2
	// Position of BS0 field.
	GPIO_BSRR_BS0_Pos = 0x0
	// Bit mask of BS0 field.
	GPIO_BSRR_BS0_Msk = 0x1
	// Bit BS0.
	GPIO_BSRR_BS0 = 0x1

	// LCKR: GPIO port configuration lock register
	// Position of LCKK field.
	GPIO_LCKR_LCKK_Pos = 0x10
	// Bit mask of LCKK field.
	GPIO_LCKR_LCKK_Msk = 0x10000
	// Bit LCKK.
	GPIO_LCKR_LCKK = 0x10000
	// Position of LCK15 field.
	GPIO_LCKR_LCK15_Pos = 0xf
	// Bit mask of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000
	// Bit LCK15.
	GPIO_LCKR_LCK15 = 0x8000
	// Position of LCK14 field.
	GPIO_LCKR_LCK14_Pos = 0xe
	// Bit mask of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000
	// Bit LCK14.
	GPIO_LCKR_LCK14 = 0x4000
	// Position of LCK13 field.
	GPIO_LCKR_LCK13_Pos = 0xd
	// Bit mask of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000
	// Bit LCK13.
	GPIO_LCKR_LCK13 = 0x2000
	// Position of LCK12 field.
	GPIO_LCKR_LCK12_Pos = 0xc
	// Bit mask of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000
	// Bit LCK12.
	GPIO_LCKR_LCK12 = 0x1000
	// Position of LCK11 field.
	GPIO_LCKR_LCK11_Pos = 0xb
	// Bit mask of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800
	// Bit LCK11.
	GPIO_LCKR_LCK11 = 0x800
	// Position of LCK10 field.
	GPIO_LCKR_LCK10_Pos = 0xa
	// Bit mask of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400
	// Bit LCK10.
	GPIO_LCKR_LCK10 = 0x400
	// Position of LCK9 field.
	GPIO_LCKR_LCK9_Pos = 0x9
	// Bit mask of LCK9 field.
	GPIO_LCKR_LCK9_Msk = 0x200
	// Bit LCK9.
	GPIO_LCKR_LCK9 = 0x200
	// Position of LCK8 field.
	GPIO_LCKR_LCK8_Pos = 0x8
	// Bit mask of LCK8 field.
	GPIO_LCKR_LCK8_Msk = 0x100
	// Bit LCK8.
	GPIO_LCKR_LCK8 = 0x100
	// Position of LCK7 field.
	GPIO_LCKR_LCK7_Pos = 0x7
	// Bit mask of LCK7 field.
	GPIO_LCKR_LCK7_Msk = 0x80
	// Bit LCK7.
	GPIO_LCKR_LCK7 = 0x80
	// Position of LCK6 field.
	GPIO_LCKR_LCK6_Pos = 0x6
	// Bit mask of LCK6 field.
	GPIO_LCKR_LCK6_Msk = 0x40
	// Bit LCK6.
	GPIO_LCKR_LCK6 = 0x40
	// Position of LCK5 field.
	GPIO_LCKR_LCK5_Pos = 0x5
	// Bit mask of LCK5 field.
	GPIO_LCKR_LCK5_Msk = 0x20
	// Bit LCK5.
	GPIO_LCKR_LCK5 = 0x20
	// Position of LCK4 field.
	GPIO_LCKR_LCK4_Pos = 0x4
	// Bit mask of LCK4 field.
	GPIO_LCKR_LCK4_Msk = 0x10
	// Bit LCK4.
	GPIO_LCKR_LCK4 = 0x10
	// Position of LCK3 field.
	GPIO_LCKR_LCK3_Pos = 0x3
	// Bit mask of LCK3 field.
	GPIO_LCKR_LCK3_Msk = 0x8
	// Bit LCK3.
	GPIO_LCKR_LCK3 = 0x8
	// Position of LCK2 field.
	GPIO_LCKR_LCK2_Pos = 0x2
	// Bit mask of LCK2 field.
	GPIO_LCKR_LCK2_Msk = 0x4
	// Bit LCK2.
	GPIO_LCKR_LCK2 = 0x4
	// Position of LCK1 field.
	GPIO_LCKR_LCK1_Pos = 0x1
	// Bit mask of LCK1 field.
	GPIO_LCKR_LCK1_Msk = 0x2
	// Bit LCK1.
	GPIO_LCKR_LCK1 = 0x2
	// Position of LCK0 field.
	GPIO_LCKR_LCK0_Pos = 0x0
	// Bit mask of LCK0 field.
	GPIO_LCKR_LCK0_Msk = 0x1
	// Bit LCK0.
	GPIO_LCKR_LCK0 = 0x1

	// AFRL: GPIO alternate function low register
	// Position of AFRL7 field.
	GPIO_AFRL_AFRL7_Pos = 0x1c
	// Bit mask of AFRL7 field.
	GPIO_AFRL_AFRL7_Msk = 0xf0000000
	// Position of AFRL6 field.
	GPIO_AFRL_AFRL6_Pos = 0x18
	// Bit mask of AFRL6 field.
	GPIO_AFRL_AFRL6_Msk = 0xf000000
	// Position of AFRL5 field.
	GPIO_AFRL_AFRL5_Pos = 0x14
	// Bit mask of AFRL5 field.
	GPIO_AFRL_AFRL5_Msk = 0xf00000
	// Position of AFRL4 field.
	GPIO_AFRL_AFRL4_Pos = 0x10
	// Bit mask of AFRL4 field.
	GPIO_AFRL_AFRL4_Msk = 0xf0000
	// Position of AFRL3 field.
	GPIO_AFRL_AFRL3_Pos = 0xc
	// Bit mask of AFRL3 field.
	GPIO_AFRL_AFRL3_Msk = 0xf000
	// Position of AFRL2 field.
	GPIO_AFRL_AFRL2_Pos = 0x8
	// Bit mask of AFRL2 field.
	GPIO_AFRL_AFRL2_Msk = 0xf00
	// Position of AFRL1 field.
	GPIO_AFRL_AFRL1_Pos = 0x4
	// Bit mask of AFRL1 field.
	GPIO_AFRL_AFRL1_Msk = 0xf0
	// Position of AFRL0 field.
	GPIO_AFRL_AFRL0_Pos = 0x0
	// Bit mask of AFRL0 field.
	GPIO_AFRL_AFRL0_Msk = 0xf

	// AFRH: GPIO alternate function high register
	// Position of AFRH15 field.
	GPIO_AFRH_AFRH15_Pos = 0x1c
	// Bit mask of AFRH15 field.
	GPIO_AFRH_AFRH15_Msk = 0xf0000000
	// Position of AFRH14 field.
	GPIO_AFRH_AFRH14_Pos = 0x18
	// Bit mask of AFRH14 field.
	GPIO_AFRH_AFRH14_Msk = 0xf000000
	// Position of AFRH13 field.
	GPIO_AFRH_AFRH13_Pos = 0x14
	// Bit mask of AFRH13 field.
	GPIO_AFRH_AFRH13_Msk = 0xf00000
	// Position of AFRH12 field.
	GPIO_AFRH_AFRH12_Pos = 0x10
	// Bit mask of AFRH12 field.
	GPIO_AFRH_AFRH12_Msk = 0xf0000
	// Position of AFRH11 field.
	GPIO_AFRH_AFRH11_Pos = 0xc
	// Bit mask of AFRH11 field.
	GPIO_AFRH_AFRH11_Msk = 0xf000
	// Position of AFRH10 field.
	GPIO_AFRH_AFRH10_Pos = 0x8
	// Bit mask of AFRH10 field.
	GPIO_AFRH_AFRH10_Msk = 0xf00
	// Position of AFRH9 field.
	GPIO_AFRH_AFRH9_Pos = 0x4
	// Bit mask of AFRH9 field.
	GPIO_AFRH_AFRH9_Msk = 0xf0
	// Position of AFRH8 field.
	GPIO_AFRH_AFRH8_Pos = 0x0
	// Bit mask of AFRH8 field.
	GPIO_AFRH_AFRH8_Msk = 0xf

	// BRR: GPIO port bit reset register
	// Position of BR0 field.
	GPIO_BRR_BR0_Pos = 0x0
	// Bit mask of BR0 field.
	GPIO_BRR_BR0_Msk = 0x1
	// Bit BR0.
	GPIO_BRR_BR0 = 0x1
	// Position of BR1 field.
	GPIO_BRR_BR1_Pos = 0x1
	// Bit mask of BR1 field.
	GPIO_BRR_BR1_Msk = 0x2
	// Bit BR1.
	GPIO_BRR_BR1 = 0x2
	// Position of BR2 field.
	GPIO_BRR_BR2_Pos = 0x2
	// Bit mask of BR2 field.
	GPIO_BRR_BR2_Msk = 0x4
	// Bit BR2.
	GPIO_BRR_BR2 = 0x4
	// Position of BR3 field.
	GPIO_BRR_BR3_Pos = 0x3
	// Bit mask of BR3 field.
	GPIO_BRR_BR3_Msk = 0x8
	// Bit BR3.
	GPIO_BRR_BR3 = 0x8
	// Position of BR4 field.
	GPIO_BRR_BR4_Pos = 0x4
	// Bit mask of BR4 field.
	GPIO_BRR_BR4_Msk = 0x10
	// Bit BR4.
	GPIO_BRR_BR4 = 0x10
	// Position of BR5 field.
	GPIO_BRR_BR5_Pos = 0x5
	// Bit mask of BR5 field.
	GPIO_BRR_BR5_Msk = 0x20
	// Bit BR5.
	GPIO_BRR_BR5 = 0x20
	// Position of BR6 field.
	GPIO_BRR_BR6_Pos = 0x6
	// Bit mask of BR6 field.
	GPIO_BRR_BR6_Msk = 0x40
	// Bit BR6.
	GPIO_BRR_BR6 = 0x40
	// Position of BR7 field.
	GPIO_BRR_BR7_Pos = 0x7
	// Bit mask of BR7 field.
	GPIO_BRR_BR7_Msk = 0x80
	// Bit BR7.
	GPIO_BRR_BR7 = 0x80
	// Position of BR8 field.
	GPIO_BRR_BR8_Pos = 0x8
	// Bit mask of BR8 field.
	GPIO_BRR_BR8_Msk = 0x100
	// Bit BR8.
	GPIO_BRR_BR8 = 0x100
	// Position of BR9 field.
	GPIO_BRR_BR9_Pos = 0x9
	// Bit mask of BR9 field.
	GPIO_BRR_BR9_Msk = 0x200
	// Bit BR9.
	GPIO_BRR_BR9 = 0x200
	// Position of BR10 field.
	GPIO_BRR_BR10_Pos = 0xa
	// Bit mask of BR10 field.
	GPIO_BRR_BR10_Msk = 0x400
	// Bit BR10.
	GPIO_BRR_BR10 = 0x400
	// Position of BR11 field.
	GPIO_BRR_BR11_Pos = 0xb
	// Bit mask of BR11 field.
	GPIO_BRR_BR11_Msk = 0x800
	// Bit BR11.
	GPIO_BRR_BR11 = 0x800
	// Position of BR12 field.
	GPIO_BRR_BR12_Pos = 0xc
	// Bit mask of BR12 field.
	GPIO_BRR_BR12_Msk = 0x1000
	// Bit BR12.
	GPIO_BRR_BR12 = 0x1000
	// Position of BR13 field.
	GPIO_BRR_BR13_Pos = 0xd
	// Bit mask of BR13 field.
	GPIO_BRR_BR13_Msk = 0x2000
	// Bit BR13.
	GPIO_BRR_BR13 = 0x2000
	// Position of BR14 field.
	GPIO_BRR_BR14_Pos = 0xe
	// Bit mask of BR14 field.
	GPIO_BRR_BR14_Msk = 0x4000
	// Bit BR14.
	GPIO_BRR_BR14 = 0x4000
	// Position of BR15 field.
	GPIO_BRR_BR15_Pos = 0xf
	// Bit mask of BR15 field.
	GPIO_BRR_BR15_Msk = 0x8000
	// Bit BR15.
	GPIO_BRR_BR15 = 0x8000
)

// Bitfields for HSEM: Hardware semaphore
const (
	// HSEM_R0: HSEM register HSEM_R0 HSEM_R31
	// Position of PROCID field.
	HSEM_HSEM_R0_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_R0_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_R0_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_R0_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_R0_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_R0_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_R0_LOCK = 0x80000000

	// HSEM_R1: HSEM register HSEM_R0 HSEM_R31
	// Position of PROCID field.
	HSEM_HSEM_R1_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_R1_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_R1_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_R1_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_R1_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_R1_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_R1_LOCK = 0x80000000

	// HSEM_R2: HSEM register HSEM_R0 HSEM_R31
	// Position of PROCID field.
	HSEM_HSEM_R2_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_R2_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_R2_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_R2_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_R2_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_R2_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_R2_LOCK = 0x80000000

	// HSEM_R3: HSEM register HSEM_R0 HSEM_R31
	// Position of PROCID field.
	HSEM_HSEM_R3_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_R3_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_R3_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_R3_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_R3_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_R3_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_R3_LOCK = 0x80000000

	// HSEM_R4: HSEM register HSEM_R0 HSEM_R31
	// Position of PROCID field.
	HSEM_HSEM_R4_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_R4_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_R4_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_R4_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_R4_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_R4_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_R4_LOCK = 0x80000000

	// HSEM_R5: HSEM register HSEM_R0 HSEM_R31
	// Position of PROCID field.
	HSEM_HSEM_R5_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_R5_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_R5_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_R5_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_R5_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_R5_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_R5_LOCK = 0x80000000

	// HSEM_R6: HSEM register HSEM_R0 HSEM_R31
	// Position of PROCID field.
	HSEM_HSEM_R6_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_R6_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_R6_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_R6_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_R6_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_R6_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_R6_LOCK = 0x80000000

	// HSEM_R7: HSEM register HSEM_R0 HSEM_R31
	// Position of PROCID field.
	HSEM_HSEM_R7_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_R7_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_R7_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_R7_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_R7_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_R7_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_R7_LOCK = 0x80000000

	// HSEM_R8: HSEM register HSEM_R0 HSEM_R31
	// Position of PROCID field.
	HSEM_HSEM_R8_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_R8_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_R8_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_R8_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_R8_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_R8_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_R8_LOCK = 0x80000000

	// HSEM_R9: HSEM register HSEM_R0 HSEM_R31
	// Position of PROCID field.
	HSEM_HSEM_R9_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_R9_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_R9_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_R9_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_R9_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_R9_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_R9_LOCK = 0x80000000

	// HSEM_R10: HSEM register HSEM_R0 HSEM_R31
	// Position of PROCID field.
	HSEM_HSEM_R10_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_R10_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_R10_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_R10_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_R10_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_R10_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_R10_LOCK = 0x80000000

	// HSEM_R11: HSEM register HSEM_R0 HSEM_R31
	// Position of PROCID field.
	HSEM_HSEM_R11_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_R11_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_R11_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_R11_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_R11_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_R11_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_R11_LOCK = 0x80000000

	// HSEM_R12: HSEM register HSEM_R0 HSEM_R31
	// Position of PROCID field.
	HSEM_HSEM_R12_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_R12_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_R12_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_R12_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_R12_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_R12_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_R12_LOCK = 0x80000000

	// HSEM_R13: HSEM register HSEM_R0 HSEM_R31
	// Position of PROCID field.
	HSEM_HSEM_R13_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_R13_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_R13_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_R13_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_R13_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_R13_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_R13_LOCK = 0x80000000

	// HSEM_R14: HSEM register HSEM_R0 HSEM_R31
	// Position of PROCID field.
	HSEM_HSEM_R14_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_R14_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_R14_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_R14_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_R14_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_R14_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_R14_LOCK = 0x80000000

	// HSEM_R15: HSEM register HSEM_R0 HSEM_R31
	// Position of PROCID field.
	HSEM_HSEM_R15_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_R15_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_R15_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_R15_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_R15_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_R15_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_R15_LOCK = 0x80000000

	// HSEM_RLR0: HSEM Read lock register
	// Position of PROCID field.
	HSEM_HSEM_RLR0_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_RLR0_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_RLR0_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_RLR0_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_RLR0_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_RLR0_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_RLR0_LOCK = 0x80000000

	// HSEM_RLR1: HSEM Read lock register
	// Position of PROCID field.
	HSEM_HSEM_RLR1_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_RLR1_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_RLR1_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_RLR1_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_RLR1_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_RLR1_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_RLR1_LOCK = 0x80000000

	// HSEM_RLR2: HSEM Read lock register
	// Position of PROCID field.
	HSEM_HSEM_RLR2_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_RLR2_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_RLR2_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_RLR2_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_RLR2_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_RLR2_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_RLR2_LOCK = 0x80000000

	// HSEM_RLR3: HSEM Read lock register
	// Position of PROCID field.
	HSEM_HSEM_RLR3_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_RLR3_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_RLR3_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_RLR3_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_RLR3_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_RLR3_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_RLR3_LOCK = 0x80000000

	// HSEM_RLR4: HSEM Read lock register
	// Position of PROCID field.
	HSEM_HSEM_RLR4_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_RLR4_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_RLR4_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_RLR4_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_RLR4_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_RLR4_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_RLR4_LOCK = 0x80000000

	// HSEM_RLR5: HSEM Read lock register
	// Position of PROCID field.
	HSEM_HSEM_RLR5_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_RLR5_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_RLR5_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_RLR5_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_RLR5_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_RLR5_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_RLR5_LOCK = 0x80000000

	// HSEM_RLR6: HSEM Read lock register
	// Position of PROCID field.
	HSEM_HSEM_RLR6_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_RLR6_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_RLR6_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_RLR6_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_RLR6_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_RLR6_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_RLR6_LOCK = 0x80000000

	// HSEM_RLR7: HSEM Read lock register
	// Position of PROCID field.
	HSEM_HSEM_RLR7_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_RLR7_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_RLR7_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_RLR7_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_RLR7_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_RLR7_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_RLR7_LOCK = 0x80000000

	// HSEM_RLR8: HSEM Read lock register
	// Position of PROCID field.
	HSEM_HSEM_RLR8_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_RLR8_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_RLR8_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_RLR8_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_RLR8_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_RLR8_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_RLR8_LOCK = 0x80000000

	// HSEM_RLR9: HSEM Read lock register
	// Position of PROCID field.
	HSEM_HSEM_RLR9_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_RLR9_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_RLR9_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_RLR9_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_RLR9_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_RLR9_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_RLR9_LOCK = 0x80000000

	// HSEM_RLR10: HSEM Read lock register
	// Position of PROCID field.
	HSEM_HSEM_RLR10_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_RLR10_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_RLR10_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_RLR10_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_RLR10_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_RLR10_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_RLR10_LOCK = 0x80000000

	// HSEM_RLR11: HSEM Read lock register
	// Position of PROCID field.
	HSEM_HSEM_RLR11_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_RLR11_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_RLR11_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_RLR11_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_RLR11_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_RLR11_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_RLR11_LOCK = 0x80000000

	// HSEM_RLR12: HSEM Read lock register
	// Position of PROCID field.
	HSEM_HSEM_RLR12_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_RLR12_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_RLR12_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_RLR12_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_RLR12_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_RLR12_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_RLR12_LOCK = 0x80000000

	// HSEM_RLR13: HSEM Read lock register
	// Position of PROCID field.
	HSEM_HSEM_RLR13_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_RLR13_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_RLR13_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_RLR13_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_RLR13_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_RLR13_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_RLR13_LOCK = 0x80000000

	// HSEM_RLR14: HSEM Read lock register
	// Position of PROCID field.
	HSEM_HSEM_RLR14_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_RLR14_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_RLR14_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_RLR14_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_RLR14_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_RLR14_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_RLR14_LOCK = 0x80000000

	// HSEM_RLR15: HSEM Read lock register
	// Position of PROCID field.
	HSEM_HSEM_RLR15_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	HSEM_HSEM_RLR15_PROCID_Msk = 0xff
	// Position of COREID field.
	HSEM_HSEM_RLR15_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_RLR15_COREID_Msk = 0xf00
	// Position of LOCK field.
	HSEM_HSEM_RLR15_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	HSEM_HSEM_RLR15_LOCK_Msk = 0x80000000
	// Bit LOCK.
	HSEM_HSEM_RLR15_LOCK = 0x80000000

	// HSEM_C1IER: HSEM Interrupt enable register
	// Position of ISE0 field.
	HSEM_HSEM_C1IER_ISE0_Pos = 0x0
	// Bit mask of ISE0 field.
	HSEM_HSEM_C1IER_ISE0_Msk = 0x1
	// Bit ISE0.
	HSEM_HSEM_C1IER_ISE0 = 0x1
	// Position of ISE1 field.
	HSEM_HSEM_C1IER_ISE1_Pos = 0x1
	// Bit mask of ISE1 field.
	HSEM_HSEM_C1IER_ISE1_Msk = 0x2
	// Bit ISE1.
	HSEM_HSEM_C1IER_ISE1 = 0x2
	// Position of ISE2 field.
	HSEM_HSEM_C1IER_ISE2_Pos = 0x2
	// Bit mask of ISE2 field.
	HSEM_HSEM_C1IER_ISE2_Msk = 0x4
	// Bit ISE2.
	HSEM_HSEM_C1IER_ISE2 = 0x4
	// Position of ISE3 field.
	HSEM_HSEM_C1IER_ISE3_Pos = 0x3
	// Bit mask of ISE3 field.
	HSEM_HSEM_C1IER_ISE3_Msk = 0x8
	// Bit ISE3.
	HSEM_HSEM_C1IER_ISE3 = 0x8
	// Position of ISE4 field.
	HSEM_HSEM_C1IER_ISE4_Pos = 0x4
	// Bit mask of ISE4 field.
	HSEM_HSEM_C1IER_ISE4_Msk = 0x10
	// Bit ISE4.
	HSEM_HSEM_C1IER_ISE4 = 0x10
	// Position of ISE5 field.
	HSEM_HSEM_C1IER_ISE5_Pos = 0x5
	// Bit mask of ISE5 field.
	HSEM_HSEM_C1IER_ISE5_Msk = 0x20
	// Bit ISE5.
	HSEM_HSEM_C1IER_ISE5 = 0x20
	// Position of ISE6 field.
	HSEM_HSEM_C1IER_ISE6_Pos = 0x6
	// Bit mask of ISE6 field.
	HSEM_HSEM_C1IER_ISE6_Msk = 0x40
	// Bit ISE6.
	HSEM_HSEM_C1IER_ISE6 = 0x40
	// Position of ISE7 field.
	HSEM_HSEM_C1IER_ISE7_Pos = 0x7
	// Bit mask of ISE7 field.
	HSEM_HSEM_C1IER_ISE7_Msk = 0x80
	// Bit ISE7.
	HSEM_HSEM_C1IER_ISE7 = 0x80
	// Position of ISE8 field.
	HSEM_HSEM_C1IER_ISE8_Pos = 0x8
	// Bit mask of ISE8 field.
	HSEM_HSEM_C1IER_ISE8_Msk = 0x100
	// Bit ISE8.
	HSEM_HSEM_C1IER_ISE8 = 0x100
	// Position of ISE9 field.
	HSEM_HSEM_C1IER_ISE9_Pos = 0x9
	// Bit mask of ISE9 field.
	HSEM_HSEM_C1IER_ISE9_Msk = 0x200
	// Bit ISE9.
	HSEM_HSEM_C1IER_ISE9 = 0x200
	// Position of ISE10 field.
	HSEM_HSEM_C1IER_ISE10_Pos = 0xa
	// Bit mask of ISE10 field.
	HSEM_HSEM_C1IER_ISE10_Msk = 0x400
	// Bit ISE10.
	HSEM_HSEM_C1IER_ISE10 = 0x400
	// Position of ISE11 field.
	HSEM_HSEM_C1IER_ISE11_Pos = 0xb
	// Bit mask of ISE11 field.
	HSEM_HSEM_C1IER_ISE11_Msk = 0x800
	// Bit ISE11.
	HSEM_HSEM_C1IER_ISE11 = 0x800
	// Position of ISE12 field.
	HSEM_HSEM_C1IER_ISE12_Pos = 0xc
	// Bit mask of ISE12 field.
	HSEM_HSEM_C1IER_ISE12_Msk = 0x1000
	// Bit ISE12.
	HSEM_HSEM_C1IER_ISE12 = 0x1000
	// Position of ISE13 field.
	HSEM_HSEM_C1IER_ISE13_Pos = 0xd
	// Bit mask of ISE13 field.
	HSEM_HSEM_C1IER_ISE13_Msk = 0x2000
	// Bit ISE13.
	HSEM_HSEM_C1IER_ISE13 = 0x2000
	// Position of ISE14 field.
	HSEM_HSEM_C1IER_ISE14_Pos = 0xe
	// Bit mask of ISE14 field.
	HSEM_HSEM_C1IER_ISE14_Msk = 0x4000
	// Bit ISE14.
	HSEM_HSEM_C1IER_ISE14 = 0x4000
	// Position of ISE15 field.
	HSEM_HSEM_C1IER_ISE15_Pos = 0xf
	// Bit mask of ISE15 field.
	HSEM_HSEM_C1IER_ISE15_Msk = 0x8000
	// Bit ISE15.
	HSEM_HSEM_C1IER_ISE15 = 0x8000

	// HSEM_C1ICR: HSEM Interrupt clear register
	// Position of ISC0 field.
	HSEM_HSEM_C1ICR_ISC0_Pos = 0x0
	// Bit mask of ISC0 field.
	HSEM_HSEM_C1ICR_ISC0_Msk = 0x1
	// Bit ISC0.
	HSEM_HSEM_C1ICR_ISC0 = 0x1
	// Position of ISC1 field.
	HSEM_HSEM_C1ICR_ISC1_Pos = 0x1
	// Bit mask of ISC1 field.
	HSEM_HSEM_C1ICR_ISC1_Msk = 0x2
	// Bit ISC1.
	HSEM_HSEM_C1ICR_ISC1 = 0x2
	// Position of ISC2 field.
	HSEM_HSEM_C1ICR_ISC2_Pos = 0x2
	// Bit mask of ISC2 field.
	HSEM_HSEM_C1ICR_ISC2_Msk = 0x4
	// Bit ISC2.
	HSEM_HSEM_C1ICR_ISC2 = 0x4
	// Position of ISC3 field.
	HSEM_HSEM_C1ICR_ISC3_Pos = 0x3
	// Bit mask of ISC3 field.
	HSEM_HSEM_C1ICR_ISC3_Msk = 0x8
	// Bit ISC3.
	HSEM_HSEM_C1ICR_ISC3 = 0x8
	// Position of ISC4 field.
	HSEM_HSEM_C1ICR_ISC4_Pos = 0x4
	// Bit mask of ISC4 field.
	HSEM_HSEM_C1ICR_ISC4_Msk = 0x10
	// Bit ISC4.
	HSEM_HSEM_C1ICR_ISC4 = 0x10
	// Position of ISC5 field.
	HSEM_HSEM_C1ICR_ISC5_Pos = 0x5
	// Bit mask of ISC5 field.
	HSEM_HSEM_C1ICR_ISC5_Msk = 0x20
	// Bit ISC5.
	HSEM_HSEM_C1ICR_ISC5 = 0x20
	// Position of ISC6 field.
	HSEM_HSEM_C1ICR_ISC6_Pos = 0x6
	// Bit mask of ISC6 field.
	HSEM_HSEM_C1ICR_ISC6_Msk = 0x40
	// Bit ISC6.
	HSEM_HSEM_C1ICR_ISC6 = 0x40
	// Position of ISC7 field.
	HSEM_HSEM_C1ICR_ISC7_Pos = 0x7
	// Bit mask of ISC7 field.
	HSEM_HSEM_C1ICR_ISC7_Msk = 0x80
	// Bit ISC7.
	HSEM_HSEM_C1ICR_ISC7 = 0x80
	// Position of ISC8 field.
	HSEM_HSEM_C1ICR_ISC8_Pos = 0x8
	// Bit mask of ISC8 field.
	HSEM_HSEM_C1ICR_ISC8_Msk = 0x100
	// Bit ISC8.
	HSEM_HSEM_C1ICR_ISC8 = 0x100
	// Position of ISC9 field.
	HSEM_HSEM_C1ICR_ISC9_Pos = 0x9
	// Bit mask of ISC9 field.
	HSEM_HSEM_C1ICR_ISC9_Msk = 0x200
	// Bit ISC9.
	HSEM_HSEM_C1ICR_ISC9 = 0x200
	// Position of ISC10 field.
	HSEM_HSEM_C1ICR_ISC10_Pos = 0xa
	// Bit mask of ISC10 field.
	HSEM_HSEM_C1ICR_ISC10_Msk = 0x400
	// Bit ISC10.
	HSEM_HSEM_C1ICR_ISC10 = 0x400
	// Position of ISC11 field.
	HSEM_HSEM_C1ICR_ISC11_Pos = 0xb
	// Bit mask of ISC11 field.
	HSEM_HSEM_C1ICR_ISC11_Msk = 0x800
	// Bit ISC11.
	HSEM_HSEM_C1ICR_ISC11 = 0x800
	// Position of ISC12 field.
	HSEM_HSEM_C1ICR_ISC12_Pos = 0xc
	// Bit mask of ISC12 field.
	HSEM_HSEM_C1ICR_ISC12_Msk = 0x1000
	// Bit ISC12.
	HSEM_HSEM_C1ICR_ISC12 = 0x1000
	// Position of ISC13 field.
	HSEM_HSEM_C1ICR_ISC13_Pos = 0xd
	// Bit mask of ISC13 field.
	HSEM_HSEM_C1ICR_ISC13_Msk = 0x2000
	// Bit ISC13.
	HSEM_HSEM_C1ICR_ISC13 = 0x2000
	// Position of ISC14 field.
	HSEM_HSEM_C1ICR_ISC14_Pos = 0xe
	// Bit mask of ISC14 field.
	HSEM_HSEM_C1ICR_ISC14_Msk = 0x4000
	// Bit ISC14.
	HSEM_HSEM_C1ICR_ISC14 = 0x4000
	// Position of ISC15 field.
	HSEM_HSEM_C1ICR_ISC15_Pos = 0xf
	// Bit mask of ISC15 field.
	HSEM_HSEM_C1ICR_ISC15_Msk = 0x8000
	// Bit ISC15.
	HSEM_HSEM_C1ICR_ISC15 = 0x8000

	// HSEM_C1ISR: HSEM Interrupt status register
	// Position of ISF0 field.
	HSEM_HSEM_C1ISR_ISF0_Pos = 0x0
	// Bit mask of ISF0 field.
	HSEM_HSEM_C1ISR_ISF0_Msk = 0x1
	// Bit ISF0.
	HSEM_HSEM_C1ISR_ISF0 = 0x1
	// Position of ISF1 field.
	HSEM_HSEM_C1ISR_ISF1_Pos = 0x1
	// Bit mask of ISF1 field.
	HSEM_HSEM_C1ISR_ISF1_Msk = 0x2
	// Bit ISF1.
	HSEM_HSEM_C1ISR_ISF1 = 0x2
	// Position of ISF2 field.
	HSEM_HSEM_C1ISR_ISF2_Pos = 0x2
	// Bit mask of ISF2 field.
	HSEM_HSEM_C1ISR_ISF2_Msk = 0x4
	// Bit ISF2.
	HSEM_HSEM_C1ISR_ISF2 = 0x4
	// Position of ISF3 field.
	HSEM_HSEM_C1ISR_ISF3_Pos = 0x3
	// Bit mask of ISF3 field.
	HSEM_HSEM_C1ISR_ISF3_Msk = 0x8
	// Bit ISF3.
	HSEM_HSEM_C1ISR_ISF3 = 0x8
	// Position of ISF4 field.
	HSEM_HSEM_C1ISR_ISF4_Pos = 0x4
	// Bit mask of ISF4 field.
	HSEM_HSEM_C1ISR_ISF4_Msk = 0x10
	// Bit ISF4.
	HSEM_HSEM_C1ISR_ISF4 = 0x10
	// Position of ISF5 field.
	HSEM_HSEM_C1ISR_ISF5_Pos = 0x5
	// Bit mask of ISF5 field.
	HSEM_HSEM_C1ISR_ISF5_Msk = 0x20
	// Bit ISF5.
	HSEM_HSEM_C1ISR_ISF5 = 0x20
	// Position of ISF6 field.
	HSEM_HSEM_C1ISR_ISF6_Pos = 0x6
	// Bit mask of ISF6 field.
	HSEM_HSEM_C1ISR_ISF6_Msk = 0x40
	// Bit ISF6.
	HSEM_HSEM_C1ISR_ISF6 = 0x40
	// Position of ISF7 field.
	HSEM_HSEM_C1ISR_ISF7_Pos = 0x7
	// Bit mask of ISF7 field.
	HSEM_HSEM_C1ISR_ISF7_Msk = 0x80
	// Bit ISF7.
	HSEM_HSEM_C1ISR_ISF7 = 0x80
	// Position of ISF8 field.
	HSEM_HSEM_C1ISR_ISF8_Pos = 0x8
	// Bit mask of ISF8 field.
	HSEM_HSEM_C1ISR_ISF8_Msk = 0x100
	// Bit ISF8.
	HSEM_HSEM_C1ISR_ISF8 = 0x100
	// Position of ISF9 field.
	HSEM_HSEM_C1ISR_ISF9_Pos = 0x9
	// Bit mask of ISF9 field.
	HSEM_HSEM_C1ISR_ISF9_Msk = 0x200
	// Bit ISF9.
	HSEM_HSEM_C1ISR_ISF9 = 0x200
	// Position of ISF10 field.
	HSEM_HSEM_C1ISR_ISF10_Pos = 0xa
	// Bit mask of ISF10 field.
	HSEM_HSEM_C1ISR_ISF10_Msk = 0x400
	// Bit ISF10.
	HSEM_HSEM_C1ISR_ISF10 = 0x400
	// Position of ISF11 field.
	HSEM_HSEM_C1ISR_ISF11_Pos = 0xb
	// Bit mask of ISF11 field.
	HSEM_HSEM_C1ISR_ISF11_Msk = 0x800
	// Bit ISF11.
	HSEM_HSEM_C1ISR_ISF11 = 0x800
	// Position of ISF12 field.
	HSEM_HSEM_C1ISR_ISF12_Pos = 0xc
	// Bit mask of ISF12 field.
	HSEM_HSEM_C1ISR_ISF12_Msk = 0x1000
	// Bit ISF12.
	HSEM_HSEM_C1ISR_ISF12 = 0x1000
	// Position of ISF13 field.
	HSEM_HSEM_C1ISR_ISF13_Pos = 0xd
	// Bit mask of ISF13 field.
	HSEM_HSEM_C1ISR_ISF13_Msk = 0x2000
	// Bit ISF13.
	HSEM_HSEM_C1ISR_ISF13 = 0x2000
	// Position of ISF14 field.
	HSEM_HSEM_C1ISR_ISF14_Pos = 0xe
	// Bit mask of ISF14 field.
	HSEM_HSEM_C1ISR_ISF14_Msk = 0x4000
	// Bit ISF14.
	HSEM_HSEM_C1ISR_ISF14 = 0x4000
	// Position of ISF15 field.
	HSEM_HSEM_C1ISR_ISF15_Pos = 0xf
	// Bit mask of ISF15 field.
	HSEM_HSEM_C1ISR_ISF15_Msk = 0x8000
	// Bit ISF15.
	HSEM_HSEM_C1ISR_ISF15 = 0x8000

	// HSEM_C1MISR: HSEM Masked interrupt status register
	// Position of MISF0 field.
	HSEM_HSEM_C1MISR_MISF0_Pos = 0x0
	// Bit mask of MISF0 field.
	HSEM_HSEM_C1MISR_MISF0_Msk = 0x1
	// Bit MISF0.
	HSEM_HSEM_C1MISR_MISF0 = 0x1
	// Position of MISF1 field.
	HSEM_HSEM_C1MISR_MISF1_Pos = 0x1
	// Bit mask of MISF1 field.
	HSEM_HSEM_C1MISR_MISF1_Msk = 0x2
	// Bit MISF1.
	HSEM_HSEM_C1MISR_MISF1 = 0x2
	// Position of MISF2 field.
	HSEM_HSEM_C1MISR_MISF2_Pos = 0x2
	// Bit mask of MISF2 field.
	HSEM_HSEM_C1MISR_MISF2_Msk = 0x4
	// Bit MISF2.
	HSEM_HSEM_C1MISR_MISF2 = 0x4
	// Position of MISF3 field.
	HSEM_HSEM_C1MISR_MISF3_Pos = 0x3
	// Bit mask of MISF3 field.
	HSEM_HSEM_C1MISR_MISF3_Msk = 0x8
	// Bit MISF3.
	HSEM_HSEM_C1MISR_MISF3 = 0x8
	// Position of MISF4 field.
	HSEM_HSEM_C1MISR_MISF4_Pos = 0x4
	// Bit mask of MISF4 field.
	HSEM_HSEM_C1MISR_MISF4_Msk = 0x10
	// Bit MISF4.
	HSEM_HSEM_C1MISR_MISF4 = 0x10
	// Position of MISF5 field.
	HSEM_HSEM_C1MISR_MISF5_Pos = 0x5
	// Bit mask of MISF5 field.
	HSEM_HSEM_C1MISR_MISF5_Msk = 0x20
	// Bit MISF5.
	HSEM_HSEM_C1MISR_MISF5 = 0x20
	// Position of MISF6 field.
	HSEM_HSEM_C1MISR_MISF6_Pos = 0x6
	// Bit mask of MISF6 field.
	HSEM_HSEM_C1MISR_MISF6_Msk = 0x40
	// Bit MISF6.
	HSEM_HSEM_C1MISR_MISF6 = 0x40
	// Position of MISF7 field.
	HSEM_HSEM_C1MISR_MISF7_Pos = 0x7
	// Bit mask of MISF7 field.
	HSEM_HSEM_C1MISR_MISF7_Msk = 0x80
	// Bit MISF7.
	HSEM_HSEM_C1MISR_MISF7 = 0x80
	// Position of MISF8 field.
	HSEM_HSEM_C1MISR_MISF8_Pos = 0x8
	// Bit mask of MISF8 field.
	HSEM_HSEM_C1MISR_MISF8_Msk = 0x100
	// Bit MISF8.
	HSEM_HSEM_C1MISR_MISF8 = 0x100
	// Position of MISF9 field.
	HSEM_HSEM_C1MISR_MISF9_Pos = 0x9
	// Bit mask of MISF9 field.
	HSEM_HSEM_C1MISR_MISF9_Msk = 0x200
	// Bit MISF9.
	HSEM_HSEM_C1MISR_MISF9 = 0x200
	// Position of MISF10 field.
	HSEM_HSEM_C1MISR_MISF10_Pos = 0xa
	// Bit mask of MISF10 field.
	HSEM_HSEM_C1MISR_MISF10_Msk = 0x400
	// Bit MISF10.
	HSEM_HSEM_C1MISR_MISF10 = 0x400
	// Position of MISF11 field.
	HSEM_HSEM_C1MISR_MISF11_Pos = 0xb
	// Bit mask of MISF11 field.
	HSEM_HSEM_C1MISR_MISF11_Msk = 0x800
	// Bit MISF11.
	HSEM_HSEM_C1MISR_MISF11 = 0x800
	// Position of MISF12 field.
	HSEM_HSEM_C1MISR_MISF12_Pos = 0xc
	// Bit mask of MISF12 field.
	HSEM_HSEM_C1MISR_MISF12_Msk = 0x1000
	// Bit MISF12.
	HSEM_HSEM_C1MISR_MISF12 = 0x1000
	// Position of MISF13 field.
	HSEM_HSEM_C1MISR_MISF13_Pos = 0xd
	// Bit mask of MISF13 field.
	HSEM_HSEM_C1MISR_MISF13_Msk = 0x2000
	// Bit MISF13.
	HSEM_HSEM_C1MISR_MISF13 = 0x2000
	// Position of MISF14 field.
	HSEM_HSEM_C1MISR_MISF14_Pos = 0xe
	// Bit mask of MISF14 field.
	HSEM_HSEM_C1MISR_MISF14_Msk = 0x4000
	// Bit MISF14.
	HSEM_HSEM_C1MISR_MISF14 = 0x4000
	// Position of MISF15 field.
	HSEM_HSEM_C1MISR_MISF15_Pos = 0xf
	// Bit mask of MISF15 field.
	HSEM_HSEM_C1MISR_MISF15_Msk = 0x8000
	// Bit MISF15.
	HSEM_HSEM_C1MISR_MISF15 = 0x8000

	// HSEM_C2IER: HSEM Interrupt enable register
	// Position of ISE0 field.
	HSEM_HSEM_C2IER_ISE0_Pos = 0x0
	// Bit mask of ISE0 field.
	HSEM_HSEM_C2IER_ISE0_Msk = 0x1
	// Bit ISE0.
	HSEM_HSEM_C2IER_ISE0 = 0x1
	// Position of ISE1 field.
	HSEM_HSEM_C2IER_ISE1_Pos = 0x1
	// Bit mask of ISE1 field.
	HSEM_HSEM_C2IER_ISE1_Msk = 0x2
	// Bit ISE1.
	HSEM_HSEM_C2IER_ISE1 = 0x2
	// Position of ISE2 field.
	HSEM_HSEM_C2IER_ISE2_Pos = 0x2
	// Bit mask of ISE2 field.
	HSEM_HSEM_C2IER_ISE2_Msk = 0x4
	// Bit ISE2.
	HSEM_HSEM_C2IER_ISE2 = 0x4
	// Position of ISE3 field.
	HSEM_HSEM_C2IER_ISE3_Pos = 0x3
	// Bit mask of ISE3 field.
	HSEM_HSEM_C2IER_ISE3_Msk = 0x8
	// Bit ISE3.
	HSEM_HSEM_C2IER_ISE3 = 0x8
	// Position of ISE4 field.
	HSEM_HSEM_C2IER_ISE4_Pos = 0x4
	// Bit mask of ISE4 field.
	HSEM_HSEM_C2IER_ISE4_Msk = 0x10
	// Bit ISE4.
	HSEM_HSEM_C2IER_ISE4 = 0x10
	// Position of ISE5 field.
	HSEM_HSEM_C2IER_ISE5_Pos = 0x5
	// Bit mask of ISE5 field.
	HSEM_HSEM_C2IER_ISE5_Msk = 0x20
	// Bit ISE5.
	HSEM_HSEM_C2IER_ISE5 = 0x20
	// Position of ISE6 field.
	HSEM_HSEM_C2IER_ISE6_Pos = 0x6
	// Bit mask of ISE6 field.
	HSEM_HSEM_C2IER_ISE6_Msk = 0x40
	// Bit ISE6.
	HSEM_HSEM_C2IER_ISE6 = 0x40
	// Position of ISE7 field.
	HSEM_HSEM_C2IER_ISE7_Pos = 0x7
	// Bit mask of ISE7 field.
	HSEM_HSEM_C2IER_ISE7_Msk = 0x80
	// Bit ISE7.
	HSEM_HSEM_C2IER_ISE7 = 0x80
	// Position of ISE8 field.
	HSEM_HSEM_C2IER_ISE8_Pos = 0x8
	// Bit mask of ISE8 field.
	HSEM_HSEM_C2IER_ISE8_Msk = 0x100
	// Bit ISE8.
	HSEM_HSEM_C2IER_ISE8 = 0x100
	// Position of ISE9 field.
	HSEM_HSEM_C2IER_ISE9_Pos = 0x9
	// Bit mask of ISE9 field.
	HSEM_HSEM_C2IER_ISE9_Msk = 0x200
	// Bit ISE9.
	HSEM_HSEM_C2IER_ISE9 = 0x200
	// Position of ISE10 field.
	HSEM_HSEM_C2IER_ISE10_Pos = 0xa
	// Bit mask of ISE10 field.
	HSEM_HSEM_C2IER_ISE10_Msk = 0x400
	// Bit ISE10.
	HSEM_HSEM_C2IER_ISE10 = 0x400
	// Position of ISE11 field.
	HSEM_HSEM_C2IER_ISE11_Pos = 0xb
	// Bit mask of ISE11 field.
	HSEM_HSEM_C2IER_ISE11_Msk = 0x800
	// Bit ISE11.
	HSEM_HSEM_C2IER_ISE11 = 0x800
	// Position of ISE12 field.
	HSEM_HSEM_C2IER_ISE12_Pos = 0xc
	// Bit mask of ISE12 field.
	HSEM_HSEM_C2IER_ISE12_Msk = 0x1000
	// Bit ISE12.
	HSEM_HSEM_C2IER_ISE12 = 0x1000
	// Position of ISE13 field.
	HSEM_HSEM_C2IER_ISE13_Pos = 0xd
	// Bit mask of ISE13 field.
	HSEM_HSEM_C2IER_ISE13_Msk = 0x2000
	// Bit ISE13.
	HSEM_HSEM_C2IER_ISE13 = 0x2000
	// Position of ISE14 field.
	HSEM_HSEM_C2IER_ISE14_Pos = 0xe
	// Bit mask of ISE14 field.
	HSEM_HSEM_C2IER_ISE14_Msk = 0x4000
	// Bit ISE14.
	HSEM_HSEM_C2IER_ISE14 = 0x4000
	// Position of ISE15 field.
	HSEM_HSEM_C2IER_ISE15_Pos = 0xf
	// Bit mask of ISE15 field.
	HSEM_HSEM_C2IER_ISE15_Msk = 0x8000
	// Bit ISE15.
	HSEM_HSEM_C2IER_ISE15 = 0x8000

	// HSEM_C2ICR: HSEM Interrupt clear register
	// Position of ISC0 field.
	HSEM_HSEM_C2ICR_ISC0_Pos = 0x0
	// Bit mask of ISC0 field.
	HSEM_HSEM_C2ICR_ISC0_Msk = 0x1
	// Bit ISC0.
	HSEM_HSEM_C2ICR_ISC0 = 0x1
	// Position of ISC1 field.
	HSEM_HSEM_C2ICR_ISC1_Pos = 0x1
	// Bit mask of ISC1 field.
	HSEM_HSEM_C2ICR_ISC1_Msk = 0x2
	// Bit ISC1.
	HSEM_HSEM_C2ICR_ISC1 = 0x2
	// Position of ISC2 field.
	HSEM_HSEM_C2ICR_ISC2_Pos = 0x2
	// Bit mask of ISC2 field.
	HSEM_HSEM_C2ICR_ISC2_Msk = 0x4
	// Bit ISC2.
	HSEM_HSEM_C2ICR_ISC2 = 0x4
	// Position of ISC3 field.
	HSEM_HSEM_C2ICR_ISC3_Pos = 0x3
	// Bit mask of ISC3 field.
	HSEM_HSEM_C2ICR_ISC3_Msk = 0x8
	// Bit ISC3.
	HSEM_HSEM_C2ICR_ISC3 = 0x8
	// Position of ISC4 field.
	HSEM_HSEM_C2ICR_ISC4_Pos = 0x4
	// Bit mask of ISC4 field.
	HSEM_HSEM_C2ICR_ISC4_Msk = 0x10
	// Bit ISC4.
	HSEM_HSEM_C2ICR_ISC4 = 0x10
	// Position of ISC5 field.
	HSEM_HSEM_C2ICR_ISC5_Pos = 0x5
	// Bit mask of ISC5 field.
	HSEM_HSEM_C2ICR_ISC5_Msk = 0x20
	// Bit ISC5.
	HSEM_HSEM_C2ICR_ISC5 = 0x20
	// Position of ISC6 field.
	HSEM_HSEM_C2ICR_ISC6_Pos = 0x6
	// Bit mask of ISC6 field.
	HSEM_HSEM_C2ICR_ISC6_Msk = 0x40
	// Bit ISC6.
	HSEM_HSEM_C2ICR_ISC6 = 0x40
	// Position of ISC7 field.
	HSEM_HSEM_C2ICR_ISC7_Pos = 0x7
	// Bit mask of ISC7 field.
	HSEM_HSEM_C2ICR_ISC7_Msk = 0x80
	// Bit ISC7.
	HSEM_HSEM_C2ICR_ISC7 = 0x80
	// Position of ISC8 field.
	HSEM_HSEM_C2ICR_ISC8_Pos = 0x8
	// Bit mask of ISC8 field.
	HSEM_HSEM_C2ICR_ISC8_Msk = 0x100
	// Bit ISC8.
	HSEM_HSEM_C2ICR_ISC8 = 0x100
	// Position of ISC9 field.
	HSEM_HSEM_C2ICR_ISC9_Pos = 0x9
	// Bit mask of ISC9 field.
	HSEM_HSEM_C2ICR_ISC9_Msk = 0x200
	// Bit ISC9.
	HSEM_HSEM_C2ICR_ISC9 = 0x200
	// Position of ISC10 field.
	HSEM_HSEM_C2ICR_ISC10_Pos = 0xa
	// Bit mask of ISC10 field.
	HSEM_HSEM_C2ICR_ISC10_Msk = 0x400
	// Bit ISC10.
	HSEM_HSEM_C2ICR_ISC10 = 0x400
	// Position of ISC11 field.
	HSEM_HSEM_C2ICR_ISC11_Pos = 0xb
	// Bit mask of ISC11 field.
	HSEM_HSEM_C2ICR_ISC11_Msk = 0x800
	// Bit ISC11.
	HSEM_HSEM_C2ICR_ISC11 = 0x800
	// Position of ISC12 field.
	HSEM_HSEM_C2ICR_ISC12_Pos = 0xc
	// Bit mask of ISC12 field.
	HSEM_HSEM_C2ICR_ISC12_Msk = 0x1000
	// Bit ISC12.
	HSEM_HSEM_C2ICR_ISC12 = 0x1000
	// Position of ISC13 field.
	HSEM_HSEM_C2ICR_ISC13_Pos = 0xd
	// Bit mask of ISC13 field.
	HSEM_HSEM_C2ICR_ISC13_Msk = 0x2000
	// Bit ISC13.
	HSEM_HSEM_C2ICR_ISC13 = 0x2000
	// Position of ISC14 field.
	HSEM_HSEM_C2ICR_ISC14_Pos = 0xe
	// Bit mask of ISC14 field.
	HSEM_HSEM_C2ICR_ISC14_Msk = 0x4000
	// Bit ISC14.
	HSEM_HSEM_C2ICR_ISC14 = 0x4000
	// Position of ISC15 field.
	HSEM_HSEM_C2ICR_ISC15_Pos = 0xf
	// Bit mask of ISC15 field.
	HSEM_HSEM_C2ICR_ISC15_Msk = 0x8000
	// Bit ISC15.
	HSEM_HSEM_C2ICR_ISC15 = 0x8000

	// HSEM_C2ISR: HSEM Interrupt status register
	// Position of ISF0 field.
	HSEM_HSEM_C2ISR_ISF0_Pos = 0x0
	// Bit mask of ISF0 field.
	HSEM_HSEM_C2ISR_ISF0_Msk = 0x1
	// Bit ISF0.
	HSEM_HSEM_C2ISR_ISF0 = 0x1
	// Position of ISF1 field.
	HSEM_HSEM_C2ISR_ISF1_Pos = 0x1
	// Bit mask of ISF1 field.
	HSEM_HSEM_C2ISR_ISF1_Msk = 0x2
	// Bit ISF1.
	HSEM_HSEM_C2ISR_ISF1 = 0x2
	// Position of ISF2 field.
	HSEM_HSEM_C2ISR_ISF2_Pos = 0x2
	// Bit mask of ISF2 field.
	HSEM_HSEM_C2ISR_ISF2_Msk = 0x4
	// Bit ISF2.
	HSEM_HSEM_C2ISR_ISF2 = 0x4
	// Position of ISF3 field.
	HSEM_HSEM_C2ISR_ISF3_Pos = 0x3
	// Bit mask of ISF3 field.
	HSEM_HSEM_C2ISR_ISF3_Msk = 0x8
	// Bit ISF3.
	HSEM_HSEM_C2ISR_ISF3 = 0x8
	// Position of ISF4 field.
	HSEM_HSEM_C2ISR_ISF4_Pos = 0x4
	// Bit mask of ISF4 field.
	HSEM_HSEM_C2ISR_ISF4_Msk = 0x10
	// Bit ISF4.
	HSEM_HSEM_C2ISR_ISF4 = 0x10
	// Position of ISF5 field.
	HSEM_HSEM_C2ISR_ISF5_Pos = 0x5
	// Bit mask of ISF5 field.
	HSEM_HSEM_C2ISR_ISF5_Msk = 0x20
	// Bit ISF5.
	HSEM_HSEM_C2ISR_ISF5 = 0x20
	// Position of ISF6 field.
	HSEM_HSEM_C2ISR_ISF6_Pos = 0x6
	// Bit mask of ISF6 field.
	HSEM_HSEM_C2ISR_ISF6_Msk = 0x40
	// Bit ISF6.
	HSEM_HSEM_C2ISR_ISF6 = 0x40
	// Position of ISF7 field.
	HSEM_HSEM_C2ISR_ISF7_Pos = 0x7
	// Bit mask of ISF7 field.
	HSEM_HSEM_C2ISR_ISF7_Msk = 0x80
	// Bit ISF7.
	HSEM_HSEM_C2ISR_ISF7 = 0x80
	// Position of ISF8 field.
	HSEM_HSEM_C2ISR_ISF8_Pos = 0x8
	// Bit mask of ISF8 field.
	HSEM_HSEM_C2ISR_ISF8_Msk = 0x100
	// Bit ISF8.
	HSEM_HSEM_C2ISR_ISF8 = 0x100
	// Position of ISF9 field.
	HSEM_HSEM_C2ISR_ISF9_Pos = 0x9
	// Bit mask of ISF9 field.
	HSEM_HSEM_C2ISR_ISF9_Msk = 0x200
	// Bit ISF9.
	HSEM_HSEM_C2ISR_ISF9 = 0x200
	// Position of ISF10 field.
	HSEM_HSEM_C2ISR_ISF10_Pos = 0xa
	// Bit mask of ISF10 field.
	HSEM_HSEM_C2ISR_ISF10_Msk = 0x400
	// Bit ISF10.
	HSEM_HSEM_C2ISR_ISF10 = 0x400
	// Position of ISF11 field.
	HSEM_HSEM_C2ISR_ISF11_Pos = 0xb
	// Bit mask of ISF11 field.
	HSEM_HSEM_C2ISR_ISF11_Msk = 0x800
	// Bit ISF11.
	HSEM_HSEM_C2ISR_ISF11 = 0x800
	// Position of ISF12 field.
	HSEM_HSEM_C2ISR_ISF12_Pos = 0xc
	// Bit mask of ISF12 field.
	HSEM_HSEM_C2ISR_ISF12_Msk = 0x1000
	// Bit ISF12.
	HSEM_HSEM_C2ISR_ISF12 = 0x1000
	// Position of ISF13 field.
	HSEM_HSEM_C2ISR_ISF13_Pos = 0xd
	// Bit mask of ISF13 field.
	HSEM_HSEM_C2ISR_ISF13_Msk = 0x2000
	// Bit ISF13.
	HSEM_HSEM_C2ISR_ISF13 = 0x2000
	// Position of ISF14 field.
	HSEM_HSEM_C2ISR_ISF14_Pos = 0xe
	// Bit mask of ISF14 field.
	HSEM_HSEM_C2ISR_ISF14_Msk = 0x4000
	// Bit ISF14.
	HSEM_HSEM_C2ISR_ISF14 = 0x4000
	// Position of ISF15 field.
	HSEM_HSEM_C2ISR_ISF15_Pos = 0xf
	// Bit mask of ISF15 field.
	HSEM_HSEM_C2ISR_ISF15_Msk = 0x8000
	// Bit ISF15.
	HSEM_HSEM_C2ISR_ISF15 = 0x8000

	// HSEM_C2MISR: HSEM Masked interrupt status register
	// Position of MISF0 field.
	HSEM_HSEM_C2MISR_MISF0_Pos = 0x0
	// Bit mask of MISF0 field.
	HSEM_HSEM_C2MISR_MISF0_Msk = 0x1
	// Bit MISF0.
	HSEM_HSEM_C2MISR_MISF0 = 0x1
	// Position of MISF1 field.
	HSEM_HSEM_C2MISR_MISF1_Pos = 0x1
	// Bit mask of MISF1 field.
	HSEM_HSEM_C2MISR_MISF1_Msk = 0x2
	// Bit MISF1.
	HSEM_HSEM_C2MISR_MISF1 = 0x2
	// Position of MISF2 field.
	HSEM_HSEM_C2MISR_MISF2_Pos = 0x2
	// Bit mask of MISF2 field.
	HSEM_HSEM_C2MISR_MISF2_Msk = 0x4
	// Bit MISF2.
	HSEM_HSEM_C2MISR_MISF2 = 0x4
	// Position of MISF3 field.
	HSEM_HSEM_C2MISR_MISF3_Pos = 0x3
	// Bit mask of MISF3 field.
	HSEM_HSEM_C2MISR_MISF3_Msk = 0x8
	// Bit MISF3.
	HSEM_HSEM_C2MISR_MISF3 = 0x8
	// Position of MISF4 field.
	HSEM_HSEM_C2MISR_MISF4_Pos = 0x4
	// Bit mask of MISF4 field.
	HSEM_HSEM_C2MISR_MISF4_Msk = 0x10
	// Bit MISF4.
	HSEM_HSEM_C2MISR_MISF4 = 0x10
	// Position of MISF5 field.
	HSEM_HSEM_C2MISR_MISF5_Pos = 0x5
	// Bit mask of MISF5 field.
	HSEM_HSEM_C2MISR_MISF5_Msk = 0x20
	// Bit MISF5.
	HSEM_HSEM_C2MISR_MISF5 = 0x20
	// Position of MISF6 field.
	HSEM_HSEM_C2MISR_MISF6_Pos = 0x6
	// Bit mask of MISF6 field.
	HSEM_HSEM_C2MISR_MISF6_Msk = 0x40
	// Bit MISF6.
	HSEM_HSEM_C2MISR_MISF6 = 0x40
	// Position of MISF7 field.
	HSEM_HSEM_C2MISR_MISF7_Pos = 0x7
	// Bit mask of MISF7 field.
	HSEM_HSEM_C2MISR_MISF7_Msk = 0x80
	// Bit MISF7.
	HSEM_HSEM_C2MISR_MISF7 = 0x80
	// Position of MISF8 field.
	HSEM_HSEM_C2MISR_MISF8_Pos = 0x8
	// Bit mask of MISF8 field.
	HSEM_HSEM_C2MISR_MISF8_Msk = 0x100
	// Bit MISF8.
	HSEM_HSEM_C2MISR_MISF8 = 0x100
	// Position of MISF9 field.
	HSEM_HSEM_C2MISR_MISF9_Pos = 0x9
	// Bit mask of MISF9 field.
	HSEM_HSEM_C2MISR_MISF9_Msk = 0x200
	// Bit MISF9.
	HSEM_HSEM_C2MISR_MISF9 = 0x200
	// Position of MISF10 field.
	HSEM_HSEM_C2MISR_MISF10_Pos = 0xa
	// Bit mask of MISF10 field.
	HSEM_HSEM_C2MISR_MISF10_Msk = 0x400
	// Bit MISF10.
	HSEM_HSEM_C2MISR_MISF10 = 0x400
	// Position of MISF11 field.
	HSEM_HSEM_C2MISR_MISF11_Pos = 0xb
	// Bit mask of MISF11 field.
	HSEM_HSEM_C2MISR_MISF11_Msk = 0x800
	// Bit MISF11.
	HSEM_HSEM_C2MISR_MISF11 = 0x800
	// Position of MISF12 field.
	HSEM_HSEM_C2MISR_MISF12_Pos = 0xc
	// Bit mask of MISF12 field.
	HSEM_HSEM_C2MISR_MISF12_Msk = 0x1000
	// Bit MISF12.
	HSEM_HSEM_C2MISR_MISF12 = 0x1000
	// Position of MISF13 field.
	HSEM_HSEM_C2MISR_MISF13_Pos = 0xd
	// Bit mask of MISF13 field.
	HSEM_HSEM_C2MISR_MISF13_Msk = 0x2000
	// Bit MISF13.
	HSEM_HSEM_C2MISR_MISF13 = 0x2000
	// Position of MISF14 field.
	HSEM_HSEM_C2MISR_MISF14_Pos = 0xe
	// Bit mask of MISF14 field.
	HSEM_HSEM_C2MISR_MISF14_Msk = 0x4000
	// Bit MISF14.
	HSEM_HSEM_C2MISR_MISF14 = 0x4000
	// Position of MISF15 field.
	HSEM_HSEM_C2MISR_MISF15_Pos = 0xf
	// Bit mask of MISF15 field.
	HSEM_HSEM_C2MISR_MISF15_Msk = 0x8000
	// Bit MISF15.
	HSEM_HSEM_C2MISR_MISF15 = 0x8000

	// HSEM_CR: HSEM Clear register
	// Position of COREID field.
	HSEM_HSEM_CR_COREID_Pos = 0x8
	// Bit mask of COREID field.
	HSEM_HSEM_CR_COREID_Msk = 0xf00
	// Position of KEY field.
	HSEM_HSEM_CR_KEY_Pos = 0x10
	// Bit mask of KEY field.
	HSEM_HSEM_CR_KEY_Msk = 0xffff0000

	// HSEM_KEYR: HSEM Interrupt clear register
	// Position of KEY field.
	HSEM_HSEM_KEYR_KEY_Pos = 0x10
	// Bit mask of KEY field.
	HSEM_HSEM_KEYR_KEY_Msk = 0xffff0000
)

// Bitfields for I2C1: Inter-integrated circuit
const (
	// CR1: Control register 1
	// Position of PE field.
	I2C_CR1_PE_Pos = 0x0
	// Bit mask of PE field.
	I2C_CR1_PE_Msk = 0x1
	// Bit PE.
	I2C_CR1_PE = 0x1
	// Position of TXIE field.
	I2C_CR1_TXIE_Pos = 0x1
	// Bit mask of TXIE field.
	I2C_CR1_TXIE_Msk = 0x2
	// Bit TXIE.
	I2C_CR1_TXIE = 0x2
	// Position of RXIE field.
	I2C_CR1_RXIE_Pos = 0x2
	// Bit mask of RXIE field.
	I2C_CR1_RXIE_Msk = 0x4
	// Bit RXIE.
	I2C_CR1_RXIE = 0x4
	// Position of ADDRIE field.
	I2C_CR1_ADDRIE_Pos = 0x3
	// Bit mask of ADDRIE field.
	I2C_CR1_ADDRIE_Msk = 0x8
	// Bit ADDRIE.
	I2C_CR1_ADDRIE = 0x8
	// Position of NACKIE field.
	I2C_CR1_NACKIE_Pos = 0x4
	// Bit mask of NACKIE field.
	I2C_CR1_NACKIE_Msk = 0x10
	// Bit NACKIE.
	I2C_CR1_NACKIE = 0x10
	// Position of STOPIE field.
	I2C_CR1_STOPIE_Pos = 0x5
	// Bit mask of STOPIE field.
	I2C_CR1_STOPIE_Msk = 0x20
	// Bit STOPIE.
	I2C_CR1_STOPIE = 0x20
	// Position of TCIE field.
	I2C_CR1_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	I2C_CR1_TCIE_Msk = 0x40
	// Bit TCIE.
	I2C_CR1_TCIE = 0x40
	// Position of ERRIE field.
	I2C_CR1_ERRIE_Pos = 0x7
	// Bit mask of ERRIE field.
	I2C_CR1_ERRIE_Msk = 0x80
	// Bit ERRIE.
	I2C_CR1_ERRIE = 0x80
	// Position of DNF field.
	I2C_CR1_DNF_Pos = 0x8
	// Bit mask of DNF field.
	I2C_CR1_DNF_Msk = 0xf00
	// Position of ANFOFF field.
	I2C_CR1_ANFOFF_Pos = 0xc
	// Bit mask of ANFOFF field.
	I2C_CR1_ANFOFF_Msk = 0x1000
	// Bit ANFOFF.
	I2C_CR1_ANFOFF = 0x1000
	// Position of TXDMAEN field.
	I2C_CR1_TXDMAEN_Pos = 0xe
	// Bit mask of TXDMAEN field.
	I2C_CR1_TXDMAEN_Msk = 0x4000
	// Bit TXDMAEN.
	I2C_CR1_TXDMAEN = 0x4000
	// Position of RXDMAEN field.
	I2C_CR1_RXDMAEN_Pos = 0xf
	// Bit mask of RXDMAEN field.
	I2C_CR1_RXDMAEN_Msk = 0x8000
	// Bit RXDMAEN.
	I2C_CR1_RXDMAEN = 0x8000
	// Position of SBC field.
	I2C_CR1_SBC_Pos = 0x10
	// Bit mask of SBC field.
	I2C_CR1_SBC_Msk = 0x10000
	// Bit SBC.
	I2C_CR1_SBC = 0x10000
	// Position of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Pos = 0x11
	// Bit mask of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Msk = 0x20000
	// Bit NOSTRETCH.
	I2C_CR1_NOSTRETCH = 0x20000
	// Position of WUPEN field.
	I2C_CR1_WUPEN_Pos = 0x12
	// Bit mask of WUPEN field.
	I2C_CR1_WUPEN_Msk = 0x40000
	// Bit WUPEN.
	I2C_CR1_WUPEN = 0x40000
	// Position of GCEN field.
	I2C_CR1_GCEN_Pos = 0x13
	// Bit mask of GCEN field.
	I2C_CR1_GCEN_Msk = 0x80000
	// Bit GCEN.
	I2C_CR1_GCEN = 0x80000
	// Position of SMBHEN field.
	I2C_CR1_SMBHEN_Pos = 0x14
	// Bit mask of SMBHEN field.
	I2C_CR1_SMBHEN_Msk = 0x100000
	// Bit SMBHEN.
	I2C_CR1_SMBHEN = 0x100000
	// Position of SMBDEN field.
	I2C_CR1_SMBDEN_Pos = 0x15
	// Bit mask of SMBDEN field.
	I2C_CR1_SMBDEN_Msk = 0x200000
	// Bit SMBDEN.
	I2C_CR1_SMBDEN = 0x200000
	// Position of ALERTEN field.
	I2C_CR1_ALERTEN_Pos = 0x16
	// Bit mask of ALERTEN field.
	I2C_CR1_ALERTEN_Msk = 0x400000
	// Bit ALERTEN.
	I2C_CR1_ALERTEN = 0x400000
	// Position of PECEN field.
	I2C_CR1_PECEN_Pos = 0x17
	// Bit mask of PECEN field.
	I2C_CR1_PECEN_Msk = 0x800000
	// Bit PECEN.
	I2C_CR1_PECEN = 0x800000

	// CR2: Control register 2
	// Position of PECBYTE field.
	I2C_CR2_PECBYTE_Pos = 0x1a
	// Bit mask of PECBYTE field.
	I2C_CR2_PECBYTE_Msk = 0x4000000
	// Bit PECBYTE.
	I2C_CR2_PECBYTE = 0x4000000
	// Position of AUTOEND field.
	I2C_CR2_AUTOEND_Pos = 0x19
	// Bit mask of AUTOEND field.
	I2C_CR2_AUTOEND_Msk = 0x2000000
	// Bit AUTOEND.
	I2C_CR2_AUTOEND = 0x2000000
	// Position of RELOAD field.
	I2C_CR2_RELOAD_Pos = 0x18
	// Bit mask of RELOAD field.
	I2C_CR2_RELOAD_Msk = 0x1000000
	// Bit RELOAD.
	I2C_CR2_RELOAD = 0x1000000
	// Position of NBYTES field.
	I2C_CR2_NBYTES_Pos = 0x10
	// Bit mask of NBYTES field.
	I2C_CR2_NBYTES_Msk = 0xff0000
	// Position of NACK field.
	I2C_CR2_NACK_Pos = 0xf
	// Bit mask of NACK field.
	I2C_CR2_NACK_Msk = 0x8000
	// Bit NACK.
	I2C_CR2_NACK = 0x8000
	// Position of STOP field.
	I2C_CR2_STOP_Pos = 0xe
	// Bit mask of STOP field.
	I2C_CR2_STOP_Msk = 0x4000
	// Bit STOP.
	I2C_CR2_STOP = 0x4000
	// Position of START field.
	I2C_CR2_START_Pos = 0xd
	// Bit mask of START field.
	I2C_CR2_START_Msk = 0x2000
	// Bit START.
	I2C_CR2_START = 0x2000
	// Position of HEAD10R field.
	I2C_CR2_HEAD10R_Pos = 0xc
	// Bit mask of HEAD10R field.
	I2C_CR2_HEAD10R_Msk = 0x1000
	// Bit HEAD10R.
	I2C_CR2_HEAD10R = 0x1000
	// Position of ADD10 field.
	I2C_CR2_ADD10_Pos = 0xb
	// Bit mask of ADD10 field.
	I2C_CR2_ADD10_Msk = 0x800
	// Bit ADD10.
	I2C_CR2_ADD10 = 0x800
	// Position of RD_WRN field.
	I2C_CR2_RD_WRN_Pos = 0xa
	// Bit mask of RD_WRN field.
	I2C_CR2_RD_WRN_Msk = 0x400
	// Bit RD_WRN.
	I2C_CR2_RD_WRN = 0x400
	// Position of SADD field.
	I2C_CR2_SADD_Pos = 0x0
	// Bit mask of SADD field.
	I2C_CR2_SADD_Msk = 0x3ff

	// OAR1: Own address register 1
	// Position of OA1 field.
	I2C_OAR1_OA1_Pos = 0x0
	// Bit mask of OA1 field.
	I2C_OAR1_OA1_Msk = 0x3ff
	// Position of OA1MODE field.
	I2C_OAR1_OA1MODE_Pos = 0xa
	// Bit mask of OA1MODE field.
	I2C_OAR1_OA1MODE_Msk = 0x400
	// Bit OA1MODE.
	I2C_OAR1_OA1MODE = 0x400
	// Position of OA1EN field.
	I2C_OAR1_OA1EN_Pos = 0xf
	// Bit mask of OA1EN field.
	I2C_OAR1_OA1EN_Msk = 0x8000
	// Bit OA1EN.
	I2C_OAR1_OA1EN = 0x8000

	// OAR2: Own address register 2
	// Position of OA2 field.
	I2C_OAR2_OA2_Pos = 0x1
	// Bit mask of OA2 field.
	I2C_OAR2_OA2_Msk = 0xfe
	// Position of OA2MSK field.
	I2C_OAR2_OA2MSK_Pos = 0x8
	// Bit mask of OA2MSK field.
	I2C_OAR2_OA2MSK_Msk = 0x700
	// Position of OA2EN field.
	I2C_OAR2_OA2EN_Pos = 0xf
	// Bit mask of OA2EN field.
	I2C_OAR2_OA2EN_Msk = 0x8000
	// Bit OA2EN.
	I2C_OAR2_OA2EN = 0x8000

	// TIMINGR: Timing register
	// Position of SCLL field.
	I2C_TIMINGR_SCLL_Pos = 0x0
	// Bit mask of SCLL field.
	I2C_TIMINGR_SCLL_Msk = 0xff
	// Position of SCLH field.
	I2C_TIMINGR_SCLH_Pos = 0x8
	// Bit mask of SCLH field.
	I2C_TIMINGR_SCLH_Msk = 0xff00
	// Position of SDADEL field.
	I2C_TIMINGR_SDADEL_Pos = 0x10
	// Bit mask of SDADEL field.
	I2C_TIMINGR_SDADEL_Msk = 0xf0000
	// Position of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Pos = 0x14
	// Bit mask of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Msk = 0xf00000
	// Position of PRESC field.
	I2C_TIMINGR_PRESC_Pos = 0x1c
	// Bit mask of PRESC field.
	I2C_TIMINGR_PRESC_Msk = 0xf0000000

	// TIMEOUTR: Status register 1
	// Position of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Pos = 0x0
	// Bit mask of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Msk = 0xfff
	// Position of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Pos = 0xc
	// Bit mask of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Msk = 0x1000
	// Bit TIDLE.
	I2C_TIMEOUTR_TIDLE = 0x1000
	// Position of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Pos = 0xf
	// Bit mask of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Msk = 0x8000
	// Bit TIMOUTEN.
	I2C_TIMEOUTR_TIMOUTEN = 0x8000
	// Position of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Pos = 0x10
	// Bit mask of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Msk = 0xfff0000
	// Position of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Pos = 0x1f
	// Bit mask of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Msk = 0x80000000
	// Bit TEXTEN.
	I2C_TIMEOUTR_TEXTEN = 0x80000000

	// ISR: Interrupt and Status register
	// Position of ADDCODE field.
	I2C_ISR_ADDCODE_Pos = 0x11
	// Bit mask of ADDCODE field.
	I2C_ISR_ADDCODE_Msk = 0xfe0000
	// Position of DIR field.
	I2C_ISR_DIR_Pos = 0x10
	// Bit mask of DIR field.
	I2C_ISR_DIR_Msk = 0x10000
	// Bit DIR.
	I2C_ISR_DIR = 0x10000
	// Position of BUSY field.
	I2C_ISR_BUSY_Pos = 0xf
	// Bit mask of BUSY field.
	I2C_ISR_BUSY_Msk = 0x8000
	// Bit BUSY.
	I2C_ISR_BUSY = 0x8000
	// Position of ALERT field.
	I2C_ISR_ALERT_Pos = 0xd
	// Bit mask of ALERT field.
	I2C_ISR_ALERT_Msk = 0x2000
	// Bit ALERT.
	I2C_ISR_ALERT = 0x2000
	// Position of TIMEOUT field.
	I2C_ISR_TIMEOUT_Pos = 0xc
	// Bit mask of TIMEOUT field.
	I2C_ISR_TIMEOUT_Msk = 0x1000
	// Bit TIMEOUT.
	I2C_ISR_TIMEOUT = 0x1000
	// Position of PECERR field.
	I2C_ISR_PECERR_Pos = 0xb
	// Bit mask of PECERR field.
	I2C_ISR_PECERR_Msk = 0x800
	// Bit PECERR.
	I2C_ISR_PECERR = 0x800
	// Position of OVR field.
	I2C_ISR_OVR_Pos = 0xa
	// Bit mask of OVR field.
	I2C_ISR_OVR_Msk = 0x400
	// Bit OVR.
	I2C_ISR_OVR = 0x400
	// Position of ARLO field.
	I2C_ISR_ARLO_Pos = 0x9
	// Bit mask of ARLO field.
	I2C_ISR_ARLO_Msk = 0x200
	// Bit ARLO.
	I2C_ISR_ARLO = 0x200
	// Position of BERR field.
	I2C_ISR_BERR_Pos = 0x8
	// Bit mask of BERR field.
	I2C_ISR_BERR_Msk = 0x100
	// Bit BERR.
	I2C_ISR_BERR = 0x100
	// Position of TCR field.
	I2C_ISR_TCR_Pos = 0x7
	// Bit mask of TCR field.
	I2C_ISR_TCR_Msk = 0x80
	// Bit TCR.
	I2C_ISR_TCR = 0x80
	// Position of TC field.
	I2C_ISR_TC_Pos = 0x6
	// Bit mask of TC field.
	I2C_ISR_TC_Msk = 0x40
	// Bit TC.
	I2C_ISR_TC = 0x40
	// Position of STOPF field.
	I2C_ISR_STOPF_Pos = 0x5
	// Bit mask of STOPF field.
	I2C_ISR_STOPF_Msk = 0x20
	// Bit STOPF.
	I2C_ISR_STOPF = 0x20
	// Position of NACKF field.
	I2C_ISR_NACKF_Pos = 0x4
	// Bit mask of NACKF field.
	I2C_ISR_NACKF_Msk = 0x10
	// Bit NACKF.
	I2C_ISR_NACKF = 0x10
	// Position of ADDR field.
	I2C_ISR_ADDR_Pos = 0x3
	// Bit mask of ADDR field.
	I2C_ISR_ADDR_Msk = 0x8
	// Bit ADDR.
	I2C_ISR_ADDR = 0x8
	// Position of RXNE field.
	I2C_ISR_RXNE_Pos = 0x2
	// Bit mask of RXNE field.
	I2C_ISR_RXNE_Msk = 0x4
	// Bit RXNE.
	I2C_ISR_RXNE = 0x4
	// Position of TXIS field.
	I2C_ISR_TXIS_Pos = 0x1
	// Bit mask of TXIS field.
	I2C_ISR_TXIS_Msk = 0x2
	// Bit TXIS.
	I2C_ISR_TXIS = 0x2
	// Position of TXE field.
	I2C_ISR_TXE_Pos = 0x0
	// Bit mask of TXE field.
	I2C_ISR_TXE_Msk = 0x1
	// Bit TXE.
	I2C_ISR_TXE = 0x1

	// ICR: Interrupt clear register
	// Position of ALERTCF field.
	I2C_ICR_ALERTCF_Pos = 0xd
	// Bit mask of ALERTCF field.
	I2C_ICR_ALERTCF_Msk = 0x2000
	// Bit ALERTCF.
	I2C_ICR_ALERTCF = 0x2000
	// Position of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Pos = 0xc
	// Bit mask of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Msk = 0x1000
	// Bit TIMOUTCF.
	I2C_ICR_TIMOUTCF = 0x1000
	// Position of PECCF field.
	I2C_ICR_PECCF_Pos = 0xb
	// Bit mask of PECCF field.
	I2C_ICR_PECCF_Msk = 0x800
	// Bit PECCF.
	I2C_ICR_PECCF = 0x800
	// Position of OVRCF field.
	I2C_ICR_OVRCF_Pos = 0xa
	// Bit mask of OVRCF field.
	I2C_ICR_OVRCF_Msk = 0x400
	// Bit OVRCF.
	I2C_ICR_OVRCF = 0x400
	// Position of ARLOCF field.
	I2C_ICR_ARLOCF_Pos = 0x9
	// Bit mask of ARLOCF field.
	I2C_ICR_ARLOCF_Msk = 0x200
	// Bit ARLOCF.
	I2C_ICR_ARLOCF = 0x200
	// Position of BERRCF field.
	I2C_ICR_BERRCF_Pos = 0x8
	// Bit mask of BERRCF field.
	I2C_ICR_BERRCF_Msk = 0x100
	// Bit BERRCF.
	I2C_ICR_BERRCF = 0x100
	// Position of STOPCF field.
	I2C_ICR_STOPCF_Pos = 0x5
	// Bit mask of STOPCF field.
	I2C_ICR_STOPCF_Msk = 0x20
	// Bit STOPCF.
	I2C_ICR_STOPCF = 0x20
	// Position of NACKCF field.
	I2C_ICR_NACKCF_Pos = 0x4
	// Bit mask of NACKCF field.
	I2C_ICR_NACKCF_Msk = 0x10
	// Bit NACKCF.
	I2C_ICR_NACKCF = 0x10
	// Position of ADDRCF field.
	I2C_ICR_ADDRCF_Pos = 0x3
	// Bit mask of ADDRCF field.
	I2C_ICR_ADDRCF_Msk = 0x8
	// Bit ADDRCF.
	I2C_ICR_ADDRCF = 0x8

	// PECR: PEC register
	// Position of PEC field.
	I2C_PECR_PEC_Pos = 0x0
	// Bit mask of PEC field.
	I2C_PECR_PEC_Msk = 0xff

	// RXDR: Receive data register
	// Position of RXDATA field.
	I2C_RXDR_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	I2C_RXDR_RXDATA_Msk = 0xff

	// TXDR: Transmit data register
	// Position of TXDATA field.
	I2C_TXDR_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	I2C_TXDR_TXDATA_Msk = 0xff
)

// Bitfields for IPCC: Inter Processor communication controller
const (
	// IPCC_C1CR: IPCC Processor 1 control register
	// Position of RXOIE field.
	IPCC_IPCC_C1CR_RXOIE_Pos = 0x0
	// Bit mask of RXOIE field.
	IPCC_IPCC_C1CR_RXOIE_Msk = 0x1
	// Bit RXOIE.
	IPCC_IPCC_C1CR_RXOIE = 0x1
	// Position of TXFIE field.
	IPCC_IPCC_C1CR_TXFIE_Pos = 0x10
	// Bit mask of TXFIE field.
	IPCC_IPCC_C1CR_TXFIE_Msk = 0x10000
	// Bit TXFIE.
	IPCC_IPCC_C1CR_TXFIE = 0x10000

	// IPCC_C1MR: IPCC Processor 1 mask register
	// Position of CH1OM field.
	IPCC_IPCC_C1MR_CH1OM_Pos = 0x0
	// Bit mask of CH1OM field.
	IPCC_IPCC_C1MR_CH1OM_Msk = 0x1
	// Bit CH1OM.
	IPCC_IPCC_C1MR_CH1OM = 0x1
	// Position of CH2OM field.
	IPCC_IPCC_C1MR_CH2OM_Pos = 0x1
	// Bit mask of CH2OM field.
	IPCC_IPCC_C1MR_CH2OM_Msk = 0x2
	// Bit CH2OM.
	IPCC_IPCC_C1MR_CH2OM = 0x2
	// Position of CH3OM field.
	IPCC_IPCC_C1MR_CH3OM_Pos = 0x2
	// Bit mask of CH3OM field.
	IPCC_IPCC_C1MR_CH3OM_Msk = 0x4
	// Bit CH3OM.
	IPCC_IPCC_C1MR_CH3OM = 0x4
	// Position of CH4OM field.
	IPCC_IPCC_C1MR_CH4OM_Pos = 0x3
	// Bit mask of CH4OM field.
	IPCC_IPCC_C1MR_CH4OM_Msk = 0x8
	// Bit CH4OM.
	IPCC_IPCC_C1MR_CH4OM = 0x8
	// Position of CH5OM field.
	IPCC_IPCC_C1MR_CH5OM_Pos = 0x4
	// Bit mask of CH5OM field.
	IPCC_IPCC_C1MR_CH5OM_Msk = 0x10
	// Bit CH5OM.
	IPCC_IPCC_C1MR_CH5OM = 0x10
	// Position of CH6OM field.
	IPCC_IPCC_C1MR_CH6OM_Pos = 0x5
	// Bit mask of CH6OM field.
	IPCC_IPCC_C1MR_CH6OM_Msk = 0x20
	// Bit CH6OM.
	IPCC_IPCC_C1MR_CH6OM = 0x20
	// Position of CH1FM field.
	IPCC_IPCC_C1MR_CH1FM_Pos = 0x10
	// Bit mask of CH1FM field.
	IPCC_IPCC_C1MR_CH1FM_Msk = 0x10000
	// Bit CH1FM.
	IPCC_IPCC_C1MR_CH1FM = 0x10000
	// Position of CH2FM field.
	IPCC_IPCC_C1MR_CH2FM_Pos = 0x11
	// Bit mask of CH2FM field.
	IPCC_IPCC_C1MR_CH2FM_Msk = 0x20000
	// Bit CH2FM.
	IPCC_IPCC_C1MR_CH2FM = 0x20000
	// Position of CH3FM field.
	IPCC_IPCC_C1MR_CH3FM_Pos = 0x12
	// Bit mask of CH3FM field.
	IPCC_IPCC_C1MR_CH3FM_Msk = 0x40000
	// Bit CH3FM.
	IPCC_IPCC_C1MR_CH3FM = 0x40000
	// Position of CH4FM field.
	IPCC_IPCC_C1MR_CH4FM_Pos = 0x13
	// Bit mask of CH4FM field.
	IPCC_IPCC_C1MR_CH4FM_Msk = 0x80000
	// Bit CH4FM.
	IPCC_IPCC_C1MR_CH4FM = 0x80000
	// Position of CH5FM field.
	IPCC_IPCC_C1MR_CH5FM_Pos = 0x14
	// Bit mask of CH5FM field.
	IPCC_IPCC_C1MR_CH5FM_Msk = 0x100000
	// Bit CH5FM.
	IPCC_IPCC_C1MR_CH5FM = 0x100000
	// Position of CH6FM field.
	IPCC_IPCC_C1MR_CH6FM_Pos = 0x15
	// Bit mask of CH6FM field.
	IPCC_IPCC_C1MR_CH6FM_Msk = 0x200000
	// Bit CH6FM.
	IPCC_IPCC_C1MR_CH6FM = 0x200000

	// IPCC_C1SCR: Reading this register will always return 0x0000 0000.
	// Position of CH1C field.
	IPCC_IPCC_C1SCR_CH1C_Pos = 0x0
	// Bit mask of CH1C field.
	IPCC_IPCC_C1SCR_CH1C_Msk = 0x1
	// Bit CH1C.
	IPCC_IPCC_C1SCR_CH1C = 0x1
	// Position of CH2C field.
	IPCC_IPCC_C1SCR_CH2C_Pos = 0x1
	// Bit mask of CH2C field.
	IPCC_IPCC_C1SCR_CH2C_Msk = 0x2
	// Bit CH2C.
	IPCC_IPCC_C1SCR_CH2C = 0x2
	// Position of CH3C field.
	IPCC_IPCC_C1SCR_CH3C_Pos = 0x2
	// Bit mask of CH3C field.
	IPCC_IPCC_C1SCR_CH3C_Msk = 0x4
	// Bit CH3C.
	IPCC_IPCC_C1SCR_CH3C = 0x4
	// Position of CH4C field.
	IPCC_IPCC_C1SCR_CH4C_Pos = 0x3
	// Bit mask of CH4C field.
	IPCC_IPCC_C1SCR_CH4C_Msk = 0x8
	// Bit CH4C.
	IPCC_IPCC_C1SCR_CH4C = 0x8
	// Position of CH5C field.
	IPCC_IPCC_C1SCR_CH5C_Pos = 0x4
	// Bit mask of CH5C field.
	IPCC_IPCC_C1SCR_CH5C_Msk = 0x10
	// Bit CH5C.
	IPCC_IPCC_C1SCR_CH5C = 0x10
	// Position of CH6C field.
	IPCC_IPCC_C1SCR_CH6C_Pos = 0x5
	// Bit mask of CH6C field.
	IPCC_IPCC_C1SCR_CH6C_Msk = 0x20
	// Bit CH6C.
	IPCC_IPCC_C1SCR_CH6C = 0x20
	// Position of CH1S field.
	IPCC_IPCC_C1SCR_CH1S_Pos = 0x10
	// Bit mask of CH1S field.
	IPCC_IPCC_C1SCR_CH1S_Msk = 0x10000
	// Bit CH1S.
	IPCC_IPCC_C1SCR_CH1S = 0x10000
	// Position of CH2S field.
	IPCC_IPCC_C1SCR_CH2S_Pos = 0x11
	// Bit mask of CH2S field.
	IPCC_IPCC_C1SCR_CH2S_Msk = 0x20000
	// Bit CH2S.
	IPCC_IPCC_C1SCR_CH2S = 0x20000
	// Position of CH3S field.
	IPCC_IPCC_C1SCR_CH3S_Pos = 0x12
	// Bit mask of CH3S field.
	IPCC_IPCC_C1SCR_CH3S_Msk = 0x40000
	// Bit CH3S.
	IPCC_IPCC_C1SCR_CH3S = 0x40000
	// Position of CH4S field.
	IPCC_IPCC_C1SCR_CH4S_Pos = 0x13
	// Bit mask of CH4S field.
	IPCC_IPCC_C1SCR_CH4S_Msk = 0x80000
	// Bit CH4S.
	IPCC_IPCC_C1SCR_CH4S = 0x80000
	// Position of CH5S field.
	IPCC_IPCC_C1SCR_CH5S_Pos = 0x14
	// Bit mask of CH5S field.
	IPCC_IPCC_C1SCR_CH5S_Msk = 0x100000
	// Bit CH5S.
	IPCC_IPCC_C1SCR_CH5S = 0x100000
	// Position of CH6S field.
	IPCC_IPCC_C1SCR_CH6S_Pos = 0x15
	// Bit mask of CH6S field.
	IPCC_IPCC_C1SCR_CH6S_Msk = 0x200000
	// Bit CH6S.
	IPCC_IPCC_C1SCR_CH6S = 0x200000

	// IPCC_C1TOC2SR: IPCC processor 1 to processor 2 status register
	// Position of CH1F field.
	IPCC_IPCC_C1TOC2SR_CH1F_Pos = 0x0
	// Bit mask of CH1F field.
	IPCC_IPCC_C1TOC2SR_CH1F_Msk = 0x1
	// Bit CH1F.
	IPCC_IPCC_C1TOC2SR_CH1F = 0x1
	// Position of CH2F field.
	IPCC_IPCC_C1TOC2SR_CH2F_Pos = 0x1
	// Bit mask of CH2F field.
	IPCC_IPCC_C1TOC2SR_CH2F_Msk = 0x2
	// Bit CH2F.
	IPCC_IPCC_C1TOC2SR_CH2F = 0x2
	// Position of CH3F field.
	IPCC_IPCC_C1TOC2SR_CH3F_Pos = 0x2
	// Bit mask of CH3F field.
	IPCC_IPCC_C1TOC2SR_CH3F_Msk = 0x4
	// Bit CH3F.
	IPCC_IPCC_C1TOC2SR_CH3F = 0x4
	// Position of CH4F field.
	IPCC_IPCC_C1TOC2SR_CH4F_Pos = 0x3
	// Bit mask of CH4F field.
	IPCC_IPCC_C1TOC2SR_CH4F_Msk = 0x8
	// Bit CH4F.
	IPCC_IPCC_C1TOC2SR_CH4F = 0x8
	// Position of CH5F field.
	IPCC_IPCC_C1TOC2SR_CH5F_Pos = 0x4
	// Bit mask of CH5F field.
	IPCC_IPCC_C1TOC2SR_CH5F_Msk = 0x10
	// Bit CH5F.
	IPCC_IPCC_C1TOC2SR_CH5F = 0x10
	// Position of CH6F field.
	IPCC_IPCC_C1TOC2SR_CH6F_Pos = 0x5
	// Bit mask of CH6F field.
	IPCC_IPCC_C1TOC2SR_CH6F_Msk = 0x20
	// Bit CH6F.
	IPCC_IPCC_C1TOC2SR_CH6F = 0x20

	// IPCC_C2CR: IPCC Processor 2 control register
	// Position of RXOIE field.
	IPCC_IPCC_C2CR_RXOIE_Pos = 0x0
	// Bit mask of RXOIE field.
	IPCC_IPCC_C2CR_RXOIE_Msk = 0x1
	// Bit RXOIE.
	IPCC_IPCC_C2CR_RXOIE = 0x1
	// Position of TXFIE field.
	IPCC_IPCC_C2CR_TXFIE_Pos = 0x10
	// Bit mask of TXFIE field.
	IPCC_IPCC_C2CR_TXFIE_Msk = 0x10000
	// Bit TXFIE.
	IPCC_IPCC_C2CR_TXFIE = 0x10000

	// IPCC_C2MR: IPCC Processor 2 mask register
	// Position of CH1OM field.
	IPCC_IPCC_C2MR_CH1OM_Pos = 0x0
	// Bit mask of CH1OM field.
	IPCC_IPCC_C2MR_CH1OM_Msk = 0x1
	// Bit CH1OM.
	IPCC_IPCC_C2MR_CH1OM = 0x1
	// Position of CH2OM field.
	IPCC_IPCC_C2MR_CH2OM_Pos = 0x1
	// Bit mask of CH2OM field.
	IPCC_IPCC_C2MR_CH2OM_Msk = 0x2
	// Bit CH2OM.
	IPCC_IPCC_C2MR_CH2OM = 0x2
	// Position of CH3OM field.
	IPCC_IPCC_C2MR_CH3OM_Pos = 0x2
	// Bit mask of CH3OM field.
	IPCC_IPCC_C2MR_CH3OM_Msk = 0x4
	// Bit CH3OM.
	IPCC_IPCC_C2MR_CH3OM = 0x4
	// Position of CH4OM field.
	IPCC_IPCC_C2MR_CH4OM_Pos = 0x3
	// Bit mask of CH4OM field.
	IPCC_IPCC_C2MR_CH4OM_Msk = 0x8
	// Bit CH4OM.
	IPCC_IPCC_C2MR_CH4OM = 0x8
	// Position of CH5OM field.
	IPCC_IPCC_C2MR_CH5OM_Pos = 0x4
	// Bit mask of CH5OM field.
	IPCC_IPCC_C2MR_CH5OM_Msk = 0x10
	// Bit CH5OM.
	IPCC_IPCC_C2MR_CH5OM = 0x10
	// Position of CH6OM field.
	IPCC_IPCC_C2MR_CH6OM_Pos = 0x5
	// Bit mask of CH6OM field.
	IPCC_IPCC_C2MR_CH6OM_Msk = 0x20
	// Bit CH6OM.
	IPCC_IPCC_C2MR_CH6OM = 0x20
	// Position of CH1FM field.
	IPCC_IPCC_C2MR_CH1FM_Pos = 0x10
	// Bit mask of CH1FM field.
	IPCC_IPCC_C2MR_CH1FM_Msk = 0x10000
	// Bit CH1FM.
	IPCC_IPCC_C2MR_CH1FM = 0x10000
	// Position of CH2FM field.
	IPCC_IPCC_C2MR_CH2FM_Pos = 0x11
	// Bit mask of CH2FM field.
	IPCC_IPCC_C2MR_CH2FM_Msk = 0x20000
	// Bit CH2FM.
	IPCC_IPCC_C2MR_CH2FM = 0x20000
	// Position of CH3FM field.
	IPCC_IPCC_C2MR_CH3FM_Pos = 0x12
	// Bit mask of CH3FM field.
	IPCC_IPCC_C2MR_CH3FM_Msk = 0x40000
	// Bit CH3FM.
	IPCC_IPCC_C2MR_CH3FM = 0x40000
	// Position of CH4FM field.
	IPCC_IPCC_C2MR_CH4FM_Pos = 0x13
	// Bit mask of CH4FM field.
	IPCC_IPCC_C2MR_CH4FM_Msk = 0x80000
	// Bit CH4FM.
	IPCC_IPCC_C2MR_CH4FM = 0x80000
	// Position of CH5FM field.
	IPCC_IPCC_C2MR_CH5FM_Pos = 0x14
	// Bit mask of CH5FM field.
	IPCC_IPCC_C2MR_CH5FM_Msk = 0x100000
	// Bit CH5FM.
	IPCC_IPCC_C2MR_CH5FM = 0x100000
	// Position of CH6FM field.
	IPCC_IPCC_C2MR_CH6FM_Pos = 0x15
	// Bit mask of CH6FM field.
	IPCC_IPCC_C2MR_CH6FM_Msk = 0x200000
	// Bit CH6FM.
	IPCC_IPCC_C2MR_CH6FM = 0x200000

	// IPCC_C2SCR: Reading this register will always return 0x0000 0000.
	// Position of CH1C field.
	IPCC_IPCC_C2SCR_CH1C_Pos = 0x0
	// Bit mask of CH1C field.
	IPCC_IPCC_C2SCR_CH1C_Msk = 0x1
	// Bit CH1C.
	IPCC_IPCC_C2SCR_CH1C = 0x1
	// Position of CH2C field.
	IPCC_IPCC_C2SCR_CH2C_Pos = 0x1
	// Bit mask of CH2C field.
	IPCC_IPCC_C2SCR_CH2C_Msk = 0x2
	// Bit CH2C.
	IPCC_IPCC_C2SCR_CH2C = 0x2
	// Position of CH3C field.
	IPCC_IPCC_C2SCR_CH3C_Pos = 0x2
	// Bit mask of CH3C field.
	IPCC_IPCC_C2SCR_CH3C_Msk = 0x4
	// Bit CH3C.
	IPCC_IPCC_C2SCR_CH3C = 0x4
	// Position of CH4C field.
	IPCC_IPCC_C2SCR_CH4C_Pos = 0x3
	// Bit mask of CH4C field.
	IPCC_IPCC_C2SCR_CH4C_Msk = 0x8
	// Bit CH4C.
	IPCC_IPCC_C2SCR_CH4C = 0x8
	// Position of CH5C field.
	IPCC_IPCC_C2SCR_CH5C_Pos = 0x4
	// Bit mask of CH5C field.
	IPCC_IPCC_C2SCR_CH5C_Msk = 0x10
	// Bit CH5C.
	IPCC_IPCC_C2SCR_CH5C = 0x10
	// Position of CH6C field.
	IPCC_IPCC_C2SCR_CH6C_Pos = 0x5
	// Bit mask of CH6C field.
	IPCC_IPCC_C2SCR_CH6C_Msk = 0x20
	// Bit CH6C.
	IPCC_IPCC_C2SCR_CH6C = 0x20
	// Position of CH1S field.
	IPCC_IPCC_C2SCR_CH1S_Pos = 0x10
	// Bit mask of CH1S field.
	IPCC_IPCC_C2SCR_CH1S_Msk = 0x10000
	// Bit CH1S.
	IPCC_IPCC_C2SCR_CH1S = 0x10000
	// Position of CH2S field.
	IPCC_IPCC_C2SCR_CH2S_Pos = 0x11
	// Bit mask of CH2S field.
	IPCC_IPCC_C2SCR_CH2S_Msk = 0x20000
	// Bit CH2S.
	IPCC_IPCC_C2SCR_CH2S = 0x20000
	// Position of CH3S field.
	IPCC_IPCC_C2SCR_CH3S_Pos = 0x12
	// Bit mask of CH3S field.
	IPCC_IPCC_C2SCR_CH3S_Msk = 0x40000
	// Bit CH3S.
	IPCC_IPCC_C2SCR_CH3S = 0x40000
	// Position of CH4S field.
	IPCC_IPCC_C2SCR_CH4S_Pos = 0x13
	// Bit mask of CH4S field.
	IPCC_IPCC_C2SCR_CH4S_Msk = 0x80000
	// Bit CH4S.
	IPCC_IPCC_C2SCR_CH4S = 0x80000
	// Position of CH5S field.
	IPCC_IPCC_C2SCR_CH5S_Pos = 0x14
	// Bit mask of CH5S field.
	IPCC_IPCC_C2SCR_CH5S_Msk = 0x100000
	// Bit CH5S.
	IPCC_IPCC_C2SCR_CH5S = 0x100000
	// Position of CH6S field.
	IPCC_IPCC_C2SCR_CH6S_Pos = 0x15
	// Bit mask of CH6S field.
	IPCC_IPCC_C2SCR_CH6S_Msk = 0x200000
	// Bit CH6S.
	IPCC_IPCC_C2SCR_CH6S = 0x200000

	// IPCC_C2TOC1SR: IPCC processor 2 to processor 1 status register
	// Position of CH1F field.
	IPCC_IPCC_C2TOC1SR_CH1F_Pos = 0x0
	// Bit mask of CH1F field.
	IPCC_IPCC_C2TOC1SR_CH1F_Msk = 0x1
	// Bit CH1F.
	IPCC_IPCC_C2TOC1SR_CH1F = 0x1
	// Position of CH2F field.
	IPCC_IPCC_C2TOC1SR_CH2F_Pos = 0x1
	// Bit mask of CH2F field.
	IPCC_IPCC_C2TOC1SR_CH2F_Msk = 0x2
	// Bit CH2F.
	IPCC_IPCC_C2TOC1SR_CH2F = 0x2
	// Position of CH3F field.
	IPCC_IPCC_C2TOC1SR_CH3F_Pos = 0x2
	// Bit mask of CH3F field.
	IPCC_IPCC_C2TOC1SR_CH3F_Msk = 0x4
	// Bit CH3F.
	IPCC_IPCC_C2TOC1SR_CH3F = 0x4
	// Position of CH4F field.
	IPCC_IPCC_C2TOC1SR_CH4F_Pos = 0x3
	// Bit mask of CH4F field.
	IPCC_IPCC_C2TOC1SR_CH4F_Msk = 0x8
	// Bit CH4F.
	IPCC_IPCC_C2TOC1SR_CH4F = 0x8
	// Position of CH5F field.
	IPCC_IPCC_C2TOC1SR_CH5F_Pos = 0x4
	// Bit mask of CH5F field.
	IPCC_IPCC_C2TOC1SR_CH5F_Msk = 0x10
	// Bit CH5F.
	IPCC_IPCC_C2TOC1SR_CH5F = 0x10
	// Position of CH6F field.
	IPCC_IPCC_C2TOC1SR_CH6F_Pos = 0x5
	// Bit mask of CH6F field.
	IPCC_IPCC_C2TOC1SR_CH6F_Msk = 0x20
	// Bit CH6F.
	IPCC_IPCC_C2TOC1SR_CH6F = 0x20

	// IPCC_HWCFGR: IPCC Hardware configuration register
	// Position of CHANNELS field.
	IPCC_IPCC_HWCFGR_CHANNELS_Pos = 0x0
	// Bit mask of CHANNELS field.
	IPCC_IPCC_HWCFGR_CHANNELS_Msk = 0xff

	// IPCC_VERR: IPCC IP Version register
	// Position of MINREV field.
	IPCC_IPCC_VERR_MINREV_Pos = 0x0
	// Bit mask of MINREV field.
	IPCC_IPCC_VERR_MINREV_Msk = 0xf
	// Position of MAJREV field.
	IPCC_IPCC_VERR_MAJREV_Pos = 0x4
	// Bit mask of MAJREV field.
	IPCC_IPCC_VERR_MAJREV_Msk = 0xf0

	// IPCC_IPIDR: IPCC IP Identification register
	// Position of ID field.
	IPCC_IPCC_IPIDR_ID_Pos = 0x0
	// Bit mask of ID field.
	IPCC_IPCC_IPIDR_ID_Msk = 0xffffffff

	// IPCC_SIDR: IPCC Size ID register
	// Position of SID field.
	IPCC_IPCC_SIDR_SID_Pos = 0x0
	// Bit mask of SID field.
	IPCC_IPCC_SIDR_SID_Msk = 0xffffffff
)

// Bitfields for IWDG: Independent watchdog
const (
	// KR: Key register
	// Position of KEY field.
	IWDG_KR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	IWDG_KR_KEY_Msk = 0xffff

	// PR: Prescaler register
	// Position of PR field.
	IWDG_PR_PR_Pos = 0x0
	// Bit mask of PR field.
	IWDG_PR_PR_Msk = 0x7

	// RLR: Reload register
	// Position of RL field.
	IWDG_RLR_RL_Pos = 0x0
	// Bit mask of RL field.
	IWDG_RLR_RL_Msk = 0xfff

	// SR: Status register
	// Position of WVU field.
	IWDG_SR_WVU_Pos = 0x2
	// Bit mask of WVU field.
	IWDG_SR_WVU_Msk = 0x4
	// Bit WVU.
	IWDG_SR_WVU = 0x4
	// Position of RVU field.
	IWDG_SR_RVU_Pos = 0x1
	// Bit mask of RVU field.
	IWDG_SR_RVU_Msk = 0x2
	// Bit RVU.
	IWDG_SR_RVU = 0x2
	// Position of PVU field.
	IWDG_SR_PVU_Pos = 0x0
	// Bit mask of PVU field.
	IWDG_SR_PVU_Msk = 0x1
	// Bit PVU.
	IWDG_SR_PVU = 0x1

	// WINR: Window register
	// Position of WIN field.
	IWDG_WINR_WIN_Pos = 0x0
	// Bit mask of WIN field.
	IWDG_WINR_WIN_Msk = 0xfff
)

// Bitfields for LPTIM1: Low-power timer
const (
	// ISR: interrupt and status register
	// Position of REPOK field.
	LPTIM_ISR_REPOK_Pos = 0x8
	// Bit mask of REPOK field.
	LPTIM_ISR_REPOK_Msk = 0x100
	// Bit REPOK.
	LPTIM_ISR_REPOK = 0x100
	// Position of UE field.
	LPTIM_ISR_UE_Pos = 0x7
	// Bit mask of UE field.
	LPTIM_ISR_UE_Msk = 0x80
	// Bit UE.
	LPTIM_ISR_UE = 0x80
	// Position of DOWN field.
	LPTIM_ISR_DOWN_Pos = 0x6
	// Bit mask of DOWN field.
	LPTIM_ISR_DOWN_Msk = 0x40
	// Bit DOWN.
	LPTIM_ISR_DOWN = 0x40
	// Position of UP field.
	LPTIM_ISR_UP_Pos = 0x5
	// Bit mask of UP field.
	LPTIM_ISR_UP_Msk = 0x20
	// Bit UP.
	LPTIM_ISR_UP = 0x20
	// Position of ARROK field.
	LPTIM_ISR_ARROK_Pos = 0x4
	// Bit mask of ARROK field.
	LPTIM_ISR_ARROK_Msk = 0x10
	// Bit ARROK.
	LPTIM_ISR_ARROK = 0x10
	// Position of CMPOK field.
	LPTIM_ISR_CMPOK_Pos = 0x3
	// Bit mask of CMPOK field.
	LPTIM_ISR_CMPOK_Msk = 0x8
	// Bit CMPOK.
	LPTIM_ISR_CMPOK = 0x8
	// Position of EXTTRIG field.
	LPTIM_ISR_EXTTRIG_Pos = 0x2
	// Bit mask of EXTTRIG field.
	LPTIM_ISR_EXTTRIG_Msk = 0x4
	// Bit EXTTRIG.
	LPTIM_ISR_EXTTRIG = 0x4
	// Position of ARRM field.
	LPTIM_ISR_ARRM_Pos = 0x1
	// Bit mask of ARRM field.
	LPTIM_ISR_ARRM_Msk = 0x2
	// Bit ARRM.
	LPTIM_ISR_ARRM = 0x2
	// Position of CMPM field.
	LPTIM_ISR_CMPM_Pos = 0x0
	// Bit mask of CMPM field.
	LPTIM_ISR_CMPM_Msk = 0x1
	// Bit CMPM.
	LPTIM_ISR_CMPM = 0x1

	// ICR: interrupt clear register
	// Position of REPOKCF field.
	LPTIM_ICR_REPOKCF_Pos = 0x8
	// Bit mask of REPOKCF field.
	LPTIM_ICR_REPOKCF_Msk = 0x100
	// Bit REPOKCF.
	LPTIM_ICR_REPOKCF = 0x100
	// Position of UECF field.
	LPTIM_ICR_UECF_Pos = 0x7
	// Bit mask of UECF field.
	LPTIM_ICR_UECF_Msk = 0x80
	// Bit UECF.
	LPTIM_ICR_UECF = 0x80
	// Position of DOWNCF field.
	LPTIM_ICR_DOWNCF_Pos = 0x6
	// Bit mask of DOWNCF field.
	LPTIM_ICR_DOWNCF_Msk = 0x40
	// Bit DOWNCF.
	LPTIM_ICR_DOWNCF = 0x40
	// Position of UPCF field.
	LPTIM_ICR_UPCF_Pos = 0x5
	// Bit mask of UPCF field.
	LPTIM_ICR_UPCF_Msk = 0x20
	// Bit UPCF.
	LPTIM_ICR_UPCF = 0x20
	// Position of ARROKCF field.
	LPTIM_ICR_ARROKCF_Pos = 0x4
	// Bit mask of ARROKCF field.
	LPTIM_ICR_ARROKCF_Msk = 0x10
	// Bit ARROKCF.
	LPTIM_ICR_ARROKCF = 0x10
	// Position of CMPOKCF field.
	LPTIM_ICR_CMPOKCF_Pos = 0x3
	// Bit mask of CMPOKCF field.
	LPTIM_ICR_CMPOKCF_Msk = 0x8
	// Bit CMPOKCF.
	LPTIM_ICR_CMPOKCF = 0x8
	// Position of EXTTRIGCF field.
	LPTIM_ICR_EXTTRIGCF_Pos = 0x2
	// Bit mask of EXTTRIGCF field.
	LPTIM_ICR_EXTTRIGCF_Msk = 0x4
	// Bit EXTTRIGCF.
	LPTIM_ICR_EXTTRIGCF = 0x4
	// Position of ARRMCF field.
	LPTIM_ICR_ARRMCF_Pos = 0x1
	// Bit mask of ARRMCF field.
	LPTIM_ICR_ARRMCF_Msk = 0x2
	// Bit ARRMCF.
	LPTIM_ICR_ARRMCF = 0x2
	// Position of CMPMCF field.
	LPTIM_ICR_CMPMCF_Pos = 0x0
	// Bit mask of CMPMCF field.
	LPTIM_ICR_CMPMCF_Msk = 0x1
	// Bit CMPMCF.
	LPTIM_ICR_CMPMCF = 0x1

	// IER: interrupt enable register
	// Position of REPOKIE field.
	LPTIM_IER_REPOKIE_Pos = 0x8
	// Bit mask of REPOKIE field.
	LPTIM_IER_REPOKIE_Msk = 0x100
	// Bit REPOKIE.
	LPTIM_IER_REPOKIE = 0x100
	// Position of UEIE field.
	LPTIM_IER_UEIE_Pos = 0x7
	// Bit mask of UEIE field.
	LPTIM_IER_UEIE_Msk = 0x80
	// Bit UEIE.
	LPTIM_IER_UEIE = 0x80
	// Position of DOWNIE field.
	LPTIM_IER_DOWNIE_Pos = 0x6
	// Bit mask of DOWNIE field.
	LPTIM_IER_DOWNIE_Msk = 0x40
	// Bit DOWNIE.
	LPTIM_IER_DOWNIE = 0x40
	// Position of UPIE field.
	LPTIM_IER_UPIE_Pos = 0x5
	// Bit mask of UPIE field.
	LPTIM_IER_UPIE_Msk = 0x20
	// Bit UPIE.
	LPTIM_IER_UPIE = 0x20
	// Position of ARROKIE field.
	LPTIM_IER_ARROKIE_Pos = 0x4
	// Bit mask of ARROKIE field.
	LPTIM_IER_ARROKIE_Msk = 0x10
	// Bit ARROKIE.
	LPTIM_IER_ARROKIE = 0x10
	// Position of CMPOKIE field.
	LPTIM_IER_CMPOKIE_Pos = 0x3
	// Bit mask of CMPOKIE field.
	LPTIM_IER_CMPOKIE_Msk = 0x8
	// Bit CMPOKIE.
	LPTIM_IER_CMPOKIE = 0x8
	// Position of EXTTRIGIE field.
	LPTIM_IER_EXTTRIGIE_Pos = 0x2
	// Bit mask of EXTTRIGIE field.
	LPTIM_IER_EXTTRIGIE_Msk = 0x4
	// Bit EXTTRIGIE.
	LPTIM_IER_EXTTRIGIE = 0x4
	// Position of ARRMIE field.
	LPTIM_IER_ARRMIE_Pos = 0x1
	// Bit mask of ARRMIE field.
	LPTIM_IER_ARRMIE_Msk = 0x2
	// Bit ARRMIE.
	LPTIM_IER_ARRMIE = 0x2
	// Position of CMPMIE field.
	LPTIM_IER_CMPMIE_Pos = 0x0
	// Bit mask of CMPMIE field.
	LPTIM_IER_CMPMIE_Msk = 0x1
	// Bit CMPMIE.
	LPTIM_IER_CMPMIE = 0x1

	// CFGR: configuration register
	// Position of ENC field.
	LPTIM_CFGR_ENC_Pos = 0x18
	// Bit mask of ENC field.
	LPTIM_CFGR_ENC_Msk = 0x1000000
	// Bit ENC.
	LPTIM_CFGR_ENC = 0x1000000
	// Position of COUNTMODE field.
	LPTIM_CFGR_COUNTMODE_Pos = 0x17
	// Bit mask of COUNTMODE field.
	LPTIM_CFGR_COUNTMODE_Msk = 0x800000
	// Bit COUNTMODE.
	LPTIM_CFGR_COUNTMODE = 0x800000
	// Position of PRELOAD field.
	LPTIM_CFGR_PRELOAD_Pos = 0x16
	// Bit mask of PRELOAD field.
	LPTIM_CFGR_PRELOAD_Msk = 0x400000
	// Bit PRELOAD.
	LPTIM_CFGR_PRELOAD = 0x400000
	// Position of WAVPOL field.
	LPTIM_CFGR_WAVPOL_Pos = 0x15
	// Bit mask of WAVPOL field.
	LPTIM_CFGR_WAVPOL_Msk = 0x200000
	// Bit WAVPOL.
	LPTIM_CFGR_WAVPOL = 0x200000
	// Position of WAVE field.
	LPTIM_CFGR_WAVE_Pos = 0x14
	// Bit mask of WAVE field.
	LPTIM_CFGR_WAVE_Msk = 0x100000
	// Bit WAVE.
	LPTIM_CFGR_WAVE = 0x100000
	// Position of TIMOUT field.
	LPTIM_CFGR_TIMOUT_Pos = 0x13
	// Bit mask of TIMOUT field.
	LPTIM_CFGR_TIMOUT_Msk = 0x80000
	// Bit TIMOUT.
	LPTIM_CFGR_TIMOUT = 0x80000
	// Position of TRIGEN field.
	LPTIM_CFGR_TRIGEN_Pos = 0x11
	// Bit mask of TRIGEN field.
	LPTIM_CFGR_TRIGEN_Msk = 0x60000
	// Position of TRIGSEL field.
	LPTIM_CFGR_TRIGSEL_Pos = 0xd
	// Bit mask of TRIGSEL field.
	LPTIM_CFGR_TRIGSEL_Msk = 0xe000
	// Position of PRESC field.
	LPTIM_CFGR_PRESC_Pos = 0x9
	// Bit mask of PRESC field.
	LPTIM_CFGR_PRESC_Msk = 0xe00
	// Position of TRGFLT field.
	LPTIM_CFGR_TRGFLT_Pos = 0x6
	// Bit mask of TRGFLT field.
	LPTIM_CFGR_TRGFLT_Msk = 0xc0
	// Position of CKFLT field.
	LPTIM_CFGR_CKFLT_Pos = 0x3
	// Bit mask of CKFLT field.
	LPTIM_CFGR_CKFLT_Msk = 0x18
	// Position of CKPOL field.
	LPTIM_CFGR_CKPOL_Pos = 0x1
	// Bit mask of CKPOL field.
	LPTIM_CFGR_CKPOL_Msk = 0x6
	// Position of CKSEL field.
	LPTIM_CFGR_CKSEL_Pos = 0x0
	// Bit mask of CKSEL field.
	LPTIM_CFGR_CKSEL_Msk = 0x1
	// Bit CKSEL.
	LPTIM_CFGR_CKSEL = 0x1

	// CR: control register
	// Position of RSTARE field.
	LPTIM_CR_RSTARE_Pos = 0x4
	// Bit mask of RSTARE field.
	LPTIM_CR_RSTARE_Msk = 0x10
	// Bit RSTARE.
	LPTIM_CR_RSTARE = 0x10
	// Position of COUNTRST field.
	LPTIM_CR_COUNTRST_Pos = 0x3
	// Bit mask of COUNTRST field.
	LPTIM_CR_COUNTRST_Msk = 0x8
	// Bit COUNTRST.
	LPTIM_CR_COUNTRST = 0x8
	// Position of CNTSTRT field.
	LPTIM_CR_CNTSTRT_Pos = 0x2
	// Bit mask of CNTSTRT field.
	LPTIM_CR_CNTSTRT_Msk = 0x4
	// Bit CNTSTRT.
	LPTIM_CR_CNTSTRT = 0x4
	// Position of SNGSTRT field.
	LPTIM_CR_SNGSTRT_Pos = 0x1
	// Bit mask of SNGSTRT field.
	LPTIM_CR_SNGSTRT_Msk = 0x2
	// Bit SNGSTRT.
	LPTIM_CR_SNGSTRT = 0x2
	// Position of ENABLE field.
	LPTIM_CR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	LPTIM_CR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	LPTIM_CR_ENABLE = 0x1

	// CMP: compare register
	// Position of CMP field.
	LPTIM_CMP_CMP_Pos = 0x0
	// Bit mask of CMP field.
	LPTIM_CMP_CMP_Msk = 0xffff

	// ARR: autoreload register
	// Position of ARR field.
	LPTIM_ARR_ARR_Pos = 0x0
	// Bit mask of ARR field.
	LPTIM_ARR_ARR_Msk = 0xffff

	// CNT: counter register
	// Position of CNT field.
	LPTIM_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	LPTIM_CNT_CNT_Msk = 0xffff

	// LPTIM1_OR: option register
	// Position of OR_1 field.
	LPTIM_LPTIM1_OR_OR_1_Pos = 0x1
	// Bit mask of OR_1 field.
	LPTIM_LPTIM1_OR_OR_1_Msk = 0x2
	// Bit OR_1.
	LPTIM_LPTIM1_OR_OR_1 = 0x2
	// Position of OR_0 field.
	LPTIM_LPTIM1_OR_OR_0_Pos = 0x0
	// Bit mask of OR_0 field.
	LPTIM_LPTIM1_OR_OR_0_Msk = 0x1
	// Bit OR_0.
	LPTIM_LPTIM1_OR_OR_0 = 0x1

	// RCR: repetition register
	// Position of REP field.
	LPTIM_RCR_REP_Pos = 0x0
	// Bit mask of REP field.
	LPTIM_RCR_REP_Msk = 0xff
)

// Bitfields for LPUART: Universal synchronous asynchronous receiver transmitter
const (
	// CR1_enabled: Control register 1
	// Position of RXFFIE field.
	USART_CR1_enabled_RXFFIE_Pos = 0x1f
	// Bit mask of RXFFIE field.
	USART_CR1_enabled_RXFFIE_Msk = 0x80000000
	// Bit RXFFIE.
	USART_CR1_enabled_RXFFIE = 0x80000000
	// Position of TXFEIE field.
	USART_CR1_enabled_TXFEIE_Pos = 0x1e
	// Bit mask of TXFEIE field.
	USART_CR1_enabled_TXFEIE_Msk = 0x40000000
	// Bit TXFEIE.
	USART_CR1_enabled_TXFEIE = 0x40000000
	// Position of FIFOEN field.
	USART_CR1_enabled_FIFOEN_Pos = 0x1d
	// Bit mask of FIFOEN field.
	USART_CR1_enabled_FIFOEN_Msk = 0x20000000
	// Bit FIFOEN.
	USART_CR1_enabled_FIFOEN = 0x20000000
	// Position of M1 field.
	USART_CR1_enabled_M1_Pos = 0x1c
	// Bit mask of M1 field.
	USART_CR1_enabled_M1_Msk = 0x10000000
	// Bit M1.
	USART_CR1_enabled_M1 = 0x10000000
	// Position of DEAT field.
	USART_CR1_enabled_DEAT_Pos = 0x15
	// Bit mask of DEAT field.
	USART_CR1_enabled_DEAT_Msk = 0x3e00000
	// Position of DEDT field.
	USART_CR1_enabled_DEDT_Pos = 0x10
	// Bit mask of DEDT field.
	USART_CR1_enabled_DEDT_Msk = 0x1f0000
	// Position of CMIE field.
	USART_CR1_enabled_CMIE_Pos = 0xe
	// Bit mask of CMIE field.
	USART_CR1_enabled_CMIE_Msk = 0x4000
	// Bit CMIE.
	USART_CR1_enabled_CMIE = 0x4000
	// Position of MME field.
	USART_CR1_enabled_MME_Pos = 0xd
	// Bit mask of MME field.
	USART_CR1_enabled_MME_Msk = 0x2000
	// Bit MME.
	USART_CR1_enabled_MME = 0x2000
	// Position of M0 field.
	USART_CR1_enabled_M0_Pos = 0xc
	// Bit mask of M0 field.
	USART_CR1_enabled_M0_Msk = 0x1000
	// Bit M0.
	USART_CR1_enabled_M0 = 0x1000
	// Position of WAKE field.
	USART_CR1_enabled_WAKE_Pos = 0xb
	// Bit mask of WAKE field.
	USART_CR1_enabled_WAKE_Msk = 0x800
	// Bit WAKE.
	USART_CR1_enabled_WAKE = 0x800
	// Position of PCE field.
	USART_CR1_enabled_PCE_Pos = 0xa
	// Bit mask of PCE field.
	USART_CR1_enabled_PCE_Msk = 0x400
	// Bit PCE.
	USART_CR1_enabled_PCE = 0x400
	// Position of PS field.
	USART_CR1_enabled_PS_Pos = 0x9
	// Bit mask of PS field.
	USART_CR1_enabled_PS_Msk = 0x200
	// Bit PS.
	USART_CR1_enabled_PS = 0x200
	// Position of PEIE field.
	USART_CR1_enabled_PEIE_Pos = 0x8
	// Bit mask of PEIE field.
	USART_CR1_enabled_PEIE_Msk = 0x100
	// Bit PEIE.
	USART_CR1_enabled_PEIE = 0x100
	// Position of TXFNFIE field.
	USART_CR1_enabled_TXFNFIE_Pos = 0x7
	// Bit mask of TXFNFIE field.
	USART_CR1_enabled_TXFNFIE_Msk = 0x80
	// Bit TXFNFIE.
	USART_CR1_enabled_TXFNFIE = 0x80
	// Position of TCIE field.
	USART_CR1_enabled_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	USART_CR1_enabled_TCIE_Msk = 0x40
	// Bit TCIE.
	USART_CR1_enabled_TCIE = 0x40
	// Position of RXNEIE field.
	USART_CR1_enabled_RXNEIE_Pos = 0x5
	// Bit mask of RXNEIE field.
	USART_CR1_enabled_RXNEIE_Msk = 0x20
	// Bit RXNEIE.
	USART_CR1_enabled_RXNEIE = 0x20
	// Position of IDLEIE field.
	USART_CR1_enabled_IDLEIE_Pos = 0x4
	// Bit mask of IDLEIE field.
	USART_CR1_enabled_IDLEIE_Msk = 0x10
	// Bit IDLEIE.
	USART_CR1_enabled_IDLEIE = 0x10
	// Position of TE field.
	USART_CR1_enabled_TE_Pos = 0x3
	// Bit mask of TE field.
	USART_CR1_enabled_TE_Msk = 0x8
	// Bit TE.
	USART_CR1_enabled_TE = 0x8
	// Position of RE field.
	USART_CR1_enabled_RE_Pos = 0x2
	// Bit mask of RE field.
	USART_CR1_enabled_RE_Msk = 0x4
	// Bit RE.
	USART_CR1_enabled_RE = 0x4
	// Position of UESM field.
	USART_CR1_enabled_UESM_Pos = 0x1
	// Bit mask of UESM field.
	USART_CR1_enabled_UESM_Msk = 0x2
	// Bit UESM.
	USART_CR1_enabled_UESM = 0x2
	// Position of UE field.
	USART_CR1_enabled_UE_Pos = 0x0
	// Bit mask of UE field.
	USART_CR1_enabled_UE_Msk = 0x1
	// Bit UE.
	USART_CR1_enabled_UE = 0x1

	// CR1_disabled: Control register 1
	// Position of FIFOEN field.
	USART_CR1_disabled_FIFOEN_Pos = 0x1d
	// Bit mask of FIFOEN field.
	USART_CR1_disabled_FIFOEN_Msk = 0x20000000
	// Bit FIFOEN.
	USART_CR1_disabled_FIFOEN = 0x20000000
	// Position of M1 field.
	USART_CR1_disabled_M1_Pos = 0x1c
	// Bit mask of M1 field.
	USART_CR1_disabled_M1_Msk = 0x10000000
	// Bit M1.
	USART_CR1_disabled_M1 = 0x10000000
	// Position of DEAT field.
	USART_CR1_disabled_DEAT_Pos = 0x15
	// Bit mask of DEAT field.
	USART_CR1_disabled_DEAT_Msk = 0x3e00000
	// Position of DEDT field.
	USART_CR1_disabled_DEDT_Pos = 0x10
	// Bit mask of DEDT field.
	USART_CR1_disabled_DEDT_Msk = 0x1f0000
	// Position of CMIE field.
	USART_CR1_disabled_CMIE_Pos = 0xe
	// Bit mask of CMIE field.
	USART_CR1_disabled_CMIE_Msk = 0x4000
	// Bit CMIE.
	USART_CR1_disabled_CMIE = 0x4000
	// Position of MME field.
	USART_CR1_disabled_MME_Pos = 0xd
	// Bit mask of MME field.
	USART_CR1_disabled_MME_Msk = 0x2000
	// Bit MME.
	USART_CR1_disabled_MME = 0x2000
	// Position of M0 field.
	USART_CR1_disabled_M0_Pos = 0xc
	// Bit mask of M0 field.
	USART_CR1_disabled_M0_Msk = 0x1000
	// Bit M0.
	USART_CR1_disabled_M0 = 0x1000
	// Position of WAKE field.
	USART_CR1_disabled_WAKE_Pos = 0xb
	// Bit mask of WAKE field.
	USART_CR1_disabled_WAKE_Msk = 0x800
	// Bit WAKE.
	USART_CR1_disabled_WAKE = 0x800
	// Position of PCE field.
	USART_CR1_disabled_PCE_Pos = 0xa
	// Bit mask of PCE field.
	USART_CR1_disabled_PCE_Msk = 0x400
	// Bit PCE.
	USART_CR1_disabled_PCE = 0x400
	// Position of PS field.
	USART_CR1_disabled_PS_Pos = 0x9
	// Bit mask of PS field.
	USART_CR1_disabled_PS_Msk = 0x200
	// Bit PS.
	USART_CR1_disabled_PS = 0x200
	// Position of PEIE field.
	USART_CR1_disabled_PEIE_Pos = 0x8
	// Bit mask of PEIE field.
	USART_CR1_disabled_PEIE_Msk = 0x100
	// Bit PEIE.
	USART_CR1_disabled_PEIE = 0x100
	// Position of TXEIE field.
	USART_CR1_disabled_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	USART_CR1_disabled_TXEIE_Msk = 0x80
	// Bit TXEIE.
	USART_CR1_disabled_TXEIE = 0x80
	// Position of TCIE field.
	USART_CR1_disabled_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	USART_CR1_disabled_TCIE_Msk = 0x40
	// Bit TCIE.
	USART_CR1_disabled_TCIE = 0x40
	// Position of RXFNEIE field.
	USART_CR1_disabled_RXFNEIE_Pos = 0x5
	// Bit mask of RXFNEIE field.
	USART_CR1_disabled_RXFNEIE_Msk = 0x20
	// Bit RXFNEIE.
	USART_CR1_disabled_RXFNEIE = 0x20
	// Position of IDLEIE field.
	USART_CR1_disabled_IDLEIE_Pos = 0x4
	// Bit mask of IDLEIE field.
	USART_CR1_disabled_IDLEIE_Msk = 0x10
	// Bit IDLEIE.
	USART_CR1_disabled_IDLEIE = 0x10
	// Position of TE field.
	USART_CR1_disabled_TE_Pos = 0x3
	// Bit mask of TE field.
	USART_CR1_disabled_TE_Msk = 0x8
	// Bit TE.
	USART_CR1_disabled_TE = 0x8
	// Position of RE field.
	USART_CR1_disabled_RE_Pos = 0x2
	// Bit mask of RE field.
	USART_CR1_disabled_RE_Msk = 0x4
	// Bit RE.
	USART_CR1_disabled_RE = 0x4
	// Position of UESM field.
	USART_CR1_disabled_UESM_Pos = 0x1
	// Bit mask of UESM field.
	USART_CR1_disabled_UESM_Msk = 0x2
	// Bit UESM.
	USART_CR1_disabled_UESM = 0x2
	// Position of UE field.
	USART_CR1_disabled_UE_Pos = 0x0
	// Bit mask of UE field.
	USART_CR1_disabled_UE_Msk = 0x1
	// Bit UE.
	USART_CR1_disabled_UE = 0x1

	// CR2: Control register 2
	// Position of ADD field.
	USART_CR2_ADD_Pos = 0x18
	// Bit mask of ADD field.
	USART_CR2_ADD_Msk = 0xff000000
	// Position of MSBFIRST field.
	USART_CR2_MSBFIRST_Pos = 0x13
	// Bit mask of MSBFIRST field.
	USART_CR2_MSBFIRST_Msk = 0x80000
	// Bit MSBFIRST.
	USART_CR2_MSBFIRST = 0x80000
	// Position of DATAINV field.
	USART_CR2_DATAINV_Pos = 0x12
	// Bit mask of DATAINV field.
	USART_CR2_DATAINV_Msk = 0x40000
	// Bit DATAINV.
	USART_CR2_DATAINV = 0x40000
	// Position of TXINV field.
	USART_CR2_TXINV_Pos = 0x11
	// Bit mask of TXINV field.
	USART_CR2_TXINV_Msk = 0x20000
	// Bit TXINV.
	USART_CR2_TXINV = 0x20000
	// Position of RXINV field.
	USART_CR2_RXINV_Pos = 0x10
	// Bit mask of RXINV field.
	USART_CR2_RXINV_Msk = 0x10000
	// Bit RXINV.
	USART_CR2_RXINV = 0x10000
	// Position of SWAP field.
	USART_CR2_SWAP_Pos = 0xf
	// Bit mask of SWAP field.
	USART_CR2_SWAP_Msk = 0x8000
	// Bit SWAP.
	USART_CR2_SWAP = 0x8000
	// Position of STOP field.
	USART_CR2_STOP_Pos = 0xc
	// Bit mask of STOP field.
	USART_CR2_STOP_Msk = 0x3000
	// Position of ADDM7 field.
	USART_CR2_ADDM7_Pos = 0x4
	// Bit mask of ADDM7 field.
	USART_CR2_ADDM7_Msk = 0x10
	// Bit ADDM7.
	USART_CR2_ADDM7 = 0x10

	// CR3: Control register 3
	// Position of TXFTCFG field.
	USART_CR3_TXFTCFG_Pos = 0x1d
	// Bit mask of TXFTCFG field.
	USART_CR3_TXFTCFG_Msk = 0xe0000000
	// Position of RXFTIE field.
	USART_CR3_RXFTIE_Pos = 0x1c
	// Bit mask of RXFTIE field.
	USART_CR3_RXFTIE_Msk = 0x10000000
	// Bit RXFTIE.
	USART_CR3_RXFTIE = 0x10000000
	// Position of RXFTCFG field.
	USART_CR3_RXFTCFG_Pos = 0x19
	// Bit mask of RXFTCFG field.
	USART_CR3_RXFTCFG_Msk = 0xe000000
	// Position of TXFTIE field.
	USART_CR3_TXFTIE_Pos = 0x17
	// Bit mask of TXFTIE field.
	USART_CR3_TXFTIE_Msk = 0x800000
	// Bit TXFTIE.
	USART_CR3_TXFTIE = 0x800000
	// Position of WUFIE field.
	USART_CR3_WUFIE_Pos = 0x16
	// Bit mask of WUFIE field.
	USART_CR3_WUFIE_Msk = 0x400000
	// Bit WUFIE.
	USART_CR3_WUFIE = 0x400000
	// Position of WUS field.
	USART_CR3_WUS_Pos = 0x14
	// Bit mask of WUS field.
	USART_CR3_WUS_Msk = 0x300000
	// Position of DEP field.
	USART_CR3_DEP_Pos = 0xf
	// Bit mask of DEP field.
	USART_CR3_DEP_Msk = 0x8000
	// Bit DEP.
	USART_CR3_DEP = 0x8000
	// Position of DEM field.
	USART_CR3_DEM_Pos = 0xe
	// Bit mask of DEM field.
	USART_CR3_DEM_Msk = 0x4000
	// Bit DEM.
	USART_CR3_DEM = 0x4000
	// Position of DDRE field.
	USART_CR3_DDRE_Pos = 0xd
	// Bit mask of DDRE field.
	USART_CR3_DDRE_Msk = 0x2000
	// Bit DDRE.
	USART_CR3_DDRE = 0x2000
	// Position of OVRDIS field.
	USART_CR3_OVRDIS_Pos = 0xc
	// Bit mask of OVRDIS field.
	USART_CR3_OVRDIS_Msk = 0x1000
	// Bit OVRDIS.
	USART_CR3_OVRDIS = 0x1000
	// Position of CTSIE field.
	USART_CR3_CTSIE_Pos = 0xa
	// Bit mask of CTSIE field.
	USART_CR3_CTSIE_Msk = 0x400
	// Bit CTSIE.
	USART_CR3_CTSIE = 0x400
	// Position of CTSE field.
	USART_CR3_CTSE_Pos = 0x9
	// Bit mask of CTSE field.
	USART_CR3_CTSE_Msk = 0x200
	// Bit CTSE.
	USART_CR3_CTSE = 0x200
	// Position of RTSE field.
	USART_CR3_RTSE_Pos = 0x8
	// Bit mask of RTSE field.
	USART_CR3_RTSE_Msk = 0x100
	// Bit RTSE.
	USART_CR3_RTSE = 0x100
	// Position of DMAT field.
	USART_CR3_DMAT_Pos = 0x7
	// Bit mask of DMAT field.
	USART_CR3_DMAT_Msk = 0x80
	// Bit DMAT.
	USART_CR3_DMAT = 0x80
	// Position of DMAR field.
	USART_CR3_DMAR_Pos = 0x6
	// Bit mask of DMAR field.
	USART_CR3_DMAR_Msk = 0x40
	// Bit DMAR.
	USART_CR3_DMAR = 0x40
	// Position of HDSEL field.
	USART_CR3_HDSEL_Pos = 0x3
	// Bit mask of HDSEL field.
	USART_CR3_HDSEL_Msk = 0x8
	// Bit HDSEL.
	USART_CR3_HDSEL = 0x8
	// Position of EIE field.
	USART_CR3_EIE_Pos = 0x0
	// Bit mask of EIE field.
	USART_CR3_EIE_Msk = 0x1
	// Bit EIE.
	USART_CR3_EIE = 0x1

	// BRR: Baud rate register
	// Position of BRR field.
	USART_BRR_BRR_Pos = 0x0
	// Bit mask of BRR field.
	USART_BRR_BRR_Msk = 0xfffff

	// RQR: Request register
	// Position of TXFRQ field.
	USART_RQR_TXFRQ_Pos = 0x4
	// Bit mask of TXFRQ field.
	USART_RQR_TXFRQ_Msk = 0x10
	// Bit TXFRQ.
	USART_RQR_TXFRQ = 0x10
	// Position of RXFRQ field.
	USART_RQR_RXFRQ_Pos = 0x3
	// Bit mask of RXFRQ field.
	USART_RQR_RXFRQ_Msk = 0x8
	// Bit RXFRQ.
	USART_RQR_RXFRQ = 0x8
	// Position of MMRQ field.
	USART_RQR_MMRQ_Pos = 0x2
	// Bit mask of MMRQ field.
	USART_RQR_MMRQ_Msk = 0x4
	// Bit MMRQ.
	USART_RQR_MMRQ = 0x4
	// Position of SBKRQ field.
	USART_RQR_SBKRQ_Pos = 0x1
	// Bit mask of SBKRQ field.
	USART_RQR_SBKRQ_Msk = 0x2
	// Bit SBKRQ.
	USART_RQR_SBKRQ = 0x2

	// ISR_enabled: Interrupt and status register
	// Position of TXFT field.
	USART_ISR_enabled_TXFT_Pos = 0x1b
	// Bit mask of TXFT field.
	USART_ISR_enabled_TXFT_Msk = 0x8000000
	// Bit TXFT.
	USART_ISR_enabled_TXFT = 0x8000000
	// Position of RXFT field.
	USART_ISR_enabled_RXFT_Pos = 0x1a
	// Bit mask of RXFT field.
	USART_ISR_enabled_RXFT_Msk = 0x4000000
	// Bit RXFT.
	USART_ISR_enabled_RXFT = 0x4000000
	// Position of RXFF field.
	USART_ISR_enabled_RXFF_Pos = 0x18
	// Bit mask of RXFF field.
	USART_ISR_enabled_RXFF_Msk = 0x1000000
	// Bit RXFF.
	USART_ISR_enabled_RXFF = 0x1000000
	// Position of TXFE field.
	USART_ISR_enabled_TXFE_Pos = 0x17
	// Bit mask of TXFE field.
	USART_ISR_enabled_TXFE_Msk = 0x800000
	// Bit TXFE.
	USART_ISR_enabled_TXFE = 0x800000
	// Position of REACK field.
	USART_ISR_enabled_REACK_Pos = 0x16
	// Bit mask of REACK field.
	USART_ISR_enabled_REACK_Msk = 0x400000
	// Bit REACK.
	USART_ISR_enabled_REACK = 0x400000
	// Position of TEACK field.
	USART_ISR_enabled_TEACK_Pos = 0x15
	// Bit mask of TEACK field.
	USART_ISR_enabled_TEACK_Msk = 0x200000
	// Bit TEACK.
	USART_ISR_enabled_TEACK = 0x200000
	// Position of WUF field.
	USART_ISR_enabled_WUF_Pos = 0x14
	// Bit mask of WUF field.
	USART_ISR_enabled_WUF_Msk = 0x100000
	// Bit WUF.
	USART_ISR_enabled_WUF = 0x100000
	// Position of RWU field.
	USART_ISR_enabled_RWU_Pos = 0x13
	// Bit mask of RWU field.
	USART_ISR_enabled_RWU_Msk = 0x80000
	// Bit RWU.
	USART_ISR_enabled_RWU = 0x80000
	// Position of SBKF field.
	USART_ISR_enabled_SBKF_Pos = 0x12
	// Bit mask of SBKF field.
	USART_ISR_enabled_SBKF_Msk = 0x40000
	// Bit SBKF.
	USART_ISR_enabled_SBKF = 0x40000
	// Position of CMF field.
	USART_ISR_enabled_CMF_Pos = 0x11
	// Bit mask of CMF field.
	USART_ISR_enabled_CMF_Msk = 0x20000
	// Bit CMF.
	USART_ISR_enabled_CMF = 0x20000
	// Position of BUSY field.
	USART_ISR_enabled_BUSY_Pos = 0x10
	// Bit mask of BUSY field.
	USART_ISR_enabled_BUSY_Msk = 0x10000
	// Bit BUSY.
	USART_ISR_enabled_BUSY = 0x10000
	// Position of CTS field.
	USART_ISR_enabled_CTS_Pos = 0xa
	// Bit mask of CTS field.
	USART_ISR_enabled_CTS_Msk = 0x400
	// Bit CTS.
	USART_ISR_enabled_CTS = 0x400
	// Position of CTSIF field.
	USART_ISR_enabled_CTSIF_Pos = 0x9
	// Bit mask of CTSIF field.
	USART_ISR_enabled_CTSIF_Msk = 0x200
	// Bit CTSIF.
	USART_ISR_enabled_CTSIF = 0x200
	// Position of TXFNF field.
	USART_ISR_enabled_TXFNF_Pos = 0x7
	// Bit mask of TXFNF field.
	USART_ISR_enabled_TXFNF_Msk = 0x80
	// Bit TXFNF.
	USART_ISR_enabled_TXFNF = 0x80
	// Position of TC field.
	USART_ISR_enabled_TC_Pos = 0x6
	// Bit mask of TC field.
	USART_ISR_enabled_TC_Msk = 0x40
	// Bit TC.
	USART_ISR_enabled_TC = 0x40
	// Position of RXFNE field.
	USART_ISR_enabled_RXFNE_Pos = 0x5
	// Bit mask of RXFNE field.
	USART_ISR_enabled_RXFNE_Msk = 0x20
	// Bit RXFNE.
	USART_ISR_enabled_RXFNE = 0x20
	// Position of IDLE field.
	USART_ISR_enabled_IDLE_Pos = 0x4
	// Bit mask of IDLE field.
	USART_ISR_enabled_IDLE_Msk = 0x10
	// Bit IDLE.
	USART_ISR_enabled_IDLE = 0x10
	// Position of ORE field.
	USART_ISR_enabled_ORE_Pos = 0x3
	// Bit mask of ORE field.
	USART_ISR_enabled_ORE_Msk = 0x8
	// Bit ORE.
	USART_ISR_enabled_ORE = 0x8
	// Position of NE field.
	USART_ISR_enabled_NE_Pos = 0x2
	// Bit mask of NE field.
	USART_ISR_enabled_NE_Msk = 0x4
	// Bit NE.
	USART_ISR_enabled_NE = 0x4
	// Position of FE field.
	USART_ISR_enabled_FE_Pos = 0x1
	// Bit mask of FE field.
	USART_ISR_enabled_FE_Msk = 0x2
	// Bit FE.
	USART_ISR_enabled_FE = 0x2
	// Position of PE field.
	USART_ISR_enabled_PE_Pos = 0x0
	// Bit mask of PE field.
	USART_ISR_enabled_PE_Msk = 0x1
	// Bit PE.
	USART_ISR_enabled_PE = 0x1

	// ISR_disabled: Interrupt and status register
	// Position of REACK field.
	USART_ISR_disabled_REACK_Pos = 0x16
	// Bit mask of REACK field.
	USART_ISR_disabled_REACK_Msk = 0x400000
	// Bit REACK.
	USART_ISR_disabled_REACK = 0x400000
	// Position of TEACK field.
	USART_ISR_disabled_TEACK_Pos = 0x15
	// Bit mask of TEACK field.
	USART_ISR_disabled_TEACK_Msk = 0x200000
	// Bit TEACK.
	USART_ISR_disabled_TEACK = 0x200000
	// Position of WUF field.
	USART_ISR_disabled_WUF_Pos = 0x14
	// Bit mask of WUF field.
	USART_ISR_disabled_WUF_Msk = 0x100000
	// Bit WUF.
	USART_ISR_disabled_WUF = 0x100000
	// Position of RWU field.
	USART_ISR_disabled_RWU_Pos = 0x13
	// Bit mask of RWU field.
	USART_ISR_disabled_RWU_Msk = 0x80000
	// Bit RWU.
	USART_ISR_disabled_RWU = 0x80000
	// Position of SBKF field.
	USART_ISR_disabled_SBKF_Pos = 0x12
	// Bit mask of SBKF field.
	USART_ISR_disabled_SBKF_Msk = 0x40000
	// Bit SBKF.
	USART_ISR_disabled_SBKF = 0x40000
	// Position of CMF field.
	USART_ISR_disabled_CMF_Pos = 0x11
	// Bit mask of CMF field.
	USART_ISR_disabled_CMF_Msk = 0x20000
	// Bit CMF.
	USART_ISR_disabled_CMF = 0x20000
	// Position of BUSY field.
	USART_ISR_disabled_BUSY_Pos = 0x10
	// Bit mask of BUSY field.
	USART_ISR_disabled_BUSY_Msk = 0x10000
	// Bit BUSY.
	USART_ISR_disabled_BUSY = 0x10000
	// Position of CTS field.
	USART_ISR_disabled_CTS_Pos = 0xa
	// Bit mask of CTS field.
	USART_ISR_disabled_CTS_Msk = 0x400
	// Bit CTS.
	USART_ISR_disabled_CTS = 0x400
	// Position of CTSIF field.
	USART_ISR_disabled_CTSIF_Pos = 0x9
	// Bit mask of CTSIF field.
	USART_ISR_disabled_CTSIF_Msk = 0x200
	// Bit CTSIF.
	USART_ISR_disabled_CTSIF = 0x200
	// Position of TXE field.
	USART_ISR_disabled_TXE_Pos = 0x7
	// Bit mask of TXE field.
	USART_ISR_disabled_TXE_Msk = 0x80
	// Bit TXE.
	USART_ISR_disabled_TXE = 0x80
	// Position of TC field.
	USART_ISR_disabled_TC_Pos = 0x6
	// Bit mask of TC field.
	USART_ISR_disabled_TC_Msk = 0x40
	// Bit TC.
	USART_ISR_disabled_TC = 0x40
	// Position of RXFNE field.
	USART_ISR_disabled_RXFNE_Pos = 0x5
	// Bit mask of RXFNE field.
	USART_ISR_disabled_RXFNE_Msk = 0x20
	// Bit RXFNE.
	USART_ISR_disabled_RXFNE = 0x20
	// Position of IDLE field.
	USART_ISR_disabled_IDLE_Pos = 0x4
	// Bit mask of IDLE field.
	USART_ISR_disabled_IDLE_Msk = 0x10
	// Bit IDLE.
	USART_ISR_disabled_IDLE = 0x10
	// Position of ORE field.
	USART_ISR_disabled_ORE_Pos = 0x3
	// Bit mask of ORE field.
	USART_ISR_disabled_ORE_Msk = 0x8
	// Bit ORE.
	USART_ISR_disabled_ORE = 0x8
	// Position of NE field.
	USART_ISR_disabled_NE_Pos = 0x2
	// Bit mask of NE field.
	USART_ISR_disabled_NE_Msk = 0x4
	// Bit NE.
	USART_ISR_disabled_NE = 0x4
	// Position of FE field.
	USART_ISR_disabled_FE_Pos = 0x1
	// Bit mask of FE field.
	USART_ISR_disabled_FE_Msk = 0x2
	// Bit FE.
	USART_ISR_disabled_FE = 0x2
	// Position of PE field.
	USART_ISR_disabled_PE_Pos = 0x0
	// Bit mask of PE field.
	USART_ISR_disabled_PE_Msk = 0x1
	// Bit PE.
	USART_ISR_disabled_PE = 0x1

	// ICR: Interrupt flag clear register
	// Position of WUCF field.
	USART_ICR_WUCF_Pos = 0x14
	// Bit mask of WUCF field.
	USART_ICR_WUCF_Msk = 0x100000
	// Bit WUCF.
	USART_ICR_WUCF = 0x100000
	// Position of CMCF field.
	USART_ICR_CMCF_Pos = 0x11
	// Bit mask of CMCF field.
	USART_ICR_CMCF_Msk = 0x20000
	// Bit CMCF.
	USART_ICR_CMCF = 0x20000
	// Position of CTSCF field.
	USART_ICR_CTSCF_Pos = 0x9
	// Bit mask of CTSCF field.
	USART_ICR_CTSCF_Msk = 0x200
	// Bit CTSCF.
	USART_ICR_CTSCF = 0x200
	// Position of TCCF field.
	USART_ICR_TCCF_Pos = 0x6
	// Bit mask of TCCF field.
	USART_ICR_TCCF_Msk = 0x40
	// Bit TCCF.
	USART_ICR_TCCF = 0x40
	// Position of IDLECF field.
	USART_ICR_IDLECF_Pos = 0x4
	// Bit mask of IDLECF field.
	USART_ICR_IDLECF_Msk = 0x10
	// Bit IDLECF.
	USART_ICR_IDLECF = 0x10
	// Position of ORECF field.
	USART_ICR_ORECF_Pos = 0x3
	// Bit mask of ORECF field.
	USART_ICR_ORECF_Msk = 0x8
	// Bit ORECF.
	USART_ICR_ORECF = 0x8
	// Position of NECF field.
	USART_ICR_NECF_Pos = 0x2
	// Bit mask of NECF field.
	USART_ICR_NECF_Msk = 0x4
	// Bit NECF.
	USART_ICR_NECF = 0x4
	// Position of FECF field.
	USART_ICR_FECF_Pos = 0x1
	// Bit mask of FECF field.
	USART_ICR_FECF_Msk = 0x2
	// Bit FECF.
	USART_ICR_FECF = 0x2
	// Position of PECF field.
	USART_ICR_PECF_Pos = 0x0
	// Bit mask of PECF field.
	USART_ICR_PECF_Msk = 0x1
	// Bit PECF.
	USART_ICR_PECF = 0x1

	// RDR: Receive data register
	// Position of RDR field.
	USART_RDR_RDR_Pos = 0x0
	// Bit mask of RDR field.
	USART_RDR_RDR_Msk = 0x1ff

	// TDR: Transmit data register
	// Position of TDR field.
	USART_TDR_TDR_Pos = 0x0
	// Bit mask of TDR field.
	USART_TDR_TDR_Msk = 0x1ff

	// PRESC: Prescaler register
	// Position of PRESCALER field.
	USART_PRESC_PRESCALER_Pos = 0x0
	// Bit mask of PRESCALER field.
	USART_PRESC_PRESCALER_Msk = 0xf
)

// Bitfields for MPU: Memory protection unit
const (
	// MPU_TYPER: MPU type register
	// Position of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE_Pos = 0x0
	// Bit mask of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE_Msk = 0x1
	// Bit SEPARATE.
	MPU_MPU_TYPER_SEPARATE = 0x1
	// Position of DREGION field.
	MPU_MPU_TYPER_DREGION_Pos = 0x8
	// Bit mask of DREGION field.
	MPU_MPU_TYPER_DREGION_Msk = 0xff00
	// Position of IREGION field.
	MPU_MPU_TYPER_IREGION_Pos = 0x10
	// Bit mask of IREGION field.
	MPU_MPU_TYPER_IREGION_Msk = 0xff0000

	// MPU_CTRL: MPU control register
	// Position of ENABLE field.
	MPU_MPU_CTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	MPU_MPU_CTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	MPU_MPU_CTRL_ENABLE = 0x1
	// Position of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA_Pos = 0x1
	// Bit mask of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA_Msk = 0x2
	// Bit HFNMIENA.
	MPU_MPU_CTRL_HFNMIENA = 0x2
	// Position of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA_Pos = 0x2
	// Bit mask of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA_Msk = 0x4
	// Bit PRIVDEFENA.
	MPU_MPU_CTRL_PRIVDEFENA = 0x4

	// MPU_RNR: MPU region number register
	// Position of REGION field.
	MPU_MPU_RNR_REGION_Pos = 0x0
	// Bit mask of REGION field.
	MPU_MPU_RNR_REGION_Msk = 0xff

	// MPU_RBAR: MPU region base address register
	// Position of REGION field.
	MPU_MPU_RBAR_REGION_Pos = 0x0
	// Bit mask of REGION field.
	MPU_MPU_RBAR_REGION_Msk = 0xf
	// Position of VALID field.
	MPU_MPU_RBAR_VALID_Pos = 0x4
	// Bit mask of VALID field.
	MPU_MPU_RBAR_VALID_Msk = 0x10
	// Bit VALID.
	MPU_MPU_RBAR_VALID = 0x10
	// Position of ADDR field.
	MPU_MPU_RBAR_ADDR_Pos = 0x5
	// Bit mask of ADDR field.
	MPU_MPU_RBAR_ADDR_Msk = 0xffffffe0

	// MPU_RASR: MPU region attribute and size register
	// Position of ENABLE field.
	MPU_MPU_RASR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	MPU_MPU_RASR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	MPU_MPU_RASR_ENABLE = 0x1
	// Position of SIZE field.
	MPU_MPU_RASR_SIZE_Pos = 0x1
	// Bit mask of SIZE field.
	MPU_MPU_RASR_SIZE_Msk = 0x3e
	// Position of SRD field.
	MPU_MPU_RASR_SRD_Pos = 0x8
	// Bit mask of SRD field.
	MPU_MPU_RASR_SRD_Msk = 0xff00
	// Position of B field.
	MPU_MPU_RASR_B_Pos = 0x10
	// Bit mask of B field.
	MPU_MPU_RASR_B_Msk = 0x10000
	// Bit B.
	MPU_MPU_RASR_B = 0x10000
	// Position of C field.
	MPU_MPU_RASR_C_Pos = 0x11
	// Bit mask of C field.
	MPU_MPU_RASR_C_Msk = 0x20000
	// Bit C.
	MPU_MPU_RASR_C = 0x20000
	// Position of S field.
	MPU_MPU_RASR_S_Pos = 0x12
	// Bit mask of S field.
	MPU_MPU_RASR_S_Msk = 0x40000
	// Bit S.
	MPU_MPU_RASR_S = 0x40000
	// Position of TEX field.
	MPU_MPU_RASR_TEX_Pos = 0x13
	// Bit mask of TEX field.
	MPU_MPU_RASR_TEX_Msk = 0x380000
	// Position of AP field.
	MPU_MPU_RASR_AP_Pos = 0x18
	// Bit mask of AP field.
	MPU_MPU_RASR_AP_Msk = 0x7000000
	// Position of XN field.
	MPU_MPU_RASR_XN_Pos = 0x1c
	// Bit mask of XN field.
	MPU_MPU_RASR_XN_Msk = 0x10000000
	// Bit XN.
	MPU_MPU_RASR_XN = 0x10000000
)

// Bitfields for NVIC: Nested Vectored Interrupt Controller
const (
	// ISER0: Interrupt Set-Enable Register
	// Position of SETENA field.
	NVIC_ISER0_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER0_SETENA_Msk = 0xffffffff

	// ICER0: Interrupt Clear-Enable Register
	// Position of CLRENA field.
	NVIC_ICER0_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER0_CLRENA_Msk = 0xffffffff

	// ISPR0: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR0_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR0_SETPEND_Msk = 0xffffffff

	// ICPR0: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Msk = 0xffffffff

	// IABR0: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR0_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR0_ACTIVE_Msk = 0xffffffff

	// IABR1: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR1_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR1_ACTIVE_Msk = 0xffffffff

	// IPR0: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Msk = 0xff000000

	// IPR1: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Msk = 0xff000000

	// IPR2: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Msk = 0xff000000

	// IPR3: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Msk = 0xff000000

	// IPR4: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Msk = 0xff000000

	// IPR5: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR5_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR5_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR5_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR5_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR5_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR5_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR5_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR5_IPR_N3_Msk = 0xff000000

	// IPR6: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR6_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR6_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR6_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR6_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR6_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR6_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR6_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR6_IPR_N3_Msk = 0xff000000

	// IPR7: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR7_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR7_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR7_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR7_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR7_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR7_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR7_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR7_IPR_N3_Msk = 0xff000000

	// IPR8: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR8_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR8_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR8_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR8_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR8_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR8_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR8_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR8_IPR_N3_Msk = 0xff000000
)

// Bitfields for PKA: Public key accelerator
const (
	// CR: control register
	// Position of ADDRERRIE field.
	PKA_CR_ADDRERRIE_Pos = 0x14
	// Bit mask of ADDRERRIE field.
	PKA_CR_ADDRERRIE_Msk = 0x100000
	// Bit ADDRERRIE.
	PKA_CR_ADDRERRIE = 0x100000
	// Position of RAMERRIE field.
	PKA_CR_RAMERRIE_Pos = 0x13
	// Bit mask of RAMERRIE field.
	PKA_CR_RAMERRIE_Msk = 0x80000
	// Bit RAMERRIE.
	PKA_CR_RAMERRIE = 0x80000
	// Position of PROCENDIE field.
	PKA_CR_PROCENDIE_Pos = 0x11
	// Bit mask of PROCENDIE field.
	PKA_CR_PROCENDIE_Msk = 0x20000
	// Bit PROCENDIE.
	PKA_CR_PROCENDIE = 0x20000
	// Position of MODE field.
	PKA_CR_MODE_Pos = 0x8
	// Bit mask of MODE field.
	PKA_CR_MODE_Msk = 0x3f00
	// Position of START field.
	PKA_CR_START_Pos = 0x1
	// Bit mask of START field.
	PKA_CR_START_Msk = 0x2
	// Bit START.
	PKA_CR_START = 0x2
	// Position of EN field.
	PKA_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	PKA_CR_EN_Msk = 0x1
	// Bit EN.
	PKA_CR_EN = 0x1

	// SR: status register
	// Position of ADDRERRF field.
	PKA_SR_ADDRERRF_Pos = 0x14
	// Bit mask of ADDRERRF field.
	PKA_SR_ADDRERRF_Msk = 0x100000
	// Bit ADDRERRF.
	PKA_SR_ADDRERRF = 0x100000
	// Position of RAMERRF field.
	PKA_SR_RAMERRF_Pos = 0x13
	// Bit mask of RAMERRF field.
	PKA_SR_RAMERRF_Msk = 0x80000
	// Bit RAMERRF.
	PKA_SR_RAMERRF = 0x80000
	// Position of PROCENDF field.
	PKA_SR_PROCENDF_Pos = 0x11
	// Bit mask of PROCENDF field.
	PKA_SR_PROCENDF_Msk = 0x20000
	// Bit PROCENDF.
	PKA_SR_PROCENDF = 0x20000
	// Position of BUSY field.
	PKA_SR_BUSY_Pos = 0x10
	// Bit mask of BUSY field.
	PKA_SR_BUSY_Msk = 0x10000
	// Bit BUSY.
	PKA_SR_BUSY = 0x10000

	// CLRFR: clear flag register
	// Position of ADDRERRFC field.
	PKA_CLRFR_ADDRERRFC_Pos = 0x14
	// Bit mask of ADDRERRFC field.
	PKA_CLRFR_ADDRERRFC_Msk = 0x100000
	// Bit ADDRERRFC.
	PKA_CLRFR_ADDRERRFC = 0x100000
	// Position of RAMERRFC field.
	PKA_CLRFR_RAMERRFC_Pos = 0x13
	// Bit mask of RAMERRFC field.
	PKA_CLRFR_RAMERRFC_Msk = 0x80000
	// Bit RAMERRFC.
	PKA_CLRFR_RAMERRFC = 0x80000
	// Position of PROCENDFC field.
	PKA_CLRFR_PROCENDFC_Pos = 0x11
	// Bit mask of PROCENDFC field.
	PKA_CLRFR_PROCENDFC_Msk = 0x20000
	// Bit PROCENDFC.
	PKA_CLRFR_PROCENDFC = 0x20000
)

// Bitfields for PWR: Power control
const (
	// CR1: Power control register 1
	// Position of LPR field.
	PWR_CR1_LPR_Pos = 0xe
	// Bit mask of LPR field.
	PWR_CR1_LPR_Msk = 0x4000
	// Bit LPR.
	PWR_CR1_LPR = 0x4000
	// Position of VOS field.
	PWR_CR1_VOS_Pos = 0x9
	// Bit mask of VOS field.
	PWR_CR1_VOS_Msk = 0x600
	// Position of DBP field.
	PWR_CR1_DBP_Pos = 0x8
	// Bit mask of DBP field.
	PWR_CR1_DBP_Msk = 0x100
	// Bit DBP.
	PWR_CR1_DBP = 0x100
	// Position of FPDS field.
	PWR_CR1_FPDS_Pos = 0x5
	// Bit mask of FPDS field.
	PWR_CR1_FPDS_Msk = 0x20
	// Bit FPDS.
	PWR_CR1_FPDS = 0x20
	// Position of FPDR field.
	PWR_CR1_FPDR_Pos = 0x4
	// Bit mask of FPDR field.
	PWR_CR1_FPDR_Msk = 0x10
	// Bit FPDR.
	PWR_CR1_FPDR = 0x10
	// Position of SUBGHZSPINSSSEL field.
	PWR_CR1_SUBGHZSPINSSSEL_Pos = 0x3
	// Bit mask of SUBGHZSPINSSSEL field.
	PWR_CR1_SUBGHZSPINSSSEL_Msk = 0x8
	// Bit SUBGHZSPINSSSEL.
	PWR_CR1_SUBGHZSPINSSSEL = 0x8
	// Position of LPMS field.
	PWR_CR1_LPMS_Pos = 0x0
	// Bit mask of LPMS field.
	PWR_CR1_LPMS_Msk = 0x7

	// CR2: Power control register 2
	// Position of PVME3 field.
	PWR_CR2_PVME3_Pos = 0x6
	// Bit mask of PVME3 field.
	PWR_CR2_PVME3_Msk = 0x40
	// Bit PVME3.
	PWR_CR2_PVME3 = 0x40
	// Position of PLS field.
	PWR_CR2_PLS_Pos = 0x1
	// Bit mask of PLS field.
	PWR_CR2_PLS_Msk = 0xe
	// Position of PVDE field.
	PWR_CR2_PVDE_Pos = 0x0
	// Bit mask of PVDE field.
	PWR_CR2_PVDE_Msk = 0x1
	// Bit PVDE.
	PWR_CR2_PVDE = 0x1

	// CR3: Power control register 3
	// Position of EIWUL field.
	PWR_CR3_EIWUL_Pos = 0xf
	// Bit mask of EIWUL field.
	PWR_CR3_EIWUL_Msk = 0x8000
	// Bit EIWUL.
	PWR_CR3_EIWUL = 0x8000
	// Position of EC2H field.
	PWR_CR3_EC2H_Pos = 0xe
	// Bit mask of EC2H field.
	PWR_CR3_EC2H_Msk = 0x4000
	// Bit EC2H.
	PWR_CR3_EC2H = 0x4000
	// Position of EWRFIRQ field.
	PWR_CR3_EWRFIRQ_Pos = 0xd
	// Bit mask of EWRFIRQ field.
	PWR_CR3_EWRFIRQ_Msk = 0x2000
	// Bit EWRFIRQ.
	PWR_CR3_EWRFIRQ = 0x2000
	// Position of EWRFBUSY field.
	PWR_CR3_EWRFBUSY_Pos = 0xb
	// Bit mask of EWRFBUSY field.
	PWR_CR3_EWRFBUSY_Msk = 0x800
	// Bit EWRFBUSY.
	PWR_CR3_EWRFBUSY = 0x800
	// Position of APC field.
	PWR_CR3_APC_Pos = 0xa
	// Bit mask of APC field.
	PWR_CR3_APC_Msk = 0x400
	// Bit APC.
	PWR_CR3_APC = 0x400
	// Position of RRS field.
	PWR_CR3_RRS_Pos = 0x9
	// Bit mask of RRS field.
	PWR_CR3_RRS_Msk = 0x200
	// Bit RRS.
	PWR_CR3_RRS = 0x200
	// Position of EWPVD field.
	PWR_CR3_EWPVD_Pos = 0x8
	// Bit mask of EWPVD field.
	PWR_CR3_EWPVD_Msk = 0x100
	// Bit EWPVD.
	PWR_CR3_EWPVD = 0x100
	// Position of EULPEN field.
	PWR_CR3_EULPEN_Pos = 0x7
	// Bit mask of EULPEN field.
	PWR_CR3_EULPEN_Msk = 0x80
	// Bit EULPEN.
	PWR_CR3_EULPEN = 0x80
	// Position of EWUP3 field.
	PWR_CR3_EWUP3_Pos = 0x2
	// Bit mask of EWUP3 field.
	PWR_CR3_EWUP3_Msk = 0x4
	// Bit EWUP3.
	PWR_CR3_EWUP3 = 0x4
	// Position of EWUP2 field.
	PWR_CR3_EWUP2_Pos = 0x1
	// Bit mask of EWUP2 field.
	PWR_CR3_EWUP2_Msk = 0x2
	// Bit EWUP2.
	PWR_CR3_EWUP2 = 0x2
	// Position of EWUP1 field.
	PWR_CR3_EWUP1_Pos = 0x0
	// Bit mask of EWUP1 field.
	PWR_CR3_EWUP1_Msk = 0x1
	// Bit EWUP1.
	PWR_CR3_EWUP1 = 0x1

	// CR4: Power control register 4
	// Position of C2BOOT field.
	PWR_CR4_C2BOOT_Pos = 0xf
	// Bit mask of C2BOOT field.
	PWR_CR4_C2BOOT_Msk = 0x8000
	// Bit C2BOOT.
	PWR_CR4_C2BOOT = 0x8000
	// Position of WRFBUSYP field.
	PWR_CR4_WRFBUSYP_Pos = 0xb
	// Bit mask of WRFBUSYP field.
	PWR_CR4_WRFBUSYP_Msk = 0x800
	// Bit WRFBUSYP.
	PWR_CR4_WRFBUSYP = 0x800
	// Position of VBRS field.
	PWR_CR4_VBRS_Pos = 0x9
	// Bit mask of VBRS field.
	PWR_CR4_VBRS_Msk = 0x200
	// Bit VBRS.
	PWR_CR4_VBRS = 0x200
	// Position of VBE field.
	PWR_CR4_VBE_Pos = 0x8
	// Bit mask of VBE field.
	PWR_CR4_VBE_Msk = 0x100
	// Bit VBE.
	PWR_CR4_VBE = 0x100
	// Position of WP3 field.
	PWR_CR4_WP3_Pos = 0x2
	// Bit mask of WP3 field.
	PWR_CR4_WP3_Msk = 0x4
	// Bit WP3.
	PWR_CR4_WP3 = 0x4
	// Position of WP2 field.
	PWR_CR4_WP2_Pos = 0x1
	// Bit mask of WP2 field.
	PWR_CR4_WP2_Msk = 0x2
	// Bit WP2.
	PWR_CR4_WP2 = 0x2
	// Position of WP1 field.
	PWR_CR4_WP1_Pos = 0x0
	// Bit mask of WP1 field.
	PWR_CR4_WP1_Msk = 0x1
	// Bit WP1.
	PWR_CR4_WP1 = 0x1

	// SR1: Power status register 1
	// Position of WUFI field.
	PWR_SR1_WUFI_Pos = 0xf
	// Bit mask of WUFI field.
	PWR_SR1_WUFI_Msk = 0x8000
	// Bit WUFI.
	PWR_SR1_WUFI = 0x8000
	// Position of C2HF field.
	PWR_SR1_C2HF_Pos = 0xe
	// Bit mask of C2HF field.
	PWR_SR1_C2HF_Msk = 0x4000
	// Bit C2HF.
	PWR_SR1_C2HF = 0x4000
	// Position of WRFBUSYF field.
	PWR_SR1_WRFBUSYF_Pos = 0xb
	// Bit mask of WRFBUSYF field.
	PWR_SR1_WRFBUSYF_Msk = 0x800
	// Bit WRFBUSYF.
	PWR_SR1_WRFBUSYF = 0x800
	// Position of WPVDF field.
	PWR_SR1_WPVDF_Pos = 0x8
	// Bit mask of WPVDF field.
	PWR_SR1_WPVDF_Msk = 0x100
	// Bit WPVDF.
	PWR_SR1_WPVDF = 0x100
	// Position of WUF3 field.
	PWR_SR1_WUF3_Pos = 0x2
	// Bit mask of WUF3 field.
	PWR_SR1_WUF3_Msk = 0x4
	// Bit WUF3.
	PWR_SR1_WUF3 = 0x4
	// Position of WUF2 field.
	PWR_SR1_WUF2_Pos = 0x1
	// Bit mask of WUF2 field.
	PWR_SR1_WUF2_Msk = 0x2
	// Bit WUF2.
	PWR_SR1_WUF2 = 0x2
	// Position of WUF1 field.
	PWR_SR1_WUF1_Pos = 0x0
	// Bit mask of WUF1 field.
	PWR_SR1_WUF1_Msk = 0x1
	// Bit WUF1.
	PWR_SR1_WUF1 = 0x1

	// SR2: Power status register 2
	// Position of PVMO3 field.
	PWR_SR2_PVMO3_Pos = 0xe
	// Bit mask of PVMO3 field.
	PWR_SR2_PVMO3_Msk = 0x4000
	// Bit PVMO3.
	PWR_SR2_PVMO3 = 0x4000
	// Position of PVDO field.
	PWR_SR2_PVDO_Pos = 0xb
	// Bit mask of PVDO field.
	PWR_SR2_PVDO_Msk = 0x800
	// Bit PVDO.
	PWR_SR2_PVDO = 0x800
	// Position of VOSF field.
	PWR_SR2_VOSF_Pos = 0xa
	// Bit mask of VOSF field.
	PWR_SR2_VOSF_Msk = 0x400
	// Bit VOSF.
	PWR_SR2_VOSF = 0x400
	// Position of REGLPF field.
	PWR_SR2_REGLPF_Pos = 0x9
	// Bit mask of REGLPF field.
	PWR_SR2_REGLPF_Msk = 0x200
	// Bit REGLPF.
	PWR_SR2_REGLPF = 0x200
	// Position of REGLPS field.
	PWR_SR2_REGLPS_Pos = 0x8
	// Bit mask of REGLPS field.
	PWR_SR2_REGLPS_Msk = 0x100
	// Bit REGLPS.
	PWR_SR2_REGLPS = 0x100
	// Position of FLASHRDY field.
	PWR_SR2_FLASHRDY_Pos = 0x7
	// Bit mask of FLASHRDY field.
	PWR_SR2_FLASHRDY_Msk = 0x80
	// Bit FLASHRDY.
	PWR_SR2_FLASHRDY = 0x80
	// Position of REGMRS field.
	PWR_SR2_REGMRS_Pos = 0x6
	// Bit mask of REGMRS field.
	PWR_SR2_REGMRS_Msk = 0x40
	// Bit REGMRS.
	PWR_SR2_REGMRS = 0x40
	// Position of RFEOLF field.
	PWR_SR2_RFEOLF_Pos = 0x5
	// Bit mask of RFEOLF field.
	PWR_SR2_RFEOLF_Msk = 0x20
	// Bit RFEOLF.
	PWR_SR2_RFEOLF = 0x20
	// Position of LDORDY field.
	PWR_SR2_LDORDY_Pos = 0x4
	// Bit mask of LDORDY field.
	PWR_SR2_LDORDY_Msk = 0x10
	// Bit LDORDY.
	PWR_SR2_LDORDY = 0x10
	// Position of SMPSRDY field.
	PWR_SR2_SMPSRDY_Pos = 0x3
	// Bit mask of SMPSRDY field.
	PWR_SR2_SMPSRDY_Msk = 0x8
	// Bit SMPSRDY.
	PWR_SR2_SMPSRDY = 0x8
	// Position of RFBUSYMS field.
	PWR_SR2_RFBUSYMS_Pos = 0x2
	// Bit mask of RFBUSYMS field.
	PWR_SR2_RFBUSYMS_Msk = 0x4
	// Bit RFBUSYMS.
	PWR_SR2_RFBUSYMS = 0x4
	// Position of RFBUSYS field.
	PWR_SR2_RFBUSYS_Pos = 0x1
	// Bit mask of RFBUSYS field.
	PWR_SR2_RFBUSYS_Msk = 0x2
	// Bit RFBUSYS.
	PWR_SR2_RFBUSYS = 0x2
	// Position of C2BOOTS field.
	PWR_SR2_C2BOOTS_Pos = 0x0
	// Bit mask of C2BOOTS field.
	PWR_SR2_C2BOOTS_Msk = 0x1
	// Bit C2BOOTS.
	PWR_SR2_C2BOOTS = 0x1

	// SCR: Power status clear register
	// Position of CC2HF field.
	PWR_SCR_CC2HF_Pos = 0xe
	// Bit mask of CC2HF field.
	PWR_SCR_CC2HF_Msk = 0x4000
	// Bit CC2HF.
	PWR_SCR_CC2HF = 0x4000
	// Position of CWRFBUSYF field.
	PWR_SCR_CWRFBUSYF_Pos = 0xb
	// Bit mask of CWRFBUSYF field.
	PWR_SCR_CWRFBUSYF_Msk = 0x800
	// Bit CWRFBUSYF.
	PWR_SCR_CWRFBUSYF = 0x800
	// Position of CWPVDF field.
	PWR_SCR_CWPVDF_Pos = 0x8
	// Bit mask of CWPVDF field.
	PWR_SCR_CWPVDF_Msk = 0x100
	// Bit CWPVDF.
	PWR_SCR_CWPVDF = 0x100
	// Position of CWUF3 field.
	PWR_SCR_CWUF3_Pos = 0x2
	// Bit mask of CWUF3 field.
	PWR_SCR_CWUF3_Msk = 0x4
	// Bit CWUF3.
	PWR_SCR_CWUF3 = 0x4
	// Position of CWUF2 field.
	PWR_SCR_CWUF2_Pos = 0x1
	// Bit mask of CWUF2 field.
	PWR_SCR_CWUF2_Msk = 0x2
	// Bit CWUF2.
	PWR_SCR_CWUF2 = 0x2
	// Position of CWUF1 field.
	PWR_SCR_CWUF1_Pos = 0x0
	// Bit mask of CWUF1 field.
	PWR_SCR_CWUF1_Msk = 0x1
	// Bit CWUF1.
	PWR_SCR_CWUF1 = 0x1

	// CR5: Power control register 5
	// Position of SMPSEN field.
	PWR_CR5_SMPSEN_Pos = 0xf
	// Bit mask of SMPSEN field.
	PWR_CR5_SMPSEN_Msk = 0x8000
	// Bit SMPSEN.
	PWR_CR5_SMPSEN = 0x8000
	// Position of RFEOLEN field.
	PWR_CR5_RFEOLEN_Pos = 0xe
	// Bit mask of RFEOLEN field.
	PWR_CR5_RFEOLEN_Msk = 0x4000
	// Bit RFEOLEN.
	PWR_CR5_RFEOLEN = 0x4000

	// PUCRA: Power Port A pull-up control register
	// Position of PU15 field.
	PWR_PUCRA_PU15_Pos = 0xf
	// Bit mask of PU15 field.
	PWR_PUCRA_PU15_Msk = 0x8000
	// Bit PU15.
	PWR_PUCRA_PU15 = 0x8000
	// Position of PU14 field.
	PWR_PUCRA_PU14_Pos = 0xe
	// Bit mask of PU14 field.
	PWR_PUCRA_PU14_Msk = 0x4000
	// Bit PU14.
	PWR_PUCRA_PU14 = 0x4000
	// Position of PU13 field.
	PWR_PUCRA_PU13_Pos = 0xd
	// Bit mask of PU13 field.
	PWR_PUCRA_PU13_Msk = 0x2000
	// Bit PU13.
	PWR_PUCRA_PU13 = 0x2000
	// Position of PU12 field.
	PWR_PUCRA_PU12_Pos = 0xc
	// Bit mask of PU12 field.
	PWR_PUCRA_PU12_Msk = 0x1000
	// Bit PU12.
	PWR_PUCRA_PU12 = 0x1000
	// Position of PU11 field.
	PWR_PUCRA_PU11_Pos = 0xb
	// Bit mask of PU11 field.
	PWR_PUCRA_PU11_Msk = 0x800
	// Bit PU11.
	PWR_PUCRA_PU11 = 0x800
	// Position of PU10 field.
	PWR_PUCRA_PU10_Pos = 0xa
	// Bit mask of PU10 field.
	PWR_PUCRA_PU10_Msk = 0x400
	// Bit PU10.
	PWR_PUCRA_PU10 = 0x400
	// Position of PU9 field.
	PWR_PUCRA_PU9_Pos = 0x9
	// Bit mask of PU9 field.
	PWR_PUCRA_PU9_Msk = 0x200
	// Bit PU9.
	PWR_PUCRA_PU9 = 0x200
	// Position of PU8 field.
	PWR_PUCRA_PU8_Pos = 0x8
	// Bit mask of PU8 field.
	PWR_PUCRA_PU8_Msk = 0x100
	// Bit PU8.
	PWR_PUCRA_PU8 = 0x100
	// Position of PU7 field.
	PWR_PUCRA_PU7_Pos = 0x7
	// Bit mask of PU7 field.
	PWR_PUCRA_PU7_Msk = 0x80
	// Bit PU7.
	PWR_PUCRA_PU7 = 0x80
	// Position of PU6 field.
	PWR_PUCRA_PU6_Pos = 0x6
	// Bit mask of PU6 field.
	PWR_PUCRA_PU6_Msk = 0x40
	// Bit PU6.
	PWR_PUCRA_PU6 = 0x40
	// Position of PU5 field.
	PWR_PUCRA_PU5_Pos = 0x5
	// Bit mask of PU5 field.
	PWR_PUCRA_PU5_Msk = 0x20
	// Bit PU5.
	PWR_PUCRA_PU5 = 0x20
	// Position of PU4 field.
	PWR_PUCRA_PU4_Pos = 0x4
	// Bit mask of PU4 field.
	PWR_PUCRA_PU4_Msk = 0x10
	// Bit PU4.
	PWR_PUCRA_PU4 = 0x10
	// Position of PU3 field.
	PWR_PUCRA_PU3_Pos = 0x3
	// Bit mask of PU3 field.
	PWR_PUCRA_PU3_Msk = 0x8
	// Bit PU3.
	PWR_PUCRA_PU3 = 0x8
	// Position of PU2 field.
	PWR_PUCRA_PU2_Pos = 0x2
	// Bit mask of PU2 field.
	PWR_PUCRA_PU2_Msk = 0x4
	// Bit PU2.
	PWR_PUCRA_PU2 = 0x4
	// Position of PU1 field.
	PWR_PUCRA_PU1_Pos = 0x1
	// Bit mask of PU1 field.
	PWR_PUCRA_PU1_Msk = 0x2
	// Bit PU1.
	PWR_PUCRA_PU1 = 0x2
	// Position of PU0 field.
	PWR_PUCRA_PU0_Pos = 0x0
	// Bit mask of PU0 field.
	PWR_PUCRA_PU0_Msk = 0x1
	// Bit PU0.
	PWR_PUCRA_PU0 = 0x1

	// PDCRA: Power Port A pull-down control register
	// Position of PD15 field.
	PWR_PDCRA_PD15_Pos = 0xf
	// Bit mask of PD15 field.
	PWR_PDCRA_PD15_Msk = 0x8000
	// Bit PD15.
	PWR_PDCRA_PD15 = 0x8000
	// Position of PD14 field.
	PWR_PDCRA_PD14_Pos = 0xe
	// Bit mask of PD14 field.
	PWR_PDCRA_PD14_Msk = 0x4000
	// Bit PD14.
	PWR_PDCRA_PD14 = 0x4000
	// Position of PD13 field.
	PWR_PDCRA_PD13_Pos = 0xd
	// Bit mask of PD13 field.
	PWR_PDCRA_PD13_Msk = 0x2000
	// Bit PD13.
	PWR_PDCRA_PD13 = 0x2000
	// Position of PD12 field.
	PWR_PDCRA_PD12_Pos = 0xc
	// Bit mask of PD12 field.
	PWR_PDCRA_PD12_Msk = 0x1000
	// Bit PD12.
	PWR_PDCRA_PD12 = 0x1000
	// Position of PD11 field.
	PWR_PDCRA_PD11_Pos = 0xb
	// Bit mask of PD11 field.
	PWR_PDCRA_PD11_Msk = 0x800
	// Bit PD11.
	PWR_PDCRA_PD11 = 0x800
	// Position of PD10 field.
	PWR_PDCRA_PD10_Pos = 0xa
	// Bit mask of PD10 field.
	PWR_PDCRA_PD10_Msk = 0x400
	// Bit PD10.
	PWR_PDCRA_PD10 = 0x400
	// Position of PD9 field.
	PWR_PDCRA_PD9_Pos = 0x9
	// Bit mask of PD9 field.
	PWR_PDCRA_PD9_Msk = 0x200
	// Bit PD9.
	PWR_PDCRA_PD9 = 0x200
	// Position of PD8 field.
	PWR_PDCRA_PD8_Pos = 0x8
	// Bit mask of PD8 field.
	PWR_PDCRA_PD8_Msk = 0x100
	// Bit PD8.
	PWR_PDCRA_PD8 = 0x100
	// Position of PD7 field.
	PWR_PDCRA_PD7_Pos = 0x7
	// Bit mask of PD7 field.
	PWR_PDCRA_PD7_Msk = 0x80
	// Bit PD7.
	PWR_PDCRA_PD7 = 0x80
	// Position of PD6 field.
	PWR_PDCRA_PD6_Pos = 0x6
	// Bit mask of PD6 field.
	PWR_PDCRA_PD6_Msk = 0x40
	// Bit PD6.
	PWR_PDCRA_PD6 = 0x40
	// Position of PD5 field.
	PWR_PDCRA_PD5_Pos = 0x5
	// Bit mask of PD5 field.
	PWR_PDCRA_PD5_Msk = 0x20
	// Bit PD5.
	PWR_PDCRA_PD5 = 0x20
	// Position of PD4 field.
	PWR_PDCRA_PD4_Pos = 0x4
	// Bit mask of PD4 field.
	PWR_PDCRA_PD4_Msk = 0x10
	// Bit PD4.
	PWR_PDCRA_PD4 = 0x10
	// Position of PD3 field.
	PWR_PDCRA_PD3_Pos = 0x3
	// Bit mask of PD3 field.
	PWR_PDCRA_PD3_Msk = 0x8
	// Bit PD3.
	PWR_PDCRA_PD3 = 0x8
	// Position of PD2 field.
	PWR_PDCRA_PD2_Pos = 0x2
	// Bit mask of PD2 field.
	PWR_PDCRA_PD2_Msk = 0x4
	// Bit PD2.
	PWR_PDCRA_PD2 = 0x4
	// Position of PD1 field.
	PWR_PDCRA_PD1_Pos = 0x1
	// Bit mask of PD1 field.
	PWR_PDCRA_PD1_Msk = 0x2
	// Bit PD1.
	PWR_PDCRA_PD1 = 0x2
	// Position of PD0 field.
	PWR_PDCRA_PD0_Pos = 0x0
	// Bit mask of PD0 field.
	PWR_PDCRA_PD0_Msk = 0x1
	// Bit PD0.
	PWR_PDCRA_PD0 = 0x1

	// PUCRB: Power Port B pull-up control register
	// Position of PU15 field.
	PWR_PUCRB_PU15_Pos = 0xf
	// Bit mask of PU15 field.
	PWR_PUCRB_PU15_Msk = 0x8000
	// Bit PU15.
	PWR_PUCRB_PU15 = 0x8000
	// Position of PU14 field.
	PWR_PUCRB_PU14_Pos = 0xe
	// Bit mask of PU14 field.
	PWR_PUCRB_PU14_Msk = 0x4000
	// Bit PU14.
	PWR_PUCRB_PU14 = 0x4000
	// Position of PU13 field.
	PWR_PUCRB_PU13_Pos = 0xd
	// Bit mask of PU13 field.
	PWR_PUCRB_PU13_Msk = 0x2000
	// Bit PU13.
	PWR_PUCRB_PU13 = 0x2000
	// Position of PU12 field.
	PWR_PUCRB_PU12_Pos = 0xc
	// Bit mask of PU12 field.
	PWR_PUCRB_PU12_Msk = 0x1000
	// Bit PU12.
	PWR_PUCRB_PU12 = 0x1000
	// Position of PU11 field.
	PWR_PUCRB_PU11_Pos = 0xb
	// Bit mask of PU11 field.
	PWR_PUCRB_PU11_Msk = 0x800
	// Bit PU11.
	PWR_PUCRB_PU11 = 0x800
	// Position of PU10 field.
	PWR_PUCRB_PU10_Pos = 0xa
	// Bit mask of PU10 field.
	PWR_PUCRB_PU10_Msk = 0x400
	// Bit PU10.
	PWR_PUCRB_PU10 = 0x400
	// Position of PU9 field.
	PWR_PUCRB_PU9_Pos = 0x9
	// Bit mask of PU9 field.
	PWR_PUCRB_PU9_Msk = 0x200
	// Bit PU9.
	PWR_PUCRB_PU9 = 0x200
	// Position of PU8 field.
	PWR_PUCRB_PU8_Pos = 0x8
	// Bit mask of PU8 field.
	PWR_PUCRB_PU8_Msk = 0x100
	// Bit PU8.
	PWR_PUCRB_PU8 = 0x100
	// Position of PU7 field.
	PWR_PUCRB_PU7_Pos = 0x7
	// Bit mask of PU7 field.
	PWR_PUCRB_PU7_Msk = 0x80
	// Bit PU7.
	PWR_PUCRB_PU7 = 0x80
	// Position of PU6 field.
	PWR_PUCRB_PU6_Pos = 0x6
	// Bit mask of PU6 field.
	PWR_PUCRB_PU6_Msk = 0x40
	// Bit PU6.
	PWR_PUCRB_PU6 = 0x40
	// Position of PU5 field.
	PWR_PUCRB_PU5_Pos = 0x5
	// Bit mask of PU5 field.
	PWR_PUCRB_PU5_Msk = 0x20
	// Bit PU5.
	PWR_PUCRB_PU5 = 0x20
	// Position of PU4 field.
	PWR_PUCRB_PU4_Pos = 0x4
	// Bit mask of PU4 field.
	PWR_PUCRB_PU4_Msk = 0x10
	// Bit PU4.
	PWR_PUCRB_PU4 = 0x10
	// Position of PU3 field.
	PWR_PUCRB_PU3_Pos = 0x3
	// Bit mask of PU3 field.
	PWR_PUCRB_PU3_Msk = 0x8
	// Bit PU3.
	PWR_PUCRB_PU3 = 0x8
	// Position of PU2 field.
	PWR_PUCRB_PU2_Pos = 0x2
	// Bit mask of PU2 field.
	PWR_PUCRB_PU2_Msk = 0x4
	// Bit PU2.
	PWR_PUCRB_PU2 = 0x4
	// Position of PU1 field.
	PWR_PUCRB_PU1_Pos = 0x1
	// Bit mask of PU1 field.
	PWR_PUCRB_PU1_Msk = 0x2
	// Bit PU1.
	PWR_PUCRB_PU1 = 0x2
	// Position of PU0 field.
	PWR_PUCRB_PU0_Pos = 0x0
	// Bit mask of PU0 field.
	PWR_PUCRB_PU0_Msk = 0x1
	// Bit PU0.
	PWR_PUCRB_PU0 = 0x1

	// PDCRB: Power Port B pull-down control register
	// Position of PD15 field.
	PWR_PDCRB_PD15_Pos = 0xf
	// Bit mask of PD15 field.
	PWR_PDCRB_PD15_Msk = 0x8000
	// Bit PD15.
	PWR_PDCRB_PD15 = 0x8000
	// Position of PD14 field.
	PWR_PDCRB_PD14_Pos = 0xe
	// Bit mask of PD14 field.
	PWR_PDCRB_PD14_Msk = 0x4000
	// Bit PD14.
	PWR_PDCRB_PD14 = 0x4000
	// Position of PD13 field.
	PWR_PDCRB_PD13_Pos = 0xd
	// Bit mask of PD13 field.
	PWR_PDCRB_PD13_Msk = 0x2000
	// Bit PD13.
	PWR_PDCRB_PD13 = 0x2000
	// Position of PD12 field.
	PWR_PDCRB_PD12_Pos = 0xc
	// Bit mask of PD12 field.
	PWR_PDCRB_PD12_Msk = 0x1000
	// Bit PD12.
	PWR_PDCRB_PD12 = 0x1000
	// Position of PD11 field.
	PWR_PDCRB_PD11_Pos = 0xb
	// Bit mask of PD11 field.
	PWR_PDCRB_PD11_Msk = 0x800
	// Bit PD11.
	PWR_PDCRB_PD11 = 0x800
	// Position of PD10 field.
	PWR_PDCRB_PD10_Pos = 0xa
	// Bit mask of PD10 field.
	PWR_PDCRB_PD10_Msk = 0x400
	// Bit PD10.
	PWR_PDCRB_PD10 = 0x400
	// Position of PD9 field.
	PWR_PDCRB_PD9_Pos = 0x9
	// Bit mask of PD9 field.
	PWR_PDCRB_PD9_Msk = 0x200
	// Bit PD9.
	PWR_PDCRB_PD9 = 0x200
	// Position of PD8 field.
	PWR_PDCRB_PD8_Pos = 0x8
	// Bit mask of PD8 field.
	PWR_PDCRB_PD8_Msk = 0x100
	// Bit PD8.
	PWR_PDCRB_PD8 = 0x100
	// Position of PD7 field.
	PWR_PDCRB_PD7_Pos = 0x7
	// Bit mask of PD7 field.
	PWR_PDCRB_PD7_Msk = 0x80
	// Bit PD7.
	PWR_PDCRB_PD7 = 0x80
	// Position of PD6 field.
	PWR_PDCRB_PD6_Pos = 0x6
	// Bit mask of PD6 field.
	PWR_PDCRB_PD6_Msk = 0x40
	// Bit PD6.
	PWR_PDCRB_PD6 = 0x40
	// Position of PD5 field.
	PWR_PDCRB_PD5_Pos = 0x5
	// Bit mask of PD5 field.
	PWR_PDCRB_PD5_Msk = 0x20
	// Bit PD5.
	PWR_PDCRB_PD5 = 0x20
	// Position of PD4 field.
	PWR_PDCRB_PD4_Pos = 0x4
	// Bit mask of PD4 field.
	PWR_PDCRB_PD4_Msk = 0x10
	// Bit PD4.
	PWR_PDCRB_PD4 = 0x10
	// Position of PD3 field.
	PWR_PDCRB_PD3_Pos = 0x3
	// Bit mask of PD3 field.
	PWR_PDCRB_PD3_Msk = 0x8
	// Bit PD3.
	PWR_PDCRB_PD3 = 0x8
	// Position of PD2 field.
	PWR_PDCRB_PD2_Pos = 0x2
	// Bit mask of PD2 field.
	PWR_PDCRB_PD2_Msk = 0x4
	// Bit PD2.
	PWR_PDCRB_PD2 = 0x4
	// Position of PD1 field.
	PWR_PDCRB_PD1_Pos = 0x1
	// Bit mask of PD1 field.
	PWR_PDCRB_PD1_Msk = 0x2
	// Bit PD1.
	PWR_PDCRB_PD1 = 0x2
	// Position of PD0 field.
	PWR_PDCRB_PD0_Pos = 0x0
	// Bit mask of PD0 field.
	PWR_PDCRB_PD0_Msk = 0x1
	// Bit PD0.
	PWR_PDCRB_PD0 = 0x1

	// PUCRC: Power Port C pull-up control register
	// Position of PU15 field.
	PWR_PUCRC_PU15_Pos = 0xf
	// Bit mask of PU15 field.
	PWR_PUCRC_PU15_Msk = 0x8000
	// Bit PU15.
	PWR_PUCRC_PU15 = 0x8000
	// Position of PU14 field.
	PWR_PUCRC_PU14_Pos = 0xe
	// Bit mask of PU14 field.
	PWR_PUCRC_PU14_Msk = 0x4000
	// Bit PU14.
	PWR_PUCRC_PU14 = 0x4000
	// Position of PU13 field.
	PWR_PUCRC_PU13_Pos = 0xd
	// Bit mask of PU13 field.
	PWR_PUCRC_PU13_Msk = 0x2000
	// Bit PU13.
	PWR_PUCRC_PU13 = 0x2000
	// Position of PU2 field.
	PWR_PUCRC_PU2_Pos = 0x2
	// Bit mask of PU2 field.
	PWR_PUCRC_PU2_Msk = 0x4
	// Bit PU2.
	PWR_PUCRC_PU2 = 0x4
	// Position of PU1 field.
	PWR_PUCRC_PU1_Pos = 0x1
	// Bit mask of PU1 field.
	PWR_PUCRC_PU1_Msk = 0x2
	// Bit PU1.
	PWR_PUCRC_PU1 = 0x2
	// Position of PU0 field.
	PWR_PUCRC_PU0_Pos = 0x0
	// Bit mask of PU0 field.
	PWR_PUCRC_PU0_Msk = 0x1
	// Bit PU0.
	PWR_PUCRC_PU0 = 0x1
	// Position of PU3 field.
	PWR_PUCRC_PU3_Pos = 0x3
	// Bit mask of PU3 field.
	PWR_PUCRC_PU3_Msk = 0x8
	// Bit PU3.
	PWR_PUCRC_PU3 = 0x8
	// Position of PU4 field.
	PWR_PUCRC_PU4_Pos = 0x4
	// Bit mask of PU4 field.
	PWR_PUCRC_PU4_Msk = 0x10
	// Bit PU4.
	PWR_PUCRC_PU4 = 0x10
	// Position of PU5 field.
	PWR_PUCRC_PU5_Pos = 0x5
	// Bit mask of PU5 field.
	PWR_PUCRC_PU5_Msk = 0x20
	// Bit PU5.
	PWR_PUCRC_PU5 = 0x20
	// Position of PU6 field.
	PWR_PUCRC_PU6_Pos = 0x6
	// Bit mask of PU6 field.
	PWR_PUCRC_PU6_Msk = 0x40
	// Bit PU6.
	PWR_PUCRC_PU6 = 0x40

	// PDCRC: Power Port C pull-down control register
	// Position of PD15 field.
	PWR_PDCRC_PD15_Pos = 0xf
	// Bit mask of PD15 field.
	PWR_PDCRC_PD15_Msk = 0x8000
	// Bit PD15.
	PWR_PDCRC_PD15 = 0x8000
	// Position of PD14 field.
	PWR_PDCRC_PD14_Pos = 0xe
	// Bit mask of PD14 field.
	PWR_PDCRC_PD14_Msk = 0x4000
	// Bit PD14.
	PWR_PDCRC_PD14 = 0x4000
	// Position of PD13 field.
	PWR_PDCRC_PD13_Pos = 0xd
	// Bit mask of PD13 field.
	PWR_PDCRC_PD13_Msk = 0x2000
	// Bit PD13.
	PWR_PDCRC_PD13 = 0x2000
	// Position of PD2 field.
	PWR_PDCRC_PD2_Pos = 0x2
	// Bit mask of PD2 field.
	PWR_PDCRC_PD2_Msk = 0x4
	// Bit PD2.
	PWR_PDCRC_PD2 = 0x4
	// Position of PD1 field.
	PWR_PDCRC_PD1_Pos = 0x1
	// Bit mask of PD1 field.
	PWR_PDCRC_PD1_Msk = 0x2
	// Bit PD1.
	PWR_PDCRC_PD1 = 0x2
	// Position of PD0 field.
	PWR_PDCRC_PD0_Pos = 0x0
	// Bit mask of PD0 field.
	PWR_PDCRC_PD0_Msk = 0x1
	// Bit PD0.
	PWR_PDCRC_PD0 = 0x1
	// Position of PD3 field.
	PWR_PDCRC_PD3_Pos = 0x3
	// Bit mask of PD3 field.
	PWR_PDCRC_PD3_Msk = 0x8
	// Bit PD3.
	PWR_PDCRC_PD3 = 0x8
	// Position of PD4 field.
	PWR_PDCRC_PD4_Pos = 0x4
	// Bit mask of PD4 field.
	PWR_PDCRC_PD4_Msk = 0x10
	// Bit PD4.
	PWR_PDCRC_PD4 = 0x10
	// Position of PD5 field.
	PWR_PDCRC_PD5_Pos = 0x5
	// Bit mask of PD5 field.
	PWR_PDCRC_PD5_Msk = 0x20
	// Bit PD5.
	PWR_PDCRC_PD5 = 0x20
	// Position of PD6 field.
	PWR_PDCRC_PD6_Pos = 0x6
	// Bit mask of PD6 field.
	PWR_PDCRC_PD6_Msk = 0x40
	// Bit PD6.
	PWR_PDCRC_PD6 = 0x40

	// PUCRH: Power Port H pull-up control register
	// Position of PU3 field.
	PWR_PUCRH_PU3_Pos = 0x3
	// Bit mask of PU3 field.
	PWR_PUCRH_PU3_Msk = 0x8
	// Bit PU3.
	PWR_PUCRH_PU3 = 0x8

	// PDCRH: Power Port H pull-down control register
	// Position of PD3 field.
	PWR_PDCRH_PD3_Pos = 0x3
	// Bit mask of PD3 field.
	PWR_PDCRH_PD3_Msk = 0x8
	// Bit PD3.
	PWR_PDCRH_PD3 = 0x8

	// C2CR1: Power CPU2 control register 1 [dual core device only]
	// Position of FPDS field.
	PWR_C2CR1_FPDS_Pos = 0x5
	// Bit mask of FPDS field.
	PWR_C2CR1_FPDS_Msk = 0x20
	// Bit FPDS.
	PWR_C2CR1_FPDS = 0x20
	// Position of FPDR field.
	PWR_C2CR1_FPDR_Pos = 0x4
	// Bit mask of FPDR field.
	PWR_C2CR1_FPDR_Msk = 0x10
	// Bit FPDR.
	PWR_C2CR1_FPDR = 0x10
	// Position of LPMS field.
	PWR_C2CR1_LPMS_Pos = 0x0
	// Bit mask of LPMS field.
	PWR_C2CR1_LPMS_Msk = 0x7

	// C2CR3: Power CPU2 control register 3 [dual core device only]
	// Position of EIWUL field.
	PWR_C2CR3_EIWUL_Pos = 0xf
	// Bit mask of EIWUL field.
	PWR_C2CR3_EIWUL_Msk = 0x8000
	// Bit EIWUL.
	PWR_C2CR3_EIWUL = 0x8000
	// Position of EWRFIRQ field.
	PWR_C2CR3_EWRFIRQ_Pos = 0xd
	// Bit mask of EWRFIRQ field.
	PWR_C2CR3_EWRFIRQ_Msk = 0x2000
	// Bit EWRFIRQ.
	PWR_C2CR3_EWRFIRQ = 0x2000
	// Position of EWRFBUSY field.
	PWR_C2CR3_EWRFBUSY_Pos = 0xb
	// Bit mask of EWRFBUSY field.
	PWR_C2CR3_EWRFBUSY_Msk = 0x800
	// Bit EWRFBUSY.
	PWR_C2CR3_EWRFBUSY = 0x800
	// Position of APC field.
	PWR_C2CR3_APC_Pos = 0xa
	// Bit mask of APC field.
	PWR_C2CR3_APC_Msk = 0x400
	// Bit APC.
	PWR_C2CR3_APC = 0x400
	// Position of EWPVD field.
	PWR_C2CR3_EWPVD_Pos = 0x8
	// Bit mask of EWPVD field.
	PWR_C2CR3_EWPVD_Msk = 0x100
	// Bit EWPVD.
	PWR_C2CR3_EWPVD = 0x100
	// Position of EWUP3 field.
	PWR_C2CR3_EWUP3_Pos = 0x2
	// Bit mask of EWUP3 field.
	PWR_C2CR3_EWUP3_Msk = 0x4
	// Bit EWUP3.
	PWR_C2CR3_EWUP3 = 0x4
	// Position of EWUP2 field.
	PWR_C2CR3_EWUP2_Pos = 0x1
	// Bit mask of EWUP2 field.
	PWR_C2CR3_EWUP2_Msk = 0x2
	// Bit EWUP2.
	PWR_C2CR3_EWUP2 = 0x2
	// Position of EWUP1 field.
	PWR_C2CR3_EWUP1_Pos = 0x0
	// Bit mask of EWUP1 field.
	PWR_C2CR3_EWUP1_Msk = 0x1
	// Bit EWUP1.
	PWR_C2CR3_EWUP1 = 0x1

	// EXTSCR: Power extended status and status clear register
	// Position of C2DS field.
	PWR_EXTSCR_C2DS_Pos = 0xf
	// Bit mask of C2DS field.
	PWR_EXTSCR_C2DS_Msk = 0x8000
	// Bit C2DS.
	PWR_EXTSCR_C2DS = 0x8000
	// Position of C1DS field.
	PWR_EXTSCR_C1DS_Pos = 0xe
	// Bit mask of C1DS field.
	PWR_EXTSCR_C1DS_Msk = 0x4000
	// Bit C1DS.
	PWR_EXTSCR_C1DS = 0x4000
	// Position of C2STOPF field.
	PWR_EXTSCR_C2STOPF_Pos = 0xd
	// Bit mask of C2STOPF field.
	PWR_EXTSCR_C2STOPF_Msk = 0x2000
	// Bit C2STOPF.
	PWR_EXTSCR_C2STOPF = 0x2000
	// Position of C2STOP2F field.
	PWR_EXTSCR_C2STOP2F_Pos = 0xc
	// Bit mask of C2STOP2F field.
	PWR_EXTSCR_C2STOP2F_Msk = 0x1000
	// Bit C2STOP2F.
	PWR_EXTSCR_C2STOP2F = 0x1000
	// Position of C2SBF field.
	PWR_EXTSCR_C2SBF_Pos = 0xb
	// Bit mask of C2SBF field.
	PWR_EXTSCR_C2SBF_Msk = 0x800
	// Bit C2SBF.
	PWR_EXTSCR_C2SBF = 0x800
	// Position of C1STOPF field.
	PWR_EXTSCR_C1STOPF_Pos = 0xa
	// Bit mask of C1STOPF field.
	PWR_EXTSCR_C1STOPF_Msk = 0x400
	// Bit C1STOPF.
	PWR_EXTSCR_C1STOPF = 0x400
	// Position of C1STOP2F field.
	PWR_EXTSCR_C1STOP2F_Pos = 0x9
	// Bit mask of C1STOP2F field.
	PWR_EXTSCR_C1STOP2F_Msk = 0x200
	// Bit C1STOP2F.
	PWR_EXTSCR_C1STOP2F = 0x200
	// Position of C1SBF field.
	PWR_EXTSCR_C1SBF_Pos = 0x8
	// Bit mask of C1SBF field.
	PWR_EXTSCR_C1SBF_Msk = 0x100
	// Bit C1SBF.
	PWR_EXTSCR_C1SBF = 0x100
	// Position of C2CSSF field.
	PWR_EXTSCR_C2CSSF_Pos = 0x1
	// Bit mask of C2CSSF field.
	PWR_EXTSCR_C2CSSF_Msk = 0x2
	// Bit C2CSSF.
	PWR_EXTSCR_C2CSSF = 0x2
	// Position of C1CSSF field.
	PWR_EXTSCR_C1CSSF_Pos = 0x0
	// Bit mask of C1CSSF field.
	PWR_EXTSCR_C1CSSF_Msk = 0x1
	// Bit C1CSSF.
	PWR_EXTSCR_C1CSSF = 0x1

	// SECCFGR: Power security configuration register [dual core device only]
	// Position of C2EWILA field.
	PWR_SECCFGR_C2EWILA_Pos = 0xf
	// Bit mask of C2EWILA field.
	PWR_SECCFGR_C2EWILA_Msk = 0x8000
	// Bit C2EWILA.
	PWR_SECCFGR_C2EWILA = 0x8000

	// SUBGHZSPICR: Power SPI3 control register
	// Position of NSS field.
	PWR_SUBGHZSPICR_NSS_Pos = 0xf
	// Bit mask of NSS field.
	PWR_SUBGHZSPICR_NSS_Msk = 0x8000
	// Bit NSS.
	PWR_SUBGHZSPICR_NSS = 0x8000

	// RSSCMDR: RSS Command register [dual core device only]
	// Position of RSSCMD field.
	PWR_RSSCMDR_RSSCMD_Pos = 0x0
	// Bit mask of RSSCMD field.
	PWR_RSSCMDR_RSSCMD_Msk = 0xff
)

// Bitfields for RCC: Reset and clock control
const (
	// CR: Clock control register
	// Position of PLLRDY field.
	RCC_CR_PLLRDY_Pos = 0x19
	// Bit mask of PLLRDY field.
	RCC_CR_PLLRDY_Msk = 0x2000000
	// Bit PLLRDY.
	RCC_CR_PLLRDY = 0x2000000
	// Position of PLLON field.
	RCC_CR_PLLON_Pos = 0x18
	// Bit mask of PLLON field.
	RCC_CR_PLLON_Msk = 0x1000000
	// Bit PLLON.
	RCC_CR_PLLON = 0x1000000
	// Position of HSEBYPPWR field.
	RCC_CR_HSEBYPPWR_Pos = 0x15
	// Bit mask of HSEBYPPWR field.
	RCC_CR_HSEBYPPWR_Msk = 0x200000
	// Bit HSEBYPPWR.
	RCC_CR_HSEBYPPWR = 0x200000
	// Position of HSEPRE field.
	RCC_CR_HSEPRE_Pos = 0x14
	// Bit mask of HSEPRE field.
	RCC_CR_HSEPRE_Msk = 0x100000
	// Bit HSEPRE.
	RCC_CR_HSEPRE = 0x100000
	// Position of CSSON field.
	RCC_CR_CSSON_Pos = 0x13
	// Bit mask of CSSON field.
	RCC_CR_CSSON_Msk = 0x80000
	// Bit CSSON.
	RCC_CR_CSSON = 0x80000
	// Position of HSERDY field.
	RCC_CR_HSERDY_Pos = 0x11
	// Bit mask of HSERDY field.
	RCC_CR_HSERDY_Msk = 0x20000
	// Bit HSERDY.
	RCC_CR_HSERDY = 0x20000
	// Position of HSEON field.
	RCC_CR_HSEON_Pos = 0x10
	// Bit mask of HSEON field.
	RCC_CR_HSEON_Msk = 0x10000
	// Bit HSEON.
	RCC_CR_HSEON = 0x10000
	// Position of HSIKERDY field.
	RCC_CR_HSIKERDY_Pos = 0xc
	// Bit mask of HSIKERDY field.
	RCC_CR_HSIKERDY_Msk = 0x1000
	// Bit HSIKERDY.
	RCC_CR_HSIKERDY = 0x1000
	// Position of HSIASFS field.
	RCC_CR_HSIASFS_Pos = 0xb
	// Bit mask of HSIASFS field.
	RCC_CR_HSIASFS_Msk = 0x800
	// Bit HSIASFS.
	RCC_CR_HSIASFS = 0x800
	// Position of HSIRDY field.
	RCC_CR_HSIRDY_Pos = 0xa
	// Bit mask of HSIRDY field.
	RCC_CR_HSIRDY_Msk = 0x400
	// Bit HSIRDY.
	RCC_CR_HSIRDY = 0x400
	// Position of HSIKERON field.
	RCC_CR_HSIKERON_Pos = 0x9
	// Bit mask of HSIKERON field.
	RCC_CR_HSIKERON_Msk = 0x200
	// Bit HSIKERON.
	RCC_CR_HSIKERON = 0x200
	// Position of HSION field.
	RCC_CR_HSION_Pos = 0x8
	// Bit mask of HSION field.
	RCC_CR_HSION_Msk = 0x100
	// Bit HSION.
	RCC_CR_HSION = 0x100
	// Position of MSIRANGE field.
	RCC_CR_MSIRANGE_Pos = 0x4
	// Bit mask of MSIRANGE field.
	RCC_CR_MSIRANGE_Msk = 0xf0
	// Position of MSIRGSEL field.
	RCC_CR_MSIRGSEL_Pos = 0x3
	// Bit mask of MSIRGSEL field.
	RCC_CR_MSIRGSEL_Msk = 0x8
	// Bit MSIRGSEL.
	RCC_CR_MSIRGSEL = 0x8
	// Position of MSIPLLEN field.
	RCC_CR_MSIPLLEN_Pos = 0x2
	// Bit mask of MSIPLLEN field.
	RCC_CR_MSIPLLEN_Msk = 0x4
	// Bit MSIPLLEN.
	RCC_CR_MSIPLLEN = 0x4
	// Position of MSIRDY field.
	RCC_CR_MSIRDY_Pos = 0x1
	// Bit mask of MSIRDY field.
	RCC_CR_MSIRDY_Msk = 0x2
	// Bit MSIRDY.
	RCC_CR_MSIRDY = 0x2
	// Position of MSION field.
	RCC_CR_MSION_Pos = 0x0
	// Bit mask of MSION field.
	RCC_CR_MSION_Msk = 0x1
	// Bit MSION.
	RCC_CR_MSION = 0x1

	// ICSCR: Internal clock sources calibration register
	// Position of HSITRIM field.
	RCC_ICSCR_HSITRIM_Pos = 0x18
	// Bit mask of HSITRIM field.
	RCC_ICSCR_HSITRIM_Msk = 0x7f000000
	// Position of HSICAL field.
	RCC_ICSCR_HSICAL_Pos = 0x10
	// Bit mask of HSICAL field.
	RCC_ICSCR_HSICAL_Msk = 0xff0000
	// Position of MSITRIM field.
	RCC_ICSCR_MSITRIM_Pos = 0x8
	// Bit mask of MSITRIM field.
	RCC_ICSCR_MSITRIM_Msk = 0xff00
	// Position of MSICAL field.
	RCC_ICSCR_MSICAL_Pos = 0x0
	// Bit mask of MSICAL field.
	RCC_ICSCR_MSICAL_Msk = 0xff

	// CFGR: Clock configuration register
	// Position of MCOPRE field.
	RCC_CFGR_MCOPRE_Pos = 0x1c
	// Bit mask of MCOPRE field.
	RCC_CFGR_MCOPRE_Msk = 0x70000000
	// Position of MCOSEL field.
	RCC_CFGR_MCOSEL_Pos = 0x18
	// Bit mask of MCOSEL field.
	RCC_CFGR_MCOSEL_Msk = 0xf000000
	// Position of PPRE2F field.
	RCC_CFGR_PPRE2F_Pos = 0x12
	// Bit mask of PPRE2F field.
	RCC_CFGR_PPRE2F_Msk = 0x40000
	// Bit PPRE2F.
	RCC_CFGR_PPRE2F = 0x40000
	// Position of PPRE1F field.
	RCC_CFGR_PPRE1F_Pos = 0x11
	// Bit mask of PPRE1F field.
	RCC_CFGR_PPRE1F_Msk = 0x20000
	// Bit PPRE1F.
	RCC_CFGR_PPRE1F = 0x20000
	// Position of HPREF field.
	RCC_CFGR_HPREF_Pos = 0x10
	// Bit mask of HPREF field.
	RCC_CFGR_HPREF_Msk = 0x10000
	// Bit HPREF.
	RCC_CFGR_HPREF = 0x10000
	// Position of STOPWUCK field.
	RCC_CFGR_STOPWUCK_Pos = 0xf
	// Bit mask of STOPWUCK field.
	RCC_CFGR_STOPWUCK_Msk = 0x8000
	// Bit STOPWUCK.
	RCC_CFGR_STOPWUCK = 0x8000
	// Position of PPRE2 field.
	RCC_CFGR_PPRE2_Pos = 0xb
	// Bit mask of PPRE2 field.
	RCC_CFGR_PPRE2_Msk = 0x3800
	// Position of PPRE1 field.
	RCC_CFGR_PPRE1_Pos = 0x8
	// Bit mask of PPRE1 field.
	RCC_CFGR_PPRE1_Msk = 0x700
	// Position of HPRE field.
	RCC_CFGR_HPRE_Pos = 0x4
	// Bit mask of HPRE field.
	RCC_CFGR_HPRE_Msk = 0xf0
	// Position of SWS field.
	RCC_CFGR_SWS_Pos = 0x2
	// Bit mask of SWS field.
	RCC_CFGR_SWS_Msk = 0xc
	// Position of SW field.
	RCC_CFGR_SW_Pos = 0x0
	// Bit mask of SW field.
	RCC_CFGR_SW_Msk = 0x3

	// PLLCFGR: PLL configuration register
	// Position of PLLR field.
	RCC_PLLCFGR_PLLR_Pos = 0x1d
	// Bit mask of PLLR field.
	RCC_PLLCFGR_PLLR_Msk = 0xe0000000
	// Position of PLLREN field.
	RCC_PLLCFGR_PLLREN_Pos = 0x1c
	// Bit mask of PLLREN field.
	RCC_PLLCFGR_PLLREN_Msk = 0x10000000
	// Bit PLLREN.
	RCC_PLLCFGR_PLLREN = 0x10000000
	// Position of PLLQ field.
	RCC_PLLCFGR_PLLQ_Pos = 0x19
	// Bit mask of PLLQ field.
	RCC_PLLCFGR_PLLQ_Msk = 0xe000000
	// Position of PLLQEN field.
	RCC_PLLCFGR_PLLQEN_Pos = 0x18
	// Bit mask of PLLQEN field.
	RCC_PLLCFGR_PLLQEN_Msk = 0x1000000
	// Bit PLLQEN.
	RCC_PLLCFGR_PLLQEN = 0x1000000
	// Position of PLLP field.
	RCC_PLLCFGR_PLLP_Pos = 0x11
	// Bit mask of PLLP field.
	RCC_PLLCFGR_PLLP_Msk = 0x3e0000
	// Position of PLLPEN field.
	RCC_PLLCFGR_PLLPEN_Pos = 0x10
	// Bit mask of PLLPEN field.
	RCC_PLLCFGR_PLLPEN_Msk = 0x10000
	// Bit PLLPEN.
	RCC_PLLCFGR_PLLPEN = 0x10000
	// Position of PLLN field.
	RCC_PLLCFGR_PLLN_Pos = 0x8
	// Bit mask of PLLN field.
	RCC_PLLCFGR_PLLN_Msk = 0x7f00
	// Position of PLLM field.
	RCC_PLLCFGR_PLLM_Pos = 0x4
	// Bit mask of PLLM field.
	RCC_PLLCFGR_PLLM_Msk = 0x70
	// Position of PLLSRC field.
	RCC_PLLCFGR_PLLSRC_Pos = 0x0
	// Bit mask of PLLSRC field.
	RCC_PLLCFGR_PLLSRC_Msk = 0x3

	// CIER: Clock interrupt enable register
	// Position of LSECSSIE field.
	RCC_CIER_LSECSSIE_Pos = 0x9
	// Bit mask of LSECSSIE field.
	RCC_CIER_LSECSSIE_Msk = 0x200
	// Bit LSECSSIE.
	RCC_CIER_LSECSSIE = 0x200
	// Position of PLLRDYIE field.
	RCC_CIER_PLLRDYIE_Pos = 0x5
	// Bit mask of PLLRDYIE field.
	RCC_CIER_PLLRDYIE_Msk = 0x20
	// Bit PLLRDYIE.
	RCC_CIER_PLLRDYIE = 0x20
	// Position of HSERDYIE field.
	RCC_CIER_HSERDYIE_Pos = 0x4
	// Bit mask of HSERDYIE field.
	RCC_CIER_HSERDYIE_Msk = 0x10
	// Bit HSERDYIE.
	RCC_CIER_HSERDYIE = 0x10
	// Position of HSIRDYIE field.
	RCC_CIER_HSIRDYIE_Pos = 0x3
	// Bit mask of HSIRDYIE field.
	RCC_CIER_HSIRDYIE_Msk = 0x8
	// Bit HSIRDYIE.
	RCC_CIER_HSIRDYIE = 0x8
	// Position of MSIRDYIE field.
	RCC_CIER_MSIRDYIE_Pos = 0x2
	// Bit mask of MSIRDYIE field.
	RCC_CIER_MSIRDYIE_Msk = 0x4
	// Bit MSIRDYIE.
	RCC_CIER_MSIRDYIE = 0x4
	// Position of LSERDYIE field.
	RCC_CIER_LSERDYIE_Pos = 0x1
	// Bit mask of LSERDYIE field.
	RCC_CIER_LSERDYIE_Msk = 0x2
	// Bit LSERDYIE.
	RCC_CIER_LSERDYIE = 0x2
	// Position of LSIRDYIE field.
	RCC_CIER_LSIRDYIE_Pos = 0x0
	// Bit mask of LSIRDYIE field.
	RCC_CIER_LSIRDYIE_Msk = 0x1
	// Bit LSIRDYIE.
	RCC_CIER_LSIRDYIE = 0x1

	// CIFR: Clock interrupt flag register
	// Position of LSECSSF field.
	RCC_CIFR_LSECSSF_Pos = 0x9
	// Bit mask of LSECSSF field.
	RCC_CIFR_LSECSSF_Msk = 0x200
	// Bit LSECSSF.
	RCC_CIFR_LSECSSF = 0x200
	// Position of CSSF field.
	RCC_CIFR_CSSF_Pos = 0x8
	// Bit mask of CSSF field.
	RCC_CIFR_CSSF_Msk = 0x100
	// Bit CSSF.
	RCC_CIFR_CSSF = 0x100
	// Position of PLLRDYF field.
	RCC_CIFR_PLLRDYF_Pos = 0x5
	// Bit mask of PLLRDYF field.
	RCC_CIFR_PLLRDYF_Msk = 0x20
	// Bit PLLRDYF.
	RCC_CIFR_PLLRDYF = 0x20
	// Position of HSERDYF field.
	RCC_CIFR_HSERDYF_Pos = 0x4
	// Bit mask of HSERDYF field.
	RCC_CIFR_HSERDYF_Msk = 0x10
	// Bit HSERDYF.
	RCC_CIFR_HSERDYF = 0x10
	// Position of HSIRDYF field.
	RCC_CIFR_HSIRDYF_Pos = 0x3
	// Bit mask of HSIRDYF field.
	RCC_CIFR_HSIRDYF_Msk = 0x8
	// Bit HSIRDYF.
	RCC_CIFR_HSIRDYF = 0x8
	// Position of MSIRDYF field.
	RCC_CIFR_MSIRDYF_Pos = 0x2
	// Bit mask of MSIRDYF field.
	RCC_CIFR_MSIRDYF_Msk = 0x4
	// Bit MSIRDYF.
	RCC_CIFR_MSIRDYF = 0x4
	// Position of LSERDYF field.
	RCC_CIFR_LSERDYF_Pos = 0x1
	// Bit mask of LSERDYF field.
	RCC_CIFR_LSERDYF_Msk = 0x2
	// Bit LSERDYF.
	RCC_CIFR_LSERDYF = 0x2
	// Position of LSIRDYF field.
	RCC_CIFR_LSIRDYF_Pos = 0x0
	// Bit mask of LSIRDYF field.
	RCC_CIFR_LSIRDYF_Msk = 0x1
	// Bit LSIRDYF.
	RCC_CIFR_LSIRDYF = 0x1

	// CICR: Clock interrupt clear register
	// Position of LSECSSC field.
	RCC_CICR_LSECSSC_Pos = 0x9
	// Bit mask of LSECSSC field.
	RCC_CICR_LSECSSC_Msk = 0x200
	// Bit LSECSSC.
	RCC_CICR_LSECSSC = 0x200
	// Position of CSSC field.
	RCC_CICR_CSSC_Pos = 0x8
	// Bit mask of CSSC field.
	RCC_CICR_CSSC_Msk = 0x100
	// Bit CSSC.
	RCC_CICR_CSSC = 0x100
	// Position of PLLRDYC field.
	RCC_CICR_PLLRDYC_Pos = 0x5
	// Bit mask of PLLRDYC field.
	RCC_CICR_PLLRDYC_Msk = 0x20
	// Bit PLLRDYC.
	RCC_CICR_PLLRDYC = 0x20
	// Position of HSERDYC field.
	RCC_CICR_HSERDYC_Pos = 0x4
	// Bit mask of HSERDYC field.
	RCC_CICR_HSERDYC_Msk = 0x10
	// Bit HSERDYC.
	RCC_CICR_HSERDYC = 0x10
	// Position of HSIRDYC field.
	RCC_CICR_HSIRDYC_Pos = 0x3
	// Bit mask of HSIRDYC field.
	RCC_CICR_HSIRDYC_Msk = 0x8
	// Bit HSIRDYC.
	RCC_CICR_HSIRDYC = 0x8
	// Position of MSIRDYC field.
	RCC_CICR_MSIRDYC_Pos = 0x2
	// Bit mask of MSIRDYC field.
	RCC_CICR_MSIRDYC_Msk = 0x4
	// Bit MSIRDYC.
	RCC_CICR_MSIRDYC = 0x4
	// Position of LSERDYC field.
	RCC_CICR_LSERDYC_Pos = 0x1
	// Bit mask of LSERDYC field.
	RCC_CICR_LSERDYC_Msk = 0x2
	// Bit LSERDYC.
	RCC_CICR_LSERDYC = 0x2
	// Position of LSIRDYC field.
	RCC_CICR_LSIRDYC_Pos = 0x0
	// Bit mask of LSIRDYC field.
	RCC_CICR_LSIRDYC_Msk = 0x1
	// Bit LSIRDYC.
	RCC_CICR_LSIRDYC = 0x1

	// AHB1RSTR: AHB1 peripheral reset register
	// Position of CRCRST field.
	RCC_AHB1RSTR_CRCRST_Pos = 0xc
	// Bit mask of CRCRST field.
	RCC_AHB1RSTR_CRCRST_Msk = 0x1000
	// Bit CRCRST.
	RCC_AHB1RSTR_CRCRST = 0x1000
	// Position of DMAMUX1RST field.
	RCC_AHB1RSTR_DMAMUX1RST_Pos = 0x2
	// Bit mask of DMAMUX1RST field.
	RCC_AHB1RSTR_DMAMUX1RST_Msk = 0x4
	// Bit DMAMUX1RST.
	RCC_AHB1RSTR_DMAMUX1RST = 0x4
	// Position of DMA2RST field.
	RCC_AHB1RSTR_DMA2RST_Pos = 0x1
	// Bit mask of DMA2RST field.
	RCC_AHB1RSTR_DMA2RST_Msk = 0x2
	// Bit DMA2RST.
	RCC_AHB1RSTR_DMA2RST = 0x2
	// Position of DMA1RST field.
	RCC_AHB1RSTR_DMA1RST_Pos = 0x0
	// Bit mask of DMA1RST field.
	RCC_AHB1RSTR_DMA1RST_Msk = 0x1
	// Bit DMA1RST.
	RCC_AHB1RSTR_DMA1RST = 0x1

	// AHB2RSTR: AHB2 peripheral reset register
	// Position of GPIOHRST field.
	RCC_AHB2RSTR_GPIOHRST_Pos = 0x7
	// Bit mask of GPIOHRST field.
	RCC_AHB2RSTR_GPIOHRST_Msk = 0x80
	// Bit GPIOHRST.
	RCC_AHB2RSTR_GPIOHRST = 0x80
	// Position of GPIOCRST field.
	RCC_AHB2RSTR_GPIOCRST_Pos = 0x2
	// Bit mask of GPIOCRST field.
	RCC_AHB2RSTR_GPIOCRST_Msk = 0x4
	// Bit GPIOCRST.
	RCC_AHB2RSTR_GPIOCRST = 0x4
	// Position of GPIOBRST field.
	RCC_AHB2RSTR_GPIOBRST_Pos = 0x1
	// Bit mask of GPIOBRST field.
	RCC_AHB2RSTR_GPIOBRST_Msk = 0x2
	// Bit GPIOBRST.
	RCC_AHB2RSTR_GPIOBRST = 0x2
	// Position of GPIOARST field.
	RCC_AHB2RSTR_GPIOARST_Pos = 0x0
	// Bit mask of GPIOARST field.
	RCC_AHB2RSTR_GPIOARST_Msk = 0x1
	// Bit GPIOARST.
	RCC_AHB2RSTR_GPIOARST = 0x1

	// AHB3RSTR: AHB3 peripheral reset register
	// Position of FLASHRST field.
	RCC_AHB3RSTR_FLASHRST_Pos = 0x19
	// Bit mask of FLASHRST field.
	RCC_AHB3RSTR_FLASHRST_Msk = 0x2000000
	// Bit FLASHRST.
	RCC_AHB3RSTR_FLASHRST = 0x2000000
	// Position of IPCCRST field.
	RCC_AHB3RSTR_IPCCRST_Pos = 0x14
	// Bit mask of IPCCRST field.
	RCC_AHB3RSTR_IPCCRST_Msk = 0x100000
	// Bit IPCCRST.
	RCC_AHB3RSTR_IPCCRST = 0x100000
	// Position of HSEMRST field.
	RCC_AHB3RSTR_HSEMRST_Pos = 0x13
	// Bit mask of HSEMRST field.
	RCC_AHB3RSTR_HSEMRST_Msk = 0x80000
	// Bit HSEMRST.
	RCC_AHB3RSTR_HSEMRST = 0x80000
	// Position of RNGRST field.
	RCC_AHB3RSTR_RNGRST_Pos = 0x12
	// Bit mask of RNGRST field.
	RCC_AHB3RSTR_RNGRST_Msk = 0x40000
	// Bit RNGRST.
	RCC_AHB3RSTR_RNGRST = 0x40000
	// Position of AESRST field.
	RCC_AHB3RSTR_AESRST_Pos = 0x11
	// Bit mask of AESRST field.
	RCC_AHB3RSTR_AESRST_Msk = 0x20000
	// Bit AESRST.
	RCC_AHB3RSTR_AESRST = 0x20000
	// Position of PKARST field.
	RCC_AHB3RSTR_PKARST_Pos = 0x10
	// Bit mask of PKARST field.
	RCC_AHB3RSTR_PKARST_Msk = 0x10000
	// Bit PKARST.
	RCC_AHB3RSTR_PKARST = 0x10000

	// APB1RSTR1: APB1 peripheral reset register 1
	// Position of LPTIM1RST field.
	RCC_APB1RSTR1_LPTIM1RST_Pos = 0x1f
	// Bit mask of LPTIM1RST field.
	RCC_APB1RSTR1_LPTIM1RST_Msk = 0x80000000
	// Bit LPTIM1RST.
	RCC_APB1RSTR1_LPTIM1RST = 0x80000000
	// Position of DACRST field.
	RCC_APB1RSTR1_DACRST_Pos = 0x1d
	// Bit mask of DACRST field.
	RCC_APB1RSTR1_DACRST_Msk = 0x20000000
	// Bit DACRST.
	RCC_APB1RSTR1_DACRST = 0x20000000
	// Position of I2C3RST field.
	RCC_APB1RSTR1_I2C3RST_Pos = 0x17
	// Bit mask of I2C3RST field.
	RCC_APB1RSTR1_I2C3RST_Msk = 0x800000
	// Bit I2C3RST.
	RCC_APB1RSTR1_I2C3RST = 0x800000
	// Position of I2C2RST field.
	RCC_APB1RSTR1_I2C2RST_Pos = 0x16
	// Bit mask of I2C2RST field.
	RCC_APB1RSTR1_I2C2RST_Msk = 0x400000
	// Bit I2C2RST.
	RCC_APB1RSTR1_I2C2RST = 0x400000
	// Position of I2C1RST field.
	RCC_APB1RSTR1_I2C1RST_Pos = 0x15
	// Bit mask of I2C1RST field.
	RCC_APB1RSTR1_I2C1RST_Msk = 0x200000
	// Bit I2C1RST.
	RCC_APB1RSTR1_I2C1RST = 0x200000
	// Position of USART2RST field.
	RCC_APB1RSTR1_USART2RST_Pos = 0x11
	// Bit mask of USART2RST field.
	RCC_APB1RSTR1_USART2RST_Msk = 0x20000
	// Bit USART2RST.
	RCC_APB1RSTR1_USART2RST = 0x20000
	// Position of SPI2S2RST field.
	RCC_APB1RSTR1_SPI2S2RST_Pos = 0xe
	// Bit mask of SPI2S2RST field.
	RCC_APB1RSTR1_SPI2S2RST_Msk = 0x4000
	// Bit SPI2S2RST.
	RCC_APB1RSTR1_SPI2S2RST = 0x4000
	// Position of TIM2RST field.
	RCC_APB1RSTR1_TIM2RST_Pos = 0x0
	// Bit mask of TIM2RST field.
	RCC_APB1RSTR1_TIM2RST_Msk = 0x1
	// Bit TIM2RST.
	RCC_APB1RSTR1_TIM2RST = 0x1

	// APB1RSTR2: APB1 peripheral reset register 2
	// Position of LPTIM3RST field.
	RCC_APB1RSTR2_LPTIM3RST_Pos = 0x6
	// Bit mask of LPTIM3RST field.
	RCC_APB1RSTR2_LPTIM3RST_Msk = 0x40
	// Bit LPTIM3RST.
	RCC_APB1RSTR2_LPTIM3RST = 0x40
	// Position of LPTIM2RST field.
	RCC_APB1RSTR2_LPTIM2RST_Pos = 0x5
	// Bit mask of LPTIM2RST field.
	RCC_APB1RSTR2_LPTIM2RST_Msk = 0x20
	// Bit LPTIM2RST.
	RCC_APB1RSTR2_LPTIM2RST = 0x20
	// Position of LPUART1RST field.
	RCC_APB1RSTR2_LPUART1RST_Pos = 0x0
	// Bit mask of LPUART1RST field.
	RCC_APB1RSTR2_LPUART1RST_Msk = 0x1
	// Bit LPUART1RST.
	RCC_APB1RSTR2_LPUART1RST = 0x1

	// APB2RSTR: APB2 peripheral reset register
	// Position of TIM17RST field.
	RCC_APB2RSTR_TIM17RST_Pos = 0x12
	// Bit mask of TIM17RST field.
	RCC_APB2RSTR_TIM17RST_Msk = 0x40000
	// Bit TIM17RST.
	RCC_APB2RSTR_TIM17RST = 0x40000
	// Position of TIM16RST field.
	RCC_APB2RSTR_TIM16RST_Pos = 0x11
	// Bit mask of TIM16RST field.
	RCC_APB2RSTR_TIM16RST_Msk = 0x20000
	// Bit TIM16RST.
	RCC_APB2RSTR_TIM16RST = 0x20000
	// Position of USART1RST field.
	RCC_APB2RSTR_USART1RST_Pos = 0xe
	// Bit mask of USART1RST field.
	RCC_APB2RSTR_USART1RST_Msk = 0x4000
	// Bit USART1RST.
	RCC_APB2RSTR_USART1RST = 0x4000
	// Position of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Pos = 0xc
	// Bit mask of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Msk = 0x1000
	// Bit SPI1RST.
	RCC_APB2RSTR_SPI1RST = 0x1000
	// Position of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Pos = 0xb
	// Bit mask of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Msk = 0x800
	// Bit TIM1RST.
	RCC_APB2RSTR_TIM1RST = 0x800
	// Position of ADCRST field.
	RCC_APB2RSTR_ADCRST_Pos = 0x9
	// Bit mask of ADCRST field.
	RCC_APB2RSTR_ADCRST_Msk = 0x200
	// Bit ADCRST.
	RCC_APB2RSTR_ADCRST = 0x200

	// APB3RSTR: APB3 peripheral reset register
	// Position of SUBGHZSPIRST field.
	RCC_APB3RSTR_SUBGHZSPIRST_Pos = 0x0
	// Bit mask of SUBGHZSPIRST field.
	RCC_APB3RSTR_SUBGHZSPIRST_Msk = 0x1
	// Bit SUBGHZSPIRST.
	RCC_APB3RSTR_SUBGHZSPIRST = 0x1

	// AHB1ENR: AHB1 peripheral clock enable register
	// Position of CRCEN field.
	RCC_AHB1ENR_CRCEN_Pos = 0xc
	// Bit mask of CRCEN field.
	RCC_AHB1ENR_CRCEN_Msk = 0x1000
	// Bit CRCEN.
	RCC_AHB1ENR_CRCEN = 0x1000
	// Position of DMAMUX1EN field.
	RCC_AHB1ENR_DMAMUX1EN_Pos = 0x2
	// Bit mask of DMAMUX1EN field.
	RCC_AHB1ENR_DMAMUX1EN_Msk = 0x4
	// Bit DMAMUX1EN.
	RCC_AHB1ENR_DMAMUX1EN = 0x4
	// Position of DMA2EN field.
	RCC_AHB1ENR_DMA2EN_Pos = 0x1
	// Bit mask of DMA2EN field.
	RCC_AHB1ENR_DMA2EN_Msk = 0x2
	// Bit DMA2EN.
	RCC_AHB1ENR_DMA2EN = 0x2
	// Position of DMA1EN field.
	RCC_AHB1ENR_DMA1EN_Pos = 0x0
	// Bit mask of DMA1EN field.
	RCC_AHB1ENR_DMA1EN_Msk = 0x1
	// Bit DMA1EN.
	RCC_AHB1ENR_DMA1EN = 0x1

	// AHB2ENR: AHB2 peripheral clock enable register
	// Position of GPIOHEN field.
	RCC_AHB2ENR_GPIOHEN_Pos = 0x7
	// Bit mask of GPIOHEN field.
	RCC_AHB2ENR_GPIOHEN_Msk = 0x80
	// Bit GPIOHEN.
	RCC_AHB2ENR_GPIOHEN = 0x80
	// Position of GPIOCEN field.
	RCC_AHB2ENR_GPIOCEN_Pos = 0x2
	// Bit mask of GPIOCEN field.
	RCC_AHB2ENR_GPIOCEN_Msk = 0x4
	// Bit GPIOCEN.
	RCC_AHB2ENR_GPIOCEN = 0x4
	// Position of GPIOBEN field.
	RCC_AHB2ENR_GPIOBEN_Pos = 0x1
	// Bit mask of GPIOBEN field.
	RCC_AHB2ENR_GPIOBEN_Msk = 0x2
	// Bit GPIOBEN.
	RCC_AHB2ENR_GPIOBEN = 0x2
	// Position of GPIOAEN field.
	RCC_AHB2ENR_GPIOAEN_Pos = 0x0
	// Bit mask of GPIOAEN field.
	RCC_AHB2ENR_GPIOAEN_Msk = 0x1
	// Bit GPIOAEN.
	RCC_AHB2ENR_GPIOAEN = 0x1

	// AHB3ENR: AHB3 peripheral clock enable register
	// Position of FLASHEN field.
	RCC_AHB3ENR_FLASHEN_Pos = 0x19
	// Bit mask of FLASHEN field.
	RCC_AHB3ENR_FLASHEN_Msk = 0x2000000
	// Bit FLASHEN.
	RCC_AHB3ENR_FLASHEN = 0x2000000
	// Position of IPCCEN field.
	RCC_AHB3ENR_IPCCEN_Pos = 0x14
	// Bit mask of IPCCEN field.
	RCC_AHB3ENR_IPCCEN_Msk = 0x100000
	// Bit IPCCEN.
	RCC_AHB3ENR_IPCCEN = 0x100000
	// Position of HSEMEN field.
	RCC_AHB3ENR_HSEMEN_Pos = 0x13
	// Bit mask of HSEMEN field.
	RCC_AHB3ENR_HSEMEN_Msk = 0x80000
	// Bit HSEMEN.
	RCC_AHB3ENR_HSEMEN = 0x80000
	// Position of RNGEN field.
	RCC_AHB3ENR_RNGEN_Pos = 0x12
	// Bit mask of RNGEN field.
	RCC_AHB3ENR_RNGEN_Msk = 0x40000
	// Bit RNGEN.
	RCC_AHB3ENR_RNGEN = 0x40000
	// Position of AESEN field.
	RCC_AHB3ENR_AESEN_Pos = 0x11
	// Bit mask of AESEN field.
	RCC_AHB3ENR_AESEN_Msk = 0x20000
	// Bit AESEN.
	RCC_AHB3ENR_AESEN = 0x20000
	// Position of PKAEN field.
	RCC_AHB3ENR_PKAEN_Pos = 0x10
	// Bit mask of PKAEN field.
	RCC_AHB3ENR_PKAEN_Msk = 0x10000
	// Bit PKAEN.
	RCC_AHB3ENR_PKAEN = 0x10000

	// APB1ENR1: APB1 peripheral clock enable register 1
	// Position of LPTIM1EN field.
	RCC_APB1ENR1_LPTIM1EN_Pos = 0x1f
	// Bit mask of LPTIM1EN field.
	RCC_APB1ENR1_LPTIM1EN_Msk = 0x80000000
	// Bit LPTIM1EN.
	RCC_APB1ENR1_LPTIM1EN = 0x80000000
	// Position of DAC1EN field.
	RCC_APB1ENR1_DAC1EN_Pos = 0x1d
	// Bit mask of DAC1EN field.
	RCC_APB1ENR1_DAC1EN_Msk = 0x20000000
	// Bit DAC1EN.
	RCC_APB1ENR1_DAC1EN = 0x20000000
	// Position of I2C3EN field.
	RCC_APB1ENR1_I2C3EN_Pos = 0x17
	// Bit mask of I2C3EN field.
	RCC_APB1ENR1_I2C3EN_Msk = 0x800000
	// Bit I2C3EN.
	RCC_APB1ENR1_I2C3EN = 0x800000
	// Position of I2C2EN field.
	RCC_APB1ENR1_I2C2EN_Pos = 0x16
	// Bit mask of I2C2EN field.
	RCC_APB1ENR1_I2C2EN_Msk = 0x400000
	// Bit I2C2EN.
	RCC_APB1ENR1_I2C2EN = 0x400000
	// Position of I2C1EN field.
	RCC_APB1ENR1_I2C1EN_Pos = 0x15
	// Bit mask of I2C1EN field.
	RCC_APB1ENR1_I2C1EN_Msk = 0x200000
	// Bit I2C1EN.
	RCC_APB1ENR1_I2C1EN = 0x200000
	// Position of USART2EN field.
	RCC_APB1ENR1_USART2EN_Pos = 0x11
	// Bit mask of USART2EN field.
	RCC_APB1ENR1_USART2EN_Msk = 0x20000
	// Bit USART2EN.
	RCC_APB1ENR1_USART2EN = 0x20000
	// Position of SPI2S2EN field.
	RCC_APB1ENR1_SPI2S2EN_Pos = 0xe
	// Bit mask of SPI2S2EN field.
	RCC_APB1ENR1_SPI2S2EN_Msk = 0x4000
	// Bit SPI2S2EN.
	RCC_APB1ENR1_SPI2S2EN = 0x4000
	// Position of WWDGEN field.
	RCC_APB1ENR1_WWDGEN_Pos = 0xb
	// Bit mask of WWDGEN field.
	RCC_APB1ENR1_WWDGEN_Msk = 0x800
	// Bit WWDGEN.
	RCC_APB1ENR1_WWDGEN = 0x800
	// Position of RTCAPBEN field.
	RCC_APB1ENR1_RTCAPBEN_Pos = 0xa
	// Bit mask of RTCAPBEN field.
	RCC_APB1ENR1_RTCAPBEN_Msk = 0x400
	// Bit RTCAPBEN.
	RCC_APB1ENR1_RTCAPBEN = 0x400
	// Position of TIM2EN field.
	RCC_APB1ENR1_TIM2EN_Pos = 0x0
	// Bit mask of TIM2EN field.
	RCC_APB1ENR1_TIM2EN_Msk = 0x1
	// Bit TIM2EN.
	RCC_APB1ENR1_TIM2EN = 0x1

	// APB1ENR2: APB1 peripheral clock enable register 2
	// Position of LPTIM3EN field.
	RCC_APB1ENR2_LPTIM3EN_Pos = 0x6
	// Bit mask of LPTIM3EN field.
	RCC_APB1ENR2_LPTIM3EN_Msk = 0x40
	// Bit LPTIM3EN.
	RCC_APB1ENR2_LPTIM3EN = 0x40
	// Position of LPTIM2EN field.
	RCC_APB1ENR2_LPTIM2EN_Pos = 0x5
	// Bit mask of LPTIM2EN field.
	RCC_APB1ENR2_LPTIM2EN_Msk = 0x20
	// Bit LPTIM2EN.
	RCC_APB1ENR2_LPTIM2EN = 0x20
	// Position of LPUART1EN field.
	RCC_APB1ENR2_LPUART1EN_Pos = 0x0
	// Bit mask of LPUART1EN field.
	RCC_APB1ENR2_LPUART1EN_Msk = 0x1
	// Bit LPUART1EN.
	RCC_APB1ENR2_LPUART1EN = 0x1

	// APB2ENR: APB2 peripheral clock enable register
	// Position of TIM17EN field.
	RCC_APB2ENR_TIM17EN_Pos = 0x12
	// Bit mask of TIM17EN field.
	RCC_APB2ENR_TIM17EN_Msk = 0x40000
	// Bit TIM17EN.
	RCC_APB2ENR_TIM17EN = 0x40000
	// Position of TIM16EN field.
	RCC_APB2ENR_TIM16EN_Pos = 0x11
	// Bit mask of TIM16EN field.
	RCC_APB2ENR_TIM16EN_Msk = 0x20000
	// Bit TIM16EN.
	RCC_APB2ENR_TIM16EN = 0x20000
	// Position of USART1EN field.
	RCC_APB2ENR_USART1EN_Pos = 0xe
	// Bit mask of USART1EN field.
	RCC_APB2ENR_USART1EN_Msk = 0x4000
	// Bit USART1EN.
	RCC_APB2ENR_USART1EN = 0x4000
	// Position of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Pos = 0xc
	// Bit mask of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Msk = 0x1000
	// Bit SPI1EN.
	RCC_APB2ENR_SPI1EN = 0x1000
	// Position of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Pos = 0xb
	// Bit mask of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Msk = 0x800
	// Bit TIM1EN.
	RCC_APB2ENR_TIM1EN = 0x800
	// Position of ADCEN field.
	RCC_APB2ENR_ADCEN_Pos = 0x9
	// Bit mask of ADCEN field.
	RCC_APB2ENR_ADCEN_Msk = 0x200
	// Bit ADCEN.
	RCC_APB2ENR_ADCEN = 0x200

	// APB3ENR: APB3 peripheral clock enable register
	// Position of SUBGHZSPIEN field.
	RCC_APB3ENR_SUBGHZSPIEN_Pos = 0x0
	// Bit mask of SUBGHZSPIEN field.
	RCC_APB3ENR_SUBGHZSPIEN_Msk = 0x1
	// Bit SUBGHZSPIEN.
	RCC_APB3ENR_SUBGHZSPIEN = 0x1

	// AHB1SMENR: AHB1 peripheral clocks enable in Sleep modes register
	// Position of CRCSMEN field.
	RCC_AHB1SMENR_CRCSMEN_Pos = 0xc
	// Bit mask of CRCSMEN field.
	RCC_AHB1SMENR_CRCSMEN_Msk = 0x1000
	// Bit CRCSMEN.
	RCC_AHB1SMENR_CRCSMEN = 0x1000
	// Position of DMAMUX1SMEN field.
	RCC_AHB1SMENR_DMAMUX1SMEN_Pos = 0x2
	// Bit mask of DMAMUX1SMEN field.
	RCC_AHB1SMENR_DMAMUX1SMEN_Msk = 0x4
	// Bit DMAMUX1SMEN.
	RCC_AHB1SMENR_DMAMUX1SMEN = 0x4
	// Position of DMA2SMEN field.
	RCC_AHB1SMENR_DMA2SMEN_Pos = 0x1
	// Bit mask of DMA2SMEN field.
	RCC_AHB1SMENR_DMA2SMEN_Msk = 0x2
	// Bit DMA2SMEN.
	RCC_AHB1SMENR_DMA2SMEN = 0x2
	// Position of DMA1SMEN field.
	RCC_AHB1SMENR_DMA1SMEN_Pos = 0x0
	// Bit mask of DMA1SMEN field.
	RCC_AHB1SMENR_DMA1SMEN_Msk = 0x1
	// Bit DMA1SMEN.
	RCC_AHB1SMENR_DMA1SMEN = 0x1

	// AHB2SMENR: AHB2 peripheral clocks enable in Sleep modes register
	// Position of GPIOHSMEN field.
	RCC_AHB2SMENR_GPIOHSMEN_Pos = 0x7
	// Bit mask of GPIOHSMEN field.
	RCC_AHB2SMENR_GPIOHSMEN_Msk = 0x80
	// Bit GPIOHSMEN.
	RCC_AHB2SMENR_GPIOHSMEN = 0x80
	// Position of GPIOCSMEN field.
	RCC_AHB2SMENR_GPIOCSMEN_Pos = 0x2
	// Bit mask of GPIOCSMEN field.
	RCC_AHB2SMENR_GPIOCSMEN_Msk = 0x4
	// Bit GPIOCSMEN.
	RCC_AHB2SMENR_GPIOCSMEN = 0x4
	// Position of GPIOBSMEN field.
	RCC_AHB2SMENR_GPIOBSMEN_Pos = 0x1
	// Bit mask of GPIOBSMEN field.
	RCC_AHB2SMENR_GPIOBSMEN_Msk = 0x2
	// Bit GPIOBSMEN.
	RCC_AHB2SMENR_GPIOBSMEN = 0x2
	// Position of GPIOASMEN field.
	RCC_AHB2SMENR_GPIOASMEN_Pos = 0x0
	// Bit mask of GPIOASMEN field.
	RCC_AHB2SMENR_GPIOASMEN_Msk = 0x1
	// Bit GPIOASMEN.
	RCC_AHB2SMENR_GPIOASMEN = 0x1

	// AHB3SMENR: AHB3 peripheral clocks enable in Sleep and Stop modes register
	// Position of FLASHSMEN field.
	RCC_AHB3SMENR_FLASHSMEN_Pos = 0x19
	// Bit mask of FLASHSMEN field.
	RCC_AHB3SMENR_FLASHSMEN_Msk = 0x2000000
	// Bit FLASHSMEN.
	RCC_AHB3SMENR_FLASHSMEN = 0x2000000
	// Position of SRAM2SMEN field.
	RCC_AHB3SMENR_SRAM2SMEN_Pos = 0x18
	// Bit mask of SRAM2SMEN field.
	RCC_AHB3SMENR_SRAM2SMEN_Msk = 0x1000000
	// Bit SRAM2SMEN.
	RCC_AHB3SMENR_SRAM2SMEN = 0x1000000
	// Position of SRAM1SMEN field.
	RCC_AHB3SMENR_SRAM1SMEN_Pos = 0x17
	// Bit mask of SRAM1SMEN field.
	RCC_AHB3SMENR_SRAM1SMEN_Msk = 0x800000
	// Bit SRAM1SMEN.
	RCC_AHB3SMENR_SRAM1SMEN = 0x800000
	// Position of RNGSMEN field.
	RCC_AHB3SMENR_RNGSMEN_Pos = 0x12
	// Bit mask of RNGSMEN field.
	RCC_AHB3SMENR_RNGSMEN_Msk = 0x40000
	// Bit RNGSMEN.
	RCC_AHB3SMENR_RNGSMEN = 0x40000
	// Position of AESSMEN field.
	RCC_AHB3SMENR_AESSMEN_Pos = 0x11
	// Bit mask of AESSMEN field.
	RCC_AHB3SMENR_AESSMEN_Msk = 0x20000
	// Bit AESSMEN.
	RCC_AHB3SMENR_AESSMEN = 0x20000
	// Position of PKASMEN field.
	RCC_AHB3SMENR_PKASMEN_Pos = 0x10
	// Bit mask of PKASMEN field.
	RCC_AHB3SMENR_PKASMEN_Msk = 0x10000
	// Bit PKASMEN.
	RCC_AHB3SMENR_PKASMEN = 0x10000

	// APB1SMENR1: APB1 peripheral clocks enable in Sleep mode register 1
	// Position of LPTIM1SMEN field.
	RCC_APB1SMENR1_LPTIM1SMEN_Pos = 0x1f
	// Bit mask of LPTIM1SMEN field.
	RCC_APB1SMENR1_LPTIM1SMEN_Msk = 0x80000000
	// Bit LPTIM1SMEN.
	RCC_APB1SMENR1_LPTIM1SMEN = 0x80000000
	// Position of DACSMEN field.
	RCC_APB1SMENR1_DACSMEN_Pos = 0x1d
	// Bit mask of DACSMEN field.
	RCC_APB1SMENR1_DACSMEN_Msk = 0x20000000
	// Bit DACSMEN.
	RCC_APB1SMENR1_DACSMEN = 0x20000000
	// Position of I2C3SMEN field.
	RCC_APB1SMENR1_I2C3SMEN_Pos = 0x17
	// Bit mask of I2C3SMEN field.
	RCC_APB1SMENR1_I2C3SMEN_Msk = 0x800000
	// Bit I2C3SMEN.
	RCC_APB1SMENR1_I2C3SMEN = 0x800000
	// Position of I2C2SMEN field.
	RCC_APB1SMENR1_I2C2SMEN_Pos = 0x16
	// Bit mask of I2C2SMEN field.
	RCC_APB1SMENR1_I2C2SMEN_Msk = 0x400000
	// Bit I2C2SMEN.
	RCC_APB1SMENR1_I2C2SMEN = 0x400000
	// Position of I2C1SMEN field.
	RCC_APB1SMENR1_I2C1SMEN_Pos = 0x15
	// Bit mask of I2C1SMEN field.
	RCC_APB1SMENR1_I2C1SMEN_Msk = 0x200000
	// Bit I2C1SMEN.
	RCC_APB1SMENR1_I2C1SMEN = 0x200000
	// Position of USART2SMEN field.
	RCC_APB1SMENR1_USART2SMEN_Pos = 0x11
	// Bit mask of USART2SMEN field.
	RCC_APB1SMENR1_USART2SMEN_Msk = 0x20000
	// Bit USART2SMEN.
	RCC_APB1SMENR1_USART2SMEN = 0x20000
	// Position of SPI2S2SMEN field.
	RCC_APB1SMENR1_SPI2S2SMEN_Pos = 0xe
	// Bit mask of SPI2S2SMEN field.
	RCC_APB1SMENR1_SPI2S2SMEN_Msk = 0x4000
	// Bit SPI2S2SMEN.
	RCC_APB1SMENR1_SPI2S2SMEN = 0x4000
	// Position of WWDGSMEN field.
	RCC_APB1SMENR1_WWDGSMEN_Pos = 0xb
	// Bit mask of WWDGSMEN field.
	RCC_APB1SMENR1_WWDGSMEN_Msk = 0x800
	// Bit WWDGSMEN.
	RCC_APB1SMENR1_WWDGSMEN = 0x800
	// Position of RTCAPBSMEN field.
	RCC_APB1SMENR1_RTCAPBSMEN_Pos = 0xa
	// Bit mask of RTCAPBSMEN field.
	RCC_APB1SMENR1_RTCAPBSMEN_Msk = 0x400
	// Bit RTCAPBSMEN.
	RCC_APB1SMENR1_RTCAPBSMEN = 0x400
	// Position of TIM2SMEN field.
	RCC_APB1SMENR1_TIM2SMEN_Pos = 0x0
	// Bit mask of TIM2SMEN field.
	RCC_APB1SMENR1_TIM2SMEN_Msk = 0x1
	// Bit TIM2SMEN.
	RCC_APB1SMENR1_TIM2SMEN = 0x1

	// APB1SMENR2: APB1 peripheral clocks enable in Sleep mode register 2
	// Position of LPTIM3SMEN field.
	RCC_APB1SMENR2_LPTIM3SMEN_Pos = 0x6
	// Bit mask of LPTIM3SMEN field.
	RCC_APB1SMENR2_LPTIM3SMEN_Msk = 0x40
	// Bit LPTIM3SMEN.
	RCC_APB1SMENR2_LPTIM3SMEN = 0x40
	// Position of LPTIM2SMEN field.
	RCC_APB1SMENR2_LPTIM2SMEN_Pos = 0x5
	// Bit mask of LPTIM2SMEN field.
	RCC_APB1SMENR2_LPTIM2SMEN_Msk = 0x20
	// Bit LPTIM2SMEN.
	RCC_APB1SMENR2_LPTIM2SMEN = 0x20
	// Position of LPUART1SMEN field.
	RCC_APB1SMENR2_LPUART1SMEN_Pos = 0x0
	// Bit mask of LPUART1SMEN field.
	RCC_APB1SMENR2_LPUART1SMEN_Msk = 0x1
	// Bit LPUART1SMEN.
	RCC_APB1SMENR2_LPUART1SMEN = 0x1

	// APB2SMENR: APB2 peripheral clocks enable in Sleep mode register
	// Position of TIM17SMEN field.
	RCC_APB2SMENR_TIM17SMEN_Pos = 0x12
	// Bit mask of TIM17SMEN field.
	RCC_APB2SMENR_TIM17SMEN_Msk = 0x40000
	// Bit TIM17SMEN.
	RCC_APB2SMENR_TIM17SMEN = 0x40000
	// Position of TIM16SMEN field.
	RCC_APB2SMENR_TIM16SMEN_Pos = 0x11
	// Bit mask of TIM16SMEN field.
	RCC_APB2SMENR_TIM16SMEN_Msk = 0x20000
	// Bit TIM16SMEN.
	RCC_APB2SMENR_TIM16SMEN = 0x20000
	// Position of USART1SMEN field.
	RCC_APB2SMENR_USART1SMEN_Pos = 0xe
	// Bit mask of USART1SMEN field.
	RCC_APB2SMENR_USART1SMEN_Msk = 0x4000
	// Bit USART1SMEN.
	RCC_APB2SMENR_USART1SMEN = 0x4000
	// Position of SPI1SMEN field.
	RCC_APB2SMENR_SPI1SMEN_Pos = 0xc
	// Bit mask of SPI1SMEN field.
	RCC_APB2SMENR_SPI1SMEN_Msk = 0x1000
	// Bit SPI1SMEN.
	RCC_APB2SMENR_SPI1SMEN = 0x1000
	// Position of TIM1SMEN field.
	RCC_APB2SMENR_TIM1SMEN_Pos = 0xb
	// Bit mask of TIM1SMEN field.
	RCC_APB2SMENR_TIM1SMEN_Msk = 0x800
	// Bit TIM1SMEN.
	RCC_APB2SMENR_TIM1SMEN = 0x800
	// Position of ADCSMEN field.
	RCC_APB2SMENR_ADCSMEN_Pos = 0x9
	// Bit mask of ADCSMEN field.
	RCC_APB2SMENR_ADCSMEN_Msk = 0x200
	// Bit ADCSMEN.
	RCC_APB2SMENR_ADCSMEN = 0x200

	// APB3SMENR: APB3 peripheral clock enable in Sleep mode register
	// Position of SUBGHZSPISMEN field.
	RCC_APB3SMENR_SUBGHZSPISMEN_Pos = 0x0
	// Bit mask of SUBGHZSPISMEN field.
	RCC_APB3SMENR_SUBGHZSPISMEN_Msk = 0x1
	// Bit SUBGHZSPISMEN.
	RCC_APB3SMENR_SUBGHZSPISMEN = 0x1

	// CCIPR: Peripherals independent clock configuration register
	// Position of RNGSEL field.
	RCC_CCIPR_RNGSEL_Pos = 0x1e
	// Bit mask of RNGSEL field.
	RCC_CCIPR_RNGSEL_Msk = 0xc0000000
	// Position of ADCSEL field.
	RCC_CCIPR_ADCSEL_Pos = 0x1c
	// Bit mask of ADCSEL field.
	RCC_CCIPR_ADCSEL_Msk = 0x30000000
	// Position of LPTIM3SEL field.
	RCC_CCIPR_LPTIM3SEL_Pos = 0x16
	// Bit mask of LPTIM3SEL field.
	RCC_CCIPR_LPTIM3SEL_Msk = 0xc00000
	// Position of LPTIM2SEL field.
	RCC_CCIPR_LPTIM2SEL_Pos = 0x14
	// Bit mask of LPTIM2SEL field.
	RCC_CCIPR_LPTIM2SEL_Msk = 0x300000
	// Position of LPTIM1SEL field.
	RCC_CCIPR_LPTIM1SEL_Pos = 0x12
	// Bit mask of LPTIM1SEL field.
	RCC_CCIPR_LPTIM1SEL_Msk = 0xc0000
	// Position of I2C3SEL field.
	RCC_CCIPR_I2C3SEL_Pos = 0x10
	// Bit mask of I2C3SEL field.
	RCC_CCIPR_I2C3SEL_Msk = 0x30000
	// Position of I2C2SEL field.
	RCC_CCIPR_I2C2SEL_Pos = 0xe
	// Bit mask of I2C2SEL field.
	RCC_CCIPR_I2C2SEL_Msk = 0xc000
	// Position of I2C1SEL field.
	RCC_CCIPR_I2C1SEL_Pos = 0xc
	// Bit mask of I2C1SEL field.
	RCC_CCIPR_I2C1SEL_Msk = 0x3000
	// Position of LPUART1SEL field.
	RCC_CCIPR_LPUART1SEL_Pos = 0xa
	// Bit mask of LPUART1SEL field.
	RCC_CCIPR_LPUART1SEL_Msk = 0xc00
	// Position of SPI2S2SEL field.
	RCC_CCIPR_SPI2S2SEL_Pos = 0x8
	// Bit mask of SPI2S2SEL field.
	RCC_CCIPR_SPI2S2SEL_Msk = 0x300
	// Position of USART2SEL field.
	RCC_CCIPR_USART2SEL_Pos = 0x2
	// Bit mask of USART2SEL field.
	RCC_CCIPR_USART2SEL_Msk = 0xc
	// Position of USART1SEL field.
	RCC_CCIPR_USART1SEL_Pos = 0x0
	// Bit mask of USART1SEL field.
	RCC_CCIPR_USART1SEL_Msk = 0x3

	// BDCR: Backup domain control register
	// Position of LSCOSEL field.
	RCC_BDCR_LSCOSEL_Pos = 0x19
	// Bit mask of LSCOSEL field.
	RCC_BDCR_LSCOSEL_Msk = 0x2000000
	// Bit LSCOSEL.
	RCC_BDCR_LSCOSEL = 0x2000000
	// Position of LSCOEN field.
	RCC_BDCR_LSCOEN_Pos = 0x18
	// Bit mask of LSCOEN field.
	RCC_BDCR_LSCOEN_Msk = 0x1000000
	// Bit LSCOEN.
	RCC_BDCR_LSCOEN = 0x1000000
	// Position of BDRST field.
	RCC_BDCR_BDRST_Pos = 0x10
	// Bit mask of BDRST field.
	RCC_BDCR_BDRST_Msk = 0x10000
	// Bit BDRST.
	RCC_BDCR_BDRST = 0x10000
	// Position of RTCEN field.
	RCC_BDCR_RTCEN_Pos = 0xf
	// Bit mask of RTCEN field.
	RCC_BDCR_RTCEN_Msk = 0x8000
	// Bit RTCEN.
	RCC_BDCR_RTCEN = 0x8000
	// Position of LSESYSRDY field.
	RCC_BDCR_LSESYSRDY_Pos = 0xb
	// Bit mask of LSESYSRDY field.
	RCC_BDCR_LSESYSRDY_Msk = 0x800
	// Bit LSESYSRDY.
	RCC_BDCR_LSESYSRDY = 0x800
	// Position of RTCSEL field.
	RCC_BDCR_RTCSEL_Pos = 0x8
	// Bit mask of RTCSEL field.
	RCC_BDCR_RTCSEL_Msk = 0x300
	// Position of LSESYSEN field.
	RCC_BDCR_LSESYSEN_Pos = 0x7
	// Bit mask of LSESYSEN field.
	RCC_BDCR_LSESYSEN_Msk = 0x80
	// Bit LSESYSEN.
	RCC_BDCR_LSESYSEN = 0x80
	// Position of LSECSSD field.
	RCC_BDCR_LSECSSD_Pos = 0x6
	// Bit mask of LSECSSD field.
	RCC_BDCR_LSECSSD_Msk = 0x40
	// Bit LSECSSD.
	RCC_BDCR_LSECSSD = 0x40
	// Position of LSECSSON field.
	RCC_BDCR_LSECSSON_Pos = 0x5
	// Bit mask of LSECSSON field.
	RCC_BDCR_LSECSSON_Msk = 0x20
	// Bit LSECSSON.
	RCC_BDCR_LSECSSON = 0x20
	// Position of LSEDRV field.
	RCC_BDCR_LSEDRV_Pos = 0x3
	// Bit mask of LSEDRV field.
	RCC_BDCR_LSEDRV_Msk = 0x18
	// Position of LSEBYP field.
	RCC_BDCR_LSEBYP_Pos = 0x2
	// Bit mask of LSEBYP field.
	RCC_BDCR_LSEBYP_Msk = 0x4
	// Bit LSEBYP.
	RCC_BDCR_LSEBYP = 0x4
	// Position of LSERDY field.
	RCC_BDCR_LSERDY_Pos = 0x1
	// Bit mask of LSERDY field.
	RCC_BDCR_LSERDY_Msk = 0x2
	// Bit LSERDY.
	RCC_BDCR_LSERDY = 0x2
	// Position of LSEON field.
	RCC_BDCR_LSEON_Pos = 0x0
	// Bit mask of LSEON field.
	RCC_BDCR_LSEON_Msk = 0x1
	// Bit LSEON.
	RCC_BDCR_LSEON = 0x1

	// CSR: Control/status register
	// Position of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Pos = 0x1f
	// Bit mask of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Msk = 0x80000000
	// Bit LPWRRSTF.
	RCC_CSR_LPWRRSTF = 0x80000000
	// Position of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Pos = 0x1e
	// Bit mask of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Msk = 0x40000000
	// Bit WWDGRSTF.
	RCC_CSR_WWDGRSTF = 0x40000000
	// Position of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Pos = 0x1d
	// Bit mask of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Msk = 0x20000000
	// Bit IWDGRSTF.
	RCC_CSR_IWDGRSTF = 0x20000000
	// Position of SFTRSTF field.
	RCC_CSR_SFTRSTF_Pos = 0x1c
	// Bit mask of SFTRSTF field.
	RCC_CSR_SFTRSTF_Msk = 0x10000000
	// Bit SFTRSTF.
	RCC_CSR_SFTRSTF = 0x10000000
	// Position of BORRSTF field.
	RCC_CSR_BORRSTF_Pos = 0x1b
	// Bit mask of BORRSTF field.
	RCC_CSR_BORRSTF_Msk = 0x8000000
	// Bit BORRSTF.
	RCC_CSR_BORRSTF = 0x8000000
	// Position of PINRSTF field.
	RCC_CSR_PINRSTF_Pos = 0x1a
	// Bit mask of PINRSTF field.
	RCC_CSR_PINRSTF_Msk = 0x4000000
	// Bit PINRSTF.
	RCC_CSR_PINRSTF = 0x4000000
	// Position of OBLRSTF field.
	RCC_CSR_OBLRSTF_Pos = 0x19
	// Bit mask of OBLRSTF field.
	RCC_CSR_OBLRSTF_Msk = 0x2000000
	// Bit OBLRSTF.
	RCC_CSR_OBLRSTF = 0x2000000
	// Position of RFILARSTF field.
	RCC_CSR_RFILARSTF_Pos = 0x18
	// Bit mask of RFILARSTF field.
	RCC_CSR_RFILARSTF_Msk = 0x1000000
	// Bit RFILARSTF.
	RCC_CSR_RFILARSTF = 0x1000000
	// Position of RMVF field.
	RCC_CSR_RMVF_Pos = 0x17
	// Bit mask of RMVF field.
	RCC_CSR_RMVF_Msk = 0x800000
	// Bit RMVF.
	RCC_CSR_RMVF = 0x800000
	// Position of RFRST field.
	RCC_CSR_RFRST_Pos = 0xf
	// Bit mask of RFRST field.
	RCC_CSR_RFRST_Msk = 0x8000
	// Bit RFRST.
	RCC_CSR_RFRST = 0x8000
	// Position of RFRSTF field.
	RCC_CSR_RFRSTF_Pos = 0xe
	// Bit mask of RFRSTF field.
	RCC_CSR_RFRSTF_Msk = 0x4000
	// Bit RFRSTF.
	RCC_CSR_RFRSTF = 0x4000
	// Position of MSISRANGE field.
	RCC_CSR_MSISRANGE_Pos = 0x8
	// Bit mask of MSISRANGE field.
	RCC_CSR_MSISRANGE_Msk = 0xf00
	// Position of LSIPRE field.
	RCC_CSR_LSIPRE_Pos = 0x4
	// Bit mask of LSIPRE field.
	RCC_CSR_LSIPRE_Msk = 0x10
	// Bit LSIPRE.
	RCC_CSR_LSIPRE = 0x10
	// Position of LSIRDY field.
	RCC_CSR_LSIRDY_Pos = 0x1
	// Bit mask of LSIRDY field.
	RCC_CSR_LSIRDY_Msk = 0x2
	// Bit LSIRDY.
	RCC_CSR_LSIRDY = 0x2
	// Position of LSION field.
	RCC_CSR_LSION_Pos = 0x0
	// Bit mask of LSION field.
	RCC_CSR_LSION_Msk = 0x1
	// Bit LSION.
	RCC_CSR_LSION = 0x1

	// EXTCFGR: Extended clock recovery register
	// Position of C2HPREF field.
	RCC_EXTCFGR_C2HPREF_Pos = 0x11
	// Bit mask of C2HPREF field.
	RCC_EXTCFGR_C2HPREF_Msk = 0x20000
	// Bit C2HPREF.
	RCC_EXTCFGR_C2HPREF = 0x20000
	// Position of SHDHPREF field.
	RCC_EXTCFGR_SHDHPREF_Pos = 0x10
	// Bit mask of SHDHPREF field.
	RCC_EXTCFGR_SHDHPREF_Msk = 0x10000
	// Bit SHDHPREF.
	RCC_EXTCFGR_SHDHPREF = 0x10000
	// Position of C2HPRE field.
	RCC_EXTCFGR_C2HPRE_Pos = 0x4
	// Bit mask of C2HPRE field.
	RCC_EXTCFGR_C2HPRE_Msk = 0xf0
	// Position of SHDHPRE field.
	RCC_EXTCFGR_SHDHPRE_Pos = 0x0
	// Bit mask of SHDHPRE field.
	RCC_EXTCFGR_SHDHPRE_Msk = 0xf

	// C2AHB1ENR: CPU2 AHB1 peripheral clock enable register
	// Position of CRCEN field.
	RCC_C2AHB1ENR_CRCEN_Pos = 0xc
	// Bit mask of CRCEN field.
	RCC_C2AHB1ENR_CRCEN_Msk = 0x1000
	// Bit CRCEN.
	RCC_C2AHB1ENR_CRCEN = 0x1000
	// Position of DMAMUX1EN field.
	RCC_C2AHB1ENR_DMAMUX1EN_Pos = 0x2
	// Bit mask of DMAMUX1EN field.
	RCC_C2AHB1ENR_DMAMUX1EN_Msk = 0x4
	// Bit DMAMUX1EN.
	RCC_C2AHB1ENR_DMAMUX1EN = 0x4
	// Position of DMA2EN field.
	RCC_C2AHB1ENR_DMA2EN_Pos = 0x1
	// Bit mask of DMA2EN field.
	RCC_C2AHB1ENR_DMA2EN_Msk = 0x2
	// Bit DMA2EN.
	RCC_C2AHB1ENR_DMA2EN = 0x2
	// Position of DMA1EN field.
	RCC_C2AHB1ENR_DMA1EN_Pos = 0x0
	// Bit mask of DMA1EN field.
	RCC_C2AHB1ENR_DMA1EN_Msk = 0x1
	// Bit DMA1EN.
	RCC_C2AHB1ENR_DMA1EN = 0x1

	// C2AHB2ENR: CPU2 AHB2 peripheral clock enable register
	// Position of GPIOHEN field.
	RCC_C2AHB2ENR_GPIOHEN_Pos = 0x7
	// Bit mask of GPIOHEN field.
	RCC_C2AHB2ENR_GPIOHEN_Msk = 0x80
	// Bit GPIOHEN.
	RCC_C2AHB2ENR_GPIOHEN = 0x80
	// Position of GPIOCEN field.
	RCC_C2AHB2ENR_GPIOCEN_Pos = 0x2
	// Bit mask of GPIOCEN field.
	RCC_C2AHB2ENR_GPIOCEN_Msk = 0x4
	// Bit GPIOCEN.
	RCC_C2AHB2ENR_GPIOCEN = 0x4
	// Position of GPIOBEN field.
	RCC_C2AHB2ENR_GPIOBEN_Pos = 0x1
	// Bit mask of GPIOBEN field.
	RCC_C2AHB2ENR_GPIOBEN_Msk = 0x2
	// Bit GPIOBEN.
	RCC_C2AHB2ENR_GPIOBEN = 0x2
	// Position of GPIOAEN field.
	RCC_C2AHB2ENR_GPIOAEN_Pos = 0x0
	// Bit mask of GPIOAEN field.
	RCC_C2AHB2ENR_GPIOAEN_Msk = 0x1
	// Bit GPIOAEN.
	RCC_C2AHB2ENR_GPIOAEN = 0x1

	// C2AHB3ENR: CPU2 AHB3 peripheral clock enable register [dual core device only]
	// Position of FLASHEN field.
	RCC_C2AHB3ENR_FLASHEN_Pos = 0x19
	// Bit mask of FLASHEN field.
	RCC_C2AHB3ENR_FLASHEN_Msk = 0x2000000
	// Bit FLASHEN.
	RCC_C2AHB3ENR_FLASHEN = 0x2000000
	// Position of IPCCEN field.
	RCC_C2AHB3ENR_IPCCEN_Pos = 0x14
	// Bit mask of IPCCEN field.
	RCC_C2AHB3ENR_IPCCEN_Msk = 0x100000
	// Bit IPCCEN.
	RCC_C2AHB3ENR_IPCCEN = 0x100000
	// Position of HSEMEN field.
	RCC_C2AHB3ENR_HSEMEN_Pos = 0x13
	// Bit mask of HSEMEN field.
	RCC_C2AHB3ENR_HSEMEN_Msk = 0x80000
	// Bit HSEMEN.
	RCC_C2AHB3ENR_HSEMEN = 0x80000
	// Position of RNGEN field.
	RCC_C2AHB3ENR_RNGEN_Pos = 0x12
	// Bit mask of RNGEN field.
	RCC_C2AHB3ENR_RNGEN_Msk = 0x40000
	// Bit RNGEN.
	RCC_C2AHB3ENR_RNGEN = 0x40000
	// Position of AESEN field.
	RCC_C2AHB3ENR_AESEN_Pos = 0x11
	// Bit mask of AESEN field.
	RCC_C2AHB3ENR_AESEN_Msk = 0x20000
	// Bit AESEN.
	RCC_C2AHB3ENR_AESEN = 0x20000
	// Position of PKAEN field.
	RCC_C2AHB3ENR_PKAEN_Pos = 0x10
	// Bit mask of PKAEN field.
	RCC_C2AHB3ENR_PKAEN_Msk = 0x10000
	// Bit PKAEN.
	RCC_C2AHB3ENR_PKAEN = 0x10000

	// C2APB1ENR1: CPU2 APB1 peripheral clock enable register 1 [dual core device only]
	// Position of LPTIM1EN field.
	RCC_C2APB1ENR1_LPTIM1EN_Pos = 0x1f
	// Bit mask of LPTIM1EN field.
	RCC_C2APB1ENR1_LPTIM1EN_Msk = 0x80000000
	// Bit LPTIM1EN.
	RCC_C2APB1ENR1_LPTIM1EN = 0x80000000
	// Position of DAC1EN field.
	RCC_C2APB1ENR1_DAC1EN_Pos = 0x1d
	// Bit mask of DAC1EN field.
	RCC_C2APB1ENR1_DAC1EN_Msk = 0x20000000
	// Bit DAC1EN.
	RCC_C2APB1ENR1_DAC1EN = 0x20000000
	// Position of I2C3EN field.
	RCC_C2APB1ENR1_I2C3EN_Pos = 0x17
	// Bit mask of I2C3EN field.
	RCC_C2APB1ENR1_I2C3EN_Msk = 0x800000
	// Bit I2C3EN.
	RCC_C2APB1ENR1_I2C3EN = 0x800000
	// Position of I2C2EN field.
	RCC_C2APB1ENR1_I2C2EN_Pos = 0x16
	// Bit mask of I2C2EN field.
	RCC_C2APB1ENR1_I2C2EN_Msk = 0x400000
	// Bit I2C2EN.
	RCC_C2APB1ENR1_I2C2EN = 0x400000
	// Position of I2C1EN field.
	RCC_C2APB1ENR1_I2C1EN_Pos = 0x15
	// Bit mask of I2C1EN field.
	RCC_C2APB1ENR1_I2C1EN_Msk = 0x200000
	// Bit I2C1EN.
	RCC_C2APB1ENR1_I2C1EN = 0x200000
	// Position of USART2EN field.
	RCC_C2APB1ENR1_USART2EN_Pos = 0x11
	// Bit mask of USART2EN field.
	RCC_C2APB1ENR1_USART2EN_Msk = 0x20000
	// Bit USART2EN.
	RCC_C2APB1ENR1_USART2EN = 0x20000
	// Position of SPI2S2EN field.
	RCC_C2APB1ENR1_SPI2S2EN_Pos = 0xe
	// Bit mask of SPI2S2EN field.
	RCC_C2APB1ENR1_SPI2S2EN_Msk = 0x4000
	// Bit SPI2S2EN.
	RCC_C2APB1ENR1_SPI2S2EN = 0x4000
	// Position of RTCAPBEN field.
	RCC_C2APB1ENR1_RTCAPBEN_Pos = 0xa
	// Bit mask of RTCAPBEN field.
	RCC_C2APB1ENR1_RTCAPBEN_Msk = 0x400
	// Bit RTCAPBEN.
	RCC_C2APB1ENR1_RTCAPBEN = 0x400
	// Position of TIM2EN field.
	RCC_C2APB1ENR1_TIM2EN_Pos = 0x0
	// Bit mask of TIM2EN field.
	RCC_C2APB1ENR1_TIM2EN_Msk = 0x1
	// Bit TIM2EN.
	RCC_C2APB1ENR1_TIM2EN = 0x1

	// C2APB1ENR2: CPU2 APB1 peripheral clock enable register 2 [dual core device only]
	// Position of LPTIM3EN field.
	RCC_C2APB1ENR2_LPTIM3EN_Pos = 0x6
	// Bit mask of LPTIM3EN field.
	RCC_C2APB1ENR2_LPTIM3EN_Msk = 0x40
	// Bit LPTIM3EN.
	RCC_C2APB1ENR2_LPTIM3EN = 0x40
	// Position of LPTIM2EN field.
	RCC_C2APB1ENR2_LPTIM2EN_Pos = 0x5
	// Bit mask of LPTIM2EN field.
	RCC_C2APB1ENR2_LPTIM2EN_Msk = 0x20
	// Bit LPTIM2EN.
	RCC_C2APB1ENR2_LPTIM2EN = 0x20
	// Position of LPUART1EN field.
	RCC_C2APB1ENR2_LPUART1EN_Pos = 0x0
	// Bit mask of LPUART1EN field.
	RCC_C2APB1ENR2_LPUART1EN_Msk = 0x1
	// Bit LPUART1EN.
	RCC_C2APB1ENR2_LPUART1EN = 0x1

	// C2APB2ENR: CPU2 APB2 peripheral clock enable register [dual core device only]
	// Position of TIM17EN field.
	RCC_C2APB2ENR_TIM17EN_Pos = 0x12
	// Bit mask of TIM17EN field.
	RCC_C2APB2ENR_TIM17EN_Msk = 0x40000
	// Bit TIM17EN.
	RCC_C2APB2ENR_TIM17EN = 0x40000
	// Position of TIM16EN field.
	RCC_C2APB2ENR_TIM16EN_Pos = 0x11
	// Bit mask of TIM16EN field.
	RCC_C2APB2ENR_TIM16EN_Msk = 0x20000
	// Bit TIM16EN.
	RCC_C2APB2ENR_TIM16EN = 0x20000
	// Position of USART1EN field.
	RCC_C2APB2ENR_USART1EN_Pos = 0xe
	// Bit mask of USART1EN field.
	RCC_C2APB2ENR_USART1EN_Msk = 0x4000
	// Bit USART1EN.
	RCC_C2APB2ENR_USART1EN = 0x4000
	// Position of SPI1EN field.
	RCC_C2APB2ENR_SPI1EN_Pos = 0xc
	// Bit mask of SPI1EN field.
	RCC_C2APB2ENR_SPI1EN_Msk = 0x1000
	// Bit SPI1EN.
	RCC_C2APB2ENR_SPI1EN = 0x1000
	// Position of TIM1EN field.
	RCC_C2APB2ENR_TIM1EN_Pos = 0xb
	// Bit mask of TIM1EN field.
	RCC_C2APB2ENR_TIM1EN_Msk = 0x800
	// Bit TIM1EN.
	RCC_C2APB2ENR_TIM1EN = 0x800
	// Position of ADCEN field.
	RCC_C2APB2ENR_ADCEN_Pos = 0x9
	// Bit mask of ADCEN field.
	RCC_C2APB2ENR_ADCEN_Msk = 0x200
	// Bit ADCEN.
	RCC_C2APB2ENR_ADCEN = 0x200

	// C2APB3ENR: CPU2 APB3 peripheral clock enable register [dual core device only]
	// Position of SUBGHZSPIEN field.
	RCC_C2APB3ENR_SUBGHZSPIEN_Pos = 0x0
	// Bit mask of SUBGHZSPIEN field.
	RCC_C2APB3ENR_SUBGHZSPIEN_Msk = 0x1
	// Bit SUBGHZSPIEN.
	RCC_C2APB3ENR_SUBGHZSPIEN = 0x1

	// C2AHB1SMENR: CPU2 AHB1 peripheral clocks enable in Sleep modes register [dual core device only]
	// Position of CRCSMEN field.
	RCC_C2AHB1SMENR_CRCSMEN_Pos = 0xc
	// Bit mask of CRCSMEN field.
	RCC_C2AHB1SMENR_CRCSMEN_Msk = 0x1000
	// Bit CRCSMEN.
	RCC_C2AHB1SMENR_CRCSMEN = 0x1000
	// Position of DMAMUX1SMEN field.
	RCC_C2AHB1SMENR_DMAMUX1SMEN_Pos = 0x2
	// Bit mask of DMAMUX1SMEN field.
	RCC_C2AHB1SMENR_DMAMUX1SMEN_Msk = 0x4
	// Bit DMAMUX1SMEN.
	RCC_C2AHB1SMENR_DMAMUX1SMEN = 0x4
	// Position of DMA2SMEN field.
	RCC_C2AHB1SMENR_DMA2SMEN_Pos = 0x1
	// Bit mask of DMA2SMEN field.
	RCC_C2AHB1SMENR_DMA2SMEN_Msk = 0x2
	// Bit DMA2SMEN.
	RCC_C2AHB1SMENR_DMA2SMEN = 0x2
	// Position of DMA1SMEN field.
	RCC_C2AHB1SMENR_DMA1SMEN_Pos = 0x0
	// Bit mask of DMA1SMEN field.
	RCC_C2AHB1SMENR_DMA1SMEN_Msk = 0x1
	// Bit DMA1SMEN.
	RCC_C2AHB1SMENR_DMA1SMEN = 0x1

	// C2AHB2SMENR: CPU2 AHB2 peripheral clocks enable in Sleep modes register [dual core device only]
	// Position of GPIOHSMEN field.
	RCC_C2AHB2SMENR_GPIOHSMEN_Pos = 0x7
	// Bit mask of GPIOHSMEN field.
	RCC_C2AHB2SMENR_GPIOHSMEN_Msk = 0x80
	// Bit GPIOHSMEN.
	RCC_C2AHB2SMENR_GPIOHSMEN = 0x80
	// Position of GPIOCSMEN field.
	RCC_C2AHB2SMENR_GPIOCSMEN_Pos = 0x2
	// Bit mask of GPIOCSMEN field.
	RCC_C2AHB2SMENR_GPIOCSMEN_Msk = 0x4
	// Bit GPIOCSMEN.
	RCC_C2AHB2SMENR_GPIOCSMEN = 0x4
	// Position of GPIOBSMEN field.
	RCC_C2AHB2SMENR_GPIOBSMEN_Pos = 0x1
	// Bit mask of GPIOBSMEN field.
	RCC_C2AHB2SMENR_GPIOBSMEN_Msk = 0x2
	// Bit GPIOBSMEN.
	RCC_C2AHB2SMENR_GPIOBSMEN = 0x2
	// Position of GPIOASMEN field.
	RCC_C2AHB2SMENR_GPIOASMEN_Pos = 0x0
	// Bit mask of GPIOASMEN field.
	RCC_C2AHB2SMENR_GPIOASMEN_Msk = 0x1
	// Bit GPIOASMEN.
	RCC_C2AHB2SMENR_GPIOASMEN = 0x1

	// C2AHB3SMENR: CPU2 AHB3 peripheral clocks enable in Sleep mode register [dual core device only]
	// Position of FLASHSMEN field.
	RCC_C2AHB3SMENR_FLASHSMEN_Pos = 0x19
	// Bit mask of FLASHSMEN field.
	RCC_C2AHB3SMENR_FLASHSMEN_Msk = 0x2000000
	// Bit FLASHSMEN.
	RCC_C2AHB3SMENR_FLASHSMEN = 0x2000000
	// Position of SRAM2SMEN field.
	RCC_C2AHB3SMENR_SRAM2SMEN_Pos = 0x18
	// Bit mask of SRAM2SMEN field.
	RCC_C2AHB3SMENR_SRAM2SMEN_Msk = 0x1000000
	// Bit SRAM2SMEN.
	RCC_C2AHB3SMENR_SRAM2SMEN = 0x1000000
	// Position of SRAM1SMEN field.
	RCC_C2AHB3SMENR_SRAM1SMEN_Pos = 0x17
	// Bit mask of SRAM1SMEN field.
	RCC_C2AHB3SMENR_SRAM1SMEN_Msk = 0x800000
	// Bit SRAM1SMEN.
	RCC_C2AHB3SMENR_SRAM1SMEN = 0x800000
	// Position of RNGSMEN field.
	RCC_C2AHB3SMENR_RNGSMEN_Pos = 0x12
	// Bit mask of RNGSMEN field.
	RCC_C2AHB3SMENR_RNGSMEN_Msk = 0x40000
	// Bit RNGSMEN.
	RCC_C2AHB3SMENR_RNGSMEN = 0x40000
	// Position of AESSMEN field.
	RCC_C2AHB3SMENR_AESSMEN_Pos = 0x11
	// Bit mask of AESSMEN field.
	RCC_C2AHB3SMENR_AESSMEN_Msk = 0x20000
	// Bit AESSMEN.
	RCC_C2AHB3SMENR_AESSMEN = 0x20000
	// Position of PKASMEN field.
	RCC_C2AHB3SMENR_PKASMEN_Pos = 0x10
	// Bit mask of PKASMEN field.
	RCC_C2AHB3SMENR_PKASMEN_Msk = 0x10000
	// Bit PKASMEN.
	RCC_C2AHB3SMENR_PKASMEN = 0x10000

	// C2APB1SMENR1: CPU2 APB1 peripheral clocks enable in Sleep mode register 1 [dual core device only]
	// Position of LPTIM1SMEN field.
	RCC_C2APB1SMENR1_LPTIM1SMEN_Pos = 0x1f
	// Bit mask of LPTIM1SMEN field.
	RCC_C2APB1SMENR1_LPTIM1SMEN_Msk = 0x80000000
	// Bit LPTIM1SMEN.
	RCC_C2APB1SMENR1_LPTIM1SMEN = 0x80000000
	// Position of DAC1SMEN field.
	RCC_C2APB1SMENR1_DAC1SMEN_Pos = 0x1d
	// Bit mask of DAC1SMEN field.
	RCC_C2APB1SMENR1_DAC1SMEN_Msk = 0x20000000
	// Bit DAC1SMEN.
	RCC_C2APB1SMENR1_DAC1SMEN = 0x20000000
	// Position of I2C3SMEN field.
	RCC_C2APB1SMENR1_I2C3SMEN_Pos = 0x17
	// Bit mask of I2C3SMEN field.
	RCC_C2APB1SMENR1_I2C3SMEN_Msk = 0x800000
	// Bit I2C3SMEN.
	RCC_C2APB1SMENR1_I2C3SMEN = 0x800000
	// Position of I2C2SMEN field.
	RCC_C2APB1SMENR1_I2C2SMEN_Pos = 0x16
	// Bit mask of I2C2SMEN field.
	RCC_C2APB1SMENR1_I2C2SMEN_Msk = 0x400000
	// Bit I2C2SMEN.
	RCC_C2APB1SMENR1_I2C2SMEN = 0x400000
	// Position of I2C1SMEN field.
	RCC_C2APB1SMENR1_I2C1SMEN_Pos = 0x15
	// Bit mask of I2C1SMEN field.
	RCC_C2APB1SMENR1_I2C1SMEN_Msk = 0x200000
	// Bit I2C1SMEN.
	RCC_C2APB1SMENR1_I2C1SMEN = 0x200000
	// Position of USART2SMEN field.
	RCC_C2APB1SMENR1_USART2SMEN_Pos = 0x11
	// Bit mask of USART2SMEN field.
	RCC_C2APB1SMENR1_USART2SMEN_Msk = 0x20000
	// Bit USART2SMEN.
	RCC_C2APB1SMENR1_USART2SMEN = 0x20000
	// Position of SPI2S2SMEN field.
	RCC_C2APB1SMENR1_SPI2S2SMEN_Pos = 0xe
	// Bit mask of SPI2S2SMEN field.
	RCC_C2APB1SMENR1_SPI2S2SMEN_Msk = 0x4000
	// Bit SPI2S2SMEN.
	RCC_C2APB1SMENR1_SPI2S2SMEN = 0x4000
	// Position of RTCAPBSMEN field.
	RCC_C2APB1SMENR1_RTCAPBSMEN_Pos = 0xa
	// Bit mask of RTCAPBSMEN field.
	RCC_C2APB1SMENR1_RTCAPBSMEN_Msk = 0x400
	// Bit RTCAPBSMEN.
	RCC_C2APB1SMENR1_RTCAPBSMEN = 0x400
	// Position of TIM2SMEN field.
	RCC_C2APB1SMENR1_TIM2SMEN_Pos = 0x0
	// Bit mask of TIM2SMEN field.
	RCC_C2APB1SMENR1_TIM2SMEN_Msk = 0x1
	// Bit TIM2SMEN.
	RCC_C2APB1SMENR1_TIM2SMEN = 0x1

	// C2APB1SMENR2: CPU2 APB1 peripheral clocks enable in Sleep mode register 2 [dual core device only]
	// Position of LPTIM3SMEN field.
	RCC_C2APB1SMENR2_LPTIM3SMEN_Pos = 0x6
	// Bit mask of LPTIM3SMEN field.
	RCC_C2APB1SMENR2_LPTIM3SMEN_Msk = 0x40
	// Bit LPTIM3SMEN.
	RCC_C2APB1SMENR2_LPTIM3SMEN = 0x40
	// Position of LPTIM2SMEN field.
	RCC_C2APB1SMENR2_LPTIM2SMEN_Pos = 0x5
	// Bit mask of LPTIM2SMEN field.
	RCC_C2APB1SMENR2_LPTIM2SMEN_Msk = 0x20
	// Bit LPTIM2SMEN.
	RCC_C2APB1SMENR2_LPTIM2SMEN = 0x20
	// Position of LPUART1SMEN field.
	RCC_C2APB1SMENR2_LPUART1SMEN_Pos = 0x0
	// Bit mask of LPUART1SMEN field.
	RCC_C2APB1SMENR2_LPUART1SMEN_Msk = 0x1
	// Bit LPUART1SMEN.
	RCC_C2APB1SMENR2_LPUART1SMEN = 0x1

	// C2APB2SMENR: CPU2 APB2 peripheral clocks enable in Sleep mode register [dual core device only]
	// Position of TIM17SMEN field.
	RCC_C2APB2SMENR_TIM17SMEN_Pos = 0x12
	// Bit mask of TIM17SMEN field.
	RCC_C2APB2SMENR_TIM17SMEN_Msk = 0x40000
	// Bit TIM17SMEN.
	RCC_C2APB2SMENR_TIM17SMEN = 0x40000
	// Position of TIM16SMEN field.
	RCC_C2APB2SMENR_TIM16SMEN_Pos = 0x11
	// Bit mask of TIM16SMEN field.
	RCC_C2APB2SMENR_TIM16SMEN_Msk = 0x20000
	// Bit TIM16SMEN.
	RCC_C2APB2SMENR_TIM16SMEN = 0x20000
	// Position of USART1SMEN field.
	RCC_C2APB2SMENR_USART1SMEN_Pos = 0xe
	// Bit mask of USART1SMEN field.
	RCC_C2APB2SMENR_USART1SMEN_Msk = 0x4000
	// Bit USART1SMEN.
	RCC_C2APB2SMENR_USART1SMEN = 0x4000
	// Position of SPI1SMEN field.
	RCC_C2APB2SMENR_SPI1SMEN_Pos = 0xc
	// Bit mask of SPI1SMEN field.
	RCC_C2APB2SMENR_SPI1SMEN_Msk = 0x1000
	// Bit SPI1SMEN.
	RCC_C2APB2SMENR_SPI1SMEN = 0x1000
	// Position of TIM1SMEN field.
	RCC_C2APB2SMENR_TIM1SMEN_Pos = 0xb
	// Bit mask of TIM1SMEN field.
	RCC_C2APB2SMENR_TIM1SMEN_Msk = 0x800
	// Bit TIM1SMEN.
	RCC_C2APB2SMENR_TIM1SMEN = 0x800
	// Position of ADCSMEN field.
	RCC_C2APB2SMENR_ADCSMEN_Pos = 0x9
	// Bit mask of ADCSMEN field.
	RCC_C2APB2SMENR_ADCSMEN_Msk = 0x200
	// Bit ADCSMEN.
	RCC_C2APB2SMENR_ADCSMEN = 0x200

	// C2APB3SMENR: CPU2 APB3 peripheral clock enable in Sleep mode register [dual core device only]
	// Position of SUBGHZSPISMEN field.
	RCC_C2APB3SMENR_SUBGHZSPISMEN_Pos = 0x0
	// Bit mask of SUBGHZSPISMEN field.
	RCC_C2APB3SMENR_SUBGHZSPISMEN_Msk = 0x1
	// Bit SUBGHZSPISMEN.
	RCC_C2APB3SMENR_SUBGHZSPISMEN = 0x1
)

// Bitfields for RNG: True random number generator
const (
	// CR: control register
	// Position of RNGEN field.
	RNG_CR_RNGEN_Pos = 0x2
	// Bit mask of RNGEN field.
	RNG_CR_RNGEN_Msk = 0x4
	// Bit RNGEN.
	RNG_CR_RNGEN = 0x4
	// Position of IE field.
	RNG_CR_IE_Pos = 0x3
	// Bit mask of IE field.
	RNG_CR_IE_Msk = 0x8
	// Bit IE.
	RNG_CR_IE = 0x8
	// Position of CED field.
	RNG_CR_CED_Pos = 0x5
	// Bit mask of CED field.
	RNG_CR_CED_Msk = 0x20
	// Bit CED.
	RNG_CR_CED = 0x20
	// Position of RNG_CONFIG3 field.
	RNG_CR_RNG_CONFIG3_Pos = 0x8
	// Bit mask of RNG_CONFIG3 field.
	RNG_CR_RNG_CONFIG3_Msk = 0xf00
	// Position of NISTC field.
	RNG_CR_NISTC_Pos = 0xc
	// Bit mask of NISTC field.
	RNG_CR_NISTC_Msk = 0x1000
	// Bit NISTC.
	RNG_CR_NISTC = 0x1000
	// Position of RNG_CONFIG2 field.
	RNG_CR_RNG_CONFIG2_Pos = 0xd
	// Bit mask of RNG_CONFIG2 field.
	RNG_CR_RNG_CONFIG2_Msk = 0xe000
	// Position of CLKDIV field.
	RNG_CR_CLKDIV_Pos = 0x10
	// Bit mask of CLKDIV field.
	RNG_CR_CLKDIV_Msk = 0xf0000
	// Position of RNG_CONFIG1 field.
	RNG_CR_RNG_CONFIG1_Pos = 0x14
	// Bit mask of RNG_CONFIG1 field.
	RNG_CR_RNG_CONFIG1_Msk = 0x3f00000
	// Position of CONDRST field.
	RNG_CR_CONDRST_Pos = 0x1e
	// Bit mask of CONDRST field.
	RNG_CR_CONDRST_Msk = 0x40000000
	// Bit CONDRST.
	RNG_CR_CONDRST = 0x40000000
	// Position of CONFIGLOCK field.
	RNG_CR_CONFIGLOCK_Pos = 0x1f
	// Bit mask of CONFIGLOCK field.
	RNG_CR_CONFIGLOCK_Msk = 0x80000000
	// Bit CONFIGLOCK.
	RNG_CR_CONFIGLOCK = 0x80000000

	// SR: status register
	// Position of SEIS field.
	RNG_SR_SEIS_Pos = 0x6
	// Bit mask of SEIS field.
	RNG_SR_SEIS_Msk = 0x40
	// Bit SEIS.
	RNG_SR_SEIS = 0x40
	// Position of CEIS field.
	RNG_SR_CEIS_Pos = 0x5
	// Bit mask of CEIS field.
	RNG_SR_CEIS_Msk = 0x20
	// Bit CEIS.
	RNG_SR_CEIS = 0x20
	// Position of SECS field.
	RNG_SR_SECS_Pos = 0x2
	// Bit mask of SECS field.
	RNG_SR_SECS_Msk = 0x4
	// Bit SECS.
	RNG_SR_SECS = 0x4
	// Position of CECS field.
	RNG_SR_CECS_Pos = 0x1
	// Bit mask of CECS field.
	RNG_SR_CECS_Msk = 0x2
	// Bit CECS.
	RNG_SR_CECS = 0x2
	// Position of DRDY field.
	RNG_SR_DRDY_Pos = 0x0
	// Bit mask of DRDY field.
	RNG_SR_DRDY_Msk = 0x1
	// Bit DRDY.
	RNG_SR_DRDY = 0x1

	// DR: data register
	// Position of RNDATA field.
	RNG_DR_RNDATA_Pos = 0x0
	// Bit mask of RNDATA field.
	RNG_DR_RNDATA_Msk = 0xffffffff

	// HTCR: health test control register
	// Position of HTCFG field.
	RNG_HTCR_HTCFG_Pos = 0x0
	// Bit mask of HTCFG field.
	RNG_HTCR_HTCFG_Msk = 0xffffffff
)

// Bitfields for RTC: Real-time clock
const (
	// TR: TR
	// Position of PM field.
	RTC_TR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_TR_PM_Msk = 0x400000
	// Bit PM.
	RTC_TR_PM = 0x400000
	// Position of HT field.
	RTC_TR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_TR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_TR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_TR_HU_Msk = 0xf0000
	// Position of MNT field.
	RTC_TR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_TR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_TR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_TR_MNU_Msk = 0xf00
	// Position of ST field.
	RTC_TR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_TR_ST_Msk = 0x70
	// Position of SU field.
	RTC_TR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_TR_SU_Msk = 0xf

	// DR: DR
	// Position of YT field.
	RTC_DR_YT_Pos = 0x14
	// Bit mask of YT field.
	RTC_DR_YT_Msk = 0xf00000
	// Position of YU field.
	RTC_DR_YU_Pos = 0x10
	// Bit mask of YU field.
	RTC_DR_YU_Msk = 0xf0000
	// Position of WDU field.
	RTC_DR_WDU_Pos = 0xd
	// Bit mask of WDU field.
	RTC_DR_WDU_Msk = 0xe000
	// Position of MT field.
	RTC_DR_MT_Pos = 0xc
	// Bit mask of MT field.
	RTC_DR_MT_Msk = 0x1000
	// Bit MT.
	RTC_DR_MT = 0x1000
	// Position of MU field.
	RTC_DR_MU_Pos = 0x8
	// Bit mask of MU field.
	RTC_DR_MU_Msk = 0xf00
	// Position of DT field.
	RTC_DR_DT_Pos = 0x4
	// Bit mask of DT field.
	RTC_DR_DT_Msk = 0x30
	// Position of DU field.
	RTC_DR_DU_Pos = 0x0
	// Bit mask of DU field.
	RTC_DR_DU_Msk = 0xf

	// SSR: SSR
	// Position of SS field.
	RTC_SSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_SSR_SS_Msk = 0xffffffff

	// ICSR: ICSR
	// Position of RECALPF field.
	RTC_ICSR_RECALPF_Pos = 0x10
	// Bit mask of RECALPF field.
	RTC_ICSR_RECALPF_Msk = 0x10000
	// Bit RECALPF.
	RTC_ICSR_RECALPF = 0x10000
	// Position of BCDU field.
	RTC_ICSR_BCDU_Pos = 0xa
	// Bit mask of BCDU field.
	RTC_ICSR_BCDU_Msk = 0x1c00
	// Position of BIN field.
	RTC_ICSR_BIN_Pos = 0x8
	// Bit mask of BIN field.
	RTC_ICSR_BIN_Msk = 0x300
	// Position of INIT field.
	RTC_ICSR_INIT_Pos = 0x7
	// Bit mask of INIT field.
	RTC_ICSR_INIT_Msk = 0x80
	// Bit INIT.
	RTC_ICSR_INIT = 0x80
	// Position of INITF field.
	RTC_ICSR_INITF_Pos = 0x6
	// Bit mask of INITF field.
	RTC_ICSR_INITF_Msk = 0x40
	// Bit INITF.
	RTC_ICSR_INITF = 0x40
	// Position of RSF field.
	RTC_ICSR_RSF_Pos = 0x5
	// Bit mask of RSF field.
	RTC_ICSR_RSF_Msk = 0x20
	// Bit RSF.
	RTC_ICSR_RSF = 0x20
	// Position of INITS field.
	RTC_ICSR_INITS_Pos = 0x4
	// Bit mask of INITS field.
	RTC_ICSR_INITS_Msk = 0x10
	// Bit INITS.
	RTC_ICSR_INITS = 0x10
	// Position of SHPF field.
	RTC_ICSR_SHPF_Pos = 0x3
	// Bit mask of SHPF field.
	RTC_ICSR_SHPF_Msk = 0x8
	// Bit SHPF.
	RTC_ICSR_SHPF = 0x8
	// Position of WUTWF field.
	RTC_ICSR_WUTWF_Pos = 0x2
	// Bit mask of WUTWF field.
	RTC_ICSR_WUTWF_Msk = 0x4
	// Bit WUTWF.
	RTC_ICSR_WUTWF = 0x4

	// PRER: PRER
	// Position of PREDIV_A field.
	RTC_PRER_PREDIV_A_Pos = 0x10
	// Bit mask of PREDIV_A field.
	RTC_PRER_PREDIV_A_Msk = 0x7f0000
	// Position of PREDIV_S field.
	RTC_PRER_PREDIV_S_Pos = 0x0
	// Bit mask of PREDIV_S field.
	RTC_PRER_PREDIV_S_Msk = 0x7fff

	// WUTR: WUTR
	// Position of WUTOCLR field.
	RTC_WUTR_WUTOCLR_Pos = 0x10
	// Bit mask of WUTOCLR field.
	RTC_WUTR_WUTOCLR_Msk = 0xffff0000
	// Position of WUT field.
	RTC_WUTR_WUT_Pos = 0x0
	// Bit mask of WUT field.
	RTC_WUTR_WUT_Msk = 0xffff

	// CR: CR
	// Position of OUT2EN field.
	RTC_CR_OUT2EN_Pos = 0x1f
	// Bit mask of OUT2EN field.
	RTC_CR_OUT2EN_Msk = 0x80000000
	// Bit OUT2EN.
	RTC_CR_OUT2EN = 0x80000000
	// Position of TAMPALRM_TYPE field.
	RTC_CR_TAMPALRM_TYPE_Pos = 0x1e
	// Bit mask of TAMPALRM_TYPE field.
	RTC_CR_TAMPALRM_TYPE_Msk = 0x40000000
	// Bit TAMPALRM_TYPE.
	RTC_CR_TAMPALRM_TYPE = 0x40000000
	// Position of TAMPALRM_PU field.
	RTC_CR_TAMPALRM_PU_Pos = 0x1d
	// Bit mask of TAMPALRM_PU field.
	RTC_CR_TAMPALRM_PU_Msk = 0x20000000
	// Bit TAMPALRM_PU.
	RTC_CR_TAMPALRM_PU = 0x20000000
	// Position of TAMPOE field.
	RTC_CR_TAMPOE_Pos = 0x1a
	// Bit mask of TAMPOE field.
	RTC_CR_TAMPOE_Msk = 0x4000000
	// Bit TAMPOE.
	RTC_CR_TAMPOE = 0x4000000
	// Position of TAMPTS field.
	RTC_CR_TAMPTS_Pos = 0x19
	// Bit mask of TAMPTS field.
	RTC_CR_TAMPTS_Msk = 0x2000000
	// Bit TAMPTS.
	RTC_CR_TAMPTS = 0x2000000
	// Position of ITSE field.
	RTC_CR_ITSE_Pos = 0x18
	// Bit mask of ITSE field.
	RTC_CR_ITSE_Msk = 0x1000000
	// Bit ITSE.
	RTC_CR_ITSE = 0x1000000
	// Position of COE field.
	RTC_CR_COE_Pos = 0x17
	// Bit mask of COE field.
	RTC_CR_COE_Msk = 0x800000
	// Bit COE.
	RTC_CR_COE = 0x800000
	// Position of OSEL field.
	RTC_CR_OSEL_Pos = 0x15
	// Bit mask of OSEL field.
	RTC_CR_OSEL_Msk = 0x600000
	// Position of POL field.
	RTC_CR_POL_Pos = 0x14
	// Bit mask of POL field.
	RTC_CR_POL_Msk = 0x100000
	// Bit POL.
	RTC_CR_POL = 0x100000
	// Position of COSEL field.
	RTC_CR_COSEL_Pos = 0x13
	// Bit mask of COSEL field.
	RTC_CR_COSEL_Msk = 0x80000
	// Bit COSEL.
	RTC_CR_COSEL = 0x80000
	// Position of BKP field.
	RTC_CR_BKP_Pos = 0x12
	// Bit mask of BKP field.
	RTC_CR_BKP_Msk = 0x40000
	// Bit BKP.
	RTC_CR_BKP = 0x40000
	// Position of SUB1H field.
	RTC_CR_SUB1H_Pos = 0x11
	// Bit mask of SUB1H field.
	RTC_CR_SUB1H_Msk = 0x20000
	// Bit SUB1H.
	RTC_CR_SUB1H = 0x20000
	// Position of ADD1H field.
	RTC_CR_ADD1H_Pos = 0x10
	// Bit mask of ADD1H field.
	RTC_CR_ADD1H_Msk = 0x10000
	// Bit ADD1H.
	RTC_CR_ADD1H = 0x10000
	// Position of TSIE field.
	RTC_CR_TSIE_Pos = 0xf
	// Bit mask of TSIE field.
	RTC_CR_TSIE_Msk = 0x8000
	// Bit TSIE.
	RTC_CR_TSIE = 0x8000
	// Position of WUTIE field.
	RTC_CR_WUTIE_Pos = 0xe
	// Bit mask of WUTIE field.
	RTC_CR_WUTIE_Msk = 0x4000
	// Bit WUTIE.
	RTC_CR_WUTIE = 0x4000
	// Position of ALRBIE field.
	RTC_CR_ALRBIE_Pos = 0xd
	// Bit mask of ALRBIE field.
	RTC_CR_ALRBIE_Msk = 0x2000
	// Bit ALRBIE.
	RTC_CR_ALRBIE = 0x2000
	// Position of ALRAIE field.
	RTC_CR_ALRAIE_Pos = 0xc
	// Bit mask of ALRAIE field.
	RTC_CR_ALRAIE_Msk = 0x1000
	// Bit ALRAIE.
	RTC_CR_ALRAIE = 0x1000
	// Position of TSE field.
	RTC_CR_TSE_Pos = 0xb
	// Bit mask of TSE field.
	RTC_CR_TSE_Msk = 0x800
	// Bit TSE.
	RTC_CR_TSE = 0x800
	// Position of WUTE field.
	RTC_CR_WUTE_Pos = 0xa
	// Bit mask of WUTE field.
	RTC_CR_WUTE_Msk = 0x400
	// Bit WUTE.
	RTC_CR_WUTE = 0x400
	// Position of ALRBE field.
	RTC_CR_ALRBE_Pos = 0x9
	// Bit mask of ALRBE field.
	RTC_CR_ALRBE_Msk = 0x200
	// Bit ALRBE.
	RTC_CR_ALRBE = 0x200
	// Position of ALRAE field.
	RTC_CR_ALRAE_Pos = 0x8
	// Bit mask of ALRAE field.
	RTC_CR_ALRAE_Msk = 0x100
	// Bit ALRAE.
	RTC_CR_ALRAE = 0x100
	// Position of SSRUIE field.
	RTC_CR_SSRUIE_Pos = 0x7
	// Bit mask of SSRUIE field.
	RTC_CR_SSRUIE_Msk = 0x80
	// Bit SSRUIE.
	RTC_CR_SSRUIE = 0x80
	// Position of FMT field.
	RTC_CR_FMT_Pos = 0x6
	// Bit mask of FMT field.
	RTC_CR_FMT_Msk = 0x40
	// Bit FMT.
	RTC_CR_FMT = 0x40
	// Position of BYPSHAD field.
	RTC_CR_BYPSHAD_Pos = 0x5
	// Bit mask of BYPSHAD field.
	RTC_CR_BYPSHAD_Msk = 0x20
	// Bit BYPSHAD.
	RTC_CR_BYPSHAD = 0x20
	// Position of REFCKON field.
	RTC_CR_REFCKON_Pos = 0x4
	// Bit mask of REFCKON field.
	RTC_CR_REFCKON_Msk = 0x10
	// Bit REFCKON.
	RTC_CR_REFCKON = 0x10
	// Position of TSEDGE field.
	RTC_CR_TSEDGE_Pos = 0x3
	// Bit mask of TSEDGE field.
	RTC_CR_TSEDGE_Msk = 0x8
	// Bit TSEDGE.
	RTC_CR_TSEDGE = 0x8
	// Position of WUCKSEL field.
	RTC_CR_WUCKSEL_Pos = 0x0
	// Bit mask of WUCKSEL field.
	RTC_CR_WUCKSEL_Msk = 0x7

	// WPR: write protection register
	// Position of KEY field.
	RTC_WPR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	RTC_WPR_KEY_Msk = 0xff

	// CALR: CALR
	// Position of CALP field.
	RTC_CALR_CALP_Pos = 0xf
	// Bit mask of CALP field.
	RTC_CALR_CALP_Msk = 0x8000
	// Bit CALP.
	RTC_CALR_CALP = 0x8000
	// Position of CALW8 field.
	RTC_CALR_CALW8_Pos = 0xe
	// Bit mask of CALW8 field.
	RTC_CALR_CALW8_Msk = 0x4000
	// Bit CALW8.
	RTC_CALR_CALW8 = 0x4000
	// Position of CALW16 field.
	RTC_CALR_CALW16_Pos = 0xd
	// Bit mask of CALW16 field.
	RTC_CALR_CALW16_Msk = 0x2000
	// Bit CALW16.
	RTC_CALR_CALW16 = 0x2000
	// Position of LPCAL field.
	RTC_CALR_LPCAL_Pos = 0xc
	// Bit mask of LPCAL field.
	RTC_CALR_LPCAL_Msk = 0x1000
	// Bit LPCAL.
	RTC_CALR_LPCAL = 0x1000
	// Position of CALM field.
	RTC_CALR_CALM_Pos = 0x0
	// Bit mask of CALM field.
	RTC_CALR_CALM_Msk = 0x1ff

	// SHIFTR: SHIFTR
	// Position of ADD1S field.
	RTC_SHIFTR_ADD1S_Pos = 0x1f
	// Bit mask of ADD1S field.
	RTC_SHIFTR_ADD1S_Msk = 0x80000000
	// Bit ADD1S.
	RTC_SHIFTR_ADD1S = 0x80000000
	// Position of SUBFS field.
	RTC_SHIFTR_SUBFS_Pos = 0x0
	// Bit mask of SUBFS field.
	RTC_SHIFTR_SUBFS_Msk = 0x7fff

	// TSTR: TSTR
	// Position of PM field.
	RTC_TSTR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_TSTR_PM_Msk = 0x400000
	// Bit PM.
	RTC_TSTR_PM = 0x400000
	// Position of HT field.
	RTC_TSTR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_TSTR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_TSTR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_TSTR_HU_Msk = 0xf0000
	// Position of MNT field.
	RTC_TSTR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_TSTR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_TSTR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_TSTR_MNU_Msk = 0xf00
	// Position of ST field.
	RTC_TSTR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_TSTR_ST_Msk = 0x70
	// Position of SU field.
	RTC_TSTR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_TSTR_SU_Msk = 0xf

	// TSDR: TSDR
	// Position of WDU field.
	RTC_TSDR_WDU_Pos = 0xd
	// Bit mask of WDU field.
	RTC_TSDR_WDU_Msk = 0xe000
	// Position of MT field.
	RTC_TSDR_MT_Pos = 0xc
	// Bit mask of MT field.
	RTC_TSDR_MT_Msk = 0x1000
	// Bit MT.
	RTC_TSDR_MT = 0x1000
	// Position of MU field.
	RTC_TSDR_MU_Pos = 0x8
	// Bit mask of MU field.
	RTC_TSDR_MU_Msk = 0xf00
	// Position of DT field.
	RTC_TSDR_DT_Pos = 0x4
	// Bit mask of DT field.
	RTC_TSDR_DT_Msk = 0x30
	// Position of DU field.
	RTC_TSDR_DU_Pos = 0x0
	// Bit mask of DU field.
	RTC_TSDR_DU_Msk = 0xf

	// TSSSR: TSSSR
	// Position of SS field.
	RTC_TSSSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_TSSSR_SS_Msk = 0xffffffff

	// ALRMAR: ALRMAR
	// Position of MSK4 field.
	RTC_ALRMAR_MSK4_Pos = 0x1f
	// Bit mask of MSK4 field.
	RTC_ALRMAR_MSK4_Msk = 0x80000000
	// Bit MSK4.
	RTC_ALRMAR_MSK4 = 0x80000000
	// Position of WDSEL field.
	RTC_ALRMAR_WDSEL_Pos = 0x1e
	// Bit mask of WDSEL field.
	RTC_ALRMAR_WDSEL_Msk = 0x40000000
	// Bit WDSEL.
	RTC_ALRMAR_WDSEL = 0x40000000
	// Position of DT field.
	RTC_ALRMAR_DT_Pos = 0x1c
	// Bit mask of DT field.
	RTC_ALRMAR_DT_Msk = 0x30000000
	// Position of DU field.
	RTC_ALRMAR_DU_Pos = 0x18
	// Bit mask of DU field.
	RTC_ALRMAR_DU_Msk = 0xf000000
	// Position of MSK3 field.
	RTC_ALRMAR_MSK3_Pos = 0x17
	// Bit mask of MSK3 field.
	RTC_ALRMAR_MSK3_Msk = 0x800000
	// Bit MSK3.
	RTC_ALRMAR_MSK3 = 0x800000
	// Position of PM field.
	RTC_ALRMAR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_ALRMAR_PM_Msk = 0x400000
	// Bit PM.
	RTC_ALRMAR_PM = 0x400000
	// Position of HT field.
	RTC_ALRMAR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_ALRMAR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_ALRMAR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_ALRMAR_HU_Msk = 0xf0000
	// Position of MSK2 field.
	RTC_ALRMAR_MSK2_Pos = 0xf
	// Bit mask of MSK2 field.
	RTC_ALRMAR_MSK2_Msk = 0x8000
	// Bit MSK2.
	RTC_ALRMAR_MSK2 = 0x8000
	// Position of MNT field.
	RTC_ALRMAR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_ALRMAR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_ALRMAR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_ALRMAR_MNU_Msk = 0xf00
	// Position of MSK1 field.
	RTC_ALRMAR_MSK1_Pos = 0x7
	// Bit mask of MSK1 field.
	RTC_ALRMAR_MSK1_Msk = 0x80
	// Bit MSK1.
	RTC_ALRMAR_MSK1 = 0x80
	// Position of ST field.
	RTC_ALRMAR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_ALRMAR_ST_Msk = 0x70
	// Position of SU field.
	RTC_ALRMAR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_ALRMAR_SU_Msk = 0xf

	// ALRMASSR: ALRMASSR
	// Position of SSCLR field.
	RTC_ALRMASSR_SSCLR_Pos = 0x1f
	// Bit mask of SSCLR field.
	RTC_ALRMASSR_SSCLR_Msk = 0x80000000
	// Bit SSCLR.
	RTC_ALRMASSR_SSCLR = 0x80000000
	// Position of MASKSS field.
	RTC_ALRMASSR_MASKSS_Pos = 0x18
	// Bit mask of MASKSS field.
	RTC_ALRMASSR_MASKSS_Msk = 0x3f000000
	// Position of SS field.
	RTC_ALRMASSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_ALRMASSR_SS_Msk = 0x7fff

	// ALRMBR: ALRMBR
	// Position of MSK4 field.
	RTC_ALRMBR_MSK4_Pos = 0x1f
	// Bit mask of MSK4 field.
	RTC_ALRMBR_MSK4_Msk = 0x80000000
	// Bit MSK4.
	RTC_ALRMBR_MSK4 = 0x80000000
	// Position of WDSEL field.
	RTC_ALRMBR_WDSEL_Pos = 0x1e
	// Bit mask of WDSEL field.
	RTC_ALRMBR_WDSEL_Msk = 0x40000000
	// Bit WDSEL.
	RTC_ALRMBR_WDSEL = 0x40000000
	// Position of DT field.
	RTC_ALRMBR_DT_Pos = 0x1c
	// Bit mask of DT field.
	RTC_ALRMBR_DT_Msk = 0x30000000
	// Position of DU field.
	RTC_ALRMBR_DU_Pos = 0x18
	// Bit mask of DU field.
	RTC_ALRMBR_DU_Msk = 0xf000000
	// Position of MSK3 field.
	RTC_ALRMBR_MSK3_Pos = 0x17
	// Bit mask of MSK3 field.
	RTC_ALRMBR_MSK3_Msk = 0x800000
	// Bit MSK3.
	RTC_ALRMBR_MSK3 = 0x800000
	// Position of PM field.
	RTC_ALRMBR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_ALRMBR_PM_Msk = 0x400000
	// Bit PM.
	RTC_ALRMBR_PM = 0x400000
	// Position of HT field.
	RTC_ALRMBR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_ALRMBR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_ALRMBR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_ALRMBR_HU_Msk = 0xf0000
	// Position of MSK2 field.
	RTC_ALRMBR_MSK2_Pos = 0xf
	// Bit mask of MSK2 field.
	RTC_ALRMBR_MSK2_Msk = 0x8000
	// Bit MSK2.
	RTC_ALRMBR_MSK2 = 0x8000
	// Position of MNT field.
	RTC_ALRMBR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_ALRMBR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_ALRMBR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_ALRMBR_MNU_Msk = 0xf00
	// Position of MSK1 field.
	RTC_ALRMBR_MSK1_Pos = 0x7
	// Bit mask of MSK1 field.
	RTC_ALRMBR_MSK1_Msk = 0x80
	// Bit MSK1.
	RTC_ALRMBR_MSK1 = 0x80
	// Position of ST field.
	RTC_ALRMBR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_ALRMBR_ST_Msk = 0x70
	// Position of SU field.
	RTC_ALRMBR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_ALRMBR_SU_Msk = 0xf

	// ALRMBSSR: ALRMBSSR
	// Position of SSCLR field.
	RTC_ALRMBSSR_SSCLR_Pos = 0x1f
	// Bit mask of SSCLR field.
	RTC_ALRMBSSR_SSCLR_Msk = 0x80000000
	// Bit SSCLR.
	RTC_ALRMBSSR_SSCLR = 0x80000000
	// Position of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Pos = 0x18
	// Bit mask of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Msk = 0x3f000000
	// Position of SS field.
	RTC_ALRMBSSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_ALRMBSSR_SS_Msk = 0x7fff

	// SR: SR
	// Position of SSRUF field.
	RTC_SR_SSRUF_Pos = 0x6
	// Bit mask of SSRUF field.
	RTC_SR_SSRUF_Msk = 0x40
	// Bit SSRUF.
	RTC_SR_SSRUF = 0x40
	// Position of ITSF field.
	RTC_SR_ITSF_Pos = 0x5
	// Bit mask of ITSF field.
	RTC_SR_ITSF_Msk = 0x20
	// Bit ITSF.
	RTC_SR_ITSF = 0x20
	// Position of TSOVF field.
	RTC_SR_TSOVF_Pos = 0x4
	// Bit mask of TSOVF field.
	RTC_SR_TSOVF_Msk = 0x10
	// Bit TSOVF.
	RTC_SR_TSOVF = 0x10
	// Position of TSF field.
	RTC_SR_TSF_Pos = 0x3
	// Bit mask of TSF field.
	RTC_SR_TSF_Msk = 0x8
	// Bit TSF.
	RTC_SR_TSF = 0x8
	// Position of WUTF field.
	RTC_SR_WUTF_Pos = 0x2
	// Bit mask of WUTF field.
	RTC_SR_WUTF_Msk = 0x4
	// Bit WUTF.
	RTC_SR_WUTF = 0x4
	// Position of ALRBF field.
	RTC_SR_ALRBF_Pos = 0x1
	// Bit mask of ALRBF field.
	RTC_SR_ALRBF_Msk = 0x2
	// Bit ALRBF.
	RTC_SR_ALRBF = 0x2
	// Position of ALRAF field.
	RTC_SR_ALRAF_Pos = 0x0
	// Bit mask of ALRAF field.
	RTC_SR_ALRAF_Msk = 0x1
	// Bit ALRAF.
	RTC_SR_ALRAF = 0x1

	// MISR: MISR
	// Position of SSRUMF field.
	RTC_MISR_SSRUMF_Pos = 0x6
	// Bit mask of SSRUMF field.
	RTC_MISR_SSRUMF_Msk = 0x40
	// Bit SSRUMF.
	RTC_MISR_SSRUMF = 0x40
	// Position of ITSMF field.
	RTC_MISR_ITSMF_Pos = 0x5
	// Bit mask of ITSMF field.
	RTC_MISR_ITSMF_Msk = 0x20
	// Bit ITSMF.
	RTC_MISR_ITSMF = 0x20
	// Position of TSOVMF field.
	RTC_MISR_TSOVMF_Pos = 0x4
	// Bit mask of TSOVMF field.
	RTC_MISR_TSOVMF_Msk = 0x10
	// Bit TSOVMF.
	RTC_MISR_TSOVMF = 0x10
	// Position of TSMF field.
	RTC_MISR_TSMF_Pos = 0x3
	// Bit mask of TSMF field.
	RTC_MISR_TSMF_Msk = 0x8
	// Bit TSMF.
	RTC_MISR_TSMF = 0x8
	// Position of WUTMF field.
	RTC_MISR_WUTMF_Pos = 0x2
	// Bit mask of WUTMF field.
	RTC_MISR_WUTMF_Msk = 0x4
	// Bit WUTMF.
	RTC_MISR_WUTMF = 0x4
	// Position of ALRBMF field.
	RTC_MISR_ALRBMF_Pos = 0x1
	// Bit mask of ALRBMF field.
	RTC_MISR_ALRBMF_Msk = 0x2
	// Bit ALRBMF.
	RTC_MISR_ALRBMF = 0x2
	// Position of ALRAMF field.
	RTC_MISR_ALRAMF_Pos = 0x0
	// Bit mask of ALRAMF field.
	RTC_MISR_ALRAMF_Msk = 0x1
	// Bit ALRAMF.
	RTC_MISR_ALRAMF = 0x1

	// SCR: SCR
	// Position of CSSRUF field.
	RTC_SCR_CSSRUF_Pos = 0x6
	// Bit mask of CSSRUF field.
	RTC_SCR_CSSRUF_Msk = 0x40
	// Bit CSSRUF.
	RTC_SCR_CSSRUF = 0x40
	// Position of CITSF field.
	RTC_SCR_CITSF_Pos = 0x5
	// Bit mask of CITSF field.
	RTC_SCR_CITSF_Msk = 0x20
	// Bit CITSF.
	RTC_SCR_CITSF = 0x20
	// Position of CTSOVF field.
	RTC_SCR_CTSOVF_Pos = 0x4
	// Bit mask of CTSOVF field.
	RTC_SCR_CTSOVF_Msk = 0x10
	// Bit CTSOVF.
	RTC_SCR_CTSOVF = 0x10
	// Position of CTSF field.
	RTC_SCR_CTSF_Pos = 0x3
	// Bit mask of CTSF field.
	RTC_SCR_CTSF_Msk = 0x8
	// Bit CTSF.
	RTC_SCR_CTSF = 0x8
	// Position of CWUTF field.
	RTC_SCR_CWUTF_Pos = 0x2
	// Bit mask of CWUTF field.
	RTC_SCR_CWUTF_Msk = 0x4
	// Bit CWUTF.
	RTC_SCR_CWUTF = 0x4
	// Position of CALRBF field.
	RTC_SCR_CALRBF_Pos = 0x1
	// Bit mask of CALRBF field.
	RTC_SCR_CALRBF_Msk = 0x2
	// Bit CALRBF.
	RTC_SCR_CALRBF = 0x2
	// Position of CALRAF field.
	RTC_SCR_CALRAF_Pos = 0x0
	// Bit mask of CALRAF field.
	RTC_SCR_CALRAF_Msk = 0x1
	// Bit CALRAF.
	RTC_SCR_CALRAF = 0x1

	// ALRABINR: RTC alarm A binary mode register
	// Position of SS field.
	RTC_ALRABINR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_ALRABINR_SS_Msk = 0xffffffff

	// ALRBBINR: RTC alarm B binary mode register
	// Position of SS field.
	RTC_ALRBBINR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_ALRBBINR_SS_Msk = 0xffffffff
)

// Bitfields for SCB: System control block
const (
	// CPUID: CPUID base register
	// Position of Revision field.
	SCB_CPUID_Revision_Pos = 0x0
	// Bit mask of Revision field.
	SCB_CPUID_Revision_Msk = 0xf
	// Position of PartNo field.
	SCB_CPUID_PartNo_Pos = 0x4
	// Bit mask of PartNo field.
	SCB_CPUID_PartNo_Msk = 0xfff0
	// Position of Constant field.
	SCB_CPUID_Constant_Pos = 0x10
	// Bit mask of Constant field.
	SCB_CPUID_Constant_Msk = 0xf0000
	// Position of Variant field.
	SCB_CPUID_Variant_Pos = 0x14
	// Bit mask of Variant field.
	SCB_CPUID_Variant_Msk = 0xf00000
	// Position of Implementer field.
	SCB_CPUID_Implementer_Pos = 0x18
	// Bit mask of Implementer field.
	SCB_CPUID_Implementer_Msk = 0xff000000

	// ICSR: Interrupt control and state register
	// Position of VECTACTIVE field.
	SCB_ICSR_VECTACTIVE_Pos = 0x0
	// Bit mask of VECTACTIVE field.
	SCB_ICSR_VECTACTIVE_Msk = 0x1ff
	// Position of RETTOBASE field.
	SCB_ICSR_RETTOBASE_Pos = 0xb
	// Bit mask of RETTOBASE field.
	SCB_ICSR_RETTOBASE_Msk = 0x800
	// Bit RETTOBASE.
	SCB_ICSR_RETTOBASE = 0x800
	// Position of VECTPENDING field.
	SCB_ICSR_VECTPENDING_Pos = 0xc
	// Bit mask of VECTPENDING field.
	SCB_ICSR_VECTPENDING_Msk = 0x7f000
	// Position of ISRPENDING field.
	SCB_ICSR_ISRPENDING_Pos = 0x16
	// Bit mask of ISRPENDING field.
	SCB_ICSR_ISRPENDING_Msk = 0x400000
	// Bit ISRPENDING.
	SCB_ICSR_ISRPENDING = 0x400000
	// Position of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR_Pos = 0x19
	// Bit mask of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR_Msk = 0x2000000
	// Bit PENDSTCLR.
	SCB_ICSR_PENDSTCLR = 0x2000000
	// Position of PENDSTSET field.
	SCB_ICSR_PENDSTSET_Pos = 0x1a
	// Bit mask of PENDSTSET field.
	SCB_ICSR_PENDSTSET_Msk = 0x4000000
	// Bit PENDSTSET.
	SCB_ICSR_PENDSTSET = 0x4000000
	// Position of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR_Pos = 0x1b
	// Bit mask of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR_Msk = 0x8000000
	// Bit PENDSVCLR.
	SCB_ICSR_PENDSVCLR = 0x8000000
	// Position of PENDSVSET field.
	SCB_ICSR_PENDSVSET_Pos = 0x1c
	// Bit mask of PENDSVSET field.
	SCB_ICSR_PENDSVSET_Msk = 0x10000000
	// Bit PENDSVSET.
	SCB_ICSR_PENDSVSET = 0x10000000
	// Position of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET_Pos = 0x1f
	// Bit mask of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET_Msk = 0x80000000
	// Bit NMIPENDSET.
	SCB_ICSR_NMIPENDSET = 0x80000000

	// VTOR: Vector table offset register
	// Position of TBLOFF field.
	SCB_VTOR_TBLOFF_Pos = 0x9
	// Bit mask of TBLOFF field.
	SCB_VTOR_TBLOFF_Msk = 0x3ffffe00

	// AIRCR: Application interrupt and reset control register
	// Position of VECTRESET field.
	SCB_AIRCR_VECTRESET_Pos = 0x0
	// Bit mask of VECTRESET field.
	SCB_AIRCR_VECTRESET_Msk = 0x1
	// Bit VECTRESET.
	SCB_AIRCR_VECTRESET = 0x1
	// Position of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE_Pos = 0x1
	// Bit mask of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE_Msk = 0x2
	// Bit VECTCLRACTIVE.
	SCB_AIRCR_VECTCLRACTIVE = 0x2
	// Position of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ_Pos = 0x2
	// Bit mask of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ_Msk = 0x4
	// Bit SYSRESETREQ.
	SCB_AIRCR_SYSRESETREQ = 0x4
	// Position of PRIGROUP field.
	SCB_AIRCR_PRIGROUP_Pos = 0x8
	// Bit mask of PRIGROUP field.
	SCB_AIRCR_PRIGROUP_Msk = 0x700
	// Position of ENDIANESS field.
	SCB_AIRCR_ENDIANESS_Pos = 0xf
	// Bit mask of ENDIANESS field.
	SCB_AIRCR_ENDIANESS_Msk = 0x8000
	// Bit ENDIANESS.
	SCB_AIRCR_ENDIANESS = 0x8000
	// Position of VECTKEYSTAT field.
	SCB_AIRCR_VECTKEYSTAT_Pos = 0x10
	// Bit mask of VECTKEYSTAT field.
	SCB_AIRCR_VECTKEYSTAT_Msk = 0xffff0000

	// SCR: System control register
	// Position of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT_Pos = 0x1
	// Bit mask of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT_Msk = 0x2
	// Bit SLEEPONEXIT.
	SCB_SCR_SLEEPONEXIT = 0x2
	// Position of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP_Pos = 0x2
	// Bit mask of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP_Msk = 0x4
	// Bit SLEEPDEEP.
	SCB_SCR_SLEEPDEEP = 0x4
	// Position of SEVEONPEND field.
	SCB_SCR_SEVEONPEND_Pos = 0x4
	// Bit mask of SEVEONPEND field.
	SCB_SCR_SEVEONPEND_Msk = 0x10
	// Bit SEVEONPEND.
	SCB_SCR_SEVEONPEND = 0x10

	// CCR: Configuration and control register
	// Position of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA_Pos = 0x0
	// Bit mask of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA_Msk = 0x1
	// Bit NONBASETHRDENA.
	SCB_CCR_NONBASETHRDENA = 0x1
	// Position of USERSETMPEND field.
	SCB_CCR_USERSETMPEND_Pos = 0x1
	// Bit mask of USERSETMPEND field.
	SCB_CCR_USERSETMPEND_Msk = 0x2
	// Bit USERSETMPEND.
	SCB_CCR_USERSETMPEND = 0x2
	// Position of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP_Pos = 0x3
	// Bit mask of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP_Msk = 0x8
	// Bit UNALIGN__TRP.
	SCB_CCR_UNALIGN__TRP = 0x8
	// Position of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP_Pos = 0x4
	// Bit mask of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP_Msk = 0x10
	// Bit DIV_0_TRP.
	SCB_CCR_DIV_0_TRP = 0x10
	// Position of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN_Pos = 0x8
	// Bit mask of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN_Msk = 0x100
	// Bit BFHFNMIGN.
	SCB_CCR_BFHFNMIGN = 0x100
	// Position of STKALIGN field.
	SCB_CCR_STKALIGN_Pos = 0x9
	// Bit mask of STKALIGN field.
	SCB_CCR_STKALIGN_Msk = 0x200
	// Bit STKALIGN.
	SCB_CCR_STKALIGN = 0x200

	// SHPR1: System handler priority registers
	// Position of PRI_4 field.
	SCB_SHPR1_PRI_4_Pos = 0x0
	// Bit mask of PRI_4 field.
	SCB_SHPR1_PRI_4_Msk = 0xff
	// Position of PRI_5 field.
	SCB_SHPR1_PRI_5_Pos = 0x8
	// Bit mask of PRI_5 field.
	SCB_SHPR1_PRI_5_Msk = 0xff00
	// Position of PRI_6 field.
	SCB_SHPR1_PRI_6_Pos = 0x10
	// Bit mask of PRI_6 field.
	SCB_SHPR1_PRI_6_Msk = 0xff0000

	// SHPR2: System handler priority registers
	// Position of PRI_11 field.
	SCB_SHPR2_PRI_11_Pos = 0x18
	// Bit mask of PRI_11 field.
	SCB_SHPR2_PRI_11_Msk = 0xff000000

	// SHPR3: System handler priority registers
	// Position of PRI_14 field.
	SCB_SHPR3_PRI_14_Pos = 0x10
	// Bit mask of PRI_14 field.
	SCB_SHPR3_PRI_14_Msk = 0xff0000
	// Position of PRI_15 field.
	SCB_SHPR3_PRI_15_Pos = 0x18
	// Bit mask of PRI_15 field.
	SCB_SHPR3_PRI_15_Msk = 0xff000000

	// SHCSR: System handler control and state register
	// Position of MEMFAULTACT field.
	SCB_SHCSR_MEMFAULTACT_Pos = 0x0
	// Bit mask of MEMFAULTACT field.
	SCB_SHCSR_MEMFAULTACT_Msk = 0x1
	// Bit MEMFAULTACT.
	SCB_SHCSR_MEMFAULTACT = 0x1
	// Position of BUSFAULTACT field.
	SCB_SHCSR_BUSFAULTACT_Pos = 0x1
	// Bit mask of BUSFAULTACT field.
	SCB_SHCSR_BUSFAULTACT_Msk = 0x2
	// Bit BUSFAULTACT.
	SCB_SHCSR_BUSFAULTACT = 0x2
	// Position of USGFAULTACT field.
	SCB_SHCSR_USGFAULTACT_Pos = 0x3
	// Bit mask of USGFAULTACT field.
	SCB_SHCSR_USGFAULTACT_Msk = 0x8
	// Bit USGFAULTACT.
	SCB_SHCSR_USGFAULTACT = 0x8
	// Position of SVCALLACT field.
	SCB_SHCSR_SVCALLACT_Pos = 0x7
	// Bit mask of SVCALLACT field.
	SCB_SHCSR_SVCALLACT_Msk = 0x80
	// Bit SVCALLACT.
	SCB_SHCSR_SVCALLACT = 0x80
	// Position of MONITORACT field.
	SCB_SHCSR_MONITORACT_Pos = 0x8
	// Bit mask of MONITORACT field.
	SCB_SHCSR_MONITORACT_Msk = 0x100
	// Bit MONITORACT.
	SCB_SHCSR_MONITORACT = 0x100
	// Position of PENDSVACT field.
	SCB_SHCSR_PENDSVACT_Pos = 0xa
	// Bit mask of PENDSVACT field.
	SCB_SHCSR_PENDSVACT_Msk = 0x400
	// Bit PENDSVACT.
	SCB_SHCSR_PENDSVACT = 0x400
	// Position of SYSTICKACT field.
	SCB_SHCSR_SYSTICKACT_Pos = 0xb
	// Bit mask of SYSTICKACT field.
	SCB_SHCSR_SYSTICKACT_Msk = 0x800
	// Bit SYSTICKACT.
	SCB_SHCSR_SYSTICKACT = 0x800
	// Position of USGFAULTPENDED field.
	SCB_SHCSR_USGFAULTPENDED_Pos = 0xc
	// Bit mask of USGFAULTPENDED field.
	SCB_SHCSR_USGFAULTPENDED_Msk = 0x1000
	// Bit USGFAULTPENDED.
	SCB_SHCSR_USGFAULTPENDED = 0x1000
	// Position of MEMFAULTPENDED field.
	SCB_SHCSR_MEMFAULTPENDED_Pos = 0xd
	// Bit mask of MEMFAULTPENDED field.
	SCB_SHCSR_MEMFAULTPENDED_Msk = 0x2000
	// Bit MEMFAULTPENDED.
	SCB_SHCSR_MEMFAULTPENDED = 0x2000
	// Position of BUSFAULTPENDED field.
	SCB_SHCSR_BUSFAULTPENDED_Pos = 0xe
	// Bit mask of BUSFAULTPENDED field.
	SCB_SHCSR_BUSFAULTPENDED_Msk = 0x4000
	// Bit BUSFAULTPENDED.
	SCB_SHCSR_BUSFAULTPENDED = 0x4000
	// Position of SVCALLPENDED field.
	SCB_SHCSR_SVCALLPENDED_Pos = 0xf
	// Bit mask of SVCALLPENDED field.
	SCB_SHCSR_SVCALLPENDED_Msk = 0x8000
	// Bit SVCALLPENDED.
	SCB_SHCSR_SVCALLPENDED = 0x8000
	// Position of MEMFAULTENA field.
	SCB_SHCSR_MEMFAULTENA_Pos = 0x10
	// Bit mask of MEMFAULTENA field.
	SCB_SHCSR_MEMFAULTENA_Msk = 0x10000
	// Bit MEMFAULTENA.
	SCB_SHCSR_MEMFAULTENA = 0x10000
	// Position of BUSFAULTENA field.
	SCB_SHCSR_BUSFAULTENA_Pos = 0x11
	// Bit mask of BUSFAULTENA field.
	SCB_SHCSR_BUSFAULTENA_Msk = 0x20000
	// Bit BUSFAULTENA.
	SCB_SHCSR_BUSFAULTENA = 0x20000
	// Position of USGFAULTENA field.
	SCB_SHCSR_USGFAULTENA_Pos = 0x12
	// Bit mask of USGFAULTENA field.
	SCB_SHCSR_USGFAULTENA_Msk = 0x40000
	// Bit USGFAULTENA.
	SCB_SHCSR_USGFAULTENA = 0x40000

	// CFSR_UFSR_BFSR_MMFSR: Configurable fault status register
	// Position of IACCVIOL field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL_Pos = 0x1
	// Bit mask of IACCVIOL field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL_Msk = 0x2
	// Bit IACCVIOL.
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL = 0x2
	// Position of MUNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR_Pos = 0x3
	// Bit mask of MUNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR_Msk = 0x8
	// Bit MUNSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR = 0x8
	// Position of MSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR_Pos = 0x4
	// Bit mask of MSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR_Msk = 0x10
	// Bit MSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR = 0x10
	// Position of MLSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR_Pos = 0x5
	// Bit mask of MLSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR_Msk = 0x20
	// Bit MLSPERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR = 0x20
	// Position of MMARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID_Pos = 0x7
	// Bit mask of MMARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID_Msk = 0x80
	// Bit MMARVALID.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID = 0x80
	// Position of IBUSERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR_Pos = 0x8
	// Bit mask of IBUSERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR_Msk = 0x100
	// Bit IBUSERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR = 0x100
	// Position of PRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR_Pos = 0x9
	// Bit mask of PRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR_Msk = 0x200
	// Bit PRECISERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR = 0x200
	// Position of IMPRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR_Pos = 0xa
	// Bit mask of IMPRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR_Msk = 0x400
	// Bit IMPRECISERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR = 0x400
	// Position of UNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR_Pos = 0xb
	// Bit mask of UNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR_Msk = 0x800
	// Bit UNSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR = 0x800
	// Position of STKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR_Pos = 0xc
	// Bit mask of STKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR_Msk = 0x1000
	// Bit STKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR = 0x1000
	// Position of LSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR_Pos = 0xd
	// Bit mask of LSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR_Msk = 0x2000
	// Bit LSPERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR = 0x2000
	// Position of BFARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID_Pos = 0xf
	// Bit mask of BFARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID_Msk = 0x8000
	// Bit BFARVALID.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID = 0x8000
	// Position of UNDEFINSTR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR_Pos = 0x10
	// Bit mask of UNDEFINSTR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR_Msk = 0x10000
	// Bit UNDEFINSTR.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR = 0x10000
	// Position of INVSTATE field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE_Pos = 0x11
	// Bit mask of INVSTATE field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE_Msk = 0x20000
	// Bit INVSTATE.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE = 0x20000
	// Position of INVPC field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC_Pos = 0x12
	// Bit mask of INVPC field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC_Msk = 0x40000
	// Bit INVPC.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC = 0x40000
	// Position of NOCP field.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP_Pos = 0x13
	// Bit mask of NOCP field.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP_Msk = 0x80000
	// Bit NOCP.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP = 0x80000
	// Position of UNALIGNED field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED_Pos = 0x18
	// Bit mask of UNALIGNED field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED_Msk = 0x1000000
	// Bit UNALIGNED.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED = 0x1000000
	// Position of DIVBYZERO field.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO_Pos = 0x19
	// Bit mask of DIVBYZERO field.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO_Msk = 0x2000000
	// Bit DIVBYZERO.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO = 0x2000000

	// HFSR: Hard fault status register
	// Position of VECTTBL field.
	SCB_HFSR_VECTTBL_Pos = 0x1
	// Bit mask of VECTTBL field.
	SCB_HFSR_VECTTBL_Msk = 0x2
	// Bit VECTTBL.
	SCB_HFSR_VECTTBL = 0x2
	// Position of FORCED field.
	SCB_HFSR_FORCED_Pos = 0x1e
	// Bit mask of FORCED field.
	SCB_HFSR_FORCED_Msk = 0x40000000
	// Bit FORCED.
	SCB_HFSR_FORCED = 0x40000000
	// Position of DEBUG_VT field.
	SCB_HFSR_DEBUG_VT_Pos = 0x1f
	// Bit mask of DEBUG_VT field.
	SCB_HFSR_DEBUG_VT_Msk = 0x80000000
	// Bit DEBUG_VT.
	SCB_HFSR_DEBUG_VT = 0x80000000

	// MMFAR: Memory management fault address register
	// Position of MMFAR field.
	SCB_MMFAR_MMFAR_Pos = 0x0
	// Bit mask of MMFAR field.
	SCB_MMFAR_MMFAR_Msk = 0xffffffff

	// BFAR: Bus fault address register
	// Position of BFAR field.
	SCB_BFAR_BFAR_Pos = 0x0
	// Bit mask of BFAR field.
	SCB_BFAR_BFAR_Msk = 0xffffffff

	// AFSR: Auxiliary fault status register
	// Position of IMPDEF field.
	SCB_AFSR_IMPDEF_Pos = 0x0
	// Bit mask of IMPDEF field.
	SCB_AFSR_IMPDEF_Msk = 0xffffffff
)

// Bitfields for SPI1: Serial peripheral interface/Inter-IC sound
const (
	// CR1: control register 1
	// Position of BIDIMODE field.
	SPI_CR1_BIDIMODE_Pos = 0xf
	// Bit mask of BIDIMODE field.
	SPI_CR1_BIDIMODE_Msk = 0x8000
	// Bit BIDIMODE.
	SPI_CR1_BIDIMODE = 0x8000
	// Position of BIDIOE field.
	SPI_CR1_BIDIOE_Pos = 0xe
	// Bit mask of BIDIOE field.
	SPI_CR1_BIDIOE_Msk = 0x4000
	// Bit BIDIOE.
	SPI_CR1_BIDIOE = 0x4000
	// Position of CRCEN field.
	SPI_CR1_CRCEN_Pos = 0xd
	// Bit mask of CRCEN field.
	SPI_CR1_CRCEN_Msk = 0x2000
	// Bit CRCEN.
	SPI_CR1_CRCEN = 0x2000
	// Position of CRCNEXT field.
	SPI_CR1_CRCNEXT_Pos = 0xc
	// Bit mask of CRCNEXT field.
	SPI_CR1_CRCNEXT_Msk = 0x1000
	// Bit CRCNEXT.
	SPI_CR1_CRCNEXT = 0x1000
	// Position of DFF field.
	SPI_CR1_DFF_Pos = 0xb
	// Bit mask of DFF field.
	SPI_CR1_DFF_Msk = 0x800
	// Bit DFF.
	SPI_CR1_DFF = 0x800
	// Position of RXONLY field.
	SPI_CR1_RXONLY_Pos = 0xa
	// Bit mask of RXONLY field.
	SPI_CR1_RXONLY_Msk = 0x400
	// Bit RXONLY.
	SPI_CR1_RXONLY = 0x400
	// Position of SSM field.
	SPI_CR1_SSM_Pos = 0x9
	// Bit mask of SSM field.
	SPI_CR1_SSM_Msk = 0x200
	// Bit SSM.
	SPI_CR1_SSM = 0x200
	// Position of SSI field.
	SPI_CR1_SSI_Pos = 0x8
	// Bit mask of SSI field.
	SPI_CR1_SSI_Msk = 0x100
	// Bit SSI.
	SPI_CR1_SSI = 0x100
	// Position of LSBFIRST field.
	SPI_CR1_LSBFIRST_Pos = 0x7
	// Bit mask of LSBFIRST field.
	SPI_CR1_LSBFIRST_Msk = 0x80
	// Bit LSBFIRST.
	SPI_CR1_LSBFIRST = 0x80
	// Position of SPE field.
	SPI_CR1_SPE_Pos = 0x6
	// Bit mask of SPE field.
	SPI_CR1_SPE_Msk = 0x40
	// Bit SPE.
	SPI_CR1_SPE = 0x40
	// Position of BR field.
	SPI_CR1_BR_Pos = 0x3
	// Bit mask of BR field.
	SPI_CR1_BR_Msk = 0x38
	// Position of MSTR field.
	SPI_CR1_MSTR_Pos = 0x2
	// Bit mask of MSTR field.
	SPI_CR1_MSTR_Msk = 0x4
	// Bit MSTR.
	SPI_CR1_MSTR = 0x4
	// Position of CPOL field.
	SPI_CR1_CPOL_Pos = 0x1
	// Bit mask of CPOL field.
	SPI_CR1_CPOL_Msk = 0x2
	// Bit CPOL.
	SPI_CR1_CPOL = 0x2
	// Position of CPHA field.
	SPI_CR1_CPHA_Pos = 0x0
	// Bit mask of CPHA field.
	SPI_CR1_CPHA_Msk = 0x1
	// Bit CPHA.
	SPI_CR1_CPHA = 0x1

	// CR2: control register 2
	// Position of RXDMAEN field.
	SPI_CR2_RXDMAEN_Pos = 0x0
	// Bit mask of RXDMAEN field.
	SPI_CR2_RXDMAEN_Msk = 0x1
	// Bit RXDMAEN.
	SPI_CR2_RXDMAEN = 0x1
	// Position of TXDMAEN field.
	SPI_CR2_TXDMAEN_Pos = 0x1
	// Bit mask of TXDMAEN field.
	SPI_CR2_TXDMAEN_Msk = 0x2
	// Bit TXDMAEN.
	SPI_CR2_TXDMAEN = 0x2
	// Position of SSOE field.
	SPI_CR2_SSOE_Pos = 0x2
	// Bit mask of SSOE field.
	SPI_CR2_SSOE_Msk = 0x4
	// Bit SSOE.
	SPI_CR2_SSOE = 0x4
	// Position of NSSP field.
	SPI_CR2_NSSP_Pos = 0x3
	// Bit mask of NSSP field.
	SPI_CR2_NSSP_Msk = 0x8
	// Bit NSSP.
	SPI_CR2_NSSP = 0x8
	// Position of FRF field.
	SPI_CR2_FRF_Pos = 0x4
	// Bit mask of FRF field.
	SPI_CR2_FRF_Msk = 0x10
	// Bit FRF.
	SPI_CR2_FRF = 0x10
	// Position of ERRIE field.
	SPI_CR2_ERRIE_Pos = 0x5
	// Bit mask of ERRIE field.
	SPI_CR2_ERRIE_Msk = 0x20
	// Bit ERRIE.
	SPI_CR2_ERRIE = 0x20
	// Position of RXNEIE field.
	SPI_CR2_RXNEIE_Pos = 0x6
	// Bit mask of RXNEIE field.
	SPI_CR2_RXNEIE_Msk = 0x40
	// Bit RXNEIE.
	SPI_CR2_RXNEIE = 0x40
	// Position of TXEIE field.
	SPI_CR2_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	SPI_CR2_TXEIE_Msk = 0x80
	// Bit TXEIE.
	SPI_CR2_TXEIE = 0x80
	// Position of DS field.
	SPI_CR2_DS_Pos = 0x8
	// Bit mask of DS field.
	SPI_CR2_DS_Msk = 0xf00
	// Position of FRXTH field.
	SPI_CR2_FRXTH_Pos = 0xc
	// Bit mask of FRXTH field.
	SPI_CR2_FRXTH_Msk = 0x1000
	// Bit FRXTH.
	SPI_CR2_FRXTH = 0x1000
	// Position of LDMA_RX field.
	SPI_CR2_LDMA_RX_Pos = 0xd
	// Bit mask of LDMA_RX field.
	SPI_CR2_LDMA_RX_Msk = 0x2000
	// Bit LDMA_RX.
	SPI_CR2_LDMA_RX = 0x2000
	// Position of LDMA_TX field.
	SPI_CR2_LDMA_TX_Pos = 0xe
	// Bit mask of LDMA_TX field.
	SPI_CR2_LDMA_TX_Msk = 0x4000
	// Bit LDMA_TX.
	SPI_CR2_LDMA_TX = 0x4000

	// SR: status register
	// Position of RXNE field.
	SPI_SR_RXNE_Pos = 0x0
	// Bit mask of RXNE field.
	SPI_SR_RXNE_Msk = 0x1
	// Bit RXNE.
	SPI_SR_RXNE = 0x1
	// Position of TXE field.
	SPI_SR_TXE_Pos = 0x1
	// Bit mask of TXE field.
	SPI_SR_TXE_Msk = 0x2
	// Bit TXE.
	SPI_SR_TXE = 0x2
	// Position of CHSIDE field.
	SPI_SR_CHSIDE_Pos = 0x2
	// Bit mask of CHSIDE field.
	SPI_SR_CHSIDE_Msk = 0x4
	// Bit CHSIDE.
	SPI_SR_CHSIDE = 0x4
	// Position of UDR field.
	SPI_SR_UDR_Pos = 0x3
	// Bit mask of UDR field.
	SPI_SR_UDR_Msk = 0x8
	// Bit UDR.
	SPI_SR_UDR = 0x8
	// Position of CRCERR field.
	SPI_SR_CRCERR_Pos = 0x4
	// Bit mask of CRCERR field.
	SPI_SR_CRCERR_Msk = 0x10
	// Bit CRCERR.
	SPI_SR_CRCERR = 0x10
	// Position of MODF field.
	SPI_SR_MODF_Pos = 0x5
	// Bit mask of MODF field.
	SPI_SR_MODF_Msk = 0x20
	// Bit MODF.
	SPI_SR_MODF = 0x20
	// Position of OVR field.
	SPI_SR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	SPI_SR_OVR_Msk = 0x40
	// Bit OVR.
	SPI_SR_OVR = 0x40
	// Position of BSY field.
	SPI_SR_BSY_Pos = 0x7
	// Bit mask of BSY field.
	SPI_SR_BSY_Msk = 0x80
	// Bit BSY.
	SPI_SR_BSY = 0x80
	// Position of TIFRFE field.
	SPI_SR_TIFRFE_Pos = 0x8
	// Bit mask of TIFRFE field.
	SPI_SR_TIFRFE_Msk = 0x100
	// Bit TIFRFE.
	SPI_SR_TIFRFE = 0x100
	// Position of FRLVL field.
	SPI_SR_FRLVL_Pos = 0x9
	// Bit mask of FRLVL field.
	SPI_SR_FRLVL_Msk = 0x600
	// Position of FTLVL field.
	SPI_SR_FTLVL_Pos = 0xb
	// Bit mask of FTLVL field.
	SPI_SR_FTLVL_Msk = 0x1800

	// DR: data register
	// Position of DR field.
	SPI_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	SPI_DR_DR_Msk = 0xffff

	// CRCPR: CRC polynomial register
	// Position of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Pos = 0x0
	// Bit mask of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Msk = 0xffff

	// RXCRCR: RX CRC register
	// Position of RxCRC field.
	SPI_RXCRCR_RxCRC_Pos = 0x0
	// Bit mask of RxCRC field.
	SPI_RXCRCR_RxCRC_Msk = 0xffff

	// TXCRCR: TX CRC register
	// Position of TxCRC field.
	SPI_TXCRCR_TxCRC_Pos = 0x0
	// Bit mask of TxCRC field.
	SPI_TXCRCR_TxCRC_Msk = 0xffff

	// I2SCFGR: configuration register
	// Position of CHLEN field.
	SPI_I2SCFGR_CHLEN_Pos = 0x0
	// Bit mask of CHLEN field.
	SPI_I2SCFGR_CHLEN_Msk = 0x1
	// Bit CHLEN.
	SPI_I2SCFGR_CHLEN = 0x1
	// Position of DATLEN field.
	SPI_I2SCFGR_DATLEN_Pos = 0x1
	// Bit mask of DATLEN field.
	SPI_I2SCFGR_DATLEN_Msk = 0x6
	// Position of CKPOL field.
	SPI_I2SCFGR_CKPOL_Pos = 0x3
	// Bit mask of CKPOL field.
	SPI_I2SCFGR_CKPOL_Msk = 0x8
	// Bit CKPOL.
	SPI_I2SCFGR_CKPOL = 0x8
	// Position of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Pos = 0x4
	// Bit mask of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Msk = 0x30
	// Position of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Pos = 0x7
	// Bit mask of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Msk = 0x80
	// Bit PCMSYNC.
	SPI_I2SCFGR_PCMSYNC = 0x80
	// Position of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Pos = 0x8
	// Bit mask of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Msk = 0x300
	// Position of I2SE field.
	SPI_I2SCFGR_I2SE_Pos = 0xa
	// Bit mask of I2SE field.
	SPI_I2SCFGR_I2SE_Msk = 0x400
	// Bit I2SE.
	SPI_I2SCFGR_I2SE = 0x400
	// Position of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Pos = 0xb
	// Bit mask of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Msk = 0x800
	// Bit I2SMOD.
	SPI_I2SCFGR_I2SMOD = 0x800
	// Position of ASTRTEN field.
	SPI_I2SCFGR_ASTRTEN_Pos = 0xc
	// Bit mask of ASTRTEN field.
	SPI_I2SCFGR_ASTRTEN_Msk = 0x1000
	// Bit ASTRTEN.
	SPI_I2SCFGR_ASTRTEN = 0x1000

	// I2SPR: prescaler register
	// Position of I2SDIV field.
	SPI_I2SPR_I2SDIV_Pos = 0x0
	// Bit mask of I2SDIV field.
	SPI_I2SPR_I2SDIV_Msk = 0xff
	// Position of ODD field.
	SPI_I2SPR_ODD_Pos = 0x8
	// Bit mask of ODD field.
	SPI_I2SPR_ODD_Msk = 0x100
	// Bit ODD.
	SPI_I2SPR_ODD = 0x100
	// Position of MCKOE field.
	SPI_I2SPR_MCKOE_Pos = 0x9
	// Bit mask of MCKOE field.
	SPI_I2SPR_MCKOE_Msk = 0x200
	// Bit MCKOE.
	SPI_I2SPR_MCKOE = 0x200
)

// Bitfields for STK: SysTick timer
const (
	// CTRL: SysTick control and status register
	// Position of ENABLE field.
	STK_CTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	STK_CTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	STK_CTRL_ENABLE = 0x1
	// Position of TICKINT field.
	STK_CTRL_TICKINT_Pos = 0x1
	// Bit mask of TICKINT field.
	STK_CTRL_TICKINT_Msk = 0x2
	// Bit TICKINT.
	STK_CTRL_TICKINT = 0x2
	// Position of CLKSOURCE field.
	STK_CTRL_CLKSOURCE_Pos = 0x2
	// Bit mask of CLKSOURCE field.
	STK_CTRL_CLKSOURCE_Msk = 0x4
	// Bit CLKSOURCE.
	STK_CTRL_CLKSOURCE = 0x4
	// Position of COUNTFLAG field.
	STK_CTRL_COUNTFLAG_Pos = 0x10
	// Bit mask of COUNTFLAG field.
	STK_CTRL_COUNTFLAG_Msk = 0x10000
	// Bit COUNTFLAG.
	STK_CTRL_COUNTFLAG = 0x10000

	// LOAD: SysTick reload value register
	// Position of RELOAD field.
	STK_LOAD_RELOAD_Pos = 0x0
	// Bit mask of RELOAD field.
	STK_LOAD_RELOAD_Msk = 0xffffff

	// VAL: SysTick current value register
	// Position of CURRENT field.
	STK_VAL_CURRENT_Pos = 0x0
	// Bit mask of CURRENT field.
	STK_VAL_CURRENT_Msk = 0xffffff

	// CALIB: SysTick calibration value register
	// Position of TENMS field.
	STK_CALIB_TENMS_Pos = 0x0
	// Bit mask of TENMS field.
	STK_CALIB_TENMS_Msk = 0xffffff
	// Position of SKEW field.
	STK_CALIB_SKEW_Pos = 0x1e
	// Bit mask of SKEW field.
	STK_CALIB_SKEW_Msk = 0x40000000
	// Bit SKEW.
	STK_CALIB_SKEW = 0x40000000
	// Position of NOREF field.
	STK_CALIB_NOREF_Pos = 0x1f
	// Bit mask of NOREF field.
	STK_CALIB_NOREF_Msk = 0x80000000
	// Bit NOREF.
	STK_CALIB_NOREF = 0x80000000
)

// Bitfields for SYSCFG: System configuration controller
const (
	// MEMRMP: memory remap register
	// Position of MEM_MODE field.
	SYSCFG_MEMRMP_MEM_MODE_Pos = 0x0
	// Bit mask of MEM_MODE field.
	SYSCFG_MEMRMP_MEM_MODE_Msk = 0x7

	// CFGR1: configuration register 1
	// Position of I2C3_FMP field.
	SYSCFG_CFGR1_I2C3_FMP_Pos = 0x16
	// Bit mask of I2C3_FMP field.
	SYSCFG_CFGR1_I2C3_FMP_Msk = 0x400000
	// Bit I2C3_FMP.
	SYSCFG_CFGR1_I2C3_FMP = 0x400000
	// Position of I2C2_FMP field.
	SYSCFG_CFGR1_I2C2_FMP_Pos = 0x15
	// Bit mask of I2C2_FMP field.
	SYSCFG_CFGR1_I2C2_FMP_Msk = 0x200000
	// Bit I2C2_FMP.
	SYSCFG_CFGR1_I2C2_FMP = 0x200000
	// Position of I2C1_FMP field.
	SYSCFG_CFGR1_I2C1_FMP_Pos = 0x14
	// Bit mask of I2C1_FMP field.
	SYSCFG_CFGR1_I2C1_FMP_Msk = 0x100000
	// Bit I2C1_FMP.
	SYSCFG_CFGR1_I2C1_FMP = 0x100000
	// Position of I2C_PB9_FMP field.
	SYSCFG_CFGR1_I2C_PB9_FMP_Pos = 0x13
	// Bit mask of I2C_PB9_FMP field.
	SYSCFG_CFGR1_I2C_PB9_FMP_Msk = 0x80000
	// Bit I2C_PB9_FMP.
	SYSCFG_CFGR1_I2C_PB9_FMP = 0x80000
	// Position of I2C_PB8_FMP field.
	SYSCFG_CFGR1_I2C_PB8_FMP_Pos = 0x12
	// Bit mask of I2C_PB8_FMP field.
	SYSCFG_CFGR1_I2C_PB8_FMP_Msk = 0x40000
	// Bit I2C_PB8_FMP.
	SYSCFG_CFGR1_I2C_PB8_FMP = 0x40000
	// Position of I2C_PB7_FMP field.
	SYSCFG_CFGR1_I2C_PB7_FMP_Pos = 0x11
	// Bit mask of I2C_PB7_FMP field.
	SYSCFG_CFGR1_I2C_PB7_FMP_Msk = 0x20000
	// Bit I2C_PB7_FMP.
	SYSCFG_CFGR1_I2C_PB7_FMP = 0x20000
	// Position of I2C_PB6_FMP field.
	SYSCFG_CFGR1_I2C_PB6_FMP_Pos = 0x10
	// Bit mask of I2C_PB6_FMP field.
	SYSCFG_CFGR1_I2C_PB6_FMP_Msk = 0x10000
	// Bit I2C_PB6_FMP.
	SYSCFG_CFGR1_I2C_PB6_FMP = 0x10000
	// Position of BOOSTEN field.
	SYSCFG_CFGR1_BOOSTEN_Pos = 0x8
	// Bit mask of BOOSTEN field.
	SYSCFG_CFGR1_BOOSTEN_Msk = 0x100
	// Bit BOOSTEN.
	SYSCFG_CFGR1_BOOSTEN = 0x100

	// EXTICR1: external interrupt configuration register 1
	// Position of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Pos = 0xc
	// Bit mask of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Msk = 0x7000
	// Position of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Pos = 0x8
	// Bit mask of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Msk = 0x700
	// Position of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Pos = 0x4
	// Bit mask of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Msk = 0x70
	// Position of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Pos = 0x0
	// Bit mask of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Msk = 0x7

	// EXTICR2: external interrupt configuration register 2
	// Position of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Pos = 0xc
	// Bit mask of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Msk = 0x7000
	// Position of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Pos = 0x8
	// Bit mask of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Msk = 0x700
	// Position of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Pos = 0x4
	// Bit mask of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Msk = 0x70
	// Position of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Pos = 0x0
	// Bit mask of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Msk = 0x7

	// EXTICR3: external interrupt configuration register 3
	// Position of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Pos = 0xc
	// Bit mask of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Msk = 0x7000
	// Position of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Pos = 0x8
	// Bit mask of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Msk = 0x700
	// Position of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Pos = 0x4
	// Bit mask of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Msk = 0x70
	// Position of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Pos = 0x0
	// Bit mask of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Msk = 0x7

	// EXTICR4: external interrupt configuration register 4
	// Position of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Pos = 0xc
	// Bit mask of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Msk = 0x7000
	// Position of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Pos = 0x8
	// Bit mask of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Msk = 0x700
	// Position of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Pos = 0x4
	// Bit mask of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Msk = 0x70
	// Position of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Pos = 0x0
	// Bit mask of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Msk = 0x7

	// SCSR: SCSR
	// Position of PKASRAMBSY field.
	SYSCFG_SCSR_PKASRAMBSY_Pos = 0x8
	// Bit mask of PKASRAMBSY field.
	SYSCFG_SCSR_PKASRAMBSY_Msk = 0x100
	// Bit PKASRAMBSY.
	SYSCFG_SCSR_PKASRAMBSY = 0x100
	// Position of SRAMBSY field.
	SYSCFG_SCSR_SRAMBSY_Pos = 0x1
	// Bit mask of SRAMBSY field.
	SYSCFG_SCSR_SRAMBSY_Msk = 0x2
	// Bit SRAMBSY.
	SYSCFG_SCSR_SRAMBSY = 0x2
	// Position of SRAM2ER field.
	SYSCFG_SCSR_SRAM2ER_Pos = 0x0
	// Bit mask of SRAM2ER field.
	SYSCFG_SCSR_SRAM2ER_Msk = 0x1
	// Bit SRAM2ER.
	SYSCFG_SCSR_SRAM2ER = 0x1

	// CFGR2: CFGR2
	// Position of SPF field.
	SYSCFG_CFGR2_SPF_Pos = 0x8
	// Bit mask of SPF field.
	SYSCFG_CFGR2_SPF_Msk = 0x100
	// Bit SPF.
	SYSCFG_CFGR2_SPF = 0x100
	// Position of ECCL field.
	SYSCFG_CFGR2_ECCL_Pos = 0x3
	// Bit mask of ECCL field.
	SYSCFG_CFGR2_ECCL_Msk = 0x8
	// Bit ECCL.
	SYSCFG_CFGR2_ECCL = 0x8
	// Position of PVDL field.
	SYSCFG_CFGR2_PVDL_Pos = 0x2
	// Bit mask of PVDL field.
	SYSCFG_CFGR2_PVDL_Msk = 0x4
	// Bit PVDL.
	SYSCFG_CFGR2_PVDL = 0x4
	// Position of SPL field.
	SYSCFG_CFGR2_SPL_Pos = 0x1
	// Bit mask of SPL field.
	SYSCFG_CFGR2_SPL_Msk = 0x2
	// Bit SPL.
	SYSCFG_CFGR2_SPL = 0x2
	// Position of CLL field.
	SYSCFG_CFGR2_CLL_Pos = 0x0
	// Bit mask of CLL field.
	SYSCFG_CFGR2_CLL_Msk = 0x1
	// Bit CLL.
	SYSCFG_CFGR2_CLL = 0x1

	// SWPR: SWPR
	// Position of P31WP field.
	SYSCFG_SWPR_P31WP_Pos = 0x1f
	// Bit mask of P31WP field.
	SYSCFG_SWPR_P31WP_Msk = 0x80000000
	// Bit P31WP.
	SYSCFG_SWPR_P31WP = 0x80000000
	// Position of P30WP field.
	SYSCFG_SWPR_P30WP_Pos = 0x1e
	// Bit mask of P30WP field.
	SYSCFG_SWPR_P30WP_Msk = 0x40000000
	// Bit P30WP.
	SYSCFG_SWPR_P30WP = 0x40000000
	// Position of P29WP field.
	SYSCFG_SWPR_P29WP_Pos = 0x1d
	// Bit mask of P29WP field.
	SYSCFG_SWPR_P29WP_Msk = 0x20000000
	// Bit P29WP.
	SYSCFG_SWPR_P29WP = 0x20000000
	// Position of P28WP field.
	SYSCFG_SWPR_P28WP_Pos = 0x1c
	// Bit mask of P28WP field.
	SYSCFG_SWPR_P28WP_Msk = 0x10000000
	// Bit P28WP.
	SYSCFG_SWPR_P28WP = 0x10000000
	// Position of P27WP field.
	SYSCFG_SWPR_P27WP_Pos = 0x1b
	// Bit mask of P27WP field.
	SYSCFG_SWPR_P27WP_Msk = 0x8000000
	// Bit P27WP.
	SYSCFG_SWPR_P27WP = 0x8000000
	// Position of P26WP field.
	SYSCFG_SWPR_P26WP_Pos = 0x1a
	// Bit mask of P26WP field.
	SYSCFG_SWPR_P26WP_Msk = 0x4000000
	// Bit P26WP.
	SYSCFG_SWPR_P26WP = 0x4000000
	// Position of P25WP field.
	SYSCFG_SWPR_P25WP_Pos = 0x19
	// Bit mask of P25WP field.
	SYSCFG_SWPR_P25WP_Msk = 0x2000000
	// Bit P25WP.
	SYSCFG_SWPR_P25WP = 0x2000000
	// Position of P24WP field.
	SYSCFG_SWPR_P24WP_Pos = 0x18
	// Bit mask of P24WP field.
	SYSCFG_SWPR_P24WP_Msk = 0x1000000
	// Bit P24WP.
	SYSCFG_SWPR_P24WP = 0x1000000
	// Position of P23WP field.
	SYSCFG_SWPR_P23WP_Pos = 0x17
	// Bit mask of P23WP field.
	SYSCFG_SWPR_P23WP_Msk = 0x800000
	// Bit P23WP.
	SYSCFG_SWPR_P23WP = 0x800000
	// Position of P22WP field.
	SYSCFG_SWPR_P22WP_Pos = 0x16
	// Bit mask of P22WP field.
	SYSCFG_SWPR_P22WP_Msk = 0x400000
	// Bit P22WP.
	SYSCFG_SWPR_P22WP = 0x400000
	// Position of P21WP field.
	SYSCFG_SWPR_P21WP_Pos = 0x15
	// Bit mask of P21WP field.
	SYSCFG_SWPR_P21WP_Msk = 0x200000
	// Bit P21WP.
	SYSCFG_SWPR_P21WP = 0x200000
	// Position of P20WP field.
	SYSCFG_SWPR_P20WP_Pos = 0x14
	// Bit mask of P20WP field.
	SYSCFG_SWPR_P20WP_Msk = 0x100000
	// Bit P20WP.
	SYSCFG_SWPR_P20WP = 0x100000
	// Position of P19WP field.
	SYSCFG_SWPR_P19WP_Pos = 0x13
	// Bit mask of P19WP field.
	SYSCFG_SWPR_P19WP_Msk = 0x80000
	// Bit P19WP.
	SYSCFG_SWPR_P19WP = 0x80000
	// Position of P18WP field.
	SYSCFG_SWPR_P18WP_Pos = 0x12
	// Bit mask of P18WP field.
	SYSCFG_SWPR_P18WP_Msk = 0x40000
	// Bit P18WP.
	SYSCFG_SWPR_P18WP = 0x40000
	// Position of P17WP field.
	SYSCFG_SWPR_P17WP_Pos = 0x11
	// Bit mask of P17WP field.
	SYSCFG_SWPR_P17WP_Msk = 0x20000
	// Bit P17WP.
	SYSCFG_SWPR_P17WP = 0x20000
	// Position of P16WP field.
	SYSCFG_SWPR_P16WP_Pos = 0x10
	// Bit mask of P16WP field.
	SYSCFG_SWPR_P16WP_Msk = 0x10000
	// Bit P16WP.
	SYSCFG_SWPR_P16WP = 0x10000
	// Position of P15WP field.
	SYSCFG_SWPR_P15WP_Pos = 0xf
	// Bit mask of P15WP field.
	SYSCFG_SWPR_P15WP_Msk = 0x8000
	// Bit P15WP.
	SYSCFG_SWPR_P15WP = 0x8000
	// Position of P14WP field.
	SYSCFG_SWPR_P14WP_Pos = 0xe
	// Bit mask of P14WP field.
	SYSCFG_SWPR_P14WP_Msk = 0x4000
	// Bit P14WP.
	SYSCFG_SWPR_P14WP = 0x4000
	// Position of P13WP field.
	SYSCFG_SWPR_P13WP_Pos = 0xd
	// Bit mask of P13WP field.
	SYSCFG_SWPR_P13WP_Msk = 0x2000
	// Bit P13WP.
	SYSCFG_SWPR_P13WP = 0x2000
	// Position of P12WP field.
	SYSCFG_SWPR_P12WP_Pos = 0xc
	// Bit mask of P12WP field.
	SYSCFG_SWPR_P12WP_Msk = 0x1000
	// Bit P12WP.
	SYSCFG_SWPR_P12WP = 0x1000
	// Position of P11WP field.
	SYSCFG_SWPR_P11WP_Pos = 0xb
	// Bit mask of P11WP field.
	SYSCFG_SWPR_P11WP_Msk = 0x800
	// Bit P11WP.
	SYSCFG_SWPR_P11WP = 0x800
	// Position of P10WP field.
	SYSCFG_SWPR_P10WP_Pos = 0xa
	// Bit mask of P10WP field.
	SYSCFG_SWPR_P10WP_Msk = 0x400
	// Bit P10WP.
	SYSCFG_SWPR_P10WP = 0x400
	// Position of P9WP field.
	SYSCFG_SWPR_P9WP_Pos = 0x9
	// Bit mask of P9WP field.
	SYSCFG_SWPR_P9WP_Msk = 0x200
	// Bit P9WP.
	SYSCFG_SWPR_P9WP = 0x200
	// Position of P8WP field.
	SYSCFG_SWPR_P8WP_Pos = 0x8
	// Bit mask of P8WP field.
	SYSCFG_SWPR_P8WP_Msk = 0x100
	// Bit P8WP.
	SYSCFG_SWPR_P8WP = 0x100
	// Position of P7WP field.
	SYSCFG_SWPR_P7WP_Pos = 0x7
	// Bit mask of P7WP field.
	SYSCFG_SWPR_P7WP_Msk = 0x80
	// Bit P7WP.
	SYSCFG_SWPR_P7WP = 0x80
	// Position of P6WP field.
	SYSCFG_SWPR_P6WP_Pos = 0x6
	// Bit mask of P6WP field.
	SYSCFG_SWPR_P6WP_Msk = 0x40
	// Bit P6WP.
	SYSCFG_SWPR_P6WP = 0x40
	// Position of P5WP field.
	SYSCFG_SWPR_P5WP_Pos = 0x5
	// Bit mask of P5WP field.
	SYSCFG_SWPR_P5WP_Msk = 0x20
	// Bit P5WP.
	SYSCFG_SWPR_P5WP = 0x20
	// Position of P4WP field.
	SYSCFG_SWPR_P4WP_Pos = 0x4
	// Bit mask of P4WP field.
	SYSCFG_SWPR_P4WP_Msk = 0x10
	// Bit P4WP.
	SYSCFG_SWPR_P4WP = 0x10
	// Position of P3WP field.
	SYSCFG_SWPR_P3WP_Pos = 0x3
	// Bit mask of P3WP field.
	SYSCFG_SWPR_P3WP_Msk = 0x8
	// Bit P3WP.
	SYSCFG_SWPR_P3WP = 0x8
	// Position of P2WP field.
	SYSCFG_SWPR_P2WP_Pos = 0x2
	// Bit mask of P2WP field.
	SYSCFG_SWPR_P2WP_Msk = 0x4
	// Bit P2WP.
	SYSCFG_SWPR_P2WP = 0x4
	// Position of P1WP field.
	SYSCFG_SWPR_P1WP_Pos = 0x1
	// Bit mask of P1WP field.
	SYSCFG_SWPR_P1WP_Msk = 0x2
	// Bit P1WP.
	SYSCFG_SWPR_P1WP = 0x2
	// Position of P0WP field.
	SYSCFG_SWPR_P0WP_Pos = 0x0
	// Bit mask of P0WP field.
	SYSCFG_SWPR_P0WP_Msk = 0x1
	// Bit P0WP.
	SYSCFG_SWPR_P0WP = 0x1

	// SKR: SKR
	// Position of KEY field.
	SYSCFG_SKR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	SYSCFG_SKR_KEY_Msk = 0xff

	// IMR1: SYSCFG CPU1 interrupt mask register 1
	// Position of RTCSTAMPTAMPLSECSSIM field.
	SYSCFG_IMR1_RTCSTAMPTAMPLSECSSIM_Pos = 0x0
	// Bit mask of RTCSTAMPTAMPLSECSSIM field.
	SYSCFG_IMR1_RTCSTAMPTAMPLSECSSIM_Msk = 0x1
	// Bit RTCSTAMPTAMPLSECSSIM.
	SYSCFG_IMR1_RTCSTAMPTAMPLSECSSIM = 0x1
	// Position of RTCSSRUIM field.
	SYSCFG_IMR1_RTCSSRUIM_Pos = 0x2
	// Bit mask of RTCSSRUIM field.
	SYSCFG_IMR1_RTCSSRUIM_Msk = 0x4
	// Bit RTCSSRUIM.
	SYSCFG_IMR1_RTCSSRUIM = 0x4
	// Position of EXTI5IM field.
	SYSCFG_IMR1_EXTI5IM_Pos = 0x15
	// Bit mask of EXTI5IM field.
	SYSCFG_IMR1_EXTI5IM_Msk = 0x200000
	// Bit EXTI5IM.
	SYSCFG_IMR1_EXTI5IM = 0x200000
	// Position of EXTI6IM field.
	SYSCFG_IMR1_EXTI6IM_Pos = 0x16
	// Bit mask of EXTI6IM field.
	SYSCFG_IMR1_EXTI6IM_Msk = 0x400000
	// Bit EXTI6IM.
	SYSCFG_IMR1_EXTI6IM = 0x400000
	// Position of EXTI7IM field.
	SYSCFG_IMR1_EXTI7IM_Pos = 0x17
	// Bit mask of EXTI7IM field.
	SYSCFG_IMR1_EXTI7IM_Msk = 0x800000
	// Bit EXTI7IM.
	SYSCFG_IMR1_EXTI7IM = 0x800000
	// Position of EXTI8IM field.
	SYSCFG_IMR1_EXTI8IM_Pos = 0x18
	// Bit mask of EXTI8IM field.
	SYSCFG_IMR1_EXTI8IM_Msk = 0x1000000
	// Bit EXTI8IM.
	SYSCFG_IMR1_EXTI8IM = 0x1000000
	// Position of EXTI9IM field.
	SYSCFG_IMR1_EXTI9IM_Pos = 0x19
	// Bit mask of EXTI9IM field.
	SYSCFG_IMR1_EXTI9IM_Msk = 0x2000000
	// Bit EXTI9IM.
	SYSCFG_IMR1_EXTI9IM = 0x2000000
	// Position of EXTI10IM field.
	SYSCFG_IMR1_EXTI10IM_Pos = 0x1a
	// Bit mask of EXTI10IM field.
	SYSCFG_IMR1_EXTI10IM_Msk = 0x4000000
	// Bit EXTI10IM.
	SYSCFG_IMR1_EXTI10IM = 0x4000000
	// Position of EXTI11IM field.
	SYSCFG_IMR1_EXTI11IM_Pos = 0x1b
	// Bit mask of EXTI11IM field.
	SYSCFG_IMR1_EXTI11IM_Msk = 0x8000000
	// Bit EXTI11IM.
	SYSCFG_IMR1_EXTI11IM = 0x8000000
	// Position of EXTI12IM field.
	SYSCFG_IMR1_EXTI12IM_Pos = 0x1c
	// Bit mask of EXTI12IM field.
	SYSCFG_IMR1_EXTI12IM_Msk = 0x10000000
	// Bit EXTI12IM.
	SYSCFG_IMR1_EXTI12IM = 0x10000000
	// Position of EXTI13IM field.
	SYSCFG_IMR1_EXTI13IM_Pos = 0x1d
	// Bit mask of EXTI13IM field.
	SYSCFG_IMR1_EXTI13IM_Msk = 0x20000000
	// Bit EXTI13IM.
	SYSCFG_IMR1_EXTI13IM = 0x20000000
	// Position of EXTI14IM field.
	SYSCFG_IMR1_EXTI14IM_Pos = 0x1e
	// Bit mask of EXTI14IM field.
	SYSCFG_IMR1_EXTI14IM_Msk = 0x40000000
	// Bit EXTI14IM.
	SYSCFG_IMR1_EXTI14IM = 0x40000000
	// Position of EXTI15IM field.
	SYSCFG_IMR1_EXTI15IM_Pos = 0x1f
	// Bit mask of EXTI15IM field.
	SYSCFG_IMR1_EXTI15IM_Msk = 0x80000000
	// Bit EXTI15IM.
	SYSCFG_IMR1_EXTI15IM = 0x80000000

	// IMR2: SYSCFG CPU1 interrupt mask register 2
	// Position of PVM3IM field.
	SYSCFG_IMR2_PVM3IM_Pos = 0x12
	// Bit mask of PVM3IM field.
	SYSCFG_IMR2_PVM3IM_Msk = 0x40000
	// Bit PVM3IM.
	SYSCFG_IMR2_PVM3IM = 0x40000
	// Position of PVDIM field.
	SYSCFG_IMR2_PVDIM_Pos = 0x14
	// Bit mask of PVDIM field.
	SYSCFG_IMR2_PVDIM_Msk = 0x100000
	// Bit PVDIM.
	SYSCFG_IMR2_PVDIM = 0x100000

	// C2IMR1: SYSCFG CPU2 interrupt mask register 1
	// Position of RTCSTAMPTAMPLSECSSIM field.
	SYSCFG_C2IMR1_RTCSTAMPTAMPLSECSSIM_Pos = 0x0
	// Bit mask of RTCSTAMPTAMPLSECSSIM field.
	SYSCFG_C2IMR1_RTCSTAMPTAMPLSECSSIM_Msk = 0x1
	// Bit RTCSTAMPTAMPLSECSSIM.
	SYSCFG_C2IMR1_RTCSTAMPTAMPLSECSSIM = 0x1
	// Position of RTCALARMIM field.
	SYSCFG_C2IMR1_RTCALARMIM_Pos = 0x1
	// Bit mask of RTCALARMIM field.
	SYSCFG_C2IMR1_RTCALARMIM_Msk = 0x2
	// Bit RTCALARMIM.
	SYSCFG_C2IMR1_RTCALARMIM = 0x2
	// Position of RTCSSRUIM field.
	SYSCFG_C2IMR1_RTCSSRUIM_Pos = 0x2
	// Bit mask of RTCSSRUIM field.
	SYSCFG_C2IMR1_RTCSSRUIM_Msk = 0x4
	// Bit RTCSSRUIM.
	SYSCFG_C2IMR1_RTCSSRUIM = 0x4
	// Position of RTCWKUPIM field.
	SYSCFG_C2IMR1_RTCWKUPIM_Pos = 0x3
	// Bit mask of RTCWKUPIM field.
	SYSCFG_C2IMR1_RTCWKUPIM_Msk = 0x8
	// Bit RTCWKUPIM.
	SYSCFG_C2IMR1_RTCWKUPIM = 0x8
	// Position of RCCIM field.
	SYSCFG_C2IMR1_RCCIM_Pos = 0x5
	// Bit mask of RCCIM field.
	SYSCFG_C2IMR1_RCCIM_Msk = 0x20
	// Bit RCCIM.
	SYSCFG_C2IMR1_RCCIM = 0x20
	// Position of FLASHIM field.
	SYSCFG_C2IMR1_FLASHIM_Pos = 0x6
	// Bit mask of FLASHIM field.
	SYSCFG_C2IMR1_FLASHIM_Msk = 0x40
	// Bit FLASHIM.
	SYSCFG_C2IMR1_FLASHIM = 0x40
	// Position of PKAIM field.
	SYSCFG_C2IMR1_PKAIM_Pos = 0x8
	// Bit mask of PKAIM field.
	SYSCFG_C2IMR1_PKAIM_Msk = 0x100
	// Bit PKAIM.
	SYSCFG_C2IMR1_PKAIM = 0x100
	// Position of AESIM field.
	SYSCFG_C2IMR1_AESIM_Pos = 0xa
	// Bit mask of AESIM field.
	SYSCFG_C2IMR1_AESIM_Msk = 0x400
	// Bit AESIM.
	SYSCFG_C2IMR1_AESIM = 0x400
	// Position of COMPIM field.
	SYSCFG_C2IMR1_COMPIM_Pos = 0xb
	// Bit mask of COMPIM field.
	SYSCFG_C2IMR1_COMPIM_Msk = 0x800
	// Bit COMPIM.
	SYSCFG_C2IMR1_COMPIM = 0x800
	// Position of ADCIM field.
	SYSCFG_C2IMR1_ADCIM_Pos = 0xc
	// Bit mask of ADCIM field.
	SYSCFG_C2IMR1_ADCIM_Msk = 0x1000
	// Bit ADCIM.
	SYSCFG_C2IMR1_ADCIM = 0x1000
	// Position of DACIM field.
	SYSCFG_C2IMR1_DACIM_Pos = 0xd
	// Bit mask of DACIM field.
	SYSCFG_C2IMR1_DACIM_Msk = 0x2000
	// Bit DACIM.
	SYSCFG_C2IMR1_DACIM = 0x2000
	// Position of EXTI0IM field.
	SYSCFG_C2IMR1_EXTI0IM_Pos = 0x10
	// Bit mask of EXTI0IM field.
	SYSCFG_C2IMR1_EXTI0IM_Msk = 0x10000
	// Bit EXTI0IM.
	SYSCFG_C2IMR1_EXTI0IM = 0x10000
	// Position of EXTI1IM field.
	SYSCFG_C2IMR1_EXTI1IM_Pos = 0x11
	// Bit mask of EXTI1IM field.
	SYSCFG_C2IMR1_EXTI1IM_Msk = 0x20000
	// Bit EXTI1IM.
	SYSCFG_C2IMR1_EXTI1IM = 0x20000
	// Position of EXTI2IM field.
	SYSCFG_C2IMR1_EXTI2IM_Pos = 0x12
	// Bit mask of EXTI2IM field.
	SYSCFG_C2IMR1_EXTI2IM_Msk = 0x40000
	// Bit EXTI2IM.
	SYSCFG_C2IMR1_EXTI2IM = 0x40000
	// Position of EXTI3IM field.
	SYSCFG_C2IMR1_EXTI3IM_Pos = 0x13
	// Bit mask of EXTI3IM field.
	SYSCFG_C2IMR1_EXTI3IM_Msk = 0x80000
	// Bit EXTI3IM.
	SYSCFG_C2IMR1_EXTI3IM = 0x80000
	// Position of EXTI4IM field.
	SYSCFG_C2IMR1_EXTI4IM_Pos = 0x14
	// Bit mask of EXTI4IM field.
	SYSCFG_C2IMR1_EXTI4IM_Msk = 0x100000
	// Bit EXTI4IM.
	SYSCFG_C2IMR1_EXTI4IM = 0x100000
	// Position of EXTI5IM field.
	SYSCFG_C2IMR1_EXTI5IM_Pos = 0x15
	// Bit mask of EXTI5IM field.
	SYSCFG_C2IMR1_EXTI5IM_Msk = 0x200000
	// Bit EXTI5IM.
	SYSCFG_C2IMR1_EXTI5IM = 0x200000
	// Position of EXTI6IM field.
	SYSCFG_C2IMR1_EXTI6IM_Pos = 0x16
	// Bit mask of EXTI6IM field.
	SYSCFG_C2IMR1_EXTI6IM_Msk = 0x400000
	// Bit EXTI6IM.
	SYSCFG_C2IMR1_EXTI6IM = 0x400000
	// Position of EXTI7IM field.
	SYSCFG_C2IMR1_EXTI7IM_Pos = 0x17
	// Bit mask of EXTI7IM field.
	SYSCFG_C2IMR1_EXTI7IM_Msk = 0x800000
	// Bit EXTI7IM.
	SYSCFG_C2IMR1_EXTI7IM = 0x800000
	// Position of EXTI8IM field.
	SYSCFG_C2IMR1_EXTI8IM_Pos = 0x18
	// Bit mask of EXTI8IM field.
	SYSCFG_C2IMR1_EXTI8IM_Msk = 0x1000000
	// Bit EXTI8IM.
	SYSCFG_C2IMR1_EXTI8IM = 0x1000000
	// Position of EXTI9IM field.
	SYSCFG_C2IMR1_EXTI9IM_Pos = 0x19
	// Bit mask of EXTI9IM field.
	SYSCFG_C2IMR1_EXTI9IM_Msk = 0x2000000
	// Bit EXTI9IM.
	SYSCFG_C2IMR1_EXTI9IM = 0x2000000
	// Position of EXTI10IM field.
	SYSCFG_C2IMR1_EXTI10IM_Pos = 0x1a
	// Bit mask of EXTI10IM field.
	SYSCFG_C2IMR1_EXTI10IM_Msk = 0x4000000
	// Bit EXTI10IM.
	SYSCFG_C2IMR1_EXTI10IM = 0x4000000
	// Position of EXTI11IM field.
	SYSCFG_C2IMR1_EXTI11IM_Pos = 0x1b
	// Bit mask of EXTI11IM field.
	SYSCFG_C2IMR1_EXTI11IM_Msk = 0x8000000
	// Bit EXTI11IM.
	SYSCFG_C2IMR1_EXTI11IM = 0x8000000
	// Position of EXTI12IM field.
	SYSCFG_C2IMR1_EXTI12IM_Pos = 0x1c
	// Bit mask of EXTI12IM field.
	SYSCFG_C2IMR1_EXTI12IM_Msk = 0x10000000
	// Bit EXTI12IM.
	SYSCFG_C2IMR1_EXTI12IM = 0x10000000
	// Position of EXTI13IM field.
	SYSCFG_C2IMR1_EXTI13IM_Pos = 0x1d
	// Bit mask of EXTI13IM field.
	SYSCFG_C2IMR1_EXTI13IM_Msk = 0x20000000
	// Bit EXTI13IM.
	SYSCFG_C2IMR1_EXTI13IM = 0x20000000
	// Position of EXTI14IM field.
	SYSCFG_C2IMR1_EXTI14IM_Pos = 0x1e
	// Bit mask of EXTI14IM field.
	SYSCFG_C2IMR1_EXTI14IM_Msk = 0x40000000
	// Bit EXTI14IM.
	SYSCFG_C2IMR1_EXTI14IM = 0x40000000
	// Position of EXTI15IM field.
	SYSCFG_C2IMR1_EXTI15IM_Pos = 0x1f
	// Bit mask of EXTI15IM field.
	SYSCFG_C2IMR1_EXTI15IM_Msk = 0x80000000
	// Bit EXTI15IM.
	SYSCFG_C2IMR1_EXTI15IM = 0x80000000

	// C2IMR2: SYSCFG CPU2 interrupt mask register 2
	// Position of DMA1CH1IM field.
	SYSCFG_C2IMR2_DMA1CH1IM_Pos = 0x0
	// Bit mask of DMA1CH1IM field.
	SYSCFG_C2IMR2_DMA1CH1IM_Msk = 0x1
	// Bit DMA1CH1IM.
	SYSCFG_C2IMR2_DMA1CH1IM = 0x1
	// Position of DMA1CH2IM field.
	SYSCFG_C2IMR2_DMA1CH2IM_Pos = 0x1
	// Bit mask of DMA1CH2IM field.
	SYSCFG_C2IMR2_DMA1CH2IM_Msk = 0x2
	// Bit DMA1CH2IM.
	SYSCFG_C2IMR2_DMA1CH2IM = 0x2
	// Position of DMA1CH3IM field.
	SYSCFG_C2IMR2_DMA1CH3IM_Pos = 0x2
	// Bit mask of DMA1CH3IM field.
	SYSCFG_C2IMR2_DMA1CH3IM_Msk = 0x4
	// Bit DMA1CH3IM.
	SYSCFG_C2IMR2_DMA1CH3IM = 0x4
	// Position of DMA1CH4IM field.
	SYSCFG_C2IMR2_DMA1CH4IM_Pos = 0x3
	// Bit mask of DMA1CH4IM field.
	SYSCFG_C2IMR2_DMA1CH4IM_Msk = 0x8
	// Bit DMA1CH4IM.
	SYSCFG_C2IMR2_DMA1CH4IM = 0x8
	// Position of DMA1CH5IM field.
	SYSCFG_C2IMR2_DMA1CH5IM_Pos = 0x4
	// Bit mask of DMA1CH5IM field.
	SYSCFG_C2IMR2_DMA1CH5IM_Msk = 0x10
	// Bit DMA1CH5IM.
	SYSCFG_C2IMR2_DMA1CH5IM = 0x10
	// Position of DMA1CH6IM field.
	SYSCFG_C2IMR2_DMA1CH6IM_Pos = 0x5
	// Bit mask of DMA1CH6IM field.
	SYSCFG_C2IMR2_DMA1CH6IM_Msk = 0x20
	// Bit DMA1CH6IM.
	SYSCFG_C2IMR2_DMA1CH6IM = 0x20
	// Position of DMA1CH7IM field.
	SYSCFG_C2IMR2_DMA1CH7IM_Pos = 0x6
	// Bit mask of DMA1CH7IM field.
	SYSCFG_C2IMR2_DMA1CH7IM_Msk = 0x40
	// Bit DMA1CH7IM.
	SYSCFG_C2IMR2_DMA1CH7IM = 0x40
	// Position of DMA2CH1IM field.
	SYSCFG_C2IMR2_DMA2CH1IM_Pos = 0x8
	// Bit mask of DMA2CH1IM field.
	SYSCFG_C2IMR2_DMA2CH1IM_Msk = 0x100
	// Bit DMA2CH1IM.
	SYSCFG_C2IMR2_DMA2CH1IM = 0x100
	// Position of DMA2CH2IM field.
	SYSCFG_C2IMR2_DMA2CH2IM_Pos = 0x9
	// Bit mask of DMA2CH2IM field.
	SYSCFG_C2IMR2_DMA2CH2IM_Msk = 0x200
	// Bit DMA2CH2IM.
	SYSCFG_C2IMR2_DMA2CH2IM = 0x200
	// Position of DMA2CH3IM field.
	SYSCFG_C2IMR2_DMA2CH3IM_Pos = 0xa
	// Bit mask of DMA2CH3IM field.
	SYSCFG_C2IMR2_DMA2CH3IM_Msk = 0x400
	// Bit DMA2CH3IM.
	SYSCFG_C2IMR2_DMA2CH3IM = 0x400
	// Position of DMA2CH4IM field.
	SYSCFG_C2IMR2_DMA2CH4IM_Pos = 0xb
	// Bit mask of DMA2CH4IM field.
	SYSCFG_C2IMR2_DMA2CH4IM_Msk = 0x800
	// Bit DMA2CH4IM.
	SYSCFG_C2IMR2_DMA2CH4IM = 0x800
	// Position of DMA2CH5IM field.
	SYSCFG_C2IMR2_DMA2CH5IM_Pos = 0xc
	// Bit mask of DMA2CH5IM field.
	SYSCFG_C2IMR2_DMA2CH5IM_Msk = 0x1000
	// Bit DMA2CH5IM.
	SYSCFG_C2IMR2_DMA2CH5IM = 0x1000
	// Position of DMA2CH6IM field.
	SYSCFG_C2IMR2_DMA2CH6IM_Pos = 0xd
	// Bit mask of DMA2CH6IM field.
	SYSCFG_C2IMR2_DMA2CH6IM_Msk = 0x2000
	// Bit DMA2CH6IM.
	SYSCFG_C2IMR2_DMA2CH6IM = 0x2000
	// Position of DMA2CH7IM field.
	SYSCFG_C2IMR2_DMA2CH7IM_Pos = 0xe
	// Bit mask of DMA2CH7IM field.
	SYSCFG_C2IMR2_DMA2CH7IM_Msk = 0x4000
	// Bit DMA2CH7IM.
	SYSCFG_C2IMR2_DMA2CH7IM = 0x4000
	// Position of DMAMUX1IM field.
	SYSCFG_C2IMR2_DMAMUX1IM_Pos = 0xf
	// Bit mask of DMAMUX1IM field.
	SYSCFG_C2IMR2_DMAMUX1IM_Msk = 0x8000
	// Bit DMAMUX1IM.
	SYSCFG_C2IMR2_DMAMUX1IM = 0x8000
	// Position of PVM3IM field.
	SYSCFG_C2IMR2_PVM3IM_Pos = 0x12
	// Bit mask of PVM3IM field.
	SYSCFG_C2IMR2_PVM3IM_Msk = 0x40000
	// Bit PVM3IM.
	SYSCFG_C2IMR2_PVM3IM = 0x40000
	// Position of PVDIM field.
	SYSCFG_C2IMR2_PVDIM_Pos = 0x14
	// Bit mask of PVDIM field.
	SYSCFG_C2IMR2_PVDIM_Msk = 0x100000
	// Bit PVDIM.
	SYSCFG_C2IMR2_PVDIM = 0x100000

	// RFDCR: radio debug control register
	// Position of RFTBSEL field.
	SYSCFG_RFDCR_RFTBSEL_Pos = 0x0
	// Bit mask of RFTBSEL field.
	SYSCFG_RFDCR_RFTBSEL_Msk = 0x1
	// Bit RFTBSEL.
	SYSCFG_RFDCR_RFTBSEL = 0x1
)

// Bitfields for TAMP: Tamper and backup registers
const (
	// CR1: control register 1
	// Position of TAMP1E field.
	TAMP_CR1_TAMP1E_Pos = 0x0
	// Bit mask of TAMP1E field.
	TAMP_CR1_TAMP1E_Msk = 0x1
	// Bit TAMP1E.
	TAMP_CR1_TAMP1E = 0x1
	// Position of TAMP2E field.
	TAMP_CR1_TAMP2E_Pos = 0x1
	// Bit mask of TAMP2E field.
	TAMP_CR1_TAMP2E_Msk = 0x2
	// Bit TAMP2E.
	TAMP_CR1_TAMP2E = 0x2
	// Position of TAMP3E field.
	TAMP_CR1_TAMP3E_Pos = 0x2
	// Bit mask of TAMP3E field.
	TAMP_CR1_TAMP3E_Msk = 0x4
	// Bit TAMP3E.
	TAMP_CR1_TAMP3E = 0x4
	// Position of ITAMP3E field.
	TAMP_CR1_ITAMP3E_Pos = 0x12
	// Bit mask of ITAMP3E field.
	TAMP_CR1_ITAMP3E_Msk = 0x40000
	// Bit ITAMP3E.
	TAMP_CR1_ITAMP3E = 0x40000
	// Position of ITAMP5E field.
	TAMP_CR1_ITAMP5E_Pos = 0x14
	// Bit mask of ITAMP5E field.
	TAMP_CR1_ITAMP5E_Msk = 0x100000
	// Bit ITAMP5E.
	TAMP_CR1_ITAMP5E = 0x100000
	// Position of ITAMP6E field.
	TAMP_CR1_ITAMP6E_Pos = 0x15
	// Bit mask of ITAMP6E field.
	TAMP_CR1_ITAMP6E_Msk = 0x200000
	// Bit ITAMP6E.
	TAMP_CR1_ITAMP6E = 0x200000
	// Position of ITAMP8E field.
	TAMP_CR1_ITAMP8E_Pos = 0x17
	// Bit mask of ITAMP8E field.
	TAMP_CR1_ITAMP8E_Msk = 0x800000
	// Bit ITAMP8E.
	TAMP_CR1_ITAMP8E = 0x800000

	// CR2: control register 2
	// Position of TAMP1NOER field.
	TAMP_CR2_TAMP1NOER_Pos = 0x0
	// Bit mask of TAMP1NOER field.
	TAMP_CR2_TAMP1NOER_Msk = 0x1
	// Bit TAMP1NOER.
	TAMP_CR2_TAMP1NOER = 0x1
	// Position of TAMP2NOER field.
	TAMP_CR2_TAMP2NOER_Pos = 0x1
	// Bit mask of TAMP2NOER field.
	TAMP_CR2_TAMP2NOER_Msk = 0x2
	// Bit TAMP2NOER.
	TAMP_CR2_TAMP2NOER = 0x2
	// Position of TAMP3NOER field.
	TAMP_CR2_TAMP3NOER_Pos = 0x2
	// Bit mask of TAMP3NOER field.
	TAMP_CR2_TAMP3NOER_Msk = 0x4
	// Bit TAMP3NOER.
	TAMP_CR2_TAMP3NOER = 0x4
	// Position of TAMP1MSK field.
	TAMP_CR2_TAMP1MSK_Pos = 0x10
	// Bit mask of TAMP1MSK field.
	TAMP_CR2_TAMP1MSK_Msk = 0x10000
	// Bit TAMP1MSK.
	TAMP_CR2_TAMP1MSK = 0x10000
	// Position of TAMP2MSK field.
	TAMP_CR2_TAMP2MSK_Pos = 0x11
	// Bit mask of TAMP2MSK field.
	TAMP_CR2_TAMP2MSK_Msk = 0x20000
	// Bit TAMP2MSK.
	TAMP_CR2_TAMP2MSK = 0x20000
	// Position of TAMP3MSK field.
	TAMP_CR2_TAMP3MSK_Pos = 0x12
	// Bit mask of TAMP3MSK field.
	TAMP_CR2_TAMP3MSK_Msk = 0x40000
	// Bit TAMP3MSK.
	TAMP_CR2_TAMP3MSK = 0x40000
	// Position of BKERASE field.
	TAMP_CR2_BKERASE_Pos = 0x17
	// Bit mask of BKERASE field.
	TAMP_CR2_BKERASE_Msk = 0x800000
	// Bit BKERASE.
	TAMP_CR2_BKERASE = 0x800000
	// Position of TAMP1TRG field.
	TAMP_CR2_TAMP1TRG_Pos = 0x18
	// Bit mask of TAMP1TRG field.
	TAMP_CR2_TAMP1TRG_Msk = 0x1000000
	// Bit TAMP1TRG.
	TAMP_CR2_TAMP1TRG = 0x1000000
	// Position of TAMP2TRG field.
	TAMP_CR2_TAMP2TRG_Pos = 0x19
	// Bit mask of TAMP2TRG field.
	TAMP_CR2_TAMP2TRG_Msk = 0x2000000
	// Bit TAMP2TRG.
	TAMP_CR2_TAMP2TRG = 0x2000000
	// Position of TAMP3TRG field.
	TAMP_CR2_TAMP3TRG_Pos = 0x1a
	// Bit mask of TAMP3TRG field.
	TAMP_CR2_TAMP3TRG_Msk = 0x4000000
	// Bit TAMP3TRG.
	TAMP_CR2_TAMP3TRG = 0x4000000

	// CR3: TAMP control register 3
	// Position of ITAMP3NOER field.
	TAMP_CR3_ITAMP3NOER_Pos = 0x2
	// Bit mask of ITAMP3NOER field.
	TAMP_CR3_ITAMP3NOER_Msk = 0x4
	// Bit ITAMP3NOER.
	TAMP_CR3_ITAMP3NOER = 0x4
	// Position of ITAMP5NOER field.
	TAMP_CR3_ITAMP5NOER_Pos = 0x4
	// Bit mask of ITAMP5NOER field.
	TAMP_CR3_ITAMP5NOER_Msk = 0x10
	// Bit ITAMP5NOER.
	TAMP_CR3_ITAMP5NOER = 0x10
	// Position of ITAMP6NOER field.
	TAMP_CR3_ITAMP6NOER_Pos = 0x5
	// Bit mask of ITAMP6NOER field.
	TAMP_CR3_ITAMP6NOER_Msk = 0x20
	// Bit ITAMP6NOER.
	TAMP_CR3_ITAMP6NOER = 0x20
	// Position of ITAMP8NOER field.
	TAMP_CR3_ITAMP8NOER_Pos = 0x7
	// Bit mask of ITAMP8NOER field.
	TAMP_CR3_ITAMP8NOER_Msk = 0x80
	// Bit ITAMP8NOER.
	TAMP_CR3_ITAMP8NOER = 0x80

	// FLTCR: TAMP filter control register
	// Position of TAMPFREQ field.
	TAMP_FLTCR_TAMPFREQ_Pos = 0x0
	// Bit mask of TAMPFREQ field.
	TAMP_FLTCR_TAMPFREQ_Msk = 0x7
	// Position of TAMPFLT field.
	TAMP_FLTCR_TAMPFLT_Pos = 0x3
	// Bit mask of TAMPFLT field.
	TAMP_FLTCR_TAMPFLT_Msk = 0x18
	// Position of TAMPPRCH field.
	TAMP_FLTCR_TAMPPRCH_Pos = 0x5
	// Bit mask of TAMPPRCH field.
	TAMP_FLTCR_TAMPPRCH_Msk = 0x60
	// Position of TAMPPUDIS field.
	TAMP_FLTCR_TAMPPUDIS_Pos = 0x7
	// Bit mask of TAMPPUDIS field.
	TAMP_FLTCR_TAMPPUDIS_Msk = 0x80
	// Bit TAMPPUDIS.
	TAMP_FLTCR_TAMPPUDIS = 0x80

	// IER: TAMP interrupt enable register
	// Position of TAMP1IE field.
	TAMP_IER_TAMP1IE_Pos = 0x0
	// Bit mask of TAMP1IE field.
	TAMP_IER_TAMP1IE_Msk = 0x1
	// Bit TAMP1IE.
	TAMP_IER_TAMP1IE = 0x1
	// Position of TAMP2IE field.
	TAMP_IER_TAMP2IE_Pos = 0x1
	// Bit mask of TAMP2IE field.
	TAMP_IER_TAMP2IE_Msk = 0x2
	// Bit TAMP2IE.
	TAMP_IER_TAMP2IE = 0x2
	// Position of TAMP3IE field.
	TAMP_IER_TAMP3IE_Pos = 0x2
	// Bit mask of TAMP3IE field.
	TAMP_IER_TAMP3IE_Msk = 0x4
	// Bit TAMP3IE.
	TAMP_IER_TAMP3IE = 0x4
	// Position of ITAMP3IE field.
	TAMP_IER_ITAMP3IE_Pos = 0x12
	// Bit mask of ITAMP3IE field.
	TAMP_IER_ITAMP3IE_Msk = 0x40000
	// Bit ITAMP3IE.
	TAMP_IER_ITAMP3IE = 0x40000
	// Position of ITAMP5IE field.
	TAMP_IER_ITAMP5IE_Pos = 0x14
	// Bit mask of ITAMP5IE field.
	TAMP_IER_ITAMP5IE_Msk = 0x100000
	// Bit ITAMP5IE.
	TAMP_IER_ITAMP5IE = 0x100000
	// Position of ITAMP6IE field.
	TAMP_IER_ITAMP6IE_Pos = 0x15
	// Bit mask of ITAMP6IE field.
	TAMP_IER_ITAMP6IE_Msk = 0x200000
	// Bit ITAMP6IE.
	TAMP_IER_ITAMP6IE = 0x200000
	// Position of ITAMP8IE field.
	TAMP_IER_ITAMP8IE_Pos = 0x17
	// Bit mask of ITAMP8IE field.
	TAMP_IER_ITAMP8IE_Msk = 0x800000
	// Bit ITAMP8IE.
	TAMP_IER_ITAMP8IE = 0x800000

	// SR: TAMP status register
	// Position of TAMP1F field.
	TAMP_SR_TAMP1F_Pos = 0x0
	// Bit mask of TAMP1F field.
	TAMP_SR_TAMP1F_Msk = 0x1
	// Bit TAMP1F.
	TAMP_SR_TAMP1F = 0x1
	// Position of TAMP2F field.
	TAMP_SR_TAMP2F_Pos = 0x1
	// Bit mask of TAMP2F field.
	TAMP_SR_TAMP2F_Msk = 0x2
	// Bit TAMP2F.
	TAMP_SR_TAMP2F = 0x2
	// Position of TAMP3F field.
	TAMP_SR_TAMP3F_Pos = 0x2
	// Bit mask of TAMP3F field.
	TAMP_SR_TAMP3F_Msk = 0x4
	// Bit TAMP3F.
	TAMP_SR_TAMP3F = 0x4
	// Position of ITAMP3F field.
	TAMP_SR_ITAMP3F_Pos = 0x12
	// Bit mask of ITAMP3F field.
	TAMP_SR_ITAMP3F_Msk = 0x40000
	// Bit ITAMP3F.
	TAMP_SR_ITAMP3F = 0x40000
	// Position of ITAMP5F field.
	TAMP_SR_ITAMP5F_Pos = 0x14
	// Bit mask of ITAMP5F field.
	TAMP_SR_ITAMP5F_Msk = 0x100000
	// Bit ITAMP5F.
	TAMP_SR_ITAMP5F = 0x100000
	// Position of ITAMP6F field.
	TAMP_SR_ITAMP6F_Pos = 0x15
	// Bit mask of ITAMP6F field.
	TAMP_SR_ITAMP6F_Msk = 0x200000
	// Bit ITAMP6F.
	TAMP_SR_ITAMP6F = 0x200000
	// Position of ITAMP8F field.
	TAMP_SR_ITAMP8F_Pos = 0x17
	// Bit mask of ITAMP8F field.
	TAMP_SR_ITAMP8F_Msk = 0x800000
	// Bit ITAMP8F.
	TAMP_SR_ITAMP8F = 0x800000

	// MISR: TAMP masked interrupt status register
	// Position of TAMP1MF field.
	TAMP_MISR_TAMP1MF_Pos = 0x0
	// Bit mask of TAMP1MF field.
	TAMP_MISR_TAMP1MF_Msk = 0x1
	// Bit TAMP1MF.
	TAMP_MISR_TAMP1MF = 0x1
	// Position of TAMP2MF field.
	TAMP_MISR_TAMP2MF_Pos = 0x1
	// Bit mask of TAMP2MF field.
	TAMP_MISR_TAMP2MF_Msk = 0x2
	// Bit TAMP2MF.
	TAMP_MISR_TAMP2MF = 0x2
	// Position of TAMP3MF field.
	TAMP_MISR_TAMP3MF_Pos = 0x2
	// Bit mask of TAMP3MF field.
	TAMP_MISR_TAMP3MF_Msk = 0x4
	// Bit TAMP3MF.
	TAMP_MISR_TAMP3MF = 0x4
	// Position of ITAMP3MF field.
	TAMP_MISR_ITAMP3MF_Pos = 0x12
	// Bit mask of ITAMP3MF field.
	TAMP_MISR_ITAMP3MF_Msk = 0x40000
	// Bit ITAMP3MF.
	TAMP_MISR_ITAMP3MF = 0x40000
	// Position of ITAMP5MF field.
	TAMP_MISR_ITAMP5MF_Pos = 0x14
	// Bit mask of ITAMP5MF field.
	TAMP_MISR_ITAMP5MF_Msk = 0x100000
	// Bit ITAMP5MF.
	TAMP_MISR_ITAMP5MF = 0x100000
	// Position of ITAMP6MF field.
	TAMP_MISR_ITAMP6MF_Pos = 0x15
	// Bit mask of ITAMP6MF field.
	TAMP_MISR_ITAMP6MF_Msk = 0x200000
	// Bit ITAMP6MF.
	TAMP_MISR_ITAMP6MF = 0x200000
	// Position of ITAMP8MF field.
	TAMP_MISR_ITAMP8MF_Pos = 0x17
	// Bit mask of ITAMP8MF field.
	TAMP_MISR_ITAMP8MF_Msk = 0x800000
	// Bit ITAMP8MF.
	TAMP_MISR_ITAMP8MF = 0x800000

	// SCR: TAMP status clear register
	// Position of CTAMP1F field.
	TAMP_SCR_CTAMP1F_Pos = 0x0
	// Bit mask of CTAMP1F field.
	TAMP_SCR_CTAMP1F_Msk = 0x1
	// Bit CTAMP1F.
	TAMP_SCR_CTAMP1F = 0x1
	// Position of CTAMP2F field.
	TAMP_SCR_CTAMP2F_Pos = 0x1
	// Bit mask of CTAMP2F field.
	TAMP_SCR_CTAMP2F_Msk = 0x2
	// Bit CTAMP2F.
	TAMP_SCR_CTAMP2F = 0x2
	// Position of CTAMP3F field.
	TAMP_SCR_CTAMP3F_Pos = 0x2
	// Bit mask of CTAMP3F field.
	TAMP_SCR_CTAMP3F_Msk = 0x4
	// Bit CTAMP3F.
	TAMP_SCR_CTAMP3F = 0x4
	// Position of CITAMP3F field.
	TAMP_SCR_CITAMP3F_Pos = 0x12
	// Bit mask of CITAMP3F field.
	TAMP_SCR_CITAMP3F_Msk = 0x40000
	// Bit CITAMP3F.
	TAMP_SCR_CITAMP3F = 0x40000
	// Position of CITAMP5F field.
	TAMP_SCR_CITAMP5F_Pos = 0x14
	// Bit mask of CITAMP5F field.
	TAMP_SCR_CITAMP5F_Msk = 0x100000
	// Bit CITAMP5F.
	TAMP_SCR_CITAMP5F = 0x100000
	// Position of CITAMP6F field.
	TAMP_SCR_CITAMP6F_Pos = 0x15
	// Bit mask of CITAMP6F field.
	TAMP_SCR_CITAMP6F_Msk = 0x200000
	// Bit CITAMP6F.
	TAMP_SCR_CITAMP6F = 0x200000
	// Position of CITAMP8F field.
	TAMP_SCR_CITAMP8F_Pos = 0x17
	// Bit mask of CITAMP8F field.
	TAMP_SCR_CITAMP8F_Msk = 0x800000
	// Bit CITAMP8F.
	TAMP_SCR_CITAMP8F = 0x800000

	// COUNTR: monotonic counter register
	// Position of COUNT field.
	TAMP_COUNTR_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	TAMP_COUNTR_COUNT_Msk = 0xffffffff

	// BKP0R: TAMP backup register
	// Position of BKP field.
	TAMP_BKP0R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	TAMP_BKP0R_BKP_Msk = 0xffffffff

	// BKP1R: TAMP backup register
	// Position of BKP field.
	TAMP_BKP1R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	TAMP_BKP1R_BKP_Msk = 0xffffffff

	// BKP2R: TAMP backup register
	// Position of BKP field.
	TAMP_BKP2R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	TAMP_BKP2R_BKP_Msk = 0xffffffff

	// BKP3R: TAMP backup register
	// Position of BKP field.
	TAMP_BKP3R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	TAMP_BKP3R_BKP_Msk = 0xffffffff

	// BKP4R: TAMP backup register
	// Position of BKP field.
	TAMP_BKP4R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	TAMP_BKP4R_BKP_Msk = 0xffffffff

	// BKP5R: TAMP backup register
	// Position of BKP field.
	TAMP_BKP5R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	TAMP_BKP5R_BKP_Msk = 0xffffffff

	// BKP6R: TAMP backup register
	// Position of BKP field.
	TAMP_BKP6R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	TAMP_BKP6R_BKP_Msk = 0xffffffff

	// BKP7R: TAMP backup register
	// Position of BKP field.
	TAMP_BKP7R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	TAMP_BKP7R_BKP_Msk = 0xffffffff

	// BKP8R: TAMP backup register
	// Position of BKP field.
	TAMP_BKP8R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	TAMP_BKP8R_BKP_Msk = 0xffffffff

	// BKP9R: TAMP backup register
	// Position of BKP field.
	TAMP_BKP9R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	TAMP_BKP9R_BKP_Msk = 0xffffffff

	// BKP10R: TAMP backup register
	// Position of BKP field.
	TAMP_BKP10R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	TAMP_BKP10R_BKP_Msk = 0xffffffff

	// BKP11R: TAMP backup register
	// Position of BKP field.
	TAMP_BKP11R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	TAMP_BKP11R_BKP_Msk = 0xffffffff

	// BKP12R: TAMP backup register
	// Position of BKP field.
	TAMP_BKP12R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	TAMP_BKP12R_BKP_Msk = 0xffffffff

	// BKP13R: TAMP backup register
	// Position of BKP field.
	TAMP_BKP13R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	TAMP_BKP13R_BKP_Msk = 0xffffffff

	// BKP14R: TAMP backup register
	// Position of BKP field.
	TAMP_BKP14R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	TAMP_BKP14R_BKP_Msk = 0xffffffff

	// BKP15R: TAMP backup register
	// Position of BKP field.
	TAMP_BKP15R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	TAMP_BKP15R_BKP_Msk = 0xffffffff

	// BKP16R: TAMP backup register
	// Position of BKP field.
	TAMP_BKP16R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	TAMP_BKP16R_BKP_Msk = 0xffffffff

	// BKP17R: TAMP backup register
	// Position of BKP field.
	TAMP_BKP17R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	TAMP_BKP17R_BKP_Msk = 0xffffffff

	// BKP18R: TAMP backup register
	// Position of BKP field.
	TAMP_BKP18R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	TAMP_BKP18R_BKP_Msk = 0xffffffff

	// BKP19R: TAMP backup register
	// Position of BKP field.
	TAMP_BKP19R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	TAMP_BKP19R_BKP_Msk = 0xffffffff
)

// Bitfields for TIM1: Advanced-control timers
const (
	// CR1: control register 1
	// Position of UIFREMAP field.
	AdavanceTIM_CR1_UIFREMAP_Pos = 0xb
	// Bit mask of UIFREMAP field.
	AdavanceTIM_CR1_UIFREMAP_Msk = 0x800
	// Bit UIFREMAP.
	AdavanceTIM_CR1_UIFREMAP = 0x800
	// Position of CKD field.
	AdavanceTIM_CR1_CKD_Pos = 0x8
	// Bit mask of CKD field.
	AdavanceTIM_CR1_CKD_Msk = 0x300
	// Position of ARPE field.
	AdavanceTIM_CR1_ARPE_Pos = 0x7
	// Bit mask of ARPE field.
	AdavanceTIM_CR1_ARPE_Msk = 0x80
	// Bit ARPE.
	AdavanceTIM_CR1_ARPE = 0x80
	// Position of CMS field.
	AdavanceTIM_CR1_CMS_Pos = 0x5
	// Bit mask of CMS field.
	AdavanceTIM_CR1_CMS_Msk = 0x60
	// Position of DIR field.
	AdavanceTIM_CR1_DIR_Pos = 0x4
	// Bit mask of DIR field.
	AdavanceTIM_CR1_DIR_Msk = 0x10
	// Bit DIR.
	AdavanceTIM_CR1_DIR = 0x10
	// Position of OPM field.
	AdavanceTIM_CR1_OPM_Pos = 0x3
	// Bit mask of OPM field.
	AdavanceTIM_CR1_OPM_Msk = 0x8
	// Bit OPM.
	AdavanceTIM_CR1_OPM = 0x8
	// Position of URS field.
	AdavanceTIM_CR1_URS_Pos = 0x2
	// Bit mask of URS field.
	AdavanceTIM_CR1_URS_Msk = 0x4
	// Bit URS.
	AdavanceTIM_CR1_URS = 0x4
	// Position of UDIS field.
	AdavanceTIM_CR1_UDIS_Pos = 0x1
	// Bit mask of UDIS field.
	AdavanceTIM_CR1_UDIS_Msk = 0x2
	// Bit UDIS.
	AdavanceTIM_CR1_UDIS = 0x2
	// Position of CEN field.
	AdavanceTIM_CR1_CEN_Pos = 0x0
	// Bit mask of CEN field.
	AdavanceTIM_CR1_CEN_Msk = 0x1
	// Bit CEN.
	AdavanceTIM_CR1_CEN = 0x1

	// CR2: control register 2
	// Position of MMS2 field.
	AdavanceTIM_CR2_MMS2_Pos = 0x14
	// Bit mask of MMS2 field.
	AdavanceTIM_CR2_MMS2_Msk = 0xf00000
	// Position of OIS6 field.
	AdavanceTIM_CR2_OIS6_Pos = 0x12
	// Bit mask of OIS6 field.
	AdavanceTIM_CR2_OIS6_Msk = 0x40000
	// Bit OIS6.
	AdavanceTIM_CR2_OIS6 = 0x40000
	// Position of OIS5 field.
	AdavanceTIM_CR2_OIS5_Pos = 0x10
	// Bit mask of OIS5 field.
	AdavanceTIM_CR2_OIS5_Msk = 0x10000
	// Bit OIS5.
	AdavanceTIM_CR2_OIS5 = 0x10000
	// Position of OIS4 field.
	AdavanceTIM_CR2_OIS4_Pos = 0xe
	// Bit mask of OIS4 field.
	AdavanceTIM_CR2_OIS4_Msk = 0x4000
	// Bit OIS4.
	AdavanceTIM_CR2_OIS4 = 0x4000
	// Position of OIS3N field.
	AdavanceTIM_CR2_OIS3N_Pos = 0xd
	// Bit mask of OIS3N field.
	AdavanceTIM_CR2_OIS3N_Msk = 0x2000
	// Bit OIS3N.
	AdavanceTIM_CR2_OIS3N = 0x2000
	// Position of OIS3 field.
	AdavanceTIM_CR2_OIS3_Pos = 0xc
	// Bit mask of OIS3 field.
	AdavanceTIM_CR2_OIS3_Msk = 0x1000
	// Bit OIS3.
	AdavanceTIM_CR2_OIS3 = 0x1000
	// Position of OIS2N field.
	AdavanceTIM_CR2_OIS2N_Pos = 0xb
	// Bit mask of OIS2N field.
	AdavanceTIM_CR2_OIS2N_Msk = 0x800
	// Bit OIS2N.
	AdavanceTIM_CR2_OIS2N = 0x800
	// Position of OIS2 field.
	AdavanceTIM_CR2_OIS2_Pos = 0xa
	// Bit mask of OIS2 field.
	AdavanceTIM_CR2_OIS2_Msk = 0x400
	// Bit OIS2.
	AdavanceTIM_CR2_OIS2 = 0x400
	// Position of OIS1N field.
	AdavanceTIM_CR2_OIS1N_Pos = 0x9
	// Bit mask of OIS1N field.
	AdavanceTIM_CR2_OIS1N_Msk = 0x200
	// Bit OIS1N.
	AdavanceTIM_CR2_OIS1N = 0x200
	// Position of OIS1 field.
	AdavanceTIM_CR2_OIS1_Pos = 0x8
	// Bit mask of OIS1 field.
	AdavanceTIM_CR2_OIS1_Msk = 0x100
	// Bit OIS1.
	AdavanceTIM_CR2_OIS1 = 0x100
	// Position of TI1S field.
	AdavanceTIM_CR2_TI1S_Pos = 0x7
	// Bit mask of TI1S field.
	AdavanceTIM_CR2_TI1S_Msk = 0x80
	// Bit TI1S.
	AdavanceTIM_CR2_TI1S = 0x80
	// Position of MMS field.
	AdavanceTIM_CR2_MMS_Pos = 0x4
	// Bit mask of MMS field.
	AdavanceTIM_CR2_MMS_Msk = 0x70
	// Position of CCDS field.
	AdavanceTIM_CR2_CCDS_Pos = 0x3
	// Bit mask of CCDS field.
	AdavanceTIM_CR2_CCDS_Msk = 0x8
	// Bit CCDS.
	AdavanceTIM_CR2_CCDS = 0x8
	// Position of CCUS field.
	AdavanceTIM_CR2_CCUS_Pos = 0x2
	// Bit mask of CCUS field.
	AdavanceTIM_CR2_CCUS_Msk = 0x4
	// Bit CCUS.
	AdavanceTIM_CR2_CCUS = 0x4
	// Position of CCPC field.
	AdavanceTIM_CR2_CCPC_Pos = 0x0
	// Bit mask of CCPC field.
	AdavanceTIM_CR2_CCPC_Msk = 0x1
	// Bit CCPC.
	AdavanceTIM_CR2_CCPC = 0x1

	// SMCR: slave mode control register
	// Position of TS3_4 field.
	AdavanceTIM_SMCR_TS3_4_Pos = 0x14
	// Bit mask of TS3_4 field.
	AdavanceTIM_SMCR_TS3_4_Msk = 0x300000
	// Position of SMS_3 field.
	AdavanceTIM_SMCR_SMS_3_Pos = 0x10
	// Bit mask of SMS_3 field.
	AdavanceTIM_SMCR_SMS_3_Msk = 0x10000
	// Bit SMS_3.
	AdavanceTIM_SMCR_SMS_3 = 0x10000
	// Position of ETP field.
	AdavanceTIM_SMCR_ETP_Pos = 0xf
	// Bit mask of ETP field.
	AdavanceTIM_SMCR_ETP_Msk = 0x8000
	// Bit ETP.
	AdavanceTIM_SMCR_ETP = 0x8000
	// Position of ECE field.
	AdavanceTIM_SMCR_ECE_Pos = 0xe
	// Bit mask of ECE field.
	AdavanceTIM_SMCR_ECE_Msk = 0x4000
	// Bit ECE.
	AdavanceTIM_SMCR_ECE = 0x4000
	// Position of ETPS field.
	AdavanceTIM_SMCR_ETPS_Pos = 0xc
	// Bit mask of ETPS field.
	AdavanceTIM_SMCR_ETPS_Msk = 0x3000
	// Position of ETF field.
	AdavanceTIM_SMCR_ETF_Pos = 0x8
	// Bit mask of ETF field.
	AdavanceTIM_SMCR_ETF_Msk = 0xf00
	// Position of MSM field.
	AdavanceTIM_SMCR_MSM_Pos = 0x7
	// Bit mask of MSM field.
	AdavanceTIM_SMCR_MSM_Msk = 0x80
	// Bit MSM.
	AdavanceTIM_SMCR_MSM = 0x80
	// Position of TS field.
	AdavanceTIM_SMCR_TS_Pos = 0x4
	// Bit mask of TS field.
	AdavanceTIM_SMCR_TS_Msk = 0x70
	// Position of OCCS field.
	AdavanceTIM_SMCR_OCCS_Pos = 0x3
	// Bit mask of OCCS field.
	AdavanceTIM_SMCR_OCCS_Msk = 0x8
	// Bit OCCS.
	AdavanceTIM_SMCR_OCCS = 0x8
	// Position of SMS field.
	AdavanceTIM_SMCR_SMS_Pos = 0x0
	// Bit mask of SMS field.
	AdavanceTIM_SMCR_SMS_Msk = 0x7

	// DIER: DMA/interrupt enable register
	// Position of TDE field.
	AdavanceTIM_DIER_TDE_Pos = 0xe
	// Bit mask of TDE field.
	AdavanceTIM_DIER_TDE_Msk = 0x4000
	// Bit TDE.
	AdavanceTIM_DIER_TDE = 0x4000
	// Position of COMDE field.
	AdavanceTIM_DIER_COMDE_Pos = 0xd
	// Bit mask of COMDE field.
	AdavanceTIM_DIER_COMDE_Msk = 0x2000
	// Bit COMDE.
	AdavanceTIM_DIER_COMDE = 0x2000
	// Position of CC4DE field.
	AdavanceTIM_DIER_CC4DE_Pos = 0xc
	// Bit mask of CC4DE field.
	AdavanceTIM_DIER_CC4DE_Msk = 0x1000
	// Bit CC4DE.
	AdavanceTIM_DIER_CC4DE = 0x1000
	// Position of CC3DE field.
	AdavanceTIM_DIER_CC3DE_Pos = 0xb
	// Bit mask of CC3DE field.
	AdavanceTIM_DIER_CC3DE_Msk = 0x800
	// Bit CC3DE.
	AdavanceTIM_DIER_CC3DE = 0x800
	// Position of CC2DE field.
	AdavanceTIM_DIER_CC2DE_Pos = 0xa
	// Bit mask of CC2DE field.
	AdavanceTIM_DIER_CC2DE_Msk = 0x400
	// Bit CC2DE.
	AdavanceTIM_DIER_CC2DE = 0x400
	// Position of CC1DE field.
	AdavanceTIM_DIER_CC1DE_Pos = 0x9
	// Bit mask of CC1DE field.
	AdavanceTIM_DIER_CC1DE_Msk = 0x200
	// Bit CC1DE.
	AdavanceTIM_DIER_CC1DE = 0x200
	// Position of UDE field.
	AdavanceTIM_DIER_UDE_Pos = 0x8
	// Bit mask of UDE field.
	AdavanceTIM_DIER_UDE_Msk = 0x100
	// Bit UDE.
	AdavanceTIM_DIER_UDE = 0x100
	// Position of BIE field.
	AdavanceTIM_DIER_BIE_Pos = 0x7
	// Bit mask of BIE field.
	AdavanceTIM_DIER_BIE_Msk = 0x80
	// Bit BIE.
	AdavanceTIM_DIER_BIE = 0x80
	// Position of TIE field.
	AdavanceTIM_DIER_TIE_Pos = 0x6
	// Bit mask of TIE field.
	AdavanceTIM_DIER_TIE_Msk = 0x40
	// Bit TIE.
	AdavanceTIM_DIER_TIE = 0x40
	// Position of COMIE field.
	AdavanceTIM_DIER_COMIE_Pos = 0x5
	// Bit mask of COMIE field.
	AdavanceTIM_DIER_COMIE_Msk = 0x20
	// Bit COMIE.
	AdavanceTIM_DIER_COMIE = 0x20
	// Position of CC4IE field.
	AdavanceTIM_DIER_CC4IE_Pos = 0x4
	// Bit mask of CC4IE field.
	AdavanceTIM_DIER_CC4IE_Msk = 0x10
	// Bit CC4IE.
	AdavanceTIM_DIER_CC4IE = 0x10
	// Position of CC3IE field.
	AdavanceTIM_DIER_CC3IE_Pos = 0x3
	// Bit mask of CC3IE field.
	AdavanceTIM_DIER_CC3IE_Msk = 0x8
	// Bit CC3IE.
	AdavanceTIM_DIER_CC3IE = 0x8
	// Position of CC2IE field.
	AdavanceTIM_DIER_CC2IE_Pos = 0x2
	// Bit mask of CC2IE field.
	AdavanceTIM_DIER_CC2IE_Msk = 0x4
	// Bit CC2IE.
	AdavanceTIM_DIER_CC2IE = 0x4
	// Position of CC1IE field.
	AdavanceTIM_DIER_CC1IE_Pos = 0x1
	// Bit mask of CC1IE field.
	AdavanceTIM_DIER_CC1IE_Msk = 0x2
	// Bit CC1IE.
	AdavanceTIM_DIER_CC1IE = 0x2
	// Position of UIE field.
	AdavanceTIM_DIER_UIE_Pos = 0x0
	// Bit mask of UIE field.
	AdavanceTIM_DIER_UIE_Msk = 0x1
	// Bit UIE.
	AdavanceTIM_DIER_UIE = 0x1

	// SR: status register
	// Position of CC6IF field.
	AdavanceTIM_SR_CC6IF_Pos = 0x11
	// Bit mask of CC6IF field.
	AdavanceTIM_SR_CC6IF_Msk = 0x20000
	// Bit CC6IF.
	AdavanceTIM_SR_CC6IF = 0x20000
	// Position of CC5IF field.
	AdavanceTIM_SR_CC5IF_Pos = 0x10
	// Bit mask of CC5IF field.
	AdavanceTIM_SR_CC5IF_Msk = 0x10000
	// Bit CC5IF.
	AdavanceTIM_SR_CC5IF = 0x10000
	// Position of SBIF field.
	AdavanceTIM_SR_SBIF_Pos = 0xd
	// Bit mask of SBIF field.
	AdavanceTIM_SR_SBIF_Msk = 0x2000
	// Bit SBIF.
	AdavanceTIM_SR_SBIF = 0x2000
	// Position of CC4OF field.
	AdavanceTIM_SR_CC4OF_Pos = 0xc
	// Bit mask of CC4OF field.
	AdavanceTIM_SR_CC4OF_Msk = 0x1000
	// Bit CC4OF.
	AdavanceTIM_SR_CC4OF = 0x1000
	// Position of CC3OF field.
	AdavanceTIM_SR_CC3OF_Pos = 0xb
	// Bit mask of CC3OF field.
	AdavanceTIM_SR_CC3OF_Msk = 0x800
	// Bit CC3OF.
	AdavanceTIM_SR_CC3OF = 0x800
	// Position of CC2OF field.
	AdavanceTIM_SR_CC2OF_Pos = 0xa
	// Bit mask of CC2OF field.
	AdavanceTIM_SR_CC2OF_Msk = 0x400
	// Bit CC2OF.
	AdavanceTIM_SR_CC2OF = 0x400
	// Position of CC1OF field.
	AdavanceTIM_SR_CC1OF_Pos = 0x9
	// Bit mask of CC1OF field.
	AdavanceTIM_SR_CC1OF_Msk = 0x200
	// Bit CC1OF.
	AdavanceTIM_SR_CC1OF = 0x200
	// Position of B2IF field.
	AdavanceTIM_SR_B2IF_Pos = 0x8
	// Bit mask of B2IF field.
	AdavanceTIM_SR_B2IF_Msk = 0x100
	// Bit B2IF.
	AdavanceTIM_SR_B2IF = 0x100
	// Position of BIF field.
	AdavanceTIM_SR_BIF_Pos = 0x7
	// Bit mask of BIF field.
	AdavanceTIM_SR_BIF_Msk = 0x80
	// Bit BIF.
	AdavanceTIM_SR_BIF = 0x80
	// Position of TIF field.
	AdavanceTIM_SR_TIF_Pos = 0x6
	// Bit mask of TIF field.
	AdavanceTIM_SR_TIF_Msk = 0x40
	// Bit TIF.
	AdavanceTIM_SR_TIF = 0x40
	// Position of COMIF field.
	AdavanceTIM_SR_COMIF_Pos = 0x5
	// Bit mask of COMIF field.
	AdavanceTIM_SR_COMIF_Msk = 0x20
	// Bit COMIF.
	AdavanceTIM_SR_COMIF = 0x20
	// Position of CC4IF field.
	AdavanceTIM_SR_CC4IF_Pos = 0x4
	// Bit mask of CC4IF field.
	AdavanceTIM_SR_CC4IF_Msk = 0x10
	// Bit CC4IF.
	AdavanceTIM_SR_CC4IF = 0x10
	// Position of CC3IF field.
	AdavanceTIM_SR_CC3IF_Pos = 0x3
	// Bit mask of CC3IF field.
	AdavanceTIM_SR_CC3IF_Msk = 0x8
	// Bit CC3IF.
	AdavanceTIM_SR_CC3IF = 0x8
	// Position of CC2IF field.
	AdavanceTIM_SR_CC2IF_Pos = 0x2
	// Bit mask of CC2IF field.
	AdavanceTIM_SR_CC2IF_Msk = 0x4
	// Bit CC2IF.
	AdavanceTIM_SR_CC2IF = 0x4
	// Position of CC1IF field.
	AdavanceTIM_SR_CC1IF_Pos = 0x1
	// Bit mask of CC1IF field.
	AdavanceTIM_SR_CC1IF_Msk = 0x2
	// Bit CC1IF.
	AdavanceTIM_SR_CC1IF = 0x2
	// Position of UIF field.
	AdavanceTIM_SR_UIF_Pos = 0x0
	// Bit mask of UIF field.
	AdavanceTIM_SR_UIF_Msk = 0x1
	// Bit UIF.
	AdavanceTIM_SR_UIF = 0x1

	// EGR: event generation register
	// Position of B2G field.
	AdavanceTIM_EGR_B2G_Pos = 0x8
	// Bit mask of B2G field.
	AdavanceTIM_EGR_B2G_Msk = 0x100
	// Bit B2G.
	AdavanceTIM_EGR_B2G = 0x100
	// Position of BG field.
	AdavanceTIM_EGR_BG_Pos = 0x7
	// Bit mask of BG field.
	AdavanceTIM_EGR_BG_Msk = 0x80
	// Bit BG.
	AdavanceTIM_EGR_BG = 0x80
	// Position of TG field.
	AdavanceTIM_EGR_TG_Pos = 0x6
	// Bit mask of TG field.
	AdavanceTIM_EGR_TG_Msk = 0x40
	// Bit TG.
	AdavanceTIM_EGR_TG = 0x40
	// Position of COM field.
	AdavanceTIM_EGR_COM_Pos = 0x5
	// Bit mask of COM field.
	AdavanceTIM_EGR_COM_Msk = 0x20
	// Bit COM.
	AdavanceTIM_EGR_COM = 0x20
	// Position of CC4G field.
	AdavanceTIM_EGR_CC4G_Pos = 0x4
	// Bit mask of CC4G field.
	AdavanceTIM_EGR_CC4G_Msk = 0x10
	// Bit CC4G.
	AdavanceTIM_EGR_CC4G = 0x10
	// Position of CC3G field.
	AdavanceTIM_EGR_CC3G_Pos = 0x3
	// Bit mask of CC3G field.
	AdavanceTIM_EGR_CC3G_Msk = 0x8
	// Bit CC3G.
	AdavanceTIM_EGR_CC3G = 0x8
	// Position of CC2G field.
	AdavanceTIM_EGR_CC2G_Pos = 0x2
	// Bit mask of CC2G field.
	AdavanceTIM_EGR_CC2G_Msk = 0x4
	// Bit CC2G.
	AdavanceTIM_EGR_CC2G = 0x4
	// Position of CC1G field.
	AdavanceTIM_EGR_CC1G_Pos = 0x1
	// Bit mask of CC1G field.
	AdavanceTIM_EGR_CC1G_Msk = 0x2
	// Bit CC1G.
	AdavanceTIM_EGR_CC1G = 0x2
	// Position of UG field.
	AdavanceTIM_EGR_UG_Pos = 0x0
	// Bit mask of UG field.
	AdavanceTIM_EGR_UG_Msk = 0x1
	// Bit UG.
	AdavanceTIM_EGR_UG = 0x1

	// CCMR1_Output: capture/compare mode register 1 (output mode)
	// Position of OC2M_3 field.
	AdavanceTIM_CCMR1_Output_OC2M_3_Pos = 0x18
	// Bit mask of OC2M_3 field.
	AdavanceTIM_CCMR1_Output_OC2M_3_Msk = 0x1000000
	// Bit OC2M_3.
	AdavanceTIM_CCMR1_Output_OC2M_3 = 0x1000000
	// Position of OC1M_3 field.
	AdavanceTIM_CCMR1_Output_OC1M_3_Pos = 0x10
	// Bit mask of OC1M_3 field.
	AdavanceTIM_CCMR1_Output_OC1M_3_Msk = 0x10000
	// Bit OC1M_3.
	AdavanceTIM_CCMR1_Output_OC1M_3 = 0x10000
	// Position of OC2CE field.
	AdavanceTIM_CCMR1_Output_OC2CE_Pos = 0xf
	// Bit mask of OC2CE field.
	AdavanceTIM_CCMR1_Output_OC2CE_Msk = 0x8000
	// Bit OC2CE.
	AdavanceTIM_CCMR1_Output_OC2CE = 0x8000
	// Position of OC2M field.
	AdavanceTIM_CCMR1_Output_OC2M_Pos = 0xc
	// Bit mask of OC2M field.
	AdavanceTIM_CCMR1_Output_OC2M_Msk = 0x7000
	// Position of OC2PE field.
	AdavanceTIM_CCMR1_Output_OC2PE_Pos = 0xb
	// Bit mask of OC2PE field.
	AdavanceTIM_CCMR1_Output_OC2PE_Msk = 0x800
	// Bit OC2PE.
	AdavanceTIM_CCMR1_Output_OC2PE = 0x800
	// Position of OC2FE field.
	AdavanceTIM_CCMR1_Output_OC2FE_Pos = 0xa
	// Bit mask of OC2FE field.
	AdavanceTIM_CCMR1_Output_OC2FE_Msk = 0x400
	// Bit OC2FE.
	AdavanceTIM_CCMR1_Output_OC2FE = 0x400
	// Position of CC2S field.
	AdavanceTIM_CCMR1_Output_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	AdavanceTIM_CCMR1_Output_CC2S_Msk = 0x300
	// Position of OC1CE field.
	AdavanceTIM_CCMR1_Output_OC1CE_Pos = 0x7
	// Bit mask of OC1CE field.
	AdavanceTIM_CCMR1_Output_OC1CE_Msk = 0x80
	// Bit OC1CE.
	AdavanceTIM_CCMR1_Output_OC1CE = 0x80
	// Position of OC1M field.
	AdavanceTIM_CCMR1_Output_OC1M_Pos = 0x4
	// Bit mask of OC1M field.
	AdavanceTIM_CCMR1_Output_OC1M_Msk = 0x70
	// Position of OC1PE field.
	AdavanceTIM_CCMR1_Output_OC1PE_Pos = 0x3
	// Bit mask of OC1PE field.
	AdavanceTIM_CCMR1_Output_OC1PE_Msk = 0x8
	// Bit OC1PE.
	AdavanceTIM_CCMR1_Output_OC1PE = 0x8
	// Position of OC1FE field.
	AdavanceTIM_CCMR1_Output_OC1FE_Pos = 0x2
	// Bit mask of OC1FE field.
	AdavanceTIM_CCMR1_Output_OC1FE_Msk = 0x4
	// Bit OC1FE.
	AdavanceTIM_CCMR1_Output_OC1FE = 0x4
	// Position of CC1S field.
	AdavanceTIM_CCMR1_Output_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	AdavanceTIM_CCMR1_Output_CC1S_Msk = 0x3

	// CCMR1_Input: capture/compare mode register 1 (input mode)
	// Position of IC2F field.
	AdavanceTIM_CCMR1_Input_IC2F_Pos = 0xc
	// Bit mask of IC2F field.
	AdavanceTIM_CCMR1_Input_IC2F_Msk = 0xf000
	// Position of IC2PSC field.
	AdavanceTIM_CCMR1_Input_IC2PSC_Pos = 0xa
	// Bit mask of IC2PSC field.
	AdavanceTIM_CCMR1_Input_IC2PSC_Msk = 0xc00
	// Position of CC2S field.
	AdavanceTIM_CCMR1_Input_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	AdavanceTIM_CCMR1_Input_CC2S_Msk = 0x300
	// Position of IC1F field.
	AdavanceTIM_CCMR1_Input_IC1F_Pos = 0x4
	// Bit mask of IC1F field.
	AdavanceTIM_CCMR1_Input_IC1F_Msk = 0xf0
	// Position of IC1PSC field.
	AdavanceTIM_CCMR1_Input_IC1PSC_Pos = 0x2
	// Bit mask of IC1PSC field.
	AdavanceTIM_CCMR1_Input_IC1PSC_Msk = 0xc
	// Position of CC1S field.
	AdavanceTIM_CCMR1_Input_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	AdavanceTIM_CCMR1_Input_CC1S_Msk = 0x3

	// CCMR2_Output: capture/compare mode register 2 (output mode)
	// Position of OC4M_3 field.
	AdavanceTIM_CCMR2_Output_OC4M_3_Pos = 0x18
	// Bit mask of OC4M_3 field.
	AdavanceTIM_CCMR2_Output_OC4M_3_Msk = 0x1000000
	// Bit OC4M_3.
	AdavanceTIM_CCMR2_Output_OC4M_3 = 0x1000000
	// Position of OC3M_3 field.
	AdavanceTIM_CCMR2_Output_OC3M_3_Pos = 0x10
	// Bit mask of OC3M_3 field.
	AdavanceTIM_CCMR2_Output_OC3M_3_Msk = 0x10000
	// Bit OC3M_3.
	AdavanceTIM_CCMR2_Output_OC3M_3 = 0x10000
	// Position of OC4CE field.
	AdavanceTIM_CCMR2_Output_OC4CE_Pos = 0xf
	// Bit mask of OC4CE field.
	AdavanceTIM_CCMR2_Output_OC4CE_Msk = 0x8000
	// Bit OC4CE.
	AdavanceTIM_CCMR2_Output_OC4CE = 0x8000
	// Position of OC4M field.
	AdavanceTIM_CCMR2_Output_OC4M_Pos = 0xc
	// Bit mask of OC4M field.
	AdavanceTIM_CCMR2_Output_OC4M_Msk = 0x7000
	// Position of OC4PE field.
	AdavanceTIM_CCMR2_Output_OC4PE_Pos = 0xb
	// Bit mask of OC4PE field.
	AdavanceTIM_CCMR2_Output_OC4PE_Msk = 0x800
	// Bit OC4PE.
	AdavanceTIM_CCMR2_Output_OC4PE = 0x800
	// Position of OC4FE field.
	AdavanceTIM_CCMR2_Output_OC4FE_Pos = 0xa
	// Bit mask of OC4FE field.
	AdavanceTIM_CCMR2_Output_OC4FE_Msk = 0x400
	// Bit OC4FE.
	AdavanceTIM_CCMR2_Output_OC4FE = 0x400
	// Position of CC4S field.
	AdavanceTIM_CCMR2_Output_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	AdavanceTIM_CCMR2_Output_CC4S_Msk = 0x300
	// Position of OC3CE field.
	AdavanceTIM_CCMR2_Output_OC3CE_Pos = 0x7
	// Bit mask of OC3CE field.
	AdavanceTIM_CCMR2_Output_OC3CE_Msk = 0x80
	// Bit OC3CE.
	AdavanceTIM_CCMR2_Output_OC3CE = 0x80
	// Position of OC3M field.
	AdavanceTIM_CCMR2_Output_OC3M_Pos = 0x4
	// Bit mask of OC3M field.
	AdavanceTIM_CCMR2_Output_OC3M_Msk = 0x70
	// Position of OC3PE field.
	AdavanceTIM_CCMR2_Output_OC3PE_Pos = 0x3
	// Bit mask of OC3PE field.
	AdavanceTIM_CCMR2_Output_OC3PE_Msk = 0x8
	// Bit OC3PE.
	AdavanceTIM_CCMR2_Output_OC3PE = 0x8
	// Position of OC3FE field.
	AdavanceTIM_CCMR2_Output_OC3FE_Pos = 0x2
	// Bit mask of OC3FE field.
	AdavanceTIM_CCMR2_Output_OC3FE_Msk = 0x4
	// Bit OC3FE.
	AdavanceTIM_CCMR2_Output_OC3FE = 0x4
	// Position of CC3S field.
	AdavanceTIM_CCMR2_Output_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	AdavanceTIM_CCMR2_Output_CC3S_Msk = 0x3

	// CCMR2_Input: capture/compare mode register 2 (input mode)
	// Position of IC4F field.
	AdavanceTIM_CCMR2_Input_IC4F_Pos = 0xc
	// Bit mask of IC4F field.
	AdavanceTIM_CCMR2_Input_IC4F_Msk = 0xf000
	// Position of IC4PSC field.
	AdavanceTIM_CCMR2_Input_IC4PSC_Pos = 0xa
	// Bit mask of IC4PSC field.
	AdavanceTIM_CCMR2_Input_IC4PSC_Msk = 0xc00
	// Position of CC4S field.
	AdavanceTIM_CCMR2_Input_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	AdavanceTIM_CCMR2_Input_CC4S_Msk = 0x300
	// Position of IC3F field.
	AdavanceTIM_CCMR2_Input_IC3F_Pos = 0x4
	// Bit mask of IC3F field.
	AdavanceTIM_CCMR2_Input_IC3F_Msk = 0xf0
	// Position of IC3PSC field.
	AdavanceTIM_CCMR2_Input_IC3PSC_Pos = 0x2
	// Bit mask of IC3PSC field.
	AdavanceTIM_CCMR2_Input_IC3PSC_Msk = 0xc
	// Position of CC3S field.
	AdavanceTIM_CCMR2_Input_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	AdavanceTIM_CCMR2_Input_CC3S_Msk = 0x3

	// CCER: capture/compare enable register
	// Position of CC6P field.
	AdavanceTIM_CCER_CC6P_Pos = 0x15
	// Bit mask of CC6P field.
	AdavanceTIM_CCER_CC6P_Msk = 0x200000
	// Bit CC6P.
	AdavanceTIM_CCER_CC6P = 0x200000
	// Position of CC6E field.
	AdavanceTIM_CCER_CC6E_Pos = 0x14
	// Bit mask of CC6E field.
	AdavanceTIM_CCER_CC6E_Msk = 0x100000
	// Bit CC6E.
	AdavanceTIM_CCER_CC6E = 0x100000
	// Position of CC5P field.
	AdavanceTIM_CCER_CC5P_Pos = 0x11
	// Bit mask of CC5P field.
	AdavanceTIM_CCER_CC5P_Msk = 0x20000
	// Bit CC5P.
	AdavanceTIM_CCER_CC5P = 0x20000
	// Position of CC5E field.
	AdavanceTIM_CCER_CC5E_Pos = 0x10
	// Bit mask of CC5E field.
	AdavanceTIM_CCER_CC5E_Msk = 0x10000
	// Bit CC5E.
	AdavanceTIM_CCER_CC5E = 0x10000
	// Position of CC4P field.
	AdavanceTIM_CCER_CC4P_Pos = 0xd
	// Bit mask of CC4P field.
	AdavanceTIM_CCER_CC4P_Msk = 0x2000
	// Bit CC4P.
	AdavanceTIM_CCER_CC4P = 0x2000
	// Position of CC4E field.
	AdavanceTIM_CCER_CC4E_Pos = 0xc
	// Bit mask of CC4E field.
	AdavanceTIM_CCER_CC4E_Msk = 0x1000
	// Bit CC4E.
	AdavanceTIM_CCER_CC4E = 0x1000
	// Position of CC3NP field.
	AdavanceTIM_CCER_CC3NP_Pos = 0xb
	// Bit mask of CC3NP field.
	AdavanceTIM_CCER_CC3NP_Msk = 0x800
	// Bit CC3NP.
	AdavanceTIM_CCER_CC3NP = 0x800
	// Position of CC3NE field.
	AdavanceTIM_CCER_CC3NE_Pos = 0xa
	// Bit mask of CC3NE field.
	AdavanceTIM_CCER_CC3NE_Msk = 0x400
	// Bit CC3NE.
	AdavanceTIM_CCER_CC3NE = 0x400
	// Position of CC3P field.
	AdavanceTIM_CCER_CC3P_Pos = 0x9
	// Bit mask of CC3P field.
	AdavanceTIM_CCER_CC3P_Msk = 0x200
	// Bit CC3P.
	AdavanceTIM_CCER_CC3P = 0x200
	// Position of CC3E field.
	AdavanceTIM_CCER_CC3E_Pos = 0x8
	// Bit mask of CC3E field.
	AdavanceTIM_CCER_CC3E_Msk = 0x100
	// Bit CC3E.
	AdavanceTIM_CCER_CC3E = 0x100
	// Position of CC2NP field.
	AdavanceTIM_CCER_CC2NP_Pos = 0x7
	// Bit mask of CC2NP field.
	AdavanceTIM_CCER_CC2NP_Msk = 0x80
	// Bit CC2NP.
	AdavanceTIM_CCER_CC2NP = 0x80
	// Position of CC2NE field.
	AdavanceTIM_CCER_CC2NE_Pos = 0x6
	// Bit mask of CC2NE field.
	AdavanceTIM_CCER_CC2NE_Msk = 0x40
	// Bit CC2NE.
	AdavanceTIM_CCER_CC2NE = 0x40
	// Position of CC2P field.
	AdavanceTIM_CCER_CC2P_Pos = 0x5
	// Bit mask of CC2P field.
	AdavanceTIM_CCER_CC2P_Msk = 0x20
	// Bit CC2P.
	AdavanceTIM_CCER_CC2P = 0x20
	// Position of CC2E field.
	AdavanceTIM_CCER_CC2E_Pos = 0x4
	// Bit mask of CC2E field.
	AdavanceTIM_CCER_CC2E_Msk = 0x10
	// Bit CC2E.
	AdavanceTIM_CCER_CC2E = 0x10
	// Position of CC1NP field.
	AdavanceTIM_CCER_CC1NP_Pos = 0x3
	// Bit mask of CC1NP field.
	AdavanceTIM_CCER_CC1NP_Msk = 0x8
	// Bit CC1NP.
	AdavanceTIM_CCER_CC1NP = 0x8
	// Position of CC1NE field.
	AdavanceTIM_CCER_CC1NE_Pos = 0x2
	// Bit mask of CC1NE field.
	AdavanceTIM_CCER_CC1NE_Msk = 0x4
	// Bit CC1NE.
	AdavanceTIM_CCER_CC1NE = 0x4
	// Position of CC1P field.
	AdavanceTIM_CCER_CC1P_Pos = 0x1
	// Bit mask of CC1P field.
	AdavanceTIM_CCER_CC1P_Msk = 0x2
	// Bit CC1P.
	AdavanceTIM_CCER_CC1P = 0x2
	// Position of CC1E field.
	AdavanceTIM_CCER_CC1E_Pos = 0x0
	// Bit mask of CC1E field.
	AdavanceTIM_CCER_CC1E_Msk = 0x1
	// Bit CC1E.
	AdavanceTIM_CCER_CC1E = 0x1

	// CNT: counter
	// Position of UIFCPY field.
	AdavanceTIM_CNT_UIFCPY_Pos = 0x1f
	// Bit mask of UIFCPY field.
	AdavanceTIM_CNT_UIFCPY_Msk = 0x80000000
	// Bit UIFCPY.
	AdavanceTIM_CNT_UIFCPY = 0x80000000
	// Position of CNT field.
	AdavanceTIM_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	AdavanceTIM_CNT_CNT_Msk = 0xffff

	// PSC: prescaler
	// Position of PSC field.
	AdavanceTIM_PSC_PSC_Pos = 0x0
	// Bit mask of PSC field.
	AdavanceTIM_PSC_PSC_Msk = 0xffff

	// ARR: auto-reload register
	// Position of ARR field.
	AdavanceTIM_ARR_ARR_Pos = 0x0
	// Bit mask of ARR field.
	AdavanceTIM_ARR_ARR_Msk = 0xffff

	// RCR: repetition counter register
	// Position of REP field.
	AdavanceTIM_RCR_REP_Pos = 0x0
	// Bit mask of REP field.
	AdavanceTIM_RCR_REP_Msk = 0xffff

	// CCR1: capture/compare register 1
	// Position of CCR1 field.
	AdavanceTIM_CCR1_CCR1_Pos = 0x0
	// Bit mask of CCR1 field.
	AdavanceTIM_CCR1_CCR1_Msk = 0xffff

	// CCR2: capture/compare register 2
	// Position of CCR2 field.
	AdavanceTIM_CCR2_CCR2_Pos = 0x0
	// Bit mask of CCR2 field.
	AdavanceTIM_CCR2_CCR2_Msk = 0xffff

	// CCR3: capture/compare register 3
	// Position of CCR3 field.
	AdavanceTIM_CCR3_CCR3_Pos = 0x0
	// Bit mask of CCR3 field.
	AdavanceTIM_CCR3_CCR3_Msk = 0xffff

	// CCR4: capture/compare register 4
	// Position of CCR4 field.
	AdavanceTIM_CCR4_CCR4_Pos = 0x0
	// Bit mask of CCR4 field.
	AdavanceTIM_CCR4_CCR4_Msk = 0xffff

	// BDTR: break and dead-time register
	// Position of BK2BID field.
	AdavanceTIM_BDTR_BK2BID_Pos = 0x1d
	// Bit mask of BK2BID field.
	AdavanceTIM_BDTR_BK2BID_Msk = 0x20000000
	// Bit BK2BID.
	AdavanceTIM_BDTR_BK2BID = 0x20000000
	// Position of BKBID field.
	AdavanceTIM_BDTR_BKBID_Pos = 0x1c
	// Bit mask of BKBID field.
	AdavanceTIM_BDTR_BKBID_Msk = 0x10000000
	// Bit BKBID.
	AdavanceTIM_BDTR_BKBID = 0x10000000
	// Position of BK2DSRM field.
	AdavanceTIM_BDTR_BK2DSRM_Pos = 0x1b
	// Bit mask of BK2DSRM field.
	AdavanceTIM_BDTR_BK2DSRM_Msk = 0x8000000
	// Bit BK2DSRM.
	AdavanceTIM_BDTR_BK2DSRM = 0x8000000
	// Position of BKDSRM field.
	AdavanceTIM_BDTR_BKDSRM_Pos = 0x1a
	// Bit mask of BKDSRM field.
	AdavanceTIM_BDTR_BKDSRM_Msk = 0x4000000
	// Bit BKDSRM.
	AdavanceTIM_BDTR_BKDSRM = 0x4000000
	// Position of BK2P field.
	AdavanceTIM_BDTR_BK2P_Pos = 0x19
	// Bit mask of BK2P field.
	AdavanceTIM_BDTR_BK2P_Msk = 0x2000000
	// Bit BK2P.
	AdavanceTIM_BDTR_BK2P = 0x2000000
	// Position of BK2E field.
	AdavanceTIM_BDTR_BK2E_Pos = 0x18
	// Bit mask of BK2E field.
	AdavanceTIM_BDTR_BK2E_Msk = 0x1000000
	// Bit BK2E.
	AdavanceTIM_BDTR_BK2E = 0x1000000
	// Position of BK2F field.
	AdavanceTIM_BDTR_BK2F_Pos = 0x14
	// Bit mask of BK2F field.
	AdavanceTIM_BDTR_BK2F_Msk = 0xf00000
	// Position of BKF field.
	AdavanceTIM_BDTR_BKF_Pos = 0x10
	// Bit mask of BKF field.
	AdavanceTIM_BDTR_BKF_Msk = 0xf0000
	// Position of MOE field.
	AdavanceTIM_BDTR_MOE_Pos = 0xf
	// Bit mask of MOE field.
	AdavanceTIM_BDTR_MOE_Msk = 0x8000
	// Bit MOE.
	AdavanceTIM_BDTR_MOE = 0x8000
	// Position of AOE field.
	AdavanceTIM_BDTR_AOE_Pos = 0xe
	// Bit mask of AOE field.
	AdavanceTIM_BDTR_AOE_Msk = 0x4000
	// Bit AOE.
	AdavanceTIM_BDTR_AOE = 0x4000
	// Position of BKP field.
	AdavanceTIM_BDTR_BKP_Pos = 0xd
	// Bit mask of BKP field.
	AdavanceTIM_BDTR_BKP_Msk = 0x2000
	// Bit BKP.
	AdavanceTIM_BDTR_BKP = 0x2000
	// Position of BKE field.
	AdavanceTIM_BDTR_BKE_Pos = 0xc
	// Bit mask of BKE field.
	AdavanceTIM_BDTR_BKE_Msk = 0x1000
	// Bit BKE.
	AdavanceTIM_BDTR_BKE = 0x1000
	// Position of OSSR field.
	AdavanceTIM_BDTR_OSSR_Pos = 0xb
	// Bit mask of OSSR field.
	AdavanceTIM_BDTR_OSSR_Msk = 0x800
	// Bit OSSR.
	AdavanceTIM_BDTR_OSSR = 0x800
	// Position of OSSI field.
	AdavanceTIM_BDTR_OSSI_Pos = 0xa
	// Bit mask of OSSI field.
	AdavanceTIM_BDTR_OSSI_Msk = 0x400
	// Bit OSSI.
	AdavanceTIM_BDTR_OSSI = 0x400
	// Position of LOCK field.
	AdavanceTIM_BDTR_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	AdavanceTIM_BDTR_LOCK_Msk = 0x300
	// Position of DT field.
	AdavanceTIM_BDTR_DT_Pos = 0x0
	// Bit mask of DT field.
	AdavanceTIM_BDTR_DT_Msk = 0xff

	// DCR: DMA control register
	// Position of DBL field.
	AdavanceTIM_DCR_DBL_Pos = 0x8
	// Bit mask of DBL field.
	AdavanceTIM_DCR_DBL_Msk = 0x1f00
	// Position of DBA field.
	AdavanceTIM_DCR_DBA_Pos = 0x0
	// Bit mask of DBA field.
	AdavanceTIM_DCR_DBA_Msk = 0x1f

	// DMAR: DMA address for full transfer
	// Position of DMAB field.
	AdavanceTIM_DMAR_DMAB_Pos = 0x0
	// Bit mask of DMAB field.
	AdavanceTIM_DMAR_DMAB_Msk = 0xffff

	// OR1: option register 1
	// Position of TI1_RMP field.
	AdavanceTIM_OR1_TI1_RMP_Pos = 0x4
	// Bit mask of TI1_RMP field.
	AdavanceTIM_OR1_TI1_RMP_Msk = 0x10
	// Bit TI1_RMP.
	AdavanceTIM_OR1_TI1_RMP = 0x10
	// Position of TIM1_ETR_ADC1_RMP field.
	AdavanceTIM_OR1_TIM1_ETR_ADC1_RMP_Pos = 0x0
	// Bit mask of TIM1_ETR_ADC1_RMP field.
	AdavanceTIM_OR1_TIM1_ETR_ADC1_RMP_Msk = 0x3

	// CCMR3OutputComparemode: capture/compare mode register 3
	// Position of OC6M_3 field.
	AdavanceTIM_CCMR3OutputComparemode_OC6M_3_Pos = 0x18
	// Bit mask of OC6M_3 field.
	AdavanceTIM_CCMR3OutputComparemode_OC6M_3_Msk = 0x1000000
	// Bit OC6M_3.
	AdavanceTIM_CCMR3OutputComparemode_OC6M_3 = 0x1000000
	// Position of OC5M_3 field.
	AdavanceTIM_CCMR3OutputComparemode_OC5M_3_Pos = 0x10
	// Bit mask of OC5M_3 field.
	AdavanceTIM_CCMR3OutputComparemode_OC5M_3_Msk = 0x10000
	// Bit OC5M_3.
	AdavanceTIM_CCMR3OutputComparemode_OC5M_3 = 0x10000
	// Position of OC6CE field.
	AdavanceTIM_CCMR3OutputComparemode_OC6CE_Pos = 0xf
	// Bit mask of OC6CE field.
	AdavanceTIM_CCMR3OutputComparemode_OC6CE_Msk = 0x8000
	// Bit OC6CE.
	AdavanceTIM_CCMR3OutputComparemode_OC6CE = 0x8000
	// Position of OC6M field.
	AdavanceTIM_CCMR3OutputComparemode_OC6M_Pos = 0xc
	// Bit mask of OC6M field.
	AdavanceTIM_CCMR3OutputComparemode_OC6M_Msk = 0x7000
	// Position of OC6PE field.
	AdavanceTIM_CCMR3OutputComparemode_OC6PE_Pos = 0xb
	// Bit mask of OC6PE field.
	AdavanceTIM_CCMR3OutputComparemode_OC6PE_Msk = 0x800
	// Bit OC6PE.
	AdavanceTIM_CCMR3OutputComparemode_OC6PE = 0x800
	// Position of OC6FE field.
	AdavanceTIM_CCMR3OutputComparemode_OC6FE_Pos = 0xa
	// Bit mask of OC6FE field.
	AdavanceTIM_CCMR3OutputComparemode_OC6FE_Msk = 0x400
	// Bit OC6FE.
	AdavanceTIM_CCMR3OutputComparemode_OC6FE = 0x400
	// Position of OC5CE field.
	AdavanceTIM_CCMR3OutputComparemode_OC5CE_Pos = 0x7
	// Bit mask of OC5CE field.
	AdavanceTIM_CCMR3OutputComparemode_OC5CE_Msk = 0x80
	// Bit OC5CE.
	AdavanceTIM_CCMR3OutputComparemode_OC5CE = 0x80
	// Position of OC5M field.
	AdavanceTIM_CCMR3OutputComparemode_OC5M_Pos = 0x4
	// Bit mask of OC5M field.
	AdavanceTIM_CCMR3OutputComparemode_OC5M_Msk = 0x70
	// Position of OC5PE field.
	AdavanceTIM_CCMR3OutputComparemode_OC5PE_Pos = 0x3
	// Bit mask of OC5PE field.
	AdavanceTIM_CCMR3OutputComparemode_OC5PE_Msk = 0x8
	// Bit OC5PE.
	AdavanceTIM_CCMR3OutputComparemode_OC5PE = 0x8
	// Position of OC5FE field.
	AdavanceTIM_CCMR3OutputComparemode_OC5FE_Pos = 0x2
	// Bit mask of OC5FE field.
	AdavanceTIM_CCMR3OutputComparemode_OC5FE_Msk = 0x4
	// Bit OC5FE.
	AdavanceTIM_CCMR3OutputComparemode_OC5FE = 0x4

	// CCR5: capture/compare register 5
	// Position of GC5C3 field.
	AdavanceTIM_CCR5_GC5C3_Pos = 0x1f
	// Bit mask of GC5C3 field.
	AdavanceTIM_CCR5_GC5C3_Msk = 0x80000000
	// Bit GC5C3.
	AdavanceTIM_CCR5_GC5C3 = 0x80000000
	// Position of GC5C2 field.
	AdavanceTIM_CCR5_GC5C2_Pos = 0x1e
	// Bit mask of GC5C2 field.
	AdavanceTIM_CCR5_GC5C2_Msk = 0x40000000
	// Bit GC5C2.
	AdavanceTIM_CCR5_GC5C2 = 0x40000000
	// Position of GC5C1 field.
	AdavanceTIM_CCR5_GC5C1_Pos = 0x1d
	// Bit mask of GC5C1 field.
	AdavanceTIM_CCR5_GC5C1_Msk = 0x20000000
	// Bit GC5C1.
	AdavanceTIM_CCR5_GC5C1 = 0x20000000
	// Position of CCR5 field.
	AdavanceTIM_CCR5_CCR5_Pos = 0x0
	// Bit mask of CCR5 field.
	AdavanceTIM_CCR5_CCR5_Msk = 0xffff

	// CCR6: capture/compare register 6
	// Position of CCR6 field.
	AdavanceTIM_CCR6_CCR6_Pos = 0x0
	// Bit mask of CCR6 field.
	AdavanceTIM_CCR6_CCR6_Msk = 0xffff

	// AF1: alternate function option register 1
	// Position of ResETRSEL field.
	AdavanceTIM_AF1_ResETRSEL_Pos = 0xe
	// Bit mask of ResETRSEL field.
	AdavanceTIM_AF1_ResETRSEL_Msk = 0x3c000
	// Position of BKCMP2P field.
	AdavanceTIM_AF1_BKCMP2P_Pos = 0xb
	// Bit mask of BKCMP2P field.
	AdavanceTIM_AF1_BKCMP2P_Msk = 0x800
	// Bit BKCMP2P.
	AdavanceTIM_AF1_BKCMP2P = 0x800
	// Position of BKCMP1P field.
	AdavanceTIM_AF1_BKCMP1P_Pos = 0xa
	// Bit mask of BKCMP1P field.
	AdavanceTIM_AF1_BKCMP1P_Msk = 0x400
	// Bit BKCMP1P.
	AdavanceTIM_AF1_BKCMP1P = 0x400
	// Position of BKINP field.
	AdavanceTIM_AF1_BKINP_Pos = 0x9
	// Bit mask of BKINP field.
	AdavanceTIM_AF1_BKINP_Msk = 0x200
	// Bit BKINP.
	AdavanceTIM_AF1_BKINP = 0x200
	// Position of BKCMP2E field.
	AdavanceTIM_AF1_BKCMP2E_Pos = 0x2
	// Bit mask of BKCMP2E field.
	AdavanceTIM_AF1_BKCMP2E_Msk = 0x4
	// Bit BKCMP2E.
	AdavanceTIM_AF1_BKCMP2E = 0x4
	// Position of BKCMP1E field.
	AdavanceTIM_AF1_BKCMP1E_Pos = 0x1
	// Bit mask of BKCMP1E field.
	AdavanceTIM_AF1_BKCMP1E_Msk = 0x2
	// Bit BKCMP1E.
	AdavanceTIM_AF1_BKCMP1E = 0x2
	// Position of BKINE field.
	AdavanceTIM_AF1_BKINE_Pos = 0x0
	// Bit mask of BKINE field.
	AdavanceTIM_AF1_BKINE_Msk = 0x1
	// Bit BKINE.
	AdavanceTIM_AF1_BKINE = 0x1

	// AF2: Alternate function register 2
	// Position of BK2CMP2P field.
	AdavanceTIM_AF2_BK2CMP2P_Pos = 0xb
	// Bit mask of BK2CMP2P field.
	AdavanceTIM_AF2_BK2CMP2P_Msk = 0x800
	// Bit BK2CMP2P.
	AdavanceTIM_AF2_BK2CMP2P = 0x800
	// Position of BK2CMP1P field.
	AdavanceTIM_AF2_BK2CMP1P_Pos = 0xa
	// Bit mask of BK2CMP1P field.
	AdavanceTIM_AF2_BK2CMP1P_Msk = 0x400
	// Bit BK2CMP1P.
	AdavanceTIM_AF2_BK2CMP1P = 0x400
	// Position of BK2INP field.
	AdavanceTIM_AF2_BK2INP_Pos = 0x9
	// Bit mask of BK2INP field.
	AdavanceTIM_AF2_BK2INP_Msk = 0x200
	// Bit BK2INP.
	AdavanceTIM_AF2_BK2INP = 0x200
	// Position of BK2CMP2E field.
	AdavanceTIM_AF2_BK2CMP2E_Pos = 0x2
	// Bit mask of BK2CMP2E field.
	AdavanceTIM_AF2_BK2CMP2E_Msk = 0x4
	// Bit BK2CMP2E.
	AdavanceTIM_AF2_BK2CMP2E = 0x4
	// Position of BK2CMP1E field.
	AdavanceTIM_AF2_BK2CMP1E_Pos = 0x1
	// Bit mask of BK2CMP1E field.
	AdavanceTIM_AF2_BK2CMP1E_Msk = 0x2
	// Bit BK2CMP1E.
	AdavanceTIM_AF2_BK2CMP1E = 0x2
	// Position of BK2INE field.
	AdavanceTIM_AF2_BK2INE_Pos = 0x0
	// Bit mask of BK2INE field.
	AdavanceTIM_AF2_BK2INE_Msk = 0x1
	// Bit BK2INE.
	AdavanceTIM_AF2_BK2INE = 0x1

	// TISEL: timer input selection register
	// Position of TI4SEL field.
	AdavanceTIM_TISEL_TI4SEL_Pos = 0x18
	// Bit mask of TI4SEL field.
	AdavanceTIM_TISEL_TI4SEL_Msk = 0xf000000
	// Position of TI3SEL field.
	AdavanceTIM_TISEL_TI3SEL_Pos = 0x10
	// Bit mask of TI3SEL field.
	AdavanceTIM_TISEL_TI3SEL_Msk = 0xf0000
	// Position of TI2SEL field.
	AdavanceTIM_TISEL_TI2SEL_Pos = 0x8
	// Bit mask of TI2SEL field.
	AdavanceTIM_TISEL_TI2SEL_Msk = 0xf00
	// Position of TI1SEL field.
	AdavanceTIM_TISEL_TI1SEL_Pos = 0x0
	// Bit mask of TI1SEL field.
	AdavanceTIM_TISEL_TI1SEL_Msk = 0xf
)

// Bitfields for TIM2: General-purpose-timers
const (
	// CR1: control register 1
	// Position of UIFREMAP field.
	GPTIM_CR1_UIFREMAP_Pos = 0xb
	// Bit mask of UIFREMAP field.
	GPTIM_CR1_UIFREMAP_Msk = 0x800
	// Bit UIFREMAP.
	GPTIM_CR1_UIFREMAP = 0x800
	// Position of CKD field.
	GPTIM_CR1_CKD_Pos = 0x8
	// Bit mask of CKD field.
	GPTIM_CR1_CKD_Msk = 0x300
	// Position of ARPE field.
	GPTIM_CR1_ARPE_Pos = 0x7
	// Bit mask of ARPE field.
	GPTIM_CR1_ARPE_Msk = 0x80
	// Bit ARPE.
	GPTIM_CR1_ARPE = 0x80
	// Position of CMS field.
	GPTIM_CR1_CMS_Pos = 0x5
	// Bit mask of CMS field.
	GPTIM_CR1_CMS_Msk = 0x60
	// Position of DIR field.
	GPTIM_CR1_DIR_Pos = 0x4
	// Bit mask of DIR field.
	GPTIM_CR1_DIR_Msk = 0x10
	// Bit DIR.
	GPTIM_CR1_DIR = 0x10
	// Position of OPM field.
	GPTIM_CR1_OPM_Pos = 0x3
	// Bit mask of OPM field.
	GPTIM_CR1_OPM_Msk = 0x8
	// Bit OPM.
	GPTIM_CR1_OPM = 0x8
	// Position of URS field.
	GPTIM_CR1_URS_Pos = 0x2
	// Bit mask of URS field.
	GPTIM_CR1_URS_Msk = 0x4
	// Bit URS.
	GPTIM_CR1_URS = 0x4
	// Position of UDIS field.
	GPTIM_CR1_UDIS_Pos = 0x1
	// Bit mask of UDIS field.
	GPTIM_CR1_UDIS_Msk = 0x2
	// Bit UDIS.
	GPTIM_CR1_UDIS = 0x2
	// Position of CEN field.
	GPTIM_CR1_CEN_Pos = 0x0
	// Bit mask of CEN field.
	GPTIM_CR1_CEN_Msk = 0x1
	// Bit CEN.
	GPTIM_CR1_CEN = 0x1

	// CR2: control register 2
	// Position of TI1S field.
	GPTIM_CR2_TI1S_Pos = 0x7
	// Bit mask of TI1S field.
	GPTIM_CR2_TI1S_Msk = 0x80
	// Bit TI1S.
	GPTIM_CR2_TI1S = 0x80
	// Position of MMS field.
	GPTIM_CR2_MMS_Pos = 0x4
	// Bit mask of MMS field.
	GPTIM_CR2_MMS_Msk = 0x70
	// Position of CCDS field.
	GPTIM_CR2_CCDS_Pos = 0x3
	// Bit mask of CCDS field.
	GPTIM_CR2_CCDS_Msk = 0x8
	// Bit CCDS.
	GPTIM_CR2_CCDS = 0x8

	// SMCR: slave mode control register
	// Position of SMS_3 field.
	GPTIM_SMCR_SMS_3_Pos = 0x10
	// Bit mask of SMS_3 field.
	GPTIM_SMCR_SMS_3_Msk = 0x10000
	// Bit SMS_3.
	GPTIM_SMCR_SMS_3 = 0x10000
	// Position of ETP field.
	GPTIM_SMCR_ETP_Pos = 0xf
	// Bit mask of ETP field.
	GPTIM_SMCR_ETP_Msk = 0x8000
	// Bit ETP.
	GPTIM_SMCR_ETP = 0x8000
	// Position of ECE field.
	GPTIM_SMCR_ECE_Pos = 0xe
	// Bit mask of ECE field.
	GPTIM_SMCR_ECE_Msk = 0x4000
	// Bit ECE.
	GPTIM_SMCR_ECE = 0x4000
	// Position of ETPS field.
	GPTIM_SMCR_ETPS_Pos = 0xc
	// Bit mask of ETPS field.
	GPTIM_SMCR_ETPS_Msk = 0x3000
	// Position of ETF field.
	GPTIM_SMCR_ETF_Pos = 0x8
	// Bit mask of ETF field.
	GPTIM_SMCR_ETF_Msk = 0xf00
	// Position of MSM field.
	GPTIM_SMCR_MSM_Pos = 0x7
	// Bit mask of MSM field.
	GPTIM_SMCR_MSM_Msk = 0x80
	// Bit MSM.
	GPTIM_SMCR_MSM = 0x80
	// Position of TS field.
	GPTIM_SMCR_TS_Pos = 0x4
	// Bit mask of TS field.
	GPTIM_SMCR_TS_Msk = 0x70
	// Position of OCCS field.
	GPTIM_SMCR_OCCS_Pos = 0x3
	// Bit mask of OCCS field.
	GPTIM_SMCR_OCCS_Msk = 0x8
	// Bit OCCS.
	GPTIM_SMCR_OCCS = 0x8
	// Position of SMS field.
	GPTIM_SMCR_SMS_Pos = 0x0
	// Bit mask of SMS field.
	GPTIM_SMCR_SMS_Msk = 0x7

	// DIER: DMA/Interrupt enable register
	// Position of CC4DE field.
	GPTIM_DIER_CC4DE_Pos = 0xc
	// Bit mask of CC4DE field.
	GPTIM_DIER_CC4DE_Msk = 0x1000
	// Bit CC4DE.
	GPTIM_DIER_CC4DE = 0x1000
	// Position of CC3DE field.
	GPTIM_DIER_CC3DE_Pos = 0xb
	// Bit mask of CC3DE field.
	GPTIM_DIER_CC3DE_Msk = 0x800
	// Bit CC3DE.
	GPTIM_DIER_CC3DE = 0x800
	// Position of CC2DE field.
	GPTIM_DIER_CC2DE_Pos = 0xa
	// Bit mask of CC2DE field.
	GPTIM_DIER_CC2DE_Msk = 0x400
	// Bit CC2DE.
	GPTIM_DIER_CC2DE = 0x400
	// Position of CC1DE field.
	GPTIM_DIER_CC1DE_Pos = 0x9
	// Bit mask of CC1DE field.
	GPTIM_DIER_CC1DE_Msk = 0x200
	// Bit CC1DE.
	GPTIM_DIER_CC1DE = 0x200
	// Position of UDE field.
	GPTIM_DIER_UDE_Pos = 0x8
	// Bit mask of UDE field.
	GPTIM_DIER_UDE_Msk = 0x100
	// Bit UDE.
	GPTIM_DIER_UDE = 0x100
	// Position of TIE field.
	GPTIM_DIER_TIE_Pos = 0x6
	// Bit mask of TIE field.
	GPTIM_DIER_TIE_Msk = 0x40
	// Bit TIE.
	GPTIM_DIER_TIE = 0x40
	// Position of CC4IE field.
	GPTIM_DIER_CC4IE_Pos = 0x4
	// Bit mask of CC4IE field.
	GPTIM_DIER_CC4IE_Msk = 0x10
	// Bit CC4IE.
	GPTIM_DIER_CC4IE = 0x10
	// Position of CC3IE field.
	GPTIM_DIER_CC3IE_Pos = 0x3
	// Bit mask of CC3IE field.
	GPTIM_DIER_CC3IE_Msk = 0x8
	// Bit CC3IE.
	GPTIM_DIER_CC3IE = 0x8
	// Position of CC2IE field.
	GPTIM_DIER_CC2IE_Pos = 0x2
	// Bit mask of CC2IE field.
	GPTIM_DIER_CC2IE_Msk = 0x4
	// Bit CC2IE.
	GPTIM_DIER_CC2IE = 0x4
	// Position of CC1IE field.
	GPTIM_DIER_CC1IE_Pos = 0x1
	// Bit mask of CC1IE field.
	GPTIM_DIER_CC1IE_Msk = 0x2
	// Bit CC1IE.
	GPTIM_DIER_CC1IE = 0x2
	// Position of UIE field.
	GPTIM_DIER_UIE_Pos = 0x0
	// Bit mask of UIE field.
	GPTIM_DIER_UIE_Msk = 0x1
	// Bit UIE.
	GPTIM_DIER_UIE = 0x1

	// SR: status register
	// Position of CC4OF field.
	GPTIM_SR_CC4OF_Pos = 0xc
	// Bit mask of CC4OF field.
	GPTIM_SR_CC4OF_Msk = 0x1000
	// Bit CC4OF.
	GPTIM_SR_CC4OF = 0x1000
	// Position of CC3OF field.
	GPTIM_SR_CC3OF_Pos = 0xb
	// Bit mask of CC3OF field.
	GPTIM_SR_CC3OF_Msk = 0x800
	// Bit CC3OF.
	GPTIM_SR_CC3OF = 0x800
	// Position of CC2OF field.
	GPTIM_SR_CC2OF_Pos = 0xa
	// Bit mask of CC2OF field.
	GPTIM_SR_CC2OF_Msk = 0x400
	// Bit CC2OF.
	GPTIM_SR_CC2OF = 0x400
	// Position of CC1OF field.
	GPTIM_SR_CC1OF_Pos = 0x9
	// Bit mask of CC1OF field.
	GPTIM_SR_CC1OF_Msk = 0x200
	// Bit CC1OF.
	GPTIM_SR_CC1OF = 0x200
	// Position of TIF field.
	GPTIM_SR_TIF_Pos = 0x6
	// Bit mask of TIF field.
	GPTIM_SR_TIF_Msk = 0x40
	// Bit TIF.
	GPTIM_SR_TIF = 0x40
	// Position of CC4IF field.
	GPTIM_SR_CC4IF_Pos = 0x4
	// Bit mask of CC4IF field.
	GPTIM_SR_CC4IF_Msk = 0x10
	// Bit CC4IF.
	GPTIM_SR_CC4IF = 0x10
	// Position of CC3IF field.
	GPTIM_SR_CC3IF_Pos = 0x3
	// Bit mask of CC3IF field.
	GPTIM_SR_CC3IF_Msk = 0x8
	// Bit CC3IF.
	GPTIM_SR_CC3IF = 0x8
	// Position of CC2IF field.
	GPTIM_SR_CC2IF_Pos = 0x2
	// Bit mask of CC2IF field.
	GPTIM_SR_CC2IF_Msk = 0x4
	// Bit CC2IF.
	GPTIM_SR_CC2IF = 0x4
	// Position of CC1IF field.
	GPTIM_SR_CC1IF_Pos = 0x1
	// Bit mask of CC1IF field.
	GPTIM_SR_CC1IF_Msk = 0x2
	// Bit CC1IF.
	GPTIM_SR_CC1IF = 0x2
	// Position of UIF field.
	GPTIM_SR_UIF_Pos = 0x0
	// Bit mask of UIF field.
	GPTIM_SR_UIF_Msk = 0x1
	// Bit UIF.
	GPTIM_SR_UIF = 0x1

	// EGR: event generation register
	// Position of TG field.
	GPTIM_EGR_TG_Pos = 0x6
	// Bit mask of TG field.
	GPTIM_EGR_TG_Msk = 0x40
	// Bit TG.
	GPTIM_EGR_TG = 0x40
	// Position of CC4G field.
	GPTIM_EGR_CC4G_Pos = 0x4
	// Bit mask of CC4G field.
	GPTIM_EGR_CC4G_Msk = 0x10
	// Bit CC4G.
	GPTIM_EGR_CC4G = 0x10
	// Position of CC3G field.
	GPTIM_EGR_CC3G_Pos = 0x3
	// Bit mask of CC3G field.
	GPTIM_EGR_CC3G_Msk = 0x8
	// Bit CC3G.
	GPTIM_EGR_CC3G = 0x8
	// Position of CC2G field.
	GPTIM_EGR_CC2G_Pos = 0x2
	// Bit mask of CC2G field.
	GPTIM_EGR_CC2G_Msk = 0x4
	// Bit CC2G.
	GPTIM_EGR_CC2G = 0x4
	// Position of CC1G field.
	GPTIM_EGR_CC1G_Pos = 0x1
	// Bit mask of CC1G field.
	GPTIM_EGR_CC1G_Msk = 0x2
	// Bit CC1G.
	GPTIM_EGR_CC1G = 0x2
	// Position of UG field.
	GPTIM_EGR_UG_Pos = 0x0
	// Bit mask of UG field.
	GPTIM_EGR_UG_Msk = 0x1
	// Bit UG.
	GPTIM_EGR_UG = 0x1

	// CCMR1_Output: capture/compare mode register 1 (output mode)
	// Position of OC2M_3 field.
	GPTIM_CCMR1_Output_OC2M_3_Pos = 0x18
	// Bit mask of OC2M_3 field.
	GPTIM_CCMR1_Output_OC2M_3_Msk = 0x1000000
	// Bit OC2M_3.
	GPTIM_CCMR1_Output_OC2M_3 = 0x1000000
	// Position of OC1M_3 field.
	GPTIM_CCMR1_Output_OC1M_3_Pos = 0x10
	// Bit mask of OC1M_3 field.
	GPTIM_CCMR1_Output_OC1M_3_Msk = 0x10000
	// Bit OC1M_3.
	GPTIM_CCMR1_Output_OC1M_3 = 0x10000
	// Position of OC2CE field.
	GPTIM_CCMR1_Output_OC2CE_Pos = 0xf
	// Bit mask of OC2CE field.
	GPTIM_CCMR1_Output_OC2CE_Msk = 0x8000
	// Bit OC2CE.
	GPTIM_CCMR1_Output_OC2CE = 0x8000
	// Position of OC2M field.
	GPTIM_CCMR1_Output_OC2M_Pos = 0xc
	// Bit mask of OC2M field.
	GPTIM_CCMR1_Output_OC2M_Msk = 0x7000
	// Position of OC2PE field.
	GPTIM_CCMR1_Output_OC2PE_Pos = 0xb
	// Bit mask of OC2PE field.
	GPTIM_CCMR1_Output_OC2PE_Msk = 0x800
	// Bit OC2PE.
	GPTIM_CCMR1_Output_OC2PE = 0x800
	// Position of OC2FE field.
	GPTIM_CCMR1_Output_OC2FE_Pos = 0xa
	// Bit mask of OC2FE field.
	GPTIM_CCMR1_Output_OC2FE_Msk = 0x400
	// Bit OC2FE.
	GPTIM_CCMR1_Output_OC2FE = 0x400
	// Position of CC2S field.
	GPTIM_CCMR1_Output_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	GPTIM_CCMR1_Output_CC2S_Msk = 0x300
	// Position of OC1CE field.
	GPTIM_CCMR1_Output_OC1CE_Pos = 0x7
	// Bit mask of OC1CE field.
	GPTIM_CCMR1_Output_OC1CE_Msk = 0x80
	// Bit OC1CE.
	GPTIM_CCMR1_Output_OC1CE = 0x80
	// Position of OC1M field.
	GPTIM_CCMR1_Output_OC1M_Pos = 0x4
	// Bit mask of OC1M field.
	GPTIM_CCMR1_Output_OC1M_Msk = 0x70
	// Position of OC1PE field.
	GPTIM_CCMR1_Output_OC1PE_Pos = 0x3
	// Bit mask of OC1PE field.
	GPTIM_CCMR1_Output_OC1PE_Msk = 0x8
	// Bit OC1PE.
	GPTIM_CCMR1_Output_OC1PE = 0x8
	// Position of OC1FE field.
	GPTIM_CCMR1_Output_OC1FE_Pos = 0x2
	// Bit mask of OC1FE field.
	GPTIM_CCMR1_Output_OC1FE_Msk = 0x4
	// Bit OC1FE.
	GPTIM_CCMR1_Output_OC1FE = 0x4
	// Position of CC1S field.
	GPTIM_CCMR1_Output_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	GPTIM_CCMR1_Output_CC1S_Msk = 0x3

	// CCMR1_Input: capture/compare mode register 1 (input mode)
	// Position of IC2F field.
	GPTIM_CCMR1_Input_IC2F_Pos = 0xc
	// Bit mask of IC2F field.
	GPTIM_CCMR1_Input_IC2F_Msk = 0xf000
	// Position of IC2PSC field.
	GPTIM_CCMR1_Input_IC2PSC_Pos = 0xa
	// Bit mask of IC2PSC field.
	GPTIM_CCMR1_Input_IC2PSC_Msk = 0xc00
	// Position of CC2S field.
	GPTIM_CCMR1_Input_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	GPTIM_CCMR1_Input_CC2S_Msk = 0x300
	// Position of IC1F field.
	GPTIM_CCMR1_Input_IC1F_Pos = 0x4
	// Bit mask of IC1F field.
	GPTIM_CCMR1_Input_IC1F_Msk = 0xf0
	// Position of IC1PSC field.
	GPTIM_CCMR1_Input_IC1PSC_Pos = 0x2
	// Bit mask of IC1PSC field.
	GPTIM_CCMR1_Input_IC1PSC_Msk = 0xc
	// Position of CC1S field.
	GPTIM_CCMR1_Input_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	GPTIM_CCMR1_Input_CC1S_Msk = 0x3

	// CCMR2_Output: capture/compare mode register 2 (output mode)
	// Position of OC4M_3 field.
	GPTIM_CCMR2_Output_OC4M_3_Pos = 0x18
	// Bit mask of OC4M_3 field.
	GPTIM_CCMR2_Output_OC4M_3_Msk = 0x1000000
	// Bit OC4M_3.
	GPTIM_CCMR2_Output_OC4M_3 = 0x1000000
	// Position of OC3M_3 field.
	GPTIM_CCMR2_Output_OC3M_3_Pos = 0x10
	// Bit mask of OC3M_3 field.
	GPTIM_CCMR2_Output_OC3M_3_Msk = 0x10000
	// Bit OC3M_3.
	GPTIM_CCMR2_Output_OC3M_3 = 0x10000
	// Position of OC4CE field.
	GPTIM_CCMR2_Output_OC4CE_Pos = 0xf
	// Bit mask of OC4CE field.
	GPTIM_CCMR2_Output_OC4CE_Msk = 0x8000
	// Bit OC4CE.
	GPTIM_CCMR2_Output_OC4CE = 0x8000
	// Position of OC4M field.
	GPTIM_CCMR2_Output_OC4M_Pos = 0xc
	// Bit mask of OC4M field.
	GPTIM_CCMR2_Output_OC4M_Msk = 0x7000
	// Position of OC4PE field.
	GPTIM_CCMR2_Output_OC4PE_Pos = 0xb
	// Bit mask of OC4PE field.
	GPTIM_CCMR2_Output_OC4PE_Msk = 0x800
	// Bit OC4PE.
	GPTIM_CCMR2_Output_OC4PE = 0x800
	// Position of OC4FE field.
	GPTIM_CCMR2_Output_OC4FE_Pos = 0xa
	// Bit mask of OC4FE field.
	GPTIM_CCMR2_Output_OC4FE_Msk = 0x400
	// Bit OC4FE.
	GPTIM_CCMR2_Output_OC4FE = 0x400
	// Position of CC4S field.
	GPTIM_CCMR2_Output_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	GPTIM_CCMR2_Output_CC4S_Msk = 0x300
	// Position of OC3CE field.
	GPTIM_CCMR2_Output_OC3CE_Pos = 0x7
	// Bit mask of OC3CE field.
	GPTIM_CCMR2_Output_OC3CE_Msk = 0x80
	// Bit OC3CE.
	GPTIM_CCMR2_Output_OC3CE = 0x80
	// Position of OC3M field.
	GPTIM_CCMR2_Output_OC3M_Pos = 0x4
	// Bit mask of OC3M field.
	GPTIM_CCMR2_Output_OC3M_Msk = 0x70
	// Position of OC3PE field.
	GPTIM_CCMR2_Output_OC3PE_Pos = 0x3
	// Bit mask of OC3PE field.
	GPTIM_CCMR2_Output_OC3PE_Msk = 0x8
	// Bit OC3PE.
	GPTIM_CCMR2_Output_OC3PE = 0x8
	// Position of OC3FE field.
	GPTIM_CCMR2_Output_OC3FE_Pos = 0x2
	// Bit mask of OC3FE field.
	GPTIM_CCMR2_Output_OC3FE_Msk = 0x4
	// Bit OC3FE.
	GPTIM_CCMR2_Output_OC3FE = 0x4
	// Position of CC3S field.
	GPTIM_CCMR2_Output_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	GPTIM_CCMR2_Output_CC3S_Msk = 0x3

	// CCMR2_Input: capture/compare mode register 2 (input mode)
	// Position of IC4F field.
	GPTIM_CCMR2_Input_IC4F_Pos = 0xc
	// Bit mask of IC4F field.
	GPTIM_CCMR2_Input_IC4F_Msk = 0xf000
	// Position of IC4PSC field.
	GPTIM_CCMR2_Input_IC4PSC_Pos = 0xa
	// Bit mask of IC4PSC field.
	GPTIM_CCMR2_Input_IC4PSC_Msk = 0xc00
	// Position of CC4S field.
	GPTIM_CCMR2_Input_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	GPTIM_CCMR2_Input_CC4S_Msk = 0x300
	// Position of IC3F field.
	GPTIM_CCMR2_Input_IC3F_Pos = 0x4
	// Bit mask of IC3F field.
	GPTIM_CCMR2_Input_IC3F_Msk = 0xf0
	// Position of IC3PSC field.
	GPTIM_CCMR2_Input_IC3PSC_Pos = 0x2
	// Bit mask of IC3PSC field.
	GPTIM_CCMR2_Input_IC3PSC_Msk = 0xc
	// Position of CC3S field.
	GPTIM_CCMR2_Input_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	GPTIM_CCMR2_Input_CC3S_Msk = 0x3

	// CCER: capture/compare enable register
	// Position of CC4NP field.
	GPTIM_CCER_CC4NP_Pos = 0xf
	// Bit mask of CC4NP field.
	GPTIM_CCER_CC4NP_Msk = 0x8000
	// Bit CC4NP.
	GPTIM_CCER_CC4NP = 0x8000
	// Position of CC4P field.
	GPTIM_CCER_CC4P_Pos = 0xd
	// Bit mask of CC4P field.
	GPTIM_CCER_CC4P_Msk = 0x2000
	// Bit CC4P.
	GPTIM_CCER_CC4P = 0x2000
	// Position of CC4E field.
	GPTIM_CCER_CC4E_Pos = 0xc
	// Bit mask of CC4E field.
	GPTIM_CCER_CC4E_Msk = 0x1000
	// Bit CC4E.
	GPTIM_CCER_CC4E = 0x1000
	// Position of CC3NP field.
	GPTIM_CCER_CC3NP_Pos = 0xb
	// Bit mask of CC3NP field.
	GPTIM_CCER_CC3NP_Msk = 0x800
	// Bit CC3NP.
	GPTIM_CCER_CC3NP = 0x800
	// Position of CC3P field.
	GPTIM_CCER_CC3P_Pos = 0x9
	// Bit mask of CC3P field.
	GPTIM_CCER_CC3P_Msk = 0x200
	// Bit CC3P.
	GPTIM_CCER_CC3P = 0x200
	// Position of CC3E field.
	GPTIM_CCER_CC3E_Pos = 0x8
	// Bit mask of CC3E field.
	GPTIM_CCER_CC3E_Msk = 0x100
	// Bit CC3E.
	GPTIM_CCER_CC3E = 0x100
	// Position of CC2NP field.
	GPTIM_CCER_CC2NP_Pos = 0x7
	// Bit mask of CC2NP field.
	GPTIM_CCER_CC2NP_Msk = 0x80
	// Bit CC2NP.
	GPTIM_CCER_CC2NP = 0x80
	// Position of CC2P field.
	GPTIM_CCER_CC2P_Pos = 0x5
	// Bit mask of CC2P field.
	GPTIM_CCER_CC2P_Msk = 0x20
	// Bit CC2P.
	GPTIM_CCER_CC2P = 0x20
	// Position of CC2E field.
	GPTIM_CCER_CC2E_Pos = 0x4
	// Bit mask of CC2E field.
	GPTIM_CCER_CC2E_Msk = 0x10
	// Bit CC2E.
	GPTIM_CCER_CC2E = 0x10
	// Position of CC1NP field.
	GPTIM_CCER_CC1NP_Pos = 0x3
	// Bit mask of CC1NP field.
	GPTIM_CCER_CC1NP_Msk = 0x8
	// Bit CC1NP.
	GPTIM_CCER_CC1NP = 0x8
	// Position of CC1P field.
	GPTIM_CCER_CC1P_Pos = 0x1
	// Bit mask of CC1P field.
	GPTIM_CCER_CC1P_Msk = 0x2
	// Bit CC1P.
	GPTIM_CCER_CC1P = 0x2
	// Position of CC1E field.
	GPTIM_CCER_CC1E_Pos = 0x0
	// Bit mask of CC1E field.
	GPTIM_CCER_CC1E_Msk = 0x1
	// Bit CC1E.
	GPTIM_CCER_CC1E = 0x1

	// CNT: counter
	// Position of CNT_H field.
	GPTIM_CNT_CNT_H_Pos = 0x10
	// Bit mask of CNT_H field.
	GPTIM_CNT_CNT_H_Msk = 0xffff0000
	// Position of CNT_L field.
	GPTIM_CNT_CNT_L_Pos = 0x0
	// Bit mask of CNT_L field.
	GPTIM_CNT_CNT_L_Msk = 0xffff

	// PSC: prescaler
	// Position of PSC field.
	GPTIM_PSC_PSC_Pos = 0x0
	// Bit mask of PSC field.
	GPTIM_PSC_PSC_Msk = 0xffff

	// ARR: auto-reload register
	// Position of ARR_H field.
	GPTIM_ARR_ARR_H_Pos = 0x10
	// Bit mask of ARR_H field.
	GPTIM_ARR_ARR_H_Msk = 0xffff0000
	// Position of ARR_L field.
	GPTIM_ARR_ARR_L_Pos = 0x0
	// Bit mask of ARR_L field.
	GPTIM_ARR_ARR_L_Msk = 0xffff

	// CCR1: capture/compare register 1
	// Position of CCR1_H field.
	GPTIM_CCR1_CCR1_H_Pos = 0x10
	// Bit mask of CCR1_H field.
	GPTIM_CCR1_CCR1_H_Msk = 0xffff0000
	// Position of CCR1_L field.
	GPTIM_CCR1_CCR1_L_Pos = 0x0
	// Bit mask of CCR1_L field.
	GPTIM_CCR1_CCR1_L_Msk = 0xffff

	// CCR2: capture/compare register 2
	// Position of CCR2_H field.
	GPTIM_CCR2_CCR2_H_Pos = 0x10
	// Bit mask of CCR2_H field.
	GPTIM_CCR2_CCR2_H_Msk = 0xffff0000
	// Position of CCR2_L field.
	GPTIM_CCR2_CCR2_L_Pos = 0x0
	// Bit mask of CCR2_L field.
	GPTIM_CCR2_CCR2_L_Msk = 0xffff

	// CCR3: capture/compare register 3
	// Position of CCR3_H field.
	GPTIM_CCR3_CCR3_H_Pos = 0x10
	// Bit mask of CCR3_H field.
	GPTIM_CCR3_CCR3_H_Msk = 0xffff0000
	// Position of CCR3_L field.
	GPTIM_CCR3_CCR3_L_Pos = 0x0
	// Bit mask of CCR3_L field.
	GPTIM_CCR3_CCR3_L_Msk = 0xffff

	// CCR4: capture/compare register 4
	// Position of CCR4_H field.
	GPTIM_CCR4_CCR4_H_Pos = 0x10
	// Bit mask of CCR4_H field.
	GPTIM_CCR4_CCR4_H_Msk = 0xffff0000
	// Position of CCR4_L field.
	GPTIM_CCR4_CCR4_L_Pos = 0x0
	// Bit mask of CCR4_L field.
	GPTIM_CCR4_CCR4_L_Msk = 0xffff

	// DCR: DMA control register
	// Position of DBL field.
	GPTIM_DCR_DBL_Pos = 0x8
	// Bit mask of DBL field.
	GPTIM_DCR_DBL_Msk = 0x1f00
	// Position of DBA field.
	GPTIM_DCR_DBA_Pos = 0x0
	// Bit mask of DBA field.
	GPTIM_DCR_DBA_Msk = 0x1f

	// DMAR: DMA address for full transfer
	// Position of DMAB field.
	GPTIM_DMAR_DMAB_Pos = 0x0
	// Bit mask of DMAB field.
	GPTIM_DMAR_DMAB_Msk = 0xffff

	// TIM2_OR1: TIM2 option register
	// Position of TI4_RMP field.
	GPTIM_TIM2_OR1_TI4_RMP_Pos = 0x2
	// Bit mask of TI4_RMP field.
	GPTIM_TIM2_OR1_TI4_RMP_Msk = 0xc
	// Position of ETR_RMP field.
	GPTIM_TIM2_OR1_ETR_RMP_Pos = 0x1
	// Bit mask of ETR_RMP field.
	GPTIM_TIM2_OR1_ETR_RMP_Msk = 0x2
	// Bit ETR_RMP.
	GPTIM_TIM2_OR1_ETR_RMP = 0x2

	// TIM2_AF1: TIM2 alternate function option register 1
	// Position of ETRSEL field.
	GPTIM_TIM2_AF1_ETRSEL_Pos = 0xe
	// Bit mask of ETRSEL field.
	GPTIM_TIM2_AF1_ETRSEL_Msk = 0x3c000

	// TIM2_TISEL: TIM2 timer input selection register
	// Position of TI1SEL field.
	GPTIM_TIM2_TISEL_TI1SEL_Pos = 0x0
	// Bit mask of TI1SEL field.
	GPTIM_TIM2_TISEL_TI1SEL_Msk = 0xf
	// Position of TI2SEL field.
	GPTIM_TIM2_TISEL_TI2SEL_Pos = 0x8
	// Bit mask of TI2SEL field.
	GPTIM_TIM2_TISEL_TI2SEL_Msk = 0xf00
)

// Bitfields for TZIC: TrustZone Interrupt Control
const (
	// IER1: TZIC interrupt enable register 1
	// Position of TZICIE field.
	TZSC_IER1_TZICIE_Pos = 0x0
	// Bit mask of TZICIE field.
	TZSC_IER1_TZICIE_Msk = 0x1
	// Bit TZICIE.
	TZSC_IER1_TZICIE = 0x1
	// Position of TZSCIE field.
	TZSC_IER1_TZSCIE_Pos = 0x1
	// Bit mask of TZSCIE field.
	TZSC_IER1_TZSCIE_Msk = 0x2
	// Bit TZSCIE.
	TZSC_IER1_TZSCIE = 0x2
	// Position of AESIE field.
	TZSC_IER1_AESIE_Pos = 0x2
	// Bit mask of AESIE field.
	TZSC_IER1_AESIE_Msk = 0x4
	// Bit AESIE.
	TZSC_IER1_AESIE = 0x4
	// Position of RNGIE field.
	TZSC_IER1_RNGIE_Pos = 0x3
	// Bit mask of RNGIE field.
	TZSC_IER1_RNGIE_Msk = 0x8
	// Bit RNGIE.
	TZSC_IER1_RNGIE = 0x8
	// Position of SUBGHZSPIIE field.
	TZSC_IER1_SUBGHZSPIIE_Pos = 0x4
	// Bit mask of SUBGHZSPIIE field.
	TZSC_IER1_SUBGHZSPIIE_Msk = 0x10
	// Bit SUBGHZSPIIE.
	TZSC_IER1_SUBGHZSPIIE = 0x10
	// Position of PWRIE field.
	TZSC_IER1_PWRIE_Pos = 0x5
	// Bit mask of PWRIE field.
	TZSC_IER1_PWRIE_Msk = 0x20
	// Bit PWRIE.
	TZSC_IER1_PWRIE = 0x20
	// Position of FLASHIFIE field.
	TZSC_IER1_FLASHIFIE_Pos = 0x6
	// Bit mask of FLASHIFIE field.
	TZSC_IER1_FLASHIFIE_Msk = 0x40
	// Bit FLASHIFIE.
	TZSC_IER1_FLASHIFIE = 0x40
	// Position of DMA1IE field.
	TZSC_IER1_DMA1IE_Pos = 0x7
	// Bit mask of DMA1IE field.
	TZSC_IER1_DMA1IE_Msk = 0x80
	// Bit DMA1IE.
	TZSC_IER1_DMA1IE = 0x80
	// Position of DMA2IE field.
	TZSC_IER1_DMA2IE_Pos = 0x8
	// Bit mask of DMA2IE field.
	TZSC_IER1_DMA2IE_Msk = 0x100
	// Bit DMA2IE.
	TZSC_IER1_DMA2IE = 0x100
	// Position of DMAMUX1IE field.
	TZSC_IER1_DMAMUX1IE_Pos = 0x9
	// Bit mask of DMAMUX1IE field.
	TZSC_IER1_DMAMUX1IE_Msk = 0x200
	// Bit DMAMUX1IE.
	TZSC_IER1_DMAMUX1IE = 0x200
	// Position of FLASHIE field.
	TZSC_IER1_FLASHIE_Pos = 0xa
	// Bit mask of FLASHIE field.
	TZSC_IER1_FLASHIE_Msk = 0x400
	// Bit FLASHIE.
	TZSC_IER1_FLASHIE = 0x400
	// Position of SRAM1IE field.
	TZSC_IER1_SRAM1IE_Pos = 0xb
	// Bit mask of SRAM1IE field.
	TZSC_IER1_SRAM1IE_Msk = 0x800
	// Bit SRAM1IE.
	TZSC_IER1_SRAM1IE = 0x800
	// Position of SRAM2IE field.
	TZSC_IER1_SRAM2IE_Pos = 0xc
	// Bit mask of SRAM2IE field.
	TZSC_IER1_SRAM2IE_Msk = 0x1000
	// Bit SRAM2IE.
	TZSC_IER1_SRAM2IE = 0x1000
	// Position of PKAIE field.
	TZSC_IER1_PKAIE_Pos = 0xd
	// Bit mask of PKAIE field.
	TZSC_IER1_PKAIE_Msk = 0x2000
	// Bit PKAIE.
	TZSC_IER1_PKAIE = 0x2000

	// MISR1: TZIC status register 1
	// Position of TZICMF field.
	TZSC_MISR1_TZICMF_Pos = 0x0
	// Bit mask of TZICMF field.
	TZSC_MISR1_TZICMF_Msk = 0x1
	// Bit TZICMF.
	TZSC_MISR1_TZICMF = 0x1
	// Position of TZSCMF field.
	TZSC_MISR1_TZSCMF_Pos = 0x1
	// Bit mask of TZSCMF field.
	TZSC_MISR1_TZSCMF_Msk = 0x2
	// Bit TZSCMF.
	TZSC_MISR1_TZSCMF = 0x2
	// Position of AESMF field.
	TZSC_MISR1_AESMF_Pos = 0x2
	// Bit mask of AESMF field.
	TZSC_MISR1_AESMF_Msk = 0x4
	// Bit AESMF.
	TZSC_MISR1_AESMF = 0x4
	// Position of RNGMF field.
	TZSC_MISR1_RNGMF_Pos = 0x3
	// Bit mask of RNGMF field.
	TZSC_MISR1_RNGMF_Msk = 0x8
	// Bit RNGMF.
	TZSC_MISR1_RNGMF = 0x8
	// Position of SUBGHZSPIMF field.
	TZSC_MISR1_SUBGHZSPIMF_Pos = 0x4
	// Bit mask of SUBGHZSPIMF field.
	TZSC_MISR1_SUBGHZSPIMF_Msk = 0x10
	// Bit SUBGHZSPIMF.
	TZSC_MISR1_SUBGHZSPIMF = 0x10
	// Position of PWRMF field.
	TZSC_MISR1_PWRMF_Pos = 0x5
	// Bit mask of PWRMF field.
	TZSC_MISR1_PWRMF_Msk = 0x20
	// Bit PWRMF.
	TZSC_MISR1_PWRMF = 0x20
	// Position of FLASHIFMF field.
	TZSC_MISR1_FLASHIFMF_Pos = 0x6
	// Bit mask of FLASHIFMF field.
	TZSC_MISR1_FLASHIFMF_Msk = 0x40
	// Bit FLASHIFMF.
	TZSC_MISR1_FLASHIFMF = 0x40
	// Position of DMA1MF field.
	TZSC_MISR1_DMA1MF_Pos = 0x7
	// Bit mask of DMA1MF field.
	TZSC_MISR1_DMA1MF_Msk = 0x80
	// Bit DMA1MF.
	TZSC_MISR1_DMA1MF = 0x80
	// Position of DMA2MF field.
	TZSC_MISR1_DMA2MF_Pos = 0x8
	// Bit mask of DMA2MF field.
	TZSC_MISR1_DMA2MF_Msk = 0x100
	// Bit DMA2MF.
	TZSC_MISR1_DMA2MF = 0x100
	// Position of DMAMUX1MF field.
	TZSC_MISR1_DMAMUX1MF_Pos = 0x9
	// Bit mask of DMAMUX1MF field.
	TZSC_MISR1_DMAMUX1MF_Msk = 0x200
	// Bit DMAMUX1MF.
	TZSC_MISR1_DMAMUX1MF = 0x200
	// Position of FLASHMF field.
	TZSC_MISR1_FLASHMF_Pos = 0xa
	// Bit mask of FLASHMF field.
	TZSC_MISR1_FLASHMF_Msk = 0x400
	// Bit FLASHMF.
	TZSC_MISR1_FLASHMF = 0x400
	// Position of SRAM1MF field.
	TZSC_MISR1_SRAM1MF_Pos = 0xb
	// Bit mask of SRAM1MF field.
	TZSC_MISR1_SRAM1MF_Msk = 0x800
	// Bit SRAM1MF.
	TZSC_MISR1_SRAM1MF = 0x800
	// Position of SRAM2MF field.
	TZSC_MISR1_SRAM2MF_Pos = 0xc
	// Bit mask of SRAM2MF field.
	TZSC_MISR1_SRAM2MF_Msk = 0x1000
	// Bit SRAM2MF.
	TZSC_MISR1_SRAM2MF = 0x1000
	// Position of PKAMF field.
	TZSC_MISR1_PKAMF_Pos = 0xd
	// Bit mask of PKAMF field.
	TZSC_MISR1_PKAMF_Msk = 0x2000
	// Bit PKAMF.
	TZSC_MISR1_PKAMF = 0x2000

	// ICR1: TZIC interrupt status clear register 1
	// Position of TZICCF field.
	TZSC_ICR1_TZICCF_Pos = 0x0
	// Bit mask of TZICCF field.
	TZSC_ICR1_TZICCF_Msk = 0x1
	// Bit TZICCF.
	TZSC_ICR1_TZICCF = 0x1
	// Position of TZSCCF field.
	TZSC_ICR1_TZSCCF_Pos = 0x1
	// Bit mask of TZSCCF field.
	TZSC_ICR1_TZSCCF_Msk = 0x2
	// Bit TZSCCF.
	TZSC_ICR1_TZSCCF = 0x2
	// Position of AESCF field.
	TZSC_ICR1_AESCF_Pos = 0x2
	// Bit mask of AESCF field.
	TZSC_ICR1_AESCF_Msk = 0x4
	// Bit AESCF.
	TZSC_ICR1_AESCF = 0x4
	// Position of RNGCF field.
	TZSC_ICR1_RNGCF_Pos = 0x3
	// Bit mask of RNGCF field.
	TZSC_ICR1_RNGCF_Msk = 0x8
	// Bit RNGCF.
	TZSC_ICR1_RNGCF = 0x8
	// Position of SUBGHZSPICF field.
	TZSC_ICR1_SUBGHZSPICF_Pos = 0x4
	// Bit mask of SUBGHZSPICF field.
	TZSC_ICR1_SUBGHZSPICF_Msk = 0x10
	// Bit SUBGHZSPICF.
	TZSC_ICR1_SUBGHZSPICF = 0x10
	// Position of PWRCF field.
	TZSC_ICR1_PWRCF_Pos = 0x5
	// Bit mask of PWRCF field.
	TZSC_ICR1_PWRCF_Msk = 0x20
	// Bit PWRCF.
	TZSC_ICR1_PWRCF = 0x20
	// Position of FLASHIFCF field.
	TZSC_ICR1_FLASHIFCF_Pos = 0x6
	// Bit mask of FLASHIFCF field.
	TZSC_ICR1_FLASHIFCF_Msk = 0x40
	// Bit FLASHIFCF.
	TZSC_ICR1_FLASHIFCF = 0x40
	// Position of DMA1CF field.
	TZSC_ICR1_DMA1CF_Pos = 0x7
	// Bit mask of DMA1CF field.
	TZSC_ICR1_DMA1CF_Msk = 0x80
	// Bit DMA1CF.
	TZSC_ICR1_DMA1CF = 0x80
	// Position of DMA2CF field.
	TZSC_ICR1_DMA2CF_Pos = 0x8
	// Bit mask of DMA2CF field.
	TZSC_ICR1_DMA2CF_Msk = 0x100
	// Bit DMA2CF.
	TZSC_ICR1_DMA2CF = 0x100
	// Position of DMAMUX1CF field.
	TZSC_ICR1_DMAMUX1CF_Pos = 0x9
	// Bit mask of DMAMUX1CF field.
	TZSC_ICR1_DMAMUX1CF_Msk = 0x200
	// Bit DMAMUX1CF.
	TZSC_ICR1_DMAMUX1CF = 0x200
	// Position of FLASHCF field.
	TZSC_ICR1_FLASHCF_Pos = 0xa
	// Bit mask of FLASHCF field.
	TZSC_ICR1_FLASHCF_Msk = 0x400
	// Bit FLASHCF.
	TZSC_ICR1_FLASHCF = 0x400
	// Position of SRAM1CF field.
	TZSC_ICR1_SRAM1CF_Pos = 0xb
	// Bit mask of SRAM1CF field.
	TZSC_ICR1_SRAM1CF_Msk = 0x800
	// Bit SRAM1CF.
	TZSC_ICR1_SRAM1CF = 0x800
	// Position of SRAM2CF field.
	TZSC_ICR1_SRAM2CF_Pos = 0xc
	// Bit mask of SRAM2CF field.
	TZSC_ICR1_SRAM2CF_Msk = 0x1000
	// Bit SRAM2CF.
	TZSC_ICR1_SRAM2CF = 0x1000
	// Position of PKACF field.
	TZSC_ICR1_PKACF_Pos = 0xd
	// Bit mask of PKACF field.
	TZSC_ICR1_PKACF_Msk = 0x2000
	// Bit PKACF.
	TZSC_ICR1_PKACF = 0x2000
)

// Bitfields for VREFBUF: Voltage reference buffer
const (
	// CSR: control and status register
	// Position of VRR field.
	VREFBUF_CSR_VRR_Pos = 0x3
	// Bit mask of VRR field.
	VREFBUF_CSR_VRR_Msk = 0x8
	// Bit VRR.
	VREFBUF_CSR_VRR = 0x8
	// Position of VRS field.
	VREFBUF_CSR_VRS_Pos = 0x2
	// Bit mask of VRS field.
	VREFBUF_CSR_VRS_Msk = 0x4
	// Bit VRS.
	VREFBUF_CSR_VRS = 0x4
	// Position of HIZ field.
	VREFBUF_CSR_HIZ_Pos = 0x1
	// Bit mask of HIZ field.
	VREFBUF_CSR_HIZ_Msk = 0x2
	// Bit HIZ.
	VREFBUF_CSR_HIZ = 0x2
	// Position of ENVR field.
	VREFBUF_CSR_ENVR_Pos = 0x0
	// Bit mask of ENVR field.
	VREFBUF_CSR_ENVR_Msk = 0x1
	// Bit ENVR.
	VREFBUF_CSR_ENVR = 0x1

	// CCR: calibration control register
	// Position of TRIM field.
	VREFBUF_CCR_TRIM_Pos = 0x0
	// Bit mask of TRIM field.
	VREFBUF_CCR_TRIM_Msk = 0x3f
)

// Bitfields for WWDG: System window watchdog
const (
	// CR: Control register
	// Position of WDGA field.
	WWDG_CR_WDGA_Pos = 0x7
	// Bit mask of WDGA field.
	WWDG_CR_WDGA_Msk = 0x80
	// Bit WDGA.
	WWDG_CR_WDGA = 0x80
	// Position of T field.
	WWDG_CR_T_Pos = 0x0
	// Bit mask of T field.
	WWDG_CR_T_Msk = 0x7f

	// CFR: Configuration register
	// Position of WDGTB field.
	WWDG_CFR_WDGTB_Pos = 0xb
	// Bit mask of WDGTB field.
	WWDG_CFR_WDGTB_Msk = 0x3800
	// Position of EWI field.
	WWDG_CFR_EWI_Pos = 0x9
	// Bit mask of EWI field.
	WWDG_CFR_EWI_Msk = 0x200
	// Bit EWI.
	WWDG_CFR_EWI = 0x200
	// Position of W field.
	WWDG_CFR_W_Pos = 0x0
	// Bit mask of W field.
	WWDG_CFR_W_Msk = 0x7f

	// SR: Status register
	// Position of EWIF field.
	WWDG_SR_EWIF_Pos = 0x0
	// Bit mask of EWIF field.
	WWDG_SR_EWIF_Msk = 0x1
	// Bit EWIF.
	WWDG_SR_EWIF = 0x1
)
