/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.5.1
 *
 * Copyright (c) 2022 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 1092 "/build/pyqt6/src/PyQt6-6.2.3/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 29 "/build/pyqt6/src/PyQt6-6.2.3/build/QtCore/sipQtCoreQList2200.cpp"



extern "C" {static void assign_QList_2200(void *, Py_ssize_t, void *);}
static void assign_QList_2200(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QList<float> *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QList<float> *>(sipSrc);
}


extern "C" {static void *array_QList_2200(Py_ssize_t);}
static void *array_QList_2200(Py_ssize_t sipNrElem)
{
    return new  ::QList<float>[sipNrElem];
}


extern "C" {static void *copy_QList_2200(const void *, Py_ssize_t);}
static void *copy_QList_2200(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::QList<float>(reinterpret_cast<const  ::QList<float> *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_QList_2200(void *, int, void *);}
static void release_QList_2200(void *sipCppV, int, void *)
{
     ::QList<float> *sipCpp = reinterpret_cast< ::QList<float> *>(sipCppV);
    delete sipCpp;
}



extern "C" {static int convertTo_QList_2200(PyObject *, void **, int *, PyObject *, void **);}
static int convertTo_QList_2200(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj, void **)
{
     ::QList<float> **sipCppPtr = reinterpret_cast< ::QList<float> **>(sipCppPtrV);

#line 1119 "/build/pyqt6/src/PyQt6-6.2.3/sip/QtCore/qpycore_qlist.sip"
    PyObject *iter = PyObject_GetIter(sipPy);

    if (!sipIsErr)
    {
        PyErr_Clear();
        Py_XDECREF(iter);

        return (iter && !PyBytes_Check(sipPy) && !PyUnicode_Check(sipPy));
    }

    if (!iter)
    {
        *sipIsErr = 1;

        return 0;
    }

    QList<float> *ql = new QList<float>;

    for (Py_ssize_t i = 0; ; ++i)
    {
        PyErr_Clear();
        PyObject *itm = PyIter_Next(iter);

        if (!itm)
        {
            if (PyErr_Occurred())
            {
                delete ql;
                Py_DECREF(iter);
                *sipIsErr = 1;

                return 0;
            }

            break;
        }

        PyErr_Clear();
        double val = PyFloat_AsDouble(itm);

        if (PyErr_Occurred())
        {
            PyErr_Format(PyExc_TypeError,
                    "index %zd has type '%s' but 'float' is expected", i,
                    sipPyTypeName(Py_TYPE(itm)));

            Py_DECREF(itm);
            delete ql;
            Py_DECREF(iter);
            *sipIsErr = 1;

            return 0;
        }

        ql->append(val);

        Py_DECREF(itm);
    }

    Py_DECREF(iter);

    *sipCppPtr = ql;

    return sipGetState(sipTransferObj);
#line 135 "/build/pyqt6/src/PyQt6-6.2.3/build/QtCore/sipQtCoreQList2200.cpp"
}


extern "C" {static PyObject *convertFrom_QList_2200(void *, PyObject *);}
static PyObject *convertFrom_QList_2200(void *sipCppV, PyObject *)
{
    ::QList<float> *sipCpp = reinterpret_cast< ::QList<float> *>(sipCppV);

#line 1096 "/build/pyqt6/src/PyQt6-6.2.3/sip/QtCore/qpycore_qlist.sip"
    PyObject *l = PyList_New(sipCpp->size());

    if (!l)
        return 0;

    for (int i = 0; i < sipCpp->size(); ++i)
    {
        PyObject *pobj = PyFloat_FromDouble(sipCpp->value(i));

        if (!pobj)
        {
            Py_DECREF(l);

            return 0;
        }

        PyList_SetItem(l, i, pobj);
    }

    return l;
#line 165 "/build/pyqt6/src/PyQt6-6.2.3/build/QtCore/sipQtCoreQList2200.cpp"
}


sipMappedTypeDef sipTypeDef_QtCore_QList_2200 = {
    {
        SIP_NULLPTR,
        SIP_TYPE_MAPPED,
        sipNameNr_40714,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        -1,
        {0, 0, 1},
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    assign_QList_2200,
    array_QList_2200,
    copy_QList_2200,
    release_QList_2200,
    convertTo_QList_2200,
    convertFrom_QList_2200
};
