
#include <sbkpython.h>
#include <shiboken.h>
#include <algorithm>
#include <signature.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include <qapp_macro.h>
#include "pyfalkon_python.h"



// Extra includes

// Current module's type array.
PyTypeObject **SbkPyFalkonTypes = nullptr;
// Current module's PyObject pointer.
PyObject *SbkPyFalkonModuleObject = nullptr;
// Current module's converter array.
SbkConverter **SbkPyFalkonTypeConverters = nullptr;
    // Begin code injection
#include <pythonplugin.h>

    // End of code injection

void cleanTypesAttributes(void) {
    if (PY_VERSION_HEX >= 0x03000000 && PY_VERSION_HEX < 0x03060000)
        return; // PYSIDE-953: testbinding crashes in Python 3.5 when hasattr touches types!
    for (int i = 0, imax = SBK_PyFalkon_IDX_COUNT; i < imax; i++) {
        PyObject *pyType = reinterpret_cast<PyObject *>(SbkPyFalkonTypes[i]);
        Shiboken::AutoDecRef attrName(Py_BuildValue("s", "staticMetaObject"));
        if (pyType && PyObject_HasAttr(pyType, attrName))
            PyObject_SetAttr(pyType, attrName, Py_None);
    }
}
// Global functions ------------------------------------------------------------
static PyObject *SbkPyFalkonModule_registerPlugin(PyObject *self, PyObject *pyArg)
{
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: registerPlugin(PluginInterface*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGININTERFACE_IDX]), (pyArg)))) {
        overloadId = 0; // registerPlugin(PluginInterface*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkPyFalkonModule_registerPlugin_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::PluginInterface *cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // registerPlugin(PluginInterface*)
            // Begin code injection
            Py_INCREF(pyArg);
            pyfalkon_register_plugin(cppArg0);

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    SbkPyFalkonModule_registerPlugin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.registerPlugin");
        return {};
}


static PyMethodDef PyFalkon_methods[] = {
    {"registerPlugin", reinterpret_cast<PyCFunction>(SbkPyFalkonModule_registerPlugin), METH_O},
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
void init_WheelHelper(PyObject *module);
void init_WebView(PyObject *module);
void init_WebTab(PyObject *module);
void init_WebPage(PyObject *module);
void init_WebInspector(PyObject *module);
void init_WebHitTestResult(PyObject *module);
void init_UrlInterceptor(PyObject *module);
void init_ToolButton(PyObject *module);
void init_TabbedWebView(PyObject *module);
void init_TabTreeModel(PyObject *module);
void init_TabStackedWidget(PyObject *module);
void init_TabWidget(PyObject *module);
void init_TabMruModel(PyObject *module);
void init_TabModel(PyObject *module);
void init_TabIcon(PyObject *module);
void init_TabContextMenu(PyObject *module);
void init_StatusBar(PyObject *module);
void init_SqueezeLabelV2(PyObject *module);
void init_SqueezeLabelV1(PyObject *module);
void init_SqlQueryJob(PyObject *module);
void init_SqlDatabase(PyObject *module);
void init_SideWidget(PyObject *module);
void init_SideBarManager(PyObject *module);
void init_SideBarInterface(PyObject *module);
void init_Settings(PyObject *module);
void init_SearchToolBar(PyObject *module);
void init_SearchEnginesManager(PyObject *module);
void init_SearchEnginesDialog(PyObject *module);
void init_QzTools(PyObject *module);
void init_QzSettings(PyObject *module);
void init_PyFalkonQz(PyObject *module);
void init_QtSingleApplication(PyObject *module);
void init_Plugins(PyObject *module);
void init_PluginSpec(PyObject *module);
void init_PluginProxy(PyObject *module);
void init_PluginInterface(PyObject *module);
void init_Plugins_Plugin(PyObject *enclosingClass);
void init_PasswordManager(PyObject *module);
void init_PasswordEntry(PyObject *module);
void init_PasswordBackend(PyObject *module);
void init_PageFormData(PyObject *module);
void init_NetworkManager(PyObject *module);
void init_NavigationBar(PyObject *module);
void init_Menu(PyObject *module);
void init_MainApplication(PyObject *module);
void init_LoadRequest(PyObject *module);
void init_LineEdit(PyObject *module);
void init_LocationBar(PyObject *module);
void init_IconProvider(PyObject *module);
void init_HistoryModel(PyObject *module);
void init_History(PyObject *module);
void init_History_HistoryEntry(PyObject *enclosingClass);
void init_HistoryItem(PyObject *module);
void init_ExternalJsObject(PyObject *module);
void init_ExtensionSchemeHandler(PyObject *module);
void init_SearchEnginesManager_Engine(PyObject *enclosingClass);
void init_DownloadManager(PyObject *module);
void init_DownloadItem(PyObject *module);
void init_DownloadManager_DownloadInfo(PyObject *enclosingClass);
void init_DesktopNotificationsFactory(PyObject *module);
void init_DesktopFile(PyObject *module);
void init_DelayedFileWatcher(PyObject *module);
void init_DataPaths(PyObject *module);
void init_TabIcon_Data(PyObject *enclosingClass);
void init_CookieManager(PyObject *module);
void init_CookieJar(PyObject *module);
void init_ComboTabBar(PyObject *module);
void init_TabBar(PyObject *module);
void init_ClickableLabel(PyObject *module);
void init_CheckBoxDialog(PyObject *module);
void init_BrowserWindow(PyObject *module);
void init_BookmarksTools(PyObject *module);
void init_BookmarksModel(PyObject *module);
void init_BookmarksFoldersMenu(PyObject *module);
void init_BookmarksFoldersButton(PyObject *module);
void init_Bookmarks(PyObject *module);
void init_BookmarkItem(PyObject *module);
void init_LocationBar_LoadAction(PyObject *enclosingClass);
void init_AutoSaver(PyObject *module);
void init_AutoFill(PyObject *module);
void init_Action(PyObject *module);
void init_AbstractButtonInterface(PyObject *module);
void init_AbstractButtonInterface_ClickController(PyObject *enclosingClass);

// Required modules' type and converter arrays.
PyTypeObject **SbkPySide2_QtWebEngineCoreTypes;
SbkConverter **SbkPySide2_QtWebEngineCoreTypeConverters;
PyTypeObject **SbkPySide2_QtCoreTypes;
SbkConverter **SbkPySide2_QtCoreTypeConverters;
PyTypeObject **SbkPySide2_QtNetworkTypes;
SbkConverter **SbkPySide2_QtNetworkTypeConverters;
PyTypeObject **SbkPySide2_QtWebEngineWidgetsTypes;
SbkConverter **SbkPySide2_QtWebEngineWidgetsTypeConverters;
PyTypeObject **SbkPySide2_QtGuiTypes;
SbkConverter **SbkPySide2_QtGuiTypeConverters;
PyTypeObject **SbkPySide2_QtWidgetsTypes;
SbkConverter **SbkPySide2_QtWidgetsTypeConverters;
PyTypeObject **SbkPySide2_QtWebChannelTypes;
SbkConverter **SbkPySide2_QtWebChannelTypeConverters;
PyTypeObject **SbkPySide2_QtPrintSupportTypes;
SbkConverter **SbkPySide2_QtPrintSupportTypeConverters;

// Module initialization ------------------------------------------------------------
// Container Type converters.

// C++ to Python conversion for type 'const QList<QObject* > &'.
static PyObject *_constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QObject* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QObject* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QObject* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QObject* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QObject* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX], pyIn))
        return _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QByteArray >'.
static PyObject *_QList_QByteArray__CppToPython__QList_QByteArray_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QByteArray > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QByteArray >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QByteArray cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QByteArray__PythonToCpp__QList_QByteArray_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QByteArray > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QByteArray cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyIn))
        return _QList_QByteArray__PythonToCpp__QList_QByteArray_;
    return {};
}

// C++ to Python conversion for type 'QList<QGraphicsWidget* >'.
static PyObject *_QList_QGraphicsWidgetPTR__CppToPython__QList_QGraphicsWidgetPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QGraphicsWidget* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QGraphicsWidget* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QGraphicsWidget* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSWIDGET_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QGraphicsWidgetPTR__PythonToCpp__QList_QGraphicsWidgetPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QGraphicsWidget* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QGraphicsWidget* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSWIDGET_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QGraphicsWidgetPTR__PythonToCpp__QList_QGraphicsWidgetPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSWIDGET_IDX], pyIn))
        return _QList_QGraphicsWidgetPTR__PythonToCpp__QList_QGraphicsWidgetPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QWidget* >'.
static PyObject *_QList_QWidgetPTR__CppToPython__QList_QWidgetPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QWidget* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QWidget* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QWidget* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QWidgetPTR__PythonToCpp__QList_QWidgetPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QWidget* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QWidget* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QWidgetPTR__PythonToCpp__QList_QWidgetPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX], pyIn))
        return _QList_QWidgetPTR__PythonToCpp__QList_QWidgetPTR_;
    return {};
}

// C++ to Python conversion for type 'const QList<QKeySequence > &'.
static PyObject *_constQList_QKeySequence_REF_CppToPython__constQList_QKeySequence_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QKeySequence > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QKeySequence >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QKeySequence cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QKeySequence_REF_PythonToCpp__constQList_QKeySequence_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QKeySequence > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QKeySequence cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QKeySequence_REF_PythonToCpp__constQList_QKeySequence_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), pyIn))
        return _constQList_QKeySequence_REF_PythonToCpp__constQList_QKeySequence_REF;
    return {};
}

// C++ to Python conversion for type 'QVector<PasswordEntry >'.
static PyObject *_QVector_PasswordEntry__CppToPython__QVector_PasswordEntry_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<PasswordEntry > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<PasswordEntry >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<PasswordEntry >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::PasswordEntry cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_PasswordEntry__PythonToCpp__QVector_PasswordEntry_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<PasswordEntry > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::PasswordEntry cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_PasswordEntry__PythonToCpp__QVector_PasswordEntry__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), pyIn))
        return _QVector_PasswordEntry__PythonToCpp__QVector_PasswordEntry_;
    return {};
}

// C++ to Python conversion for type 'QList<BookmarkItem* >'.
static PyObject *_QList_BookmarkItemPTR__CppToPython__QList_BookmarkItemPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<BookmarkItem* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<BookmarkItem* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::BookmarkItem* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_BookmarkItemPTR__PythonToCpp__QList_BookmarkItemPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<BookmarkItem* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::BookmarkItem* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_BookmarkItemPTR__PythonToCpp__QList_BookmarkItemPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], pyIn))
        return _QList_BookmarkItemPTR__PythonToCpp__QList_BookmarkItemPTR_;
    return {};
}

// C++ to Python conversion for type 'const QMap<QString,QVariant > &'.
static PyObject *_constQMap_QString_QVariant_REF_CppToPython__constQMap_QString_QVariant_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QMap<QString,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QMap<QString,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QString key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _constQMap_QString_QVariant_REF_PythonToCpp__constQMap_QString_QVariant_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__constQMap_QString_QVariant_REF_PythonToCpp__constQMap_QString_QVariant_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return _constQMap_QString_QVariant_REF_PythonToCpp__constQMap_QString_QVariant_REF;
    return {};
}

// C++ to Python conversion for type 'const QList<QVariant > &'.
static PyObject *_constQList_QVariant_REF_CppToPython__constQList_QVariant_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QVariant >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QVariant cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QVariant_REF_PythonToCpp__constQList_QVariant_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QVariant > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QVariant cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QVariant_REF_PythonToCpp__constQList_QVariant_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyIn))
        return _constQList_QVariant_REF_PythonToCpp__constQList_QVariant_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QAction* >'.
static PyObject *_QList_QActionPTR__CppToPython__QList_QActionPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QAction* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QAction* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QAction* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QActionPTR__PythonToCpp__QList_QActionPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QAction* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QAction* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QActionPTR__PythonToCpp__QList_QActionPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], pyIn))
        return _QList_QActionPTR__PythonToCpp__QList_QActionPTR_;
    return {};
}

// C++ to Python conversion for type 'const QVector<int > &'.
static PyObject *_constQVector_int_REF_CppToPython__constQVector_int_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<int > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<int >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<int >::size_type idx = 0; idx < vectorSize; ++idx) {
        int cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_int_REF_PythonToCpp__constQVector_int_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<int > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        int cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_int_REF_PythonToCpp__constQVector_int_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn))
        return _constQVector_int_REF_PythonToCpp__constQVector_int_REF;
    return {};
}

// C++ to Python conversion for type 'const QHash<int,QByteArray > &'.
static PyObject *_constQHash_int_QByteArray_REF_CppToPython__constQHash_int_QByteArray_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QHash<int,QByteArray > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QHash<int,QByteArray >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        int key = it.key();
        ::QByteArray value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _constQHash_int_QByteArray_REF_PythonToCpp__constQHash_int_QByteArray_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QHash<int,QByteArray > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        int cppKey;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), key, &(cppKey));
        ::QByteArray cppValue;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__constQHash_int_QByteArray_REF_PythonToCpp__constQHash_int_QByteArray_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), false, *PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX])->converter, false, pyIn))
        return _constQHash_int_QByteArray_REF_PythonToCpp__constQHash_int_QByteArray_REF;
    return {};
}

// C++ to Python conversion for type 'QMap<int,QVariant >'.
static PyObject *_QMap_int_QVariant__CppToPython__QMap_int_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QMap<int,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QMap<int,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        int key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _QMap_int_QVariant__PythonToCpp__QMap_int_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QMap<int,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        int cppKey;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__QMap_int_QVariant__PythonToCpp__QMap_int_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return _QMap_int_QVariant__PythonToCpp__QMap_int_QVariant_;
    return {};
}

// C++ to Python conversion for type 'const QList<QPersistentModelIndex > &'.
static PyObject *_constQList_QPersistentModelIndex_REF_CppToPython__constQList_QPersistentModelIndex_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QPersistentModelIndex > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QPersistentModelIndex >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QPersistentModelIndex cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPERSISTENTMODELINDEX_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QPersistentModelIndex_REF_PythonToCpp__constQList_QPersistentModelIndex_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QPersistentModelIndex > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPersistentModelIndex cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPERSISTENTMODELINDEX_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QPersistentModelIndex_REF_PythonToCpp__constQList_QPersistentModelIndex_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPERSISTENTMODELINDEX_IDX]), pyIn))
        return _constQList_QPersistentModelIndex_REF_PythonToCpp__constQList_QPersistentModelIndex_REF;
    return {};
}

// C++ to Python conversion for type 'const QList<QDockWidget* > &'.
static PyObject *_constQList_QDockWidgetPTR_REF_CppToPython__constQList_QDockWidgetPTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QDockWidget* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QDockWidget* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QDockWidget* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QDOCKWIDGET_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QDockWidgetPTR_REF_PythonToCpp__constQList_QDockWidgetPTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QDockWidget* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QDockWidget* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QDOCKWIDGET_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QDockWidgetPTR_REF_PythonToCpp__constQList_QDockWidgetPTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtWidgetsTypes[SBK_QDOCKWIDGET_IDX], pyIn))
        return _constQList_QDockWidgetPTR_REF_PythonToCpp__constQList_QDockWidgetPTR_REF;
    return {};
}

// C++ to Python conversion for type 'const QList<int > &'.
static PyObject *_constQList_int_REF_CppToPython__constQList_int_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<int > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<int >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        int cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_int_REF_PythonToCpp__constQList_int_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<int > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        int cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_int_REF_PythonToCpp__constQList_int_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn))
        return _constQList_int_REF_PythonToCpp__constQList_int_REF;
    return {};
}

// C++ to Python conversion for type 'const QHash<QString,QVariant > &'.
static PyObject *_constQHash_QString_QVariant_REF_CppToPython__constQHash_QString_QVariant_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QHash<QString,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QHash<QString,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QString key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _constQHash_QString_QVariant_REF_PythonToCpp__constQHash_QString_QVariant_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QHash<QString,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__constQHash_QString_QVariant_REF_PythonToCpp__constQHash_QString_QVariant_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return _constQHash_QString_QVariant_REF_PythonToCpp__constQHash_QString_QVariant_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QAbstractButton* >'.
static PyObject *_QList_QAbstractButtonPTR__CppToPython__QList_QAbstractButtonPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QAbstractButton* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QAbstractButton* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QAbstractButton* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTBUTTON_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QAbstractButtonPTR__PythonToCpp__QList_QAbstractButtonPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QAbstractButton* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QAbstractButton* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTBUTTON_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QAbstractButtonPTR__PythonToCpp__QList_QAbstractButtonPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTBUTTON_IDX], pyIn))
        return _QList_QAbstractButtonPTR__PythonToCpp__QList_QAbstractButtonPTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<QNetworkCookie >'.
static PyObject *_QVector_QNetworkCookie__CppToPython__QVector_QNetworkCookie_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QNetworkCookie > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QNetworkCookie >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QNetworkCookie >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QNetworkCookie cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCOOKIE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_QNetworkCookie__PythonToCpp__QVector_QNetworkCookie_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QNetworkCookie > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QNetworkCookie cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCOOKIE_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_QNetworkCookie__PythonToCpp__QVector_QNetworkCookie__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCOOKIE_IDX]), pyIn))
        return _QVector_QNetworkCookie__PythonToCpp__QVector_QNetworkCookie_;
    return {};
}

// C++ to Python conversion for type 'QVector<History::HistoryEntry >'.
static PyObject *_QVector_History_HistoryEntry__CppToPython__QVector_History_HistoryEntry_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<History::HistoryEntry > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<History::HistoryEntry >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<History::HistoryEntry >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::History::HistoryEntry cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_History_HistoryEntry__PythonToCpp__QVector_History_HistoryEntry_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<History::HistoryEntry > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::History::HistoryEntry cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_History_HistoryEntry__PythonToCpp__QVector_History_HistoryEntry__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX]), pyIn))
        return _QVector_History_HistoryEntry__PythonToCpp__QVector_History_HistoryEntry_;
    return {};
}

// C++ to Python conversion for type 'QList<History::HistoryEntry >'.
static PyObject *_QList_History_HistoryEntry__CppToPython__QList_History_HistoryEntry_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<History::HistoryEntry > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<History::HistoryEntry >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::History::HistoryEntry cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_History_HistoryEntry__PythonToCpp__QList_History_HistoryEntry_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<History::HistoryEntry > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::History::HistoryEntry cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_History_HistoryEntry__PythonToCpp__QList_History_HistoryEntry__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX]), pyIn))
        return _QList_History_HistoryEntry__PythonToCpp__QList_History_HistoryEntry_;
    return {};
}

// C++ to Python conversion for type 'const QList<QTextLayout::FormatRange > &'.
static PyObject *_constQList_QTextLayout_FormatRange_REF_CppToPython__constQList_QTextLayout_FormatRange_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QTextLayout::FormatRange > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QTextLayout::FormatRange >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QTextLayout::FormatRange cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLAYOUT_FORMATRANGE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QTextLayout_FormatRange_REF_PythonToCpp__constQList_QTextLayout_FormatRange_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QTextLayout::FormatRange > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QTextLayout::FormatRange cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLAYOUT_FORMATRANGE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QTextLayout_FormatRange_REF_PythonToCpp__constQList_QTextLayout_FormatRange_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLAYOUT_FORMATRANGE_IDX]), pyIn))
        return _constQList_QTextLayout_FormatRange_REF_PythonToCpp__constQList_QTextLayout_FormatRange_REF;
    return {};
}

// C++ to Python conversion for type 'QList<BrowserWindow* >'.
static PyObject *_QList_BrowserWindowPTR__CppToPython__QList_BrowserWindowPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<BrowserWindow* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<BrowserWindow* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::BrowserWindow* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BROWSERWINDOW_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_BrowserWindowPTR__PythonToCpp__QList_BrowserWindowPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<BrowserWindow* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::BrowserWindow* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BROWSERWINDOW_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_BrowserWindowPTR__PythonToCpp__QList_BrowserWindowPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPyFalkonTypes[SBK_BROWSERWINDOW_IDX], pyIn))
        return _QList_BrowserWindowPTR__PythonToCpp__QList_BrowserWindowPTR_;
    return {};
}

// C++ to Python conversion for type 'const QVector<QHstsPolicy > &'.
static PyObject *_constQVector_QHstsPolicy_REF_CppToPython__constQVector_QHstsPolicy_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QHstsPolicy > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QHstsPolicy >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QHstsPolicy >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QHstsPolicy cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_QHstsPolicy_REF_PythonToCpp__constQVector_QHstsPolicy_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QHstsPolicy > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QHstsPolicy cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_QHstsPolicy_REF_PythonToCpp__constQVector_QHstsPolicy_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX]), pyIn))
        return _constQVector_QHstsPolicy_REF_PythonToCpp__constQVector_QHstsPolicy_REF;
    return {};
}

// C++ to Python conversion for type 'const QList<QSslError > &'.
static PyObject *_constQList_QSslError_REF_CppToPython__constQList_QSslError_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QSslError > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QSslError >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QSslError cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QSslError_REF_PythonToCpp__constQList_QSslError_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QSslError > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QSslError cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QSslError_REF_PythonToCpp__constQList_QSslError_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX]), pyIn))
        return _constQList_QSslError_REF_PythonToCpp__constQList_QSslError_REF;
    return {};
}

// C++ to Python conversion for type 'QHash<QString,PasswordBackend* >'.
static PyObject *_QHash_QString_PasswordBackendPTR__CppToPython__QHash_QString_PasswordBackendPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QHash<QString,PasswordBackend* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QHash<QString,PasswordBackend* >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QString key = it.key();
        ::PasswordBackend* value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDBACKEND_IDX]), value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _QHash_QString_PasswordBackendPTR__PythonToCpp__QHash_QString_PasswordBackendPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QHash<QString,PasswordBackend* > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], key, &(cppKey));
        ::PasswordBackend* cppValue{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDBACKEND_IDX]), value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__QHash_QString_PasswordBackendPTR__PythonToCpp__QHash_QString_PasswordBackendPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, *PepType_SGTP(SbkPyFalkonTypes[SBK_PASSWORDBACKEND_IDX])->converter, true, pyIn))
        return _QHash_QString_PasswordBackendPTR__PythonToCpp__QHash_QString_PasswordBackendPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<Plugins::Plugin >'.
static PyObject *_QList_Plugins_Plugin__CppToPython__QList_Plugins_Plugin_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<Plugins::Plugin > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<Plugins::Plugin >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::Plugins::Plugin cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_Plugins_Plugin__PythonToCpp__QList_Plugins_Plugin_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<Plugins::Plugin > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Plugins::Plugin cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_Plugins_Plugin__PythonToCpp__QList_Plugins_Plugin__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX]), pyIn))
        return _QList_Plugins_Plugin__PythonToCpp__QList_Plugins_Plugin_;
    return {};
}

// C++ to Python conversion for type 'QList<PluginInterface* >'.
static PyObject *_QList_PluginInterfacePTR__CppToPython__QList_PluginInterfacePTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<PluginInterface* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<PluginInterface* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::PluginInterface* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGININTERFACE_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_PluginInterfacePTR__PythonToCpp__QList_PluginInterfacePTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<PluginInterface* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::PluginInterface* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGININTERFACE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_PluginInterfacePTR__PythonToCpp__QList_PluginInterfacePTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPyFalkonTypes[SBK_PLUGININTERFACE_IDX], pyIn))
        return _QList_PluginInterfacePTR__PythonToCpp__QList_PluginInterfacePTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<SearchEnginesManager::Engine >'.
static PyObject *_QVector_SearchEnginesManager_Engine__CppToPython__QVector_SearchEnginesManager_Engine_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<SearchEnginesManager::Engine > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<SearchEnginesManager::Engine >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<SearchEnginesManager::Engine >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::SearchEnginesManager::Engine cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_SearchEnginesManager_Engine__PythonToCpp__QVector_SearchEnginesManager_Engine_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<SearchEnginesManager::Engine > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::SearchEnginesManager::Engine cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_SearchEnginesManager_Engine__PythonToCpp__QVector_SearchEnginesManager_Engine__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_ENGINE_IDX]), pyIn))
        return _QVector_SearchEnginesManager_Engine__PythonToCpp__QVector_SearchEnginesManager_Engine_;
    return {};
}

// C++ to Python conversion for type 'QList<WebTab* >'.
static PyObject *_QList_WebTabPTR__CppToPython__QList_WebTabPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<WebTab* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<WebTab* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::WebTab* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_WEBTAB_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_WebTabPTR__PythonToCpp__QList_WebTabPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<WebTab* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::WebTab* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_WEBTAB_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_WebTabPTR__PythonToCpp__QList_WebTabPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPyFalkonTypes[SBK_WEBTAB_IDX], pyIn))
        return _QList_WebTabPTR__PythonToCpp__QList_WebTabPTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<WebTab* >'.
static PyObject *_QVector_WebTabPTR__CppToPython__QVector_WebTabPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<WebTab* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<WebTab* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<WebTab* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::WebTab* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_WEBTAB_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_WebTabPTR__PythonToCpp__QVector_WebTabPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<WebTab* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::WebTab* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_WEBTAB_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_WebTabPTR__PythonToCpp__QVector_WebTabPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPyFalkonTypes[SBK_WEBTAB_IDX], pyIn))
        return _QVector_WebTabPTR__PythonToCpp__QVector_WebTabPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QString >'.
static PyObject *_QList_QString__CppToPython__QList_QString_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QString > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QString >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QString cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QString__PythonToCpp__QList_QString_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QString > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QString cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QString__PythonToCpp__QList_QString__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn))
        return _QList_QString__PythonToCpp__QList_QString_;
    return {};
}


#ifdef IS_PY3K
static struct PyModuleDef moduledef = {
    /* m_base     */ PyModuleDef_HEAD_INIT,
    /* m_name     */ "PyFalkon",
    /* m_doc      */ nullptr,
    /* m_size     */ -1,
    /* m_methods  */ PyFalkon_methods,
    /* m_reload   */ nullptr,
    /* m_traverse */ nullptr,
    /* m_clear    */ nullptr,
    /* m_free     */ nullptr
};

#endif

// The signatures string for the global functions.
// Multiple signatures have their index "n:" in front.
static const char *PyFalkon_SignatureStrings[] = {
    "PyFalkon.registerPlugin(arg__1:PyFalkon.PluginInterface)",
    nullptr}; // Sentinel

SBK_MODULE_INIT_FUNCTION_BEGIN(PyFalkon)
    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtWebEngineCore"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtWebEngineCoreTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtWebEngineCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtCore"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtCoreTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtNetwork"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtNetworkTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtNetworkTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtWebEngineWidgets"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtWebEngineWidgetsTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtWebEngineWidgetsTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtGui"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtGuiTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtGuiTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtWidgets"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtWidgetsTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtWidgetsTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtWebChannel"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtWebChannelTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtWebChannelTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtPrintSupport"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtPrintSupportTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtPrintSupportTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    // Create an array of wrapper types for the current module.
    static PyTypeObject *cppApi[SBK_PyFalkon_IDX_COUNT];
    SbkPyFalkonTypes = cppApi;

    // Create an array of primitive type converters for the current module.
    static SbkConverter *sbkConverters[SBK_PyFalkon_CONVERTERS_IDX_COUNT];
    SbkPyFalkonTypeConverters = sbkConverters;

#ifdef IS_PY3K
    PyObject *module = Shiboken::Module::create("PyFalkon", &moduledef);
#else
    PyObject *module = Shiboken::Module::create("PyFalkon", PyFalkon_methods);
#endif

    // Make module available from global scope
    SbkPyFalkonModuleObject = module;

    // Initialize classes in the type system
    init_WheelHelper(module);
    init_WebView(module);
    init_WebTab(module);
    init_WebPage(module);
    init_WebInspector(module);
    init_WebHitTestResult(module);
    init_UrlInterceptor(module);
    init_ToolButton(module);
    init_TabbedWebView(module);
    init_TabTreeModel(module);
    init_TabStackedWidget(module);
    init_TabWidget(module);
    init_TabMruModel(module);
    init_TabModel(module);
    init_TabIcon(module);
    init_TabContextMenu(module);
    init_StatusBar(module);
    init_SqueezeLabelV2(module);
    init_SqueezeLabelV1(module);
    init_SqlQueryJob(module);
    init_SqlDatabase(module);
    init_SideWidget(module);
    init_SideBarManager(module);
    init_SideBarInterface(module);
    init_Settings(module);
    init_SearchToolBar(module);
    init_SearchEnginesManager(module);
    init_SearchEnginesDialog(module);
    init_QzTools(module);
    init_QzSettings(module);
    init_PyFalkonQz(module);
    init_QtSingleApplication(module);
    init_Plugins(module);
    init_PluginSpec(module);
    init_PluginProxy(module);
    init_PluginInterface(module);
    init_Plugins_Plugin(reinterpret_cast<PyTypeObject *>(SbkPyFalkonTypes[SBK_PLUGINS_IDX])->tp_dict);
    init_PasswordManager(module);
    init_PasswordEntry(module);
    init_PasswordBackend(module);
    init_PageFormData(module);
    init_NetworkManager(module);
    init_NavigationBar(module);
    init_Menu(module);
    init_MainApplication(module);
    init_LoadRequest(module);
    init_LineEdit(module);
    init_LocationBar(module);
    init_IconProvider(module);
    init_HistoryModel(module);
    init_History(module);
    init_History_HistoryEntry(reinterpret_cast<PyTypeObject *>(SbkPyFalkonTypes[SBK_HISTORY_IDX])->tp_dict);
    init_HistoryItem(module);
    init_ExternalJsObject(module);
    init_ExtensionSchemeHandler(module);
    init_SearchEnginesManager_Engine(reinterpret_cast<PyTypeObject *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_IDX])->tp_dict);
    init_DownloadManager(module);
    init_DownloadItem(module);
    init_DownloadManager_DownloadInfo(reinterpret_cast<PyTypeObject *>(SbkPyFalkonTypes[SBK_DOWNLOADMANAGER_IDX])->tp_dict);
    init_DesktopNotificationsFactory(module);
    init_DesktopFile(module);
    init_DelayedFileWatcher(module);
    init_DataPaths(module);
    init_TabIcon_Data(reinterpret_cast<PyTypeObject *>(SbkPyFalkonTypes[SBK_TABICON_IDX])->tp_dict);
    init_CookieManager(module);
    init_CookieJar(module);
    init_ComboTabBar(module);
    init_TabBar(module);
    init_ClickableLabel(module);
    init_CheckBoxDialog(module);
    init_BrowserWindow(module);
    init_BookmarksTools(module);
    init_BookmarksModel(module);
    init_BookmarksFoldersMenu(module);
    init_BookmarksFoldersButton(module);
    init_Bookmarks(module);
    init_BookmarkItem(module);
    init_LocationBar_LoadAction(reinterpret_cast<PyTypeObject *>(SbkPyFalkonTypes[SBK_LOCATIONBAR_IDX])->tp_dict);
    init_AutoSaver(module);
    init_AutoFill(module);
    init_Action(module);
    init_AbstractButtonInterface(module);
    init_AbstractButtonInterface_ClickController(reinterpret_cast<PyTypeObject *>(SbkPyFalkonTypes[SBK_ABSTRACTBUTTONINTERFACE_IDX])->tp_dict);

    // Register converter for type 'const QList<QObject*>&'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QOBJECTPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QOBJECTPTR_IDX], "const QList<QObject*>&");
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QOBJECTPTR_IDX], "QList<QObject*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QOBJECTPTR_IDX],
        _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF,
        is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible);

    // Register converter for type 'QList<QByteArray>'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QBYTEARRAY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QByteArray__CppToPython__QList_QByteArray_);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QBYTEARRAY_IDX], "QList<QByteArray>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QBYTEARRAY_IDX],
        _QList_QByteArray__PythonToCpp__QList_QByteArray_,
        is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible);

    // Register converter for type 'QList<QGraphicsWidget*>'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QGRAPHICSWIDGETPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QGraphicsWidgetPTR__CppToPython__QList_QGraphicsWidgetPTR_);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QGRAPHICSWIDGETPTR_IDX], "QList<QGraphicsWidget*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QGRAPHICSWIDGETPTR_IDX],
        _QList_QGraphicsWidgetPTR__PythonToCpp__QList_QGraphicsWidgetPTR_,
        is__QList_QGraphicsWidgetPTR__PythonToCpp__QList_QGraphicsWidgetPTR__Convertible);

    // Register converter for type 'QList<QWidget*>'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QWIDGETPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QWidgetPTR__CppToPython__QList_QWidgetPTR_);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QWIDGETPTR_IDX], "QList<QWidget*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QWIDGETPTR_IDX],
        _QList_QWidgetPTR__PythonToCpp__QList_QWidgetPTR_,
        is__QList_QWidgetPTR__PythonToCpp__QList_QWidgetPTR__Convertible);

    // Register converter for type 'const QList<QKeySequence>&'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QKEYSEQUENCE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QKeySequence_REF_CppToPython__constQList_QKeySequence_REF);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QKEYSEQUENCE_IDX], "const QList<QKeySequence>&");
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QKEYSEQUENCE_IDX], "QList<QKeySequence>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QKEYSEQUENCE_IDX],
        _constQList_QKeySequence_REF_PythonToCpp__constQList_QKeySequence_REF,
        is__constQList_QKeySequence_REF_PythonToCpp__constQList_QKeySequence_REF_Convertible);

    // Register converter for type 'QVector<PasswordEntry>'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_PASSWORDENTRY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_PasswordEntry__CppToPython__QVector_PasswordEntry_);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_PASSWORDENTRY_IDX], "QVector<PasswordEntry>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_PASSWORDENTRY_IDX],
        _QVector_PasswordEntry__PythonToCpp__QVector_PasswordEntry_,
        is__QVector_PasswordEntry__PythonToCpp__QVector_PasswordEntry__Convertible);

    // Register converter for type 'QList<BookmarkItem*>'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_BOOKMARKITEMPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_BookmarkItemPTR__CppToPython__QList_BookmarkItemPTR_);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_BOOKMARKITEMPTR_IDX], "QList<BookmarkItem*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_BOOKMARKITEMPTR_IDX],
        _QList_BookmarkItemPTR__PythonToCpp__QList_BookmarkItemPTR_,
        is__QList_BookmarkItemPTR__PythonToCpp__QList_BookmarkItemPTR__Convertible);

    // Register converter for type 'const QMap<QString,QVariant>&'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QMAP_QSTRING_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _constQMap_QString_QVariant_REF_CppToPython__constQMap_QString_QVariant_REF);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QMAP_QSTRING_QVARIANT_IDX], "const QMap<QString,QVariant>&");
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QMAP_QSTRING_QVARIANT_IDX], "QMap<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QMAP_QSTRING_QVARIANT_IDX],
        _constQMap_QString_QVariant_REF_PythonToCpp__constQMap_QString_QVariant_REF,
        is__constQMap_QString_QVariant_REF_PythonToCpp__constQMap_QString_QVariant_REF_Convertible);

    // Register converter for type 'const QList<QVariant>&'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QVariant_REF_CppToPython__constQList_QVariant_REF);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QVARIANT_IDX], "const QList<QVariant>&");
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QVARIANT_IDX], "QList<QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QVARIANT_IDX],
        _constQList_QVariant_REF_PythonToCpp__constQList_QVariant_REF,
        is__constQList_QVariant_REF_PythonToCpp__constQList_QVariant_REF_Convertible);

    // Register converter for type 'QList<QAction*>'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QACTIONPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QActionPTR__CppToPython__QList_QActionPTR_);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QACTIONPTR_IDX], "QList<QAction*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QACTIONPTR_IDX],
        _QList_QActionPTR__PythonToCpp__QList_QActionPTR_,
        is__QList_QActionPTR__PythonToCpp__QList_QActionPTR__Convertible);

    // Register converter for type 'const QVector<int>&'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_INT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_int_REF_CppToPython__constQVector_int_REF);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_INT_IDX], "const QVector<int>&");
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_INT_IDX], "QVector<int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_INT_IDX],
        _constQVector_int_REF_PythonToCpp__constQVector_int_REF,
        is__constQVector_int_REF_PythonToCpp__constQVector_int_REF_Convertible);

    // Register converter for type 'const QHash<int,QByteArray>&'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QHASH_INT_QBYTEARRAY_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _constQHash_int_QByteArray_REF_CppToPython__constQHash_int_QByteArray_REF);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QHASH_INT_QBYTEARRAY_IDX], "const QHash<int,QByteArray>&");
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QHASH_INT_QBYTEARRAY_IDX], "QHash<int,QByteArray>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QHASH_INT_QBYTEARRAY_IDX],
        _constQHash_int_QByteArray_REF_PythonToCpp__constQHash_int_QByteArray_REF,
        is__constQHash_int_QByteArray_REF_PythonToCpp__constQHash_int_QByteArray_REF_Convertible);

    // Register converter for type 'QMap<int,QVariant>'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QMAP_INT_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_int_QVariant__CppToPython__QMap_int_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QMAP_INT_QVARIANT_IDX], "QMap<int,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QMAP_INT_QVARIANT_IDX],
        _QMap_int_QVariant__PythonToCpp__QMap_int_QVariant_,
        is__QMap_int_QVariant__PythonToCpp__QMap_int_QVariant__Convertible);

    // Register converter for type 'const QList<QPersistentModelIndex>&'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QPERSISTENTMODELINDEX_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QPersistentModelIndex_REF_CppToPython__constQList_QPersistentModelIndex_REF);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QPERSISTENTMODELINDEX_IDX], "const QList<QPersistentModelIndex>&");
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QPERSISTENTMODELINDEX_IDX], "QList<QPersistentModelIndex>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QPERSISTENTMODELINDEX_IDX],
        _constQList_QPersistentModelIndex_REF_PythonToCpp__constQList_QPersistentModelIndex_REF,
        is__constQList_QPersistentModelIndex_REF_PythonToCpp__constQList_QPersistentModelIndex_REF_Convertible);

    // Register converter for type 'const QList<QDockWidget*>&'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QDOCKWIDGETPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QDockWidgetPTR_REF_CppToPython__constQList_QDockWidgetPTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QDOCKWIDGETPTR_IDX], "const QList<QDockWidget*>&");
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QDOCKWIDGETPTR_IDX], "QList<QDockWidget*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QDOCKWIDGETPTR_IDX],
        _constQList_QDockWidgetPTR_REF_PythonToCpp__constQList_QDockWidgetPTR_REF,
        is__constQList_QDockWidgetPTR_REF_PythonToCpp__constQList_QDockWidgetPTR_REF_Convertible);

    // Register converter for type 'const QList<int>&'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_INT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_int_REF_CppToPython__constQList_int_REF);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_INT_IDX], "const QList<int>&");
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_INT_IDX], "QList<int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_INT_IDX],
        _constQList_int_REF_PythonToCpp__constQList_int_REF,
        is__constQList_int_REF_PythonToCpp__constQList_int_REF_Convertible);

    // Register converter for type 'const QHash<QString,QVariant>&'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QHASH_QSTRING_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _constQHash_QString_QVariant_REF_CppToPython__constQHash_QString_QVariant_REF);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QHASH_QSTRING_QVARIANT_IDX], "const QHash<QString,QVariant>&");
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QHASH_QSTRING_QVARIANT_IDX], "QHash<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QHASH_QSTRING_QVARIANT_IDX],
        _constQHash_QString_QVariant_REF_PythonToCpp__constQHash_QString_QVariant_REF,
        is__constQHash_QString_QVariant_REF_PythonToCpp__constQHash_QString_QVariant_REF_Convertible);

    // Register converter for type 'QList<QAbstractButton*>'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QABSTRACTBUTTONPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QAbstractButtonPTR__CppToPython__QList_QAbstractButtonPTR_);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QABSTRACTBUTTONPTR_IDX], "QList<QAbstractButton*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QABSTRACTBUTTONPTR_IDX],
        _QList_QAbstractButtonPTR__PythonToCpp__QList_QAbstractButtonPTR_,
        is__QList_QAbstractButtonPTR__PythonToCpp__QList_QAbstractButtonPTR__Convertible);

    // Register converter for type 'QVector<QNetworkCookie>'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_QNETWORKCOOKIE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_QNetworkCookie__CppToPython__QVector_QNetworkCookie_);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_QNETWORKCOOKIE_IDX], "QVector<QNetworkCookie>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_QNETWORKCOOKIE_IDX],
        _QVector_QNetworkCookie__PythonToCpp__QVector_QNetworkCookie_,
        is__QVector_QNetworkCookie__PythonToCpp__QVector_QNetworkCookie__Convertible);

    // Register converter for type 'QVector<History::HistoryEntry>'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_HISTORY_HISTORYENTRY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_History_HistoryEntry__CppToPython__QVector_History_HistoryEntry_);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_HISTORY_HISTORYENTRY_IDX], "QVector<History::HistoryEntry>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_HISTORY_HISTORYENTRY_IDX],
        _QVector_History_HistoryEntry__PythonToCpp__QVector_History_HistoryEntry_,
        is__QVector_History_HistoryEntry__PythonToCpp__QVector_History_HistoryEntry__Convertible);

    // Register converter for type 'QList<History::HistoryEntry>'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_HISTORY_HISTORYENTRY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_History_HistoryEntry__CppToPython__QList_History_HistoryEntry_);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_HISTORY_HISTORYENTRY_IDX], "QList<History::HistoryEntry>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_HISTORY_HISTORYENTRY_IDX],
        _QList_History_HistoryEntry__PythonToCpp__QList_History_HistoryEntry_,
        is__QList_History_HistoryEntry__PythonToCpp__QList_History_HistoryEntry__Convertible);

    // Register converter for type 'const QList<QTextLayout::FormatRange>&'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QTEXTLAYOUT_FORMATRANGE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QTextLayout_FormatRange_REF_CppToPython__constQList_QTextLayout_FormatRange_REF);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QTEXTLAYOUT_FORMATRANGE_IDX], "const QList<QTextLayout::FormatRange>&");
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QTEXTLAYOUT_FORMATRANGE_IDX], "QList<QTextLayout::FormatRange>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QTEXTLAYOUT_FORMATRANGE_IDX],
        _constQList_QTextLayout_FormatRange_REF_PythonToCpp__constQList_QTextLayout_FormatRange_REF,
        is__constQList_QTextLayout_FormatRange_REF_PythonToCpp__constQList_QTextLayout_FormatRange_REF_Convertible);

    // Register converter for type 'QList<BrowserWindow*>'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_BROWSERWINDOWPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_BrowserWindowPTR__CppToPython__QList_BrowserWindowPTR_);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_BROWSERWINDOWPTR_IDX], "QList<BrowserWindow*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_BROWSERWINDOWPTR_IDX],
        _QList_BrowserWindowPTR__PythonToCpp__QList_BrowserWindowPTR_,
        is__QList_BrowserWindowPTR__PythonToCpp__QList_BrowserWindowPTR__Convertible);

    // Register converter for type 'const QVector<QHstsPolicy>&'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_QHSTSPOLICY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_QHstsPolicy_REF_CppToPython__constQVector_QHstsPolicy_REF);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_QHSTSPOLICY_IDX], "const QVector<QHstsPolicy>&");
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_QHSTSPOLICY_IDX], "QVector<QHstsPolicy>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_QHSTSPOLICY_IDX],
        _constQVector_QHstsPolicy_REF_PythonToCpp__constQVector_QHstsPolicy_REF,
        is__constQVector_QHstsPolicy_REF_PythonToCpp__constQVector_QHstsPolicy_REF_Convertible);

    // Register converter for type 'const QList<QSslError>&'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QSSLERROR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QSslError_REF_CppToPython__constQList_QSslError_REF);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QSSLERROR_IDX], "const QList<QSslError>&");
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QSSLERROR_IDX], "QList<QSslError>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QSSLERROR_IDX],
        _constQList_QSslError_REF_PythonToCpp__constQList_QSslError_REF,
        is__constQList_QSslError_REF_PythonToCpp__constQList_QSslError_REF_Convertible);

    // Register converter for type 'QHash<QString,PasswordBackend*>'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QHASH_QSTRING_PASSWORDBACKENDPTR_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QHash_QString_PasswordBackendPTR__CppToPython__QHash_QString_PasswordBackendPTR_);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QHASH_QSTRING_PASSWORDBACKENDPTR_IDX], "QHash<QString,PasswordBackend*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QHASH_QSTRING_PASSWORDBACKENDPTR_IDX],
        _QHash_QString_PasswordBackendPTR__PythonToCpp__QHash_QString_PasswordBackendPTR_,
        is__QHash_QString_PasswordBackendPTR__PythonToCpp__QHash_QString_PasswordBackendPTR__Convertible);

    // Register converter for type 'QList<Plugins::Plugin>'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_PLUGINS_PLUGIN_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_Plugins_Plugin__CppToPython__QList_Plugins_Plugin_);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_PLUGINS_PLUGIN_IDX], "QList<Plugins::Plugin>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_PLUGINS_PLUGIN_IDX],
        _QList_Plugins_Plugin__PythonToCpp__QList_Plugins_Plugin_,
        is__QList_Plugins_Plugin__PythonToCpp__QList_Plugins_Plugin__Convertible);

    // Register converter for type 'QList<PluginInterface*>'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_PLUGININTERFACEPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_PluginInterfacePTR__CppToPython__QList_PluginInterfacePTR_);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_PLUGININTERFACEPTR_IDX], "QList<PluginInterface*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_PLUGININTERFACEPTR_IDX],
        _QList_PluginInterfacePTR__PythonToCpp__QList_PluginInterfacePTR_,
        is__QList_PluginInterfacePTR__PythonToCpp__QList_PluginInterfacePTR__Convertible);

    // Register converter for type 'QVector<SearchEnginesManager::Engine>'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_SEARCHENGINESMANAGER_ENGINE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_SearchEnginesManager_Engine__CppToPython__QVector_SearchEnginesManager_Engine_);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_SEARCHENGINESMANAGER_ENGINE_IDX], "QVector<SearchEnginesManager::Engine>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_SEARCHENGINESMANAGER_ENGINE_IDX],
        _QVector_SearchEnginesManager_Engine__PythonToCpp__QVector_SearchEnginesManager_Engine_,
        is__QVector_SearchEnginesManager_Engine__PythonToCpp__QVector_SearchEnginesManager_Engine__Convertible);

    // Register converter for type 'QList<WebTab*>'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_WEBTABPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_WebTabPTR__CppToPython__QList_WebTabPTR_);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_WEBTABPTR_IDX], "QList<WebTab*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_WEBTABPTR_IDX],
        _QList_WebTabPTR__PythonToCpp__QList_WebTabPTR_,
        is__QList_WebTabPTR__PythonToCpp__QList_WebTabPTR__Convertible);

    // Register converter for type 'QVector<WebTab*>'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_WEBTABPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_WebTabPTR__CppToPython__QVector_WebTabPTR_);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_WEBTABPTR_IDX], "QVector<WebTab*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_WEBTABPTR_IDX],
        _QVector_WebTabPTR__PythonToCpp__QVector_WebTabPTR_,
        is__QVector_WebTabPTR__PythonToCpp__QVector_WebTabPTR__Convertible);

    // Register converter for type 'QList<QString>'.
    SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QSTRING_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QString__CppToPython__QList_QString_);
    Shiboken::Conversions::registerConverterName(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QSTRING_IDX], "QList<QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_QSTRING_IDX],
        _QList_QString__PythonToCpp__QList_QString_,
        is__QList_QString__PythonToCpp__QList_QString__Convertible);

    // Register primitive types converters.

    Shiboken::Module::registerTypes(module, SbkPyFalkonTypes);
    Shiboken::Module::registerTypeConverters(module, SbkPyFalkonTypeConverters);

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module PyFalkon");
    }
    // Begin code injection
    QList<QByteArray> version = QByteArray(Qz::VERSION).split('.');
    PyObject *pyFalkonVersion = PyTuple_New(3);
    for (int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(pyFalkonVersion, i, PyInt_FromLong(version[i].toInt()));
    PyModule_AddObject(module, "__version_info__", pyFalkonVersion);
    PyModule_AddStringConstant(module, "__version__", Qz::VERSION);

    // End of code injection

    PySide::registerCleanupFunction(cleanTypesAttributes);

    FinishSignatureInitialization(module, PyFalkon_SignatureStrings);

SBK_MODULE_INIT_FUNCTION_END
