// This file is generated by kconfig_compiler_kf5 from etesyncresource.kcfg.
// All changes you do to this file will be lost.

#include "settings.h"

#include <klocalizedstring.h>

#include <qglobal.h>
#include <QFile>

#include <QDebug>

class SettingsHelper
{
  public:
    SettingsHelper() : q(nullptr) {}
    ~SettingsHelper() { delete q; }
    SettingsHelper(const SettingsHelper&) = delete;
    SettingsHelper& operator=(const SettingsHelper&) = delete;
    Settings *q;
};
Q_GLOBAL_STATIC(SettingsHelper, s_globalSettings)
Settings *Settings::self()
{
  if (!s_globalSettings()->q)
     qFatal("you need to call Settings::instance before using");
  return s_globalSettings()->q;
}

void Settings::instance(const QString& cfgfilename)
{
  if (s_globalSettings()->q) {
     qDebug() << "Settings::instance called after the first use - ignoring";
     return;
  }
  new Settings(KSharedConfig::openConfig(cfgfilename));
  s_globalSettings()->q->read();
}

void Settings::instance(KSharedConfig::Ptr config)
{
  if (s_globalSettings()->q) {
     qDebug() << "Settings::instance called after the first use - ignoring";
     return;
  }
  new Settings(std::move(config));
  s_globalSettings()->q->read();
}

Settings::Settings( KSharedConfig::Ptr config )
  : KConfigSkeleton( std::move( config ) )
{
  Q_ASSERT(!s_globalSettings()->q);
  s_globalSettings()->q = this;
  setCurrentGroup( QStringLiteral( "General" ) );

  mBaseUrlItem = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "BaseUrl" ), mBaseUrl );
  mBaseUrlItem->setLabel( i18n("Server URL") );
  mBaseUrlItem->setToolTip( i18n("The URL of the EteSync server, should be something like https://myserver.org/") );
  mBaseUrlItem->setWhatsThis( i18n("The URL of the EteSync server, should be something like https://myserver.org/") );
  addItem( mBaseUrlItem, QStringLiteral( "BaseUrl" ) );
  mUsernameItem = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "Username" ), mUsername );
  mUsernameItem->setLabel( i18nc("the username to login on server", "Username") );
  mUsernameItem->setToolTip( i18n("The username that is used to log into the EteSync server") );
  mUsernameItem->setWhatsThis( i18n("The username that is used to log into the EteSync server") );
  addItem( mUsernameItem, QStringLiteral( "Username" ) );
  mBasePathItem = new KConfigSkeleton::ItemPath( currentGroup(), QStringLiteral( "BasePath" ), mBasePath, QStringLiteral( "$HOME/.local/share/akonadi_etesync_resource" ) );
  mBasePathItem->setLabel( i18n("Path to base directory") );
  addItem( mBasePathItem, QStringLiteral( "BasePath" ) );
}

Settings::~Settings()
{
  s_globalSettings()->q = nullptr;
}

