// third_party/blink/public/mojom/file_system_access/native_file_system_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/file_system_access/native_file_system_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/file_system_access/native_file_system_manager.mojom-params-data.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_manager.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/file_system_access/native_file_system_manager.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_NATIVE_FILE_SYSTEM_MANAGER_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_NATIVE_FILE_SYSTEM_MANAGER_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
ChooseFileSystemEntryAcceptsOption::ChooseFileSystemEntryAcceptsOption()
    : description(),
      mime_types(),
      extensions() {}

ChooseFileSystemEntryAcceptsOption::ChooseFileSystemEntryAcceptsOption(
    const ::base::string16& description_in,
    std::vector<std::string> mime_types_in,
    std::vector<std::string> extensions_in)
    : description(std::move(description_in)),
      mime_types(std::move(mime_types_in)),
      extensions(std::move(extensions_in)) {}

ChooseFileSystemEntryAcceptsOption::~ChooseFileSystemEntryAcceptsOption() = default;

void ChooseFileSystemEntryAcceptsOption::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("description", base::trace_event::ValueToString(this->description, "<value of type const ::base::string16&>"));
  value->BeginArray("mime_types");
  for (const auto& item0 : this->mime_types) {
    value->AppendString(item0);
  }
  value->EndArray();
  value->BeginArray("extensions");
  for (const auto& item0 : this->extensions) {
    value->AppendString(item0);
  }
  value->EndArray();
}

bool ChooseFileSystemEntryAcceptsOption::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char NativeFileSystemManager::Name_[] = "blink.mojom.NativeFileSystemManager";

class NativeFileSystemManager_GetSandboxedFileSystem_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeFileSystemManager_GetSandboxedFileSystem_ForwardToCallback(
      NativeFileSystemManager::GetSandboxedFileSystemCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeFileSystemManager::GetSandboxedFileSystemCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemManager_GetSandboxedFileSystem_ForwardToCallback);
};

class NativeFileSystemManager_ChooseEntries_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeFileSystemManager_ChooseEntries_ForwardToCallback(
      NativeFileSystemManager::ChooseEntriesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeFileSystemManager::ChooseEntriesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemManager_ChooseEntries_ForwardToCallback);
};

class NativeFileSystemManager_GetEntryFromDragDropToken_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeFileSystemManager_GetEntryFromDragDropToken_ForwardToCallback(
      NativeFileSystemManager::GetEntryFromDragDropTokenCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeFileSystemManager::GetEntryFromDragDropTokenCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemManager_GetEntryFromDragDropToken_ForwardToCallback);
};

NativeFileSystemManagerProxy::NativeFileSystemManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NativeFileSystemManagerProxy::GetSandboxedFileSystem(
    GetSandboxedFileSystemCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::NativeFileSystemManager::GetSandboxedFileSystem");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemManager_GetSandboxedFileSystem_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemManager_GetSandboxedFileSystem_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemManager::Name_);
  message.set_method_name("GetSandboxedFileSystem");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeFileSystemManager_GetSandboxedFileSystem_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NativeFileSystemManagerProxy::ChooseEntries(
    ChooseFileSystemEntryType in_type, std::vector<ChooseFileSystemEntryAcceptsOptionPtr> in_accepts, bool in_include_accepts_all, ChooseEntriesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeFileSystemManager::ChooseEntries", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("type", base::trace_event::ValueToString(in_type));
      raw_value->BeginArray("accepts");
      for (const auto& item0 : in_accepts) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      raw_value->SetBoolean("include_accepts_all", in_include_accepts_all);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemManager_ChooseEntries_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemManager_ChooseEntries_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::ChooseFileSystemEntryType>(
      in_type, &params->type);
  typename decltype(params->accepts)::BaseType::BufferWriter
      accepts_writer;
  const mojo::internal::ContainerValidateParams accepts_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ChooseFileSystemEntryAcceptsOptionDataView>>(
      in_accepts, buffer, &accepts_writer, &accepts_validate_params,
      &serialization_context);
  params->accepts.Set(
      accepts_writer.is_null() ? nullptr : accepts_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->accepts.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null accepts in NativeFileSystemManager.ChooseEntries request");
  params->include_accepts_all = in_include_accepts_all;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemManager::Name_);
  message.set_method_name("ChooseEntries");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeFileSystemManager_ChooseEntries_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NativeFileSystemManagerProxy::GetFileHandleFromToken(
    ::mojo::PendingRemote<::blink::mojom::NativeFileSystemTransferToken> in_token, ::mojo::PendingReceiver<::blink::mojom::NativeFileSystemFileHandle> in_file_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeFileSystemManager::GetFileHandleFromToken", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("token", in_token.is_valid());
      raw_value->SetBoolean("file_handle", in_file_handle.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemManager_GetFileHandleFromToken_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemManager_GetFileHandleFromToken_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::NativeFileSystemTransferTokenInterfaceBase>>(
      in_token, &params->token, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->token),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid token in NativeFileSystemManager.GetFileHandleFromToken request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::NativeFileSystemFileHandleInterfaceBase>>(
      in_file_handle, &params->file_handle, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->file_handle),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid file_handle in NativeFileSystemManager.GetFileHandleFromToken request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemManager::Name_);
  message.set_method_name("GetFileHandleFromToken");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NativeFileSystemManagerProxy::GetDirectoryHandleFromToken(
    ::mojo::PendingRemote<::blink::mojom::NativeFileSystemTransferToken> in_token, ::mojo::PendingReceiver<::blink::mojom::NativeFileSystemDirectoryHandle> in_directory_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeFileSystemManager::GetDirectoryHandleFromToken", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("token", in_token.is_valid());
      raw_value->SetBoolean("directory_handle", in_directory_handle.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemManager_GetDirectoryHandleFromToken_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemManager_GetDirectoryHandleFromToken_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::NativeFileSystemTransferTokenInterfaceBase>>(
      in_token, &params->token, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->token),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid token in NativeFileSystemManager.GetDirectoryHandleFromToken request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::NativeFileSystemDirectoryHandleInterfaceBase>>(
      in_directory_handle, &params->directory_handle, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->directory_handle),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid directory_handle in NativeFileSystemManager.GetDirectoryHandleFromToken request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemManager::Name_);
  message.set_method_name("GetDirectoryHandleFromToken");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NativeFileSystemManagerProxy::GetEntryFromDragDropToken(
    ::mojo::PendingRemote<::blink::mojom::NativeFileSystemDragDropToken> in_token, GetEntryFromDragDropTokenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeFileSystemManager::GetEntryFromDragDropToken", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("token", in_token.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemManager_GetEntryFromDragDropToken_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemManager_GetEntryFromDragDropToken_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::NativeFileSystemDragDropTokenInterfaceBase>>(
      in_token, &params->token, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->token),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid token in NativeFileSystemManager.GetEntryFromDragDropToken request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemManager::Name_);
  message.set_method_name("GetEntryFromDragDropToken");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeFileSystemManager_GetEntryFromDragDropToken_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class NativeFileSystemManager_GetSandboxedFileSystem_ProxyToResponder {
 public:
  static NativeFileSystemManager::GetSandboxedFileSystemCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeFileSystemManager_GetSandboxedFileSystem_ProxyToResponder> proxy(
        new NativeFileSystemManager_GetSandboxedFileSystem_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeFileSystemManager_GetSandboxedFileSystem_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeFileSystemManager_GetSandboxedFileSystem_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeFileSystemManager_GetSandboxedFileSystem_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeFileSystemManager::GetSandboxedFileSystemCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::NativeFileSystemErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::NativeFileSystemDirectoryHandle> in_directory);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemManager_GetSandboxedFileSystem_ProxyToResponder);
};

bool NativeFileSystemManager_GetSandboxedFileSystem_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeFileSystemManager::GetSandboxedFileSystemCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeFileSystemManager_GetSandboxedFileSystem_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeFileSystemManager_GetSandboxedFileSystem_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::NativeFileSystemErrorPtr p_result{};
  ::mojo::PendingRemote<::blink::mojom::NativeFileSystemDirectoryHandle> p_directory{};
  NativeFileSystemManager_GetSandboxedFileSystem_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success) {
    p_directory =
        input_data_view.TakeDirectory<decltype(p_directory)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeFileSystemManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_directory));
  return true;
}

void NativeFileSystemManager_GetSandboxedFileSystem_ProxyToResponder::Run(
    ::blink::mojom::NativeFileSystemErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::NativeFileSystemDirectoryHandle> in_directory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeFileSystemManager::GetSandboxedFileSystemCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("directory", in_directory.is_valid());
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemManager_GetSandboxedFileSystem_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemManager_GetSandboxedFileSystem_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::blink::mojom::NativeFileSystemErrorDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::NativeFileSystemDirectoryHandleInterfaceBase>>(
      in_directory, &params->directory, &serialization_context);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeFileSystemManager::GetSandboxedFileSystemCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemManager::Name_);
  message.set_method_name("GetSandboxedFileSystem");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NativeFileSystemManager_ChooseEntries_ProxyToResponder {
 public:
  static NativeFileSystemManager::ChooseEntriesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeFileSystemManager_ChooseEntries_ProxyToResponder> proxy(
        new NativeFileSystemManager_ChooseEntries_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeFileSystemManager_ChooseEntries_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeFileSystemManager_ChooseEntries_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeFileSystemManager_ChooseEntries_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeFileSystemManager::ChooseEntriesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::NativeFileSystemErrorPtr in_result, std::vector<::blink::mojom::NativeFileSystemEntryPtr> in_entries);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemManager_ChooseEntries_ProxyToResponder);
};

bool NativeFileSystemManager_ChooseEntries_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeFileSystemManager::ChooseEntriesCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeFileSystemManager_ChooseEntries_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeFileSystemManager_ChooseEntries_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::NativeFileSystemErrorPtr p_result{};
  std::vector<::blink::mojom::NativeFileSystemEntryPtr> p_entries{};
  NativeFileSystemManager_ChooseEntries_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadEntries(&p_entries))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeFileSystemManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_entries));
  return true;
}

void NativeFileSystemManager_ChooseEntries_ProxyToResponder::Run(
    ::blink::mojom::NativeFileSystemErrorPtr in_result, std::vector<::blink::mojom::NativeFileSystemEntryPtr> in_entries) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeFileSystemManager::ChooseEntriesCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->BeginArray("entries");
      for (const auto& item0 : in_entries) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemManager_ChooseEntries_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemManager_ChooseEntries_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::blink::mojom::NativeFileSystemErrorDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  typename decltype(params->entries)::BaseType::BufferWriter
      entries_writer;
  const mojo::internal::ContainerValidateParams entries_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::NativeFileSystemEntryDataView>>(
      in_entries, buffer, &entries_writer, &entries_validate_params,
      &serialization_context);
  params->entries.Set(
      entries_writer.is_null() ? nullptr : entries_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->entries.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null entries in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeFileSystemManager::ChooseEntriesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemManager::Name_);
  message.set_method_name("ChooseEntries");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NativeFileSystemManager_GetEntryFromDragDropToken_ProxyToResponder {
 public:
  static NativeFileSystemManager::GetEntryFromDragDropTokenCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeFileSystemManager_GetEntryFromDragDropToken_ProxyToResponder> proxy(
        new NativeFileSystemManager_GetEntryFromDragDropToken_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeFileSystemManager_GetEntryFromDragDropToken_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeFileSystemManager_GetEntryFromDragDropToken_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeFileSystemManager_GetEntryFromDragDropToken_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeFileSystemManager::GetEntryFromDragDropTokenCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::NativeFileSystemEntryPtr in_entry);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemManager_GetEntryFromDragDropToken_ProxyToResponder);
};

bool NativeFileSystemManager_GetEntryFromDragDropToken_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeFileSystemManager::GetEntryFromDragDropTokenCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeFileSystemManager_GetEntryFromDragDropToken_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeFileSystemManager_GetEntryFromDragDropToken_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::NativeFileSystemEntryPtr p_entry{};
  NativeFileSystemManager_GetEntryFromDragDropToken_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadEntry(&p_entry))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeFileSystemManager::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_entry));
  return true;
}

void NativeFileSystemManager_GetEntryFromDragDropToken_ProxyToResponder::Run(
    ::blink::mojom::NativeFileSystemEntryPtr in_entry) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeFileSystemManager::GetEntryFromDragDropTokenCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_entry.is_null()) {
        raw_value->SetString("entry", "nullptr");
      } else {
        raw_value->BeginDictionary("entry");
        in_entry->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemManager_GetEntryFromDragDropToken_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemManager_GetEntryFromDragDropToken_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->entry)::BaseType::BufferWriter
      entry_writer;
  mojo::internal::Serialize<::blink::mojom::NativeFileSystemEntryDataView>(
      in_entry, buffer, &entry_writer, &serialization_context);
  params->entry.Set(
      entry_writer.is_null() ? nullptr : entry_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->entry.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null entry in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeFileSystemManager::GetEntryFromDragDropTokenCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemManager::Name_);
  message.set_method_name("GetEntryFromDragDropToken");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool NativeFileSystemManagerStubDispatch::Accept(
    NativeFileSystemManager* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kNativeFileSystemManager_GetSandboxedFileSystem_Name: {
      break;
    }
    case internal::kNativeFileSystemManager_ChooseEntries_Name: {
      break;
    }
    case internal::kNativeFileSystemManager_GetFileHandleFromToken_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemManager::GetFileHandleFromToken",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemManager::GetFileHandleFromToken");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NativeFileSystemManager_GetFileHandleFromToken_Params_Data* params =
          reinterpret_cast<internal::NativeFileSystemManager_GetFileHandleFromToken_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::NativeFileSystemTransferToken> p_token{};
      ::mojo::PendingReceiver<::blink::mojom::NativeFileSystemFileHandle> p_file_handle{};
      NativeFileSystemManager_GetFileHandleFromToken_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (success) {
        p_file_handle =
            input_data_view.TakeFileHandle<decltype(p_file_handle)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemManager::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFileHandleFromToken(
std::move(p_token), 
std::move(p_file_handle));
      return true;
    }
    case internal::kNativeFileSystemManager_GetDirectoryHandleFromToken_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemManager::GetDirectoryHandleFromToken",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemManager::GetDirectoryHandleFromToken");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NativeFileSystemManager_GetDirectoryHandleFromToken_Params_Data* params =
          reinterpret_cast<internal::NativeFileSystemManager_GetDirectoryHandleFromToken_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::NativeFileSystemTransferToken> p_token{};
      ::mojo::PendingReceiver<::blink::mojom::NativeFileSystemDirectoryHandle> p_directory_handle{};
      NativeFileSystemManager_GetDirectoryHandleFromToken_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (success) {
        p_directory_handle =
            input_data_view.TakeDirectoryHandle<decltype(p_directory_handle)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemManager::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDirectoryHandleFromToken(
std::move(p_token), 
std::move(p_directory_handle));
      return true;
    }
    case internal::kNativeFileSystemManager_GetEntryFromDragDropToken_Name: {
      break;
    }
  }
  return false;
}

// static
bool NativeFileSystemManagerStubDispatch::AcceptWithResponder(
    NativeFileSystemManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNativeFileSystemManager_GetSandboxedFileSystem_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemManager::GetSandboxedFileSystem",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemManager::GetSandboxedFileSystem");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeFileSystemManager_GetSandboxedFileSystem_Params_Data* params =
          reinterpret_cast<
              internal::NativeFileSystemManager_GetSandboxedFileSystem_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      NativeFileSystemManager_GetSandboxedFileSystem_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemManager::Name_, 0, false);
        return false;
      }
      NativeFileSystemManager::GetSandboxedFileSystemCallback callback =
          NativeFileSystemManager_GetSandboxedFileSystem_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSandboxedFileSystem(std::move(callback));
      return true;
    }
    case internal::kNativeFileSystemManager_ChooseEntries_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemManager::ChooseEntries",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemManager::ChooseEntries");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeFileSystemManager_ChooseEntries_Params_Data* params =
          reinterpret_cast<
              internal::NativeFileSystemManager_ChooseEntries_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ChooseFileSystemEntryType p_type{};
      std::vector<ChooseFileSystemEntryAcceptsOptionPtr> p_accepts{};
      bool p_include_accepts_all{};
      NativeFileSystemManager_ChooseEntries_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadAccepts(&p_accepts))
        success = false;
      if (success)
        p_include_accepts_all = input_data_view.include_accepts_all();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemManager::Name_, 1, false);
        return false;
      }
      NativeFileSystemManager::ChooseEntriesCallback callback =
          NativeFileSystemManager_ChooseEntries_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ChooseEntries(
std::move(p_type), 
std::move(p_accepts), 
std::move(p_include_accepts_all), std::move(callback));
      return true;
    }
    case internal::kNativeFileSystemManager_GetFileHandleFromToken_Name: {
      break;
    }
    case internal::kNativeFileSystemManager_GetDirectoryHandleFromToken_Name: {
      break;
    }
    case internal::kNativeFileSystemManager_GetEntryFromDragDropToken_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemManager::GetEntryFromDragDropToken",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemManager::GetEntryFromDragDropToken");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeFileSystemManager_GetEntryFromDragDropToken_Params_Data* params =
          reinterpret_cast<
              internal::NativeFileSystemManager_GetEntryFromDragDropToken_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::NativeFileSystemDragDropToken> p_token{};
      NativeFileSystemManager_GetEntryFromDragDropToken_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemManager::Name_, 4, false);
        return false;
      }
      NativeFileSystemManager::GetEntryFromDragDropTokenCallback callback =
          NativeFileSystemManager_GetEntryFromDragDropToken_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetEntryFromDragDropToken(
std::move(p_token), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kNativeFileSystemManagerValidationInfo[] = {
    {&internal::NativeFileSystemManager_GetSandboxedFileSystem_Params_Data::Validate,
     &internal::NativeFileSystemManager_GetSandboxedFileSystem_ResponseParams_Data::Validate},
    {&internal::NativeFileSystemManager_ChooseEntries_Params_Data::Validate,
     &internal::NativeFileSystemManager_ChooseEntries_ResponseParams_Data::Validate},
    {&internal::NativeFileSystemManager_GetFileHandleFromToken_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::NativeFileSystemManager_GetDirectoryHandleFromToken_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::NativeFileSystemManager_GetEntryFromDragDropToken_Params_Data::Validate,
     &internal::NativeFileSystemManager_GetEntryFromDragDropToken_ResponseParams_Data::Validate},
};

bool NativeFileSystemManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::NativeFileSystemManager::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kNativeFileSystemManagerValidationInfo);
}

bool NativeFileSystemManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::NativeFileSystemManager::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kNativeFileSystemManagerValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::ChooseFileSystemEntryAcceptsOption::DataView, ::blink::mojom::ChooseFileSystemEntryAcceptsOptionPtr>::Read(
    ::blink::mojom::ChooseFileSystemEntryAcceptsOption::DataView input,
    ::blink::mojom::ChooseFileSystemEntryAcceptsOptionPtr* output) {
  bool success = true;
  ::blink::mojom::ChooseFileSystemEntryAcceptsOptionPtr result(::blink::mojom::ChooseFileSystemEntryAcceptsOption::New());
  
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success && !input.ReadMimeTypes(&result->mime_types))
        success = false;
      if (success && !input.ReadExtensions(&result->extensions))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif