
#line 135 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtQml module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <private/qqmljsengine_p.h>
#include <private/qqmljslexer_p.h>
#include <private/qqmljsast_p.h>
#include <private/qqmljsmemorypool_p.h>

#include <QtCore/qdebug.h>
#include <QtCore/qcoreapplication.h>

#include <string.h>


#line 494 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"


#include "qqmljsparser_p.h"

#include <QtCore/qvarlengtharray.h>

//
//  W A R N I N G
//  -------------
//
// This file is automatically generated from qqmljs.g.
// Changes should be made to that file, not here. Any change to this file will
// be lost!
//
// To regenerate this file, run:
//    qlalr --no-debug --no-lines --qt qqmljs.g
//

#define UNIMPLEMENTED syntaxError(loc(1), "Unimplemented"); return false

using namespace QQmlJS;

QT_BEGIN_NAMESPACE

void Parser::reallocateStack()
{
    if (! stack_size)
        stack_size = 128;
    else
        stack_size <<= 1;

    sym_stack = reinterpret_cast<Value*> (realloc(sym_stack, stack_size * sizeof(Value)));
    state_stack = reinterpret_cast<int*> (realloc(state_stack, stack_size * sizeof(int)));
    location_stack = reinterpret_cast<SourceLocation*> (realloc(location_stack, stack_size * sizeof(SourceLocation)));
    string_stack.resize(stack_size);
    rawString_stack.resize(stack_size);
}

Parser::Parser(Engine *engine):
    driver(engine),
    pool(engine->pool())
{
}

Parser::~Parser()
{
    if (stack_size) {
        free(sym_stack);
        free(state_stack);
        free(location_stack);
    }
}

static inline SourceLocation location(Lexer *lexer)
{
    SourceLocation loc;
    loc.offset = lexer->tokenOffset();
    loc.length = lexer->tokenLength();
    loc.startLine = lexer->tokenStartLine();
    loc.startColumn = lexer->tokenStartColumn();
    return loc;
}

AST::UiQualifiedId *Parser::reparseAsQualifiedId(AST::ExpressionNode *expr)
{
    QVarLengthArray<QStringView, 4> nameIds;
    QVarLengthArray<SourceLocation, 4> locations;

    AST::ExpressionNode *it = expr;
    while (AST::FieldMemberExpression *m = AST::cast<AST::FieldMemberExpression *>(it)) {
        nameIds.append(m->name);
        locations.append(m->identifierToken);
        it = m->base;
    }

    if (AST::IdentifierExpression *idExpr = AST::cast<AST::IdentifierExpression *>(it)) {
        AST::UiQualifiedId *q = new (pool) AST::UiQualifiedId(idExpr->name);
        q->identifierToken = idExpr->identifierToken;

        AST::UiQualifiedId *currentId = q;
        for (int i = nameIds.size() - 1; i != -1; --i) {
            currentId = new (pool) AST::UiQualifiedId(currentId, nameIds[i]);
            currentId->identifierToken = locations[i];
        }

        return currentId->finish();
    }

    return 0;
}

void Parser::pushToken(int token)
{
    Q_ASSERT(last_token);
    Q_ASSERT(last_token < &token_buffer[TOKEN_BUFFER_SIZE]);
    last_token->token = yytoken;
    last_token->dval = yylval;
    last_token->spell = yytokenspell;
    last_token->raw = yytokenraw;
    last_token->loc = yylloc;
    ++last_token;
    yytoken = token;
}

int Parser::lookaheadToken(Lexer *lexer)
{
    if (yytoken < 0) {
        yytoken = lexer->lex();
        yylval = lexer->tokenValue();
        yytokenspell = lexer->tokenSpell();
        yytokenraw = lexer->rawString();
        yylloc = location(lexer);
    }
    return yytoken;
}

bool Parser::ensureNoFunctionTypeAnnotations(AST::TypeAnnotation *returnValueAnnotation, AST::FormalParameterList *formals)
{
    for (auto formal = formals; formal; formal = formal->next) {
        if (formal->element && formal->element->typeAnnotation) {
            syntaxError(formal->element->typeAnnotation->firstSourceLocation(), "Type annotations are not permitted in function parameters in JavaScript functions");
            return false;
        }
    }
    if (returnValueAnnotation) {
        syntaxError(returnValueAnnotation->firstSourceLocation(), "Type annotations are not permitted for the return value of JavaScript functions");
        return false;
    }
    return true;
}

//#define PARSER_DEBUG

bool Parser::parse(int startToken)
{
    Lexer *lexer = driver->lexer();
    bool hadErrors = false;
    yytoken = -1;
    int action = 0;

    token_buffer[0].token = startToken;
    first_token = &token_buffer[0];
    if (startToken == T_FEED_JS_SCRIPT && !lexer->qmlMode()) {
        Directives ignoreDirectives;
        Directives *directives = driver->directives();
        if (!directives)
            directives = &ignoreDirectives;
        DiagnosticMessage error;
        if (!lexer->scanDirectives(directives, &error)) {
            diagnostic_messages.append(error);
            return false;
        }
        token_buffer[1].token = lexer->tokenKind();
        token_buffer[1].dval = lexer->tokenValue();
        token_buffer[1].loc = location(lexer);
        token_buffer[1].spell = lexer->tokenSpell();
        last_token = &token_buffer[2];
    } else {
        last_token = &token_buffer[1];
    }

    tos = -1;
    program = 0;

    do {
        if (++tos == stack_size)
            reallocateStack();

        state_stack[tos] = action;

    _Lcheck_token:
        if (yytoken == -1 && -TERMINAL_COUNT != action_index[action]) {
            yyprevlloc = yylloc;

            if (first_token == last_token) {
                yytoken = lexer->lex();
                yylval = lexer->tokenValue();
                yytokenspell = lexer->tokenSpell();
                yytokenraw = lexer->rawString();
                yylloc = location(lexer);
            } else {
                yytoken = first_token->token;
                yylval = first_token->dval;
                yytokenspell = first_token->spell;
                yytokenraw = first_token->raw;
                yylloc = first_token->loc;
                ++first_token;
                if (first_token == last_token)
                    first_token = last_token = &token_buffer[0];
            }
        }

#ifdef PARSER_DEBUG
       qDebug() << "   in state" << action;
#endif

        action = t_action(action, yytoken);
#ifdef PARSER_DEBUG
       qDebug() << "   current token" << yytoken << (yytoken >= 0 ? spell[yytoken] : "(null)") << "new state" << action;
#endif
        if (action > 0) {
            if (action != ACCEPT_STATE) {
                yytoken = -1;
                sym(1).dval = yylval;
                stringRef(1) = yytokenspell;
                rawStringRef(1) = yytokenraw;
                loc(1) = yylloc;
            } else {
              --tos;
              return ! hadErrors;
            }
        } else if (action < 0) {
          const int r = -action - 1;
          tos -= rhs[r];

#ifdef PARSER_DEBUG
          qDebug() << "        reducing through rule " << -action;
#endif

          switch (r) {

#line 721 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 0: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 729 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 1: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 737 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 2: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 745 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 3: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 753 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 4: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 761 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 5: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 770 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 6: {
        sym(1).UiProgram = new (pool) AST::UiProgram(sym(1).UiHeaderItemList, sym(2).UiObjectMemberList->finish());
    } break;

#line 778 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 8: {
        sym(1).Node = sym(1).UiHeaderItemList->finish();
    } break;

#line 785 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 9: {
        sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiPragma);
    } break;

#line 792 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 10: {
        sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiImport);
    } break;

#line 799 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 11: {
        sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiHeaderItemList, sym(2).UiPragma);
    } break;

#line 806 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 12: {
        sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiHeaderItemList, sym(2).UiImport);
    } break;

#line 818 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 16: {
        AST::UiPragma *pragma = new (pool) AST::UiPragma(stringRef(2));
        pragma->pragmaToken = loc(1);
        pragma->semicolonToken = loc(3);
        sym(1).Node = pragma;
    } break;

#line 830 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 18: {
        sym(1).UiImport->semicolonToken = loc(2);
    } break;

#line 837 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 19: {
        const int major = sym(1).dval;
        const int minor = sym(3).dval;
        if (!QTypeRevision::isValidSegment(major) || !QTypeRevision::isValidSegment(minor)) {
            diagnostic_messages.append(
                    compileError(loc(1),
                    QLatin1String("Invalid version. Version numbers must be >= 0 and < 255.")));
            return false;
        }
        auto version = new (pool) AST::UiVersionSpecifier(major, minor);
        version->majorToken = loc(1);
        version->minorToken = loc(3);
        sym(1).UiVersionSpecifier = version;
    } break;

#line 856 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 20: {
        const int major = sym(1).dval;
        if (!QTypeRevision::isValidSegment(major)) {
            diagnostic_messages.append(
                    compileError(loc(1),
                    QLatin1String("Invalid major version. Version numbers must be >= 0 and < 255.")));
            return false;
        }
        auto version = new (pool) AST::UiVersionSpecifier(sym(1).dval);
        version->majorToken = loc(1);
        sym(1).UiVersionSpecifier = version;
    } break;

#line 872 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 21: {
        sym(1).UiImport->version = sym(2).UiVersionSpecifier;
        sym(1).UiImport->semicolonToken = loc(3);
    } break;

#line 880 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 22: {
        sym(1).UiImport->version = sym(2).UiVersionSpecifier;
        sym(1).UiImport->asToken = loc(3);
        sym(1).UiImport->importIdToken = loc(4);
        sym(1).UiImport->importId = stringRef(4);
        sym(1).UiImport->semicolonToken = loc(5);
    } break;

#line 891 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 23: {
        sym(1).UiImport->asToken = loc(2);
        sym(1).UiImport->importIdToken = loc(3);
        sym(1).UiImport->importId = stringRef(3);
        sym(1).UiImport->semicolonToken = loc(4);
    } break;

#line 901 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 24: {
        AST::UiImport *node = 0;

        if (AST::StringLiteral *importIdLiteral = AST::cast<AST::StringLiteral *>(sym(2).Expression)) {
            node = new (pool) AST::UiImport(importIdLiteral->value);
            node->fileNameToken = loc(2);
        } else if (AST::UiQualifiedId *qualifiedId = reparseAsQualifiedId(sym(2).Expression)) {
            node = new (pool) AST::UiImport(qualifiedId);
            node->fileNameToken = loc(2);
        }

        sym(1).Node = node;

        if (node) {
            node->importToken = loc(1);
        } else {
            diagnostic_messages.append(compileError(loc(1),
             QLatin1String("Expected a qualified name id or a string literal")));

            return false; // ### remove me
        }
    } break;

#line 927 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 25: {
        sym(1).Node = nullptr;
    } break;

#line 934 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 26: {
        sym(1).Node = new (pool) AST::UiObjectMemberList(sym(1).UiObjectMember);
    } break;

#line 941 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 27: {
        AST::IdentifierExpression *node = new (pool) AST::IdentifierExpression(stringRef(1));
        node->identifierToken = loc(1);
        sym(1).Node = node;
    } break;

#line 950 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 28: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        sym(1).Node = node;
    } break;

#line 960 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 29: {
        if (AST::UiQualifiedId *qualifiedId = reparseAsQualifiedId(sym(1).Expression)) {
            sym(1).UiQualifiedId = qualifiedId;
        } else {
            sym(1).UiQualifiedId = 0;

            diagnostic_messages.append(compileError(loc(1),
            QLatin1String("Expected a qualified name id")));

            return false;
        }
        AST::UiAnnotation *node = new (pool) AST::UiAnnotation(sym(1).UiQualifiedId, sym(2).UiObjectInitializer);
        sym(1).Node = node;
    } break;

#line 978 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

case 30: {
    sym(1).Node = sym(2).Node;
} break;

#line 986 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 31: {
        sym(1).Node = new (pool) AST::UiAnnotationList(sym(1).UiAnnotation);
    } break;

#line 993 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 32: {
        AST::UiAnnotationList *node = new (pool) AST::UiAnnotationList(sym(1).UiAnnotationList, sym(2).UiAnnotation);
        sym(1).Node = node;
    } break;

#line 1001 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

   case 33: {
       AST::UiObjectDefinition *node = sym(2).UiObjectDefinition;
       node->annotations = sym(1).UiAnnotationList->finish();
       sym(1).Node = node;
   } break;

#line 1012 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 35: {
        sym(1).Node = new (pool) AST::UiObjectMemberList(sym(1).UiObjectMember);
    } break;

#line 1019 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 36: {
        AST::UiObjectMemberList *node = new (pool) AST:: UiObjectMemberList(sym(1).UiObjectMemberList, sym(2).UiObjectMember);
        sym(1).Node = node;
    } break;

#line 1027 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 37: {
        sym(1).Node = new (pool) AST::UiArrayMemberList(sym(1).UiObjectMember);
    } break;

#line 1034 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 38: {
        AST::UiArrayMemberList *node = new (pool) AST::UiArrayMemberList(sym(1).UiArrayMemberList, sym(3).UiObjectMember);
        node->commaToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1043 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 39: {
        AST::UiObjectInitializer *node = new (pool) AST::UiObjectInitializer((AST::UiObjectMemberList*)0);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1053 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 40: {
        AST::UiObjectInitializer *node = new (pool) AST::UiObjectInitializer(sym(2).UiObjectMemberList->finish());
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1063 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 41: {
        AST::UiObjectDefinition *node = new (pool) AST::UiObjectDefinition(sym(1).UiQualifiedId, sym(2).UiObjectInitializer);
        sym(1).Node = node;
    } break;

#line 1071 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

   case 42: {
       AST::UiObjectMember *node = sym(2).UiObjectMember;
       node->annotations = sym(1).UiAnnotationList->finish();
       sym(1).Node = sym(2).Node;
   } break;

#line 1084 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 45: {
        AST::UiArrayBinding *node = new (pool) AST::UiArrayBinding(sym(1).UiQualifiedId, sym(5).UiArrayMemberList->finish());
        node->colonToken = loc(2);
        node->lbracketToken = loc(4);
        node->rbracketToken = loc(6);
        sym(1).Node = node;
    } break;

#line 1095 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 46: {
        AST::UiObjectBinding *node = new (pool) AST::UiObjectBinding(
            sym(1).UiQualifiedId, sym(4).UiQualifiedId, sym(5).UiObjectInitializer);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1105 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 47: {
        AST::UiObjectBinding *node = new (pool) AST::UiObjectBinding(
          sym(3).UiQualifiedId, sym(1).UiQualifiedId, sym(4).UiObjectInitializer);
        node->colonToken = loc(2);
        node->hasOnToken = true;
        sym(1).Node = node;
    } break;

#line 1117 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 48: {
        AST::ObjectPattern *l = new (pool) AST::ObjectPattern(sym(3).PatternPropertyList->finish());
        l->lbraceToken = loc(1);
        l->rbraceToken = loc(4);
        AST::ExpressionStatement *node = new (pool) AST::ExpressionStatement(l);
        node->semicolonToken = loc(5);
        sym(1).Node = node;
    } break;

#line 1130 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 49: {
        AST::ObjectPattern *l = new (pool) AST::ObjectPattern(sym(3).PatternPropertyList->finish());
        l->lbraceToken = loc(1);
        l->rbraceToken = loc(5);
        AST::ExpressionStatement *node = new (pool) AST::ExpressionStatement(l);
        node->semicolonToken = loc(6);
        sym(1).Node = node;
    } break;

#line 1143 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 50: Q_FALLTHROUGH(); 
#line 1145 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 51: Q_FALLTHROUGH(); 
#line 1147 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 52: {
        sym(1).Node = sym(3).Node;
    } break;

#line 1155 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 53: Q_FALLTHROUGH(); 
#line 1157 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 54: Q_FALLTHROUGH(); 
#line 1159 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 55: Q_FALLTHROUGH(); 
#line 1161 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 56: Q_FALLTHROUGH(); 
#line 1163 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 57: Q_FALLTHROUGH(); 
#line 1165 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 58: {
        sym(1).Node = sym(2).Node;
    } break;

#line 1172 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

case 59:
{
    AST::UiScriptBinding *node = new (pool) AST::UiScriptBinding(sym(1).UiQualifiedId, sym(3).Statement);
    node->colonToken = loc(2);
    sym(1).Node = node;
    } break;

#line 1182 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 60: Q_FALLTHROUGH(); 
#line 1184 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 61: Q_FALLTHROUGH(); 
#line 1186 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 62: {
        AST::UiQualifiedId *node = new (pool) AST::UiQualifiedId(stringRef(1));
        node->identifierToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1195 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 63: {
        AST::UiQualifiedId *node = new (pool) AST::UiQualifiedId(sym(1).UiQualifiedId, stringRef(3));
        node->identifierToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1204 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 64: {
        sym(1).Node = nullptr;
    } break;

#line 1211 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 65: {
        sym(1).Node = sym(1).UiParameterList->finish();
    } break;

#line 1218 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 66: {
        AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(3).UiQualifiedId->finish(), stringRef(1));
        node->identifierToken = loc(1);
        node->colonToken = loc(2);
        node->propertyTypeToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1229 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 67: {
        AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(1).UiQualifiedId->finish(), stringRef(2));
        node->propertyTypeToken = loc(1);
        node->identifierToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1239 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 68: {
        AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(1).UiParameterList, sym(5).UiQualifiedId->finish(), stringRef(3));
        node->propertyTypeToken = loc(5);
        node->commaToken = loc(2);
        node->identifierToken = loc(3);
        node->colonToken = loc(4);
        sym(1).Node = node;
    } break;

#line 1251 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 69: {
        AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(1).UiParameterList, sym(3).UiQualifiedId->finish(), stringRef(4));
        node->propertyTypeToken = loc(3);
        node->commaToken = loc(2);
        node->identifierToken = loc(4);
        sym(1).Node = node;
    } break;

#line 1262 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 70: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(nullptr, stringRef(2));
        node->type = AST::UiPublicMember::Signal;
        node->propertyToken = loc(1);
        node->typeToken = loc(2);
        node->identifierToken = loc(2);
        node->parameters = sym(4).UiParameterList;
        node->semicolonToken = loc(6);
        sym(1).Node = node;
    } break;

#line 1276 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 71: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(nullptr, stringRef(2));
        node->type = AST::UiPublicMember::Signal;
        node->propertyToken = loc(1);
        node->typeToken = loc(2);
        node->identifierToken = loc(2);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1289 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 72: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(4).UiQualifiedId->finish(), stringRef(6));
        node->typeModifier = stringRef(2);
        node->propertyToken = loc(1);
        node->typeModifierToken = loc(2);
        node->typeToken = loc(4);
        node->identifierToken = loc(6);
        node->semicolonToken = loc(7);
        sym(1).Node = node;
    } break;

#line 1305 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 74: {
        AST::UiPublicMember *node = sym(2).UiPublicMember;
        node->isReadonlyMember = true;
        node->readonlyToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1315 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 75: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(2).UiQualifiedId->finish(), stringRef(3));
        node->propertyToken = loc(1);
        node->typeToken = loc(2);
        node->identifierToken = loc(3);
        node->semicolonToken = loc(4);
        sym(1).Node = node;
    } break;

#line 1330 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 77: {
        AST::UiPublicMember *node = sym(2).UiPublicMember;
        node->isDefaultMember = true;
        node->defaultToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1341 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 78: {
        AST::UiPublicMember *node = sym(2).UiPublicMember;
        node->isRequired = true;
        node->requiredToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1351 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 79: {
        AST::UiPublicMember *node = sym(3).UiPublicMember;
        node->isRequired = true;
        node->requiredToken = loc(2);
        node->isDefaultMember = true;
        node->defaultToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1363 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 80: {
        AST::UiPublicMember *node = sym(3).UiPublicMember;
        node->isRequired = true;
        node->requiredToken = loc(1);
        node->isDefaultMember = true;
        node->defaultToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1375 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 81: {
        AST::UiPublicMember *node = sym(2).UiPublicMember;
        node->isDefaultMember = true;
        node->defaultToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1385 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 82: {
        AST::UiPublicMember *node = sym(3).UiPublicMember;
        node->isDefaultMember = true;
        node->defaultToken = loc(1);
        node->isRequired = true;
        node->requiredToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1398 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 83: {
        AST::UiPublicMember *node = sym(3).UiPublicMember;
        node->isDefaultMember = true;
        node->defaultToken = loc(2);
        node->isRequired = true;
        node->requiredToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1410 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

/* we need OptionalSemicolon because UiScriptStatement might already parse the last semicolon
  and then we would miss a semicolon (see tests/auto/quick/qquickvisualdatamodel/data/objectlist.qml)*/
 
#line 1416 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 86: {
        AST::UiRequired *node = new (pool) AST::UiRequired(stringRef(2));
        node->requiredToken = loc(1);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1428 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 88: {
        AST::UiPublicMember *node = sym(2).UiPublicMember;
        node->requiredToken = loc(1);
        node->isRequired = true;
        sym(1).Node = node;
    } break;

#line 1438 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 89: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(2).UiQualifiedId->finish(), stringRef(3), sym(5).Statement);
        node->propertyToken = loc(1);
        node->typeToken = loc(2);
        node->identifierToken = loc(3);
        node->colonToken = loc(4);
        sym(1).Node = node;
    } break;

#line 1452 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 91: {
        AST::UiPublicMember *node = sym(2).UiPublicMember;
        node->isReadonlyMember = true;
        node->readonlyToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1462 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 92: {
        AST::UiPublicMember *node = sym(2).UiPublicMember;
        node->isDefaultMember = true;
        node->defaultToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1472 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 93: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(4).UiQualifiedId->finish(), stringRef(6));
        node->typeModifier = stringRef(2);
        node->propertyToken = loc(1);
        node->typeModifierToken = loc(2);
        node->typeToken = loc(4);
        node->identifierToken = loc(6);
        node->semicolonToken = loc(7); // insert a fake ';' before ':'

        AST::UiQualifiedId *propertyName = new (pool) AST::UiQualifiedId(stringRef(6));
        propertyName->identifierToken = loc(6);
        propertyName->next = 0;

        AST::UiArrayBinding *binding = new (pool) AST::UiArrayBinding(propertyName, sym(9).UiArrayMemberList->finish());
        binding->colonToken = loc(7);
        binding->lbracketToken = loc(8);
        binding->rbracketToken = loc(10);

        node->binding = binding;

        sym(1).Node = node;
    } break;

#line 1500 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 95: {
        AST::UiPublicMember *node = sym(2).UiPublicMember;
        node->isReadonlyMember = true;
        node->readonlyToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1510 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 96: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(2).UiQualifiedId->finish(), stringRef(3));
        node->propertyToken = loc(1);
        node->typeToken = loc(2);
        node->identifierToken = loc(3);
        node->semicolonToken = loc(4); // insert a fake ';' before ':'

        AST::UiQualifiedId *propertyName = new (pool) AST::UiQualifiedId(stringRef(3));
        propertyName->identifierToken = loc(3);
        propertyName->next = 0;

        AST::UiObjectBinding *binding = new (pool) AST::UiObjectBinding(
          propertyName, sym(6).UiQualifiedId, sym(7).UiObjectInitializer);
        binding->colonToken = loc(4);

        node->binding = binding;

        sym(1).Node = node;
    } break;

#line 1535 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 98: {
        AST::UiPublicMember *node = sym(2).UiPublicMember;
        node->isReadonlyMember = true;
        node->readonlyToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1545 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 99: {
        auto node = new (pool) AST::UiSourceElement(sym(1).Node);
        sym(1).Node = node;
    } break;

#line 1553 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 100: {
        sym(1).Node = new (pool) AST::UiSourceElement(sym(1).Node);
    } break;

#line 1560 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 101: {
        sym(1).Node = new (pool) AST::UiSourceElement(sym(1).Node);
    } break;

#line 1567 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 102: {
      if (AST::ArrayMemberExpression *mem = AST::cast<AST::ArrayMemberExpression *>(sym(1).Expression)) {
        diagnostic_messages.append(compileError(mem->lbracketToken,
          QLatin1String("Ignored annotation"), QtWarningMsg));

        sym(1).Expression = mem->base;
      }

      if (AST::UiQualifiedId *qualifiedId = reparseAsQualifiedId(sym(1).Expression)) {
        sym(1).UiQualifiedId = qualifiedId;
      } else {
        sym(1).UiQualifiedId = 0;

        diagnostic_messages.append(compileError(loc(1),
          QLatin1String("Expected a qualified name id")));

        return false; // ### recover
      }
    } break;

#line 1590 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 103: {
        AST::UiEnumDeclaration *enumDeclaration = new (pool) AST::UiEnumDeclaration(stringRef(2), sym(4).UiEnumMemberList->finish());
        enumDeclaration->enumToken = loc(1);
        enumDeclaration->rbraceToken = loc(5);
        sym(1).Node = enumDeclaration;
        break;
    }

#line 1601 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 104: {
        if (!stringRef(2).front().isUpper()) {
            diagnostic_messages.append(compileError(loc(2),
                QLatin1String("Type name must be upper case"), QtWarningMsg));
        }
        auto inlineComponent = new (pool) AST::UiInlineComponent(stringRef(2), sym(4).UiObjectDefinition);
        inlineComponent->componentToken = loc(1);
        sym(1).Node = inlineComponent;
    } break;

#line 1614 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 105: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(stringRef(1));
        node->memberToken = loc(1);
        sym(1).Node = node;
        break;
    }

#line 1624 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 106: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(stringRef(1), sym(3).dval);
        node->memberToken = loc(1);
        node->valueToken = loc(3);
        sym(1).Node = node;
        break;
    }

#line 1635 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 107: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(sym(1).UiEnumMemberList, stringRef(3));
        node->memberToken = loc(3);
        sym(1).Node = node;
        break;
    }

#line 1645 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 108: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(sym(1).UiEnumMemberList, stringRef(3), sym(5).dval);
        node->memberToken = loc(3);
        node->valueToken = loc(5);
        sym(1).Node = node;
        break;
    }

#line 1689 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 135: {
        sym(1).TypeArgumentList = new (pool) AST::TypeArgumentList(sym(1).Type);
    } break;

#line 1696 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 136: {
        sym(1).TypeArgumentList = new (pool) AST::TypeArgumentList(sym(1).TypeArgumentList, sym(3).Type);
    } break;

#line 1703 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 137: {
        sym(1).Type = new (pool) AST::Type(sym(1).UiQualifiedId, sym(3).TypeArgumentList->finish());
    } break;

#line 1710 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 138: {
        AST::UiQualifiedId *id = new (pool) AST::UiQualifiedId(stringRef(1));
        id->identifierToken = loc(1);
        sym(1).Type = new (pool) AST::Type(id->finish());
    } break;

#line 1719 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 139: {
        sym(1).Type = new (pool) AST::Type(sym(1).UiQualifiedId);
    } break;

#line 1726 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 140: {
        AST::UiQualifiedId *id = new (pool) AST::UiQualifiedId(stringRef(1));
        id->identifierToken = loc(1);
        sym(1).Type = new (pool) AST::Type(id->finish());
    } break;

#line 1735 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 141: {
        sym(1).TypeAnnotation = new (pool) AST::TypeAnnotation(sym(2).Type);
        sym(1).TypeAnnotation->colonToken = loc(1);
    } break;

#line 1744 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 143: {
        sym(1).TypeAnnotation = nullptr;
    } break;

#line 1755 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 144: {
        AST::ThisExpression *node = new (pool) AST::ThisExpression();
        node->thisToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1764 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 145: {
        AST::IdentifierExpression *node = new (pool) AST::IdentifierExpression(stringRef(1));
        node->identifierToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1782 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 154: {
        if (coverExpressionType != CE_ParenthesizedExpression) {
            syntaxError(coverExpressionErrorLocation, "Expected token ')'.");
            return false;
        }
    } break;

#line 1793 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 155: {
        AST::NestedExpression *node = new (pool) AST::NestedExpression(sym(2).Expression);
        node->lparenToken = loc(1);
        node->rparenToken = loc(3);
        sym(1).Node = node;
        coverExpressionType = CE_ParenthesizedExpression;
    } break;

#line 1804 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 156: {
        sym(1).Node = nullptr;
        coverExpressionErrorLocation = loc(2);
        coverExpressionType = CE_FormalParameterList;
    } break;

#line 1813 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 157: {
        AST::FormalParameterList *node = (new (pool) AST::FormalParameterList(nullptr, sym(2).PatternElement))->finish(pool);
        sym(1).Node = node;
        coverExpressionErrorLocation = loc(2);
        coverExpressionType = CE_FormalParameterList;
    } break;

#line 1823 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 158: {
        AST::FormalParameterList *list = sym(2).Expression->reparseAsFormalParameterList(pool);
        if (!list) {
            syntaxError(loc(1), "Invalid Arrow parameter list.");
            return false;
        }
        if (sym(4).Node) {
            list = new (pool) AST::FormalParameterList(list, sym(4).PatternElement);
        }
        coverExpressionErrorLocation = loc(4);
        coverExpressionType = CE_FormalParameterList;
        sym(1).Node = list->finish(pool);
    } break;

#line 1840 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 159: {
        AST::NullExpression *node = new (pool) AST::NullExpression();
        node->nullToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1849 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 160: {
        AST::TrueLiteral *node = new (pool) AST::TrueLiteral();
        node->trueToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1858 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 161: {
        AST::FalseLiteral *node = new (pool) AST::FalseLiteral();
        node->falseToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1867 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 162: {
        AST::NumericLiteral *node = new (pool) AST::NumericLiteral(sym(1).dval);
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1876 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 163: Q_FALLTHROUGH(); 
#line 1879 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 164: {
        AST::StringLiteral *node = new (pool) AST::StringLiteral(stringRef(1));
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1891 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

{
    Lexer::RegExpBodyPrefix prefix;
    case 165:
        prefix = Lexer::NoPrefix;
        goto scan_regexp;

#line 1903 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 166:
        prefix = Lexer::EqualPrefix;
        goto scan_regexp;

    scan_regexp: {
        bool rx = lexer->scanRegExp(prefix);
        if (!rx) {
            diagnostic_messages.append(compileError(location(lexer), lexer->errorMessage()));
            return false;
        }

        loc(1).length = lexer->tokenLength();
        yylloc = loc(1); // adjust the location of the current token

        AST::RegExpLiteral *node = new (pool) AST::RegExpLiteral(driver->newStringRef(lexer->regExpPattern()), lexer->regExpFlags());
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;
}

#line 1927 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 167: {
        AST::PatternElementList *list = nullptr;
        if (sym(2).Elision)
            list = (new (pool) AST::PatternElementList(sym(2).Elision, nullptr))->finish();
        AST::ArrayPattern *node = new (pool) AST::ArrayPattern(list);
        node->lbracketToken = loc(1);
        node->rbracketToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1940 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 168: {
        AST::ArrayPattern *node = new (pool) AST::ArrayPattern(sym(2).PatternElementList->finish());
        node->lbracketToken = loc(1);
        node->rbracketToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1950 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 169: {
        auto *list = sym(2).PatternElementList;
        if (sym(4).Elision) {
            AST::PatternElementList *l = new (pool) AST::PatternElementList(sym(4).Elision, nullptr);
            list = list->append(l);
        }
        AST::ArrayPattern *node = new (pool) AST::ArrayPattern(list->finish());
        node->lbracketToken = loc(1);
        node->commaToken = loc(3);
        node->rbracketToken = loc(5);
        sym(1).Node = node;
        Q_ASSERT(node->isValidArrayLiteral());
    } break;

#line 1967 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 170: {
        AST::PatternElement *e = new (pool) AST::PatternElement(sym(1).Expression);
        sym(1).Node = new (pool) AST::PatternElementList(nullptr, e);
    } break;

#line 1975 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 171: {
        AST::PatternElement *e = new (pool) AST::PatternElement(sym(2).Expression);
        sym(1).Node = new (pool) AST::PatternElementList(sym(1).Elision->finish(), e);
    } break;

#line 1983 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 172: {
        AST::PatternElementList *node = new (pool) AST::PatternElementList(sym(1).Elision, sym(2).PatternElement);
        sym(1).Node = node;
    } break;

#line 1991 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 173: {
        AST::PatternElement *e = new (pool) AST::PatternElement(sym(4).Expression);
        AST::PatternElementList *node = new (pool) AST::PatternElementList(sym(3).Elision, e);
        sym(1).Node = sym(1).PatternElementList->append(node);
    } break;

#line 2000 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 174: {
        AST::PatternElementList *node = new (pool) AST::PatternElementList(sym(3).Elision, sym(4).PatternElement);
        sym(1).Node = sym(1).PatternElementList->append(node);
    } break;

#line 2008 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 175: {
        AST::Elision *node = new (pool) AST::Elision();
        node->commaToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2017 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 176: {
        AST::Elision *node = new (pool) AST::Elision(sym(1).Elision);
        node->commaToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2026 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 177: {
        sym(1).Node = nullptr;
    } break;

#line 2033 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 178: {
        sym(1).Node = sym(1).Elision->finish();
    } break;

#line 2040 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 179: {
        AST::PatternElement *node = new (pool) AST::PatternElement(sym(2).Expression, AST::PatternElement::SpreadElement);
        sym(1).Node = node;
    } break;

#line 2048 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 180: {
        AST::ObjectPattern *node = new (pool) AST::ObjectPattern();
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2058 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 181: {
        AST::ObjectPattern *node = new (pool) AST::ObjectPattern(sym(2).PatternPropertyList->finish());
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        sym(1).Node = node;
    } break;

#line 2068 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 182: {
        AST::ObjectPattern *node = new (pool) AST::ObjectPattern(sym(2).PatternPropertyList->finish());
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2079 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 183: Q_FALLTHROUGH(); 
#line 2081 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 184: {
      sym(1).Node = new (pool) AST::PatternPropertyList(sym(1).PatternProperty);
    } break;

#line 2088 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 185: Q_FALLTHROUGH(); 
#line 2090 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 186: {
        AST::PatternPropertyList *node = new (pool) AST::PatternPropertyList(sym(1).PatternPropertyList, sym(3).PatternProperty);
        sym(1).Node = node;
    } break;

#line 2098 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 187: {
        AST::IdentifierPropertyName *name = new (pool) AST::IdentifierPropertyName(stringRef(1));
        name->propertyNameToken = loc(1);
        AST::IdentifierExpression *expr = new (pool) AST::IdentifierExpression(stringRef(1));
        expr->identifierToken = loc(1);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(name, expr);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2114 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 189: {
        AST::IdentifierPropertyName *name = new (pool) AST::IdentifierPropertyName(stringRef(1));
        name->propertyNameToken = loc(1);
        AST::IdentifierExpression *left = new (pool) AST::IdentifierExpression(stringRef(1));
        left->identifierToken = loc(1);
        // if initializer is an anonymous function expression, we need to assign identifierref as it's name
        if (auto *f = asAnonymousFunctionDefinition(sym(2).Expression))
            f->name = stringRef(1);
        if (auto *c = asAnonymousClassDefinition(sym(2).Expression))
            c->name = stringRef(1);
        AST::BinaryExpression *assignment = new (pool) AST::BinaryExpression(left, QSOperator::Assign, sym(2).Expression);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(name, assignment);
        node->colonToken = loc(1);
        sym(1).Node = node;

    } break;

#line 2134 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 190: Q_FALLTHROUGH(); 
#line 2136 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 191: {
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(1).PropertyName, sym(3).Expression);
        if (auto *c = asAnonymousClassDefinition(sym(3).Expression)) {
            if (!AST::cast<AST::ComputedPropertyName *>(sym(1).PropertyName))
                c->name = driver->newStringRef(sym(1).PropertyName->asString());
        }
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2154 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 195: {
        AST::IdentifierPropertyName *node = new (pool) AST::IdentifierPropertyName(stringRef(1));
        node->propertyNameToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2163 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 196: Q_FALLTHROUGH(); 
#line 2165 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 197: {
        AST::StringLiteralPropertyName *node = new (pool) AST::StringLiteralPropertyName(stringRef(1));
        node->propertyNameToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2174 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 198: Q_FALLTHROUGH(); 
#line 2176 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 199: {
        AST::NumericLiteralPropertyName *node = new (pool) AST::NumericLiteralPropertyName(sym(1).dval);
        node->propertyNameToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2227 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 240: {
        AST::ComputedPropertyName *node = new (pool) AST::ComputedPropertyName(sym(2).Expression);
        node->propertyNameToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2236 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 241: Q_FALLTHROUGH(); 
#line 2238 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

case 242: {
    sym(1) = sym(2);
} break;

#line 2246 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 243: Q_FALLTHROUGH(); 
#line 2248 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 244: {
        sym(1).Node = nullptr;
    } break;

#line 2258 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 247: {
        AST::TemplateLiteral *node = new (pool) AST::TemplateLiteral(stringRef(1), rawStringRef(1), nullptr);
        node->literalToken = loc(1);
        node->hasNoSubstitution = true;
        sym(1).Node = node;
    } break;

#line 2268 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 248: {
        AST::TemplateLiteral *node = new (pool) AST::TemplateLiteral(stringRef(1), rawStringRef(1), nullptr);
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2277 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 249: Q_FALLTHROUGH(); 
#line 2280 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 250: {
        AST::TemplateLiteral *node = new (pool) AST::TemplateLiteral(stringRef(1), rawStringRef(1), sym(2).Expression);
        node->next = sym(3).Template;
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2293 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 252: {
        AST::SuperLiteral *node = new (pool) AST::SuperLiteral();
        node->superToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2303 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 253: Q_FALLTHROUGH(); 
#line 2305 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 254: {
        AST::ArrayMemberExpression *node = new (pool) AST::ArrayMemberExpression(sym(1).Expression, sym(3).Expression);
        node->lbracketToken = loc(2);
        node->rbracketToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2314 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 255: {
        AST::ArrayMemberExpression *node = new (pool) AST::ArrayMemberExpression(sym(1).Expression, sym(4).Expression);
        node->lbracketToken = loc(3);
        node->rbracketToken = loc(5);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2326 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 256:
    {
        AST::IdentifierExpression *node = new (pool) AST::IdentifierExpression(stringRef(1));
        node->identifierToken= loc(1);
        sym(1).Node = node;
    } Q_FALLTHROUGH();

#line 2334 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 257: Q_FALLTHROUGH(); 
#line 2336 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 258: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        sym(1).Node = node;
    } break;

#line 2346 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 259: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2359 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 261: {
        AST::NewMemberExpression *node = new (pool) AST::NewMemberExpression(sym(2).Expression, sym(4).ArgumentList);
        node->newToken = loc(1);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        sym(1).Node = node;
    } break;

#line 2375 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 264: {
        AST::NewExpression *node = new (pool) AST::NewExpression(sym(2).Expression);
        node->newToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2385 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 265: Q_FALLTHROUGH(); 
#line 2387 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 266: {
        AST::TaggedTemplate *node = new (pool) AST::TaggedTemplate(sym(1).Expression, sym(2).Template);
        sym(1).Node = node;
    } break;

#line 2395 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 267: {
        AST::CallExpression *node = new (pool) AST::CallExpression(sym(1).Expression, sym(3).ArgumentList);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2405 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 268: {
        AST::CallExpression *node = new (pool) AST::CallExpression(sym(1).Expression, sym(4).ArgumentList);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2416 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 269: Q_FALLTHROUGH(); 
#line 2418 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 270: {
        AST::CallExpression *node = new (pool) AST::CallExpression(sym(1).Expression, sym(3).ArgumentList);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2428 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 271: {
        AST::CallExpression *node = new (pool) AST::CallExpression(sym(1).Expression, sym(4).ArgumentList);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2440 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 272: {
        AST::ArrayMemberExpression *node = new (pool) AST::ArrayMemberExpression(sym(1).Expression, sym(3).Expression);
        node->lbracketToken = loc(2);
        node->rbracketToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2450 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 273: {
        AST::ArrayMemberExpression *node = new (pool) AST::ArrayMemberExpression(sym(1).Expression, sym(4).Expression);
        node->lbracketToken = loc(3);
        node->rbracketToken = loc(5);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2461 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 274: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        sym(1).Node = node;
    } break;

#line 2471 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 275: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2482 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 276: {
        sym(1).Node = nullptr;
    } break;

#line 2489 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 277: Q_FALLTHROUGH(); 
#line 2491 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 278: {
        sym(1).Node = sym(1).ArgumentList->finish();
    } break;

#line 2498 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 279: {
        sym(1).Node = new (pool) AST::ArgumentList(sym(1).Expression);
    } break;

#line 2505 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 280: {
        AST::ArgumentList *node = new (pool) AST::ArgumentList(sym(2).Expression);
        node->isSpreadElement = true;
        sym(1).Node = node;
    } break;

#line 2514 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 281: {
        AST::ArgumentList *node = new (pool) AST::ArgumentList(sym(1).ArgumentList, sym(3).Expression);
        node->commaToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2523 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 282: {
        AST::ArgumentList *node = new (pool) AST::ArgumentList(sym(1).ArgumentList, sym(4).Expression);
        node->commaToken = loc(2);
        node->isSpreadElement = true;
        sym(1).Node = node;
    } break;

#line 2538 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 286: {
        AST::PostIncrementExpression *node = new (pool) AST::PostIncrementExpression(sym(1).Expression);
        node->incrementToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2547 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 287: {
        AST::PostDecrementExpression *node = new (pool) AST::PostDecrementExpression(sym(1).Expression);
        node->decrementToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2556 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 288: {
        AST::PreIncrementExpression *node = new (pool) AST::PreIncrementExpression(sym(2).Expression);
        node->incrementToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2565 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 289: {
        AST::PreDecrementExpression *node = new (pool) AST::PreDecrementExpression(sym(2).Expression);
        node->decrementToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2576 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 291: {
        AST::DeleteExpression *node = new (pool) AST::DeleteExpression(sym(2).Expression);
        node->deleteToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2585 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 292: {
        AST::VoidExpression *node = new (pool) AST::VoidExpression(sym(2).Expression);
        node->voidToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2594 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 293: {
        AST::TypeOfExpression *node = new (pool) AST::TypeOfExpression(sym(2).Expression);
        node->typeofToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2603 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 294: {
        AST::UnaryPlusExpression *node = new (pool) AST::UnaryPlusExpression(sym(2).Expression);
        node->plusToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2612 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 295: {
        AST::UnaryMinusExpression *node = new (pool) AST::UnaryMinusExpression(sym(2).Expression);
        node->minusToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2621 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 296: {
        AST::TildeExpression *node = new (pool) AST::TildeExpression(sym(2).Expression);
        node->tildeToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2630 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 297: {
        AST::NotExpression *node = new (pool) AST::NotExpression(sym(2).Expression);
        node->notToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2641 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 299: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Exp, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2652 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 301: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, sym(2).ival, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2661 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 302: {
        sym(1).ival = QSOperator::Mul;
    } break;

#line 2668 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 303: {
        sym(1).ival = QSOperator::Div;
    } break;

#line 2675 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 304: {
        sym(1).ival = QSOperator::Mod;
    } break;

#line 2684 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 306: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Add, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2693 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 307: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Sub, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2704 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 309: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::LShift, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2713 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 310: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::RShift, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2722 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 311: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::URShift, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2734 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 314: Q_FALLTHROUGH(); 
#line 2736 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 315: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, sym(2).ival, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2745 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 316: {
        sym(1).ival = QSOperator::Lt;
    } break;

#line 2751 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 317: {
        sym(1).ival = QSOperator::Gt;
    } break;

#line 2757 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 318: {
        sym(1).ival = QSOperator::Le;
    } break;

#line 2763 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 319: {
        sym(1).ival = QSOperator::Ge;
    } break;

#line 2769 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 320: {
        sym(1).ival = QSOperator::InstanceOf;
    } break;

#line 2775 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 321: {
        sym(1).ival = QSOperator::As;
    } break;

#line 2782 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 322: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::In, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2794 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 325: Q_FALLTHROUGH(); 
#line 2796 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 326: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, sym(2).ival, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2805 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 327: {
        sym(1).ival = QSOperator::Equal;
    } break;

#line 2811 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 328: {
        sym(1).ival = QSOperator::NotEqual;
    } break;

#line 2817 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 329: {
        sym(1).ival = QSOperator::StrictEqual;
    } break;

#line 2823 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 330: {
        sym(1).ival = QSOperator::StrictNotEqual;
    } break;

#line 2834 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 333: Q_FALLTHROUGH(); 
#line 2836 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 334: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::BitAnd, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2849 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 337: Q_FALLTHROUGH(); 
#line 2851 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 338: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::BitXor, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2863 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 341: Q_FALLTHROUGH(); 
#line 2865 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 342: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::BitOr, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2877 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 345: Q_FALLTHROUGH(); 
#line 2879 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 346: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::And, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2891 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 349: Q_FALLTHROUGH(); 
#line 2893 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 350: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Or, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2905 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 353: Q_FALLTHROUGH(); 
#line 2907 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 354: {

        auto *lhs = sym(1).Expression;
        auto *rhs = sym(3).Expression;

        // Check if lhs or rhs contain || or &&

        if (lhs->binaryExpressionCast() != nullptr) {
            auto *binaryExpr = lhs->binaryExpressionCast();
            if (binaryExpr->op == QSOperator::And || binaryExpr->op == QSOperator::Or) {
                syntaxError(binaryExpr->operatorToken, "Left-hand side may not contain || or &&");
                return false;
            }
        }

        if (rhs->binaryExpressionCast() != nullptr) {
            auto *binaryExpr = rhs->binaryExpressionCast();
            if (binaryExpr->op == QSOperator::And || binaryExpr->op == QSOperator::Or) {
                syntaxError(binaryExpr->operatorToken, "Right-hand side may not contain || or &&");
                return false;
            }
        }

        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(lhs, QSOperator::Coalesce, rhs);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2941 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 357: Q_FALLTHROUGH(); 
#line 2943 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 358: {
        AST::ConditionalExpression *node = new (pool) AST::ConditionalExpression(sym(1).Expression, sym(3).Expression, sym(5).Expression);
        node->questionToken = loc(2);
        node->colonToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2962 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 365: Q_FALLTHROUGH(); 
#line 2964 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 366: {
        if (sym(1).Expression->containsOptionalChain()) {
            syntaxError(loc(1), QStringLiteral("Optional chains are not permitted on the left-hand-side in assignments"));
        }
        // need to convert the LHS to an AssignmentPattern if it was an Array/ObjectLiteral
        if (AST::Pattern *p = sym(1).Expression->patternCast()) {
            SourceLocation errorLoc;
            QString errorMsg;
            if (!p->convertLiteralToAssignmentPattern(pool, &errorLoc, &errorMsg)) {
                syntaxError(errorLoc, errorMsg);
                return false;
            }
        }
        // if lhs is an identifier expression and rhs is an anonymous function expression, we need to assign the name of lhs to the function
        if (auto *f = asAnonymousFunctionDefinition(sym(3).Expression)) {
            if (auto *id = AST::cast<AST::IdentifierExpression *>(sym(1).Expression))
                f->name = id->name;
        }
        if (auto *c = asAnonymousClassDefinition(sym(3).Expression)) {
            if (auto *id = AST::cast<AST::IdentifierExpression *>(sym(1).Expression))
                c->name = id->name;
        }

        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Assign, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2995 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 367: Q_FALLTHROUGH(); 
#line 2997 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 368: {
        if (sym(1).Expression->containsOptionalChain()) {
            syntaxError(loc(1), QStringLiteral("Optional chains are not permitted on the left-hand-side in assignments"));
        }
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, sym(2).ival, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3009 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 369: {
        sym(1).ival = QSOperator::InplaceMul;
    } break;

#line 3016 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 370: {
        sym(1).ival = QSOperator::InplaceExp;
    } break;

#line 3023 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 371: {
        sym(1).ival = QSOperator::InplaceDiv;
    } break;

#line 3030 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 372: {
        sym(1).ival = QSOperator::InplaceMod;
    } break;

#line 3037 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 373: {
        sym(1).ival = QSOperator::InplaceAdd;
    } break;

#line 3044 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 374: {
        sym(1).ival = QSOperator::InplaceSub;
    } break;

#line 3051 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 375: {
        sym(1).ival = QSOperator::InplaceLeftShift;
    } break;

#line 3058 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 376: {
        sym(1).ival = QSOperator::InplaceRightShift;
    } break;

#line 3065 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 377: {
        sym(1).ival = QSOperator::InplaceURightShift;
    } break;

#line 3072 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 378: {
        sym(1).ival = QSOperator::InplaceAnd;
    } break;

#line 3079 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 379: {
        sym(1).ival = QSOperator::InplaceXor;
    } break;

#line 3086 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 380: {
        sym(1).ival = QSOperator::InplaceOr;
    } break;

#line 3096 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 383: Q_FALLTHROUGH(); 
#line 3098 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 384: {
          AST::Expression *node = new (pool) AST::Expression(sym(1).Expression, sym(3).Expression);
          node->commaToken = loc(2);
          sym(1).Node = node;
    } break;

#line 3107 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 385: Q_FALLTHROUGH(); 
#line 3109 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 386: {
      sym(1).Node = nullptr;
    } break;

#line 3121 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 389: {
        sym(1).Node = sym(3).Node;
    } break;

#line 3128 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 390: Q_FALLTHROUGH(); 
#line 3130 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 391: Q_FALLTHROUGH(); 
#line 3132 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 392: Q_FALLTHROUGH(); 
#line 3134 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 393: Q_FALLTHROUGH(); 
#line 3136 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 394: Q_FALLTHROUGH(); 
#line 3138 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 395: Q_FALLTHROUGH(); 
#line 3140 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 396: Q_FALLTHROUGH(); 
#line 3142 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 397: Q_FALLTHROUGH(); 
#line 3144 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 398: Q_FALLTHROUGH(); 
#line 3146 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 399: Q_FALLTHROUGH(); 
#line 3148 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 400: Q_FALLTHROUGH(); 
#line 3150 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 401: Q_FALLTHROUGH(); 
#line 3152 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 402: {
        sym(1).Node = sym(2).Node;
    } break;

#line 3174 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 413: {
        AST::Block *node = new (pool) AST::Block(sym(2).StatementList);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3186 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 415: {
        sym(1).StatementList = sym(1).StatementList->append(sym(2).StatementList);
    } break;

#line 3193 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 416: {
        sym(1).StatementList = new (pool) AST::StatementList(sym(1).Statement);
    } break;

#line 3200 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 417: {
        sym(1).Node = new (pool) AST::StatementList(sym(3).FunctionDeclaration);
    } break;

#line 3207 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 418: {
        sym(1).Node = nullptr;
    } break;

#line 3214 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 419: {
        sym(1).Node = sym(1).StatementList->finish();
    } break;

#line 3221 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 420: {
        sym(1).scope = AST::VariableScope::Let;
    } break;

#line 3227 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 421: {
        sym(1).scope = AST::VariableScope::Const;
    } break;

#line 3234 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 422: {
        sym(1).scope = AST::VariableScope::Var;
    } break;

#line 3241 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 423: Q_FALLTHROUGH(); 
#line 3243 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 424: Q_FALLTHROUGH(); 
#line 3245 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 425: Q_FALLTHROUGH(); 
#line 3247 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 426: {
        AST::VariableDeclarationList *declarations = sym(2).VariableDeclarationList->finish(sym(1).scope);
        for (auto it = declarations; it; it = it->next) {
            if (it->declaration && it->declaration->typeAnnotation) {
                syntaxError(it->declaration->typeAnnotation->firstSourceLocation(), "Type annotations are not permitted in variable declarations");
                return false;
            }
        }
        AST::VariableStatement *node = new (pool) AST::VariableStatement(declarations);
        node->declarationKindToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3265 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 428: Q_FALLTHROUGH(); 
#line 3267 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 429: Q_FALLTHROUGH(); 
#line 3269 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 430: Q_FALLTHROUGH(); 
#line 3271 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 431: {
  sym(1).Node = new (pool) AST::VariableDeclarationList(sym(1).PatternElement);
    } break;

#line 3278 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 432: Q_FALLTHROUGH(); 
#line 3280 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 433: Q_FALLTHROUGH(); 
#line 3282 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 434: Q_FALLTHROUGH(); 
#line 3284 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 435: {
        AST::VariableDeclarationList *node = new (pool) AST::VariableDeclarationList(sym(1).VariableDeclarationList, sym(3).PatternElement);
        node->commaToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3293 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 436: Q_FALLTHROUGH(); 
#line 3295 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 437: Q_FALLTHROUGH(); 
#line 3297 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 438: Q_FALLTHROUGH(); 
#line 3299 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 439: {
        auto *node = new (pool) AST::PatternElement(stringRef(1), sym(2).TypeAnnotation, sym(3).Expression);
        node->identifierToken = loc(1);
        sym(1).Node = node;
        // if initializer is an anonymous function expression, we need to assign identifierref as it's name
        if (auto *f = asAnonymousFunctionDefinition(sym(3).Expression))
            f->name = stringRef(1);
        if (auto *c = asAnonymousClassDefinition(sym(3).Expression))
            c->name = stringRef(1);
    } break;

#line 3313 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 440: Q_FALLTHROUGH(); 
#line 3315 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 441: Q_FALLTHROUGH(); 
#line 3317 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 442: Q_FALLTHROUGH(); 
#line 3319 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 443: {
        auto *node = new (pool) AST::PatternElement(sym(1).Pattern, sym(2).Expression);
        node->identifierToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3328 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 444: {
        auto *node = new (pool) AST::ObjectPattern(sym(2).PatternPropertyList);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        node->parseMode = AST::Pattern::Binding;
        sym(1).Node = node;
    } break;

#line 3339 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 445: {
        auto *node = new (pool) AST::ArrayPattern(sym(2).PatternElementList);
        node->lbracketToken = loc(1);
        node->rbracketToken = loc(3);
        node->parseMode = AST::Pattern::Binding;
        sym(1).Node = node;
    } break;

#line 3350 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 446: {
        sym(1).Node = nullptr;
    } break;

#line 3357 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
 case 447: 
#line 3359 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 448: {
        sym(1).Node = sym(1).PatternPropertyList->finish();
    } break;

#line 3366 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 449: {
        if (sym(1).Elision || sym(2).Node) {
            auto *l = new (pool) AST::PatternElementList(sym(1).Elision, sym(2).PatternElement);
            sym(1).Node = l->finish();
        } else {
            sym(1).Node = nullptr;
        }
    } break;

#line 3378 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 450: {
        sym(1).Node = sym(1).PatternElementList->finish();
    } break;

#line 3385 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 451: {
        if (sym(3).Elision || sym(4).Node) {
            auto *l = new (pool) AST::PatternElementList(sym(3).Elision, sym(4).PatternElement);
            l = sym(1).PatternElementList->append(l);
            sym(1).Node = l;
        }
        sym(1).Node = sym(1).PatternElementList->finish();
    } break;

#line 3397 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 452: {
        sym(1).Node = new (pool) AST::PatternPropertyList(sym(1).PatternProperty);
    } break;

#line 3404 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 453: {
        sym(1).Node = new (pool) AST::PatternPropertyList(sym(1).PatternPropertyList, sym(3).PatternProperty);
    } break;

#line 3413 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 455: {
        sym(1).PatternElementList = sym(1).PatternElementList->append(sym(3).PatternElementList);
    } break;

#line 3420 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 456: {
        sym(1).Node = new (pool) AST::PatternElementList(sym(1).Elision, sym(2).PatternElement);
    } break;

#line 3428 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 457: {
        AST::StringLiteralPropertyName *name = new (pool) AST::StringLiteralPropertyName(stringRef(1));
        name->propertyNameToken = loc(1);
        // if initializer is an anonymous function expression, we need to assign identifierref as it's name
        if (auto *f = asAnonymousFunctionDefinition(sym(2).Expression))
            f->name = stringRef(1);
        if (auto *c = asAnonymousClassDefinition(sym(2).Expression))
            c->name = stringRef(1);
        sym(1).Node = new (pool) AST::PatternProperty(name, stringRef(1), sym(2).Expression);
    } break;

#line 3442 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 458: {
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(1).PropertyName, stringRef(3), sym(4).Expression);
        sym(1).Node = node;
    } break;

#line 3450 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 459: {
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(1).PropertyName, sym(3).Pattern, sym(4).Expression);
        sym(1).Node = node;
    } break;

#line 3458 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 460: {
      AST::PatternElement *node = new (pool) AST::PatternElement(stringRef(1), sym(2).TypeAnnotation, sym(3).Expression);
      node->identifierToken = loc(1);
      // if initializer is an anonymous function expression, we need to assign identifierref as it's name
      if (auto *f = asAnonymousFunctionDefinition(sym(3).Expression))
          f->name = stringRef(1);
      if (auto *c = asAnonymousClassDefinition(sym(3).Expression))
          c->name = stringRef(1);
      sym(1).Node = node;
    } break;

#line 3472 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 461: {
        AST::PatternElement *node = new (pool) AST::PatternElement(sym(1).Pattern, sym(2).Expression);
        sym(1).Node = node;
    } break;

#line 3480 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 462: {
        AST::PatternElement *node = new (pool) AST::PatternElement(stringRef(2), /*type annotation*/nullptr, nullptr, AST::PatternElement::RestElement);
        node->identifierToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3489 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 463: {
        AST::PatternElement *node = new (pool) AST::PatternElement(sym(2).Pattern, nullptr, AST::PatternElement::RestElement);
        sym(1).Node = node;
    } break;

#line 3497 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 464: {
        sym(1).Node = nullptr;
    } break;

#line 3507 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 466: {
        AST::EmptyStatement *node = new (pool) AST::EmptyStatement();
        node->semicolonToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3522 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 467: {
        int token = lookaheadToken(lexer);
        if (token == T_LBRACE)
            pushToken(T_FORCE_BLOCK);
        else if (token == T_FUNCTION || token == T_FUNCTION_STAR || token == T_CLASS || token == T_LET || token == T_CONST)
            pushToken(T_FORCE_DECLARATION);
    } break;

#line 3533 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 468: {
        AST::ExpressionStatement *node = new (pool) AST::ExpressionStatement(sym(1).Expression);
        node->semicolonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3542 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 469: {
        AST::IfStatement *node = new (pool) AST::IfStatement(sym(3).Expression, sym(5).Statement, sym(7).Statement);
        node->ifToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->elseToken = loc(6);
        sym(1).Node = node;
    } break;

#line 3554 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 470: {
        AST::IfStatement *node = new (pool) AST::IfStatement(sym(3).Expression, sym(5).Statement);
        node->ifToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3567 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 472: {
        AST::DoWhileStatement *node = new (pool) AST::DoWhileStatement(sym(2).Statement, sym(5).Expression);
        node->doToken = loc(1);
        node->whileToken = loc(3);
        node->lparenToken = loc(4);
        node->rparenToken = loc(6);
        node->semicolonToken = loc(7);
        sym(1).Node = node;
    } break;

#line 3580 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 473: {
        AST::WhileStatement *node = new (pool) AST::WhileStatement(sym(3).Expression, sym(5).Statement);
        node->whileToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3591 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 474: {
        AST::ForStatement *node = new (pool) AST::ForStatement(sym(3).Expression, sym(5).Expression, sym(7).Expression, sym(9).Statement);
        node->forToken = loc(1);
        node->lparenToken = loc(2);
        node->firstSemicolonToken = loc(4);
        node->secondSemicolonToken = loc(6);
        node->rparenToken = loc(8);
        sym(1).Node = node;
    } break;

#line 3604 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 475: Q_FALLTHROUGH(); 
#line 3606 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 476: {
        // ### get rid of the static_cast!
        AST::ForStatement *node = new (pool) AST::ForStatement(
          static_cast<AST::VariableStatement *>(sym(3).Node)->declarations, sym(5).Expression,
          sym(7).Expression, sym(9).Statement);
        node->forToken = loc(1);
        node->lparenToken = loc(2);
        node->firstSemicolonToken = loc(4);
        node->secondSemicolonToken = loc(6);
        node->rparenToken = loc(8);
        sym(1).Node = node;
    } break;

#line 3622 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 477: {
        sym(1).forEachType = AST::ForEachType::In;
    } break;

#line 3629 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 478: {
        sym(1).forEachType = AST::ForEachType::Of;
    } break;

#line 3636 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 479: {
        // need to convert the LHS to an AssignmentPattern if it was an Array/ObjectLiteral
        if (AST::Pattern *p = sym(3).Expression->patternCast()) {
            SourceLocation errorLoc;
            QString errorMsg;
            if (!p->convertLiteralToAssignmentPattern(pool, &errorLoc, &errorMsg)) {
                syntaxError(errorLoc, errorMsg);
                return false;
            }
        }
        AST::ForEachStatement *node = new (pool) AST::ForEachStatement(sym(3).Expression, sym(5).Expression, sym(7).Statement);
        node->forToken = loc(1);
        node->lparenToken = loc(2);
        node->inOfToken = loc(4);
        node->rparenToken = loc(6);
        node->type = sym(4).forEachType;
        sym(1).Node = node;
    } break;

#line 3658 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 480: {
        AST::ForEachStatement *node = new (pool) AST::ForEachStatement(sym(3).PatternElement, sym(5).Expression, sym(7).Statement);
        node->forToken = loc(1);
        node->lparenToken = loc(2);
        node->inOfToken = loc(4);
        node->rparenToken = loc(6);
        node->type = sym(4).forEachType;
        sym(1).Node = node;
    } break;

#line 3671 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 481: Q_FALLTHROUGH(); 
#line 3673 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 482: {
        if (auto typeAnnotation = sym(3).TypeAnnotation) {
            syntaxError(typeAnnotation->firstSourceLocation(), "Type annotations are not permitted in variable declarations");
            return false;
        }
        auto *node = new (pool) AST::PatternElement(stringRef(2), sym(3).TypeAnnotation, nullptr);
        node->identifierToken = loc(2);
        node->scope = sym(1).scope;
        node->isForDeclaration = true;
        sym(1).Node = node;
    } break;

#line 3688 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 483: Q_FALLTHROUGH(); 
#line 3690 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 484: {
        auto *node = new (pool) AST::PatternElement(sym(2).Pattern, nullptr);
        node->scope = sym(1).scope;
        node->isForDeclaration = true;
        sym(1).Node = node;
    } break;

#line 3700 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 485: {
        AST::ContinueStatement *node = new (pool) AST::ContinueStatement();
        node->continueToken = loc(1);
        node->semicolonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3710 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 486: {
        AST::ContinueStatement *node = new (pool) AST::ContinueStatement(stringRef(2));
        node->continueToken = loc(1);
        node->identifierToken = loc(2);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3721 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 487: {
        AST::BreakStatement *node = new (pool) AST::BreakStatement(QStringView());
        node->breakToken = loc(1);
        node->semicolonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3731 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 488: {
        AST::BreakStatement *node = new (pool) AST::BreakStatement(stringRef(2));
        node->breakToken = loc(1);
        node->identifierToken = loc(2);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3742 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 489: {
        if (!functionNestingLevel) {
            syntaxError(loc(1), "Return statement not allowed outside of Function declaration.");
            return false;
        }
        AST::ReturnStatement *node = new (pool) AST::ReturnStatement(sym(2).Expression);
        node->returnToken = loc(1);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3756 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 490: {
        AST::WithStatement *node = new (pool) AST::WithStatement(sym(3).Expression, sym(5).Statement);
        node->withToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3767 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 491: {
        AST::SwitchStatement *node = new (pool) AST::SwitchStatement(sym(3).Expression, sym(5).CaseBlock);
        node->switchToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3778 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 492: {
        AST::CaseBlock *node = new (pool) AST::CaseBlock(sym(2).CaseClauses);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3788 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 493: {
        AST::CaseBlock *node = new (pool) AST::CaseBlock(sym(2).CaseClauses, sym(3).DefaultClause, sym(4).CaseClauses);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(5);
        sym(1).Node = node;
    } break;

#line 3798 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 494: {
        sym(1).Node = new (pool) AST::CaseClauses(sym(1).CaseClause);
    } break;

#line 3805 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 495: {
        sym(1).Node = new (pool) AST::CaseClauses(sym(1).CaseClauses, sym(2).CaseClause);
    } break;

#line 3812 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 496: {
        sym(1).Node = nullptr;
    } break;

#line 3819 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 497: {
        sym(1).Node = sym(1).CaseClauses->finish();
    } break;

#line 3826 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 498: {
        AST::CaseClause *node = new (pool) AST::CaseClause(sym(2).Expression, sym(4).StatementList);
        node->caseToken = loc(1);
        node->colonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3836 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 499: {
        AST::DefaultClause *node = new (pool) AST::DefaultClause(sym(3).StatementList);
        node->defaultToken = loc(1);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3846 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 500: {
        AST::LabelledStatement *node = new (pool) AST::LabelledStatement(stringRef(1), sym(3).Statement);
        node->identifierToken = loc(1);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3858 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 502: {
        syntaxError(loc(3), "FunctionDeclarations are not allowed after a label.");
        return false;
    } break;

#line 3866 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 503: {
        AST::ThrowStatement *node = new (pool) AST::ThrowStatement(sym(2).Expression);
        node->throwToken = loc(1);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3876 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 504: {
        AST::TryStatement *node = new (pool) AST::TryStatement(sym(2).Statement, sym(3).Catch);
        node->tryToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3885 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 505: {
        AST::TryStatement *node = new (pool) AST::TryStatement(sym(2).Statement, sym(3).Finally);
        node->tryToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3894 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 506: {
        AST::TryStatement *node = new (pool) AST::TryStatement(sym(2).Statement, sym(3).Catch, sym(4).Finally);
        node->tryToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3903 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 507: {
        AST::Catch *node = new (pool) AST::Catch(sym(3).PatternElement, sym(5).Block);
        node->catchToken = loc(1);
        node->lparenToken = loc(2);
        node->identifierToken = loc(3);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3915 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 508: {
        AST::Finally *node = new (pool) AST::Finally(sym(2).Block);
        node->finallyToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3924 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 509: {
        AST::PatternElement *node = new (pool) AST::PatternElement(stringRef(1));
        node->identifierToken = loc(1);
        node->scope = AST::VariableScope::Let;
        sym(1).Node = node;
    } break;

#line 3934 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 510: {
        AST::PatternElement *node = new (pool) AST::PatternElement(sym(1).Pattern);
        node->scope = AST::VariableScope::Let;
        sym(1).Node = node;
    } break;

#line 3943 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 511: {
        AST::DebuggerStatement *node = new (pool) AST::DebuggerStatement();
        node->debuggerToken = loc(1);
        node->semicolonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3960 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 513: {
        if (!ensureNoFunctionTypeAnnotations(sym(6).TypeAnnotation, sym(4).FormalParameterList))
            return false;
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList,
                                                                             /*type annotation*/nullptr);
        node->functionToken = loc(1);
        node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(7);
        node->rbraceToken = loc(9);
        sym(1).Node = node;
    } break;

#line 3977 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 514: {
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList,
                                                                             sym(6).TypeAnnotation);
        node->functionToken = loc(1);
        node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(7);
        node->rbraceToken = loc(9);
        sym(1).Node = node;
    } break;

#line 3993 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 516: {
        if (!ensureNoFunctionTypeAnnotations(sym(5).TypeAnnotation, sym(3).FormalParameterList))
            return false;
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(QStringView(), sym(3).FormalParameterList, sym(7).StatementList,
                                                                             /*type annotation*/nullptr);
        node->functionToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->lbraceToken = loc(6);
        node->rbraceToken = loc(8);
        sym(1).Node = node;
    } break;

#line 4009 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 517: {
        if (!ensureNoFunctionTypeAnnotations(sym(6).TypeAnnotation, sym(4).FormalParameterList))
            return false;
        AST::FunctionExpression *node = new (pool) AST::FunctionExpression(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList,
                                                                           /*type annotation*/nullptr);
        node->functionToken = loc(1);
        if (! stringRef(2).isNull())
          node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(7);
        node->rbraceToken = loc(9);
        sym(1).Node = node;
    } break;

#line 4027 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 518: {
        if (!ensureNoFunctionTypeAnnotations(sym(5).TypeAnnotation, sym(3).FormalParameterList))
            return false;
        AST::FunctionExpression *node = new (pool) AST::FunctionExpression(QStringView(), sym(3).FormalParameterList, sym(7).StatementList,
                                                                           /*type annotation*/nullptr);
        node->functionToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->lbraceToken = loc(6);
        node->rbraceToken = loc(8);
        sym(1).Node = node;
    } break;

#line 4045 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 520: {
        sym(1).Node = nullptr;
    } break;

#line 4052 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 521: {
        AST::FormalParameterList *node = (new (pool) AST::FormalParameterList(nullptr, sym(1).PatternElement))->finish(pool);
        sym(1).Node = node;
    } break;

#line 4060 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
 case 522: 
#line 4062 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 523: {
        sym(1).Node = sym(1).FormalParameterList->finish(pool);
    } break;

#line 4069 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 524: {
        AST::FormalParameterList *node = (new (pool) AST::FormalParameterList(sym(1).FormalParameterList, sym(3).PatternElement))->finish(pool);
        sym(1).Node = node;
    } break;

#line 4077 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 525: {
        AST::FormalParameterList *node = new (pool) AST::FormalParameterList(nullptr, sym(1).PatternElement);
        sym(1).Node = node;
    } break;

#line 4086 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 526: {
        AST::FormalParameterList *node = new (pool) AST::FormalParameterList(sym(1).FormalParameterList, sym(3).PatternElement);
        sym(1).Node = node;
    } break;

#line 4096 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 528: {
        ++functionNestingLevel;
    } break;

#line 4103 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 529: {
        --functionNestingLevel;
    } break;

#line 4113 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 531: Q_FALLTHROUGH(); 
#line 4115 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 532: {
        AST::ReturnStatement *ret = new (pool) AST::ReturnStatement(sym(4).Expression);
        ret->returnToken = sym(4).Node->firstSourceLocation().startZeroLengthLocation();
        ret->semicolonToken = sym(4).Node->lastSourceLocation().endZeroLengthLocation(driver->code());
        AST::StatementList *statements = (new (pool) AST::StatementList(ret))->finish();
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(QStringView(), sym(1).FormalParameterList, statements);
        f->isArrowFunction = true;
        f->functionToken = sym(1).Node ? sym(1).Node->firstSourceLocation().startZeroLengthLocation() : loc(1).startZeroLengthLocation();
        f->lbraceToken = sym(4).Node->firstSourceLocation().startZeroLengthLocation();
        f->rbraceToken = sym(4).Node->lastSourceLocation().endZeroLengthLocation(driver->code());
        sym(1).Node = f;
    } break;

#line 4131 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 533: Q_FALLTHROUGH(); 
#line 4133 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 534: {
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(QStringView(), sym(1).FormalParameterList, sym(6).StatementList);
        f->isArrowFunction = true;
        f->functionToken = sym(1).Node ? sym(1).Node->firstSourceLocation().startZeroLengthLocation() : loc(1).startZeroLengthLocation();
        f->lbraceToken = loc(6);
        f->rbraceToken = loc(7);
        sym(1).Node = f;
    } break;

#line 4145 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 535: {
        AST::PatternElement *e = new (pool) AST::PatternElement(stringRef(1), /*type annotation*/nullptr, nullptr, AST::PatternElement::Binding);
        e->identifierToken = loc(1);
        sym(1).FormalParameterList = (new (pool) AST::FormalParameterList(nullptr, e))->finish(pool);
    } break;

#line 4156 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 536: {
        if (coverExpressionType != CE_FormalParameterList) {
            AST::NestedExpression *ne = static_cast<AST::NestedExpression *>(sym(1).Node);
            AST::FormalParameterList *list = ne->expression->reparseAsFormalParameterList(pool);
            if (!list) {
                syntaxError(loc(1), "Invalid Arrow parameter list.");
                return false;
            }
            sym(1).Node = list->finish(pool);
        }
    } break;

#line 4174 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 537: {
        if (lookaheadToken(lexer) == T_LBRACE)
            pushToken(T_FORCE_BLOCK);
    } break;

#line 4182 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 538: {
        if (!ensureNoFunctionTypeAnnotations(sym(5).TypeAnnotation, sym(3).FormalParameterList))
            return false;
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(stringRef(1), sym(3).FormalParameterList, sym(7).StatementList);
        f->functionToken = sym(1).PropertyName->firstSourceLocation();
        f->lparenToken = loc(2);
        f->rparenToken = loc(4);
        f->lbraceToken = loc(6);
        f->rbraceToken = loc(8);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(1).PropertyName, f, AST::PatternProperty::Method);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 4199 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 539: {
        if (!ensureNoFunctionTypeAnnotations(sym(6).TypeAnnotation, sym(4).FormalParameterList))
            return false;
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList);
        f->functionToken = sym(2).PropertyName->firstSourceLocation();
        f->lparenToken = loc(3);
        f->rparenToken = loc(5);
        f->lbraceToken = loc(7);
        f->rbraceToken = loc(9);
        f->isGenerator = true;
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(2).PropertyName, f, AST::PatternProperty::Method);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 4218 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 540: {
        if (!ensureNoFunctionTypeAnnotations(sym(5).TypeAnnotation, /*formals*/nullptr))
            return false;
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(stringRef(2), nullptr, sym(7).StatementList);
        f->functionToken = sym(2).PropertyName->firstSourceLocation();
        f->lparenToken = loc(3);
        f->rparenToken = loc(4);
        f->lbraceToken = loc(6);
        f->rbraceToken = loc(8);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(2).PropertyName, f, AST::PatternProperty::Getter);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 4235 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 541: {
        if (!ensureNoFunctionTypeAnnotations(sym(6).TypeAnnotation, sym(4).FormalParameterList))
            return false;
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList);
        f->functionToken = sym(2).PropertyName->firstSourceLocation();
        f->lparenToken = loc(3);
        f->rparenToken = loc(5);
        f->lbraceToken = loc(7);
        f->rbraceToken = loc(9);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(2).PropertyName, f, AST::PatternProperty::Setter);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 4253 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 542: {
        AST::FormalParameterList *node = (new (pool) AST::FormalParameterList(nullptr, sym(1).PatternElement))->finish(pool);
        sym(1).Node = node;
    } break;

#line 4261 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 543: {
        lexer->enterGeneratorBody();
    } break;

#line 4268 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 544: {
        --functionNestingLevel;
        lexer->leaveGeneratorBody();
    } break;

#line 4278 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 546: {
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(stringRef(2), sym(4).FormalParameterList, sym(7).StatementList);
        node->functionToken = loc(1);
        node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(6);
        node->rbraceToken = loc(8);
        node->isGenerator = true;
        sym(1).Node = node;
    } break;

#line 4294 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 548: {
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(QStringView(), sym(3).FormalParameterList, sym(6).StatementList);
        node->functionToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->lbraceToken = loc(5);
        node->rbraceToken = loc(7);
        node->isGenerator = true;
        sym(1).Node = node;
    } break;

#line 4308 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 549: {
        AST::FunctionExpression *node = new (pool) AST::FunctionExpression(stringRef(2), sym(4).FormalParameterList, sym(7).StatementList);
        node->functionToken = loc(1);
        if (!stringRef(2).isNull())
          node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(6);
        node->rbraceToken = loc(8);
        node->isGenerator = true;
        sym(1).Node = node;
    } break;

#line 4324 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 550: {
        AST::FunctionExpression *node = new (pool) AST::FunctionExpression(QStringView(), sym(3).FormalParameterList, sym(6).StatementList);
        node->functionToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->lbraceToken = loc(5);
        node->rbraceToken = loc(7);
        node->isGenerator = true;
        sym(1).Node = node;
    } break;

#line 4340 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 552: Q_FALLTHROUGH(); 
#line 4342 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 553: {
        AST::YieldExpression *node = new (pool) AST::YieldExpression();
        node->yieldToken = loc(1);
        sym(1).Node = node;
    } break;

#line 4351 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 554: Q_FALLTHROUGH(); 
#line 4353 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 555: {
        AST::YieldExpression *node = new (pool) AST::YieldExpression(sym(3).Expression);
        node->yieldToken = loc(1);
        node->isYieldStar = true;
        sym(1).Node = node;
    } break;

#line 4363 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 556: Q_FALLTHROUGH(); 
#line 4365 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 557: {
        AST::YieldExpression *node = new (pool) AST::YieldExpression(sym(2).Expression);
        node->yieldToken = loc(1);
        sym(1).Node = node;
    } break;

#line 4375 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 558: {
        AST::ClassDeclaration *node = new (pool) AST::ClassDeclaration(stringRef(2), sym(3).Expression, sym(5).ClassElementList);
        node->classToken = loc(1);
        node->identifierToken = loc(2);
        node->lbraceToken = loc(4);
        node->rbraceToken = loc(6);
        sym(1).Node = node;
    } break;

#line 4387 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 559: {
        AST::ClassExpression *node = new (pool) AST::ClassExpression(stringRef(2), sym(3).Expression, sym(5).ClassElementList);
        node->classToken = loc(1);
        node->identifierToken = loc(2);
        node->lbraceToken = loc(4);
        node->rbraceToken = loc(6);
        sym(1).Node = node;
    } break;

#line 4399 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 560: {
        AST::ClassDeclaration *node = new (pool) AST::ClassDeclaration(QStringView(), sym(2).Expression, sym(4).ClassElementList);
        node->classToken = loc(1);
        node->lbraceToken = loc(3);
        node->rbraceToken = loc(5);
        sym(1).Node = node;
    } break;

#line 4410 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 561: {
        AST::ClassExpression *node = new (pool) AST::ClassExpression(QStringView(), sym(2).Expression, sym(4).ClassElementList);
        node->classToken = loc(1);
        node->lbraceToken = loc(3);
        node->rbraceToken = loc(5);
        sym(1).Node = node;
    } break;

#line 4423 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 563: {
        lexer->setStaticIsKeyword(true);
    } break;

#line 4430 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
 case 564: 
#line 4432 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 565: {
        lexer->setStaticIsKeyword(false);
    } break;

#line 4439 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 566: {
        sym(1).Node = nullptr;
    } break;

#line 4446 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 567: {
        sym(1).Node = sym(2).Node;
    } break;

#line 4453 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 568: {
        sym(1).Node = nullptr;
    } break;

#line 4460 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 569: {
        if (sym(1).Node)
            sym(1).Node = sym(1).ClassElementList->finish();
    } break;

#line 4470 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 571: {
        if (sym(1).Node) {
            if (sym(2).Node)
                sym(1).ClassElementList = sym(1).ClassElementList->append(sym(2).ClassElementList);
        } else if (sym(2).Node) {
            sym(1).Node = sym(2).Node;
        }
    } break;

#line 4482 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 572: {
        AST::ClassElementList *node = new (pool) AST::ClassElementList(sym(1).PatternProperty, false);
        sym(1).Node = node;
    } break;

#line 4490 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 573: {
        lexer->setStaticIsKeyword(true);
        AST::ClassElementList *node = new (pool) AST::ClassElementList(sym(2).PatternProperty, true);
        sym(1).Node = node;
    } break;

#line 4499 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 574: {
        sym(1).Node = nullptr;
    } break;

#line 4508 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 575: {
        sym(1).Node = nullptr;
    } break;

#line 4517 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 577: {
        sym(1).Node = new (pool) AST::Program(sym(1).StatementList->finish());
    } break;

#line 4524 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
  case 578: {
        sym(1).Node = new (pool) AST::ESModule(sym(1).StatementList);
    } break;

#line 4530 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 579: {
        sym(1).StatementList = sym(1).StatementList->finish();
    } break;

#line 4537 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 580: {
        sym(1).StatementList = nullptr;
    } break;

#line 4547 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 583: {
        sym(1).StatementList = sym(1).StatementList->append(sym(2).StatementList);
    } break;

#line 4555 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
 case 584:  Q_FALLTHROUGH(); 
#line 4557 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 585: {
        sym(1).StatementList = new (pool) AST::StatementList(sym(1).Node);
    } break;

#line 4566 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 587: {
        auto decl = new (pool) AST::ImportDeclaration(sym(2).ImportClause, sym(3).FromClause);
        decl->importToken = loc(1);
        sym(1).Node = decl;
    } break;

#line 4574 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 588: {
        auto decl = new (pool) AST::ImportDeclaration(stringRef(2));
        decl->importToken = loc(1);
        decl->moduleSpecifierToken = loc(2);
        sym(1).Node = decl;
    } break;

#line 4584 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 589: {
        auto clause = new (pool) AST::ImportClause(stringRef(1));
        clause->importedDefaultBindingToken = loc(1);
        sym(1).ImportClause = clause;
    } break;

#line 4592 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 590: {
        sym(1).ImportClause = new (pool) AST::ImportClause(sym(1).NameSpaceImport);
    } break;

#line 4598 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 591: {
        sym(1).ImportClause = new (pool) AST::ImportClause(sym(1).NamedImports);
    } break;

#line 4604 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 592: {
        auto importClause = new (pool) AST::ImportClause(stringRef(1), sym(3).NameSpaceImport);
        importClause->importedDefaultBindingToken = loc(1);
        sym(1).ImportClause = importClause;
    } break;

#line 4612 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 593: {
        auto importClause = new (pool) AST::ImportClause(stringRef(1), sym(3).NamedImports);
        importClause->importedDefaultBindingToken = loc(1);
        sym(1).ImportClause = importClause;
    } break;

#line 4623 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 595: {
        auto import = new (pool) AST::NameSpaceImport(stringRef(3));
        import->starToken = loc(1);
        import->importedBindingToken = loc(3);
        sym(1).NameSpaceImport = import;
    } break;

#line 4633 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 596: {
        auto namedImports = new (pool) AST::NamedImports();
        namedImports->leftBraceToken = loc(1);
        namedImports->rightBraceToken = loc(2);
        sym(1).NamedImports = namedImports;
    } break;

#line 4642 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 597: {
        auto namedImports = new (pool) AST::NamedImports(sym(2).ImportsList->finish());
        namedImports->leftBraceToken = loc(1);
        namedImports->rightBraceToken = loc(3);
        sym(1).NamedImports = namedImports;
    } break;

#line 4651 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 598: {
        auto namedImports = new (pool) AST::NamedImports(sym(2).ImportsList->finish());
        namedImports->leftBraceToken = loc(1);
        namedImports->rightBraceToken = loc(4);
        sym(1).NamedImports = namedImports;
    } break;

#line 4661 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 599: {
        auto clause = new (pool) AST::FromClause(stringRef(2));
        clause->fromToken = loc(1);
        clause->moduleSpecifierToken = loc(2);
        sym(1).FromClause = clause;
    } break;

#line 4671 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 600: {
        auto importsList = new (pool) AST::ImportsList(sym(1).ImportSpecifier);
        importsList->importSpecifierToken = loc(1);
        sym(1).ImportsList = importsList;
    } break;

#line 4679 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 601: {
        auto importsList = new (pool) AST::ImportsList(sym(1).ImportsList, sym(3).ImportSpecifier);
        importsList->importSpecifierToken = loc(3);
        sym(1).ImportsList = importsList;
    } break;

#line 4691 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 602: {
        auto importSpecifier = new (pool) AST::ImportSpecifier(stringRef(1));
        importSpecifier->importedBindingToken = loc(1);
        sym(1).ImportSpecifier = importSpecifier;
    } break;

#line 4699 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 603: {
    auto importSpecifier = new (pool) AST::ImportSpecifier(stringRef(1), stringRef(3));
    importSpecifier->identifierToken = loc(1);
    importSpecifier->importedBindingToken = loc(3);
    sym(1).ImportSpecifier = importSpecifier;
    } break;

#line 4716 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 606: {
        int token = lookaheadToken(lexer);
        if (token == T_FUNCTION || token == T_FUNCTION_STAR || token == T_CLASS)
            pushToken(T_FORCE_DECLARATION);
    } break;

#line 4725 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 607: {
        auto exportDeclaration = new (pool) AST::ExportDeclaration(sym(3).FromClause);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4733 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 608: {
        auto exportDeclaration = new (pool) AST::ExportDeclaration(sym(2).ExportClause, sym(3).FromClause);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4741 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 609: {
        auto exportDeclaration = new (pool) AST::ExportDeclaration(sym(2).ExportClause);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4749 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"
 case 610:  Q_FALLTHROUGH(); 
#line 4751 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 611: {
        auto exportDeclaration = new (pool) AST::ExportDeclaration(/*exportDefault=*/false, sym(2).Node);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4759 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 612: {
        if (auto *f = AST::cast<AST::FunctionDeclaration*>(sym(5).Node)) {
            if (f->name.isEmpty()) {
                f->name = stringRef(2);
                f->identifierToken = loc(2);
            }
        }
    } Q_FALLTHROUGH();

#line 4770 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 613: {
        // Emulate 15.2.3.11
        if (auto *cls = AST::cast<AST::ClassDeclaration*>(sym(5).Node)) {
            if (cls->name.isEmpty()) {
                cls->name = stringRef(2);
                cls->identifierToken = loc(2);
            }
        }

        auto exportDeclaration = new (pool) AST::ExportDeclaration(/*exportDefault=*/true, sym(5).Node);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4786 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 614: {
        // if lhs is an identifier expression and rhs is an anonymous function expression, we need to assign the name of lhs to the function
        if (auto *f = asAnonymousFunctionDefinition(sym(4).Node)) {
            f->name = stringRef(2);
        }
        if (auto *c = asAnonymousClassDefinition(sym(4).Expression)) {
            c->name = stringRef(2);
        }

        auto exportDeclaration = new (pool) AST::ExportDeclaration(/*exportDefault=*/true, sym(4).Node);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4803 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 615: {
        auto exportClause = new (pool) AST::ExportClause();
        exportClause->leftBraceToken = loc(1);
        exportClause->rightBraceToken = loc(2);
        sym(1).ExportClause = exportClause;
    } break;

#line 4812 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 616: {
        auto exportClause = new (pool) AST::ExportClause(sym(2).ExportsList->finish());
        exportClause->leftBraceToken = loc(1);
        exportClause->rightBraceToken = loc(3);
        sym(1).ExportClause = exportClause;
    } break;

#line 4821 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 617: {
        auto exportClause = new (pool) AST::ExportClause(sym(2).ExportsList->finish());
        exportClause->leftBraceToken = loc(1);
        exportClause->rightBraceToken = loc(4);
        sym(1).ExportClause = exportClause;
    } break;

#line 4831 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 618: {
        sym(1).ExportsList = new (pool) AST::ExportsList(sym(1).ExportSpecifier);
    } break;

#line 4837 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 619: {
        sym(1).ExportsList = new (pool) AST::ExportsList(sym(1).ExportsList, sym(3).ExportSpecifier);
    } break;

#line 4844 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 620: {
        auto exportSpecifier = new (pool) AST::ExportSpecifier(stringRef(1));
        exportSpecifier->identifierToken = loc(1);
        sym(1).ExportSpecifier = exportSpecifier;
    } break;

#line 4852 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    case 621: {
        auto exportSpecifier = new (pool) AST::ExportSpecifier(stringRef(1), stringRef(3));
        exportSpecifier->identifierToken = loc(1);
        exportSpecifier->exportedIdentifierToken = loc(3);
        sym(1).ExportSpecifier = exportSpecifier;
    } break;

#line 4863 "/build/qt6-declarative/src/qtdeclarative-everywhere-src-6.2.3/src/qml/parser/qqmljs.g"

    // ------------ end of switch statement
            } // switch
            action = nt_action(state_stack[tos], lhs[r] - TERMINAL_COUNT);
        } // if
    } while (action != 0);

#ifdef PARSER_DEBUG
    qDebug() << "Done or error.";
#endif

    if (first_token == last_token) {
        const int errorState = state_stack[tos];

        // automatic insertion of `;'
        if (yytoken != -1 && ((t_action(errorState, T_AUTOMATIC_SEMICOLON) && lexer->canInsertAutomaticSemicolon(yytoken))
                              || t_action(errorState, T_COMPATIBILITY_SEMICOLON))) {
#ifdef PARSER_DEBUG
            qDebug() << "Inserting automatic semicolon.";
#endif
            SavedToken &tk = token_buffer[0];
            tk.token = yytoken;
            tk.dval = yylval;
            tk.spell = yytokenspell;
            tk.raw = yytokenraw;
            tk.loc = yylloc;

            yylloc = yyprevlloc;
            yylloc.offset += yylloc.length;
            yylloc.startColumn += yylloc.length;
            yylloc.length = 0;

            //const QString msg = QCoreApplication::translate("QQmlParser", "Missing `;'");
            //diagnostic_messages.append(compileError(yyloc, msg, QtWarningMsg));

            first_token = &token_buffer[0];
            last_token = &token_buffer[1];

            yytoken = T_SEMICOLON;
            yylval = 0;

            action = errorState;

            goto _Lcheck_token;
        }

        hadErrors = true;

        token_buffer[0].token = yytoken;
        token_buffer[0].dval = yylval;
        token_buffer[0].spell = yytokenspell;
        token_buffer[0].raw = yytokenraw;
        token_buffer[0].loc = yylloc;

        token_buffer[1].token = yytoken       = lexer->lex();
        token_buffer[1].dval  = yylval        = lexer->tokenValue();
        token_buffer[1].spell = yytokenspell  = lexer->tokenSpell();
        token_buffer[1].raw   = yytokenraw    = lexer->rawString();
        token_buffer[1].loc   = yylloc        = location(lexer);

        if (t_action(errorState, yytoken)) {
#ifdef PARSER_DEBUG
            qDebug() << "Parse error, trying to recover.";
#endif
            QString msg;
            int token = token_buffer[0].token;
            if (token < 0 || token >= TERMINAL_COUNT)
                msg = QCoreApplication::translate("QQmlParser", "Syntax error");
            else
                msg = QCoreApplication::translate("QQmlParser", "Unexpected token `%1'").arg(QLatin1String(spell[token]));
            diagnostic_messages.append(compileError(token_buffer[0].loc, msg));

            action = errorState;
            goto _Lcheck_token;
        }

        static int tokens[] = {
            T_PLUS,
            T_EQ,

            T_COMMA,
            T_COLON,
            T_SEMICOLON,

            T_RPAREN, T_RBRACKET, T_RBRACE,

            T_NUMERIC_LITERAL,
            T_IDENTIFIER,

            T_LPAREN, T_LBRACKET, T_LBRACE,

            EOF_SYMBOL
        };

        for (int *tk = tokens; *tk != EOF_SYMBOL; ++tk) {
            int a = t_action(errorState, *tk);
            if (a > 0 && t_action(a, yytoken)) {
#ifdef PARSER_DEBUG
                qDebug() << "Parse error, trying to recover (2).";
#endif
                const QString msg = QCoreApplication::translate("QQmlParser", "Expected token `%1'").arg(QLatin1String(spell[*tk]));
                diagnostic_messages.append(compileError(token_buffer[0].loc, msg));

                pushToken(*tk);
                goto _Lcheck_token;
            }
        }

        for (int tk = 1; tk < TERMINAL_COUNT; ++tk) {
            if (tk == T_AUTOMATIC_SEMICOLON || tk == T_FEED_UI_PROGRAM    ||
                tk == T_FEED_JS_STATEMENT   || tk == T_FEED_JS_EXPRESSION)
               continue;

            int a = t_action(errorState, tk);
            if (a > 0 && t_action(a, yytoken)) {
                const QString msg = QCoreApplication::translate("QQmlParser", "Expected token `%1'").arg(QLatin1String(spell[tk]));
                diagnostic_messages.append(compileError(token_buffer[0].loc, msg));

                pushToken(tk);
                goto _Lcheck_token;
            }
        }

        const QString msg = QCoreApplication::translate("QQmlParser", "Syntax error");
        diagnostic_messages.append(compileError(token_buffer[0].loc, msg));
    }

    return false;
}

QT_END_NAMESPACE


