
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include <qapp_macro.h>

QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "networkmanager_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void NetworkManagerWrapper::pysideInitQtMetaTypes()
{
}

void NetworkManagerWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

NetworkManagerWrapper::NetworkManagerWrapper(QObject * parent) : NetworkManager(parent)
{
    resetPyMethodCache();
    // ... middle
}

void NetworkManagerWrapper::childEvent(QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void NetworkManagerWrapper::connectNotify(const QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

QNetworkReply * NetworkManagerWrapper::createRequest(QNetworkAccessManager::Operation op, const QNetworkRequest & request, QIODevice * outgoingData)
{
    if (m_PyMethodCache[2])
        return this->::NetworkManager::createRequest(op, request, outgoingData);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "createRequest";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::NetworkManager::createRequest(op, request, outgoingData);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_OPERATION_IDX])->converter, &op),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), &request),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), outgoingData)
    ));
    bool invalidateArg3 = PyTuple_GET_ITEM(pyArgs, 2)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREPLY_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "NetworkManager.createRequest", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QNetworkReply >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QNetworkReply *cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg3)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 2));
    return cppResult;
}

void NetworkManagerWrapper::customEvent(QEvent * event)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void NetworkManagerWrapper::disconnectNotify(const QMetaMethod & signal)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool NetworkManagerWrapper::event(QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "NetworkManager.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool NetworkManagerWrapper::eventFilter(QObject * watched, QEvent * event)
{
    if (m_PyMethodCache[6])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "NetworkManager.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void NetworkManagerWrapper::timerEvent(QTimerEvent * event)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *NetworkManagerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return NetworkManager::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int NetworkManagerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = NetworkManager::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *NetworkManagerWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< NetworkManagerWrapper *>(this));
        return NetworkManager::qt_metacast(_clname);
}

NetworkManagerWrapper::~NetworkManagerWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_NetworkManager_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const char *argNames[] = {"parent"};
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::NetworkManager >()))
        return -1;

    ::NetworkManagerWrapper *cptr{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:NetworkManager", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: NetworkManager::NetworkManager(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // NetworkManager(QObject*)
    } else if ((pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // NetworkManager(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_NetworkManager_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *keyName = nullptr;
            PyObject *value = nullptr;
            keyName = Py_BuildValue("s","parent");
            if (PyDict_Contains(kwds, keyName)) {
                value = PyDict_GetItem(kwds, keyName);
                if (value && pyArgs[0]) {
                    PyErr_SetString(PyExc_TypeError, "PyFalkon.NetworkManager(): got multiple values for keyword argument 'parent'.");
                    return -1;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_NetworkManager_Init_TypeError;
                }
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = Q_NULLPTR;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // NetworkManager(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::NetworkManagerWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::NetworkManagerWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::NetworkManager >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto Sbk_NetworkManager_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (kwds && !PySide::fillQtProperties(self, metaObject, kwds, argNames, 1))
        return -1;


    return 1;

    Sbk_NetworkManager_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.NetworkManager");
        return -1;
}

static PyObject *Sbk_NetworkManagerFunc_authentication(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<NetworkManagerWrapper *>(reinterpret_cast< ::NetworkManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_NETWORKMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 3) {
        PyErr_SetString(PyExc_TypeError, "PyFalkon.NetworkManager.authentication(): too many arguments");
        return {};
    } else if (numArgs < 2) {
        PyErr_SetString(PyExc_TypeError, "PyFalkon.NetworkManager.authentication(): not enough arguments");
        return {};
    }

    if (!PyArg_ParseTuple(args, "|OOO:authentication", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: NetworkManager::authentication(QUrl,QAuthenticator*,QWidget*)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // authentication(QUrl,QAuthenticator*,QWidget*)
        } else if ((pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[2])))) {
            overloadId = 0; // authentication(QUrl,QAuthenticator*,QWidget*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_NetworkManagerFunc_authentication_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *keyName = nullptr;
            PyObject *value = nullptr;
            keyName = Py_BuildValue("s","parent");
            if (PyDict_Contains(kwds, keyName)) {
                value = PyDict_GetItem(kwds, keyName);
                if (value && pyArgs[2]) {
                    PyErr_SetString(PyExc_TypeError, "PyFalkon.NetworkManager.authentication(): got multiple values for keyword argument 'parent'.");
                    return {};
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[2]))))
                        goto Sbk_NetworkManagerFunc_authentication_TypeError;
                }
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QAuthenticator *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QWidget *cppArg2 = Q_NULLPTR;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // authentication(QUrl,QAuthenticator*,QWidget*)
            cppSelf->authentication(*cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_NetworkManagerFunc_authentication_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.NetworkManager.authentication");
        return {};
}

static PyObject *Sbk_NetworkManagerFunc_certificateError(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<NetworkManagerWrapper *>(reinterpret_cast< ::NetworkManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_NETWORKMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "PyFalkon.NetworkManager.certificateError(): too many arguments");
        return {};
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "PyFalkon.NetworkManager.certificateError(): not enough arguments");
        return {};
    }

    if (!PyArg_ParseTuple(args, "|OO:certificateError", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: NetworkManager::certificateError(QWebEngineCertificateError,QWidget*)
    if ((pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // certificateError(QWebEngineCertificateError,QWidget*)
        } else if ((pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[1])))) {
            overloadId = 0; // certificateError(QWebEngineCertificateError,QWidget*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_NetworkManagerFunc_certificateError_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *keyName = nullptr;
            PyObject *value = nullptr;
            keyName = Py_BuildValue("s","parent");
            if (PyDict_Contains(kwds, keyName)) {
                value = PyDict_GetItem(kwds, keyName);
                if (value && pyArgs[1]) {
                    PyErr_SetString(PyExc_TypeError, "PyFalkon.NetworkManager.certificateError(): got multiple values for keyword argument 'parent'.");
                    return {};
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[1]))))
                        goto Sbk_NetworkManagerFunc_certificateError_TypeError;
                }
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWebEngineCertificateError *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QWidget *cppArg1 = Q_NULLPTR;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // certificateError(QWebEngineCertificateError,QWidget*)
            bool cppResult = cppSelf->certificateError(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_NetworkManagerFunc_certificateError_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.NetworkManager.certificateError");
        return {};
}

static PyObject *Sbk_NetworkManagerFunc_createRequest(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<NetworkManagerWrapper *>(reinterpret_cast< ::NetworkManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_NETWORKMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "createRequest", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QNetworkAccessManager::createRequest(QNetworkAccessManager::Operation,QNetworkRequest,QIODevice*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_OPERATION_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[2])))) {
        overloadId = 0; // createRequest(QNetworkAccessManager::Operation,QNetworkRequest,QIODevice*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_NetworkManagerFunc_createRequest_TypeError;

    // Call function/method
    {
        ::QNetworkAccessManager::Operation cppArg0{QNetworkAccessManager::UnknownOperation};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QNetworkRequest cppArg1_local;
        ::QNetworkRequest *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QIODevice *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // createRequest(QNetworkAccessManager::Operation,QNetworkRequest,QIODevice*)
            QNetworkReply * cppResult = static_cast<::NetworkManagerWrapper *>(cppSelf)->NetworkManagerWrapper::createRequest_protected(cppArg0, *cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREPLY_IDX]), cppResult);

            // Ownership transferences.
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_NetworkManagerFunc_createRequest_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.NetworkManager.createRequest");
        return {};
}

static PyObject *Sbk_NetworkManagerFunc_installUrlInterceptor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<NetworkManagerWrapper *>(reinterpret_cast< ::NetworkManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_NETWORKMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: NetworkManager::installUrlInterceptor(UrlInterceptor*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_URLINTERCEPTOR_IDX]), (pyArg)))) {
        overloadId = 0; // installUrlInterceptor(UrlInterceptor*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_NetworkManagerFunc_installUrlInterceptor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::UrlInterceptor *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // installUrlInterceptor(UrlInterceptor*)
            cppSelf->installUrlInterceptor(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_NetworkManagerFunc_installUrlInterceptor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.NetworkManager.installUrlInterceptor");
        return {};
}

static PyObject *Sbk_NetworkManagerFunc_loadSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<NetworkManagerWrapper *>(reinterpret_cast< ::NetworkManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_NETWORKMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // loadSettings()
            cppSelf->loadSettings();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_NetworkManagerFunc_proxyAuthentication(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<NetworkManagerWrapper *>(reinterpret_cast< ::NetworkManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_NETWORKMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 3) {
        PyErr_SetString(PyExc_TypeError, "PyFalkon.NetworkManager.proxyAuthentication(): too many arguments");
        return {};
    } else if (numArgs < 2) {
        PyErr_SetString(PyExc_TypeError, "PyFalkon.NetworkManager.proxyAuthentication(): not enough arguments");
        return {};
    }

    if (!PyArg_ParseTuple(args, "|OOO:proxyAuthentication", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: NetworkManager::proxyAuthentication(QString,QAuthenticator*,QWidget*)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // proxyAuthentication(QString,QAuthenticator*,QWidget*)
        } else if ((pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[2])))) {
            overloadId = 0; // proxyAuthentication(QString,QAuthenticator*,QWidget*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_NetworkManagerFunc_proxyAuthentication_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *keyName = nullptr;
            PyObject *value = nullptr;
            keyName = Py_BuildValue("s","parent");
            if (PyDict_Contains(kwds, keyName)) {
                value = PyDict_GetItem(kwds, keyName);
                if (value && pyArgs[2]) {
                    PyErr_SetString(PyExc_TypeError, "PyFalkon.NetworkManager.proxyAuthentication(): got multiple values for keyword argument 'parent'.");
                    return {};
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[2]))))
                        goto Sbk_NetworkManagerFunc_proxyAuthentication_TypeError;
                }
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QAuthenticator *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QWidget *cppArg2 = Q_NULLPTR;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // proxyAuthentication(QString,QAuthenticator*,QWidget*)
            cppSelf->proxyAuthentication(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_NetworkManagerFunc_proxyAuthentication_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.NetworkManager.proxyAuthentication");
        return {};
}

static PyObject *Sbk_NetworkManagerFunc_registerExtensionSchemeHandler(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<NetworkManagerWrapper *>(reinterpret_cast< ::NetworkManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_NETWORKMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "registerExtensionSchemeHandler", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: NetworkManager::registerExtensionSchemeHandler(QString,ExtensionSchemeHandler*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_EXTENSIONSCHEMEHANDLER_IDX]), (pyArgs[1])))) {
        overloadId = 0; // registerExtensionSchemeHandler(QString,ExtensionSchemeHandler*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_NetworkManagerFunc_registerExtensionSchemeHandler_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::ExtensionSchemeHandler *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // registerExtensionSchemeHandler(QString,ExtensionSchemeHandler*)
            cppSelf->registerExtensionSchemeHandler(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_NetworkManagerFunc_registerExtensionSchemeHandler_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.NetworkManager.registerExtensionSchemeHandler");
        return {};
}

static PyObject *Sbk_NetworkManagerFunc_registerSchemes(PyObject *self)
{

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // registerSchemes()
            ::NetworkManager::registerSchemes();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_NetworkManagerFunc_removeUrlInterceptor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<NetworkManagerWrapper *>(reinterpret_cast< ::NetworkManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_NETWORKMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: NetworkManager::removeUrlInterceptor(UrlInterceptor*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_URLINTERCEPTOR_IDX]), (pyArg)))) {
        overloadId = 0; // removeUrlInterceptor(UrlInterceptor*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_NetworkManagerFunc_removeUrlInterceptor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::UrlInterceptor *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeUrlInterceptor(UrlInterceptor*)
            cppSelf->removeUrlInterceptor(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_NetworkManagerFunc_removeUrlInterceptor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.NetworkManager.removeUrlInterceptor");
        return {};
}

static PyObject *Sbk_NetworkManagerFunc_shutdown(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<NetworkManagerWrapper *>(reinterpret_cast< ::NetworkManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_NETWORKMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shutdown()
            cppSelf->shutdown();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_NetworkManagerFunc_unregisterExtensionSchemeHandler(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<NetworkManagerWrapper *>(reinterpret_cast< ::NetworkManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_NETWORKMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: NetworkManager::unregisterExtensionSchemeHandler(ExtensionSchemeHandler*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_EXTENSIONSCHEMEHANDLER_IDX]), (pyArg)))) {
        overloadId = 0; // unregisterExtensionSchemeHandler(ExtensionSchemeHandler*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_NetworkManagerFunc_unregisterExtensionSchemeHandler_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::ExtensionSchemeHandler *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // unregisterExtensionSchemeHandler(ExtensionSchemeHandler*)
            cppSelf->unregisterExtensionSchemeHandler(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_NetworkManagerFunc_unregisterExtensionSchemeHandler_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.NetworkManager.unregisterExtensionSchemeHandler");
        return {};
}


static const char *Sbk_NetworkManager_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_NetworkManager_methods[] = {
    {"authentication", reinterpret_cast<PyCFunction>(Sbk_NetworkManagerFunc_authentication), METH_VARARGS|METH_KEYWORDS},
    {"certificateError", reinterpret_cast<PyCFunction>(Sbk_NetworkManagerFunc_certificateError), METH_VARARGS|METH_KEYWORDS},
    {"createRequest", reinterpret_cast<PyCFunction>(Sbk_NetworkManagerFunc_createRequest), METH_VARARGS},
    {"installUrlInterceptor", reinterpret_cast<PyCFunction>(Sbk_NetworkManagerFunc_installUrlInterceptor), METH_O},
    {"loadSettings", reinterpret_cast<PyCFunction>(Sbk_NetworkManagerFunc_loadSettings), METH_NOARGS},
    {"proxyAuthentication", reinterpret_cast<PyCFunction>(Sbk_NetworkManagerFunc_proxyAuthentication), METH_VARARGS|METH_KEYWORDS},
    {"registerExtensionSchemeHandler", reinterpret_cast<PyCFunction>(Sbk_NetworkManagerFunc_registerExtensionSchemeHandler), METH_VARARGS},
    {"registerSchemes", reinterpret_cast<PyCFunction>(Sbk_NetworkManagerFunc_registerSchemes), METH_NOARGS|METH_STATIC},
    {"removeUrlInterceptor", reinterpret_cast<PyCFunction>(Sbk_NetworkManagerFunc_removeUrlInterceptor), METH_O},
    {"shutdown", reinterpret_cast<PyCFunction>(Sbk_NetworkManagerFunc_shutdown), METH_NOARGS},
    {"unregisterExtensionSchemeHandler", reinterpret_cast<PyCFunction>(Sbk_NetworkManagerFunc_unregisterExtensionSchemeHandler), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_NetworkManager_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::NetworkManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_NETWORKMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<NetworkManagerWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_NetworkManager_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_NetworkManager_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_NetworkManager_Type = nullptr;
static SbkObjectType *Sbk_NetworkManager_TypeF(void)
{
    return _Sbk_NetworkManager_Type;
}

static PyType_Slot Sbk_NetworkManager_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_NetworkManager_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_NetworkManager_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_NetworkManager_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_NetworkManager_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_NetworkManager_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_NetworkManager_spec = {
    "1:PyFalkon.NetworkManager",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_NetworkManager_slots
};

} //extern "C"

static void *Sbk_NetworkManager_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::NetworkManager *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void NetworkManager_PythonToCpp_NetworkManager_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_NetworkManager_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_NetworkManager_PythonToCpp_NetworkManager_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_NetworkManager_TypeF())))
        return NetworkManager_PythonToCpp_NetworkManager_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *NetworkManager_PTR_CppToPython_NetworkManager(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::NetworkManager *>(const_cast<void *>(cppIn)), Sbk_NetworkManager_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *NetworkManager_SignatureStrings[] = {
    "PyFalkon.NetworkManager(self,parent:PySide2.QtCore.QObject=Q_NULLPTR)",
    "PyFalkon.NetworkManager.authentication(self,url:PySide2.QtCore.QUrl,auth:PySide2.QtNetwork.QAuthenticator,parent:PySide2.QtWidgets.QWidget=Q_NULLPTR)",
    "PyFalkon.NetworkManager.certificateError(self,error:PySide2.QtWebEngineWidgets.QWebEngineCertificateError,parent:PySide2.QtWidgets.QWidget=Q_NULLPTR)->bool",
    "PyFalkon.NetworkManager.createRequest(self,op:PySide2.QtNetwork.QNetworkAccessManager.Operation,request:PySide2.QtNetwork.QNetworkRequest,outgoingData:PySide2.QtCore.QIODevice)->PySide2.QtNetwork.QNetworkReply",
    "PyFalkon.NetworkManager.installUrlInterceptor(self,interceptor:PyFalkon.UrlInterceptor)",
    "PyFalkon.NetworkManager.loadSettings(self)",
    "PyFalkon.NetworkManager.proxyAuthentication(self,proxyHost:QString,auth:PySide2.QtNetwork.QAuthenticator,parent:PySide2.QtWidgets.QWidget=Q_NULLPTR)",
    "PyFalkon.NetworkManager.registerExtensionSchemeHandler(self,name:QString,handler:PyFalkon.ExtensionSchemeHandler)",
    "PyFalkon.NetworkManager.registerSchemes()",
    "PyFalkon.NetworkManager.removeUrlInterceptor(self,interceptor:PyFalkon.UrlInterceptor)",
    "PyFalkon.NetworkManager.shutdown(self)",
    "PyFalkon.NetworkManager.unregisterExtensionSchemeHandler(self,handler:PyFalkon.ExtensionSchemeHandler)",
    nullptr}; // Sentinel

void init_NetworkManager(PyObject *module)
{
    _Sbk_NetworkManager_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "NetworkManager",
        "NetworkManager*",
        &Sbk_NetworkManager_spec,
        &Shiboken::callCppDestructor< ::NetworkManager >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_NetworkManager_Type);
    InitSignatureStrings(pyType, NetworkManager_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_NetworkManager_Type), Sbk_NetworkManager_PropertyStrings);
    SbkPyFalkonTypes[SBK_NETWORKMANAGER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_NetworkManager_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_NetworkManager_TypeF(),
        NetworkManager_PythonToCpp_NetworkManager_PTR,
        is_NetworkManager_PythonToCpp_NetworkManager_PTR_Convertible,
        NetworkManager_PTR_CppToPython_NetworkManager);

    Shiboken::Conversions::registerConverterName(converter, "NetworkManager");
    Shiboken::Conversions::registerConverterName(converter, "NetworkManager*");
    Shiboken::Conversions::registerConverterName(converter, "NetworkManager&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::NetworkManager).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::NetworkManagerWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_NetworkManager_TypeF(), &Sbk_NetworkManager_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_NetworkManager_TypeF(), &::NetworkManager::staticMetaObject);

    NetworkManagerWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_NetworkManager_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_NetworkManager_TypeF(), &::NetworkManager::staticMetaObject, sizeof(NetworkManagerWrapper));
}
