
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include <qapp_macro.h>

QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "webhittestresult_wrapper.h"

// inner classes

// Extra includes
#include <QMap>
#include <qpoint.h>
#include <qrect.h>
#include <qurl.h>
#include <qwebenginecontextmenudata.h>
#include <webpage.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_WebHitTestResult_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::WebHitTestResult >()))
        return -1;

    ::WebHitTestResult *cptr{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "WebHitTestResult", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: WebHitTestResult::WebHitTestResult(WebHitTestResult)
    // 1: WebHitTestResult::WebHitTestResult(const WebPage*,QPoint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_WEBPAGE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[1])))) {
        overloadId = 1; // WebHitTestResult(const WebPage*,QPoint)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // WebHitTestResult(WebHitTestResult)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_WebHitTestResult_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // WebHitTestResult(const WebHitTestResult & WebHitTestResult)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::WebHitTestResult cppArg0_local = ::WebHitTestResult(static_cast<::WebPage*>(nullptr), ::QPoint());
            ::WebHitTestResult *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // WebHitTestResult(WebHitTestResult)
                cptr = new ::WebHitTestResult(*cppArg0);
            }
            break;
        }
        case 1: // WebHitTestResult(const WebPage * page, const QPoint & pos)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::WebPage *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QPoint cppArg1_local;
            ::QPoint *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // WebHitTestResult(const WebPage*,QPoint)
                cptr = new ::WebHitTestResult(cppArg0, *cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::WebHitTestResult >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto Sbk_WebHitTestResult_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_WebHitTestResult_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.WebHitTestResult");
        return -1;
}

static PyObject *Sbk_WebHitTestResultFunc_alternateText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // alternateText()const
            QString cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->alternateText();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_WebHitTestResultFunc_baseUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // baseUrl()const
            QUrl cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->baseUrl();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_WebHitTestResultFunc_boundingRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // boundingRect()const
            QRect cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->boundingRect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_WebHitTestResultFunc_imageUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // imageUrl()const
            QUrl cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->imageUrl();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_WebHitTestResultFunc_isContentEditable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isContentEditable()const
            bool cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->isContentEditable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_WebHitTestResultFunc_isContentSelected(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isContentSelected()const
            bool cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->isContentSelected();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_WebHitTestResultFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_WebHitTestResultFunc_linkTitle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // linkTitle()const
            QString cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->linkTitle();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_WebHitTestResultFunc_linkUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // linkUrl()const
            QUrl cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->linkUrl();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_WebHitTestResultFunc_mediaMuted(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mediaMuted()const
            bool cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->mediaMuted();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_WebHitTestResultFunc_mediaPaused(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mediaPaused()const
            bool cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->mediaPaused();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_WebHitTestResultFunc_mediaUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mediaUrl()const
            QUrl cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->mediaUrl();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_WebHitTestResultFunc_pos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pos()const
            QPoint cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->pos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_WebHitTestResultFunc_tagName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // tagName()const
            QString cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->tagName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_WebHitTestResultFunc_updateWithContextMenuData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: WebHitTestResult::updateWithContextMenuData(QWebEngineContextMenuData)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_IDX]), (pyArg)))) {
        overloadId = 0; // updateWithContextMenuData(QWebEngineContextMenuData)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_WebHitTestResultFunc_updateWithContextMenuData_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWebEngineContextMenuData cppArg0_local;
        ::QWebEngineContextMenuData *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // updateWithContextMenuData(QWebEngineContextMenuData)
            cppSelf->updateWithContextMenuData(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_WebHitTestResultFunc_updateWithContextMenuData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.WebHitTestResult.updateWithContextMenuData");
        return {};
}

static PyObject *Sbk_WebHitTestResultFunc_viewportPos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // viewportPos()const
            QPointF cppResult = const_cast<const ::WebHitTestResult *>(cppSelf)->viewportPos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_WebHitTestResult___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_WebHitTestResult_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_WebHitTestResult_methods[] = {
    {"alternateText", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_alternateText), METH_NOARGS},
    {"baseUrl", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_baseUrl), METH_NOARGS},
    {"boundingRect", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_boundingRect), METH_NOARGS},
    {"imageUrl", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_imageUrl), METH_NOARGS},
    {"isContentEditable", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_isContentEditable), METH_NOARGS},
    {"isContentSelected", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_isContentSelected), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_isNull), METH_NOARGS},
    {"linkTitle", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_linkTitle), METH_NOARGS},
    {"linkUrl", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_linkUrl), METH_NOARGS},
    {"mediaMuted", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_mediaMuted), METH_NOARGS},
    {"mediaPaused", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_mediaPaused), METH_NOARGS},
    {"mediaUrl", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_mediaUrl), METH_NOARGS},
    {"pos", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_pos), METH_NOARGS},
    {"tagName", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_tagName), METH_NOARGS},
    {"updateWithContextMenuData", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_updateWithContextMenuData), METH_O},
    {"viewportPos", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResultFunc_viewportPos), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_WebHitTestResult___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_WebHitTestResult___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

} // extern "C"

static int Sbk_WebHitTestResult_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_WebHitTestResult_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_WebHitTestResult_Type = nullptr;
static SbkObjectType *Sbk_WebHitTestResult_TypeF(void)
{
    return _Sbk_WebHitTestResult_Type;
}

static PyType_Slot Sbk_WebHitTestResult_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_WebHitTestResult_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_WebHitTestResult_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_WebHitTestResult_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_WebHitTestResult_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_WebHitTestResult___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_WebHitTestResult___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_WebHitTestResult_spec = {
    "1:PyFalkon.WebHitTestResult",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_WebHitTestResult_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void WebHitTestResult_PythonToCpp_WebHitTestResult_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_WebHitTestResult_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_WebHitTestResult_PythonToCpp_WebHitTestResult_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_WebHitTestResult_TypeF())))
        return WebHitTestResult_PythonToCpp_WebHitTestResult_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *WebHitTestResult_PTR_CppToPython_WebHitTestResult(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::WebHitTestResult *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_WebHitTestResult_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *WebHitTestResult_COPY_CppToPython_WebHitTestResult(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_WebHitTestResult_TypeF(), new ::WebHitTestResult(*reinterpret_cast<const ::WebHitTestResult *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void WebHitTestResult_PythonToCpp_WebHitTestResult_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::WebHitTestResult *>(cppOut) = *reinterpret_cast< ::WebHitTestResult *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_WebHitTestResult_PythonToCpp_WebHitTestResult_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_WebHitTestResult_TypeF())))
        return WebHitTestResult_PythonToCpp_WebHitTestResult_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *WebHitTestResult_SignatureStrings[] = {
    "1:PyFalkon.WebHitTestResult(self,WebHitTestResult:PyFalkon.WebHitTestResult)",
    "0:PyFalkon.WebHitTestResult(self,page:PyFalkon.WebPage,pos:PySide2.QtCore.QPoint)",
    "PyFalkon.WebHitTestResult.alternateText(self)->QString",
    "PyFalkon.WebHitTestResult.baseUrl(self)->PySide2.QtCore.QUrl",
    "PyFalkon.WebHitTestResult.boundingRect(self)->PySide2.QtCore.QRect",
    "PyFalkon.WebHitTestResult.imageUrl(self)->PySide2.QtCore.QUrl",
    "PyFalkon.WebHitTestResult.isContentEditable(self)->bool",
    "PyFalkon.WebHitTestResult.isContentSelected(self)->bool",
    "PyFalkon.WebHitTestResult.isNull(self)->bool",
    "PyFalkon.WebHitTestResult.linkTitle(self)->QString",
    "PyFalkon.WebHitTestResult.linkUrl(self)->PySide2.QtCore.QUrl",
    "PyFalkon.WebHitTestResult.mediaMuted(self)->bool",
    "PyFalkon.WebHitTestResult.mediaPaused(self)->bool",
    "PyFalkon.WebHitTestResult.mediaUrl(self)->PySide2.QtCore.QUrl",
    "PyFalkon.WebHitTestResult.pos(self)->PySide2.QtCore.QPoint",
    "PyFalkon.WebHitTestResult.tagName(self)->QString",
    "PyFalkon.WebHitTestResult.updateWithContextMenuData(self,data:PySide2.QtWebEngineWidgets.QWebEngineContextMenuData)",
    "PyFalkon.WebHitTestResult.viewportPos(self)->PySide2.QtCore.QPointF",
    "PyFalkon.WebHitTestResult.__copy__()",
    nullptr}; // Sentinel

void init_WebHitTestResult(PyObject *module)
{
    _Sbk_WebHitTestResult_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "WebHitTestResult",
        "WebHitTestResult",
        &Sbk_WebHitTestResult_spec,
        &Shiboken::callCppDestructor< ::WebHitTestResult >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_WebHitTestResult_Type);
    InitSignatureStrings(pyType, WebHitTestResult_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_WebHitTestResult_Type), Sbk_WebHitTestResult_PropertyStrings);
    SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_WebHitTestResult_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_WebHitTestResult_TypeF(),
        WebHitTestResult_PythonToCpp_WebHitTestResult_PTR,
        is_WebHitTestResult_PythonToCpp_WebHitTestResult_PTR_Convertible,
        WebHitTestResult_PTR_CppToPython_WebHitTestResult,
        WebHitTestResult_COPY_CppToPython_WebHitTestResult);

    Shiboken::Conversions::registerConverterName(converter, "WebHitTestResult");
    Shiboken::Conversions::registerConverterName(converter, "WebHitTestResult*");
    Shiboken::Conversions::registerConverterName(converter, "WebHitTestResult&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::WebHitTestResult).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        WebHitTestResult_PythonToCpp_WebHitTestResult_COPY,
        is_WebHitTestResult_PythonToCpp_WebHitTestResult_COPY_Convertible);


}
