// This file is generated by kconfig_compiler_kf5 from okular_core.kcfg.
// All changes you do to this file will be lost.

#include "settings_core.h"

#include <qglobal.h>
#include <QFile>

#include <QDebug>

using namespace Okular;

namespace Okular {

class SettingsCorePrivate
{
  public:

    // Core Performance
    int memoryLevel;
    bool enableThreading;
    int textAntialias;
    int graphicsAntialias;
    int textHinting;

    // Document
    QColor paperColor;
    bool changeColors;
    int renderMode;

    // Core General
    bool obeyDRM;
    bool chooseGenerators;
    int externalEditor;
    QString externalEditorCommand;

    // Core Presentation
    bool slidesAdvance;
    uint slidesAdvanceTime;
    bool slidesLoop;
    int slidesTapNavigation;

    // items
    KConfigSkeleton::ItemEnum *itemMemoryLevel;
    KConfigSkeleton::ItemBool *itemEnableThreading;
    KConfigSkeleton::ItemEnum *itemTextAntialias;
    KConfigSkeleton::ItemEnum *itemGraphicsAntialias;
    KConfigSkeleton::ItemEnum *itemTextHinting;
    KConfigCompilerSignallingItem *itemPaperColor;
    KConfigCompilerSignallingItem *itemChangeColors;
    KConfigCompilerSignallingItem *itemRenderMode;
    KConfigSkeleton::ItemBool *itemObeyDRM;
    KConfigSkeleton::ItemBool *itemChooseGenerators;
    KConfigSkeleton::ItemEnum *itemExternalEditor;
    KConfigSkeleton::ItemString *itemExternalEditorCommand;
    KConfigSkeleton::ItemBool *itemSlidesAdvance;
    KConfigSkeleton::ItemUInt *itemSlidesAdvanceTime;
    KConfigSkeleton::ItemBool *itemSlidesLoop;
    KConfigSkeleton::ItemEnum *itemSlidesTapNavigation;
    uint settingsChanged;
};


}
namespace Okular {

class SettingsCoreHelper
{
  public:
    SettingsCoreHelper() : q(nullptr) {}
    ~SettingsCoreHelper() { delete q; }
    SettingsCoreHelper(const SettingsCoreHelper&) = delete;
    SettingsCoreHelper& operator=(const SettingsCoreHelper&) = delete;
    SettingsCore *q;
};

}
Q_GLOBAL_STATIC(SettingsCoreHelper, s_globalSettingsCore)
SettingsCore *SettingsCore::self()
{
  if (!s_globalSettingsCore()->q)
     qFatal("you need to call SettingsCore::instance before using");
  return s_globalSettingsCore()->q;
}

void SettingsCore::instance(const QString& cfgfilename)
{
  if (s_globalSettingsCore()->q) {
     qDebug() << "SettingsCore::instance called after the first use - ignoring";
     return;
  }
  new SettingsCore(KSharedConfig::openConfig(cfgfilename));
  s_globalSettingsCore()->q->read();
}

void SettingsCore::instance(KSharedConfig::Ptr config)
{
  if (s_globalSettingsCore()->q) {
     qDebug() << "SettingsCore::instance called after the first use - ignoring";
     return;
  }
  new SettingsCore(std::move(config));
  s_globalSettingsCore()->q->read();
}

SettingsCore::SettingsCore( KSharedConfig::Ptr config )
  : KConfigSkeleton( std::move( config ) )
{
  d = new SettingsCorePrivate;
  d->settingsChanged = 0;
  Q_ASSERT(!s_globalSettingsCore()->q);
  s_globalSettingsCore()->q = this;
  KConfigCompilerSignallingItem::NotifyFunction notifyFunction = static_cast<KConfigCompilerSignallingItem::NotifyFunction>(&SettingsCore::itemChanged);

  setCurrentGroup( QStringLiteral( "Core Performance" ) );

  QList<KConfigSkeleton::ItemEnum::Choice> valuesMemoryLevel;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Low");
    valuesMemoryLevel.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Normal");
    valuesMemoryLevel.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Aggressive");
    valuesMemoryLevel.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Greedy");
    valuesMemoryLevel.append( choice );
  }
  d->itemMemoryLevel = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "MemoryLevel" ), d->memoryLevel, valuesMemoryLevel, EnumMemoryLevel::Normal );
  addItem( d->itemMemoryLevel, QStringLiteral( "MemoryLevel" ) );
  d->itemEnableThreading = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "EnableThreading" ), d->enableThreading, true );
  addItem( d->itemEnableThreading, QStringLiteral( "EnableThreading" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesTextAntialias;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Disabled");
    valuesTextAntialias.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Enabled");
    valuesTextAntialias.append( choice );
  }
  d->itemTextAntialias = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "TextAntialias" ), d->textAntialias, valuesTextAntialias, EnumTextAntialias::Enabled );
  addItem( d->itemTextAntialias, QStringLiteral( "TextAntialias" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesGraphicsAntialias;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Disabled");
    valuesGraphicsAntialias.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Enabled");
    valuesGraphicsAntialias.append( choice );
  }
  d->itemGraphicsAntialias = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "GraphicsAntialias" ), d->graphicsAntialias, valuesGraphicsAntialias, EnumGraphicsAntialias::Enabled );
  addItem( d->itemGraphicsAntialias, QStringLiteral( "GraphicsAntialias" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesTextHinting;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Disabled");
    valuesTextHinting.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Enabled");
    valuesTextHinting.append( choice );
  }
  d->itemTextHinting = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "TextHinting" ), d->textHinting, valuesTextHinting, EnumTextHinting::Disabled );
  addItem( d->itemTextHinting, QStringLiteral( "TextHinting" ) );

  setCurrentGroup( QStringLiteral( "Document" ) );

  KConfigSkeleton::ItemColor  *innerItemPaperColor;
  innerItemPaperColor = new KConfigSkeleton::ItemColor( currentGroup(), QStringLiteral( "PaperColor" ), d->paperColor, Qt::white );
  d->itemPaperColor = new KConfigCompilerSignallingItem(innerItemPaperColor, this, notifyFunction, signalColorModesChanged);
  addItem( d->itemPaperColor, QStringLiteral( "PaperColor" ) );
  KConfigSkeleton::ItemBool  *innerItemChangeColors;
  innerItemChangeColors = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ChangeColors" ), d->changeColors, false );
  d->itemChangeColors = new KConfigCompilerSignallingItem(innerItemChangeColors, this, notifyFunction, signalColorModesChanged);
  addItem( d->itemChangeColors, QStringLiteral( "ChangeColors" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesRenderMode;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Inverted");
    valuesRenderMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Paper");
    valuesRenderMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Recolor");
    valuesRenderMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("BlackWhite");
    valuesRenderMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("InvertLightness");
    valuesRenderMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("InvertLuma");
    valuesRenderMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("InvertLumaSymmetric");
    valuesRenderMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("HueShiftPositive");
    valuesRenderMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("HueShiftNegative");
    valuesRenderMode.append( choice );
  }
  KConfigSkeleton::ItemEnum  *innerItemRenderMode;
  innerItemRenderMode = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "RenderMode" ), d->renderMode, valuesRenderMode, EnumRenderMode::Inverted );
  d->itemRenderMode = new KConfigCompilerSignallingItem(innerItemRenderMode, this, notifyFunction, signalColorModesChanged);
  addItem( d->itemRenderMode, QStringLiteral( "RenderMode" ) );

  setCurrentGroup( QStringLiteral( "Core General" ) );

  d->itemObeyDRM = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ObeyDRM" ), d->obeyDRM, true );
  addItem( d->itemObeyDRM, QStringLiteral( "ObeyDRM" ) );
  d->itemChooseGenerators = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ChooseGenerators" ), d->chooseGenerators, false );
  addItem( d->itemChooseGenerators, QStringLiteral( "ChooseGenerators" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesExternalEditor;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Custom");
    valuesExternalEditor.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Kate");
    valuesExternalEditor.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Kile");
    valuesExternalEditor.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Scite");
    valuesExternalEditor.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Emacsclient");
    valuesExternalEditor.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Lyxclient");
    valuesExternalEditor.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Texstudio");
    valuesExternalEditor.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Texifyidea");
    valuesExternalEditor.append( choice );
  }
  d->itemExternalEditor = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "ExternalEditor" ), d->externalEditor, valuesExternalEditor, EnumExternalEditor::Kate );
  addItem( d->itemExternalEditor, QStringLiteral( "ExternalEditor" ) );
  d->itemExternalEditorCommand = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "ExternalEditorCommand" ), d->externalEditorCommand, QStringLiteral( "kate --line %l --column %c" ) );
  addItem( d->itemExternalEditorCommand, QStringLiteral( "ExternalEditorCommand" ) );

  setCurrentGroup( QStringLiteral( "Core Presentation" ) );

  d->itemSlidesAdvance = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "SlidesAdvance" ), d->slidesAdvance, false );
  addItem( d->itemSlidesAdvance, QStringLiteral( "SlidesAdvance" ) );
  d->itemSlidesAdvanceTime = new KConfigSkeleton::ItemUInt( currentGroup(), QStringLiteral( "SlidesAdvanceTime" ), d->slidesAdvanceTime, 5 );
  d->itemSlidesAdvanceTime->setMinValue(1);
  d->itemSlidesAdvanceTime->setMaxValue(3600);
  addItem( d->itemSlidesAdvanceTime, QStringLiteral( "SlidesAdvanceTime" ) );
  d->itemSlidesLoop = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "SlidesLoop" ), d->slidesLoop, false );
  addItem( d->itemSlidesLoop, QStringLiteral( "SlidesLoop" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesSlidesTapNavigation;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("ForwardBackward");
    valuesSlidesTapNavigation.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Forward");
    valuesSlidesTapNavigation.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Disabled");
    valuesSlidesTapNavigation.append( choice );
  }
  d->itemSlidesTapNavigation = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "SlidesTapNavigation" ), d->slidesTapNavigation, valuesSlidesTapNavigation, EnumSlidesTapNavigation::Forward );
  addItem( d->itemSlidesTapNavigation, QStringLiteral( "SlidesTapNavigation" ) );
}

void SettingsCore::setMemoryLevel( int v )
{
    if (!self()->SettingsCore::isMemoryLevelImmutable())
      self()->d->memoryLevel = v;
}

int SettingsCore::memoryLevel()
{
  return self()->d->memoryLevel;
}

bool  SettingsCore::isMemoryLevelImmutable()
{
    return self()->isImmutable( QStringLiteral( "MemoryLevel" ) );
}


void SettingsCore::setEnableThreading( bool v )
{
    if (!self()->SettingsCore::isEnableThreadingImmutable())
      self()->d->enableThreading = v;
}

bool SettingsCore::enableThreading()
{
  return self()->d->enableThreading;
}

bool  SettingsCore::isEnableThreadingImmutable()
{
    return self()->isImmutable( QStringLiteral( "EnableThreading" ) );
}


void SettingsCore::setTextAntialias( int v )
{
    if (!self()->SettingsCore::isTextAntialiasImmutable())
      self()->d->textAntialias = v;
}

int SettingsCore::textAntialias()
{
  return self()->d->textAntialias;
}

bool  SettingsCore::isTextAntialiasImmutable()
{
    return self()->isImmutable( QStringLiteral( "TextAntialias" ) );
}


void SettingsCore::setGraphicsAntialias( int v )
{
    if (!self()->SettingsCore::isGraphicsAntialiasImmutable())
      self()->d->graphicsAntialias = v;
}

int SettingsCore::graphicsAntialias()
{
  return self()->d->graphicsAntialias;
}

bool  SettingsCore::isGraphicsAntialiasImmutable()
{
    return self()->isImmutable( QStringLiteral( "GraphicsAntialias" ) );
}


void SettingsCore::setTextHinting( int v )
{
    if (!self()->SettingsCore::isTextHintingImmutable())
      self()->d->textHinting = v;
}

int SettingsCore::textHinting()
{
  return self()->d->textHinting;
}

bool  SettingsCore::isTextHintingImmutable()
{
    return self()->isImmutable( QStringLiteral( "TextHinting" ) );
}


void SettingsCore::setPaperColor( const QColor & v )
{
    if (v != self()->d->paperColor && !self()->SettingsCore::isPaperColorImmutable()) {
      self()->d->paperColor = v;
      self()->d->settingsChanged |= signalColorModesChanged;
    }
}

QColor SettingsCore::paperColor()
{
  return self()->d->paperColor;
}

bool  SettingsCore::isPaperColorImmutable()
{
    return self()->isImmutable( QStringLiteral( "PaperColor" ) );
}


void SettingsCore::setChangeColors( bool v )
{
    if (v != self()->d->changeColors && !self()->SettingsCore::isChangeColorsImmutable()) {
      self()->d->changeColors = v;
      self()->d->settingsChanged |= signalColorModesChanged;
    }
}

bool SettingsCore::changeColors()
{
  return self()->d->changeColors;
}

bool  SettingsCore::isChangeColorsImmutable()
{
    return self()->isImmutable( QStringLiteral( "ChangeColors" ) );
}


void SettingsCore::setRenderMode( int v )
{
    if (v != self()->d->renderMode && !self()->SettingsCore::isRenderModeImmutable()) {
      self()->d->renderMode = v;
      self()->d->settingsChanged |= signalColorModesChanged;
    }
}

int SettingsCore::renderMode()
{
  return self()->d->renderMode;
}

bool  SettingsCore::isRenderModeImmutable()
{
    return self()->isImmutable( QStringLiteral( "RenderMode" ) );
}


void SettingsCore::setObeyDRM( bool v )
{
    if (!self()->SettingsCore::isObeyDRMImmutable())
      self()->d->obeyDRM = v;
}

bool SettingsCore::obeyDRM()
{
  return self()->d->obeyDRM;
}

bool  SettingsCore::isObeyDRMImmutable()
{
    return self()->isImmutable( QStringLiteral( "ObeyDRM" ) );
}


void SettingsCore::setChooseGenerators( bool v )
{
    if (!self()->SettingsCore::isChooseGeneratorsImmutable())
      self()->d->chooseGenerators = v;
}

bool SettingsCore::chooseGenerators()
{
  return self()->d->chooseGenerators;
}

bool  SettingsCore::isChooseGeneratorsImmutable()
{
    return self()->isImmutable( QStringLiteral( "ChooseGenerators" ) );
}


void SettingsCore::setExternalEditor( int v )
{
    if (!self()->SettingsCore::isExternalEditorImmutable())
      self()->d->externalEditor = v;
}

int SettingsCore::externalEditor()
{
  return self()->d->externalEditor;
}

bool  SettingsCore::isExternalEditorImmutable()
{
    return self()->isImmutable( QStringLiteral( "ExternalEditor" ) );
}


void SettingsCore::setExternalEditorCommand( const QString & v )
{
    if (!self()->SettingsCore::isExternalEditorCommandImmutable())
      self()->d->externalEditorCommand = v;
}

QString SettingsCore::externalEditorCommand()
{
  return self()->d->externalEditorCommand;
}

bool  SettingsCore::isExternalEditorCommandImmutable()
{
    return self()->isImmutable( QStringLiteral( "ExternalEditorCommand" ) );
}


void SettingsCore::setSlidesAdvance( bool v )
{
    if (!self()->SettingsCore::isSlidesAdvanceImmutable())
      self()->d->slidesAdvance = v;
}

bool SettingsCore::slidesAdvance()
{
  return self()->d->slidesAdvance;
}

bool  SettingsCore::isSlidesAdvanceImmutable()
{
    return self()->isImmutable( QStringLiteral( "SlidesAdvance" ) );
}


void SettingsCore::setSlidesAdvanceTime( uint v )
{
    if (v < 1)
    {
      qDebug() << "setSlidesAdvanceTime: value " << v << " is less than the minimum value of 1";
      v = 1;
    }

    if (v > 3600)
    {
      qDebug() << "setSlidesAdvanceTime: value " << v << " is greater than the maximum value of 3600";
      v = 3600;
    }

    if (!self()->SettingsCore::isSlidesAdvanceTimeImmutable())
      self()->d->slidesAdvanceTime = v;
}

uint SettingsCore::slidesAdvanceTime()
{
  return self()->d->slidesAdvanceTime;
}

bool  SettingsCore::isSlidesAdvanceTimeImmutable()
{
    return self()->isImmutable( QStringLiteral( "SlidesAdvanceTime" ) );
}


void SettingsCore::setSlidesLoop( bool v )
{
    if (!self()->SettingsCore::isSlidesLoopImmutable())
      self()->d->slidesLoop = v;
}

bool SettingsCore::slidesLoop()
{
  return self()->d->slidesLoop;
}

bool  SettingsCore::isSlidesLoopImmutable()
{
    return self()->isImmutable( QStringLiteral( "SlidesLoop" ) );
}


void SettingsCore::setSlidesTapNavigation( int v )
{
    if (!self()->SettingsCore::isSlidesTapNavigationImmutable())
      self()->d->slidesTapNavigation = v;
}

int SettingsCore::slidesTapNavigation()
{
  return self()->d->slidesTapNavigation;
}

bool  SettingsCore::isSlidesTapNavigationImmutable()
{
    return self()->isImmutable( QStringLiteral( "SlidesTapNavigation" ) );
}


SettingsCore::~SettingsCore()
{
  delete d;
  s_globalSettingsCore()->q = nullptr;
}

bool SettingsCore::usrSave()
{
  const bool res = KConfigSkeleton::usrSave();
  if (!res) return false;

  if ( d->settingsChanged & signalColorModesChanged )
    Q_EMIT colorModesChanged();
  d->settingsChanged = 0;
  return true;
}

void SettingsCore::itemChanged(quint64 flags) {
  d->settingsChanged |= flags;

}

#include "settings_core.moc"

