// cc/mojom/render_frame_metadata.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "cc/mojom/render_frame_metadata.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "cc/mojom/render_frame_metadata.mojom-params-data.h"
#include "cc/mojom/render_frame_metadata.mojom-shared-message-ids.h"

#include "cc/mojom/render_frame_metadata.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef CC_MOJOM_RENDER_FRAME_METADATA_MOJOM_BLINK_JUMBO_H_
#define CC_MOJOM_RENDER_FRAME_METADATA_MOJOM_BLINK_JUMBO_H_
#endif
namespace cc {
namespace mojom {
namespace blink {
DelegatedInkBrowserMetadata::DelegatedInkBrowserMetadata()
    : delegated_ink_is_hovering() {}

DelegatedInkBrowserMetadata::DelegatedInkBrowserMetadata(
    bool delegated_ink_is_hovering_in)
    : delegated_ink_is_hovering(std::move(delegated_ink_is_hovering_in)) {}

DelegatedInkBrowserMetadata::~DelegatedInkBrowserMetadata() = default;
size_t DelegatedInkBrowserMetadata::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->delegated_ink_is_hovering);
  return seed;
}

void DelegatedInkBrowserMetadata::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delegated_ink_is_hovering"), this->delegated_ink_is_hovering, 
      "<value of type bool>");
}

bool DelegatedInkBrowserMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RenderFrameMetadata::RenderFrameMetadata()
    : root_background_color(),
      root_scroll_offset(),
      is_scroll_offset_at_top(),
      selection(),
      is_mobile_optimized(),
      delegated_ink_metadata(),
      device_scale_factor(),
      viewport_size_in_pixels(),
      local_surface_id(),
      page_scale_factor(),
      external_page_scale_factor(),
      top_controls_height(),
      top_controls_shown_ratio(),
      new_vertical_scroll_direction(),
      bottom_controls_height(),
      bottom_controls_shown_ratio(),
      top_controls_min_height_offset(),
      bottom_controls_min_height_offset(),
      min_page_scale_factor(),
      max_page_scale_factor(),
      root_overflow_y_hidden(),
      scrollable_viewport_size(),
      root_layer_size(),
      has_transparent_background() {}

RenderFrameMetadata::RenderFrameMetadata(
    uint32_t root_background_color_in,
    const base::Optional<::gfx::Vector2dF>& root_scroll_offset_in,
    bool is_scroll_offset_at_top_in,
    const ::viz::Selection<::gfx::SelectionBound>& selection_in,
    bool is_mobile_optimized_in,
    DelegatedInkBrowserMetadataPtr delegated_ink_metadata_in,
    float device_scale_factor_in,
    const ::gfx::Size& viewport_size_in_pixels_in,
    const base::Optional<::viz::LocalSurfaceId>& local_surface_id_in,
    float page_scale_factor_in,
    float external_page_scale_factor_in,
    float top_controls_height_in,
    float top_controls_shown_ratio_in,
    ::viz::VerticalScrollDirection new_vertical_scroll_direction_in,
    float bottom_controls_height_in,
    float bottom_controls_shown_ratio_in,
    float top_controls_min_height_offset_in,
    float bottom_controls_min_height_offset_in,
    float min_page_scale_factor_in,
    float max_page_scale_factor_in,
    bool root_overflow_y_hidden_in,
    const ::gfx::SizeF& scrollable_viewport_size_in,
    const ::gfx::SizeF& root_layer_size_in,
    bool has_transparent_background_in)
    : root_background_color(std::move(root_background_color_in)),
      root_scroll_offset(std::move(root_scroll_offset_in)),
      is_scroll_offset_at_top(std::move(is_scroll_offset_at_top_in)),
      selection(std::move(selection_in)),
      is_mobile_optimized(std::move(is_mobile_optimized_in)),
      delegated_ink_metadata(std::move(delegated_ink_metadata_in)),
      device_scale_factor(std::move(device_scale_factor_in)),
      viewport_size_in_pixels(std::move(viewport_size_in_pixels_in)),
      local_surface_id(std::move(local_surface_id_in)),
      page_scale_factor(std::move(page_scale_factor_in)),
      external_page_scale_factor(std::move(external_page_scale_factor_in)),
      top_controls_height(std::move(top_controls_height_in)),
      top_controls_shown_ratio(std::move(top_controls_shown_ratio_in)),
      new_vertical_scroll_direction(std::move(new_vertical_scroll_direction_in)),
      bottom_controls_height(std::move(bottom_controls_height_in)),
      bottom_controls_shown_ratio(std::move(bottom_controls_shown_ratio_in)),
      top_controls_min_height_offset(std::move(top_controls_min_height_offset_in)),
      bottom_controls_min_height_offset(std::move(bottom_controls_min_height_offset_in)),
      min_page_scale_factor(std::move(min_page_scale_factor_in)),
      max_page_scale_factor(std::move(max_page_scale_factor_in)),
      root_overflow_y_hidden(std::move(root_overflow_y_hidden_in)),
      scrollable_viewport_size(std::move(scrollable_viewport_size_in)),
      root_layer_size(std::move(root_layer_size_in)),
      has_transparent_background(std::move(has_transparent_background_in)) {}

RenderFrameMetadata::~RenderFrameMetadata() = default;

void RenderFrameMetadata::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_background_color"), this->root_background_color, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_scroll_offset"), this->root_scroll_offset, 
      "<value of type const base::Optional<::gfx::Vector2dF>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_scroll_offset_at_top"), this->is_scroll_offset_at_top, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selection"), this->selection, 
      "<value of type const ::viz::Selection<::gfx::SelectionBound>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_mobile_optimized"), this->is_mobile_optimized, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delegated_ink_metadata"), this->delegated_ink_metadata, 
      "<value of type DelegatedInkBrowserMetadataPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_scale_factor"), this->device_scale_factor, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "viewport_size_in_pixels"), this->viewport_size_in_pixels, 
      "<value of type const ::gfx::Size&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "local_surface_id"), this->local_surface_id, 
      "<value of type const base::Optional<::viz::LocalSurfaceId>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_scale_factor"), this->page_scale_factor, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "external_page_scale_factor"), this->external_page_scale_factor, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_controls_height"), this->top_controls_height, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_controls_shown_ratio"), this->top_controls_shown_ratio, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "new_vertical_scroll_direction"), this->new_vertical_scroll_direction, 
      "<value of type ::viz::VerticalScrollDirection>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bottom_controls_height"), this->bottom_controls_height, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bottom_controls_shown_ratio"), this->bottom_controls_shown_ratio, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_controls_min_height_offset"), this->top_controls_min_height_offset, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bottom_controls_min_height_offset"), this->bottom_controls_min_height_offset, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_page_scale_factor"), this->min_page_scale_factor, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_page_scale_factor"), this->max_page_scale_factor, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_overflow_y_hidden"), this->root_overflow_y_hidden, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scrollable_viewport_size"), this->scrollable_viewport_size, 
      "<value of type const ::gfx::SizeF&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_layer_size"), this->root_layer_size, 
      "<value of type const ::gfx::SizeF&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_transparent_background"), this->has_transparent_background, 
      "<value of type bool>");
}

bool RenderFrameMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char RenderFrameMetadataObserver::Name_[] = "cc.mojom.RenderFrameMetadataObserver";

RenderFrameMetadataObserverProxy::RenderFrameMetadataObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RenderFrameMetadataObserverProxy::ReportAllFrameSubmissionsForTesting(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "cc::mojom::RenderFrameMetadataObserver::ReportAllFrameSubmissionsForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::cc::mojom::internal::RenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_Params_Data> params(
          message);
  params.Allocate();
  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderFrameMetadataObserver::Name_);
  message.set_method_name("ReportAllFrameSubmissionsForTesting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RenderFrameMetadataObserverStubDispatch::Accept(
    RenderFrameMetadataObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)cc::mojom::RenderFrameMetadataObserver::ReportAllFrameSubmissionsForTesting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)cc::mojom::RenderFrameMetadataObserver::ReportAllFrameSubmissionsForTesting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_Params_Data* params =
          reinterpret_cast<internal::RenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_enabled{};
      RenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderFrameMetadataObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportAllFrameSubmissionsForTesting(
std::move(p_enabled));
      return true;
    }
  }
  return false;
}

// static
bool RenderFrameMetadataObserverStubDispatch::AcceptWithResponder(
    RenderFrameMetadataObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRenderFrameMetadataObserverValidationInfo[] = {
    {internal::kRenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_Name,
     {&internal::RenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RenderFrameMetadataObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::cc::mojom::blink::RenderFrameMetadataObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRenderFrameMetadataObserverValidationInfo);
}

const char RenderFrameMetadataObserverClient::Name_[] = "cc.mojom.RenderFrameMetadataObserverClient";

RenderFrameMetadataObserverClientProxy::RenderFrameMetadataObserverClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RenderFrameMetadataObserverClientProxy::OnRenderFrameMetadataChanged(
    uint32_t in_frame_token, const ::cc::RenderFrameMetadata& in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "cc::mojom::RenderFrameMetadataObserverClient::OnRenderFrameMetadataChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_token"), in_frame_token, 
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata, 
                        "<value of type const ::cc::RenderFrameMetadata&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::cc::mojom::internal::RenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_Params_Data> params(
          message);
  params.Allocate();
  params->frame_token = in_frame_token;
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType> metadata_fragment(
          params.message());
  mojo::internal::Serialize<::cc::mojom::RenderFrameMetadataDataView>(
      in_metadata, metadata_fragment);
  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->metadata.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null metadata in RenderFrameMetadataObserverClient.OnRenderFrameMetadataChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderFrameMetadataObserverClient::Name_);
  message.set_method_name("OnRenderFrameMetadataChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RenderFrameMetadataObserverClientProxy::OnFrameSubmissionForTesting(
    uint32_t in_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "cc::mojom::RenderFrameMetadataObserverClient::OnFrameSubmissionForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_token"), in_frame_token, 
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::cc::mojom::internal::RenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_Params_Data> params(
          message);
  params.Allocate();
  params->frame_token = in_frame_token;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderFrameMetadataObserverClient::Name_);
  message.set_method_name("OnFrameSubmissionForTesting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RenderFrameMetadataObserverClientStubDispatch::Accept(
    RenderFrameMetadataObserverClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)cc::mojom::RenderFrameMetadataObserverClient::OnRenderFrameMetadataChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)cc::mojom::RenderFrameMetadataObserverClient::OnRenderFrameMetadataChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_Params_Data* params =
          reinterpret_cast<internal::RenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_frame_token{};
      ::cc::RenderFrameMetadata p_metadata{};
      RenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_token = input_data_view.frame_token();
      if (success && !input_data_view.ReadMetadata(&p_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderFrameMetadataObserverClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRenderFrameMetadataChanged(
std::move(p_frame_token), 
std::move(p_metadata));
      return true;
    }
    case internal::kRenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)cc::mojom::RenderFrameMetadataObserverClient::OnFrameSubmissionForTesting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)cc::mojom::RenderFrameMetadataObserverClient::OnFrameSubmissionForTesting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_Params_Data* params =
          reinterpret_cast<internal::RenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_frame_token{};
      RenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_token = input_data_view.frame_token();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderFrameMetadataObserverClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameSubmissionForTesting(
std::move(p_frame_token));
      return true;
    }
  }
  return false;
}

// static
bool RenderFrameMetadataObserverClientStubDispatch::AcceptWithResponder(
    RenderFrameMetadataObserverClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_Name: {
      break;
    }
    case internal::kRenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRenderFrameMetadataObserverClientValidationInfo[] = {
    {internal::kRenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_Name,
     {&internal::RenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_Name,
     {&internal::RenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RenderFrameMetadataObserverClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::cc::mojom::blink::RenderFrameMetadataObserverClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRenderFrameMetadataObserverClientValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace cc

namespace mojo {


// static
bool StructTraits<::cc::mojom::blink::DelegatedInkBrowserMetadata::DataView, ::cc::mojom::blink::DelegatedInkBrowserMetadataPtr>::Read(
    ::cc::mojom::blink::DelegatedInkBrowserMetadata::DataView input,
    ::cc::mojom::blink::DelegatedInkBrowserMetadataPtr* output) {
  bool success = true;
  ::cc::mojom::blink::DelegatedInkBrowserMetadataPtr result(::cc::mojom::blink::DelegatedInkBrowserMetadata::New());
  
      if (success)
        result->delegated_ink_is_hovering = input.delegated_ink_is_hovering();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::cc::mojom::blink::RenderFrameMetadata::DataView, ::cc::mojom::blink::RenderFrameMetadataPtr>::Read(
    ::cc::mojom::blink::RenderFrameMetadata::DataView input,
    ::cc::mojom::blink::RenderFrameMetadataPtr* output) {
  bool success = true;
  ::cc::mojom::blink::RenderFrameMetadataPtr result(::cc::mojom::blink::RenderFrameMetadata::New());
  
      if (success)
        result->root_background_color = input.root_background_color();
      if (success && !input.ReadRootScrollOffset(&result->root_scroll_offset))
        success = false;
      if (success)
        result->is_scroll_offset_at_top = input.is_scroll_offset_at_top();
      if (success && !input.ReadSelection(&result->selection))
        success = false;
      if (success)
        result->is_mobile_optimized = input.is_mobile_optimized();
      if (success && !input.ReadDelegatedInkMetadata(&result->delegated_ink_metadata))
        success = false;
      if (success)
        result->device_scale_factor = input.device_scale_factor();
      if (success && !input.ReadViewportSizeInPixels(&result->viewport_size_in_pixels))
        success = false;
      if (success && !input.ReadLocalSurfaceId(&result->local_surface_id))
        success = false;
      if (success)
        result->page_scale_factor = input.page_scale_factor();
      if (success)
        result->external_page_scale_factor = input.external_page_scale_factor();
      if (success)
        result->top_controls_height = input.top_controls_height();
      if (success)
        result->top_controls_shown_ratio = input.top_controls_shown_ratio();
      if (success && !input.ReadNewVerticalScrollDirection(&result->new_vertical_scroll_direction))
        success = false;
      if (success)
        result->bottom_controls_height = input.bottom_controls_height();
      if (success)
        result->bottom_controls_shown_ratio = input.bottom_controls_shown_ratio();
      if (success)
        result->top_controls_min_height_offset = input.top_controls_min_height_offset();
      if (success)
        result->bottom_controls_min_height_offset = input.bottom_controls_min_height_offset();
      if (success)
        result->min_page_scale_factor = input.min_page_scale_factor();
      if (success)
        result->max_page_scale_factor = input.max_page_scale_factor();
      if (success)
        result->root_overflow_y_hidden = input.root_overflow_y_hidden();
      if (success && !input.ReadScrollableViewportSize(&result->scrollable_viewport_size))
        success = false;
      if (success && !input.ReadRootLayerSize(&result->root_layer_size))
        success = false;
      if (success)
        result->has_transparent_background = input.has_transparent_background();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif