// components/autofill/core/common/mojom/autofill_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/autofill/core/common/mojom/autofill_types.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/autofill/core/common/mojom/autofill_types.mojom-params-data.h"
namespace autofill {
namespace mojom {

std::string SubmissionIndicatorEventToString(SubmissionIndicatorEvent value) {
  switch(value) {
    case SubmissionIndicatorEvent::NONE:
      return "SubmissionIndicatorEvent::NONE";
    case SubmissionIndicatorEvent::HTML_FORM_SUBMISSION:
      return "SubmissionIndicatorEvent::HTML_FORM_SUBMISSION";
    case SubmissionIndicatorEvent::SAME_DOCUMENT_NAVIGATION:
      return "SubmissionIndicatorEvent::SAME_DOCUMENT_NAVIGATION";
    case SubmissionIndicatorEvent::XHR_SUCCEEDED:
      return "SubmissionIndicatorEvent::XHR_SUCCEEDED";
    case SubmissionIndicatorEvent::FRAME_DETACHED:
      return "SubmissionIndicatorEvent::FRAME_DETACHED";
    case SubmissionIndicatorEvent::DOM_MUTATION_AFTER_XHR:
      return "SubmissionIndicatorEvent::DOM_MUTATION_AFTER_XHR";
    case SubmissionIndicatorEvent::PROVISIONALLY_SAVED_FORM_ON_START_PROVISIONAL_LOAD:
      return "SubmissionIndicatorEvent::PROVISIONALLY_SAVED_FORM_ON_START_PROVISIONAL_LOAD";
    case SubmissionIndicatorEvent::PROBABLE_FORM_SUBMISSION:
      return "SubmissionIndicatorEvent::PROBABLE_FORM_SUBMISSION";
    case SubmissionIndicatorEvent::CHANGE_PASSWORD_FORM_CLEARED:
      return "SubmissionIndicatorEvent::CHANGE_PASSWORD_FORM_CLEARED";
    default:
      return base::StringPrintf("Unknown SubmissionIndicatorEvent value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, SubmissionIndicatorEvent value) {
  return os << SubmissionIndicatorEventToString(value);
}

std::string SubmissionSourceToString(SubmissionSource value) {
  switch(value) {
    case SubmissionSource::NONE:
      return "SubmissionSource::NONE";
    case SubmissionSource::SAME_DOCUMENT_NAVIGATION:
      return "SubmissionSource::SAME_DOCUMENT_NAVIGATION";
    case SubmissionSource::XHR_SUCCEEDED:
      return "SubmissionSource::XHR_SUCCEEDED";
    case SubmissionSource::FRAME_DETACHED:
      return "SubmissionSource::FRAME_DETACHED";
    case SubmissionSource::DOM_MUTATION_AFTER_XHR:
      return "SubmissionSource::DOM_MUTATION_AFTER_XHR";
    case SubmissionSource::PROBABLY_FORM_SUBMITTED:
      return "SubmissionSource::PROBABLY_FORM_SUBMITTED";
    case SubmissionSource::FORM_SUBMISSION:
      return "SubmissionSource::FORM_SUBMISSION";
    default:
      return base::StringPrintf("Unknown SubmissionSource value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, SubmissionSource value) {
  return os << SubmissionSourceToString(value);
}

std::string FocusedFieldTypeToString(FocusedFieldType value) {
  switch(value) {
    case FocusedFieldType::kUnknown:
      return "FocusedFieldType::kUnknown";
    case FocusedFieldType::kUnfillableElement:
      return "FocusedFieldType::kUnfillableElement";
    case FocusedFieldType::kFillableTextArea:
      return "FocusedFieldType::kFillableTextArea";
    case FocusedFieldType::kFillableSearchField:
      return "FocusedFieldType::kFillableSearchField";
    case FocusedFieldType::kFillableNonSearchField:
      return "FocusedFieldType::kFillableNonSearchField";
    case FocusedFieldType::kFillableUsernameField:
      return "FocusedFieldType::kFillableUsernameField";
    case FocusedFieldType::kFillablePasswordField:
      return "FocusedFieldType::kFillablePasswordField";
    default:
      return base::StringPrintf("Unknown FocusedFieldType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, FocusedFieldType value) {
  return os << FocusedFieldTypeToString(value);
}

std::string ButtonTitleTypeToString(ButtonTitleType value) {
  switch(value) {
    case ButtonTitleType::NONE:
      return "ButtonTitleType::NONE";
    case ButtonTitleType::BUTTON_ELEMENT_SUBMIT_TYPE:
      return "ButtonTitleType::BUTTON_ELEMENT_SUBMIT_TYPE";
    case ButtonTitleType::BUTTON_ELEMENT_BUTTON_TYPE:
      return "ButtonTitleType::BUTTON_ELEMENT_BUTTON_TYPE";
    case ButtonTitleType::INPUT_ELEMENT_SUBMIT_TYPE:
      return "ButtonTitleType::INPUT_ELEMENT_SUBMIT_TYPE";
    case ButtonTitleType::INPUT_ELEMENT_BUTTON_TYPE:
      return "ButtonTitleType::INPUT_ELEMENT_BUTTON_TYPE";
    case ButtonTitleType::HYPERLINK:
      return "ButtonTitleType::HYPERLINK";
    case ButtonTitleType::DIV:
      return "ButtonTitleType::DIV";
    case ButtonTitleType::SPAN:
      return "ButtonTitleType::SPAN";
    default:
      return base::StringPrintf("Unknown ButtonTitleType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ButtonTitleType value) {
  return os << ButtonTitleTypeToString(value);
}

std::string AutofillStateToString(AutofillState value) {
  switch(value) {
    case AutofillState::kNoSuggestions:
      return "AutofillState::kNoSuggestions";
    case AutofillState::kAutofillAvailable:
      return "AutofillState::kAutofillAvailable";
    case AutofillState::kAutocompleteAvailable:
      return "AutofillState::kAutocompleteAvailable";
    default:
      return base::StringPrintf("Unknown AutofillState value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, AutofillState value) {
  return os << AutofillStateToString(value);
}

std::string FormFieldData_CheckStatusToString(FormFieldData_CheckStatus value) {
  switch(value) {
    case FormFieldData_CheckStatus::kNotCheckable:
      return "FormFieldData_CheckStatus::kNotCheckable";
    case FormFieldData_CheckStatus::kCheckableButUnchecked:
      return "FormFieldData_CheckStatus::kCheckableButUnchecked";
    case FormFieldData_CheckStatus::kChecked:
      return "FormFieldData_CheckStatus::kChecked";
    default:
      return base::StringPrintf("Unknown FormFieldData_CheckStatus value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, FormFieldData_CheckStatus value) {
  return os << FormFieldData_CheckStatusToString(value);
}

std::string FormFieldData_RoleAttributeToString(FormFieldData_RoleAttribute value) {
  switch(value) {
    case FormFieldData_RoleAttribute::kPresentation:
      return "FormFieldData_RoleAttribute::kPresentation";
    case FormFieldData_RoleAttribute::kOther:
      return "FormFieldData_RoleAttribute::kOther";
    default:
      return base::StringPrintf("Unknown FormFieldData_RoleAttribute value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, FormFieldData_RoleAttribute value) {
  return os << FormFieldData_RoleAttributeToString(value);
}

std::string FormFieldData_LabelSourceToString(FormFieldData_LabelSource value) {
  switch(value) {
    case FormFieldData_LabelSource::kUnknown:
      return "FormFieldData_LabelSource::kUnknown";
    case FormFieldData_LabelSource::kLabelTag:
      return "FormFieldData_LabelSource::kLabelTag";
    case FormFieldData_LabelSource::kPTag:
      return "FormFieldData_LabelSource::kPTag";
    case FormFieldData_LabelSource::kDivTable:
      return "FormFieldData_LabelSource::kDivTable";
    case FormFieldData_LabelSource::kTdTag:
      return "FormFieldData_LabelSource::kTdTag";
    case FormFieldData_LabelSource::kDdTag:
      return "FormFieldData_LabelSource::kDdTag";
    case FormFieldData_LabelSource::kLiTag:
      return "FormFieldData_LabelSource::kLiTag";
    case FormFieldData_LabelSource::kPlaceHolder:
      return "FormFieldData_LabelSource::kPlaceHolder";
    case FormFieldData_LabelSource::kAriaLabel:
      return "FormFieldData_LabelSource::kAriaLabel";
    case FormFieldData_LabelSource::kCombined:
      return "FormFieldData_LabelSource::kCombined";
    case FormFieldData_LabelSource::kValue:
      return "FormFieldData_LabelSource::kValue";
    default:
      return base::StringPrintf("Unknown FormFieldData_LabelSource value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, FormFieldData_LabelSource value) {
  return os << FormFieldData_LabelSourceToString(value);
}

namespace internal {


// static
bool FormRendererId_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FormRendererId_Data* object = static_cast<const FormRendererId_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

FormRendererId_Data::FormRendererId_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FieldRendererId_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FieldRendererId_Data* object = static_cast<const FieldRendererId_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

FieldRendererId_Data::FieldRendererId_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FormFieldData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 200, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FormFieldData_Data* object = static_cast<const FormFieldData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->label, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id_attribute, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id_attribute, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name_attribute, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name_attribute, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form_control_type, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams form_control_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->form_control_type, validation_context,
                                         &form_control_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->autocomplete_attribute, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams autocomplete_attribute_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->autocomplete_attribute, validation_context,
                                         &autocomplete_attribute_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->placeholder, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->placeholder, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->css_classes, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->css_classes, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aria_label, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->aria_label, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aria_description, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->aria_description, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->unique_renderer_id, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->unique_renderer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->section, 17, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams section_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->section, validation_context,
                                         &section_validate_params)) {
    return false;
  }


  if (!::autofill::mojom::internal::FormFieldData_CheckStatus_Data
        ::Validate(object->check_status, validation_context))
    return false;


  if (!::autofill::mojom::internal::FormFieldData_RoleAttribute_Data
        ::Validate(object->role, validation_context))
    return false;


  if (!::mojo_base::mojom::internal::TextDirection_Data
        ::Validate(object->text_direction, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_input, 25, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->user_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->option_values, 26, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams option_values_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->option_values, validation_context,
                                         &option_values_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->option_contents, 27, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams option_contents_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->option_contents, validation_context,
                                         &option_contents_validate_params)) {
    return false;
  }


  if (!::autofill::mojom::internal::FormFieldData_LabelSource_Data
        ::Validate(object->label_source, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 29, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->datalist_values, 30, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams datalist_values_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->datalist_values, validation_context,
                                         &datalist_values_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->datalist_labels, 31, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams datalist_labels_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->datalist_labels, validation_context,
                                         &datalist_labels_validate_params)) {
    return false;
  }

  return true;
}

FormFieldData_Data::FormFieldData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ButtonTitleInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ButtonTitleInfo_Data* object = static_cast<const ButtonTitleInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;


  if (!::autofill::mojom::internal::ButtonTitleType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

ButtonTitleInfo_Data::ButtonTitleInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FormData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 104, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FormData_Data* object = static_cast<const FormData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id_attribute, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id_attribute, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name_attribute, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name_attribute, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->button_titles, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams button_titles_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->button_titles, validation_context,
                                         &button_titles_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->full_url, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->full_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->action, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->action, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_frame_origin, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->main_frame_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->unique_renderer_id, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->unique_renderer_id, validation_context))
    return false;


  if (!::autofill::mojom::internal::SubmissionIndicatorEvent_Data
        ::Validate(object->submission_event, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fields, 14, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams fields_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->fields, validation_context,
                                         &fields_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->username_predictions, 15, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams username_predictions_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->username_predictions, validation_context,
                                         &username_predictions_validate_params)) {
    return false;
  }

  return true;
}

FormData_Data::FormData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FormFieldDataPredictions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FormFieldDataPredictions_Data* object = static_cast<const FormFieldDataPredictions_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signature, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams signature_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->signature, validation_context,
                                         &signature_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->heuristic_type, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams heuristic_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->heuristic_type, validation_context,
                                         &heuristic_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->server_type, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams server_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->server_type, validation_context,
                                         &server_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->overall_type, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams overall_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->overall_type, validation_context,
                                         &overall_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parseable_name, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams parseable_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->parseable_name, validation_context,
                                         &parseable_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->section, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams section_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->section, validation_context,
                                         &section_validate_params)) {
    return false;
  }

  return true;
}

FormFieldDataPredictions_Data::FormFieldDataPredictions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FormDataPredictions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FormDataPredictions_Data* object = static_cast<const FormDataPredictions_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signature, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams signature_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->signature, validation_context,
                                         &signature_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fields, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams fields_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->fields, validation_context,
                                         &fields_validate_params)) {
    return false;
  }

  return true;
}

FormDataPredictions_Data::FormDataPredictions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordAndMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PasswordAndMetadata_Data* object = static_cast<const PasswordAndMetadata_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->username, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->username, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->password, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->password, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->realm, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams realm_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->realm, validation_context,
                                         &realm_validate_params)) {
    return false;
  }

  return true;
}

PasswordAndMetadata_Data::PasswordAndMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordFormFillData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PasswordFormFillData_Data* object = static_cast<const PasswordFormFillData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form_renderer_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form_renderer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->action, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->action, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->username_field, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->username_field, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->password_field, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->password_field, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->preferred_realm, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams preferred_realm_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->preferred_realm, validation_context,
                                         &preferred_realm_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->additional_logins, 9, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams additional_logins_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->additional_logins, validation_context,
                                         &additional_logins_validate_params)) {
    return false;
  }

  return true;
}

PasswordFormFillData_Data::PasswordFormFillData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordFormGenerationData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PasswordFormGenerationData_Data* object = static_cast<const PasswordFormGenerationData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_password_renderer_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_password_renderer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->confirmation_password_renderer_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->confirmation_password_renderer_id, validation_context))
    return false;

  return true;
}

PasswordFormGenerationData_Data::PasswordFormGenerationData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordGenerationUIData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PasswordGenerationUIData_Data* object = static_cast<const PasswordGenerationUIData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->generation_element, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->generation_element, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->generation_element_id, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->generation_element_id, validation_context))
    return false;


  if (!::mojo_base::mojom::internal::TextDirection_Data
        ::Validate(object->text_direction, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form_data, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form_data, validation_context))
    return false;

  return true;
}

PasswordGenerationUIData_Data::PasswordGenerationUIData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ParsingResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ParsingResult_Data* object = static_cast<const ParsingResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->username_renderer_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->username_renderer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->password_renderer_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->password_renderer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_password_renderer_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_password_renderer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->confirm_password_renderer_id, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->confirm_password_renderer_id, validation_context))
    return false;

  return true;
}

ParsingResult_Data::ParsingResult_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace autofill

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::SubmissionIndicatorEvent>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::autofill::mojom::SubmissionIndicatorEvent value) {
  return std::move(context).WriteString(::autofill::mojom::SubmissionIndicatorEventToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::SubmissionSource>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::autofill::mojom::SubmissionSource value) {
  return std::move(context).WriteString(::autofill::mojom::SubmissionSourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::FocusedFieldType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::autofill::mojom::FocusedFieldType value) {
  return std::move(context).WriteString(::autofill::mojom::FocusedFieldTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::ButtonTitleType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::autofill::mojom::ButtonTitleType value) {
  return std::move(context).WriteString(::autofill::mojom::ButtonTitleTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::AutofillState>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::autofill::mojom::AutofillState value) {
  return std::move(context).WriteString(::autofill::mojom::AutofillStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::FormFieldData_CheckStatus>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::autofill::mojom::FormFieldData_CheckStatus value) {
  return std::move(context).WriteString(::autofill::mojom::FormFieldData_CheckStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::FormFieldData_RoleAttribute>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::autofill::mojom::FormFieldData_RoleAttribute value) {
  return std::move(context).WriteString(::autofill::mojom::FormFieldData_RoleAttributeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::FormFieldData_LabelSource>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::autofill::mojom::FormFieldData_LabelSource value) {
  return std::move(context).WriteString(::autofill::mojom::FormFieldData_LabelSourceToString(value));
}

} // namespace perfetto
