// components/content_settings/core/common/content_settings.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/content_settings/core/common/content_settings.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/content_settings/core/common/content_settings.mojom-params-data.h"
namespace content_settings {
namespace mojom {

std::string ContentSettingToString(ContentSetting value) {
  switch(value) {
    case ContentSetting::DEFAULT:
      return "ContentSetting::DEFAULT";
    case ContentSetting::ALLOW:
      return "ContentSetting::ALLOW";
    case ContentSetting::BLOCK:
      return "ContentSetting::BLOCK";
    case ContentSetting::ASK:
      return "ContentSetting::ASK";
    case ContentSetting::SESSION_ONLY:
      return "ContentSetting::SESSION_ONLY";
    case ContentSetting::DETECT_IMPORTANT_CONTENT:
      return "ContentSetting::DETECT_IMPORTANT_CONTENT";
    default:
      return base::StringPrintf("Unknown ContentSetting value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ContentSetting value) {
  return os << ContentSettingToString(value);
}

namespace internal {


// static
bool PatternParts_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PatternParts_Data* object = static_cast<const PatternParts_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scheme, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams scheme_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->scheme, validation_context,
                                         &scheme_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams host_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->host, validation_context,
                                         &host_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->port, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams port_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->port, validation_context,
                                         &port_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams path_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->path, validation_context,
                                         &path_validate_params)) {
    return false;
  }

  return true;
}

PatternParts_Data::PatternParts_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentSettingsPattern_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ContentSettingsPattern_Data* object = static_cast<const ContentSettingsPattern_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parts, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->parts, validation_context))
    return false;

  return true;
}

ContentSettingsPattern_Data::ContentSettingsPattern_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentSettingPatternSource_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ContentSettingPatternSource_Data* object = static_cast<const ContentSettingPatternSource_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->primary_pattern, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->primary_pattern, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->secondary_pattern, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->secondary_pattern, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->setting_value, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->setting_value, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->expiration, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->expiration, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams source_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->source, validation_context,
                                         &source_validate_params)) {
    return false;
  }

  return true;
}

ContentSettingPatternSource_Data::ContentSettingPatternSource_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RendererContentSettingRules_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RendererContentSettingRules_Data* object = static_cast<const RendererContentSettingRules_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_rules, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams image_rules_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->image_rules, validation_context,
                                         &image_rules_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->script_rules, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams script_rules_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->script_rules, validation_context,
                                         &script_rules_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->popup_redirect_rules, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams popup_redirect_rules_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->popup_redirect_rules, validation_context,
                                         &popup_redirect_rules_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mixed_content_rules, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams mixed_content_rules_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->mixed_content_rules, validation_context,
                                         &mixed_content_rules_validate_params)) {
    return false;
  }

  return true;
}

RendererContentSettingRules_Data::RendererContentSettingRules_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace content_settings

namespace perfetto {

// static
void TraceFormatTraits<::content_settings::mojom::ContentSetting>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::content_settings::mojom::ContentSetting value) {
  return std::move(context).WriteString(::content_settings::mojom::ContentSettingToString(value));
}

} // namespace perfetto
