// components/content_settings/core/common/content_settings.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/content_settings/core/common/content_settings.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "components/content_settings/core/common/content_settings.mojom-params-data.h"
#include "components/content_settings/core/common/content_settings.mojom-shared-message-ids.h"

#include "components/content_settings/core/common/content_settings.mojom-import-headers.h"


#ifndef COMPONENTS_CONTENT_SETTINGS_CORE_COMMON_CONTENT_SETTINGS_MOJOM_JUMBO_H_
#define COMPONENTS_CONTENT_SETTINGS_CORE_COMMON_CONTENT_SETTINGS_MOJOM_JUMBO_H_
#include "components/content_settings/core/common/content_settings_param_traits.h"
#endif
namespace content_settings {
namespace mojom {
PatternParts::PatternParts()
    : scheme(),
      is_scheme_wildcard(),
      host(),
      has_domain_wildcard(),
      port(),
      is_port_wildcard(),
      path(),
      is_path_wildcard() {}

PatternParts::PatternParts(
    const std::string& scheme_in,
    bool is_scheme_wildcard_in,
    const std::string& host_in,
    bool has_domain_wildcard_in,
    const std::string& port_in,
    bool is_port_wildcard_in,
    const std::string& path_in,
    bool is_path_wildcard_in)
    : scheme(std::move(scheme_in)),
      is_scheme_wildcard(std::move(is_scheme_wildcard_in)),
      host(std::move(host_in)),
      has_domain_wildcard(std::move(has_domain_wildcard_in)),
      port(std::move(port_in)),
      is_port_wildcard(std::move(is_port_wildcard_in)),
      path(std::move(path_in)),
      is_path_wildcard(std::move(is_path_wildcard_in)) {}

PatternParts::~PatternParts() = default;

void PatternParts::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scheme"), this->scheme, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_scheme_wildcard"), this->is_scheme_wildcard, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host"), this->host, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_domain_wildcard"), this->has_domain_wildcard, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "port"), this->port, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_port_wildcard"), this->is_port_wildcard, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_path_wildcard"), this->is_path_wildcard, 
      "<value of type bool>");
}

bool PatternParts::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ContentSettingsPattern::ContentSettingsPattern()
    : parts(),
      is_valid() {}

ContentSettingsPattern::ContentSettingsPattern(
    const ::ContentSettingsPattern::PatternParts& parts_in,
    bool is_valid_in)
    : parts(std::move(parts_in)),
      is_valid(std::move(is_valid_in)) {}

ContentSettingsPattern::~ContentSettingsPattern() = default;

void ContentSettingsPattern::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parts"), this->parts, 
      "<value of type const ::ContentSettingsPattern::PatternParts&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_valid"), this->is_valid, 
      "<value of type bool>");
}

bool ContentSettingsPattern::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ContentSettingPatternSource::ContentSettingPatternSource()
    : primary_pattern(),
      secondary_pattern(),
      setting_value(),
      expiration(),
      source(),
      incognito() {}

ContentSettingPatternSource::ContentSettingPatternSource(
    const ::ContentSettingsPattern& primary_pattern_in,
    const ::ContentSettingsPattern& secondary_pattern_in,
    ::base::Value setting_value_in,
    ::base::Time expiration_in,
    const std::string& source_in,
    bool incognito_in)
    : primary_pattern(std::move(primary_pattern_in)),
      secondary_pattern(std::move(secondary_pattern_in)),
      setting_value(std::move(setting_value_in)),
      expiration(std::move(expiration_in)),
      source(std::move(source_in)),
      incognito(std::move(incognito_in)) {}

ContentSettingPatternSource::~ContentSettingPatternSource() = default;

void ContentSettingPatternSource::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_pattern"), this->primary_pattern, 
      "<value of type const ::ContentSettingsPattern&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "secondary_pattern"), this->secondary_pattern, 
      "<value of type const ::ContentSettingsPattern&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "setting_value"), this->setting_value, 
      "<value of type ::base::Value>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expiration"), this->expiration, 
      "<value of type ::base::Time>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source"), this->source, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "incognito"), this->incognito, 
      "<value of type bool>");
}

bool ContentSettingPatternSource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RendererContentSettingRules::RendererContentSettingRules()
    : image_rules(),
      script_rules(),
      popup_redirect_rules(),
      mixed_content_rules() {}

RendererContentSettingRules::RendererContentSettingRules(
    std::vector<::ContentSettingPatternSource> image_rules_in,
    std::vector<::ContentSettingPatternSource> script_rules_in,
    std::vector<::ContentSettingPatternSource> popup_redirect_rules_in,
    std::vector<::ContentSettingPatternSource> mixed_content_rules_in)
    : image_rules(std::move(image_rules_in)),
      script_rules(std::move(script_rules_in)),
      popup_redirect_rules(std::move(popup_redirect_rules_in)),
      mixed_content_rules(std::move(mixed_content_rules_in)) {}

RendererContentSettingRules::~RendererContentSettingRules() = default;

void RendererContentSettingRules::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_rules"), this->image_rules, 
      "<value of type const std::vector<::ContentSettingPatternSource>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_rules"), this->script_rules, 
      "<value of type const std::vector<::ContentSettingPatternSource>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "popup_redirect_rules"), this->popup_redirect_rules, 
      "<value of type const std::vector<::ContentSettingPatternSource>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mixed_content_rules"), this->mixed_content_rules, 
      "<value of type const std::vector<::ContentSettingPatternSource>&>");
}

bool RendererContentSettingRules::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace content_settings

namespace mojo {


// static
bool StructTraits<::content_settings::mojom::PatternParts::DataView, ::content_settings::mojom::PatternPartsPtr>::Read(
    ::content_settings::mojom::PatternParts::DataView input,
    ::content_settings::mojom::PatternPartsPtr* output) {
  bool success = true;
  ::content_settings::mojom::PatternPartsPtr result(::content_settings::mojom::PatternParts::New());
  
      if (success && !input.ReadScheme(&result->scheme))
        success = false;
      if (success)
        result->is_scheme_wildcard = input.is_scheme_wildcard();
      if (success && !input.ReadHost(&result->host))
        success = false;
      if (success)
        result->has_domain_wildcard = input.has_domain_wildcard();
      if (success && !input.ReadPort(&result->port))
        success = false;
      if (success)
        result->is_port_wildcard = input.is_port_wildcard();
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success)
        result->is_path_wildcard = input.is_path_wildcard();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content_settings::mojom::ContentSettingsPattern::DataView, ::content_settings::mojom::ContentSettingsPatternPtr>::Read(
    ::content_settings::mojom::ContentSettingsPattern::DataView input,
    ::content_settings::mojom::ContentSettingsPatternPtr* output) {
  bool success = true;
  ::content_settings::mojom::ContentSettingsPatternPtr result(::content_settings::mojom::ContentSettingsPattern::New());
  
      if (success && !input.ReadParts(&result->parts))
        success = false;
      if (success)
        result->is_valid = input.is_valid();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content_settings::mojom::ContentSettingPatternSource::DataView, ::content_settings::mojom::ContentSettingPatternSourcePtr>::Read(
    ::content_settings::mojom::ContentSettingPatternSource::DataView input,
    ::content_settings::mojom::ContentSettingPatternSourcePtr* output) {
  bool success = true;
  ::content_settings::mojom::ContentSettingPatternSourcePtr result(::content_settings::mojom::ContentSettingPatternSource::New());
  
      if (success && !input.ReadPrimaryPattern(&result->primary_pattern))
        success = false;
      if (success && !input.ReadSecondaryPattern(&result->secondary_pattern))
        success = false;
      if (success && !input.ReadSettingValue(&result->setting_value))
        success = false;
      if (success && !input.ReadExpiration(&result->expiration))
        success = false;
      if (success && !input.ReadSource(&result->source))
        success = false;
      if (success)
        result->incognito = input.incognito();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content_settings::mojom::RendererContentSettingRules::DataView, ::content_settings::mojom::RendererContentSettingRulesPtr>::Read(
    ::content_settings::mojom::RendererContentSettingRules::DataView input,
    ::content_settings::mojom::RendererContentSettingRulesPtr* output) {
  bool success = true;
  ::content_settings::mojom::RendererContentSettingRulesPtr result(::content_settings::mojom::RendererContentSettingRules::New());
  
      if (success && !input.ReadImageRules(&result->image_rules))
        success = false;
      if (success && !input.ReadScriptRules(&result->script_rules))
        success = false;
      if (success && !input.ReadPopupRedirectRules(&result->popup_redirect_rules))
        success = false;
      if (success && !input.ReadMixedContentRules(&result->mixed_content_rules))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif