// components/download/public/common/download_stream.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/download/public/common/download_stream.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/download/public/common/download_stream.mojom-params-data.h"
namespace download {
namespace mojom {

std::string NetworkRequestStatusToString(NetworkRequestStatus value) {
  switch(value) {
    case NetworkRequestStatus::OK:
      return "NetworkRequestStatus::OK";
    case NetworkRequestStatus::NETWORK_TIMEOUT:
      return "NetworkRequestStatus::NETWORK_TIMEOUT";
    case NetworkRequestStatus::NETWORK_DISCONNECTED:
      return "NetworkRequestStatus::NETWORK_DISCONNECTED";
    case NetworkRequestStatus::NETWORK_SERVER_DOWN:
      return "NetworkRequestStatus::NETWORK_SERVER_DOWN";
    case NetworkRequestStatus::SERVER_NO_RANGE:
      return "NetworkRequestStatus::SERVER_NO_RANGE";
    case NetworkRequestStatus::SERVER_CONTENT_LENGTH_MISMATCH:
      return "NetworkRequestStatus::SERVER_CONTENT_LENGTH_MISMATCH";
    case NetworkRequestStatus::SERVER_UNREACHABLE:
      return "NetworkRequestStatus::SERVER_UNREACHABLE";
    case NetworkRequestStatus::SERVER_CERT_PROBLEM:
      return "NetworkRequestStatus::SERVER_CERT_PROBLEM";
    case NetworkRequestStatus::USER_CANCELED:
      return "NetworkRequestStatus::USER_CANCELED";
    case NetworkRequestStatus::NETWORK_FAILED:
      return "NetworkRequestStatus::NETWORK_FAILED";
    default:
      return base::StringPrintf("Unknown NetworkRequestStatus value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, NetworkRequestStatus value) {
  return os << NetworkRequestStatusToString(value);
}

namespace internal {


// static
bool DownloadStreamHandle_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DownloadStreamHandle_Data* object = static_cast<const DownloadStreamHandle_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->stream, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->stream,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client_receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DownloadStreamHandle_Data::DownloadStreamHandle_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DownloadStreamClient_OnStreamCompleted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DownloadStreamClient_OnStreamCompleted_Params_Data* object = static_cast<const DownloadStreamClient_OnStreamCompleted_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::download::mojom::internal::NetworkRequestStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

DownloadStreamClient_OnStreamCompleted_Params_Data::DownloadStreamClient_OnStreamCompleted_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace download

namespace perfetto {

// static
void TraceFormatTraits<::download::mojom::NetworkRequestStatus>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::download::mojom::NetworkRequestStatus value) {
  return std::move(context).WriteString(::download::mojom::NetworkRequestStatusToString(value));
}

} // namespace perfetto
